/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto

package com.google.recaptchaenterprise.v1;

/**
 *
 *
 * <pre>
 * User information associated with a request protected by reCAPTCHA Enterprise.
 * </pre>
 *
 * Protobuf type {@code google.cloud.recaptchaenterprise.v1.UserInfo}
 */
public final class UserInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.recaptchaenterprise.v1.UserInfo)
    UserInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UserInfo.newBuilder() to construct.
  private UserInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UserInfo() {
    accountId_ = "";
    userIds_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UserInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1_UserInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1_UserInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.recaptchaenterprise.v1.UserInfo.class,
            com.google.recaptchaenterprise.v1.UserInfo.Builder.class);
  }

  public static final int CREATE_ACCOUNT_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp createAccountTime_;
  /**
   *
   *
   * <pre>
   * Optional. Creation time for this account associated with this user. Leave
   * blank for non logged-in actions, guest checkout, or when there is no
   * account associated with the current user.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp create_account_time = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the createAccountTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateAccountTime() {
    return createAccountTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Creation time for this account associated with this user. Leave
   * blank for non logged-in actions, guest checkout, or when there is no
   * account associated with the current user.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp create_account_time = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The createAccountTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateAccountTime() {
    return createAccountTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : createAccountTime_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Creation time for this account associated with this user. Leave
   * blank for non logged-in actions, guest checkout, or when there is no
   * account associated with the current user.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp create_account_time = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateAccountTimeOrBuilder() {
    return createAccountTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : createAccountTime_;
  }

  public static final int ACCOUNT_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object accountId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. For logged-in requests or login/registration requests, the unique
   * account identifier associated with this user. You can use the username if
   * it is stable (meaning it is the same for every request associated with the
   * same user), or any stable user ID of your choice. Leave blank for non
   * logged-in actions or guest checkout.
   * </pre>
   *
   * <code>string account_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The accountId.
   */
  @java.lang.Override
  public java.lang.String getAccountId() {
    java.lang.Object ref = accountId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      accountId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. For logged-in requests or login/registration requests, the unique
   * account identifier associated with this user. You can use the username if
   * it is stable (meaning it is the same for every request associated with the
   * same user), or any stable user ID of your choice. Leave blank for non
   * logged-in actions or guest checkout.
   * </pre>
   *
   * <code>string account_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for accountId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAccountIdBytes() {
    java.lang.Object ref = accountId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      accountId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USER_IDS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.recaptchaenterprise.v1.UserId> userIds_;
  /**
   *
   *
   * <pre>
   * Optional. Identifiers associated with this user or request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1.UserId user_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.recaptchaenterprise.v1.UserId> getUserIdsList() {
    return userIds_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Identifiers associated with this user or request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1.UserId user_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.recaptchaenterprise.v1.UserIdOrBuilder>
      getUserIdsOrBuilderList() {
    return userIds_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Identifiers associated with this user or request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1.UserId user_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getUserIdsCount() {
    return userIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Identifiers associated with this user or request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1.UserId user_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.UserId getUserIds(int index) {
    return userIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Identifiers associated with this user or request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1.UserId user_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.UserIdOrBuilder getUserIdsOrBuilder(int index) {
    return userIds_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (createAccountTime_ != null) {
      output.writeMessage(1, getCreateAccountTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(accountId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, accountId_);
    }
    for (int i = 0; i < userIds_.size(); i++) {
      output.writeMessage(3, userIds_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (createAccountTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCreateAccountTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(accountId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, accountId_);
    }
    for (int i = 0; i < userIds_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, userIds_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.recaptchaenterprise.v1.UserInfo)) {
      return super.equals(obj);
    }
    com.google.recaptchaenterprise.v1.UserInfo other =
        (com.google.recaptchaenterprise.v1.UserInfo) obj;

    if (hasCreateAccountTime() != other.hasCreateAccountTime()) return false;
    if (hasCreateAccountTime()) {
      if (!getCreateAccountTime().equals(other.getCreateAccountTime())) return false;
    }
    if (!getAccountId().equals(other.getAccountId())) return false;
    if (!getUserIdsList().equals(other.getUserIdsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCreateAccountTime()) {
      hash = (37 * hash) + CREATE_ACCOUNT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateAccountTime().hashCode();
    }
    hash = (37 * hash) + ACCOUNT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getAccountId().hashCode();
    if (getUserIdsCount() > 0) {
      hash = (37 * hash) + USER_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getUserIdsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.recaptchaenterprise.v1.UserInfo parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.UserInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.UserInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.UserInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.UserInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.UserInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.UserInfo parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.UserInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.UserInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.UserInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.UserInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.UserInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.recaptchaenterprise.v1.UserInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * User information associated with a request protected by reCAPTCHA Enterprise.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recaptchaenterprise.v1.UserInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.recaptchaenterprise.v1.UserInfo)
      com.google.recaptchaenterprise.v1.UserInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_UserInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_UserInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.recaptchaenterprise.v1.UserInfo.class,
              com.google.recaptchaenterprise.v1.UserInfo.Builder.class);
    }

    // Construct using com.google.recaptchaenterprise.v1.UserInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      createAccountTime_ = null;
      if (createAccountTimeBuilder_ != null) {
        createAccountTimeBuilder_.dispose();
        createAccountTimeBuilder_ = null;
      }
      accountId_ = "";
      if (userIdsBuilder_ == null) {
        userIds_ = java.util.Collections.emptyList();
      } else {
        userIds_ = null;
        userIdsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_UserInfo_descriptor;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.UserInfo getDefaultInstanceForType() {
      return com.google.recaptchaenterprise.v1.UserInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.UserInfo build() {
      com.google.recaptchaenterprise.v1.UserInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.UserInfo buildPartial() {
      com.google.recaptchaenterprise.v1.UserInfo result =
          new com.google.recaptchaenterprise.v1.UserInfo(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.recaptchaenterprise.v1.UserInfo result) {
      if (userIdsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          userIds_ = java.util.Collections.unmodifiableList(userIds_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.userIds_ = userIds_;
      } else {
        result.userIds_ = userIdsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.recaptchaenterprise.v1.UserInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.createAccountTime_ =
            createAccountTimeBuilder_ == null
                ? createAccountTime_
                : createAccountTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.accountId_ = accountId_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.recaptchaenterprise.v1.UserInfo) {
        return mergeFrom((com.google.recaptchaenterprise.v1.UserInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.recaptchaenterprise.v1.UserInfo other) {
      if (other == com.google.recaptchaenterprise.v1.UserInfo.getDefaultInstance()) return this;
      if (other.hasCreateAccountTime()) {
        mergeCreateAccountTime(other.getCreateAccountTime());
      }
      if (!other.getAccountId().isEmpty()) {
        accountId_ = other.accountId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (userIdsBuilder_ == null) {
        if (!other.userIds_.isEmpty()) {
          if (userIds_.isEmpty()) {
            userIds_ = other.userIds_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureUserIdsIsMutable();
            userIds_.addAll(other.userIds_);
          }
          onChanged();
        }
      } else {
        if (!other.userIds_.isEmpty()) {
          if (userIdsBuilder_.isEmpty()) {
            userIdsBuilder_.dispose();
            userIdsBuilder_ = null;
            userIds_ = other.userIds_;
            bitField0_ = (bitField0_ & ~0x00000004);
            userIdsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getUserIdsFieldBuilder()
                    : null;
          } else {
            userIdsBuilder_.addAllMessages(other.userIds_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getCreateAccountTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                accountId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.recaptchaenterprise.v1.UserId m =
                    input.readMessage(
                        com.google.recaptchaenterprise.v1.UserId.parser(), extensionRegistry);
                if (userIdsBuilder_ == null) {
                  ensureUserIdsIsMutable();
                  userIds_.add(m);
                } else {
                  userIdsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp createAccountTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createAccountTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Creation time for this account associated with this user. Leave
     * blank for non logged-in actions, guest checkout, or when there is no
     * account associated with the current user.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_account_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the createAccountTime field is set.
     */
    public boolean hasCreateAccountTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Creation time for this account associated with this user. Leave
     * blank for non logged-in actions, guest checkout, or when there is no
     * account associated with the current user.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_account_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The createAccountTime.
     */
    public com.google.protobuf.Timestamp getCreateAccountTime() {
      if (createAccountTimeBuilder_ == null) {
        return createAccountTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createAccountTime_;
      } else {
        return createAccountTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Creation time for this account associated with this user. Leave
     * blank for non logged-in actions, guest checkout, or when there is no
     * account associated with the current user.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_account_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCreateAccountTime(com.google.protobuf.Timestamp value) {
      if (createAccountTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createAccountTime_ = value;
      } else {
        createAccountTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Creation time for this account associated with this user. Leave
     * blank for non logged-in actions, guest checkout, or when there is no
     * account associated with the current user.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_account_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCreateAccountTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createAccountTimeBuilder_ == null) {
        createAccountTime_ = builderForValue.build();
      } else {
        createAccountTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Creation time for this account associated with this user. Leave
     * blank for non logged-in actions, guest checkout, or when there is no
     * account associated with the current user.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_account_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeCreateAccountTime(com.google.protobuf.Timestamp value) {
      if (createAccountTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && createAccountTime_ != null
            && createAccountTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateAccountTimeBuilder().mergeFrom(value);
        } else {
          createAccountTime_ = value;
        }
      } else {
        createAccountTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Creation time for this account associated with this user. Leave
     * blank for non logged-in actions, guest checkout, or when there is no
     * account associated with the current user.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_account_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCreateAccountTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      createAccountTime_ = null;
      if (createAccountTimeBuilder_ != null) {
        createAccountTimeBuilder_.dispose();
        createAccountTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Creation time for this account associated with this user. Leave
     * blank for non logged-in actions, guest checkout, or when there is no
     * account associated with the current user.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_account_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateAccountTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getCreateAccountTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Creation time for this account associated with this user. Leave
     * blank for non logged-in actions, guest checkout, or when there is no
     * account associated with the current user.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_account_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateAccountTimeOrBuilder() {
      if (createAccountTimeBuilder_ != null) {
        return createAccountTimeBuilder_.getMessageOrBuilder();
      } else {
        return createAccountTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createAccountTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Creation time for this account associated with this user. Leave
     * blank for non logged-in actions, guest checkout, or when there is no
     * account associated with the current user.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_account_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateAccountTimeFieldBuilder() {
      if (createAccountTimeBuilder_ == null) {
        createAccountTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateAccountTime(), getParentForChildren(), isClean());
        createAccountTime_ = null;
      }
      return createAccountTimeBuilder_;
    }

    private java.lang.Object accountId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. For logged-in requests or login/registration requests, the unique
     * account identifier associated with this user. You can use the username if
     * it is stable (meaning it is the same for every request associated with the
     * same user), or any stable user ID of your choice. Leave blank for non
     * logged-in actions or guest checkout.
     * </pre>
     *
     * <code>string account_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The accountId.
     */
    public java.lang.String getAccountId() {
      java.lang.Object ref = accountId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        accountId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. For logged-in requests or login/registration requests, the unique
     * account identifier associated with this user. You can use the username if
     * it is stable (meaning it is the same for every request associated with the
     * same user), or any stable user ID of your choice. Leave blank for non
     * logged-in actions or guest checkout.
     * </pre>
     *
     * <code>string account_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for accountId.
     */
    public com.google.protobuf.ByteString getAccountIdBytes() {
      java.lang.Object ref = accountId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        accountId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. For logged-in requests or login/registration requests, the unique
     * account identifier associated with this user. You can use the username if
     * it is stable (meaning it is the same for every request associated with the
     * same user), or any stable user ID of your choice. Leave blank for non
     * logged-in actions or guest checkout.
     * </pre>
     *
     * <code>string account_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The accountId to set.
     * @return This builder for chaining.
     */
    public Builder setAccountId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      accountId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. For logged-in requests or login/registration requests, the unique
     * account identifier associated with this user. You can use the username if
     * it is stable (meaning it is the same for every request associated with the
     * same user), or any stable user ID of your choice. Leave blank for non
     * logged-in actions or guest checkout.
     * </pre>
     *
     * <code>string account_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAccountId() {
      accountId_ = getDefaultInstance().getAccountId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. For logged-in requests or login/registration requests, the unique
     * account identifier associated with this user. You can use the username if
     * it is stable (meaning it is the same for every request associated with the
     * same user), or any stable user ID of your choice. Leave blank for non
     * logged-in actions or guest checkout.
     * </pre>
     *
     * <code>string account_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for accountId to set.
     * @return This builder for chaining.
     */
    public Builder setAccountIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      accountId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.recaptchaenterprise.v1.UserId> userIds_ =
        java.util.Collections.emptyList();

    private void ensureUserIdsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        userIds_ = new java.util.ArrayList<com.google.recaptchaenterprise.v1.UserId>(userIds_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.recaptchaenterprise.v1.UserId,
            com.google.recaptchaenterprise.v1.UserId.Builder,
            com.google.recaptchaenterprise.v1.UserIdOrBuilder>
        userIdsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Identifiers associated with this user or request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.UserId user_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.recaptchaenterprise.v1.UserId> getUserIdsList() {
      if (userIdsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(userIds_);
      } else {
        return userIdsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Identifiers associated with this user or request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.UserId user_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getUserIdsCount() {
      if (userIdsBuilder_ == null) {
        return userIds_.size();
      } else {
        return userIdsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Identifiers associated with this user or request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.UserId user_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.UserId getUserIds(int index) {
      if (userIdsBuilder_ == null) {
        return userIds_.get(index);
      } else {
        return userIdsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Identifiers associated with this user or request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.UserId user_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setUserIds(int index, com.google.recaptchaenterprise.v1.UserId value) {
      if (userIdsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUserIdsIsMutable();
        userIds_.set(index, value);
        onChanged();
      } else {
        userIdsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Identifiers associated with this user or request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.UserId user_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setUserIds(
        int index, com.google.recaptchaenterprise.v1.UserId.Builder builderForValue) {
      if (userIdsBuilder_ == null) {
        ensureUserIdsIsMutable();
        userIds_.set(index, builderForValue.build());
        onChanged();
      } else {
        userIdsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Identifiers associated with this user or request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.UserId user_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addUserIds(com.google.recaptchaenterprise.v1.UserId value) {
      if (userIdsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUserIdsIsMutable();
        userIds_.add(value);
        onChanged();
      } else {
        userIdsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Identifiers associated with this user or request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.UserId user_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addUserIds(int index, com.google.recaptchaenterprise.v1.UserId value) {
      if (userIdsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUserIdsIsMutable();
        userIds_.add(index, value);
        onChanged();
      } else {
        userIdsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Identifiers associated with this user or request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.UserId user_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addUserIds(com.google.recaptchaenterprise.v1.UserId.Builder builderForValue) {
      if (userIdsBuilder_ == null) {
        ensureUserIdsIsMutable();
        userIds_.add(builderForValue.build());
        onChanged();
      } else {
        userIdsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Identifiers associated with this user or request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.UserId user_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addUserIds(
        int index, com.google.recaptchaenterprise.v1.UserId.Builder builderForValue) {
      if (userIdsBuilder_ == null) {
        ensureUserIdsIsMutable();
        userIds_.add(index, builderForValue.build());
        onChanged();
      } else {
        userIdsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Identifiers associated with this user or request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.UserId user_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllUserIds(
        java.lang.Iterable<? extends com.google.recaptchaenterprise.v1.UserId> values) {
      if (userIdsBuilder_ == null) {
        ensureUserIdsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, userIds_);
        onChanged();
      } else {
        userIdsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Identifiers associated with this user or request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.UserId user_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearUserIds() {
      if (userIdsBuilder_ == null) {
        userIds_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        userIdsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Identifiers associated with this user or request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.UserId user_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeUserIds(int index) {
      if (userIdsBuilder_ == null) {
        ensureUserIdsIsMutable();
        userIds_.remove(index);
        onChanged();
      } else {
        userIdsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Identifiers associated with this user or request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.UserId user_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.UserId.Builder getUserIdsBuilder(int index) {
      return getUserIdsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Identifiers associated with this user or request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.UserId user_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.UserIdOrBuilder getUserIdsOrBuilder(int index) {
      if (userIdsBuilder_ == null) {
        return userIds_.get(index);
      } else {
        return userIdsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Identifiers associated with this user or request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.UserId user_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.recaptchaenterprise.v1.UserIdOrBuilder>
        getUserIdsOrBuilderList() {
      if (userIdsBuilder_ != null) {
        return userIdsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(userIds_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Identifiers associated with this user or request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.UserId user_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.UserId.Builder addUserIdsBuilder() {
      return getUserIdsFieldBuilder()
          .addBuilder(com.google.recaptchaenterprise.v1.UserId.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Identifiers associated with this user or request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.UserId user_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.UserId.Builder addUserIdsBuilder(int index) {
      return getUserIdsFieldBuilder()
          .addBuilder(index, com.google.recaptchaenterprise.v1.UserId.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Identifiers associated with this user or request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.UserId user_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.recaptchaenterprise.v1.UserId.Builder>
        getUserIdsBuilderList() {
      return getUserIdsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.recaptchaenterprise.v1.UserId,
            com.google.recaptchaenterprise.v1.UserId.Builder,
            com.google.recaptchaenterprise.v1.UserIdOrBuilder>
        getUserIdsFieldBuilder() {
      if (userIdsBuilder_ == null) {
        userIdsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.recaptchaenterprise.v1.UserId,
                com.google.recaptchaenterprise.v1.UserId.Builder,
                com.google.recaptchaenterprise.v1.UserIdOrBuilder>(
                userIds_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        userIds_ = null;
      }
      return userIdsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.recaptchaenterprise.v1.UserInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.recaptchaenterprise.v1.UserInfo)
  private static final com.google.recaptchaenterprise.v1.UserInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.recaptchaenterprise.v1.UserInfo();
  }

  public static com.google.recaptchaenterprise.v1.UserInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UserInfo> PARSER =
      new com.google.protobuf.AbstractParser<UserInfo>() {
        @java.lang.Override
        public UserInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UserInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UserInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.recaptchaenterprise.v1.UserInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
