/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/recaptchaenterprise/v1beta1/recaptchaenterprise.proto

package com.google.recaptchaenterprise.v1beta1;

/**
 *
 *
 * <pre>
 * A key used to identify and configure applications (web and/or mobile) that
 * use reCAPTCHA Enterprise.
 * </pre>
 *
 * Protobuf type {@code google.cloud.recaptchaenterprise.v1beta1.Key}
 */
public final class Key extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.recaptchaenterprise.v1beta1.Key)
    KeyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Key.newBuilder() to construct.
  private Key(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Key() {
    name_ = "";
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Key();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Key(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              displayName_ = s;
              break;
            }
          case 26:
            {
              com.google.recaptchaenterprise.v1beta1.WebKeySettings.Builder subBuilder = null;
              if (platformSettingsCase_ == 3) {
                subBuilder =
                    ((com.google.recaptchaenterprise.v1beta1.WebKeySettings) platformSettings_)
                        .toBuilder();
              }
              platformSettings_ =
                  input.readMessage(
                      com.google.recaptchaenterprise.v1beta1.WebKeySettings.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.recaptchaenterprise.v1beta1.WebKeySettings) platformSettings_);
                platformSettings_ = subBuilder.buildPartial();
              }
              platformSettingsCase_ = 3;
              break;
            }
          case 34:
            {
              com.google.recaptchaenterprise.v1beta1.AndroidKeySettings.Builder subBuilder = null;
              if (platformSettingsCase_ == 4) {
                subBuilder =
                    ((com.google.recaptchaenterprise.v1beta1.AndroidKeySettings) platformSettings_)
                        .toBuilder();
              }
              platformSettings_ =
                  input.readMessage(
                      com.google.recaptchaenterprise.v1beta1.AndroidKeySettings.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.recaptchaenterprise.v1beta1.AndroidKeySettings) platformSettings_);
                platformSettings_ = subBuilder.buildPartial();
              }
              platformSettingsCase_ = 4;
              break;
            }
          case 42:
            {
              com.google.recaptchaenterprise.v1beta1.IOSKeySettings.Builder subBuilder = null;
              if (platformSettingsCase_ == 5) {
                subBuilder =
                    ((com.google.recaptchaenterprise.v1beta1.IOSKeySettings) platformSettings_)
                        .toBuilder();
              }
              platformSettings_ =
                  input.readMessage(
                      com.google.recaptchaenterprise.v1beta1.IOSKeySettings.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.recaptchaenterprise.v1beta1.IOSKeySettings) platformSettings_);
                platformSettings_ = subBuilder.buildPartial();
              }
              platformSettingsCase_ = 5;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1beta1_Key_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1beta1_Key_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.recaptchaenterprise.v1beta1.Key.class,
            com.google.recaptchaenterprise.v1beta1.Key.Builder.class);
  }

  private int platformSettingsCase_ = 0;
  private java.lang.Object platformSettings_;

  public enum PlatformSettingsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    WEB_SETTINGS(3),
    ANDROID_SETTINGS(4),
    IOS_SETTINGS(5),
    PLATFORMSETTINGS_NOT_SET(0);
    private final int value;

    private PlatformSettingsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PlatformSettingsCase valueOf(int value) {
      return forNumber(value);
    }

    public static PlatformSettingsCase forNumber(int value) {
      switch (value) {
        case 3:
          return WEB_SETTINGS;
        case 4:
          return ANDROID_SETTINGS;
        case 5:
          return IOS_SETTINGS;
        case 0:
          return PLATFORMSETTINGS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public PlatformSettingsCase getPlatformSettingsCase() {
    return PlatformSettingsCase.forNumber(platformSettingsCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The resource name for the Key in the format
   * "projects/{project_number}/keys/{key_id}".
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name for the Key in the format
   * "projects/{project_number}/keys/{key_id}".
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Human-readable display name of this key. Modifiable by user.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Human-readable display name of this key. Modifiable by user.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WEB_SETTINGS_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Settings for keys that can be used by websites.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.WebKeySettings web_settings = 3;</code>
   *
   * @return Whether the webSettings field is set.
   */
  public boolean hasWebSettings() {
    return platformSettingsCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Settings for keys that can be used by websites.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.WebKeySettings web_settings = 3;</code>
   *
   * @return The webSettings.
   */
  public com.google.recaptchaenterprise.v1beta1.WebKeySettings getWebSettings() {
    if (platformSettingsCase_ == 3) {
      return (com.google.recaptchaenterprise.v1beta1.WebKeySettings) platformSettings_;
    }
    return com.google.recaptchaenterprise.v1beta1.WebKeySettings.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Settings for keys that can be used by websites.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.WebKeySettings web_settings = 3;</code>
   */
  public com.google.recaptchaenterprise.v1beta1.WebKeySettingsOrBuilder getWebSettingsOrBuilder() {
    if (platformSettingsCase_ == 3) {
      return (com.google.recaptchaenterprise.v1beta1.WebKeySettings) platformSettings_;
    }
    return com.google.recaptchaenterprise.v1beta1.WebKeySettings.getDefaultInstance();
  }

  public static final int ANDROID_SETTINGS_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Settings for keys that can be used by Android apps.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.AndroidKeySettings android_settings = 4;</code>
   *
   * @return Whether the androidSettings field is set.
   */
  public boolean hasAndroidSettings() {
    return platformSettingsCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Settings for keys that can be used by Android apps.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.AndroidKeySettings android_settings = 4;</code>
   *
   * @return The androidSettings.
   */
  public com.google.recaptchaenterprise.v1beta1.AndroidKeySettings getAndroidSettings() {
    if (platformSettingsCase_ == 4) {
      return (com.google.recaptchaenterprise.v1beta1.AndroidKeySettings) platformSettings_;
    }
    return com.google.recaptchaenterprise.v1beta1.AndroidKeySettings.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Settings for keys that can be used by Android apps.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.AndroidKeySettings android_settings = 4;</code>
   */
  public com.google.recaptchaenterprise.v1beta1.AndroidKeySettingsOrBuilder
      getAndroidSettingsOrBuilder() {
    if (platformSettingsCase_ == 4) {
      return (com.google.recaptchaenterprise.v1beta1.AndroidKeySettings) platformSettings_;
    }
    return com.google.recaptchaenterprise.v1beta1.AndroidKeySettings.getDefaultInstance();
  }

  public static final int IOS_SETTINGS_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Settings for keys that can be used by iOS apps.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.IOSKeySettings ios_settings = 5;</code>
   *
   * @return Whether the iosSettings field is set.
   */
  public boolean hasIosSettings() {
    return platformSettingsCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Settings for keys that can be used by iOS apps.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.IOSKeySettings ios_settings = 5;</code>
   *
   * @return The iosSettings.
   */
  public com.google.recaptchaenterprise.v1beta1.IOSKeySettings getIosSettings() {
    if (platformSettingsCase_ == 5) {
      return (com.google.recaptchaenterprise.v1beta1.IOSKeySettings) platformSettings_;
    }
    return com.google.recaptchaenterprise.v1beta1.IOSKeySettings.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Settings for keys that can be used by iOS apps.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.IOSKeySettings ios_settings = 5;</code>
   */
  public com.google.recaptchaenterprise.v1beta1.IOSKeySettingsOrBuilder getIosSettingsOrBuilder() {
    if (platformSettingsCase_ == 5) {
      return (com.google.recaptchaenterprise.v1beta1.IOSKeySettings) platformSettings_;
    }
    return com.google.recaptchaenterprise.v1beta1.IOSKeySettings.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (platformSettingsCase_ == 3) {
      output.writeMessage(
          3, (com.google.recaptchaenterprise.v1beta1.WebKeySettings) platformSettings_);
    }
    if (platformSettingsCase_ == 4) {
      output.writeMessage(
          4, (com.google.recaptchaenterprise.v1beta1.AndroidKeySettings) platformSettings_);
    }
    if (platformSettingsCase_ == 5) {
      output.writeMessage(
          5, (com.google.recaptchaenterprise.v1beta1.IOSKeySettings) platformSettings_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (platformSettingsCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.recaptchaenterprise.v1beta1.WebKeySettings) platformSettings_);
    }
    if (platformSettingsCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.recaptchaenterprise.v1beta1.AndroidKeySettings) platformSettings_);
    }
    if (platformSettingsCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.recaptchaenterprise.v1beta1.IOSKeySettings) platformSettings_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.recaptchaenterprise.v1beta1.Key)) {
      return super.equals(obj);
    }
    com.google.recaptchaenterprise.v1beta1.Key other =
        (com.google.recaptchaenterprise.v1beta1.Key) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getPlatformSettingsCase().equals(other.getPlatformSettingsCase())) return false;
    switch (platformSettingsCase_) {
      case 3:
        if (!getWebSettings().equals(other.getWebSettings())) return false;
        break;
      case 4:
        if (!getAndroidSettings().equals(other.getAndroidSettings())) return false;
        break;
      case 5:
        if (!getIosSettings().equals(other.getIosSettings())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    switch (platformSettingsCase_) {
      case 3:
        hash = (37 * hash) + WEB_SETTINGS_FIELD_NUMBER;
        hash = (53 * hash) + getWebSettings().hashCode();
        break;
      case 4:
        hash = (37 * hash) + ANDROID_SETTINGS_FIELD_NUMBER;
        hash = (53 * hash) + getAndroidSettings().hashCode();
        break;
      case 5:
        hash = (37 * hash) + IOS_SETTINGS_FIELD_NUMBER;
        hash = (53 * hash) + getIosSettings().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.recaptchaenterprise.v1beta1.Key parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1beta1.Key parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.Key parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1beta1.Key parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.Key parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1beta1.Key parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.Key parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1beta1.Key parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.Key parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1beta1.Key parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.Key parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1beta1.Key parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.recaptchaenterprise.v1beta1.Key prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A key used to identify and configure applications (web and/or mobile) that
   * use reCAPTCHA Enterprise.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recaptchaenterprise.v1beta1.Key}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.recaptchaenterprise.v1beta1.Key)
      com.google.recaptchaenterprise.v1beta1.KeyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_Key_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_Key_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.recaptchaenterprise.v1beta1.Key.class,
              com.google.recaptchaenterprise.v1beta1.Key.Builder.class);
    }

    // Construct using com.google.recaptchaenterprise.v1beta1.Key.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      displayName_ = "";

      platformSettingsCase_ = 0;
      platformSettings_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_Key_descriptor;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.Key getDefaultInstanceForType() {
      return com.google.recaptchaenterprise.v1beta1.Key.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.Key build() {
      com.google.recaptchaenterprise.v1beta1.Key result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.Key buildPartial() {
      com.google.recaptchaenterprise.v1beta1.Key result =
          new com.google.recaptchaenterprise.v1beta1.Key(this);
      result.name_ = name_;
      result.displayName_ = displayName_;
      if (platformSettingsCase_ == 3) {
        if (webSettingsBuilder_ == null) {
          result.platformSettings_ = platformSettings_;
        } else {
          result.platformSettings_ = webSettingsBuilder_.build();
        }
      }
      if (platformSettingsCase_ == 4) {
        if (androidSettingsBuilder_ == null) {
          result.platformSettings_ = platformSettings_;
        } else {
          result.platformSettings_ = androidSettingsBuilder_.build();
        }
      }
      if (platformSettingsCase_ == 5) {
        if (iosSettingsBuilder_ == null) {
          result.platformSettings_ = platformSettings_;
        } else {
          result.platformSettings_ = iosSettingsBuilder_.build();
        }
      }
      result.platformSettingsCase_ = platformSettingsCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.recaptchaenterprise.v1beta1.Key) {
        return mergeFrom((com.google.recaptchaenterprise.v1beta1.Key) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.recaptchaenterprise.v1beta1.Key other) {
      if (other == com.google.recaptchaenterprise.v1beta1.Key.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      switch (other.getPlatformSettingsCase()) {
        case WEB_SETTINGS:
          {
            mergeWebSettings(other.getWebSettings());
            break;
          }
        case ANDROID_SETTINGS:
          {
            mergeAndroidSettings(other.getAndroidSettings());
            break;
          }
        case IOS_SETTINGS:
          {
            mergeIosSettings(other.getIosSettings());
            break;
          }
        case PLATFORMSETTINGS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.recaptchaenterprise.v1beta1.Key parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.recaptchaenterprise.v1beta1.Key) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int platformSettingsCase_ = 0;
    private java.lang.Object platformSettings_;

    public PlatformSettingsCase getPlatformSettingsCase() {
      return PlatformSettingsCase.forNumber(platformSettingsCase_);
    }

    public Builder clearPlatformSettings() {
      platformSettingsCase_ = 0;
      platformSettings_ = null;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name for the Key in the format
     * "projects/{project_number}/keys/{key_id}".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name for the Key in the format
     * "projects/{project_number}/keys/{key_id}".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name for the Key in the format
     * "projects/{project_number}/keys/{key_id}".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name for the Key in the format
     * "projects/{project_number}/keys/{key_id}".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name for the Key in the format
     * "projects/{project_number}/keys/{key_id}".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Human-readable display name of this key. Modifiable by user.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Human-readable display name of this key. Modifiable by user.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Human-readable display name of this key. Modifiable by user.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Human-readable display name of this key. Modifiable by user.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Human-readable display name of this key. Modifiable by user.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.WebKeySettings,
            com.google.recaptchaenterprise.v1beta1.WebKeySettings.Builder,
            com.google.recaptchaenterprise.v1beta1.WebKeySettingsOrBuilder>
        webSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by websites.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.WebKeySettings web_settings = 3;</code>
     *
     * @return Whether the webSettings field is set.
     */
    public boolean hasWebSettings() {
      return platformSettingsCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by websites.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.WebKeySettings web_settings = 3;</code>
     *
     * @return The webSettings.
     */
    public com.google.recaptchaenterprise.v1beta1.WebKeySettings getWebSettings() {
      if (webSettingsBuilder_ == null) {
        if (platformSettingsCase_ == 3) {
          return (com.google.recaptchaenterprise.v1beta1.WebKeySettings) platformSettings_;
        }
        return com.google.recaptchaenterprise.v1beta1.WebKeySettings.getDefaultInstance();
      } else {
        if (platformSettingsCase_ == 3) {
          return webSettingsBuilder_.getMessage();
        }
        return com.google.recaptchaenterprise.v1beta1.WebKeySettings.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by websites.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.WebKeySettings web_settings = 3;</code>
     */
    public Builder setWebSettings(com.google.recaptchaenterprise.v1beta1.WebKeySettings value) {
      if (webSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        platformSettings_ = value;
        onChanged();
      } else {
        webSettingsBuilder_.setMessage(value);
      }
      platformSettingsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by websites.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.WebKeySettings web_settings = 3;</code>
     */
    public Builder setWebSettings(
        com.google.recaptchaenterprise.v1beta1.WebKeySettings.Builder builderForValue) {
      if (webSettingsBuilder_ == null) {
        platformSettings_ = builderForValue.build();
        onChanged();
      } else {
        webSettingsBuilder_.setMessage(builderForValue.build());
      }
      platformSettingsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by websites.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.WebKeySettings web_settings = 3;</code>
     */
    public Builder mergeWebSettings(com.google.recaptchaenterprise.v1beta1.WebKeySettings value) {
      if (webSettingsBuilder_ == null) {
        if (platformSettingsCase_ == 3
            && platformSettings_
                != com.google.recaptchaenterprise.v1beta1.WebKeySettings.getDefaultInstance()) {
          platformSettings_ =
              com.google.recaptchaenterprise.v1beta1.WebKeySettings.newBuilder(
                      (com.google.recaptchaenterprise.v1beta1.WebKeySettings) platformSettings_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          platformSettings_ = value;
        }
        onChanged();
      } else {
        if (platformSettingsCase_ == 3) {
          webSettingsBuilder_.mergeFrom(value);
        }
        webSettingsBuilder_.setMessage(value);
      }
      platformSettingsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by websites.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.WebKeySettings web_settings = 3;</code>
     */
    public Builder clearWebSettings() {
      if (webSettingsBuilder_ == null) {
        if (platformSettingsCase_ == 3) {
          platformSettingsCase_ = 0;
          platformSettings_ = null;
          onChanged();
        }
      } else {
        if (platformSettingsCase_ == 3) {
          platformSettingsCase_ = 0;
          platformSettings_ = null;
        }
        webSettingsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by websites.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.WebKeySettings web_settings = 3;</code>
     */
    public com.google.recaptchaenterprise.v1beta1.WebKeySettings.Builder getWebSettingsBuilder() {
      return getWebSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by websites.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.WebKeySettings web_settings = 3;</code>
     */
    public com.google.recaptchaenterprise.v1beta1.WebKeySettingsOrBuilder
        getWebSettingsOrBuilder() {
      if ((platformSettingsCase_ == 3) && (webSettingsBuilder_ != null)) {
        return webSettingsBuilder_.getMessageOrBuilder();
      } else {
        if (platformSettingsCase_ == 3) {
          return (com.google.recaptchaenterprise.v1beta1.WebKeySettings) platformSettings_;
        }
        return com.google.recaptchaenterprise.v1beta1.WebKeySettings.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by websites.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.WebKeySettings web_settings = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.WebKeySettings,
            com.google.recaptchaenterprise.v1beta1.WebKeySettings.Builder,
            com.google.recaptchaenterprise.v1beta1.WebKeySettingsOrBuilder>
        getWebSettingsFieldBuilder() {
      if (webSettingsBuilder_ == null) {
        if (!(platformSettingsCase_ == 3)) {
          platformSettings_ =
              com.google.recaptchaenterprise.v1beta1.WebKeySettings.getDefaultInstance();
        }
        webSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1beta1.WebKeySettings,
                com.google.recaptchaenterprise.v1beta1.WebKeySettings.Builder,
                com.google.recaptchaenterprise.v1beta1.WebKeySettingsOrBuilder>(
                (com.google.recaptchaenterprise.v1beta1.WebKeySettings) platformSettings_,
                getParentForChildren(),
                isClean());
        platformSettings_ = null;
      }
      platformSettingsCase_ = 3;
      onChanged();
      ;
      return webSettingsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.AndroidKeySettings,
            com.google.recaptchaenterprise.v1beta1.AndroidKeySettings.Builder,
            com.google.recaptchaenterprise.v1beta1.AndroidKeySettingsOrBuilder>
        androidSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by Android apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.AndroidKeySettings android_settings = 4;
     * </code>
     *
     * @return Whether the androidSettings field is set.
     */
    public boolean hasAndroidSettings() {
      return platformSettingsCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by Android apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.AndroidKeySettings android_settings = 4;
     * </code>
     *
     * @return The androidSettings.
     */
    public com.google.recaptchaenterprise.v1beta1.AndroidKeySettings getAndroidSettings() {
      if (androidSettingsBuilder_ == null) {
        if (platformSettingsCase_ == 4) {
          return (com.google.recaptchaenterprise.v1beta1.AndroidKeySettings) platformSettings_;
        }
        return com.google.recaptchaenterprise.v1beta1.AndroidKeySettings.getDefaultInstance();
      } else {
        if (platformSettingsCase_ == 4) {
          return androidSettingsBuilder_.getMessage();
        }
        return com.google.recaptchaenterprise.v1beta1.AndroidKeySettings.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by Android apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.AndroidKeySettings android_settings = 4;
     * </code>
     */
    public Builder setAndroidSettings(
        com.google.recaptchaenterprise.v1beta1.AndroidKeySettings value) {
      if (androidSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        platformSettings_ = value;
        onChanged();
      } else {
        androidSettingsBuilder_.setMessage(value);
      }
      platformSettingsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by Android apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.AndroidKeySettings android_settings = 4;
     * </code>
     */
    public Builder setAndroidSettings(
        com.google.recaptchaenterprise.v1beta1.AndroidKeySettings.Builder builderForValue) {
      if (androidSettingsBuilder_ == null) {
        platformSettings_ = builderForValue.build();
        onChanged();
      } else {
        androidSettingsBuilder_.setMessage(builderForValue.build());
      }
      platformSettingsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by Android apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.AndroidKeySettings android_settings = 4;
     * </code>
     */
    public Builder mergeAndroidSettings(
        com.google.recaptchaenterprise.v1beta1.AndroidKeySettings value) {
      if (androidSettingsBuilder_ == null) {
        if (platformSettingsCase_ == 4
            && platformSettings_
                != com.google.recaptchaenterprise.v1beta1.AndroidKeySettings.getDefaultInstance()) {
          platformSettings_ =
              com.google.recaptchaenterprise.v1beta1.AndroidKeySettings.newBuilder(
                      (com.google.recaptchaenterprise.v1beta1.AndroidKeySettings) platformSettings_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          platformSettings_ = value;
        }
        onChanged();
      } else {
        if (platformSettingsCase_ == 4) {
          androidSettingsBuilder_.mergeFrom(value);
        }
        androidSettingsBuilder_.setMessage(value);
      }
      platformSettingsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by Android apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.AndroidKeySettings android_settings = 4;
     * </code>
     */
    public Builder clearAndroidSettings() {
      if (androidSettingsBuilder_ == null) {
        if (platformSettingsCase_ == 4) {
          platformSettingsCase_ = 0;
          platformSettings_ = null;
          onChanged();
        }
      } else {
        if (platformSettingsCase_ == 4) {
          platformSettingsCase_ = 0;
          platformSettings_ = null;
        }
        androidSettingsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by Android apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.AndroidKeySettings android_settings = 4;
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.AndroidKeySettings.Builder
        getAndroidSettingsBuilder() {
      return getAndroidSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by Android apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.AndroidKeySettings android_settings = 4;
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.AndroidKeySettingsOrBuilder
        getAndroidSettingsOrBuilder() {
      if ((platformSettingsCase_ == 4) && (androidSettingsBuilder_ != null)) {
        return androidSettingsBuilder_.getMessageOrBuilder();
      } else {
        if (platformSettingsCase_ == 4) {
          return (com.google.recaptchaenterprise.v1beta1.AndroidKeySettings) platformSettings_;
        }
        return com.google.recaptchaenterprise.v1beta1.AndroidKeySettings.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by Android apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.AndroidKeySettings android_settings = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.AndroidKeySettings,
            com.google.recaptchaenterprise.v1beta1.AndroidKeySettings.Builder,
            com.google.recaptchaenterprise.v1beta1.AndroidKeySettingsOrBuilder>
        getAndroidSettingsFieldBuilder() {
      if (androidSettingsBuilder_ == null) {
        if (!(platformSettingsCase_ == 4)) {
          platformSettings_ =
              com.google.recaptchaenterprise.v1beta1.AndroidKeySettings.getDefaultInstance();
        }
        androidSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1beta1.AndroidKeySettings,
                com.google.recaptchaenterprise.v1beta1.AndroidKeySettings.Builder,
                com.google.recaptchaenterprise.v1beta1.AndroidKeySettingsOrBuilder>(
                (com.google.recaptchaenterprise.v1beta1.AndroidKeySettings) platformSettings_,
                getParentForChildren(),
                isClean());
        platformSettings_ = null;
      }
      platformSettingsCase_ = 4;
      onChanged();
      ;
      return androidSettingsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.IOSKeySettings,
            com.google.recaptchaenterprise.v1beta1.IOSKeySettings.Builder,
            com.google.recaptchaenterprise.v1beta1.IOSKeySettingsOrBuilder>
        iosSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by iOS apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.IOSKeySettings ios_settings = 5;</code>
     *
     * @return Whether the iosSettings field is set.
     */
    public boolean hasIosSettings() {
      return platformSettingsCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by iOS apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.IOSKeySettings ios_settings = 5;</code>
     *
     * @return The iosSettings.
     */
    public com.google.recaptchaenterprise.v1beta1.IOSKeySettings getIosSettings() {
      if (iosSettingsBuilder_ == null) {
        if (platformSettingsCase_ == 5) {
          return (com.google.recaptchaenterprise.v1beta1.IOSKeySettings) platformSettings_;
        }
        return com.google.recaptchaenterprise.v1beta1.IOSKeySettings.getDefaultInstance();
      } else {
        if (platformSettingsCase_ == 5) {
          return iosSettingsBuilder_.getMessage();
        }
        return com.google.recaptchaenterprise.v1beta1.IOSKeySettings.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by iOS apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.IOSKeySettings ios_settings = 5;</code>
     */
    public Builder setIosSettings(com.google.recaptchaenterprise.v1beta1.IOSKeySettings value) {
      if (iosSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        platformSettings_ = value;
        onChanged();
      } else {
        iosSettingsBuilder_.setMessage(value);
      }
      platformSettingsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by iOS apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.IOSKeySettings ios_settings = 5;</code>
     */
    public Builder setIosSettings(
        com.google.recaptchaenterprise.v1beta1.IOSKeySettings.Builder builderForValue) {
      if (iosSettingsBuilder_ == null) {
        platformSettings_ = builderForValue.build();
        onChanged();
      } else {
        iosSettingsBuilder_.setMessage(builderForValue.build());
      }
      platformSettingsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by iOS apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.IOSKeySettings ios_settings = 5;</code>
     */
    public Builder mergeIosSettings(com.google.recaptchaenterprise.v1beta1.IOSKeySettings value) {
      if (iosSettingsBuilder_ == null) {
        if (platformSettingsCase_ == 5
            && platformSettings_
                != com.google.recaptchaenterprise.v1beta1.IOSKeySettings.getDefaultInstance()) {
          platformSettings_ =
              com.google.recaptchaenterprise.v1beta1.IOSKeySettings.newBuilder(
                      (com.google.recaptchaenterprise.v1beta1.IOSKeySettings) platformSettings_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          platformSettings_ = value;
        }
        onChanged();
      } else {
        if (platformSettingsCase_ == 5) {
          iosSettingsBuilder_.mergeFrom(value);
        }
        iosSettingsBuilder_.setMessage(value);
      }
      platformSettingsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by iOS apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.IOSKeySettings ios_settings = 5;</code>
     */
    public Builder clearIosSettings() {
      if (iosSettingsBuilder_ == null) {
        if (platformSettingsCase_ == 5) {
          platformSettingsCase_ = 0;
          platformSettings_ = null;
          onChanged();
        }
      } else {
        if (platformSettingsCase_ == 5) {
          platformSettingsCase_ = 0;
          platformSettings_ = null;
        }
        iosSettingsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by iOS apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.IOSKeySettings ios_settings = 5;</code>
     */
    public com.google.recaptchaenterprise.v1beta1.IOSKeySettings.Builder getIosSettingsBuilder() {
      return getIosSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by iOS apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.IOSKeySettings ios_settings = 5;</code>
     */
    public com.google.recaptchaenterprise.v1beta1.IOSKeySettingsOrBuilder
        getIosSettingsOrBuilder() {
      if ((platformSettingsCase_ == 5) && (iosSettingsBuilder_ != null)) {
        return iosSettingsBuilder_.getMessageOrBuilder();
      } else {
        if (platformSettingsCase_ == 5) {
          return (com.google.recaptchaenterprise.v1beta1.IOSKeySettings) platformSettings_;
        }
        return com.google.recaptchaenterprise.v1beta1.IOSKeySettings.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by iOS apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.IOSKeySettings ios_settings = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.IOSKeySettings,
            com.google.recaptchaenterprise.v1beta1.IOSKeySettings.Builder,
            com.google.recaptchaenterprise.v1beta1.IOSKeySettingsOrBuilder>
        getIosSettingsFieldBuilder() {
      if (iosSettingsBuilder_ == null) {
        if (!(platformSettingsCase_ == 5)) {
          platformSettings_ =
              com.google.recaptchaenterprise.v1beta1.IOSKeySettings.getDefaultInstance();
        }
        iosSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1beta1.IOSKeySettings,
                com.google.recaptchaenterprise.v1beta1.IOSKeySettings.Builder,
                com.google.recaptchaenterprise.v1beta1.IOSKeySettingsOrBuilder>(
                (com.google.recaptchaenterprise.v1beta1.IOSKeySettings) platformSettings_,
                getParentForChildren(),
                isClean());
        platformSettings_ = null;
      }
      platformSettingsCase_ = 5;
      onChanged();
      ;
      return iosSettingsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.recaptchaenterprise.v1beta1.Key)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.recaptchaenterprise.v1beta1.Key)
  private static final com.google.recaptchaenterprise.v1beta1.Key DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.recaptchaenterprise.v1beta1.Key();
  }

  public static com.google.recaptchaenterprise.v1beta1.Key getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Key> PARSER =
      new com.google.protobuf.AbstractParser<Key>() {
        @java.lang.Override
        public Key parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Key(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Key> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Key> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.Key getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
