/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/recaptchaenterprise/v1beta1/recaptchaenterprise.proto

package com.google.recaptchaenterprise.v1beta1;

/**
 *
 *
 * <pre>
 * Settings specific to keys that can be used by websites.
 * </pre>
 *
 * Protobuf type {@code google.cloud.recaptchaenterprise.v1beta1.WebKeySettings}
 */
public final class WebKeySettings extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.recaptchaenterprise.v1beta1.WebKeySettings)
    WebKeySettingsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use WebKeySettings.newBuilder() to construct.
  private WebKeySettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WebKeySettings() {
    allowedDomains_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    integrationType_ = 0;
    challengeSecurityPreference_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WebKeySettings();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private WebKeySettings(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                allowedDomains_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              allowedDomains_.add(s);
              break;
            }
          case 16:
            {
              allowAmpTraffic_ = input.readBool();
              break;
            }
          case 24:
            {
              enforceAllowedDomains_ = input.readBool();
              break;
            }
          case 32:
            {
              int rawValue = input.readEnum();

              integrationType_ = rawValue;
              break;
            }
          case 40:
            {
              int rawValue = input.readEnum();

              challengeSecurityPreference_ = rawValue;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        allowedDomains_ = allowedDomains_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1beta1_WebKeySettings_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1beta1_WebKeySettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.recaptchaenterprise.v1beta1.WebKeySettings.class,
            com.google.recaptchaenterprise.v1beta1.WebKeySettings.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Enum that represents the integration types for web keys.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.recaptchaenterprise.v1beta1.WebKeySettings.IntegrationType}
   */
  public enum IntegrationType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default type that indicates this enum hasn't been specified. This is not
     * a valid IntegrationType, one of the other types must be specified
     * instead.
     * </pre>
     *
     * <code>INTEGRATION_TYPE_UNSPECIFIED = 0;</code>
     */
    INTEGRATION_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Only used to produce scores. It doesn't display the "I'm not a robot"
     * checkbox and never shows captcha challenges.
     * </pre>
     *
     * <code>SCORE_ONLY = 1;</code>
     */
    SCORE_ONLY(1),
    /**
     *
     *
     * <pre>
     * Displays the "I'm not a robot" checkbox and may show captcha challenges
     * after it is checked.
     * </pre>
     *
     * <code>CHECKBOX_CHALLENGE = 2;</code>
     */
    CHECKBOX_CHALLENGE(2),
    /**
     *
     *
     * <pre>
     * Doesn't display the "I'm not a robot" checkbox, but may show captcha
     * challenges after risk analysis.
     * </pre>
     *
     * <code>INVISIBLE_CHALLENGE = 3;</code>
     */
    INVISIBLE_CHALLENGE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default type that indicates this enum hasn't been specified. This is not
     * a valid IntegrationType, one of the other types must be specified
     * instead.
     * </pre>
     *
     * <code>INTEGRATION_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int INTEGRATION_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Only used to produce scores. It doesn't display the "I'm not a robot"
     * checkbox and never shows captcha challenges.
     * </pre>
     *
     * <code>SCORE_ONLY = 1;</code>
     */
    public static final int SCORE_ONLY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Displays the "I'm not a robot" checkbox and may show captcha challenges
     * after it is checked.
     * </pre>
     *
     * <code>CHECKBOX_CHALLENGE = 2;</code>
     */
    public static final int CHECKBOX_CHALLENGE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Doesn't display the "I'm not a robot" checkbox, but may show captcha
     * challenges after risk analysis.
     * </pre>
     *
     * <code>INVISIBLE_CHALLENGE = 3;</code>
     */
    public static final int INVISIBLE_CHALLENGE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IntegrationType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static IntegrationType forNumber(int value) {
      switch (value) {
        case 0:
          return INTEGRATION_TYPE_UNSPECIFIED;
        case 1:
          return SCORE_ONLY;
        case 2:
          return CHECKBOX_CHALLENGE;
        case 3:
          return INVISIBLE_CHALLENGE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<IntegrationType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<IntegrationType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<IntegrationType>() {
              public IntegrationType findValueByNumber(int number) {
                return IntegrationType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1beta1.WebKeySettings.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final IntegrationType[] VALUES = values();

    public static IntegrationType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private IntegrationType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.recaptchaenterprise.v1beta1.WebKeySettings.IntegrationType)
  }

  /**
   *
   *
   * <pre>
   * Enum that represents the possible challenge frequency and difficulty
   * configurations for a web key.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.recaptchaenterprise.v1beta1.WebKeySettings.ChallengeSecurityPreference}
   */
  public enum ChallengeSecurityPreference implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default type that indicates this enum hasn't been specified.
     * </pre>
     *
     * <code>CHALLENGE_SECURITY_PREFERENCE_UNSPECIFIED = 0;</code>
     */
    CHALLENGE_SECURITY_PREFERENCE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Key tends to show fewer and easier challenges.
     * </pre>
     *
     * <code>USABILITY = 1;</code>
     */
    USABILITY(1),
    /**
     *
     *
     * <pre>
     * Key tends to show balanced (in amount and difficulty) challenges.
     * </pre>
     *
     * <code>BALANCED = 2;</code>
     */
    BALANCED(2),
    /**
     *
     *
     * <pre>
     * Key tends to show more and harder challenges.
     * </pre>
     *
     * <code>SECURITY = 3;</code>
     */
    SECURITY(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default type that indicates this enum hasn't been specified.
     * </pre>
     *
     * <code>CHALLENGE_SECURITY_PREFERENCE_UNSPECIFIED = 0;</code>
     */
    public static final int CHALLENGE_SECURITY_PREFERENCE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Key tends to show fewer and easier challenges.
     * </pre>
     *
     * <code>USABILITY = 1;</code>
     */
    public static final int USABILITY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Key tends to show balanced (in amount and difficulty) challenges.
     * </pre>
     *
     * <code>BALANCED = 2;</code>
     */
    public static final int BALANCED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Key tends to show more and harder challenges.
     * </pre>
     *
     * <code>SECURITY = 3;</code>
     */
    public static final int SECURITY_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ChallengeSecurityPreference valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ChallengeSecurityPreference forNumber(int value) {
      switch (value) {
        case 0:
          return CHALLENGE_SECURITY_PREFERENCE_UNSPECIFIED;
        case 1:
          return USABILITY;
        case 2:
          return BALANCED;
        case 3:
          return SECURITY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ChallengeSecurityPreference>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ChallengeSecurityPreference>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ChallengeSecurityPreference>() {
              public ChallengeSecurityPreference findValueByNumber(int number) {
                return ChallengeSecurityPreference.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1beta1.WebKeySettings.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final ChallengeSecurityPreference[] VALUES = values();

    public static ChallengeSecurityPreference valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ChallengeSecurityPreference(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.recaptchaenterprise.v1beta1.WebKeySettings.ChallengeSecurityPreference)
  }

  public static final int ENFORCE_ALLOWED_DOMAINS_FIELD_NUMBER = 3;
  private boolean enforceAllowedDomains_;
  /**
   *
   *
   * <pre>
   * Whether allowed_domains is enforced or not.
   * </pre>
   *
   * <code>bool enforce_allowed_domains = 3;</code>
   *
   * @return The enforceAllowedDomains.
   */
  public boolean getEnforceAllowedDomains() {
    return enforceAllowedDomains_;
  }

  public static final int ALLOWED_DOMAINS_FIELD_NUMBER = 1;
  private com.google.protobuf.LazyStringList allowedDomains_;
  /**
   *
   *
   * <pre>
   * Domains or subdomains of websites allowed to use the key. All subdomains
   * of an allowed domain are automatically allowed. A valid domain requires a
   * host and must not include any path, port, query or fragment.
   * Examples: 'example.com' or 'subdomain.example.com'
   * </pre>
   *
   * <code>repeated string allowed_domains = 1;</code>
   *
   * @return A list containing the allowedDomains.
   */
  public com.google.protobuf.ProtocolStringList getAllowedDomainsList() {
    return allowedDomains_;
  }
  /**
   *
   *
   * <pre>
   * Domains or subdomains of websites allowed to use the key. All subdomains
   * of an allowed domain are automatically allowed. A valid domain requires a
   * host and must not include any path, port, query or fragment.
   * Examples: 'example.com' or 'subdomain.example.com'
   * </pre>
   *
   * <code>repeated string allowed_domains = 1;</code>
   *
   * @return The count of allowedDomains.
   */
  public int getAllowedDomainsCount() {
    return allowedDomains_.size();
  }
  /**
   *
   *
   * <pre>
   * Domains or subdomains of websites allowed to use the key. All subdomains
   * of an allowed domain are automatically allowed. A valid domain requires a
   * host and must not include any path, port, query or fragment.
   * Examples: 'example.com' or 'subdomain.example.com'
   * </pre>
   *
   * <code>repeated string allowed_domains = 1;</code>
   *
   * @param index The index of the element to return.
   * @return The allowedDomains at the given index.
   */
  public java.lang.String getAllowedDomains(int index) {
    return allowedDomains_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Domains or subdomains of websites allowed to use the key. All subdomains
   * of an allowed domain are automatically allowed. A valid domain requires a
   * host and must not include any path, port, query or fragment.
   * Examples: 'example.com' or 'subdomain.example.com'
   * </pre>
   *
   * <code>repeated string allowed_domains = 1;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the allowedDomains at the given index.
   */
  public com.google.protobuf.ByteString getAllowedDomainsBytes(int index) {
    return allowedDomains_.getByteString(index);
  }

  public static final int ALLOW_AMP_TRAFFIC_FIELD_NUMBER = 2;
  private boolean allowAmpTraffic_;
  /**
   *
   *
   * <pre>
   * Whether this key can be used on AMP (Accelerated Mobile Pages) websites.
   * </pre>
   *
   * <code>bool allow_amp_traffic = 2;</code>
   *
   * @return The allowAmpTraffic.
   */
  public boolean getAllowAmpTraffic() {
    return allowAmpTraffic_;
  }

  public static final int INTEGRATION_TYPE_FIELD_NUMBER = 4;
  private int integrationType_;
  /**
   *
   *
   * <pre>
   * Required. Describes how this key is integrated with the website.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.WebKeySettings.IntegrationType integration_type = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for integrationType.
   */
  public int getIntegrationTypeValue() {
    return integrationType_;
  }
  /**
   *
   *
   * <pre>
   * Required. Describes how this key is integrated with the website.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.WebKeySettings.IntegrationType integration_type = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The integrationType.
   */
  public com.google.recaptchaenterprise.v1beta1.WebKeySettings.IntegrationType
      getIntegrationType() {
    @SuppressWarnings("deprecation")
    com.google.recaptchaenterprise.v1beta1.WebKeySettings.IntegrationType result =
        com.google.recaptchaenterprise.v1beta1.WebKeySettings.IntegrationType.valueOf(
            integrationType_);
    return result == null
        ? com.google.recaptchaenterprise.v1beta1.WebKeySettings.IntegrationType.UNRECOGNIZED
        : result;
  }

  public static final int CHALLENGE_SECURITY_PREFERENCE_FIELD_NUMBER = 5;
  private int challengeSecurityPreference_;
  /**
   *
   *
   * <pre>
   * Settings for the frequency and difficulty at which this key triggers
   * captcha challenges. This should only be specified for IntegrationTypes
   * CHECKBOX_CHALLENGE and INVISIBLE_CHALLENGE.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.WebKeySettings.ChallengeSecurityPreference challenge_security_preference = 5;
   * </code>
   *
   * @return The enum numeric value on the wire for challengeSecurityPreference.
   */
  public int getChallengeSecurityPreferenceValue() {
    return challengeSecurityPreference_;
  }
  /**
   *
   *
   * <pre>
   * Settings for the frequency and difficulty at which this key triggers
   * captcha challenges. This should only be specified for IntegrationTypes
   * CHECKBOX_CHALLENGE and INVISIBLE_CHALLENGE.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.WebKeySettings.ChallengeSecurityPreference challenge_security_preference = 5;
   * </code>
   *
   * @return The challengeSecurityPreference.
   */
  public com.google.recaptchaenterprise.v1beta1.WebKeySettings.ChallengeSecurityPreference
      getChallengeSecurityPreference() {
    @SuppressWarnings("deprecation")
    com.google.recaptchaenterprise.v1beta1.WebKeySettings.ChallengeSecurityPreference result =
        com.google.recaptchaenterprise.v1beta1.WebKeySettings.ChallengeSecurityPreference.valueOf(
            challengeSecurityPreference_);
    return result == null
        ? com.google.recaptchaenterprise.v1beta1.WebKeySettings.ChallengeSecurityPreference
            .UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < allowedDomains_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, allowedDomains_.getRaw(i));
    }
    if (allowAmpTraffic_ != false) {
      output.writeBool(2, allowAmpTraffic_);
    }
    if (enforceAllowedDomains_ != false) {
      output.writeBool(3, enforceAllowedDomains_);
    }
    if (integrationType_
        != com.google.recaptchaenterprise.v1beta1.WebKeySettings.IntegrationType
            .INTEGRATION_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, integrationType_);
    }
    if (challengeSecurityPreference_
        != com.google.recaptchaenterprise.v1beta1.WebKeySettings.ChallengeSecurityPreference
            .CHALLENGE_SECURITY_PREFERENCE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, challengeSecurityPreference_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < allowedDomains_.size(); i++) {
        dataSize += computeStringSizeNoTag(allowedDomains_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAllowedDomainsList().size();
    }
    if (allowAmpTraffic_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, allowAmpTraffic_);
    }
    if (enforceAllowedDomains_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, enforceAllowedDomains_);
    }
    if (integrationType_
        != com.google.recaptchaenterprise.v1beta1.WebKeySettings.IntegrationType
            .INTEGRATION_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, integrationType_);
    }
    if (challengeSecurityPreference_
        != com.google.recaptchaenterprise.v1beta1.WebKeySettings.ChallengeSecurityPreference
            .CHALLENGE_SECURITY_PREFERENCE_UNSPECIFIED
            .getNumber()) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(5, challengeSecurityPreference_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.recaptchaenterprise.v1beta1.WebKeySettings)) {
      return super.equals(obj);
    }
    com.google.recaptchaenterprise.v1beta1.WebKeySettings other =
        (com.google.recaptchaenterprise.v1beta1.WebKeySettings) obj;

    if (getEnforceAllowedDomains() != other.getEnforceAllowedDomains()) return false;
    if (!getAllowedDomainsList().equals(other.getAllowedDomainsList())) return false;
    if (getAllowAmpTraffic() != other.getAllowAmpTraffic()) return false;
    if (integrationType_ != other.integrationType_) return false;
    if (challengeSecurityPreference_ != other.challengeSecurityPreference_) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ENFORCE_ALLOWED_DOMAINS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnforceAllowedDomains());
    if (getAllowedDomainsCount() > 0) {
      hash = (37 * hash) + ALLOWED_DOMAINS_FIELD_NUMBER;
      hash = (53 * hash) + getAllowedDomainsList().hashCode();
    }
    hash = (37 * hash) + ALLOW_AMP_TRAFFIC_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowAmpTraffic());
    hash = (37 * hash) + INTEGRATION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + integrationType_;
    hash = (37 * hash) + CHALLENGE_SECURITY_PREFERENCE_FIELD_NUMBER;
    hash = (53 * hash) + challengeSecurityPreference_;
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.recaptchaenterprise.v1beta1.WebKeySettings parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1beta1.WebKeySettings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.WebKeySettings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1beta1.WebKeySettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.WebKeySettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1beta1.WebKeySettings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.WebKeySettings parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1beta1.WebKeySettings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.WebKeySettings parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1beta1.WebKeySettings parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.WebKeySettings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1beta1.WebKeySettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.recaptchaenterprise.v1beta1.WebKeySettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Settings specific to keys that can be used by websites.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recaptchaenterprise.v1beta1.WebKeySettings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.recaptchaenterprise.v1beta1.WebKeySettings)
      com.google.recaptchaenterprise.v1beta1.WebKeySettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_WebKeySettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_WebKeySettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.recaptchaenterprise.v1beta1.WebKeySettings.class,
              com.google.recaptchaenterprise.v1beta1.WebKeySettings.Builder.class);
    }

    // Construct using com.google.recaptchaenterprise.v1beta1.WebKeySettings.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      enforceAllowedDomains_ = false;

      allowedDomains_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      allowAmpTraffic_ = false;

      integrationType_ = 0;

      challengeSecurityPreference_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_WebKeySettings_descriptor;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.WebKeySettings getDefaultInstanceForType() {
      return com.google.recaptchaenterprise.v1beta1.WebKeySettings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.WebKeySettings build() {
      com.google.recaptchaenterprise.v1beta1.WebKeySettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.WebKeySettings buildPartial() {
      com.google.recaptchaenterprise.v1beta1.WebKeySettings result =
          new com.google.recaptchaenterprise.v1beta1.WebKeySettings(this);
      int from_bitField0_ = bitField0_;
      result.enforceAllowedDomains_ = enforceAllowedDomains_;
      if (((bitField0_ & 0x00000001) != 0)) {
        allowedDomains_ = allowedDomains_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.allowedDomains_ = allowedDomains_;
      result.allowAmpTraffic_ = allowAmpTraffic_;
      result.integrationType_ = integrationType_;
      result.challengeSecurityPreference_ = challengeSecurityPreference_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.recaptchaenterprise.v1beta1.WebKeySettings) {
        return mergeFrom((com.google.recaptchaenterprise.v1beta1.WebKeySettings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.recaptchaenterprise.v1beta1.WebKeySettings other) {
      if (other == com.google.recaptchaenterprise.v1beta1.WebKeySettings.getDefaultInstance())
        return this;
      if (other.getEnforceAllowedDomains() != false) {
        setEnforceAllowedDomains(other.getEnforceAllowedDomains());
      }
      if (!other.allowedDomains_.isEmpty()) {
        if (allowedDomains_.isEmpty()) {
          allowedDomains_ = other.allowedDomains_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureAllowedDomainsIsMutable();
          allowedDomains_.addAll(other.allowedDomains_);
        }
        onChanged();
      }
      if (other.getAllowAmpTraffic() != false) {
        setAllowAmpTraffic(other.getAllowAmpTraffic());
      }
      if (other.integrationType_ != 0) {
        setIntegrationTypeValue(other.getIntegrationTypeValue());
      }
      if (other.challengeSecurityPreference_ != 0) {
        setChallengeSecurityPreferenceValue(other.getChallengeSecurityPreferenceValue());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.recaptchaenterprise.v1beta1.WebKeySettings parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.recaptchaenterprise.v1beta1.WebKeySettings) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private boolean enforceAllowedDomains_;
    /**
     *
     *
     * <pre>
     * Whether allowed_domains is enforced or not.
     * </pre>
     *
     * <code>bool enforce_allowed_domains = 3;</code>
     *
     * @return The enforceAllowedDomains.
     */
    public boolean getEnforceAllowedDomains() {
      return enforceAllowedDomains_;
    }
    /**
     *
     *
     * <pre>
     * Whether allowed_domains is enforced or not.
     * </pre>
     *
     * <code>bool enforce_allowed_domains = 3;</code>
     *
     * @param value The enforceAllowedDomains to set.
     * @return This builder for chaining.
     */
    public Builder setEnforceAllowedDomains(boolean value) {

      enforceAllowedDomains_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether allowed_domains is enforced or not.
     * </pre>
     *
     * <code>bool enforce_allowed_domains = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnforceAllowedDomains() {

      enforceAllowedDomains_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList allowedDomains_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureAllowedDomainsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        allowedDomains_ = new com.google.protobuf.LazyStringArrayList(allowedDomains_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Domains or subdomains of websites allowed to use the key. All subdomains
     * of an allowed domain are automatically allowed. A valid domain requires a
     * host and must not include any path, port, query or fragment.
     * Examples: 'example.com' or 'subdomain.example.com'
     * </pre>
     *
     * <code>repeated string allowed_domains = 1;</code>
     *
     * @return A list containing the allowedDomains.
     */
    public com.google.protobuf.ProtocolStringList getAllowedDomainsList() {
      return allowedDomains_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Domains or subdomains of websites allowed to use the key. All subdomains
     * of an allowed domain are automatically allowed. A valid domain requires a
     * host and must not include any path, port, query or fragment.
     * Examples: 'example.com' or 'subdomain.example.com'
     * </pre>
     *
     * <code>repeated string allowed_domains = 1;</code>
     *
     * @return The count of allowedDomains.
     */
    public int getAllowedDomainsCount() {
      return allowedDomains_.size();
    }
    /**
     *
     *
     * <pre>
     * Domains or subdomains of websites allowed to use the key. All subdomains
     * of an allowed domain are automatically allowed. A valid domain requires a
     * host and must not include any path, port, query or fragment.
     * Examples: 'example.com' or 'subdomain.example.com'
     * </pre>
     *
     * <code>repeated string allowed_domains = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The allowedDomains at the given index.
     */
    public java.lang.String getAllowedDomains(int index) {
      return allowedDomains_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Domains or subdomains of websites allowed to use the key. All subdomains
     * of an allowed domain are automatically allowed. A valid domain requires a
     * host and must not include any path, port, query or fragment.
     * Examples: 'example.com' or 'subdomain.example.com'
     * </pre>
     *
     * <code>repeated string allowed_domains = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allowedDomains at the given index.
     */
    public com.google.protobuf.ByteString getAllowedDomainsBytes(int index) {
      return allowedDomains_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Domains or subdomains of websites allowed to use the key. All subdomains
     * of an allowed domain are automatically allowed. A valid domain requires a
     * host and must not include any path, port, query or fragment.
     * Examples: 'example.com' or 'subdomain.example.com'
     * </pre>
     *
     * <code>repeated string allowed_domains = 1;</code>
     *
     * @param index The index to set the value at.
     * @param value The allowedDomains to set.
     * @return This builder for chaining.
     */
    public Builder setAllowedDomains(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowedDomainsIsMutable();
      allowedDomains_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Domains or subdomains of websites allowed to use the key. All subdomains
     * of an allowed domain are automatically allowed. A valid domain requires a
     * host and must not include any path, port, query or fragment.
     * Examples: 'example.com' or 'subdomain.example.com'
     * </pre>
     *
     * <code>repeated string allowed_domains = 1;</code>
     *
     * @param value The allowedDomains to add.
     * @return This builder for chaining.
     */
    public Builder addAllowedDomains(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowedDomainsIsMutable();
      allowedDomains_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Domains or subdomains of websites allowed to use the key. All subdomains
     * of an allowed domain are automatically allowed. A valid domain requires a
     * host and must not include any path, port, query or fragment.
     * Examples: 'example.com' or 'subdomain.example.com'
     * </pre>
     *
     * <code>repeated string allowed_domains = 1;</code>
     *
     * @param values The allowedDomains to add.
     * @return This builder for chaining.
     */
    public Builder addAllAllowedDomains(java.lang.Iterable<java.lang.String> values) {
      ensureAllowedDomainsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowedDomains_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Domains or subdomains of websites allowed to use the key. All subdomains
     * of an allowed domain are automatically allowed. A valid domain requires a
     * host and must not include any path, port, query or fragment.
     * Examples: 'example.com' or 'subdomain.example.com'
     * </pre>
     *
     * <code>repeated string allowed_domains = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowedDomains() {
      allowedDomains_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Domains or subdomains of websites allowed to use the key. All subdomains
     * of an allowed domain are automatically allowed. A valid domain requires a
     * host and must not include any path, port, query or fragment.
     * Examples: 'example.com' or 'subdomain.example.com'
     * </pre>
     *
     * <code>repeated string allowed_domains = 1;</code>
     *
     * @param value The bytes of the allowedDomains to add.
     * @return This builder for chaining.
     */
    public Builder addAllowedDomainsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAllowedDomainsIsMutable();
      allowedDomains_.add(value);
      onChanged();
      return this;
    }

    private boolean allowAmpTraffic_;
    /**
     *
     *
     * <pre>
     * Whether this key can be used on AMP (Accelerated Mobile Pages) websites.
     * </pre>
     *
     * <code>bool allow_amp_traffic = 2;</code>
     *
     * @return The allowAmpTraffic.
     */
    public boolean getAllowAmpTraffic() {
      return allowAmpTraffic_;
    }
    /**
     *
     *
     * <pre>
     * Whether this key can be used on AMP (Accelerated Mobile Pages) websites.
     * </pre>
     *
     * <code>bool allow_amp_traffic = 2;</code>
     *
     * @param value The allowAmpTraffic to set.
     * @return This builder for chaining.
     */
    public Builder setAllowAmpTraffic(boolean value) {

      allowAmpTraffic_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether this key can be used on AMP (Accelerated Mobile Pages) websites.
     * </pre>
     *
     * <code>bool allow_amp_traffic = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowAmpTraffic() {

      allowAmpTraffic_ = false;
      onChanged();
      return this;
    }

    private int integrationType_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Describes how this key is integrated with the website.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.WebKeySettings.IntegrationType integration_type = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for integrationType.
     */
    public int getIntegrationTypeValue() {
      return integrationType_;
    }
    /**
     *
     *
     * <pre>
     * Required. Describes how this key is integrated with the website.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.WebKeySettings.IntegrationType integration_type = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for integrationType to set.
     * @return This builder for chaining.
     */
    public Builder setIntegrationTypeValue(int value) {
      integrationType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Describes how this key is integrated with the website.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.WebKeySettings.IntegrationType integration_type = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The integrationType.
     */
    public com.google.recaptchaenterprise.v1beta1.WebKeySettings.IntegrationType
        getIntegrationType() {
      @SuppressWarnings("deprecation")
      com.google.recaptchaenterprise.v1beta1.WebKeySettings.IntegrationType result =
          com.google.recaptchaenterprise.v1beta1.WebKeySettings.IntegrationType.valueOf(
              integrationType_);
      return result == null
          ? com.google.recaptchaenterprise.v1beta1.WebKeySettings.IntegrationType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Describes how this key is integrated with the website.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.WebKeySettings.IntegrationType integration_type = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The integrationType to set.
     * @return This builder for chaining.
     */
    public Builder setIntegrationType(
        com.google.recaptchaenterprise.v1beta1.WebKeySettings.IntegrationType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      integrationType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Describes how this key is integrated with the website.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.WebKeySettings.IntegrationType integration_type = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIntegrationType() {

      integrationType_ = 0;
      onChanged();
      return this;
    }

    private int challengeSecurityPreference_ = 0;
    /**
     *
     *
     * <pre>
     * Settings for the frequency and difficulty at which this key triggers
     * captcha challenges. This should only be specified for IntegrationTypes
     * CHECKBOX_CHALLENGE and INVISIBLE_CHALLENGE.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.WebKeySettings.ChallengeSecurityPreference challenge_security_preference = 5;
     * </code>
     *
     * @return The enum numeric value on the wire for challengeSecurityPreference.
     */
    public int getChallengeSecurityPreferenceValue() {
      return challengeSecurityPreference_;
    }
    /**
     *
     *
     * <pre>
     * Settings for the frequency and difficulty at which this key triggers
     * captcha challenges. This should only be specified for IntegrationTypes
     * CHECKBOX_CHALLENGE and INVISIBLE_CHALLENGE.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.WebKeySettings.ChallengeSecurityPreference challenge_security_preference = 5;
     * </code>
     *
     * @param value The enum numeric value on the wire for challengeSecurityPreference to set.
     * @return This builder for chaining.
     */
    public Builder setChallengeSecurityPreferenceValue(int value) {
      challengeSecurityPreference_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for the frequency and difficulty at which this key triggers
     * captcha challenges. This should only be specified for IntegrationTypes
     * CHECKBOX_CHALLENGE and INVISIBLE_CHALLENGE.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.WebKeySettings.ChallengeSecurityPreference challenge_security_preference = 5;
     * </code>
     *
     * @return The challengeSecurityPreference.
     */
    public com.google.recaptchaenterprise.v1beta1.WebKeySettings.ChallengeSecurityPreference
        getChallengeSecurityPreference() {
      @SuppressWarnings("deprecation")
      com.google.recaptchaenterprise.v1beta1.WebKeySettings.ChallengeSecurityPreference result =
          com.google.recaptchaenterprise.v1beta1.WebKeySettings.ChallengeSecurityPreference.valueOf(
              challengeSecurityPreference_);
      return result == null
          ? com.google.recaptchaenterprise.v1beta1.WebKeySettings.ChallengeSecurityPreference
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Settings for the frequency and difficulty at which this key triggers
     * captcha challenges. This should only be specified for IntegrationTypes
     * CHECKBOX_CHALLENGE and INVISIBLE_CHALLENGE.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.WebKeySettings.ChallengeSecurityPreference challenge_security_preference = 5;
     * </code>
     *
     * @param value The challengeSecurityPreference to set.
     * @return This builder for chaining.
     */
    public Builder setChallengeSecurityPreference(
        com.google.recaptchaenterprise.v1beta1.WebKeySettings.ChallengeSecurityPreference value) {
      if (value == null) {
        throw new NullPointerException();
      }

      challengeSecurityPreference_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for the frequency and difficulty at which this key triggers
     * captcha challenges. This should only be specified for IntegrationTypes
     * CHECKBOX_CHALLENGE and INVISIBLE_CHALLENGE.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.WebKeySettings.ChallengeSecurityPreference challenge_security_preference = 5;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearChallengeSecurityPreference() {

      challengeSecurityPreference_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.recaptchaenterprise.v1beta1.WebKeySettings)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.recaptchaenterprise.v1beta1.WebKeySettings)
  private static final com.google.recaptchaenterprise.v1beta1.WebKeySettings DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.recaptchaenterprise.v1beta1.WebKeySettings();
  }

  public static com.google.recaptchaenterprise.v1beta1.WebKeySettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WebKeySettings> PARSER =
      new com.google.protobuf.AbstractParser<WebKeySettings>() {
        @java.lang.Override
        public WebKeySettings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new WebKeySettings(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<WebKeySettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WebKeySettings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.WebKeySettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
