/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/recaptchaenterprise/v1beta1/recaptchaenterprise.proto

package com.google.recaptchaenterprise.v1beta1;

/**
 *
 *
 * <pre>
 * A recaptcha assessment resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.recaptchaenterprise.v1beta1.Assessment}
 */
public final class Assessment extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.recaptchaenterprise.v1beta1.Assessment)
    AssessmentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Assessment.newBuilder() to construct.
  private Assessment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Assessment() {
    name_ = "";
    reasons_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Assessment();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Assessment(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              com.google.recaptchaenterprise.v1beta1.Event.Builder subBuilder = null;
              if (event_ != null) {
                subBuilder = event_.toBuilder();
              }
              event_ =
                  input.readMessage(
                      com.google.recaptchaenterprise.v1beta1.Event.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(event_);
                event_ = subBuilder.buildPartial();
              }

              break;
            }
          case 29:
            {
              score_ = input.readFloat();
              break;
            }
          case 34:
            {
              com.google.recaptchaenterprise.v1beta1.TokenProperties.Builder subBuilder = null;
              if (tokenProperties_ != null) {
                subBuilder = tokenProperties_.toBuilder();
              }
              tokenProperties_ =
                  input.readMessage(
                      com.google.recaptchaenterprise.v1beta1.TokenProperties.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(tokenProperties_);
                tokenProperties_ = subBuilder.buildPartial();
              }

              break;
            }
          case 40:
            {
              int rawValue = input.readEnum();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                reasons_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000001;
              }
              reasons_.add(rawValue);
              break;
            }
          case 42:
            {
              int length = input.readRawVarint32();
              int oldLimit = input.pushLimit(length);
              while (input.getBytesUntilLimit() > 0) {
                int rawValue = input.readEnum();
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  reasons_ = new java.util.ArrayList<java.lang.Integer>();
                  mutable_bitField0_ |= 0x00000001;
                }
                reasons_.add(rawValue);
              }
              input.popLimit(oldLimit);
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        reasons_ = java.util.Collections.unmodifiableList(reasons_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1beta1_Assessment_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1beta1_Assessment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.recaptchaenterprise.v1beta1.Assessment.class,
            com.google.recaptchaenterprise.v1beta1.Assessment.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * LINT.IfChange(classification_reason)
   * Reasons contributing to the risk analysis verdict.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason}
   */
  public enum ClassificationReason implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default unspecified type.
     * </pre>
     *
     * <code>CLASSIFICATION_REASON_UNSPECIFIED = 0;</code>
     */
    CLASSIFICATION_REASON_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Interactions matched the behavior of an automated agent.
     * </pre>
     *
     * <code>AUTOMATION = 1;</code>
     */
    AUTOMATION(1),
    /**
     *
     *
     * <pre>
     * The event originated from an illegitimate environment.
     * </pre>
     *
     * <code>UNEXPECTED_ENVIRONMENT = 2;</code>
     */
    UNEXPECTED_ENVIRONMENT(2),
    /**
     *
     *
     * <pre>
     * Traffic volume from the event source is higher than normal.
     * </pre>
     *
     * <code>TOO_MUCH_TRAFFIC = 3;</code>
     */
    TOO_MUCH_TRAFFIC(3),
    /**
     *
     *
     * <pre>
     * Interactions with the site were significantly different than expected
     * patterns.
     * </pre>
     *
     * <code>UNEXPECTED_USAGE_PATTERNS = 4;</code>
     */
    UNEXPECTED_USAGE_PATTERNS(4),
    /**
     *
     *
     * <pre>
     * Too little traffic has been received from this site thus far to generate
     * quality risk analysis.
     * </pre>
     *
     * <code>LOW_CONFIDENCE_SCORE = 5;</code>
     */
    LOW_CONFIDENCE_SCORE(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default unspecified type.
     * </pre>
     *
     * <code>CLASSIFICATION_REASON_UNSPECIFIED = 0;</code>
     */
    public static final int CLASSIFICATION_REASON_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Interactions matched the behavior of an automated agent.
     * </pre>
     *
     * <code>AUTOMATION = 1;</code>
     */
    public static final int AUTOMATION_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The event originated from an illegitimate environment.
     * </pre>
     *
     * <code>UNEXPECTED_ENVIRONMENT = 2;</code>
     */
    public static final int UNEXPECTED_ENVIRONMENT_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Traffic volume from the event source is higher than normal.
     * </pre>
     *
     * <code>TOO_MUCH_TRAFFIC = 3;</code>
     */
    public static final int TOO_MUCH_TRAFFIC_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Interactions with the site were significantly different than expected
     * patterns.
     * </pre>
     *
     * <code>UNEXPECTED_USAGE_PATTERNS = 4;</code>
     */
    public static final int UNEXPECTED_USAGE_PATTERNS_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Too little traffic has been received from this site thus far to generate
     * quality risk analysis.
     * </pre>
     *
     * <code>LOW_CONFIDENCE_SCORE = 5;</code>
     */
    public static final int LOW_CONFIDENCE_SCORE_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ClassificationReason valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ClassificationReason forNumber(int value) {
      switch (value) {
        case 0:
          return CLASSIFICATION_REASON_UNSPECIFIED;
        case 1:
          return AUTOMATION;
        case 2:
          return UNEXPECTED_ENVIRONMENT;
        case 3:
          return TOO_MUCH_TRAFFIC;
        case 4:
          return UNEXPECTED_USAGE_PATTERNS;
        case 5:
          return LOW_CONFIDENCE_SCORE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ClassificationReason>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ClassificationReason>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ClassificationReason>() {
              public ClassificationReason findValueByNumber(int number) {
                return ClassificationReason.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1beta1.Assessment.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ClassificationReason[] VALUES = values();

    public static ClassificationReason valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ClassificationReason(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason)
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. The resource name for the Assessment in the format
   * "projects/{project_number}/assessments/{assessment_id}".
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name for the Assessment in the format
   * "projects/{project_number}/assessments/{assessment_id}".
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EVENT_FIELD_NUMBER = 2;
  private com.google.recaptchaenterprise.v1beta1.Event event_;
  /**
   *
   *
   * <pre>
   * The event being assessed.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.Event event = 2;</code>
   *
   * @return Whether the event field is set.
   */
  @java.lang.Override
  public boolean hasEvent() {
    return event_ != null;
  }
  /**
   *
   *
   * <pre>
   * The event being assessed.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.Event event = 2;</code>
   *
   * @return The event.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.Event getEvent() {
    return event_ == null
        ? com.google.recaptchaenterprise.v1beta1.Event.getDefaultInstance()
        : event_;
  }
  /**
   *
   *
   * <pre>
   * The event being assessed.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.Event event = 2;</code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.EventOrBuilder getEventOrBuilder() {
    return getEvent();
  }

  public static final int SCORE_FIELD_NUMBER = 3;
  private float score_;
  /**
   *
   *
   * <pre>
   * Output only. Legitimate event score from 0.0 to 1.0.
   * (1.0 means very likely legitimate traffic while 0.0 means very likely
   * non-legitimate traffic).
   * </pre>
   *
   * <code>float score = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The score.
   */
  @java.lang.Override
  public float getScore() {
    return score_;
  }

  public static final int TOKEN_PROPERTIES_FIELD_NUMBER = 4;
  private com.google.recaptchaenterprise.v1beta1.TokenProperties tokenProperties_;
  /**
   *
   *
   * <pre>
   * Output only. Properties of the provided event token.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the tokenProperties field is set.
   */
  @java.lang.Override
  public boolean hasTokenProperties() {
    return tokenProperties_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Properties of the provided event token.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The tokenProperties.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.TokenProperties getTokenProperties() {
    return tokenProperties_ == null
        ? com.google.recaptchaenterprise.v1beta1.TokenProperties.getDefaultInstance()
        : tokenProperties_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Properties of the provided event token.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.TokenPropertiesOrBuilder
      getTokenPropertiesOrBuilder() {
    return getTokenProperties();
  }

  public static final int REASONS_FIELD_NUMBER = 5;
  private java.util.List<java.lang.Integer> reasons_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason>
      reasons_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer,
              com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason>() {
            public com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason convert(
                java.lang.Integer from) {
              @SuppressWarnings("deprecation")
              com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason result =
                  com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason.valueOf(
                      from);
              return result == null
                  ? com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason
                      .UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Output only. Reasons contributing to the risk analysis verdict.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the reasons.
   */
  @java.lang.Override
  public java.util.List<com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason>
      getReasonsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason>(
        reasons_, reasons_converter_);
  }
  /**
   *
   *
   * <pre>
   * Output only. Reasons contributing to the risk analysis verdict.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of reasons.
   */
  @java.lang.Override
  public int getReasonsCount() {
    return reasons_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Reasons contributing to the risk analysis verdict.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The reasons at the given index.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason getReasons(
      int index) {
    return reasons_converter_.convert(reasons_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Output only. Reasons contributing to the risk analysis verdict.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for reasons.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getReasonsValueList() {
    return reasons_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Reasons contributing to the risk analysis verdict.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of reasons at the given index.
   */
  @java.lang.Override
  public int getReasonsValue(int index) {
    return reasons_.get(index);
  }

  private int reasonsMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (event_ != null) {
      output.writeMessage(2, getEvent());
    }
    if (score_ != 0F) {
      output.writeFloat(3, score_);
    }
    if (tokenProperties_ != null) {
      output.writeMessage(4, getTokenProperties());
    }
    if (getReasonsList().size() > 0) {
      output.writeUInt32NoTag(42);
      output.writeUInt32NoTag(reasonsMemoizedSerializedSize);
    }
    for (int i = 0; i < reasons_.size(); i++) {
      output.writeEnumNoTag(reasons_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (event_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEvent());
    }
    if (score_ != 0F) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(3, score_);
    }
    if (tokenProperties_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTokenProperties());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < reasons_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(reasons_.get(i));
      }
      size += dataSize;
      if (!getReasonsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      reasonsMemoizedSerializedSize = dataSize;
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.recaptchaenterprise.v1beta1.Assessment)) {
      return super.equals(obj);
    }
    com.google.recaptchaenterprise.v1beta1.Assessment other =
        (com.google.recaptchaenterprise.v1beta1.Assessment) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasEvent() != other.hasEvent()) return false;
    if (hasEvent()) {
      if (!getEvent().equals(other.getEvent())) return false;
    }
    if (java.lang.Float.floatToIntBits(getScore())
        != java.lang.Float.floatToIntBits(other.getScore())) return false;
    if (hasTokenProperties() != other.hasTokenProperties()) return false;
    if (hasTokenProperties()) {
      if (!getTokenProperties().equals(other.getTokenProperties())) return false;
    }
    if (!reasons_.equals(other.reasons_)) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasEvent()) {
      hash = (37 * hash) + EVENT_FIELD_NUMBER;
      hash = (53 * hash) + getEvent().hashCode();
    }
    hash = (37 * hash) + SCORE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getScore());
    if (hasTokenProperties()) {
      hash = (37 * hash) + TOKEN_PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + getTokenProperties().hashCode();
    }
    if (getReasonsCount() > 0) {
      hash = (37 * hash) + REASONS_FIELD_NUMBER;
      hash = (53 * hash) + reasons_.hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.recaptchaenterprise.v1beta1.Assessment parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1beta1.Assessment parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.Assessment parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1beta1.Assessment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.Assessment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1beta1.Assessment parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.Assessment parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1beta1.Assessment parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.Assessment parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1beta1.Assessment parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.Assessment parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1beta1.Assessment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.recaptchaenterprise.v1beta1.Assessment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A recaptcha assessment resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recaptchaenterprise.v1beta1.Assessment}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.recaptchaenterprise.v1beta1.Assessment)
      com.google.recaptchaenterprise.v1beta1.AssessmentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_Assessment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_Assessment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.recaptchaenterprise.v1beta1.Assessment.class,
              com.google.recaptchaenterprise.v1beta1.Assessment.Builder.class);
    }

    // Construct using com.google.recaptchaenterprise.v1beta1.Assessment.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (eventBuilder_ == null) {
        event_ = null;
      } else {
        event_ = null;
        eventBuilder_ = null;
      }
      score_ = 0F;

      if (tokenPropertiesBuilder_ == null) {
        tokenProperties_ = null;
      } else {
        tokenProperties_ = null;
        tokenPropertiesBuilder_ = null;
      }
      reasons_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_Assessment_descriptor;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.Assessment getDefaultInstanceForType() {
      return com.google.recaptchaenterprise.v1beta1.Assessment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.Assessment build() {
      com.google.recaptchaenterprise.v1beta1.Assessment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.Assessment buildPartial() {
      com.google.recaptchaenterprise.v1beta1.Assessment result =
          new com.google.recaptchaenterprise.v1beta1.Assessment(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      if (eventBuilder_ == null) {
        result.event_ = event_;
      } else {
        result.event_ = eventBuilder_.build();
      }
      result.score_ = score_;
      if (tokenPropertiesBuilder_ == null) {
        result.tokenProperties_ = tokenProperties_;
      } else {
        result.tokenProperties_ = tokenPropertiesBuilder_.build();
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        reasons_ = java.util.Collections.unmodifiableList(reasons_);
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.reasons_ = reasons_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.recaptchaenterprise.v1beta1.Assessment) {
        return mergeFrom((com.google.recaptchaenterprise.v1beta1.Assessment) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.recaptchaenterprise.v1beta1.Assessment other) {
      if (other == com.google.recaptchaenterprise.v1beta1.Assessment.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasEvent()) {
        mergeEvent(other.getEvent());
      }
      if (other.getScore() != 0F) {
        setScore(other.getScore());
      }
      if (other.hasTokenProperties()) {
        mergeTokenProperties(other.getTokenProperties());
      }
      if (!other.reasons_.isEmpty()) {
        if (reasons_.isEmpty()) {
          reasons_ = other.reasons_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureReasonsIsMutable();
          reasons_.addAll(other.reasons_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.recaptchaenterprise.v1beta1.Assessment parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.recaptchaenterprise.v1beta1.Assessment) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name for the Assessment in the format
     * "projects/{project_number}/assessments/{assessment_id}".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for the Assessment in the format
     * "projects/{project_number}/assessments/{assessment_id}".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for the Assessment in the format
     * "projects/{project_number}/assessments/{assessment_id}".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for the Assessment in the format
     * "projects/{project_number}/assessments/{assessment_id}".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for the Assessment in the format
     * "projects/{project_number}/assessments/{assessment_id}".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.recaptchaenterprise.v1beta1.Event event_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.Event,
            com.google.recaptchaenterprise.v1beta1.Event.Builder,
            com.google.recaptchaenterprise.v1beta1.EventOrBuilder>
        eventBuilder_;
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.Event event = 2;</code>
     *
     * @return Whether the event field is set.
     */
    public boolean hasEvent() {
      return eventBuilder_ != null || event_ != null;
    }
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.Event event = 2;</code>
     *
     * @return The event.
     */
    public com.google.recaptchaenterprise.v1beta1.Event getEvent() {
      if (eventBuilder_ == null) {
        return event_ == null
            ? com.google.recaptchaenterprise.v1beta1.Event.getDefaultInstance()
            : event_;
      } else {
        return eventBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.Event event = 2;</code>
     */
    public Builder setEvent(com.google.recaptchaenterprise.v1beta1.Event value) {
      if (eventBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        event_ = value;
        onChanged();
      } else {
        eventBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.Event event = 2;</code>
     */
    public Builder setEvent(com.google.recaptchaenterprise.v1beta1.Event.Builder builderForValue) {
      if (eventBuilder_ == null) {
        event_ = builderForValue.build();
        onChanged();
      } else {
        eventBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.Event event = 2;</code>
     */
    public Builder mergeEvent(com.google.recaptchaenterprise.v1beta1.Event value) {
      if (eventBuilder_ == null) {
        if (event_ != null) {
          event_ =
              com.google.recaptchaenterprise.v1beta1.Event.newBuilder(event_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          event_ = value;
        }
        onChanged();
      } else {
        eventBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.Event event = 2;</code>
     */
    public Builder clearEvent() {
      if (eventBuilder_ == null) {
        event_ = null;
        onChanged();
      } else {
        event_ = null;
        eventBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.Event event = 2;</code>
     */
    public com.google.recaptchaenterprise.v1beta1.Event.Builder getEventBuilder() {

      onChanged();
      return getEventFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.Event event = 2;</code>
     */
    public com.google.recaptchaenterprise.v1beta1.EventOrBuilder getEventOrBuilder() {
      if (eventBuilder_ != null) {
        return eventBuilder_.getMessageOrBuilder();
      } else {
        return event_ == null
            ? com.google.recaptchaenterprise.v1beta1.Event.getDefaultInstance()
            : event_;
      }
    }
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.Event event = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.Event,
            com.google.recaptchaenterprise.v1beta1.Event.Builder,
            com.google.recaptchaenterprise.v1beta1.EventOrBuilder>
        getEventFieldBuilder() {
      if (eventBuilder_ == null) {
        eventBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1beta1.Event,
                com.google.recaptchaenterprise.v1beta1.Event.Builder,
                com.google.recaptchaenterprise.v1beta1.EventOrBuilder>(
                getEvent(), getParentForChildren(), isClean());
        event_ = null;
      }
      return eventBuilder_;
    }

    private float score_;
    /**
     *
     *
     * <pre>
     * Output only. Legitimate event score from 0.0 to 1.0.
     * (1.0 means very likely legitimate traffic while 0.0 means very likely
     * non-legitimate traffic).
     * </pre>
     *
     * <code>float score = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The score.
     */
    @java.lang.Override
    public float getScore() {
      return score_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Legitimate event score from 0.0 to 1.0.
     * (1.0 means very likely legitimate traffic while 0.0 means very likely
     * non-legitimate traffic).
     * </pre>
     *
     * <code>float score = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The score to set.
     * @return This builder for chaining.
     */
    public Builder setScore(float value) {

      score_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Legitimate event score from 0.0 to 1.0.
     * (1.0 means very likely legitimate traffic while 0.0 means very likely
     * non-legitimate traffic).
     * </pre>
     *
     * <code>float score = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearScore() {

      score_ = 0F;
      onChanged();
      return this;
    }

    private com.google.recaptchaenterprise.v1beta1.TokenProperties tokenProperties_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.TokenProperties,
            com.google.recaptchaenterprise.v1beta1.TokenProperties.Builder,
            com.google.recaptchaenterprise.v1beta1.TokenPropertiesOrBuilder>
        tokenPropertiesBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the tokenProperties field is set.
     */
    public boolean hasTokenProperties() {
      return tokenPropertiesBuilder_ != null || tokenProperties_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The tokenProperties.
     */
    public com.google.recaptchaenterprise.v1beta1.TokenProperties getTokenProperties() {
      if (tokenPropertiesBuilder_ == null) {
        return tokenProperties_ == null
            ? com.google.recaptchaenterprise.v1beta1.TokenProperties.getDefaultInstance()
            : tokenProperties_;
      } else {
        return tokenPropertiesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTokenProperties(
        com.google.recaptchaenterprise.v1beta1.TokenProperties value) {
      if (tokenPropertiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tokenProperties_ = value;
        onChanged();
      } else {
        tokenPropertiesBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTokenProperties(
        com.google.recaptchaenterprise.v1beta1.TokenProperties.Builder builderForValue) {
      if (tokenPropertiesBuilder_ == null) {
        tokenProperties_ = builderForValue.build();
        onChanged();
      } else {
        tokenPropertiesBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeTokenProperties(
        com.google.recaptchaenterprise.v1beta1.TokenProperties value) {
      if (tokenPropertiesBuilder_ == null) {
        if (tokenProperties_ != null) {
          tokenProperties_ =
              com.google.recaptchaenterprise.v1beta1.TokenProperties.newBuilder(tokenProperties_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          tokenProperties_ = value;
        }
        onChanged();
      } else {
        tokenPropertiesBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTokenProperties() {
      if (tokenPropertiesBuilder_ == null) {
        tokenProperties_ = null;
        onChanged();
      } else {
        tokenProperties_ = null;
        tokenPropertiesBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.TokenProperties.Builder
        getTokenPropertiesBuilder() {

      onChanged();
      return getTokenPropertiesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.TokenPropertiesOrBuilder
        getTokenPropertiesOrBuilder() {
      if (tokenPropertiesBuilder_ != null) {
        return tokenPropertiesBuilder_.getMessageOrBuilder();
      } else {
        return tokenProperties_ == null
            ? com.google.recaptchaenterprise.v1beta1.TokenProperties.getDefaultInstance()
            : tokenProperties_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.TokenProperties,
            com.google.recaptchaenterprise.v1beta1.TokenProperties.Builder,
            com.google.recaptchaenterprise.v1beta1.TokenPropertiesOrBuilder>
        getTokenPropertiesFieldBuilder() {
      if (tokenPropertiesBuilder_ == null) {
        tokenPropertiesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1beta1.TokenProperties,
                com.google.recaptchaenterprise.v1beta1.TokenProperties.Builder,
                com.google.recaptchaenterprise.v1beta1.TokenPropertiesOrBuilder>(
                getTokenProperties(), getParentForChildren(), isClean());
        tokenProperties_ = null;
      }
      return tokenPropertiesBuilder_;
    }

    private java.util.List<java.lang.Integer> reasons_ = java.util.Collections.emptyList();

    private void ensureReasonsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        reasons_ = new java.util.ArrayList<java.lang.Integer>(reasons_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Reasons contributing to the risk analysis verdict.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the reasons.
     */
    public java.util.List<com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason>
        getReasonsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer,
          com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason>(
          reasons_, reasons_converter_);
    }
    /**
     *
     *
     * <pre>
     * Output only. Reasons contributing to the risk analysis verdict.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of reasons.
     */
    public int getReasonsCount() {
      return reasons_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Reasons contributing to the risk analysis verdict.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The reasons at the given index.
     */
    public com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason getReasons(
        int index) {
      return reasons_converter_.convert(reasons_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Output only. Reasons contributing to the risk analysis verdict.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The reasons to set.
     * @return This builder for chaining.
     */
    public Builder setReasons(
        int index, com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReasonsIsMutable();
      reasons_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reasons contributing to the risk analysis verdict.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The reasons to add.
     * @return This builder for chaining.
     */
    public Builder addReasons(
        com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReasonsIsMutable();
      reasons_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reasons contributing to the risk analysis verdict.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The reasons to add.
     * @return This builder for chaining.
     */
    public Builder addAllReasons(
        java.lang.Iterable<
                ? extends com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason>
            values) {
      ensureReasonsIsMutable();
      for (com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason value : values) {
        reasons_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reasons contributing to the risk analysis verdict.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReasons() {
      reasons_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reasons contributing to the risk analysis verdict.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for reasons.
     */
    public java.util.List<java.lang.Integer> getReasonsValueList() {
      return java.util.Collections.unmodifiableList(reasons_);
    }
    /**
     *
     *
     * <pre>
     * Output only. Reasons contributing to the risk analysis verdict.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of reasons at the given index.
     */
    public int getReasonsValue(int index) {
      return reasons_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Reasons contributing to the risk analysis verdict.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of reasons at the given index.
     * @return This builder for chaining.
     */
    public Builder setReasonsValue(int index, int value) {
      ensureReasonsIsMutable();
      reasons_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reasons contributing to the risk analysis verdict.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for reasons to add.
     * @return This builder for chaining.
     */
    public Builder addReasonsValue(int value) {
      ensureReasonsIsMutable();
      reasons_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reasons contributing to the risk analysis verdict.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The enum numeric values on the wire for reasons to add.
     * @return This builder for chaining.
     */
    public Builder addAllReasonsValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureReasonsIsMutable();
      for (int value : values) {
        reasons_.add(value);
      }
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.recaptchaenterprise.v1beta1.Assessment)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.recaptchaenterprise.v1beta1.Assessment)
  private static final com.google.recaptchaenterprise.v1beta1.Assessment DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.recaptchaenterprise.v1beta1.Assessment();
  }

  public static com.google.recaptchaenterprise.v1beta1.Assessment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Assessment> PARSER =
      new com.google.protobuf.AbstractParser<Assessment>() {
        @java.lang.Override
        public Assessment parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Assessment(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Assessment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Assessment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.Assessment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
