/*
 * Decompiled with CFR 0.152.
 */
package com.google.recaptchaenterprise.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class KeyName
implements ResourceName {
    private static final PathTemplate PROJECT_KEY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/keys/{key}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String key;

    @Deprecated
    protected KeyName() {
        this.project = null;
        this.key = null;
    }

    private KeyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.key = (String)Preconditions.checkNotNull((Object)builder.getKey());
    }

    public String getProject() {
        return this.project;
    }

    public String getKey() {
        return this.key;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static KeyName of(String project, String key) {
        return KeyName.newBuilder().setProject(project).setKey(key).build();
    }

    public static String format(String project, String key) {
        return KeyName.newBuilder().setProject(project).setKey(key).build().toString();
    }

    public static KeyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_KEY.validatedMatch(formattedString, "KeyName.parse: formattedString not in valid format");
        return KeyName.of((String)matchMap.get("project"), (String)matchMap.get("key"));
    }

    public static List<KeyName> parseList(List<String> formattedStrings) {
        ArrayList<KeyName> list = new ArrayList<KeyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(KeyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<KeyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (KeyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_KEY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            KeyName keyName = this;
            synchronized (keyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.key != null) {
                        fieldMapBuilder.put((Object)"key", (Object)this.key);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_KEY.instantiate(new String[]{"project", this.project, "key", this.key});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            KeyName that = (KeyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.key, that.key);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.key);
    }

    public static class Builder {
        private String project;
        private String key;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getKey() {
            return this.key;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        private Builder(KeyName keyName) {
            this.project = keyName.project;
            this.key = keyName.key;
        }

        public KeyName build() {
            return new KeyName(this);
        }
    }
}

