/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/recaptchaenterprise/v1beta1/recaptchaenterprise.proto

package com.google.recaptchaenterprise.v1beta1;

/**
 *
 *
 * <pre>
 * The request message to annotate an Assessment.
 * </pre>
 *
 * Protobuf type {@code google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest}
 */
public final class AnnotateAssessmentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest)
    AnnotateAssessmentRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AnnotateAssessmentRequest.newBuilder() to construct.
  private AnnotateAssessmentRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AnnotateAssessmentRequest() {
    name_ = "";
    annotation_ = 0;
    reasons_ = java.util.Collections.emptyList();
    hashedAccountId_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AnnotateAssessmentRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1beta1_AnnotateAssessmentRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1beta1_AnnotateAssessmentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.class,
            com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Enum that represents the types of annotations.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Annotation}
   */
  public enum Annotation implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default unspecified type.
     * </pre>
     *
     * <code>ANNOTATION_UNSPECIFIED = 0;</code>
     */
    ANNOTATION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Provides information that the event turned out to be legitimate.
     * </pre>
     *
     * <code>LEGITIMATE = 1;</code>
     */
    LEGITIMATE(1),
    /**
     *
     *
     * <pre>
     * Provides information that the event turned out to be fraudulent.
     * </pre>
     *
     * <code>FRAUDULENT = 2;</code>
     */
    FRAUDULENT(2),
    /**
     *
     *
     * <pre>
     * Provides information that the event was related to a login event in which
     * the user typed the correct password. Deprecated, prefer indicating
     * CORRECT_PASSWORD through the reasons field instead.
     * </pre>
     *
     * <code>PASSWORD_CORRECT = 3 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    PASSWORD_CORRECT(3),
    /**
     *
     *
     * <pre>
     * Provides information that the event was related to a login event in which
     * the user typed the incorrect password. Deprecated, prefer indicating
     * INCORRECT_PASSWORD through the reasons field instead.
     * </pre>
     *
     * <code>PASSWORD_INCORRECT = 4 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    PASSWORD_INCORRECT(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default unspecified type.
     * </pre>
     *
     * <code>ANNOTATION_UNSPECIFIED = 0;</code>
     */
    public static final int ANNOTATION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Provides information that the event turned out to be legitimate.
     * </pre>
     *
     * <code>LEGITIMATE = 1;</code>
     */
    public static final int LEGITIMATE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Provides information that the event turned out to be fraudulent.
     * </pre>
     *
     * <code>FRAUDULENT = 2;</code>
     */
    public static final int FRAUDULENT_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Provides information that the event was related to a login event in which
     * the user typed the correct password. Deprecated, prefer indicating
     * CORRECT_PASSWORD through the reasons field instead.
     * </pre>
     *
     * <code>PASSWORD_CORRECT = 3 [deprecated = true];</code>
     */
    @java.lang.Deprecated public static final int PASSWORD_CORRECT_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Provides information that the event was related to a login event in which
     * the user typed the incorrect password. Deprecated, prefer indicating
     * INCORRECT_PASSWORD through the reasons field instead.
     * </pre>
     *
     * <code>PASSWORD_INCORRECT = 4 [deprecated = true];</code>
     */
    @java.lang.Deprecated public static final int PASSWORD_INCORRECT_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Annotation valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Annotation forNumber(int value) {
      switch (value) {
        case 0:
          return ANNOTATION_UNSPECIFIED;
        case 1:
          return LEGITIMATE;
        case 2:
          return FRAUDULENT;
        case 3:
          return PASSWORD_CORRECT;
        case 4:
          return PASSWORD_INCORRECT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Annotation> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Annotation> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Annotation>() {
          public Annotation findValueByNumber(int number) {
            return Annotation.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Annotation[] VALUES = values();

    public static Annotation valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Annotation(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Annotation)
  }

  /**
   *
   *
   * <pre>
   * Enum that represents potential reasons for annotating an assessment.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason}
   */
  public enum Reason implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default unspecified reason.
     * </pre>
     *
     * <code>REASON_UNSPECIFIED = 0;</code>
     */
    REASON_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Indicates that the transaction had a chargeback issued with no other
     * details. When possible, specify the type by using CHARGEBACK_FRAUD or
     * CHARGEBACK_DISPUTE instead.
     * </pre>
     *
     * <code>CHARGEBACK = 1;</code>
     */
    CHARGEBACK(1),
    /**
     *
     *
     * <pre>
     * Indicates that the transaction had a chargeback issued related to an
     * alleged unauthorized transaction from the cardholder's perspective (for
     * example, the card number was stolen).
     * </pre>
     *
     * <code>CHARGEBACK_FRAUD = 8;</code>
     */
    CHARGEBACK_FRAUD(8),
    /**
     *
     *
     * <pre>
     * Indicates that the transaction had a chargeback issued related to the
     * cardholder having provided their card details but allegedly not being
     * satisfied with the purchase (for example, misrepresentation, attempted
     * cancellation).
     * </pre>
     *
     * <code>CHARGEBACK_DISPUTE = 9;</code>
     */
    CHARGEBACK_DISPUTE(9),
    /**
     *
     *
     * <pre>
     * Indicates that the completed payment transaction was refunded by the
     * seller.
     * </pre>
     *
     * <code>REFUND = 10;</code>
     */
    REFUND(10),
    /**
     *
     *
     * <pre>
     * Indicates that the completed payment transaction was determined to be
     * fraudulent by the seller, and was cancelled and refunded as a result.
     * </pre>
     *
     * <code>REFUND_FRAUD = 11;</code>
     */
    REFUND_FRAUD(11),
    /**
     *
     *
     * <pre>
     * Indicates that the payment transaction was accepted, and the user was
     * charged.
     * </pre>
     *
     * <code>TRANSACTION_ACCEPTED = 12;</code>
     */
    TRANSACTION_ACCEPTED(12),
    /**
     *
     *
     * <pre>
     * Indicates that the payment transaction was declined, for example due to
     * invalid card details.
     * </pre>
     *
     * <code>TRANSACTION_DECLINED = 13;</code>
     */
    TRANSACTION_DECLINED(13),
    /**
     *
     *
     * <pre>
     * Indicates the transaction associated with the assessment is suspected of
     * being fraudulent based on the payment method, billing details, shipping
     * address or other transaction information.
     * </pre>
     *
     * <code>PAYMENT_HEURISTICS = 2;</code>
     */
    PAYMENT_HEURISTICS(2),
    /**
     *
     *
     * <pre>
     * Indicates that the user was served a 2FA challenge. An old assessment
     * with `ENUM_VALUES.INITIATED_TWO_FACTOR` reason that has not been
     * overwritten with `PASSED_TWO_FACTOR` is treated as an abandoned 2FA flow.
     * This is equivalent to `FAILED_TWO_FACTOR`.
     * </pre>
     *
     * <code>INITIATED_TWO_FACTOR = 7;</code>
     */
    INITIATED_TWO_FACTOR(7),
    /**
     *
     *
     * <pre>
     * Indicates that the user passed a 2FA challenge.
     * </pre>
     *
     * <code>PASSED_TWO_FACTOR = 3;</code>
     */
    PASSED_TWO_FACTOR(3),
    /**
     *
     *
     * <pre>
     * Indicates that the user failed a 2FA challenge.
     * </pre>
     *
     * <code>FAILED_TWO_FACTOR = 4;</code>
     */
    FAILED_TWO_FACTOR(4),
    /**
     *
     *
     * <pre>
     * Indicates the user provided the correct password.
     * </pre>
     *
     * <code>CORRECT_PASSWORD = 5;</code>
     */
    CORRECT_PASSWORD(5),
    /**
     *
     *
     * <pre>
     * Indicates the user provided an incorrect password.
     * </pre>
     *
     * <code>INCORRECT_PASSWORD = 6;</code>
     */
    INCORRECT_PASSWORD(6),
    /**
     *
     *
     * <pre>
     * Indicates that the user sent unwanted and abusive messages to other users
     * of the platform, such as spam, scams, phishing, or social engineering.
     * </pre>
     *
     * <code>SOCIAL_SPAM = 14;</code>
     */
    SOCIAL_SPAM(14),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default unspecified reason.
     * </pre>
     *
     * <code>REASON_UNSPECIFIED = 0;</code>
     */
    public static final int REASON_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Indicates that the transaction had a chargeback issued with no other
     * details. When possible, specify the type by using CHARGEBACK_FRAUD or
     * CHARGEBACK_DISPUTE instead.
     * </pre>
     *
     * <code>CHARGEBACK = 1;</code>
     */
    public static final int CHARGEBACK_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Indicates that the transaction had a chargeback issued related to an
     * alleged unauthorized transaction from the cardholder's perspective (for
     * example, the card number was stolen).
     * </pre>
     *
     * <code>CHARGEBACK_FRAUD = 8;</code>
     */
    public static final int CHARGEBACK_FRAUD_VALUE = 8;
    /**
     *
     *
     * <pre>
     * Indicates that the transaction had a chargeback issued related to the
     * cardholder having provided their card details but allegedly not being
     * satisfied with the purchase (for example, misrepresentation, attempted
     * cancellation).
     * </pre>
     *
     * <code>CHARGEBACK_DISPUTE = 9;</code>
     */
    public static final int CHARGEBACK_DISPUTE_VALUE = 9;
    /**
     *
     *
     * <pre>
     * Indicates that the completed payment transaction was refunded by the
     * seller.
     * </pre>
     *
     * <code>REFUND = 10;</code>
     */
    public static final int REFUND_VALUE = 10;
    /**
     *
     *
     * <pre>
     * Indicates that the completed payment transaction was determined to be
     * fraudulent by the seller, and was cancelled and refunded as a result.
     * </pre>
     *
     * <code>REFUND_FRAUD = 11;</code>
     */
    public static final int REFUND_FRAUD_VALUE = 11;
    /**
     *
     *
     * <pre>
     * Indicates that the payment transaction was accepted, and the user was
     * charged.
     * </pre>
     *
     * <code>TRANSACTION_ACCEPTED = 12;</code>
     */
    public static final int TRANSACTION_ACCEPTED_VALUE = 12;
    /**
     *
     *
     * <pre>
     * Indicates that the payment transaction was declined, for example due to
     * invalid card details.
     * </pre>
     *
     * <code>TRANSACTION_DECLINED = 13;</code>
     */
    public static final int TRANSACTION_DECLINED_VALUE = 13;
    /**
     *
     *
     * <pre>
     * Indicates the transaction associated with the assessment is suspected of
     * being fraudulent based on the payment method, billing details, shipping
     * address or other transaction information.
     * </pre>
     *
     * <code>PAYMENT_HEURISTICS = 2;</code>
     */
    public static final int PAYMENT_HEURISTICS_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Indicates that the user was served a 2FA challenge. An old assessment
     * with `ENUM_VALUES.INITIATED_TWO_FACTOR` reason that has not been
     * overwritten with `PASSED_TWO_FACTOR` is treated as an abandoned 2FA flow.
     * This is equivalent to `FAILED_TWO_FACTOR`.
     * </pre>
     *
     * <code>INITIATED_TWO_FACTOR = 7;</code>
     */
    public static final int INITIATED_TWO_FACTOR_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Indicates that the user passed a 2FA challenge.
     * </pre>
     *
     * <code>PASSED_TWO_FACTOR = 3;</code>
     */
    public static final int PASSED_TWO_FACTOR_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Indicates that the user failed a 2FA challenge.
     * </pre>
     *
     * <code>FAILED_TWO_FACTOR = 4;</code>
     */
    public static final int FAILED_TWO_FACTOR_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Indicates the user provided the correct password.
     * </pre>
     *
     * <code>CORRECT_PASSWORD = 5;</code>
     */
    public static final int CORRECT_PASSWORD_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Indicates the user provided an incorrect password.
     * </pre>
     *
     * <code>INCORRECT_PASSWORD = 6;</code>
     */
    public static final int INCORRECT_PASSWORD_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Indicates that the user sent unwanted and abusive messages to other users
     * of the platform, such as spam, scams, phishing, or social engineering.
     * </pre>
     *
     * <code>SOCIAL_SPAM = 14;</code>
     */
    public static final int SOCIAL_SPAM_VALUE = 14;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Reason valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Reason forNumber(int value) {
      switch (value) {
        case 0:
          return REASON_UNSPECIFIED;
        case 1:
          return CHARGEBACK;
        case 8:
          return CHARGEBACK_FRAUD;
        case 9:
          return CHARGEBACK_DISPUTE;
        case 10:
          return REFUND;
        case 11:
          return REFUND_FRAUD;
        case 12:
          return TRANSACTION_ACCEPTED;
        case 13:
          return TRANSACTION_DECLINED;
        case 2:
          return PAYMENT_HEURISTICS;
        case 7:
          return INITIATED_TWO_FACTOR;
        case 3:
          return PASSED_TWO_FACTOR;
        case 4:
          return FAILED_TWO_FACTOR;
        case 5:
          return CORRECT_PASSWORD;
        case 6:
          return INCORRECT_PASSWORD;
        case 14:
          return SOCIAL_SPAM;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Reason> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Reason> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Reason>() {
          public Reason findValueByNumber(int number) {
            return Reason.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final Reason[] VALUES = values();

    public static Reason valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Reason(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Assessment, in the format
   * `projects/{project_number}/assessments/{assessment_id}`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Assessment, in the format
   * `projects/{project_number}/assessments/{assessment_id}`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANNOTATION_FIELD_NUMBER = 2;
  private int annotation_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The annotation that will be assigned to the Event. This field can
   * be left empty to provide reasons that apply to an event without concluding
   * whether the event is legitimate or fraudulent.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Annotation annotation = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for annotation.
   */
  @java.lang.Override
  public int getAnnotationValue() {
    return annotation_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The annotation that will be assigned to the Event. This field can
   * be left empty to provide reasons that apply to an event without concluding
   * whether the event is legitimate or fraudulent.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Annotation annotation = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The annotation.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Annotation
      getAnnotation() {
    com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Annotation result =
        com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Annotation.forNumber(
            annotation_);
    return result == null
        ? com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Annotation.UNRECOGNIZED
        : result;
  }

  public static final int REASONS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> reasons_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer,
          com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason>
      reasons_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer,
              com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason>() {
            public com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason convert(
                java.lang.Integer from) {
              com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason result =
                  com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason.forNumber(
                      from);
              return result == null
                  ? com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason
                      .UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Optional. Optional reasons for the annotation that will be assigned to the
   * Event.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason reasons = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the reasons.
   */
  @java.lang.Override
  public java.util.List<com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason>
      getReasonsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason>(
        reasons_, reasons_converter_);
  }
  /**
   *
   *
   * <pre>
   * Optional. Optional reasons for the annotation that will be assigned to the
   * Event.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason reasons = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of reasons.
   */
  @java.lang.Override
  public int getReasonsCount() {
    return reasons_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Optional reasons for the annotation that will be assigned to the
   * Event.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason reasons = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The reasons at the given index.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason getReasons(
      int index) {
    return reasons_converter_.convert(reasons_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Optional. Optional reasons for the annotation that will be assigned to the
   * Event.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason reasons = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for reasons.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getReasonsValueList() {
    return reasons_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Optional reasons for the annotation that will be assigned to the
   * Event.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason reasons = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of reasons at the given index.
   */
  @java.lang.Override
  public int getReasonsValue(int index) {
    return reasons_.get(index);
  }

  private int reasonsMemoizedSerializedSize;

  public static final int HASHED_ACCOUNT_ID_FIELD_NUMBER = 4;
  private com.google.protobuf.ByteString hashedAccountId_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * Optional. Optional unique stable hashed user identifier to apply to the
   * assessment. This is an alternative to setting the hashed_account_id in
   * CreateAssessment, for example when the account identifier is not yet known
   * in the initial request. It is recommended that the identifier is hashed
   * using hmac-sha256 with stable secret.
   * </pre>
   *
   * <code>bytes hashed_account_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The hashedAccountId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHashedAccountId() {
    return hashedAccountId_;
  }

  public static final int TRANSACTION_EVENT_FIELD_NUMBER = 5;
  private com.google.recaptchaenterprise.v1beta1.TransactionEvent transactionEvent_;
  /**
   *
   *
   * <pre>
   * Optional. If the assessment is part of a payment transaction, provide
   * details on payment lifecycle events that occur in the transaction.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.TransactionEvent transaction_event = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the transactionEvent field is set.
   */
  @java.lang.Override
  public boolean hasTransactionEvent() {
    return transactionEvent_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. If the assessment is part of a payment transaction, provide
   * details on payment lifecycle events that occur in the transaction.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.TransactionEvent transaction_event = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The transactionEvent.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.TransactionEvent getTransactionEvent() {
    return transactionEvent_ == null
        ? com.google.recaptchaenterprise.v1beta1.TransactionEvent.getDefaultInstance()
        : transactionEvent_;
  }
  /**
   *
   *
   * <pre>
   * Optional. If the assessment is part of a payment transaction, provide
   * details on payment lifecycle events that occur in the transaction.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.TransactionEvent transaction_event = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.TransactionEventOrBuilder
      getTransactionEventOrBuilder() {
    return transactionEvent_ == null
        ? com.google.recaptchaenterprise.v1beta1.TransactionEvent.getDefaultInstance()
        : transactionEvent_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (annotation_
        != com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Annotation
            .ANNOTATION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, annotation_);
    }
    if (getReasonsList().size() > 0) {
      output.writeUInt32NoTag(26);
      output.writeUInt32NoTag(reasonsMemoizedSerializedSize);
    }
    for (int i = 0; i < reasons_.size(); i++) {
      output.writeEnumNoTag(reasons_.get(i));
    }
    if (!hashedAccountId_.isEmpty()) {
      output.writeBytes(4, hashedAccountId_);
    }
    if (transactionEvent_ != null) {
      output.writeMessage(5, getTransactionEvent());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (annotation_
        != com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Annotation
            .ANNOTATION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, annotation_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < reasons_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(reasons_.get(i));
      }
      size += dataSize;
      if (!getReasonsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      reasonsMemoizedSerializedSize = dataSize;
    }
    if (!hashedAccountId_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(4, hashedAccountId_);
    }
    if (transactionEvent_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getTransactionEvent());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest)) {
      return super.equals(obj);
    }
    com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest other =
        (com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (annotation_ != other.annotation_) return false;
    if (!reasons_.equals(other.reasons_)) return false;
    if (!getHashedAccountId().equals(other.getHashedAccountId())) return false;
    if (hasTransactionEvent() != other.hasTransactionEvent()) return false;
    if (hasTransactionEvent()) {
      if (!getTransactionEvent().equals(other.getTransactionEvent())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + ANNOTATION_FIELD_NUMBER;
    hash = (53 * hash) + annotation_;
    if (getReasonsCount() > 0) {
      hash = (37 * hash) + REASONS_FIELD_NUMBER;
      hash = (53 * hash) + reasons_.hashCode();
    }
    hash = (37 * hash) + HASHED_ACCOUNT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getHashedAccountId().hashCode();
    if (hasTransactionEvent()) {
      hash = (37 * hash) + TRANSACTION_EVENT_FIELD_NUMBER;
      hash = (53 * hash) + getTransactionEvent().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request message to annotate an Assessment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest)
      com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_AnnotateAssessmentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_AnnotateAssessmentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.class,
              com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Builder.class);
    }

    // Construct using com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      annotation_ = 0;
      reasons_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      hashedAccountId_ = com.google.protobuf.ByteString.EMPTY;
      transactionEvent_ = null;
      if (transactionEventBuilder_ != null) {
        transactionEventBuilder_.dispose();
        transactionEventBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_AnnotateAssessmentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest
        getDefaultInstanceForType() {
      return com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest build() {
      com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest buildPartial() {
      com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest result =
          new com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest result) {
      if (((bitField0_ & 0x00000004) != 0)) {
        reasons_ = java.util.Collections.unmodifiableList(reasons_);
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.reasons_ = reasons_;
    }

    private void buildPartial0(
        com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.annotation_ = annotation_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.hashedAccountId_ = hashedAccountId_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.transactionEvent_ =
            transactionEventBuilder_ == null ? transactionEvent_ : transactionEventBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest) {
        return mergeFrom((com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest other) {
      if (other
          == com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.annotation_ != 0) {
        setAnnotationValue(other.getAnnotationValue());
      }
      if (!other.reasons_.isEmpty()) {
        if (reasons_.isEmpty()) {
          reasons_ = other.reasons_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureReasonsIsMutable();
          reasons_.addAll(other.reasons_);
        }
        onChanged();
      }
      if (other.getHashedAccountId() != com.google.protobuf.ByteString.EMPTY) {
        setHashedAccountId(other.getHashedAccountId());
      }
      if (other.hasTransactionEvent()) {
        mergeTransactionEvent(other.getTransactionEvent());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                annotation_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                int tmpRaw = input.readEnum();
                ensureReasonsIsMutable();
                reasons_.add(tmpRaw);
                break;
              } // case 24
            case 26:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureReasonsIsMutable();
                  reasons_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 26
            case 34:
              {
                hashedAccountId_ = input.readBytes();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getTransactionEventFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Assessment, in the format
     * `projects/{project_number}/assessments/{assessment_id}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Assessment, in the format
     * `projects/{project_number}/assessments/{assessment_id}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Assessment, in the format
     * `projects/{project_number}/assessments/{assessment_id}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Assessment, in the format
     * `projects/{project_number}/assessments/{assessment_id}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Assessment, in the format
     * `projects/{project_number}/assessments/{assessment_id}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int annotation_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The annotation that will be assigned to the Event. This field can
     * be left empty to provide reasons that apply to an event without concluding
     * whether the event is legitimate or fraudulent.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Annotation annotation = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for annotation.
     */
    @java.lang.Override
    public int getAnnotationValue() {
      return annotation_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The annotation that will be assigned to the Event. This field can
     * be left empty to provide reasons that apply to an event without concluding
     * whether the event is legitimate or fraudulent.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Annotation annotation = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for annotation to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationValue(int value) {
      annotation_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The annotation that will be assigned to the Event. This field can
     * be left empty to provide reasons that apply to an event without concluding
     * whether the event is legitimate or fraudulent.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Annotation annotation = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The annotation.
     */
    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Annotation
        getAnnotation() {
      com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Annotation result =
          com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Annotation.forNumber(
              annotation_);
      return result == null
          ? com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Annotation.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The annotation that will be assigned to the Event. This field can
     * be left empty to provide reasons that apply to an event without concluding
     * whether the event is legitimate or fraudulent.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Annotation annotation = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The annotation to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotation(
        com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Annotation value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      annotation_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The annotation that will be assigned to the Event. This field can
     * be left empty to provide reasons that apply to an event without concluding
     * whether the event is legitimate or fraudulent.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Annotation annotation = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnnotation() {
      bitField0_ = (bitField0_ & ~0x00000002);
      annotation_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> reasons_ = java.util.Collections.emptyList();

    private void ensureReasonsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        reasons_ = new java.util.ArrayList<java.lang.Integer>(reasons_);
        bitField0_ |= 0x00000004;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional reasons for the annotation that will be assigned to the
     * Event.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason reasons = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the reasons.
     */
    public java.util.List<com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason>
        getReasonsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer,
          com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason>(
          reasons_, reasons_converter_);
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional reasons for the annotation that will be assigned to the
     * Event.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason reasons = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of reasons.
     */
    public int getReasonsCount() {
      return reasons_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional reasons for the annotation that will be assigned to the
     * Event.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason reasons = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The reasons at the given index.
     */
    public com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason getReasons(
        int index) {
      return reasons_converter_.convert(reasons_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional reasons for the annotation that will be assigned to the
     * Event.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason reasons = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The reasons to set.
     * @return This builder for chaining.
     */
    public Builder setReasons(
        int index, com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReasonsIsMutable();
      reasons_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional reasons for the annotation that will be assigned to the
     * Event.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason reasons = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The reasons to add.
     * @return This builder for chaining.
     */
    public Builder addReasons(
        com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReasonsIsMutable();
      reasons_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional reasons for the annotation that will be assigned to the
     * Event.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason reasons = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The reasons to add.
     * @return This builder for chaining.
     */
    public Builder addAllReasons(
        java.lang.Iterable<
                ? extends com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason>
            values) {
      ensureReasonsIsMutable();
      for (com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason value : values) {
        reasons_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional reasons for the annotation that will be assigned to the
     * Event.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason reasons = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReasons() {
      reasons_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional reasons for the annotation that will be assigned to the
     * Event.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason reasons = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for reasons.
     */
    public java.util.List<java.lang.Integer> getReasonsValueList() {
      return java.util.Collections.unmodifiableList(reasons_);
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional reasons for the annotation that will be assigned to the
     * Event.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason reasons = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of reasons at the given index.
     */
    public int getReasonsValue(int index) {
      return reasons_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional reasons for the annotation that will be assigned to the
     * Event.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason reasons = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for reasons to set.
     * @return This builder for chaining.
     */
    public Builder setReasonsValue(int index, int value) {
      ensureReasonsIsMutable();
      reasons_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional reasons for the annotation that will be assigned to the
     * Event.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason reasons = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for reasons to add.
     * @return This builder for chaining.
     */
    public Builder addReasonsValue(int value) {
      ensureReasonsIsMutable();
      reasons_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional reasons for the annotation that will be assigned to the
     * Event.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason reasons = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The enum numeric values on the wire for reasons to add.
     * @return This builder for chaining.
     */
    public Builder addAllReasonsValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureReasonsIsMutable();
      for (int value : values) {
        reasons_.add(value);
      }
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString hashedAccountId_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Optional. Optional unique stable hashed user identifier to apply to the
     * assessment. This is an alternative to setting the hashed_account_id in
     * CreateAssessment, for example when the account identifier is not yet known
     * in the initial request. It is recommended that the identifier is hashed
     * using hmac-sha256 with stable secret.
     * </pre>
     *
     * <code>bytes hashed_account_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The hashedAccountId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getHashedAccountId() {
      return hashedAccountId_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional unique stable hashed user identifier to apply to the
     * assessment. This is an alternative to setting the hashed_account_id in
     * CreateAssessment, for example when the account identifier is not yet known
     * in the initial request. It is recommended that the identifier is hashed
     * using hmac-sha256 with stable secret.
     * </pre>
     *
     * <code>bytes hashed_account_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The hashedAccountId to set.
     * @return This builder for chaining.
     */
    public Builder setHashedAccountId(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      hashedAccountId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional unique stable hashed user identifier to apply to the
     * assessment. This is an alternative to setting the hashed_account_id in
     * CreateAssessment, for example when the account identifier is not yet known
     * in the initial request. It is recommended that the identifier is hashed
     * using hmac-sha256 with stable secret.
     * </pre>
     *
     * <code>bytes hashed_account_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHashedAccountId() {
      bitField0_ = (bitField0_ & ~0x00000008);
      hashedAccountId_ = getDefaultInstance().getHashedAccountId();
      onChanged();
      return this;
    }

    private com.google.recaptchaenterprise.v1beta1.TransactionEvent transactionEvent_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.TransactionEvent,
            com.google.recaptchaenterprise.v1beta1.TransactionEvent.Builder,
            com.google.recaptchaenterprise.v1beta1.TransactionEventOrBuilder>
        transactionEventBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. If the assessment is part of a payment transaction, provide
     * details on payment lifecycle events that occur in the transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TransactionEvent transaction_event = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the transactionEvent field is set.
     */
    public boolean hasTransactionEvent() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. If the assessment is part of a payment transaction, provide
     * details on payment lifecycle events that occur in the transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TransactionEvent transaction_event = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The transactionEvent.
     */
    public com.google.recaptchaenterprise.v1beta1.TransactionEvent getTransactionEvent() {
      if (transactionEventBuilder_ == null) {
        return transactionEvent_ == null
            ? com.google.recaptchaenterprise.v1beta1.TransactionEvent.getDefaultInstance()
            : transactionEvent_;
      } else {
        return transactionEventBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If the assessment is part of a payment transaction, provide
     * details on payment lifecycle events that occur in the transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TransactionEvent transaction_event = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTransactionEvent(
        com.google.recaptchaenterprise.v1beta1.TransactionEvent value) {
      if (transactionEventBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transactionEvent_ = value;
      } else {
        transactionEventBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If the assessment is part of a payment transaction, provide
     * details on payment lifecycle events that occur in the transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TransactionEvent transaction_event = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTransactionEvent(
        com.google.recaptchaenterprise.v1beta1.TransactionEvent.Builder builderForValue) {
      if (transactionEventBuilder_ == null) {
        transactionEvent_ = builderForValue.build();
      } else {
        transactionEventBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If the assessment is part of a payment transaction, provide
     * details on payment lifecycle events that occur in the transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TransactionEvent transaction_event = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeTransactionEvent(
        com.google.recaptchaenterprise.v1beta1.TransactionEvent value) {
      if (transactionEventBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && transactionEvent_ != null
            && transactionEvent_
                != com.google.recaptchaenterprise.v1beta1.TransactionEvent.getDefaultInstance()) {
          getTransactionEventBuilder().mergeFrom(value);
        } else {
          transactionEvent_ = value;
        }
      } else {
        transactionEventBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If the assessment is part of a payment transaction, provide
     * details on payment lifecycle events that occur in the transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TransactionEvent transaction_event = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearTransactionEvent() {
      bitField0_ = (bitField0_ & ~0x00000010);
      transactionEvent_ = null;
      if (transactionEventBuilder_ != null) {
        transactionEventBuilder_.dispose();
        transactionEventBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If the assessment is part of a payment transaction, provide
     * details on payment lifecycle events that occur in the transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TransactionEvent transaction_event = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.TransactionEvent.Builder
        getTransactionEventBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getTransactionEventFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. If the assessment is part of a payment transaction, provide
     * details on payment lifecycle events that occur in the transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TransactionEvent transaction_event = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.TransactionEventOrBuilder
        getTransactionEventOrBuilder() {
      if (transactionEventBuilder_ != null) {
        return transactionEventBuilder_.getMessageOrBuilder();
      } else {
        return transactionEvent_ == null
            ? com.google.recaptchaenterprise.v1beta1.TransactionEvent.getDefaultInstance()
            : transactionEvent_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If the assessment is part of a payment transaction, provide
     * details on payment lifecycle events that occur in the transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TransactionEvent transaction_event = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.TransactionEvent,
            com.google.recaptchaenterprise.v1beta1.TransactionEvent.Builder,
            com.google.recaptchaenterprise.v1beta1.TransactionEventOrBuilder>
        getTransactionEventFieldBuilder() {
      if (transactionEventBuilder_ == null) {
        transactionEventBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1beta1.TransactionEvent,
                com.google.recaptchaenterprise.v1beta1.TransactionEvent.Builder,
                com.google.recaptchaenterprise.v1beta1.TransactionEventOrBuilder>(
                getTransactionEvent(), getParentForChildren(), isClean());
        transactionEvent_ = null;
      }
      return transactionEventBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest)
  private static final com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest();
  }

  public static com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AnnotateAssessmentRequest> PARSER =
      new com.google.protobuf.AbstractParser<AnnotateAssessmentRequest>() {
        @java.lang.Override
        public AnnotateAssessmentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AnnotateAssessmentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AnnotateAssessmentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
