/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/recaptchaenterprise/v1beta1/recaptchaenterprise.proto

package com.google.recaptchaenterprise.v1beta1;

/**
 *
 *
 * <pre>
 * Transaction data associated with a payment protected by reCAPTCHA Enterprise.
 * </pre>
 *
 * Protobuf type {@code google.cloud.recaptchaenterprise.v1beta1.TransactionData}
 */
public final class TransactionData extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.recaptchaenterprise.v1beta1.TransactionData)
    TransactionDataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TransactionData.newBuilder() to construct.
  private TransactionData(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TransactionData() {
    transactionId_ = "";
    paymentMethod_ = "";
    cardBin_ = "";
    cardLastFour_ = "";
    currencyCode_ = "";
    merchants_ = java.util.Collections.emptyList();
    items_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TransactionData();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionData_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionData_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.recaptchaenterprise.v1beta1.TransactionData.class,
            com.google.recaptchaenterprise.v1beta1.TransactionData.Builder.class);
  }

  public interface AddressOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The recipient name, potentially including information such as "care of".
     * </pre>
     *
     * <code>string recipient = 1;</code>
     *
     * @return The recipient.
     */
    java.lang.String getRecipient();
    /**
     *
     *
     * <pre>
     * The recipient name, potentially including information such as "care of".
     * </pre>
     *
     * <code>string recipient = 1;</code>
     *
     * @return The bytes for recipient.
     */
    com.google.protobuf.ByteString getRecipientBytes();

    /**
     *
     *
     * <pre>
     * The first lines of the address. The first line generally contains the
     * street name and number, and further lines may include information such as
     * an apartment number.
     * </pre>
     *
     * <code>repeated string address = 2;</code>
     *
     * @return A list containing the address.
     */
    java.util.List<java.lang.String> getAddressList();
    /**
     *
     *
     * <pre>
     * The first lines of the address. The first line generally contains the
     * street name and number, and further lines may include information such as
     * an apartment number.
     * </pre>
     *
     * <code>repeated string address = 2;</code>
     *
     * @return The count of address.
     */
    int getAddressCount();
    /**
     *
     *
     * <pre>
     * The first lines of the address. The first line generally contains the
     * street name and number, and further lines may include information such as
     * an apartment number.
     * </pre>
     *
     * <code>repeated string address = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The address at the given index.
     */
    java.lang.String getAddress(int index);
    /**
     *
     *
     * <pre>
     * The first lines of the address. The first line generally contains the
     * street name and number, and further lines may include information such as
     * an apartment number.
     * </pre>
     *
     * <code>repeated string address = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the address at the given index.
     */
    com.google.protobuf.ByteString getAddressBytes(int index);

    /**
     *
     *
     * <pre>
     * The town/city of the address.
     * </pre>
     *
     * <code>string locality = 3;</code>
     *
     * @return The locality.
     */
    java.lang.String getLocality();
    /**
     *
     *
     * <pre>
     * The town/city of the address.
     * </pre>
     *
     * <code>string locality = 3;</code>
     *
     * @return The bytes for locality.
     */
    com.google.protobuf.ByteString getLocalityBytes();

    /**
     *
     *
     * <pre>
     * The state, province, or otherwise administrative area of the address.
     * </pre>
     *
     * <code>string administrative_area = 4;</code>
     *
     * @return The administrativeArea.
     */
    java.lang.String getAdministrativeArea();
    /**
     *
     *
     * <pre>
     * The state, province, or otherwise administrative area of the address.
     * </pre>
     *
     * <code>string administrative_area = 4;</code>
     *
     * @return The bytes for administrativeArea.
     */
    com.google.protobuf.ByteString getAdministrativeAreaBytes();

    /**
     *
     *
     * <pre>
     * The CLDR country/region of the address.
     * </pre>
     *
     * <code>string region_code = 5;</code>
     *
     * @return The regionCode.
     */
    java.lang.String getRegionCode();
    /**
     *
     *
     * <pre>
     * The CLDR country/region of the address.
     * </pre>
     *
     * <code>string region_code = 5;</code>
     *
     * @return The bytes for regionCode.
     */
    com.google.protobuf.ByteString getRegionCodeBytes();

    /**
     *
     *
     * <pre>
     * The postal or ZIP code of the address.
     * </pre>
     *
     * <code>string postal_code = 6;</code>
     *
     * @return The postalCode.
     */
    java.lang.String getPostalCode();
    /**
     *
     *
     * <pre>
     * The postal or ZIP code of the address.
     * </pre>
     *
     * <code>string postal_code = 6;</code>
     *
     * @return The bytes for postalCode.
     */
    com.google.protobuf.ByteString getPostalCodeBytes();
  }
  /**
   *
   *
   * <pre>
   * Structured address format for billing and shipping addresses.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address}
   */
  public static final class Address extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address)
      AddressOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Address.newBuilder() to construct.
    private Address(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Address() {
      recipient_ = "";
      address_ = com.google.protobuf.LazyStringArrayList.emptyList();
      locality_ = "";
      administrativeArea_ = "";
      regionCode_ = "";
      postalCode_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Address();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionData_Address_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionData_Address_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.recaptchaenterprise.v1beta1.TransactionData.Address.class,
              com.google.recaptchaenterprise.v1beta1.TransactionData.Address.Builder.class);
    }

    public static final int RECIPIENT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object recipient_ = "";
    /**
     *
     *
     * <pre>
     * The recipient name, potentially including information such as "care of".
     * </pre>
     *
     * <code>string recipient = 1;</code>
     *
     * @return The recipient.
     */
    @java.lang.Override
    public java.lang.String getRecipient() {
      java.lang.Object ref = recipient_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        recipient_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The recipient name, potentially including information such as "care of".
     * </pre>
     *
     * <code>string recipient = 1;</code>
     *
     * @return The bytes for recipient.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRecipientBytes() {
      java.lang.Object ref = recipient_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        recipient_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ADDRESS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList address_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * The first lines of the address. The first line generally contains the
     * street name and number, and further lines may include information such as
     * an apartment number.
     * </pre>
     *
     * <code>repeated string address = 2;</code>
     *
     * @return A list containing the address.
     */
    public com.google.protobuf.ProtocolStringList getAddressList() {
      return address_;
    }
    /**
     *
     *
     * <pre>
     * The first lines of the address. The first line generally contains the
     * street name and number, and further lines may include information such as
     * an apartment number.
     * </pre>
     *
     * <code>repeated string address = 2;</code>
     *
     * @return The count of address.
     */
    public int getAddressCount() {
      return address_.size();
    }
    /**
     *
     *
     * <pre>
     * The first lines of the address. The first line generally contains the
     * street name and number, and further lines may include information such as
     * an apartment number.
     * </pre>
     *
     * <code>repeated string address = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The address at the given index.
     */
    public java.lang.String getAddress(int index) {
      return address_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The first lines of the address. The first line generally contains the
     * street name and number, and further lines may include information such as
     * an apartment number.
     * </pre>
     *
     * <code>repeated string address = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the address at the given index.
     */
    public com.google.protobuf.ByteString getAddressBytes(int index) {
      return address_.getByteString(index);
    }

    public static final int LOCALITY_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object locality_ = "";
    /**
     *
     *
     * <pre>
     * The town/city of the address.
     * </pre>
     *
     * <code>string locality = 3;</code>
     *
     * @return The locality.
     */
    @java.lang.Override
    public java.lang.String getLocality() {
      java.lang.Object ref = locality_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        locality_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The town/city of the address.
     * </pre>
     *
     * <code>string locality = 3;</code>
     *
     * @return The bytes for locality.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLocalityBytes() {
      java.lang.Object ref = locality_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        locality_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ADMINISTRATIVE_AREA_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object administrativeArea_ = "";
    /**
     *
     *
     * <pre>
     * The state, province, or otherwise administrative area of the address.
     * </pre>
     *
     * <code>string administrative_area = 4;</code>
     *
     * @return The administrativeArea.
     */
    @java.lang.Override
    public java.lang.String getAdministrativeArea() {
      java.lang.Object ref = administrativeArea_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        administrativeArea_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The state, province, or otherwise administrative area of the address.
     * </pre>
     *
     * <code>string administrative_area = 4;</code>
     *
     * @return The bytes for administrativeArea.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAdministrativeAreaBytes() {
      java.lang.Object ref = administrativeArea_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        administrativeArea_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int REGION_CODE_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object regionCode_ = "";
    /**
     *
     *
     * <pre>
     * The CLDR country/region of the address.
     * </pre>
     *
     * <code>string region_code = 5;</code>
     *
     * @return The regionCode.
     */
    @java.lang.Override
    public java.lang.String getRegionCode() {
      java.lang.Object ref = regionCode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        regionCode_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The CLDR country/region of the address.
     * </pre>
     *
     * <code>string region_code = 5;</code>
     *
     * @return The bytes for regionCode.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRegionCodeBytes() {
      java.lang.Object ref = regionCode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        regionCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int POSTAL_CODE_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private volatile java.lang.Object postalCode_ = "";
    /**
     *
     *
     * <pre>
     * The postal or ZIP code of the address.
     * </pre>
     *
     * <code>string postal_code = 6;</code>
     *
     * @return The postalCode.
     */
    @java.lang.Override
    public java.lang.String getPostalCode() {
      java.lang.Object ref = postalCode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        postalCode_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The postal or ZIP code of the address.
     * </pre>
     *
     * <code>string postal_code = 6;</code>
     *
     * @return The bytes for postalCode.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPostalCodeBytes() {
      java.lang.Object ref = postalCode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        postalCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(recipient_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, recipient_);
      }
      for (int i = 0; i < address_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, address_.getRaw(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locality_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, locality_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(administrativeArea_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, administrativeArea_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(regionCode_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, regionCode_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(postalCode_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, postalCode_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(recipient_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, recipient_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < address_.size(); i++) {
          dataSize += computeStringSizeNoTag(address_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getAddressList().size();
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locality_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, locality_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(administrativeArea_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, administrativeArea_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(regionCode_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, regionCode_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(postalCode_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, postalCode_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.recaptchaenterprise.v1beta1.TransactionData.Address)) {
        return super.equals(obj);
      }
      com.google.recaptchaenterprise.v1beta1.TransactionData.Address other =
          (com.google.recaptchaenterprise.v1beta1.TransactionData.Address) obj;

      if (!getRecipient().equals(other.getRecipient())) return false;
      if (!getAddressList().equals(other.getAddressList())) return false;
      if (!getLocality().equals(other.getLocality())) return false;
      if (!getAdministrativeArea().equals(other.getAdministrativeArea())) return false;
      if (!getRegionCode().equals(other.getRegionCode())) return false;
      if (!getPostalCode().equals(other.getPostalCode())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + RECIPIENT_FIELD_NUMBER;
      hash = (53 * hash) + getRecipient().hashCode();
      if (getAddressCount() > 0) {
        hash = (37 * hash) + ADDRESS_FIELD_NUMBER;
        hash = (53 * hash) + getAddressList().hashCode();
      }
      hash = (37 * hash) + LOCALITY_FIELD_NUMBER;
      hash = (53 * hash) + getLocality().hashCode();
      hash = (37 * hash) + ADMINISTRATIVE_AREA_FIELD_NUMBER;
      hash = (53 * hash) + getAdministrativeArea().hashCode();
      hash = (37 * hash) + REGION_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getRegionCode().hashCode();
      hash = (37 * hash) + POSTAL_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getPostalCode().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.Address parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.Address parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.Address parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.Address parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.Address parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.Address parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.Address parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.Address parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.Address parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.Address parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.Address parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.Address parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.recaptchaenterprise.v1beta1.TransactionData.Address prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Structured address format for billing and shipping addresses.
     * </pre>
     *
     * Protobuf type {@code google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address)
        com.google.recaptchaenterprise.v1beta1.TransactionData.AddressOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
            .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionData_Address_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
            .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionData_Address_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.recaptchaenterprise.v1beta1.TransactionData.Address.class,
                com.google.recaptchaenterprise.v1beta1.TransactionData.Address.Builder.class);
      }

      // Construct using com.google.recaptchaenterprise.v1beta1.TransactionData.Address.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        recipient_ = "";
        address_ = com.google.protobuf.LazyStringArrayList.emptyList();
        locality_ = "";
        administrativeArea_ = "";
        regionCode_ = "";
        postalCode_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
            .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionData_Address_descriptor;
      }

      @java.lang.Override
      public com.google.recaptchaenterprise.v1beta1.TransactionData.Address
          getDefaultInstanceForType() {
        return com.google.recaptchaenterprise.v1beta1.TransactionData.Address.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.recaptchaenterprise.v1beta1.TransactionData.Address build() {
        com.google.recaptchaenterprise.v1beta1.TransactionData.Address result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.recaptchaenterprise.v1beta1.TransactionData.Address buildPartial() {
        com.google.recaptchaenterprise.v1beta1.TransactionData.Address result =
            new com.google.recaptchaenterprise.v1beta1.TransactionData.Address(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.recaptchaenterprise.v1beta1.TransactionData.Address result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.recipient_ = recipient_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          address_.makeImmutable();
          result.address_ = address_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.locality_ = locality_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.administrativeArea_ = administrativeArea_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.regionCode_ = regionCode_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.postalCode_ = postalCode_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.recaptchaenterprise.v1beta1.TransactionData.Address) {
          return mergeFrom((com.google.recaptchaenterprise.v1beta1.TransactionData.Address) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.recaptchaenterprise.v1beta1.TransactionData.Address other) {
        if (other
            == com.google.recaptchaenterprise.v1beta1.TransactionData.Address.getDefaultInstance())
          return this;
        if (!other.getRecipient().isEmpty()) {
          recipient_ = other.recipient_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.address_.isEmpty()) {
          if (address_.isEmpty()) {
            address_ = other.address_;
            bitField0_ |= 0x00000002;
          } else {
            ensureAddressIsMutable();
            address_.addAll(other.address_);
          }
          onChanged();
        }
        if (!other.getLocality().isEmpty()) {
          locality_ = other.locality_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getAdministrativeArea().isEmpty()) {
          administrativeArea_ = other.administrativeArea_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (!other.getRegionCode().isEmpty()) {
          regionCode_ = other.regionCode_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (!other.getPostalCode().isEmpty()) {
          postalCode_ = other.postalCode_;
          bitField0_ |= 0x00000020;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  recipient_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureAddressIsMutable();
                  address_.add(s);
                  break;
                } // case 18
              case 26:
                {
                  locality_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  administrativeArea_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  regionCode_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 50:
                {
                  postalCode_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object recipient_ = "";
      /**
       *
       *
       * <pre>
       * The recipient name, potentially including information such as "care of".
       * </pre>
       *
       * <code>string recipient = 1;</code>
       *
       * @return The recipient.
       */
      public java.lang.String getRecipient() {
        java.lang.Object ref = recipient_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          recipient_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The recipient name, potentially including information such as "care of".
       * </pre>
       *
       * <code>string recipient = 1;</code>
       *
       * @return The bytes for recipient.
       */
      public com.google.protobuf.ByteString getRecipientBytes() {
        java.lang.Object ref = recipient_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          recipient_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The recipient name, potentially including information such as "care of".
       * </pre>
       *
       * <code>string recipient = 1;</code>
       *
       * @param value The recipient to set.
       * @return This builder for chaining.
       */
      public Builder setRecipient(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        recipient_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The recipient name, potentially including information such as "care of".
       * </pre>
       *
       * <code>string recipient = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRecipient() {
        recipient_ = getDefaultInstance().getRecipient();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The recipient name, potentially including information such as "care of".
       * </pre>
       *
       * <code>string recipient = 1;</code>
       *
       * @param value The bytes for recipient to set.
       * @return This builder for chaining.
       */
      public Builder setRecipientBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        recipient_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList address_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureAddressIsMutable() {
        if (!address_.isModifiable()) {
          address_ = new com.google.protobuf.LazyStringArrayList(address_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * The first lines of the address. The first line generally contains the
       * street name and number, and further lines may include information such as
       * an apartment number.
       * </pre>
       *
       * <code>repeated string address = 2;</code>
       *
       * @return A list containing the address.
       */
      public com.google.protobuf.ProtocolStringList getAddressList() {
        address_.makeImmutable();
        return address_;
      }
      /**
       *
       *
       * <pre>
       * The first lines of the address. The first line generally contains the
       * street name and number, and further lines may include information such as
       * an apartment number.
       * </pre>
       *
       * <code>repeated string address = 2;</code>
       *
       * @return The count of address.
       */
      public int getAddressCount() {
        return address_.size();
      }
      /**
       *
       *
       * <pre>
       * The first lines of the address. The first line generally contains the
       * street name and number, and further lines may include information such as
       * an apartment number.
       * </pre>
       *
       * <code>repeated string address = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The address at the given index.
       */
      public java.lang.String getAddress(int index) {
        return address_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The first lines of the address. The first line generally contains the
       * street name and number, and further lines may include information such as
       * an apartment number.
       * </pre>
       *
       * <code>repeated string address = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the address at the given index.
       */
      public com.google.protobuf.ByteString getAddressBytes(int index) {
        return address_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * The first lines of the address. The first line generally contains the
       * street name and number, and further lines may include information such as
       * an apartment number.
       * </pre>
       *
       * <code>repeated string address = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The address to set.
       * @return This builder for chaining.
       */
      public Builder setAddress(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAddressIsMutable();
        address_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The first lines of the address. The first line generally contains the
       * street name and number, and further lines may include information such as
       * an apartment number.
       * </pre>
       *
       * <code>repeated string address = 2;</code>
       *
       * @param value The address to add.
       * @return This builder for chaining.
       */
      public Builder addAddress(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAddressIsMutable();
        address_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The first lines of the address. The first line generally contains the
       * street name and number, and further lines may include information such as
       * an apartment number.
       * </pre>
       *
       * <code>repeated string address = 2;</code>
       *
       * @param values The address to add.
       * @return This builder for chaining.
       */
      public Builder addAllAddress(java.lang.Iterable<java.lang.String> values) {
        ensureAddressIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, address_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The first lines of the address. The first line generally contains the
       * street name and number, and further lines may include information such as
       * an apartment number.
       * </pre>
       *
       * <code>repeated string address = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAddress() {
        address_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The first lines of the address. The first line generally contains the
       * street name and number, and further lines may include information such as
       * an apartment number.
       * </pre>
       *
       * <code>repeated string address = 2;</code>
       *
       * @param value The bytes of the address to add.
       * @return This builder for chaining.
       */
      public Builder addAddressBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureAddressIsMutable();
        address_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object locality_ = "";
      /**
       *
       *
       * <pre>
       * The town/city of the address.
       * </pre>
       *
       * <code>string locality = 3;</code>
       *
       * @return The locality.
       */
      public java.lang.String getLocality() {
        java.lang.Object ref = locality_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          locality_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The town/city of the address.
       * </pre>
       *
       * <code>string locality = 3;</code>
       *
       * @return The bytes for locality.
       */
      public com.google.protobuf.ByteString getLocalityBytes() {
        java.lang.Object ref = locality_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          locality_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The town/city of the address.
       * </pre>
       *
       * <code>string locality = 3;</code>
       *
       * @param value The locality to set.
       * @return This builder for chaining.
       */
      public Builder setLocality(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        locality_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The town/city of the address.
       * </pre>
       *
       * <code>string locality = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLocality() {
        locality_ = getDefaultInstance().getLocality();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The town/city of the address.
       * </pre>
       *
       * <code>string locality = 3;</code>
       *
       * @param value The bytes for locality to set.
       * @return This builder for chaining.
       */
      public Builder setLocalityBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        locality_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object administrativeArea_ = "";
      /**
       *
       *
       * <pre>
       * The state, province, or otherwise administrative area of the address.
       * </pre>
       *
       * <code>string administrative_area = 4;</code>
       *
       * @return The administrativeArea.
       */
      public java.lang.String getAdministrativeArea() {
        java.lang.Object ref = administrativeArea_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          administrativeArea_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The state, province, or otherwise administrative area of the address.
       * </pre>
       *
       * <code>string administrative_area = 4;</code>
       *
       * @return The bytes for administrativeArea.
       */
      public com.google.protobuf.ByteString getAdministrativeAreaBytes() {
        java.lang.Object ref = administrativeArea_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          administrativeArea_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The state, province, or otherwise administrative area of the address.
       * </pre>
       *
       * <code>string administrative_area = 4;</code>
       *
       * @param value The administrativeArea to set.
       * @return This builder for chaining.
       */
      public Builder setAdministrativeArea(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        administrativeArea_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The state, province, or otherwise administrative area of the address.
       * </pre>
       *
       * <code>string administrative_area = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAdministrativeArea() {
        administrativeArea_ = getDefaultInstance().getAdministrativeArea();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The state, province, or otherwise administrative area of the address.
       * </pre>
       *
       * <code>string administrative_area = 4;</code>
       *
       * @param value The bytes for administrativeArea to set.
       * @return This builder for chaining.
       */
      public Builder setAdministrativeAreaBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        administrativeArea_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object regionCode_ = "";
      /**
       *
       *
       * <pre>
       * The CLDR country/region of the address.
       * </pre>
       *
       * <code>string region_code = 5;</code>
       *
       * @return The regionCode.
       */
      public java.lang.String getRegionCode() {
        java.lang.Object ref = regionCode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          regionCode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The CLDR country/region of the address.
       * </pre>
       *
       * <code>string region_code = 5;</code>
       *
       * @return The bytes for regionCode.
       */
      public com.google.protobuf.ByteString getRegionCodeBytes() {
        java.lang.Object ref = regionCode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          regionCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The CLDR country/region of the address.
       * </pre>
       *
       * <code>string region_code = 5;</code>
       *
       * @param value The regionCode to set.
       * @return This builder for chaining.
       */
      public Builder setRegionCode(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        regionCode_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The CLDR country/region of the address.
       * </pre>
       *
       * <code>string region_code = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRegionCode() {
        regionCode_ = getDefaultInstance().getRegionCode();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The CLDR country/region of the address.
       * </pre>
       *
       * <code>string region_code = 5;</code>
       *
       * @param value The bytes for regionCode to set.
       * @return This builder for chaining.
       */
      public Builder setRegionCodeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        regionCode_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private java.lang.Object postalCode_ = "";
      /**
       *
       *
       * <pre>
       * The postal or ZIP code of the address.
       * </pre>
       *
       * <code>string postal_code = 6;</code>
       *
       * @return The postalCode.
       */
      public java.lang.String getPostalCode() {
        java.lang.Object ref = postalCode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          postalCode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The postal or ZIP code of the address.
       * </pre>
       *
       * <code>string postal_code = 6;</code>
       *
       * @return The bytes for postalCode.
       */
      public com.google.protobuf.ByteString getPostalCodeBytes() {
        java.lang.Object ref = postalCode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          postalCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The postal or ZIP code of the address.
       * </pre>
       *
       * <code>string postal_code = 6;</code>
       *
       * @param value The postalCode to set.
       * @return This builder for chaining.
       */
      public Builder setPostalCode(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        postalCode_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The postal or ZIP code of the address.
       * </pre>
       *
       * <code>string postal_code = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPostalCode() {
        postalCode_ = getDefaultInstance().getPostalCode();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The postal or ZIP code of the address.
       * </pre>
       *
       * <code>string postal_code = 6;</code>
       *
       * @param value The bytes for postalCode to set.
       * @return This builder for chaining.
       */
      public Builder setPostalCodeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        postalCode_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address)
    private static final com.google.recaptchaenterprise.v1beta1.TransactionData.Address
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.recaptchaenterprise.v1beta1.TransactionData.Address();
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.Address
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Address> PARSER =
        new com.google.protobuf.AbstractParser<Address>() {
          @java.lang.Override
          public Address parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Address> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Address> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.TransactionData.Address
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface UserOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.recaptchaenterprise.v1beta1.TransactionData.User)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Unique account identifier for this user. If using account defender,
     * this should match the hashed_account_id field. Otherwise, a unique and
     * persistent identifier for this account.
     * </pre>
     *
     * <code>string account_id = 6;</code>
     *
     * @return The accountId.
     */
    java.lang.String getAccountId();
    /**
     *
     *
     * <pre>
     * Unique account identifier for this user. If using account defender,
     * this should match the hashed_account_id field. Otherwise, a unique and
     * persistent identifier for this account.
     * </pre>
     *
     * <code>string account_id = 6;</code>
     *
     * @return The bytes for accountId.
     */
    com.google.protobuf.ByteString getAccountIdBytes();

    /**
     *
     *
     * <pre>
     * The epoch milliseconds of the user's account creation.
     * </pre>
     *
     * <code>int64 creation_ms = 1;</code>
     *
     * @return The creationMs.
     */
    long getCreationMs();

    /**
     *
     *
     * <pre>
     * The email address of the user.
     * </pre>
     *
     * <code>string email = 2;</code>
     *
     * @return The email.
     */
    java.lang.String getEmail();
    /**
     *
     *
     * <pre>
     * The email address of the user.
     * </pre>
     *
     * <code>string email = 2;</code>
     *
     * @return The bytes for email.
     */
    com.google.protobuf.ByteString getEmailBytes();

    /**
     *
     *
     * <pre>
     * Whether the email has been verified to be accessible by the user (OTP or
     * similar).
     * </pre>
     *
     * <code>bool email_verified = 3;</code>
     *
     * @return The emailVerified.
     */
    boolean getEmailVerified();

    /**
     *
     *
     * <pre>
     * The phone number of the user, with country code.
     * </pre>
     *
     * <code>string phone_number = 4;</code>
     *
     * @return The phoneNumber.
     */
    java.lang.String getPhoneNumber();
    /**
     *
     *
     * <pre>
     * The phone number of the user, with country code.
     * </pre>
     *
     * <code>string phone_number = 4;</code>
     *
     * @return The bytes for phoneNumber.
     */
    com.google.protobuf.ByteString getPhoneNumberBytes();

    /**
     *
     *
     * <pre>
     * Whether the phone number has been verified to be accessible by the user
     * (OTP or similar).
     * </pre>
     *
     * <code>bool phone_verified = 5;</code>
     *
     * @return The phoneVerified.
     */
    boolean getPhoneVerified();
  }
  /**
   *
   *
   * <pre>
   * Details about a user's account involved in the transaction.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recaptchaenterprise.v1beta1.TransactionData.User}
   */
  public static final class User extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.recaptchaenterprise.v1beta1.TransactionData.User)
      UserOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use User.newBuilder() to construct.
    private User(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private User() {
      accountId_ = "";
      email_ = "";
      phoneNumber_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new User();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionData_User_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionData_User_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.recaptchaenterprise.v1beta1.TransactionData.User.class,
              com.google.recaptchaenterprise.v1beta1.TransactionData.User.Builder.class);
    }

    public static final int ACCOUNT_ID_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private volatile java.lang.Object accountId_ = "";
    /**
     *
     *
     * <pre>
     * Unique account identifier for this user. If using account defender,
     * this should match the hashed_account_id field. Otherwise, a unique and
     * persistent identifier for this account.
     * </pre>
     *
     * <code>string account_id = 6;</code>
     *
     * @return The accountId.
     */
    @java.lang.Override
    public java.lang.String getAccountId() {
      java.lang.Object ref = accountId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        accountId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique account identifier for this user. If using account defender,
     * this should match the hashed_account_id field. Otherwise, a unique and
     * persistent identifier for this account.
     * </pre>
     *
     * <code>string account_id = 6;</code>
     *
     * @return The bytes for accountId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAccountIdBytes() {
      java.lang.Object ref = accountId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        accountId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CREATION_MS_FIELD_NUMBER = 1;
    private long creationMs_ = 0L;
    /**
     *
     *
     * <pre>
     * The epoch milliseconds of the user's account creation.
     * </pre>
     *
     * <code>int64 creation_ms = 1;</code>
     *
     * @return The creationMs.
     */
    @java.lang.Override
    public long getCreationMs() {
      return creationMs_;
    }

    public static final int EMAIL_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object email_ = "";
    /**
     *
     *
     * <pre>
     * The email address of the user.
     * </pre>
     *
     * <code>string email = 2;</code>
     *
     * @return The email.
     */
    @java.lang.Override
    public java.lang.String getEmail() {
      java.lang.Object ref = email_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        email_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The email address of the user.
     * </pre>
     *
     * <code>string email = 2;</code>
     *
     * @return The bytes for email.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEmailBytes() {
      java.lang.Object ref = email_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        email_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int EMAIL_VERIFIED_FIELD_NUMBER = 3;
    private boolean emailVerified_ = false;
    /**
     *
     *
     * <pre>
     * Whether the email has been verified to be accessible by the user (OTP or
     * similar).
     * </pre>
     *
     * <code>bool email_verified = 3;</code>
     *
     * @return The emailVerified.
     */
    @java.lang.Override
    public boolean getEmailVerified() {
      return emailVerified_;
    }

    public static final int PHONE_NUMBER_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object phoneNumber_ = "";
    /**
     *
     *
     * <pre>
     * The phone number of the user, with country code.
     * </pre>
     *
     * <code>string phone_number = 4;</code>
     *
     * @return The phoneNumber.
     */
    @java.lang.Override
    public java.lang.String getPhoneNumber() {
      java.lang.Object ref = phoneNumber_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        phoneNumber_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The phone number of the user, with country code.
     * </pre>
     *
     * <code>string phone_number = 4;</code>
     *
     * @return The bytes for phoneNumber.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPhoneNumberBytes() {
      java.lang.Object ref = phoneNumber_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        phoneNumber_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PHONE_VERIFIED_FIELD_NUMBER = 5;
    private boolean phoneVerified_ = false;
    /**
     *
     *
     * <pre>
     * Whether the phone number has been verified to be accessible by the user
     * (OTP or similar).
     * </pre>
     *
     * <code>bool phone_verified = 5;</code>
     *
     * @return The phoneVerified.
     */
    @java.lang.Override
    public boolean getPhoneVerified() {
      return phoneVerified_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (creationMs_ != 0L) {
        output.writeInt64(1, creationMs_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(email_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, email_);
      }
      if (emailVerified_ != false) {
        output.writeBool(3, emailVerified_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(phoneNumber_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, phoneNumber_);
      }
      if (phoneVerified_ != false) {
        output.writeBool(5, phoneVerified_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(accountId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, accountId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (creationMs_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, creationMs_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(email_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, email_);
      }
      if (emailVerified_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, emailVerified_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(phoneNumber_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, phoneNumber_);
      }
      if (phoneVerified_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, phoneVerified_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(accountId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, accountId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.recaptchaenterprise.v1beta1.TransactionData.User)) {
        return super.equals(obj);
      }
      com.google.recaptchaenterprise.v1beta1.TransactionData.User other =
          (com.google.recaptchaenterprise.v1beta1.TransactionData.User) obj;

      if (!getAccountId().equals(other.getAccountId())) return false;
      if (getCreationMs() != other.getCreationMs()) return false;
      if (!getEmail().equals(other.getEmail())) return false;
      if (getEmailVerified() != other.getEmailVerified()) return false;
      if (!getPhoneNumber().equals(other.getPhoneNumber())) return false;
      if (getPhoneVerified() != other.getPhoneVerified()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ACCOUNT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getAccountId().hashCode();
      hash = (37 * hash) + CREATION_MS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getCreationMs());
      hash = (37 * hash) + EMAIL_FIELD_NUMBER;
      hash = (53 * hash) + getEmail().hashCode();
      hash = (37 * hash) + EMAIL_VERIFIED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEmailVerified());
      hash = (37 * hash) + PHONE_NUMBER_FIELD_NUMBER;
      hash = (53 * hash) + getPhoneNumber().hashCode();
      hash = (37 * hash) + PHONE_VERIFIED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPhoneVerified());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.User parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.User parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.User parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.User parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.User parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.User parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.User parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.User parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.User parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.User parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.User parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.User parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.recaptchaenterprise.v1beta1.TransactionData.User prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Details about a user's account involved in the transaction.
     * </pre>
     *
     * Protobuf type {@code google.cloud.recaptchaenterprise.v1beta1.TransactionData.User}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.recaptchaenterprise.v1beta1.TransactionData.User)
        com.google.recaptchaenterprise.v1beta1.TransactionData.UserOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
            .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionData_User_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
            .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionData_User_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.recaptchaenterprise.v1beta1.TransactionData.User.class,
                com.google.recaptchaenterprise.v1beta1.TransactionData.User.Builder.class);
      }

      // Construct using com.google.recaptchaenterprise.v1beta1.TransactionData.User.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        accountId_ = "";
        creationMs_ = 0L;
        email_ = "";
        emailVerified_ = false;
        phoneNumber_ = "";
        phoneVerified_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
            .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionData_User_descriptor;
      }

      @java.lang.Override
      public com.google.recaptchaenterprise.v1beta1.TransactionData.User
          getDefaultInstanceForType() {
        return com.google.recaptchaenterprise.v1beta1.TransactionData.User.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.recaptchaenterprise.v1beta1.TransactionData.User build() {
        com.google.recaptchaenterprise.v1beta1.TransactionData.User result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.recaptchaenterprise.v1beta1.TransactionData.User buildPartial() {
        com.google.recaptchaenterprise.v1beta1.TransactionData.User result =
            new com.google.recaptchaenterprise.v1beta1.TransactionData.User(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.recaptchaenterprise.v1beta1.TransactionData.User result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.accountId_ = accountId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.creationMs_ = creationMs_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.email_ = email_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.emailVerified_ = emailVerified_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.phoneNumber_ = phoneNumber_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.phoneVerified_ = phoneVerified_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.recaptchaenterprise.v1beta1.TransactionData.User) {
          return mergeFrom((com.google.recaptchaenterprise.v1beta1.TransactionData.User) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.recaptchaenterprise.v1beta1.TransactionData.User other) {
        if (other
            == com.google.recaptchaenterprise.v1beta1.TransactionData.User.getDefaultInstance())
          return this;
        if (!other.getAccountId().isEmpty()) {
          accountId_ = other.accountId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getCreationMs() != 0L) {
          setCreationMs(other.getCreationMs());
        }
        if (!other.getEmail().isEmpty()) {
          email_ = other.email_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (other.getEmailVerified() != false) {
          setEmailVerified(other.getEmailVerified());
        }
        if (!other.getPhoneNumber().isEmpty()) {
          phoneNumber_ = other.phoneNumber_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (other.getPhoneVerified() != false) {
          setPhoneVerified(other.getPhoneVerified());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  creationMs_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 8
              case 18:
                {
                  email_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 18
              case 24:
                {
                  emailVerified_ = input.readBool();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 24
              case 34:
                {
                  phoneNumber_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 34
              case 40:
                {
                  phoneVerified_ = input.readBool();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 40
              case 50:
                {
                  accountId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object accountId_ = "";
      /**
       *
       *
       * <pre>
       * Unique account identifier for this user. If using account defender,
       * this should match the hashed_account_id field. Otherwise, a unique and
       * persistent identifier for this account.
       * </pre>
       *
       * <code>string account_id = 6;</code>
       *
       * @return The accountId.
       */
      public java.lang.String getAccountId() {
        java.lang.Object ref = accountId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          accountId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Unique account identifier for this user. If using account defender,
       * this should match the hashed_account_id field. Otherwise, a unique and
       * persistent identifier for this account.
       * </pre>
       *
       * <code>string account_id = 6;</code>
       *
       * @return The bytes for accountId.
       */
      public com.google.protobuf.ByteString getAccountIdBytes() {
        java.lang.Object ref = accountId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          accountId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Unique account identifier for this user. If using account defender,
       * this should match the hashed_account_id field. Otherwise, a unique and
       * persistent identifier for this account.
       * </pre>
       *
       * <code>string account_id = 6;</code>
       *
       * @param value The accountId to set.
       * @return This builder for chaining.
       */
      public Builder setAccountId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        accountId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Unique account identifier for this user. If using account defender,
       * this should match the hashed_account_id field. Otherwise, a unique and
       * persistent identifier for this account.
       * </pre>
       *
       * <code>string account_id = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAccountId() {
        accountId_ = getDefaultInstance().getAccountId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Unique account identifier for this user. If using account defender,
       * this should match the hashed_account_id field. Otherwise, a unique and
       * persistent identifier for this account.
       * </pre>
       *
       * <code>string account_id = 6;</code>
       *
       * @param value The bytes for accountId to set.
       * @return This builder for chaining.
       */
      public Builder setAccountIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        accountId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private long creationMs_;
      /**
       *
       *
       * <pre>
       * The epoch milliseconds of the user's account creation.
       * </pre>
       *
       * <code>int64 creation_ms = 1;</code>
       *
       * @return The creationMs.
       */
      @java.lang.Override
      public long getCreationMs() {
        return creationMs_;
      }
      /**
       *
       *
       * <pre>
       * The epoch milliseconds of the user's account creation.
       * </pre>
       *
       * <code>int64 creation_ms = 1;</code>
       *
       * @param value The creationMs to set.
       * @return This builder for chaining.
       */
      public Builder setCreationMs(long value) {

        creationMs_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The epoch milliseconds of the user's account creation.
       * </pre>
       *
       * <code>int64 creation_ms = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCreationMs() {
        bitField0_ = (bitField0_ & ~0x00000002);
        creationMs_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object email_ = "";
      /**
       *
       *
       * <pre>
       * The email address of the user.
       * </pre>
       *
       * <code>string email = 2;</code>
       *
       * @return The email.
       */
      public java.lang.String getEmail() {
        java.lang.Object ref = email_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          email_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The email address of the user.
       * </pre>
       *
       * <code>string email = 2;</code>
       *
       * @return The bytes for email.
       */
      public com.google.protobuf.ByteString getEmailBytes() {
        java.lang.Object ref = email_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          email_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The email address of the user.
       * </pre>
       *
       * <code>string email = 2;</code>
       *
       * @param value The email to set.
       * @return This builder for chaining.
       */
      public Builder setEmail(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        email_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The email address of the user.
       * </pre>
       *
       * <code>string email = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEmail() {
        email_ = getDefaultInstance().getEmail();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The email address of the user.
       * </pre>
       *
       * <code>string email = 2;</code>
       *
       * @param value The bytes for email to set.
       * @return This builder for chaining.
       */
      public Builder setEmailBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        email_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private boolean emailVerified_;
      /**
       *
       *
       * <pre>
       * Whether the email has been verified to be accessible by the user (OTP or
       * similar).
       * </pre>
       *
       * <code>bool email_verified = 3;</code>
       *
       * @return The emailVerified.
       */
      @java.lang.Override
      public boolean getEmailVerified() {
        return emailVerified_;
      }
      /**
       *
       *
       * <pre>
       * Whether the email has been verified to be accessible by the user (OTP or
       * similar).
       * </pre>
       *
       * <code>bool email_verified = 3;</code>
       *
       * @param value The emailVerified to set.
       * @return This builder for chaining.
       */
      public Builder setEmailVerified(boolean value) {

        emailVerified_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether the email has been verified to be accessible by the user (OTP or
       * similar).
       * </pre>
       *
       * <code>bool email_verified = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEmailVerified() {
        bitField0_ = (bitField0_ & ~0x00000008);
        emailVerified_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object phoneNumber_ = "";
      /**
       *
       *
       * <pre>
       * The phone number of the user, with country code.
       * </pre>
       *
       * <code>string phone_number = 4;</code>
       *
       * @return The phoneNumber.
       */
      public java.lang.String getPhoneNumber() {
        java.lang.Object ref = phoneNumber_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          phoneNumber_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The phone number of the user, with country code.
       * </pre>
       *
       * <code>string phone_number = 4;</code>
       *
       * @return The bytes for phoneNumber.
       */
      public com.google.protobuf.ByteString getPhoneNumberBytes() {
        java.lang.Object ref = phoneNumber_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          phoneNumber_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The phone number of the user, with country code.
       * </pre>
       *
       * <code>string phone_number = 4;</code>
       *
       * @param value The phoneNumber to set.
       * @return This builder for chaining.
       */
      public Builder setPhoneNumber(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        phoneNumber_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The phone number of the user, with country code.
       * </pre>
       *
       * <code>string phone_number = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPhoneNumber() {
        phoneNumber_ = getDefaultInstance().getPhoneNumber();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The phone number of the user, with country code.
       * </pre>
       *
       * <code>string phone_number = 4;</code>
       *
       * @param value The bytes for phoneNumber to set.
       * @return This builder for chaining.
       */
      public Builder setPhoneNumberBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        phoneNumber_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private boolean phoneVerified_;
      /**
       *
       *
       * <pre>
       * Whether the phone number has been verified to be accessible by the user
       * (OTP or similar).
       * </pre>
       *
       * <code>bool phone_verified = 5;</code>
       *
       * @return The phoneVerified.
       */
      @java.lang.Override
      public boolean getPhoneVerified() {
        return phoneVerified_;
      }
      /**
       *
       *
       * <pre>
       * Whether the phone number has been verified to be accessible by the user
       * (OTP or similar).
       * </pre>
       *
       * <code>bool phone_verified = 5;</code>
       *
       * @param value The phoneVerified to set.
       * @return This builder for chaining.
       */
      public Builder setPhoneVerified(boolean value) {

        phoneVerified_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether the phone number has been verified to be accessible by the user
       * (OTP or similar).
       * </pre>
       *
       * <code>bool phone_verified = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPhoneVerified() {
        bitField0_ = (bitField0_ & ~0x00000020);
        phoneVerified_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.recaptchaenterprise.v1beta1.TransactionData.User)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.recaptchaenterprise.v1beta1.TransactionData.User)
    private static final com.google.recaptchaenterprise.v1beta1.TransactionData.User
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.recaptchaenterprise.v1beta1.TransactionData.User();
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.User getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<User> PARSER =
        new com.google.protobuf.AbstractParser<User>() {
          @java.lang.Override
          public User parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<User> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<User> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.TransactionData.User getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ItemOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The full name of the item.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * The full name of the item.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * The value per item that the user is paying, in the transaction currency,
     * after discounts.
     * </pre>
     *
     * <code>double value = 2;</code>
     *
     * @return The value.
     */
    double getValue();

    /**
     *
     *
     * <pre>
     * The quantity of this item that is being purchased.
     * </pre>
     *
     * <code>int64 quantity = 3;</code>
     *
     * @return The quantity.
     */
    long getQuantity();

    /**
     *
     *
     * <pre>
     * When a merchant is specified, its corresponding account_id. Necessary to
     * populate marketplace-style transactions.
     * </pre>
     *
     * <code>string merchant_account_id = 4;</code>
     *
     * @return The merchantAccountId.
     */
    java.lang.String getMerchantAccountId();
    /**
     *
     *
     * <pre>
     * When a merchant is specified, its corresponding account_id. Necessary to
     * populate marketplace-style transactions.
     * </pre>
     *
     * <code>string merchant_account_id = 4;</code>
     *
     * @return The bytes for merchantAccountId.
     */
    com.google.protobuf.ByteString getMerchantAccountIdBytes();
  }
  /**
   *
   *
   * <pre>
   * Line items being purchased in this transaction.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item}
   */
  public static final class Item extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item)
      ItemOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Item.newBuilder() to construct.
    private Item(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Item() {
      name_ = "";
      merchantAccountId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Item();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionData_Item_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionData_Item_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.recaptchaenterprise.v1beta1.TransactionData.Item.class,
              com.google.recaptchaenterprise.v1beta1.TransactionData.Item.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The full name of the item.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of the item.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VALUE_FIELD_NUMBER = 2;
    private double value_ = 0D;
    /**
     *
     *
     * <pre>
     * The value per item that the user is paying, in the transaction currency,
     * after discounts.
     * </pre>
     *
     * <code>double value = 2;</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public double getValue() {
      return value_;
    }

    public static final int QUANTITY_FIELD_NUMBER = 3;
    private long quantity_ = 0L;
    /**
     *
     *
     * <pre>
     * The quantity of this item that is being purchased.
     * </pre>
     *
     * <code>int64 quantity = 3;</code>
     *
     * @return The quantity.
     */
    @java.lang.Override
    public long getQuantity() {
      return quantity_;
    }

    public static final int MERCHANT_ACCOUNT_ID_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object merchantAccountId_ = "";
    /**
     *
     *
     * <pre>
     * When a merchant is specified, its corresponding account_id. Necessary to
     * populate marketplace-style transactions.
     * </pre>
     *
     * <code>string merchant_account_id = 4;</code>
     *
     * @return The merchantAccountId.
     */
    @java.lang.Override
    public java.lang.String getMerchantAccountId() {
      java.lang.Object ref = merchantAccountId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        merchantAccountId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * When a merchant is specified, its corresponding account_id. Necessary to
     * populate marketplace-style transactions.
     * </pre>
     *
     * <code>string merchant_account_id = 4;</code>
     *
     * @return The bytes for merchantAccountId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMerchantAccountIdBytes() {
      java.lang.Object ref = merchantAccountId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        merchantAccountId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (java.lang.Double.doubleToRawLongBits(value_) != 0) {
        output.writeDouble(2, value_);
      }
      if (quantity_ != 0L) {
        output.writeInt64(3, quantity_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(merchantAccountId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, merchantAccountId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (java.lang.Double.doubleToRawLongBits(value_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, value_);
      }
      if (quantity_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, quantity_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(merchantAccountId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, merchantAccountId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.recaptchaenterprise.v1beta1.TransactionData.Item)) {
        return super.equals(obj);
      }
      com.google.recaptchaenterprise.v1beta1.TransactionData.Item other =
          (com.google.recaptchaenterprise.v1beta1.TransactionData.Item) obj;

      if (!getName().equals(other.getName())) return false;
      if (java.lang.Double.doubleToLongBits(getValue())
          != java.lang.Double.doubleToLongBits(other.getValue())) return false;
      if (getQuantity() != other.getQuantity()) return false;
      if (!getMerchantAccountId().equals(other.getMerchantAccountId())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getValue()));
      hash = (37 * hash) + QUANTITY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getQuantity());
      hash = (37 * hash) + MERCHANT_ACCOUNT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getMerchantAccountId().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.Item parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.Item parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.Item parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.Item parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.Item parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.Item parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.Item parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.Item parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.Item parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.Item parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.Item parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.Item parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.recaptchaenterprise.v1beta1.TransactionData.Item prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Line items being purchased in this transaction.
     * </pre>
     *
     * Protobuf type {@code google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item)
        com.google.recaptchaenterprise.v1beta1.TransactionData.ItemOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
            .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionData_Item_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
            .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionData_Item_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.recaptchaenterprise.v1beta1.TransactionData.Item.class,
                com.google.recaptchaenterprise.v1beta1.TransactionData.Item.Builder.class);
      }

      // Construct using com.google.recaptchaenterprise.v1beta1.TransactionData.Item.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        value_ = 0D;
        quantity_ = 0L;
        merchantAccountId_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
            .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionData_Item_descriptor;
      }

      @java.lang.Override
      public com.google.recaptchaenterprise.v1beta1.TransactionData.Item
          getDefaultInstanceForType() {
        return com.google.recaptchaenterprise.v1beta1.TransactionData.Item.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.recaptchaenterprise.v1beta1.TransactionData.Item build() {
        com.google.recaptchaenterprise.v1beta1.TransactionData.Item result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.recaptchaenterprise.v1beta1.TransactionData.Item buildPartial() {
        com.google.recaptchaenterprise.v1beta1.TransactionData.Item result =
            new com.google.recaptchaenterprise.v1beta1.TransactionData.Item(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.recaptchaenterprise.v1beta1.TransactionData.Item result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.value_ = value_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.quantity_ = quantity_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.merchantAccountId_ = merchantAccountId_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.recaptchaenterprise.v1beta1.TransactionData.Item) {
          return mergeFrom((com.google.recaptchaenterprise.v1beta1.TransactionData.Item) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.recaptchaenterprise.v1beta1.TransactionData.Item other) {
        if (other
            == com.google.recaptchaenterprise.v1beta1.TransactionData.Item.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getValue() != 0D) {
          setValue(other.getValue());
        }
        if (other.getQuantity() != 0L) {
          setQuantity(other.getQuantity());
        }
        if (!other.getMerchantAccountId().isEmpty()) {
          merchantAccountId_ = other.merchantAccountId_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 17:
                {
                  value_ = input.readDouble();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 17
              case 24:
                {
                  quantity_ = input.readInt64();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 34:
                {
                  merchantAccountId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * The full name of the item.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full name of the item.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full name of the item.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full name of the item.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full name of the item.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private double value_;
      /**
       *
       *
       * <pre>
       * The value per item that the user is paying, in the transaction currency,
       * after discounts.
       * </pre>
       *
       * <code>double value = 2;</code>
       *
       * @return The value.
       */
      @java.lang.Override
      public double getValue() {
        return value_;
      }
      /**
       *
       *
       * <pre>
       * The value per item that the user is paying, in the transaction currency,
       * after discounts.
       * </pre>
       *
       * <code>double value = 2;</code>
       *
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(double value) {

        value_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value per item that the user is paying, in the transaction currency,
       * after discounts.
       * </pre>
       *
       * <code>double value = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValue() {
        bitField0_ = (bitField0_ & ~0x00000002);
        value_ = 0D;
        onChanged();
        return this;
      }

      private long quantity_;
      /**
       *
       *
       * <pre>
       * The quantity of this item that is being purchased.
       * </pre>
       *
       * <code>int64 quantity = 3;</code>
       *
       * @return The quantity.
       */
      @java.lang.Override
      public long getQuantity() {
        return quantity_;
      }
      /**
       *
       *
       * <pre>
       * The quantity of this item that is being purchased.
       * </pre>
       *
       * <code>int64 quantity = 3;</code>
       *
       * @param value The quantity to set.
       * @return This builder for chaining.
       */
      public Builder setQuantity(long value) {

        quantity_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The quantity of this item that is being purchased.
       * </pre>
       *
       * <code>int64 quantity = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearQuantity() {
        bitField0_ = (bitField0_ & ~0x00000004);
        quantity_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object merchantAccountId_ = "";
      /**
       *
       *
       * <pre>
       * When a merchant is specified, its corresponding account_id. Necessary to
       * populate marketplace-style transactions.
       * </pre>
       *
       * <code>string merchant_account_id = 4;</code>
       *
       * @return The merchantAccountId.
       */
      public java.lang.String getMerchantAccountId() {
        java.lang.Object ref = merchantAccountId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          merchantAccountId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * When a merchant is specified, its corresponding account_id. Necessary to
       * populate marketplace-style transactions.
       * </pre>
       *
       * <code>string merchant_account_id = 4;</code>
       *
       * @return The bytes for merchantAccountId.
       */
      public com.google.protobuf.ByteString getMerchantAccountIdBytes() {
        java.lang.Object ref = merchantAccountId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          merchantAccountId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * When a merchant is specified, its corresponding account_id. Necessary to
       * populate marketplace-style transactions.
       * </pre>
       *
       * <code>string merchant_account_id = 4;</code>
       *
       * @param value The merchantAccountId to set.
       * @return This builder for chaining.
       */
      public Builder setMerchantAccountId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        merchantAccountId_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * When a merchant is specified, its corresponding account_id. Necessary to
       * populate marketplace-style transactions.
       * </pre>
       *
       * <code>string merchant_account_id = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMerchantAccountId() {
        merchantAccountId_ = getDefaultInstance().getMerchantAccountId();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * When a merchant is specified, its corresponding account_id. Necessary to
       * populate marketplace-style transactions.
       * </pre>
       *
       * <code>string merchant_account_id = 4;</code>
       *
       * @param value The bytes for merchantAccountId to set.
       * @return This builder for chaining.
       */
      public Builder setMerchantAccountIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        merchantAccountId_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item)
    private static final com.google.recaptchaenterprise.v1beta1.TransactionData.Item
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.recaptchaenterprise.v1beta1.TransactionData.Item();
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.Item getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Item> PARSER =
        new com.google.protobuf.AbstractParser<Item>() {
          @java.lang.Override
          public Item parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Item> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Item> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.TransactionData.Item getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GatewayInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Name of the gateway service (for example, stripe, square, paypal).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Name of the gateway service (for example, stripe, square, paypal).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Gateway response code describing the state of the transaction.
     * </pre>
     *
     * <code>string gateway_response_code = 2;</code>
     *
     * @return The gatewayResponseCode.
     */
    java.lang.String getGatewayResponseCode();
    /**
     *
     *
     * <pre>
     * Gateway response code describing the state of the transaction.
     * </pre>
     *
     * <code>string gateway_response_code = 2;</code>
     *
     * @return The bytes for gatewayResponseCode.
     */
    com.google.protobuf.ByteString getGatewayResponseCodeBytes();

    /**
     *
     *
     * <pre>
     * AVS response code from the gateway
     * (available only when reCAPTCHA Enterprise is called after authorization).
     * </pre>
     *
     * <code>string avs_response_code = 3;</code>
     *
     * @return The avsResponseCode.
     */
    java.lang.String getAvsResponseCode();
    /**
     *
     *
     * <pre>
     * AVS response code from the gateway
     * (available only when reCAPTCHA Enterprise is called after authorization).
     * </pre>
     *
     * <code>string avs_response_code = 3;</code>
     *
     * @return The bytes for avsResponseCode.
     */
    com.google.protobuf.ByteString getAvsResponseCodeBytes();

    /**
     *
     *
     * <pre>
     * CVV response code from the gateway
     * (available only when reCAPTCHA Enterprise is called after authorization).
     * </pre>
     *
     * <code>string cvv_response_code = 4;</code>
     *
     * @return The cvvResponseCode.
     */
    java.lang.String getCvvResponseCode();
    /**
     *
     *
     * <pre>
     * CVV response code from the gateway
     * (available only when reCAPTCHA Enterprise is called after authorization).
     * </pre>
     *
     * <code>string cvv_response_code = 4;</code>
     *
     * @return The bytes for cvvResponseCode.
     */
    com.google.protobuf.ByteString getCvvResponseCodeBytes();
  }
  /**
   *
   *
   * <pre>
   * Details about the transaction from the gateway.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo}
   */
  public static final class GatewayInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo)
      GatewayInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GatewayInfo.newBuilder() to construct.
    private GatewayInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GatewayInfo() {
      name_ = "";
      gatewayResponseCode_ = "";
      avsResponseCode_ = "";
      cvvResponseCode_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GatewayInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionData_GatewayInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionData_GatewayInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo.class,
              com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the gateway service (for example, stripe, square, paypal).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the gateway service (for example, stripe, square, paypal).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GATEWAY_RESPONSE_CODE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object gatewayResponseCode_ = "";
    /**
     *
     *
     * <pre>
     * Gateway response code describing the state of the transaction.
     * </pre>
     *
     * <code>string gateway_response_code = 2;</code>
     *
     * @return The gatewayResponseCode.
     */
    @java.lang.Override
    public java.lang.String getGatewayResponseCode() {
      java.lang.Object ref = gatewayResponseCode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gatewayResponseCode_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Gateway response code describing the state of the transaction.
     * </pre>
     *
     * <code>string gateway_response_code = 2;</code>
     *
     * @return The bytes for gatewayResponseCode.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGatewayResponseCodeBytes() {
      java.lang.Object ref = gatewayResponseCode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gatewayResponseCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int AVS_RESPONSE_CODE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object avsResponseCode_ = "";
    /**
     *
     *
     * <pre>
     * AVS response code from the gateway
     * (available only when reCAPTCHA Enterprise is called after authorization).
     * </pre>
     *
     * <code>string avs_response_code = 3;</code>
     *
     * @return The avsResponseCode.
     */
    @java.lang.Override
    public java.lang.String getAvsResponseCode() {
      java.lang.Object ref = avsResponseCode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        avsResponseCode_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * AVS response code from the gateway
     * (available only when reCAPTCHA Enterprise is called after authorization).
     * </pre>
     *
     * <code>string avs_response_code = 3;</code>
     *
     * @return The bytes for avsResponseCode.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAvsResponseCodeBytes() {
      java.lang.Object ref = avsResponseCode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        avsResponseCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CVV_RESPONSE_CODE_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object cvvResponseCode_ = "";
    /**
     *
     *
     * <pre>
     * CVV response code from the gateway
     * (available only when reCAPTCHA Enterprise is called after authorization).
     * </pre>
     *
     * <code>string cvv_response_code = 4;</code>
     *
     * @return The cvvResponseCode.
     */
    @java.lang.Override
    public java.lang.String getCvvResponseCode() {
      java.lang.Object ref = cvvResponseCode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cvvResponseCode_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * CVV response code from the gateway
     * (available only when reCAPTCHA Enterprise is called after authorization).
     * </pre>
     *
     * <code>string cvv_response_code = 4;</code>
     *
     * @return The bytes for cvvResponseCode.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCvvResponseCodeBytes() {
      java.lang.Object ref = cvvResponseCode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cvvResponseCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gatewayResponseCode_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, gatewayResponseCode_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(avsResponseCode_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, avsResponseCode_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cvvResponseCode_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, cvvResponseCode_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gatewayResponseCode_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, gatewayResponseCode_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(avsResponseCode_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, avsResponseCode_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cvvResponseCode_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, cvvResponseCode_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo)) {
        return super.equals(obj);
      }
      com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo other =
          (com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getGatewayResponseCode().equals(other.getGatewayResponseCode())) return false;
      if (!getAvsResponseCode().equals(other.getAvsResponseCode())) return false;
      if (!getCvvResponseCode().equals(other.getCvvResponseCode())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + GATEWAY_RESPONSE_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getGatewayResponseCode().hashCode();
      hash = (37 * hash) + AVS_RESPONSE_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getAvsResponseCode().hashCode();
      hash = (37 * hash) + CVV_RESPONSE_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getCvvResponseCode().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Details about the transaction from the gateway.
     * </pre>
     *
     * Protobuf type {@code google.cloud.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo)
        com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
            .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionData_GatewayInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
            .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionData_GatewayInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo.class,
                com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo.Builder.class);
      }

      // Construct using
      // com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        gatewayResponseCode_ = "";
        avsResponseCode_ = "";
        cvvResponseCode_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
            .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionData_GatewayInfo_descriptor;
      }

      @java.lang.Override
      public com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo
          getDefaultInstanceForType() {
        return com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo build() {
        com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo buildPartial() {
        com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo result =
            new com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.gatewayResponseCode_ = gatewayResponseCode_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.avsResponseCode_ = avsResponseCode_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.cvvResponseCode_ = cvvResponseCode_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo) {
          return mergeFrom(
              (com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo other) {
        if (other
            == com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo
                .getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getGatewayResponseCode().isEmpty()) {
          gatewayResponseCode_ = other.gatewayResponseCode_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getAvsResponseCode().isEmpty()) {
          avsResponseCode_ = other.avsResponseCode_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getCvvResponseCode().isEmpty()) {
          cvvResponseCode_ = other.cvvResponseCode_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  gatewayResponseCode_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  avsResponseCode_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  cvvResponseCode_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Name of the gateway service (for example, stripe, square, paypal).
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of the gateway service (for example, stripe, square, paypal).
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of the gateway service (for example, stripe, square, paypal).
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name of the gateway service (for example, stripe, square, paypal).
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name of the gateway service (for example, stripe, square, paypal).
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object gatewayResponseCode_ = "";
      /**
       *
       *
       * <pre>
       * Gateway response code describing the state of the transaction.
       * </pre>
       *
       * <code>string gateway_response_code = 2;</code>
       *
       * @return The gatewayResponseCode.
       */
      public java.lang.String getGatewayResponseCode() {
        java.lang.Object ref = gatewayResponseCode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          gatewayResponseCode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Gateway response code describing the state of the transaction.
       * </pre>
       *
       * <code>string gateway_response_code = 2;</code>
       *
       * @return The bytes for gatewayResponseCode.
       */
      public com.google.protobuf.ByteString getGatewayResponseCodeBytes() {
        java.lang.Object ref = gatewayResponseCode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          gatewayResponseCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Gateway response code describing the state of the transaction.
       * </pre>
       *
       * <code>string gateway_response_code = 2;</code>
       *
       * @param value The gatewayResponseCode to set.
       * @return This builder for chaining.
       */
      public Builder setGatewayResponseCode(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        gatewayResponseCode_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Gateway response code describing the state of the transaction.
       * </pre>
       *
       * <code>string gateway_response_code = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGatewayResponseCode() {
        gatewayResponseCode_ = getDefaultInstance().getGatewayResponseCode();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Gateway response code describing the state of the transaction.
       * </pre>
       *
       * <code>string gateway_response_code = 2;</code>
       *
       * @param value The bytes for gatewayResponseCode to set.
       * @return This builder for chaining.
       */
      public Builder setGatewayResponseCodeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        gatewayResponseCode_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object avsResponseCode_ = "";
      /**
       *
       *
       * <pre>
       * AVS response code from the gateway
       * (available only when reCAPTCHA Enterprise is called after authorization).
       * </pre>
       *
       * <code>string avs_response_code = 3;</code>
       *
       * @return The avsResponseCode.
       */
      public java.lang.String getAvsResponseCode() {
        java.lang.Object ref = avsResponseCode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          avsResponseCode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * AVS response code from the gateway
       * (available only when reCAPTCHA Enterprise is called after authorization).
       * </pre>
       *
       * <code>string avs_response_code = 3;</code>
       *
       * @return The bytes for avsResponseCode.
       */
      public com.google.protobuf.ByteString getAvsResponseCodeBytes() {
        java.lang.Object ref = avsResponseCode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          avsResponseCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * AVS response code from the gateway
       * (available only when reCAPTCHA Enterprise is called after authorization).
       * </pre>
       *
       * <code>string avs_response_code = 3;</code>
       *
       * @param value The avsResponseCode to set.
       * @return This builder for chaining.
       */
      public Builder setAvsResponseCode(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        avsResponseCode_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * AVS response code from the gateway
       * (available only when reCAPTCHA Enterprise is called after authorization).
       * </pre>
       *
       * <code>string avs_response_code = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAvsResponseCode() {
        avsResponseCode_ = getDefaultInstance().getAvsResponseCode();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * AVS response code from the gateway
       * (available only when reCAPTCHA Enterprise is called after authorization).
       * </pre>
       *
       * <code>string avs_response_code = 3;</code>
       *
       * @param value The bytes for avsResponseCode to set.
       * @return This builder for chaining.
       */
      public Builder setAvsResponseCodeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        avsResponseCode_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object cvvResponseCode_ = "";
      /**
       *
       *
       * <pre>
       * CVV response code from the gateway
       * (available only when reCAPTCHA Enterprise is called after authorization).
       * </pre>
       *
       * <code>string cvv_response_code = 4;</code>
       *
       * @return The cvvResponseCode.
       */
      public java.lang.String getCvvResponseCode() {
        java.lang.Object ref = cvvResponseCode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          cvvResponseCode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * CVV response code from the gateway
       * (available only when reCAPTCHA Enterprise is called after authorization).
       * </pre>
       *
       * <code>string cvv_response_code = 4;</code>
       *
       * @return The bytes for cvvResponseCode.
       */
      public com.google.protobuf.ByteString getCvvResponseCodeBytes() {
        java.lang.Object ref = cvvResponseCode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          cvvResponseCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * CVV response code from the gateway
       * (available only when reCAPTCHA Enterprise is called after authorization).
       * </pre>
       *
       * <code>string cvv_response_code = 4;</code>
       *
       * @param value The cvvResponseCode to set.
       * @return This builder for chaining.
       */
      public Builder setCvvResponseCode(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        cvvResponseCode_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * CVV response code from the gateway
       * (available only when reCAPTCHA Enterprise is called after authorization).
       * </pre>
       *
       * <code>string cvv_response_code = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCvvResponseCode() {
        cvvResponseCode_ = getDefaultInstance().getCvvResponseCode();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * CVV response code from the gateway
       * (available only when reCAPTCHA Enterprise is called after authorization).
       * </pre>
       *
       * <code>string cvv_response_code = 4;</code>
       *
       * @param value The bytes for cvvResponseCode to set.
       * @return This builder for chaining.
       */
      public Builder setCvvResponseCodeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        cvvResponseCode_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo)
    private static final com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo();
    }

    public static com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GatewayInfo> PARSER =
        new com.google.protobuf.AbstractParser<GatewayInfo>() {
          @java.lang.Override
          public GatewayInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GatewayInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GatewayInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int TRANSACTION_ID_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object transactionId_ = "";
  /**
   *
   *
   * <pre>
   * Unique identifier for the transaction. This custom identifier can be used
   * to reference this transaction in the future, for example, labeling a refund
   * or chargeback event. Two attempts at the same transaction should use the
   * same transaction id.
   * </pre>
   *
   * <code>optional string transaction_id = 11;</code>
   *
   * @return Whether the transactionId field is set.
   */
  @java.lang.Override
  public boolean hasTransactionId() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Unique identifier for the transaction. This custom identifier can be used
   * to reference this transaction in the future, for example, labeling a refund
   * or chargeback event. Two attempts at the same transaction should use the
   * same transaction id.
   * </pre>
   *
   * <code>optional string transaction_id = 11;</code>
   *
   * @return The transactionId.
   */
  @java.lang.Override
  public java.lang.String getTransactionId() {
    java.lang.Object ref = transactionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      transactionId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Unique identifier for the transaction. This custom identifier can be used
   * to reference this transaction in the future, for example, labeling a refund
   * or chargeback event. Two attempts at the same transaction should use the
   * same transaction id.
   * </pre>
   *
   * <code>optional string transaction_id = 11;</code>
   *
   * @return The bytes for transactionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTransactionIdBytes() {
    java.lang.Object ref = transactionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      transactionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAYMENT_METHOD_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object paymentMethod_ = "";
  /**
   *
   *
   * <pre>
   * The payment method for the transaction. The allowed values are:
   *
   * * credit-card
   * * debit-card
   * * gift-card
   * * processor-{name} (If a third-party is used, for example,
   * processor-paypal)
   * * custom-{name} (If an alternative method is used, for example,
   * custom-crypto)
   * </pre>
   *
   * <code>string payment_method = 1;</code>
   *
   * @return The paymentMethod.
   */
  @java.lang.Override
  public java.lang.String getPaymentMethod() {
    java.lang.Object ref = paymentMethod_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      paymentMethod_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The payment method for the transaction. The allowed values are:
   *
   * * credit-card
   * * debit-card
   * * gift-card
   * * processor-{name} (If a third-party is used, for example,
   * processor-paypal)
   * * custom-{name} (If an alternative method is used, for example,
   * custom-crypto)
   * </pre>
   *
   * <code>string payment_method = 1;</code>
   *
   * @return The bytes for paymentMethod.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPaymentMethodBytes() {
    java.lang.Object ref = paymentMethod_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      paymentMethod_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CARD_BIN_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cardBin_ = "";
  /**
   *
   *
   * <pre>
   * The Bank Identification Number - generally the first 6 or 8 digits of the
   * card.
   * </pre>
   *
   * <code>string card_bin = 2;</code>
   *
   * @return The cardBin.
   */
  @java.lang.Override
  public java.lang.String getCardBin() {
    java.lang.Object ref = cardBin_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cardBin_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Bank Identification Number - generally the first 6 or 8 digits of the
   * card.
   * </pre>
   *
   * <code>string card_bin = 2;</code>
   *
   * @return The bytes for cardBin.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCardBinBytes() {
    java.lang.Object ref = cardBin_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cardBin_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CARD_LAST_FOUR_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cardLastFour_ = "";
  /**
   *
   *
   * <pre>
   * The last four digits of the card.
   * </pre>
   *
   * <code>string card_last_four = 3;</code>
   *
   * @return The cardLastFour.
   */
  @java.lang.Override
  public java.lang.String getCardLastFour() {
    java.lang.Object ref = cardLastFour_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cardLastFour_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The last four digits of the card.
   * </pre>
   *
   * <code>string card_last_four = 3;</code>
   *
   * @return The bytes for cardLastFour.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCardLastFourBytes() {
    java.lang.Object ref = cardLastFour_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cardLastFour_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CURRENCY_CODE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object currencyCode_ = "";
  /**
   *
   *
   * <pre>
   * The currency code in ISO-4217 format.
   * </pre>
   *
   * <code>string currency_code = 4;</code>
   *
   * @return The currencyCode.
   */
  @java.lang.Override
  public java.lang.String getCurrencyCode() {
    java.lang.Object ref = currencyCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      currencyCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The currency code in ISO-4217 format.
   * </pre>
   *
   * <code>string currency_code = 4;</code>
   *
   * @return The bytes for currencyCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCurrencyCodeBytes() {
    java.lang.Object ref = currencyCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      currencyCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALUE_FIELD_NUMBER = 5;
  private double value_ = 0D;
  /**
   *
   *
   * <pre>
   * The decimal value of the transaction in the specified currency.
   * </pre>
   *
   * <code>double value = 5;</code>
   *
   * @return The value.
   */
  @java.lang.Override
  public double getValue() {
    return value_;
  }

  public static final int SHIPPING_VALUE_FIELD_NUMBER = 12;
  private double shippingValue_ = 0D;
  /**
   *
   *
   * <pre>
   * The value of shipping in the specified currency. 0 for free or no shipping.
   * </pre>
   *
   * <code>double shipping_value = 12;</code>
   *
   * @return The shippingValue.
   */
  @java.lang.Override
  public double getShippingValue() {
    return shippingValue_;
  }

  public static final int SHIPPING_ADDRESS_FIELD_NUMBER = 6;
  private com.google.recaptchaenterprise.v1beta1.TransactionData.Address shippingAddress_;
  /**
   *
   *
   * <pre>
   * Destination address if this transaction involves shipping a physical item.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address shipping_address = 6;
   * </code>
   *
   * @return Whether the shippingAddress field is set.
   */
  @java.lang.Override
  public boolean hasShippingAddress() {
    return shippingAddress_ != null;
  }
  /**
   *
   *
   * <pre>
   * Destination address if this transaction involves shipping a physical item.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address shipping_address = 6;
   * </code>
   *
   * @return The shippingAddress.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.TransactionData.Address getShippingAddress() {
    return shippingAddress_ == null
        ? com.google.recaptchaenterprise.v1beta1.TransactionData.Address.getDefaultInstance()
        : shippingAddress_;
  }
  /**
   *
   *
   * <pre>
   * Destination address if this transaction involves shipping a physical item.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address shipping_address = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.TransactionData.AddressOrBuilder
      getShippingAddressOrBuilder() {
    return shippingAddress_ == null
        ? com.google.recaptchaenterprise.v1beta1.TransactionData.Address.getDefaultInstance()
        : shippingAddress_;
  }

  public static final int BILLING_ADDRESS_FIELD_NUMBER = 7;
  private com.google.recaptchaenterprise.v1beta1.TransactionData.Address billingAddress_;
  /**
   *
   *
   * <pre>
   * Address associated with the payment method when applicable.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address billing_address = 7;
   * </code>
   *
   * @return Whether the billingAddress field is set.
   */
  @java.lang.Override
  public boolean hasBillingAddress() {
    return billingAddress_ != null;
  }
  /**
   *
   *
   * <pre>
   * Address associated with the payment method when applicable.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address billing_address = 7;
   * </code>
   *
   * @return The billingAddress.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.TransactionData.Address getBillingAddress() {
    return billingAddress_ == null
        ? com.google.recaptchaenterprise.v1beta1.TransactionData.Address.getDefaultInstance()
        : billingAddress_;
  }
  /**
   *
   *
   * <pre>
   * Address associated with the payment method when applicable.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address billing_address = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.TransactionData.AddressOrBuilder
      getBillingAddressOrBuilder() {
    return billingAddress_ == null
        ? com.google.recaptchaenterprise.v1beta1.TransactionData.Address.getDefaultInstance()
        : billingAddress_;
  }

  public static final int USER_FIELD_NUMBER = 8;
  private com.google.recaptchaenterprise.v1beta1.TransactionData.User user_;
  /**
   *
   *
   * <pre>
   * Information about the user paying/initiating the transaction.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.User user = 8;</code>
   *
   * @return Whether the user field is set.
   */
  @java.lang.Override
  public boolean hasUser() {
    return user_ != null;
  }
  /**
   *
   *
   * <pre>
   * Information about the user paying/initiating the transaction.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.User user = 8;</code>
   *
   * @return The user.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.TransactionData.User getUser() {
    return user_ == null
        ? com.google.recaptchaenterprise.v1beta1.TransactionData.User.getDefaultInstance()
        : user_;
  }
  /**
   *
   *
   * <pre>
   * Information about the user paying/initiating the transaction.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.User user = 8;</code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.TransactionData.UserOrBuilder getUserOrBuilder() {
    return user_ == null
        ? com.google.recaptchaenterprise.v1beta1.TransactionData.User.getDefaultInstance()
        : user_;
  }

  public static final int MERCHANTS_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private java.util.List<com.google.recaptchaenterprise.v1beta1.TransactionData.User> merchants_;
  /**
   *
   *
   * <pre>
   * Information about the user or users fulfilling the transaction.
   * </pre>
   *
   * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.User merchants = 13;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.recaptchaenterprise.v1beta1.TransactionData.User>
      getMerchantsList() {
    return merchants_;
  }
  /**
   *
   *
   * <pre>
   * Information about the user or users fulfilling the transaction.
   * </pre>
   *
   * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.User merchants = 13;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.recaptchaenterprise.v1beta1.TransactionData.UserOrBuilder>
      getMerchantsOrBuilderList() {
    return merchants_;
  }
  /**
   *
   *
   * <pre>
   * Information about the user or users fulfilling the transaction.
   * </pre>
   *
   * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.User merchants = 13;
   * </code>
   */
  @java.lang.Override
  public int getMerchantsCount() {
    return merchants_.size();
  }
  /**
   *
   *
   * <pre>
   * Information about the user or users fulfilling the transaction.
   * </pre>
   *
   * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.User merchants = 13;
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.TransactionData.User getMerchants(int index) {
    return merchants_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Information about the user or users fulfilling the transaction.
   * </pre>
   *
   * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.User merchants = 13;
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.TransactionData.UserOrBuilder getMerchantsOrBuilder(
      int index) {
    return merchants_.get(index);
  }

  public static final int ITEMS_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private java.util.List<com.google.recaptchaenterprise.v1beta1.TransactionData.Item> items_;
  /**
   *
   *
   * <pre>
   * Items purchased in this transaction.
   * </pre>
   *
   * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item items = 14;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.recaptchaenterprise.v1beta1.TransactionData.Item>
      getItemsList() {
    return items_;
  }
  /**
   *
   *
   * <pre>
   * Items purchased in this transaction.
   * </pre>
   *
   * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item items = 14;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.recaptchaenterprise.v1beta1.TransactionData.ItemOrBuilder>
      getItemsOrBuilderList() {
    return items_;
  }
  /**
   *
   *
   * <pre>
   * Items purchased in this transaction.
   * </pre>
   *
   * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item items = 14;
   * </code>
   */
  @java.lang.Override
  public int getItemsCount() {
    return items_.size();
  }
  /**
   *
   *
   * <pre>
   * Items purchased in this transaction.
   * </pre>
   *
   * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item items = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.TransactionData.Item getItems(int index) {
    return items_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Items purchased in this transaction.
   * </pre>
   *
   * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item items = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.TransactionData.ItemOrBuilder getItemsOrBuilder(
      int index) {
    return items_.get(index);
  }

  public static final int GATEWAY_INFO_FIELD_NUMBER = 10;
  private com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo gatewayInfo_;
  /**
   *
   *
   * <pre>
   * Information about the payment gateway's response to the transaction.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo gateway_info = 10;
   * </code>
   *
   * @return Whether the gatewayInfo field is set.
   */
  @java.lang.Override
  public boolean hasGatewayInfo() {
    return gatewayInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Information about the payment gateway's response to the transaction.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo gateway_info = 10;
   * </code>
   *
   * @return The gatewayInfo.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo getGatewayInfo() {
    return gatewayInfo_ == null
        ? com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo.getDefaultInstance()
        : gatewayInfo_;
  }
  /**
   *
   *
   * <pre>
   * Information about the payment gateway's response to the transaction.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo gateway_info = 10;
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfoOrBuilder
      getGatewayInfoOrBuilder() {
    return gatewayInfo_ == null
        ? com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo.getDefaultInstance()
        : gatewayInfo_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(paymentMethod_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, paymentMethod_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cardBin_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, cardBin_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cardLastFour_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, cardLastFour_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(currencyCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, currencyCode_);
    }
    if (java.lang.Double.doubleToRawLongBits(value_) != 0) {
      output.writeDouble(5, value_);
    }
    if (shippingAddress_ != null) {
      output.writeMessage(6, getShippingAddress());
    }
    if (billingAddress_ != null) {
      output.writeMessage(7, getBillingAddress());
    }
    if (user_ != null) {
      output.writeMessage(8, getUser());
    }
    if (gatewayInfo_ != null) {
      output.writeMessage(10, getGatewayInfo());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, transactionId_);
    }
    if (java.lang.Double.doubleToRawLongBits(shippingValue_) != 0) {
      output.writeDouble(12, shippingValue_);
    }
    for (int i = 0; i < merchants_.size(); i++) {
      output.writeMessage(13, merchants_.get(i));
    }
    for (int i = 0; i < items_.size(); i++) {
      output.writeMessage(14, items_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(paymentMethod_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, paymentMethod_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cardBin_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, cardBin_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cardLastFour_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, cardLastFour_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(currencyCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, currencyCode_);
    }
    if (java.lang.Double.doubleToRawLongBits(value_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(5, value_);
    }
    if (shippingAddress_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getShippingAddress());
    }
    if (billingAddress_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getBillingAddress());
    }
    if (user_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getUser());
    }
    if (gatewayInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getGatewayInfo());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, transactionId_);
    }
    if (java.lang.Double.doubleToRawLongBits(shippingValue_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(12, shippingValue_);
    }
    for (int i = 0; i < merchants_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, merchants_.get(i));
    }
    for (int i = 0; i < items_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, items_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.recaptchaenterprise.v1beta1.TransactionData)) {
      return super.equals(obj);
    }
    com.google.recaptchaenterprise.v1beta1.TransactionData other =
        (com.google.recaptchaenterprise.v1beta1.TransactionData) obj;

    if (hasTransactionId() != other.hasTransactionId()) return false;
    if (hasTransactionId()) {
      if (!getTransactionId().equals(other.getTransactionId())) return false;
    }
    if (!getPaymentMethod().equals(other.getPaymentMethod())) return false;
    if (!getCardBin().equals(other.getCardBin())) return false;
    if (!getCardLastFour().equals(other.getCardLastFour())) return false;
    if (!getCurrencyCode().equals(other.getCurrencyCode())) return false;
    if (java.lang.Double.doubleToLongBits(getValue())
        != java.lang.Double.doubleToLongBits(other.getValue())) return false;
    if (java.lang.Double.doubleToLongBits(getShippingValue())
        != java.lang.Double.doubleToLongBits(other.getShippingValue())) return false;
    if (hasShippingAddress() != other.hasShippingAddress()) return false;
    if (hasShippingAddress()) {
      if (!getShippingAddress().equals(other.getShippingAddress())) return false;
    }
    if (hasBillingAddress() != other.hasBillingAddress()) return false;
    if (hasBillingAddress()) {
      if (!getBillingAddress().equals(other.getBillingAddress())) return false;
    }
    if (hasUser() != other.hasUser()) return false;
    if (hasUser()) {
      if (!getUser().equals(other.getUser())) return false;
    }
    if (!getMerchantsList().equals(other.getMerchantsList())) return false;
    if (!getItemsList().equals(other.getItemsList())) return false;
    if (hasGatewayInfo() != other.hasGatewayInfo()) return false;
    if (hasGatewayInfo()) {
      if (!getGatewayInfo().equals(other.getGatewayInfo())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasTransactionId()) {
      hash = (37 * hash) + TRANSACTION_ID_FIELD_NUMBER;
      hash = (53 * hash) + getTransactionId().hashCode();
    }
    hash = (37 * hash) + PAYMENT_METHOD_FIELD_NUMBER;
    hash = (53 * hash) + getPaymentMethod().hashCode();
    hash = (37 * hash) + CARD_BIN_FIELD_NUMBER;
    hash = (53 * hash) + getCardBin().hashCode();
    hash = (37 * hash) + CARD_LAST_FOUR_FIELD_NUMBER;
    hash = (53 * hash) + getCardLastFour().hashCode();
    hash = (37 * hash) + CURRENCY_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getCurrencyCode().hashCode();
    hash = (37 * hash) + VALUE_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getValue()));
    hash = (37 * hash) + SHIPPING_VALUE_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getShippingValue()));
    if (hasShippingAddress()) {
      hash = (37 * hash) + SHIPPING_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getShippingAddress().hashCode();
    }
    if (hasBillingAddress()) {
      hash = (37 * hash) + BILLING_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getBillingAddress().hashCode();
    }
    if (hasUser()) {
      hash = (37 * hash) + USER_FIELD_NUMBER;
      hash = (53 * hash) + getUser().hashCode();
    }
    if (getMerchantsCount() > 0) {
      hash = (37 * hash) + MERCHANTS_FIELD_NUMBER;
      hash = (53 * hash) + getMerchantsList().hashCode();
    }
    if (getItemsCount() > 0) {
      hash = (37 * hash) + ITEMS_FIELD_NUMBER;
      hash = (53 * hash) + getItemsList().hashCode();
    }
    if (hasGatewayInfo()) {
      hash = (37 * hash) + GATEWAY_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getGatewayInfo().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.recaptchaenterprise.v1beta1.TransactionData parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1beta1.TransactionData parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.TransactionData parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1beta1.TransactionData parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.TransactionData parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1beta1.TransactionData parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.TransactionData parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1beta1.TransactionData parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.TransactionData parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1beta1.TransactionData parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.TransactionData parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1beta1.TransactionData parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.recaptchaenterprise.v1beta1.TransactionData prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Transaction data associated with a payment protected by reCAPTCHA Enterprise.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recaptchaenterprise.v1beta1.TransactionData}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.recaptchaenterprise.v1beta1.TransactionData)
      com.google.recaptchaenterprise.v1beta1.TransactionDataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionData_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.recaptchaenterprise.v1beta1.TransactionData.class,
              com.google.recaptchaenterprise.v1beta1.TransactionData.Builder.class);
    }

    // Construct using com.google.recaptchaenterprise.v1beta1.TransactionData.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      transactionId_ = "";
      paymentMethod_ = "";
      cardBin_ = "";
      cardLastFour_ = "";
      currencyCode_ = "";
      value_ = 0D;
      shippingValue_ = 0D;
      shippingAddress_ = null;
      if (shippingAddressBuilder_ != null) {
        shippingAddressBuilder_.dispose();
        shippingAddressBuilder_ = null;
      }
      billingAddress_ = null;
      if (billingAddressBuilder_ != null) {
        billingAddressBuilder_.dispose();
        billingAddressBuilder_ = null;
      }
      user_ = null;
      if (userBuilder_ != null) {
        userBuilder_.dispose();
        userBuilder_ = null;
      }
      if (merchantsBuilder_ == null) {
        merchants_ = java.util.Collections.emptyList();
      } else {
        merchants_ = null;
        merchantsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      if (itemsBuilder_ == null) {
        items_ = java.util.Collections.emptyList();
      } else {
        items_ = null;
        itemsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000800);
      gatewayInfo_ = null;
      if (gatewayInfoBuilder_ != null) {
        gatewayInfoBuilder_.dispose();
        gatewayInfoBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionData_descriptor;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.TransactionData getDefaultInstanceForType() {
      return com.google.recaptchaenterprise.v1beta1.TransactionData.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.TransactionData build() {
      com.google.recaptchaenterprise.v1beta1.TransactionData result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.TransactionData buildPartial() {
      com.google.recaptchaenterprise.v1beta1.TransactionData result =
          new com.google.recaptchaenterprise.v1beta1.TransactionData(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.recaptchaenterprise.v1beta1.TransactionData result) {
      if (merchantsBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          merchants_ = java.util.Collections.unmodifiableList(merchants_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.merchants_ = merchants_;
      } else {
        result.merchants_ = merchantsBuilder_.build();
      }
      if (itemsBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)) {
          items_ = java.util.Collections.unmodifiableList(items_);
          bitField0_ = (bitField0_ & ~0x00000800);
        }
        result.items_ = items_;
      } else {
        result.items_ = itemsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.recaptchaenterprise.v1beta1.TransactionData result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.transactionId_ = transactionId_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.paymentMethod_ = paymentMethod_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.cardBin_ = cardBin_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.cardLastFour_ = cardLastFour_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.currencyCode_ = currencyCode_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.value_ = value_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.shippingValue_ = shippingValue_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.shippingAddress_ =
            shippingAddressBuilder_ == null ? shippingAddress_ : shippingAddressBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.billingAddress_ =
            billingAddressBuilder_ == null ? billingAddress_ : billingAddressBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.user_ = userBuilder_ == null ? user_ : userBuilder_.build();
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.gatewayInfo_ =
            gatewayInfoBuilder_ == null ? gatewayInfo_ : gatewayInfoBuilder_.build();
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.recaptchaenterprise.v1beta1.TransactionData) {
        return mergeFrom((com.google.recaptchaenterprise.v1beta1.TransactionData) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.recaptchaenterprise.v1beta1.TransactionData other) {
      if (other == com.google.recaptchaenterprise.v1beta1.TransactionData.getDefaultInstance())
        return this;
      if (other.hasTransactionId()) {
        transactionId_ = other.transactionId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getPaymentMethod().isEmpty()) {
        paymentMethod_ = other.paymentMethod_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getCardBin().isEmpty()) {
        cardBin_ = other.cardBin_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getCardLastFour().isEmpty()) {
        cardLastFour_ = other.cardLastFour_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getCurrencyCode().isEmpty()) {
        currencyCode_ = other.currencyCode_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.getValue() != 0D) {
        setValue(other.getValue());
      }
      if (other.getShippingValue() != 0D) {
        setShippingValue(other.getShippingValue());
      }
      if (other.hasShippingAddress()) {
        mergeShippingAddress(other.getShippingAddress());
      }
      if (other.hasBillingAddress()) {
        mergeBillingAddress(other.getBillingAddress());
      }
      if (other.hasUser()) {
        mergeUser(other.getUser());
      }
      if (merchantsBuilder_ == null) {
        if (!other.merchants_.isEmpty()) {
          if (merchants_.isEmpty()) {
            merchants_ = other.merchants_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureMerchantsIsMutable();
            merchants_.addAll(other.merchants_);
          }
          onChanged();
        }
      } else {
        if (!other.merchants_.isEmpty()) {
          if (merchantsBuilder_.isEmpty()) {
            merchantsBuilder_.dispose();
            merchantsBuilder_ = null;
            merchants_ = other.merchants_;
            bitField0_ = (bitField0_ & ~0x00000400);
            merchantsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMerchantsFieldBuilder()
                    : null;
          } else {
            merchantsBuilder_.addAllMessages(other.merchants_);
          }
        }
      }
      if (itemsBuilder_ == null) {
        if (!other.items_.isEmpty()) {
          if (items_.isEmpty()) {
            items_ = other.items_;
            bitField0_ = (bitField0_ & ~0x00000800);
          } else {
            ensureItemsIsMutable();
            items_.addAll(other.items_);
          }
          onChanged();
        }
      } else {
        if (!other.items_.isEmpty()) {
          if (itemsBuilder_.isEmpty()) {
            itemsBuilder_.dispose();
            itemsBuilder_ = null;
            items_ = other.items_;
            bitField0_ = (bitField0_ & ~0x00000800);
            itemsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getItemsFieldBuilder()
                    : null;
          } else {
            itemsBuilder_.addAllMessages(other.items_);
          }
        }
      }
      if (other.hasGatewayInfo()) {
        mergeGatewayInfo(other.getGatewayInfo());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                paymentMethod_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                cardBin_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                cardLastFour_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                currencyCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 41:
              {
                value_ = input.readDouble();
                bitField0_ |= 0x00000020;
                break;
              } // case 41
            case 50:
              {
                input.readMessage(getShippingAddressFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getBillingAddressFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getUserFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 66
            case 82:
              {
                input.readMessage(getGatewayInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 82
            case 90:
              {
                transactionId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 90
            case 97:
              {
                shippingValue_ = input.readDouble();
                bitField0_ |= 0x00000040;
                break;
              } // case 97
            case 106:
              {
                com.google.recaptchaenterprise.v1beta1.TransactionData.User m =
                    input.readMessage(
                        com.google.recaptchaenterprise.v1beta1.TransactionData.User.parser(),
                        extensionRegistry);
                if (merchantsBuilder_ == null) {
                  ensureMerchantsIsMutable();
                  merchants_.add(m);
                } else {
                  merchantsBuilder_.addMessage(m);
                }
                break;
              } // case 106
            case 114:
              {
                com.google.recaptchaenterprise.v1beta1.TransactionData.Item m =
                    input.readMessage(
                        com.google.recaptchaenterprise.v1beta1.TransactionData.Item.parser(),
                        extensionRegistry);
                if (itemsBuilder_ == null) {
                  ensureItemsIsMutable();
                  items_.add(m);
                } else {
                  itemsBuilder_.addMessage(m);
                }
                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object transactionId_ = "";
    /**
     *
     *
     * <pre>
     * Unique identifier for the transaction. This custom identifier can be used
     * to reference this transaction in the future, for example, labeling a refund
     * or chargeback event. Two attempts at the same transaction should use the
     * same transaction id.
     * </pre>
     *
     * <code>optional string transaction_id = 11;</code>
     *
     * @return Whether the transactionId field is set.
     */
    public boolean hasTransactionId() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Unique identifier for the transaction. This custom identifier can be used
     * to reference this transaction in the future, for example, labeling a refund
     * or chargeback event. Two attempts at the same transaction should use the
     * same transaction id.
     * </pre>
     *
     * <code>optional string transaction_id = 11;</code>
     *
     * @return The transactionId.
     */
    public java.lang.String getTransactionId() {
      java.lang.Object ref = transactionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        transactionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier for the transaction. This custom identifier can be used
     * to reference this transaction in the future, for example, labeling a refund
     * or chargeback event. Two attempts at the same transaction should use the
     * same transaction id.
     * </pre>
     *
     * <code>optional string transaction_id = 11;</code>
     *
     * @return The bytes for transactionId.
     */
    public com.google.protobuf.ByteString getTransactionIdBytes() {
      java.lang.Object ref = transactionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        transactionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier for the transaction. This custom identifier can be used
     * to reference this transaction in the future, for example, labeling a refund
     * or chargeback event. Two attempts at the same transaction should use the
     * same transaction id.
     * </pre>
     *
     * <code>optional string transaction_id = 11;</code>
     *
     * @param value The transactionId to set.
     * @return This builder for chaining.
     */
    public Builder setTransactionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      transactionId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique identifier for the transaction. This custom identifier can be used
     * to reference this transaction in the future, for example, labeling a refund
     * or chargeback event. Two attempts at the same transaction should use the
     * same transaction id.
     * </pre>
     *
     * <code>optional string transaction_id = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransactionId() {
      transactionId_ = getDefaultInstance().getTransactionId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique identifier for the transaction. This custom identifier can be used
     * to reference this transaction in the future, for example, labeling a refund
     * or chargeback event. Two attempts at the same transaction should use the
     * same transaction id.
     * </pre>
     *
     * <code>optional string transaction_id = 11;</code>
     *
     * @param value The bytes for transactionId to set.
     * @return This builder for chaining.
     */
    public Builder setTransactionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      transactionId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object paymentMethod_ = "";
    /**
     *
     *
     * <pre>
     * The payment method for the transaction. The allowed values are:
     *
     * * credit-card
     * * debit-card
     * * gift-card
     * * processor-{name} (If a third-party is used, for example,
     * processor-paypal)
     * * custom-{name} (If an alternative method is used, for example,
     * custom-crypto)
     * </pre>
     *
     * <code>string payment_method = 1;</code>
     *
     * @return The paymentMethod.
     */
    public java.lang.String getPaymentMethod() {
      java.lang.Object ref = paymentMethod_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        paymentMethod_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The payment method for the transaction. The allowed values are:
     *
     * * credit-card
     * * debit-card
     * * gift-card
     * * processor-{name} (If a third-party is used, for example,
     * processor-paypal)
     * * custom-{name} (If an alternative method is used, for example,
     * custom-crypto)
     * </pre>
     *
     * <code>string payment_method = 1;</code>
     *
     * @return The bytes for paymentMethod.
     */
    public com.google.protobuf.ByteString getPaymentMethodBytes() {
      java.lang.Object ref = paymentMethod_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        paymentMethod_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The payment method for the transaction. The allowed values are:
     *
     * * credit-card
     * * debit-card
     * * gift-card
     * * processor-{name} (If a third-party is used, for example,
     * processor-paypal)
     * * custom-{name} (If an alternative method is used, for example,
     * custom-crypto)
     * </pre>
     *
     * <code>string payment_method = 1;</code>
     *
     * @param value The paymentMethod to set.
     * @return This builder for chaining.
     */
    public Builder setPaymentMethod(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      paymentMethod_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The payment method for the transaction. The allowed values are:
     *
     * * credit-card
     * * debit-card
     * * gift-card
     * * processor-{name} (If a third-party is used, for example,
     * processor-paypal)
     * * custom-{name} (If an alternative method is used, for example,
     * custom-crypto)
     * </pre>
     *
     * <code>string payment_method = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPaymentMethod() {
      paymentMethod_ = getDefaultInstance().getPaymentMethod();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The payment method for the transaction. The allowed values are:
     *
     * * credit-card
     * * debit-card
     * * gift-card
     * * processor-{name} (If a third-party is used, for example,
     * processor-paypal)
     * * custom-{name} (If an alternative method is used, for example,
     * custom-crypto)
     * </pre>
     *
     * <code>string payment_method = 1;</code>
     *
     * @param value The bytes for paymentMethod to set.
     * @return This builder for chaining.
     */
    public Builder setPaymentMethodBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      paymentMethod_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object cardBin_ = "";
    /**
     *
     *
     * <pre>
     * The Bank Identification Number - generally the first 6 or 8 digits of the
     * card.
     * </pre>
     *
     * <code>string card_bin = 2;</code>
     *
     * @return The cardBin.
     */
    public java.lang.String getCardBin() {
      java.lang.Object ref = cardBin_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cardBin_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Bank Identification Number - generally the first 6 or 8 digits of the
     * card.
     * </pre>
     *
     * <code>string card_bin = 2;</code>
     *
     * @return The bytes for cardBin.
     */
    public com.google.protobuf.ByteString getCardBinBytes() {
      java.lang.Object ref = cardBin_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cardBin_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Bank Identification Number - generally the first 6 or 8 digits of the
     * card.
     * </pre>
     *
     * <code>string card_bin = 2;</code>
     *
     * @param value The cardBin to set.
     * @return This builder for chaining.
     */
    public Builder setCardBin(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cardBin_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Bank Identification Number - generally the first 6 or 8 digits of the
     * card.
     * </pre>
     *
     * <code>string card_bin = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCardBin() {
      cardBin_ = getDefaultInstance().getCardBin();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Bank Identification Number - generally the first 6 or 8 digits of the
     * card.
     * </pre>
     *
     * <code>string card_bin = 2;</code>
     *
     * @param value The bytes for cardBin to set.
     * @return This builder for chaining.
     */
    public Builder setCardBinBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cardBin_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object cardLastFour_ = "";
    /**
     *
     *
     * <pre>
     * The last four digits of the card.
     * </pre>
     *
     * <code>string card_last_four = 3;</code>
     *
     * @return The cardLastFour.
     */
    public java.lang.String getCardLastFour() {
      java.lang.Object ref = cardLastFour_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cardLastFour_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The last four digits of the card.
     * </pre>
     *
     * <code>string card_last_four = 3;</code>
     *
     * @return The bytes for cardLastFour.
     */
    public com.google.protobuf.ByteString getCardLastFourBytes() {
      java.lang.Object ref = cardLastFour_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cardLastFour_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The last four digits of the card.
     * </pre>
     *
     * <code>string card_last_four = 3;</code>
     *
     * @param value The cardLastFour to set.
     * @return This builder for chaining.
     */
    public Builder setCardLastFour(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cardLastFour_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The last four digits of the card.
     * </pre>
     *
     * <code>string card_last_four = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCardLastFour() {
      cardLastFour_ = getDefaultInstance().getCardLastFour();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The last four digits of the card.
     * </pre>
     *
     * <code>string card_last_four = 3;</code>
     *
     * @param value The bytes for cardLastFour to set.
     * @return This builder for chaining.
     */
    public Builder setCardLastFourBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cardLastFour_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object currencyCode_ = "";
    /**
     *
     *
     * <pre>
     * The currency code in ISO-4217 format.
     * </pre>
     *
     * <code>string currency_code = 4;</code>
     *
     * @return The currencyCode.
     */
    public java.lang.String getCurrencyCode() {
      java.lang.Object ref = currencyCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        currencyCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The currency code in ISO-4217 format.
     * </pre>
     *
     * <code>string currency_code = 4;</code>
     *
     * @return The bytes for currencyCode.
     */
    public com.google.protobuf.ByteString getCurrencyCodeBytes() {
      java.lang.Object ref = currencyCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        currencyCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The currency code in ISO-4217 format.
     * </pre>
     *
     * <code>string currency_code = 4;</code>
     *
     * @param value The currencyCode to set.
     * @return This builder for chaining.
     */
    public Builder setCurrencyCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      currencyCode_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The currency code in ISO-4217 format.
     * </pre>
     *
     * <code>string currency_code = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCurrencyCode() {
      currencyCode_ = getDefaultInstance().getCurrencyCode();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The currency code in ISO-4217 format.
     * </pre>
     *
     * <code>string currency_code = 4;</code>
     *
     * @param value The bytes for currencyCode to set.
     * @return This builder for chaining.
     */
    public Builder setCurrencyCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      currencyCode_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private double value_;
    /**
     *
     *
     * <pre>
     * The decimal value of the transaction in the specified currency.
     * </pre>
     *
     * <code>double value = 5;</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public double getValue() {
      return value_;
    }
    /**
     *
     *
     * <pre>
     * The decimal value of the transaction in the specified currency.
     * </pre>
     *
     * <code>double value = 5;</code>
     *
     * @param value The value to set.
     * @return This builder for chaining.
     */
    public Builder setValue(double value) {

      value_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The decimal value of the transaction in the specified currency.
     * </pre>
     *
     * <code>double value = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValue() {
      bitField0_ = (bitField0_ & ~0x00000020);
      value_ = 0D;
      onChanged();
      return this;
    }

    private double shippingValue_;
    /**
     *
     *
     * <pre>
     * The value of shipping in the specified currency. 0 for free or no shipping.
     * </pre>
     *
     * <code>double shipping_value = 12;</code>
     *
     * @return The shippingValue.
     */
    @java.lang.Override
    public double getShippingValue() {
      return shippingValue_;
    }
    /**
     *
     *
     * <pre>
     * The value of shipping in the specified currency. 0 for free or no shipping.
     * </pre>
     *
     * <code>double shipping_value = 12;</code>
     *
     * @param value The shippingValue to set.
     * @return This builder for chaining.
     */
    public Builder setShippingValue(double value) {

      shippingValue_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The value of shipping in the specified currency. 0 for free or no shipping.
     * </pre>
     *
     * <code>double shipping_value = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearShippingValue() {
      bitField0_ = (bitField0_ & ~0x00000040);
      shippingValue_ = 0D;
      onChanged();
      return this;
    }

    private com.google.recaptchaenterprise.v1beta1.TransactionData.Address shippingAddress_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.TransactionData.Address,
            com.google.recaptchaenterprise.v1beta1.TransactionData.Address.Builder,
            com.google.recaptchaenterprise.v1beta1.TransactionData.AddressOrBuilder>
        shippingAddressBuilder_;
    /**
     *
     *
     * <pre>
     * Destination address if this transaction involves shipping a physical item.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address shipping_address = 6;
     * </code>
     *
     * @return Whether the shippingAddress field is set.
     */
    public boolean hasShippingAddress() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Destination address if this transaction involves shipping a physical item.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address shipping_address = 6;
     * </code>
     *
     * @return The shippingAddress.
     */
    public com.google.recaptchaenterprise.v1beta1.TransactionData.Address getShippingAddress() {
      if (shippingAddressBuilder_ == null) {
        return shippingAddress_ == null
            ? com.google.recaptchaenterprise.v1beta1.TransactionData.Address.getDefaultInstance()
            : shippingAddress_;
      } else {
        return shippingAddressBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Destination address if this transaction involves shipping a physical item.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address shipping_address = 6;
     * </code>
     */
    public Builder setShippingAddress(
        com.google.recaptchaenterprise.v1beta1.TransactionData.Address value) {
      if (shippingAddressBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        shippingAddress_ = value;
      } else {
        shippingAddressBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination address if this transaction involves shipping a physical item.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address shipping_address = 6;
     * </code>
     */
    public Builder setShippingAddress(
        com.google.recaptchaenterprise.v1beta1.TransactionData.Address.Builder builderForValue) {
      if (shippingAddressBuilder_ == null) {
        shippingAddress_ = builderForValue.build();
      } else {
        shippingAddressBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination address if this transaction involves shipping a physical item.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address shipping_address = 6;
     * </code>
     */
    public Builder mergeShippingAddress(
        com.google.recaptchaenterprise.v1beta1.TransactionData.Address value) {
      if (shippingAddressBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && shippingAddress_ != null
            && shippingAddress_
                != com.google.recaptchaenterprise.v1beta1.TransactionData.Address
                    .getDefaultInstance()) {
          getShippingAddressBuilder().mergeFrom(value);
        } else {
          shippingAddress_ = value;
        }
      } else {
        shippingAddressBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination address if this transaction involves shipping a physical item.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address shipping_address = 6;
     * </code>
     */
    public Builder clearShippingAddress() {
      bitField0_ = (bitField0_ & ~0x00000080);
      shippingAddress_ = null;
      if (shippingAddressBuilder_ != null) {
        shippingAddressBuilder_.dispose();
        shippingAddressBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination address if this transaction involves shipping a physical item.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address shipping_address = 6;
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.TransactionData.Address.Builder
        getShippingAddressBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getShippingAddressFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Destination address if this transaction involves shipping a physical item.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address shipping_address = 6;
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.TransactionData.AddressOrBuilder
        getShippingAddressOrBuilder() {
      if (shippingAddressBuilder_ != null) {
        return shippingAddressBuilder_.getMessageOrBuilder();
      } else {
        return shippingAddress_ == null
            ? com.google.recaptchaenterprise.v1beta1.TransactionData.Address.getDefaultInstance()
            : shippingAddress_;
      }
    }
    /**
     *
     *
     * <pre>
     * Destination address if this transaction involves shipping a physical item.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address shipping_address = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.TransactionData.Address,
            com.google.recaptchaenterprise.v1beta1.TransactionData.Address.Builder,
            com.google.recaptchaenterprise.v1beta1.TransactionData.AddressOrBuilder>
        getShippingAddressFieldBuilder() {
      if (shippingAddressBuilder_ == null) {
        shippingAddressBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1beta1.TransactionData.Address,
                com.google.recaptchaenterprise.v1beta1.TransactionData.Address.Builder,
                com.google.recaptchaenterprise.v1beta1.TransactionData.AddressOrBuilder>(
                getShippingAddress(), getParentForChildren(), isClean());
        shippingAddress_ = null;
      }
      return shippingAddressBuilder_;
    }

    private com.google.recaptchaenterprise.v1beta1.TransactionData.Address billingAddress_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.TransactionData.Address,
            com.google.recaptchaenterprise.v1beta1.TransactionData.Address.Builder,
            com.google.recaptchaenterprise.v1beta1.TransactionData.AddressOrBuilder>
        billingAddressBuilder_;
    /**
     *
     *
     * <pre>
     * Address associated with the payment method when applicable.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address billing_address = 7;
     * </code>
     *
     * @return Whether the billingAddress field is set.
     */
    public boolean hasBillingAddress() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Address associated with the payment method when applicable.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address billing_address = 7;
     * </code>
     *
     * @return The billingAddress.
     */
    public com.google.recaptchaenterprise.v1beta1.TransactionData.Address getBillingAddress() {
      if (billingAddressBuilder_ == null) {
        return billingAddress_ == null
            ? com.google.recaptchaenterprise.v1beta1.TransactionData.Address.getDefaultInstance()
            : billingAddress_;
      } else {
        return billingAddressBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Address associated with the payment method when applicable.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address billing_address = 7;
     * </code>
     */
    public Builder setBillingAddress(
        com.google.recaptchaenterprise.v1beta1.TransactionData.Address value) {
      if (billingAddressBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        billingAddress_ = value;
      } else {
        billingAddressBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Address associated with the payment method when applicable.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address billing_address = 7;
     * </code>
     */
    public Builder setBillingAddress(
        com.google.recaptchaenterprise.v1beta1.TransactionData.Address.Builder builderForValue) {
      if (billingAddressBuilder_ == null) {
        billingAddress_ = builderForValue.build();
      } else {
        billingAddressBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Address associated with the payment method when applicable.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address billing_address = 7;
     * </code>
     */
    public Builder mergeBillingAddress(
        com.google.recaptchaenterprise.v1beta1.TransactionData.Address value) {
      if (billingAddressBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && billingAddress_ != null
            && billingAddress_
                != com.google.recaptchaenterprise.v1beta1.TransactionData.Address
                    .getDefaultInstance()) {
          getBillingAddressBuilder().mergeFrom(value);
        } else {
          billingAddress_ = value;
        }
      } else {
        billingAddressBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Address associated with the payment method when applicable.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address billing_address = 7;
     * </code>
     */
    public Builder clearBillingAddress() {
      bitField0_ = (bitField0_ & ~0x00000100);
      billingAddress_ = null;
      if (billingAddressBuilder_ != null) {
        billingAddressBuilder_.dispose();
        billingAddressBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Address associated with the payment method when applicable.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address billing_address = 7;
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.TransactionData.Address.Builder
        getBillingAddressBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getBillingAddressFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Address associated with the payment method when applicable.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address billing_address = 7;
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.TransactionData.AddressOrBuilder
        getBillingAddressOrBuilder() {
      if (billingAddressBuilder_ != null) {
        return billingAddressBuilder_.getMessageOrBuilder();
      } else {
        return billingAddress_ == null
            ? com.google.recaptchaenterprise.v1beta1.TransactionData.Address.getDefaultInstance()
            : billingAddress_;
      }
    }
    /**
     *
     *
     * <pre>
     * Address associated with the payment method when applicable.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.Address billing_address = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.TransactionData.Address,
            com.google.recaptchaenterprise.v1beta1.TransactionData.Address.Builder,
            com.google.recaptchaenterprise.v1beta1.TransactionData.AddressOrBuilder>
        getBillingAddressFieldBuilder() {
      if (billingAddressBuilder_ == null) {
        billingAddressBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1beta1.TransactionData.Address,
                com.google.recaptchaenterprise.v1beta1.TransactionData.Address.Builder,
                com.google.recaptchaenterprise.v1beta1.TransactionData.AddressOrBuilder>(
                getBillingAddress(), getParentForChildren(), isClean());
        billingAddress_ = null;
      }
      return billingAddressBuilder_;
    }

    private com.google.recaptchaenterprise.v1beta1.TransactionData.User user_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.TransactionData.User,
            com.google.recaptchaenterprise.v1beta1.TransactionData.User.Builder,
            com.google.recaptchaenterprise.v1beta1.TransactionData.UserOrBuilder>
        userBuilder_;
    /**
     *
     *
     * <pre>
     * Information about the user paying/initiating the transaction.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.User user = 8;</code>
     *
     * @return Whether the user field is set.
     */
    public boolean hasUser() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Information about the user paying/initiating the transaction.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.User user = 8;</code>
     *
     * @return The user.
     */
    public com.google.recaptchaenterprise.v1beta1.TransactionData.User getUser() {
      if (userBuilder_ == null) {
        return user_ == null
            ? com.google.recaptchaenterprise.v1beta1.TransactionData.User.getDefaultInstance()
            : user_;
      } else {
        return userBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the user paying/initiating the transaction.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.User user = 8;</code>
     */
    public Builder setUser(com.google.recaptchaenterprise.v1beta1.TransactionData.User value) {
      if (userBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        user_ = value;
      } else {
        userBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the user paying/initiating the transaction.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.User user = 8;</code>
     */
    public Builder setUser(
        com.google.recaptchaenterprise.v1beta1.TransactionData.User.Builder builderForValue) {
      if (userBuilder_ == null) {
        user_ = builderForValue.build();
      } else {
        userBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the user paying/initiating the transaction.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.User user = 8;</code>
     */
    public Builder mergeUser(com.google.recaptchaenterprise.v1beta1.TransactionData.User value) {
      if (userBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && user_ != null
            && user_
                != com.google.recaptchaenterprise.v1beta1.TransactionData.User
                    .getDefaultInstance()) {
          getUserBuilder().mergeFrom(value);
        } else {
          user_ = value;
        }
      } else {
        userBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the user paying/initiating the transaction.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.User user = 8;</code>
     */
    public Builder clearUser() {
      bitField0_ = (bitField0_ & ~0x00000200);
      user_ = null;
      if (userBuilder_ != null) {
        userBuilder_.dispose();
        userBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the user paying/initiating the transaction.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.User user = 8;</code>
     */
    public com.google.recaptchaenterprise.v1beta1.TransactionData.User.Builder getUserBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getUserFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Information about the user paying/initiating the transaction.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.User user = 8;</code>
     */
    public com.google.recaptchaenterprise.v1beta1.TransactionData.UserOrBuilder getUserOrBuilder() {
      if (userBuilder_ != null) {
        return userBuilder_.getMessageOrBuilder();
      } else {
        return user_ == null
            ? com.google.recaptchaenterprise.v1beta1.TransactionData.User.getDefaultInstance()
            : user_;
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the user paying/initiating the transaction.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.TransactionData.User user = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.TransactionData.User,
            com.google.recaptchaenterprise.v1beta1.TransactionData.User.Builder,
            com.google.recaptchaenterprise.v1beta1.TransactionData.UserOrBuilder>
        getUserFieldBuilder() {
      if (userBuilder_ == null) {
        userBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1beta1.TransactionData.User,
                com.google.recaptchaenterprise.v1beta1.TransactionData.User.Builder,
                com.google.recaptchaenterprise.v1beta1.TransactionData.UserOrBuilder>(
                getUser(), getParentForChildren(), isClean());
        user_ = null;
      }
      return userBuilder_;
    }

    private java.util.List<com.google.recaptchaenterprise.v1beta1.TransactionData.User> merchants_ =
        java.util.Collections.emptyList();

    private void ensureMerchantsIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        merchants_ =
            new java.util.ArrayList<com.google.recaptchaenterprise.v1beta1.TransactionData.User>(
                merchants_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.TransactionData.User,
            com.google.recaptchaenterprise.v1beta1.TransactionData.User.Builder,
            com.google.recaptchaenterprise.v1beta1.TransactionData.UserOrBuilder>
        merchantsBuilder_;

    /**
     *
     *
     * <pre>
     * Information about the user or users fulfilling the transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.User merchants = 13;
     * </code>
     */
    public java.util.List<com.google.recaptchaenterprise.v1beta1.TransactionData.User>
        getMerchantsList() {
      if (merchantsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(merchants_);
      } else {
        return merchantsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the user or users fulfilling the transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.User merchants = 13;
     * </code>
     */
    public int getMerchantsCount() {
      if (merchantsBuilder_ == null) {
        return merchants_.size();
      } else {
        return merchantsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the user or users fulfilling the transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.User merchants = 13;
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.TransactionData.User getMerchants(int index) {
      if (merchantsBuilder_ == null) {
        return merchants_.get(index);
      } else {
        return merchantsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the user or users fulfilling the transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.User merchants = 13;
     * </code>
     */
    public Builder setMerchants(
        int index, com.google.recaptchaenterprise.v1beta1.TransactionData.User value) {
      if (merchantsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMerchantsIsMutable();
        merchants_.set(index, value);
        onChanged();
      } else {
        merchantsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the user or users fulfilling the transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.User merchants = 13;
     * </code>
     */
    public Builder setMerchants(
        int index,
        com.google.recaptchaenterprise.v1beta1.TransactionData.User.Builder builderForValue) {
      if (merchantsBuilder_ == null) {
        ensureMerchantsIsMutable();
        merchants_.set(index, builderForValue.build());
        onChanged();
      } else {
        merchantsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the user or users fulfilling the transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.User merchants = 13;
     * </code>
     */
    public Builder addMerchants(com.google.recaptchaenterprise.v1beta1.TransactionData.User value) {
      if (merchantsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMerchantsIsMutable();
        merchants_.add(value);
        onChanged();
      } else {
        merchantsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the user or users fulfilling the transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.User merchants = 13;
     * </code>
     */
    public Builder addMerchants(
        int index, com.google.recaptchaenterprise.v1beta1.TransactionData.User value) {
      if (merchantsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMerchantsIsMutable();
        merchants_.add(index, value);
        onChanged();
      } else {
        merchantsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the user or users fulfilling the transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.User merchants = 13;
     * </code>
     */
    public Builder addMerchants(
        com.google.recaptchaenterprise.v1beta1.TransactionData.User.Builder builderForValue) {
      if (merchantsBuilder_ == null) {
        ensureMerchantsIsMutable();
        merchants_.add(builderForValue.build());
        onChanged();
      } else {
        merchantsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the user or users fulfilling the transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.User merchants = 13;
     * </code>
     */
    public Builder addMerchants(
        int index,
        com.google.recaptchaenterprise.v1beta1.TransactionData.User.Builder builderForValue) {
      if (merchantsBuilder_ == null) {
        ensureMerchantsIsMutable();
        merchants_.add(index, builderForValue.build());
        onChanged();
      } else {
        merchantsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the user or users fulfilling the transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.User merchants = 13;
     * </code>
     */
    public Builder addAllMerchants(
        java.lang.Iterable<? extends com.google.recaptchaenterprise.v1beta1.TransactionData.User>
            values) {
      if (merchantsBuilder_ == null) {
        ensureMerchantsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, merchants_);
        onChanged();
      } else {
        merchantsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the user or users fulfilling the transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.User merchants = 13;
     * </code>
     */
    public Builder clearMerchants() {
      if (merchantsBuilder_ == null) {
        merchants_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        merchantsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the user or users fulfilling the transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.User merchants = 13;
     * </code>
     */
    public Builder removeMerchants(int index) {
      if (merchantsBuilder_ == null) {
        ensureMerchantsIsMutable();
        merchants_.remove(index);
        onChanged();
      } else {
        merchantsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the user or users fulfilling the transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.User merchants = 13;
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.TransactionData.User.Builder getMerchantsBuilder(
        int index) {
      return getMerchantsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Information about the user or users fulfilling the transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.User merchants = 13;
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.TransactionData.UserOrBuilder
        getMerchantsOrBuilder(int index) {
      if (merchantsBuilder_ == null) {
        return merchants_.get(index);
      } else {
        return merchantsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the user or users fulfilling the transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.User merchants = 13;
     * </code>
     */
    public java.util.List<
            ? extends com.google.recaptchaenterprise.v1beta1.TransactionData.UserOrBuilder>
        getMerchantsOrBuilderList() {
      if (merchantsBuilder_ != null) {
        return merchantsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(merchants_);
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the user or users fulfilling the transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.User merchants = 13;
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.TransactionData.User.Builder
        addMerchantsBuilder() {
      return getMerchantsFieldBuilder()
          .addBuilder(
              com.google.recaptchaenterprise.v1beta1.TransactionData.User.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Information about the user or users fulfilling the transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.User merchants = 13;
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.TransactionData.User.Builder addMerchantsBuilder(
        int index) {
      return getMerchantsFieldBuilder()
          .addBuilder(
              index,
              com.google.recaptchaenterprise.v1beta1.TransactionData.User.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Information about the user or users fulfilling the transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.User merchants = 13;
     * </code>
     */
    public java.util.List<com.google.recaptchaenterprise.v1beta1.TransactionData.User.Builder>
        getMerchantsBuilderList() {
      return getMerchantsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.TransactionData.User,
            com.google.recaptchaenterprise.v1beta1.TransactionData.User.Builder,
            com.google.recaptchaenterprise.v1beta1.TransactionData.UserOrBuilder>
        getMerchantsFieldBuilder() {
      if (merchantsBuilder_ == null) {
        merchantsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.recaptchaenterprise.v1beta1.TransactionData.User,
                com.google.recaptchaenterprise.v1beta1.TransactionData.User.Builder,
                com.google.recaptchaenterprise.v1beta1.TransactionData.UserOrBuilder>(
                merchants_, ((bitField0_ & 0x00000400) != 0), getParentForChildren(), isClean());
        merchants_ = null;
      }
      return merchantsBuilder_;
    }

    private java.util.List<com.google.recaptchaenterprise.v1beta1.TransactionData.Item> items_ =
        java.util.Collections.emptyList();

    private void ensureItemsIsMutable() {
      if (!((bitField0_ & 0x00000800) != 0)) {
        items_ =
            new java.util.ArrayList<com.google.recaptchaenterprise.v1beta1.TransactionData.Item>(
                items_);
        bitField0_ |= 0x00000800;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.TransactionData.Item,
            com.google.recaptchaenterprise.v1beta1.TransactionData.Item.Builder,
            com.google.recaptchaenterprise.v1beta1.TransactionData.ItemOrBuilder>
        itemsBuilder_;

    /**
     *
     *
     * <pre>
     * Items purchased in this transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item items = 14;
     * </code>
     */
    public java.util.List<com.google.recaptchaenterprise.v1beta1.TransactionData.Item>
        getItemsList() {
      if (itemsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(items_);
      } else {
        return itemsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Items purchased in this transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item items = 14;
     * </code>
     */
    public int getItemsCount() {
      if (itemsBuilder_ == null) {
        return items_.size();
      } else {
        return itemsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Items purchased in this transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item items = 14;
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.TransactionData.Item getItems(int index) {
      if (itemsBuilder_ == null) {
        return items_.get(index);
      } else {
        return itemsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Items purchased in this transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item items = 14;
     * </code>
     */
    public Builder setItems(
        int index, com.google.recaptchaenterprise.v1beta1.TransactionData.Item value) {
      if (itemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureItemsIsMutable();
        items_.set(index, value);
        onChanged();
      } else {
        itemsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Items purchased in this transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item items = 14;
     * </code>
     */
    public Builder setItems(
        int index,
        com.google.recaptchaenterprise.v1beta1.TransactionData.Item.Builder builderForValue) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        items_.set(index, builderForValue.build());
        onChanged();
      } else {
        itemsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Items purchased in this transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item items = 14;
     * </code>
     */
    public Builder addItems(com.google.recaptchaenterprise.v1beta1.TransactionData.Item value) {
      if (itemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureItemsIsMutable();
        items_.add(value);
        onChanged();
      } else {
        itemsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Items purchased in this transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item items = 14;
     * </code>
     */
    public Builder addItems(
        int index, com.google.recaptchaenterprise.v1beta1.TransactionData.Item value) {
      if (itemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureItemsIsMutable();
        items_.add(index, value);
        onChanged();
      } else {
        itemsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Items purchased in this transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item items = 14;
     * </code>
     */
    public Builder addItems(
        com.google.recaptchaenterprise.v1beta1.TransactionData.Item.Builder builderForValue) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        items_.add(builderForValue.build());
        onChanged();
      } else {
        itemsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Items purchased in this transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item items = 14;
     * </code>
     */
    public Builder addItems(
        int index,
        com.google.recaptchaenterprise.v1beta1.TransactionData.Item.Builder builderForValue) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        items_.add(index, builderForValue.build());
        onChanged();
      } else {
        itemsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Items purchased in this transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item items = 14;
     * </code>
     */
    public Builder addAllItems(
        java.lang.Iterable<? extends com.google.recaptchaenterprise.v1beta1.TransactionData.Item>
            values) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, items_);
        onChanged();
      } else {
        itemsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Items purchased in this transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item items = 14;
     * </code>
     */
    public Builder clearItems() {
      if (itemsBuilder_ == null) {
        items_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000800);
        onChanged();
      } else {
        itemsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Items purchased in this transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item items = 14;
     * </code>
     */
    public Builder removeItems(int index) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        items_.remove(index);
        onChanged();
      } else {
        itemsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Items purchased in this transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item items = 14;
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.TransactionData.Item.Builder getItemsBuilder(
        int index) {
      return getItemsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Items purchased in this transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item items = 14;
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.TransactionData.ItemOrBuilder getItemsOrBuilder(
        int index) {
      if (itemsBuilder_ == null) {
        return items_.get(index);
      } else {
        return itemsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Items purchased in this transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item items = 14;
     * </code>
     */
    public java.util.List<
            ? extends com.google.recaptchaenterprise.v1beta1.TransactionData.ItemOrBuilder>
        getItemsOrBuilderList() {
      if (itemsBuilder_ != null) {
        return itemsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(items_);
      }
    }
    /**
     *
     *
     * <pre>
     * Items purchased in this transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item items = 14;
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.TransactionData.Item.Builder addItemsBuilder() {
      return getItemsFieldBuilder()
          .addBuilder(
              com.google.recaptchaenterprise.v1beta1.TransactionData.Item.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Items purchased in this transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item items = 14;
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.TransactionData.Item.Builder addItemsBuilder(
        int index) {
      return getItemsFieldBuilder()
          .addBuilder(
              index,
              com.google.recaptchaenterprise.v1beta1.TransactionData.Item.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Items purchased in this transaction.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1beta1.TransactionData.Item items = 14;
     * </code>
     */
    public java.util.List<com.google.recaptchaenterprise.v1beta1.TransactionData.Item.Builder>
        getItemsBuilderList() {
      return getItemsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.TransactionData.Item,
            com.google.recaptchaenterprise.v1beta1.TransactionData.Item.Builder,
            com.google.recaptchaenterprise.v1beta1.TransactionData.ItemOrBuilder>
        getItemsFieldBuilder() {
      if (itemsBuilder_ == null) {
        itemsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.recaptchaenterprise.v1beta1.TransactionData.Item,
                com.google.recaptchaenterprise.v1beta1.TransactionData.Item.Builder,
                com.google.recaptchaenterprise.v1beta1.TransactionData.ItemOrBuilder>(
                items_, ((bitField0_ & 0x00000800) != 0), getParentForChildren(), isClean());
        items_ = null;
      }
      return itemsBuilder_;
    }

    private com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo gatewayInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo,
            com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo.Builder,
            com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfoOrBuilder>
        gatewayInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Information about the payment gateway's response to the transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo gateway_info = 10;
     * </code>
     *
     * @return Whether the gatewayInfo field is set.
     */
    public boolean hasGatewayInfo() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Information about the payment gateway's response to the transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo gateway_info = 10;
     * </code>
     *
     * @return The gatewayInfo.
     */
    public com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo getGatewayInfo() {
      if (gatewayInfoBuilder_ == null) {
        return gatewayInfo_ == null
            ? com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo
                .getDefaultInstance()
            : gatewayInfo_;
      } else {
        return gatewayInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the payment gateway's response to the transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo gateway_info = 10;
     * </code>
     */
    public Builder setGatewayInfo(
        com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo value) {
      if (gatewayInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        gatewayInfo_ = value;
      } else {
        gatewayInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the payment gateway's response to the transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo gateway_info = 10;
     * </code>
     */
    public Builder setGatewayInfo(
        com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo.Builder
            builderForValue) {
      if (gatewayInfoBuilder_ == null) {
        gatewayInfo_ = builderForValue.build();
      } else {
        gatewayInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the payment gateway's response to the transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo gateway_info = 10;
     * </code>
     */
    public Builder mergeGatewayInfo(
        com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo value) {
      if (gatewayInfoBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && gatewayInfo_ != null
            && gatewayInfo_
                != com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo
                    .getDefaultInstance()) {
          getGatewayInfoBuilder().mergeFrom(value);
        } else {
          gatewayInfo_ = value;
        }
      } else {
        gatewayInfoBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the payment gateway's response to the transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo gateway_info = 10;
     * </code>
     */
    public Builder clearGatewayInfo() {
      bitField0_ = (bitField0_ & ~0x00001000);
      gatewayInfo_ = null;
      if (gatewayInfoBuilder_ != null) {
        gatewayInfoBuilder_.dispose();
        gatewayInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the payment gateway's response to the transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo gateway_info = 10;
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo.Builder
        getGatewayInfoBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getGatewayInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Information about the payment gateway's response to the transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo gateway_info = 10;
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfoOrBuilder
        getGatewayInfoOrBuilder() {
      if (gatewayInfoBuilder_ != null) {
        return gatewayInfoBuilder_.getMessageOrBuilder();
      } else {
        return gatewayInfo_ == null
            ? com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo
                .getDefaultInstance()
            : gatewayInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the payment gateway's response to the transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo gateway_info = 10;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo,
            com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo.Builder,
            com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfoOrBuilder>
        getGatewayInfoFieldBuilder() {
      if (gatewayInfoBuilder_ == null) {
        gatewayInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo,
                com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfo.Builder,
                com.google.recaptchaenterprise.v1beta1.TransactionData.GatewayInfoOrBuilder>(
                getGatewayInfo(), getParentForChildren(), isClean());
        gatewayInfo_ = null;
      }
      return gatewayInfoBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.recaptchaenterprise.v1beta1.TransactionData)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.recaptchaenterprise.v1beta1.TransactionData)
  private static final com.google.recaptchaenterprise.v1beta1.TransactionData DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.recaptchaenterprise.v1beta1.TransactionData();
  }

  public static com.google.recaptchaenterprise.v1beta1.TransactionData getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TransactionData> PARSER =
      new com.google.protobuf.AbstractParser<TransactionData>() {
        @java.lang.Override
        public TransactionData parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TransactionData> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TransactionData> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.TransactionData getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
