/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/recaptchaenterprise/v1beta1/recaptchaenterprise.proto

// Protobuf Java Version: 3.25.3
package com.google.recaptchaenterprise.v1beta1;

/**
 *
 *
 * <pre>
 * A reCAPTCHA Enterprise assessment resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.recaptchaenterprise.v1beta1.Assessment}
 */
public final class Assessment extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.recaptchaenterprise.v1beta1.Assessment)
    AssessmentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Assessment.newBuilder() to construct.
  private Assessment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Assessment() {
    name_ = "";
    reasons_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Assessment();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1beta1_Assessment_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1beta1_Assessment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.recaptchaenterprise.v1beta1.Assessment.class,
            com.google.recaptchaenterprise.v1beta1.Assessment.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Reasons contributing to the risk analysis verdict.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason}
   */
  public enum ClassificationReason implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default unspecified type.
     * </pre>
     *
     * <code>CLASSIFICATION_REASON_UNSPECIFIED = 0;</code>
     */
    CLASSIFICATION_REASON_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Interactions matched the behavior of an automated agent.
     * </pre>
     *
     * <code>AUTOMATION = 1;</code>
     */
    AUTOMATION(1),
    /**
     *
     *
     * <pre>
     * The event originated from an illegitimate environment.
     * </pre>
     *
     * <code>UNEXPECTED_ENVIRONMENT = 2;</code>
     */
    UNEXPECTED_ENVIRONMENT(2),
    /**
     *
     *
     * <pre>
     * Traffic volume from the event source is higher than normal.
     * </pre>
     *
     * <code>TOO_MUCH_TRAFFIC = 3;</code>
     */
    TOO_MUCH_TRAFFIC(3),
    /**
     *
     *
     * <pre>
     * Interactions with the site were significantly different than expected
     * patterns.
     * </pre>
     *
     * <code>UNEXPECTED_USAGE_PATTERNS = 4;</code>
     */
    UNEXPECTED_USAGE_PATTERNS(4),
    /**
     *
     *
     * <pre>
     * Too little traffic has been received from this site thus far to generate
     * quality risk analysis.
     * </pre>
     *
     * <code>LOW_CONFIDENCE_SCORE = 5;</code>
     */
    LOW_CONFIDENCE_SCORE(5),
    /**
     *
     *
     * <pre>
     * The request matches behavioral characteristics of a carding attack.
     * </pre>
     *
     * <code>SUSPECTED_CARDING = 6;</code>
     */
    SUSPECTED_CARDING(6),
    /**
     *
     *
     * <pre>
     * The request matches behavioral characteristics of chargebacks for fraud.
     * </pre>
     *
     * <code>SUSPECTED_CHARGEBACK = 7;</code>
     */
    SUSPECTED_CHARGEBACK(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default unspecified type.
     * </pre>
     *
     * <code>CLASSIFICATION_REASON_UNSPECIFIED = 0;</code>
     */
    public static final int CLASSIFICATION_REASON_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Interactions matched the behavior of an automated agent.
     * </pre>
     *
     * <code>AUTOMATION = 1;</code>
     */
    public static final int AUTOMATION_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The event originated from an illegitimate environment.
     * </pre>
     *
     * <code>UNEXPECTED_ENVIRONMENT = 2;</code>
     */
    public static final int UNEXPECTED_ENVIRONMENT_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Traffic volume from the event source is higher than normal.
     * </pre>
     *
     * <code>TOO_MUCH_TRAFFIC = 3;</code>
     */
    public static final int TOO_MUCH_TRAFFIC_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Interactions with the site were significantly different than expected
     * patterns.
     * </pre>
     *
     * <code>UNEXPECTED_USAGE_PATTERNS = 4;</code>
     */
    public static final int UNEXPECTED_USAGE_PATTERNS_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Too little traffic has been received from this site thus far to generate
     * quality risk analysis.
     * </pre>
     *
     * <code>LOW_CONFIDENCE_SCORE = 5;</code>
     */
    public static final int LOW_CONFIDENCE_SCORE_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The request matches behavioral characteristics of a carding attack.
     * </pre>
     *
     * <code>SUSPECTED_CARDING = 6;</code>
     */
    public static final int SUSPECTED_CARDING_VALUE = 6;
    /**
     *
     *
     * <pre>
     * The request matches behavioral characteristics of chargebacks for fraud.
     * </pre>
     *
     * <code>SUSPECTED_CHARGEBACK = 7;</code>
     */
    public static final int SUSPECTED_CHARGEBACK_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ClassificationReason valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ClassificationReason forNumber(int value) {
      switch (value) {
        case 0:
          return CLASSIFICATION_REASON_UNSPECIFIED;
        case 1:
          return AUTOMATION;
        case 2:
          return UNEXPECTED_ENVIRONMENT;
        case 3:
          return TOO_MUCH_TRAFFIC;
        case 4:
          return UNEXPECTED_USAGE_PATTERNS;
        case 5:
          return LOW_CONFIDENCE_SCORE;
        case 6:
          return SUSPECTED_CARDING;
        case 7:
          return SUSPECTED_CHARGEBACK;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ClassificationReason>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ClassificationReason>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ClassificationReason>() {
              public ClassificationReason findValueByNumber(int number) {
                return ClassificationReason.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1beta1.Assessment.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ClassificationReason[] VALUES = values();

    public static ClassificationReason valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ClassificationReason(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name for the Assessment in the format
   * `projects/{project_number}/assessments/{assessment_id}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name for the Assessment in the format
   * `projects/{project_number}/assessments/{assessment_id}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EVENT_FIELD_NUMBER = 2;
  private com.google.recaptchaenterprise.v1beta1.Event event_;
  /**
   *
   *
   * <pre>
   * The event being assessed.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.Event event = 2;</code>
   *
   * @return Whether the event field is set.
   */
  @java.lang.Override
  public boolean hasEvent() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The event being assessed.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.Event event = 2;</code>
   *
   * @return The event.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.Event getEvent() {
    return event_ == null
        ? com.google.recaptchaenterprise.v1beta1.Event.getDefaultInstance()
        : event_;
  }
  /**
   *
   *
   * <pre>
   * The event being assessed.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1beta1.Event event = 2;</code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.EventOrBuilder getEventOrBuilder() {
    return event_ == null
        ? com.google.recaptchaenterprise.v1beta1.Event.getDefaultInstance()
        : event_;
  }

  public static final int SCORE_FIELD_NUMBER = 3;
  private float score_ = 0F;
  /**
   *
   *
   * <pre>
   * Output only. Legitimate event score from 0.0 to 1.0.
   * (1.0 means very likely legitimate traffic while 0.0 means very likely
   * non-legitimate traffic).
   * </pre>
   *
   * <code>float score = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The score.
   */
  @java.lang.Override
  public float getScore() {
    return score_;
  }

  public static final int TOKEN_PROPERTIES_FIELD_NUMBER = 4;
  private com.google.recaptchaenterprise.v1beta1.TokenProperties tokenProperties_;
  /**
   *
   *
   * <pre>
   * Output only. Properties of the provided event token.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the tokenProperties field is set.
   */
  @java.lang.Override
  public boolean hasTokenProperties() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Properties of the provided event token.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The tokenProperties.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.TokenProperties getTokenProperties() {
    return tokenProperties_ == null
        ? com.google.recaptchaenterprise.v1beta1.TokenProperties.getDefaultInstance()
        : tokenProperties_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Properties of the provided event token.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.TokenPropertiesOrBuilder
      getTokenPropertiesOrBuilder() {
    return tokenProperties_ == null
        ? com.google.recaptchaenterprise.v1beta1.TokenProperties.getDefaultInstance()
        : tokenProperties_;
  }

  public static final int REASONS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> reasons_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason>
      reasons_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer,
              com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason>() {
            public com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason convert(
                java.lang.Integer from) {
              com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason result =
                  com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason.forNumber(
                      from);
              return result == null
                  ? com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason
                      .UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Output only. Reasons contributing to the risk analysis verdict.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the reasons.
   */
  @java.lang.Override
  public java.util.List<com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason>
      getReasonsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason>(
        reasons_, reasons_converter_);
  }
  /**
   *
   *
   * <pre>
   * Output only. Reasons contributing to the risk analysis verdict.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of reasons.
   */
  @java.lang.Override
  public int getReasonsCount() {
    return reasons_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Reasons contributing to the risk analysis verdict.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The reasons at the given index.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason getReasons(
      int index) {
    return reasons_converter_.convert(reasons_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Output only. Reasons contributing to the risk analysis verdict.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for reasons.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getReasonsValueList() {
    return reasons_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Reasons contributing to the risk analysis verdict.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of reasons at the given index.
   */
  @java.lang.Override
  public int getReasonsValue(int index) {
    return reasons_.get(index);
  }

  private int reasonsMemoizedSerializedSize;

  public static final int PASSWORD_LEAK_VERIFICATION_FIELD_NUMBER = 7;
  private com.google.recaptchaenterprise.v1beta1.PasswordLeakVerification passwordLeakVerification_;
  /**
   *
   *
   * <pre>
   * Information about the user's credentials used to check for leaks.
   * This feature is part of the Early Access Program (EAP). Exercise caution,
   * and do not deploy integrations based on this feature in a production
   * environment.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.PasswordLeakVerification password_leak_verification = 7;
   * </code>
   *
   * @return Whether the passwordLeakVerification field is set.
   */
  @java.lang.Override
  public boolean hasPasswordLeakVerification() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Information about the user's credentials used to check for leaks.
   * This feature is part of the Early Access Program (EAP). Exercise caution,
   * and do not deploy integrations based on this feature in a production
   * environment.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.PasswordLeakVerification password_leak_verification = 7;
   * </code>
   *
   * @return The passwordLeakVerification.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.PasswordLeakVerification
      getPasswordLeakVerification() {
    return passwordLeakVerification_ == null
        ? com.google.recaptchaenterprise.v1beta1.PasswordLeakVerification.getDefaultInstance()
        : passwordLeakVerification_;
  }
  /**
   *
   *
   * <pre>
   * Information about the user's credentials used to check for leaks.
   * This feature is part of the Early Access Program (EAP). Exercise caution,
   * and do not deploy integrations based on this feature in a production
   * environment.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.PasswordLeakVerification password_leak_verification = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.PasswordLeakVerificationOrBuilder
      getPasswordLeakVerificationOrBuilder() {
    return passwordLeakVerification_ == null
        ? com.google.recaptchaenterprise.v1beta1.PasswordLeakVerification.getDefaultInstance()
        : passwordLeakVerification_;
  }

  public static final int ACCOUNT_DEFENDER_ASSESSMENT_FIELD_NUMBER = 8;
  private com.google.recaptchaenterprise.v1beta1.AccountDefenderAssessment
      accountDefenderAssessment_;
  /**
   *
   *
   * <pre>
   * Assessment returned by account defender when a hashed_account_id is
   * provided.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.AccountDefenderAssessment account_defender_assessment = 8;
   * </code>
   *
   * @return Whether the accountDefenderAssessment field is set.
   */
  @java.lang.Override
  public boolean hasAccountDefenderAssessment() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Assessment returned by account defender when a hashed_account_id is
   * provided.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.AccountDefenderAssessment account_defender_assessment = 8;
   * </code>
   *
   * @return The accountDefenderAssessment.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.AccountDefenderAssessment
      getAccountDefenderAssessment() {
    return accountDefenderAssessment_ == null
        ? com.google.recaptchaenterprise.v1beta1.AccountDefenderAssessment.getDefaultInstance()
        : accountDefenderAssessment_;
  }
  /**
   *
   *
   * <pre>
   * Assessment returned by account defender when a hashed_account_id is
   * provided.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.AccountDefenderAssessment account_defender_assessment = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.AccountDefenderAssessmentOrBuilder
      getAccountDefenderAssessmentOrBuilder() {
    return accountDefenderAssessment_ == null
        ? com.google.recaptchaenterprise.v1beta1.AccountDefenderAssessment.getDefaultInstance()
        : accountDefenderAssessment_;
  }

  public static final int FRAUD_PREVENTION_ASSESSMENT_FIELD_NUMBER = 11;
  private com.google.recaptchaenterprise.v1beta1.FraudPreventionAssessment
      fraudPreventionAssessment_;
  /**
   *
   *
   * <pre>
   * Assessment returned by Fraud Prevention when TransactionData is provided.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.FraudPreventionAssessment fraud_prevention_assessment = 11;
   * </code>
   *
   * @return Whether the fraudPreventionAssessment field is set.
   */
  @java.lang.Override
  public boolean hasFraudPreventionAssessment() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Assessment returned by Fraud Prevention when TransactionData is provided.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.FraudPreventionAssessment fraud_prevention_assessment = 11;
   * </code>
   *
   * @return The fraudPreventionAssessment.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.FraudPreventionAssessment
      getFraudPreventionAssessment() {
    return fraudPreventionAssessment_ == null
        ? com.google.recaptchaenterprise.v1beta1.FraudPreventionAssessment.getDefaultInstance()
        : fraudPreventionAssessment_;
  }
  /**
   *
   *
   * <pre>
   * Assessment returned by Fraud Prevention when TransactionData is provided.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.FraudPreventionAssessment fraud_prevention_assessment = 11;
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.FraudPreventionAssessmentOrBuilder
      getFraudPreventionAssessmentOrBuilder() {
    return fraudPreventionAssessment_ == null
        ? com.google.recaptchaenterprise.v1beta1.FraudPreventionAssessment.getDefaultInstance()
        : fraudPreventionAssessment_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getEvent());
    }
    if (java.lang.Float.floatToRawIntBits(score_) != 0) {
      output.writeFloat(3, score_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getTokenProperties());
    }
    if (getReasonsList().size() > 0) {
      output.writeUInt32NoTag(42);
      output.writeUInt32NoTag(reasonsMemoizedSerializedSize);
    }
    for (int i = 0; i < reasons_.size(); i++) {
      output.writeEnumNoTag(reasons_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(7, getPasswordLeakVerification());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(8, getAccountDefenderAssessment());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(11, getFraudPreventionAssessment());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEvent());
    }
    if (java.lang.Float.floatToRawIntBits(score_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(3, score_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTokenProperties());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < reasons_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(reasons_.get(i));
      }
      size += dataSize;
      if (!getReasonsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      reasonsMemoizedSerializedSize = dataSize;
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, getPasswordLeakVerification());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, getAccountDefenderAssessment());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, getFraudPreventionAssessment());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.recaptchaenterprise.v1beta1.Assessment)) {
      return super.equals(obj);
    }
    com.google.recaptchaenterprise.v1beta1.Assessment other =
        (com.google.recaptchaenterprise.v1beta1.Assessment) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasEvent() != other.hasEvent()) return false;
    if (hasEvent()) {
      if (!getEvent().equals(other.getEvent())) return false;
    }
    if (java.lang.Float.floatToIntBits(getScore())
        != java.lang.Float.floatToIntBits(other.getScore())) return false;
    if (hasTokenProperties() != other.hasTokenProperties()) return false;
    if (hasTokenProperties()) {
      if (!getTokenProperties().equals(other.getTokenProperties())) return false;
    }
    if (!reasons_.equals(other.reasons_)) return false;
    if (hasPasswordLeakVerification() != other.hasPasswordLeakVerification()) return false;
    if (hasPasswordLeakVerification()) {
      if (!getPasswordLeakVerification().equals(other.getPasswordLeakVerification())) return false;
    }
    if (hasAccountDefenderAssessment() != other.hasAccountDefenderAssessment()) return false;
    if (hasAccountDefenderAssessment()) {
      if (!getAccountDefenderAssessment().equals(other.getAccountDefenderAssessment()))
        return false;
    }
    if (hasFraudPreventionAssessment() != other.hasFraudPreventionAssessment()) return false;
    if (hasFraudPreventionAssessment()) {
      if (!getFraudPreventionAssessment().equals(other.getFraudPreventionAssessment()))
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasEvent()) {
      hash = (37 * hash) + EVENT_FIELD_NUMBER;
      hash = (53 * hash) + getEvent().hashCode();
    }
    hash = (37 * hash) + SCORE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getScore());
    if (hasTokenProperties()) {
      hash = (37 * hash) + TOKEN_PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + getTokenProperties().hashCode();
    }
    if (getReasonsCount() > 0) {
      hash = (37 * hash) + REASONS_FIELD_NUMBER;
      hash = (53 * hash) + reasons_.hashCode();
    }
    if (hasPasswordLeakVerification()) {
      hash = (37 * hash) + PASSWORD_LEAK_VERIFICATION_FIELD_NUMBER;
      hash = (53 * hash) + getPasswordLeakVerification().hashCode();
    }
    if (hasAccountDefenderAssessment()) {
      hash = (37 * hash) + ACCOUNT_DEFENDER_ASSESSMENT_FIELD_NUMBER;
      hash = (53 * hash) + getAccountDefenderAssessment().hashCode();
    }
    if (hasFraudPreventionAssessment()) {
      hash = (37 * hash) + FRAUD_PREVENTION_ASSESSMENT_FIELD_NUMBER;
      hash = (53 * hash) + getFraudPreventionAssessment().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.recaptchaenterprise.v1beta1.Assessment parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1beta1.Assessment parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.Assessment parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1beta1.Assessment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.Assessment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1beta1.Assessment parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.Assessment parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1beta1.Assessment parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.Assessment parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1beta1.Assessment parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.Assessment parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1beta1.Assessment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.recaptchaenterprise.v1beta1.Assessment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A reCAPTCHA Enterprise assessment resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recaptchaenterprise.v1beta1.Assessment}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.recaptchaenterprise.v1beta1.Assessment)
      com.google.recaptchaenterprise.v1beta1.AssessmentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_Assessment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_Assessment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.recaptchaenterprise.v1beta1.Assessment.class,
              com.google.recaptchaenterprise.v1beta1.Assessment.Builder.class);
    }

    // Construct using com.google.recaptchaenterprise.v1beta1.Assessment.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEventFieldBuilder();
        getTokenPropertiesFieldBuilder();
        getPasswordLeakVerificationFieldBuilder();
        getAccountDefenderAssessmentFieldBuilder();
        getFraudPreventionAssessmentFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      event_ = null;
      if (eventBuilder_ != null) {
        eventBuilder_.dispose();
        eventBuilder_ = null;
      }
      score_ = 0F;
      tokenProperties_ = null;
      if (tokenPropertiesBuilder_ != null) {
        tokenPropertiesBuilder_.dispose();
        tokenPropertiesBuilder_ = null;
      }
      reasons_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      passwordLeakVerification_ = null;
      if (passwordLeakVerificationBuilder_ != null) {
        passwordLeakVerificationBuilder_.dispose();
        passwordLeakVerificationBuilder_ = null;
      }
      accountDefenderAssessment_ = null;
      if (accountDefenderAssessmentBuilder_ != null) {
        accountDefenderAssessmentBuilder_.dispose();
        accountDefenderAssessmentBuilder_ = null;
      }
      fraudPreventionAssessment_ = null;
      if (fraudPreventionAssessmentBuilder_ != null) {
        fraudPreventionAssessmentBuilder_.dispose();
        fraudPreventionAssessmentBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_Assessment_descriptor;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.Assessment getDefaultInstanceForType() {
      return com.google.recaptchaenterprise.v1beta1.Assessment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.Assessment build() {
      com.google.recaptchaenterprise.v1beta1.Assessment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.Assessment buildPartial() {
      com.google.recaptchaenterprise.v1beta1.Assessment result =
          new com.google.recaptchaenterprise.v1beta1.Assessment(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.recaptchaenterprise.v1beta1.Assessment result) {
      if (((bitField0_ & 0x00000010) != 0)) {
        reasons_ = java.util.Collections.unmodifiableList(reasons_);
        bitField0_ = (bitField0_ & ~0x00000010);
      }
      result.reasons_ = reasons_;
    }

    private void buildPartial0(com.google.recaptchaenterprise.v1beta1.Assessment result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.event_ = eventBuilder_ == null ? event_ : eventBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.score_ = score_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.tokenProperties_ =
            tokenPropertiesBuilder_ == null ? tokenProperties_ : tokenPropertiesBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.passwordLeakVerification_ =
            passwordLeakVerificationBuilder_ == null
                ? passwordLeakVerification_
                : passwordLeakVerificationBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.accountDefenderAssessment_ =
            accountDefenderAssessmentBuilder_ == null
                ? accountDefenderAssessment_
                : accountDefenderAssessmentBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.fraudPreventionAssessment_ =
            fraudPreventionAssessmentBuilder_ == null
                ? fraudPreventionAssessment_
                : fraudPreventionAssessmentBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.recaptchaenterprise.v1beta1.Assessment) {
        return mergeFrom((com.google.recaptchaenterprise.v1beta1.Assessment) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.recaptchaenterprise.v1beta1.Assessment other) {
      if (other == com.google.recaptchaenterprise.v1beta1.Assessment.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasEvent()) {
        mergeEvent(other.getEvent());
      }
      if (other.getScore() != 0F) {
        setScore(other.getScore());
      }
      if (other.hasTokenProperties()) {
        mergeTokenProperties(other.getTokenProperties());
      }
      if (!other.reasons_.isEmpty()) {
        if (reasons_.isEmpty()) {
          reasons_ = other.reasons_;
          bitField0_ = (bitField0_ & ~0x00000010);
        } else {
          ensureReasonsIsMutable();
          reasons_.addAll(other.reasons_);
        }
        onChanged();
      }
      if (other.hasPasswordLeakVerification()) {
        mergePasswordLeakVerification(other.getPasswordLeakVerification());
      }
      if (other.hasAccountDefenderAssessment()) {
        mergeAccountDefenderAssessment(other.getAccountDefenderAssessment());
      }
      if (other.hasFraudPreventionAssessment()) {
        mergeFraudPreventionAssessment(other.getFraudPreventionAssessment());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getEventFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 29:
              {
                score_ = input.readFloat();
                bitField0_ |= 0x00000004;
                break;
              } // case 29
            case 34:
              {
                input.readMessage(getTokenPropertiesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                int tmpRaw = input.readEnum();
                ensureReasonsIsMutable();
                reasons_.add(tmpRaw);
                break;
              } // case 40
            case 42:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureReasonsIsMutable();
                  reasons_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 42
            case 58:
              {
                input.readMessage(
                    getPasswordLeakVerificationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getAccountDefenderAssessmentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            case 90:
              {
                input.readMessage(
                    getFraudPreventionAssessmentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name for the Assessment in the format
     * `projects/{project_number}/assessments/{assessment_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for the Assessment in the format
     * `projects/{project_number}/assessments/{assessment_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for the Assessment in the format
     * `projects/{project_number}/assessments/{assessment_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for the Assessment in the format
     * `projects/{project_number}/assessments/{assessment_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for the Assessment in the format
     * `projects/{project_number}/assessments/{assessment_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.recaptchaenterprise.v1beta1.Event event_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.Event,
            com.google.recaptchaenterprise.v1beta1.Event.Builder,
            com.google.recaptchaenterprise.v1beta1.EventOrBuilder>
        eventBuilder_;
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.Event event = 2;</code>
     *
     * @return Whether the event field is set.
     */
    public boolean hasEvent() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.Event event = 2;</code>
     *
     * @return The event.
     */
    public com.google.recaptchaenterprise.v1beta1.Event getEvent() {
      if (eventBuilder_ == null) {
        return event_ == null
            ? com.google.recaptchaenterprise.v1beta1.Event.getDefaultInstance()
            : event_;
      } else {
        return eventBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.Event event = 2;</code>
     */
    public Builder setEvent(com.google.recaptchaenterprise.v1beta1.Event value) {
      if (eventBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        event_ = value;
      } else {
        eventBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.Event event = 2;</code>
     */
    public Builder setEvent(com.google.recaptchaenterprise.v1beta1.Event.Builder builderForValue) {
      if (eventBuilder_ == null) {
        event_ = builderForValue.build();
      } else {
        eventBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.Event event = 2;</code>
     */
    public Builder mergeEvent(com.google.recaptchaenterprise.v1beta1.Event value) {
      if (eventBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && event_ != null
            && event_ != com.google.recaptchaenterprise.v1beta1.Event.getDefaultInstance()) {
          getEventBuilder().mergeFrom(value);
        } else {
          event_ = value;
        }
      } else {
        eventBuilder_.mergeFrom(value);
      }
      if (event_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.Event event = 2;</code>
     */
    public Builder clearEvent() {
      bitField0_ = (bitField0_ & ~0x00000002);
      event_ = null;
      if (eventBuilder_ != null) {
        eventBuilder_.dispose();
        eventBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.Event event = 2;</code>
     */
    public com.google.recaptchaenterprise.v1beta1.Event.Builder getEventBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getEventFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.Event event = 2;</code>
     */
    public com.google.recaptchaenterprise.v1beta1.EventOrBuilder getEventOrBuilder() {
      if (eventBuilder_ != null) {
        return eventBuilder_.getMessageOrBuilder();
      } else {
        return event_ == null
            ? com.google.recaptchaenterprise.v1beta1.Event.getDefaultInstance()
            : event_;
      }
    }
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1beta1.Event event = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.Event,
            com.google.recaptchaenterprise.v1beta1.Event.Builder,
            com.google.recaptchaenterprise.v1beta1.EventOrBuilder>
        getEventFieldBuilder() {
      if (eventBuilder_ == null) {
        eventBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1beta1.Event,
                com.google.recaptchaenterprise.v1beta1.Event.Builder,
                com.google.recaptchaenterprise.v1beta1.EventOrBuilder>(
                getEvent(), getParentForChildren(), isClean());
        event_ = null;
      }
      return eventBuilder_;
    }

    private float score_;
    /**
     *
     *
     * <pre>
     * Output only. Legitimate event score from 0.0 to 1.0.
     * (1.0 means very likely legitimate traffic while 0.0 means very likely
     * non-legitimate traffic).
     * </pre>
     *
     * <code>float score = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The score.
     */
    @java.lang.Override
    public float getScore() {
      return score_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Legitimate event score from 0.0 to 1.0.
     * (1.0 means very likely legitimate traffic while 0.0 means very likely
     * non-legitimate traffic).
     * </pre>
     *
     * <code>float score = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The score to set.
     * @return This builder for chaining.
     */
    public Builder setScore(float value) {

      score_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Legitimate event score from 0.0 to 1.0.
     * (1.0 means very likely legitimate traffic while 0.0 means very likely
     * non-legitimate traffic).
     * </pre>
     *
     * <code>float score = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearScore() {
      bitField0_ = (bitField0_ & ~0x00000004);
      score_ = 0F;
      onChanged();
      return this;
    }

    private com.google.recaptchaenterprise.v1beta1.TokenProperties tokenProperties_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.TokenProperties,
            com.google.recaptchaenterprise.v1beta1.TokenProperties.Builder,
            com.google.recaptchaenterprise.v1beta1.TokenPropertiesOrBuilder>
        tokenPropertiesBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the tokenProperties field is set.
     */
    public boolean hasTokenProperties() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The tokenProperties.
     */
    public com.google.recaptchaenterprise.v1beta1.TokenProperties getTokenProperties() {
      if (tokenPropertiesBuilder_ == null) {
        return tokenProperties_ == null
            ? com.google.recaptchaenterprise.v1beta1.TokenProperties.getDefaultInstance()
            : tokenProperties_;
      } else {
        return tokenPropertiesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTokenProperties(
        com.google.recaptchaenterprise.v1beta1.TokenProperties value) {
      if (tokenPropertiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tokenProperties_ = value;
      } else {
        tokenPropertiesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTokenProperties(
        com.google.recaptchaenterprise.v1beta1.TokenProperties.Builder builderForValue) {
      if (tokenPropertiesBuilder_ == null) {
        tokenProperties_ = builderForValue.build();
      } else {
        tokenPropertiesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeTokenProperties(
        com.google.recaptchaenterprise.v1beta1.TokenProperties value) {
      if (tokenPropertiesBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && tokenProperties_ != null
            && tokenProperties_
                != com.google.recaptchaenterprise.v1beta1.TokenProperties.getDefaultInstance()) {
          getTokenPropertiesBuilder().mergeFrom(value);
        } else {
          tokenProperties_ = value;
        }
      } else {
        tokenPropertiesBuilder_.mergeFrom(value);
      }
      if (tokenProperties_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTokenProperties() {
      bitField0_ = (bitField0_ & ~0x00000008);
      tokenProperties_ = null;
      if (tokenPropertiesBuilder_ != null) {
        tokenPropertiesBuilder_.dispose();
        tokenPropertiesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.TokenProperties.Builder
        getTokenPropertiesBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getTokenPropertiesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.TokenPropertiesOrBuilder
        getTokenPropertiesOrBuilder() {
      if (tokenPropertiesBuilder_ != null) {
        return tokenPropertiesBuilder_.getMessageOrBuilder();
      } else {
        return tokenProperties_ == null
            ? com.google.recaptchaenterprise.v1beta1.TokenProperties.getDefaultInstance()
            : tokenProperties_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.TokenProperties,
            com.google.recaptchaenterprise.v1beta1.TokenProperties.Builder,
            com.google.recaptchaenterprise.v1beta1.TokenPropertiesOrBuilder>
        getTokenPropertiesFieldBuilder() {
      if (tokenPropertiesBuilder_ == null) {
        tokenPropertiesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1beta1.TokenProperties,
                com.google.recaptchaenterprise.v1beta1.TokenProperties.Builder,
                com.google.recaptchaenterprise.v1beta1.TokenPropertiesOrBuilder>(
                getTokenProperties(), getParentForChildren(), isClean());
        tokenProperties_ = null;
      }
      return tokenPropertiesBuilder_;
    }

    private java.util.List<java.lang.Integer> reasons_ = java.util.Collections.emptyList();

    private void ensureReasonsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        reasons_ = new java.util.ArrayList<java.lang.Integer>(reasons_);
        bitField0_ |= 0x00000010;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Reasons contributing to the risk analysis verdict.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the reasons.
     */
    public java.util.List<com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason>
        getReasonsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer,
          com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason>(
          reasons_, reasons_converter_);
    }
    /**
     *
     *
     * <pre>
     * Output only. Reasons contributing to the risk analysis verdict.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of reasons.
     */
    public int getReasonsCount() {
      return reasons_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Reasons contributing to the risk analysis verdict.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The reasons at the given index.
     */
    public com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason getReasons(
        int index) {
      return reasons_converter_.convert(reasons_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Output only. Reasons contributing to the risk analysis verdict.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The reasons to set.
     * @return This builder for chaining.
     */
    public Builder setReasons(
        int index, com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReasonsIsMutable();
      reasons_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reasons contributing to the risk analysis verdict.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The reasons to add.
     * @return This builder for chaining.
     */
    public Builder addReasons(
        com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReasonsIsMutable();
      reasons_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reasons contributing to the risk analysis verdict.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The reasons to add.
     * @return This builder for chaining.
     */
    public Builder addAllReasons(
        java.lang.Iterable<
                ? extends com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason>
            values) {
      ensureReasonsIsMutable();
      for (com.google.recaptchaenterprise.v1beta1.Assessment.ClassificationReason value : values) {
        reasons_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reasons contributing to the risk analysis verdict.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReasons() {
      reasons_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reasons contributing to the risk analysis verdict.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for reasons.
     */
    public java.util.List<java.lang.Integer> getReasonsValueList() {
      return java.util.Collections.unmodifiableList(reasons_);
    }
    /**
     *
     *
     * <pre>
     * Output only. Reasons contributing to the risk analysis verdict.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of reasons at the given index.
     */
    public int getReasonsValue(int index) {
      return reasons_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Reasons contributing to the risk analysis verdict.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for reasons to set.
     * @return This builder for chaining.
     */
    public Builder setReasonsValue(int index, int value) {
      ensureReasonsIsMutable();
      reasons_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reasons contributing to the risk analysis verdict.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for reasons to add.
     * @return This builder for chaining.
     */
    public Builder addReasonsValue(int value) {
      ensureReasonsIsMutable();
      reasons_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reasons contributing to the risk analysis verdict.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason reasons = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The enum numeric values on the wire for reasons to add.
     * @return This builder for chaining.
     */
    public Builder addAllReasonsValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureReasonsIsMutable();
      for (int value : values) {
        reasons_.add(value);
      }
      onChanged();
      return this;
    }

    private com.google.recaptchaenterprise.v1beta1.PasswordLeakVerification
        passwordLeakVerification_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.PasswordLeakVerification,
            com.google.recaptchaenterprise.v1beta1.PasswordLeakVerification.Builder,
            com.google.recaptchaenterprise.v1beta1.PasswordLeakVerificationOrBuilder>
        passwordLeakVerificationBuilder_;
    /**
     *
     *
     * <pre>
     * Information about the user's credentials used to check for leaks.
     * This feature is part of the Early Access Program (EAP). Exercise caution,
     * and do not deploy integrations based on this feature in a production
     * environment.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.PasswordLeakVerification password_leak_verification = 7;
     * </code>
     *
     * @return Whether the passwordLeakVerification field is set.
     */
    public boolean hasPasswordLeakVerification() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Information about the user's credentials used to check for leaks.
     * This feature is part of the Early Access Program (EAP). Exercise caution,
     * and do not deploy integrations based on this feature in a production
     * environment.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.PasswordLeakVerification password_leak_verification = 7;
     * </code>
     *
     * @return The passwordLeakVerification.
     */
    public com.google.recaptchaenterprise.v1beta1.PasswordLeakVerification
        getPasswordLeakVerification() {
      if (passwordLeakVerificationBuilder_ == null) {
        return passwordLeakVerification_ == null
            ? com.google.recaptchaenterprise.v1beta1.PasswordLeakVerification.getDefaultInstance()
            : passwordLeakVerification_;
      } else {
        return passwordLeakVerificationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the user's credentials used to check for leaks.
     * This feature is part of the Early Access Program (EAP). Exercise caution,
     * and do not deploy integrations based on this feature in a production
     * environment.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.PasswordLeakVerification password_leak_verification = 7;
     * </code>
     */
    public Builder setPasswordLeakVerification(
        com.google.recaptchaenterprise.v1beta1.PasswordLeakVerification value) {
      if (passwordLeakVerificationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        passwordLeakVerification_ = value;
      } else {
        passwordLeakVerificationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the user's credentials used to check for leaks.
     * This feature is part of the Early Access Program (EAP). Exercise caution,
     * and do not deploy integrations based on this feature in a production
     * environment.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.PasswordLeakVerification password_leak_verification = 7;
     * </code>
     */
    public Builder setPasswordLeakVerification(
        com.google.recaptchaenterprise.v1beta1.PasswordLeakVerification.Builder builderForValue) {
      if (passwordLeakVerificationBuilder_ == null) {
        passwordLeakVerification_ = builderForValue.build();
      } else {
        passwordLeakVerificationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the user's credentials used to check for leaks.
     * This feature is part of the Early Access Program (EAP). Exercise caution,
     * and do not deploy integrations based on this feature in a production
     * environment.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.PasswordLeakVerification password_leak_verification = 7;
     * </code>
     */
    public Builder mergePasswordLeakVerification(
        com.google.recaptchaenterprise.v1beta1.PasswordLeakVerification value) {
      if (passwordLeakVerificationBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && passwordLeakVerification_ != null
            && passwordLeakVerification_
                != com.google.recaptchaenterprise.v1beta1.PasswordLeakVerification
                    .getDefaultInstance()) {
          getPasswordLeakVerificationBuilder().mergeFrom(value);
        } else {
          passwordLeakVerification_ = value;
        }
      } else {
        passwordLeakVerificationBuilder_.mergeFrom(value);
      }
      if (passwordLeakVerification_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the user's credentials used to check for leaks.
     * This feature is part of the Early Access Program (EAP). Exercise caution,
     * and do not deploy integrations based on this feature in a production
     * environment.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.PasswordLeakVerification password_leak_verification = 7;
     * </code>
     */
    public Builder clearPasswordLeakVerification() {
      bitField0_ = (bitField0_ & ~0x00000020);
      passwordLeakVerification_ = null;
      if (passwordLeakVerificationBuilder_ != null) {
        passwordLeakVerificationBuilder_.dispose();
        passwordLeakVerificationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the user's credentials used to check for leaks.
     * This feature is part of the Early Access Program (EAP). Exercise caution,
     * and do not deploy integrations based on this feature in a production
     * environment.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.PasswordLeakVerification password_leak_verification = 7;
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.PasswordLeakVerification.Builder
        getPasswordLeakVerificationBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getPasswordLeakVerificationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Information about the user's credentials used to check for leaks.
     * This feature is part of the Early Access Program (EAP). Exercise caution,
     * and do not deploy integrations based on this feature in a production
     * environment.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.PasswordLeakVerification password_leak_verification = 7;
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.PasswordLeakVerificationOrBuilder
        getPasswordLeakVerificationOrBuilder() {
      if (passwordLeakVerificationBuilder_ != null) {
        return passwordLeakVerificationBuilder_.getMessageOrBuilder();
      } else {
        return passwordLeakVerification_ == null
            ? com.google.recaptchaenterprise.v1beta1.PasswordLeakVerification.getDefaultInstance()
            : passwordLeakVerification_;
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the user's credentials used to check for leaks.
     * This feature is part of the Early Access Program (EAP). Exercise caution,
     * and do not deploy integrations based on this feature in a production
     * environment.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.PasswordLeakVerification password_leak_verification = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.PasswordLeakVerification,
            com.google.recaptchaenterprise.v1beta1.PasswordLeakVerification.Builder,
            com.google.recaptchaenterprise.v1beta1.PasswordLeakVerificationOrBuilder>
        getPasswordLeakVerificationFieldBuilder() {
      if (passwordLeakVerificationBuilder_ == null) {
        passwordLeakVerificationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1beta1.PasswordLeakVerification,
                com.google.recaptchaenterprise.v1beta1.PasswordLeakVerification.Builder,
                com.google.recaptchaenterprise.v1beta1.PasswordLeakVerificationOrBuilder>(
                getPasswordLeakVerification(), getParentForChildren(), isClean());
        passwordLeakVerification_ = null;
      }
      return passwordLeakVerificationBuilder_;
    }

    private com.google.recaptchaenterprise.v1beta1.AccountDefenderAssessment
        accountDefenderAssessment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.AccountDefenderAssessment,
            com.google.recaptchaenterprise.v1beta1.AccountDefenderAssessment.Builder,
            com.google.recaptchaenterprise.v1beta1.AccountDefenderAssessmentOrBuilder>
        accountDefenderAssessmentBuilder_;
    /**
     *
     *
     * <pre>
     * Assessment returned by account defender when a hashed_account_id is
     * provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.AccountDefenderAssessment account_defender_assessment = 8;
     * </code>
     *
     * @return Whether the accountDefenderAssessment field is set.
     */
    public boolean hasAccountDefenderAssessment() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Assessment returned by account defender when a hashed_account_id is
     * provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.AccountDefenderAssessment account_defender_assessment = 8;
     * </code>
     *
     * @return The accountDefenderAssessment.
     */
    public com.google.recaptchaenterprise.v1beta1.AccountDefenderAssessment
        getAccountDefenderAssessment() {
      if (accountDefenderAssessmentBuilder_ == null) {
        return accountDefenderAssessment_ == null
            ? com.google.recaptchaenterprise.v1beta1.AccountDefenderAssessment.getDefaultInstance()
            : accountDefenderAssessment_;
      } else {
        return accountDefenderAssessmentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Assessment returned by account defender when a hashed_account_id is
     * provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.AccountDefenderAssessment account_defender_assessment = 8;
     * </code>
     */
    public Builder setAccountDefenderAssessment(
        com.google.recaptchaenterprise.v1beta1.AccountDefenderAssessment value) {
      if (accountDefenderAssessmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        accountDefenderAssessment_ = value;
      } else {
        accountDefenderAssessmentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Assessment returned by account defender when a hashed_account_id is
     * provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.AccountDefenderAssessment account_defender_assessment = 8;
     * </code>
     */
    public Builder setAccountDefenderAssessment(
        com.google.recaptchaenterprise.v1beta1.AccountDefenderAssessment.Builder builderForValue) {
      if (accountDefenderAssessmentBuilder_ == null) {
        accountDefenderAssessment_ = builderForValue.build();
      } else {
        accountDefenderAssessmentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Assessment returned by account defender when a hashed_account_id is
     * provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.AccountDefenderAssessment account_defender_assessment = 8;
     * </code>
     */
    public Builder mergeAccountDefenderAssessment(
        com.google.recaptchaenterprise.v1beta1.AccountDefenderAssessment value) {
      if (accountDefenderAssessmentBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && accountDefenderAssessment_ != null
            && accountDefenderAssessment_
                != com.google.recaptchaenterprise.v1beta1.AccountDefenderAssessment
                    .getDefaultInstance()) {
          getAccountDefenderAssessmentBuilder().mergeFrom(value);
        } else {
          accountDefenderAssessment_ = value;
        }
      } else {
        accountDefenderAssessmentBuilder_.mergeFrom(value);
      }
      if (accountDefenderAssessment_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Assessment returned by account defender when a hashed_account_id is
     * provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.AccountDefenderAssessment account_defender_assessment = 8;
     * </code>
     */
    public Builder clearAccountDefenderAssessment() {
      bitField0_ = (bitField0_ & ~0x00000040);
      accountDefenderAssessment_ = null;
      if (accountDefenderAssessmentBuilder_ != null) {
        accountDefenderAssessmentBuilder_.dispose();
        accountDefenderAssessmentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Assessment returned by account defender when a hashed_account_id is
     * provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.AccountDefenderAssessment account_defender_assessment = 8;
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.AccountDefenderAssessment.Builder
        getAccountDefenderAssessmentBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getAccountDefenderAssessmentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Assessment returned by account defender when a hashed_account_id is
     * provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.AccountDefenderAssessment account_defender_assessment = 8;
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.AccountDefenderAssessmentOrBuilder
        getAccountDefenderAssessmentOrBuilder() {
      if (accountDefenderAssessmentBuilder_ != null) {
        return accountDefenderAssessmentBuilder_.getMessageOrBuilder();
      } else {
        return accountDefenderAssessment_ == null
            ? com.google.recaptchaenterprise.v1beta1.AccountDefenderAssessment.getDefaultInstance()
            : accountDefenderAssessment_;
      }
    }
    /**
     *
     *
     * <pre>
     * Assessment returned by account defender when a hashed_account_id is
     * provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.AccountDefenderAssessment account_defender_assessment = 8;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.AccountDefenderAssessment,
            com.google.recaptchaenterprise.v1beta1.AccountDefenderAssessment.Builder,
            com.google.recaptchaenterprise.v1beta1.AccountDefenderAssessmentOrBuilder>
        getAccountDefenderAssessmentFieldBuilder() {
      if (accountDefenderAssessmentBuilder_ == null) {
        accountDefenderAssessmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1beta1.AccountDefenderAssessment,
                com.google.recaptchaenterprise.v1beta1.AccountDefenderAssessment.Builder,
                com.google.recaptchaenterprise.v1beta1.AccountDefenderAssessmentOrBuilder>(
                getAccountDefenderAssessment(), getParentForChildren(), isClean());
        accountDefenderAssessment_ = null;
      }
      return accountDefenderAssessmentBuilder_;
    }

    private com.google.recaptchaenterprise.v1beta1.FraudPreventionAssessment
        fraudPreventionAssessment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.FraudPreventionAssessment,
            com.google.recaptchaenterprise.v1beta1.FraudPreventionAssessment.Builder,
            com.google.recaptchaenterprise.v1beta1.FraudPreventionAssessmentOrBuilder>
        fraudPreventionAssessmentBuilder_;
    /**
     *
     *
     * <pre>
     * Assessment returned by Fraud Prevention when TransactionData is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.FraudPreventionAssessment fraud_prevention_assessment = 11;
     * </code>
     *
     * @return Whether the fraudPreventionAssessment field is set.
     */
    public boolean hasFraudPreventionAssessment() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Assessment returned by Fraud Prevention when TransactionData is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.FraudPreventionAssessment fraud_prevention_assessment = 11;
     * </code>
     *
     * @return The fraudPreventionAssessment.
     */
    public com.google.recaptchaenterprise.v1beta1.FraudPreventionAssessment
        getFraudPreventionAssessment() {
      if (fraudPreventionAssessmentBuilder_ == null) {
        return fraudPreventionAssessment_ == null
            ? com.google.recaptchaenterprise.v1beta1.FraudPreventionAssessment.getDefaultInstance()
            : fraudPreventionAssessment_;
      } else {
        return fraudPreventionAssessmentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Assessment returned by Fraud Prevention when TransactionData is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.FraudPreventionAssessment fraud_prevention_assessment = 11;
     * </code>
     */
    public Builder setFraudPreventionAssessment(
        com.google.recaptchaenterprise.v1beta1.FraudPreventionAssessment value) {
      if (fraudPreventionAssessmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fraudPreventionAssessment_ = value;
      } else {
        fraudPreventionAssessmentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Assessment returned by Fraud Prevention when TransactionData is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.FraudPreventionAssessment fraud_prevention_assessment = 11;
     * </code>
     */
    public Builder setFraudPreventionAssessment(
        com.google.recaptchaenterprise.v1beta1.FraudPreventionAssessment.Builder builderForValue) {
      if (fraudPreventionAssessmentBuilder_ == null) {
        fraudPreventionAssessment_ = builderForValue.build();
      } else {
        fraudPreventionAssessmentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Assessment returned by Fraud Prevention when TransactionData is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.FraudPreventionAssessment fraud_prevention_assessment = 11;
     * </code>
     */
    public Builder mergeFraudPreventionAssessment(
        com.google.recaptchaenterprise.v1beta1.FraudPreventionAssessment value) {
      if (fraudPreventionAssessmentBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && fraudPreventionAssessment_ != null
            && fraudPreventionAssessment_
                != com.google.recaptchaenterprise.v1beta1.FraudPreventionAssessment
                    .getDefaultInstance()) {
          getFraudPreventionAssessmentBuilder().mergeFrom(value);
        } else {
          fraudPreventionAssessment_ = value;
        }
      } else {
        fraudPreventionAssessmentBuilder_.mergeFrom(value);
      }
      if (fraudPreventionAssessment_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Assessment returned by Fraud Prevention when TransactionData is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.FraudPreventionAssessment fraud_prevention_assessment = 11;
     * </code>
     */
    public Builder clearFraudPreventionAssessment() {
      bitField0_ = (bitField0_ & ~0x00000080);
      fraudPreventionAssessment_ = null;
      if (fraudPreventionAssessmentBuilder_ != null) {
        fraudPreventionAssessmentBuilder_.dispose();
        fraudPreventionAssessmentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Assessment returned by Fraud Prevention when TransactionData is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.FraudPreventionAssessment fraud_prevention_assessment = 11;
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.FraudPreventionAssessment.Builder
        getFraudPreventionAssessmentBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getFraudPreventionAssessmentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Assessment returned by Fraud Prevention when TransactionData is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.FraudPreventionAssessment fraud_prevention_assessment = 11;
     * </code>
     */
    public com.google.recaptchaenterprise.v1beta1.FraudPreventionAssessmentOrBuilder
        getFraudPreventionAssessmentOrBuilder() {
      if (fraudPreventionAssessmentBuilder_ != null) {
        return fraudPreventionAssessmentBuilder_.getMessageOrBuilder();
      } else {
        return fraudPreventionAssessment_ == null
            ? com.google.recaptchaenterprise.v1beta1.FraudPreventionAssessment.getDefaultInstance()
            : fraudPreventionAssessment_;
      }
    }
    /**
     *
     *
     * <pre>
     * Assessment returned by Fraud Prevention when TransactionData is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.FraudPreventionAssessment fraud_prevention_assessment = 11;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1beta1.FraudPreventionAssessment,
            com.google.recaptchaenterprise.v1beta1.FraudPreventionAssessment.Builder,
            com.google.recaptchaenterprise.v1beta1.FraudPreventionAssessmentOrBuilder>
        getFraudPreventionAssessmentFieldBuilder() {
      if (fraudPreventionAssessmentBuilder_ == null) {
        fraudPreventionAssessmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1beta1.FraudPreventionAssessment,
                com.google.recaptchaenterprise.v1beta1.FraudPreventionAssessment.Builder,
                com.google.recaptchaenterprise.v1beta1.FraudPreventionAssessmentOrBuilder>(
                getFraudPreventionAssessment(), getParentForChildren(), isClean());
        fraudPreventionAssessment_ = null;
      }
      return fraudPreventionAssessmentBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.recaptchaenterprise.v1beta1.Assessment)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.recaptchaenterprise.v1beta1.Assessment)
  private static final com.google.recaptchaenterprise.v1beta1.Assessment DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.recaptchaenterprise.v1beta1.Assessment();
  }

  public static com.google.recaptchaenterprise.v1beta1.Assessment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Assessment> PARSER =
      new com.google.protobuf.AbstractParser<Assessment>() {
        @java.lang.Override
        public Assessment parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Assessment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Assessment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.Assessment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
