/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/recaptchaenterprise/v1beta1/recaptchaenterprise.proto

// Protobuf Java Version: 3.25.5
package com.google.recaptchaenterprise.v1beta1;

/** Protobuf type {@code google.cloud.recaptchaenterprise.v1beta1.TokenProperties} */
public final class TokenProperties extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.recaptchaenterprise.v1beta1.TokenProperties)
    TokenPropertiesOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TokenProperties.newBuilder() to construct.
  private TokenProperties(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TokenProperties() {
    invalidReason_ = 0;
    hostname_ = "";
    action_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TokenProperties();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1beta1_TokenProperties_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1beta1_TokenProperties_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.recaptchaenterprise.v1beta1.TokenProperties.class,
            com.google.recaptchaenterprise.v1beta1.TokenProperties.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Enum that represents the types of invalid token reasons.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.recaptchaenterprise.v1beta1.TokenProperties.InvalidReason}
   */
  public enum InvalidReason implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default unspecified type.
     * </pre>
     *
     * <code>INVALID_REASON_UNSPECIFIED = 0;</code>
     */
    INVALID_REASON_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * If the failure reason was not accounted for.
     * </pre>
     *
     * <code>UNKNOWN_INVALID_REASON = 1;</code>
     */
    UNKNOWN_INVALID_REASON(1),
    /**
     *
     *
     * <pre>
     * The provided user verification token was malformed.
     * </pre>
     *
     * <code>MALFORMED = 2;</code>
     */
    MALFORMED(2),
    /**
     *
     *
     * <pre>
     * The user verification token had expired.
     * </pre>
     *
     * <code>EXPIRED = 3;</code>
     */
    EXPIRED(3),
    /**
     *
     *
     * <pre>
     * The user verification had already been seen.
     * </pre>
     *
     * <code>DUPE = 4;</code>
     */
    DUPE(4),
    /**
     *
     *
     * <pre>
     * The user verification token did not match the provided site key.
     * This may be a configuration error (for example, development keys used in
     * production) or end users trying to use verification tokens from other
     * sites.
     * </pre>
     *
     * <code>SITE_MISMATCH = 5 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    SITE_MISMATCH(5),
    /**
     *
     *
     * <pre>
     * The user verification token was not present.  It is a required input.
     * </pre>
     *
     * <code>MISSING = 6;</code>
     */
    MISSING(6),
    /**
     *
     *
     * <pre>
     * A retriable error (such as network failure) occurred on the browser.
     * Could easily be simulated by an attacker.
     * </pre>
     *
     * <code>BROWSER_ERROR = 7;</code>
     */
    BROWSER_ERROR(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default unspecified type.
     * </pre>
     *
     * <code>INVALID_REASON_UNSPECIFIED = 0;</code>
     */
    public static final int INVALID_REASON_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * If the failure reason was not accounted for.
     * </pre>
     *
     * <code>UNKNOWN_INVALID_REASON = 1;</code>
     */
    public static final int UNKNOWN_INVALID_REASON_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The provided user verification token was malformed.
     * </pre>
     *
     * <code>MALFORMED = 2;</code>
     */
    public static final int MALFORMED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The user verification token had expired.
     * </pre>
     *
     * <code>EXPIRED = 3;</code>
     */
    public static final int EXPIRED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The user verification had already been seen.
     * </pre>
     *
     * <code>DUPE = 4;</code>
     */
    public static final int DUPE_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The user verification token did not match the provided site key.
     * This may be a configuration error (for example, development keys used in
     * production) or end users trying to use verification tokens from other
     * sites.
     * </pre>
     *
     * <code>SITE_MISMATCH = 5 [deprecated = true];</code>
     */
    @java.lang.Deprecated public static final int SITE_MISMATCH_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The user verification token was not present.  It is a required input.
     * </pre>
     *
     * <code>MISSING = 6;</code>
     */
    public static final int MISSING_VALUE = 6;
    /**
     *
     *
     * <pre>
     * A retriable error (such as network failure) occurred on the browser.
     * Could easily be simulated by an attacker.
     * </pre>
     *
     * <code>BROWSER_ERROR = 7;</code>
     */
    public static final int BROWSER_ERROR_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static InvalidReason valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static InvalidReason forNumber(int value) {
      switch (value) {
        case 0:
          return INVALID_REASON_UNSPECIFIED;
        case 1:
          return UNKNOWN_INVALID_REASON;
        case 2:
          return MALFORMED;
        case 3:
          return EXPIRED;
        case 4:
          return DUPE;
        case 5:
          return SITE_MISMATCH;
        case 6:
          return MISSING;
        case 7:
          return BROWSER_ERROR;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<InvalidReason> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<InvalidReason> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<InvalidReason>() {
          public InvalidReason findValueByNumber(int number) {
            return InvalidReason.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1beta1.TokenProperties.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final InvalidReason[] VALUES = values();

    public static InvalidReason valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private InvalidReason(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.recaptchaenterprise.v1beta1.TokenProperties.InvalidReason)
  }

  private int bitField0_;
  public static final int VALID_FIELD_NUMBER = 1;
  private boolean valid_ = false;
  /**
   *
   *
   * <pre>
   * Whether the provided user response token is valid. When valid = false, the
   * reason could be specified in invalid_reason or it could also be due to
   * a user failing to solve a challenge or a sitekey mismatch (i.e the sitekey
   * used to generate the token was different than the one specified in the
   * assessment).
   * </pre>
   *
   * <code>bool valid = 1;</code>
   *
   * @return The valid.
   */
  @java.lang.Override
  public boolean getValid() {
    return valid_;
  }

  public static final int INVALID_REASON_FIELD_NUMBER = 2;
  private int invalidReason_ = 0;
  /**
   *
   *
   * <pre>
   * Reason associated with the response when valid = false.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties.InvalidReason invalid_reason = 2;
   * </code>
   *
   * @return The enum numeric value on the wire for invalidReason.
   */
  @java.lang.Override
  public int getInvalidReasonValue() {
    return invalidReason_;
  }
  /**
   *
   *
   * <pre>
   * Reason associated with the response when valid = false.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties.InvalidReason invalid_reason = 2;
   * </code>
   *
   * @return The invalidReason.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.TokenProperties.InvalidReason getInvalidReason() {
    com.google.recaptchaenterprise.v1beta1.TokenProperties.InvalidReason result =
        com.google.recaptchaenterprise.v1beta1.TokenProperties.InvalidReason.forNumber(
            invalidReason_);
    return result == null
        ? com.google.recaptchaenterprise.v1beta1.TokenProperties.InvalidReason.UNRECOGNIZED
        : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * The timestamp corresponding to the generation of the token.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The timestamp corresponding to the generation of the token.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * The timestamp corresponding to the generation of the token.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int HOSTNAME_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object hostname_ = "";
  /**
   *
   *
   * <pre>
   * The hostname of the page on which the token was generated.
   * </pre>
   *
   * <code>string hostname = 4;</code>
   *
   * @return The hostname.
   */
  @java.lang.Override
  public java.lang.String getHostname() {
    java.lang.Object ref = hostname_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      hostname_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The hostname of the page on which the token was generated.
   * </pre>
   *
   * <code>string hostname = 4;</code>
   *
   * @return The bytes for hostname.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHostnameBytes() {
    java.lang.Object ref = hostname_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      hostname_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ACTION_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object action_ = "";
  /**
   *
   *
   * <pre>
   * Action name provided at token generation.
   * </pre>
   *
   * <code>string action = 5;</code>
   *
   * @return The action.
   */
  @java.lang.Override
  public java.lang.String getAction() {
    java.lang.Object ref = action_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      action_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Action name provided at token generation.
   * </pre>
   *
   * <code>string action = 5;</code>
   *
   * @return The bytes for action.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getActionBytes() {
    java.lang.Object ref = action_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      action_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (valid_ != false) {
      output.writeBool(1, valid_);
    }
    if (invalidReason_
        != com.google.recaptchaenterprise.v1beta1.TokenProperties.InvalidReason
            .INVALID_REASON_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, invalidReason_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostname_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, hostname_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(action_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, action_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (valid_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, valid_);
    }
    if (invalidReason_
        != com.google.recaptchaenterprise.v1beta1.TokenProperties.InvalidReason
            .INVALID_REASON_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, invalidReason_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostname_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, hostname_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(action_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, action_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.recaptchaenterprise.v1beta1.TokenProperties)) {
      return super.equals(obj);
    }
    com.google.recaptchaenterprise.v1beta1.TokenProperties other =
        (com.google.recaptchaenterprise.v1beta1.TokenProperties) obj;

    if (getValid() != other.getValid()) return false;
    if (invalidReason_ != other.invalidReason_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getHostname().equals(other.getHostname())) return false;
    if (!getAction().equals(other.getAction())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + VALID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getValid());
    hash = (37 * hash) + INVALID_REASON_FIELD_NUMBER;
    hash = (53 * hash) + invalidReason_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + HOSTNAME_FIELD_NUMBER;
    hash = (53 * hash) + getHostname().hashCode();
    hash = (37 * hash) + ACTION_FIELD_NUMBER;
    hash = (53 * hash) + getAction().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.recaptchaenterprise.v1beta1.TokenProperties parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1beta1.TokenProperties parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.TokenProperties parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1beta1.TokenProperties parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.TokenProperties parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1beta1.TokenProperties parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.TokenProperties parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1beta1.TokenProperties parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.TokenProperties parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1beta1.TokenProperties parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.TokenProperties parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1beta1.TokenProperties parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.recaptchaenterprise.v1beta1.TokenProperties prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /** Protobuf type {@code google.cloud.recaptchaenterprise.v1beta1.TokenProperties} */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.recaptchaenterprise.v1beta1.TokenProperties)
      com.google.recaptchaenterprise.v1beta1.TokenPropertiesOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_TokenProperties_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_TokenProperties_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.recaptchaenterprise.v1beta1.TokenProperties.class,
              com.google.recaptchaenterprise.v1beta1.TokenProperties.Builder.class);
    }

    // Construct using com.google.recaptchaenterprise.v1beta1.TokenProperties.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      valid_ = false;
      invalidReason_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      hostname_ = "";
      action_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_TokenProperties_descriptor;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.TokenProperties getDefaultInstanceForType() {
      return com.google.recaptchaenterprise.v1beta1.TokenProperties.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.TokenProperties build() {
      com.google.recaptchaenterprise.v1beta1.TokenProperties result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.TokenProperties buildPartial() {
      com.google.recaptchaenterprise.v1beta1.TokenProperties result =
          new com.google.recaptchaenterprise.v1beta1.TokenProperties(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.recaptchaenterprise.v1beta1.TokenProperties result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.valid_ = valid_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.invalidReason_ = invalidReason_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.hostname_ = hostname_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.action_ = action_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.recaptchaenterprise.v1beta1.TokenProperties) {
        return mergeFrom((com.google.recaptchaenterprise.v1beta1.TokenProperties) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.recaptchaenterprise.v1beta1.TokenProperties other) {
      if (other == com.google.recaptchaenterprise.v1beta1.TokenProperties.getDefaultInstance())
        return this;
      if (other.getValid() != false) {
        setValid(other.getValid());
      }
      if (other.invalidReason_ != 0) {
        setInvalidReasonValue(other.getInvalidReasonValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (!other.getHostname().isEmpty()) {
        hostname_ = other.hostname_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getAction().isEmpty()) {
        action_ = other.action_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                valid_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                invalidReason_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                hostname_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                action_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean valid_;
    /**
     *
     *
     * <pre>
     * Whether the provided user response token is valid. When valid = false, the
     * reason could be specified in invalid_reason or it could also be due to
     * a user failing to solve a challenge or a sitekey mismatch (i.e the sitekey
     * used to generate the token was different than the one specified in the
     * assessment).
     * </pre>
     *
     * <code>bool valid = 1;</code>
     *
     * @return The valid.
     */
    @java.lang.Override
    public boolean getValid() {
      return valid_;
    }
    /**
     *
     *
     * <pre>
     * Whether the provided user response token is valid. When valid = false, the
     * reason could be specified in invalid_reason or it could also be due to
     * a user failing to solve a challenge or a sitekey mismatch (i.e the sitekey
     * used to generate the token was different than the one specified in the
     * assessment).
     * </pre>
     *
     * <code>bool valid = 1;</code>
     *
     * @param value The valid to set.
     * @return This builder for chaining.
     */
    public Builder setValid(boolean value) {

      valid_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the provided user response token is valid. When valid = false, the
     * reason could be specified in invalid_reason or it could also be due to
     * a user failing to solve a challenge or a sitekey mismatch (i.e the sitekey
     * used to generate the token was different than the one specified in the
     * assessment).
     * </pre>
     *
     * <code>bool valid = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValid() {
      bitField0_ = (bitField0_ & ~0x00000001);
      valid_ = false;
      onChanged();
      return this;
    }

    private int invalidReason_ = 0;
    /**
     *
     *
     * <pre>
     * Reason associated with the response when valid = false.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties.InvalidReason invalid_reason = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for invalidReason.
     */
    @java.lang.Override
    public int getInvalidReasonValue() {
      return invalidReason_;
    }
    /**
     *
     *
     * <pre>
     * Reason associated with the response when valid = false.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties.InvalidReason invalid_reason = 2;
     * </code>
     *
     * @param value The enum numeric value on the wire for invalidReason to set.
     * @return This builder for chaining.
     */
    public Builder setInvalidReasonValue(int value) {
      invalidReason_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reason associated with the response when valid = false.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties.InvalidReason invalid_reason = 2;
     * </code>
     *
     * @return The invalidReason.
     */
    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.TokenProperties.InvalidReason getInvalidReason() {
      com.google.recaptchaenterprise.v1beta1.TokenProperties.InvalidReason result =
          com.google.recaptchaenterprise.v1beta1.TokenProperties.InvalidReason.forNumber(
              invalidReason_);
      return result == null
          ? com.google.recaptchaenterprise.v1beta1.TokenProperties.InvalidReason.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Reason associated with the response when valid = false.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties.InvalidReason invalid_reason = 2;
     * </code>
     *
     * @param value The invalidReason to set.
     * @return This builder for chaining.
     */
    public Builder setInvalidReason(
        com.google.recaptchaenterprise.v1beta1.TokenProperties.InvalidReason value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      invalidReason_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reason associated with the response when valid = false.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TokenProperties.InvalidReason invalid_reason = 2;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInvalidReason() {
      bitField0_ = (bitField0_ & ~0x00000002);
      invalidReason_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The timestamp corresponding to the generation of the token.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The timestamp corresponding to the generation of the token.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp corresponding to the generation of the token.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp corresponding to the generation of the token.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp corresponding to the generation of the token.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp corresponding to the generation of the token.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp corresponding to the generation of the token.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The timestamp corresponding to the generation of the token.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp corresponding to the generation of the token.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private java.lang.Object hostname_ = "";
    /**
     *
     *
     * <pre>
     * The hostname of the page on which the token was generated.
     * </pre>
     *
     * <code>string hostname = 4;</code>
     *
     * @return The hostname.
     */
    public java.lang.String getHostname() {
      java.lang.Object ref = hostname_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        hostname_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The hostname of the page on which the token was generated.
     * </pre>
     *
     * <code>string hostname = 4;</code>
     *
     * @return The bytes for hostname.
     */
    public com.google.protobuf.ByteString getHostnameBytes() {
      java.lang.Object ref = hostname_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        hostname_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The hostname of the page on which the token was generated.
     * </pre>
     *
     * <code>string hostname = 4;</code>
     *
     * @param value The hostname to set.
     * @return This builder for chaining.
     */
    public Builder setHostname(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      hostname_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The hostname of the page on which the token was generated.
     * </pre>
     *
     * <code>string hostname = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHostname() {
      hostname_ = getDefaultInstance().getHostname();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The hostname of the page on which the token was generated.
     * </pre>
     *
     * <code>string hostname = 4;</code>
     *
     * @param value The bytes for hostname to set.
     * @return This builder for chaining.
     */
    public Builder setHostnameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      hostname_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object action_ = "";
    /**
     *
     *
     * <pre>
     * Action name provided at token generation.
     * </pre>
     *
     * <code>string action = 5;</code>
     *
     * @return The action.
     */
    public java.lang.String getAction() {
      java.lang.Object ref = action_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        action_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Action name provided at token generation.
     * </pre>
     *
     * <code>string action = 5;</code>
     *
     * @return The bytes for action.
     */
    public com.google.protobuf.ByteString getActionBytes() {
      java.lang.Object ref = action_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        action_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Action name provided at token generation.
     * </pre>
     *
     * <code>string action = 5;</code>
     *
     * @param value The action to set.
     * @return This builder for chaining.
     */
    public Builder setAction(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      action_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action name provided at token generation.
     * </pre>
     *
     * <code>string action = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAction() {
      action_ = getDefaultInstance().getAction();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action name provided at token generation.
     * </pre>
     *
     * <code>string action = 5;</code>
     *
     * @param value The bytes for action to set.
     * @return This builder for chaining.
     */
    public Builder setActionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      action_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.recaptchaenterprise.v1beta1.TokenProperties)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.recaptchaenterprise.v1beta1.TokenProperties)
  private static final com.google.recaptchaenterprise.v1beta1.TokenProperties DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.recaptchaenterprise.v1beta1.TokenProperties();
  }

  public static com.google.recaptchaenterprise.v1beta1.TokenProperties getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TokenProperties> PARSER =
      new com.google.protobuf.AbstractParser<TokenProperties>() {
        @java.lang.Override
        public TokenProperties parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TokenProperties> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TokenProperties> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.TokenProperties getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
