/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommender.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InsightName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/insightTypes/{insight_type}/insights/{insight}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String insightType;
    private final String insight;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getInsightType() {
        return this.insightType;
    }

    public String getInsight() {
        return this.insight;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private InsightName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.insightType = (String)Preconditions.checkNotNull((Object)builder.getInsightType());
        this.insight = (String)Preconditions.checkNotNull((Object)builder.getInsight());
    }

    public static InsightName of(String project, String location, String insightType, String insight) {
        return InsightName.newBuilder().setProject(project).setLocation(location).setInsightType(insightType).setInsight(insight).build();
    }

    public static String format(String project, String location, String insightType, String insight) {
        return InsightName.newBuilder().setProject(project).setLocation(location).setInsightType(insightType).setInsight(insight).build().toString();
    }

    public static InsightName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "InsightName.parse: formattedString not in valid format");
        return InsightName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("insight_type"), (String)matchMap.get("insight"));
    }

    public static List<InsightName> parseList(List<String> formattedStrings) {
        ArrayList<InsightName> list = new ArrayList<InsightName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(InsightName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<InsightName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (InsightName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            InsightName insightName = this;
            synchronized (insightName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"insightType", (Object)this.insightType);
                    fieldMapBuilder.put((Object)"insight", (Object)this.insight);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "insight_type", this.insightType, "insight", this.insight});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InsightName) {
            InsightName that = (InsightName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.insightType.equals(that.insightType) && this.insight.equals(that.insight);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.insightType.hashCode();
        h *= 1000003;
        return h ^= this.insight.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String insightType;
        private String insight;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInsightType() {
            return this.insightType;
        }

        public String getInsight() {
            return this.insight;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setInsightType(String insightType) {
            this.insightType = insightType;
            return this;
        }

        public Builder setInsight(String insight) {
            this.insight = insight;
            return this;
        }

        private Builder() {
        }

        private Builder(InsightName insightName) {
            this.project = insightName.project;
            this.location = insightName.location;
            this.insightType = insightName.insightType;
            this.insight = insightName.insight;
        }

        public InsightName build() {
            return new InsightName(this);
        }
    }
}

