/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/recommender/v1/recommendation.proto

package com.google.cloud.recommender.v1;

/**
 *
 *
 * <pre>
 * Contains the impact a recommendation can have for a given category.
 * </pre>
 *
 * Protobuf type {@code google.cloud.recommender.v1.Impact}
 */
public final class Impact extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.recommender.v1.Impact)
    ImpactOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Impact.newBuilder() to construct.
  private Impact(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Impact() {
    category_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Impact();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.recommender.v1.RecommendationOuterClass
        .internal_static_google_cloud_recommender_v1_Impact_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.recommender.v1.RecommendationOuterClass
        .internal_static_google_cloud_recommender_v1_Impact_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.recommender.v1.Impact.class,
            com.google.cloud.recommender.v1.Impact.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The category of the impact.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.recommender.v1.Impact.Category}
   */
  public enum Category implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default unspecified category. Don't use directly.
     * </pre>
     *
     * <code>CATEGORY_UNSPECIFIED = 0;</code>
     */
    CATEGORY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Indicates a potential increase or decrease in cost.
     * </pre>
     *
     * <code>COST = 1;</code>
     */
    COST(1),
    /**
     *
     *
     * <pre>
     * Indicates a potential increase or decrease in security.
     * </pre>
     *
     * <code>SECURITY = 2;</code>
     */
    SECURITY(2),
    /**
     *
     *
     * <pre>
     * Indicates a potential increase or decrease in performance.
     * </pre>
     *
     * <code>PERFORMANCE = 3;</code>
     */
    PERFORMANCE(3),
    /**
     *
     *
     * <pre>
     * Indicates a potential increase or decrease in manageability.
     * </pre>
     *
     * <code>MANAGEABILITY = 4;</code>
     */
    MANAGEABILITY(4),
    /**
     *
     *
     * <pre>
     * Indicates a potential increase or decrease in sustainability.
     * </pre>
     *
     * <code>SUSTAINABILITY = 5;</code>
     */
    SUSTAINABILITY(5),
    /**
     *
     *
     * <pre>
     * Indicates a potential increase or decrease in reliability.
     * </pre>
     *
     * <code>RELIABILITY = 6;</code>
     */
    RELIABILITY(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default unspecified category. Don't use directly.
     * </pre>
     *
     * <code>CATEGORY_UNSPECIFIED = 0;</code>
     */
    public static final int CATEGORY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Indicates a potential increase or decrease in cost.
     * </pre>
     *
     * <code>COST = 1;</code>
     */
    public static final int COST_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Indicates a potential increase or decrease in security.
     * </pre>
     *
     * <code>SECURITY = 2;</code>
     */
    public static final int SECURITY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Indicates a potential increase or decrease in performance.
     * </pre>
     *
     * <code>PERFORMANCE = 3;</code>
     */
    public static final int PERFORMANCE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Indicates a potential increase or decrease in manageability.
     * </pre>
     *
     * <code>MANAGEABILITY = 4;</code>
     */
    public static final int MANAGEABILITY_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Indicates a potential increase or decrease in sustainability.
     * </pre>
     *
     * <code>SUSTAINABILITY = 5;</code>
     */
    public static final int SUSTAINABILITY_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Indicates a potential increase or decrease in reliability.
     * </pre>
     *
     * <code>RELIABILITY = 6;</code>
     */
    public static final int RELIABILITY_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Category valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Category forNumber(int value) {
      switch (value) {
        case 0:
          return CATEGORY_UNSPECIFIED;
        case 1:
          return COST;
        case 2:
          return SECURITY;
        case 3:
          return PERFORMANCE;
        case 4:
          return MANAGEABILITY;
        case 5:
          return SUSTAINABILITY;
        case 6:
          return RELIABILITY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Category> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Category> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Category>() {
          public Category findValueByNumber(int number) {
            return Category.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.recommender.v1.Impact.getDescriptor().getEnumTypes().get(0);
    }

    private static final Category[] VALUES = values();

    public static Category valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Category(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.recommender.v1.Impact.Category)
  }

  private int projectionCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object projection_;

  public enum ProjectionCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    COST_PROJECTION(100),
    SECURITY_PROJECTION(101),
    SUSTAINABILITY_PROJECTION(102),
    RELIABILITY_PROJECTION(103),
    PROJECTION_NOT_SET(0);
    private final int value;

    private ProjectionCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ProjectionCase valueOf(int value) {
      return forNumber(value);
    }

    public static ProjectionCase forNumber(int value) {
      switch (value) {
        case 100:
          return COST_PROJECTION;
        case 101:
          return SECURITY_PROJECTION;
        case 102:
          return SUSTAINABILITY_PROJECTION;
        case 103:
          return RELIABILITY_PROJECTION;
        case 0:
          return PROJECTION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ProjectionCase getProjectionCase() {
    return ProjectionCase.forNumber(projectionCase_);
  }

  public static final int CATEGORY_FIELD_NUMBER = 1;
  private int category_ = 0;
  /**
   *
   *
   * <pre>
   * Category that is being targeted.
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.Impact.Category category = 1;</code>
   *
   * @return The enum numeric value on the wire for category.
   */
  @java.lang.Override
  public int getCategoryValue() {
    return category_;
  }
  /**
   *
   *
   * <pre>
   * Category that is being targeted.
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.Impact.Category category = 1;</code>
   *
   * @return The category.
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.Impact.Category getCategory() {
    com.google.cloud.recommender.v1.Impact.Category result =
        com.google.cloud.recommender.v1.Impact.Category.forNumber(category_);
    return result == null ? com.google.cloud.recommender.v1.Impact.Category.UNRECOGNIZED : result;
  }

  public static final int COST_PROJECTION_FIELD_NUMBER = 100;
  /**
   *
   *
   * <pre>
   * Use with CategoryType.COST
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.CostProjection cost_projection = 100;</code>
   *
   * @return Whether the costProjection field is set.
   */
  @java.lang.Override
  public boolean hasCostProjection() {
    return projectionCase_ == 100;
  }
  /**
   *
   *
   * <pre>
   * Use with CategoryType.COST
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.CostProjection cost_projection = 100;</code>
   *
   * @return The costProjection.
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.CostProjection getCostProjection() {
    if (projectionCase_ == 100) {
      return (com.google.cloud.recommender.v1.CostProjection) projection_;
    }
    return com.google.cloud.recommender.v1.CostProjection.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Use with CategoryType.COST
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.CostProjection cost_projection = 100;</code>
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.CostProjectionOrBuilder getCostProjectionOrBuilder() {
    if (projectionCase_ == 100) {
      return (com.google.cloud.recommender.v1.CostProjection) projection_;
    }
    return com.google.cloud.recommender.v1.CostProjection.getDefaultInstance();
  }

  public static final int SECURITY_PROJECTION_FIELD_NUMBER = 101;
  /**
   *
   *
   * <pre>
   * Use with CategoryType.SECURITY
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.SecurityProjection security_projection = 101;</code>
   *
   * @return Whether the securityProjection field is set.
   */
  @java.lang.Override
  public boolean hasSecurityProjection() {
    return projectionCase_ == 101;
  }
  /**
   *
   *
   * <pre>
   * Use with CategoryType.SECURITY
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.SecurityProjection security_projection = 101;</code>
   *
   * @return The securityProjection.
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.SecurityProjection getSecurityProjection() {
    if (projectionCase_ == 101) {
      return (com.google.cloud.recommender.v1.SecurityProjection) projection_;
    }
    return com.google.cloud.recommender.v1.SecurityProjection.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Use with CategoryType.SECURITY
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.SecurityProjection security_projection = 101;</code>
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.SecurityProjectionOrBuilder
      getSecurityProjectionOrBuilder() {
    if (projectionCase_ == 101) {
      return (com.google.cloud.recommender.v1.SecurityProjection) projection_;
    }
    return com.google.cloud.recommender.v1.SecurityProjection.getDefaultInstance();
  }

  public static final int SUSTAINABILITY_PROJECTION_FIELD_NUMBER = 102;
  /**
   *
   *
   * <pre>
   * Use with CategoryType.SUSTAINABILITY
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.SustainabilityProjection sustainability_projection = 102;
   * </code>
   *
   * @return Whether the sustainabilityProjection field is set.
   */
  @java.lang.Override
  public boolean hasSustainabilityProjection() {
    return projectionCase_ == 102;
  }
  /**
   *
   *
   * <pre>
   * Use with CategoryType.SUSTAINABILITY
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.SustainabilityProjection sustainability_projection = 102;
   * </code>
   *
   * @return The sustainabilityProjection.
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.SustainabilityProjection getSustainabilityProjection() {
    if (projectionCase_ == 102) {
      return (com.google.cloud.recommender.v1.SustainabilityProjection) projection_;
    }
    return com.google.cloud.recommender.v1.SustainabilityProjection.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Use with CategoryType.SUSTAINABILITY
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.SustainabilityProjection sustainability_projection = 102;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.SustainabilityProjectionOrBuilder
      getSustainabilityProjectionOrBuilder() {
    if (projectionCase_ == 102) {
      return (com.google.cloud.recommender.v1.SustainabilityProjection) projection_;
    }
    return com.google.cloud.recommender.v1.SustainabilityProjection.getDefaultInstance();
  }

  public static final int RELIABILITY_PROJECTION_FIELD_NUMBER = 103;
  /**
   *
   *
   * <pre>
   * Use with CategoryType.RELIABILITY
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.ReliabilityProjection reliability_projection = 103;</code>
   *
   * @return Whether the reliabilityProjection field is set.
   */
  @java.lang.Override
  public boolean hasReliabilityProjection() {
    return projectionCase_ == 103;
  }
  /**
   *
   *
   * <pre>
   * Use with CategoryType.RELIABILITY
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.ReliabilityProjection reliability_projection = 103;</code>
   *
   * @return The reliabilityProjection.
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.ReliabilityProjection getReliabilityProjection() {
    if (projectionCase_ == 103) {
      return (com.google.cloud.recommender.v1.ReliabilityProjection) projection_;
    }
    return com.google.cloud.recommender.v1.ReliabilityProjection.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Use with CategoryType.RELIABILITY
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.ReliabilityProjection reliability_projection = 103;</code>
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.ReliabilityProjectionOrBuilder
      getReliabilityProjectionOrBuilder() {
    if (projectionCase_ == 103) {
      return (com.google.cloud.recommender.v1.ReliabilityProjection) projection_;
    }
    return com.google.cloud.recommender.v1.ReliabilityProjection.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (category_
        != com.google.cloud.recommender.v1.Impact.Category.CATEGORY_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, category_);
    }
    if (projectionCase_ == 100) {
      output.writeMessage(100, (com.google.cloud.recommender.v1.CostProjection) projection_);
    }
    if (projectionCase_ == 101) {
      output.writeMessage(101, (com.google.cloud.recommender.v1.SecurityProjection) projection_);
    }
    if (projectionCase_ == 102) {
      output.writeMessage(
          102, (com.google.cloud.recommender.v1.SustainabilityProjection) projection_);
    }
    if (projectionCase_ == 103) {
      output.writeMessage(103, (com.google.cloud.recommender.v1.ReliabilityProjection) projection_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (category_
        != com.google.cloud.recommender.v1.Impact.Category.CATEGORY_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, category_);
    }
    if (projectionCase_ == 100) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              100, (com.google.cloud.recommender.v1.CostProjection) projection_);
    }
    if (projectionCase_ == 101) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              101, (com.google.cloud.recommender.v1.SecurityProjection) projection_);
    }
    if (projectionCase_ == 102) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              102, (com.google.cloud.recommender.v1.SustainabilityProjection) projection_);
    }
    if (projectionCase_ == 103) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              103, (com.google.cloud.recommender.v1.ReliabilityProjection) projection_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.recommender.v1.Impact)) {
      return super.equals(obj);
    }
    com.google.cloud.recommender.v1.Impact other = (com.google.cloud.recommender.v1.Impact) obj;

    if (category_ != other.category_) return false;
    if (!getProjectionCase().equals(other.getProjectionCase())) return false;
    switch (projectionCase_) {
      case 100:
        if (!getCostProjection().equals(other.getCostProjection())) return false;
        break;
      case 101:
        if (!getSecurityProjection().equals(other.getSecurityProjection())) return false;
        break;
      case 102:
        if (!getSustainabilityProjection().equals(other.getSustainabilityProjection()))
          return false;
        break;
      case 103:
        if (!getReliabilityProjection().equals(other.getReliabilityProjection())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CATEGORY_FIELD_NUMBER;
    hash = (53 * hash) + category_;
    switch (projectionCase_) {
      case 100:
        hash = (37 * hash) + COST_PROJECTION_FIELD_NUMBER;
        hash = (53 * hash) + getCostProjection().hashCode();
        break;
      case 101:
        hash = (37 * hash) + SECURITY_PROJECTION_FIELD_NUMBER;
        hash = (53 * hash) + getSecurityProjection().hashCode();
        break;
      case 102:
        hash = (37 * hash) + SUSTAINABILITY_PROJECTION_FIELD_NUMBER;
        hash = (53 * hash) + getSustainabilityProjection().hashCode();
        break;
      case 103:
        hash = (37 * hash) + RELIABILITY_PROJECTION_FIELD_NUMBER;
        hash = (53 * hash) + getReliabilityProjection().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.recommender.v1.Impact parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.recommender.v1.Impact parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.recommender.v1.Impact parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.recommender.v1.Impact parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.recommender.v1.Impact parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.recommender.v1.Impact parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.recommender.v1.Impact parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.recommender.v1.Impact parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.recommender.v1.Impact parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.recommender.v1.Impact parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.recommender.v1.Impact parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.recommender.v1.Impact parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.recommender.v1.Impact prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Contains the impact a recommendation can have for a given category.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recommender.v1.Impact}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.recommender.v1.Impact)
      com.google.cloud.recommender.v1.ImpactOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.recommender.v1.RecommendationOuterClass
          .internal_static_google_cloud_recommender_v1_Impact_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.recommender.v1.RecommendationOuterClass
          .internal_static_google_cloud_recommender_v1_Impact_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.recommender.v1.Impact.class,
              com.google.cloud.recommender.v1.Impact.Builder.class);
    }

    // Construct using com.google.cloud.recommender.v1.Impact.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      category_ = 0;
      if (costProjectionBuilder_ != null) {
        costProjectionBuilder_.clear();
      }
      if (securityProjectionBuilder_ != null) {
        securityProjectionBuilder_.clear();
      }
      if (sustainabilityProjectionBuilder_ != null) {
        sustainabilityProjectionBuilder_.clear();
      }
      if (reliabilityProjectionBuilder_ != null) {
        reliabilityProjectionBuilder_.clear();
      }
      projectionCase_ = 0;
      projection_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.recommender.v1.RecommendationOuterClass
          .internal_static_google_cloud_recommender_v1_Impact_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.recommender.v1.Impact getDefaultInstanceForType() {
      return com.google.cloud.recommender.v1.Impact.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.recommender.v1.Impact build() {
      com.google.cloud.recommender.v1.Impact result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.recommender.v1.Impact buildPartial() {
      com.google.cloud.recommender.v1.Impact result =
          new com.google.cloud.recommender.v1.Impact(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.recommender.v1.Impact result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.category_ = category_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.recommender.v1.Impact result) {
      result.projectionCase_ = projectionCase_;
      result.projection_ = this.projection_;
      if (projectionCase_ == 100 && costProjectionBuilder_ != null) {
        result.projection_ = costProjectionBuilder_.build();
      }
      if (projectionCase_ == 101 && securityProjectionBuilder_ != null) {
        result.projection_ = securityProjectionBuilder_.build();
      }
      if (projectionCase_ == 102 && sustainabilityProjectionBuilder_ != null) {
        result.projection_ = sustainabilityProjectionBuilder_.build();
      }
      if (projectionCase_ == 103 && reliabilityProjectionBuilder_ != null) {
        result.projection_ = reliabilityProjectionBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.recommender.v1.Impact) {
        return mergeFrom((com.google.cloud.recommender.v1.Impact) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.recommender.v1.Impact other) {
      if (other == com.google.cloud.recommender.v1.Impact.getDefaultInstance()) return this;
      if (other.category_ != 0) {
        setCategoryValue(other.getCategoryValue());
      }
      switch (other.getProjectionCase()) {
        case COST_PROJECTION:
          {
            mergeCostProjection(other.getCostProjection());
            break;
          }
        case SECURITY_PROJECTION:
          {
            mergeSecurityProjection(other.getSecurityProjection());
            break;
          }
        case SUSTAINABILITY_PROJECTION:
          {
            mergeSustainabilityProjection(other.getSustainabilityProjection());
            break;
          }
        case RELIABILITY_PROJECTION:
          {
            mergeReliabilityProjection(other.getReliabilityProjection());
            break;
          }
        case PROJECTION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                category_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 802:
              {
                input.readMessage(getCostProjectionFieldBuilder().getBuilder(), extensionRegistry);
                projectionCase_ = 100;
                break;
              } // case 802
            case 810:
              {
                input.readMessage(
                    getSecurityProjectionFieldBuilder().getBuilder(), extensionRegistry);
                projectionCase_ = 101;
                break;
              } // case 810
            case 818:
              {
                input.readMessage(
                    getSustainabilityProjectionFieldBuilder().getBuilder(), extensionRegistry);
                projectionCase_ = 102;
                break;
              } // case 818
            case 826:
              {
                input.readMessage(
                    getReliabilityProjectionFieldBuilder().getBuilder(), extensionRegistry);
                projectionCase_ = 103;
                break;
              } // case 826
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int projectionCase_ = 0;
    private java.lang.Object projection_;

    public ProjectionCase getProjectionCase() {
      return ProjectionCase.forNumber(projectionCase_);
    }

    public Builder clearProjection() {
      projectionCase_ = 0;
      projection_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private int category_ = 0;
    /**
     *
     *
     * <pre>
     * Category that is being targeted.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Impact.Category category = 1;</code>
     *
     * @return The enum numeric value on the wire for category.
     */
    @java.lang.Override
    public int getCategoryValue() {
      return category_;
    }
    /**
     *
     *
     * <pre>
     * Category that is being targeted.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Impact.Category category = 1;</code>
     *
     * @param value The enum numeric value on the wire for category to set.
     * @return This builder for chaining.
     */
    public Builder setCategoryValue(int value) {
      category_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Category that is being targeted.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Impact.Category category = 1;</code>
     *
     * @return The category.
     */
    @java.lang.Override
    public com.google.cloud.recommender.v1.Impact.Category getCategory() {
      com.google.cloud.recommender.v1.Impact.Category result =
          com.google.cloud.recommender.v1.Impact.Category.forNumber(category_);
      return result == null ? com.google.cloud.recommender.v1.Impact.Category.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Category that is being targeted.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Impact.Category category = 1;</code>
     *
     * @param value The category to set.
     * @return This builder for chaining.
     */
    public Builder setCategory(com.google.cloud.recommender.v1.Impact.Category value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      category_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Category that is being targeted.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Impact.Category category = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCategory() {
      bitField0_ = (bitField0_ & ~0x00000001);
      category_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.recommender.v1.CostProjection,
            com.google.cloud.recommender.v1.CostProjection.Builder,
            com.google.cloud.recommender.v1.CostProjectionOrBuilder>
        costProjectionBuilder_;
    /**
     *
     *
     * <pre>
     * Use with CategoryType.COST
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.CostProjection cost_projection = 100;</code>
     *
     * @return Whether the costProjection field is set.
     */
    @java.lang.Override
    public boolean hasCostProjection() {
      return projectionCase_ == 100;
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.COST
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.CostProjection cost_projection = 100;</code>
     *
     * @return The costProjection.
     */
    @java.lang.Override
    public com.google.cloud.recommender.v1.CostProjection getCostProjection() {
      if (costProjectionBuilder_ == null) {
        if (projectionCase_ == 100) {
          return (com.google.cloud.recommender.v1.CostProjection) projection_;
        }
        return com.google.cloud.recommender.v1.CostProjection.getDefaultInstance();
      } else {
        if (projectionCase_ == 100) {
          return costProjectionBuilder_.getMessage();
        }
        return com.google.cloud.recommender.v1.CostProjection.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.COST
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.CostProjection cost_projection = 100;</code>
     */
    public Builder setCostProjection(com.google.cloud.recommender.v1.CostProjection value) {
      if (costProjectionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        projection_ = value;
        onChanged();
      } else {
        costProjectionBuilder_.setMessage(value);
      }
      projectionCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.COST
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.CostProjection cost_projection = 100;</code>
     */
    public Builder setCostProjection(
        com.google.cloud.recommender.v1.CostProjection.Builder builderForValue) {
      if (costProjectionBuilder_ == null) {
        projection_ = builderForValue.build();
        onChanged();
      } else {
        costProjectionBuilder_.setMessage(builderForValue.build());
      }
      projectionCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.COST
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.CostProjection cost_projection = 100;</code>
     */
    public Builder mergeCostProjection(com.google.cloud.recommender.v1.CostProjection value) {
      if (costProjectionBuilder_ == null) {
        if (projectionCase_ == 100
            && projection_ != com.google.cloud.recommender.v1.CostProjection.getDefaultInstance()) {
          projection_ =
              com.google.cloud.recommender.v1.CostProjection.newBuilder(
                      (com.google.cloud.recommender.v1.CostProjection) projection_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          projection_ = value;
        }
        onChanged();
      } else {
        if (projectionCase_ == 100) {
          costProjectionBuilder_.mergeFrom(value);
        } else {
          costProjectionBuilder_.setMessage(value);
        }
      }
      projectionCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.COST
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.CostProjection cost_projection = 100;</code>
     */
    public Builder clearCostProjection() {
      if (costProjectionBuilder_ == null) {
        if (projectionCase_ == 100) {
          projectionCase_ = 0;
          projection_ = null;
          onChanged();
        }
      } else {
        if (projectionCase_ == 100) {
          projectionCase_ = 0;
          projection_ = null;
        }
        costProjectionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.COST
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.CostProjection cost_projection = 100;</code>
     */
    public com.google.cloud.recommender.v1.CostProjection.Builder getCostProjectionBuilder() {
      return getCostProjectionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.COST
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.CostProjection cost_projection = 100;</code>
     */
    @java.lang.Override
    public com.google.cloud.recommender.v1.CostProjectionOrBuilder getCostProjectionOrBuilder() {
      if ((projectionCase_ == 100) && (costProjectionBuilder_ != null)) {
        return costProjectionBuilder_.getMessageOrBuilder();
      } else {
        if (projectionCase_ == 100) {
          return (com.google.cloud.recommender.v1.CostProjection) projection_;
        }
        return com.google.cloud.recommender.v1.CostProjection.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.COST
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.CostProjection cost_projection = 100;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.recommender.v1.CostProjection,
            com.google.cloud.recommender.v1.CostProjection.Builder,
            com.google.cloud.recommender.v1.CostProjectionOrBuilder>
        getCostProjectionFieldBuilder() {
      if (costProjectionBuilder_ == null) {
        if (!(projectionCase_ == 100)) {
          projection_ = com.google.cloud.recommender.v1.CostProjection.getDefaultInstance();
        }
        costProjectionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.recommender.v1.CostProjection,
                com.google.cloud.recommender.v1.CostProjection.Builder,
                com.google.cloud.recommender.v1.CostProjectionOrBuilder>(
                (com.google.cloud.recommender.v1.CostProjection) projection_,
                getParentForChildren(),
                isClean());
        projection_ = null;
      }
      projectionCase_ = 100;
      onChanged();
      return costProjectionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.recommender.v1.SecurityProjection,
            com.google.cloud.recommender.v1.SecurityProjection.Builder,
            com.google.cloud.recommender.v1.SecurityProjectionOrBuilder>
        securityProjectionBuilder_;
    /**
     *
     *
     * <pre>
     * Use with CategoryType.SECURITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.SecurityProjection security_projection = 101;</code>
     *
     * @return Whether the securityProjection field is set.
     */
    @java.lang.Override
    public boolean hasSecurityProjection() {
      return projectionCase_ == 101;
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.SECURITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.SecurityProjection security_projection = 101;</code>
     *
     * @return The securityProjection.
     */
    @java.lang.Override
    public com.google.cloud.recommender.v1.SecurityProjection getSecurityProjection() {
      if (securityProjectionBuilder_ == null) {
        if (projectionCase_ == 101) {
          return (com.google.cloud.recommender.v1.SecurityProjection) projection_;
        }
        return com.google.cloud.recommender.v1.SecurityProjection.getDefaultInstance();
      } else {
        if (projectionCase_ == 101) {
          return securityProjectionBuilder_.getMessage();
        }
        return com.google.cloud.recommender.v1.SecurityProjection.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.SECURITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.SecurityProjection security_projection = 101;</code>
     */
    public Builder setSecurityProjection(com.google.cloud.recommender.v1.SecurityProjection value) {
      if (securityProjectionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        projection_ = value;
        onChanged();
      } else {
        securityProjectionBuilder_.setMessage(value);
      }
      projectionCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.SECURITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.SecurityProjection security_projection = 101;</code>
     */
    public Builder setSecurityProjection(
        com.google.cloud.recommender.v1.SecurityProjection.Builder builderForValue) {
      if (securityProjectionBuilder_ == null) {
        projection_ = builderForValue.build();
        onChanged();
      } else {
        securityProjectionBuilder_.setMessage(builderForValue.build());
      }
      projectionCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.SECURITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.SecurityProjection security_projection = 101;</code>
     */
    public Builder mergeSecurityProjection(
        com.google.cloud.recommender.v1.SecurityProjection value) {
      if (securityProjectionBuilder_ == null) {
        if (projectionCase_ == 101
            && projection_
                != com.google.cloud.recommender.v1.SecurityProjection.getDefaultInstance()) {
          projection_ =
              com.google.cloud.recommender.v1.SecurityProjection.newBuilder(
                      (com.google.cloud.recommender.v1.SecurityProjection) projection_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          projection_ = value;
        }
        onChanged();
      } else {
        if (projectionCase_ == 101) {
          securityProjectionBuilder_.mergeFrom(value);
        } else {
          securityProjectionBuilder_.setMessage(value);
        }
      }
      projectionCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.SECURITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.SecurityProjection security_projection = 101;</code>
     */
    public Builder clearSecurityProjection() {
      if (securityProjectionBuilder_ == null) {
        if (projectionCase_ == 101) {
          projectionCase_ = 0;
          projection_ = null;
          onChanged();
        }
      } else {
        if (projectionCase_ == 101) {
          projectionCase_ = 0;
          projection_ = null;
        }
        securityProjectionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.SECURITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.SecurityProjection security_projection = 101;</code>
     */
    public com.google.cloud.recommender.v1.SecurityProjection.Builder
        getSecurityProjectionBuilder() {
      return getSecurityProjectionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.SECURITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.SecurityProjection security_projection = 101;</code>
     */
    @java.lang.Override
    public com.google.cloud.recommender.v1.SecurityProjectionOrBuilder
        getSecurityProjectionOrBuilder() {
      if ((projectionCase_ == 101) && (securityProjectionBuilder_ != null)) {
        return securityProjectionBuilder_.getMessageOrBuilder();
      } else {
        if (projectionCase_ == 101) {
          return (com.google.cloud.recommender.v1.SecurityProjection) projection_;
        }
        return com.google.cloud.recommender.v1.SecurityProjection.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.SECURITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.SecurityProjection security_projection = 101;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.recommender.v1.SecurityProjection,
            com.google.cloud.recommender.v1.SecurityProjection.Builder,
            com.google.cloud.recommender.v1.SecurityProjectionOrBuilder>
        getSecurityProjectionFieldBuilder() {
      if (securityProjectionBuilder_ == null) {
        if (!(projectionCase_ == 101)) {
          projection_ = com.google.cloud.recommender.v1.SecurityProjection.getDefaultInstance();
        }
        securityProjectionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.recommender.v1.SecurityProjection,
                com.google.cloud.recommender.v1.SecurityProjection.Builder,
                com.google.cloud.recommender.v1.SecurityProjectionOrBuilder>(
                (com.google.cloud.recommender.v1.SecurityProjection) projection_,
                getParentForChildren(),
                isClean());
        projection_ = null;
      }
      projectionCase_ = 101;
      onChanged();
      return securityProjectionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.recommender.v1.SustainabilityProjection,
            com.google.cloud.recommender.v1.SustainabilityProjection.Builder,
            com.google.cloud.recommender.v1.SustainabilityProjectionOrBuilder>
        sustainabilityProjectionBuilder_;
    /**
     *
     *
     * <pre>
     * Use with CategoryType.SUSTAINABILITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.SustainabilityProjection sustainability_projection = 102;
     * </code>
     *
     * @return Whether the sustainabilityProjection field is set.
     */
    @java.lang.Override
    public boolean hasSustainabilityProjection() {
      return projectionCase_ == 102;
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.SUSTAINABILITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.SustainabilityProjection sustainability_projection = 102;
     * </code>
     *
     * @return The sustainabilityProjection.
     */
    @java.lang.Override
    public com.google.cloud.recommender.v1.SustainabilityProjection getSustainabilityProjection() {
      if (sustainabilityProjectionBuilder_ == null) {
        if (projectionCase_ == 102) {
          return (com.google.cloud.recommender.v1.SustainabilityProjection) projection_;
        }
        return com.google.cloud.recommender.v1.SustainabilityProjection.getDefaultInstance();
      } else {
        if (projectionCase_ == 102) {
          return sustainabilityProjectionBuilder_.getMessage();
        }
        return com.google.cloud.recommender.v1.SustainabilityProjection.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.SUSTAINABILITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.SustainabilityProjection sustainability_projection = 102;
     * </code>
     */
    public Builder setSustainabilityProjection(
        com.google.cloud.recommender.v1.SustainabilityProjection value) {
      if (sustainabilityProjectionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        projection_ = value;
        onChanged();
      } else {
        sustainabilityProjectionBuilder_.setMessage(value);
      }
      projectionCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.SUSTAINABILITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.SustainabilityProjection sustainability_projection = 102;
     * </code>
     */
    public Builder setSustainabilityProjection(
        com.google.cloud.recommender.v1.SustainabilityProjection.Builder builderForValue) {
      if (sustainabilityProjectionBuilder_ == null) {
        projection_ = builderForValue.build();
        onChanged();
      } else {
        sustainabilityProjectionBuilder_.setMessage(builderForValue.build());
      }
      projectionCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.SUSTAINABILITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.SustainabilityProjection sustainability_projection = 102;
     * </code>
     */
    public Builder mergeSustainabilityProjection(
        com.google.cloud.recommender.v1.SustainabilityProjection value) {
      if (sustainabilityProjectionBuilder_ == null) {
        if (projectionCase_ == 102
            && projection_
                != com.google.cloud.recommender.v1.SustainabilityProjection.getDefaultInstance()) {
          projection_ =
              com.google.cloud.recommender.v1.SustainabilityProjection.newBuilder(
                      (com.google.cloud.recommender.v1.SustainabilityProjection) projection_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          projection_ = value;
        }
        onChanged();
      } else {
        if (projectionCase_ == 102) {
          sustainabilityProjectionBuilder_.mergeFrom(value);
        } else {
          sustainabilityProjectionBuilder_.setMessage(value);
        }
      }
      projectionCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.SUSTAINABILITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.SustainabilityProjection sustainability_projection = 102;
     * </code>
     */
    public Builder clearSustainabilityProjection() {
      if (sustainabilityProjectionBuilder_ == null) {
        if (projectionCase_ == 102) {
          projectionCase_ = 0;
          projection_ = null;
          onChanged();
        }
      } else {
        if (projectionCase_ == 102) {
          projectionCase_ = 0;
          projection_ = null;
        }
        sustainabilityProjectionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.SUSTAINABILITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.SustainabilityProjection sustainability_projection = 102;
     * </code>
     */
    public com.google.cloud.recommender.v1.SustainabilityProjection.Builder
        getSustainabilityProjectionBuilder() {
      return getSustainabilityProjectionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.SUSTAINABILITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.SustainabilityProjection sustainability_projection = 102;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.recommender.v1.SustainabilityProjectionOrBuilder
        getSustainabilityProjectionOrBuilder() {
      if ((projectionCase_ == 102) && (sustainabilityProjectionBuilder_ != null)) {
        return sustainabilityProjectionBuilder_.getMessageOrBuilder();
      } else {
        if (projectionCase_ == 102) {
          return (com.google.cloud.recommender.v1.SustainabilityProjection) projection_;
        }
        return com.google.cloud.recommender.v1.SustainabilityProjection.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.SUSTAINABILITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.SustainabilityProjection sustainability_projection = 102;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.recommender.v1.SustainabilityProjection,
            com.google.cloud.recommender.v1.SustainabilityProjection.Builder,
            com.google.cloud.recommender.v1.SustainabilityProjectionOrBuilder>
        getSustainabilityProjectionFieldBuilder() {
      if (sustainabilityProjectionBuilder_ == null) {
        if (!(projectionCase_ == 102)) {
          projection_ =
              com.google.cloud.recommender.v1.SustainabilityProjection.getDefaultInstance();
        }
        sustainabilityProjectionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.recommender.v1.SustainabilityProjection,
                com.google.cloud.recommender.v1.SustainabilityProjection.Builder,
                com.google.cloud.recommender.v1.SustainabilityProjectionOrBuilder>(
                (com.google.cloud.recommender.v1.SustainabilityProjection) projection_,
                getParentForChildren(),
                isClean());
        projection_ = null;
      }
      projectionCase_ = 102;
      onChanged();
      return sustainabilityProjectionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.recommender.v1.ReliabilityProjection,
            com.google.cloud.recommender.v1.ReliabilityProjection.Builder,
            com.google.cloud.recommender.v1.ReliabilityProjectionOrBuilder>
        reliabilityProjectionBuilder_;
    /**
     *
     *
     * <pre>
     * Use with CategoryType.RELIABILITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.ReliabilityProjection reliability_projection = 103;</code>
     *
     * @return Whether the reliabilityProjection field is set.
     */
    @java.lang.Override
    public boolean hasReliabilityProjection() {
      return projectionCase_ == 103;
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.RELIABILITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.ReliabilityProjection reliability_projection = 103;</code>
     *
     * @return The reliabilityProjection.
     */
    @java.lang.Override
    public com.google.cloud.recommender.v1.ReliabilityProjection getReliabilityProjection() {
      if (reliabilityProjectionBuilder_ == null) {
        if (projectionCase_ == 103) {
          return (com.google.cloud.recommender.v1.ReliabilityProjection) projection_;
        }
        return com.google.cloud.recommender.v1.ReliabilityProjection.getDefaultInstance();
      } else {
        if (projectionCase_ == 103) {
          return reliabilityProjectionBuilder_.getMessage();
        }
        return com.google.cloud.recommender.v1.ReliabilityProjection.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.RELIABILITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.ReliabilityProjection reliability_projection = 103;</code>
     */
    public Builder setReliabilityProjection(
        com.google.cloud.recommender.v1.ReliabilityProjection value) {
      if (reliabilityProjectionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        projection_ = value;
        onChanged();
      } else {
        reliabilityProjectionBuilder_.setMessage(value);
      }
      projectionCase_ = 103;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.RELIABILITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.ReliabilityProjection reliability_projection = 103;</code>
     */
    public Builder setReliabilityProjection(
        com.google.cloud.recommender.v1.ReliabilityProjection.Builder builderForValue) {
      if (reliabilityProjectionBuilder_ == null) {
        projection_ = builderForValue.build();
        onChanged();
      } else {
        reliabilityProjectionBuilder_.setMessage(builderForValue.build());
      }
      projectionCase_ = 103;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.RELIABILITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.ReliabilityProjection reliability_projection = 103;</code>
     */
    public Builder mergeReliabilityProjection(
        com.google.cloud.recommender.v1.ReliabilityProjection value) {
      if (reliabilityProjectionBuilder_ == null) {
        if (projectionCase_ == 103
            && projection_
                != com.google.cloud.recommender.v1.ReliabilityProjection.getDefaultInstance()) {
          projection_ =
              com.google.cloud.recommender.v1.ReliabilityProjection.newBuilder(
                      (com.google.cloud.recommender.v1.ReliabilityProjection) projection_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          projection_ = value;
        }
        onChanged();
      } else {
        if (projectionCase_ == 103) {
          reliabilityProjectionBuilder_.mergeFrom(value);
        } else {
          reliabilityProjectionBuilder_.setMessage(value);
        }
      }
      projectionCase_ = 103;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.RELIABILITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.ReliabilityProjection reliability_projection = 103;</code>
     */
    public Builder clearReliabilityProjection() {
      if (reliabilityProjectionBuilder_ == null) {
        if (projectionCase_ == 103) {
          projectionCase_ = 0;
          projection_ = null;
          onChanged();
        }
      } else {
        if (projectionCase_ == 103) {
          projectionCase_ = 0;
          projection_ = null;
        }
        reliabilityProjectionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.RELIABILITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.ReliabilityProjection reliability_projection = 103;</code>
     */
    public com.google.cloud.recommender.v1.ReliabilityProjection.Builder
        getReliabilityProjectionBuilder() {
      return getReliabilityProjectionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.RELIABILITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.ReliabilityProjection reliability_projection = 103;</code>
     */
    @java.lang.Override
    public com.google.cloud.recommender.v1.ReliabilityProjectionOrBuilder
        getReliabilityProjectionOrBuilder() {
      if ((projectionCase_ == 103) && (reliabilityProjectionBuilder_ != null)) {
        return reliabilityProjectionBuilder_.getMessageOrBuilder();
      } else {
        if (projectionCase_ == 103) {
          return (com.google.cloud.recommender.v1.ReliabilityProjection) projection_;
        }
        return com.google.cloud.recommender.v1.ReliabilityProjection.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Use with CategoryType.RELIABILITY
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.ReliabilityProjection reliability_projection = 103;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.recommender.v1.ReliabilityProjection,
            com.google.cloud.recommender.v1.ReliabilityProjection.Builder,
            com.google.cloud.recommender.v1.ReliabilityProjectionOrBuilder>
        getReliabilityProjectionFieldBuilder() {
      if (reliabilityProjectionBuilder_ == null) {
        if (!(projectionCase_ == 103)) {
          projection_ = com.google.cloud.recommender.v1.ReliabilityProjection.getDefaultInstance();
        }
        reliabilityProjectionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.recommender.v1.ReliabilityProjection,
                com.google.cloud.recommender.v1.ReliabilityProjection.Builder,
                com.google.cloud.recommender.v1.ReliabilityProjectionOrBuilder>(
                (com.google.cloud.recommender.v1.ReliabilityProjection) projection_,
                getParentForChildren(),
                isClean());
        projection_ = null;
      }
      projectionCase_ = 103;
      onChanged();
      return reliabilityProjectionBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.recommender.v1.Impact)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.recommender.v1.Impact)
  private static final com.google.cloud.recommender.v1.Impact DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.recommender.v1.Impact();
  }

  public static com.google.cloud.recommender.v1.Impact getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Impact> PARSER =
      new com.google.protobuf.AbstractParser<Impact>() {
        @java.lang.Override
        public Impact parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Impact> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Impact> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.recommender.v1.Impact getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
