/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/recommender/v1/insight.proto

package com.google.cloud.recommender.v1;

/**
 *
 *
 * <pre>
 * An insight along with the information used to derive the insight. The insight
 * may have associated recommendations as well.
 * </pre>
 *
 * Protobuf type {@code google.cloud.recommender.v1.Insight}
 */
public final class Insight extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.recommender.v1.Insight)
    InsightOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Insight.newBuilder() to construct.
  private Insight(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Insight() {
    name_ = "";
    description_ = "";
    targetResources_ = com.google.protobuf.LazyStringArrayList.emptyList();
    insightSubtype_ = "";
    category_ = 0;
    severity_ = 0;
    etag_ = "";
    associatedRecommendations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Insight();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.recommender.v1.InsightProto
        .internal_static_google_cloud_recommender_v1_Insight_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.recommender.v1.InsightProto
        .internal_static_google_cloud_recommender_v1_Insight_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.recommender.v1.Insight.class,
            com.google.cloud.recommender.v1.Insight.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Insight category.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.recommender.v1.Insight.Category}
   */
  public enum Category implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified category.
     * </pre>
     *
     * <code>CATEGORY_UNSPECIFIED = 0;</code>
     */
    CATEGORY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The insight is related to cost.
     * </pre>
     *
     * <code>COST = 1;</code>
     */
    COST(1),
    /**
     *
     *
     * <pre>
     * The insight is related to security.
     * </pre>
     *
     * <code>SECURITY = 2;</code>
     */
    SECURITY(2),
    /**
     *
     *
     * <pre>
     * The insight is related to performance.
     * </pre>
     *
     * <code>PERFORMANCE = 3;</code>
     */
    PERFORMANCE(3),
    /**
     *
     *
     * <pre>
     * This insight is related to manageability.
     * </pre>
     *
     * <code>MANAGEABILITY = 4;</code>
     */
    MANAGEABILITY(4),
    /**
     *
     *
     * <pre>
     * The insight is related to sustainability.
     * </pre>
     *
     * <code>SUSTAINABILITY = 5;</code>
     */
    SUSTAINABILITY(5),
    /**
     *
     *
     * <pre>
     * This insight is related to reliability.
     * </pre>
     *
     * <code>RELIABILITY = 6;</code>
     */
    RELIABILITY(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified category.
     * </pre>
     *
     * <code>CATEGORY_UNSPECIFIED = 0;</code>
     */
    public static final int CATEGORY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The insight is related to cost.
     * </pre>
     *
     * <code>COST = 1;</code>
     */
    public static final int COST_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The insight is related to security.
     * </pre>
     *
     * <code>SECURITY = 2;</code>
     */
    public static final int SECURITY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The insight is related to performance.
     * </pre>
     *
     * <code>PERFORMANCE = 3;</code>
     */
    public static final int PERFORMANCE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * This insight is related to manageability.
     * </pre>
     *
     * <code>MANAGEABILITY = 4;</code>
     */
    public static final int MANAGEABILITY_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The insight is related to sustainability.
     * </pre>
     *
     * <code>SUSTAINABILITY = 5;</code>
     */
    public static final int SUSTAINABILITY_VALUE = 5;
    /**
     *
     *
     * <pre>
     * This insight is related to reliability.
     * </pre>
     *
     * <code>RELIABILITY = 6;</code>
     */
    public static final int RELIABILITY_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Category valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Category forNumber(int value) {
      switch (value) {
        case 0:
          return CATEGORY_UNSPECIFIED;
        case 1:
          return COST;
        case 2:
          return SECURITY;
        case 3:
          return PERFORMANCE;
        case 4:
          return MANAGEABILITY;
        case 5:
          return SUSTAINABILITY;
        case 6:
          return RELIABILITY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Category> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Category> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Category>() {
          public Category findValueByNumber(int number) {
            return Category.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.recommender.v1.Insight.getDescriptor().getEnumTypes().get(0);
    }

    private static final Category[] VALUES = values();

    public static Category valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Category(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.recommender.v1.Insight.Category)
  }

  /**
   *
   *
   * <pre>
   * Insight severity levels.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.recommender.v1.Insight.Severity}
   */
  public enum Severity implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Insight has unspecified severity.
     * </pre>
     *
     * <code>SEVERITY_UNSPECIFIED = 0;</code>
     */
    SEVERITY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Insight has low severity.
     * </pre>
     *
     * <code>LOW = 1;</code>
     */
    LOW(1),
    /**
     *
     *
     * <pre>
     * Insight has medium severity.
     * </pre>
     *
     * <code>MEDIUM = 2;</code>
     */
    MEDIUM(2),
    /**
     *
     *
     * <pre>
     * Insight has high severity.
     * </pre>
     *
     * <code>HIGH = 3;</code>
     */
    HIGH(3),
    /**
     *
     *
     * <pre>
     * Insight has critical severity.
     * </pre>
     *
     * <code>CRITICAL = 4;</code>
     */
    CRITICAL(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Insight has unspecified severity.
     * </pre>
     *
     * <code>SEVERITY_UNSPECIFIED = 0;</code>
     */
    public static final int SEVERITY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Insight has low severity.
     * </pre>
     *
     * <code>LOW = 1;</code>
     */
    public static final int LOW_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Insight has medium severity.
     * </pre>
     *
     * <code>MEDIUM = 2;</code>
     */
    public static final int MEDIUM_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Insight has high severity.
     * </pre>
     *
     * <code>HIGH = 3;</code>
     */
    public static final int HIGH_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Insight has critical severity.
     * </pre>
     *
     * <code>CRITICAL = 4;</code>
     */
    public static final int CRITICAL_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Severity valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Severity forNumber(int value) {
      switch (value) {
        case 0:
          return SEVERITY_UNSPECIFIED;
        case 1:
          return LOW;
        case 2:
          return MEDIUM;
        case 3:
          return HIGH;
        case 4:
          return CRITICAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Severity> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Severity> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Severity>() {
          public Severity findValueByNumber(int number) {
            return Severity.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.recommender.v1.Insight.getDescriptor().getEnumTypes().get(1);
    }

    private static final Severity[] VALUES = values();

    public static Severity valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Severity(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.recommender.v1.Insight.Severity)
  }

  public interface RecommendationReferenceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.recommender.v1.Insight.RecommendationReference)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Recommendation resource name, e.g.
     * projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]/recommendations/[RECOMMENDATION_ID]
     * </pre>
     *
     * <code>string recommendation = 1;</code>
     *
     * @return The recommendation.
     */
    java.lang.String getRecommendation();
    /**
     *
     *
     * <pre>
     * Recommendation resource name, e.g.
     * projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]/recommendations/[RECOMMENDATION_ID]
     * </pre>
     *
     * <code>string recommendation = 1;</code>
     *
     * @return The bytes for recommendation.
     */
    com.google.protobuf.ByteString getRecommendationBytes();
  }
  /**
   *
   *
   * <pre>
   * Reference to an associated recommendation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recommender.v1.Insight.RecommendationReference}
   */
  public static final class RecommendationReference extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.recommender.v1.Insight.RecommendationReference)
      RecommendationReferenceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use RecommendationReference.newBuilder() to construct.
    private RecommendationReference(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RecommendationReference() {
      recommendation_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RecommendationReference();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.recommender.v1.InsightProto
          .internal_static_google_cloud_recommender_v1_Insight_RecommendationReference_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.recommender.v1.InsightProto
          .internal_static_google_cloud_recommender_v1_Insight_RecommendationReference_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.recommender.v1.Insight.RecommendationReference.class,
              com.google.cloud.recommender.v1.Insight.RecommendationReference.Builder.class);
    }

    public static final int RECOMMENDATION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object recommendation_ = "";
    /**
     *
     *
     * <pre>
     * Recommendation resource name, e.g.
     * projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]/recommendations/[RECOMMENDATION_ID]
     * </pre>
     *
     * <code>string recommendation = 1;</code>
     *
     * @return The recommendation.
     */
    @java.lang.Override
    public java.lang.String getRecommendation() {
      java.lang.Object ref = recommendation_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        recommendation_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Recommendation resource name, e.g.
     * projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]/recommendations/[RECOMMENDATION_ID]
     * </pre>
     *
     * <code>string recommendation = 1;</code>
     *
     * @return The bytes for recommendation.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRecommendationBytes() {
      java.lang.Object ref = recommendation_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        recommendation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(recommendation_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, recommendation_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(recommendation_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, recommendation_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.recommender.v1.Insight.RecommendationReference)) {
        return super.equals(obj);
      }
      com.google.cloud.recommender.v1.Insight.RecommendationReference other =
          (com.google.cloud.recommender.v1.Insight.RecommendationReference) obj;

      if (!getRecommendation().equals(other.getRecommendation())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + RECOMMENDATION_FIELD_NUMBER;
      hash = (53 * hash) + getRecommendation().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.recommender.v1.Insight.RecommendationReference parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.recommender.v1.Insight.RecommendationReference parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.recommender.v1.Insight.RecommendationReference parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.recommender.v1.Insight.RecommendationReference parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.recommender.v1.Insight.RecommendationReference parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.recommender.v1.Insight.RecommendationReference parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.recommender.v1.Insight.RecommendationReference parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.recommender.v1.Insight.RecommendationReference parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.recommender.v1.Insight.RecommendationReference
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.recommender.v1.Insight.RecommendationReference
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.recommender.v1.Insight.RecommendationReference parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.recommender.v1.Insight.RecommendationReference parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.recommender.v1.Insight.RecommendationReference prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Reference to an associated recommendation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.recommender.v1.Insight.RecommendationReference}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.recommender.v1.Insight.RecommendationReference)
        com.google.cloud.recommender.v1.Insight.RecommendationReferenceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.recommender.v1.InsightProto
            .internal_static_google_cloud_recommender_v1_Insight_RecommendationReference_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.recommender.v1.InsightProto
            .internal_static_google_cloud_recommender_v1_Insight_RecommendationReference_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.recommender.v1.Insight.RecommendationReference.class,
                com.google.cloud.recommender.v1.Insight.RecommendationReference.Builder.class);
      }

      // Construct using
      // com.google.cloud.recommender.v1.Insight.RecommendationReference.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        recommendation_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.recommender.v1.InsightProto
            .internal_static_google_cloud_recommender_v1_Insight_RecommendationReference_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.recommender.v1.Insight.RecommendationReference
          getDefaultInstanceForType() {
        return com.google.cloud.recommender.v1.Insight.RecommendationReference.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.recommender.v1.Insight.RecommendationReference build() {
        com.google.cloud.recommender.v1.Insight.RecommendationReference result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.recommender.v1.Insight.RecommendationReference buildPartial() {
        com.google.cloud.recommender.v1.Insight.RecommendationReference result =
            new com.google.cloud.recommender.v1.Insight.RecommendationReference(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.recommender.v1.Insight.RecommendationReference result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.recommendation_ = recommendation_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.recommender.v1.Insight.RecommendationReference) {
          return mergeFrom((com.google.cloud.recommender.v1.Insight.RecommendationReference) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.recommender.v1.Insight.RecommendationReference other) {
        if (other
            == com.google.cloud.recommender.v1.Insight.RecommendationReference.getDefaultInstance())
          return this;
        if (!other.getRecommendation().isEmpty()) {
          recommendation_ = other.recommendation_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  recommendation_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object recommendation_ = "";
      /**
       *
       *
       * <pre>
       * Recommendation resource name, e.g.
       * projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]/recommendations/[RECOMMENDATION_ID]
       * </pre>
       *
       * <code>string recommendation = 1;</code>
       *
       * @return The recommendation.
       */
      public java.lang.String getRecommendation() {
        java.lang.Object ref = recommendation_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          recommendation_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Recommendation resource name, e.g.
       * projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]/recommendations/[RECOMMENDATION_ID]
       * </pre>
       *
       * <code>string recommendation = 1;</code>
       *
       * @return The bytes for recommendation.
       */
      public com.google.protobuf.ByteString getRecommendationBytes() {
        java.lang.Object ref = recommendation_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          recommendation_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Recommendation resource name, e.g.
       * projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]/recommendations/[RECOMMENDATION_ID]
       * </pre>
       *
       * <code>string recommendation = 1;</code>
       *
       * @param value The recommendation to set.
       * @return This builder for chaining.
       */
      public Builder setRecommendation(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        recommendation_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Recommendation resource name, e.g.
       * projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]/recommendations/[RECOMMENDATION_ID]
       * </pre>
       *
       * <code>string recommendation = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRecommendation() {
        recommendation_ = getDefaultInstance().getRecommendation();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Recommendation resource name, e.g.
       * projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]/recommendations/[RECOMMENDATION_ID]
       * </pre>
       *
       * <code>string recommendation = 1;</code>
       *
       * @param value The bytes for recommendation to set.
       * @return This builder for chaining.
       */
      public Builder setRecommendationBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        recommendation_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.recommender.v1.Insight.RecommendationReference)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.recommender.v1.Insight.RecommendationReference)
    private static final com.google.cloud.recommender.v1.Insight.RecommendationReference
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.recommender.v1.Insight.RecommendationReference();
    }

    public static com.google.cloud.recommender.v1.Insight.RecommendationReference
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RecommendationReference> PARSER =
        new com.google.protobuf.AbstractParser<RecommendationReference>() {
          @java.lang.Override
          public RecommendationReference parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RecommendationReference> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RecommendationReference> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.recommender.v1.Insight.RecommendationReference
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Name of the insight.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the insight.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Free-form human readable summary in English. The maximum length is 500
   * characters.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Free-form human readable summary in English. The maximum length is 500
   * characters.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_RESOURCES_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList targetResources_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Fully qualified resource names that this insight is targeting.
   * </pre>
   *
   * <code>repeated string target_resources = 9;</code>
   *
   * @return A list containing the targetResources.
   */
  public com.google.protobuf.ProtocolStringList getTargetResourcesList() {
    return targetResources_;
  }
  /**
   *
   *
   * <pre>
   * Fully qualified resource names that this insight is targeting.
   * </pre>
   *
   * <code>repeated string target_resources = 9;</code>
   *
   * @return The count of targetResources.
   */
  public int getTargetResourcesCount() {
    return targetResources_.size();
  }
  /**
   *
   *
   * <pre>
   * Fully qualified resource names that this insight is targeting.
   * </pre>
   *
   * <code>repeated string target_resources = 9;</code>
   *
   * @param index The index of the element to return.
   * @return The targetResources at the given index.
   */
  public java.lang.String getTargetResources(int index) {
    return targetResources_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Fully qualified resource names that this insight is targeting.
   * </pre>
   *
   * <code>repeated string target_resources = 9;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the targetResources at the given index.
   */
  public com.google.protobuf.ByteString getTargetResourcesBytes(int index) {
    return targetResources_.getByteString(index);
  }

  public static final int INSIGHT_SUBTYPE_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object insightSubtype_ = "";
  /**
   *
   *
   * <pre>
   * Insight subtype. Insight content schema will be stable for a given subtype.
   * </pre>
   *
   * <code>string insight_subtype = 10;</code>
   *
   * @return The insightSubtype.
   */
  @java.lang.Override
  public java.lang.String getInsightSubtype() {
    java.lang.Object ref = insightSubtype_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      insightSubtype_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Insight subtype. Insight content schema will be stable for a given subtype.
   * </pre>
   *
   * <code>string insight_subtype = 10;</code>
   *
   * @return The bytes for insightSubtype.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInsightSubtypeBytes() {
    java.lang.Object ref = insightSubtype_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      insightSubtype_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTENT_FIELD_NUMBER = 3;
  private com.google.protobuf.Struct content_;
  /**
   *
   *
   * <pre>
   * A struct of custom fields to explain the insight.
   * Example: "grantedPermissionsCount": "1000"
   * </pre>
   *
   * <code>.google.protobuf.Struct content = 3;</code>
   *
   * @return Whether the content field is set.
   */
  @java.lang.Override
  public boolean hasContent() {
    return content_ != null;
  }
  /**
   *
   *
   * <pre>
   * A struct of custom fields to explain the insight.
   * Example: "grantedPermissionsCount": "1000"
   * </pre>
   *
   * <code>.google.protobuf.Struct content = 3;</code>
   *
   * @return The content.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getContent() {
    return content_ == null ? com.google.protobuf.Struct.getDefaultInstance() : content_;
  }
  /**
   *
   *
   * <pre>
   * A struct of custom fields to explain the insight.
   * Example: "grantedPermissionsCount": "1000"
   * </pre>
   *
   * <code>.google.protobuf.Struct content = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getContentOrBuilder() {
    return content_ == null ? com.google.protobuf.Struct.getDefaultInstance() : content_;
  }

  public static final int LAST_REFRESH_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp lastRefreshTime_;
  /**
   *
   *
   * <pre>
   * Timestamp of the latest data used to generate the insight.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_refresh_time = 4;</code>
   *
   * @return Whether the lastRefreshTime field is set.
   */
  @java.lang.Override
  public boolean hasLastRefreshTime() {
    return lastRefreshTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Timestamp of the latest data used to generate the insight.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_refresh_time = 4;</code>
   *
   * @return The lastRefreshTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastRefreshTime() {
    return lastRefreshTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastRefreshTime_;
  }
  /**
   *
   *
   * <pre>
   * Timestamp of the latest data used to generate the insight.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_refresh_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastRefreshTimeOrBuilder() {
    return lastRefreshTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastRefreshTime_;
  }

  public static final int OBSERVATION_PERIOD_FIELD_NUMBER = 5;
  private com.google.protobuf.Duration observationPeriod_;
  /**
   *
   *
   * <pre>
   * Observation period that led to the insight. The source data used to
   * generate the insight ends at last_refresh_time and begins at
   * (last_refresh_time - observation_period).
   * </pre>
   *
   * <code>.google.protobuf.Duration observation_period = 5;</code>
   *
   * @return Whether the observationPeriod field is set.
   */
  @java.lang.Override
  public boolean hasObservationPeriod() {
    return observationPeriod_ != null;
  }
  /**
   *
   *
   * <pre>
   * Observation period that led to the insight. The source data used to
   * generate the insight ends at last_refresh_time and begins at
   * (last_refresh_time - observation_period).
   * </pre>
   *
   * <code>.google.protobuf.Duration observation_period = 5;</code>
   *
   * @return The observationPeriod.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getObservationPeriod() {
    return observationPeriod_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : observationPeriod_;
  }
  /**
   *
   *
   * <pre>
   * Observation period that led to the insight. The source data used to
   * generate the insight ends at last_refresh_time and begins at
   * (last_refresh_time - observation_period).
   * </pre>
   *
   * <code>.google.protobuf.Duration observation_period = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getObservationPeriodOrBuilder() {
    return observationPeriod_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : observationPeriod_;
  }

  public static final int STATE_INFO_FIELD_NUMBER = 6;
  private com.google.cloud.recommender.v1.InsightStateInfo stateInfo_;
  /**
   *
   *
   * <pre>
   * Information state and metadata.
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.InsightStateInfo state_info = 6;</code>
   *
   * @return Whether the stateInfo field is set.
   */
  @java.lang.Override
  public boolean hasStateInfo() {
    return stateInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Information state and metadata.
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.InsightStateInfo state_info = 6;</code>
   *
   * @return The stateInfo.
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.InsightStateInfo getStateInfo() {
    return stateInfo_ == null
        ? com.google.cloud.recommender.v1.InsightStateInfo.getDefaultInstance()
        : stateInfo_;
  }
  /**
   *
   *
   * <pre>
   * Information state and metadata.
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.InsightStateInfo state_info = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.InsightStateInfoOrBuilder getStateInfoOrBuilder() {
    return stateInfo_ == null
        ? com.google.cloud.recommender.v1.InsightStateInfo.getDefaultInstance()
        : stateInfo_;
  }

  public static final int CATEGORY_FIELD_NUMBER = 7;
  private int category_ = 0;
  /**
   *
   *
   * <pre>
   * Category being targeted by the insight.
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.Insight.Category category = 7;</code>
   *
   * @return The enum numeric value on the wire for category.
   */
  @java.lang.Override
  public int getCategoryValue() {
    return category_;
  }
  /**
   *
   *
   * <pre>
   * Category being targeted by the insight.
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.Insight.Category category = 7;</code>
   *
   * @return The category.
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.Insight.Category getCategory() {
    com.google.cloud.recommender.v1.Insight.Category result =
        com.google.cloud.recommender.v1.Insight.Category.forNumber(category_);
    return result == null ? com.google.cloud.recommender.v1.Insight.Category.UNRECOGNIZED : result;
  }

  public static final int SEVERITY_FIELD_NUMBER = 15;
  private int severity_ = 0;
  /**
   *
   *
   * <pre>
   * Insight's severity.
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.Insight.Severity severity = 15;</code>
   *
   * @return The enum numeric value on the wire for severity.
   */
  @java.lang.Override
  public int getSeverityValue() {
    return severity_;
  }
  /**
   *
   *
   * <pre>
   * Insight's severity.
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.Insight.Severity severity = 15;</code>
   *
   * @return The severity.
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.Insight.Severity getSeverity() {
    com.google.cloud.recommender.v1.Insight.Severity result =
        com.google.cloud.recommender.v1.Insight.Severity.forNumber(severity_);
    return result == null ? com.google.cloud.recommender.v1.Insight.Severity.UNRECOGNIZED : result;
  }

  public static final int ETAG_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Fingerprint of the Insight. Provides optimistic locking when updating
   * states.
   * </pre>
   *
   * <code>string etag = 11;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Fingerprint of the Insight. Provides optimistic locking when updating
   * states.
   * </pre>
   *
   * <code>string etag = 11;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ASSOCIATED_RECOMMENDATIONS_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.recommender.v1.Insight.RecommendationReference>
      associatedRecommendations_;
  /**
   *
   *
   * <pre>
   * Recommendations derived from this insight.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recommender.v1.Insight.RecommendationReference associated_recommendations = 8;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.recommender.v1.Insight.RecommendationReference>
      getAssociatedRecommendationsList() {
    return associatedRecommendations_;
  }
  /**
   *
   *
   * <pre>
   * Recommendations derived from this insight.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recommender.v1.Insight.RecommendationReference associated_recommendations = 8;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.recommender.v1.Insight.RecommendationReferenceOrBuilder>
      getAssociatedRecommendationsOrBuilderList() {
    return associatedRecommendations_;
  }
  /**
   *
   *
   * <pre>
   * Recommendations derived from this insight.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recommender.v1.Insight.RecommendationReference associated_recommendations = 8;
   * </code>
   */
  @java.lang.Override
  public int getAssociatedRecommendationsCount() {
    return associatedRecommendations_.size();
  }
  /**
   *
   *
   * <pre>
   * Recommendations derived from this insight.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recommender.v1.Insight.RecommendationReference associated_recommendations = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.Insight.RecommendationReference
      getAssociatedRecommendations(int index) {
    return associatedRecommendations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Recommendations derived from this insight.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recommender.v1.Insight.RecommendationReference associated_recommendations = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.Insight.RecommendationReferenceOrBuilder
      getAssociatedRecommendationsOrBuilder(int index) {
    return associatedRecommendations_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (content_ != null) {
      output.writeMessage(3, getContent());
    }
    if (lastRefreshTime_ != null) {
      output.writeMessage(4, getLastRefreshTime());
    }
    if (observationPeriod_ != null) {
      output.writeMessage(5, getObservationPeriod());
    }
    if (stateInfo_ != null) {
      output.writeMessage(6, getStateInfo());
    }
    if (category_
        != com.google.cloud.recommender.v1.Insight.Category.CATEGORY_UNSPECIFIED.getNumber()) {
      output.writeEnum(7, category_);
    }
    for (int i = 0; i < associatedRecommendations_.size(); i++) {
      output.writeMessage(8, associatedRecommendations_.get(i));
    }
    for (int i = 0; i < targetResources_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, targetResources_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(insightSubtype_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, insightSubtype_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, etag_);
    }
    if (severity_
        != com.google.cloud.recommender.v1.Insight.Severity.SEVERITY_UNSPECIFIED.getNumber()) {
      output.writeEnum(15, severity_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (content_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getContent());
    }
    if (lastRefreshTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getLastRefreshTime());
    }
    if (observationPeriod_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getObservationPeriod());
    }
    if (stateInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getStateInfo());
    }
    if (category_
        != com.google.cloud.recommender.v1.Insight.Category.CATEGORY_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, category_);
    }
    for (int i = 0; i < associatedRecommendations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, associatedRecommendations_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < targetResources_.size(); i++) {
        dataSize += computeStringSizeNoTag(targetResources_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTargetResourcesList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(insightSubtype_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, insightSubtype_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, etag_);
    }
    if (severity_
        != com.google.cloud.recommender.v1.Insight.Severity.SEVERITY_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(15, severity_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.recommender.v1.Insight)) {
      return super.equals(obj);
    }
    com.google.cloud.recommender.v1.Insight other = (com.google.cloud.recommender.v1.Insight) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getTargetResourcesList().equals(other.getTargetResourcesList())) return false;
    if (!getInsightSubtype().equals(other.getInsightSubtype())) return false;
    if (hasContent() != other.hasContent()) return false;
    if (hasContent()) {
      if (!getContent().equals(other.getContent())) return false;
    }
    if (hasLastRefreshTime() != other.hasLastRefreshTime()) return false;
    if (hasLastRefreshTime()) {
      if (!getLastRefreshTime().equals(other.getLastRefreshTime())) return false;
    }
    if (hasObservationPeriod() != other.hasObservationPeriod()) return false;
    if (hasObservationPeriod()) {
      if (!getObservationPeriod().equals(other.getObservationPeriod())) return false;
    }
    if (hasStateInfo() != other.hasStateInfo()) return false;
    if (hasStateInfo()) {
      if (!getStateInfo().equals(other.getStateInfo())) return false;
    }
    if (category_ != other.category_) return false;
    if (severity_ != other.severity_) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getAssociatedRecommendationsList().equals(other.getAssociatedRecommendationsList()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getTargetResourcesCount() > 0) {
      hash = (37 * hash) + TARGET_RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getTargetResourcesList().hashCode();
    }
    hash = (37 * hash) + INSIGHT_SUBTYPE_FIELD_NUMBER;
    hash = (53 * hash) + getInsightSubtype().hashCode();
    if (hasContent()) {
      hash = (37 * hash) + CONTENT_FIELD_NUMBER;
      hash = (53 * hash) + getContent().hashCode();
    }
    if (hasLastRefreshTime()) {
      hash = (37 * hash) + LAST_REFRESH_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastRefreshTime().hashCode();
    }
    if (hasObservationPeriod()) {
      hash = (37 * hash) + OBSERVATION_PERIOD_FIELD_NUMBER;
      hash = (53 * hash) + getObservationPeriod().hashCode();
    }
    if (hasStateInfo()) {
      hash = (37 * hash) + STATE_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getStateInfo().hashCode();
    }
    hash = (37 * hash) + CATEGORY_FIELD_NUMBER;
    hash = (53 * hash) + category_;
    hash = (37 * hash) + SEVERITY_FIELD_NUMBER;
    hash = (53 * hash) + severity_;
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (getAssociatedRecommendationsCount() > 0) {
      hash = (37 * hash) + ASSOCIATED_RECOMMENDATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getAssociatedRecommendationsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.recommender.v1.Insight parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.recommender.v1.Insight parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.recommender.v1.Insight parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.recommender.v1.Insight parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.recommender.v1.Insight parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.recommender.v1.Insight parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.recommender.v1.Insight parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.recommender.v1.Insight parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.recommender.v1.Insight parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.recommender.v1.Insight parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.recommender.v1.Insight parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.recommender.v1.Insight parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.recommender.v1.Insight prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An insight along with the information used to derive the insight. The insight
   * may have associated recommendations as well.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recommender.v1.Insight}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.recommender.v1.Insight)
      com.google.cloud.recommender.v1.InsightOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.recommender.v1.InsightProto
          .internal_static_google_cloud_recommender_v1_Insight_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.recommender.v1.InsightProto
          .internal_static_google_cloud_recommender_v1_Insight_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.recommender.v1.Insight.class,
              com.google.cloud.recommender.v1.Insight.Builder.class);
    }

    // Construct using com.google.cloud.recommender.v1.Insight.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      description_ = "";
      targetResources_ = com.google.protobuf.LazyStringArrayList.emptyList();
      insightSubtype_ = "";
      content_ = null;
      if (contentBuilder_ != null) {
        contentBuilder_.dispose();
        contentBuilder_ = null;
      }
      lastRefreshTime_ = null;
      if (lastRefreshTimeBuilder_ != null) {
        lastRefreshTimeBuilder_.dispose();
        lastRefreshTimeBuilder_ = null;
      }
      observationPeriod_ = null;
      if (observationPeriodBuilder_ != null) {
        observationPeriodBuilder_.dispose();
        observationPeriodBuilder_ = null;
      }
      stateInfo_ = null;
      if (stateInfoBuilder_ != null) {
        stateInfoBuilder_.dispose();
        stateInfoBuilder_ = null;
      }
      category_ = 0;
      severity_ = 0;
      etag_ = "";
      if (associatedRecommendationsBuilder_ == null) {
        associatedRecommendations_ = java.util.Collections.emptyList();
      } else {
        associatedRecommendations_ = null;
        associatedRecommendationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000800);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.recommender.v1.InsightProto
          .internal_static_google_cloud_recommender_v1_Insight_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.recommender.v1.Insight getDefaultInstanceForType() {
      return com.google.cloud.recommender.v1.Insight.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.recommender.v1.Insight build() {
      com.google.cloud.recommender.v1.Insight result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.recommender.v1.Insight buildPartial() {
      com.google.cloud.recommender.v1.Insight result =
          new com.google.cloud.recommender.v1.Insight(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.recommender.v1.Insight result) {
      if (associatedRecommendationsBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)) {
          associatedRecommendations_ =
              java.util.Collections.unmodifiableList(associatedRecommendations_);
          bitField0_ = (bitField0_ & ~0x00000800);
        }
        result.associatedRecommendations_ = associatedRecommendations_;
      } else {
        result.associatedRecommendations_ = associatedRecommendationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.recommender.v1.Insight result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        targetResources_.makeImmutable();
        result.targetResources_ = targetResources_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.insightSubtype_ = insightSubtype_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.content_ = contentBuilder_ == null ? content_ : contentBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.lastRefreshTime_ =
            lastRefreshTimeBuilder_ == null ? lastRefreshTime_ : lastRefreshTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.observationPeriod_ =
            observationPeriodBuilder_ == null
                ? observationPeriod_
                : observationPeriodBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.stateInfo_ = stateInfoBuilder_ == null ? stateInfo_ : stateInfoBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.category_ = category_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.severity_ = severity_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.etag_ = etag_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.recommender.v1.Insight) {
        return mergeFrom((com.google.cloud.recommender.v1.Insight) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.recommender.v1.Insight other) {
      if (other == com.google.cloud.recommender.v1.Insight.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.targetResources_.isEmpty()) {
        if (targetResources_.isEmpty()) {
          targetResources_ = other.targetResources_;
          bitField0_ |= 0x00000004;
        } else {
          ensureTargetResourcesIsMutable();
          targetResources_.addAll(other.targetResources_);
        }
        onChanged();
      }
      if (!other.getInsightSubtype().isEmpty()) {
        insightSubtype_ = other.insightSubtype_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasContent()) {
        mergeContent(other.getContent());
      }
      if (other.hasLastRefreshTime()) {
        mergeLastRefreshTime(other.getLastRefreshTime());
      }
      if (other.hasObservationPeriod()) {
        mergeObservationPeriod(other.getObservationPeriod());
      }
      if (other.hasStateInfo()) {
        mergeStateInfo(other.getStateInfo());
      }
      if (other.category_ != 0) {
        setCategoryValue(other.getCategoryValue());
      }
      if (other.severity_ != 0) {
        setSeverityValue(other.getSeverityValue());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (associatedRecommendationsBuilder_ == null) {
        if (!other.associatedRecommendations_.isEmpty()) {
          if (associatedRecommendations_.isEmpty()) {
            associatedRecommendations_ = other.associatedRecommendations_;
            bitField0_ = (bitField0_ & ~0x00000800);
          } else {
            ensureAssociatedRecommendationsIsMutable();
            associatedRecommendations_.addAll(other.associatedRecommendations_);
          }
          onChanged();
        }
      } else {
        if (!other.associatedRecommendations_.isEmpty()) {
          if (associatedRecommendationsBuilder_.isEmpty()) {
            associatedRecommendationsBuilder_.dispose();
            associatedRecommendationsBuilder_ = null;
            associatedRecommendations_ = other.associatedRecommendations_;
            bitField0_ = (bitField0_ & ~0x00000800);
            associatedRecommendationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAssociatedRecommendationsFieldBuilder()
                    : null;
          } else {
            associatedRecommendationsBuilder_.addAllMessages(other.associatedRecommendations_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getContentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getLastRefreshTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getObservationPeriodFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getStateInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 50
            case 56:
              {
                category_ = input.readEnum();
                bitField0_ |= 0x00000100;
                break;
              } // case 56
            case 66:
              {
                com.google.cloud.recommender.v1.Insight.RecommendationReference m =
                    input.readMessage(
                        com.google.cloud.recommender.v1.Insight.RecommendationReference.parser(),
                        extensionRegistry);
                if (associatedRecommendationsBuilder_ == null) {
                  ensureAssociatedRecommendationsIsMutable();
                  associatedRecommendations_.add(m);
                } else {
                  associatedRecommendationsBuilder_.addMessage(m);
                }
                break;
              } // case 66
            case 74:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTargetResourcesIsMutable();
                targetResources_.add(s);
                break;
              } // case 74
            case 82:
              {
                insightSubtype_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 82
            case 90:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 120:
              {
                severity_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 120
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the insight.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the insight.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the insight.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the insight.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the insight.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Free-form human readable summary in English. The maximum length is 500
     * characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Free-form human readable summary in English. The maximum length is 500
     * characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Free-form human readable summary in English. The maximum length is 500
     * characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Free-form human readable summary in English. The maximum length is 500
     * characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Free-form human readable summary in English. The maximum length is 500
     * characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList targetResources_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTargetResourcesIsMutable() {
      if (!targetResources_.isModifiable()) {
        targetResources_ = new com.google.protobuf.LazyStringArrayList(targetResources_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Fully qualified resource names that this insight is targeting.
     * </pre>
     *
     * <code>repeated string target_resources = 9;</code>
     *
     * @return A list containing the targetResources.
     */
    public com.google.protobuf.ProtocolStringList getTargetResourcesList() {
      targetResources_.makeImmutable();
      return targetResources_;
    }
    /**
     *
     *
     * <pre>
     * Fully qualified resource names that this insight is targeting.
     * </pre>
     *
     * <code>repeated string target_resources = 9;</code>
     *
     * @return The count of targetResources.
     */
    public int getTargetResourcesCount() {
      return targetResources_.size();
    }
    /**
     *
     *
     * <pre>
     * Fully qualified resource names that this insight is targeting.
     * </pre>
     *
     * <code>repeated string target_resources = 9;</code>
     *
     * @param index The index of the element to return.
     * @return The targetResources at the given index.
     */
    public java.lang.String getTargetResources(int index) {
      return targetResources_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Fully qualified resource names that this insight is targeting.
     * </pre>
     *
     * <code>repeated string target_resources = 9;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the targetResources at the given index.
     */
    public com.google.protobuf.ByteString getTargetResourcesBytes(int index) {
      return targetResources_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Fully qualified resource names that this insight is targeting.
     * </pre>
     *
     * <code>repeated string target_resources = 9;</code>
     *
     * @param index The index to set the value at.
     * @param value The targetResources to set.
     * @return This builder for chaining.
     */
    public Builder setTargetResources(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTargetResourcesIsMutable();
      targetResources_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fully qualified resource names that this insight is targeting.
     * </pre>
     *
     * <code>repeated string target_resources = 9;</code>
     *
     * @param value The targetResources to add.
     * @return This builder for chaining.
     */
    public Builder addTargetResources(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTargetResourcesIsMutable();
      targetResources_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fully qualified resource names that this insight is targeting.
     * </pre>
     *
     * <code>repeated string target_resources = 9;</code>
     *
     * @param values The targetResources to add.
     * @return This builder for chaining.
     */
    public Builder addAllTargetResources(java.lang.Iterable<java.lang.String> values) {
      ensureTargetResourcesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, targetResources_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fully qualified resource names that this insight is targeting.
     * </pre>
     *
     * <code>repeated string target_resources = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetResources() {
      targetResources_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fully qualified resource names that this insight is targeting.
     * </pre>
     *
     * <code>repeated string target_resources = 9;</code>
     *
     * @param value The bytes of the targetResources to add.
     * @return This builder for chaining.
     */
    public Builder addTargetResourcesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTargetResourcesIsMutable();
      targetResources_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object insightSubtype_ = "";
    /**
     *
     *
     * <pre>
     * Insight subtype. Insight content schema will be stable for a given subtype.
     * </pre>
     *
     * <code>string insight_subtype = 10;</code>
     *
     * @return The insightSubtype.
     */
    public java.lang.String getInsightSubtype() {
      java.lang.Object ref = insightSubtype_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        insightSubtype_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Insight subtype. Insight content schema will be stable for a given subtype.
     * </pre>
     *
     * <code>string insight_subtype = 10;</code>
     *
     * @return The bytes for insightSubtype.
     */
    public com.google.protobuf.ByteString getInsightSubtypeBytes() {
      java.lang.Object ref = insightSubtype_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        insightSubtype_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Insight subtype. Insight content schema will be stable for a given subtype.
     * </pre>
     *
     * <code>string insight_subtype = 10;</code>
     *
     * @param value The insightSubtype to set.
     * @return This builder for chaining.
     */
    public Builder setInsightSubtype(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      insightSubtype_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Insight subtype. Insight content schema will be stable for a given subtype.
     * </pre>
     *
     * <code>string insight_subtype = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInsightSubtype() {
      insightSubtype_ = getDefaultInstance().getInsightSubtype();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Insight subtype. Insight content schema will be stable for a given subtype.
     * </pre>
     *
     * <code>string insight_subtype = 10;</code>
     *
     * @param value The bytes for insightSubtype to set.
     * @return This builder for chaining.
     */
    public Builder setInsightSubtypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      insightSubtype_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct content_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        contentBuilder_;
    /**
     *
     *
     * <pre>
     * A struct of custom fields to explain the insight.
     * Example: "grantedPermissionsCount": "1000"
     * </pre>
     *
     * <code>.google.protobuf.Struct content = 3;</code>
     *
     * @return Whether the content field is set.
     */
    public boolean hasContent() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * A struct of custom fields to explain the insight.
     * Example: "grantedPermissionsCount": "1000"
     * </pre>
     *
     * <code>.google.protobuf.Struct content = 3;</code>
     *
     * @return The content.
     */
    public com.google.protobuf.Struct getContent() {
      if (contentBuilder_ == null) {
        return content_ == null ? com.google.protobuf.Struct.getDefaultInstance() : content_;
      } else {
        return contentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A struct of custom fields to explain the insight.
     * Example: "grantedPermissionsCount": "1000"
     * </pre>
     *
     * <code>.google.protobuf.Struct content = 3;</code>
     */
    public Builder setContent(com.google.protobuf.Struct value) {
      if (contentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        content_ = value;
      } else {
        contentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A struct of custom fields to explain the insight.
     * Example: "grantedPermissionsCount": "1000"
     * </pre>
     *
     * <code>.google.protobuf.Struct content = 3;</code>
     */
    public Builder setContent(com.google.protobuf.Struct.Builder builderForValue) {
      if (contentBuilder_ == null) {
        content_ = builderForValue.build();
      } else {
        contentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A struct of custom fields to explain the insight.
     * Example: "grantedPermissionsCount": "1000"
     * </pre>
     *
     * <code>.google.protobuf.Struct content = 3;</code>
     */
    public Builder mergeContent(com.google.protobuf.Struct value) {
      if (contentBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && content_ != null
            && content_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getContentBuilder().mergeFrom(value);
        } else {
          content_ = value;
        }
      } else {
        contentBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A struct of custom fields to explain the insight.
     * Example: "grantedPermissionsCount": "1000"
     * </pre>
     *
     * <code>.google.protobuf.Struct content = 3;</code>
     */
    public Builder clearContent() {
      bitField0_ = (bitField0_ & ~0x00000010);
      content_ = null;
      if (contentBuilder_ != null) {
        contentBuilder_.dispose();
        contentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A struct of custom fields to explain the insight.
     * Example: "grantedPermissionsCount": "1000"
     * </pre>
     *
     * <code>.google.protobuf.Struct content = 3;</code>
     */
    public com.google.protobuf.Struct.Builder getContentBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getContentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A struct of custom fields to explain the insight.
     * Example: "grantedPermissionsCount": "1000"
     * </pre>
     *
     * <code>.google.protobuf.Struct content = 3;</code>
     */
    public com.google.protobuf.StructOrBuilder getContentOrBuilder() {
      if (contentBuilder_ != null) {
        return contentBuilder_.getMessageOrBuilder();
      } else {
        return content_ == null ? com.google.protobuf.Struct.getDefaultInstance() : content_;
      }
    }
    /**
     *
     *
     * <pre>
     * A struct of custom fields to explain the insight.
     * Example: "grantedPermissionsCount": "1000"
     * </pre>
     *
     * <code>.google.protobuf.Struct content = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getContentFieldBuilder() {
      if (contentBuilder_ == null) {
        contentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getContent(), getParentForChildren(), isClean());
        content_ = null;
      }
      return contentBuilder_;
    }

    private com.google.protobuf.Timestamp lastRefreshTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastRefreshTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Timestamp of the latest data used to generate the insight.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_refresh_time = 4;</code>
     *
     * @return Whether the lastRefreshTime field is set.
     */
    public boolean hasLastRefreshTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Timestamp of the latest data used to generate the insight.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_refresh_time = 4;</code>
     *
     * @return The lastRefreshTime.
     */
    public com.google.protobuf.Timestamp getLastRefreshTime() {
      if (lastRefreshTimeBuilder_ == null) {
        return lastRefreshTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastRefreshTime_;
      } else {
        return lastRefreshTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Timestamp of the latest data used to generate the insight.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_refresh_time = 4;</code>
     */
    public Builder setLastRefreshTime(com.google.protobuf.Timestamp value) {
      if (lastRefreshTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastRefreshTime_ = value;
      } else {
        lastRefreshTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp of the latest data used to generate the insight.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_refresh_time = 4;</code>
     */
    public Builder setLastRefreshTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastRefreshTimeBuilder_ == null) {
        lastRefreshTime_ = builderForValue.build();
      } else {
        lastRefreshTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp of the latest data used to generate the insight.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_refresh_time = 4;</code>
     */
    public Builder mergeLastRefreshTime(com.google.protobuf.Timestamp value) {
      if (lastRefreshTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && lastRefreshTime_ != null
            && lastRefreshTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastRefreshTimeBuilder().mergeFrom(value);
        } else {
          lastRefreshTime_ = value;
        }
      } else {
        lastRefreshTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp of the latest data used to generate the insight.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_refresh_time = 4;</code>
     */
    public Builder clearLastRefreshTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      lastRefreshTime_ = null;
      if (lastRefreshTimeBuilder_ != null) {
        lastRefreshTimeBuilder_.dispose();
        lastRefreshTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp of the latest data used to generate the insight.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_refresh_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getLastRefreshTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getLastRefreshTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Timestamp of the latest data used to generate the insight.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_refresh_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastRefreshTimeOrBuilder() {
      if (lastRefreshTimeBuilder_ != null) {
        return lastRefreshTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastRefreshTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastRefreshTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Timestamp of the latest data used to generate the insight.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_refresh_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastRefreshTimeFieldBuilder() {
      if (lastRefreshTimeBuilder_ == null) {
        lastRefreshTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastRefreshTime(), getParentForChildren(), isClean());
        lastRefreshTime_ = null;
      }
      return lastRefreshTimeBuilder_;
    }

    private com.google.protobuf.Duration observationPeriod_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        observationPeriodBuilder_;
    /**
     *
     *
     * <pre>
     * Observation period that led to the insight. The source data used to
     * generate the insight ends at last_refresh_time and begins at
     * (last_refresh_time - observation_period).
     * </pre>
     *
     * <code>.google.protobuf.Duration observation_period = 5;</code>
     *
     * @return Whether the observationPeriod field is set.
     */
    public boolean hasObservationPeriod() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Observation period that led to the insight. The source data used to
     * generate the insight ends at last_refresh_time and begins at
     * (last_refresh_time - observation_period).
     * </pre>
     *
     * <code>.google.protobuf.Duration observation_period = 5;</code>
     *
     * @return The observationPeriod.
     */
    public com.google.protobuf.Duration getObservationPeriod() {
      if (observationPeriodBuilder_ == null) {
        return observationPeriod_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : observationPeriod_;
      } else {
        return observationPeriodBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Observation period that led to the insight. The source data used to
     * generate the insight ends at last_refresh_time and begins at
     * (last_refresh_time - observation_period).
     * </pre>
     *
     * <code>.google.protobuf.Duration observation_period = 5;</code>
     */
    public Builder setObservationPeriod(com.google.protobuf.Duration value) {
      if (observationPeriodBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        observationPeriod_ = value;
      } else {
        observationPeriodBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Observation period that led to the insight. The source data used to
     * generate the insight ends at last_refresh_time and begins at
     * (last_refresh_time - observation_period).
     * </pre>
     *
     * <code>.google.protobuf.Duration observation_period = 5;</code>
     */
    public Builder setObservationPeriod(com.google.protobuf.Duration.Builder builderForValue) {
      if (observationPeriodBuilder_ == null) {
        observationPeriod_ = builderForValue.build();
      } else {
        observationPeriodBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Observation period that led to the insight. The source data used to
     * generate the insight ends at last_refresh_time and begins at
     * (last_refresh_time - observation_period).
     * </pre>
     *
     * <code>.google.protobuf.Duration observation_period = 5;</code>
     */
    public Builder mergeObservationPeriod(com.google.protobuf.Duration value) {
      if (observationPeriodBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && observationPeriod_ != null
            && observationPeriod_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getObservationPeriodBuilder().mergeFrom(value);
        } else {
          observationPeriod_ = value;
        }
      } else {
        observationPeriodBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Observation period that led to the insight. The source data used to
     * generate the insight ends at last_refresh_time and begins at
     * (last_refresh_time - observation_period).
     * </pre>
     *
     * <code>.google.protobuf.Duration observation_period = 5;</code>
     */
    public Builder clearObservationPeriod() {
      bitField0_ = (bitField0_ & ~0x00000040);
      observationPeriod_ = null;
      if (observationPeriodBuilder_ != null) {
        observationPeriodBuilder_.dispose();
        observationPeriodBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Observation period that led to the insight. The source data used to
     * generate the insight ends at last_refresh_time and begins at
     * (last_refresh_time - observation_period).
     * </pre>
     *
     * <code>.google.protobuf.Duration observation_period = 5;</code>
     */
    public com.google.protobuf.Duration.Builder getObservationPeriodBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getObservationPeriodFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Observation period that led to the insight. The source data used to
     * generate the insight ends at last_refresh_time and begins at
     * (last_refresh_time - observation_period).
     * </pre>
     *
     * <code>.google.protobuf.Duration observation_period = 5;</code>
     */
    public com.google.protobuf.DurationOrBuilder getObservationPeriodOrBuilder() {
      if (observationPeriodBuilder_ != null) {
        return observationPeriodBuilder_.getMessageOrBuilder();
      } else {
        return observationPeriod_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : observationPeriod_;
      }
    }
    /**
     *
     *
     * <pre>
     * Observation period that led to the insight. The source data used to
     * generate the insight ends at last_refresh_time and begins at
     * (last_refresh_time - observation_period).
     * </pre>
     *
     * <code>.google.protobuf.Duration observation_period = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getObservationPeriodFieldBuilder() {
      if (observationPeriodBuilder_ == null) {
        observationPeriodBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getObservationPeriod(), getParentForChildren(), isClean());
        observationPeriod_ = null;
      }
      return observationPeriodBuilder_;
    }

    private com.google.cloud.recommender.v1.InsightStateInfo stateInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.recommender.v1.InsightStateInfo,
            com.google.cloud.recommender.v1.InsightStateInfo.Builder,
            com.google.cloud.recommender.v1.InsightStateInfoOrBuilder>
        stateInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Information state and metadata.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.InsightStateInfo state_info = 6;</code>
     *
     * @return Whether the stateInfo field is set.
     */
    public boolean hasStateInfo() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Information state and metadata.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.InsightStateInfo state_info = 6;</code>
     *
     * @return The stateInfo.
     */
    public com.google.cloud.recommender.v1.InsightStateInfo getStateInfo() {
      if (stateInfoBuilder_ == null) {
        return stateInfo_ == null
            ? com.google.cloud.recommender.v1.InsightStateInfo.getDefaultInstance()
            : stateInfo_;
      } else {
        return stateInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Information state and metadata.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.InsightStateInfo state_info = 6;</code>
     */
    public Builder setStateInfo(com.google.cloud.recommender.v1.InsightStateInfo value) {
      if (stateInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stateInfo_ = value;
      } else {
        stateInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information state and metadata.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.InsightStateInfo state_info = 6;</code>
     */
    public Builder setStateInfo(
        com.google.cloud.recommender.v1.InsightStateInfo.Builder builderForValue) {
      if (stateInfoBuilder_ == null) {
        stateInfo_ = builderForValue.build();
      } else {
        stateInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information state and metadata.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.InsightStateInfo state_info = 6;</code>
     */
    public Builder mergeStateInfo(com.google.cloud.recommender.v1.InsightStateInfo value) {
      if (stateInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && stateInfo_ != null
            && stateInfo_
                != com.google.cloud.recommender.v1.InsightStateInfo.getDefaultInstance()) {
          getStateInfoBuilder().mergeFrom(value);
        } else {
          stateInfo_ = value;
        }
      } else {
        stateInfoBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information state and metadata.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.InsightStateInfo state_info = 6;</code>
     */
    public Builder clearStateInfo() {
      bitField0_ = (bitField0_ & ~0x00000080);
      stateInfo_ = null;
      if (stateInfoBuilder_ != null) {
        stateInfoBuilder_.dispose();
        stateInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information state and metadata.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.InsightStateInfo state_info = 6;</code>
     */
    public com.google.cloud.recommender.v1.InsightStateInfo.Builder getStateInfoBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getStateInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Information state and metadata.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.InsightStateInfo state_info = 6;</code>
     */
    public com.google.cloud.recommender.v1.InsightStateInfoOrBuilder getStateInfoOrBuilder() {
      if (stateInfoBuilder_ != null) {
        return stateInfoBuilder_.getMessageOrBuilder();
      } else {
        return stateInfo_ == null
            ? com.google.cloud.recommender.v1.InsightStateInfo.getDefaultInstance()
            : stateInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Information state and metadata.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.InsightStateInfo state_info = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.recommender.v1.InsightStateInfo,
            com.google.cloud.recommender.v1.InsightStateInfo.Builder,
            com.google.cloud.recommender.v1.InsightStateInfoOrBuilder>
        getStateInfoFieldBuilder() {
      if (stateInfoBuilder_ == null) {
        stateInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.recommender.v1.InsightStateInfo,
                com.google.cloud.recommender.v1.InsightStateInfo.Builder,
                com.google.cloud.recommender.v1.InsightStateInfoOrBuilder>(
                getStateInfo(), getParentForChildren(), isClean());
        stateInfo_ = null;
      }
      return stateInfoBuilder_;
    }

    private int category_ = 0;
    /**
     *
     *
     * <pre>
     * Category being targeted by the insight.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Insight.Category category = 7;</code>
     *
     * @return The enum numeric value on the wire for category.
     */
    @java.lang.Override
    public int getCategoryValue() {
      return category_;
    }
    /**
     *
     *
     * <pre>
     * Category being targeted by the insight.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Insight.Category category = 7;</code>
     *
     * @param value The enum numeric value on the wire for category to set.
     * @return This builder for chaining.
     */
    public Builder setCategoryValue(int value) {
      category_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Category being targeted by the insight.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Insight.Category category = 7;</code>
     *
     * @return The category.
     */
    @java.lang.Override
    public com.google.cloud.recommender.v1.Insight.Category getCategory() {
      com.google.cloud.recommender.v1.Insight.Category result =
          com.google.cloud.recommender.v1.Insight.Category.forNumber(category_);
      return result == null
          ? com.google.cloud.recommender.v1.Insight.Category.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Category being targeted by the insight.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Insight.Category category = 7;</code>
     *
     * @param value The category to set.
     * @return This builder for chaining.
     */
    public Builder setCategory(com.google.cloud.recommender.v1.Insight.Category value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000100;
      category_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Category being targeted by the insight.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Insight.Category category = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCategory() {
      bitField0_ = (bitField0_ & ~0x00000100);
      category_ = 0;
      onChanged();
      return this;
    }

    private int severity_ = 0;
    /**
     *
     *
     * <pre>
     * Insight's severity.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Insight.Severity severity = 15;</code>
     *
     * @return The enum numeric value on the wire for severity.
     */
    @java.lang.Override
    public int getSeverityValue() {
      return severity_;
    }
    /**
     *
     *
     * <pre>
     * Insight's severity.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Insight.Severity severity = 15;</code>
     *
     * @param value The enum numeric value on the wire for severity to set.
     * @return This builder for chaining.
     */
    public Builder setSeverityValue(int value) {
      severity_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Insight's severity.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Insight.Severity severity = 15;</code>
     *
     * @return The severity.
     */
    @java.lang.Override
    public com.google.cloud.recommender.v1.Insight.Severity getSeverity() {
      com.google.cloud.recommender.v1.Insight.Severity result =
          com.google.cloud.recommender.v1.Insight.Severity.forNumber(severity_);
      return result == null
          ? com.google.cloud.recommender.v1.Insight.Severity.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Insight's severity.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Insight.Severity severity = 15;</code>
     *
     * @param value The severity to set.
     * @return This builder for chaining.
     */
    public Builder setSeverity(com.google.cloud.recommender.v1.Insight.Severity value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      severity_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Insight's severity.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Insight.Severity severity = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSeverity() {
      bitField0_ = (bitField0_ & ~0x00000200);
      severity_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Fingerprint of the Insight. Provides optimistic locking when updating
     * states.
     * </pre>
     *
     * <code>string etag = 11;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of the Insight. Provides optimistic locking when updating
     * states.
     * </pre>
     *
     * <code>string etag = 11;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of the Insight. Provides optimistic locking when updating
     * states.
     * </pre>
     *
     * <code>string etag = 11;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of the Insight. Provides optimistic locking when updating
     * states.
     * </pre>
     *
     * <code>string etag = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of the Insight. Provides optimistic locking when updating
     * states.
     * </pre>
     *
     * <code>string etag = 11;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.recommender.v1.Insight.RecommendationReference>
        associatedRecommendations_ = java.util.Collections.emptyList();

    private void ensureAssociatedRecommendationsIsMutable() {
      if (!((bitField0_ & 0x00000800) != 0)) {
        associatedRecommendations_ =
            new java.util.ArrayList<
                com.google.cloud.recommender.v1.Insight.RecommendationReference>(
                associatedRecommendations_);
        bitField0_ |= 0x00000800;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.recommender.v1.Insight.RecommendationReference,
            com.google.cloud.recommender.v1.Insight.RecommendationReference.Builder,
            com.google.cloud.recommender.v1.Insight.RecommendationReferenceOrBuilder>
        associatedRecommendationsBuilder_;

    /**
     *
     *
     * <pre>
     * Recommendations derived from this insight.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Insight.RecommendationReference associated_recommendations = 8;
     * </code>
     */
    public java.util.List<com.google.cloud.recommender.v1.Insight.RecommendationReference>
        getAssociatedRecommendationsList() {
      if (associatedRecommendationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(associatedRecommendations_);
      } else {
        return associatedRecommendationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Recommendations derived from this insight.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Insight.RecommendationReference associated_recommendations = 8;
     * </code>
     */
    public int getAssociatedRecommendationsCount() {
      if (associatedRecommendationsBuilder_ == null) {
        return associatedRecommendations_.size();
      } else {
        return associatedRecommendationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Recommendations derived from this insight.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Insight.RecommendationReference associated_recommendations = 8;
     * </code>
     */
    public com.google.cloud.recommender.v1.Insight.RecommendationReference
        getAssociatedRecommendations(int index) {
      if (associatedRecommendationsBuilder_ == null) {
        return associatedRecommendations_.get(index);
      } else {
        return associatedRecommendationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Recommendations derived from this insight.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Insight.RecommendationReference associated_recommendations = 8;
     * </code>
     */
    public Builder setAssociatedRecommendations(
        int index, com.google.cloud.recommender.v1.Insight.RecommendationReference value) {
      if (associatedRecommendationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAssociatedRecommendationsIsMutable();
        associatedRecommendations_.set(index, value);
        onChanged();
      } else {
        associatedRecommendationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Recommendations derived from this insight.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Insight.RecommendationReference associated_recommendations = 8;
     * </code>
     */
    public Builder setAssociatedRecommendations(
        int index,
        com.google.cloud.recommender.v1.Insight.RecommendationReference.Builder builderForValue) {
      if (associatedRecommendationsBuilder_ == null) {
        ensureAssociatedRecommendationsIsMutable();
        associatedRecommendations_.set(index, builderForValue.build());
        onChanged();
      } else {
        associatedRecommendationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Recommendations derived from this insight.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Insight.RecommendationReference associated_recommendations = 8;
     * </code>
     */
    public Builder addAssociatedRecommendations(
        com.google.cloud.recommender.v1.Insight.RecommendationReference value) {
      if (associatedRecommendationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAssociatedRecommendationsIsMutable();
        associatedRecommendations_.add(value);
        onChanged();
      } else {
        associatedRecommendationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Recommendations derived from this insight.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Insight.RecommendationReference associated_recommendations = 8;
     * </code>
     */
    public Builder addAssociatedRecommendations(
        int index, com.google.cloud.recommender.v1.Insight.RecommendationReference value) {
      if (associatedRecommendationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAssociatedRecommendationsIsMutable();
        associatedRecommendations_.add(index, value);
        onChanged();
      } else {
        associatedRecommendationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Recommendations derived from this insight.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Insight.RecommendationReference associated_recommendations = 8;
     * </code>
     */
    public Builder addAssociatedRecommendations(
        com.google.cloud.recommender.v1.Insight.RecommendationReference.Builder builderForValue) {
      if (associatedRecommendationsBuilder_ == null) {
        ensureAssociatedRecommendationsIsMutable();
        associatedRecommendations_.add(builderForValue.build());
        onChanged();
      } else {
        associatedRecommendationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Recommendations derived from this insight.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Insight.RecommendationReference associated_recommendations = 8;
     * </code>
     */
    public Builder addAssociatedRecommendations(
        int index,
        com.google.cloud.recommender.v1.Insight.RecommendationReference.Builder builderForValue) {
      if (associatedRecommendationsBuilder_ == null) {
        ensureAssociatedRecommendationsIsMutable();
        associatedRecommendations_.add(index, builderForValue.build());
        onChanged();
      } else {
        associatedRecommendationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Recommendations derived from this insight.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Insight.RecommendationReference associated_recommendations = 8;
     * </code>
     */
    public Builder addAllAssociatedRecommendations(
        java.lang.Iterable<
                ? extends com.google.cloud.recommender.v1.Insight.RecommendationReference>
            values) {
      if (associatedRecommendationsBuilder_ == null) {
        ensureAssociatedRecommendationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, associatedRecommendations_);
        onChanged();
      } else {
        associatedRecommendationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Recommendations derived from this insight.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Insight.RecommendationReference associated_recommendations = 8;
     * </code>
     */
    public Builder clearAssociatedRecommendations() {
      if (associatedRecommendationsBuilder_ == null) {
        associatedRecommendations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000800);
        onChanged();
      } else {
        associatedRecommendationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Recommendations derived from this insight.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Insight.RecommendationReference associated_recommendations = 8;
     * </code>
     */
    public Builder removeAssociatedRecommendations(int index) {
      if (associatedRecommendationsBuilder_ == null) {
        ensureAssociatedRecommendationsIsMutable();
        associatedRecommendations_.remove(index);
        onChanged();
      } else {
        associatedRecommendationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Recommendations derived from this insight.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Insight.RecommendationReference associated_recommendations = 8;
     * </code>
     */
    public com.google.cloud.recommender.v1.Insight.RecommendationReference.Builder
        getAssociatedRecommendationsBuilder(int index) {
      return getAssociatedRecommendationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Recommendations derived from this insight.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Insight.RecommendationReference associated_recommendations = 8;
     * </code>
     */
    public com.google.cloud.recommender.v1.Insight.RecommendationReferenceOrBuilder
        getAssociatedRecommendationsOrBuilder(int index) {
      if (associatedRecommendationsBuilder_ == null) {
        return associatedRecommendations_.get(index);
      } else {
        return associatedRecommendationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Recommendations derived from this insight.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Insight.RecommendationReference associated_recommendations = 8;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.recommender.v1.Insight.RecommendationReferenceOrBuilder>
        getAssociatedRecommendationsOrBuilderList() {
      if (associatedRecommendationsBuilder_ != null) {
        return associatedRecommendationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(associatedRecommendations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Recommendations derived from this insight.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Insight.RecommendationReference associated_recommendations = 8;
     * </code>
     */
    public com.google.cloud.recommender.v1.Insight.RecommendationReference.Builder
        addAssociatedRecommendationsBuilder() {
      return getAssociatedRecommendationsFieldBuilder()
          .addBuilder(
              com.google.cloud.recommender.v1.Insight.RecommendationReference.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Recommendations derived from this insight.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Insight.RecommendationReference associated_recommendations = 8;
     * </code>
     */
    public com.google.cloud.recommender.v1.Insight.RecommendationReference.Builder
        addAssociatedRecommendationsBuilder(int index) {
      return getAssociatedRecommendationsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.recommender.v1.Insight.RecommendationReference.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Recommendations derived from this insight.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Insight.RecommendationReference associated_recommendations = 8;
     * </code>
     */
    public java.util.List<com.google.cloud.recommender.v1.Insight.RecommendationReference.Builder>
        getAssociatedRecommendationsBuilderList() {
      return getAssociatedRecommendationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.recommender.v1.Insight.RecommendationReference,
            com.google.cloud.recommender.v1.Insight.RecommendationReference.Builder,
            com.google.cloud.recommender.v1.Insight.RecommendationReferenceOrBuilder>
        getAssociatedRecommendationsFieldBuilder() {
      if (associatedRecommendationsBuilder_ == null) {
        associatedRecommendationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.recommender.v1.Insight.RecommendationReference,
                com.google.cloud.recommender.v1.Insight.RecommendationReference.Builder,
                com.google.cloud.recommender.v1.Insight.RecommendationReferenceOrBuilder>(
                associatedRecommendations_,
                ((bitField0_ & 0x00000800) != 0),
                getParentForChildren(),
                isClean());
        associatedRecommendations_ = null;
      }
      return associatedRecommendationsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.recommender.v1.Insight)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.recommender.v1.Insight)
  private static final com.google.cloud.recommender.v1.Insight DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.recommender.v1.Insight();
  }

  public static com.google.cloud.recommender.v1.Insight getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Insight> PARSER =
      new com.google.protobuf.AbstractParser<Insight>() {
        @java.lang.Override
        public Insight parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Insight> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Insight> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.recommender.v1.Insight getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
