/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/recommender/v1/recommendation.proto

package com.google.cloud.recommender.v1;

/**
 *
 *
 * <pre>
 * Contains an operation for a resource loosely based on the JSON-PATCH format
 * with support for:
 *
 * * Custom filters for describing partial array patch.
 * * Extended path values for describing nested arrays.
 * * Custom fields for describing the resource for which the operation is being
 *   described.
 * * Allows extension to custom operations not natively supported by RFC6902.
 * See https://tools.ietf.org/html/rfc6902 for details on the original RFC.
 * </pre>
 *
 * Protobuf type {@code google.cloud.recommender.v1.Operation}
 */
public final class Operation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.recommender.v1.Operation)
    OperationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Operation.newBuilder() to construct.
  private Operation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Operation() {
    action_ = "";
    resourceType_ = "";
    resource_ = "";
    path_ = "";
    sourceResource_ = "";
    sourcePath_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Operation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.recommender.v1.RecommendationOuterClass
        .internal_static_google_cloud_recommender_v1_Operation_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 8:
        return internalGetPathFilters();
      case 11:
        return internalGetPathValueMatchers();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.recommender.v1.RecommendationOuterClass
        .internal_static_google_cloud_recommender_v1_Operation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.recommender.v1.Operation.class,
            com.google.cloud.recommender.v1.Operation.Builder.class);
  }

  private int pathValueCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object pathValue_;

  public enum PathValueCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    VALUE(7),
    VALUE_MATCHER(10),
    PATHVALUE_NOT_SET(0);
    private final int value;

    private PathValueCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PathValueCase valueOf(int value) {
      return forNumber(value);
    }

    public static PathValueCase forNumber(int value) {
      switch (value) {
        case 7:
          return VALUE;
        case 10:
          return VALUE_MATCHER;
        case 0:
          return PATHVALUE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public PathValueCase getPathValueCase() {
    return PathValueCase.forNumber(pathValueCase_);
  }

  public static final int ACTION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object action_ = "";
  /**
   *
   *
   * <pre>
   * Type of this operation. Contains one of 'add', 'remove', 'replace', 'move',
   * 'copy', 'test' and custom operations. This field is case-insensitive and
   * always populated.
   * </pre>
   *
   * <code>string action = 1;</code>
   *
   * @return The action.
   */
  @java.lang.Override
  public java.lang.String getAction() {
    java.lang.Object ref = action_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      action_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Type of this operation. Contains one of 'add', 'remove', 'replace', 'move',
   * 'copy', 'test' and custom operations. This field is case-insensitive and
   * always populated.
   * </pre>
   *
   * <code>string action = 1;</code>
   *
   * @return The bytes for action.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getActionBytes() {
    java.lang.Object ref = action_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      action_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESOURCE_TYPE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceType_ = "";
  /**
   *
   *
   * <pre>
   * Type of GCP resource being modified/tested. This field is always populated.
   * Example: cloudresourcemanager.googleapis.com/Project,
   * compute.googleapis.com/Instance
   * </pre>
   *
   * <code>string resource_type = 2;</code>
   *
   * @return The resourceType.
   */
  @java.lang.Override
  public java.lang.String getResourceType() {
    java.lang.Object ref = resourceType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Type of GCP resource being modified/tested. This field is always populated.
   * Example: cloudresourcemanager.googleapis.com/Project,
   * compute.googleapis.com/Instance
   * </pre>
   *
   * <code>string resource_type = 2;</code>
   *
   * @return The bytes for resourceType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResourceTypeBytes() {
    java.lang.Object ref = resourceType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resourceType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESOURCE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object resource_ = "";
  /**
   *
   *
   * <pre>
   * Contains the fully qualified resource name. This field is always populated.
   * ex: //cloudresourcemanager.googleapis.com/projects/foo.
   * </pre>
   *
   * <code>string resource = 3;</code>
   *
   * @return The resource.
   */
  @java.lang.Override
  public java.lang.String getResource() {
    java.lang.Object ref = resource_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resource_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Contains the fully qualified resource name. This field is always populated.
   * ex: //cloudresourcemanager.googleapis.com/projects/foo.
   * </pre>
   *
   * <code>string resource = 3;</code>
   *
   * @return The bytes for resource.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResourceBytes() {
    java.lang.Object ref = resource_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resource_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PATH_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object path_ = "";
  /**
   *
   *
   * <pre>
   * Path to the target field being operated on. If the operation is at the
   * resource level, then path should be "/". This field is always populated.
   * </pre>
   *
   * <code>string path = 4;</code>
   *
   * @return The path.
   */
  @java.lang.Override
  public java.lang.String getPath() {
    java.lang.Object ref = path_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      path_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Path to the target field being operated on. If the operation is at the
   * resource level, then path should be "/". This field is always populated.
   * </pre>
   *
   * <code>string path = 4;</code>
   *
   * @return The bytes for path.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPathBytes() {
    java.lang.Object ref = path_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      path_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_RESOURCE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceResource_ = "";
  /**
   *
   *
   * <pre>
   * Can be set with action 'copy' to copy resource configuration across
   * different resources of the same type. Example: A resource clone can be
   * done via action = 'copy', path = "/", from = "/",
   * source_resource = &lt;source&gt; and resource_name = &lt;target&gt;.
   * This field is empty for all other values of `action`.
   * </pre>
   *
   * <code>string source_resource = 5;</code>
   *
   * @return The sourceResource.
   */
  @java.lang.Override
  public java.lang.String getSourceResource() {
    java.lang.Object ref = sourceResource_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceResource_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Can be set with action 'copy' to copy resource configuration across
   * different resources of the same type. Example: A resource clone can be
   * done via action = 'copy', path = "/", from = "/",
   * source_resource = &lt;source&gt; and resource_name = &lt;target&gt;.
   * This field is empty for all other values of `action`.
   * </pre>
   *
   * <code>string source_resource = 5;</code>
   *
   * @return The bytes for sourceResource.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceResourceBytes() {
    java.lang.Object ref = sourceResource_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceResource_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_PATH_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourcePath_ = "";
  /**
   *
   *
   * <pre>
   * Can be set with action 'copy' or 'move' to indicate the source field within
   * resource or source_resource, ignored if provided for other operation types.
   * </pre>
   *
   * <code>string source_path = 6;</code>
   *
   * @return The sourcePath.
   */
  @java.lang.Override
  public java.lang.String getSourcePath() {
    java.lang.Object ref = sourcePath_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourcePath_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Can be set with action 'copy' or 'move' to indicate the source field within
   * resource or source_resource, ignored if provided for other operation types.
   * </pre>
   *
   * <code>string source_path = 6;</code>
   *
   * @return The bytes for sourcePath.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourcePathBytes() {
    java.lang.Object ref = sourcePath_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourcePath_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALUE_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Value for the `path` field. Will be set for actions:'add'/'replace'.
   * Maybe set for action: 'test'. Either this or `value_matcher` will be set
   * for 'test' operation. An exact match must be performed.
   * </pre>
   *
   * <code>.google.protobuf.Value value = 7;</code>
   *
   * @return Whether the value field is set.
   */
  @java.lang.Override
  public boolean hasValue() {
    return pathValueCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Value for the `path` field. Will be set for actions:'add'/'replace'.
   * Maybe set for action: 'test'. Either this or `value_matcher` will be set
   * for 'test' operation. An exact match must be performed.
   * </pre>
   *
   * <code>.google.protobuf.Value value = 7;</code>
   *
   * @return The value.
   */
  @java.lang.Override
  public com.google.protobuf.Value getValue() {
    if (pathValueCase_ == 7) {
      return (com.google.protobuf.Value) pathValue_;
    }
    return com.google.protobuf.Value.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Value for the `path` field. Will be set for actions:'add'/'replace'.
   * Maybe set for action: 'test'. Either this or `value_matcher` will be set
   * for 'test' operation. An exact match must be performed.
   * </pre>
   *
   * <code>.google.protobuf.Value value = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getValueOrBuilder() {
    if (pathValueCase_ == 7) {
      return (com.google.protobuf.Value) pathValue_;
    }
    return com.google.protobuf.Value.getDefaultInstance();
  }

  public static final int VALUE_MATCHER_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * Can be set for action 'test' for advanced matching for the value of
   * 'path' field. Either this or `value` will be set for 'test' operation.
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.ValueMatcher value_matcher = 10;</code>
   *
   * @return Whether the valueMatcher field is set.
   */
  @java.lang.Override
  public boolean hasValueMatcher() {
    return pathValueCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * Can be set for action 'test' for advanced matching for the value of
   * 'path' field. Either this or `value` will be set for 'test' operation.
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.ValueMatcher value_matcher = 10;</code>
   *
   * @return The valueMatcher.
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.ValueMatcher getValueMatcher() {
    if (pathValueCase_ == 10) {
      return (com.google.cloud.recommender.v1.ValueMatcher) pathValue_;
    }
    return com.google.cloud.recommender.v1.ValueMatcher.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Can be set for action 'test' for advanced matching for the value of
   * 'path' field. Either this or `value` will be set for 'test' operation.
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.ValueMatcher value_matcher = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.ValueMatcherOrBuilder getValueMatcherOrBuilder() {
    if (pathValueCase_ == 10) {
      return (com.google.cloud.recommender.v1.ValueMatcher) pathValue_;
    }
    return com.google.cloud.recommender.v1.ValueMatcher.getDefaultInstance();
  }

  public static final int PATH_FILTERS_FIELD_NUMBER = 8;

  private static final class PathFiltersDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.protobuf.Value>newDefaultInstance(
                    com.google.cloud.recommender.v1.RecommendationOuterClass
                        .internal_static_google_cloud_recommender_v1_Operation_PathFiltersEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.protobuf.Value.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value> pathFilters_;

  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
      internalGetPathFilters() {
    if (pathFilters_ == null) {
      return com.google.protobuf.MapField.emptyMapField(PathFiltersDefaultEntryHolder.defaultEntry);
    }
    return pathFilters_;
  }

  public int getPathFiltersCount() {
    return internalGetPathFilters().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Set of filters to apply if `path` refers to array elements or nested array
   * elements in order to narrow down to a single unique element that is being
   * tested/modified.
   * This is intended to be an exact match per filter. To perform advanced
   * matching, use path_value_matchers.
   *
   * * Example:
   * ```
   * {
   *   "/versions/&#42;&#47;name" : "it-123"
   *   "/versions/&#42;&#47;targetSize/percent": 20
   * }
   * ```
   * * Example:
   * ```
   * {
   *   "/bindings/&#42;&#47;role": "roles/owner"
   *   "/bindings/&#42;&#47;condition" : null
   * }
   * ```
   * * Example:
   * ```
   * {
   *   "/bindings/&#42;&#47;role": "roles/owner"
   *   "/bindings/&#42;&#47;members/&#42;" : ["x&#64;example.com", "y&#64;example.com"]
   * }
   * ```
   * When both path_filters and path_value_matchers are set, an implicit AND
   * must be performed.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; path_filters = 8;</code>
   */
  @java.lang.Override
  public boolean containsPathFilters(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetPathFilters().getMap().containsKey(key);
  }
  /** Use {@link #getPathFiltersMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.protobuf.Value> getPathFilters() {
    return getPathFiltersMap();
  }
  /**
   *
   *
   * <pre>
   * Set of filters to apply if `path` refers to array elements or nested array
   * elements in order to narrow down to a single unique element that is being
   * tested/modified.
   * This is intended to be an exact match per filter. To perform advanced
   * matching, use path_value_matchers.
   *
   * * Example:
   * ```
   * {
   *   "/versions/&#42;&#47;name" : "it-123"
   *   "/versions/&#42;&#47;targetSize/percent": 20
   * }
   * ```
   * * Example:
   * ```
   * {
   *   "/bindings/&#42;&#47;role": "roles/owner"
   *   "/bindings/&#42;&#47;condition" : null
   * }
   * ```
   * * Example:
   * ```
   * {
   *   "/bindings/&#42;&#47;role": "roles/owner"
   *   "/bindings/&#42;&#47;members/&#42;" : ["x&#64;example.com", "y&#64;example.com"]
   * }
   * ```
   * When both path_filters and path_value_matchers are set, an implicit AND
   * must be performed.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; path_filters = 8;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.protobuf.Value> getPathFiltersMap() {
    return internalGetPathFilters().getMap();
  }
  /**
   *
   *
   * <pre>
   * Set of filters to apply if `path` refers to array elements or nested array
   * elements in order to narrow down to a single unique element that is being
   * tested/modified.
   * This is intended to be an exact match per filter. To perform advanced
   * matching, use path_value_matchers.
   *
   * * Example:
   * ```
   * {
   *   "/versions/&#42;&#47;name" : "it-123"
   *   "/versions/&#42;&#47;targetSize/percent": 20
   * }
   * ```
   * * Example:
   * ```
   * {
   *   "/bindings/&#42;&#47;role": "roles/owner"
   *   "/bindings/&#42;&#47;condition" : null
   * }
   * ```
   * * Example:
   * ```
   * {
   *   "/bindings/&#42;&#47;role": "roles/owner"
   *   "/bindings/&#42;&#47;members/&#42;" : ["x&#64;example.com", "y&#64;example.com"]
   * }
   * ```
   * When both path_filters and path_value_matchers are set, an implicit AND
   * must be performed.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; path_filters = 8;</code>
   */
  @java.lang.Override
  public /* nullable */ com.google.protobuf.Value getPathFiltersOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.protobuf.Value defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.protobuf.Value> map =
        internalGetPathFilters().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Set of filters to apply if `path` refers to array elements or nested array
   * elements in order to narrow down to a single unique element that is being
   * tested/modified.
   * This is intended to be an exact match per filter. To perform advanced
   * matching, use path_value_matchers.
   *
   * * Example:
   * ```
   * {
   *   "/versions/&#42;&#47;name" : "it-123"
   *   "/versions/&#42;&#47;targetSize/percent": 20
   * }
   * ```
   * * Example:
   * ```
   * {
   *   "/bindings/&#42;&#47;role": "roles/owner"
   *   "/bindings/&#42;&#47;condition" : null
   * }
   * ```
   * * Example:
   * ```
   * {
   *   "/bindings/&#42;&#47;role": "roles/owner"
   *   "/bindings/&#42;&#47;members/&#42;" : ["x&#64;example.com", "y&#64;example.com"]
   * }
   * ```
   * When both path_filters and path_value_matchers are set, an implicit AND
   * must be performed.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; path_filters = 8;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Value getPathFiltersOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.protobuf.Value> map =
        internalGetPathFilters().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int PATH_VALUE_MATCHERS_FIELD_NUMBER = 11;

  private static final class PathValueMatchersDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.recommender.v1.ValueMatcher>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.recommender.v1.ValueMatcher>newDefaultInstance(
                    com.google.cloud.recommender.v1.RecommendationOuterClass
                        .internal_static_google_cloud_recommender_v1_Operation_PathValueMatchersEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.cloud.recommender.v1.ValueMatcher.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.recommender.v1.ValueMatcher>
      pathValueMatchers_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.recommender.v1.ValueMatcher>
      internalGetPathValueMatchers() {
    if (pathValueMatchers_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          PathValueMatchersDefaultEntryHolder.defaultEntry);
    }
    return pathValueMatchers_;
  }

  public int getPathValueMatchersCount() {
    return internalGetPathValueMatchers().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Similar to path_filters, this contains set of filters to apply if `path`
   * field refers to array elements. This is meant to support value matching
   * beyond exact match. To perform exact match, use path_filters.
   * When both path_filters and path_value_matchers are set, an implicit AND
   * must be performed.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.recommender.v1.ValueMatcher&gt; path_value_matchers = 11;
   * </code>
   */
  @java.lang.Override
  public boolean containsPathValueMatchers(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetPathValueMatchers().getMap().containsKey(key);
  }
  /** Use {@link #getPathValueMatchersMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.recommender.v1.ValueMatcher>
      getPathValueMatchers() {
    return getPathValueMatchersMap();
  }
  /**
   *
   *
   * <pre>
   * Similar to path_filters, this contains set of filters to apply if `path`
   * field refers to array elements. This is meant to support value matching
   * beyond exact match. To perform exact match, use path_filters.
   * When both path_filters and path_value_matchers are set, an implicit AND
   * must be performed.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.recommender.v1.ValueMatcher&gt; path_value_matchers = 11;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.recommender.v1.ValueMatcher>
      getPathValueMatchersMap() {
    return internalGetPathValueMatchers().getMap();
  }
  /**
   *
   *
   * <pre>
   * Similar to path_filters, this contains set of filters to apply if `path`
   * field refers to array elements. This is meant to support value matching
   * beyond exact match. To perform exact match, use path_filters.
   * When both path_filters and path_value_matchers are set, an implicit AND
   * must be performed.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.recommender.v1.ValueMatcher&gt; path_value_matchers = 11;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.recommender.v1.ValueMatcher getPathValueMatchersOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.recommender.v1.ValueMatcher defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.recommender.v1.ValueMatcher> map =
        internalGetPathValueMatchers().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Similar to path_filters, this contains set of filters to apply if `path`
   * field refers to array elements. This is meant to support value matching
   * beyond exact match. To perform exact match, use path_filters.
   * When both path_filters and path_value_matchers are set, an implicit AND
   * must be performed.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.recommender.v1.ValueMatcher&gt; path_value_matchers = 11;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.ValueMatcher getPathValueMatchersOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.recommender.v1.ValueMatcher> map =
        internalGetPathValueMatchers().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(action_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, action_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, resourceType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resource_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, resource_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, path_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceResource_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, sourceResource_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourcePath_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, sourcePath_);
    }
    if (pathValueCase_ == 7) {
      output.writeMessage(7, (com.google.protobuf.Value) pathValue_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetPathFilters(), PathFiltersDefaultEntryHolder.defaultEntry, 8);
    if (pathValueCase_ == 10) {
      output.writeMessage(10, (com.google.cloud.recommender.v1.ValueMatcher) pathValue_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetPathValueMatchers(),
        PathValueMatchersDefaultEntryHolder.defaultEntry,
        11);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(action_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, action_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, resourceType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resource_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, resource_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, path_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceResource_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, sourceResource_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourcePath_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, sourcePath_);
    }
    if (pathValueCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.protobuf.Value) pathValue_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Value> entry :
        internalGetPathFilters().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value> pathFilters__ =
          PathFiltersDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, pathFilters__);
    }
    if (pathValueCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.cloud.recommender.v1.ValueMatcher) pathValue_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.recommender.v1.ValueMatcher> entry :
        internalGetPathValueMatchers().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.cloud.recommender.v1.ValueMatcher>
          pathValueMatchers__ =
              PathValueMatchersDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, pathValueMatchers__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.recommender.v1.Operation)) {
      return super.equals(obj);
    }
    com.google.cloud.recommender.v1.Operation other =
        (com.google.cloud.recommender.v1.Operation) obj;

    if (!getAction().equals(other.getAction())) return false;
    if (!getResourceType().equals(other.getResourceType())) return false;
    if (!getResource().equals(other.getResource())) return false;
    if (!getPath().equals(other.getPath())) return false;
    if (!getSourceResource().equals(other.getSourceResource())) return false;
    if (!getSourcePath().equals(other.getSourcePath())) return false;
    if (!internalGetPathFilters().equals(other.internalGetPathFilters())) return false;
    if (!internalGetPathValueMatchers().equals(other.internalGetPathValueMatchers())) return false;
    if (!getPathValueCase().equals(other.getPathValueCase())) return false;
    switch (pathValueCase_) {
      case 7:
        if (!getValue().equals(other.getValue())) return false;
        break;
      case 10:
        if (!getValueMatcher().equals(other.getValueMatcher())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ACTION_FIELD_NUMBER;
    hash = (53 * hash) + getAction().hashCode();
    hash = (37 * hash) + RESOURCE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getResourceType().hashCode();
    hash = (37 * hash) + RESOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getResource().hashCode();
    hash = (37 * hash) + PATH_FIELD_NUMBER;
    hash = (53 * hash) + getPath().hashCode();
    hash = (37 * hash) + SOURCE_RESOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getSourceResource().hashCode();
    hash = (37 * hash) + SOURCE_PATH_FIELD_NUMBER;
    hash = (53 * hash) + getSourcePath().hashCode();
    if (!internalGetPathFilters().getMap().isEmpty()) {
      hash = (37 * hash) + PATH_FILTERS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetPathFilters().hashCode();
    }
    if (!internalGetPathValueMatchers().getMap().isEmpty()) {
      hash = (37 * hash) + PATH_VALUE_MATCHERS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetPathValueMatchers().hashCode();
    }
    switch (pathValueCase_) {
      case 7:
        hash = (37 * hash) + VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getValue().hashCode();
        break;
      case 10:
        hash = (37 * hash) + VALUE_MATCHER_FIELD_NUMBER;
        hash = (53 * hash) + getValueMatcher().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.recommender.v1.Operation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.recommender.v1.Operation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.recommender.v1.Operation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.recommender.v1.Operation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.recommender.v1.Operation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.recommender.v1.Operation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.recommender.v1.Operation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.recommender.v1.Operation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.recommender.v1.Operation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.recommender.v1.Operation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.recommender.v1.Operation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.recommender.v1.Operation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.recommender.v1.Operation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Contains an operation for a resource loosely based on the JSON-PATCH format
   * with support for:
   *
   * * Custom filters for describing partial array patch.
   * * Extended path values for describing nested arrays.
   * * Custom fields for describing the resource for which the operation is being
   *   described.
   * * Allows extension to custom operations not natively supported by RFC6902.
   * See https://tools.ietf.org/html/rfc6902 for details on the original RFC.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recommender.v1.Operation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.recommender.v1.Operation)
      com.google.cloud.recommender.v1.OperationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.recommender.v1.RecommendationOuterClass
          .internal_static_google_cloud_recommender_v1_Operation_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 8:
          return internalGetPathFilters();
        case 11:
          return internalGetPathValueMatchers();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 8:
          return internalGetMutablePathFilters();
        case 11:
          return internalGetMutablePathValueMatchers();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.recommender.v1.RecommendationOuterClass
          .internal_static_google_cloud_recommender_v1_Operation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.recommender.v1.Operation.class,
              com.google.cloud.recommender.v1.Operation.Builder.class);
    }

    // Construct using com.google.cloud.recommender.v1.Operation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      action_ = "";
      resourceType_ = "";
      resource_ = "";
      path_ = "";
      sourceResource_ = "";
      sourcePath_ = "";
      if (valueBuilder_ != null) {
        valueBuilder_.clear();
      }
      if (valueMatcherBuilder_ != null) {
        valueMatcherBuilder_.clear();
      }
      internalGetMutablePathFilters().clear();
      internalGetMutablePathValueMatchers().clear();
      pathValueCase_ = 0;
      pathValue_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.recommender.v1.RecommendationOuterClass
          .internal_static_google_cloud_recommender_v1_Operation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.recommender.v1.Operation getDefaultInstanceForType() {
      return com.google.cloud.recommender.v1.Operation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.recommender.v1.Operation build() {
      com.google.cloud.recommender.v1.Operation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.recommender.v1.Operation buildPartial() {
      com.google.cloud.recommender.v1.Operation result =
          new com.google.cloud.recommender.v1.Operation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.recommender.v1.Operation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.action_ = action_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.resourceType_ = resourceType_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.resource_ = resource_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.path_ = path_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.sourceResource_ = sourceResource_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.sourcePath_ = sourcePath_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.pathFilters_ = internalGetPathFilters();
        result.pathFilters_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.pathValueMatchers_ = internalGetPathValueMatchers();
        result.pathValueMatchers_.makeImmutable();
      }
    }

    private void buildPartialOneofs(com.google.cloud.recommender.v1.Operation result) {
      result.pathValueCase_ = pathValueCase_;
      result.pathValue_ = this.pathValue_;
      if (pathValueCase_ == 7 && valueBuilder_ != null) {
        result.pathValue_ = valueBuilder_.build();
      }
      if (pathValueCase_ == 10 && valueMatcherBuilder_ != null) {
        result.pathValue_ = valueMatcherBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.recommender.v1.Operation) {
        return mergeFrom((com.google.cloud.recommender.v1.Operation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.recommender.v1.Operation other) {
      if (other == com.google.cloud.recommender.v1.Operation.getDefaultInstance()) return this;
      if (!other.getAction().isEmpty()) {
        action_ = other.action_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getResourceType().isEmpty()) {
        resourceType_ = other.resourceType_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getResource().isEmpty()) {
        resource_ = other.resource_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getPath().isEmpty()) {
        path_ = other.path_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getSourceResource().isEmpty()) {
        sourceResource_ = other.sourceResource_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getSourcePath().isEmpty()) {
        sourcePath_ = other.sourcePath_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      internalGetMutablePathFilters().mergeFrom(other.internalGetPathFilters());
      bitField0_ |= 0x00000100;
      internalGetMutablePathValueMatchers().mergeFrom(other.internalGetPathValueMatchers());
      bitField0_ |= 0x00000200;
      switch (other.getPathValueCase()) {
        case VALUE:
          {
            mergeValue(other.getValue());
            break;
          }
        case VALUE_MATCHER:
          {
            mergeValueMatcher(other.getValueMatcher());
            break;
          }
        case PATHVALUE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                action_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                resourceType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                resource_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                path_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                sourceResource_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                sourcePath_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getValueFieldBuilder().getBuilder(), extensionRegistry);
                pathValueCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
                    pathFilters__ =
                        input.readMessage(
                            PathFiltersDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutablePathFilters()
                    .getMutableMap()
                    .put(pathFilters__.getKey(), pathFilters__.getValue());
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 82:
              {
                input.readMessage(getValueMatcherFieldBuilder().getBuilder(), extensionRegistry);
                pathValueCase_ = 10;
                break;
              } // case 82
            case 90:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.recommender.v1.ValueMatcher>
                    pathValueMatchers__ =
                        input.readMessage(
                            PathValueMatchersDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutablePathValueMatchers()
                    .getMutableMap()
                    .put(pathValueMatchers__.getKey(), pathValueMatchers__.getValue());
                bitField0_ |= 0x00000200;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int pathValueCase_ = 0;
    private java.lang.Object pathValue_;

    public PathValueCase getPathValueCase() {
      return PathValueCase.forNumber(pathValueCase_);
    }

    public Builder clearPathValue() {
      pathValueCase_ = 0;
      pathValue_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object action_ = "";
    /**
     *
     *
     * <pre>
     * Type of this operation. Contains one of 'add', 'remove', 'replace', 'move',
     * 'copy', 'test' and custom operations. This field is case-insensitive and
     * always populated.
     * </pre>
     *
     * <code>string action = 1;</code>
     *
     * @return The action.
     */
    public java.lang.String getAction() {
      java.lang.Object ref = action_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        action_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of this operation. Contains one of 'add', 'remove', 'replace', 'move',
     * 'copy', 'test' and custom operations. This field is case-insensitive and
     * always populated.
     * </pre>
     *
     * <code>string action = 1;</code>
     *
     * @return The bytes for action.
     */
    public com.google.protobuf.ByteString getActionBytes() {
      java.lang.Object ref = action_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        action_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of this operation. Contains one of 'add', 'remove', 'replace', 'move',
     * 'copy', 'test' and custom operations. This field is case-insensitive and
     * always populated.
     * </pre>
     *
     * <code>string action = 1;</code>
     *
     * @param value The action to set.
     * @return This builder for chaining.
     */
    public Builder setAction(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      action_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of this operation. Contains one of 'add', 'remove', 'replace', 'move',
     * 'copy', 'test' and custom operations. This field is case-insensitive and
     * always populated.
     * </pre>
     *
     * <code>string action = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAction() {
      action_ = getDefaultInstance().getAction();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of this operation. Contains one of 'add', 'remove', 'replace', 'move',
     * 'copy', 'test' and custom operations. This field is case-insensitive and
     * always populated.
     * </pre>
     *
     * <code>string action = 1;</code>
     *
     * @param value The bytes for action to set.
     * @return This builder for chaining.
     */
    public Builder setActionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      action_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object resourceType_ = "";
    /**
     *
     *
     * <pre>
     * Type of GCP resource being modified/tested. This field is always populated.
     * Example: cloudresourcemanager.googleapis.com/Project,
     * compute.googleapis.com/Instance
     * </pre>
     *
     * <code>string resource_type = 2;</code>
     *
     * @return The resourceType.
     */
    public java.lang.String getResourceType() {
      java.lang.Object ref = resourceType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of GCP resource being modified/tested. This field is always populated.
     * Example: cloudresourcemanager.googleapis.com/Project,
     * compute.googleapis.com/Instance
     * </pre>
     *
     * <code>string resource_type = 2;</code>
     *
     * @return The bytes for resourceType.
     */
    public com.google.protobuf.ByteString getResourceTypeBytes() {
      java.lang.Object ref = resourceType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of GCP resource being modified/tested. This field is always populated.
     * Example: cloudresourcemanager.googleapis.com/Project,
     * compute.googleapis.com/Instance
     * </pre>
     *
     * <code>string resource_type = 2;</code>
     *
     * @param value The resourceType to set.
     * @return This builder for chaining.
     */
    public Builder setResourceType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resourceType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of GCP resource being modified/tested. This field is always populated.
     * Example: cloudresourcemanager.googleapis.com/Project,
     * compute.googleapis.com/Instance
     * </pre>
     *
     * <code>string resource_type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceType() {
      resourceType_ = getDefaultInstance().getResourceType();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of GCP resource being modified/tested. This field is always populated.
     * Example: cloudresourcemanager.googleapis.com/Project,
     * compute.googleapis.com/Instance
     * </pre>
     *
     * <code>string resource_type = 2;</code>
     *
     * @param value The bytes for resourceType to set.
     * @return This builder for chaining.
     */
    public Builder setResourceTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      resourceType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object resource_ = "";
    /**
     *
     *
     * <pre>
     * Contains the fully qualified resource name. This field is always populated.
     * ex: //cloudresourcemanager.googleapis.com/projects/foo.
     * </pre>
     *
     * <code>string resource = 3;</code>
     *
     * @return The resource.
     */
    public java.lang.String getResource() {
      java.lang.Object ref = resource_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resource_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Contains the fully qualified resource name. This field is always populated.
     * ex: //cloudresourcemanager.googleapis.com/projects/foo.
     * </pre>
     *
     * <code>string resource = 3;</code>
     *
     * @return The bytes for resource.
     */
    public com.google.protobuf.ByteString getResourceBytes() {
      java.lang.Object ref = resource_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Contains the fully qualified resource name. This field is always populated.
     * ex: //cloudresourcemanager.googleapis.com/projects/foo.
     * </pre>
     *
     * <code>string resource = 3;</code>
     *
     * @param value The resource to set.
     * @return This builder for chaining.
     */
    public Builder setResource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resource_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains the fully qualified resource name. This field is always populated.
     * ex: //cloudresourcemanager.googleapis.com/projects/foo.
     * </pre>
     *
     * <code>string resource = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResource() {
      resource_ = getDefaultInstance().getResource();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains the fully qualified resource name. This field is always populated.
     * ex: //cloudresourcemanager.googleapis.com/projects/foo.
     * </pre>
     *
     * <code>string resource = 3;</code>
     *
     * @param value The bytes for resource to set.
     * @return This builder for chaining.
     */
    public Builder setResourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      resource_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object path_ = "";
    /**
     *
     *
     * <pre>
     * Path to the target field being operated on. If the operation is at the
     * resource level, then path should be "/". This field is always populated.
     * </pre>
     *
     * <code>string path = 4;</code>
     *
     * @return The path.
     */
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        path_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Path to the target field being operated on. If the operation is at the
     * resource level, then path should be "/". This field is always populated.
     * </pre>
     *
     * <code>string path = 4;</code>
     *
     * @return The bytes for path.
     */
    public com.google.protobuf.ByteString getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Path to the target field being operated on. If the operation is at the
     * resource level, then path should be "/". This field is always populated.
     * </pre>
     *
     * <code>string path = 4;</code>
     *
     * @param value The path to set.
     * @return This builder for chaining.
     */
    public Builder setPath(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      path_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Path to the target field being operated on. If the operation is at the
     * resource level, then path should be "/". This field is always populated.
     * </pre>
     *
     * <code>string path = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPath() {
      path_ = getDefaultInstance().getPath();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Path to the target field being operated on. If the operation is at the
     * resource level, then path should be "/". This field is always populated.
     * </pre>
     *
     * <code>string path = 4;</code>
     *
     * @param value The bytes for path to set.
     * @return This builder for chaining.
     */
    public Builder setPathBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      path_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object sourceResource_ = "";
    /**
     *
     *
     * <pre>
     * Can be set with action 'copy' to copy resource configuration across
     * different resources of the same type. Example: A resource clone can be
     * done via action = 'copy', path = "/", from = "/",
     * source_resource = &lt;source&gt; and resource_name = &lt;target&gt;.
     * This field is empty for all other values of `action`.
     * </pre>
     *
     * <code>string source_resource = 5;</code>
     *
     * @return The sourceResource.
     */
    public java.lang.String getSourceResource() {
      java.lang.Object ref = sourceResource_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceResource_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Can be set with action 'copy' to copy resource configuration across
     * different resources of the same type. Example: A resource clone can be
     * done via action = 'copy', path = "/", from = "/",
     * source_resource = &lt;source&gt; and resource_name = &lt;target&gt;.
     * This field is empty for all other values of `action`.
     * </pre>
     *
     * <code>string source_resource = 5;</code>
     *
     * @return The bytes for sourceResource.
     */
    public com.google.protobuf.ByteString getSourceResourceBytes() {
      java.lang.Object ref = sourceResource_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceResource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Can be set with action 'copy' to copy resource configuration across
     * different resources of the same type. Example: A resource clone can be
     * done via action = 'copy', path = "/", from = "/",
     * source_resource = &lt;source&gt; and resource_name = &lt;target&gt;.
     * This field is empty for all other values of `action`.
     * </pre>
     *
     * <code>string source_resource = 5;</code>
     *
     * @param value The sourceResource to set.
     * @return This builder for chaining.
     */
    public Builder setSourceResource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceResource_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Can be set with action 'copy' to copy resource configuration across
     * different resources of the same type. Example: A resource clone can be
     * done via action = 'copy', path = "/", from = "/",
     * source_resource = &lt;source&gt; and resource_name = &lt;target&gt;.
     * This field is empty for all other values of `action`.
     * </pre>
     *
     * <code>string source_resource = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceResource() {
      sourceResource_ = getDefaultInstance().getSourceResource();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Can be set with action 'copy' to copy resource configuration across
     * different resources of the same type. Example: A resource clone can be
     * done via action = 'copy', path = "/", from = "/",
     * source_resource = &lt;source&gt; and resource_name = &lt;target&gt;.
     * This field is empty for all other values of `action`.
     * </pre>
     *
     * <code>string source_resource = 5;</code>
     *
     * @param value The bytes for sourceResource to set.
     * @return This builder for chaining.
     */
    public Builder setSourceResourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceResource_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object sourcePath_ = "";
    /**
     *
     *
     * <pre>
     * Can be set with action 'copy' or 'move' to indicate the source field within
     * resource or source_resource, ignored if provided for other operation types.
     * </pre>
     *
     * <code>string source_path = 6;</code>
     *
     * @return The sourcePath.
     */
    public java.lang.String getSourcePath() {
      java.lang.Object ref = sourcePath_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourcePath_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Can be set with action 'copy' or 'move' to indicate the source field within
     * resource or source_resource, ignored if provided for other operation types.
     * </pre>
     *
     * <code>string source_path = 6;</code>
     *
     * @return The bytes for sourcePath.
     */
    public com.google.protobuf.ByteString getSourcePathBytes() {
      java.lang.Object ref = sourcePath_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourcePath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Can be set with action 'copy' or 'move' to indicate the source field within
     * resource or source_resource, ignored if provided for other operation types.
     * </pre>
     *
     * <code>string source_path = 6;</code>
     *
     * @param value The sourcePath to set.
     * @return This builder for chaining.
     */
    public Builder setSourcePath(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourcePath_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Can be set with action 'copy' or 'move' to indicate the source field within
     * resource or source_resource, ignored if provided for other operation types.
     * </pre>
     *
     * <code>string source_path = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourcePath() {
      sourcePath_ = getDefaultInstance().getSourcePath();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Can be set with action 'copy' or 'move' to indicate the source field within
     * resource or source_resource, ignored if provided for other operation types.
     * </pre>
     *
     * <code>string source_path = 6;</code>
     *
     * @param value The bytes for sourcePath to set.
     * @return This builder for chaining.
     */
    public Builder setSourcePathBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourcePath_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        valueBuilder_;
    /**
     *
     *
     * <pre>
     * Value for the `path` field. Will be set for actions:'add'/'replace'.
     * Maybe set for action: 'test'. Either this or `value_matcher` will be set
     * for 'test' operation. An exact match must be performed.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 7;</code>
     *
     * @return Whether the value field is set.
     */
    @java.lang.Override
    public boolean hasValue() {
      return pathValueCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Value for the `path` field. Will be set for actions:'add'/'replace'.
     * Maybe set for action: 'test'. Either this or `value_matcher` will be set
     * for 'test' operation. An exact match must be performed.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 7;</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public com.google.protobuf.Value getValue() {
      if (valueBuilder_ == null) {
        if (pathValueCase_ == 7) {
          return (com.google.protobuf.Value) pathValue_;
        }
        return com.google.protobuf.Value.getDefaultInstance();
      } else {
        if (pathValueCase_ == 7) {
          return valueBuilder_.getMessage();
        }
        return com.google.protobuf.Value.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Value for the `path` field. Will be set for actions:'add'/'replace'.
     * Maybe set for action: 'test'. Either this or `value_matcher` will be set
     * for 'test' operation. An exact match must be performed.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 7;</code>
     */
    public Builder setValue(com.google.protobuf.Value value) {
      if (valueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pathValue_ = value;
        onChanged();
      } else {
        valueBuilder_.setMessage(value);
      }
      pathValueCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Value for the `path` field. Will be set for actions:'add'/'replace'.
     * Maybe set for action: 'test'. Either this or `value_matcher` will be set
     * for 'test' operation. An exact match must be performed.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 7;</code>
     */
    public Builder setValue(com.google.protobuf.Value.Builder builderForValue) {
      if (valueBuilder_ == null) {
        pathValue_ = builderForValue.build();
        onChanged();
      } else {
        valueBuilder_.setMessage(builderForValue.build());
      }
      pathValueCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Value for the `path` field. Will be set for actions:'add'/'replace'.
     * Maybe set for action: 'test'. Either this or `value_matcher` will be set
     * for 'test' operation. An exact match must be performed.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 7;</code>
     */
    public Builder mergeValue(com.google.protobuf.Value value) {
      if (valueBuilder_ == null) {
        if (pathValueCase_ == 7 && pathValue_ != com.google.protobuf.Value.getDefaultInstance()) {
          pathValue_ =
              com.google.protobuf.Value.newBuilder((com.google.protobuf.Value) pathValue_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          pathValue_ = value;
        }
        onChanged();
      } else {
        if (pathValueCase_ == 7) {
          valueBuilder_.mergeFrom(value);
        } else {
          valueBuilder_.setMessage(value);
        }
      }
      pathValueCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Value for the `path` field. Will be set for actions:'add'/'replace'.
     * Maybe set for action: 'test'. Either this or `value_matcher` will be set
     * for 'test' operation. An exact match must be performed.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 7;</code>
     */
    public Builder clearValue() {
      if (valueBuilder_ == null) {
        if (pathValueCase_ == 7) {
          pathValueCase_ = 0;
          pathValue_ = null;
          onChanged();
        }
      } else {
        if (pathValueCase_ == 7) {
          pathValueCase_ = 0;
          pathValue_ = null;
        }
        valueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Value for the `path` field. Will be set for actions:'add'/'replace'.
     * Maybe set for action: 'test'. Either this or `value_matcher` will be set
     * for 'test' operation. An exact match must be performed.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 7;</code>
     */
    public com.google.protobuf.Value.Builder getValueBuilder() {
      return getValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Value for the `path` field. Will be set for actions:'add'/'replace'.
     * Maybe set for action: 'test'. Either this or `value_matcher` will be set
     * for 'test' operation. An exact match must be performed.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 7;</code>
     */
    @java.lang.Override
    public com.google.protobuf.ValueOrBuilder getValueOrBuilder() {
      if ((pathValueCase_ == 7) && (valueBuilder_ != null)) {
        return valueBuilder_.getMessageOrBuilder();
      } else {
        if (pathValueCase_ == 7) {
          return (com.google.protobuf.Value) pathValue_;
        }
        return com.google.protobuf.Value.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Value for the `path` field. Will be set for actions:'add'/'replace'.
     * Maybe set for action: 'test'. Either this or `value_matcher` will be set
     * for 'test' operation. An exact match must be performed.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getValueFieldBuilder() {
      if (valueBuilder_ == null) {
        if (!(pathValueCase_ == 7)) {
          pathValue_ = com.google.protobuf.Value.getDefaultInstance();
        }
        valueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                (com.google.protobuf.Value) pathValue_, getParentForChildren(), isClean());
        pathValue_ = null;
      }
      pathValueCase_ = 7;
      onChanged();
      return valueBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.recommender.v1.ValueMatcher,
            com.google.cloud.recommender.v1.ValueMatcher.Builder,
            com.google.cloud.recommender.v1.ValueMatcherOrBuilder>
        valueMatcherBuilder_;
    /**
     *
     *
     * <pre>
     * Can be set for action 'test' for advanced matching for the value of
     * 'path' field. Either this or `value` will be set for 'test' operation.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.ValueMatcher value_matcher = 10;</code>
     *
     * @return Whether the valueMatcher field is set.
     */
    @java.lang.Override
    public boolean hasValueMatcher() {
      return pathValueCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * Can be set for action 'test' for advanced matching for the value of
     * 'path' field. Either this or `value` will be set for 'test' operation.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.ValueMatcher value_matcher = 10;</code>
     *
     * @return The valueMatcher.
     */
    @java.lang.Override
    public com.google.cloud.recommender.v1.ValueMatcher getValueMatcher() {
      if (valueMatcherBuilder_ == null) {
        if (pathValueCase_ == 10) {
          return (com.google.cloud.recommender.v1.ValueMatcher) pathValue_;
        }
        return com.google.cloud.recommender.v1.ValueMatcher.getDefaultInstance();
      } else {
        if (pathValueCase_ == 10) {
          return valueMatcherBuilder_.getMessage();
        }
        return com.google.cloud.recommender.v1.ValueMatcher.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Can be set for action 'test' for advanced matching for the value of
     * 'path' field. Either this or `value` will be set for 'test' operation.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.ValueMatcher value_matcher = 10;</code>
     */
    public Builder setValueMatcher(com.google.cloud.recommender.v1.ValueMatcher value) {
      if (valueMatcherBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pathValue_ = value;
        onChanged();
      } else {
        valueMatcherBuilder_.setMessage(value);
      }
      pathValueCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Can be set for action 'test' for advanced matching for the value of
     * 'path' field. Either this or `value` will be set for 'test' operation.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.ValueMatcher value_matcher = 10;</code>
     */
    public Builder setValueMatcher(
        com.google.cloud.recommender.v1.ValueMatcher.Builder builderForValue) {
      if (valueMatcherBuilder_ == null) {
        pathValue_ = builderForValue.build();
        onChanged();
      } else {
        valueMatcherBuilder_.setMessage(builderForValue.build());
      }
      pathValueCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Can be set for action 'test' for advanced matching for the value of
     * 'path' field. Either this or `value` will be set for 'test' operation.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.ValueMatcher value_matcher = 10;</code>
     */
    public Builder mergeValueMatcher(com.google.cloud.recommender.v1.ValueMatcher value) {
      if (valueMatcherBuilder_ == null) {
        if (pathValueCase_ == 10
            && pathValue_ != com.google.cloud.recommender.v1.ValueMatcher.getDefaultInstance()) {
          pathValue_ =
              com.google.cloud.recommender.v1.ValueMatcher.newBuilder(
                      (com.google.cloud.recommender.v1.ValueMatcher) pathValue_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          pathValue_ = value;
        }
        onChanged();
      } else {
        if (pathValueCase_ == 10) {
          valueMatcherBuilder_.mergeFrom(value);
        } else {
          valueMatcherBuilder_.setMessage(value);
        }
      }
      pathValueCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Can be set for action 'test' for advanced matching for the value of
     * 'path' field. Either this or `value` will be set for 'test' operation.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.ValueMatcher value_matcher = 10;</code>
     */
    public Builder clearValueMatcher() {
      if (valueMatcherBuilder_ == null) {
        if (pathValueCase_ == 10) {
          pathValueCase_ = 0;
          pathValue_ = null;
          onChanged();
        }
      } else {
        if (pathValueCase_ == 10) {
          pathValueCase_ = 0;
          pathValue_ = null;
        }
        valueMatcherBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Can be set for action 'test' for advanced matching for the value of
     * 'path' field. Either this or `value` will be set for 'test' operation.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.ValueMatcher value_matcher = 10;</code>
     */
    public com.google.cloud.recommender.v1.ValueMatcher.Builder getValueMatcherBuilder() {
      return getValueMatcherFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Can be set for action 'test' for advanced matching for the value of
     * 'path' field. Either this or `value` will be set for 'test' operation.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.ValueMatcher value_matcher = 10;</code>
     */
    @java.lang.Override
    public com.google.cloud.recommender.v1.ValueMatcherOrBuilder getValueMatcherOrBuilder() {
      if ((pathValueCase_ == 10) && (valueMatcherBuilder_ != null)) {
        return valueMatcherBuilder_.getMessageOrBuilder();
      } else {
        if (pathValueCase_ == 10) {
          return (com.google.cloud.recommender.v1.ValueMatcher) pathValue_;
        }
        return com.google.cloud.recommender.v1.ValueMatcher.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Can be set for action 'test' for advanced matching for the value of
     * 'path' field. Either this or `value` will be set for 'test' operation.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.ValueMatcher value_matcher = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.recommender.v1.ValueMatcher,
            com.google.cloud.recommender.v1.ValueMatcher.Builder,
            com.google.cloud.recommender.v1.ValueMatcherOrBuilder>
        getValueMatcherFieldBuilder() {
      if (valueMatcherBuilder_ == null) {
        if (!(pathValueCase_ == 10)) {
          pathValue_ = com.google.cloud.recommender.v1.ValueMatcher.getDefaultInstance();
        }
        valueMatcherBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.recommender.v1.ValueMatcher,
                com.google.cloud.recommender.v1.ValueMatcher.Builder,
                com.google.cloud.recommender.v1.ValueMatcherOrBuilder>(
                (com.google.cloud.recommender.v1.ValueMatcher) pathValue_,
                getParentForChildren(),
                isClean());
        pathValue_ = null;
      }
      pathValueCase_ = 10;
      onChanged();
      return valueMatcherBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value> pathFilters_;

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
        internalGetPathFilters() {
      if (pathFilters_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            PathFiltersDefaultEntryHolder.defaultEntry);
      }
      return pathFilters_;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
        internalGetMutablePathFilters() {
      if (pathFilters_ == null) {
        pathFilters_ =
            com.google.protobuf.MapField.newMapField(PathFiltersDefaultEntryHolder.defaultEntry);
      }
      if (!pathFilters_.isMutable()) {
        pathFilters_ = pathFilters_.copy();
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return pathFilters_;
    }

    public int getPathFiltersCount() {
      return internalGetPathFilters().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Set of filters to apply if `path` refers to array elements or nested array
     * elements in order to narrow down to a single unique element that is being
     * tested/modified.
     * This is intended to be an exact match per filter. To perform advanced
     * matching, use path_value_matchers.
     *
     * * Example:
     * ```
     * {
     *   "/versions/&#42;&#47;name" : "it-123"
     *   "/versions/&#42;&#47;targetSize/percent": 20
     * }
     * ```
     * * Example:
     * ```
     * {
     *   "/bindings/&#42;&#47;role": "roles/owner"
     *   "/bindings/&#42;&#47;condition" : null
     * }
     * ```
     * * Example:
     * ```
     * {
     *   "/bindings/&#42;&#47;role": "roles/owner"
     *   "/bindings/&#42;&#47;members/&#42;" : ["x&#64;example.com", "y&#64;example.com"]
     * }
     * ```
     * When both path_filters and path_value_matchers are set, an implicit AND
     * must be performed.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; path_filters = 8;</code>
     */
    @java.lang.Override
    public boolean containsPathFilters(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetPathFilters().getMap().containsKey(key);
    }
    /** Use {@link #getPathFiltersMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getPathFilters() {
      return getPathFiltersMap();
    }
    /**
     *
     *
     * <pre>
     * Set of filters to apply if `path` refers to array elements or nested array
     * elements in order to narrow down to a single unique element that is being
     * tested/modified.
     * This is intended to be an exact match per filter. To perform advanced
     * matching, use path_value_matchers.
     *
     * * Example:
     * ```
     * {
     *   "/versions/&#42;&#47;name" : "it-123"
     *   "/versions/&#42;&#47;targetSize/percent": 20
     * }
     * ```
     * * Example:
     * ```
     * {
     *   "/bindings/&#42;&#47;role": "roles/owner"
     *   "/bindings/&#42;&#47;condition" : null
     * }
     * ```
     * * Example:
     * ```
     * {
     *   "/bindings/&#42;&#47;role": "roles/owner"
     *   "/bindings/&#42;&#47;members/&#42;" : ["x&#64;example.com", "y&#64;example.com"]
     * }
     * ```
     * When both path_filters and path_value_matchers are set, an implicit AND
     * must be performed.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; path_filters = 8;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getPathFiltersMap() {
      return internalGetPathFilters().getMap();
    }
    /**
     *
     *
     * <pre>
     * Set of filters to apply if `path` refers to array elements or nested array
     * elements in order to narrow down to a single unique element that is being
     * tested/modified.
     * This is intended to be an exact match per filter. To perform advanced
     * matching, use path_value_matchers.
     *
     * * Example:
     * ```
     * {
     *   "/versions/&#42;&#47;name" : "it-123"
     *   "/versions/&#42;&#47;targetSize/percent": 20
     * }
     * ```
     * * Example:
     * ```
     * {
     *   "/bindings/&#42;&#47;role": "roles/owner"
     *   "/bindings/&#42;&#47;condition" : null
     * }
     * ```
     * * Example:
     * ```
     * {
     *   "/bindings/&#42;&#47;role": "roles/owner"
     *   "/bindings/&#42;&#47;members/&#42;" : ["x&#64;example.com", "y&#64;example.com"]
     * }
     * ```
     * When both path_filters and path_value_matchers are set, an implicit AND
     * must be performed.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; path_filters = 8;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.protobuf.Value getPathFiltersOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.protobuf.Value defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.Value> map =
          internalGetPathFilters().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Set of filters to apply if `path` refers to array elements or nested array
     * elements in order to narrow down to a single unique element that is being
     * tested/modified.
     * This is intended to be an exact match per filter. To perform advanced
     * matching, use path_value_matchers.
     *
     * * Example:
     * ```
     * {
     *   "/versions/&#42;&#47;name" : "it-123"
     *   "/versions/&#42;&#47;targetSize/percent": 20
     * }
     * ```
     * * Example:
     * ```
     * {
     *   "/bindings/&#42;&#47;role": "roles/owner"
     *   "/bindings/&#42;&#47;condition" : null
     * }
     * ```
     * * Example:
     * ```
     * {
     *   "/bindings/&#42;&#47;role": "roles/owner"
     *   "/bindings/&#42;&#47;members/&#42;" : ["x&#64;example.com", "y&#64;example.com"]
     * }
     * ```
     * When both path_filters and path_value_matchers are set, an implicit AND
     * must be performed.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; path_filters = 8;</code>
     */
    @java.lang.Override
    public com.google.protobuf.Value getPathFiltersOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.Value> map =
          internalGetPathFilters().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearPathFilters() {
      bitField0_ = (bitField0_ & ~0x00000100);
      internalGetMutablePathFilters().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of filters to apply if `path` refers to array elements or nested array
     * elements in order to narrow down to a single unique element that is being
     * tested/modified.
     * This is intended to be an exact match per filter. To perform advanced
     * matching, use path_value_matchers.
     *
     * * Example:
     * ```
     * {
     *   "/versions/&#42;&#47;name" : "it-123"
     *   "/versions/&#42;&#47;targetSize/percent": 20
     * }
     * ```
     * * Example:
     * ```
     * {
     *   "/bindings/&#42;&#47;role": "roles/owner"
     *   "/bindings/&#42;&#47;condition" : null
     * }
     * ```
     * * Example:
     * ```
     * {
     *   "/bindings/&#42;&#47;role": "roles/owner"
     *   "/bindings/&#42;&#47;members/&#42;" : ["x&#64;example.com", "y&#64;example.com"]
     * }
     * ```
     * When both path_filters and path_value_matchers are set, an implicit AND
     * must be performed.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; path_filters = 8;</code>
     */
    public Builder removePathFilters(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutablePathFilters().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getMutablePathFilters() {
      bitField0_ |= 0x00000100;
      return internalGetMutablePathFilters().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Set of filters to apply if `path` refers to array elements or nested array
     * elements in order to narrow down to a single unique element that is being
     * tested/modified.
     * This is intended to be an exact match per filter. To perform advanced
     * matching, use path_value_matchers.
     *
     * * Example:
     * ```
     * {
     *   "/versions/&#42;&#47;name" : "it-123"
     *   "/versions/&#42;&#47;targetSize/percent": 20
     * }
     * ```
     * * Example:
     * ```
     * {
     *   "/bindings/&#42;&#47;role": "roles/owner"
     *   "/bindings/&#42;&#47;condition" : null
     * }
     * ```
     * * Example:
     * ```
     * {
     *   "/bindings/&#42;&#47;role": "roles/owner"
     *   "/bindings/&#42;&#47;members/&#42;" : ["x&#64;example.com", "y&#64;example.com"]
     * }
     * ```
     * When both path_filters and path_value_matchers are set, an implicit AND
     * must be performed.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; path_filters = 8;</code>
     */
    public Builder putPathFilters(java.lang.String key, com.google.protobuf.Value value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutablePathFilters().getMutableMap().put(key, value);
      bitField0_ |= 0x00000100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of filters to apply if `path` refers to array elements or nested array
     * elements in order to narrow down to a single unique element that is being
     * tested/modified.
     * This is intended to be an exact match per filter. To perform advanced
     * matching, use path_value_matchers.
     *
     * * Example:
     * ```
     * {
     *   "/versions/&#42;&#47;name" : "it-123"
     *   "/versions/&#42;&#47;targetSize/percent": 20
     * }
     * ```
     * * Example:
     * ```
     * {
     *   "/bindings/&#42;&#47;role": "roles/owner"
     *   "/bindings/&#42;&#47;condition" : null
     * }
     * ```
     * * Example:
     * ```
     * {
     *   "/bindings/&#42;&#47;role": "roles/owner"
     *   "/bindings/&#42;&#47;members/&#42;" : ["x&#64;example.com", "y&#64;example.com"]
     * }
     * ```
     * When both path_filters and path_value_matchers are set, an implicit AND
     * must be performed.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; path_filters = 8;</code>
     */
    public Builder putAllPathFilters(
        java.util.Map<java.lang.String, com.google.protobuf.Value> values) {
      internalGetMutablePathFilters().getMutableMap().putAll(values);
      bitField0_ |= 0x00000100;
      return this;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.recommender.v1.ValueMatcher>
        pathValueMatchers_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.recommender.v1.ValueMatcher>
        internalGetPathValueMatchers() {
      if (pathValueMatchers_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            PathValueMatchersDefaultEntryHolder.defaultEntry);
      }
      return pathValueMatchers_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.recommender.v1.ValueMatcher>
        internalGetMutablePathValueMatchers() {
      if (pathValueMatchers_ == null) {
        pathValueMatchers_ =
            com.google.protobuf.MapField.newMapField(
                PathValueMatchersDefaultEntryHolder.defaultEntry);
      }
      if (!pathValueMatchers_.isMutable()) {
        pathValueMatchers_ = pathValueMatchers_.copy();
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return pathValueMatchers_;
    }

    public int getPathValueMatchersCount() {
      return internalGetPathValueMatchers().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Similar to path_filters, this contains set of filters to apply if `path`
     * field refers to array elements. This is meant to support value matching
     * beyond exact match. To perform exact match, use path_filters.
     * When both path_filters and path_value_matchers are set, an implicit AND
     * must be performed.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.recommender.v1.ValueMatcher&gt; path_value_matchers = 11;
     * </code>
     */
    @java.lang.Override
    public boolean containsPathValueMatchers(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetPathValueMatchers().getMap().containsKey(key);
    }
    /** Use {@link #getPathValueMatchersMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.recommender.v1.ValueMatcher>
        getPathValueMatchers() {
      return getPathValueMatchersMap();
    }
    /**
     *
     *
     * <pre>
     * Similar to path_filters, this contains set of filters to apply if `path`
     * field refers to array elements. This is meant to support value matching
     * beyond exact match. To perform exact match, use path_filters.
     * When both path_filters and path_value_matchers are set, an implicit AND
     * must be performed.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.recommender.v1.ValueMatcher&gt; path_value_matchers = 11;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.recommender.v1.ValueMatcher>
        getPathValueMatchersMap() {
      return internalGetPathValueMatchers().getMap();
    }
    /**
     *
     *
     * <pre>
     * Similar to path_filters, this contains set of filters to apply if `path`
     * field refers to array elements. This is meant to support value matching
     * beyond exact match. To perform exact match, use path_filters.
     * When both path_filters and path_value_matchers are set, an implicit AND
     * must be performed.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.recommender.v1.ValueMatcher&gt; path_value_matchers = 11;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.recommender.v1.ValueMatcher
        getPathValueMatchersOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.recommender.v1.ValueMatcher defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.recommender.v1.ValueMatcher> map =
          internalGetPathValueMatchers().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Similar to path_filters, this contains set of filters to apply if `path`
     * field refers to array elements. This is meant to support value matching
     * beyond exact match. To perform exact match, use path_filters.
     * When both path_filters and path_value_matchers are set, an implicit AND
     * must be performed.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.recommender.v1.ValueMatcher&gt; path_value_matchers = 11;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.recommender.v1.ValueMatcher getPathValueMatchersOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.recommender.v1.ValueMatcher> map =
          internalGetPathValueMatchers().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearPathValueMatchers() {
      bitField0_ = (bitField0_ & ~0x00000200);
      internalGetMutablePathValueMatchers().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Similar to path_filters, this contains set of filters to apply if `path`
     * field refers to array elements. This is meant to support value matching
     * beyond exact match. To perform exact match, use path_filters.
     * When both path_filters and path_value_matchers are set, an implicit AND
     * must be performed.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.recommender.v1.ValueMatcher&gt; path_value_matchers = 11;
     * </code>
     */
    public Builder removePathValueMatchers(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutablePathValueMatchers().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.recommender.v1.ValueMatcher>
        getMutablePathValueMatchers() {
      bitField0_ |= 0x00000200;
      return internalGetMutablePathValueMatchers().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Similar to path_filters, this contains set of filters to apply if `path`
     * field refers to array elements. This is meant to support value matching
     * beyond exact match. To perform exact match, use path_filters.
     * When both path_filters and path_value_matchers are set, an implicit AND
     * must be performed.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.recommender.v1.ValueMatcher&gt; path_value_matchers = 11;
     * </code>
     */
    public Builder putPathValueMatchers(
        java.lang.String key, com.google.cloud.recommender.v1.ValueMatcher value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutablePathValueMatchers().getMutableMap().put(key, value);
      bitField0_ |= 0x00000200;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Similar to path_filters, this contains set of filters to apply if `path`
     * field refers to array elements. This is meant to support value matching
     * beyond exact match. To perform exact match, use path_filters.
     * When both path_filters and path_value_matchers are set, an implicit AND
     * must be performed.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.recommender.v1.ValueMatcher&gt; path_value_matchers = 11;
     * </code>
     */
    public Builder putAllPathValueMatchers(
        java.util.Map<java.lang.String, com.google.cloud.recommender.v1.ValueMatcher> values) {
      internalGetMutablePathValueMatchers().getMutableMap().putAll(values);
      bitField0_ |= 0x00000200;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.recommender.v1.Operation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.recommender.v1.Operation)
  private static final com.google.cloud.recommender.v1.Operation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.recommender.v1.Operation();
  }

  public static com.google.cloud.recommender.v1.Operation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Operation> PARSER =
      new com.google.protobuf.AbstractParser<Operation>() {
        @java.lang.Override
        public Operation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Operation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Operation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.recommender.v1.Operation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
