/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/recommender/v1/recommendation.proto

package com.google.cloud.recommender.v1;

/**
 *
 *
 * <pre>
 * A recommendation along with a suggested action. E.g., a rightsizing
 * recommendation for an underutilized VM, IAM role recommendations, etc
 * </pre>
 *
 * Protobuf type {@code google.cloud.recommender.v1.Recommendation}
 */
public final class Recommendation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.recommender.v1.Recommendation)
    RecommendationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Recommendation.newBuilder() to construct.
  private Recommendation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Recommendation() {
    name_ = "";
    description_ = "";
    recommenderSubtype_ = "";
    additionalImpact_ = java.util.Collections.emptyList();
    priority_ = 0;
    etag_ = "";
    associatedInsights_ = java.util.Collections.emptyList();
    xorGroupId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Recommendation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.recommender.v1.RecommendationOuterClass
        .internal_static_google_cloud_recommender_v1_Recommendation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.recommender.v1.RecommendationOuterClass
        .internal_static_google_cloud_recommender_v1_Recommendation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.recommender.v1.Recommendation.class,
            com.google.cloud.recommender.v1.Recommendation.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Recommendation priority levels.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.recommender.v1.Recommendation.Priority}
   */
  public enum Priority implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Recommendation has unspecified priority.
     * </pre>
     *
     * <code>PRIORITY_UNSPECIFIED = 0;</code>
     */
    PRIORITY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Recommendation has P4 priority (lowest priority).
     * </pre>
     *
     * <code>P4 = 1;</code>
     */
    P4(1),
    /**
     *
     *
     * <pre>
     * Recommendation has P3 priority (second lowest priority).
     * </pre>
     *
     * <code>P3 = 2;</code>
     */
    P3(2),
    /**
     *
     *
     * <pre>
     * Recommendation has P2 priority (second highest priority).
     * </pre>
     *
     * <code>P2 = 3;</code>
     */
    P2(3),
    /**
     *
     *
     * <pre>
     * Recommendation has P1 priority (highest priority).
     * </pre>
     *
     * <code>P1 = 4;</code>
     */
    P1(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Recommendation has unspecified priority.
     * </pre>
     *
     * <code>PRIORITY_UNSPECIFIED = 0;</code>
     */
    public static final int PRIORITY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Recommendation has P4 priority (lowest priority).
     * </pre>
     *
     * <code>P4 = 1;</code>
     */
    public static final int P4_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Recommendation has P3 priority (second lowest priority).
     * </pre>
     *
     * <code>P3 = 2;</code>
     */
    public static final int P3_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Recommendation has P2 priority (second highest priority).
     * </pre>
     *
     * <code>P2 = 3;</code>
     */
    public static final int P2_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Recommendation has P1 priority (highest priority).
     * </pre>
     *
     * <code>P1 = 4;</code>
     */
    public static final int P1_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Priority valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Priority forNumber(int value) {
      switch (value) {
        case 0:
          return PRIORITY_UNSPECIFIED;
        case 1:
          return P4;
        case 2:
          return P3;
        case 3:
          return P2;
        case 4:
          return P1;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Priority> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Priority> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Priority>() {
          public Priority findValueByNumber(int number) {
            return Priority.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.recommender.v1.Recommendation.getDescriptor().getEnumTypes().get(0);
    }

    private static final Priority[] VALUES = values();

    public static Priority valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Priority(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.recommender.v1.Recommendation.Priority)
  }

  public interface InsightReferenceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.recommender.v1.Recommendation.InsightReference)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Insight resource name, e.g.
     * projects/[PROJECT_NUMBER]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]/insights/[INSIGHT_ID]
     * </pre>
     *
     * <code>string insight = 1;</code>
     *
     * @return The insight.
     */
    java.lang.String getInsight();
    /**
     *
     *
     * <pre>
     * Insight resource name, e.g.
     * projects/[PROJECT_NUMBER]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]/insights/[INSIGHT_ID]
     * </pre>
     *
     * <code>string insight = 1;</code>
     *
     * @return The bytes for insight.
     */
    com.google.protobuf.ByteString getInsightBytes();
  }
  /**
   *
   *
   * <pre>
   * Reference to an associated insight.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recommender.v1.Recommendation.InsightReference}
   */
  public static final class InsightReference extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.recommender.v1.Recommendation.InsightReference)
      InsightReferenceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use InsightReference.newBuilder() to construct.
    private InsightReference(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private InsightReference() {
      insight_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new InsightReference();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.recommender.v1.RecommendationOuterClass
          .internal_static_google_cloud_recommender_v1_Recommendation_InsightReference_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.recommender.v1.RecommendationOuterClass
          .internal_static_google_cloud_recommender_v1_Recommendation_InsightReference_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.recommender.v1.Recommendation.InsightReference.class,
              com.google.cloud.recommender.v1.Recommendation.InsightReference.Builder.class);
    }

    public static final int INSIGHT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object insight_ = "";
    /**
     *
     *
     * <pre>
     * Insight resource name, e.g.
     * projects/[PROJECT_NUMBER]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]/insights/[INSIGHT_ID]
     * </pre>
     *
     * <code>string insight = 1;</code>
     *
     * @return The insight.
     */
    @java.lang.Override
    public java.lang.String getInsight() {
      java.lang.Object ref = insight_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        insight_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Insight resource name, e.g.
     * projects/[PROJECT_NUMBER]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]/insights/[INSIGHT_ID]
     * </pre>
     *
     * <code>string insight = 1;</code>
     *
     * @return The bytes for insight.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getInsightBytes() {
      java.lang.Object ref = insight_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        insight_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(insight_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, insight_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(insight_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, insight_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.recommender.v1.Recommendation.InsightReference)) {
        return super.equals(obj);
      }
      com.google.cloud.recommender.v1.Recommendation.InsightReference other =
          (com.google.cloud.recommender.v1.Recommendation.InsightReference) obj;

      if (!getInsight().equals(other.getInsight())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + INSIGHT_FIELD_NUMBER;
      hash = (53 * hash) + getInsight().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.recommender.v1.Recommendation.InsightReference parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.recommender.v1.Recommendation.InsightReference parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.recommender.v1.Recommendation.InsightReference parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.recommender.v1.Recommendation.InsightReference parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.recommender.v1.Recommendation.InsightReference parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.recommender.v1.Recommendation.InsightReference parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.recommender.v1.Recommendation.InsightReference parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.recommender.v1.Recommendation.InsightReference parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.recommender.v1.Recommendation.InsightReference
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.recommender.v1.Recommendation.InsightReference
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.recommender.v1.Recommendation.InsightReference parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.recommender.v1.Recommendation.InsightReference parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.recommender.v1.Recommendation.InsightReference prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Reference to an associated insight.
     * </pre>
     *
     * Protobuf type {@code google.cloud.recommender.v1.Recommendation.InsightReference}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.recommender.v1.Recommendation.InsightReference)
        com.google.cloud.recommender.v1.Recommendation.InsightReferenceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.recommender.v1.RecommendationOuterClass
            .internal_static_google_cloud_recommender_v1_Recommendation_InsightReference_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.recommender.v1.RecommendationOuterClass
            .internal_static_google_cloud_recommender_v1_Recommendation_InsightReference_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.recommender.v1.Recommendation.InsightReference.class,
                com.google.cloud.recommender.v1.Recommendation.InsightReference.Builder.class);
      }

      // Construct using
      // com.google.cloud.recommender.v1.Recommendation.InsightReference.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        insight_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.recommender.v1.RecommendationOuterClass
            .internal_static_google_cloud_recommender_v1_Recommendation_InsightReference_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.recommender.v1.Recommendation.InsightReference
          getDefaultInstanceForType() {
        return com.google.cloud.recommender.v1.Recommendation.InsightReference.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.recommender.v1.Recommendation.InsightReference build() {
        com.google.cloud.recommender.v1.Recommendation.InsightReference result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.recommender.v1.Recommendation.InsightReference buildPartial() {
        com.google.cloud.recommender.v1.Recommendation.InsightReference result =
            new com.google.cloud.recommender.v1.Recommendation.InsightReference(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.recommender.v1.Recommendation.InsightReference result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.insight_ = insight_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.recommender.v1.Recommendation.InsightReference) {
          return mergeFrom((com.google.cloud.recommender.v1.Recommendation.InsightReference) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.recommender.v1.Recommendation.InsightReference other) {
        if (other
            == com.google.cloud.recommender.v1.Recommendation.InsightReference.getDefaultInstance())
          return this;
        if (!other.getInsight().isEmpty()) {
          insight_ = other.insight_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  insight_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object insight_ = "";
      /**
       *
       *
       * <pre>
       * Insight resource name, e.g.
       * projects/[PROJECT_NUMBER]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]/insights/[INSIGHT_ID]
       * </pre>
       *
       * <code>string insight = 1;</code>
       *
       * @return The insight.
       */
      public java.lang.String getInsight() {
        java.lang.Object ref = insight_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          insight_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Insight resource name, e.g.
       * projects/[PROJECT_NUMBER]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]/insights/[INSIGHT_ID]
       * </pre>
       *
       * <code>string insight = 1;</code>
       *
       * @return The bytes for insight.
       */
      public com.google.protobuf.ByteString getInsightBytes() {
        java.lang.Object ref = insight_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          insight_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Insight resource name, e.g.
       * projects/[PROJECT_NUMBER]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]/insights/[INSIGHT_ID]
       * </pre>
       *
       * <code>string insight = 1;</code>
       *
       * @param value The insight to set.
       * @return This builder for chaining.
       */
      public Builder setInsight(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        insight_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Insight resource name, e.g.
       * projects/[PROJECT_NUMBER]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]/insights/[INSIGHT_ID]
       * </pre>
       *
       * <code>string insight = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearInsight() {
        insight_ = getDefaultInstance().getInsight();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Insight resource name, e.g.
       * projects/[PROJECT_NUMBER]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]/insights/[INSIGHT_ID]
       * </pre>
       *
       * <code>string insight = 1;</code>
       *
       * @param value The bytes for insight to set.
       * @return This builder for chaining.
       */
      public Builder setInsightBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        insight_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.recommender.v1.Recommendation.InsightReference)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.recommender.v1.Recommendation.InsightReference)
    private static final com.google.cloud.recommender.v1.Recommendation.InsightReference
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.recommender.v1.Recommendation.InsightReference();
    }

    public static com.google.cloud.recommender.v1.Recommendation.InsightReference
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<InsightReference> PARSER =
        new com.google.protobuf.AbstractParser<InsightReference>() {
          @java.lang.Override
          public InsightReference parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<InsightReference> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<InsightReference> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.recommender.v1.Recommendation.InsightReference
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Name of recommendation.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of recommendation.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Free-form human readable summary in English. The maximum length is 500
   * characters.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Free-form human readable summary in English. The maximum length is 500
   * characters.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RECOMMENDER_SUBTYPE_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object recommenderSubtype_ = "";
  /**
   *
   *
   * <pre>
   * Contains an identifier for a subtype of recommendations produced for the
   * same recommender. Subtype is a function of content and impact, meaning a
   * new subtype might be added when significant changes to `content` or
   * `primary_impact.category` are introduced. See the Recommenders section
   * to see a list of subtypes for a given Recommender.
   *
   * Examples:
   *   For recommender = "google.iam.policy.Recommender",
   *   recommender_subtype can be one of "REMOVE_ROLE"/"REPLACE_ROLE"
   * </pre>
   *
   * <code>string recommender_subtype = 12;</code>
   *
   * @return The recommenderSubtype.
   */
  @java.lang.Override
  public java.lang.String getRecommenderSubtype() {
    java.lang.Object ref = recommenderSubtype_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      recommenderSubtype_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Contains an identifier for a subtype of recommendations produced for the
   * same recommender. Subtype is a function of content and impact, meaning a
   * new subtype might be added when significant changes to `content` or
   * `primary_impact.category` are introduced. See the Recommenders section
   * to see a list of subtypes for a given Recommender.
   *
   * Examples:
   *   For recommender = "google.iam.policy.Recommender",
   *   recommender_subtype can be one of "REMOVE_ROLE"/"REPLACE_ROLE"
   * </pre>
   *
   * <code>string recommender_subtype = 12;</code>
   *
   * @return The bytes for recommenderSubtype.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRecommenderSubtypeBytes() {
    java.lang.Object ref = recommenderSubtype_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      recommenderSubtype_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LAST_REFRESH_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp lastRefreshTime_;
  /**
   *
   *
   * <pre>
   * Last time this recommendation was refreshed by the system that created it
   * in the first place.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_refresh_time = 4;</code>
   *
   * @return Whether the lastRefreshTime field is set.
   */
  @java.lang.Override
  public boolean hasLastRefreshTime() {
    return lastRefreshTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Last time this recommendation was refreshed by the system that created it
   * in the first place.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_refresh_time = 4;</code>
   *
   * @return The lastRefreshTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastRefreshTime() {
    return lastRefreshTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastRefreshTime_;
  }
  /**
   *
   *
   * <pre>
   * Last time this recommendation was refreshed by the system that created it
   * in the first place.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_refresh_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastRefreshTimeOrBuilder() {
    return lastRefreshTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastRefreshTime_;
  }

  public static final int PRIMARY_IMPACT_FIELD_NUMBER = 5;
  private com.google.cloud.recommender.v1.Impact primaryImpact_;
  /**
   *
   *
   * <pre>
   * The primary impact that this recommendation can have while trying to
   * optimize for one category.
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.Impact primary_impact = 5;</code>
   *
   * @return Whether the primaryImpact field is set.
   */
  @java.lang.Override
  public boolean hasPrimaryImpact() {
    return primaryImpact_ != null;
  }
  /**
   *
   *
   * <pre>
   * The primary impact that this recommendation can have while trying to
   * optimize for one category.
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.Impact primary_impact = 5;</code>
   *
   * @return The primaryImpact.
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.Impact getPrimaryImpact() {
    return primaryImpact_ == null
        ? com.google.cloud.recommender.v1.Impact.getDefaultInstance()
        : primaryImpact_;
  }
  /**
   *
   *
   * <pre>
   * The primary impact that this recommendation can have while trying to
   * optimize for one category.
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.Impact primary_impact = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.ImpactOrBuilder getPrimaryImpactOrBuilder() {
    return primaryImpact_ == null
        ? com.google.cloud.recommender.v1.Impact.getDefaultInstance()
        : primaryImpact_;
  }

  public static final int ADDITIONAL_IMPACT_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.recommender.v1.Impact> additionalImpact_;
  /**
   *
   *
   * <pre>
   * Optional set of additional impact that this recommendation may have when
   * trying to optimize for the primary category. These may be positive
   * or negative.
   * </pre>
   *
   * <code>repeated .google.cloud.recommender.v1.Impact additional_impact = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.recommender.v1.Impact> getAdditionalImpactList() {
    return additionalImpact_;
  }
  /**
   *
   *
   * <pre>
   * Optional set of additional impact that this recommendation may have when
   * trying to optimize for the primary category. These may be positive
   * or negative.
   * </pre>
   *
   * <code>repeated .google.cloud.recommender.v1.Impact additional_impact = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.recommender.v1.ImpactOrBuilder>
      getAdditionalImpactOrBuilderList() {
    return additionalImpact_;
  }
  /**
   *
   *
   * <pre>
   * Optional set of additional impact that this recommendation may have when
   * trying to optimize for the primary category. These may be positive
   * or negative.
   * </pre>
   *
   * <code>repeated .google.cloud.recommender.v1.Impact additional_impact = 6;</code>
   */
  @java.lang.Override
  public int getAdditionalImpactCount() {
    return additionalImpact_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional set of additional impact that this recommendation may have when
   * trying to optimize for the primary category. These may be positive
   * or negative.
   * </pre>
   *
   * <code>repeated .google.cloud.recommender.v1.Impact additional_impact = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.Impact getAdditionalImpact(int index) {
    return additionalImpact_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional set of additional impact that this recommendation may have when
   * trying to optimize for the primary category. These may be positive
   * or negative.
   * </pre>
   *
   * <code>repeated .google.cloud.recommender.v1.Impact additional_impact = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.ImpactOrBuilder getAdditionalImpactOrBuilder(int index) {
    return additionalImpact_.get(index);
  }

  public static final int PRIORITY_FIELD_NUMBER = 17;
  private int priority_ = 0;
  /**
   *
   *
   * <pre>
   * Recommendation's priority.
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.Recommendation.Priority priority = 17;</code>
   *
   * @return The enum numeric value on the wire for priority.
   */
  @java.lang.Override
  public int getPriorityValue() {
    return priority_;
  }
  /**
   *
   *
   * <pre>
   * Recommendation's priority.
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.Recommendation.Priority priority = 17;</code>
   *
   * @return The priority.
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.Recommendation.Priority getPriority() {
    com.google.cloud.recommender.v1.Recommendation.Priority result =
        com.google.cloud.recommender.v1.Recommendation.Priority.forNumber(priority_);
    return result == null
        ? com.google.cloud.recommender.v1.Recommendation.Priority.UNRECOGNIZED
        : result;
  }

  public static final int CONTENT_FIELD_NUMBER = 7;
  private com.google.cloud.recommender.v1.RecommendationContent content_;
  /**
   *
   *
   * <pre>
   * Content of the recommendation describing recommended changes to resources.
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.RecommendationContent content = 7;</code>
   *
   * @return Whether the content field is set.
   */
  @java.lang.Override
  public boolean hasContent() {
    return content_ != null;
  }
  /**
   *
   *
   * <pre>
   * Content of the recommendation describing recommended changes to resources.
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.RecommendationContent content = 7;</code>
   *
   * @return The content.
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.RecommendationContent getContent() {
    return content_ == null
        ? com.google.cloud.recommender.v1.RecommendationContent.getDefaultInstance()
        : content_;
  }
  /**
   *
   *
   * <pre>
   * Content of the recommendation describing recommended changes to resources.
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.RecommendationContent content = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.RecommendationContentOrBuilder getContentOrBuilder() {
    return content_ == null
        ? com.google.cloud.recommender.v1.RecommendationContent.getDefaultInstance()
        : content_;
  }

  public static final int STATE_INFO_FIELD_NUMBER = 10;
  private com.google.cloud.recommender.v1.RecommendationStateInfo stateInfo_;
  /**
   *
   *
   * <pre>
   * Information for state. Contains state and metadata.
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.RecommendationStateInfo state_info = 10;</code>
   *
   * @return Whether the stateInfo field is set.
   */
  @java.lang.Override
  public boolean hasStateInfo() {
    return stateInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Information for state. Contains state and metadata.
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.RecommendationStateInfo state_info = 10;</code>
   *
   * @return The stateInfo.
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.RecommendationStateInfo getStateInfo() {
    return stateInfo_ == null
        ? com.google.cloud.recommender.v1.RecommendationStateInfo.getDefaultInstance()
        : stateInfo_;
  }
  /**
   *
   *
   * <pre>
   * Information for state. Contains state and metadata.
   * </pre>
   *
   * <code>.google.cloud.recommender.v1.RecommendationStateInfo state_info = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.RecommendationStateInfoOrBuilder getStateInfoOrBuilder() {
    return stateInfo_ == null
        ? com.google.cloud.recommender.v1.RecommendationStateInfo.getDefaultInstance()
        : stateInfo_;
  }

  public static final int ETAG_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Fingerprint of the Recommendation. Provides optimistic locking when
   * updating states.
   * </pre>
   *
   * <code>string etag = 11;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Fingerprint of the Recommendation. Provides optimistic locking when
   * updating states.
   * </pre>
   *
   * <code>string etag = 11;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ASSOCIATED_INSIGHTS_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.recommender.v1.Recommendation.InsightReference>
      associatedInsights_;
  /**
   *
   *
   * <pre>
   * Insights that led to this recommendation.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recommender.v1.Recommendation.InsightReference associated_insights = 14;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.recommender.v1.Recommendation.InsightReference>
      getAssociatedInsightsList() {
    return associatedInsights_;
  }
  /**
   *
   *
   * <pre>
   * Insights that led to this recommendation.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recommender.v1.Recommendation.InsightReference associated_insights = 14;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.recommender.v1.Recommendation.InsightReferenceOrBuilder>
      getAssociatedInsightsOrBuilderList() {
    return associatedInsights_;
  }
  /**
   *
   *
   * <pre>
   * Insights that led to this recommendation.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recommender.v1.Recommendation.InsightReference associated_insights = 14;
   * </code>
   */
  @java.lang.Override
  public int getAssociatedInsightsCount() {
    return associatedInsights_.size();
  }
  /**
   *
   *
   * <pre>
   * Insights that led to this recommendation.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recommender.v1.Recommendation.InsightReference associated_insights = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.Recommendation.InsightReference getAssociatedInsights(
      int index) {
    return associatedInsights_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Insights that led to this recommendation.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recommender.v1.Recommendation.InsightReference associated_insights = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.Recommendation.InsightReferenceOrBuilder
      getAssociatedInsightsOrBuilder(int index) {
    return associatedInsights_.get(index);
  }

  public static final int XOR_GROUP_ID_FIELD_NUMBER = 18;

  @SuppressWarnings("serial")
  private volatile java.lang.Object xorGroupId_ = "";
  /**
   *
   *
   * <pre>
   * Corresponds to a mutually exclusive group ID within a recommender.
   * A non-empty ID indicates that the recommendation belongs to a mutually
   * exclusive group. This means that only one recommendation within the group
   * is suggested to be applied.
   * </pre>
   *
   * <code>string xor_group_id = 18;</code>
   *
   * @return The xorGroupId.
   */
  @java.lang.Override
  public java.lang.String getXorGroupId() {
    java.lang.Object ref = xorGroupId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      xorGroupId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Corresponds to a mutually exclusive group ID within a recommender.
   * A non-empty ID indicates that the recommendation belongs to a mutually
   * exclusive group. This means that only one recommendation within the group
   * is suggested to be applied.
   * </pre>
   *
   * <code>string xor_group_id = 18;</code>
   *
   * @return The bytes for xorGroupId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getXorGroupIdBytes() {
    java.lang.Object ref = xorGroupId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      xorGroupId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (lastRefreshTime_ != null) {
      output.writeMessage(4, getLastRefreshTime());
    }
    if (primaryImpact_ != null) {
      output.writeMessage(5, getPrimaryImpact());
    }
    for (int i = 0; i < additionalImpact_.size(); i++) {
      output.writeMessage(6, additionalImpact_.get(i));
    }
    if (content_ != null) {
      output.writeMessage(7, getContent());
    }
    if (stateInfo_ != null) {
      output.writeMessage(10, getStateInfo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, etag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(recommenderSubtype_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, recommenderSubtype_);
    }
    for (int i = 0; i < associatedInsights_.size(); i++) {
      output.writeMessage(14, associatedInsights_.get(i));
    }
    if (priority_
        != com.google.cloud.recommender.v1.Recommendation.Priority.PRIORITY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(17, priority_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(xorGroupId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, xorGroupId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (lastRefreshTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getLastRefreshTime());
    }
    if (primaryImpact_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getPrimaryImpact());
    }
    for (int i = 0; i < additionalImpact_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, additionalImpact_.get(i));
    }
    if (content_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getContent());
    }
    if (stateInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getStateInfo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, etag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(recommenderSubtype_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, recommenderSubtype_);
    }
    for (int i = 0; i < associatedInsights_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(14, associatedInsights_.get(i));
    }
    if (priority_
        != com.google.cloud.recommender.v1.Recommendation.Priority.PRIORITY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(17, priority_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(xorGroupId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, xorGroupId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.recommender.v1.Recommendation)) {
      return super.equals(obj);
    }
    com.google.cloud.recommender.v1.Recommendation other =
        (com.google.cloud.recommender.v1.Recommendation) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getRecommenderSubtype().equals(other.getRecommenderSubtype())) return false;
    if (hasLastRefreshTime() != other.hasLastRefreshTime()) return false;
    if (hasLastRefreshTime()) {
      if (!getLastRefreshTime().equals(other.getLastRefreshTime())) return false;
    }
    if (hasPrimaryImpact() != other.hasPrimaryImpact()) return false;
    if (hasPrimaryImpact()) {
      if (!getPrimaryImpact().equals(other.getPrimaryImpact())) return false;
    }
    if (!getAdditionalImpactList().equals(other.getAdditionalImpactList())) return false;
    if (priority_ != other.priority_) return false;
    if (hasContent() != other.hasContent()) return false;
    if (hasContent()) {
      if (!getContent().equals(other.getContent())) return false;
    }
    if (hasStateInfo() != other.hasStateInfo()) return false;
    if (hasStateInfo()) {
      if (!getStateInfo().equals(other.getStateInfo())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getAssociatedInsightsList().equals(other.getAssociatedInsightsList())) return false;
    if (!getXorGroupId().equals(other.getXorGroupId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + RECOMMENDER_SUBTYPE_FIELD_NUMBER;
    hash = (53 * hash) + getRecommenderSubtype().hashCode();
    if (hasLastRefreshTime()) {
      hash = (37 * hash) + LAST_REFRESH_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastRefreshTime().hashCode();
    }
    if (hasPrimaryImpact()) {
      hash = (37 * hash) + PRIMARY_IMPACT_FIELD_NUMBER;
      hash = (53 * hash) + getPrimaryImpact().hashCode();
    }
    if (getAdditionalImpactCount() > 0) {
      hash = (37 * hash) + ADDITIONAL_IMPACT_FIELD_NUMBER;
      hash = (53 * hash) + getAdditionalImpactList().hashCode();
    }
    hash = (37 * hash) + PRIORITY_FIELD_NUMBER;
    hash = (53 * hash) + priority_;
    if (hasContent()) {
      hash = (37 * hash) + CONTENT_FIELD_NUMBER;
      hash = (53 * hash) + getContent().hashCode();
    }
    if (hasStateInfo()) {
      hash = (37 * hash) + STATE_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getStateInfo().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (getAssociatedInsightsCount() > 0) {
      hash = (37 * hash) + ASSOCIATED_INSIGHTS_FIELD_NUMBER;
      hash = (53 * hash) + getAssociatedInsightsList().hashCode();
    }
    hash = (37 * hash) + XOR_GROUP_ID_FIELD_NUMBER;
    hash = (53 * hash) + getXorGroupId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.recommender.v1.Recommendation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.recommender.v1.Recommendation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.recommender.v1.Recommendation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.recommender.v1.Recommendation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.recommender.v1.Recommendation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.recommender.v1.Recommendation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.recommender.v1.Recommendation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.recommender.v1.Recommendation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.recommender.v1.Recommendation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.recommender.v1.Recommendation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.recommender.v1.Recommendation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.recommender.v1.Recommendation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.recommender.v1.Recommendation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A recommendation along with a suggested action. E.g., a rightsizing
   * recommendation for an underutilized VM, IAM role recommendations, etc
   * </pre>
   *
   * Protobuf type {@code google.cloud.recommender.v1.Recommendation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.recommender.v1.Recommendation)
      com.google.cloud.recommender.v1.RecommendationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.recommender.v1.RecommendationOuterClass
          .internal_static_google_cloud_recommender_v1_Recommendation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.recommender.v1.RecommendationOuterClass
          .internal_static_google_cloud_recommender_v1_Recommendation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.recommender.v1.Recommendation.class,
              com.google.cloud.recommender.v1.Recommendation.Builder.class);
    }

    // Construct using com.google.cloud.recommender.v1.Recommendation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      description_ = "";
      recommenderSubtype_ = "";
      lastRefreshTime_ = null;
      if (lastRefreshTimeBuilder_ != null) {
        lastRefreshTimeBuilder_.dispose();
        lastRefreshTimeBuilder_ = null;
      }
      primaryImpact_ = null;
      if (primaryImpactBuilder_ != null) {
        primaryImpactBuilder_.dispose();
        primaryImpactBuilder_ = null;
      }
      if (additionalImpactBuilder_ == null) {
        additionalImpact_ = java.util.Collections.emptyList();
      } else {
        additionalImpact_ = null;
        additionalImpactBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      priority_ = 0;
      content_ = null;
      if (contentBuilder_ != null) {
        contentBuilder_.dispose();
        contentBuilder_ = null;
      }
      stateInfo_ = null;
      if (stateInfoBuilder_ != null) {
        stateInfoBuilder_.dispose();
        stateInfoBuilder_ = null;
      }
      etag_ = "";
      if (associatedInsightsBuilder_ == null) {
        associatedInsights_ = java.util.Collections.emptyList();
      } else {
        associatedInsights_ = null;
        associatedInsightsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      xorGroupId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.recommender.v1.RecommendationOuterClass
          .internal_static_google_cloud_recommender_v1_Recommendation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.recommender.v1.Recommendation getDefaultInstanceForType() {
      return com.google.cloud.recommender.v1.Recommendation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.recommender.v1.Recommendation build() {
      com.google.cloud.recommender.v1.Recommendation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.recommender.v1.Recommendation buildPartial() {
      com.google.cloud.recommender.v1.Recommendation result =
          new com.google.cloud.recommender.v1.Recommendation(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.recommender.v1.Recommendation result) {
      if (additionalImpactBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          additionalImpact_ = java.util.Collections.unmodifiableList(additionalImpact_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.additionalImpact_ = additionalImpact_;
      } else {
        result.additionalImpact_ = additionalImpactBuilder_.build();
      }
      if (associatedInsightsBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          associatedInsights_ = java.util.Collections.unmodifiableList(associatedInsights_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.associatedInsights_ = associatedInsights_;
      } else {
        result.associatedInsights_ = associatedInsightsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.recommender.v1.Recommendation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.recommenderSubtype_ = recommenderSubtype_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.lastRefreshTime_ =
            lastRefreshTimeBuilder_ == null ? lastRefreshTime_ : lastRefreshTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.primaryImpact_ =
            primaryImpactBuilder_ == null ? primaryImpact_ : primaryImpactBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.priority_ = priority_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.content_ = contentBuilder_ == null ? content_ : contentBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.stateInfo_ = stateInfoBuilder_ == null ? stateInfo_ : stateInfoBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.xorGroupId_ = xorGroupId_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.recommender.v1.Recommendation) {
        return mergeFrom((com.google.cloud.recommender.v1.Recommendation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.recommender.v1.Recommendation other) {
      if (other == com.google.cloud.recommender.v1.Recommendation.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getRecommenderSubtype().isEmpty()) {
        recommenderSubtype_ = other.recommenderSubtype_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasLastRefreshTime()) {
        mergeLastRefreshTime(other.getLastRefreshTime());
      }
      if (other.hasPrimaryImpact()) {
        mergePrimaryImpact(other.getPrimaryImpact());
      }
      if (additionalImpactBuilder_ == null) {
        if (!other.additionalImpact_.isEmpty()) {
          if (additionalImpact_.isEmpty()) {
            additionalImpact_ = other.additionalImpact_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureAdditionalImpactIsMutable();
            additionalImpact_.addAll(other.additionalImpact_);
          }
          onChanged();
        }
      } else {
        if (!other.additionalImpact_.isEmpty()) {
          if (additionalImpactBuilder_.isEmpty()) {
            additionalImpactBuilder_.dispose();
            additionalImpactBuilder_ = null;
            additionalImpact_ = other.additionalImpact_;
            bitField0_ = (bitField0_ & ~0x00000020);
            additionalImpactBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAdditionalImpactFieldBuilder()
                    : null;
          } else {
            additionalImpactBuilder_.addAllMessages(other.additionalImpact_);
          }
        }
      }
      if (other.priority_ != 0) {
        setPriorityValue(other.getPriorityValue());
      }
      if (other.hasContent()) {
        mergeContent(other.getContent());
      }
      if (other.hasStateInfo()) {
        mergeStateInfo(other.getStateInfo());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (associatedInsightsBuilder_ == null) {
        if (!other.associatedInsights_.isEmpty()) {
          if (associatedInsights_.isEmpty()) {
            associatedInsights_ = other.associatedInsights_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureAssociatedInsightsIsMutable();
            associatedInsights_.addAll(other.associatedInsights_);
          }
          onChanged();
        }
      } else {
        if (!other.associatedInsights_.isEmpty()) {
          if (associatedInsightsBuilder_.isEmpty()) {
            associatedInsightsBuilder_.dispose();
            associatedInsightsBuilder_ = null;
            associatedInsights_ = other.associatedInsights_;
            bitField0_ = (bitField0_ & ~0x00000400);
            associatedInsightsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAssociatedInsightsFieldBuilder()
                    : null;
          } else {
            associatedInsightsBuilder_.addAllMessages(other.associatedInsights_);
          }
        }
      }
      if (!other.getXorGroupId().isEmpty()) {
        xorGroupId_ = other.xorGroupId_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 34:
              {
                input.readMessage(getLastRefreshTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getPrimaryImpactFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.recommender.v1.Impact m =
                    input.readMessage(
                        com.google.cloud.recommender.v1.Impact.parser(), extensionRegistry);
                if (additionalImpactBuilder_ == null) {
                  ensureAdditionalImpactIsMutable();
                  additionalImpact_.add(m);
                } else {
                  additionalImpactBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getContentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 82:
              {
                input.readMessage(getStateInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            case 90:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 90
            case 98:
              {
                recommenderSubtype_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 98
            case 114:
              {
                com.google.cloud.recommender.v1.Recommendation.InsightReference m =
                    input.readMessage(
                        com.google.cloud.recommender.v1.Recommendation.InsightReference.parser(),
                        extensionRegistry);
                if (associatedInsightsBuilder_ == null) {
                  ensureAssociatedInsightsIsMutable();
                  associatedInsights_.add(m);
                } else {
                  associatedInsightsBuilder_.addMessage(m);
                }
                break;
              } // case 114
            case 136:
              {
                priority_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 136
            case 146:
              {
                xorGroupId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 146
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of recommendation.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of recommendation.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of recommendation.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of recommendation.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of recommendation.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Free-form human readable summary in English. The maximum length is 500
     * characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Free-form human readable summary in English. The maximum length is 500
     * characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Free-form human readable summary in English. The maximum length is 500
     * characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Free-form human readable summary in English. The maximum length is 500
     * characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Free-form human readable summary in English. The maximum length is 500
     * characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object recommenderSubtype_ = "";
    /**
     *
     *
     * <pre>
     * Contains an identifier for a subtype of recommendations produced for the
     * same recommender. Subtype is a function of content and impact, meaning a
     * new subtype might be added when significant changes to `content` or
     * `primary_impact.category` are introduced. See the Recommenders section
     * to see a list of subtypes for a given Recommender.
     *
     * Examples:
     *   For recommender = "google.iam.policy.Recommender",
     *   recommender_subtype can be one of "REMOVE_ROLE"/"REPLACE_ROLE"
     * </pre>
     *
     * <code>string recommender_subtype = 12;</code>
     *
     * @return The recommenderSubtype.
     */
    public java.lang.String getRecommenderSubtype() {
      java.lang.Object ref = recommenderSubtype_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        recommenderSubtype_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Contains an identifier for a subtype of recommendations produced for the
     * same recommender. Subtype is a function of content and impact, meaning a
     * new subtype might be added when significant changes to `content` or
     * `primary_impact.category` are introduced. See the Recommenders section
     * to see a list of subtypes for a given Recommender.
     *
     * Examples:
     *   For recommender = "google.iam.policy.Recommender",
     *   recommender_subtype can be one of "REMOVE_ROLE"/"REPLACE_ROLE"
     * </pre>
     *
     * <code>string recommender_subtype = 12;</code>
     *
     * @return The bytes for recommenderSubtype.
     */
    public com.google.protobuf.ByteString getRecommenderSubtypeBytes() {
      java.lang.Object ref = recommenderSubtype_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        recommenderSubtype_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Contains an identifier for a subtype of recommendations produced for the
     * same recommender. Subtype is a function of content and impact, meaning a
     * new subtype might be added when significant changes to `content` or
     * `primary_impact.category` are introduced. See the Recommenders section
     * to see a list of subtypes for a given Recommender.
     *
     * Examples:
     *   For recommender = "google.iam.policy.Recommender",
     *   recommender_subtype can be one of "REMOVE_ROLE"/"REPLACE_ROLE"
     * </pre>
     *
     * <code>string recommender_subtype = 12;</code>
     *
     * @param value The recommenderSubtype to set.
     * @return This builder for chaining.
     */
    public Builder setRecommenderSubtype(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      recommenderSubtype_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains an identifier for a subtype of recommendations produced for the
     * same recommender. Subtype is a function of content and impact, meaning a
     * new subtype might be added when significant changes to `content` or
     * `primary_impact.category` are introduced. See the Recommenders section
     * to see a list of subtypes for a given Recommender.
     *
     * Examples:
     *   For recommender = "google.iam.policy.Recommender",
     *   recommender_subtype can be one of "REMOVE_ROLE"/"REPLACE_ROLE"
     * </pre>
     *
     * <code>string recommender_subtype = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRecommenderSubtype() {
      recommenderSubtype_ = getDefaultInstance().getRecommenderSubtype();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains an identifier for a subtype of recommendations produced for the
     * same recommender. Subtype is a function of content and impact, meaning a
     * new subtype might be added when significant changes to `content` or
     * `primary_impact.category` are introduced. See the Recommenders section
     * to see a list of subtypes for a given Recommender.
     *
     * Examples:
     *   For recommender = "google.iam.policy.Recommender",
     *   recommender_subtype can be one of "REMOVE_ROLE"/"REPLACE_ROLE"
     * </pre>
     *
     * <code>string recommender_subtype = 12;</code>
     *
     * @param value The bytes for recommenderSubtype to set.
     * @return This builder for chaining.
     */
    public Builder setRecommenderSubtypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      recommenderSubtype_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp lastRefreshTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastRefreshTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Last time this recommendation was refreshed by the system that created it
     * in the first place.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_refresh_time = 4;</code>
     *
     * @return Whether the lastRefreshTime field is set.
     */
    public boolean hasLastRefreshTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Last time this recommendation was refreshed by the system that created it
     * in the first place.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_refresh_time = 4;</code>
     *
     * @return The lastRefreshTime.
     */
    public com.google.protobuf.Timestamp getLastRefreshTime() {
      if (lastRefreshTimeBuilder_ == null) {
        return lastRefreshTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastRefreshTime_;
      } else {
        return lastRefreshTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Last time this recommendation was refreshed by the system that created it
     * in the first place.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_refresh_time = 4;</code>
     */
    public Builder setLastRefreshTime(com.google.protobuf.Timestamp value) {
      if (lastRefreshTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastRefreshTime_ = value;
      } else {
        lastRefreshTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Last time this recommendation was refreshed by the system that created it
     * in the first place.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_refresh_time = 4;</code>
     */
    public Builder setLastRefreshTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastRefreshTimeBuilder_ == null) {
        lastRefreshTime_ = builderForValue.build();
      } else {
        lastRefreshTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Last time this recommendation was refreshed by the system that created it
     * in the first place.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_refresh_time = 4;</code>
     */
    public Builder mergeLastRefreshTime(com.google.protobuf.Timestamp value) {
      if (lastRefreshTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && lastRefreshTime_ != null
            && lastRefreshTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastRefreshTimeBuilder().mergeFrom(value);
        } else {
          lastRefreshTime_ = value;
        }
      } else {
        lastRefreshTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Last time this recommendation was refreshed by the system that created it
     * in the first place.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_refresh_time = 4;</code>
     */
    public Builder clearLastRefreshTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      lastRefreshTime_ = null;
      if (lastRefreshTimeBuilder_ != null) {
        lastRefreshTimeBuilder_.dispose();
        lastRefreshTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Last time this recommendation was refreshed by the system that created it
     * in the first place.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_refresh_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getLastRefreshTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getLastRefreshTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Last time this recommendation was refreshed by the system that created it
     * in the first place.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_refresh_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastRefreshTimeOrBuilder() {
      if (lastRefreshTimeBuilder_ != null) {
        return lastRefreshTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastRefreshTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastRefreshTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Last time this recommendation was refreshed by the system that created it
     * in the first place.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_refresh_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastRefreshTimeFieldBuilder() {
      if (lastRefreshTimeBuilder_ == null) {
        lastRefreshTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastRefreshTime(), getParentForChildren(), isClean());
        lastRefreshTime_ = null;
      }
      return lastRefreshTimeBuilder_;
    }

    private com.google.cloud.recommender.v1.Impact primaryImpact_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.recommender.v1.Impact,
            com.google.cloud.recommender.v1.Impact.Builder,
            com.google.cloud.recommender.v1.ImpactOrBuilder>
        primaryImpactBuilder_;
    /**
     *
     *
     * <pre>
     * The primary impact that this recommendation can have while trying to
     * optimize for one category.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Impact primary_impact = 5;</code>
     *
     * @return Whether the primaryImpact field is set.
     */
    public boolean hasPrimaryImpact() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The primary impact that this recommendation can have while trying to
     * optimize for one category.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Impact primary_impact = 5;</code>
     *
     * @return The primaryImpact.
     */
    public com.google.cloud.recommender.v1.Impact getPrimaryImpact() {
      if (primaryImpactBuilder_ == null) {
        return primaryImpact_ == null
            ? com.google.cloud.recommender.v1.Impact.getDefaultInstance()
            : primaryImpact_;
      } else {
        return primaryImpactBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The primary impact that this recommendation can have while trying to
     * optimize for one category.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Impact primary_impact = 5;</code>
     */
    public Builder setPrimaryImpact(com.google.cloud.recommender.v1.Impact value) {
      if (primaryImpactBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        primaryImpact_ = value;
      } else {
        primaryImpactBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The primary impact that this recommendation can have while trying to
     * optimize for one category.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Impact primary_impact = 5;</code>
     */
    public Builder setPrimaryImpact(
        com.google.cloud.recommender.v1.Impact.Builder builderForValue) {
      if (primaryImpactBuilder_ == null) {
        primaryImpact_ = builderForValue.build();
      } else {
        primaryImpactBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The primary impact that this recommendation can have while trying to
     * optimize for one category.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Impact primary_impact = 5;</code>
     */
    public Builder mergePrimaryImpact(com.google.cloud.recommender.v1.Impact value) {
      if (primaryImpactBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && primaryImpact_ != null
            && primaryImpact_ != com.google.cloud.recommender.v1.Impact.getDefaultInstance()) {
          getPrimaryImpactBuilder().mergeFrom(value);
        } else {
          primaryImpact_ = value;
        }
      } else {
        primaryImpactBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The primary impact that this recommendation can have while trying to
     * optimize for one category.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Impact primary_impact = 5;</code>
     */
    public Builder clearPrimaryImpact() {
      bitField0_ = (bitField0_ & ~0x00000010);
      primaryImpact_ = null;
      if (primaryImpactBuilder_ != null) {
        primaryImpactBuilder_.dispose();
        primaryImpactBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The primary impact that this recommendation can have while trying to
     * optimize for one category.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Impact primary_impact = 5;</code>
     */
    public com.google.cloud.recommender.v1.Impact.Builder getPrimaryImpactBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getPrimaryImpactFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The primary impact that this recommendation can have while trying to
     * optimize for one category.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Impact primary_impact = 5;</code>
     */
    public com.google.cloud.recommender.v1.ImpactOrBuilder getPrimaryImpactOrBuilder() {
      if (primaryImpactBuilder_ != null) {
        return primaryImpactBuilder_.getMessageOrBuilder();
      } else {
        return primaryImpact_ == null
            ? com.google.cloud.recommender.v1.Impact.getDefaultInstance()
            : primaryImpact_;
      }
    }
    /**
     *
     *
     * <pre>
     * The primary impact that this recommendation can have while trying to
     * optimize for one category.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Impact primary_impact = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.recommender.v1.Impact,
            com.google.cloud.recommender.v1.Impact.Builder,
            com.google.cloud.recommender.v1.ImpactOrBuilder>
        getPrimaryImpactFieldBuilder() {
      if (primaryImpactBuilder_ == null) {
        primaryImpactBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.recommender.v1.Impact,
                com.google.cloud.recommender.v1.Impact.Builder,
                com.google.cloud.recommender.v1.ImpactOrBuilder>(
                getPrimaryImpact(), getParentForChildren(), isClean());
        primaryImpact_ = null;
      }
      return primaryImpactBuilder_;
    }

    private java.util.List<com.google.cloud.recommender.v1.Impact> additionalImpact_ =
        java.util.Collections.emptyList();

    private void ensureAdditionalImpactIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        additionalImpact_ =
            new java.util.ArrayList<com.google.cloud.recommender.v1.Impact>(additionalImpact_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.recommender.v1.Impact,
            com.google.cloud.recommender.v1.Impact.Builder,
            com.google.cloud.recommender.v1.ImpactOrBuilder>
        additionalImpactBuilder_;

    /**
     *
     *
     * <pre>
     * Optional set of additional impact that this recommendation may have when
     * trying to optimize for the primary category. These may be positive
     * or negative.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.Impact additional_impact = 6;</code>
     */
    public java.util.List<com.google.cloud.recommender.v1.Impact> getAdditionalImpactList() {
      if (additionalImpactBuilder_ == null) {
        return java.util.Collections.unmodifiableList(additionalImpact_);
      } else {
        return additionalImpactBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional set of additional impact that this recommendation may have when
     * trying to optimize for the primary category. These may be positive
     * or negative.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.Impact additional_impact = 6;</code>
     */
    public int getAdditionalImpactCount() {
      if (additionalImpactBuilder_ == null) {
        return additionalImpact_.size();
      } else {
        return additionalImpactBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional set of additional impact that this recommendation may have when
     * trying to optimize for the primary category. These may be positive
     * or negative.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.Impact additional_impact = 6;</code>
     */
    public com.google.cloud.recommender.v1.Impact getAdditionalImpact(int index) {
      if (additionalImpactBuilder_ == null) {
        return additionalImpact_.get(index);
      } else {
        return additionalImpactBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional set of additional impact that this recommendation may have when
     * trying to optimize for the primary category. These may be positive
     * or negative.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.Impact additional_impact = 6;</code>
     */
    public Builder setAdditionalImpact(int index, com.google.cloud.recommender.v1.Impact value) {
      if (additionalImpactBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdditionalImpactIsMutable();
        additionalImpact_.set(index, value);
        onChanged();
      } else {
        additionalImpactBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional set of additional impact that this recommendation may have when
     * trying to optimize for the primary category. These may be positive
     * or negative.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.Impact additional_impact = 6;</code>
     */
    public Builder setAdditionalImpact(
        int index, com.google.cloud.recommender.v1.Impact.Builder builderForValue) {
      if (additionalImpactBuilder_ == null) {
        ensureAdditionalImpactIsMutable();
        additionalImpact_.set(index, builderForValue.build());
        onChanged();
      } else {
        additionalImpactBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional set of additional impact that this recommendation may have when
     * trying to optimize for the primary category. These may be positive
     * or negative.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.Impact additional_impact = 6;</code>
     */
    public Builder addAdditionalImpact(com.google.cloud.recommender.v1.Impact value) {
      if (additionalImpactBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdditionalImpactIsMutable();
        additionalImpact_.add(value);
        onChanged();
      } else {
        additionalImpactBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional set of additional impact that this recommendation may have when
     * trying to optimize for the primary category. These may be positive
     * or negative.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.Impact additional_impact = 6;</code>
     */
    public Builder addAdditionalImpact(int index, com.google.cloud.recommender.v1.Impact value) {
      if (additionalImpactBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdditionalImpactIsMutable();
        additionalImpact_.add(index, value);
        onChanged();
      } else {
        additionalImpactBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional set of additional impact that this recommendation may have when
     * trying to optimize for the primary category. These may be positive
     * or negative.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.Impact additional_impact = 6;</code>
     */
    public Builder addAdditionalImpact(
        com.google.cloud.recommender.v1.Impact.Builder builderForValue) {
      if (additionalImpactBuilder_ == null) {
        ensureAdditionalImpactIsMutable();
        additionalImpact_.add(builderForValue.build());
        onChanged();
      } else {
        additionalImpactBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional set of additional impact that this recommendation may have when
     * trying to optimize for the primary category. These may be positive
     * or negative.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.Impact additional_impact = 6;</code>
     */
    public Builder addAdditionalImpact(
        int index, com.google.cloud.recommender.v1.Impact.Builder builderForValue) {
      if (additionalImpactBuilder_ == null) {
        ensureAdditionalImpactIsMutable();
        additionalImpact_.add(index, builderForValue.build());
        onChanged();
      } else {
        additionalImpactBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional set of additional impact that this recommendation may have when
     * trying to optimize for the primary category. These may be positive
     * or negative.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.Impact additional_impact = 6;</code>
     */
    public Builder addAllAdditionalImpact(
        java.lang.Iterable<? extends com.google.cloud.recommender.v1.Impact> values) {
      if (additionalImpactBuilder_ == null) {
        ensureAdditionalImpactIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, additionalImpact_);
        onChanged();
      } else {
        additionalImpactBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional set of additional impact that this recommendation may have when
     * trying to optimize for the primary category. These may be positive
     * or negative.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.Impact additional_impact = 6;</code>
     */
    public Builder clearAdditionalImpact() {
      if (additionalImpactBuilder_ == null) {
        additionalImpact_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        additionalImpactBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional set of additional impact that this recommendation may have when
     * trying to optimize for the primary category. These may be positive
     * or negative.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.Impact additional_impact = 6;</code>
     */
    public Builder removeAdditionalImpact(int index) {
      if (additionalImpactBuilder_ == null) {
        ensureAdditionalImpactIsMutable();
        additionalImpact_.remove(index);
        onChanged();
      } else {
        additionalImpactBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional set of additional impact that this recommendation may have when
     * trying to optimize for the primary category. These may be positive
     * or negative.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.Impact additional_impact = 6;</code>
     */
    public com.google.cloud.recommender.v1.Impact.Builder getAdditionalImpactBuilder(int index) {
      return getAdditionalImpactFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional set of additional impact that this recommendation may have when
     * trying to optimize for the primary category. These may be positive
     * or negative.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.Impact additional_impact = 6;</code>
     */
    public com.google.cloud.recommender.v1.ImpactOrBuilder getAdditionalImpactOrBuilder(int index) {
      if (additionalImpactBuilder_ == null) {
        return additionalImpact_.get(index);
      } else {
        return additionalImpactBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional set of additional impact that this recommendation may have when
     * trying to optimize for the primary category. These may be positive
     * or negative.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.Impact additional_impact = 6;</code>
     */
    public java.util.List<? extends com.google.cloud.recommender.v1.ImpactOrBuilder>
        getAdditionalImpactOrBuilderList() {
      if (additionalImpactBuilder_ != null) {
        return additionalImpactBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(additionalImpact_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional set of additional impact that this recommendation may have when
     * trying to optimize for the primary category. These may be positive
     * or negative.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.Impact additional_impact = 6;</code>
     */
    public com.google.cloud.recommender.v1.Impact.Builder addAdditionalImpactBuilder() {
      return getAdditionalImpactFieldBuilder()
          .addBuilder(com.google.cloud.recommender.v1.Impact.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional set of additional impact that this recommendation may have when
     * trying to optimize for the primary category. These may be positive
     * or negative.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.Impact additional_impact = 6;</code>
     */
    public com.google.cloud.recommender.v1.Impact.Builder addAdditionalImpactBuilder(int index) {
      return getAdditionalImpactFieldBuilder()
          .addBuilder(index, com.google.cloud.recommender.v1.Impact.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional set of additional impact that this recommendation may have when
     * trying to optimize for the primary category. These may be positive
     * or negative.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.Impact additional_impact = 6;</code>
     */
    public java.util.List<com.google.cloud.recommender.v1.Impact.Builder>
        getAdditionalImpactBuilderList() {
      return getAdditionalImpactFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.recommender.v1.Impact,
            com.google.cloud.recommender.v1.Impact.Builder,
            com.google.cloud.recommender.v1.ImpactOrBuilder>
        getAdditionalImpactFieldBuilder() {
      if (additionalImpactBuilder_ == null) {
        additionalImpactBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.recommender.v1.Impact,
                com.google.cloud.recommender.v1.Impact.Builder,
                com.google.cloud.recommender.v1.ImpactOrBuilder>(
                additionalImpact_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        additionalImpact_ = null;
      }
      return additionalImpactBuilder_;
    }

    private int priority_ = 0;
    /**
     *
     *
     * <pre>
     * Recommendation's priority.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Recommendation.Priority priority = 17;</code>
     *
     * @return The enum numeric value on the wire for priority.
     */
    @java.lang.Override
    public int getPriorityValue() {
      return priority_;
    }
    /**
     *
     *
     * <pre>
     * Recommendation's priority.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Recommendation.Priority priority = 17;</code>
     *
     * @param value The enum numeric value on the wire for priority to set.
     * @return This builder for chaining.
     */
    public Builder setPriorityValue(int value) {
      priority_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Recommendation's priority.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Recommendation.Priority priority = 17;</code>
     *
     * @return The priority.
     */
    @java.lang.Override
    public com.google.cloud.recommender.v1.Recommendation.Priority getPriority() {
      com.google.cloud.recommender.v1.Recommendation.Priority result =
          com.google.cloud.recommender.v1.Recommendation.Priority.forNumber(priority_);
      return result == null
          ? com.google.cloud.recommender.v1.Recommendation.Priority.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Recommendation's priority.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Recommendation.Priority priority = 17;</code>
     *
     * @param value The priority to set.
     * @return This builder for chaining.
     */
    public Builder setPriority(com.google.cloud.recommender.v1.Recommendation.Priority value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      priority_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Recommendation's priority.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.Recommendation.Priority priority = 17;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPriority() {
      bitField0_ = (bitField0_ & ~0x00000040);
      priority_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.recommender.v1.RecommendationContent content_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.recommender.v1.RecommendationContent,
            com.google.cloud.recommender.v1.RecommendationContent.Builder,
            com.google.cloud.recommender.v1.RecommendationContentOrBuilder>
        contentBuilder_;
    /**
     *
     *
     * <pre>
     * Content of the recommendation describing recommended changes to resources.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.RecommendationContent content = 7;</code>
     *
     * @return Whether the content field is set.
     */
    public boolean hasContent() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Content of the recommendation describing recommended changes to resources.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.RecommendationContent content = 7;</code>
     *
     * @return The content.
     */
    public com.google.cloud.recommender.v1.RecommendationContent getContent() {
      if (contentBuilder_ == null) {
        return content_ == null
            ? com.google.cloud.recommender.v1.RecommendationContent.getDefaultInstance()
            : content_;
      } else {
        return contentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Content of the recommendation describing recommended changes to resources.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.RecommendationContent content = 7;</code>
     */
    public Builder setContent(com.google.cloud.recommender.v1.RecommendationContent value) {
      if (contentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        content_ = value;
      } else {
        contentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Content of the recommendation describing recommended changes to resources.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.RecommendationContent content = 7;</code>
     */
    public Builder setContent(
        com.google.cloud.recommender.v1.RecommendationContent.Builder builderForValue) {
      if (contentBuilder_ == null) {
        content_ = builderForValue.build();
      } else {
        contentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Content of the recommendation describing recommended changes to resources.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.RecommendationContent content = 7;</code>
     */
    public Builder mergeContent(com.google.cloud.recommender.v1.RecommendationContent value) {
      if (contentBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && content_ != null
            && content_
                != com.google.cloud.recommender.v1.RecommendationContent.getDefaultInstance()) {
          getContentBuilder().mergeFrom(value);
        } else {
          content_ = value;
        }
      } else {
        contentBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Content of the recommendation describing recommended changes to resources.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.RecommendationContent content = 7;</code>
     */
    public Builder clearContent() {
      bitField0_ = (bitField0_ & ~0x00000080);
      content_ = null;
      if (contentBuilder_ != null) {
        contentBuilder_.dispose();
        contentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Content of the recommendation describing recommended changes to resources.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.RecommendationContent content = 7;</code>
     */
    public com.google.cloud.recommender.v1.RecommendationContent.Builder getContentBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getContentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Content of the recommendation describing recommended changes to resources.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.RecommendationContent content = 7;</code>
     */
    public com.google.cloud.recommender.v1.RecommendationContentOrBuilder getContentOrBuilder() {
      if (contentBuilder_ != null) {
        return contentBuilder_.getMessageOrBuilder();
      } else {
        return content_ == null
            ? com.google.cloud.recommender.v1.RecommendationContent.getDefaultInstance()
            : content_;
      }
    }
    /**
     *
     *
     * <pre>
     * Content of the recommendation describing recommended changes to resources.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.RecommendationContent content = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.recommender.v1.RecommendationContent,
            com.google.cloud.recommender.v1.RecommendationContent.Builder,
            com.google.cloud.recommender.v1.RecommendationContentOrBuilder>
        getContentFieldBuilder() {
      if (contentBuilder_ == null) {
        contentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.recommender.v1.RecommendationContent,
                com.google.cloud.recommender.v1.RecommendationContent.Builder,
                com.google.cloud.recommender.v1.RecommendationContentOrBuilder>(
                getContent(), getParentForChildren(), isClean());
        content_ = null;
      }
      return contentBuilder_;
    }

    private com.google.cloud.recommender.v1.RecommendationStateInfo stateInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.recommender.v1.RecommendationStateInfo,
            com.google.cloud.recommender.v1.RecommendationStateInfo.Builder,
            com.google.cloud.recommender.v1.RecommendationStateInfoOrBuilder>
        stateInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Information for state. Contains state and metadata.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.RecommendationStateInfo state_info = 10;</code>
     *
     * @return Whether the stateInfo field is set.
     */
    public boolean hasStateInfo() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Information for state. Contains state and metadata.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.RecommendationStateInfo state_info = 10;</code>
     *
     * @return The stateInfo.
     */
    public com.google.cloud.recommender.v1.RecommendationStateInfo getStateInfo() {
      if (stateInfoBuilder_ == null) {
        return stateInfo_ == null
            ? com.google.cloud.recommender.v1.RecommendationStateInfo.getDefaultInstance()
            : stateInfo_;
      } else {
        return stateInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Information for state. Contains state and metadata.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.RecommendationStateInfo state_info = 10;</code>
     */
    public Builder setStateInfo(com.google.cloud.recommender.v1.RecommendationStateInfo value) {
      if (stateInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stateInfo_ = value;
      } else {
        stateInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information for state. Contains state and metadata.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.RecommendationStateInfo state_info = 10;</code>
     */
    public Builder setStateInfo(
        com.google.cloud.recommender.v1.RecommendationStateInfo.Builder builderForValue) {
      if (stateInfoBuilder_ == null) {
        stateInfo_ = builderForValue.build();
      } else {
        stateInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information for state. Contains state and metadata.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.RecommendationStateInfo state_info = 10;</code>
     */
    public Builder mergeStateInfo(com.google.cloud.recommender.v1.RecommendationStateInfo value) {
      if (stateInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && stateInfo_ != null
            && stateInfo_
                != com.google.cloud.recommender.v1.RecommendationStateInfo.getDefaultInstance()) {
          getStateInfoBuilder().mergeFrom(value);
        } else {
          stateInfo_ = value;
        }
      } else {
        stateInfoBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information for state. Contains state and metadata.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.RecommendationStateInfo state_info = 10;</code>
     */
    public Builder clearStateInfo() {
      bitField0_ = (bitField0_ & ~0x00000100);
      stateInfo_ = null;
      if (stateInfoBuilder_ != null) {
        stateInfoBuilder_.dispose();
        stateInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information for state. Contains state and metadata.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.RecommendationStateInfo state_info = 10;</code>
     */
    public com.google.cloud.recommender.v1.RecommendationStateInfo.Builder getStateInfoBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getStateInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Information for state. Contains state and metadata.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.RecommendationStateInfo state_info = 10;</code>
     */
    public com.google.cloud.recommender.v1.RecommendationStateInfoOrBuilder
        getStateInfoOrBuilder() {
      if (stateInfoBuilder_ != null) {
        return stateInfoBuilder_.getMessageOrBuilder();
      } else {
        return stateInfo_ == null
            ? com.google.cloud.recommender.v1.RecommendationStateInfo.getDefaultInstance()
            : stateInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Information for state. Contains state and metadata.
     * </pre>
     *
     * <code>.google.cloud.recommender.v1.RecommendationStateInfo state_info = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.recommender.v1.RecommendationStateInfo,
            com.google.cloud.recommender.v1.RecommendationStateInfo.Builder,
            com.google.cloud.recommender.v1.RecommendationStateInfoOrBuilder>
        getStateInfoFieldBuilder() {
      if (stateInfoBuilder_ == null) {
        stateInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.recommender.v1.RecommendationStateInfo,
                com.google.cloud.recommender.v1.RecommendationStateInfo.Builder,
                com.google.cloud.recommender.v1.RecommendationStateInfoOrBuilder>(
                getStateInfo(), getParentForChildren(), isClean());
        stateInfo_ = null;
      }
      return stateInfoBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Fingerprint of the Recommendation. Provides optimistic locking when
     * updating states.
     * </pre>
     *
     * <code>string etag = 11;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of the Recommendation. Provides optimistic locking when
     * updating states.
     * </pre>
     *
     * <code>string etag = 11;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of the Recommendation. Provides optimistic locking when
     * updating states.
     * </pre>
     *
     * <code>string etag = 11;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of the Recommendation. Provides optimistic locking when
     * updating states.
     * </pre>
     *
     * <code>string etag = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of the Recommendation. Provides optimistic locking when
     * updating states.
     * </pre>
     *
     * <code>string etag = 11;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.recommender.v1.Recommendation.InsightReference>
        associatedInsights_ = java.util.Collections.emptyList();

    private void ensureAssociatedInsightsIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        associatedInsights_ =
            new java.util.ArrayList<
                com.google.cloud.recommender.v1.Recommendation.InsightReference>(
                associatedInsights_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.recommender.v1.Recommendation.InsightReference,
            com.google.cloud.recommender.v1.Recommendation.InsightReference.Builder,
            com.google.cloud.recommender.v1.Recommendation.InsightReferenceOrBuilder>
        associatedInsightsBuilder_;

    /**
     *
     *
     * <pre>
     * Insights that led to this recommendation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Recommendation.InsightReference associated_insights = 14;
     * </code>
     */
    public java.util.List<com.google.cloud.recommender.v1.Recommendation.InsightReference>
        getAssociatedInsightsList() {
      if (associatedInsightsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(associatedInsights_);
      } else {
        return associatedInsightsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Insights that led to this recommendation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Recommendation.InsightReference associated_insights = 14;
     * </code>
     */
    public int getAssociatedInsightsCount() {
      if (associatedInsightsBuilder_ == null) {
        return associatedInsights_.size();
      } else {
        return associatedInsightsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Insights that led to this recommendation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Recommendation.InsightReference associated_insights = 14;
     * </code>
     */
    public com.google.cloud.recommender.v1.Recommendation.InsightReference getAssociatedInsights(
        int index) {
      if (associatedInsightsBuilder_ == null) {
        return associatedInsights_.get(index);
      } else {
        return associatedInsightsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Insights that led to this recommendation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Recommendation.InsightReference associated_insights = 14;
     * </code>
     */
    public Builder setAssociatedInsights(
        int index, com.google.cloud.recommender.v1.Recommendation.InsightReference value) {
      if (associatedInsightsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAssociatedInsightsIsMutable();
        associatedInsights_.set(index, value);
        onChanged();
      } else {
        associatedInsightsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Insights that led to this recommendation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Recommendation.InsightReference associated_insights = 14;
     * </code>
     */
    public Builder setAssociatedInsights(
        int index,
        com.google.cloud.recommender.v1.Recommendation.InsightReference.Builder builderForValue) {
      if (associatedInsightsBuilder_ == null) {
        ensureAssociatedInsightsIsMutable();
        associatedInsights_.set(index, builderForValue.build());
        onChanged();
      } else {
        associatedInsightsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Insights that led to this recommendation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Recommendation.InsightReference associated_insights = 14;
     * </code>
     */
    public Builder addAssociatedInsights(
        com.google.cloud.recommender.v1.Recommendation.InsightReference value) {
      if (associatedInsightsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAssociatedInsightsIsMutable();
        associatedInsights_.add(value);
        onChanged();
      } else {
        associatedInsightsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Insights that led to this recommendation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Recommendation.InsightReference associated_insights = 14;
     * </code>
     */
    public Builder addAssociatedInsights(
        int index, com.google.cloud.recommender.v1.Recommendation.InsightReference value) {
      if (associatedInsightsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAssociatedInsightsIsMutable();
        associatedInsights_.add(index, value);
        onChanged();
      } else {
        associatedInsightsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Insights that led to this recommendation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Recommendation.InsightReference associated_insights = 14;
     * </code>
     */
    public Builder addAssociatedInsights(
        com.google.cloud.recommender.v1.Recommendation.InsightReference.Builder builderForValue) {
      if (associatedInsightsBuilder_ == null) {
        ensureAssociatedInsightsIsMutable();
        associatedInsights_.add(builderForValue.build());
        onChanged();
      } else {
        associatedInsightsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Insights that led to this recommendation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Recommendation.InsightReference associated_insights = 14;
     * </code>
     */
    public Builder addAssociatedInsights(
        int index,
        com.google.cloud.recommender.v1.Recommendation.InsightReference.Builder builderForValue) {
      if (associatedInsightsBuilder_ == null) {
        ensureAssociatedInsightsIsMutable();
        associatedInsights_.add(index, builderForValue.build());
        onChanged();
      } else {
        associatedInsightsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Insights that led to this recommendation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Recommendation.InsightReference associated_insights = 14;
     * </code>
     */
    public Builder addAllAssociatedInsights(
        java.lang.Iterable<
                ? extends com.google.cloud.recommender.v1.Recommendation.InsightReference>
            values) {
      if (associatedInsightsBuilder_ == null) {
        ensureAssociatedInsightsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, associatedInsights_);
        onChanged();
      } else {
        associatedInsightsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Insights that led to this recommendation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Recommendation.InsightReference associated_insights = 14;
     * </code>
     */
    public Builder clearAssociatedInsights() {
      if (associatedInsightsBuilder_ == null) {
        associatedInsights_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        associatedInsightsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Insights that led to this recommendation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Recommendation.InsightReference associated_insights = 14;
     * </code>
     */
    public Builder removeAssociatedInsights(int index) {
      if (associatedInsightsBuilder_ == null) {
        ensureAssociatedInsightsIsMutable();
        associatedInsights_.remove(index);
        onChanged();
      } else {
        associatedInsightsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Insights that led to this recommendation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Recommendation.InsightReference associated_insights = 14;
     * </code>
     */
    public com.google.cloud.recommender.v1.Recommendation.InsightReference.Builder
        getAssociatedInsightsBuilder(int index) {
      return getAssociatedInsightsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Insights that led to this recommendation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Recommendation.InsightReference associated_insights = 14;
     * </code>
     */
    public com.google.cloud.recommender.v1.Recommendation.InsightReferenceOrBuilder
        getAssociatedInsightsOrBuilder(int index) {
      if (associatedInsightsBuilder_ == null) {
        return associatedInsights_.get(index);
      } else {
        return associatedInsightsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Insights that led to this recommendation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Recommendation.InsightReference associated_insights = 14;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.recommender.v1.Recommendation.InsightReferenceOrBuilder>
        getAssociatedInsightsOrBuilderList() {
      if (associatedInsightsBuilder_ != null) {
        return associatedInsightsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(associatedInsights_);
      }
    }
    /**
     *
     *
     * <pre>
     * Insights that led to this recommendation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Recommendation.InsightReference associated_insights = 14;
     * </code>
     */
    public com.google.cloud.recommender.v1.Recommendation.InsightReference.Builder
        addAssociatedInsightsBuilder() {
      return getAssociatedInsightsFieldBuilder()
          .addBuilder(
              com.google.cloud.recommender.v1.Recommendation.InsightReference.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Insights that led to this recommendation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Recommendation.InsightReference associated_insights = 14;
     * </code>
     */
    public com.google.cloud.recommender.v1.Recommendation.InsightReference.Builder
        addAssociatedInsightsBuilder(int index) {
      return getAssociatedInsightsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.recommender.v1.Recommendation.InsightReference.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Insights that led to this recommendation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recommender.v1.Recommendation.InsightReference associated_insights = 14;
     * </code>
     */
    public java.util.List<com.google.cloud.recommender.v1.Recommendation.InsightReference.Builder>
        getAssociatedInsightsBuilderList() {
      return getAssociatedInsightsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.recommender.v1.Recommendation.InsightReference,
            com.google.cloud.recommender.v1.Recommendation.InsightReference.Builder,
            com.google.cloud.recommender.v1.Recommendation.InsightReferenceOrBuilder>
        getAssociatedInsightsFieldBuilder() {
      if (associatedInsightsBuilder_ == null) {
        associatedInsightsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.recommender.v1.Recommendation.InsightReference,
                com.google.cloud.recommender.v1.Recommendation.InsightReference.Builder,
                com.google.cloud.recommender.v1.Recommendation.InsightReferenceOrBuilder>(
                associatedInsights_,
                ((bitField0_ & 0x00000400) != 0),
                getParentForChildren(),
                isClean());
        associatedInsights_ = null;
      }
      return associatedInsightsBuilder_;
    }

    private java.lang.Object xorGroupId_ = "";
    /**
     *
     *
     * <pre>
     * Corresponds to a mutually exclusive group ID within a recommender.
     * A non-empty ID indicates that the recommendation belongs to a mutually
     * exclusive group. This means that only one recommendation within the group
     * is suggested to be applied.
     * </pre>
     *
     * <code>string xor_group_id = 18;</code>
     *
     * @return The xorGroupId.
     */
    public java.lang.String getXorGroupId() {
      java.lang.Object ref = xorGroupId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        xorGroupId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Corresponds to a mutually exclusive group ID within a recommender.
     * A non-empty ID indicates that the recommendation belongs to a mutually
     * exclusive group. This means that only one recommendation within the group
     * is suggested to be applied.
     * </pre>
     *
     * <code>string xor_group_id = 18;</code>
     *
     * @return The bytes for xorGroupId.
     */
    public com.google.protobuf.ByteString getXorGroupIdBytes() {
      java.lang.Object ref = xorGroupId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        xorGroupId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Corresponds to a mutually exclusive group ID within a recommender.
     * A non-empty ID indicates that the recommendation belongs to a mutually
     * exclusive group. This means that only one recommendation within the group
     * is suggested to be applied.
     * </pre>
     *
     * <code>string xor_group_id = 18;</code>
     *
     * @param value The xorGroupId to set.
     * @return This builder for chaining.
     */
    public Builder setXorGroupId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      xorGroupId_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Corresponds to a mutually exclusive group ID within a recommender.
     * A non-empty ID indicates that the recommendation belongs to a mutually
     * exclusive group. This means that only one recommendation within the group
     * is suggested to be applied.
     * </pre>
     *
     * <code>string xor_group_id = 18;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearXorGroupId() {
      xorGroupId_ = getDefaultInstance().getXorGroupId();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Corresponds to a mutually exclusive group ID within a recommender.
     * A non-empty ID indicates that the recommendation belongs to a mutually
     * exclusive group. This means that only one recommendation within the group
     * is suggested to be applied.
     * </pre>
     *
     * <code>string xor_group_id = 18;</code>
     *
     * @param value The bytes for xorGroupId to set.
     * @return This builder for chaining.
     */
    public Builder setXorGroupIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      xorGroupId_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.recommender.v1.Recommendation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.recommender.v1.Recommendation)
  private static final com.google.cloud.recommender.v1.Recommendation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.recommender.v1.Recommendation();
  }

  public static com.google.cloud.recommender.v1.Recommendation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Recommendation> PARSER =
      new com.google.protobuf.AbstractParser<Recommendation>() {
        @java.lang.Override
        public Recommendation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Recommendation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Recommendation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.recommender.v1.Recommendation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
