/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/recommender/v1/recommendation.proto

package com.google.cloud.recommender.v1;

/**
 *
 *
 * <pre>
 * Contains information on the impact of a reliability recommendation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.recommender.v1.ReliabilityProjection}
 */
public final class ReliabilityProjection extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.recommender.v1.ReliabilityProjection)
    ReliabilityProjectionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReliabilityProjection.newBuilder() to construct.
  private ReliabilityProjection(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReliabilityProjection() {
    risks_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReliabilityProjection();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.recommender.v1.RecommendationOuterClass
        .internal_static_google_cloud_recommender_v1_ReliabilityProjection_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.recommender.v1.RecommendationOuterClass
        .internal_static_google_cloud_recommender_v1_ReliabilityProjection_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.recommender.v1.ReliabilityProjection.class,
            com.google.cloud.recommender.v1.ReliabilityProjection.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The risk associated with the reliability issue.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.recommender.v1.ReliabilityProjection.RiskType}
   */
  public enum RiskType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default unspecified risk. Don't use directly.
     * </pre>
     *
     * <code>RISK_TYPE_UNSPECIFIED = 0;</code>
     */
    RISK_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Potential service downtime.
     * </pre>
     *
     * <code>SERVICE_DISRUPTION = 1;</code>
     */
    SERVICE_DISRUPTION(1),
    /**
     *
     *
     * <pre>
     * Potential data loss.
     * </pre>
     *
     * <code>DATA_LOSS = 2;</code>
     */
    DATA_LOSS(2),
    /**
     *
     *
     * <pre>
     * Potential access denial. The service is still up but some or all clients
     * can't access it.
     * </pre>
     *
     * <code>ACCESS_DENY = 3;</code>
     */
    ACCESS_DENY(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default unspecified risk. Don't use directly.
     * </pre>
     *
     * <code>RISK_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int RISK_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Potential service downtime.
     * </pre>
     *
     * <code>SERVICE_DISRUPTION = 1;</code>
     */
    public static final int SERVICE_DISRUPTION_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Potential data loss.
     * </pre>
     *
     * <code>DATA_LOSS = 2;</code>
     */
    public static final int DATA_LOSS_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Potential access denial. The service is still up but some or all clients
     * can't access it.
     * </pre>
     *
     * <code>ACCESS_DENY = 3;</code>
     */
    public static final int ACCESS_DENY_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RiskType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RiskType forNumber(int value) {
      switch (value) {
        case 0:
          return RISK_TYPE_UNSPECIFIED;
        case 1:
          return SERVICE_DISRUPTION;
        case 2:
          return DATA_LOSS;
        case 3:
          return ACCESS_DENY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RiskType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RiskType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RiskType>() {
          public RiskType findValueByNumber(int number) {
            return RiskType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.recommender.v1.ReliabilityProjection.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final RiskType[] VALUES = values();

    public static RiskType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RiskType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.recommender.v1.ReliabilityProjection.RiskType)
  }

  public static final int RISKS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> risks_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.recommender.v1.ReliabilityProjection.RiskType>
      risks_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.recommender.v1.ReliabilityProjection.RiskType>() {
            public com.google.cloud.recommender.v1.ReliabilityProjection.RiskType convert(
                java.lang.Integer from) {
              com.google.cloud.recommender.v1.ReliabilityProjection.RiskType result =
                  com.google.cloud.recommender.v1.ReliabilityProjection.RiskType.forNumber(from);
              return result == null
                  ? com.google.cloud.recommender.v1.ReliabilityProjection.RiskType.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Reliability risks mitigated by this recommendation.
   * </pre>
   *
   * <code>repeated .google.cloud.recommender.v1.ReliabilityProjection.RiskType risks = 1;</code>
   *
   * @return A list containing the risks.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.recommender.v1.ReliabilityProjection.RiskType>
      getRisksList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.recommender.v1.ReliabilityProjection.RiskType>(
        risks_, risks_converter_);
  }
  /**
   *
   *
   * <pre>
   * Reliability risks mitigated by this recommendation.
   * </pre>
   *
   * <code>repeated .google.cloud.recommender.v1.ReliabilityProjection.RiskType risks = 1;</code>
   *
   * @return The count of risks.
   */
  @java.lang.Override
  public int getRisksCount() {
    return risks_.size();
  }
  /**
   *
   *
   * <pre>
   * Reliability risks mitigated by this recommendation.
   * </pre>
   *
   * <code>repeated .google.cloud.recommender.v1.ReliabilityProjection.RiskType risks = 1;</code>
   *
   * @param index The index of the element to return.
   * @return The risks at the given index.
   */
  @java.lang.Override
  public com.google.cloud.recommender.v1.ReliabilityProjection.RiskType getRisks(int index) {
    return risks_converter_.convert(risks_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Reliability risks mitigated by this recommendation.
   * </pre>
   *
   * <code>repeated .google.cloud.recommender.v1.ReliabilityProjection.RiskType risks = 1;</code>
   *
   * @return A list containing the enum numeric values on the wire for risks.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getRisksValueList() {
    return risks_;
  }
  /**
   *
   *
   * <pre>
   * Reliability risks mitigated by this recommendation.
   * </pre>
   *
   * <code>repeated .google.cloud.recommender.v1.ReliabilityProjection.RiskType risks = 1;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of risks at the given index.
   */
  @java.lang.Override
  public int getRisksValue(int index) {
    return risks_.get(index);
  }

  private int risksMemoizedSerializedSize;

  public static final int DETAILS_FIELD_NUMBER = 2;
  private com.google.protobuf.Struct details_;
  /**
   *
   *
   * <pre>
   * Per-recommender projection.
   * </pre>
   *
   * <code>.google.protobuf.Struct details = 2;</code>
   *
   * @return Whether the details field is set.
   */
  @java.lang.Override
  public boolean hasDetails() {
    return details_ != null;
  }
  /**
   *
   *
   * <pre>
   * Per-recommender projection.
   * </pre>
   *
   * <code>.google.protobuf.Struct details = 2;</code>
   *
   * @return The details.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getDetails() {
    return details_ == null ? com.google.protobuf.Struct.getDefaultInstance() : details_;
  }
  /**
   *
   *
   * <pre>
   * Per-recommender projection.
   * </pre>
   *
   * <code>.google.protobuf.Struct details = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getDetailsOrBuilder() {
    return details_ == null ? com.google.protobuf.Struct.getDefaultInstance() : details_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (getRisksList().size() > 0) {
      output.writeUInt32NoTag(10);
      output.writeUInt32NoTag(risksMemoizedSerializedSize);
    }
    for (int i = 0; i < risks_.size(); i++) {
      output.writeEnumNoTag(risks_.get(i));
    }
    if (details_ != null) {
      output.writeMessage(2, getDetails());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < risks_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(risks_.get(i));
      }
      size += dataSize;
      if (!getRisksList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      risksMemoizedSerializedSize = dataSize;
    }
    if (details_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDetails());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.recommender.v1.ReliabilityProjection)) {
      return super.equals(obj);
    }
    com.google.cloud.recommender.v1.ReliabilityProjection other =
        (com.google.cloud.recommender.v1.ReliabilityProjection) obj;

    if (!risks_.equals(other.risks_)) return false;
    if (hasDetails() != other.hasDetails()) return false;
    if (hasDetails()) {
      if (!getDetails().equals(other.getDetails())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getRisksCount() > 0) {
      hash = (37 * hash) + RISKS_FIELD_NUMBER;
      hash = (53 * hash) + risks_.hashCode();
    }
    if (hasDetails()) {
      hash = (37 * hash) + DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getDetails().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.recommender.v1.ReliabilityProjection parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.recommender.v1.ReliabilityProjection parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.recommender.v1.ReliabilityProjection parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.recommender.v1.ReliabilityProjection parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.recommender.v1.ReliabilityProjection parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.recommender.v1.ReliabilityProjection parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.recommender.v1.ReliabilityProjection parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.recommender.v1.ReliabilityProjection parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.recommender.v1.ReliabilityProjection parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.recommender.v1.ReliabilityProjection parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.recommender.v1.ReliabilityProjection parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.recommender.v1.ReliabilityProjection parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.recommender.v1.ReliabilityProjection prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Contains information on the impact of a reliability recommendation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recommender.v1.ReliabilityProjection}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.recommender.v1.ReliabilityProjection)
      com.google.cloud.recommender.v1.ReliabilityProjectionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.recommender.v1.RecommendationOuterClass
          .internal_static_google_cloud_recommender_v1_ReliabilityProjection_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.recommender.v1.RecommendationOuterClass
          .internal_static_google_cloud_recommender_v1_ReliabilityProjection_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.recommender.v1.ReliabilityProjection.class,
              com.google.cloud.recommender.v1.ReliabilityProjection.Builder.class);
    }

    // Construct using com.google.cloud.recommender.v1.ReliabilityProjection.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      risks_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      details_ = null;
      if (detailsBuilder_ != null) {
        detailsBuilder_.dispose();
        detailsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.recommender.v1.RecommendationOuterClass
          .internal_static_google_cloud_recommender_v1_ReliabilityProjection_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.recommender.v1.ReliabilityProjection getDefaultInstanceForType() {
      return com.google.cloud.recommender.v1.ReliabilityProjection.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.recommender.v1.ReliabilityProjection build() {
      com.google.cloud.recommender.v1.ReliabilityProjection result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.recommender.v1.ReliabilityProjection buildPartial() {
      com.google.cloud.recommender.v1.ReliabilityProjection result =
          new com.google.cloud.recommender.v1.ReliabilityProjection(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.recommender.v1.ReliabilityProjection result) {
      if (((bitField0_ & 0x00000001) != 0)) {
        risks_ = java.util.Collections.unmodifiableList(risks_);
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.risks_ = risks_;
    }

    private void buildPartial0(com.google.cloud.recommender.v1.ReliabilityProjection result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.details_ = detailsBuilder_ == null ? details_ : detailsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.recommender.v1.ReliabilityProjection) {
        return mergeFrom((com.google.cloud.recommender.v1.ReliabilityProjection) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.recommender.v1.ReliabilityProjection other) {
      if (other == com.google.cloud.recommender.v1.ReliabilityProjection.getDefaultInstance())
        return this;
      if (!other.risks_.isEmpty()) {
        if (risks_.isEmpty()) {
          risks_ = other.risks_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureRisksIsMutable();
          risks_.addAll(other.risks_);
        }
        onChanged();
      }
      if (other.hasDetails()) {
        mergeDetails(other.getDetails());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                int tmpRaw = input.readEnum();
                ensureRisksIsMutable();
                risks_.add(tmpRaw);
                break;
              } // case 8
            case 10:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureRisksIsMutable();
                  risks_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getDetailsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<java.lang.Integer> risks_ = java.util.Collections.emptyList();

    private void ensureRisksIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        risks_ = new java.util.ArrayList<java.lang.Integer>(risks_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Reliability risks mitigated by this recommendation.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.ReliabilityProjection.RiskType risks = 1;</code>
     *
     * @return A list containing the risks.
     */
    public java.util.List<com.google.cloud.recommender.v1.ReliabilityProjection.RiskType>
        getRisksList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.recommender.v1.ReliabilityProjection.RiskType>(
          risks_, risks_converter_);
    }
    /**
     *
     *
     * <pre>
     * Reliability risks mitigated by this recommendation.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.ReliabilityProjection.RiskType risks = 1;</code>
     *
     * @return The count of risks.
     */
    public int getRisksCount() {
      return risks_.size();
    }
    /**
     *
     *
     * <pre>
     * Reliability risks mitigated by this recommendation.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.ReliabilityProjection.RiskType risks = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The risks at the given index.
     */
    public com.google.cloud.recommender.v1.ReliabilityProjection.RiskType getRisks(int index) {
      return risks_converter_.convert(risks_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Reliability risks mitigated by this recommendation.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.ReliabilityProjection.RiskType risks = 1;</code>
     *
     * @param index The index to set the value at.
     * @param value The risks to set.
     * @return This builder for chaining.
     */
    public Builder setRisks(
        int index, com.google.cloud.recommender.v1.ReliabilityProjection.RiskType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRisksIsMutable();
      risks_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reliability risks mitigated by this recommendation.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.ReliabilityProjection.RiskType risks = 1;</code>
     *
     * @param value The risks to add.
     * @return This builder for chaining.
     */
    public Builder addRisks(com.google.cloud.recommender.v1.ReliabilityProjection.RiskType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRisksIsMutable();
      risks_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reliability risks mitigated by this recommendation.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.ReliabilityProjection.RiskType risks = 1;</code>
     *
     * @param values The risks to add.
     * @return This builder for chaining.
     */
    public Builder addAllRisks(
        java.lang.Iterable<? extends com.google.cloud.recommender.v1.ReliabilityProjection.RiskType>
            values) {
      ensureRisksIsMutable();
      for (com.google.cloud.recommender.v1.ReliabilityProjection.RiskType value : values) {
        risks_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reliability risks mitigated by this recommendation.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.ReliabilityProjection.RiskType risks = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRisks() {
      risks_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reliability risks mitigated by this recommendation.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.ReliabilityProjection.RiskType risks = 1;</code>
     *
     * @return A list containing the enum numeric values on the wire for risks.
     */
    public java.util.List<java.lang.Integer> getRisksValueList() {
      return java.util.Collections.unmodifiableList(risks_);
    }
    /**
     *
     *
     * <pre>
     * Reliability risks mitigated by this recommendation.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.ReliabilityProjection.RiskType risks = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of risks at the given index.
     */
    public int getRisksValue(int index) {
      return risks_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Reliability risks mitigated by this recommendation.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.ReliabilityProjection.RiskType risks = 1;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for risks to set.
     * @return This builder for chaining.
     */
    public Builder setRisksValue(int index, int value) {
      ensureRisksIsMutable();
      risks_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reliability risks mitigated by this recommendation.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.ReliabilityProjection.RiskType risks = 1;</code>
     *
     * @param value The enum numeric value on the wire for risks to add.
     * @return This builder for chaining.
     */
    public Builder addRisksValue(int value) {
      ensureRisksIsMutable();
      risks_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reliability risks mitigated by this recommendation.
     * </pre>
     *
     * <code>repeated .google.cloud.recommender.v1.ReliabilityProjection.RiskType risks = 1;</code>
     *
     * @param values The enum numeric values on the wire for risks to add.
     * @return This builder for chaining.
     */
    public Builder addAllRisksValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureRisksIsMutable();
      for (int value : values) {
        risks_.add(value);
      }
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct details_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        detailsBuilder_;
    /**
     *
     *
     * <pre>
     * Per-recommender projection.
     * </pre>
     *
     * <code>.google.protobuf.Struct details = 2;</code>
     *
     * @return Whether the details field is set.
     */
    public boolean hasDetails() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Per-recommender projection.
     * </pre>
     *
     * <code>.google.protobuf.Struct details = 2;</code>
     *
     * @return The details.
     */
    public com.google.protobuf.Struct getDetails() {
      if (detailsBuilder_ == null) {
        return details_ == null ? com.google.protobuf.Struct.getDefaultInstance() : details_;
      } else {
        return detailsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Per-recommender projection.
     * </pre>
     *
     * <code>.google.protobuf.Struct details = 2;</code>
     */
    public Builder setDetails(com.google.protobuf.Struct value) {
      if (detailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
      } else {
        detailsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Per-recommender projection.
     * </pre>
     *
     * <code>.google.protobuf.Struct details = 2;</code>
     */
    public Builder setDetails(com.google.protobuf.Struct.Builder builderForValue) {
      if (detailsBuilder_ == null) {
        details_ = builderForValue.build();
      } else {
        detailsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Per-recommender projection.
     * </pre>
     *
     * <code>.google.protobuf.Struct details = 2;</code>
     */
    public Builder mergeDetails(com.google.protobuf.Struct value) {
      if (detailsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && details_ != null
            && details_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getDetailsBuilder().mergeFrom(value);
        } else {
          details_ = value;
        }
      } else {
        detailsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Per-recommender projection.
     * </pre>
     *
     * <code>.google.protobuf.Struct details = 2;</code>
     */
    public Builder clearDetails() {
      bitField0_ = (bitField0_ & ~0x00000002);
      details_ = null;
      if (detailsBuilder_ != null) {
        detailsBuilder_.dispose();
        detailsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Per-recommender projection.
     * </pre>
     *
     * <code>.google.protobuf.Struct details = 2;</code>
     */
    public com.google.protobuf.Struct.Builder getDetailsBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Per-recommender projection.
     * </pre>
     *
     * <code>.google.protobuf.Struct details = 2;</code>
     */
    public com.google.protobuf.StructOrBuilder getDetailsOrBuilder() {
      if (detailsBuilder_ != null) {
        return detailsBuilder_.getMessageOrBuilder();
      } else {
        return details_ == null ? com.google.protobuf.Struct.getDefaultInstance() : details_;
      }
    }
    /**
     *
     *
     * <pre>
     * Per-recommender projection.
     * </pre>
     *
     * <code>.google.protobuf.Struct details = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getDetailsFieldBuilder() {
      if (detailsBuilder_ == null) {
        detailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getDetails(), getParentForChildren(), isClean());
        details_ = null;
      }
      return detailsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.recommender.v1.ReliabilityProjection)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.recommender.v1.ReliabilityProjection)
  private static final com.google.cloud.recommender.v1.ReliabilityProjection DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.recommender.v1.ReliabilityProjection();
  }

  public static com.google.cloud.recommender.v1.ReliabilityProjection getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReliabilityProjection> PARSER =
      new com.google.protobuf.AbstractParser<ReliabilityProjection>() {
        @java.lang.Override
        public ReliabilityProjection parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReliabilityProjection> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReliabilityProjection> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.recommender.v1.ReliabilityProjection getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
