/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/redis/v1/cloud_redis.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.redis.v1;

/**
 *
 *
 * <pre>
 * A Memorystore for Redis instance.
 * </pre>
 *
 * Protobuf type {@code google.cloud.redis.v1.Instance}
 */
public final class Instance extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.redis.v1.Instance)
    InstanceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Instance.newBuilder() to construct.
  private Instance(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Instance() {
    name_ = "";
    displayName_ = "";
    locationId_ = "";
    alternativeLocationId_ = "";
    redisVersion_ = "";
    reservedIpRange_ = "";
    secondaryIpRange_ = "";
    host_ = "";
    currentLocationId_ = "";
    state_ = 0;
    statusMessage_ = "";
    tier_ = 0;
    authorizedNetwork_ = "";
    persistenceIamIdentity_ = "";
    connectMode_ = 0;
    serverCaCerts_ = java.util.Collections.emptyList();
    transitEncryptionMode_ = 0;
    nodes_ = java.util.Collections.emptyList();
    readEndpoint_ = "";
    readReplicasMode_ = 0;
    customerManagedKey_ = "";
    suspensionReasons_ = java.util.Collections.emptyList();
    maintenanceVersion_ = "";
    availableMaintenanceVersions_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Instance();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.redis.v1.CloudRedisServiceV1Proto
        .internal_static_google_cloud_redis_v1_Instance_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 3:
        return internalGetLabels();
      case 16:
        return internalGetRedisConfigs();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.redis.v1.CloudRedisServiceV1Proto
        .internal_static_google_cloud_redis_v1_Instance_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.redis.v1.Instance.class,
            com.google.cloud.redis.v1.Instance.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Represents the different states of a Redis instance.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.redis.v1.Instance.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Redis instance is being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * Redis instance has been created and is fully usable.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    READY(2),
    /**
     *
     *
     * <pre>
     * Redis instance configuration is being updated. Certain kinds of updates
     * may cause the instance to become unusable while the update is in
     * progress.
     * </pre>
     *
     * <code>UPDATING = 3;</code>
     */
    UPDATING(3),
    /**
     *
     *
     * <pre>
     * Redis instance is being deleted.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    DELETING(4),
    /**
     *
     *
     * <pre>
     * Redis instance is being repaired and may be unusable.
     * </pre>
     *
     * <code>REPAIRING = 5;</code>
     */
    REPAIRING(5),
    /**
     *
     *
     * <pre>
     * Maintenance is being performed on this Redis instance.
     * </pre>
     *
     * <code>MAINTENANCE = 6;</code>
     */
    MAINTENANCE(6),
    /**
     *
     *
     * <pre>
     * Redis instance is importing data (availability may be affected).
     * </pre>
     *
     * <code>IMPORTING = 8;</code>
     */
    IMPORTING(8),
    /**
     *
     *
     * <pre>
     * Redis instance is failing over (availability may be affected).
     * </pre>
     *
     * <code>FAILING_OVER = 9;</code>
     */
    FAILING_OVER(9),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Redis instance is being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Redis instance has been created and is fully usable.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    public static final int READY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Redis instance configuration is being updated. Certain kinds of updates
     * may cause the instance to become unusable while the update is in
     * progress.
     * </pre>
     *
     * <code>UPDATING = 3;</code>
     */
    public static final int UPDATING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Redis instance is being deleted.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    public static final int DELETING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Redis instance is being repaired and may be unusable.
     * </pre>
     *
     * <code>REPAIRING = 5;</code>
     */
    public static final int REPAIRING_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Maintenance is being performed on this Redis instance.
     * </pre>
     *
     * <code>MAINTENANCE = 6;</code>
     */
    public static final int MAINTENANCE_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Redis instance is importing data (availability may be affected).
     * </pre>
     *
     * <code>IMPORTING = 8;</code>
     */
    public static final int IMPORTING_VALUE = 8;
    /**
     *
     *
     * <pre>
     * Redis instance is failing over (availability may be affected).
     * </pre>
     *
     * <code>FAILING_OVER = 9;</code>
     */
    public static final int FAILING_OVER_VALUE = 9;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return READY;
        case 3:
          return UPDATING;
        case 4:
          return DELETING;
        case 5:
          return REPAIRING;
        case 6:
          return MAINTENANCE;
        case 8:
          return IMPORTING;
        case 9:
          return FAILING_OVER;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.redis.v1.Instance.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.redis.v1.Instance.State)
  }

  /**
   *
   *
   * <pre>
   * Available service tiers to choose from
   * </pre>
   *
   * Protobuf enum {@code google.cloud.redis.v1.Instance.Tier}
   */
  public enum Tier implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>TIER_UNSPECIFIED = 0;</code>
     */
    TIER_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * BASIC tier: standalone instance
     * </pre>
     *
     * <code>BASIC = 1;</code>
     */
    BASIC(1),
    /**
     *
     *
     * <pre>
     * STANDARD_HA tier: highly available primary/replica instances
     * </pre>
     *
     * <code>STANDARD_HA = 3;</code>
     */
    STANDARD_HA(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>TIER_UNSPECIFIED = 0;</code>
     */
    public static final int TIER_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * BASIC tier: standalone instance
     * </pre>
     *
     * <code>BASIC = 1;</code>
     */
    public static final int BASIC_VALUE = 1;
    /**
     *
     *
     * <pre>
     * STANDARD_HA tier: highly available primary/replica instances
     * </pre>
     *
     * <code>STANDARD_HA = 3;</code>
     */
    public static final int STANDARD_HA_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Tier valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Tier forNumber(int value) {
      switch (value) {
        case 0:
          return TIER_UNSPECIFIED;
        case 1:
          return BASIC;
        case 3:
          return STANDARD_HA;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Tier> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Tier> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Tier>() {
          public Tier findValueByNumber(int number) {
            return Tier.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.redis.v1.Instance.getDescriptor().getEnumTypes().get(1);
    }

    private static final Tier[] VALUES = values();

    public static Tier valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Tier(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.redis.v1.Instance.Tier)
  }

  /**
   *
   *
   * <pre>
   * Available connection modes.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.redis.v1.Instance.ConnectMode}
   */
  public enum ConnectMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>CONNECT_MODE_UNSPECIFIED = 0;</code>
     */
    CONNECT_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Connect via direct peering to the Memorystore for Redis hosted service.
     * </pre>
     *
     * <code>DIRECT_PEERING = 1;</code>
     */
    DIRECT_PEERING(1),
    /**
     *
     *
     * <pre>
     * Connect your Memorystore for Redis instance using Private Service
     * Access. Private services access provides an IP address range for multiple
     * Google Cloud services, including Memorystore.
     * </pre>
     *
     * <code>PRIVATE_SERVICE_ACCESS = 2;</code>
     */
    PRIVATE_SERVICE_ACCESS(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>CONNECT_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int CONNECT_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Connect via direct peering to the Memorystore for Redis hosted service.
     * </pre>
     *
     * <code>DIRECT_PEERING = 1;</code>
     */
    public static final int DIRECT_PEERING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Connect your Memorystore for Redis instance using Private Service
     * Access. Private services access provides an IP address range for multiple
     * Google Cloud services, including Memorystore.
     * </pre>
     *
     * <code>PRIVATE_SERVICE_ACCESS = 2;</code>
     */
    public static final int PRIVATE_SERVICE_ACCESS_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConnectMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ConnectMode forNumber(int value) {
      switch (value) {
        case 0:
          return CONNECT_MODE_UNSPECIFIED;
        case 1:
          return DIRECT_PEERING;
        case 2:
          return PRIVATE_SERVICE_ACCESS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ConnectMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ConnectMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ConnectMode>() {
          public ConnectMode findValueByNumber(int number) {
            return ConnectMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.redis.v1.Instance.getDescriptor().getEnumTypes().get(2);
    }

    private static final ConnectMode[] VALUES = values();

    public static ConnectMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ConnectMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.redis.v1.Instance.ConnectMode)
  }

  /**
   *
   *
   * <pre>
   * Available TLS modes.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.redis.v1.Instance.TransitEncryptionMode}
   */
  public enum TransitEncryptionMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>TRANSIT_ENCRYPTION_MODE_UNSPECIFIED = 0;</code>
     */
    TRANSIT_ENCRYPTION_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Client to Server traffic encryption enabled with server authentication.
     * </pre>
     *
     * <code>SERVER_AUTHENTICATION = 1;</code>
     */
    SERVER_AUTHENTICATION(1),
    /**
     *
     *
     * <pre>
     * TLS is disabled for the instance.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    DISABLED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>TRANSIT_ENCRYPTION_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int TRANSIT_ENCRYPTION_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Client to Server traffic encryption enabled with server authentication.
     * </pre>
     *
     * <code>SERVER_AUTHENTICATION = 1;</code>
     */
    public static final int SERVER_AUTHENTICATION_VALUE = 1;
    /**
     *
     *
     * <pre>
     * TLS is disabled for the instance.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    public static final int DISABLED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TransitEncryptionMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TransitEncryptionMode forNumber(int value) {
      switch (value) {
        case 0:
          return TRANSIT_ENCRYPTION_MODE_UNSPECIFIED;
        case 1:
          return SERVER_AUTHENTICATION;
        case 2:
          return DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TransitEncryptionMode>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TransitEncryptionMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<TransitEncryptionMode>() {
              public TransitEncryptionMode findValueByNumber(int number) {
                return TransitEncryptionMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.redis.v1.Instance.getDescriptor().getEnumTypes().get(3);
    }

    private static final TransitEncryptionMode[] VALUES = values();

    public static TransitEncryptionMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TransitEncryptionMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.redis.v1.Instance.TransitEncryptionMode)
  }

  /**
   *
   *
   * <pre>
   * Read replicas mode.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.redis.v1.Instance.ReadReplicasMode}
   */
  public enum ReadReplicasMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * If not set, Memorystore Redis backend will default to
     * READ_REPLICAS_DISABLED.
     * </pre>
     *
     * <code>READ_REPLICAS_MODE_UNSPECIFIED = 0;</code>
     */
    READ_REPLICAS_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * If disabled, read endpoint will not be provided and the instance cannot
     * scale up or down the number of replicas.
     * </pre>
     *
     * <code>READ_REPLICAS_DISABLED = 1;</code>
     */
    READ_REPLICAS_DISABLED(1),
    /**
     *
     *
     * <pre>
     * If enabled, read endpoint will be provided and the instance can scale
     * up and down the number of replicas. Not valid for basic tier.
     * </pre>
     *
     * <code>READ_REPLICAS_ENABLED = 2;</code>
     */
    READ_REPLICAS_ENABLED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * If not set, Memorystore Redis backend will default to
     * READ_REPLICAS_DISABLED.
     * </pre>
     *
     * <code>READ_REPLICAS_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int READ_REPLICAS_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * If disabled, read endpoint will not be provided and the instance cannot
     * scale up or down the number of replicas.
     * </pre>
     *
     * <code>READ_REPLICAS_DISABLED = 1;</code>
     */
    public static final int READ_REPLICAS_DISABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * If enabled, read endpoint will be provided and the instance can scale
     * up and down the number of replicas. Not valid for basic tier.
     * </pre>
     *
     * <code>READ_REPLICAS_ENABLED = 2;</code>
     */
    public static final int READ_REPLICAS_ENABLED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ReadReplicasMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ReadReplicasMode forNumber(int value) {
      switch (value) {
        case 0:
          return READ_REPLICAS_MODE_UNSPECIFIED;
        case 1:
          return READ_REPLICAS_DISABLED;
        case 2:
          return READ_REPLICAS_ENABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ReadReplicasMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ReadReplicasMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ReadReplicasMode>() {
              public ReadReplicasMode findValueByNumber(int number) {
                return ReadReplicasMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.redis.v1.Instance.getDescriptor().getEnumTypes().get(4);
    }

    private static final ReadReplicasMode[] VALUES = values();

    public static ReadReplicasMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ReadReplicasMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.redis.v1.Instance.ReadReplicasMode)
  }

  /**
   *
   *
   * <pre>
   * Possible reasons for the instance to be in a "SUSPENDED" state.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.redis.v1.Instance.SuspensionReason}
   */
  public enum SuspensionReason implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>SUSPENSION_REASON_UNSPECIFIED = 0;</code>
     */
    SUSPENSION_REASON_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Something wrong with the CMEK key provided by customer.
     * </pre>
     *
     * <code>CUSTOMER_MANAGED_KEY_ISSUE = 1;</code>
     */
    CUSTOMER_MANAGED_KEY_ISSUE(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>SUSPENSION_REASON_UNSPECIFIED = 0;</code>
     */
    public static final int SUSPENSION_REASON_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Something wrong with the CMEK key provided by customer.
     * </pre>
     *
     * <code>CUSTOMER_MANAGED_KEY_ISSUE = 1;</code>
     */
    public static final int CUSTOMER_MANAGED_KEY_ISSUE_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SuspensionReason valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SuspensionReason forNumber(int value) {
      switch (value) {
        case 0:
          return SUSPENSION_REASON_UNSPECIFIED;
        case 1:
          return CUSTOMER_MANAGED_KEY_ISSUE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SuspensionReason> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SuspensionReason>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<SuspensionReason>() {
              public SuspensionReason findValueByNumber(int number) {
                return SuspensionReason.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.redis.v1.Instance.getDescriptor().getEnumTypes().get(5);
    }

    private static final SuspensionReason[] VALUES = values();

    public static SuspensionReason valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SuspensionReason(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.redis.v1.Instance.SuspensionReason)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. Unique name of the resource in this scope including project and
   * location using the form:
   *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
   *
   * Note: Redis instances are managed and addressed at regional level so
   * location_id here refers to a GCP region; however, users may choose which
   * specific zone (or collection of zones for cross-zone instances) an instance
   * should be provisioned in. Refer to
   * [location_id][google.cloud.redis.v1.Instance.location_id] and
   * [alternative_location_id][google.cloud.redis.v1.Instance.alternative_location_id]
   * fields for more details.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Unique name of the resource in this scope including project and
   * location using the form:
   *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
   *
   * Note: Redis instances are managed and addressed at regional level so
   * location_id here refers to a GCP region; however, users may choose which
   * specific zone (or collection of zones for cross-zone instances) an instance
   * should be provisioned in. Refer to
   * [location_id][google.cloud.redis.v1.Instance.location_id] and
   * [alternative_location_id][google.cloud.redis.v1.Instance.alternative_location_id]
   * fields for more details.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * An arbitrary and optional user-provided name for the instance.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An arbitrary and optional user-provided name for the instance.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 3;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.redis.v1.CloudRedisServiceV1Proto
                .internal_static_google_cloud_redis_v1_Instance_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Resource labels to represent user provided metadata
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Resource labels to represent user provided metadata
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Resource labels to represent user provided metadata
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Resource labels to represent user provided metadata
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int LOCATION_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object locationId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The zone where the instance will be provisioned. If not provided,
   * the service will choose a zone from the specified region for the instance.
   * For standard tier, additional nodes will be added across multiple zones for
   * protection against zonal failures. If specified, at least one node will be
   * provisioned in this zone.
   * </pre>
   *
   * <code>string location_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The locationId.
   */
  @java.lang.Override
  public java.lang.String getLocationId() {
    java.lang.Object ref = locationId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      locationId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The zone where the instance will be provisioned. If not provided,
   * the service will choose a zone from the specified region for the instance.
   * For standard tier, additional nodes will be added across multiple zones for
   * protection against zonal failures. If specified, at least one node will be
   * provisioned in this zone.
   * </pre>
   *
   * <code>string location_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for locationId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationIdBytes() {
    java.lang.Object ref = locationId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      locationId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ALTERNATIVE_LOCATION_ID_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object alternativeLocationId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. If specified, at least one node will be provisioned in this zone
   * in addition to the zone specified in location_id. Only applicable to
   * standard tier. If provided, it must be a different zone from the one
   * provided in [location_id]. Additional nodes beyond the first 2 will be
   * placed in zones selected by the service.
   * </pre>
   *
   * <code>string alternative_location_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The alternativeLocationId.
   */
  @java.lang.Override
  public java.lang.String getAlternativeLocationId() {
    java.lang.Object ref = alternativeLocationId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      alternativeLocationId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. If specified, at least one node will be provisioned in this zone
   * in addition to the zone specified in location_id. Only applicable to
   * standard tier. If provided, it must be a different zone from the one
   * provided in [location_id]. Additional nodes beyond the first 2 will be
   * placed in zones selected by the service.
   * </pre>
   *
   * <code>string alternative_location_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for alternativeLocationId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAlternativeLocationIdBytes() {
    java.lang.Object ref = alternativeLocationId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      alternativeLocationId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REDIS_VERSION_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object redisVersion_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The version of Redis software.
   * If not provided, latest supported version will be used. Currently, the
   * supported values are:
   *
   *  *   `REDIS_3_2` for Redis 3.2 compatibility
   *  *   `REDIS_4_0` for Redis 4.0 compatibility (default)
   *  *   `REDIS_5_0` for Redis 5.0 compatibility
   *  *   `REDIS_6_X` for Redis 6.x compatibility
   * </pre>
   *
   * <code>string redis_version = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The redisVersion.
   */
  @java.lang.Override
  public java.lang.String getRedisVersion() {
    java.lang.Object ref = redisVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      redisVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The version of Redis software.
   * If not provided, latest supported version will be used. Currently, the
   * supported values are:
   *
   *  *   `REDIS_3_2` for Redis 3.2 compatibility
   *  *   `REDIS_4_0` for Redis 4.0 compatibility (default)
   *  *   `REDIS_5_0` for Redis 5.0 compatibility
   *  *   `REDIS_6_X` for Redis 6.x compatibility
   * </pre>
   *
   * <code>string redis_version = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for redisVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRedisVersionBytes() {
    java.lang.Object ref = redisVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      redisVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESERVED_IP_RANGE_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object reservedIpRange_ = "";
  /**
   *
   *
   * <pre>
   * Optional. For DIRECT_PEERING mode, the CIDR range of internal addresses
   * that are reserved for this instance. Range must
   * be unique and non-overlapping with existing subnets in an authorized
   * network. For PRIVATE_SERVICE_ACCESS mode, the name of one allocated IP
   * address ranges associated with this private service access connection.
   * If not provided, the service will choose an unused /29 block, for
   * example, 10.0.0.0/29 or 192.168.0.0/29.  For READ_REPLICAS_ENABLED
   * the default block size is /28.
   * </pre>
   *
   * <code>string reserved_ip_range = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The reservedIpRange.
   */
  @java.lang.Override
  public java.lang.String getReservedIpRange() {
    java.lang.Object ref = reservedIpRange_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      reservedIpRange_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. For DIRECT_PEERING mode, the CIDR range of internal addresses
   * that are reserved for this instance. Range must
   * be unique and non-overlapping with existing subnets in an authorized
   * network. For PRIVATE_SERVICE_ACCESS mode, the name of one allocated IP
   * address ranges associated with this private service access connection.
   * If not provided, the service will choose an unused /29 block, for
   * example, 10.0.0.0/29 or 192.168.0.0/29.  For READ_REPLICAS_ENABLED
   * the default block size is /28.
   * </pre>
   *
   * <code>string reserved_ip_range = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for reservedIpRange.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getReservedIpRangeBytes() {
    java.lang.Object ref = reservedIpRange_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      reservedIpRange_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SECONDARY_IP_RANGE_FIELD_NUMBER = 30;

  @SuppressWarnings("serial")
  private volatile java.lang.Object secondaryIpRange_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Additional IP range for node placement. Required when enabling
   * read replicas on an existing instance. For DIRECT_PEERING mode value must
   * be a CIDR range of size /28, or "auto". For PRIVATE_SERVICE_ACCESS mode
   * value must be the name of an allocated address range associated with the
   * private service access connection, or "auto".
   * </pre>
   *
   * <code>string secondary_ip_range = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The secondaryIpRange.
   */
  @java.lang.Override
  public java.lang.String getSecondaryIpRange() {
    java.lang.Object ref = secondaryIpRange_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      secondaryIpRange_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Additional IP range for node placement. Required when enabling
   * read replicas on an existing instance. For DIRECT_PEERING mode value must
   * be a CIDR range of size /28, or "auto". For PRIVATE_SERVICE_ACCESS mode
   * value must be the name of an allocated address range associated with the
   * private service access connection, or "auto".
   * </pre>
   *
   * <code>string secondary_ip_range = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for secondaryIpRange.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSecondaryIpRangeBytes() {
    java.lang.Object ref = secondaryIpRange_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      secondaryIpRange_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HOST_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object host_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Hostname or IP address of the exposed Redis endpoint used by
   * clients to connect to the service.
   * </pre>
   *
   * <code>string host = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The host.
   */
  @java.lang.Override
  public java.lang.String getHost() {
    java.lang.Object ref = host_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      host_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Hostname or IP address of the exposed Redis endpoint used by
   * clients to connect to the service.
   * </pre>
   *
   * <code>string host = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for host.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHostBytes() {
    java.lang.Object ref = host_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      host_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PORT_FIELD_NUMBER = 11;
  private int port_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The port number of the exposed Redis endpoint.
   * </pre>
   *
   * <code>int32 port = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The port.
   */
  @java.lang.Override
  public int getPort() {
    return port_;
  }

  public static final int CURRENT_LOCATION_ID_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object currentLocationId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The current zone where the Redis primary node is located. In
   * basic tier, this will always be the same as [location_id]. In
   * standard tier, this can be the zone of any node in the instance.
   * </pre>
   *
   * <code>string current_location_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The currentLocationId.
   */
  @java.lang.Override
  public java.lang.String getCurrentLocationId() {
    java.lang.Object ref = currentLocationId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      currentLocationId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The current zone where the Redis primary node is located. In
   * basic tier, this will always be the same as [location_id]. In
   * standard tier, this can be the zone of any node in the instance.
   * </pre>
   *
   * <code>string current_location_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for currentLocationId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCurrentLocationIdBytes() {
    java.lang.Object ref = currentLocationId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      currentLocationId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 13;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int STATE_FIELD_NUMBER = 14;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The current state of this instance.
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1.Instance.State state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state of this instance.
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1.Instance.State state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.redis.v1.Instance.State getState() {
    com.google.cloud.redis.v1.Instance.State result =
        com.google.cloud.redis.v1.Instance.State.forNumber(state_);
    return result == null ? com.google.cloud.redis.v1.Instance.State.UNRECOGNIZED : result;
  }

  public static final int STATUS_MESSAGE_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private volatile java.lang.Object statusMessage_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Additional information about the current status of this
   * instance, if available.
   * </pre>
   *
   * <code>string status_message = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The statusMessage.
   */
  @java.lang.Override
  public java.lang.String getStatusMessage() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      statusMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional information about the current status of this
   * instance, if available.
   * </pre>
   *
   * <code>string status_message = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for statusMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusMessageBytes() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      statusMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REDIS_CONFIGS_FIELD_NUMBER = 16;

  private static final class RedisConfigsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.redis.v1.CloudRedisServiceV1Proto
                .internal_static_google_cloud_redis_v1_Instance_RedisConfigsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> redisConfigs_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetRedisConfigs() {
    if (redisConfigs_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          RedisConfigsDefaultEntryHolder.defaultEntry);
    }
    return redisConfigs_;
  }

  public int getRedisConfigsCount() {
    return internalGetRedisConfigs().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Redis configuration parameters, according to
   * http://redis.io/topics/config. Currently, the only supported parameters
   * are:
   *
   *  Redis version 3.2 and newer:
   *
   *  *   maxmemory-policy
   *  *   notify-keyspace-events
   *
   *  Redis version 4.0 and newer:
   *
   *  *   activedefrag
   *  *   lfu-decay-time
   *  *   lfu-log-factor
   *  *   maxmemory-gb
   *
   *  Redis version 5.0 and newer:
   *
   *  *   stream-node-max-bytes
   *  *   stream-node-max-entries
   * </pre>
   *
   * <code>map&lt;string, string&gt; redis_configs = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsRedisConfigs(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetRedisConfigs().getMap().containsKey(key);
  }
  /** Use {@link #getRedisConfigsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getRedisConfigs() {
    return getRedisConfigsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Redis configuration parameters, according to
   * http://redis.io/topics/config. Currently, the only supported parameters
   * are:
   *
   *  Redis version 3.2 and newer:
   *
   *  *   maxmemory-policy
   *  *   notify-keyspace-events
   *
   *  Redis version 4.0 and newer:
   *
   *  *   activedefrag
   *  *   lfu-decay-time
   *  *   lfu-log-factor
   *  *   maxmemory-gb
   *
   *  Redis version 5.0 and newer:
   *
   *  *   stream-node-max-bytes
   *  *   stream-node-max-entries
   * </pre>
   *
   * <code>map&lt;string, string&gt; redis_configs = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getRedisConfigsMap() {
    return internalGetRedisConfigs().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Redis configuration parameters, according to
   * http://redis.io/topics/config. Currently, the only supported parameters
   * are:
   *
   *  Redis version 3.2 and newer:
   *
   *  *   maxmemory-policy
   *  *   notify-keyspace-events
   *
   *  Redis version 4.0 and newer:
   *
   *  *   activedefrag
   *  *   lfu-decay-time
   *  *   lfu-log-factor
   *  *   maxmemory-gb
   *
   *  Redis version 5.0 and newer:
   *
   *  *   stream-node-max-bytes
   *  *   stream-node-max-entries
   * </pre>
   *
   * <code>map&lt;string, string&gt; redis_configs = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getRedisConfigsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetRedisConfigs().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Redis configuration parameters, according to
   * http://redis.io/topics/config. Currently, the only supported parameters
   * are:
   *
   *  Redis version 3.2 and newer:
   *
   *  *   maxmemory-policy
   *  *   notify-keyspace-events
   *
   *  Redis version 4.0 and newer:
   *
   *  *   activedefrag
   *  *   lfu-decay-time
   *  *   lfu-log-factor
   *  *   maxmemory-gb
   *
   *  Redis version 5.0 and newer:
   *
   *  *   stream-node-max-bytes
   *  *   stream-node-max-entries
   * </pre>
   *
   * <code>map&lt;string, string&gt; redis_configs = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getRedisConfigsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetRedisConfigs().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int TIER_FIELD_NUMBER = 17;
  private int tier_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The service tier of the instance.
   * </pre>
   *
   * <code>.google.cloud.redis.v1.Instance.Tier tier = 17 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for tier.
   */
  @java.lang.Override
  public int getTierValue() {
    return tier_;
  }
  /**
   *
   *
   * <pre>
   * Required. The service tier of the instance.
   * </pre>
   *
   * <code>.google.cloud.redis.v1.Instance.Tier tier = 17 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The tier.
   */
  @java.lang.Override
  public com.google.cloud.redis.v1.Instance.Tier getTier() {
    com.google.cloud.redis.v1.Instance.Tier result =
        com.google.cloud.redis.v1.Instance.Tier.forNumber(tier_);
    return result == null ? com.google.cloud.redis.v1.Instance.Tier.UNRECOGNIZED : result;
  }

  public static final int MEMORY_SIZE_GB_FIELD_NUMBER = 18;
  private int memorySizeGb_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Redis memory size in GiB.
   * </pre>
   *
   * <code>int32 memory_size_gb = 18 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The memorySizeGb.
   */
  @java.lang.Override
  public int getMemorySizeGb() {
    return memorySizeGb_;
  }

  public static final int AUTHORIZED_NETWORK_FIELD_NUMBER = 20;

  @SuppressWarnings("serial")
  private volatile java.lang.Object authorizedNetwork_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The full name of the Google Compute Engine
   * [network](https://cloud.google.com/vpc/docs/vpc) to which the
   * instance is connected. If left unspecified, the `default` network
   * will be used.
   * </pre>
   *
   * <code>string authorized_network = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The authorizedNetwork.
   */
  @java.lang.Override
  public java.lang.String getAuthorizedNetwork() {
    java.lang.Object ref = authorizedNetwork_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      authorizedNetwork_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The full name of the Google Compute Engine
   * [network](https://cloud.google.com/vpc/docs/vpc) to which the
   * instance is connected. If left unspecified, the `default` network
   * will be used.
   * </pre>
   *
   * <code>string authorized_network = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for authorizedNetwork.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAuthorizedNetworkBytes() {
    java.lang.Object ref = authorizedNetwork_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      authorizedNetwork_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PERSISTENCE_IAM_IDENTITY_FIELD_NUMBER = 21;

  @SuppressWarnings("serial")
  private volatile java.lang.Object persistenceIamIdentity_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Cloud IAM identity used by import / export operations to
   * transfer data to/from Cloud Storage. Format is
   * "serviceAccount:&lt;service_account_email&gt;". The value may change over time
   * for a given instance so should be checked before each import/export
   * operation.
   * </pre>
   *
   * <code>string persistence_iam_identity = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The persistenceIamIdentity.
   */
  @java.lang.Override
  public java.lang.String getPersistenceIamIdentity() {
    java.lang.Object ref = persistenceIamIdentity_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      persistenceIamIdentity_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Cloud IAM identity used by import / export operations to
   * transfer data to/from Cloud Storage. Format is
   * "serviceAccount:&lt;service_account_email&gt;". The value may change over time
   * for a given instance so should be checked before each import/export
   * operation.
   * </pre>
   *
   * <code>string persistence_iam_identity = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for persistenceIamIdentity.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPersistenceIamIdentityBytes() {
    java.lang.Object ref = persistenceIamIdentity_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      persistenceIamIdentity_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONNECT_MODE_FIELD_NUMBER = 22;
  private int connectMode_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The network connect mode of the Redis instance.
   * If not provided, the connect mode defaults to DIRECT_PEERING.
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1.Instance.ConnectMode connect_mode = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for connectMode.
   */
  @java.lang.Override
  public int getConnectModeValue() {
    return connectMode_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The network connect mode of the Redis instance.
   * If not provided, the connect mode defaults to DIRECT_PEERING.
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1.Instance.ConnectMode connect_mode = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The connectMode.
   */
  @java.lang.Override
  public com.google.cloud.redis.v1.Instance.ConnectMode getConnectMode() {
    com.google.cloud.redis.v1.Instance.ConnectMode result =
        com.google.cloud.redis.v1.Instance.ConnectMode.forNumber(connectMode_);
    return result == null ? com.google.cloud.redis.v1.Instance.ConnectMode.UNRECOGNIZED : result;
  }

  public static final int AUTH_ENABLED_FIELD_NUMBER = 23;
  private boolean authEnabled_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Indicates whether OSS Redis AUTH is enabled for the instance. If
   * set to "true" AUTH is enabled on the instance. Default value is "false"
   * meaning AUTH is disabled.
   * </pre>
   *
   * <code>bool auth_enabled = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The authEnabled.
   */
  @java.lang.Override
  public boolean getAuthEnabled() {
    return authEnabled_;
  }

  public static final int SERVER_CA_CERTS_FIELD_NUMBER = 25;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.redis.v1.TlsCertificate> serverCaCerts_;
  /**
   *
   *
   * <pre>
   * Output only. List of server CA certificates for the instance.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.redis.v1.TlsCertificate server_ca_certs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.redis.v1.TlsCertificate> getServerCaCertsList() {
    return serverCaCerts_;
  }
  /**
   *
   *
   * <pre>
   * Output only. List of server CA certificates for the instance.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.redis.v1.TlsCertificate server_ca_certs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.redis.v1.TlsCertificateOrBuilder>
      getServerCaCertsOrBuilderList() {
    return serverCaCerts_;
  }
  /**
   *
   *
   * <pre>
   * Output only. List of server CA certificates for the instance.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.redis.v1.TlsCertificate server_ca_certs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getServerCaCertsCount() {
    return serverCaCerts_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. List of server CA certificates for the instance.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.redis.v1.TlsCertificate server_ca_certs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.redis.v1.TlsCertificate getServerCaCerts(int index) {
    return serverCaCerts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. List of server CA certificates for the instance.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.redis.v1.TlsCertificate server_ca_certs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.redis.v1.TlsCertificateOrBuilder getServerCaCertsOrBuilder(int index) {
    return serverCaCerts_.get(index);
  }

  public static final int TRANSIT_ENCRYPTION_MODE_FIELD_NUMBER = 26;
  private int transitEncryptionMode_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The TLS mode of the Redis instance.
   * If not provided, TLS is disabled for the instance.
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1.Instance.TransitEncryptionMode transit_encryption_mode = 26 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for transitEncryptionMode.
   */
  @java.lang.Override
  public int getTransitEncryptionModeValue() {
    return transitEncryptionMode_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The TLS mode of the Redis instance.
   * If not provided, TLS is disabled for the instance.
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1.Instance.TransitEncryptionMode transit_encryption_mode = 26 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The transitEncryptionMode.
   */
  @java.lang.Override
  public com.google.cloud.redis.v1.Instance.TransitEncryptionMode getTransitEncryptionMode() {
    com.google.cloud.redis.v1.Instance.TransitEncryptionMode result =
        com.google.cloud.redis.v1.Instance.TransitEncryptionMode.forNumber(transitEncryptionMode_);
    return result == null
        ? com.google.cloud.redis.v1.Instance.TransitEncryptionMode.UNRECOGNIZED
        : result;
  }

  public static final int MAINTENANCE_POLICY_FIELD_NUMBER = 27;
  private com.google.cloud.redis.v1.MaintenancePolicy maintenancePolicy_;
  /**
   *
   *
   * <pre>
   * Optional. The maintenance policy for the instance. If not provided,
   * maintenance events can be performed at any time.
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1.MaintenancePolicy maintenance_policy = 27 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the maintenancePolicy field is set.
   */
  @java.lang.Override
  public boolean hasMaintenancePolicy() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The maintenance policy for the instance. If not provided,
   * maintenance events can be performed at any time.
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1.MaintenancePolicy maintenance_policy = 27 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The maintenancePolicy.
   */
  @java.lang.Override
  public com.google.cloud.redis.v1.MaintenancePolicy getMaintenancePolicy() {
    return maintenancePolicy_ == null
        ? com.google.cloud.redis.v1.MaintenancePolicy.getDefaultInstance()
        : maintenancePolicy_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The maintenance policy for the instance. If not provided,
   * maintenance events can be performed at any time.
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1.MaintenancePolicy maintenance_policy = 27 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.redis.v1.MaintenancePolicyOrBuilder getMaintenancePolicyOrBuilder() {
    return maintenancePolicy_ == null
        ? com.google.cloud.redis.v1.MaintenancePolicy.getDefaultInstance()
        : maintenancePolicy_;
  }

  public static final int MAINTENANCE_SCHEDULE_FIELD_NUMBER = 28;
  private com.google.cloud.redis.v1.MaintenanceSchedule maintenanceSchedule_;
  /**
   *
   *
   * <pre>
   * Output only. Date and time of upcoming maintenance events which have been
   * scheduled.
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1.MaintenanceSchedule maintenance_schedule = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the maintenanceSchedule field is set.
   */
  @java.lang.Override
  public boolean hasMaintenanceSchedule() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Date and time of upcoming maintenance events which have been
   * scheduled.
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1.MaintenanceSchedule maintenance_schedule = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The maintenanceSchedule.
   */
  @java.lang.Override
  public com.google.cloud.redis.v1.MaintenanceSchedule getMaintenanceSchedule() {
    return maintenanceSchedule_ == null
        ? com.google.cloud.redis.v1.MaintenanceSchedule.getDefaultInstance()
        : maintenanceSchedule_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Date and time of upcoming maintenance events which have been
   * scheduled.
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1.MaintenanceSchedule maintenance_schedule = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.redis.v1.MaintenanceScheduleOrBuilder getMaintenanceScheduleOrBuilder() {
    return maintenanceSchedule_ == null
        ? com.google.cloud.redis.v1.MaintenanceSchedule.getDefaultInstance()
        : maintenanceSchedule_;
  }

  public static final int REPLICA_COUNT_FIELD_NUMBER = 31;
  private int replicaCount_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The number of replica nodes. The valid range for the Standard
   * Tier with read replicas enabled is [1-5] and defaults to 2. If read
   * replicas are not enabled for a Standard Tier instance, the only valid value
   * is 1 and the default is 1. The valid value for basic tier is 0 and the
   * default is also 0.
   * </pre>
   *
   * <code>int32 replica_count = 31 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The replicaCount.
   */
  @java.lang.Override
  public int getReplicaCount() {
    return replicaCount_;
  }

  public static final int NODES_FIELD_NUMBER = 32;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.redis.v1.NodeInfo> nodes_;
  /**
   *
   *
   * <pre>
   * Output only. Info per node.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.redis.v1.NodeInfo nodes = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.redis.v1.NodeInfo> getNodesList() {
    return nodes_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Info per node.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.redis.v1.NodeInfo nodes = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.redis.v1.NodeInfoOrBuilder>
      getNodesOrBuilderList() {
    return nodes_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Info per node.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.redis.v1.NodeInfo nodes = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getNodesCount() {
    return nodes_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Info per node.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.redis.v1.NodeInfo nodes = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.redis.v1.NodeInfo getNodes(int index) {
    return nodes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Info per node.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.redis.v1.NodeInfo nodes = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.redis.v1.NodeInfoOrBuilder getNodesOrBuilder(int index) {
    return nodes_.get(index);
  }

  public static final int READ_ENDPOINT_FIELD_NUMBER = 33;

  @SuppressWarnings("serial")
  private volatile java.lang.Object readEndpoint_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Hostname or IP address of the exposed readonly Redis
   * endpoint. Standard tier only. Targets all healthy replica nodes in
   * instance. Replication is asynchronous and replica nodes will exhibit some
   * lag behind the primary. Write requests must target 'host'.
   * </pre>
   *
   * <code>string read_endpoint = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The readEndpoint.
   */
  @java.lang.Override
  public java.lang.String getReadEndpoint() {
    java.lang.Object ref = readEndpoint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      readEndpoint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Hostname or IP address of the exposed readonly Redis
   * endpoint. Standard tier only. Targets all healthy replica nodes in
   * instance. Replication is asynchronous and replica nodes will exhibit some
   * lag behind the primary. Write requests must target 'host'.
   * </pre>
   *
   * <code>string read_endpoint = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for readEndpoint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getReadEndpointBytes() {
    java.lang.Object ref = readEndpoint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      readEndpoint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int READ_ENDPOINT_PORT_FIELD_NUMBER = 34;
  private int readEndpointPort_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The port number of the exposed readonly redis
   * endpoint. Standard tier only. Write requests should target 'port'.
   * </pre>
   *
   * <code>int32 read_endpoint_port = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The readEndpointPort.
   */
  @java.lang.Override
  public int getReadEndpointPort() {
    return readEndpointPort_;
  }

  public static final int READ_REPLICAS_MODE_FIELD_NUMBER = 35;
  private int readReplicasMode_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Read replicas mode for the instance. Defaults to
   * READ_REPLICAS_DISABLED.
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1.Instance.ReadReplicasMode read_replicas_mode = 35 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for readReplicasMode.
   */
  @java.lang.Override
  public int getReadReplicasModeValue() {
    return readReplicasMode_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Read replicas mode for the instance. Defaults to
   * READ_REPLICAS_DISABLED.
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1.Instance.ReadReplicasMode read_replicas_mode = 35 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The readReplicasMode.
   */
  @java.lang.Override
  public com.google.cloud.redis.v1.Instance.ReadReplicasMode getReadReplicasMode() {
    com.google.cloud.redis.v1.Instance.ReadReplicasMode result =
        com.google.cloud.redis.v1.Instance.ReadReplicasMode.forNumber(readReplicasMode_);
    return result == null
        ? com.google.cloud.redis.v1.Instance.ReadReplicasMode.UNRECOGNIZED
        : result;
  }

  public static final int CUSTOMER_MANAGED_KEY_FIELD_NUMBER = 36;

  @SuppressWarnings("serial")
  private volatile java.lang.Object customerManagedKey_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The KMS key reference that the customer provides when trying to
   * create the instance.
   * </pre>
   *
   * <code>string customer_managed_key = 36 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The customerManagedKey.
   */
  @java.lang.Override
  public java.lang.String getCustomerManagedKey() {
    java.lang.Object ref = customerManagedKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      customerManagedKey_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The KMS key reference that the customer provides when trying to
   * create the instance.
   * </pre>
   *
   * <code>string customer_managed_key = 36 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for customerManagedKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCustomerManagedKeyBytes() {
    java.lang.Object ref = customerManagedKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      customerManagedKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PERSISTENCE_CONFIG_FIELD_NUMBER = 37;
  private com.google.cloud.redis.v1.PersistenceConfig persistenceConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Persistence configuration parameters
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1.PersistenceConfig persistence_config = 37 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the persistenceConfig field is set.
   */
  @java.lang.Override
  public boolean hasPersistenceConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Persistence configuration parameters
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1.PersistenceConfig persistence_config = 37 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The persistenceConfig.
   */
  @java.lang.Override
  public com.google.cloud.redis.v1.PersistenceConfig getPersistenceConfig() {
    return persistenceConfig_ == null
        ? com.google.cloud.redis.v1.PersistenceConfig.getDefaultInstance()
        : persistenceConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Persistence configuration parameters
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1.PersistenceConfig persistence_config = 37 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.redis.v1.PersistenceConfigOrBuilder getPersistenceConfigOrBuilder() {
    return persistenceConfig_ == null
        ? com.google.cloud.redis.v1.PersistenceConfig.getDefaultInstance()
        : persistenceConfig_;
  }

  public static final int SUSPENSION_REASONS_FIELD_NUMBER = 38;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> suspensionReasons_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.redis.v1.Instance.SuspensionReason>
      suspensionReasons_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.redis.v1.Instance.SuspensionReason>() {
            public com.google.cloud.redis.v1.Instance.SuspensionReason convert(
                java.lang.Integer from) {
              com.google.cloud.redis.v1.Instance.SuspensionReason result =
                  com.google.cloud.redis.v1.Instance.SuspensionReason.forNumber(from);
              return result == null
                  ? com.google.cloud.redis.v1.Instance.SuspensionReason.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Optional. reasons that causes instance in "SUSPENDED" state.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.redis.v1.Instance.SuspensionReason suspension_reasons = 38 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the suspensionReasons.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.redis.v1.Instance.SuspensionReason>
      getSuspensionReasonsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.redis.v1.Instance.SuspensionReason>(
        suspensionReasons_, suspensionReasons_converter_);
  }
  /**
   *
   *
   * <pre>
   * Optional. reasons that causes instance in "SUSPENDED" state.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.redis.v1.Instance.SuspensionReason suspension_reasons = 38 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of suspensionReasons.
   */
  @java.lang.Override
  public int getSuspensionReasonsCount() {
    return suspensionReasons_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. reasons that causes instance in "SUSPENDED" state.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.redis.v1.Instance.SuspensionReason suspension_reasons = 38 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The suspensionReasons at the given index.
   */
  @java.lang.Override
  public com.google.cloud.redis.v1.Instance.SuspensionReason getSuspensionReasons(int index) {
    return suspensionReasons_converter_.convert(suspensionReasons_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Optional. reasons that causes instance in "SUSPENDED" state.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.redis.v1.Instance.SuspensionReason suspension_reasons = 38 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for suspensionReasons.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getSuspensionReasonsValueList() {
    return suspensionReasons_;
  }
  /**
   *
   *
   * <pre>
   * Optional. reasons that causes instance in "SUSPENDED" state.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.redis.v1.Instance.SuspensionReason suspension_reasons = 38 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of suspensionReasons at the given index.
   */
  @java.lang.Override
  public int getSuspensionReasonsValue(int index) {
    return suspensionReasons_.get(index);
  }

  private int suspensionReasonsMemoizedSerializedSize;

  public static final int MAINTENANCE_VERSION_FIELD_NUMBER = 39;

  @SuppressWarnings("serial")
  private volatile java.lang.Object maintenanceVersion_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The self service update maintenance version.
   * The version is date based such as "20210712_00_00".
   * </pre>
   *
   * <code>string maintenance_version = 39 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The maintenanceVersion.
   */
  @java.lang.Override
  public java.lang.String getMaintenanceVersion() {
    java.lang.Object ref = maintenanceVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      maintenanceVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The self service update maintenance version.
   * The version is date based such as "20210712_00_00".
   * </pre>
   *
   * <code>string maintenance_version = 39 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for maintenanceVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMaintenanceVersionBytes() {
    java.lang.Object ref = maintenanceVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      maintenanceVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AVAILABLE_MAINTENANCE_VERSIONS_FIELD_NUMBER = 40;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList availableMaintenanceVersions_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. The available maintenance versions that an instance could update
   * to.
   * </pre>
   *
   * <code>
   * repeated string available_maintenance_versions = 40 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the availableMaintenanceVersions.
   */
  public com.google.protobuf.ProtocolStringList getAvailableMaintenanceVersionsList() {
    return availableMaintenanceVersions_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The available maintenance versions that an instance could update
   * to.
   * </pre>
   *
   * <code>
   * repeated string available_maintenance_versions = 40 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of availableMaintenanceVersions.
   */
  public int getAvailableMaintenanceVersionsCount() {
    return availableMaintenanceVersions_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The available maintenance versions that an instance could update
   * to.
   * </pre>
   *
   * <code>
   * repeated string available_maintenance_versions = 40 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The availableMaintenanceVersions at the given index.
   */
  public java.lang.String getAvailableMaintenanceVersions(int index) {
    return availableMaintenanceVersions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The available maintenance versions that an instance could update
   * to.
   * </pre>
   *
   * <code>
   * repeated string available_maintenance_versions = 40 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the availableMaintenanceVersions at the given index.
   */
  public com.google.protobuf.ByteString getAvailableMaintenanceVersionsBytes(int index) {
    return availableMaintenanceVersions_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 3);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locationId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, locationId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(alternativeLocationId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, alternativeLocationId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(redisVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, redisVersion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(reservedIpRange_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, reservedIpRange_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(host_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, host_);
    }
    if (port_ != 0) {
      output.writeInt32(11, port_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(currentLocationId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, currentLocationId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(13, getCreateTime());
    }
    if (state_ != com.google.cloud.redis.v1.Instance.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(14, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statusMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, statusMessage_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetRedisConfigs(), RedisConfigsDefaultEntryHolder.defaultEntry, 16);
    if (tier_ != com.google.cloud.redis.v1.Instance.Tier.TIER_UNSPECIFIED.getNumber()) {
      output.writeEnum(17, tier_);
    }
    if (memorySizeGb_ != 0) {
      output.writeInt32(18, memorySizeGb_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(authorizedNetwork_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 20, authorizedNetwork_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(persistenceIamIdentity_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 21, persistenceIamIdentity_);
    }
    if (connectMode_
        != com.google.cloud.redis.v1.Instance.ConnectMode.CONNECT_MODE_UNSPECIFIED.getNumber()) {
      output.writeEnum(22, connectMode_);
    }
    if (authEnabled_ != false) {
      output.writeBool(23, authEnabled_);
    }
    for (int i = 0; i < serverCaCerts_.size(); i++) {
      output.writeMessage(25, serverCaCerts_.get(i));
    }
    if (transitEncryptionMode_
        != com.google.cloud.redis.v1.Instance.TransitEncryptionMode
            .TRANSIT_ENCRYPTION_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(26, transitEncryptionMode_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(27, getMaintenancePolicy());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(28, getMaintenanceSchedule());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(secondaryIpRange_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30, secondaryIpRange_);
    }
    if (replicaCount_ != 0) {
      output.writeInt32(31, replicaCount_);
    }
    for (int i = 0; i < nodes_.size(); i++) {
      output.writeMessage(32, nodes_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(readEndpoint_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 33, readEndpoint_);
    }
    if (readEndpointPort_ != 0) {
      output.writeInt32(34, readEndpointPort_);
    }
    if (readReplicasMode_
        != com.google.cloud.redis.v1.Instance.ReadReplicasMode.READ_REPLICAS_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(35, readReplicasMode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(customerManagedKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 36, customerManagedKey_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(37, getPersistenceConfig());
    }
    if (getSuspensionReasonsList().size() > 0) {
      output.writeUInt32NoTag(306);
      output.writeUInt32NoTag(suspensionReasonsMemoizedSerializedSize);
    }
    for (int i = 0; i < suspensionReasons_.size(); i++) {
      output.writeEnumNoTag(suspensionReasons_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(maintenanceVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 39, maintenanceVersion_);
    }
    for (int i = 0; i < availableMaintenanceVersions_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 40, availableMaintenanceVersions_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locationId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, locationId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(alternativeLocationId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, alternativeLocationId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(redisVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, redisVersion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(reservedIpRange_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, reservedIpRange_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(host_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, host_);
    }
    if (port_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(11, port_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(currentLocationId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, currentLocationId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getCreateTime());
    }
    if (state_ != com.google.cloud.redis.v1.Instance.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(14, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statusMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, statusMessage_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetRedisConfigs().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> redisConfigs__ =
          RedisConfigsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, redisConfigs__);
    }
    if (tier_ != com.google.cloud.redis.v1.Instance.Tier.TIER_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(17, tier_);
    }
    if (memorySizeGb_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(18, memorySizeGb_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(authorizedNetwork_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(20, authorizedNetwork_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(persistenceIamIdentity_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(21, persistenceIamIdentity_);
    }
    if (connectMode_
        != com.google.cloud.redis.v1.Instance.ConnectMode.CONNECT_MODE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(22, connectMode_);
    }
    if (authEnabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(23, authEnabled_);
    }
    for (int i = 0; i < serverCaCerts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(25, serverCaCerts_.get(i));
    }
    if (transitEncryptionMode_
        != com.google.cloud.redis.v1.Instance.TransitEncryptionMode
            .TRANSIT_ENCRYPTION_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(26, transitEncryptionMode_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(27, getMaintenancePolicy());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(28, getMaintenanceSchedule());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(secondaryIpRange_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(30, secondaryIpRange_);
    }
    if (replicaCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(31, replicaCount_);
    }
    for (int i = 0; i < nodes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(32, nodes_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(readEndpoint_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(33, readEndpoint_);
    }
    if (readEndpointPort_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(34, readEndpointPort_);
    }
    if (readReplicasMode_
        != com.google.cloud.redis.v1.Instance.ReadReplicasMode.READ_REPLICAS_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(35, readReplicasMode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(customerManagedKey_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(36, customerManagedKey_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(37, getPersistenceConfig());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < suspensionReasons_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(suspensionReasons_.get(i));
      }
      size += dataSize;
      if (!getSuspensionReasonsList().isEmpty()) {
        size += 2;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      suspensionReasonsMemoizedSerializedSize = dataSize;
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(maintenanceVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(39, maintenanceVersion_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < availableMaintenanceVersions_.size(); i++) {
        dataSize += computeStringSizeNoTag(availableMaintenanceVersions_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getAvailableMaintenanceVersionsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.redis.v1.Instance)) {
      return super.equals(obj);
    }
    com.google.cloud.redis.v1.Instance other = (com.google.cloud.redis.v1.Instance) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getLocationId().equals(other.getLocationId())) return false;
    if (!getAlternativeLocationId().equals(other.getAlternativeLocationId())) return false;
    if (!getRedisVersion().equals(other.getRedisVersion())) return false;
    if (!getReservedIpRange().equals(other.getReservedIpRange())) return false;
    if (!getSecondaryIpRange().equals(other.getSecondaryIpRange())) return false;
    if (!getHost().equals(other.getHost())) return false;
    if (getPort() != other.getPort()) return false;
    if (!getCurrentLocationId().equals(other.getCurrentLocationId())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (state_ != other.state_) return false;
    if (!getStatusMessage().equals(other.getStatusMessage())) return false;
    if (!internalGetRedisConfigs().equals(other.internalGetRedisConfigs())) return false;
    if (tier_ != other.tier_) return false;
    if (getMemorySizeGb() != other.getMemorySizeGb()) return false;
    if (!getAuthorizedNetwork().equals(other.getAuthorizedNetwork())) return false;
    if (!getPersistenceIamIdentity().equals(other.getPersistenceIamIdentity())) return false;
    if (connectMode_ != other.connectMode_) return false;
    if (getAuthEnabled() != other.getAuthEnabled()) return false;
    if (!getServerCaCertsList().equals(other.getServerCaCertsList())) return false;
    if (transitEncryptionMode_ != other.transitEncryptionMode_) return false;
    if (hasMaintenancePolicy() != other.hasMaintenancePolicy()) return false;
    if (hasMaintenancePolicy()) {
      if (!getMaintenancePolicy().equals(other.getMaintenancePolicy())) return false;
    }
    if (hasMaintenanceSchedule() != other.hasMaintenanceSchedule()) return false;
    if (hasMaintenanceSchedule()) {
      if (!getMaintenanceSchedule().equals(other.getMaintenanceSchedule())) return false;
    }
    if (getReplicaCount() != other.getReplicaCount()) return false;
    if (!getNodesList().equals(other.getNodesList())) return false;
    if (!getReadEndpoint().equals(other.getReadEndpoint())) return false;
    if (getReadEndpointPort() != other.getReadEndpointPort()) return false;
    if (readReplicasMode_ != other.readReplicasMode_) return false;
    if (!getCustomerManagedKey().equals(other.getCustomerManagedKey())) return false;
    if (hasPersistenceConfig() != other.hasPersistenceConfig()) return false;
    if (hasPersistenceConfig()) {
      if (!getPersistenceConfig().equals(other.getPersistenceConfig())) return false;
    }
    if (!suspensionReasons_.equals(other.suspensionReasons_)) return false;
    if (!getMaintenanceVersion().equals(other.getMaintenanceVersion())) return false;
    if (!getAvailableMaintenanceVersionsList().equals(other.getAvailableMaintenanceVersionsList()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + LOCATION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getLocationId().hashCode();
    hash = (37 * hash) + ALTERNATIVE_LOCATION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getAlternativeLocationId().hashCode();
    hash = (37 * hash) + REDIS_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getRedisVersion().hashCode();
    hash = (37 * hash) + RESERVED_IP_RANGE_FIELD_NUMBER;
    hash = (53 * hash) + getReservedIpRange().hashCode();
    hash = (37 * hash) + SECONDARY_IP_RANGE_FIELD_NUMBER;
    hash = (53 * hash) + getSecondaryIpRange().hashCode();
    hash = (37 * hash) + HOST_FIELD_NUMBER;
    hash = (53 * hash) + getHost().hashCode();
    hash = (37 * hash) + PORT_FIELD_NUMBER;
    hash = (53 * hash) + getPort();
    hash = (37 * hash) + CURRENT_LOCATION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getCurrentLocationId().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + STATUS_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getStatusMessage().hashCode();
    if (!internalGetRedisConfigs().getMap().isEmpty()) {
      hash = (37 * hash) + REDIS_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetRedisConfigs().hashCode();
    }
    hash = (37 * hash) + TIER_FIELD_NUMBER;
    hash = (53 * hash) + tier_;
    hash = (37 * hash) + MEMORY_SIZE_GB_FIELD_NUMBER;
    hash = (53 * hash) + getMemorySizeGb();
    hash = (37 * hash) + AUTHORIZED_NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getAuthorizedNetwork().hashCode();
    hash = (37 * hash) + PERSISTENCE_IAM_IDENTITY_FIELD_NUMBER;
    hash = (53 * hash) + getPersistenceIamIdentity().hashCode();
    hash = (37 * hash) + CONNECT_MODE_FIELD_NUMBER;
    hash = (53 * hash) + connectMode_;
    hash = (37 * hash) + AUTH_ENABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAuthEnabled());
    if (getServerCaCertsCount() > 0) {
      hash = (37 * hash) + SERVER_CA_CERTS_FIELD_NUMBER;
      hash = (53 * hash) + getServerCaCertsList().hashCode();
    }
    hash = (37 * hash) + TRANSIT_ENCRYPTION_MODE_FIELD_NUMBER;
    hash = (53 * hash) + transitEncryptionMode_;
    if (hasMaintenancePolicy()) {
      hash = (37 * hash) + MAINTENANCE_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getMaintenancePolicy().hashCode();
    }
    if (hasMaintenanceSchedule()) {
      hash = (37 * hash) + MAINTENANCE_SCHEDULE_FIELD_NUMBER;
      hash = (53 * hash) + getMaintenanceSchedule().hashCode();
    }
    hash = (37 * hash) + REPLICA_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getReplicaCount();
    if (getNodesCount() > 0) {
      hash = (37 * hash) + NODES_FIELD_NUMBER;
      hash = (53 * hash) + getNodesList().hashCode();
    }
    hash = (37 * hash) + READ_ENDPOINT_FIELD_NUMBER;
    hash = (53 * hash) + getReadEndpoint().hashCode();
    hash = (37 * hash) + READ_ENDPOINT_PORT_FIELD_NUMBER;
    hash = (53 * hash) + getReadEndpointPort();
    hash = (37 * hash) + READ_REPLICAS_MODE_FIELD_NUMBER;
    hash = (53 * hash) + readReplicasMode_;
    hash = (37 * hash) + CUSTOMER_MANAGED_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getCustomerManagedKey().hashCode();
    if (hasPersistenceConfig()) {
      hash = (37 * hash) + PERSISTENCE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getPersistenceConfig().hashCode();
    }
    if (getSuspensionReasonsCount() > 0) {
      hash = (37 * hash) + SUSPENSION_REASONS_FIELD_NUMBER;
      hash = (53 * hash) + suspensionReasons_.hashCode();
    }
    hash = (37 * hash) + MAINTENANCE_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getMaintenanceVersion().hashCode();
    if (getAvailableMaintenanceVersionsCount() > 0) {
      hash = (37 * hash) + AVAILABLE_MAINTENANCE_VERSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getAvailableMaintenanceVersionsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.redis.v1.Instance parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.redis.v1.Instance parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.redis.v1.Instance parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.redis.v1.Instance parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.redis.v1.Instance parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.redis.v1.Instance parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.redis.v1.Instance parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.redis.v1.Instance parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.redis.v1.Instance parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.redis.v1.Instance parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.redis.v1.Instance parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.redis.v1.Instance parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.redis.v1.Instance prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Memorystore for Redis instance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.redis.v1.Instance}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.redis.v1.Instance)
      com.google.cloud.redis.v1.InstanceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.redis.v1.CloudRedisServiceV1Proto
          .internal_static_google_cloud_redis_v1_Instance_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetLabels();
        case 16:
          return internalGetRedisConfigs();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetMutableLabels();
        case 16:
          return internalGetMutableRedisConfigs();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.redis.v1.CloudRedisServiceV1Proto
          .internal_static_google_cloud_redis_v1_Instance_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.redis.v1.Instance.class,
              com.google.cloud.redis.v1.Instance.Builder.class);
    }

    // Construct using com.google.cloud.redis.v1.Instance.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getServerCaCertsFieldBuilder();
        getMaintenancePolicyFieldBuilder();
        getMaintenanceScheduleFieldBuilder();
        getNodesFieldBuilder();
        getPersistenceConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bitField1_ = 0;
      name_ = "";
      displayName_ = "";
      internalGetMutableLabels().clear();
      locationId_ = "";
      alternativeLocationId_ = "";
      redisVersion_ = "";
      reservedIpRange_ = "";
      secondaryIpRange_ = "";
      host_ = "";
      port_ = 0;
      currentLocationId_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      state_ = 0;
      statusMessage_ = "";
      internalGetMutableRedisConfigs().clear();
      tier_ = 0;
      memorySizeGb_ = 0;
      authorizedNetwork_ = "";
      persistenceIamIdentity_ = "";
      connectMode_ = 0;
      authEnabled_ = false;
      if (serverCaCertsBuilder_ == null) {
        serverCaCerts_ = java.util.Collections.emptyList();
      } else {
        serverCaCerts_ = null;
        serverCaCertsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00200000);
      transitEncryptionMode_ = 0;
      maintenancePolicy_ = null;
      if (maintenancePolicyBuilder_ != null) {
        maintenancePolicyBuilder_.dispose();
        maintenancePolicyBuilder_ = null;
      }
      maintenanceSchedule_ = null;
      if (maintenanceScheduleBuilder_ != null) {
        maintenanceScheduleBuilder_.dispose();
        maintenanceScheduleBuilder_ = null;
      }
      replicaCount_ = 0;
      if (nodesBuilder_ == null) {
        nodes_ = java.util.Collections.emptyList();
      } else {
        nodes_ = null;
        nodesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x04000000);
      readEndpoint_ = "";
      readEndpointPort_ = 0;
      readReplicasMode_ = 0;
      customerManagedKey_ = "";
      persistenceConfig_ = null;
      if (persistenceConfigBuilder_ != null) {
        persistenceConfigBuilder_.dispose();
        persistenceConfigBuilder_ = null;
      }
      suspensionReasons_ = java.util.Collections.emptyList();
      bitField1_ = (bitField1_ & ~0x00000001);
      maintenanceVersion_ = "";
      availableMaintenanceVersions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.redis.v1.CloudRedisServiceV1Proto
          .internal_static_google_cloud_redis_v1_Instance_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.redis.v1.Instance getDefaultInstanceForType() {
      return com.google.cloud.redis.v1.Instance.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.redis.v1.Instance build() {
      com.google.cloud.redis.v1.Instance result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.redis.v1.Instance buildPartial() {
      com.google.cloud.redis.v1.Instance result = new com.google.cloud.redis.v1.Instance(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      if (bitField1_ != 0) {
        buildPartial1(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.redis.v1.Instance result) {
      if (serverCaCertsBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)) {
          serverCaCerts_ = java.util.Collections.unmodifiableList(serverCaCerts_);
          bitField0_ = (bitField0_ & ~0x00200000);
        }
        result.serverCaCerts_ = serverCaCerts_;
      } else {
        result.serverCaCerts_ = serverCaCertsBuilder_.build();
      }
      if (nodesBuilder_ == null) {
        if (((bitField0_ & 0x04000000) != 0)) {
          nodes_ = java.util.Collections.unmodifiableList(nodes_);
          bitField0_ = (bitField0_ & ~0x04000000);
        }
        result.nodes_ = nodes_;
      } else {
        result.nodes_ = nodesBuilder_.build();
      }
      if (((bitField1_ & 0x00000001) != 0)) {
        suspensionReasons_ = java.util.Collections.unmodifiableList(suspensionReasons_);
        bitField1_ = (bitField1_ & ~0x00000001);
      }
      result.suspensionReasons_ = suspensionReasons_;
    }

    private void buildPartial0(com.google.cloud.redis.v1.Instance result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.locationId_ = locationId_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.alternativeLocationId_ = alternativeLocationId_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.redisVersion_ = redisVersion_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.reservedIpRange_ = reservedIpRange_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.secondaryIpRange_ = secondaryIpRange_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.host_ = host_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.port_ = port_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.currentLocationId_ = currentLocationId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.statusMessage_ = statusMessage_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.redisConfigs_ = internalGetRedisConfigs();
        result.redisConfigs_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.tier_ = tier_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.memorySizeGb_ = memorySizeGb_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.authorizedNetwork_ = authorizedNetwork_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.persistenceIamIdentity_ = persistenceIamIdentity_;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.connectMode_ = connectMode_;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.authEnabled_ = authEnabled_;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.transitEncryptionMode_ = transitEncryptionMode_;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.maintenancePolicy_ =
            maintenancePolicyBuilder_ == null
                ? maintenancePolicy_
                : maintenancePolicyBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.maintenanceSchedule_ =
            maintenanceScheduleBuilder_ == null
                ? maintenanceSchedule_
                : maintenanceScheduleBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.replicaCount_ = replicaCount_;
      }
      if (((from_bitField0_ & 0x08000000) != 0)) {
        result.readEndpoint_ = readEndpoint_;
      }
      if (((from_bitField0_ & 0x10000000) != 0)) {
        result.readEndpointPort_ = readEndpointPort_;
      }
      if (((from_bitField0_ & 0x20000000) != 0)) {
        result.readReplicasMode_ = readReplicasMode_;
      }
      if (((from_bitField0_ & 0x40000000) != 0)) {
        result.customerManagedKey_ = customerManagedKey_;
      }
      if (((from_bitField0_ & 0x80000000) != 0)) {
        result.persistenceConfig_ =
            persistenceConfigBuilder_ == null
                ? persistenceConfig_
                : persistenceConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartial1(com.google.cloud.redis.v1.Instance result) {
      int from_bitField1_ = bitField1_;
      if (((from_bitField1_ & 0x00000002) != 0)) {
        result.maintenanceVersion_ = maintenanceVersion_;
      }
      if (((from_bitField1_ & 0x00000004) != 0)) {
        availableMaintenanceVersions_.makeImmutable();
        result.availableMaintenanceVersions_ = availableMaintenanceVersions_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.redis.v1.Instance) {
        return mergeFrom((com.google.cloud.redis.v1.Instance) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.redis.v1.Instance other) {
      if (other == com.google.cloud.redis.v1.Instance.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000004;
      if (!other.getLocationId().isEmpty()) {
        locationId_ = other.locationId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getAlternativeLocationId().isEmpty()) {
        alternativeLocationId_ = other.alternativeLocationId_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getRedisVersion().isEmpty()) {
        redisVersion_ = other.redisVersion_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getReservedIpRange().isEmpty()) {
        reservedIpRange_ = other.reservedIpRange_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getSecondaryIpRange().isEmpty()) {
        secondaryIpRange_ = other.secondaryIpRange_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getHost().isEmpty()) {
        host_ = other.host_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.getPort() != 0) {
        setPort(other.getPort());
      }
      if (!other.getCurrentLocationId().isEmpty()) {
        currentLocationId_ = other.currentLocationId_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getStatusMessage().isEmpty()) {
        statusMessage_ = other.statusMessage_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      internalGetMutableRedisConfigs().mergeFrom(other.internalGetRedisConfigs());
      bitField0_ |= 0x00004000;
      if (other.tier_ != 0) {
        setTierValue(other.getTierValue());
      }
      if (other.getMemorySizeGb() != 0) {
        setMemorySizeGb(other.getMemorySizeGb());
      }
      if (!other.getAuthorizedNetwork().isEmpty()) {
        authorizedNetwork_ = other.authorizedNetwork_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (!other.getPersistenceIamIdentity().isEmpty()) {
        persistenceIamIdentity_ = other.persistenceIamIdentity_;
        bitField0_ |= 0x00040000;
        onChanged();
      }
      if (other.connectMode_ != 0) {
        setConnectModeValue(other.getConnectModeValue());
      }
      if (other.getAuthEnabled() != false) {
        setAuthEnabled(other.getAuthEnabled());
      }
      if (serverCaCertsBuilder_ == null) {
        if (!other.serverCaCerts_.isEmpty()) {
          if (serverCaCerts_.isEmpty()) {
            serverCaCerts_ = other.serverCaCerts_;
            bitField0_ = (bitField0_ & ~0x00200000);
          } else {
            ensureServerCaCertsIsMutable();
            serverCaCerts_.addAll(other.serverCaCerts_);
          }
          onChanged();
        }
      } else {
        if (!other.serverCaCerts_.isEmpty()) {
          if (serverCaCertsBuilder_.isEmpty()) {
            serverCaCertsBuilder_.dispose();
            serverCaCertsBuilder_ = null;
            serverCaCerts_ = other.serverCaCerts_;
            bitField0_ = (bitField0_ & ~0x00200000);
            serverCaCertsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getServerCaCertsFieldBuilder()
                    : null;
          } else {
            serverCaCertsBuilder_.addAllMessages(other.serverCaCerts_);
          }
        }
      }
      if (other.transitEncryptionMode_ != 0) {
        setTransitEncryptionModeValue(other.getTransitEncryptionModeValue());
      }
      if (other.hasMaintenancePolicy()) {
        mergeMaintenancePolicy(other.getMaintenancePolicy());
      }
      if (other.hasMaintenanceSchedule()) {
        mergeMaintenanceSchedule(other.getMaintenanceSchedule());
      }
      if (other.getReplicaCount() != 0) {
        setReplicaCount(other.getReplicaCount());
      }
      if (nodesBuilder_ == null) {
        if (!other.nodes_.isEmpty()) {
          if (nodes_.isEmpty()) {
            nodes_ = other.nodes_;
            bitField0_ = (bitField0_ & ~0x04000000);
          } else {
            ensureNodesIsMutable();
            nodes_.addAll(other.nodes_);
          }
          onChanged();
        }
      } else {
        if (!other.nodes_.isEmpty()) {
          if (nodesBuilder_.isEmpty()) {
            nodesBuilder_.dispose();
            nodesBuilder_ = null;
            nodes_ = other.nodes_;
            bitField0_ = (bitField0_ & ~0x04000000);
            nodesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNodesFieldBuilder()
                    : null;
          } else {
            nodesBuilder_.addAllMessages(other.nodes_);
          }
        }
      }
      if (!other.getReadEndpoint().isEmpty()) {
        readEndpoint_ = other.readEndpoint_;
        bitField0_ |= 0x08000000;
        onChanged();
      }
      if (other.getReadEndpointPort() != 0) {
        setReadEndpointPort(other.getReadEndpointPort());
      }
      if (other.readReplicasMode_ != 0) {
        setReadReplicasModeValue(other.getReadReplicasModeValue());
      }
      if (!other.getCustomerManagedKey().isEmpty()) {
        customerManagedKey_ = other.customerManagedKey_;
        bitField0_ |= 0x40000000;
        onChanged();
      }
      if (other.hasPersistenceConfig()) {
        mergePersistenceConfig(other.getPersistenceConfig());
      }
      if (!other.suspensionReasons_.isEmpty()) {
        if (suspensionReasons_.isEmpty()) {
          suspensionReasons_ = other.suspensionReasons_;
          bitField1_ = (bitField1_ & ~0x00000001);
        } else {
          ensureSuspensionReasonsIsMutable();
          suspensionReasons_.addAll(other.suspensionReasons_);
        }
        onChanged();
      }
      if (!other.getMaintenanceVersion().isEmpty()) {
        maintenanceVersion_ = other.maintenanceVersion_;
        bitField1_ |= 0x00000002;
        onChanged();
      }
      if (!other.availableMaintenanceVersions_.isEmpty()) {
        if (availableMaintenanceVersions_.isEmpty()) {
          availableMaintenanceVersions_ = other.availableMaintenanceVersions_;
          bitField1_ |= 0x00000004;
        } else {
          ensureAvailableMaintenanceVersionsIsMutable();
          availableMaintenanceVersions_.addAll(other.availableMaintenanceVersions_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                locationId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                alternativeLocationId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 58:
              {
                redisVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 74:
              {
                reservedIpRange_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 74
            case 82:
              {
                host_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            case 88:
              {
                port_ = input.readInt32();
                bitField0_ |= 0x00000200;
                break;
              } // case 88
            case 98:
              {
                currentLocationId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 106
            case 112:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00001000;
                break;
              } // case 112
            case 122:
              {
                statusMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 122
            case 130:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> redisConfigs__ =
                    input.readMessage(
                        RedisConfigsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableRedisConfigs()
                    .getMutableMap()
                    .put(redisConfigs__.getKey(), redisConfigs__.getValue());
                bitField0_ |= 0x00004000;
                break;
              } // case 130
            case 136:
              {
                tier_ = input.readEnum();
                bitField0_ |= 0x00008000;
                break;
              } // case 136
            case 144:
              {
                memorySizeGb_ = input.readInt32();
                bitField0_ |= 0x00010000;
                break;
              } // case 144
            case 162:
              {
                authorizedNetwork_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case 162
            case 170:
              {
                persistenceIamIdentity_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00040000;
                break;
              } // case 170
            case 176:
              {
                connectMode_ = input.readEnum();
                bitField0_ |= 0x00080000;
                break;
              } // case 176
            case 184:
              {
                authEnabled_ = input.readBool();
                bitField0_ |= 0x00100000;
                break;
              } // case 184
            case 202:
              {
                com.google.cloud.redis.v1.TlsCertificate m =
                    input.readMessage(
                        com.google.cloud.redis.v1.TlsCertificate.parser(), extensionRegistry);
                if (serverCaCertsBuilder_ == null) {
                  ensureServerCaCertsIsMutable();
                  serverCaCerts_.add(m);
                } else {
                  serverCaCertsBuilder_.addMessage(m);
                }
                break;
              } // case 202
            case 208:
              {
                transitEncryptionMode_ = input.readEnum();
                bitField0_ |= 0x00400000;
                break;
              } // case 208
            case 218:
              {
                input.readMessage(
                    getMaintenancePolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00800000;
                break;
              } // case 218
            case 226:
              {
                input.readMessage(
                    getMaintenanceScheduleFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x01000000;
                break;
              } // case 226
            case 242:
              {
                secondaryIpRange_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 242
            case 248:
              {
                replicaCount_ = input.readInt32();
                bitField0_ |= 0x02000000;
                break;
              } // case 248
            case 258:
              {
                com.google.cloud.redis.v1.NodeInfo m =
                    input.readMessage(
                        com.google.cloud.redis.v1.NodeInfo.parser(), extensionRegistry);
                if (nodesBuilder_ == null) {
                  ensureNodesIsMutable();
                  nodes_.add(m);
                } else {
                  nodesBuilder_.addMessage(m);
                }
                break;
              } // case 258
            case 266:
              {
                readEndpoint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x08000000;
                break;
              } // case 266
            case 272:
              {
                readEndpointPort_ = input.readInt32();
                bitField0_ |= 0x10000000;
                break;
              } // case 272
            case 280:
              {
                readReplicasMode_ = input.readEnum();
                bitField0_ |= 0x20000000;
                break;
              } // case 280
            case 290:
              {
                customerManagedKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x40000000;
                break;
              } // case 290
            case 298:
              {
                input.readMessage(
                    getPersistenceConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x80000000;
                break;
              } // case 298
            case 304:
              {
                int tmpRaw = input.readEnum();
                ensureSuspensionReasonsIsMutable();
                suspensionReasons_.add(tmpRaw);
                break;
              } // case 304
            case 306:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureSuspensionReasonsIsMutable();
                  suspensionReasons_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 306
            case 314:
              {
                maintenanceVersion_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00000002;
                break;
              } // case 314
            case 322:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAvailableMaintenanceVersionsIsMutable();
                availableMaintenanceVersions_.add(s);
                break;
              } // case 322
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;
    private int bitField1_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Unique name of the resource in this scope including project and
     * location using the form:
     *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
     *
     * Note: Redis instances are managed and addressed at regional level so
     * location_id here refers to a GCP region; however, users may choose which
     * specific zone (or collection of zones for cross-zone instances) an instance
     * should be provisioned in. Refer to
     * [location_id][google.cloud.redis.v1.Instance.location_id] and
     * [alternative_location_id][google.cloud.redis.v1.Instance.alternative_location_id]
     * fields for more details.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Unique name of the resource in this scope including project and
     * location using the form:
     *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
     *
     * Note: Redis instances are managed and addressed at regional level so
     * location_id here refers to a GCP region; however, users may choose which
     * specific zone (or collection of zones for cross-zone instances) an instance
     * should be provisioned in. Refer to
     * [location_id][google.cloud.redis.v1.Instance.location_id] and
     * [alternative_location_id][google.cloud.redis.v1.Instance.alternative_location_id]
     * fields for more details.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Unique name of the resource in this scope including project and
     * location using the form:
     *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
     *
     * Note: Redis instances are managed and addressed at regional level so
     * location_id here refers to a GCP region; however, users may choose which
     * specific zone (or collection of zones for cross-zone instances) an instance
     * should be provisioned in. Refer to
     * [location_id][google.cloud.redis.v1.Instance.location_id] and
     * [alternative_location_id][google.cloud.redis.v1.Instance.alternative_location_id]
     * fields for more details.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Unique name of the resource in this scope including project and
     * location using the form:
     *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
     *
     * Note: Redis instances are managed and addressed at regional level so
     * location_id here refers to a GCP region; however, users may choose which
     * specific zone (or collection of zones for cross-zone instances) an instance
     * should be provisioned in. Refer to
     * [location_id][google.cloud.redis.v1.Instance.location_id] and
     * [alternative_location_id][google.cloud.redis.v1.Instance.alternative_location_id]
     * fields for more details.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Unique name of the resource in this scope including project and
     * location using the form:
     *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
     *
     * Note: Redis instances are managed and addressed at regional level so
     * location_id here refers to a GCP region; however, users may choose which
     * specific zone (or collection of zones for cross-zone instances) an instance
     * should be provisioned in. Refer to
     * [location_id][google.cloud.redis.v1.Instance.location_id] and
     * [alternative_location_id][google.cloud.redis.v1.Instance.alternative_location_id]
     * fields for more details.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * An arbitrary and optional user-provided name for the instance.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An arbitrary and optional user-provided name for the instance.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An arbitrary and optional user-provided name for the instance.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An arbitrary and optional user-provided name for the instance.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An arbitrary and optional user-provided name for the instance.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000004;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    private java.lang.Object locationId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The zone where the instance will be provisioned. If not provided,
     * the service will choose a zone from the specified region for the instance.
     * For standard tier, additional nodes will be added across multiple zones for
     * protection against zonal failures. If specified, at least one node will be
     * provisioned in this zone.
     * </pre>
     *
     * <code>string location_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The locationId.
     */
    public java.lang.String getLocationId() {
      java.lang.Object ref = locationId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        locationId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The zone where the instance will be provisioned. If not provided,
     * the service will choose a zone from the specified region for the instance.
     * For standard tier, additional nodes will be added across multiple zones for
     * protection against zonal failures. If specified, at least one node will be
     * provisioned in this zone.
     * </pre>
     *
     * <code>string location_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for locationId.
     */
    public com.google.protobuf.ByteString getLocationIdBytes() {
      java.lang.Object ref = locationId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        locationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The zone where the instance will be provisioned. If not provided,
     * the service will choose a zone from the specified region for the instance.
     * For standard tier, additional nodes will be added across multiple zones for
     * protection against zonal failures. If specified, at least one node will be
     * provisioned in this zone.
     * </pre>
     *
     * <code>string location_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The locationId to set.
     * @return This builder for chaining.
     */
    public Builder setLocationId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      locationId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The zone where the instance will be provisioned. If not provided,
     * the service will choose a zone from the specified region for the instance.
     * For standard tier, additional nodes will be added across multiple zones for
     * protection against zonal failures. If specified, at least one node will be
     * provisioned in this zone.
     * </pre>
     *
     * <code>string location_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocationId() {
      locationId_ = getDefaultInstance().getLocationId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The zone where the instance will be provisioned. If not provided,
     * the service will choose a zone from the specified region for the instance.
     * For standard tier, additional nodes will be added across multiple zones for
     * protection against zonal failures. If specified, at least one node will be
     * provisioned in this zone.
     * </pre>
     *
     * <code>string location_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for locationId to set.
     * @return This builder for chaining.
     */
    public Builder setLocationIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      locationId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object alternativeLocationId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. If specified, at least one node will be provisioned in this zone
     * in addition to the zone specified in location_id. Only applicable to
     * standard tier. If provided, it must be a different zone from the one
     * provided in [location_id]. Additional nodes beyond the first 2 will be
     * placed in zones selected by the service.
     * </pre>
     *
     * <code>string alternative_location_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The alternativeLocationId.
     */
    public java.lang.String getAlternativeLocationId() {
      java.lang.Object ref = alternativeLocationId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        alternativeLocationId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If specified, at least one node will be provisioned in this zone
     * in addition to the zone specified in location_id. Only applicable to
     * standard tier. If provided, it must be a different zone from the one
     * provided in [location_id]. Additional nodes beyond the first 2 will be
     * placed in zones selected by the service.
     * </pre>
     *
     * <code>string alternative_location_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for alternativeLocationId.
     */
    public com.google.protobuf.ByteString getAlternativeLocationIdBytes() {
      java.lang.Object ref = alternativeLocationId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        alternativeLocationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If specified, at least one node will be provisioned in this zone
     * in addition to the zone specified in location_id. Only applicable to
     * standard tier. If provided, it must be a different zone from the one
     * provided in [location_id]. Additional nodes beyond the first 2 will be
     * placed in zones selected by the service.
     * </pre>
     *
     * <code>string alternative_location_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The alternativeLocationId to set.
     * @return This builder for chaining.
     */
    public Builder setAlternativeLocationId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      alternativeLocationId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If specified, at least one node will be provisioned in this zone
     * in addition to the zone specified in location_id. Only applicable to
     * standard tier. If provided, it must be a different zone from the one
     * provided in [location_id]. Additional nodes beyond the first 2 will be
     * placed in zones selected by the service.
     * </pre>
     *
     * <code>string alternative_location_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAlternativeLocationId() {
      alternativeLocationId_ = getDefaultInstance().getAlternativeLocationId();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If specified, at least one node will be provisioned in this zone
     * in addition to the zone specified in location_id. Only applicable to
     * standard tier. If provided, it must be a different zone from the one
     * provided in [location_id]. Additional nodes beyond the first 2 will be
     * placed in zones selected by the service.
     * </pre>
     *
     * <code>string alternative_location_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for alternativeLocationId to set.
     * @return This builder for chaining.
     */
    public Builder setAlternativeLocationIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      alternativeLocationId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object redisVersion_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The version of Redis software.
     * If not provided, latest supported version will be used. Currently, the
     * supported values are:
     *
     *  *   `REDIS_3_2` for Redis 3.2 compatibility
     *  *   `REDIS_4_0` for Redis 4.0 compatibility (default)
     *  *   `REDIS_5_0` for Redis 5.0 compatibility
     *  *   `REDIS_6_X` for Redis 6.x compatibility
     * </pre>
     *
     * <code>string redis_version = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The redisVersion.
     */
    public java.lang.String getRedisVersion() {
      java.lang.Object ref = redisVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        redisVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The version of Redis software.
     * If not provided, latest supported version will be used. Currently, the
     * supported values are:
     *
     *  *   `REDIS_3_2` for Redis 3.2 compatibility
     *  *   `REDIS_4_0` for Redis 4.0 compatibility (default)
     *  *   `REDIS_5_0` for Redis 5.0 compatibility
     *  *   `REDIS_6_X` for Redis 6.x compatibility
     * </pre>
     *
     * <code>string redis_version = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for redisVersion.
     */
    public com.google.protobuf.ByteString getRedisVersionBytes() {
      java.lang.Object ref = redisVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        redisVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The version of Redis software.
     * If not provided, latest supported version will be used. Currently, the
     * supported values are:
     *
     *  *   `REDIS_3_2` for Redis 3.2 compatibility
     *  *   `REDIS_4_0` for Redis 4.0 compatibility (default)
     *  *   `REDIS_5_0` for Redis 5.0 compatibility
     *  *   `REDIS_6_X` for Redis 6.x compatibility
     * </pre>
     *
     * <code>string redis_version = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The redisVersion to set.
     * @return This builder for chaining.
     */
    public Builder setRedisVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      redisVersion_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The version of Redis software.
     * If not provided, latest supported version will be used. Currently, the
     * supported values are:
     *
     *  *   `REDIS_3_2` for Redis 3.2 compatibility
     *  *   `REDIS_4_0` for Redis 4.0 compatibility (default)
     *  *   `REDIS_5_0` for Redis 5.0 compatibility
     *  *   `REDIS_6_X` for Redis 6.x compatibility
     * </pre>
     *
     * <code>string redis_version = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRedisVersion() {
      redisVersion_ = getDefaultInstance().getRedisVersion();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The version of Redis software.
     * If not provided, latest supported version will be used. Currently, the
     * supported values are:
     *
     *  *   `REDIS_3_2` for Redis 3.2 compatibility
     *  *   `REDIS_4_0` for Redis 4.0 compatibility (default)
     *  *   `REDIS_5_0` for Redis 5.0 compatibility
     *  *   `REDIS_6_X` for Redis 6.x compatibility
     * </pre>
     *
     * <code>string redis_version = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for redisVersion to set.
     * @return This builder for chaining.
     */
    public Builder setRedisVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      redisVersion_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object reservedIpRange_ = "";
    /**
     *
     *
     * <pre>
     * Optional. For DIRECT_PEERING mode, the CIDR range of internal addresses
     * that are reserved for this instance. Range must
     * be unique and non-overlapping with existing subnets in an authorized
     * network. For PRIVATE_SERVICE_ACCESS mode, the name of one allocated IP
     * address ranges associated with this private service access connection.
     * If not provided, the service will choose an unused /29 block, for
     * example, 10.0.0.0/29 or 192.168.0.0/29.  For READ_REPLICAS_ENABLED
     * the default block size is /28.
     * </pre>
     *
     * <code>string reserved_ip_range = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The reservedIpRange.
     */
    public java.lang.String getReservedIpRange() {
      java.lang.Object ref = reservedIpRange_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        reservedIpRange_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. For DIRECT_PEERING mode, the CIDR range of internal addresses
     * that are reserved for this instance. Range must
     * be unique and non-overlapping with existing subnets in an authorized
     * network. For PRIVATE_SERVICE_ACCESS mode, the name of one allocated IP
     * address ranges associated with this private service access connection.
     * If not provided, the service will choose an unused /29 block, for
     * example, 10.0.0.0/29 or 192.168.0.0/29.  For READ_REPLICAS_ENABLED
     * the default block size is /28.
     * </pre>
     *
     * <code>string reserved_ip_range = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for reservedIpRange.
     */
    public com.google.protobuf.ByteString getReservedIpRangeBytes() {
      java.lang.Object ref = reservedIpRange_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        reservedIpRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. For DIRECT_PEERING mode, the CIDR range of internal addresses
     * that are reserved for this instance. Range must
     * be unique and non-overlapping with existing subnets in an authorized
     * network. For PRIVATE_SERVICE_ACCESS mode, the name of one allocated IP
     * address ranges associated with this private service access connection.
     * If not provided, the service will choose an unused /29 block, for
     * example, 10.0.0.0/29 or 192.168.0.0/29.  For READ_REPLICAS_ENABLED
     * the default block size is /28.
     * </pre>
     *
     * <code>string reserved_ip_range = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The reservedIpRange to set.
     * @return This builder for chaining.
     */
    public Builder setReservedIpRange(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      reservedIpRange_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. For DIRECT_PEERING mode, the CIDR range of internal addresses
     * that are reserved for this instance. Range must
     * be unique and non-overlapping with existing subnets in an authorized
     * network. For PRIVATE_SERVICE_ACCESS mode, the name of one allocated IP
     * address ranges associated with this private service access connection.
     * If not provided, the service will choose an unused /29 block, for
     * example, 10.0.0.0/29 or 192.168.0.0/29.  For READ_REPLICAS_ENABLED
     * the default block size is /28.
     * </pre>
     *
     * <code>string reserved_ip_range = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReservedIpRange() {
      reservedIpRange_ = getDefaultInstance().getReservedIpRange();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. For DIRECT_PEERING mode, the CIDR range of internal addresses
     * that are reserved for this instance. Range must
     * be unique and non-overlapping with existing subnets in an authorized
     * network. For PRIVATE_SERVICE_ACCESS mode, the name of one allocated IP
     * address ranges associated with this private service access connection.
     * If not provided, the service will choose an unused /29 block, for
     * example, 10.0.0.0/29 or 192.168.0.0/29.  For READ_REPLICAS_ENABLED
     * the default block size is /28.
     * </pre>
     *
     * <code>string reserved_ip_range = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for reservedIpRange to set.
     * @return This builder for chaining.
     */
    public Builder setReservedIpRangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      reservedIpRange_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object secondaryIpRange_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Additional IP range for node placement. Required when enabling
     * read replicas on an existing instance. For DIRECT_PEERING mode value must
     * be a CIDR range of size /28, or "auto". For PRIVATE_SERVICE_ACCESS mode
     * value must be the name of an allocated address range associated with the
     * private service access connection, or "auto".
     * </pre>
     *
     * <code>string secondary_ip_range = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The secondaryIpRange.
     */
    public java.lang.String getSecondaryIpRange() {
      java.lang.Object ref = secondaryIpRange_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        secondaryIpRange_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional IP range for node placement. Required when enabling
     * read replicas on an existing instance. For DIRECT_PEERING mode value must
     * be a CIDR range of size /28, or "auto". For PRIVATE_SERVICE_ACCESS mode
     * value must be the name of an allocated address range associated with the
     * private service access connection, or "auto".
     * </pre>
     *
     * <code>string secondary_ip_range = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for secondaryIpRange.
     */
    public com.google.protobuf.ByteString getSecondaryIpRangeBytes() {
      java.lang.Object ref = secondaryIpRange_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        secondaryIpRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional IP range for node placement. Required when enabling
     * read replicas on an existing instance. For DIRECT_PEERING mode value must
     * be a CIDR range of size /28, or "auto". For PRIVATE_SERVICE_ACCESS mode
     * value must be the name of an allocated address range associated with the
     * private service access connection, or "auto".
     * </pre>
     *
     * <code>string secondary_ip_range = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The secondaryIpRange to set.
     * @return This builder for chaining.
     */
    public Builder setSecondaryIpRange(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      secondaryIpRange_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional IP range for node placement. Required when enabling
     * read replicas on an existing instance. For DIRECT_PEERING mode value must
     * be a CIDR range of size /28, or "auto". For PRIVATE_SERVICE_ACCESS mode
     * value must be the name of an allocated address range associated with the
     * private service access connection, or "auto".
     * </pre>
     *
     * <code>string secondary_ip_range = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSecondaryIpRange() {
      secondaryIpRange_ = getDefaultInstance().getSecondaryIpRange();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional IP range for node placement. Required when enabling
     * read replicas on an existing instance. For DIRECT_PEERING mode value must
     * be a CIDR range of size /28, or "auto". For PRIVATE_SERVICE_ACCESS mode
     * value must be the name of an allocated address range associated with the
     * private service access connection, or "auto".
     * </pre>
     *
     * <code>string secondary_ip_range = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for secondaryIpRange to set.
     * @return This builder for chaining.
     */
    public Builder setSecondaryIpRangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      secondaryIpRange_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object host_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Hostname or IP address of the exposed Redis endpoint used by
     * clients to connect to the service.
     * </pre>
     *
     * <code>string host = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The host.
     */
    public java.lang.String getHost() {
      java.lang.Object ref = host_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        host_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Hostname or IP address of the exposed Redis endpoint used by
     * clients to connect to the service.
     * </pre>
     *
     * <code>string host = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for host.
     */
    public com.google.protobuf.ByteString getHostBytes() {
      java.lang.Object ref = host_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        host_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Hostname or IP address of the exposed Redis endpoint used by
     * clients to connect to the service.
     * </pre>
     *
     * <code>string host = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The host to set.
     * @return This builder for chaining.
     */
    public Builder setHost(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      host_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Hostname or IP address of the exposed Redis endpoint used by
     * clients to connect to the service.
     * </pre>
     *
     * <code>string host = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHost() {
      host_ = getDefaultInstance().getHost();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Hostname or IP address of the exposed Redis endpoint used by
     * clients to connect to the service.
     * </pre>
     *
     * <code>string host = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for host to set.
     * @return This builder for chaining.
     */
    public Builder setHostBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      host_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private int port_;
    /**
     *
     *
     * <pre>
     * Output only. The port number of the exposed Redis endpoint.
     * </pre>
     *
     * <code>int32 port = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The port.
     */
    @java.lang.Override
    public int getPort() {
      return port_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The port number of the exposed Redis endpoint.
     * </pre>
     *
     * <code>int32 port = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The port to set.
     * @return This builder for chaining.
     */
    public Builder setPort(int value) {

      port_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The port number of the exposed Redis endpoint.
     * </pre>
     *
     * <code>int32 port = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPort() {
      bitField0_ = (bitField0_ & ~0x00000200);
      port_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object currentLocationId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The current zone where the Redis primary node is located. In
     * basic tier, this will always be the same as [location_id]. In
     * standard tier, this can be the zone of any node in the instance.
     * </pre>
     *
     * <code>string current_location_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The currentLocationId.
     */
    public java.lang.String getCurrentLocationId() {
      java.lang.Object ref = currentLocationId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        currentLocationId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The current zone where the Redis primary node is located. In
     * basic tier, this will always be the same as [location_id]. In
     * standard tier, this can be the zone of any node in the instance.
     * </pre>
     *
     * <code>string current_location_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for currentLocationId.
     */
    public com.google.protobuf.ByteString getCurrentLocationIdBytes() {
      java.lang.Object ref = currentLocationId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        currentLocationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The current zone where the Redis primary node is located. In
     * basic tier, this will always be the same as [location_id]. In
     * standard tier, this can be the zone of any node in the instance.
     * </pre>
     *
     * <code>string current_location_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The currentLocationId to set.
     * @return This builder for chaining.
     */
    public Builder setCurrentLocationId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      currentLocationId_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current zone where the Redis primary node is located. In
     * basic tier, this will always be the same as [location_id]. In
     * standard tier, this can be the zone of any node in the instance.
     * </pre>
     *
     * <code>string current_location_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCurrentLocationId() {
      currentLocationId_ = getDefaultInstance().getCurrentLocationId();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current zone where the Redis primary node is located. In
     * basic tier, this will always be the same as [location_id]. In
     * standard tier, this can be the zone of any node in the instance.
     * </pre>
     *
     * <code>string current_location_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for currentLocationId to set.
     * @return This builder for chaining.
     */
    public Builder setCurrentLocationIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      currentLocationId_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000800);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current state of this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.Instance.State state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.Instance.State state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.Instance.State state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.redis.v1.Instance.State getState() {
      com.google.cloud.redis.v1.Instance.State result =
          com.google.cloud.redis.v1.Instance.State.forNumber(state_);
      return result == null ? com.google.cloud.redis.v1.Instance.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.Instance.State state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.redis.v1.Instance.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00001000;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.Instance.State state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00001000);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object statusMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current status of this
     * instance, if available.
     * </pre>
     *
     * <code>string status_message = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The statusMessage.
     */
    public java.lang.String getStatusMessage() {
      java.lang.Object ref = statusMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        statusMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current status of this
     * instance, if available.
     * </pre>
     *
     * <code>string status_message = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for statusMessage.
     */
    public com.google.protobuf.ByteString getStatusMessageBytes() {
      java.lang.Object ref = statusMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        statusMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current status of this
     * instance, if available.
     * </pre>
     *
     * <code>string status_message = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The statusMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStatusMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      statusMessage_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current status of this
     * instance, if available.
     * </pre>
     *
     * <code>string status_message = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatusMessage() {
      statusMessage_ = getDefaultInstance().getStatusMessage();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current status of this
     * instance, if available.
     * </pre>
     *
     * <code>string status_message = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for statusMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStatusMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      statusMessage_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> redisConfigs_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetRedisConfigs() {
      if (redisConfigs_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            RedisConfigsDefaultEntryHolder.defaultEntry);
      }
      return redisConfigs_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableRedisConfigs() {
      if (redisConfigs_ == null) {
        redisConfigs_ =
            com.google.protobuf.MapField.newMapField(RedisConfigsDefaultEntryHolder.defaultEntry);
      }
      if (!redisConfigs_.isMutable()) {
        redisConfigs_ = redisConfigs_.copy();
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return redisConfigs_;
    }

    public int getRedisConfigsCount() {
      return internalGetRedisConfigs().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Redis configuration parameters, according to
     * http://redis.io/topics/config. Currently, the only supported parameters
     * are:
     *
     *  Redis version 3.2 and newer:
     *
     *  *   maxmemory-policy
     *  *   notify-keyspace-events
     *
     *  Redis version 4.0 and newer:
     *
     *  *   activedefrag
     *  *   lfu-decay-time
     *  *   lfu-log-factor
     *  *   maxmemory-gb
     *
     *  Redis version 5.0 and newer:
     *
     *  *   stream-node-max-bytes
     *  *   stream-node-max-entries
     * </pre>
     *
     * <code>map&lt;string, string&gt; redis_configs = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsRedisConfigs(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetRedisConfigs().getMap().containsKey(key);
    }
    /** Use {@link #getRedisConfigsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getRedisConfigs() {
      return getRedisConfigsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Redis configuration parameters, according to
     * http://redis.io/topics/config. Currently, the only supported parameters
     * are:
     *
     *  Redis version 3.2 and newer:
     *
     *  *   maxmemory-policy
     *  *   notify-keyspace-events
     *
     *  Redis version 4.0 and newer:
     *
     *  *   activedefrag
     *  *   lfu-decay-time
     *  *   lfu-log-factor
     *  *   maxmemory-gb
     *
     *  Redis version 5.0 and newer:
     *
     *  *   stream-node-max-bytes
     *  *   stream-node-max-entries
     * </pre>
     *
     * <code>map&lt;string, string&gt; redis_configs = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getRedisConfigsMap() {
      return internalGetRedisConfigs().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Redis configuration parameters, according to
     * http://redis.io/topics/config. Currently, the only supported parameters
     * are:
     *
     *  Redis version 3.2 and newer:
     *
     *  *   maxmemory-policy
     *  *   notify-keyspace-events
     *
     *  Redis version 4.0 and newer:
     *
     *  *   activedefrag
     *  *   lfu-decay-time
     *  *   lfu-log-factor
     *  *   maxmemory-gb
     *
     *  Redis version 5.0 and newer:
     *
     *  *   stream-node-max-bytes
     *  *   stream-node-max-entries
     * </pre>
     *
     * <code>map&lt;string, string&gt; redis_configs = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getRedisConfigsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetRedisConfigs().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Redis configuration parameters, according to
     * http://redis.io/topics/config. Currently, the only supported parameters
     * are:
     *
     *  Redis version 3.2 and newer:
     *
     *  *   maxmemory-policy
     *  *   notify-keyspace-events
     *
     *  Redis version 4.0 and newer:
     *
     *  *   activedefrag
     *  *   lfu-decay-time
     *  *   lfu-log-factor
     *  *   maxmemory-gb
     *
     *  Redis version 5.0 and newer:
     *
     *  *   stream-node-max-bytes
     *  *   stream-node-max-entries
     * </pre>
     *
     * <code>map&lt;string, string&gt; redis_configs = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getRedisConfigsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetRedisConfigs().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearRedisConfigs() {
      bitField0_ = (bitField0_ & ~0x00004000);
      internalGetMutableRedisConfigs().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Redis configuration parameters, according to
     * http://redis.io/topics/config. Currently, the only supported parameters
     * are:
     *
     *  Redis version 3.2 and newer:
     *
     *  *   maxmemory-policy
     *  *   notify-keyspace-events
     *
     *  Redis version 4.0 and newer:
     *
     *  *   activedefrag
     *  *   lfu-decay-time
     *  *   lfu-log-factor
     *  *   maxmemory-gb
     *
     *  Redis version 5.0 and newer:
     *
     *  *   stream-node-max-bytes
     *  *   stream-node-max-entries
     * </pre>
     *
     * <code>map&lt;string, string&gt; redis_configs = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeRedisConfigs(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableRedisConfigs().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableRedisConfigs() {
      bitField0_ |= 0x00004000;
      return internalGetMutableRedisConfigs().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Redis configuration parameters, according to
     * http://redis.io/topics/config. Currently, the only supported parameters
     * are:
     *
     *  Redis version 3.2 and newer:
     *
     *  *   maxmemory-policy
     *  *   notify-keyspace-events
     *
     *  Redis version 4.0 and newer:
     *
     *  *   activedefrag
     *  *   lfu-decay-time
     *  *   lfu-log-factor
     *  *   maxmemory-gb
     *
     *  Redis version 5.0 and newer:
     *
     *  *   stream-node-max-bytes
     *  *   stream-node-max-entries
     * </pre>
     *
     * <code>map&lt;string, string&gt; redis_configs = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putRedisConfigs(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableRedisConfigs().getMutableMap().put(key, value);
      bitField0_ |= 0x00004000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Redis configuration parameters, according to
     * http://redis.io/topics/config. Currently, the only supported parameters
     * are:
     *
     *  Redis version 3.2 and newer:
     *
     *  *   maxmemory-policy
     *  *   notify-keyspace-events
     *
     *  Redis version 4.0 and newer:
     *
     *  *   activedefrag
     *  *   lfu-decay-time
     *  *   lfu-log-factor
     *  *   maxmemory-gb
     *
     *  Redis version 5.0 and newer:
     *
     *  *   stream-node-max-bytes
     *  *   stream-node-max-entries
     * </pre>
     *
     * <code>map&lt;string, string&gt; redis_configs = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllRedisConfigs(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableRedisConfigs().getMutableMap().putAll(values);
      bitField0_ |= 0x00004000;
      return this;
    }

    private int tier_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The service tier of the instance.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.Instance.Tier tier = 17 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for tier.
     */
    @java.lang.Override
    public int getTierValue() {
      return tier_;
    }
    /**
     *
     *
     * <pre>
     * Required. The service tier of the instance.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.Instance.Tier tier = 17 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for tier to set.
     * @return This builder for chaining.
     */
    public Builder setTierValue(int value) {
      tier_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The service tier of the instance.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.Instance.Tier tier = 17 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The tier.
     */
    @java.lang.Override
    public com.google.cloud.redis.v1.Instance.Tier getTier() {
      com.google.cloud.redis.v1.Instance.Tier result =
          com.google.cloud.redis.v1.Instance.Tier.forNumber(tier_);
      return result == null ? com.google.cloud.redis.v1.Instance.Tier.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The service tier of the instance.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.Instance.Tier tier = 17 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The tier to set.
     * @return This builder for chaining.
     */
    public Builder setTier(com.google.cloud.redis.v1.Instance.Tier value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00008000;
      tier_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The service tier of the instance.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.Instance.Tier tier = 17 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTier() {
      bitField0_ = (bitField0_ & ~0x00008000);
      tier_ = 0;
      onChanged();
      return this;
    }

    private int memorySizeGb_;
    /**
     *
     *
     * <pre>
     * Required. Redis memory size in GiB.
     * </pre>
     *
     * <code>int32 memory_size_gb = 18 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The memorySizeGb.
     */
    @java.lang.Override
    public int getMemorySizeGb() {
      return memorySizeGb_;
    }
    /**
     *
     *
     * <pre>
     * Required. Redis memory size in GiB.
     * </pre>
     *
     * <code>int32 memory_size_gb = 18 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The memorySizeGb to set.
     * @return This builder for chaining.
     */
    public Builder setMemorySizeGb(int value) {

      memorySizeGb_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Redis memory size in GiB.
     * </pre>
     *
     * <code>int32 memory_size_gb = 18 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMemorySizeGb() {
      bitField0_ = (bitField0_ & ~0x00010000);
      memorySizeGb_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object authorizedNetwork_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The full name of the Google Compute Engine
     * [network](https://cloud.google.com/vpc/docs/vpc) to which the
     * instance is connected. If left unspecified, the `default` network
     * will be used.
     * </pre>
     *
     * <code>string authorized_network = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The authorizedNetwork.
     */
    public java.lang.String getAuthorizedNetwork() {
      java.lang.Object ref = authorizedNetwork_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        authorizedNetwork_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The full name of the Google Compute Engine
     * [network](https://cloud.google.com/vpc/docs/vpc) to which the
     * instance is connected. If left unspecified, the `default` network
     * will be used.
     * </pre>
     *
     * <code>string authorized_network = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for authorizedNetwork.
     */
    public com.google.protobuf.ByteString getAuthorizedNetworkBytes() {
      java.lang.Object ref = authorizedNetwork_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        authorizedNetwork_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The full name of the Google Compute Engine
     * [network](https://cloud.google.com/vpc/docs/vpc) to which the
     * instance is connected. If left unspecified, the `default` network
     * will be used.
     * </pre>
     *
     * <code>string authorized_network = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The authorizedNetwork to set.
     * @return This builder for chaining.
     */
    public Builder setAuthorizedNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      authorizedNetwork_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The full name of the Google Compute Engine
     * [network](https://cloud.google.com/vpc/docs/vpc) to which the
     * instance is connected. If left unspecified, the `default` network
     * will be used.
     * </pre>
     *
     * <code>string authorized_network = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAuthorizedNetwork() {
      authorizedNetwork_ = getDefaultInstance().getAuthorizedNetwork();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The full name of the Google Compute Engine
     * [network](https://cloud.google.com/vpc/docs/vpc) to which the
     * instance is connected. If left unspecified, the `default` network
     * will be used.
     * </pre>
     *
     * <code>string authorized_network = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for authorizedNetwork to set.
     * @return This builder for chaining.
     */
    public Builder setAuthorizedNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      authorizedNetwork_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private java.lang.Object persistenceIamIdentity_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Cloud IAM identity used by import / export operations to
     * transfer data to/from Cloud Storage. Format is
     * "serviceAccount:&lt;service_account_email&gt;". The value may change over time
     * for a given instance so should be checked before each import/export
     * operation.
     * </pre>
     *
     * <code>string persistence_iam_identity = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The persistenceIamIdentity.
     */
    public java.lang.String getPersistenceIamIdentity() {
      java.lang.Object ref = persistenceIamIdentity_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        persistenceIamIdentity_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud IAM identity used by import / export operations to
     * transfer data to/from Cloud Storage. Format is
     * "serviceAccount:&lt;service_account_email&gt;". The value may change over time
     * for a given instance so should be checked before each import/export
     * operation.
     * </pre>
     *
     * <code>string persistence_iam_identity = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for persistenceIamIdentity.
     */
    public com.google.protobuf.ByteString getPersistenceIamIdentityBytes() {
      java.lang.Object ref = persistenceIamIdentity_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        persistenceIamIdentity_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud IAM identity used by import / export operations to
     * transfer data to/from Cloud Storage. Format is
     * "serviceAccount:&lt;service_account_email&gt;". The value may change over time
     * for a given instance so should be checked before each import/export
     * operation.
     * </pre>
     *
     * <code>string persistence_iam_identity = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The persistenceIamIdentity to set.
     * @return This builder for chaining.
     */
    public Builder setPersistenceIamIdentity(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      persistenceIamIdentity_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud IAM identity used by import / export operations to
     * transfer data to/from Cloud Storage. Format is
     * "serviceAccount:&lt;service_account_email&gt;". The value may change over time
     * for a given instance so should be checked before each import/export
     * operation.
     * </pre>
     *
     * <code>string persistence_iam_identity = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPersistenceIamIdentity() {
      persistenceIamIdentity_ = getDefaultInstance().getPersistenceIamIdentity();
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud IAM identity used by import / export operations to
     * transfer data to/from Cloud Storage. Format is
     * "serviceAccount:&lt;service_account_email&gt;". The value may change over time
     * for a given instance so should be checked before each import/export
     * operation.
     * </pre>
     *
     * <code>string persistence_iam_identity = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for persistenceIamIdentity to set.
     * @return This builder for chaining.
     */
    public Builder setPersistenceIamIdentityBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      persistenceIamIdentity_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private int connectMode_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The network connect mode of the Redis instance.
     * If not provided, the connect mode defaults to DIRECT_PEERING.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.Instance.ConnectMode connect_mode = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for connectMode.
     */
    @java.lang.Override
    public int getConnectModeValue() {
      return connectMode_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The network connect mode of the Redis instance.
     * If not provided, the connect mode defaults to DIRECT_PEERING.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.Instance.ConnectMode connect_mode = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for connectMode to set.
     * @return This builder for chaining.
     */
    public Builder setConnectModeValue(int value) {
      connectMode_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The network connect mode of the Redis instance.
     * If not provided, the connect mode defaults to DIRECT_PEERING.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.Instance.ConnectMode connect_mode = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The connectMode.
     */
    @java.lang.Override
    public com.google.cloud.redis.v1.Instance.ConnectMode getConnectMode() {
      com.google.cloud.redis.v1.Instance.ConnectMode result =
          com.google.cloud.redis.v1.Instance.ConnectMode.forNumber(connectMode_);
      return result == null ? com.google.cloud.redis.v1.Instance.ConnectMode.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The network connect mode of the Redis instance.
     * If not provided, the connect mode defaults to DIRECT_PEERING.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.Instance.ConnectMode connect_mode = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The connectMode to set.
     * @return This builder for chaining.
     */
    public Builder setConnectMode(com.google.cloud.redis.v1.Instance.ConnectMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00080000;
      connectMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The network connect mode of the Redis instance.
     * If not provided, the connect mode defaults to DIRECT_PEERING.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.Instance.ConnectMode connect_mode = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConnectMode() {
      bitField0_ = (bitField0_ & ~0x00080000);
      connectMode_ = 0;
      onChanged();
      return this;
    }

    private boolean authEnabled_;
    /**
     *
     *
     * <pre>
     * Optional. Indicates whether OSS Redis AUTH is enabled for the instance. If
     * set to "true" AUTH is enabled on the instance. Default value is "false"
     * meaning AUTH is disabled.
     * </pre>
     *
     * <code>bool auth_enabled = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The authEnabled.
     */
    @java.lang.Override
    public boolean getAuthEnabled() {
      return authEnabled_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates whether OSS Redis AUTH is enabled for the instance. If
     * set to "true" AUTH is enabled on the instance. Default value is "false"
     * meaning AUTH is disabled.
     * </pre>
     *
     * <code>bool auth_enabled = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The authEnabled to set.
     * @return This builder for chaining.
     */
    public Builder setAuthEnabled(boolean value) {

      authEnabled_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates whether OSS Redis AUTH is enabled for the instance. If
     * set to "true" AUTH is enabled on the instance. Default value is "false"
     * meaning AUTH is disabled.
     * </pre>
     *
     * <code>bool auth_enabled = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAuthEnabled() {
      bitField0_ = (bitField0_ & ~0x00100000);
      authEnabled_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.redis.v1.TlsCertificate> serverCaCerts_ =
        java.util.Collections.emptyList();

    private void ensureServerCaCertsIsMutable() {
      if (!((bitField0_ & 0x00200000) != 0)) {
        serverCaCerts_ =
            new java.util.ArrayList<com.google.cloud.redis.v1.TlsCertificate>(serverCaCerts_);
        bitField0_ |= 0x00200000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.redis.v1.TlsCertificate,
            com.google.cloud.redis.v1.TlsCertificate.Builder,
            com.google.cloud.redis.v1.TlsCertificateOrBuilder>
        serverCaCertsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. List of server CA certificates for the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.TlsCertificate server_ca_certs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.redis.v1.TlsCertificate> getServerCaCertsList() {
      if (serverCaCertsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(serverCaCerts_);
      } else {
        return serverCaCertsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. List of server CA certificates for the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.TlsCertificate server_ca_certs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getServerCaCertsCount() {
      if (serverCaCertsBuilder_ == null) {
        return serverCaCerts_.size();
      } else {
        return serverCaCertsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. List of server CA certificates for the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.TlsCertificate server_ca_certs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.redis.v1.TlsCertificate getServerCaCerts(int index) {
      if (serverCaCertsBuilder_ == null) {
        return serverCaCerts_.get(index);
      } else {
        return serverCaCertsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. List of server CA certificates for the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.TlsCertificate server_ca_certs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setServerCaCerts(int index, com.google.cloud.redis.v1.TlsCertificate value) {
      if (serverCaCertsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServerCaCertsIsMutable();
        serverCaCerts_.set(index, value);
        onChanged();
      } else {
        serverCaCertsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of server CA certificates for the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.TlsCertificate server_ca_certs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setServerCaCerts(
        int index, com.google.cloud.redis.v1.TlsCertificate.Builder builderForValue) {
      if (serverCaCertsBuilder_ == null) {
        ensureServerCaCertsIsMutable();
        serverCaCerts_.set(index, builderForValue.build());
        onChanged();
      } else {
        serverCaCertsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of server CA certificates for the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.TlsCertificate server_ca_certs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addServerCaCerts(com.google.cloud.redis.v1.TlsCertificate value) {
      if (serverCaCertsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServerCaCertsIsMutable();
        serverCaCerts_.add(value);
        onChanged();
      } else {
        serverCaCertsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of server CA certificates for the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.TlsCertificate server_ca_certs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addServerCaCerts(int index, com.google.cloud.redis.v1.TlsCertificate value) {
      if (serverCaCertsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServerCaCertsIsMutable();
        serverCaCerts_.add(index, value);
        onChanged();
      } else {
        serverCaCertsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of server CA certificates for the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.TlsCertificate server_ca_certs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addServerCaCerts(
        com.google.cloud.redis.v1.TlsCertificate.Builder builderForValue) {
      if (serverCaCertsBuilder_ == null) {
        ensureServerCaCertsIsMutable();
        serverCaCerts_.add(builderForValue.build());
        onChanged();
      } else {
        serverCaCertsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of server CA certificates for the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.TlsCertificate server_ca_certs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addServerCaCerts(
        int index, com.google.cloud.redis.v1.TlsCertificate.Builder builderForValue) {
      if (serverCaCertsBuilder_ == null) {
        ensureServerCaCertsIsMutable();
        serverCaCerts_.add(index, builderForValue.build());
        onChanged();
      } else {
        serverCaCertsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of server CA certificates for the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.TlsCertificate server_ca_certs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllServerCaCerts(
        java.lang.Iterable<? extends com.google.cloud.redis.v1.TlsCertificate> values) {
      if (serverCaCertsBuilder_ == null) {
        ensureServerCaCertsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, serverCaCerts_);
        onChanged();
      } else {
        serverCaCertsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of server CA certificates for the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.TlsCertificate server_ca_certs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearServerCaCerts() {
      if (serverCaCertsBuilder_ == null) {
        serverCaCerts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00200000);
        onChanged();
      } else {
        serverCaCertsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of server CA certificates for the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.TlsCertificate server_ca_certs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeServerCaCerts(int index) {
      if (serverCaCertsBuilder_ == null) {
        ensureServerCaCertsIsMutable();
        serverCaCerts_.remove(index);
        onChanged();
      } else {
        serverCaCertsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of server CA certificates for the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.TlsCertificate server_ca_certs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.redis.v1.TlsCertificate.Builder getServerCaCertsBuilder(int index) {
      return getServerCaCertsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. List of server CA certificates for the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.TlsCertificate server_ca_certs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.redis.v1.TlsCertificateOrBuilder getServerCaCertsOrBuilder(int index) {
      if (serverCaCertsBuilder_ == null) {
        return serverCaCerts_.get(index);
      } else {
        return serverCaCertsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. List of server CA certificates for the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.TlsCertificate server_ca_certs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.redis.v1.TlsCertificateOrBuilder>
        getServerCaCertsOrBuilderList() {
      if (serverCaCertsBuilder_ != null) {
        return serverCaCertsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(serverCaCerts_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. List of server CA certificates for the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.TlsCertificate server_ca_certs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.redis.v1.TlsCertificate.Builder addServerCaCertsBuilder() {
      return getServerCaCertsFieldBuilder()
          .addBuilder(com.google.cloud.redis.v1.TlsCertificate.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. List of server CA certificates for the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.TlsCertificate server_ca_certs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.redis.v1.TlsCertificate.Builder addServerCaCertsBuilder(int index) {
      return getServerCaCertsFieldBuilder()
          .addBuilder(index, com.google.cloud.redis.v1.TlsCertificate.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. List of server CA certificates for the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.TlsCertificate server_ca_certs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.redis.v1.TlsCertificate.Builder>
        getServerCaCertsBuilderList() {
      return getServerCaCertsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.redis.v1.TlsCertificate,
            com.google.cloud.redis.v1.TlsCertificate.Builder,
            com.google.cloud.redis.v1.TlsCertificateOrBuilder>
        getServerCaCertsFieldBuilder() {
      if (serverCaCertsBuilder_ == null) {
        serverCaCertsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.redis.v1.TlsCertificate,
                com.google.cloud.redis.v1.TlsCertificate.Builder,
                com.google.cloud.redis.v1.TlsCertificateOrBuilder>(
                serverCaCerts_,
                ((bitField0_ & 0x00200000) != 0),
                getParentForChildren(),
                isClean());
        serverCaCerts_ = null;
      }
      return serverCaCertsBuilder_;
    }

    private int transitEncryptionMode_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The TLS mode of the Redis instance.
     * If not provided, TLS is disabled for the instance.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.Instance.TransitEncryptionMode transit_encryption_mode = 26 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for transitEncryptionMode.
     */
    @java.lang.Override
    public int getTransitEncryptionModeValue() {
      return transitEncryptionMode_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The TLS mode of the Redis instance.
     * If not provided, TLS is disabled for the instance.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.Instance.TransitEncryptionMode transit_encryption_mode = 26 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for transitEncryptionMode to set.
     * @return This builder for chaining.
     */
    public Builder setTransitEncryptionModeValue(int value) {
      transitEncryptionMode_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The TLS mode of the Redis instance.
     * If not provided, TLS is disabled for the instance.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.Instance.TransitEncryptionMode transit_encryption_mode = 26 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The transitEncryptionMode.
     */
    @java.lang.Override
    public com.google.cloud.redis.v1.Instance.TransitEncryptionMode getTransitEncryptionMode() {
      com.google.cloud.redis.v1.Instance.TransitEncryptionMode result =
          com.google.cloud.redis.v1.Instance.TransitEncryptionMode.forNumber(
              transitEncryptionMode_);
      return result == null
          ? com.google.cloud.redis.v1.Instance.TransitEncryptionMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The TLS mode of the Redis instance.
     * If not provided, TLS is disabled for the instance.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.Instance.TransitEncryptionMode transit_encryption_mode = 26 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The transitEncryptionMode to set.
     * @return This builder for chaining.
     */
    public Builder setTransitEncryptionMode(
        com.google.cloud.redis.v1.Instance.TransitEncryptionMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00400000;
      transitEncryptionMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The TLS mode of the Redis instance.
     * If not provided, TLS is disabled for the instance.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.Instance.TransitEncryptionMode transit_encryption_mode = 26 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransitEncryptionMode() {
      bitField0_ = (bitField0_ & ~0x00400000);
      transitEncryptionMode_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.redis.v1.MaintenancePolicy maintenancePolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.redis.v1.MaintenancePolicy,
            com.google.cloud.redis.v1.MaintenancePolicy.Builder,
            com.google.cloud.redis.v1.MaintenancePolicyOrBuilder>
        maintenancePolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The maintenance policy for the instance. If not provided,
     * maintenance events can be performed at any time.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.MaintenancePolicy maintenance_policy = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the maintenancePolicy field is set.
     */
    public boolean hasMaintenancePolicy() {
      return ((bitField0_ & 0x00800000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The maintenance policy for the instance. If not provided,
     * maintenance events can be performed at any time.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.MaintenancePolicy maintenance_policy = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The maintenancePolicy.
     */
    public com.google.cloud.redis.v1.MaintenancePolicy getMaintenancePolicy() {
      if (maintenancePolicyBuilder_ == null) {
        return maintenancePolicy_ == null
            ? com.google.cloud.redis.v1.MaintenancePolicy.getDefaultInstance()
            : maintenancePolicy_;
      } else {
        return maintenancePolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The maintenance policy for the instance. If not provided,
     * maintenance events can be performed at any time.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.MaintenancePolicy maintenance_policy = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMaintenancePolicy(com.google.cloud.redis.v1.MaintenancePolicy value) {
      if (maintenancePolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maintenancePolicy_ = value;
      } else {
        maintenancePolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The maintenance policy for the instance. If not provided,
     * maintenance events can be performed at any time.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.MaintenancePolicy maintenance_policy = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMaintenancePolicy(
        com.google.cloud.redis.v1.MaintenancePolicy.Builder builderForValue) {
      if (maintenancePolicyBuilder_ == null) {
        maintenancePolicy_ = builderForValue.build();
      } else {
        maintenancePolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The maintenance policy for the instance. If not provided,
     * maintenance events can be performed at any time.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.MaintenancePolicy maintenance_policy = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeMaintenancePolicy(com.google.cloud.redis.v1.MaintenancePolicy value) {
      if (maintenancePolicyBuilder_ == null) {
        if (((bitField0_ & 0x00800000) != 0)
            && maintenancePolicy_ != null
            && maintenancePolicy_
                != com.google.cloud.redis.v1.MaintenancePolicy.getDefaultInstance()) {
          getMaintenancePolicyBuilder().mergeFrom(value);
        } else {
          maintenancePolicy_ = value;
        }
      } else {
        maintenancePolicyBuilder_.mergeFrom(value);
      }
      if (maintenancePolicy_ != null) {
        bitField0_ |= 0x00800000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The maintenance policy for the instance. If not provided,
     * maintenance events can be performed at any time.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.MaintenancePolicy maintenance_policy = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMaintenancePolicy() {
      bitField0_ = (bitField0_ & ~0x00800000);
      maintenancePolicy_ = null;
      if (maintenancePolicyBuilder_ != null) {
        maintenancePolicyBuilder_.dispose();
        maintenancePolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The maintenance policy for the instance. If not provided,
     * maintenance events can be performed at any time.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.MaintenancePolicy maintenance_policy = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.redis.v1.MaintenancePolicy.Builder getMaintenancePolicyBuilder() {
      bitField0_ |= 0x00800000;
      onChanged();
      return getMaintenancePolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The maintenance policy for the instance. If not provided,
     * maintenance events can be performed at any time.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.MaintenancePolicy maintenance_policy = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.redis.v1.MaintenancePolicyOrBuilder getMaintenancePolicyOrBuilder() {
      if (maintenancePolicyBuilder_ != null) {
        return maintenancePolicyBuilder_.getMessageOrBuilder();
      } else {
        return maintenancePolicy_ == null
            ? com.google.cloud.redis.v1.MaintenancePolicy.getDefaultInstance()
            : maintenancePolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The maintenance policy for the instance. If not provided,
     * maintenance events can be performed at any time.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.MaintenancePolicy maintenance_policy = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.redis.v1.MaintenancePolicy,
            com.google.cloud.redis.v1.MaintenancePolicy.Builder,
            com.google.cloud.redis.v1.MaintenancePolicyOrBuilder>
        getMaintenancePolicyFieldBuilder() {
      if (maintenancePolicyBuilder_ == null) {
        maintenancePolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.redis.v1.MaintenancePolicy,
                com.google.cloud.redis.v1.MaintenancePolicy.Builder,
                com.google.cloud.redis.v1.MaintenancePolicyOrBuilder>(
                getMaintenancePolicy(), getParentForChildren(), isClean());
        maintenancePolicy_ = null;
      }
      return maintenancePolicyBuilder_;
    }

    private com.google.cloud.redis.v1.MaintenanceSchedule maintenanceSchedule_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.redis.v1.MaintenanceSchedule,
            com.google.cloud.redis.v1.MaintenanceSchedule.Builder,
            com.google.cloud.redis.v1.MaintenanceScheduleOrBuilder>
        maintenanceScheduleBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Date and time of upcoming maintenance events which have been
     * scheduled.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.MaintenanceSchedule maintenance_schedule = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the maintenanceSchedule field is set.
     */
    public boolean hasMaintenanceSchedule() {
      return ((bitField0_ & 0x01000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Date and time of upcoming maintenance events which have been
     * scheduled.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.MaintenanceSchedule maintenance_schedule = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The maintenanceSchedule.
     */
    public com.google.cloud.redis.v1.MaintenanceSchedule getMaintenanceSchedule() {
      if (maintenanceScheduleBuilder_ == null) {
        return maintenanceSchedule_ == null
            ? com.google.cloud.redis.v1.MaintenanceSchedule.getDefaultInstance()
            : maintenanceSchedule_;
      } else {
        return maintenanceScheduleBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Date and time of upcoming maintenance events which have been
     * scheduled.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.MaintenanceSchedule maintenance_schedule = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMaintenanceSchedule(com.google.cloud.redis.v1.MaintenanceSchedule value) {
      if (maintenanceScheduleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maintenanceSchedule_ = value;
      } else {
        maintenanceScheduleBuilder_.setMessage(value);
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Date and time of upcoming maintenance events which have been
     * scheduled.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.MaintenanceSchedule maintenance_schedule = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMaintenanceSchedule(
        com.google.cloud.redis.v1.MaintenanceSchedule.Builder builderForValue) {
      if (maintenanceScheduleBuilder_ == null) {
        maintenanceSchedule_ = builderForValue.build();
      } else {
        maintenanceScheduleBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Date and time of upcoming maintenance events which have been
     * scheduled.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.MaintenanceSchedule maintenance_schedule = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeMaintenanceSchedule(com.google.cloud.redis.v1.MaintenanceSchedule value) {
      if (maintenanceScheduleBuilder_ == null) {
        if (((bitField0_ & 0x01000000) != 0)
            && maintenanceSchedule_ != null
            && maintenanceSchedule_
                != com.google.cloud.redis.v1.MaintenanceSchedule.getDefaultInstance()) {
          getMaintenanceScheduleBuilder().mergeFrom(value);
        } else {
          maintenanceSchedule_ = value;
        }
      } else {
        maintenanceScheduleBuilder_.mergeFrom(value);
      }
      if (maintenanceSchedule_ != null) {
        bitField0_ |= 0x01000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Date and time of upcoming maintenance events which have been
     * scheduled.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.MaintenanceSchedule maintenance_schedule = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMaintenanceSchedule() {
      bitField0_ = (bitField0_ & ~0x01000000);
      maintenanceSchedule_ = null;
      if (maintenanceScheduleBuilder_ != null) {
        maintenanceScheduleBuilder_.dispose();
        maintenanceScheduleBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Date and time of upcoming maintenance events which have been
     * scheduled.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.MaintenanceSchedule maintenance_schedule = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.redis.v1.MaintenanceSchedule.Builder getMaintenanceScheduleBuilder() {
      bitField0_ |= 0x01000000;
      onChanged();
      return getMaintenanceScheduleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Date and time of upcoming maintenance events which have been
     * scheduled.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.MaintenanceSchedule maintenance_schedule = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.redis.v1.MaintenanceScheduleOrBuilder
        getMaintenanceScheduleOrBuilder() {
      if (maintenanceScheduleBuilder_ != null) {
        return maintenanceScheduleBuilder_.getMessageOrBuilder();
      } else {
        return maintenanceSchedule_ == null
            ? com.google.cloud.redis.v1.MaintenanceSchedule.getDefaultInstance()
            : maintenanceSchedule_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Date and time of upcoming maintenance events which have been
     * scheduled.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.MaintenanceSchedule maintenance_schedule = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.redis.v1.MaintenanceSchedule,
            com.google.cloud.redis.v1.MaintenanceSchedule.Builder,
            com.google.cloud.redis.v1.MaintenanceScheduleOrBuilder>
        getMaintenanceScheduleFieldBuilder() {
      if (maintenanceScheduleBuilder_ == null) {
        maintenanceScheduleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.redis.v1.MaintenanceSchedule,
                com.google.cloud.redis.v1.MaintenanceSchedule.Builder,
                com.google.cloud.redis.v1.MaintenanceScheduleOrBuilder>(
                getMaintenanceSchedule(), getParentForChildren(), isClean());
        maintenanceSchedule_ = null;
      }
      return maintenanceScheduleBuilder_;
    }

    private int replicaCount_;
    /**
     *
     *
     * <pre>
     * Optional. The number of replica nodes. The valid range for the Standard
     * Tier with read replicas enabled is [1-5] and defaults to 2. If read
     * replicas are not enabled for a Standard Tier instance, the only valid value
     * is 1 and the default is 1. The valid value for basic tier is 0 and the
     * default is also 0.
     * </pre>
     *
     * <code>int32 replica_count = 31 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The replicaCount.
     */
    @java.lang.Override
    public int getReplicaCount() {
      return replicaCount_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The number of replica nodes. The valid range for the Standard
     * Tier with read replicas enabled is [1-5] and defaults to 2. If read
     * replicas are not enabled for a Standard Tier instance, the only valid value
     * is 1 and the default is 1. The valid value for basic tier is 0 and the
     * default is also 0.
     * </pre>
     *
     * <code>int32 replica_count = 31 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The replicaCount to set.
     * @return This builder for chaining.
     */
    public Builder setReplicaCount(int value) {

      replicaCount_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The number of replica nodes. The valid range for the Standard
     * Tier with read replicas enabled is [1-5] and defaults to 2. If read
     * replicas are not enabled for a Standard Tier instance, the only valid value
     * is 1 and the default is 1. The valid value for basic tier is 0 and the
     * default is also 0.
     * </pre>
     *
     * <code>int32 replica_count = 31 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReplicaCount() {
      bitField0_ = (bitField0_ & ~0x02000000);
      replicaCount_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.redis.v1.NodeInfo> nodes_ =
        java.util.Collections.emptyList();

    private void ensureNodesIsMutable() {
      if (!((bitField0_ & 0x04000000) != 0)) {
        nodes_ = new java.util.ArrayList<com.google.cloud.redis.v1.NodeInfo>(nodes_);
        bitField0_ |= 0x04000000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.redis.v1.NodeInfo,
            com.google.cloud.redis.v1.NodeInfo.Builder,
            com.google.cloud.redis.v1.NodeInfoOrBuilder>
        nodesBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Info per node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.NodeInfo nodes = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.redis.v1.NodeInfo> getNodesList() {
      if (nodesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(nodes_);
      } else {
        return nodesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Info per node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.NodeInfo nodes = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getNodesCount() {
      if (nodesBuilder_ == null) {
        return nodes_.size();
      } else {
        return nodesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Info per node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.NodeInfo nodes = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.redis.v1.NodeInfo getNodes(int index) {
      if (nodesBuilder_ == null) {
        return nodes_.get(index);
      } else {
        return nodesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Info per node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.NodeInfo nodes = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setNodes(int index, com.google.cloud.redis.v1.NodeInfo value) {
      if (nodesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodesIsMutable();
        nodes_.set(index, value);
        onChanged();
      } else {
        nodesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Info per node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.NodeInfo nodes = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setNodes(int index, com.google.cloud.redis.v1.NodeInfo.Builder builderForValue) {
      if (nodesBuilder_ == null) {
        ensureNodesIsMutable();
        nodes_.set(index, builderForValue.build());
        onChanged();
      } else {
        nodesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Info per node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.NodeInfo nodes = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addNodes(com.google.cloud.redis.v1.NodeInfo value) {
      if (nodesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodesIsMutable();
        nodes_.add(value);
        onChanged();
      } else {
        nodesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Info per node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.NodeInfo nodes = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addNodes(int index, com.google.cloud.redis.v1.NodeInfo value) {
      if (nodesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodesIsMutable();
        nodes_.add(index, value);
        onChanged();
      } else {
        nodesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Info per node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.NodeInfo nodes = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addNodes(com.google.cloud.redis.v1.NodeInfo.Builder builderForValue) {
      if (nodesBuilder_ == null) {
        ensureNodesIsMutable();
        nodes_.add(builderForValue.build());
        onChanged();
      } else {
        nodesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Info per node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.NodeInfo nodes = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addNodes(int index, com.google.cloud.redis.v1.NodeInfo.Builder builderForValue) {
      if (nodesBuilder_ == null) {
        ensureNodesIsMutable();
        nodes_.add(index, builderForValue.build());
        onChanged();
      } else {
        nodesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Info per node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.NodeInfo nodes = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllNodes(
        java.lang.Iterable<? extends com.google.cloud.redis.v1.NodeInfo> values) {
      if (nodesBuilder_ == null) {
        ensureNodesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, nodes_);
        onChanged();
      } else {
        nodesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Info per node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.NodeInfo nodes = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearNodes() {
      if (nodesBuilder_ == null) {
        nodes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x04000000);
        onChanged();
      } else {
        nodesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Info per node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.NodeInfo nodes = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeNodes(int index) {
      if (nodesBuilder_ == null) {
        ensureNodesIsMutable();
        nodes_.remove(index);
        onChanged();
      } else {
        nodesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Info per node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.NodeInfo nodes = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.redis.v1.NodeInfo.Builder getNodesBuilder(int index) {
      return getNodesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Info per node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.NodeInfo nodes = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.redis.v1.NodeInfoOrBuilder getNodesOrBuilder(int index) {
      if (nodesBuilder_ == null) {
        return nodes_.get(index);
      } else {
        return nodesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Info per node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.NodeInfo nodes = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.redis.v1.NodeInfoOrBuilder>
        getNodesOrBuilderList() {
      if (nodesBuilder_ != null) {
        return nodesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(nodes_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Info per node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.NodeInfo nodes = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.redis.v1.NodeInfo.Builder addNodesBuilder() {
      return getNodesFieldBuilder()
          .addBuilder(com.google.cloud.redis.v1.NodeInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Info per node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.NodeInfo nodes = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.redis.v1.NodeInfo.Builder addNodesBuilder(int index) {
      return getNodesFieldBuilder()
          .addBuilder(index, com.google.cloud.redis.v1.NodeInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Info per node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.NodeInfo nodes = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.redis.v1.NodeInfo.Builder> getNodesBuilderList() {
      return getNodesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.redis.v1.NodeInfo,
            com.google.cloud.redis.v1.NodeInfo.Builder,
            com.google.cloud.redis.v1.NodeInfoOrBuilder>
        getNodesFieldBuilder() {
      if (nodesBuilder_ == null) {
        nodesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.redis.v1.NodeInfo,
                com.google.cloud.redis.v1.NodeInfo.Builder,
                com.google.cloud.redis.v1.NodeInfoOrBuilder>(
                nodes_, ((bitField0_ & 0x04000000) != 0), getParentForChildren(), isClean());
        nodes_ = null;
      }
      return nodesBuilder_;
    }

    private java.lang.Object readEndpoint_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Hostname or IP address of the exposed readonly Redis
     * endpoint. Standard tier only. Targets all healthy replica nodes in
     * instance. Replication is asynchronous and replica nodes will exhibit some
     * lag behind the primary. Write requests must target 'host'.
     * </pre>
     *
     * <code>string read_endpoint = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The readEndpoint.
     */
    public java.lang.String getReadEndpoint() {
      java.lang.Object ref = readEndpoint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        readEndpoint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Hostname or IP address of the exposed readonly Redis
     * endpoint. Standard tier only. Targets all healthy replica nodes in
     * instance. Replication is asynchronous and replica nodes will exhibit some
     * lag behind the primary. Write requests must target 'host'.
     * </pre>
     *
     * <code>string read_endpoint = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for readEndpoint.
     */
    public com.google.protobuf.ByteString getReadEndpointBytes() {
      java.lang.Object ref = readEndpoint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        readEndpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Hostname or IP address of the exposed readonly Redis
     * endpoint. Standard tier only. Targets all healthy replica nodes in
     * instance. Replication is asynchronous and replica nodes will exhibit some
     * lag behind the primary. Write requests must target 'host'.
     * </pre>
     *
     * <code>string read_endpoint = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The readEndpoint to set.
     * @return This builder for chaining.
     */
    public Builder setReadEndpoint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      readEndpoint_ = value;
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Hostname or IP address of the exposed readonly Redis
     * endpoint. Standard tier only. Targets all healthy replica nodes in
     * instance. Replication is asynchronous and replica nodes will exhibit some
     * lag behind the primary. Write requests must target 'host'.
     * </pre>
     *
     * <code>string read_endpoint = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReadEndpoint() {
      readEndpoint_ = getDefaultInstance().getReadEndpoint();
      bitField0_ = (bitField0_ & ~0x08000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Hostname or IP address of the exposed readonly Redis
     * endpoint. Standard tier only. Targets all healthy replica nodes in
     * instance. Replication is asynchronous and replica nodes will exhibit some
     * lag behind the primary. Write requests must target 'host'.
     * </pre>
     *
     * <code>string read_endpoint = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for readEndpoint to set.
     * @return This builder for chaining.
     */
    public Builder setReadEndpointBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      readEndpoint_ = value;
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }

    private int readEndpointPort_;
    /**
     *
     *
     * <pre>
     * Output only. The port number of the exposed readonly redis
     * endpoint. Standard tier only. Write requests should target 'port'.
     * </pre>
     *
     * <code>int32 read_endpoint_port = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The readEndpointPort.
     */
    @java.lang.Override
    public int getReadEndpointPort() {
      return readEndpointPort_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The port number of the exposed readonly redis
     * endpoint. Standard tier only. Write requests should target 'port'.
     * </pre>
     *
     * <code>int32 read_endpoint_port = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The readEndpointPort to set.
     * @return This builder for chaining.
     */
    public Builder setReadEndpointPort(int value) {

      readEndpointPort_ = value;
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The port number of the exposed readonly redis
     * endpoint. Standard tier only. Write requests should target 'port'.
     * </pre>
     *
     * <code>int32 read_endpoint_port = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReadEndpointPort() {
      bitField0_ = (bitField0_ & ~0x10000000);
      readEndpointPort_ = 0;
      onChanged();
      return this;
    }

    private int readReplicasMode_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Read replicas mode for the instance. Defaults to
     * READ_REPLICAS_DISABLED.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.Instance.ReadReplicasMode read_replicas_mode = 35 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for readReplicasMode.
     */
    @java.lang.Override
    public int getReadReplicasModeValue() {
      return readReplicasMode_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Read replicas mode for the instance. Defaults to
     * READ_REPLICAS_DISABLED.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.Instance.ReadReplicasMode read_replicas_mode = 35 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for readReplicasMode to set.
     * @return This builder for chaining.
     */
    public Builder setReadReplicasModeValue(int value) {
      readReplicasMode_ = value;
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Read replicas mode for the instance. Defaults to
     * READ_REPLICAS_DISABLED.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.Instance.ReadReplicasMode read_replicas_mode = 35 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The readReplicasMode.
     */
    @java.lang.Override
    public com.google.cloud.redis.v1.Instance.ReadReplicasMode getReadReplicasMode() {
      com.google.cloud.redis.v1.Instance.ReadReplicasMode result =
          com.google.cloud.redis.v1.Instance.ReadReplicasMode.forNumber(readReplicasMode_);
      return result == null
          ? com.google.cloud.redis.v1.Instance.ReadReplicasMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Read replicas mode for the instance. Defaults to
     * READ_REPLICAS_DISABLED.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.Instance.ReadReplicasMode read_replicas_mode = 35 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The readReplicasMode to set.
     * @return This builder for chaining.
     */
    public Builder setReadReplicasMode(com.google.cloud.redis.v1.Instance.ReadReplicasMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x20000000;
      readReplicasMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Read replicas mode for the instance. Defaults to
     * READ_REPLICAS_DISABLED.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.Instance.ReadReplicasMode read_replicas_mode = 35 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReadReplicasMode() {
      bitField0_ = (bitField0_ & ~0x20000000);
      readReplicasMode_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object customerManagedKey_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The KMS key reference that the customer provides when trying to
     * create the instance.
     * </pre>
     *
     * <code>string customer_managed_key = 36 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The customerManagedKey.
     */
    public java.lang.String getCustomerManagedKey() {
      java.lang.Object ref = customerManagedKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        customerManagedKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The KMS key reference that the customer provides when trying to
     * create the instance.
     * </pre>
     *
     * <code>string customer_managed_key = 36 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for customerManagedKey.
     */
    public com.google.protobuf.ByteString getCustomerManagedKeyBytes() {
      java.lang.Object ref = customerManagedKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        customerManagedKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The KMS key reference that the customer provides when trying to
     * create the instance.
     * </pre>
     *
     * <code>string customer_managed_key = 36 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The customerManagedKey to set.
     * @return This builder for chaining.
     */
    public Builder setCustomerManagedKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      customerManagedKey_ = value;
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The KMS key reference that the customer provides when trying to
     * create the instance.
     * </pre>
     *
     * <code>string customer_managed_key = 36 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomerManagedKey() {
      customerManagedKey_ = getDefaultInstance().getCustomerManagedKey();
      bitField0_ = (bitField0_ & ~0x40000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The KMS key reference that the customer provides when trying to
     * create the instance.
     * </pre>
     *
     * <code>string customer_managed_key = 36 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for customerManagedKey to set.
     * @return This builder for chaining.
     */
    public Builder setCustomerManagedKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      customerManagedKey_ = value;
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }

    private com.google.cloud.redis.v1.PersistenceConfig persistenceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.redis.v1.PersistenceConfig,
            com.google.cloud.redis.v1.PersistenceConfig.Builder,
            com.google.cloud.redis.v1.PersistenceConfigOrBuilder>
        persistenceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Persistence configuration parameters
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.PersistenceConfig persistence_config = 37 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the persistenceConfig field is set.
     */
    public boolean hasPersistenceConfig() {
      return ((bitField0_ & 0x80000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Persistence configuration parameters
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.PersistenceConfig persistence_config = 37 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The persistenceConfig.
     */
    public com.google.cloud.redis.v1.PersistenceConfig getPersistenceConfig() {
      if (persistenceConfigBuilder_ == null) {
        return persistenceConfig_ == null
            ? com.google.cloud.redis.v1.PersistenceConfig.getDefaultInstance()
            : persistenceConfig_;
      } else {
        return persistenceConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Persistence configuration parameters
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.PersistenceConfig persistence_config = 37 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPersistenceConfig(com.google.cloud.redis.v1.PersistenceConfig value) {
      if (persistenceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        persistenceConfig_ = value;
      } else {
        persistenceConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Persistence configuration parameters
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.PersistenceConfig persistence_config = 37 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPersistenceConfig(
        com.google.cloud.redis.v1.PersistenceConfig.Builder builderForValue) {
      if (persistenceConfigBuilder_ == null) {
        persistenceConfig_ = builderForValue.build();
      } else {
        persistenceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Persistence configuration parameters
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.PersistenceConfig persistence_config = 37 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePersistenceConfig(com.google.cloud.redis.v1.PersistenceConfig value) {
      if (persistenceConfigBuilder_ == null) {
        if (((bitField0_ & 0x80000000) != 0)
            && persistenceConfig_ != null
            && persistenceConfig_
                != com.google.cloud.redis.v1.PersistenceConfig.getDefaultInstance()) {
          getPersistenceConfigBuilder().mergeFrom(value);
        } else {
          persistenceConfig_ = value;
        }
      } else {
        persistenceConfigBuilder_.mergeFrom(value);
      }
      if (persistenceConfig_ != null) {
        bitField0_ |= 0x80000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Persistence configuration parameters
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.PersistenceConfig persistence_config = 37 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPersistenceConfig() {
      bitField0_ = (bitField0_ & ~0x80000000);
      persistenceConfig_ = null;
      if (persistenceConfigBuilder_ != null) {
        persistenceConfigBuilder_.dispose();
        persistenceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Persistence configuration parameters
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.PersistenceConfig persistence_config = 37 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.redis.v1.PersistenceConfig.Builder getPersistenceConfigBuilder() {
      bitField0_ |= 0x80000000;
      onChanged();
      return getPersistenceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Persistence configuration parameters
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.PersistenceConfig persistence_config = 37 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.redis.v1.PersistenceConfigOrBuilder getPersistenceConfigOrBuilder() {
      if (persistenceConfigBuilder_ != null) {
        return persistenceConfigBuilder_.getMessageOrBuilder();
      } else {
        return persistenceConfig_ == null
            ? com.google.cloud.redis.v1.PersistenceConfig.getDefaultInstance()
            : persistenceConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Persistence configuration parameters
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.PersistenceConfig persistence_config = 37 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.redis.v1.PersistenceConfig,
            com.google.cloud.redis.v1.PersistenceConfig.Builder,
            com.google.cloud.redis.v1.PersistenceConfigOrBuilder>
        getPersistenceConfigFieldBuilder() {
      if (persistenceConfigBuilder_ == null) {
        persistenceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.redis.v1.PersistenceConfig,
                com.google.cloud.redis.v1.PersistenceConfig.Builder,
                com.google.cloud.redis.v1.PersistenceConfigOrBuilder>(
                getPersistenceConfig(), getParentForChildren(), isClean());
        persistenceConfig_ = null;
      }
      return persistenceConfigBuilder_;
    }

    private java.util.List<java.lang.Integer> suspensionReasons_ =
        java.util.Collections.emptyList();

    private void ensureSuspensionReasonsIsMutable() {
      if (!((bitField1_ & 0x00000001) != 0)) {
        suspensionReasons_ = new java.util.ArrayList<java.lang.Integer>(suspensionReasons_);
        bitField1_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. reasons that causes instance in "SUSPENDED" state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.Instance.SuspensionReason suspension_reasons = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the suspensionReasons.
     */
    public java.util.List<com.google.cloud.redis.v1.Instance.SuspensionReason>
        getSuspensionReasonsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.redis.v1.Instance.SuspensionReason>(
          suspensionReasons_, suspensionReasons_converter_);
    }
    /**
     *
     *
     * <pre>
     * Optional. reasons that causes instance in "SUSPENDED" state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.Instance.SuspensionReason suspension_reasons = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of suspensionReasons.
     */
    public int getSuspensionReasonsCount() {
      return suspensionReasons_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. reasons that causes instance in "SUSPENDED" state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.Instance.SuspensionReason suspension_reasons = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The suspensionReasons at the given index.
     */
    public com.google.cloud.redis.v1.Instance.SuspensionReason getSuspensionReasons(int index) {
      return suspensionReasons_converter_.convert(suspensionReasons_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Optional. reasons that causes instance in "SUSPENDED" state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.Instance.SuspensionReason suspension_reasons = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The suspensionReasons to set.
     * @return This builder for chaining.
     */
    public Builder setSuspensionReasons(
        int index, com.google.cloud.redis.v1.Instance.SuspensionReason value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSuspensionReasonsIsMutable();
      suspensionReasons_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. reasons that causes instance in "SUSPENDED" state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.Instance.SuspensionReason suspension_reasons = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The suspensionReasons to add.
     * @return This builder for chaining.
     */
    public Builder addSuspensionReasons(com.google.cloud.redis.v1.Instance.SuspensionReason value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSuspensionReasonsIsMutable();
      suspensionReasons_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. reasons that causes instance in "SUSPENDED" state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.Instance.SuspensionReason suspension_reasons = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The suspensionReasons to add.
     * @return This builder for chaining.
     */
    public Builder addAllSuspensionReasons(
        java.lang.Iterable<? extends com.google.cloud.redis.v1.Instance.SuspensionReason> values) {
      ensureSuspensionReasonsIsMutable();
      for (com.google.cloud.redis.v1.Instance.SuspensionReason value : values) {
        suspensionReasons_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. reasons that causes instance in "SUSPENDED" state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.Instance.SuspensionReason suspension_reasons = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSuspensionReasons() {
      suspensionReasons_ = java.util.Collections.emptyList();
      bitField1_ = (bitField1_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. reasons that causes instance in "SUSPENDED" state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.Instance.SuspensionReason suspension_reasons = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for suspensionReasons.
     */
    public java.util.List<java.lang.Integer> getSuspensionReasonsValueList() {
      return java.util.Collections.unmodifiableList(suspensionReasons_);
    }
    /**
     *
     *
     * <pre>
     * Optional. reasons that causes instance in "SUSPENDED" state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.Instance.SuspensionReason suspension_reasons = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of suspensionReasons at the given index.
     */
    public int getSuspensionReasonsValue(int index) {
      return suspensionReasons_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. reasons that causes instance in "SUSPENDED" state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.Instance.SuspensionReason suspension_reasons = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for suspensionReasons to set.
     * @return This builder for chaining.
     */
    public Builder setSuspensionReasonsValue(int index, int value) {
      ensureSuspensionReasonsIsMutable();
      suspensionReasons_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. reasons that causes instance in "SUSPENDED" state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.Instance.SuspensionReason suspension_reasons = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for suspensionReasons to add.
     * @return This builder for chaining.
     */
    public Builder addSuspensionReasonsValue(int value) {
      ensureSuspensionReasonsIsMutable();
      suspensionReasons_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. reasons that causes instance in "SUSPENDED" state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1.Instance.SuspensionReason suspension_reasons = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The enum numeric values on the wire for suspensionReasons to add.
     * @return This builder for chaining.
     */
    public Builder addAllSuspensionReasonsValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureSuspensionReasonsIsMutable();
      for (int value : values) {
        suspensionReasons_.add(value);
      }
      onChanged();
      return this;
    }

    private java.lang.Object maintenanceVersion_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The self service update maintenance version.
     * The version is date based such as "20210712_00_00".
     * </pre>
     *
     * <code>string maintenance_version = 39 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The maintenanceVersion.
     */
    public java.lang.String getMaintenanceVersion() {
      java.lang.Object ref = maintenanceVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        maintenanceVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The self service update maintenance version.
     * The version is date based such as "20210712_00_00".
     * </pre>
     *
     * <code>string maintenance_version = 39 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for maintenanceVersion.
     */
    public com.google.protobuf.ByteString getMaintenanceVersionBytes() {
      java.lang.Object ref = maintenanceVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        maintenanceVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The self service update maintenance version.
     * The version is date based such as "20210712_00_00".
     * </pre>
     *
     * <code>string maintenance_version = 39 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The maintenanceVersion to set.
     * @return This builder for chaining.
     */
    public Builder setMaintenanceVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      maintenanceVersion_ = value;
      bitField1_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The self service update maintenance version.
     * The version is date based such as "20210712_00_00".
     * </pre>
     *
     * <code>string maintenance_version = 39 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaintenanceVersion() {
      maintenanceVersion_ = getDefaultInstance().getMaintenanceVersion();
      bitField1_ = (bitField1_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The self service update maintenance version.
     * The version is date based such as "20210712_00_00".
     * </pre>
     *
     * <code>string maintenance_version = 39 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for maintenanceVersion to set.
     * @return This builder for chaining.
     */
    public Builder setMaintenanceVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      maintenanceVersion_ = value;
      bitField1_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList availableMaintenanceVersions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAvailableMaintenanceVersionsIsMutable() {
      if (!availableMaintenanceVersions_.isModifiable()) {
        availableMaintenanceVersions_ =
            new com.google.protobuf.LazyStringArrayList(availableMaintenanceVersions_);
      }
      bitField1_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Optional. The available maintenance versions that an instance could update
     * to.
     * </pre>
     *
     * <code>
     * repeated string available_maintenance_versions = 40 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the availableMaintenanceVersions.
     */
    public com.google.protobuf.ProtocolStringList getAvailableMaintenanceVersionsList() {
      availableMaintenanceVersions_.makeImmutable();
      return availableMaintenanceVersions_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The available maintenance versions that an instance could update
     * to.
     * </pre>
     *
     * <code>
     * repeated string available_maintenance_versions = 40 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of availableMaintenanceVersions.
     */
    public int getAvailableMaintenanceVersionsCount() {
      return availableMaintenanceVersions_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The available maintenance versions that an instance could update
     * to.
     * </pre>
     *
     * <code>
     * repeated string available_maintenance_versions = 40 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The availableMaintenanceVersions at the given index.
     */
    public java.lang.String getAvailableMaintenanceVersions(int index) {
      return availableMaintenanceVersions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The available maintenance versions that an instance could update
     * to.
     * </pre>
     *
     * <code>
     * repeated string available_maintenance_versions = 40 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the availableMaintenanceVersions at the given index.
     */
    public com.google.protobuf.ByteString getAvailableMaintenanceVersionsBytes(int index) {
      return availableMaintenanceVersions_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The available maintenance versions that an instance could update
     * to.
     * </pre>
     *
     * <code>
     * repeated string available_maintenance_versions = 40 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The availableMaintenanceVersions to set.
     * @return This builder for chaining.
     */
    public Builder setAvailableMaintenanceVersions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAvailableMaintenanceVersionsIsMutable();
      availableMaintenanceVersions_.set(index, value);
      bitField1_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The available maintenance versions that an instance could update
     * to.
     * </pre>
     *
     * <code>
     * repeated string available_maintenance_versions = 40 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The availableMaintenanceVersions to add.
     * @return This builder for chaining.
     */
    public Builder addAvailableMaintenanceVersions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAvailableMaintenanceVersionsIsMutable();
      availableMaintenanceVersions_.add(value);
      bitField1_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The available maintenance versions that an instance could update
     * to.
     * </pre>
     *
     * <code>
     * repeated string available_maintenance_versions = 40 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The availableMaintenanceVersions to add.
     * @return This builder for chaining.
     */
    public Builder addAllAvailableMaintenanceVersions(java.lang.Iterable<java.lang.String> values) {
      ensureAvailableMaintenanceVersionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, availableMaintenanceVersions_);
      bitField1_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The available maintenance versions that an instance could update
     * to.
     * </pre>
     *
     * <code>
     * repeated string available_maintenance_versions = 40 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAvailableMaintenanceVersions() {
      availableMaintenanceVersions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField1_ = (bitField1_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The available maintenance versions that an instance could update
     * to.
     * </pre>
     *
     * <code>
     * repeated string available_maintenance_versions = 40 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes of the availableMaintenanceVersions to add.
     * @return This builder for chaining.
     */
    public Builder addAvailableMaintenanceVersionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAvailableMaintenanceVersionsIsMutable();
      availableMaintenanceVersions_.add(value);
      bitField1_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.redis.v1.Instance)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.redis.v1.Instance)
  private static final com.google.cloud.redis.v1.Instance DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.redis.v1.Instance();
  }

  public static com.google.cloud.redis.v1.Instance getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Instance> PARSER =
      new com.google.protobuf.AbstractParser<Instance>() {
        @java.lang.Override
        public Instance parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Instance> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Instance> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.redis.v1.Instance getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
