/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/redis/v1/cloud_redis.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.redis.v1;

/**
 *
 *
 * <pre>
 * Configuration of the persistence functionality.
 * </pre>
 *
 * Protobuf type {@code google.cloud.redis.v1.PersistenceConfig}
 */
public final class PersistenceConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.redis.v1.PersistenceConfig)
    PersistenceConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PersistenceConfig.newBuilder() to construct.
  private PersistenceConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PersistenceConfig() {
    persistenceMode_ = 0;
    rdbSnapshotPeriod_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PersistenceConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.redis.v1.CloudRedisServiceV1Proto
        .internal_static_google_cloud_redis_v1_PersistenceConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.redis.v1.CloudRedisServiceV1Proto
        .internal_static_google_cloud_redis_v1_PersistenceConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.redis.v1.PersistenceConfig.class,
            com.google.cloud.redis.v1.PersistenceConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Available Persistence modes.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.redis.v1.PersistenceConfig.PersistenceMode}
   */
  public enum PersistenceMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>PERSISTENCE_MODE_UNSPECIFIED = 0;</code>
     */
    PERSISTENCE_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Persistence is disabled for the instance,
     * and any existing snapshots are deleted.
     * </pre>
     *
     * <code>DISABLED = 1;</code>
     */
    DISABLED(1),
    /**
     *
     *
     * <pre>
     * RDB based Persistence is enabled.
     * </pre>
     *
     * <code>RDB = 2;</code>
     */
    RDB(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>PERSISTENCE_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int PERSISTENCE_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Persistence is disabled for the instance,
     * and any existing snapshots are deleted.
     * </pre>
     *
     * <code>DISABLED = 1;</code>
     */
    public static final int DISABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * RDB based Persistence is enabled.
     * </pre>
     *
     * <code>RDB = 2;</code>
     */
    public static final int RDB_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PersistenceMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PersistenceMode forNumber(int value) {
      switch (value) {
        case 0:
          return PERSISTENCE_MODE_UNSPECIFIED;
        case 1:
          return DISABLED;
        case 2:
          return RDB;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PersistenceMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PersistenceMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<PersistenceMode>() {
              public PersistenceMode findValueByNumber(int number) {
                return PersistenceMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.redis.v1.PersistenceConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final PersistenceMode[] VALUES = values();

    public static PersistenceMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PersistenceMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.redis.v1.PersistenceConfig.PersistenceMode)
  }

  /**
   *
   *
   * <pre>
   * Available snapshot periods for scheduling.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.redis.v1.PersistenceConfig.SnapshotPeriod}
   */
  public enum SnapshotPeriod implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>SNAPSHOT_PERIOD_UNSPECIFIED = 0;</code>
     */
    SNAPSHOT_PERIOD_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Snapshot every 1 hour.
     * </pre>
     *
     * <code>ONE_HOUR = 3;</code>
     */
    ONE_HOUR(3),
    /**
     *
     *
     * <pre>
     * Snapshot every 6 hours.
     * </pre>
     *
     * <code>SIX_HOURS = 4;</code>
     */
    SIX_HOURS(4),
    /**
     *
     *
     * <pre>
     * Snapshot every 12 hours.
     * </pre>
     *
     * <code>TWELVE_HOURS = 5;</code>
     */
    TWELVE_HOURS(5),
    /**
     *
     *
     * <pre>
     * Snapshot every 24 hours.
     * </pre>
     *
     * <code>TWENTY_FOUR_HOURS = 6;</code>
     */
    TWENTY_FOUR_HOURS(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>SNAPSHOT_PERIOD_UNSPECIFIED = 0;</code>
     */
    public static final int SNAPSHOT_PERIOD_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Snapshot every 1 hour.
     * </pre>
     *
     * <code>ONE_HOUR = 3;</code>
     */
    public static final int ONE_HOUR_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Snapshot every 6 hours.
     * </pre>
     *
     * <code>SIX_HOURS = 4;</code>
     */
    public static final int SIX_HOURS_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Snapshot every 12 hours.
     * </pre>
     *
     * <code>TWELVE_HOURS = 5;</code>
     */
    public static final int TWELVE_HOURS_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Snapshot every 24 hours.
     * </pre>
     *
     * <code>TWENTY_FOUR_HOURS = 6;</code>
     */
    public static final int TWENTY_FOUR_HOURS_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SnapshotPeriod valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SnapshotPeriod forNumber(int value) {
      switch (value) {
        case 0:
          return SNAPSHOT_PERIOD_UNSPECIFIED;
        case 3:
          return ONE_HOUR;
        case 4:
          return SIX_HOURS;
        case 5:
          return TWELVE_HOURS;
        case 6:
          return TWENTY_FOUR_HOURS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SnapshotPeriod> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SnapshotPeriod> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<SnapshotPeriod>() {
          public SnapshotPeriod findValueByNumber(int number) {
            return SnapshotPeriod.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.redis.v1.PersistenceConfig.getDescriptor().getEnumTypes().get(1);
    }

    private static final SnapshotPeriod[] VALUES = values();

    public static SnapshotPeriod valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SnapshotPeriod(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.redis.v1.PersistenceConfig.SnapshotPeriod)
  }

  private int bitField0_;
  public static final int PERSISTENCE_MODE_FIELD_NUMBER = 1;
  private int persistenceMode_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Controls whether Persistence features are enabled.
   * If not provided, the existing value will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1.PersistenceConfig.PersistenceMode persistence_mode = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for persistenceMode.
   */
  @java.lang.Override
  public int getPersistenceModeValue() {
    return persistenceMode_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Controls whether Persistence features are enabled.
   * If not provided, the existing value will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1.PersistenceConfig.PersistenceMode persistence_mode = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The persistenceMode.
   */
  @java.lang.Override
  public com.google.cloud.redis.v1.PersistenceConfig.PersistenceMode getPersistenceMode() {
    com.google.cloud.redis.v1.PersistenceConfig.PersistenceMode result =
        com.google.cloud.redis.v1.PersistenceConfig.PersistenceMode.forNumber(persistenceMode_);
    return result == null
        ? com.google.cloud.redis.v1.PersistenceConfig.PersistenceMode.UNRECOGNIZED
        : result;
  }

  public static final int RDB_SNAPSHOT_PERIOD_FIELD_NUMBER = 2;
  private int rdbSnapshotPeriod_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Period between RDB snapshots. Snapshots will be attempted every
   * period starting from the provided snapshot start time. For example, a start
   * time of 01/01/2033 06:45 and SIX_HOURS snapshot period will do nothing
   * until 01/01/2033, and then trigger snapshots every day at 06:45, 12:45,
   * 18:45, and 00:45 the next day, and so on. If not provided,
   * TWENTY_FOUR_HOURS will be used as default.
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1.PersistenceConfig.SnapshotPeriod rdb_snapshot_period = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for rdbSnapshotPeriod.
   */
  @java.lang.Override
  public int getRdbSnapshotPeriodValue() {
    return rdbSnapshotPeriod_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Period between RDB snapshots. Snapshots will be attempted every
   * period starting from the provided snapshot start time. For example, a start
   * time of 01/01/2033 06:45 and SIX_HOURS snapshot period will do nothing
   * until 01/01/2033, and then trigger snapshots every day at 06:45, 12:45,
   * 18:45, and 00:45 the next day, and so on. If not provided,
   * TWENTY_FOUR_HOURS will be used as default.
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1.PersistenceConfig.SnapshotPeriod rdb_snapshot_period = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The rdbSnapshotPeriod.
   */
  @java.lang.Override
  public com.google.cloud.redis.v1.PersistenceConfig.SnapshotPeriod getRdbSnapshotPeriod() {
    com.google.cloud.redis.v1.PersistenceConfig.SnapshotPeriod result =
        com.google.cloud.redis.v1.PersistenceConfig.SnapshotPeriod.forNumber(rdbSnapshotPeriod_);
    return result == null
        ? com.google.cloud.redis.v1.PersistenceConfig.SnapshotPeriod.UNRECOGNIZED
        : result;
  }

  public static final int RDB_NEXT_SNAPSHOT_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp rdbNextSnapshotTime_;
  /**
   *
   *
   * <pre>
   * Output only. The next time that a snapshot attempt is scheduled to occur.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp rdb_next_snapshot_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the rdbNextSnapshotTime field is set.
   */
  @java.lang.Override
  public boolean hasRdbNextSnapshotTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The next time that a snapshot attempt is scheduled to occur.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp rdb_next_snapshot_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The rdbNextSnapshotTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getRdbNextSnapshotTime() {
    return rdbNextSnapshotTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : rdbNextSnapshotTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The next time that a snapshot attempt is scheduled to occur.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp rdb_next_snapshot_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getRdbNextSnapshotTimeOrBuilder() {
    return rdbNextSnapshotTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : rdbNextSnapshotTime_;
  }

  public static final int RDB_SNAPSHOT_START_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp rdbSnapshotStartTime_;
  /**
   *
   *
   * <pre>
   * Optional. Date and time that the first snapshot was/will be attempted, and
   * to which future snapshots will be aligned. If not provided, the current
   * time will be used.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp rdb_snapshot_start_time = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the rdbSnapshotStartTime field is set.
   */
  @java.lang.Override
  public boolean hasRdbSnapshotStartTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Date and time that the first snapshot was/will be attempted, and
   * to which future snapshots will be aligned. If not provided, the current
   * time will be used.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp rdb_snapshot_start_time = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The rdbSnapshotStartTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getRdbSnapshotStartTime() {
    return rdbSnapshotStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : rdbSnapshotStartTime_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Date and time that the first snapshot was/will be attempted, and
   * to which future snapshots will be aligned. If not provided, the current
   * time will be used.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp rdb_snapshot_start_time = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getRdbSnapshotStartTimeOrBuilder() {
    return rdbSnapshotStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : rdbSnapshotStartTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (persistenceMode_
        != com.google.cloud.redis.v1.PersistenceConfig.PersistenceMode.PERSISTENCE_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, persistenceMode_);
    }
    if (rdbSnapshotPeriod_
        != com.google.cloud.redis.v1.PersistenceConfig.SnapshotPeriod.SNAPSHOT_PERIOD_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, rdbSnapshotPeriod_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getRdbNextSnapshotTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getRdbSnapshotStartTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (persistenceMode_
        != com.google.cloud.redis.v1.PersistenceConfig.PersistenceMode.PERSISTENCE_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, persistenceMode_);
    }
    if (rdbSnapshotPeriod_
        != com.google.cloud.redis.v1.PersistenceConfig.SnapshotPeriod.SNAPSHOT_PERIOD_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, rdbSnapshotPeriod_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getRdbNextSnapshotTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(5, getRdbSnapshotStartTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.redis.v1.PersistenceConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.redis.v1.PersistenceConfig other =
        (com.google.cloud.redis.v1.PersistenceConfig) obj;

    if (persistenceMode_ != other.persistenceMode_) return false;
    if (rdbSnapshotPeriod_ != other.rdbSnapshotPeriod_) return false;
    if (hasRdbNextSnapshotTime() != other.hasRdbNextSnapshotTime()) return false;
    if (hasRdbNextSnapshotTime()) {
      if (!getRdbNextSnapshotTime().equals(other.getRdbNextSnapshotTime())) return false;
    }
    if (hasRdbSnapshotStartTime() != other.hasRdbSnapshotStartTime()) return false;
    if (hasRdbSnapshotStartTime()) {
      if (!getRdbSnapshotStartTime().equals(other.getRdbSnapshotStartTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PERSISTENCE_MODE_FIELD_NUMBER;
    hash = (53 * hash) + persistenceMode_;
    hash = (37 * hash) + RDB_SNAPSHOT_PERIOD_FIELD_NUMBER;
    hash = (53 * hash) + rdbSnapshotPeriod_;
    if (hasRdbNextSnapshotTime()) {
      hash = (37 * hash) + RDB_NEXT_SNAPSHOT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getRdbNextSnapshotTime().hashCode();
    }
    if (hasRdbSnapshotStartTime()) {
      hash = (37 * hash) + RDB_SNAPSHOT_START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getRdbSnapshotStartTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.redis.v1.PersistenceConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.redis.v1.PersistenceConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.redis.v1.PersistenceConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.redis.v1.PersistenceConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.redis.v1.PersistenceConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.redis.v1.PersistenceConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.redis.v1.PersistenceConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.redis.v1.PersistenceConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.redis.v1.PersistenceConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.redis.v1.PersistenceConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.redis.v1.PersistenceConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.redis.v1.PersistenceConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.redis.v1.PersistenceConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration of the persistence functionality.
   * </pre>
   *
   * Protobuf type {@code google.cloud.redis.v1.PersistenceConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.redis.v1.PersistenceConfig)
      com.google.cloud.redis.v1.PersistenceConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.redis.v1.CloudRedisServiceV1Proto
          .internal_static_google_cloud_redis_v1_PersistenceConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.redis.v1.CloudRedisServiceV1Proto
          .internal_static_google_cloud_redis_v1_PersistenceConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.redis.v1.PersistenceConfig.class,
              com.google.cloud.redis.v1.PersistenceConfig.Builder.class);
    }

    // Construct using com.google.cloud.redis.v1.PersistenceConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getRdbNextSnapshotTimeFieldBuilder();
        getRdbSnapshotStartTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      persistenceMode_ = 0;
      rdbSnapshotPeriod_ = 0;
      rdbNextSnapshotTime_ = null;
      if (rdbNextSnapshotTimeBuilder_ != null) {
        rdbNextSnapshotTimeBuilder_.dispose();
        rdbNextSnapshotTimeBuilder_ = null;
      }
      rdbSnapshotStartTime_ = null;
      if (rdbSnapshotStartTimeBuilder_ != null) {
        rdbSnapshotStartTimeBuilder_.dispose();
        rdbSnapshotStartTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.redis.v1.CloudRedisServiceV1Proto
          .internal_static_google_cloud_redis_v1_PersistenceConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.redis.v1.PersistenceConfig getDefaultInstanceForType() {
      return com.google.cloud.redis.v1.PersistenceConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.redis.v1.PersistenceConfig build() {
      com.google.cloud.redis.v1.PersistenceConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.redis.v1.PersistenceConfig buildPartial() {
      com.google.cloud.redis.v1.PersistenceConfig result =
          new com.google.cloud.redis.v1.PersistenceConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.redis.v1.PersistenceConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.persistenceMode_ = persistenceMode_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.rdbSnapshotPeriod_ = rdbSnapshotPeriod_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.rdbNextSnapshotTime_ =
            rdbNextSnapshotTimeBuilder_ == null
                ? rdbNextSnapshotTime_
                : rdbNextSnapshotTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.rdbSnapshotStartTime_ =
            rdbSnapshotStartTimeBuilder_ == null
                ? rdbSnapshotStartTime_
                : rdbSnapshotStartTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.redis.v1.PersistenceConfig) {
        return mergeFrom((com.google.cloud.redis.v1.PersistenceConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.redis.v1.PersistenceConfig other) {
      if (other == com.google.cloud.redis.v1.PersistenceConfig.getDefaultInstance()) return this;
      if (other.persistenceMode_ != 0) {
        setPersistenceModeValue(other.getPersistenceModeValue());
      }
      if (other.rdbSnapshotPeriod_ != 0) {
        setRdbSnapshotPeriodValue(other.getRdbSnapshotPeriodValue());
      }
      if (other.hasRdbNextSnapshotTime()) {
        mergeRdbNextSnapshotTime(other.getRdbNextSnapshotTime());
      }
      if (other.hasRdbSnapshotStartTime()) {
        mergeRdbSnapshotStartTime(other.getRdbSnapshotStartTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                persistenceMode_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                rdbSnapshotPeriod_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 34:
              {
                input.readMessage(
                    getRdbNextSnapshotTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getRdbSnapshotStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int persistenceMode_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Controls whether Persistence features are enabled.
     * If not provided, the existing value will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.PersistenceConfig.PersistenceMode persistence_mode = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for persistenceMode.
     */
    @java.lang.Override
    public int getPersistenceModeValue() {
      return persistenceMode_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Controls whether Persistence features are enabled.
     * If not provided, the existing value will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.PersistenceConfig.PersistenceMode persistence_mode = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for persistenceMode to set.
     * @return This builder for chaining.
     */
    public Builder setPersistenceModeValue(int value) {
      persistenceMode_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Controls whether Persistence features are enabled.
     * If not provided, the existing value will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.PersistenceConfig.PersistenceMode persistence_mode = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The persistenceMode.
     */
    @java.lang.Override
    public com.google.cloud.redis.v1.PersistenceConfig.PersistenceMode getPersistenceMode() {
      com.google.cloud.redis.v1.PersistenceConfig.PersistenceMode result =
          com.google.cloud.redis.v1.PersistenceConfig.PersistenceMode.forNumber(persistenceMode_);
      return result == null
          ? com.google.cloud.redis.v1.PersistenceConfig.PersistenceMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Controls whether Persistence features are enabled.
     * If not provided, the existing value will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.PersistenceConfig.PersistenceMode persistence_mode = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The persistenceMode to set.
     * @return This builder for chaining.
     */
    public Builder setPersistenceMode(
        com.google.cloud.redis.v1.PersistenceConfig.PersistenceMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      persistenceMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Controls whether Persistence features are enabled.
     * If not provided, the existing value will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.PersistenceConfig.PersistenceMode persistence_mode = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPersistenceMode() {
      bitField0_ = (bitField0_ & ~0x00000001);
      persistenceMode_ = 0;
      onChanged();
      return this;
    }

    private int rdbSnapshotPeriod_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Period between RDB snapshots. Snapshots will be attempted every
     * period starting from the provided snapshot start time. For example, a start
     * time of 01/01/2033 06:45 and SIX_HOURS snapshot period will do nothing
     * until 01/01/2033, and then trigger snapshots every day at 06:45, 12:45,
     * 18:45, and 00:45 the next day, and so on. If not provided,
     * TWENTY_FOUR_HOURS will be used as default.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.PersistenceConfig.SnapshotPeriod rdb_snapshot_period = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for rdbSnapshotPeriod.
     */
    @java.lang.Override
    public int getRdbSnapshotPeriodValue() {
      return rdbSnapshotPeriod_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Period between RDB snapshots. Snapshots will be attempted every
     * period starting from the provided snapshot start time. For example, a start
     * time of 01/01/2033 06:45 and SIX_HOURS snapshot period will do nothing
     * until 01/01/2033, and then trigger snapshots every day at 06:45, 12:45,
     * 18:45, and 00:45 the next day, and so on. If not provided,
     * TWENTY_FOUR_HOURS will be used as default.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.PersistenceConfig.SnapshotPeriod rdb_snapshot_period = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for rdbSnapshotPeriod to set.
     * @return This builder for chaining.
     */
    public Builder setRdbSnapshotPeriodValue(int value) {
      rdbSnapshotPeriod_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Period between RDB snapshots. Snapshots will be attempted every
     * period starting from the provided snapshot start time. For example, a start
     * time of 01/01/2033 06:45 and SIX_HOURS snapshot period will do nothing
     * until 01/01/2033, and then trigger snapshots every day at 06:45, 12:45,
     * 18:45, and 00:45 the next day, and so on. If not provided,
     * TWENTY_FOUR_HOURS will be used as default.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.PersistenceConfig.SnapshotPeriod rdb_snapshot_period = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The rdbSnapshotPeriod.
     */
    @java.lang.Override
    public com.google.cloud.redis.v1.PersistenceConfig.SnapshotPeriod getRdbSnapshotPeriod() {
      com.google.cloud.redis.v1.PersistenceConfig.SnapshotPeriod result =
          com.google.cloud.redis.v1.PersistenceConfig.SnapshotPeriod.forNumber(rdbSnapshotPeriod_);
      return result == null
          ? com.google.cloud.redis.v1.PersistenceConfig.SnapshotPeriod.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Period between RDB snapshots. Snapshots will be attempted every
     * period starting from the provided snapshot start time. For example, a start
     * time of 01/01/2033 06:45 and SIX_HOURS snapshot period will do nothing
     * until 01/01/2033, and then trigger snapshots every day at 06:45, 12:45,
     * 18:45, and 00:45 the next day, and so on. If not provided,
     * TWENTY_FOUR_HOURS will be used as default.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.PersistenceConfig.SnapshotPeriod rdb_snapshot_period = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The rdbSnapshotPeriod to set.
     * @return This builder for chaining.
     */
    public Builder setRdbSnapshotPeriod(
        com.google.cloud.redis.v1.PersistenceConfig.SnapshotPeriod value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      rdbSnapshotPeriod_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Period between RDB snapshots. Snapshots will be attempted every
     * period starting from the provided snapshot start time. For example, a start
     * time of 01/01/2033 06:45 and SIX_HOURS snapshot period will do nothing
     * until 01/01/2033, and then trigger snapshots every day at 06:45, 12:45,
     * 18:45, and 00:45 the next day, and so on. If not provided,
     * TWENTY_FOUR_HOURS will be used as default.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1.PersistenceConfig.SnapshotPeriod rdb_snapshot_period = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRdbSnapshotPeriod() {
      bitField0_ = (bitField0_ & ~0x00000002);
      rdbSnapshotPeriod_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp rdbNextSnapshotTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        rdbNextSnapshotTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The next time that a snapshot attempt is scheduled to occur.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp rdb_next_snapshot_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the rdbNextSnapshotTime field is set.
     */
    public boolean hasRdbNextSnapshotTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The next time that a snapshot attempt is scheduled to occur.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp rdb_next_snapshot_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The rdbNextSnapshotTime.
     */
    public com.google.protobuf.Timestamp getRdbNextSnapshotTime() {
      if (rdbNextSnapshotTimeBuilder_ == null) {
        return rdbNextSnapshotTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : rdbNextSnapshotTime_;
      } else {
        return rdbNextSnapshotTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The next time that a snapshot attempt is scheduled to occur.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp rdb_next_snapshot_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRdbNextSnapshotTime(com.google.protobuf.Timestamp value) {
      if (rdbNextSnapshotTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rdbNextSnapshotTime_ = value;
      } else {
        rdbNextSnapshotTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The next time that a snapshot attempt is scheduled to occur.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp rdb_next_snapshot_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRdbNextSnapshotTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (rdbNextSnapshotTimeBuilder_ == null) {
        rdbNextSnapshotTime_ = builderForValue.build();
      } else {
        rdbNextSnapshotTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The next time that a snapshot attempt is scheduled to occur.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp rdb_next_snapshot_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeRdbNextSnapshotTime(com.google.protobuf.Timestamp value) {
      if (rdbNextSnapshotTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && rdbNextSnapshotTime_ != null
            && rdbNextSnapshotTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getRdbNextSnapshotTimeBuilder().mergeFrom(value);
        } else {
          rdbNextSnapshotTime_ = value;
        }
      } else {
        rdbNextSnapshotTimeBuilder_.mergeFrom(value);
      }
      if (rdbNextSnapshotTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The next time that a snapshot attempt is scheduled to occur.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp rdb_next_snapshot_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRdbNextSnapshotTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      rdbNextSnapshotTime_ = null;
      if (rdbNextSnapshotTimeBuilder_ != null) {
        rdbNextSnapshotTimeBuilder_.dispose();
        rdbNextSnapshotTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The next time that a snapshot attempt is scheduled to occur.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp rdb_next_snapshot_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getRdbNextSnapshotTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getRdbNextSnapshotTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The next time that a snapshot attempt is scheduled to occur.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp rdb_next_snapshot_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getRdbNextSnapshotTimeOrBuilder() {
      if (rdbNextSnapshotTimeBuilder_ != null) {
        return rdbNextSnapshotTimeBuilder_.getMessageOrBuilder();
      } else {
        return rdbNextSnapshotTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : rdbNextSnapshotTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The next time that a snapshot attempt is scheduled to occur.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp rdb_next_snapshot_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getRdbNextSnapshotTimeFieldBuilder() {
      if (rdbNextSnapshotTimeBuilder_ == null) {
        rdbNextSnapshotTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getRdbNextSnapshotTime(), getParentForChildren(), isClean());
        rdbNextSnapshotTime_ = null;
      }
      return rdbNextSnapshotTimeBuilder_;
    }

    private com.google.protobuf.Timestamp rdbSnapshotStartTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        rdbSnapshotStartTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Date and time that the first snapshot was/will be attempted, and
     * to which future snapshots will be aligned. If not provided, the current
     * time will be used.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp rdb_snapshot_start_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the rdbSnapshotStartTime field is set.
     */
    public boolean hasRdbSnapshotStartTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Date and time that the first snapshot was/will be attempted, and
     * to which future snapshots will be aligned. If not provided, the current
     * time will be used.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp rdb_snapshot_start_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The rdbSnapshotStartTime.
     */
    public com.google.protobuf.Timestamp getRdbSnapshotStartTime() {
      if (rdbSnapshotStartTimeBuilder_ == null) {
        return rdbSnapshotStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : rdbSnapshotStartTime_;
      } else {
        return rdbSnapshotStartTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Date and time that the first snapshot was/will be attempted, and
     * to which future snapshots will be aligned. If not provided, the current
     * time will be used.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp rdb_snapshot_start_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRdbSnapshotStartTime(com.google.protobuf.Timestamp value) {
      if (rdbSnapshotStartTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rdbSnapshotStartTime_ = value;
      } else {
        rdbSnapshotStartTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Date and time that the first snapshot was/will be attempted, and
     * to which future snapshots will be aligned. If not provided, the current
     * time will be used.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp rdb_snapshot_start_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRdbSnapshotStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (rdbSnapshotStartTimeBuilder_ == null) {
        rdbSnapshotStartTime_ = builderForValue.build();
      } else {
        rdbSnapshotStartTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Date and time that the first snapshot was/will be attempted, and
     * to which future snapshots will be aligned. If not provided, the current
     * time will be used.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp rdb_snapshot_start_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRdbSnapshotStartTime(com.google.protobuf.Timestamp value) {
      if (rdbSnapshotStartTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && rdbSnapshotStartTime_ != null
            && rdbSnapshotStartTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getRdbSnapshotStartTimeBuilder().mergeFrom(value);
        } else {
          rdbSnapshotStartTime_ = value;
        }
      } else {
        rdbSnapshotStartTimeBuilder_.mergeFrom(value);
      }
      if (rdbSnapshotStartTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Date and time that the first snapshot was/will be attempted, and
     * to which future snapshots will be aligned. If not provided, the current
     * time will be used.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp rdb_snapshot_start_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRdbSnapshotStartTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      rdbSnapshotStartTime_ = null;
      if (rdbSnapshotStartTimeBuilder_ != null) {
        rdbSnapshotStartTimeBuilder_.dispose();
        rdbSnapshotStartTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Date and time that the first snapshot was/will be attempted, and
     * to which future snapshots will be aligned. If not provided, the current
     * time will be used.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp rdb_snapshot_start_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getRdbSnapshotStartTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getRdbSnapshotStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Date and time that the first snapshot was/will be attempted, and
     * to which future snapshots will be aligned. If not provided, the current
     * time will be used.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp rdb_snapshot_start_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getRdbSnapshotStartTimeOrBuilder() {
      if (rdbSnapshotStartTimeBuilder_ != null) {
        return rdbSnapshotStartTimeBuilder_.getMessageOrBuilder();
      } else {
        return rdbSnapshotStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : rdbSnapshotStartTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Date and time that the first snapshot was/will be attempted, and
     * to which future snapshots will be aligned. If not provided, the current
     * time will be used.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp rdb_snapshot_start_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getRdbSnapshotStartTimeFieldBuilder() {
      if (rdbSnapshotStartTimeBuilder_ == null) {
        rdbSnapshotStartTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getRdbSnapshotStartTime(), getParentForChildren(), isClean());
        rdbSnapshotStartTime_ = null;
      }
      return rdbSnapshotStartTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.redis.v1.PersistenceConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.redis.v1.PersistenceConfig)
  private static final com.google.cloud.redis.v1.PersistenceConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.redis.v1.PersistenceConfig();
  }

  public static com.google.cloud.redis.v1.PersistenceConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PersistenceConfig> PARSER =
      new com.google.protobuf.AbstractParser<PersistenceConfig>() {
        @java.lang.Override
        public PersistenceConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PersistenceConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PersistenceConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.redis.v1.PersistenceConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
