/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/redis/v1beta1/cloud_redis.proto

package com.google.cloud.redis.v1beta1;

/**
 *
 *
 * <pre>
 * Maintenance policy for an instance.
 * </pre>
 *
 * Protobuf type {@code google.cloud.redis.v1beta1.MaintenancePolicy}
 */
public final class MaintenancePolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.redis.v1beta1.MaintenancePolicy)
    MaintenancePolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MaintenancePolicy.newBuilder() to construct.
  private MaintenancePolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MaintenancePolicy() {
    description_ = "";
    weeklyMaintenanceWindow_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MaintenancePolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.redis.v1beta1.CloudRedisServiceBetaProto
        .internal_static_google_cloud_redis_v1beta1_MaintenancePolicy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.redis.v1beta1.CloudRedisServiceBetaProto
        .internal_static_google_cloud_redis_v1beta1_MaintenancePolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.redis.v1beta1.MaintenancePolicy.class,
            com.google.cloud.redis.v1beta1.MaintenancePolicy.Builder.class);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when the policy was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the policy was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the policy was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when the policy was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the policy was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the policy was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Description of what this policy is for. Create/Update methods
   * return INVALID_ARGUMENT if the length is greater than 512.
   * </pre>
   *
   * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Description of what this policy is for. Create/Update methods
   * return INVALID_ARGUMENT if the length is greater than 512.
   * </pre>
   *
   * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WEEKLY_MAINTENANCE_WINDOW_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow>
      weeklyMaintenanceWindow_;
  /**
   *
   *
   * <pre>
   * Optional. Maintenance window that is applied to resources covered by this
   * policy. Minimum 1. For the current version, the maximum number of
   * weekly_window is expected to be one.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.redis.v1beta1.WeeklyMaintenanceWindow weekly_maintenance_window = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow>
      getWeeklyMaintenanceWindowList() {
    return weeklyMaintenanceWindow_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Maintenance window that is applied to resources covered by this
   * policy. Minimum 1. For the current version, the maximum number of
   * weekly_window is expected to be one.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.redis.v1beta1.WeeklyMaintenanceWindow weekly_maintenance_window = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindowOrBuilder>
      getWeeklyMaintenanceWindowOrBuilderList() {
    return weeklyMaintenanceWindow_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Maintenance window that is applied to resources covered by this
   * policy. Minimum 1. For the current version, the maximum number of
   * weekly_window is expected to be one.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.redis.v1beta1.WeeklyMaintenanceWindow weekly_maintenance_window = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getWeeklyMaintenanceWindowCount() {
    return weeklyMaintenanceWindow_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Maintenance window that is applied to resources covered by this
   * policy. Minimum 1. For the current version, the maximum number of
   * weekly_window is expected to be one.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.redis.v1beta1.WeeklyMaintenanceWindow weekly_maintenance_window = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow getWeeklyMaintenanceWindow(
      int index) {
    return weeklyMaintenanceWindow_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Maintenance window that is applied to resources covered by this
   * policy. Minimum 1. For the current version, the maximum number of
   * weekly_window is expected to be one.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.redis.v1beta1.WeeklyMaintenanceWindow weekly_maintenance_window = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindowOrBuilder
      getWeeklyMaintenanceWindowOrBuilder(int index) {
    return weeklyMaintenanceWindow_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (createTime_ != null) {
      output.writeMessage(1, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(2, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    for (int i = 0; i < weeklyMaintenanceWindow_.size(); i++) {
      output.writeMessage(4, weeklyMaintenanceWindow_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    for (int i = 0; i < weeklyMaintenanceWindow_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, weeklyMaintenanceWindow_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.redis.v1beta1.MaintenancePolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.redis.v1beta1.MaintenancePolicy other =
        (com.google.cloud.redis.v1beta1.MaintenancePolicy) obj;

    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getWeeklyMaintenanceWindowList().equals(other.getWeeklyMaintenanceWindowList()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getWeeklyMaintenanceWindowCount() > 0) {
      hash = (37 * hash) + WEEKLY_MAINTENANCE_WINDOW_FIELD_NUMBER;
      hash = (53 * hash) + getWeeklyMaintenanceWindowList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.redis.v1beta1.MaintenancePolicy parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.redis.v1beta1.MaintenancePolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.redis.v1beta1.MaintenancePolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.redis.v1beta1.MaintenancePolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.redis.v1beta1.MaintenancePolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.redis.v1beta1.MaintenancePolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.redis.v1beta1.MaintenancePolicy parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.redis.v1beta1.MaintenancePolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.redis.v1beta1.MaintenancePolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.redis.v1beta1.MaintenancePolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.redis.v1beta1.MaintenancePolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.redis.v1beta1.MaintenancePolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.redis.v1beta1.MaintenancePolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Maintenance policy for an instance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.redis.v1beta1.MaintenancePolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.redis.v1beta1.MaintenancePolicy)
      com.google.cloud.redis.v1beta1.MaintenancePolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.redis.v1beta1.CloudRedisServiceBetaProto
          .internal_static_google_cloud_redis_v1beta1_MaintenancePolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.redis.v1beta1.CloudRedisServiceBetaProto
          .internal_static_google_cloud_redis_v1beta1_MaintenancePolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.redis.v1beta1.MaintenancePolicy.class,
              com.google.cloud.redis.v1beta1.MaintenancePolicy.Builder.class);
    }

    // Construct using com.google.cloud.redis.v1beta1.MaintenancePolicy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      description_ = "";
      if (weeklyMaintenanceWindowBuilder_ == null) {
        weeklyMaintenanceWindow_ = java.util.Collections.emptyList();
      } else {
        weeklyMaintenanceWindow_ = null;
        weeklyMaintenanceWindowBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.redis.v1beta1.CloudRedisServiceBetaProto
          .internal_static_google_cloud_redis_v1beta1_MaintenancePolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.redis.v1beta1.MaintenancePolicy getDefaultInstanceForType() {
      return com.google.cloud.redis.v1beta1.MaintenancePolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.redis.v1beta1.MaintenancePolicy build() {
      com.google.cloud.redis.v1beta1.MaintenancePolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.redis.v1beta1.MaintenancePolicy buildPartial() {
      com.google.cloud.redis.v1beta1.MaintenancePolicy result =
          new com.google.cloud.redis.v1beta1.MaintenancePolicy(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.redis.v1beta1.MaintenancePolicy result) {
      if (weeklyMaintenanceWindowBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          weeklyMaintenanceWindow_ =
              java.util.Collections.unmodifiableList(weeklyMaintenanceWindow_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.weeklyMaintenanceWindow_ = weeklyMaintenanceWindow_;
      } else {
        result.weeklyMaintenanceWindow_ = weeklyMaintenanceWindowBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.redis.v1beta1.MaintenancePolicy result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.redis.v1beta1.MaintenancePolicy) {
        return mergeFrom((com.google.cloud.redis.v1beta1.MaintenancePolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.redis.v1beta1.MaintenancePolicy other) {
      if (other == com.google.cloud.redis.v1beta1.MaintenancePolicy.getDefaultInstance())
        return this;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (weeklyMaintenanceWindowBuilder_ == null) {
        if (!other.weeklyMaintenanceWindow_.isEmpty()) {
          if (weeklyMaintenanceWindow_.isEmpty()) {
            weeklyMaintenanceWindow_ = other.weeklyMaintenanceWindow_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureWeeklyMaintenanceWindowIsMutable();
            weeklyMaintenanceWindow_.addAll(other.weeklyMaintenanceWindow_);
          }
          onChanged();
        }
      } else {
        if (!other.weeklyMaintenanceWindow_.isEmpty()) {
          if (weeklyMaintenanceWindowBuilder_.isEmpty()) {
            weeklyMaintenanceWindowBuilder_.dispose();
            weeklyMaintenanceWindowBuilder_ = null;
            weeklyMaintenanceWindow_ = other.weeklyMaintenanceWindow_;
            bitField0_ = (bitField0_ & ~0x00000008);
            weeklyMaintenanceWindowBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getWeeklyMaintenanceWindowFieldBuilder()
                    : null;
          } else {
            weeklyMaintenanceWindowBuilder_.addAllMessages(other.weeklyMaintenanceWindow_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow m =
                    input.readMessage(
                        com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow.parser(),
                        extensionRegistry);
                if (weeklyMaintenanceWindowBuilder_ == null) {
                  ensureWeeklyMaintenanceWindowIsMutable();
                  weeklyMaintenanceWindow_.add(m);
                } else {
                  weeklyMaintenanceWindowBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the policy was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the policy was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the policy was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the policy was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the policy was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the policy was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the policy was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the policy was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the policy was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the policy was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the policy was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the policy was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the policy was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the policy was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the policy was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the policy was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the policy was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the policy was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Description of what this policy is for. Create/Update methods
     * return INVALID_ARGUMENT if the length is greater than 512.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of what this policy is for. Create/Update methods
     * return INVALID_ARGUMENT if the length is greater than 512.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of what this policy is for. Create/Update methods
     * return INVALID_ARGUMENT if the length is greater than 512.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of what this policy is for. Create/Update methods
     * return INVALID_ARGUMENT if the length is greater than 512.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of what this policy is for. Create/Update methods
     * return INVALID_ARGUMENT if the length is greater than 512.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow>
        weeklyMaintenanceWindow_ = java.util.Collections.emptyList();

    private void ensureWeeklyMaintenanceWindowIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        weeklyMaintenanceWindow_ =
            new java.util.ArrayList<com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow>(
                weeklyMaintenanceWindow_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow,
            com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow.Builder,
            com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindowOrBuilder>
        weeklyMaintenanceWindowBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Maintenance window that is applied to resources covered by this
     * policy. Minimum 1. For the current version, the maximum number of
     * weekly_window is expected to be one.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1beta1.WeeklyMaintenanceWindow weekly_maintenance_window = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow>
        getWeeklyMaintenanceWindowList() {
      if (weeklyMaintenanceWindowBuilder_ == null) {
        return java.util.Collections.unmodifiableList(weeklyMaintenanceWindow_);
      } else {
        return weeklyMaintenanceWindowBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Maintenance window that is applied to resources covered by this
     * policy. Minimum 1. For the current version, the maximum number of
     * weekly_window is expected to be one.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1beta1.WeeklyMaintenanceWindow weekly_maintenance_window = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getWeeklyMaintenanceWindowCount() {
      if (weeklyMaintenanceWindowBuilder_ == null) {
        return weeklyMaintenanceWindow_.size();
      } else {
        return weeklyMaintenanceWindowBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Maintenance window that is applied to resources covered by this
     * policy. Minimum 1. For the current version, the maximum number of
     * weekly_window is expected to be one.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1beta1.WeeklyMaintenanceWindow weekly_maintenance_window = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow getWeeklyMaintenanceWindow(
        int index) {
      if (weeklyMaintenanceWindowBuilder_ == null) {
        return weeklyMaintenanceWindow_.get(index);
      } else {
        return weeklyMaintenanceWindowBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Maintenance window that is applied to resources covered by this
     * policy. Minimum 1. For the current version, the maximum number of
     * weekly_window is expected to be one.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1beta1.WeeklyMaintenanceWindow weekly_maintenance_window = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setWeeklyMaintenanceWindow(
        int index, com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow value) {
      if (weeklyMaintenanceWindowBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWeeklyMaintenanceWindowIsMutable();
        weeklyMaintenanceWindow_.set(index, value);
        onChanged();
      } else {
        weeklyMaintenanceWindowBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maintenance window that is applied to resources covered by this
     * policy. Minimum 1. For the current version, the maximum number of
     * weekly_window is expected to be one.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1beta1.WeeklyMaintenanceWindow weekly_maintenance_window = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setWeeklyMaintenanceWindow(
        int index, com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow.Builder builderForValue) {
      if (weeklyMaintenanceWindowBuilder_ == null) {
        ensureWeeklyMaintenanceWindowIsMutable();
        weeklyMaintenanceWindow_.set(index, builderForValue.build());
        onChanged();
      } else {
        weeklyMaintenanceWindowBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maintenance window that is applied to resources covered by this
     * policy. Minimum 1. For the current version, the maximum number of
     * weekly_window is expected to be one.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1beta1.WeeklyMaintenanceWindow weekly_maintenance_window = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addWeeklyMaintenanceWindow(
        com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow value) {
      if (weeklyMaintenanceWindowBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWeeklyMaintenanceWindowIsMutable();
        weeklyMaintenanceWindow_.add(value);
        onChanged();
      } else {
        weeklyMaintenanceWindowBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maintenance window that is applied to resources covered by this
     * policy. Minimum 1. For the current version, the maximum number of
     * weekly_window is expected to be one.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1beta1.WeeklyMaintenanceWindow weekly_maintenance_window = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addWeeklyMaintenanceWindow(
        int index, com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow value) {
      if (weeklyMaintenanceWindowBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWeeklyMaintenanceWindowIsMutable();
        weeklyMaintenanceWindow_.add(index, value);
        onChanged();
      } else {
        weeklyMaintenanceWindowBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maintenance window that is applied to resources covered by this
     * policy. Minimum 1. For the current version, the maximum number of
     * weekly_window is expected to be one.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1beta1.WeeklyMaintenanceWindow weekly_maintenance_window = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addWeeklyMaintenanceWindow(
        com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow.Builder builderForValue) {
      if (weeklyMaintenanceWindowBuilder_ == null) {
        ensureWeeklyMaintenanceWindowIsMutable();
        weeklyMaintenanceWindow_.add(builderForValue.build());
        onChanged();
      } else {
        weeklyMaintenanceWindowBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maintenance window that is applied to resources covered by this
     * policy. Minimum 1. For the current version, the maximum number of
     * weekly_window is expected to be one.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1beta1.WeeklyMaintenanceWindow weekly_maintenance_window = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addWeeklyMaintenanceWindow(
        int index, com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow.Builder builderForValue) {
      if (weeklyMaintenanceWindowBuilder_ == null) {
        ensureWeeklyMaintenanceWindowIsMutable();
        weeklyMaintenanceWindow_.add(index, builderForValue.build());
        onChanged();
      } else {
        weeklyMaintenanceWindowBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maintenance window that is applied to resources covered by this
     * policy. Minimum 1. For the current version, the maximum number of
     * weekly_window is expected to be one.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1beta1.WeeklyMaintenanceWindow weekly_maintenance_window = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllWeeklyMaintenanceWindow(
        java.lang.Iterable<? extends com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow>
            values) {
      if (weeklyMaintenanceWindowBuilder_ == null) {
        ensureWeeklyMaintenanceWindowIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, weeklyMaintenanceWindow_);
        onChanged();
      } else {
        weeklyMaintenanceWindowBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maintenance window that is applied to resources covered by this
     * policy. Minimum 1. For the current version, the maximum number of
     * weekly_window is expected to be one.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1beta1.WeeklyMaintenanceWindow weekly_maintenance_window = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearWeeklyMaintenanceWindow() {
      if (weeklyMaintenanceWindowBuilder_ == null) {
        weeklyMaintenanceWindow_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        weeklyMaintenanceWindowBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maintenance window that is applied to resources covered by this
     * policy. Minimum 1. For the current version, the maximum number of
     * weekly_window is expected to be one.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1beta1.WeeklyMaintenanceWindow weekly_maintenance_window = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeWeeklyMaintenanceWindow(int index) {
      if (weeklyMaintenanceWindowBuilder_ == null) {
        ensureWeeklyMaintenanceWindowIsMutable();
        weeklyMaintenanceWindow_.remove(index);
        onChanged();
      } else {
        weeklyMaintenanceWindowBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maintenance window that is applied to resources covered by this
     * policy. Minimum 1. For the current version, the maximum number of
     * weekly_window is expected to be one.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1beta1.WeeklyMaintenanceWindow weekly_maintenance_window = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow.Builder
        getWeeklyMaintenanceWindowBuilder(int index) {
      return getWeeklyMaintenanceWindowFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Maintenance window that is applied to resources covered by this
     * policy. Minimum 1. For the current version, the maximum number of
     * weekly_window is expected to be one.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1beta1.WeeklyMaintenanceWindow weekly_maintenance_window = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindowOrBuilder
        getWeeklyMaintenanceWindowOrBuilder(int index) {
      if (weeklyMaintenanceWindowBuilder_ == null) {
        return weeklyMaintenanceWindow_.get(index);
      } else {
        return weeklyMaintenanceWindowBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Maintenance window that is applied to resources covered by this
     * policy. Minimum 1. For the current version, the maximum number of
     * weekly_window is expected to be one.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1beta1.WeeklyMaintenanceWindow weekly_maintenance_window = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindowOrBuilder>
        getWeeklyMaintenanceWindowOrBuilderList() {
      if (weeklyMaintenanceWindowBuilder_ != null) {
        return weeklyMaintenanceWindowBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(weeklyMaintenanceWindow_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Maintenance window that is applied to resources covered by this
     * policy. Minimum 1. For the current version, the maximum number of
     * weekly_window is expected to be one.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1beta1.WeeklyMaintenanceWindow weekly_maintenance_window = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow.Builder
        addWeeklyMaintenanceWindowBuilder() {
      return getWeeklyMaintenanceWindowFieldBuilder()
          .addBuilder(com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Maintenance window that is applied to resources covered by this
     * policy. Minimum 1. For the current version, the maximum number of
     * weekly_window is expected to be one.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1beta1.WeeklyMaintenanceWindow weekly_maintenance_window = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow.Builder
        addWeeklyMaintenanceWindowBuilder(int index) {
      return getWeeklyMaintenanceWindowFieldBuilder()
          .addBuilder(
              index, com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Maintenance window that is applied to resources covered by this
     * policy. Minimum 1. For the current version, the maximum number of
     * weekly_window is expected to be one.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.redis.v1beta1.WeeklyMaintenanceWindow weekly_maintenance_window = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow.Builder>
        getWeeklyMaintenanceWindowBuilderList() {
      return getWeeklyMaintenanceWindowFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow,
            com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow.Builder,
            com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindowOrBuilder>
        getWeeklyMaintenanceWindowFieldBuilder() {
      if (weeklyMaintenanceWindowBuilder_ == null) {
        weeklyMaintenanceWindowBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow,
                com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindow.Builder,
                com.google.cloud.redis.v1beta1.WeeklyMaintenanceWindowOrBuilder>(
                weeklyMaintenanceWindow_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        weeklyMaintenanceWindow_ = null;
      }
      return weeklyMaintenanceWindowBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.redis.v1beta1.MaintenancePolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.redis.v1beta1.MaintenancePolicy)
  private static final com.google.cloud.redis.v1beta1.MaintenancePolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.redis.v1beta1.MaintenancePolicy();
  }

  public static com.google.cloud.redis.v1beta1.MaintenancePolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MaintenancePolicy> PARSER =
      new com.google.protobuf.AbstractParser<MaintenancePolicy>() {
        @java.lang.Override
        public MaintenancePolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MaintenancePolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MaintenancePolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.redis.v1beta1.MaintenancePolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
