/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/redis/v1beta1/cloud_redis.proto

package com.google.cloud.redis.v1beta1;

/**
 *
 *
 * <pre>
 * A Google Cloud Redis instance.
 * </pre>
 *
 * Protobuf type {@code google.cloud.redis.v1beta1.Instance}
 */
public final class Instance extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.redis.v1beta1.Instance)
    InstanceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Instance.newBuilder() to construct.
  private Instance(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Instance() {
    name_ = "";
    displayName_ = "";
    locationId_ = "";
    alternativeLocationId_ = "";
    redisVersion_ = "";
    reservedIpRange_ = "";
    host_ = "";
    currentLocationId_ = "";
    state_ = 0;
    statusMessage_ = "";
    tier_ = 0;
    authorizedNetwork_ = "";
    persistenceIamIdentity_ = "";
    connectMode_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Instance();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Instance(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              displayName_ = s;
              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                labels_ =
                    com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000001;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                  input.readMessage(
                      LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
              labels_.getMutableMap().put(labels__.getKey(), labels__.getValue());
              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();

              locationId_ = s;
              break;
            }
          case 42:
            {
              java.lang.String s = input.readStringRequireUtf8();

              alternativeLocationId_ = s;
              break;
            }
          case 58:
            {
              java.lang.String s = input.readStringRequireUtf8();

              redisVersion_ = s;
              break;
            }
          case 74:
            {
              java.lang.String s = input.readStringRequireUtf8();

              reservedIpRange_ = s;
              break;
            }
          case 82:
            {
              java.lang.String s = input.readStringRequireUtf8();

              host_ = s;
              break;
            }
          case 88:
            {
              port_ = input.readInt32();
              break;
            }
          case 98:
            {
              java.lang.String s = input.readStringRequireUtf8();

              currentLocationId_ = s;
              break;
            }
          case 106:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 112:
            {
              int rawValue = input.readEnum();

              state_ = rawValue;
              break;
            }
          case 122:
            {
              java.lang.String s = input.readStringRequireUtf8();

              statusMessage_ = s;
              break;
            }
          case 130:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                redisConfigs_ =
                    com.google.protobuf.MapField.newMapField(
                        RedisConfigsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000002;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> redisConfigs__ =
                  input.readMessage(
                      RedisConfigsDefaultEntryHolder.defaultEntry.getParserForType(),
                      extensionRegistry);
              redisConfigs_.getMutableMap().put(redisConfigs__.getKey(), redisConfigs__.getValue());
              break;
            }
          case 136:
            {
              int rawValue = input.readEnum();

              tier_ = rawValue;
              break;
            }
          case 144:
            {
              memorySizeGb_ = input.readInt32();
              break;
            }
          case 162:
            {
              java.lang.String s = input.readStringRequireUtf8();

              authorizedNetwork_ = s;
              break;
            }
          case 170:
            {
              java.lang.String s = input.readStringRequireUtf8();

              persistenceIamIdentity_ = s;
              break;
            }
          case 176:
            {
              int rawValue = input.readEnum();

              connectMode_ = rawValue;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.redis.v1beta1.CloudRedisServiceBetaProto
        .internal_static_google_cloud_redis_v1beta1_Instance_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 3:
        return internalGetLabels();
      case 16:
        return internalGetRedisConfigs();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.redis.v1beta1.CloudRedisServiceBetaProto
        .internal_static_google_cloud_redis_v1beta1_Instance_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.redis.v1beta1.Instance.class,
            com.google.cloud.redis.v1beta1.Instance.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Represents the different states of a Redis instance.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.redis.v1beta1.Instance.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Redis instance is being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * Redis instance has been created and is fully usable.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    READY(2),
    /**
     *
     *
     * <pre>
     * Redis instance configuration is being updated. Certain kinds of updates
     * may cause the instance to become unusable while the update is in
     * progress.
     * </pre>
     *
     * <code>UPDATING = 3;</code>
     */
    UPDATING(3),
    /**
     *
     *
     * <pre>
     * Redis instance is being deleted.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    DELETING(4),
    /**
     *
     *
     * <pre>
     * Redis instance is being repaired and may be unusable.
     * </pre>
     *
     * <code>REPAIRING = 5;</code>
     */
    REPAIRING(5),
    /**
     *
     *
     * <pre>
     * Maintenance is being performed on this Redis instance.
     * </pre>
     *
     * <code>MAINTENANCE = 6;</code>
     */
    MAINTENANCE(6),
    /**
     *
     *
     * <pre>
     * Redis instance is importing data (availability may be affected).
     * </pre>
     *
     * <code>IMPORTING = 8;</code>
     */
    IMPORTING(8),
    /**
     *
     *
     * <pre>
     * Redis instance is failing over (availability may be affected).
     * </pre>
     *
     * <code>FAILING_OVER = 10;</code>
     */
    FAILING_OVER(10),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Redis instance is being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Redis instance has been created and is fully usable.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    public static final int READY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Redis instance configuration is being updated. Certain kinds of updates
     * may cause the instance to become unusable while the update is in
     * progress.
     * </pre>
     *
     * <code>UPDATING = 3;</code>
     */
    public static final int UPDATING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Redis instance is being deleted.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    public static final int DELETING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Redis instance is being repaired and may be unusable.
     * </pre>
     *
     * <code>REPAIRING = 5;</code>
     */
    public static final int REPAIRING_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Maintenance is being performed on this Redis instance.
     * </pre>
     *
     * <code>MAINTENANCE = 6;</code>
     */
    public static final int MAINTENANCE_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Redis instance is importing data (availability may be affected).
     * </pre>
     *
     * <code>IMPORTING = 8;</code>
     */
    public static final int IMPORTING_VALUE = 8;
    /**
     *
     *
     * <pre>
     * Redis instance is failing over (availability may be affected).
     * </pre>
     *
     * <code>FAILING_OVER = 10;</code>
     */
    public static final int FAILING_OVER_VALUE = 10;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return READY;
        case 3:
          return UPDATING;
        case 4:
          return DELETING;
        case 5:
          return REPAIRING;
        case 6:
          return MAINTENANCE;
        case 8:
          return IMPORTING;
        case 10:
          return FAILING_OVER;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.redis.v1beta1.Instance.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.redis.v1beta1.Instance.State)
  }

  /**
   *
   *
   * <pre>
   * Available service tiers to choose from
   * </pre>
   *
   * Protobuf enum {@code google.cloud.redis.v1beta1.Instance.Tier}
   */
  public enum Tier implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>TIER_UNSPECIFIED = 0;</code>
     */
    TIER_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * BASIC tier: standalone instance
     * </pre>
     *
     * <code>BASIC = 1;</code>
     */
    BASIC(1),
    /**
     *
     *
     * <pre>
     * STANDARD_HA tier: highly available primary/replica instances
     * </pre>
     *
     * <code>STANDARD_HA = 3;</code>
     */
    STANDARD_HA(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>TIER_UNSPECIFIED = 0;</code>
     */
    public static final int TIER_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * BASIC tier: standalone instance
     * </pre>
     *
     * <code>BASIC = 1;</code>
     */
    public static final int BASIC_VALUE = 1;
    /**
     *
     *
     * <pre>
     * STANDARD_HA tier: highly available primary/replica instances
     * </pre>
     *
     * <code>STANDARD_HA = 3;</code>
     */
    public static final int STANDARD_HA_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Tier valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Tier forNumber(int value) {
      switch (value) {
        case 0:
          return TIER_UNSPECIFIED;
        case 1:
          return BASIC;
        case 3:
          return STANDARD_HA;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Tier> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Tier> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Tier>() {
          public Tier findValueByNumber(int number) {
            return Tier.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.redis.v1beta1.Instance.getDescriptor().getEnumTypes().get(1);
    }

    private static final Tier[] VALUES = values();

    public static Tier valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Tier(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.redis.v1beta1.Instance.Tier)
  }

  /**
   *
   *
   * <pre>
   * Available connection modes.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.redis.v1beta1.Instance.ConnectMode}
   */
  public enum ConnectMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>CONNECT_MODE_UNSPECIFIED = 0;</code>
     */
    CONNECT_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Connect via directly peering with memorystore redis hosted service.
     * </pre>
     *
     * <code>DIRECT_PEERING = 1;</code>
     */
    DIRECT_PEERING(1),
    /**
     *
     *
     * <pre>
     * Connect with google via private service access and share connection
     * across google managed services.
     * </pre>
     *
     * <code>PRIVATE_SERVICE_ACCESS = 2;</code>
     */
    PRIVATE_SERVICE_ACCESS(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>CONNECT_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int CONNECT_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Connect via directly peering with memorystore redis hosted service.
     * </pre>
     *
     * <code>DIRECT_PEERING = 1;</code>
     */
    public static final int DIRECT_PEERING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Connect with google via private service access and share connection
     * across google managed services.
     * </pre>
     *
     * <code>PRIVATE_SERVICE_ACCESS = 2;</code>
     */
    public static final int PRIVATE_SERVICE_ACCESS_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConnectMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ConnectMode forNumber(int value) {
      switch (value) {
        case 0:
          return CONNECT_MODE_UNSPECIFIED;
        case 1:
          return DIRECT_PEERING;
        case 2:
          return PRIVATE_SERVICE_ACCESS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ConnectMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ConnectMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ConnectMode>() {
          public ConnectMode findValueByNumber(int number) {
            return ConnectMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.redis.v1beta1.Instance.getDescriptor().getEnumTypes().get(2);
    }

    private static final ConnectMode[] VALUES = values();

    public static ConnectMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ConnectMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.redis.v1beta1.Instance.ConnectMode)
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Required. Unique name of the resource in this scope including project and
   * location using the form:
   *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
   * Note: Redis instances are managed and addressed at regional level so
   * location_id here refers to a GCP region; however, users may choose which
   * specific zone (or collection of zones for cross-zone instances) an instance
   * should be provisioned in. Refer to [location_id][google.cloud.redis.v1beta1.Instance.location_id] and
   * [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id] fields for more details.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Unique name of the resource in this scope including project and
   * location using the form:
   *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
   * Note: Redis instances are managed and addressed at regional level so
   * location_id here refers to a GCP region; however, users may choose which
   * specific zone (or collection of zones for cross-zone instances) an instance
   * should be provisioned in. Refer to [location_id][google.cloud.redis.v1beta1.Instance.location_id] and
   * [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id] fields for more details.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * An arbitrary and optional user-provided name for the instance.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An arbitrary and optional user-provided name for the instance.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 3;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.redis.v1beta1.CloudRedisServiceBetaProto
                .internal_static_google_cloud_redis_v1beta1_Instance_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Resource labels to represent user provided metadata
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Resource labels to represent user provided metadata
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Resource labels to represent user provided metadata
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Resource labels to represent user provided metadata
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int LOCATION_ID_FIELD_NUMBER = 4;
  private volatile java.lang.Object locationId_;
  /**
   *
   *
   * <pre>
   * Optional. The zone where the instance will be provisioned. If not provided,
   * the service will choose a zone for the instance. For STANDARD_HA tier,
   * instances will be created across two zones for protection against zonal
   * failures. If [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id] is also provided, it must be
   * different from [location_id][google.cloud.redis.v1beta1.Instance.location_id].
   * </pre>
   *
   * <code>string location_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The locationId.
   */
  public java.lang.String getLocationId() {
    java.lang.Object ref = locationId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      locationId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The zone where the instance will be provisioned. If not provided,
   * the service will choose a zone for the instance. For STANDARD_HA tier,
   * instances will be created across two zones for protection against zonal
   * failures. If [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id] is also provided, it must be
   * different from [location_id][google.cloud.redis.v1beta1.Instance.location_id].
   * </pre>
   *
   * <code>string location_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for locationId.
   */
  public com.google.protobuf.ByteString getLocationIdBytes() {
    java.lang.Object ref = locationId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      locationId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ALTERNATIVE_LOCATION_ID_FIELD_NUMBER = 5;
  private volatile java.lang.Object alternativeLocationId_;
  /**
   *
   *
   * <pre>
   * Optional. Only applicable to STANDARD_HA tier which protects the instance
   * against zonal failures by provisioning it across two zones. If provided, it
   * must be a different zone from the one provided in [location_id][google.cloud.redis.v1beta1.Instance.location_id].
   * </pre>
   *
   * <code>string alternative_location_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The alternativeLocationId.
   */
  public java.lang.String getAlternativeLocationId() {
    java.lang.Object ref = alternativeLocationId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      alternativeLocationId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Only applicable to STANDARD_HA tier which protects the instance
   * against zonal failures by provisioning it across two zones. If provided, it
   * must be a different zone from the one provided in [location_id][google.cloud.redis.v1beta1.Instance.location_id].
   * </pre>
   *
   * <code>string alternative_location_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for alternativeLocationId.
   */
  public com.google.protobuf.ByteString getAlternativeLocationIdBytes() {
    java.lang.Object ref = alternativeLocationId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      alternativeLocationId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REDIS_VERSION_FIELD_NUMBER = 7;
  private volatile java.lang.Object redisVersion_;
  /**
   *
   *
   * <pre>
   * Optional. The version of Redis software.
   * If not provided, latest supported version will be used. Currently, the
   * supported values are:
   *  *   `REDIS_4_0` for Redis 4.0 compatibility (default)
   *  *   `REDIS_3_2` for Redis 3.2 compatibility
   * </pre>
   *
   * <code>string redis_version = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The redisVersion.
   */
  public java.lang.String getRedisVersion() {
    java.lang.Object ref = redisVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      redisVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The version of Redis software.
   * If not provided, latest supported version will be used. Currently, the
   * supported values are:
   *  *   `REDIS_4_0` for Redis 4.0 compatibility (default)
   *  *   `REDIS_3_2` for Redis 3.2 compatibility
   * </pre>
   *
   * <code>string redis_version = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for redisVersion.
   */
  public com.google.protobuf.ByteString getRedisVersionBytes() {
    java.lang.Object ref = redisVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      redisVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESERVED_IP_RANGE_FIELD_NUMBER = 9;
  private volatile java.lang.Object reservedIpRange_;
  /**
   *
   *
   * <pre>
   * Optional. The CIDR range of internal addresses that are reserved for this
   * instance. If not provided, the service will choose an unused /29 block,
   * for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be unique
   * and non-overlapping with existing subnets in an authorized network.
   * </pre>
   *
   * <code>string reserved_ip_range = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The reservedIpRange.
   */
  public java.lang.String getReservedIpRange() {
    java.lang.Object ref = reservedIpRange_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      reservedIpRange_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The CIDR range of internal addresses that are reserved for this
   * instance. If not provided, the service will choose an unused /29 block,
   * for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be unique
   * and non-overlapping with existing subnets in an authorized network.
   * </pre>
   *
   * <code>string reserved_ip_range = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for reservedIpRange.
   */
  public com.google.protobuf.ByteString getReservedIpRangeBytes() {
    java.lang.Object ref = reservedIpRange_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      reservedIpRange_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HOST_FIELD_NUMBER = 10;
  private volatile java.lang.Object host_;
  /**
   *
   *
   * <pre>
   * Output only. Hostname or IP address of the exposed Redis endpoint used by
   * clients to connect to the service.
   * </pre>
   *
   * <code>string host = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The host.
   */
  public java.lang.String getHost() {
    java.lang.Object ref = host_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      host_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Hostname or IP address of the exposed Redis endpoint used by
   * clients to connect to the service.
   * </pre>
   *
   * <code>string host = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for host.
   */
  public com.google.protobuf.ByteString getHostBytes() {
    java.lang.Object ref = host_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      host_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PORT_FIELD_NUMBER = 11;
  private int port_;
  /**
   *
   *
   * <pre>
   * Output only. The port number of the exposed Redis endpoint.
   * </pre>
   *
   * <code>int32 port = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The port.
   */
  public int getPort() {
    return port_;
  }

  public static final int CURRENT_LOCATION_ID_FIELD_NUMBER = 12;
  private volatile java.lang.Object currentLocationId_;
  /**
   *
   *
   * <pre>
   * Output only. The current zone where the Redis endpoint is placed. For Basic
   * Tier instances, this will always be the same as the [location_id][google.cloud.redis.v1beta1.Instance.location_id]
   * provided by the user at creation time. For Standard Tier instances,
   * this can be either [location_id][google.cloud.redis.v1beta1.Instance.location_id] or [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id] and can
   * change after a failover event.
   * </pre>
   *
   * <code>string current_location_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The currentLocationId.
   */
  public java.lang.String getCurrentLocationId() {
    java.lang.Object ref = currentLocationId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      currentLocationId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The current zone where the Redis endpoint is placed. For Basic
   * Tier instances, this will always be the same as the [location_id][google.cloud.redis.v1beta1.Instance.location_id]
   * provided by the user at creation time. For Standard Tier instances,
   * this can be either [location_id][google.cloud.redis.v1beta1.Instance.location_id] or [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id] and can
   * change after a failover event.
   * </pre>
   *
   * <code>string current_location_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for currentLocationId.
   */
  public com.google.protobuf.ByteString getCurrentLocationIdBytes() {
    java.lang.Object ref = currentLocationId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      currentLocationId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 13;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int STATE_FIELD_NUMBER = 14;
  private int state_;
  /**
   *
   *
   * <pre>
   * Output only. The current state of this instance.
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1beta1.Instance.State state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state of this instance.
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1beta1.Instance.State state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  public com.google.cloud.redis.v1beta1.Instance.State getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.redis.v1beta1.Instance.State result =
        com.google.cloud.redis.v1beta1.Instance.State.valueOf(state_);
    return result == null ? com.google.cloud.redis.v1beta1.Instance.State.UNRECOGNIZED : result;
  }

  public static final int STATUS_MESSAGE_FIELD_NUMBER = 15;
  private volatile java.lang.Object statusMessage_;
  /**
   *
   *
   * <pre>
   * Output only. Additional information about the current status of this
   * instance, if available.
   * </pre>
   *
   * <code>string status_message = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The statusMessage.
   */
  public java.lang.String getStatusMessage() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      statusMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional information about the current status of this
   * instance, if available.
   * </pre>
   *
   * <code>string status_message = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for statusMessage.
   */
  public com.google.protobuf.ByteString getStatusMessageBytes() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      statusMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REDIS_CONFIGS_FIELD_NUMBER = 16;

  private static final class RedisConfigsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.redis.v1beta1.CloudRedisServiceBetaProto
                .internal_static_google_cloud_redis_v1beta1_Instance_RedisConfigsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> redisConfigs_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetRedisConfigs() {
    if (redisConfigs_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          RedisConfigsDefaultEntryHolder.defaultEntry);
    }
    return redisConfigs_;
  }

  public int getRedisConfigsCount() {
    return internalGetRedisConfigs().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Redis configuration parameters, according to
   * http://redis.io/topics/config. Currently, the only supported parameters
   * are:
   *  Redis 3.2 and above:
   *  *   maxmemory-policy
   *  *   notify-keyspace-events
   *  Redis 4.0 and above:
   *  *   activedefrag
   *  *   lfu-log-factor
   *  *   lfu-decay-time
   * </pre>
   *
   * <code>map&lt;string, string&gt; redis_configs = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public boolean containsRedisConfigs(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetRedisConfigs().getMap().containsKey(key);
  }
  /** Use {@link #getRedisConfigsMap()} instead. */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getRedisConfigs() {
    return getRedisConfigsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Redis configuration parameters, according to
   * http://redis.io/topics/config. Currently, the only supported parameters
   * are:
   *  Redis 3.2 and above:
   *  *   maxmemory-policy
   *  *   notify-keyspace-events
   *  Redis 4.0 and above:
   *  *   activedefrag
   *  *   lfu-log-factor
   *  *   lfu-decay-time
   * </pre>
   *
   * <code>map&lt;string, string&gt; redis_configs = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public java.util.Map<java.lang.String, java.lang.String> getRedisConfigsMap() {
    return internalGetRedisConfigs().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Redis configuration parameters, according to
   * http://redis.io/topics/config. Currently, the only supported parameters
   * are:
   *  Redis 3.2 and above:
   *  *   maxmemory-policy
   *  *   notify-keyspace-events
   *  Redis 4.0 and above:
   *  *   activedefrag
   *  *   lfu-log-factor
   *  *   lfu-decay-time
   * </pre>
   *
   * <code>map&lt;string, string&gt; redis_configs = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public java.lang.String getRedisConfigsOrDefault(
      java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetRedisConfigs().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Redis configuration parameters, according to
   * http://redis.io/topics/config. Currently, the only supported parameters
   * are:
   *  Redis 3.2 and above:
   *  *   maxmemory-policy
   *  *   notify-keyspace-events
   *  Redis 4.0 and above:
   *  *   activedefrag
   *  *   lfu-log-factor
   *  *   lfu-decay-time
   * </pre>
   *
   * <code>map&lt;string, string&gt; redis_configs = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public java.lang.String getRedisConfigsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetRedisConfigs().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int TIER_FIELD_NUMBER = 17;
  private int tier_;
  /**
   *
   *
   * <pre>
   * Required. The service tier of the instance.
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1beta1.Instance.Tier tier = 17 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for tier.
   */
  public int getTierValue() {
    return tier_;
  }
  /**
   *
   *
   * <pre>
   * Required. The service tier of the instance.
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1beta1.Instance.Tier tier = 17 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The tier.
   */
  public com.google.cloud.redis.v1beta1.Instance.Tier getTier() {
    @SuppressWarnings("deprecation")
    com.google.cloud.redis.v1beta1.Instance.Tier result =
        com.google.cloud.redis.v1beta1.Instance.Tier.valueOf(tier_);
    return result == null ? com.google.cloud.redis.v1beta1.Instance.Tier.UNRECOGNIZED : result;
  }

  public static final int MEMORY_SIZE_GB_FIELD_NUMBER = 18;
  private int memorySizeGb_;
  /**
   *
   *
   * <pre>
   * Required. Redis memory size in GiB.
   * </pre>
   *
   * <code>int32 memory_size_gb = 18 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The memorySizeGb.
   */
  public int getMemorySizeGb() {
    return memorySizeGb_;
  }

  public static final int AUTHORIZED_NETWORK_FIELD_NUMBER = 20;
  private volatile java.lang.Object authorizedNetwork_;
  /**
   *
   *
   * <pre>
   * Optional. The full name of the Google Compute Engine
   * [network](/compute/docs/networks-and-firewalls#networks) to which the
   * instance is connected. If left unspecified, the `default` network
   * will be used.
   * </pre>
   *
   * <code>string authorized_network = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The authorizedNetwork.
   */
  public java.lang.String getAuthorizedNetwork() {
    java.lang.Object ref = authorizedNetwork_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      authorizedNetwork_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The full name of the Google Compute Engine
   * [network](/compute/docs/networks-and-firewalls#networks) to which the
   * instance is connected. If left unspecified, the `default` network
   * will be used.
   * </pre>
   *
   * <code>string authorized_network = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for authorizedNetwork.
   */
  public com.google.protobuf.ByteString getAuthorizedNetworkBytes() {
    java.lang.Object ref = authorizedNetwork_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      authorizedNetwork_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PERSISTENCE_IAM_IDENTITY_FIELD_NUMBER = 21;
  private volatile java.lang.Object persistenceIamIdentity_;
  /**
   *
   *
   * <pre>
   * Output only. Cloud IAM identity used by import / export operations to
   * transfer data to/from Cloud Storage. Format is
   * "serviceAccount:&lt;service_account_email&gt;". The value may change over time
   * for a given instance so should be checked before each import/export
   * operation.
   * </pre>
   *
   * <code>string persistence_iam_identity = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The persistenceIamIdentity.
   */
  public java.lang.String getPersistenceIamIdentity() {
    java.lang.Object ref = persistenceIamIdentity_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      persistenceIamIdentity_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Cloud IAM identity used by import / export operations to
   * transfer data to/from Cloud Storage. Format is
   * "serviceAccount:&lt;service_account_email&gt;". The value may change over time
   * for a given instance so should be checked before each import/export
   * operation.
   * </pre>
   *
   * <code>string persistence_iam_identity = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for persistenceIamIdentity.
   */
  public com.google.protobuf.ByteString getPersistenceIamIdentityBytes() {
    java.lang.Object ref = persistenceIamIdentity_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      persistenceIamIdentity_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONNECT_MODE_FIELD_NUMBER = 22;
  private int connectMode_;
  /**
   *
   *
   * <pre>
   * Optional. The connect mode of Redis instance.
   * If not provided, default one will be used.
   * Current default: DIRECT_PEERING.
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1beta1.Instance.ConnectMode connect_mode = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for connectMode.
   */
  public int getConnectModeValue() {
    return connectMode_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The connect mode of Redis instance.
   * If not provided, default one will be used.
   * Current default: DIRECT_PEERING.
   * </pre>
   *
   * <code>
   * .google.cloud.redis.v1beta1.Instance.ConnectMode connect_mode = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The connectMode.
   */
  public com.google.cloud.redis.v1beta1.Instance.ConnectMode getConnectMode() {
    @SuppressWarnings("deprecation")
    com.google.cloud.redis.v1beta1.Instance.ConnectMode result =
        com.google.cloud.redis.v1beta1.Instance.ConnectMode.valueOf(connectMode_);
    return result == null
        ? com.google.cloud.redis.v1beta1.Instance.ConnectMode.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 3);
    if (!getLocationIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, locationId_);
    }
    if (!getAlternativeLocationIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, alternativeLocationId_);
    }
    if (!getRedisVersionBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, redisVersion_);
    }
    if (!getReservedIpRangeBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, reservedIpRange_);
    }
    if (!getHostBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, host_);
    }
    if (port_ != 0) {
      output.writeInt32(11, port_);
    }
    if (!getCurrentLocationIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, currentLocationId_);
    }
    if (createTime_ != null) {
      output.writeMessage(13, getCreateTime());
    }
    if (state_ != com.google.cloud.redis.v1beta1.Instance.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(14, state_);
    }
    if (!getStatusMessageBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, statusMessage_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetRedisConfigs(), RedisConfigsDefaultEntryHolder.defaultEntry, 16);
    if (tier_ != com.google.cloud.redis.v1beta1.Instance.Tier.TIER_UNSPECIFIED.getNumber()) {
      output.writeEnum(17, tier_);
    }
    if (memorySizeGb_ != 0) {
      output.writeInt32(18, memorySizeGb_);
    }
    if (!getAuthorizedNetworkBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 20, authorizedNetwork_);
    }
    if (!getPersistenceIamIdentityBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 21, persistenceIamIdentity_);
    }
    if (connectMode_
        != com.google.cloud.redis.v1beta1.Instance.ConnectMode.CONNECT_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(22, connectMode_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, labels__);
    }
    if (!getLocationIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, locationId_);
    }
    if (!getAlternativeLocationIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, alternativeLocationId_);
    }
    if (!getRedisVersionBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, redisVersion_);
    }
    if (!getReservedIpRangeBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, reservedIpRange_);
    }
    if (!getHostBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, host_);
    }
    if (port_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(11, port_);
    }
    if (!getCurrentLocationIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, currentLocationId_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getCreateTime());
    }
    if (state_ != com.google.cloud.redis.v1beta1.Instance.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(14, state_);
    }
    if (!getStatusMessageBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, statusMessage_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetRedisConfigs().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> redisConfigs__ =
          RedisConfigsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, redisConfigs__);
    }
    if (tier_ != com.google.cloud.redis.v1beta1.Instance.Tier.TIER_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(17, tier_);
    }
    if (memorySizeGb_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(18, memorySizeGb_);
    }
    if (!getAuthorizedNetworkBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(20, authorizedNetwork_);
    }
    if (!getPersistenceIamIdentityBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(21, persistenceIamIdentity_);
    }
    if (connectMode_
        != com.google.cloud.redis.v1beta1.Instance.ConnectMode.CONNECT_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(22, connectMode_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.redis.v1beta1.Instance)) {
      return super.equals(obj);
    }
    com.google.cloud.redis.v1beta1.Instance other = (com.google.cloud.redis.v1beta1.Instance) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getLocationId().equals(other.getLocationId())) return false;
    if (!getAlternativeLocationId().equals(other.getAlternativeLocationId())) return false;
    if (!getRedisVersion().equals(other.getRedisVersion())) return false;
    if (!getReservedIpRange().equals(other.getReservedIpRange())) return false;
    if (!getHost().equals(other.getHost())) return false;
    if (getPort() != other.getPort()) return false;
    if (!getCurrentLocationId().equals(other.getCurrentLocationId())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (state_ != other.state_) return false;
    if (!getStatusMessage().equals(other.getStatusMessage())) return false;
    if (!internalGetRedisConfigs().equals(other.internalGetRedisConfigs())) return false;
    if (tier_ != other.tier_) return false;
    if (getMemorySizeGb() != other.getMemorySizeGb()) return false;
    if (!getAuthorizedNetwork().equals(other.getAuthorizedNetwork())) return false;
    if (!getPersistenceIamIdentity().equals(other.getPersistenceIamIdentity())) return false;
    if (connectMode_ != other.connectMode_) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + LOCATION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getLocationId().hashCode();
    hash = (37 * hash) + ALTERNATIVE_LOCATION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getAlternativeLocationId().hashCode();
    hash = (37 * hash) + REDIS_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getRedisVersion().hashCode();
    hash = (37 * hash) + RESERVED_IP_RANGE_FIELD_NUMBER;
    hash = (53 * hash) + getReservedIpRange().hashCode();
    hash = (37 * hash) + HOST_FIELD_NUMBER;
    hash = (53 * hash) + getHost().hashCode();
    hash = (37 * hash) + PORT_FIELD_NUMBER;
    hash = (53 * hash) + getPort();
    hash = (37 * hash) + CURRENT_LOCATION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getCurrentLocationId().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + STATUS_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getStatusMessage().hashCode();
    if (!internalGetRedisConfigs().getMap().isEmpty()) {
      hash = (37 * hash) + REDIS_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetRedisConfigs().hashCode();
    }
    hash = (37 * hash) + TIER_FIELD_NUMBER;
    hash = (53 * hash) + tier_;
    hash = (37 * hash) + MEMORY_SIZE_GB_FIELD_NUMBER;
    hash = (53 * hash) + getMemorySizeGb();
    hash = (37 * hash) + AUTHORIZED_NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getAuthorizedNetwork().hashCode();
    hash = (37 * hash) + PERSISTENCE_IAM_IDENTITY_FIELD_NUMBER;
    hash = (53 * hash) + getPersistenceIamIdentity().hashCode();
    hash = (37 * hash) + CONNECT_MODE_FIELD_NUMBER;
    hash = (53 * hash) + connectMode_;
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.redis.v1beta1.Instance parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.redis.v1beta1.Instance parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.redis.v1beta1.Instance parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.redis.v1beta1.Instance parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.redis.v1beta1.Instance parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.redis.v1beta1.Instance parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.redis.v1beta1.Instance parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.redis.v1beta1.Instance parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.redis.v1beta1.Instance parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.redis.v1beta1.Instance parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.redis.v1beta1.Instance parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.redis.v1beta1.Instance parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.redis.v1beta1.Instance prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Google Cloud Redis instance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.redis.v1beta1.Instance}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.redis.v1beta1.Instance)
      com.google.cloud.redis.v1beta1.InstanceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.redis.v1beta1.CloudRedisServiceBetaProto
          .internal_static_google_cloud_redis_v1beta1_Instance_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 3:
          return internalGetLabels();
        case 16:
          return internalGetRedisConfigs();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 3:
          return internalGetMutableLabels();
        case 16:
          return internalGetMutableRedisConfigs();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.redis.v1beta1.CloudRedisServiceBetaProto
          .internal_static_google_cloud_redis_v1beta1_Instance_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.redis.v1beta1.Instance.class,
              com.google.cloud.redis.v1beta1.Instance.Builder.class);
    }

    // Construct using com.google.cloud.redis.v1beta1.Instance.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      displayName_ = "";

      internalGetMutableLabels().clear();
      locationId_ = "";

      alternativeLocationId_ = "";

      redisVersion_ = "";

      reservedIpRange_ = "";

      host_ = "";

      port_ = 0;

      currentLocationId_ = "";

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      state_ = 0;

      statusMessage_ = "";

      internalGetMutableRedisConfigs().clear();
      tier_ = 0;

      memorySizeGb_ = 0;

      authorizedNetwork_ = "";

      persistenceIamIdentity_ = "";

      connectMode_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.redis.v1beta1.CloudRedisServiceBetaProto
          .internal_static_google_cloud_redis_v1beta1_Instance_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.redis.v1beta1.Instance getDefaultInstanceForType() {
      return com.google.cloud.redis.v1beta1.Instance.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.redis.v1beta1.Instance build() {
      com.google.cloud.redis.v1beta1.Instance result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.redis.v1beta1.Instance buildPartial() {
      com.google.cloud.redis.v1beta1.Instance result =
          new com.google.cloud.redis.v1beta1.Instance(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.displayName_ = displayName_;
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      result.locationId_ = locationId_;
      result.alternativeLocationId_ = alternativeLocationId_;
      result.redisVersion_ = redisVersion_;
      result.reservedIpRange_ = reservedIpRange_;
      result.host_ = host_;
      result.port_ = port_;
      result.currentLocationId_ = currentLocationId_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      result.state_ = state_;
      result.statusMessage_ = statusMessage_;
      result.redisConfigs_ = internalGetRedisConfigs();
      result.redisConfigs_.makeImmutable();
      result.tier_ = tier_;
      result.memorySizeGb_ = memorySizeGb_;
      result.authorizedNetwork_ = authorizedNetwork_;
      result.persistenceIamIdentity_ = persistenceIamIdentity_;
      result.connectMode_ = connectMode_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.redis.v1beta1.Instance) {
        return mergeFrom((com.google.cloud.redis.v1beta1.Instance) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.redis.v1beta1.Instance other) {
      if (other == com.google.cloud.redis.v1beta1.Instance.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (!other.getLocationId().isEmpty()) {
        locationId_ = other.locationId_;
        onChanged();
      }
      if (!other.getAlternativeLocationId().isEmpty()) {
        alternativeLocationId_ = other.alternativeLocationId_;
        onChanged();
      }
      if (!other.getRedisVersion().isEmpty()) {
        redisVersion_ = other.redisVersion_;
        onChanged();
      }
      if (!other.getReservedIpRange().isEmpty()) {
        reservedIpRange_ = other.reservedIpRange_;
        onChanged();
      }
      if (!other.getHost().isEmpty()) {
        host_ = other.host_;
        onChanged();
      }
      if (other.getPort() != 0) {
        setPort(other.getPort());
      }
      if (!other.getCurrentLocationId().isEmpty()) {
        currentLocationId_ = other.currentLocationId_;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getStatusMessage().isEmpty()) {
        statusMessage_ = other.statusMessage_;
        onChanged();
      }
      internalGetMutableRedisConfigs().mergeFrom(other.internalGetRedisConfigs());
      if (other.tier_ != 0) {
        setTierValue(other.getTierValue());
      }
      if (other.getMemorySizeGb() != 0) {
        setMemorySizeGb(other.getMemorySizeGb());
      }
      if (!other.getAuthorizedNetwork().isEmpty()) {
        authorizedNetwork_ = other.authorizedNetwork_;
        onChanged();
      }
      if (!other.getPersistenceIamIdentity().isEmpty()) {
        persistenceIamIdentity_ = other.persistenceIamIdentity_;
        onChanged();
      }
      if (other.connectMode_ != 0) {
        setConnectModeValue(other.getConnectModeValue());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.redis.v1beta1.Instance parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.redis.v1beta1.Instance) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Unique name of the resource in this scope including project and
     * location using the form:
     *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
     * Note: Redis instances are managed and addressed at regional level so
     * location_id here refers to a GCP region; however, users may choose which
     * specific zone (or collection of zones for cross-zone instances) an instance
     * should be provisioned in. Refer to [location_id][google.cloud.redis.v1beta1.Instance.location_id] and
     * [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id] fields for more details.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Unique name of the resource in this scope including project and
     * location using the form:
     *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
     * Note: Redis instances are managed and addressed at regional level so
     * location_id here refers to a GCP region; however, users may choose which
     * specific zone (or collection of zones for cross-zone instances) an instance
     * should be provisioned in. Refer to [location_id][google.cloud.redis.v1beta1.Instance.location_id] and
     * [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id] fields for more details.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Unique name of the resource in this scope including project and
     * location using the form:
     *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
     * Note: Redis instances are managed and addressed at regional level so
     * location_id here refers to a GCP region; however, users may choose which
     * specific zone (or collection of zones for cross-zone instances) an instance
     * should be provisioned in. Refer to [location_id][google.cloud.redis.v1beta1.Instance.location_id] and
     * [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id] fields for more details.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Unique name of the resource in this scope including project and
     * location using the form:
     *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
     * Note: Redis instances are managed and addressed at regional level so
     * location_id here refers to a GCP region; however, users may choose which
     * specific zone (or collection of zones for cross-zone instances) an instance
     * should be provisioned in. Refer to [location_id][google.cloud.redis.v1beta1.Instance.location_id] and
     * [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id] fields for more details.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Unique name of the resource in this scope including project and
     * location using the form:
     *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
     * Note: Redis instances are managed and addressed at regional level so
     * location_id here refers to a GCP region; however, users may choose which
     * specific zone (or collection of zones for cross-zone instances) an instance
     * should be provisioned in. Refer to [location_id][google.cloud.redis.v1beta1.Instance.location_id] and
     * [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id] fields for more details.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * An arbitrary and optional user-provided name for the instance.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An arbitrary and optional user-provided name for the instance.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An arbitrary and optional user-provided name for the instance.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An arbitrary and optional user-provided name for the instance.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An arbitrary and optional user-provided name for the instance.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private java.lang.Object locationId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The zone where the instance will be provisioned. If not provided,
     * the service will choose a zone for the instance. For STANDARD_HA tier,
     * instances will be created across two zones for protection against zonal
     * failures. If [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id] is also provided, it must be
     * different from [location_id][google.cloud.redis.v1beta1.Instance.location_id].
     * </pre>
     *
     * <code>string location_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The locationId.
     */
    public java.lang.String getLocationId() {
      java.lang.Object ref = locationId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        locationId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The zone where the instance will be provisioned. If not provided,
     * the service will choose a zone for the instance. For STANDARD_HA tier,
     * instances will be created across two zones for protection against zonal
     * failures. If [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id] is also provided, it must be
     * different from [location_id][google.cloud.redis.v1beta1.Instance.location_id].
     * </pre>
     *
     * <code>string location_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for locationId.
     */
    public com.google.protobuf.ByteString getLocationIdBytes() {
      java.lang.Object ref = locationId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        locationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The zone where the instance will be provisioned. If not provided,
     * the service will choose a zone for the instance. For STANDARD_HA tier,
     * instances will be created across two zones for protection against zonal
     * failures. If [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id] is also provided, it must be
     * different from [location_id][google.cloud.redis.v1beta1.Instance.location_id].
     * </pre>
     *
     * <code>string location_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The locationId to set.
     * @return This builder for chaining.
     */
    public Builder setLocationId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      locationId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The zone where the instance will be provisioned. If not provided,
     * the service will choose a zone for the instance. For STANDARD_HA tier,
     * instances will be created across two zones for protection against zonal
     * failures. If [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id] is also provided, it must be
     * different from [location_id][google.cloud.redis.v1beta1.Instance.location_id].
     * </pre>
     *
     * <code>string location_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocationId() {

      locationId_ = getDefaultInstance().getLocationId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The zone where the instance will be provisioned. If not provided,
     * the service will choose a zone for the instance. For STANDARD_HA tier,
     * instances will be created across two zones for protection against zonal
     * failures. If [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id] is also provided, it must be
     * different from [location_id][google.cloud.redis.v1beta1.Instance.location_id].
     * </pre>
     *
     * <code>string location_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for locationId to set.
     * @return This builder for chaining.
     */
    public Builder setLocationIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      locationId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object alternativeLocationId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Only applicable to STANDARD_HA tier which protects the instance
     * against zonal failures by provisioning it across two zones. If provided, it
     * must be a different zone from the one provided in [location_id][google.cloud.redis.v1beta1.Instance.location_id].
     * </pre>
     *
     * <code>string alternative_location_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The alternativeLocationId.
     */
    public java.lang.String getAlternativeLocationId() {
      java.lang.Object ref = alternativeLocationId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        alternativeLocationId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Only applicable to STANDARD_HA tier which protects the instance
     * against zonal failures by provisioning it across two zones. If provided, it
     * must be a different zone from the one provided in [location_id][google.cloud.redis.v1beta1.Instance.location_id].
     * </pre>
     *
     * <code>string alternative_location_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for alternativeLocationId.
     */
    public com.google.protobuf.ByteString getAlternativeLocationIdBytes() {
      java.lang.Object ref = alternativeLocationId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        alternativeLocationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Only applicable to STANDARD_HA tier which protects the instance
     * against zonal failures by provisioning it across two zones. If provided, it
     * must be a different zone from the one provided in [location_id][google.cloud.redis.v1beta1.Instance.location_id].
     * </pre>
     *
     * <code>string alternative_location_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The alternativeLocationId to set.
     * @return This builder for chaining.
     */
    public Builder setAlternativeLocationId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      alternativeLocationId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Only applicable to STANDARD_HA tier which protects the instance
     * against zonal failures by provisioning it across two zones. If provided, it
     * must be a different zone from the one provided in [location_id][google.cloud.redis.v1beta1.Instance.location_id].
     * </pre>
     *
     * <code>string alternative_location_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAlternativeLocationId() {

      alternativeLocationId_ = getDefaultInstance().getAlternativeLocationId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Only applicable to STANDARD_HA tier which protects the instance
     * against zonal failures by provisioning it across two zones. If provided, it
     * must be a different zone from the one provided in [location_id][google.cloud.redis.v1beta1.Instance.location_id].
     * </pre>
     *
     * <code>string alternative_location_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for alternativeLocationId to set.
     * @return This builder for chaining.
     */
    public Builder setAlternativeLocationIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      alternativeLocationId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object redisVersion_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The version of Redis software.
     * If not provided, latest supported version will be used. Currently, the
     * supported values are:
     *  *   `REDIS_4_0` for Redis 4.0 compatibility (default)
     *  *   `REDIS_3_2` for Redis 3.2 compatibility
     * </pre>
     *
     * <code>string redis_version = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The redisVersion.
     */
    public java.lang.String getRedisVersion() {
      java.lang.Object ref = redisVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        redisVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The version of Redis software.
     * If not provided, latest supported version will be used. Currently, the
     * supported values are:
     *  *   `REDIS_4_0` for Redis 4.0 compatibility (default)
     *  *   `REDIS_3_2` for Redis 3.2 compatibility
     * </pre>
     *
     * <code>string redis_version = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for redisVersion.
     */
    public com.google.protobuf.ByteString getRedisVersionBytes() {
      java.lang.Object ref = redisVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        redisVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The version of Redis software.
     * If not provided, latest supported version will be used. Currently, the
     * supported values are:
     *  *   `REDIS_4_0` for Redis 4.0 compatibility (default)
     *  *   `REDIS_3_2` for Redis 3.2 compatibility
     * </pre>
     *
     * <code>string redis_version = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The redisVersion to set.
     * @return This builder for chaining.
     */
    public Builder setRedisVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      redisVersion_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The version of Redis software.
     * If not provided, latest supported version will be used. Currently, the
     * supported values are:
     *  *   `REDIS_4_0` for Redis 4.0 compatibility (default)
     *  *   `REDIS_3_2` for Redis 3.2 compatibility
     * </pre>
     *
     * <code>string redis_version = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRedisVersion() {

      redisVersion_ = getDefaultInstance().getRedisVersion();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The version of Redis software.
     * If not provided, latest supported version will be used. Currently, the
     * supported values are:
     *  *   `REDIS_4_0` for Redis 4.0 compatibility (default)
     *  *   `REDIS_3_2` for Redis 3.2 compatibility
     * </pre>
     *
     * <code>string redis_version = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for redisVersion to set.
     * @return This builder for chaining.
     */
    public Builder setRedisVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      redisVersion_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object reservedIpRange_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The CIDR range of internal addresses that are reserved for this
     * instance. If not provided, the service will choose an unused /29 block,
     * for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be unique
     * and non-overlapping with existing subnets in an authorized network.
     * </pre>
     *
     * <code>string reserved_ip_range = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The reservedIpRange.
     */
    public java.lang.String getReservedIpRange() {
      java.lang.Object ref = reservedIpRange_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        reservedIpRange_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The CIDR range of internal addresses that are reserved for this
     * instance. If not provided, the service will choose an unused /29 block,
     * for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be unique
     * and non-overlapping with existing subnets in an authorized network.
     * </pre>
     *
     * <code>string reserved_ip_range = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for reservedIpRange.
     */
    public com.google.protobuf.ByteString getReservedIpRangeBytes() {
      java.lang.Object ref = reservedIpRange_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        reservedIpRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The CIDR range of internal addresses that are reserved for this
     * instance. If not provided, the service will choose an unused /29 block,
     * for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be unique
     * and non-overlapping with existing subnets in an authorized network.
     * </pre>
     *
     * <code>string reserved_ip_range = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The reservedIpRange to set.
     * @return This builder for chaining.
     */
    public Builder setReservedIpRange(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      reservedIpRange_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The CIDR range of internal addresses that are reserved for this
     * instance. If not provided, the service will choose an unused /29 block,
     * for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be unique
     * and non-overlapping with existing subnets in an authorized network.
     * </pre>
     *
     * <code>string reserved_ip_range = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReservedIpRange() {

      reservedIpRange_ = getDefaultInstance().getReservedIpRange();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The CIDR range of internal addresses that are reserved for this
     * instance. If not provided, the service will choose an unused /29 block,
     * for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be unique
     * and non-overlapping with existing subnets in an authorized network.
     * </pre>
     *
     * <code>string reserved_ip_range = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for reservedIpRange to set.
     * @return This builder for chaining.
     */
    public Builder setReservedIpRangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      reservedIpRange_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object host_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Hostname or IP address of the exposed Redis endpoint used by
     * clients to connect to the service.
     * </pre>
     *
     * <code>string host = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The host.
     */
    public java.lang.String getHost() {
      java.lang.Object ref = host_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        host_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Hostname or IP address of the exposed Redis endpoint used by
     * clients to connect to the service.
     * </pre>
     *
     * <code>string host = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for host.
     */
    public com.google.protobuf.ByteString getHostBytes() {
      java.lang.Object ref = host_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        host_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Hostname or IP address of the exposed Redis endpoint used by
     * clients to connect to the service.
     * </pre>
     *
     * <code>string host = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The host to set.
     * @return This builder for chaining.
     */
    public Builder setHost(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      host_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Hostname or IP address of the exposed Redis endpoint used by
     * clients to connect to the service.
     * </pre>
     *
     * <code>string host = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHost() {

      host_ = getDefaultInstance().getHost();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Hostname or IP address of the exposed Redis endpoint used by
     * clients to connect to the service.
     * </pre>
     *
     * <code>string host = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for host to set.
     * @return This builder for chaining.
     */
    public Builder setHostBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      host_ = value;
      onChanged();
      return this;
    }

    private int port_;
    /**
     *
     *
     * <pre>
     * Output only. The port number of the exposed Redis endpoint.
     * </pre>
     *
     * <code>int32 port = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The port.
     */
    public int getPort() {
      return port_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The port number of the exposed Redis endpoint.
     * </pre>
     *
     * <code>int32 port = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The port to set.
     * @return This builder for chaining.
     */
    public Builder setPort(int value) {

      port_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The port number of the exposed Redis endpoint.
     * </pre>
     *
     * <code>int32 port = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPort() {

      port_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object currentLocationId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The current zone where the Redis endpoint is placed. For Basic
     * Tier instances, this will always be the same as the [location_id][google.cloud.redis.v1beta1.Instance.location_id]
     * provided by the user at creation time. For Standard Tier instances,
     * this can be either [location_id][google.cloud.redis.v1beta1.Instance.location_id] or [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id] and can
     * change after a failover event.
     * </pre>
     *
     * <code>string current_location_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The currentLocationId.
     */
    public java.lang.String getCurrentLocationId() {
      java.lang.Object ref = currentLocationId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        currentLocationId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The current zone where the Redis endpoint is placed. For Basic
     * Tier instances, this will always be the same as the [location_id][google.cloud.redis.v1beta1.Instance.location_id]
     * provided by the user at creation time. For Standard Tier instances,
     * this can be either [location_id][google.cloud.redis.v1beta1.Instance.location_id] or [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id] and can
     * change after a failover event.
     * </pre>
     *
     * <code>string current_location_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for currentLocationId.
     */
    public com.google.protobuf.ByteString getCurrentLocationIdBytes() {
      java.lang.Object ref = currentLocationId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        currentLocationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The current zone where the Redis endpoint is placed. For Basic
     * Tier instances, this will always be the same as the [location_id][google.cloud.redis.v1beta1.Instance.location_id]
     * provided by the user at creation time. For Standard Tier instances,
     * this can be either [location_id][google.cloud.redis.v1beta1.Instance.location_id] or [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id] and can
     * change after a failover event.
     * </pre>
     *
     * <code>string current_location_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The currentLocationId to set.
     * @return This builder for chaining.
     */
    public Builder setCurrentLocationId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      currentLocationId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current zone where the Redis endpoint is placed. For Basic
     * Tier instances, this will always be the same as the [location_id][google.cloud.redis.v1beta1.Instance.location_id]
     * provided by the user at creation time. For Standard Tier instances,
     * this can be either [location_id][google.cloud.redis.v1beta1.Instance.location_id] or [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id] and can
     * change after a failover event.
     * </pre>
     *
     * <code>string current_location_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCurrentLocationId() {

      currentLocationId_ = getDefaultInstance().getCurrentLocationId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current zone where the Redis endpoint is placed. For Basic
     * Tier instances, this will always be the same as the [location_id][google.cloud.redis.v1beta1.Instance.location_id]
     * provided by the user at creation time. For Standard Tier instances,
     * this can be either [location_id][google.cloud.redis.v1beta1.Instance.location_id] or [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id] and can
     * change after a failover event.
     * </pre>
     *
     * <code>string current_location_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for currentLocationId to set.
     * @return This builder for chaining.
     */
    public Builder setCurrentLocationIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      currentLocationId_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current state of this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1beta1.Instance.State state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1beta1.Instance.State state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1beta1.Instance.State state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    public com.google.cloud.redis.v1beta1.Instance.State getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.redis.v1beta1.Instance.State result =
          com.google.cloud.redis.v1beta1.Instance.State.valueOf(state_);
      return result == null ? com.google.cloud.redis.v1beta1.Instance.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1beta1.Instance.State state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.redis.v1beta1.Instance.State value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1beta1.Instance.State state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object statusMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current status of this
     * instance, if available.
     * </pre>
     *
     * <code>string status_message = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The statusMessage.
     */
    public java.lang.String getStatusMessage() {
      java.lang.Object ref = statusMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        statusMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current status of this
     * instance, if available.
     * </pre>
     *
     * <code>string status_message = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for statusMessage.
     */
    public com.google.protobuf.ByteString getStatusMessageBytes() {
      java.lang.Object ref = statusMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        statusMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current status of this
     * instance, if available.
     * </pre>
     *
     * <code>string status_message = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The statusMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStatusMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      statusMessage_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current status of this
     * instance, if available.
     * </pre>
     *
     * <code>string status_message = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatusMessage() {

      statusMessage_ = getDefaultInstance().getStatusMessage();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current status of this
     * instance, if available.
     * </pre>
     *
     * <code>string status_message = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for statusMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStatusMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      statusMessage_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> redisConfigs_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetRedisConfigs() {
      if (redisConfigs_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            RedisConfigsDefaultEntryHolder.defaultEntry);
      }
      return redisConfigs_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableRedisConfigs() {
      onChanged();
      ;
      if (redisConfigs_ == null) {
        redisConfigs_ =
            com.google.protobuf.MapField.newMapField(RedisConfigsDefaultEntryHolder.defaultEntry);
      }
      if (!redisConfigs_.isMutable()) {
        redisConfigs_ = redisConfigs_.copy();
      }
      return redisConfigs_;
    }

    public int getRedisConfigsCount() {
      return internalGetRedisConfigs().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Redis configuration parameters, according to
     * http://redis.io/topics/config. Currently, the only supported parameters
     * are:
     *  Redis 3.2 and above:
     *  *   maxmemory-policy
     *  *   notify-keyspace-events
     *  Redis 4.0 and above:
     *  *   activedefrag
     *  *   lfu-log-factor
     *  *   lfu-decay-time
     * </pre>
     *
     * <code>map&lt;string, string&gt; redis_configs = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public boolean containsRedisConfigs(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetRedisConfigs().getMap().containsKey(key);
    }
    /** Use {@link #getRedisConfigsMap()} instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getRedisConfigs() {
      return getRedisConfigsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Redis configuration parameters, according to
     * http://redis.io/topics/config. Currently, the only supported parameters
     * are:
     *  Redis 3.2 and above:
     *  *   maxmemory-policy
     *  *   notify-keyspace-events
     *  Redis 4.0 and above:
     *  *   activedefrag
     *  *   lfu-log-factor
     *  *   lfu-decay-time
     * </pre>
     *
     * <code>map&lt;string, string&gt; redis_configs = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.Map<java.lang.String, java.lang.String> getRedisConfigsMap() {
      return internalGetRedisConfigs().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Redis configuration parameters, according to
     * http://redis.io/topics/config. Currently, the only supported parameters
     * are:
     *  Redis 3.2 and above:
     *  *   maxmemory-policy
     *  *   notify-keyspace-events
     *  Redis 4.0 and above:
     *  *   activedefrag
     *  *   lfu-log-factor
     *  *   lfu-decay-time
     * </pre>
     *
     * <code>map&lt;string, string&gt; redis_configs = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.lang.String getRedisConfigsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetRedisConfigs().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Redis configuration parameters, according to
     * http://redis.io/topics/config. Currently, the only supported parameters
     * are:
     *  Redis 3.2 and above:
     *  *   maxmemory-policy
     *  *   notify-keyspace-events
     *  Redis 4.0 and above:
     *  *   activedefrag
     *  *   lfu-log-factor
     *  *   lfu-decay-time
     * </pre>
     *
     * <code>map&lt;string, string&gt; redis_configs = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.lang.String getRedisConfigsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetRedisConfigs().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearRedisConfigs() {
      internalGetMutableRedisConfigs().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Redis configuration parameters, according to
     * http://redis.io/topics/config. Currently, the only supported parameters
     * are:
     *  Redis 3.2 and above:
     *  *   maxmemory-policy
     *  *   notify-keyspace-events
     *  Redis 4.0 and above:
     *  *   activedefrag
     *  *   lfu-log-factor
     *  *   lfu-decay-time
     * </pre>
     *
     * <code>map&lt;string, string&gt; redis_configs = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeRedisConfigs(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableRedisConfigs().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableRedisConfigs() {
      return internalGetMutableRedisConfigs().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Redis configuration parameters, according to
     * http://redis.io/topics/config. Currently, the only supported parameters
     * are:
     *  Redis 3.2 and above:
     *  *   maxmemory-policy
     *  *   notify-keyspace-events
     *  Redis 4.0 and above:
     *  *   activedefrag
     *  *   lfu-log-factor
     *  *   lfu-decay-time
     * </pre>
     *
     * <code>map&lt;string, string&gt; redis_configs = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putRedisConfigs(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableRedisConfigs().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Redis configuration parameters, according to
     * http://redis.io/topics/config. Currently, the only supported parameters
     * are:
     *  Redis 3.2 and above:
     *  *   maxmemory-policy
     *  *   notify-keyspace-events
     *  Redis 4.0 and above:
     *  *   activedefrag
     *  *   lfu-log-factor
     *  *   lfu-decay-time
     * </pre>
     *
     * <code>map&lt;string, string&gt; redis_configs = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllRedisConfigs(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableRedisConfigs().getMutableMap().putAll(values);
      return this;
    }

    private int tier_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The service tier of the instance.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1beta1.Instance.Tier tier = 17 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for tier.
     */
    public int getTierValue() {
      return tier_;
    }
    /**
     *
     *
     * <pre>
     * Required. The service tier of the instance.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1beta1.Instance.Tier tier = 17 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for tier to set.
     * @return This builder for chaining.
     */
    public Builder setTierValue(int value) {
      tier_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The service tier of the instance.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1beta1.Instance.Tier tier = 17 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The tier.
     */
    public com.google.cloud.redis.v1beta1.Instance.Tier getTier() {
      @SuppressWarnings("deprecation")
      com.google.cloud.redis.v1beta1.Instance.Tier result =
          com.google.cloud.redis.v1beta1.Instance.Tier.valueOf(tier_);
      return result == null ? com.google.cloud.redis.v1beta1.Instance.Tier.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The service tier of the instance.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1beta1.Instance.Tier tier = 17 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The tier to set.
     * @return This builder for chaining.
     */
    public Builder setTier(com.google.cloud.redis.v1beta1.Instance.Tier value) {
      if (value == null) {
        throw new NullPointerException();
      }

      tier_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The service tier of the instance.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1beta1.Instance.Tier tier = 17 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTier() {

      tier_ = 0;
      onChanged();
      return this;
    }

    private int memorySizeGb_;
    /**
     *
     *
     * <pre>
     * Required. Redis memory size in GiB.
     * </pre>
     *
     * <code>int32 memory_size_gb = 18 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The memorySizeGb.
     */
    public int getMemorySizeGb() {
      return memorySizeGb_;
    }
    /**
     *
     *
     * <pre>
     * Required. Redis memory size in GiB.
     * </pre>
     *
     * <code>int32 memory_size_gb = 18 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The memorySizeGb to set.
     * @return This builder for chaining.
     */
    public Builder setMemorySizeGb(int value) {

      memorySizeGb_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Redis memory size in GiB.
     * </pre>
     *
     * <code>int32 memory_size_gb = 18 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMemorySizeGb() {

      memorySizeGb_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object authorizedNetwork_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The full name of the Google Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the
     * instance is connected. If left unspecified, the `default` network
     * will be used.
     * </pre>
     *
     * <code>string authorized_network = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The authorizedNetwork.
     */
    public java.lang.String getAuthorizedNetwork() {
      java.lang.Object ref = authorizedNetwork_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        authorizedNetwork_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The full name of the Google Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the
     * instance is connected. If left unspecified, the `default` network
     * will be used.
     * </pre>
     *
     * <code>string authorized_network = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for authorizedNetwork.
     */
    public com.google.protobuf.ByteString getAuthorizedNetworkBytes() {
      java.lang.Object ref = authorizedNetwork_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        authorizedNetwork_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The full name of the Google Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the
     * instance is connected. If left unspecified, the `default` network
     * will be used.
     * </pre>
     *
     * <code>string authorized_network = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The authorizedNetwork to set.
     * @return This builder for chaining.
     */
    public Builder setAuthorizedNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      authorizedNetwork_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The full name of the Google Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the
     * instance is connected. If left unspecified, the `default` network
     * will be used.
     * </pre>
     *
     * <code>string authorized_network = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAuthorizedNetwork() {

      authorizedNetwork_ = getDefaultInstance().getAuthorizedNetwork();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The full name of the Google Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the
     * instance is connected. If left unspecified, the `default` network
     * will be used.
     * </pre>
     *
     * <code>string authorized_network = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for authorizedNetwork to set.
     * @return This builder for chaining.
     */
    public Builder setAuthorizedNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      authorizedNetwork_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object persistenceIamIdentity_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Cloud IAM identity used by import / export operations to
     * transfer data to/from Cloud Storage. Format is
     * "serviceAccount:&lt;service_account_email&gt;". The value may change over time
     * for a given instance so should be checked before each import/export
     * operation.
     * </pre>
     *
     * <code>string persistence_iam_identity = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The persistenceIamIdentity.
     */
    public java.lang.String getPersistenceIamIdentity() {
      java.lang.Object ref = persistenceIamIdentity_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        persistenceIamIdentity_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud IAM identity used by import / export operations to
     * transfer data to/from Cloud Storage. Format is
     * "serviceAccount:&lt;service_account_email&gt;". The value may change over time
     * for a given instance so should be checked before each import/export
     * operation.
     * </pre>
     *
     * <code>string persistence_iam_identity = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for persistenceIamIdentity.
     */
    public com.google.protobuf.ByteString getPersistenceIamIdentityBytes() {
      java.lang.Object ref = persistenceIamIdentity_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        persistenceIamIdentity_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud IAM identity used by import / export operations to
     * transfer data to/from Cloud Storage. Format is
     * "serviceAccount:&lt;service_account_email&gt;". The value may change over time
     * for a given instance so should be checked before each import/export
     * operation.
     * </pre>
     *
     * <code>string persistence_iam_identity = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The persistenceIamIdentity to set.
     * @return This builder for chaining.
     */
    public Builder setPersistenceIamIdentity(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      persistenceIamIdentity_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud IAM identity used by import / export operations to
     * transfer data to/from Cloud Storage. Format is
     * "serviceAccount:&lt;service_account_email&gt;". The value may change over time
     * for a given instance so should be checked before each import/export
     * operation.
     * </pre>
     *
     * <code>string persistence_iam_identity = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPersistenceIamIdentity() {

      persistenceIamIdentity_ = getDefaultInstance().getPersistenceIamIdentity();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud IAM identity used by import / export operations to
     * transfer data to/from Cloud Storage. Format is
     * "serviceAccount:&lt;service_account_email&gt;". The value may change over time
     * for a given instance so should be checked before each import/export
     * operation.
     * </pre>
     *
     * <code>string persistence_iam_identity = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for persistenceIamIdentity to set.
     * @return This builder for chaining.
     */
    public Builder setPersistenceIamIdentityBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      persistenceIamIdentity_ = value;
      onChanged();
      return this;
    }

    private int connectMode_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The connect mode of Redis instance.
     * If not provided, default one will be used.
     * Current default: DIRECT_PEERING.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1beta1.Instance.ConnectMode connect_mode = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for connectMode.
     */
    public int getConnectModeValue() {
      return connectMode_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The connect mode of Redis instance.
     * If not provided, default one will be used.
     * Current default: DIRECT_PEERING.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1beta1.Instance.ConnectMode connect_mode = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for connectMode to set.
     * @return This builder for chaining.
     */
    public Builder setConnectModeValue(int value) {
      connectMode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The connect mode of Redis instance.
     * If not provided, default one will be used.
     * Current default: DIRECT_PEERING.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1beta1.Instance.ConnectMode connect_mode = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The connectMode.
     */
    public com.google.cloud.redis.v1beta1.Instance.ConnectMode getConnectMode() {
      @SuppressWarnings("deprecation")
      com.google.cloud.redis.v1beta1.Instance.ConnectMode result =
          com.google.cloud.redis.v1beta1.Instance.ConnectMode.valueOf(connectMode_);
      return result == null
          ? com.google.cloud.redis.v1beta1.Instance.ConnectMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The connect mode of Redis instance.
     * If not provided, default one will be used.
     * Current default: DIRECT_PEERING.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1beta1.Instance.ConnectMode connect_mode = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The connectMode to set.
     * @return This builder for chaining.
     */
    public Builder setConnectMode(com.google.cloud.redis.v1beta1.Instance.ConnectMode value) {
      if (value == null) {
        throw new NullPointerException();
      }

      connectMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The connect mode of Redis instance.
     * If not provided, default one will be used.
     * Current default: DIRECT_PEERING.
     * </pre>
     *
     * <code>
     * .google.cloud.redis.v1beta1.Instance.ConnectMode connect_mode = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConnectMode() {

      connectMode_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.redis.v1beta1.Instance)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.redis.v1beta1.Instance)
  private static final com.google.cloud.redis.v1beta1.Instance DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.redis.v1beta1.Instance();
  }

  public static com.google.cloud.redis.v1beta1.Instance getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Instance> PARSER =
      new com.google.protobuf.AbstractParser<Instance>() {
        @java.lang.Override
        public Instance parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Instance(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Instance> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Instance> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.redis.v1beta1.Instance getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
