/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcesettings.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SettingName
implements ResourceName {
    private static final PathTemplate PROJECT_NUMBER_SETTING_NAME = PathTemplate.createWithoutUrlEncoding((String)"projects/{project_number}/settings/{setting_name}");
    private static final PathTemplate FOLDER_SETTING_NAME = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/settings/{setting_name}");
    private static final PathTemplate ORGANIZATION_SETTING_NAME = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/settings/{setting_name}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String projectNumber;
    private final String settingName;
    private final String folder;
    private final String organization;

    @Deprecated
    protected SettingName() {
        this.projectNumber = null;
        this.settingName = null;
        this.folder = null;
        this.organization = null;
    }

    private SettingName(Builder builder) {
        this.projectNumber = (String)Preconditions.checkNotNull((Object)builder.getProjectNumber());
        this.settingName = (String)Preconditions.checkNotNull((Object)builder.getSettingName());
        this.folder = null;
        this.organization = null;
        this.pathTemplate = PROJECT_NUMBER_SETTING_NAME;
    }

    private SettingName(FolderSettingNameBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.settingName = (String)Preconditions.checkNotNull((Object)builder.getSettingName());
        this.projectNumber = null;
        this.organization = null;
        this.pathTemplate = FOLDER_SETTING_NAME;
    }

    private SettingName(OrganizationSettingNameBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.settingName = (String)Preconditions.checkNotNull((Object)builder.getSettingName());
        this.projectNumber = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_SETTING_NAME;
    }

    public String getProjectNumber() {
        return this.projectNumber;
    }

    public String getSettingName() {
        return this.settingName;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectNumberSettingNameBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderSettingNameBuilder newFolderSettingNameBuilder() {
        return new FolderSettingNameBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationSettingNameBuilder newOrganizationSettingNameBuilder() {
        return new OrganizationSettingNameBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SettingName of(String projectNumber, String settingName) {
        return SettingName.newBuilder().setProjectNumber(projectNumber).setSettingName(settingName).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SettingName ofProjectNumberSettingNameName(String projectNumber, String settingName) {
        return SettingName.newBuilder().setProjectNumber(projectNumber).setSettingName(settingName).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SettingName ofFolderSettingNameName(String folder, String settingName) {
        return SettingName.newFolderSettingNameBuilder().setFolder(folder).setSettingName(settingName).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SettingName ofOrganizationSettingNameName(String organization, String settingName) {
        return SettingName.newOrganizationSettingNameBuilder().setOrganization(organization).setSettingName(settingName).build();
    }

    public static String format(String projectNumber, String settingName) {
        return SettingName.newBuilder().setProjectNumber(projectNumber).setSettingName(settingName).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectNumberSettingNameName(String projectNumber, String settingName) {
        return SettingName.newBuilder().setProjectNumber(projectNumber).setSettingName(settingName).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderSettingNameName(String folder, String settingName) {
        return SettingName.newFolderSettingNameBuilder().setFolder(folder).setSettingName(settingName).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationSettingNameName(String organization, String settingName) {
        return SettingName.newOrganizationSettingNameBuilder().setOrganization(organization).setSettingName(settingName).build().toString();
    }

    public static SettingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_NUMBER_SETTING_NAME.matches(formattedString)) {
            Map matchMap = PROJECT_NUMBER_SETTING_NAME.match(formattedString);
            return SettingName.ofProjectNumberSettingNameName((String)matchMap.get("project_number"), (String)matchMap.get("setting_name"));
        }
        if (FOLDER_SETTING_NAME.matches(formattedString)) {
            Map matchMap = FOLDER_SETTING_NAME.match(formattedString);
            return SettingName.ofFolderSettingNameName((String)matchMap.get("folder"), (String)matchMap.get("setting_name"));
        }
        if (ORGANIZATION_SETTING_NAME.matches(formattedString)) {
            Map matchMap = ORGANIZATION_SETTING_NAME.match(formattedString);
            return SettingName.ofOrganizationSettingNameName((String)matchMap.get("organization"), (String)matchMap.get("setting_name"));
        }
        throw new ValidationException("SettingName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<SettingName> parseList(List<String> formattedStrings) {
        ArrayList<SettingName> list = new ArrayList<SettingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SettingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SettingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SettingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_NUMBER_SETTING_NAME.matches(formattedString) || FOLDER_SETTING_NAME.matches(formattedString) || ORGANIZATION_SETTING_NAME.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SettingName settingName = this;
            synchronized (settingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.projectNumber != null) {
                        fieldMapBuilder.put((Object)"project_number", (Object)this.projectNumber);
                    }
                    if (this.settingName != null) {
                        fieldMapBuilder.put((Object)"setting_name", (Object)this.settingName);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            SettingName that = (SettingName)o;
            return Objects.equals(this.projectNumber, that.projectNumber) && Objects.equals(this.settingName, that.settingName) && Objects.equals(this.folder, that.folder) && Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.projectNumber);
        h *= 1000003;
        h ^= Objects.hashCode(this.settingName);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationSettingNameBuilder {
        private String organization;
        private String settingName;

        protected OrganizationSettingNameBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getSettingName() {
            return this.settingName;
        }

        public OrganizationSettingNameBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationSettingNameBuilder setSettingName(String settingName) {
            this.settingName = settingName;
            return this;
        }

        public SettingName build() {
            return new SettingName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderSettingNameBuilder {
        private String folder;
        private String settingName;

        protected FolderSettingNameBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getSettingName() {
            return this.settingName;
        }

        public FolderSettingNameBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderSettingNameBuilder setSettingName(String settingName) {
            this.settingName = settingName;
            return this;
        }

        public SettingName build() {
            return new SettingName(this);
        }
    }

    public static class Builder {
        private String projectNumber;
        private String settingName;

        protected Builder() {
        }

        public String getProjectNumber() {
            return this.projectNumber;
        }

        public String getSettingName() {
            return this.settingName;
        }

        public Builder setProjectNumber(String projectNumber) {
            this.projectNumber = projectNumber;
            return this;
        }

        public Builder setSettingName(String settingName) {
            this.settingName = settingName;
            return this;
        }

        private Builder(SettingName settingName) {
            Preconditions.checkArgument((boolean)Objects.equals(settingName.pathTemplate, PROJECT_NUMBER_SETTING_NAME), (Object)"toBuilder is only supported when SettingName has the pattern of projects/{project_number}/settings/{setting_name}");
            this.projectNumber = settingName.projectNumber;
            this.settingName = settingName.settingName;
        }

        public SettingName build() {
            return new SettingName(this);
        }
    }
}

