/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/resourcemanager/v3/tag_keys.proto

package com.google.cloud.resourcemanager.v3;

/**
 *
 *
 * <pre>
 * The ListTagKeys response message.
 * </pre>
 *
 * Protobuf type {@code google.cloud.resourcemanager.v3.ListTagKeysResponse}
 */
public final class ListTagKeysResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.resourcemanager.v3.ListTagKeysResponse)
    ListTagKeysResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListTagKeysResponse.newBuilder() to construct.
  private ListTagKeysResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListTagKeysResponse() {
    tagKeys_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListTagKeysResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.resourcemanager.v3.TagKeysProto
        .internal_static_google_cloud_resourcemanager_v3_ListTagKeysResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.resourcemanager.v3.TagKeysProto
        .internal_static_google_cloud_resourcemanager_v3_ListTagKeysResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.resourcemanager.v3.ListTagKeysResponse.class,
            com.google.cloud.resourcemanager.v3.ListTagKeysResponse.Builder.class);
  }

  public static final int TAG_KEYS_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.resourcemanager.v3.TagKey> tagKeys_;
  /**
   *
   *
   * <pre>
   * List of TagKeys that live under the specified parent in the request.
   * </pre>
   *
   * <code>repeated .google.cloud.resourcemanager.v3.TagKey tag_keys = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.resourcemanager.v3.TagKey> getTagKeysList() {
    return tagKeys_;
  }
  /**
   *
   *
   * <pre>
   * List of TagKeys that live under the specified parent in the request.
   * </pre>
   *
   * <code>repeated .google.cloud.resourcemanager.v3.TagKey tag_keys = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.resourcemanager.v3.TagKeyOrBuilder>
      getTagKeysOrBuilderList() {
    return tagKeys_;
  }
  /**
   *
   *
   * <pre>
   * List of TagKeys that live under the specified parent in the request.
   * </pre>
   *
   * <code>repeated .google.cloud.resourcemanager.v3.TagKey tag_keys = 1;</code>
   */
  @java.lang.Override
  public int getTagKeysCount() {
    return tagKeys_.size();
  }
  /**
   *
   *
   * <pre>
   * List of TagKeys that live under the specified parent in the request.
   * </pre>
   *
   * <code>repeated .google.cloud.resourcemanager.v3.TagKey tag_keys = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.resourcemanager.v3.TagKey getTagKeys(int index) {
    return tagKeys_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of TagKeys that live under the specified parent in the request.
   * </pre>
   *
   * <code>repeated .google.cloud.resourcemanager.v3.TagKey tag_keys = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.resourcemanager.v3.TagKeyOrBuilder getTagKeysOrBuilder(int index) {
    return tagKeys_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;
  private volatile java.lang.Object nextPageToken_;
  /**
   *
   *
   * <pre>
   * A pagination token returned from a previous call to `ListTagKeys`
   * that indicates from where listing should continue.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A pagination token returned from a previous call to `ListTagKeys`
   * that indicates from where listing should continue.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < tagKeys_.size(); i++) {
      output.writeMessage(1, tagKeys_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < tagKeys_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, tagKeys_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.resourcemanager.v3.ListTagKeysResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.resourcemanager.v3.ListTagKeysResponse other =
        (com.google.cloud.resourcemanager.v3.ListTagKeysResponse) obj;

    if (!getTagKeysList().equals(other.getTagKeysList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getTagKeysCount() > 0) {
      hash = (37 * hash) + TAG_KEYS_FIELD_NUMBER;
      hash = (53 * hash) + getTagKeysList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.resourcemanager.v3.ListTagKeysResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.resourcemanager.v3.ListTagKeysResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.resourcemanager.v3.ListTagKeysResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.resourcemanager.v3.ListTagKeysResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.resourcemanager.v3.ListTagKeysResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.resourcemanager.v3.ListTagKeysResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.resourcemanager.v3.ListTagKeysResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.resourcemanager.v3.ListTagKeysResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.resourcemanager.v3.ListTagKeysResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.resourcemanager.v3.ListTagKeysResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.resourcemanager.v3.ListTagKeysResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.resourcemanager.v3.ListTagKeysResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.resourcemanager.v3.ListTagKeysResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The ListTagKeys response message.
   * </pre>
   *
   * Protobuf type {@code google.cloud.resourcemanager.v3.ListTagKeysResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.resourcemanager.v3.ListTagKeysResponse)
      com.google.cloud.resourcemanager.v3.ListTagKeysResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.resourcemanager.v3.TagKeysProto
          .internal_static_google_cloud_resourcemanager_v3_ListTagKeysResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.resourcemanager.v3.TagKeysProto
          .internal_static_google_cloud_resourcemanager_v3_ListTagKeysResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.resourcemanager.v3.ListTagKeysResponse.class,
              com.google.cloud.resourcemanager.v3.ListTagKeysResponse.Builder.class);
    }

    // Construct using com.google.cloud.resourcemanager.v3.ListTagKeysResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (tagKeysBuilder_ == null) {
        tagKeys_ = java.util.Collections.emptyList();
      } else {
        tagKeys_ = null;
        tagKeysBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      nextPageToken_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.resourcemanager.v3.TagKeysProto
          .internal_static_google_cloud_resourcemanager_v3_ListTagKeysResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.resourcemanager.v3.ListTagKeysResponse getDefaultInstanceForType() {
      return com.google.cloud.resourcemanager.v3.ListTagKeysResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.resourcemanager.v3.ListTagKeysResponse build() {
      com.google.cloud.resourcemanager.v3.ListTagKeysResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.resourcemanager.v3.ListTagKeysResponse buildPartial() {
      com.google.cloud.resourcemanager.v3.ListTagKeysResponse result =
          new com.google.cloud.resourcemanager.v3.ListTagKeysResponse(this);
      int from_bitField0_ = bitField0_;
      if (tagKeysBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          tagKeys_ = java.util.Collections.unmodifiableList(tagKeys_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.tagKeys_ = tagKeys_;
      } else {
        result.tagKeys_ = tagKeysBuilder_.build();
      }
      result.nextPageToken_ = nextPageToken_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.resourcemanager.v3.ListTagKeysResponse) {
        return mergeFrom((com.google.cloud.resourcemanager.v3.ListTagKeysResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.resourcemanager.v3.ListTagKeysResponse other) {
      if (other == com.google.cloud.resourcemanager.v3.ListTagKeysResponse.getDefaultInstance())
        return this;
      if (tagKeysBuilder_ == null) {
        if (!other.tagKeys_.isEmpty()) {
          if (tagKeys_.isEmpty()) {
            tagKeys_ = other.tagKeys_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureTagKeysIsMutable();
            tagKeys_.addAll(other.tagKeys_);
          }
          onChanged();
        }
      } else {
        if (!other.tagKeys_.isEmpty()) {
          if (tagKeysBuilder_.isEmpty()) {
            tagKeysBuilder_.dispose();
            tagKeysBuilder_ = null;
            tagKeys_ = other.tagKeys_;
            bitField0_ = (bitField0_ & ~0x00000001);
            tagKeysBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTagKeysFieldBuilder()
                    : null;
          } else {
            tagKeysBuilder_.addAllMessages(other.tagKeys_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.resourcemanager.v3.TagKey m =
                    input.readMessage(
                        com.google.cloud.resourcemanager.v3.TagKey.parser(), extensionRegistry);
                if (tagKeysBuilder_ == null) {
                  ensureTagKeysIsMutable();
                  tagKeys_.add(m);
                } else {
                  tagKeysBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                nextPageToken_ = input.readStringRequireUtf8();

                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.resourcemanager.v3.TagKey> tagKeys_ =
        java.util.Collections.emptyList();

    private void ensureTagKeysIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        tagKeys_ = new java.util.ArrayList<com.google.cloud.resourcemanager.v3.TagKey>(tagKeys_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.resourcemanager.v3.TagKey,
            com.google.cloud.resourcemanager.v3.TagKey.Builder,
            com.google.cloud.resourcemanager.v3.TagKeyOrBuilder>
        tagKeysBuilder_;

    /**
     *
     *
     * <pre>
     * List of TagKeys that live under the specified parent in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.TagKey tag_keys = 1;</code>
     */
    public java.util.List<com.google.cloud.resourcemanager.v3.TagKey> getTagKeysList() {
      if (tagKeysBuilder_ == null) {
        return java.util.Collections.unmodifiableList(tagKeys_);
      } else {
        return tagKeysBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of TagKeys that live under the specified parent in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.TagKey tag_keys = 1;</code>
     */
    public int getTagKeysCount() {
      if (tagKeysBuilder_ == null) {
        return tagKeys_.size();
      } else {
        return tagKeysBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of TagKeys that live under the specified parent in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.TagKey tag_keys = 1;</code>
     */
    public com.google.cloud.resourcemanager.v3.TagKey getTagKeys(int index) {
      if (tagKeysBuilder_ == null) {
        return tagKeys_.get(index);
      } else {
        return tagKeysBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of TagKeys that live under the specified parent in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.TagKey tag_keys = 1;</code>
     */
    public Builder setTagKeys(int index, com.google.cloud.resourcemanager.v3.TagKey value) {
      if (tagKeysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagKeysIsMutable();
        tagKeys_.set(index, value);
        onChanged();
      } else {
        tagKeysBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of TagKeys that live under the specified parent in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.TagKey tag_keys = 1;</code>
     */
    public Builder setTagKeys(
        int index, com.google.cloud.resourcemanager.v3.TagKey.Builder builderForValue) {
      if (tagKeysBuilder_ == null) {
        ensureTagKeysIsMutable();
        tagKeys_.set(index, builderForValue.build());
        onChanged();
      } else {
        tagKeysBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of TagKeys that live under the specified parent in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.TagKey tag_keys = 1;</code>
     */
    public Builder addTagKeys(com.google.cloud.resourcemanager.v3.TagKey value) {
      if (tagKeysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagKeysIsMutable();
        tagKeys_.add(value);
        onChanged();
      } else {
        tagKeysBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of TagKeys that live under the specified parent in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.TagKey tag_keys = 1;</code>
     */
    public Builder addTagKeys(int index, com.google.cloud.resourcemanager.v3.TagKey value) {
      if (tagKeysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagKeysIsMutable();
        tagKeys_.add(index, value);
        onChanged();
      } else {
        tagKeysBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of TagKeys that live under the specified parent in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.TagKey tag_keys = 1;</code>
     */
    public Builder addTagKeys(com.google.cloud.resourcemanager.v3.TagKey.Builder builderForValue) {
      if (tagKeysBuilder_ == null) {
        ensureTagKeysIsMutable();
        tagKeys_.add(builderForValue.build());
        onChanged();
      } else {
        tagKeysBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of TagKeys that live under the specified parent in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.TagKey tag_keys = 1;</code>
     */
    public Builder addTagKeys(
        int index, com.google.cloud.resourcemanager.v3.TagKey.Builder builderForValue) {
      if (tagKeysBuilder_ == null) {
        ensureTagKeysIsMutable();
        tagKeys_.add(index, builderForValue.build());
        onChanged();
      } else {
        tagKeysBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of TagKeys that live under the specified parent in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.TagKey tag_keys = 1;</code>
     */
    public Builder addAllTagKeys(
        java.lang.Iterable<? extends com.google.cloud.resourcemanager.v3.TagKey> values) {
      if (tagKeysBuilder_ == null) {
        ensureTagKeysIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tagKeys_);
        onChanged();
      } else {
        tagKeysBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of TagKeys that live under the specified parent in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.TagKey tag_keys = 1;</code>
     */
    public Builder clearTagKeys() {
      if (tagKeysBuilder_ == null) {
        tagKeys_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        tagKeysBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of TagKeys that live under the specified parent in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.TagKey tag_keys = 1;</code>
     */
    public Builder removeTagKeys(int index) {
      if (tagKeysBuilder_ == null) {
        ensureTagKeysIsMutable();
        tagKeys_.remove(index);
        onChanged();
      } else {
        tagKeysBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of TagKeys that live under the specified parent in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.TagKey tag_keys = 1;</code>
     */
    public com.google.cloud.resourcemanager.v3.TagKey.Builder getTagKeysBuilder(int index) {
      return getTagKeysFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of TagKeys that live under the specified parent in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.TagKey tag_keys = 1;</code>
     */
    public com.google.cloud.resourcemanager.v3.TagKeyOrBuilder getTagKeysOrBuilder(int index) {
      if (tagKeysBuilder_ == null) {
        return tagKeys_.get(index);
      } else {
        return tagKeysBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of TagKeys that live under the specified parent in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.TagKey tag_keys = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.resourcemanager.v3.TagKeyOrBuilder>
        getTagKeysOrBuilderList() {
      if (tagKeysBuilder_ != null) {
        return tagKeysBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(tagKeys_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of TagKeys that live under the specified parent in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.TagKey tag_keys = 1;</code>
     */
    public com.google.cloud.resourcemanager.v3.TagKey.Builder addTagKeysBuilder() {
      return getTagKeysFieldBuilder()
          .addBuilder(com.google.cloud.resourcemanager.v3.TagKey.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of TagKeys that live under the specified parent in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.TagKey tag_keys = 1;</code>
     */
    public com.google.cloud.resourcemanager.v3.TagKey.Builder addTagKeysBuilder(int index) {
      return getTagKeysFieldBuilder()
          .addBuilder(index, com.google.cloud.resourcemanager.v3.TagKey.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of TagKeys that live under the specified parent in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.TagKey tag_keys = 1;</code>
     */
    public java.util.List<com.google.cloud.resourcemanager.v3.TagKey.Builder>
        getTagKeysBuilderList() {
      return getTagKeysFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.resourcemanager.v3.TagKey,
            com.google.cloud.resourcemanager.v3.TagKey.Builder,
            com.google.cloud.resourcemanager.v3.TagKeyOrBuilder>
        getTagKeysFieldBuilder() {
      if (tagKeysBuilder_ == null) {
        tagKeysBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.resourcemanager.v3.TagKey,
                com.google.cloud.resourcemanager.v3.TagKey.Builder,
                com.google.cloud.resourcemanager.v3.TagKeyOrBuilder>(
                tagKeys_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        tagKeys_ = null;
      }
      return tagKeysBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * A pagination token returned from a previous call to `ListTagKeys`
     * that indicates from where listing should continue.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A pagination token returned from a previous call to `ListTagKeys`
     * that indicates from where listing should continue.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A pagination token returned from a previous call to `ListTagKeys`
     * that indicates from where listing should continue.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      nextPageToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A pagination token returned from a previous call to `ListTagKeys`
     * that indicates from where listing should continue.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {

      nextPageToken_ = getDefaultInstance().getNextPageToken();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A pagination token returned from a previous call to `ListTagKeys`
     * that indicates from where listing should continue.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      nextPageToken_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.resourcemanager.v3.ListTagKeysResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.resourcemanager.v3.ListTagKeysResponse)
  private static final com.google.cloud.resourcemanager.v3.ListTagKeysResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.resourcemanager.v3.ListTagKeysResponse();
  }

  public static com.google.cloud.resourcemanager.v3.ListTagKeysResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListTagKeysResponse> PARSER =
      new com.google.protobuf.AbstractParser<ListTagKeysResponse>() {
        @java.lang.Override
        public ListTagKeysResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListTagKeysResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListTagKeysResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.resourcemanager.v3.ListTagKeysResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
