/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/resourcemanager/v3/folders.proto

package com.google.cloud.resourcemanager.v3;

public interface SearchFoldersRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.resourcemanager.v3.SearchFoldersRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Optional. The maximum number of folders to return in the response.
   * If unspecified, server picks an appropriate default.
   * </pre>
   *
   * <code>int32 page_size = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageSize.
   */
  int getPageSize();

  /**
   *
   *
   * <pre>
   * Optional. A pagination token returned from a previous call to `SearchFolders`
   * that indicates from where search should continue.
   * </pre>
   *
   * <code>string page_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageToken.
   */
  java.lang.String getPageToken();
  /**
   *
   *
   * <pre>
   * Optional. A pagination token returned from a previous call to `SearchFolders`
   * that indicates from where search should continue.
   * </pre>
   *
   * <code>string page_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for pageToken.
   */
  com.google.protobuf.ByteString getPageTokenBytes();

  /**
   *
   *
   * <pre>
   * Optional. Search criteria used to select the folders to return.
   * If no search criteria is specified then all accessible folders will be
   * returned.
   * Query expressions can be used to restrict results based upon displayName,
   * state and parent, where the operators `=` (`:`) `NOT`, `AND` and `OR`
   * can be used along with the suffix wildcard symbol `*`.
   * The `displayName` field in a query expression should use escaped quotes
   * for values that include whitespace to prevent unexpected behavior.
   * ```
   * | Field                   | Description                            |
   * |-------------------------|----------------------------------------|
   * | displayName             | Filters by displayName.                |
   * | parent                  | Filters by parent (for example: folders/123). |
   * | state, lifecycleState   | Filters by state.                      |
   * ```
   * Some example queries are:
   * * Query `displayName=Test*` returns Folder resources whose display name
   * starts with "Test".
   * * Query `state=ACTIVE` returns Folder resources with
   * `state` set to `ACTIVE`.
   * * Query `parent=folders/123` returns Folder resources that have
   * `folders/123` as a parent resource.
   * * Query `parent=folders/123 AND state=ACTIVE` returns active
   * Folder resources that have `folders/123` as a parent resource.
   * * Query `displayName=&#92;&#92;"Test String&#92;&#92;"` returns Folder resources with
   * display names that include both "Test" and "String".
   * </pre>
   *
   * <code>string query = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The query.
   */
  java.lang.String getQuery();
  /**
   *
   *
   * <pre>
   * Optional. Search criteria used to select the folders to return.
   * If no search criteria is specified then all accessible folders will be
   * returned.
   * Query expressions can be used to restrict results based upon displayName,
   * state and parent, where the operators `=` (`:`) `NOT`, `AND` and `OR`
   * can be used along with the suffix wildcard symbol `*`.
   * The `displayName` field in a query expression should use escaped quotes
   * for values that include whitespace to prevent unexpected behavior.
   * ```
   * | Field                   | Description                            |
   * |-------------------------|----------------------------------------|
   * | displayName             | Filters by displayName.                |
   * | parent                  | Filters by parent (for example: folders/123). |
   * | state, lifecycleState   | Filters by state.                      |
   * ```
   * Some example queries are:
   * * Query `displayName=Test*` returns Folder resources whose display name
   * starts with "Test".
   * * Query `state=ACTIVE` returns Folder resources with
   * `state` set to `ACTIVE`.
   * * Query `parent=folders/123` returns Folder resources that have
   * `folders/123` as a parent resource.
   * * Query `parent=folders/123 AND state=ACTIVE` returns active
   * Folder resources that have `folders/123` as a parent resource.
   * * Query `displayName=&#92;&#92;"Test String&#92;&#92;"` returns Folder resources with
   * display names that include both "Test" and "String".
   * </pre>
   *
   * <code>string query = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for query.
   */
  com.google.protobuf.ByteString getQueryBytes();
}
