/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/resourcemanager/v3/organizations.proto

package com.google.cloud.resourcemanager.v3;

/**
 *
 *
 * <pre>
 * The response returned from the `SearchOrganizations` method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.resourcemanager.v3.SearchOrganizationsResponse}
 */
public final class SearchOrganizationsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.resourcemanager.v3.SearchOrganizationsResponse)
    SearchOrganizationsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SearchOrganizationsResponse.newBuilder() to construct.
  private SearchOrganizationsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SearchOrganizationsResponse() {
    organizations_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SearchOrganizationsResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.resourcemanager.v3.OrganizationsProto
        .internal_static_google_cloud_resourcemanager_v3_SearchOrganizationsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.resourcemanager.v3.OrganizationsProto
        .internal_static_google_cloud_resourcemanager_v3_SearchOrganizationsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse.class,
            com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse.Builder.class);
  }

  public static final int ORGANIZATIONS_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.resourcemanager.v3.Organization> organizations_;
  /**
   *
   *
   * <pre>
   * The list of Organizations that matched the search query, possibly
   * paginated.
   * </pre>
   *
   * <code>repeated .google.cloud.resourcemanager.v3.Organization organizations = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.resourcemanager.v3.Organization> getOrganizationsList() {
    return organizations_;
  }
  /**
   *
   *
   * <pre>
   * The list of Organizations that matched the search query, possibly
   * paginated.
   * </pre>
   *
   * <code>repeated .google.cloud.resourcemanager.v3.Organization organizations = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.resourcemanager.v3.OrganizationOrBuilder>
      getOrganizationsOrBuilderList() {
    return organizations_;
  }
  /**
   *
   *
   * <pre>
   * The list of Organizations that matched the search query, possibly
   * paginated.
   * </pre>
   *
   * <code>repeated .google.cloud.resourcemanager.v3.Organization organizations = 1;</code>
   */
  @java.lang.Override
  public int getOrganizationsCount() {
    return organizations_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of Organizations that matched the search query, possibly
   * paginated.
   * </pre>
   *
   * <code>repeated .google.cloud.resourcemanager.v3.Organization organizations = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.resourcemanager.v3.Organization getOrganizations(int index) {
    return organizations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of Organizations that matched the search query, possibly
   * paginated.
   * </pre>
   *
   * <code>repeated .google.cloud.resourcemanager.v3.Organization organizations = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.resourcemanager.v3.OrganizationOrBuilder getOrganizationsOrBuilder(
      int index) {
    return organizations_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;
  private volatile java.lang.Object nextPageToken_;
  /**
   *
   *
   * <pre>
   * A pagination token to be used to retrieve the next page of results. If the
   * result is too large to fit within the page size specified in the request,
   * this field will be set with a token that can be used to fetch the next page
   * of results. If this field is empty, it indicates that this response
   * contains the last page of results.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A pagination token to be used to retrieve the next page of results. If the
   * result is too large to fit within the page size specified in the request,
   * this field will be set with a token that can be used to fetch the next page
   * of results. If this field is empty, it indicates that this response
   * contains the last page of results.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < organizations_.size(); i++) {
      output.writeMessage(1, organizations_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < organizations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, organizations_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse other =
        (com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse) obj;

    if (!getOrganizationsList().equals(other.getOrganizationsList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getOrganizationsCount() > 0) {
      hash = (37 * hash) + ORGANIZATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getOrganizationsList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The response returned from the `SearchOrganizations` method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.resourcemanager.v3.SearchOrganizationsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.resourcemanager.v3.SearchOrganizationsResponse)
      com.google.cloud.resourcemanager.v3.SearchOrganizationsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.resourcemanager.v3.OrganizationsProto
          .internal_static_google_cloud_resourcemanager_v3_SearchOrganizationsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.resourcemanager.v3.OrganizationsProto
          .internal_static_google_cloud_resourcemanager_v3_SearchOrganizationsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse.class,
              com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse.Builder.class);
    }

    // Construct using com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (organizationsBuilder_ == null) {
        organizations_ = java.util.Collections.emptyList();
      } else {
        organizations_ = null;
        organizationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      nextPageToken_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.resourcemanager.v3.OrganizationsProto
          .internal_static_google_cloud_resourcemanager_v3_SearchOrganizationsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse
        getDefaultInstanceForType() {
      return com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse build() {
      com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse buildPartial() {
      com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse result =
          new com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse(this);
      int from_bitField0_ = bitField0_;
      if (organizationsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          organizations_ = java.util.Collections.unmodifiableList(organizations_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.organizations_ = organizations_;
      } else {
        result.organizations_ = organizationsBuilder_.build();
      }
      result.nextPageToken_ = nextPageToken_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse) {
        return mergeFrom((com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse other) {
      if (other
          == com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse.getDefaultInstance())
        return this;
      if (organizationsBuilder_ == null) {
        if (!other.organizations_.isEmpty()) {
          if (organizations_.isEmpty()) {
            organizations_ = other.organizations_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureOrganizationsIsMutable();
            organizations_.addAll(other.organizations_);
          }
          onChanged();
        }
      } else {
        if (!other.organizations_.isEmpty()) {
          if (organizationsBuilder_.isEmpty()) {
            organizationsBuilder_.dispose();
            organizationsBuilder_ = null;
            organizations_ = other.organizations_;
            bitField0_ = (bitField0_ & ~0x00000001);
            organizationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getOrganizationsFieldBuilder()
                    : null;
          } else {
            organizationsBuilder_.addAllMessages(other.organizations_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.resourcemanager.v3.Organization m =
                    input.readMessage(
                        com.google.cloud.resourcemanager.v3.Organization.parser(),
                        extensionRegistry);
                if (organizationsBuilder_ == null) {
                  ensureOrganizationsIsMutable();
                  organizations_.add(m);
                } else {
                  organizationsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                nextPageToken_ = input.readStringRequireUtf8();

                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.resourcemanager.v3.Organization> organizations_ =
        java.util.Collections.emptyList();

    private void ensureOrganizationsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        organizations_ =
            new java.util.ArrayList<com.google.cloud.resourcemanager.v3.Organization>(
                organizations_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.resourcemanager.v3.Organization,
            com.google.cloud.resourcemanager.v3.Organization.Builder,
            com.google.cloud.resourcemanager.v3.OrganizationOrBuilder>
        organizationsBuilder_;

    /**
     *
     *
     * <pre>
     * The list of Organizations that matched the search query, possibly
     * paginated.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.Organization organizations = 1;</code>
     */
    public java.util.List<com.google.cloud.resourcemanager.v3.Organization> getOrganizationsList() {
      if (organizationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(organizations_);
      } else {
        return organizationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of Organizations that matched the search query, possibly
     * paginated.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.Organization organizations = 1;</code>
     */
    public int getOrganizationsCount() {
      if (organizationsBuilder_ == null) {
        return organizations_.size();
      } else {
        return organizationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of Organizations that matched the search query, possibly
     * paginated.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.Organization organizations = 1;</code>
     */
    public com.google.cloud.resourcemanager.v3.Organization getOrganizations(int index) {
      if (organizationsBuilder_ == null) {
        return organizations_.get(index);
      } else {
        return organizationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of Organizations that matched the search query, possibly
     * paginated.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.Organization organizations = 1;</code>
     */
    public Builder setOrganizations(
        int index, com.google.cloud.resourcemanager.v3.Organization value) {
      if (organizationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOrganizationsIsMutable();
        organizations_.set(index, value);
        onChanged();
      } else {
        organizationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Organizations that matched the search query, possibly
     * paginated.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.Organization organizations = 1;</code>
     */
    public Builder setOrganizations(
        int index, com.google.cloud.resourcemanager.v3.Organization.Builder builderForValue) {
      if (organizationsBuilder_ == null) {
        ensureOrganizationsIsMutable();
        organizations_.set(index, builderForValue.build());
        onChanged();
      } else {
        organizationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Organizations that matched the search query, possibly
     * paginated.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.Organization organizations = 1;</code>
     */
    public Builder addOrganizations(com.google.cloud.resourcemanager.v3.Organization value) {
      if (organizationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOrganizationsIsMutable();
        organizations_.add(value);
        onChanged();
      } else {
        organizationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Organizations that matched the search query, possibly
     * paginated.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.Organization organizations = 1;</code>
     */
    public Builder addOrganizations(
        int index, com.google.cloud.resourcemanager.v3.Organization value) {
      if (organizationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOrganizationsIsMutable();
        organizations_.add(index, value);
        onChanged();
      } else {
        organizationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Organizations that matched the search query, possibly
     * paginated.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.Organization organizations = 1;</code>
     */
    public Builder addOrganizations(
        com.google.cloud.resourcemanager.v3.Organization.Builder builderForValue) {
      if (organizationsBuilder_ == null) {
        ensureOrganizationsIsMutable();
        organizations_.add(builderForValue.build());
        onChanged();
      } else {
        organizationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Organizations that matched the search query, possibly
     * paginated.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.Organization organizations = 1;</code>
     */
    public Builder addOrganizations(
        int index, com.google.cloud.resourcemanager.v3.Organization.Builder builderForValue) {
      if (organizationsBuilder_ == null) {
        ensureOrganizationsIsMutable();
        organizations_.add(index, builderForValue.build());
        onChanged();
      } else {
        organizationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Organizations that matched the search query, possibly
     * paginated.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.Organization organizations = 1;</code>
     */
    public Builder addAllOrganizations(
        java.lang.Iterable<? extends com.google.cloud.resourcemanager.v3.Organization> values) {
      if (organizationsBuilder_ == null) {
        ensureOrganizationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, organizations_);
        onChanged();
      } else {
        organizationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Organizations that matched the search query, possibly
     * paginated.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.Organization organizations = 1;</code>
     */
    public Builder clearOrganizations() {
      if (organizationsBuilder_ == null) {
        organizations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        organizationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Organizations that matched the search query, possibly
     * paginated.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.Organization organizations = 1;</code>
     */
    public Builder removeOrganizations(int index) {
      if (organizationsBuilder_ == null) {
        ensureOrganizationsIsMutable();
        organizations_.remove(index);
        onChanged();
      } else {
        organizationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Organizations that matched the search query, possibly
     * paginated.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.Organization organizations = 1;</code>
     */
    public com.google.cloud.resourcemanager.v3.Organization.Builder getOrganizationsBuilder(
        int index) {
      return getOrganizationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of Organizations that matched the search query, possibly
     * paginated.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.Organization organizations = 1;</code>
     */
    public com.google.cloud.resourcemanager.v3.OrganizationOrBuilder getOrganizationsOrBuilder(
        int index) {
      if (organizationsBuilder_ == null) {
        return organizations_.get(index);
      } else {
        return organizationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of Organizations that matched the search query, possibly
     * paginated.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.Organization organizations = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.resourcemanager.v3.OrganizationOrBuilder>
        getOrganizationsOrBuilderList() {
      if (organizationsBuilder_ != null) {
        return organizationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(organizations_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of Organizations that matched the search query, possibly
     * paginated.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.Organization organizations = 1;</code>
     */
    public com.google.cloud.resourcemanager.v3.Organization.Builder addOrganizationsBuilder() {
      return getOrganizationsFieldBuilder()
          .addBuilder(com.google.cloud.resourcemanager.v3.Organization.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of Organizations that matched the search query, possibly
     * paginated.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.Organization organizations = 1;</code>
     */
    public com.google.cloud.resourcemanager.v3.Organization.Builder addOrganizationsBuilder(
        int index) {
      return getOrganizationsFieldBuilder()
          .addBuilder(index, com.google.cloud.resourcemanager.v3.Organization.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of Organizations that matched the search query, possibly
     * paginated.
     * </pre>
     *
     * <code>repeated .google.cloud.resourcemanager.v3.Organization organizations = 1;</code>
     */
    public java.util.List<com.google.cloud.resourcemanager.v3.Organization.Builder>
        getOrganizationsBuilderList() {
      return getOrganizationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.resourcemanager.v3.Organization,
            com.google.cloud.resourcemanager.v3.Organization.Builder,
            com.google.cloud.resourcemanager.v3.OrganizationOrBuilder>
        getOrganizationsFieldBuilder() {
      if (organizationsBuilder_ == null) {
        organizationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.resourcemanager.v3.Organization,
                com.google.cloud.resourcemanager.v3.Organization.Builder,
                com.google.cloud.resourcemanager.v3.OrganizationOrBuilder>(
                organizations_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        organizations_ = null;
      }
      return organizationsBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * A pagination token to be used to retrieve the next page of results. If the
     * result is too large to fit within the page size specified in the request,
     * this field will be set with a token that can be used to fetch the next page
     * of results. If this field is empty, it indicates that this response
     * contains the last page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A pagination token to be used to retrieve the next page of results. If the
     * result is too large to fit within the page size specified in the request,
     * this field will be set with a token that can be used to fetch the next page
     * of results. If this field is empty, it indicates that this response
     * contains the last page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A pagination token to be used to retrieve the next page of results. If the
     * result is too large to fit within the page size specified in the request,
     * this field will be set with a token that can be used to fetch the next page
     * of results. If this field is empty, it indicates that this response
     * contains the last page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      nextPageToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A pagination token to be used to retrieve the next page of results. If the
     * result is too large to fit within the page size specified in the request,
     * this field will be set with a token that can be used to fetch the next page
     * of results. If this field is empty, it indicates that this response
     * contains the last page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {

      nextPageToken_ = getDefaultInstance().getNextPageToken();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A pagination token to be used to retrieve the next page of results. If the
     * result is too large to fit within the page size specified in the request,
     * this field will be set with a token that can be used to fetch the next page
     * of results. If this field is empty, it indicates that this response
     * contains the last page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      nextPageToken_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.resourcemanager.v3.SearchOrganizationsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.resourcemanager.v3.SearchOrganizationsResponse)
  private static final com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse();
  }

  public static com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SearchOrganizationsResponse> PARSER =
      new com.google.protobuf.AbstractParser<SearchOrganizationsResponse>() {
        @java.lang.Override
        public SearchOrganizationsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SearchOrganizationsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SearchOrganizationsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
