/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2/catalog.proto

package com.google.cloud.retail.v2;

/**
 *
 *
 * <pre>
 * Catalog level attribute config for an attribute. For example, if customers
 * want to enable/disable facet for a specific attribute.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2.CatalogAttribute}
 */
public final class CatalogAttribute extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.CatalogAttribute)
    CatalogAttributeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CatalogAttribute.newBuilder() to construct.
  private CatalogAttribute(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CatalogAttribute() {
    key_ = "";
    type_ = 0;
    indexableOption_ = 0;
    dynamicFacetableOption_ = 0;
    searchableOption_ = 0;
    exactSearchableOption_ = 0;
    retrievableOption_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CatalogAttribute();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2.CatalogProto
        .internal_static_google_cloud_retail_v2_CatalogAttribute_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2.CatalogProto
        .internal_static_google_cloud_retail_v2_CatalogAttribute_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2.CatalogAttribute.class,
            com.google.cloud.retail.v2.CatalogAttribute.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of an attribute.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.retail.v2.CatalogAttribute.AttributeType}
   */
  public enum AttributeType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The type of the attribute is unknown.
     *
     * Used when type cannot be derived from attribute that is not
     * [in_use][google.cloud.retail.v2.CatalogAttribute.in_use].
     * </pre>
     *
     * <code>UNKNOWN = 0;</code>
     */
    UNKNOWN(0),
    /**
     *
     *
     * <pre>
     * Textual attribute.
     * </pre>
     *
     * <code>TEXTUAL = 1;</code>
     */
    TEXTUAL(1),
    /**
     *
     *
     * <pre>
     * Numerical attribute.
     * </pre>
     *
     * <code>NUMERICAL = 2;</code>
     */
    NUMERICAL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The type of the attribute is unknown.
     *
     * Used when type cannot be derived from attribute that is not
     * [in_use][google.cloud.retail.v2.CatalogAttribute.in_use].
     * </pre>
     *
     * <code>UNKNOWN = 0;</code>
     */
    public static final int UNKNOWN_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Textual attribute.
     * </pre>
     *
     * <code>TEXTUAL = 1;</code>
     */
    public static final int TEXTUAL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Numerical attribute.
     * </pre>
     *
     * <code>NUMERICAL = 2;</code>
     */
    public static final int NUMERICAL_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AttributeType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AttributeType forNumber(int value) {
      switch (value) {
        case 0:
          return UNKNOWN;
        case 1:
          return TEXTUAL;
        case 2:
          return NUMERICAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AttributeType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AttributeType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<AttributeType>() {
          public AttributeType findValueByNumber(int number) {
            return AttributeType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.retail.v2.CatalogAttribute.getDescriptor().getEnumTypes().get(0);
    }

    private static final AttributeType[] VALUES = values();

    public static AttributeType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AttributeType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2.CatalogAttribute.AttributeType)
  }

  /**
   *
   *
   * <pre>
   * The status of the indexable option of a catalog attribute.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.retail.v2.CatalogAttribute.IndexableOption}
   */
  public enum IndexableOption implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Value used when unset.
     * </pre>
     *
     * <code>INDEXABLE_OPTION_UNSPECIFIED = 0;</code>
     */
    INDEXABLE_OPTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Indexable option enabled for an attribute.
     * </pre>
     *
     * <code>INDEXABLE_ENABLED = 1;</code>
     */
    INDEXABLE_ENABLED(1),
    /**
     *
     *
     * <pre>
     * Indexable option disabled for an attribute.
     * </pre>
     *
     * <code>INDEXABLE_DISABLED = 2;</code>
     */
    INDEXABLE_DISABLED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Value used when unset.
     * </pre>
     *
     * <code>INDEXABLE_OPTION_UNSPECIFIED = 0;</code>
     */
    public static final int INDEXABLE_OPTION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Indexable option enabled for an attribute.
     * </pre>
     *
     * <code>INDEXABLE_ENABLED = 1;</code>
     */
    public static final int INDEXABLE_ENABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Indexable option disabled for an attribute.
     * </pre>
     *
     * <code>INDEXABLE_DISABLED = 2;</code>
     */
    public static final int INDEXABLE_DISABLED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IndexableOption valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static IndexableOption forNumber(int value) {
      switch (value) {
        case 0:
          return INDEXABLE_OPTION_UNSPECIFIED;
        case 1:
          return INDEXABLE_ENABLED;
        case 2:
          return INDEXABLE_DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<IndexableOption> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<IndexableOption>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<IndexableOption>() {
              public IndexableOption findValueByNumber(int number) {
                return IndexableOption.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.retail.v2.CatalogAttribute.getDescriptor().getEnumTypes().get(1);
    }

    private static final IndexableOption[] VALUES = values();

    public static IndexableOption valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private IndexableOption(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2.CatalogAttribute.IndexableOption)
  }

  /**
   *
   *
   * <pre>
   * The status of the dynamic facetable option of a catalog attribute.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.retail.v2.CatalogAttribute.DynamicFacetableOption}
   */
  public enum DynamicFacetableOption implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Value used when unset.
     * </pre>
     *
     * <code>DYNAMIC_FACETABLE_OPTION_UNSPECIFIED = 0;</code>
     */
    DYNAMIC_FACETABLE_OPTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Dynamic facetable option enabled for an attribute.
     * </pre>
     *
     * <code>DYNAMIC_FACETABLE_ENABLED = 1;</code>
     */
    DYNAMIC_FACETABLE_ENABLED(1),
    /**
     *
     *
     * <pre>
     * Dynamic facetable option disabled for an attribute.
     * </pre>
     *
     * <code>DYNAMIC_FACETABLE_DISABLED = 2;</code>
     */
    DYNAMIC_FACETABLE_DISABLED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Value used when unset.
     * </pre>
     *
     * <code>DYNAMIC_FACETABLE_OPTION_UNSPECIFIED = 0;</code>
     */
    public static final int DYNAMIC_FACETABLE_OPTION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Dynamic facetable option enabled for an attribute.
     * </pre>
     *
     * <code>DYNAMIC_FACETABLE_ENABLED = 1;</code>
     */
    public static final int DYNAMIC_FACETABLE_ENABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Dynamic facetable option disabled for an attribute.
     * </pre>
     *
     * <code>DYNAMIC_FACETABLE_DISABLED = 2;</code>
     */
    public static final int DYNAMIC_FACETABLE_DISABLED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DynamicFacetableOption valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DynamicFacetableOption forNumber(int value) {
      switch (value) {
        case 0:
          return DYNAMIC_FACETABLE_OPTION_UNSPECIFIED;
        case 1:
          return DYNAMIC_FACETABLE_ENABLED;
        case 2:
          return DYNAMIC_FACETABLE_DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DynamicFacetableOption>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DynamicFacetableOption>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<DynamicFacetableOption>() {
              public DynamicFacetableOption findValueByNumber(int number) {
                return DynamicFacetableOption.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.retail.v2.CatalogAttribute.getDescriptor().getEnumTypes().get(2);
    }

    private static final DynamicFacetableOption[] VALUES = values();

    public static DynamicFacetableOption valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DynamicFacetableOption(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2.CatalogAttribute.DynamicFacetableOption)
  }

  /**
   *
   *
   * <pre>
   * The status of the searchable option of a catalog attribute.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.retail.v2.CatalogAttribute.SearchableOption}
   */
  public enum SearchableOption implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Value used when unset.
     * </pre>
     *
     * <code>SEARCHABLE_OPTION_UNSPECIFIED = 0;</code>
     */
    SEARCHABLE_OPTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Searchable option enabled for an attribute.
     * </pre>
     *
     * <code>SEARCHABLE_ENABLED = 1;</code>
     */
    SEARCHABLE_ENABLED(1),
    /**
     *
     *
     * <pre>
     * Searchable option disabled for an attribute.
     * </pre>
     *
     * <code>SEARCHABLE_DISABLED = 2;</code>
     */
    SEARCHABLE_DISABLED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Value used when unset.
     * </pre>
     *
     * <code>SEARCHABLE_OPTION_UNSPECIFIED = 0;</code>
     */
    public static final int SEARCHABLE_OPTION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Searchable option enabled for an attribute.
     * </pre>
     *
     * <code>SEARCHABLE_ENABLED = 1;</code>
     */
    public static final int SEARCHABLE_ENABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Searchable option disabled for an attribute.
     * </pre>
     *
     * <code>SEARCHABLE_DISABLED = 2;</code>
     */
    public static final int SEARCHABLE_DISABLED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SearchableOption valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SearchableOption forNumber(int value) {
      switch (value) {
        case 0:
          return SEARCHABLE_OPTION_UNSPECIFIED;
        case 1:
          return SEARCHABLE_ENABLED;
        case 2:
          return SEARCHABLE_DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SearchableOption> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SearchableOption>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<SearchableOption>() {
              public SearchableOption findValueByNumber(int number) {
                return SearchableOption.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.retail.v2.CatalogAttribute.getDescriptor().getEnumTypes().get(3);
    }

    private static final SearchableOption[] VALUES = values();

    public static SearchableOption valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SearchableOption(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2.CatalogAttribute.SearchableOption)
  }

  /**
   *
   *
   * <pre>
   * The status of the exact-searchable option of a catalog attribute.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption}
   */
  public enum ExactSearchableOption implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Value used when unset.
     * </pre>
     *
     * <code>EXACT_SEARCHABLE_OPTION_UNSPECIFIED = 0;</code>
     */
    EXACT_SEARCHABLE_OPTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Exact searchable option enabled for an attribute.
     * </pre>
     *
     * <code>EXACT_SEARCHABLE_ENABLED = 1;</code>
     */
    EXACT_SEARCHABLE_ENABLED(1),
    /**
     *
     *
     * <pre>
     * Exact searchable option disabled for an attribute.
     * </pre>
     *
     * <code>EXACT_SEARCHABLE_DISABLED = 2;</code>
     */
    EXACT_SEARCHABLE_DISABLED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Value used when unset.
     * </pre>
     *
     * <code>EXACT_SEARCHABLE_OPTION_UNSPECIFIED = 0;</code>
     */
    public static final int EXACT_SEARCHABLE_OPTION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Exact searchable option enabled for an attribute.
     * </pre>
     *
     * <code>EXACT_SEARCHABLE_ENABLED = 1;</code>
     */
    public static final int EXACT_SEARCHABLE_ENABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Exact searchable option disabled for an attribute.
     * </pre>
     *
     * <code>EXACT_SEARCHABLE_DISABLED = 2;</code>
     */
    public static final int EXACT_SEARCHABLE_DISABLED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ExactSearchableOption valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ExactSearchableOption forNumber(int value) {
      switch (value) {
        case 0:
          return EXACT_SEARCHABLE_OPTION_UNSPECIFIED;
        case 1:
          return EXACT_SEARCHABLE_ENABLED;
        case 2:
          return EXACT_SEARCHABLE_DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ExactSearchableOption>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ExactSearchableOption>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ExactSearchableOption>() {
              public ExactSearchableOption findValueByNumber(int number) {
                return ExactSearchableOption.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.retail.v2.CatalogAttribute.getDescriptor().getEnumTypes().get(4);
    }

    private static final ExactSearchableOption[] VALUES = values();

    public static ExactSearchableOption valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ExactSearchableOption(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption)
  }

  /**
   *
   *
   * <pre>
   * The status of the retrievable option of a catalog attribute.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.retail.v2.CatalogAttribute.RetrievableOption}
   */
  public enum RetrievableOption implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Value used when unset.
     * </pre>
     *
     * <code>RETRIEVABLE_OPTION_UNSPECIFIED = 0;</code>
     */
    RETRIEVABLE_OPTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Retrievable option enabled for an attribute.
     * </pre>
     *
     * <code>RETRIEVABLE_ENABLED = 1;</code>
     */
    RETRIEVABLE_ENABLED(1),
    /**
     *
     *
     * <pre>
     * Retrievable option disabled for an attribute.
     * </pre>
     *
     * <code>RETRIEVABLE_DISABLED = 2;</code>
     */
    RETRIEVABLE_DISABLED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Value used when unset.
     * </pre>
     *
     * <code>RETRIEVABLE_OPTION_UNSPECIFIED = 0;</code>
     */
    public static final int RETRIEVABLE_OPTION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Retrievable option enabled for an attribute.
     * </pre>
     *
     * <code>RETRIEVABLE_ENABLED = 1;</code>
     */
    public static final int RETRIEVABLE_ENABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Retrievable option disabled for an attribute.
     * </pre>
     *
     * <code>RETRIEVABLE_DISABLED = 2;</code>
     */
    public static final int RETRIEVABLE_DISABLED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RetrievableOption valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RetrievableOption forNumber(int value) {
      switch (value) {
        case 0:
          return RETRIEVABLE_OPTION_UNSPECIFIED;
        case 1:
          return RETRIEVABLE_ENABLED;
        case 2:
          return RETRIEVABLE_DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RetrievableOption>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RetrievableOption>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<RetrievableOption>() {
              public RetrievableOption findValueByNumber(int number) {
                return RetrievableOption.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.retail.v2.CatalogAttribute.getDescriptor().getEnumTypes().get(5);
    }

    private static final RetrievableOption[] VALUES = values();

    public static RetrievableOption valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RetrievableOption(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2.CatalogAttribute.RetrievableOption)
  }

  public static final int KEY_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object key_ = "";
  /**
   *
   *
   * <pre>
   * Required. Attribute name.
   * For example: `color`, `brands`, `attributes.custom_attribute`, such as
   * `attributes.xyz`.
   * To be indexable, the attribute name can contain only alpha-numeric
   * characters and underscores. For example, an attribute named
   * `attributes.abc_xyz` can be indexed, but an attribute named
   * `attributes.abc-xyz` cannot be indexed.
   *
   * If the attribute key starts with `attributes.`, then the attribute is a
   * custom attribute. Attributes such as `brands`, `patterns`, and `title` are
   * built-in and called system attributes.
   * </pre>
   *
   * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The key.
   */
  @java.lang.Override
  public java.lang.String getKey() {
    java.lang.Object ref = key_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      key_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Attribute name.
   * For example: `color`, `brands`, `attributes.custom_attribute`, such as
   * `attributes.xyz`.
   * To be indexable, the attribute name can contain only alpha-numeric
   * characters and underscores. For example, an attribute named
   * `attributes.abc_xyz` can be indexed, but an attribute named
   * `attributes.abc-xyz` cannot be indexed.
   *
   * If the attribute key starts with `attributes.`, then the attribute is a
   * custom attribute. Attributes such as `brands`, `patterns`, and `title` are
   * built-in and called system attributes.
   * </pre>
   *
   * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for key.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKeyBytes() {
    java.lang.Object ref = key_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      key_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IN_USE_FIELD_NUMBER = 9;
  private boolean inUse_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Indicates whether this attribute has been used by any
   * products. `True` if at least one [Product][google.cloud.retail.v2.Product]
   * is using this attribute in
   * [Product.attributes][google.cloud.retail.v2.Product.attributes]. Otherwise,
   * this field is `False`.
   *
   * [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] can be
   * pre-loaded by using
   * [CatalogService.AddCatalogAttribute][google.cloud.retail.v2.CatalogService.AddCatalogAttribute],
   * [CatalogService.ImportCatalogAttributes][], or
   * [CatalogService.UpdateAttributesConfig][google.cloud.retail.v2.CatalogService.UpdateAttributesConfig]
   * APIs. This field is `False` for pre-loaded
   * [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute]s.
   *
   * Only pre-loaded [catalog
   * attributes][google.cloud.retail.v2.CatalogAttribute] that are neither in
   * use by products nor predefined can be deleted. [Catalog
   * attributes][google.cloud.retail.v2.CatalogAttribute] that are
   * either in use by products or are predefined attributes cannot be deleted;
   * however, their configuration properties will reset to default values upon
   * removal request.
   *
   * After catalog changes, it takes about 10 minutes for this field to update.
   * </pre>
   *
   * <code>bool in_use = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The inUse.
   */
  @java.lang.Override
  public boolean getInUse() {
    return inUse_;
  }

  public static final int TYPE_FIELD_NUMBER = 10;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The type of this attribute. This is derived from the attribute
   * in [Product.attributes][google.cloud.retail.v2.Product.attributes].
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2.CatalogAttribute.AttributeType type = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The type of this attribute. This is derived from the attribute
   * in [Product.attributes][google.cloud.retail.v2.Product.attributes].
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2.CatalogAttribute.AttributeType type = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.CatalogAttribute.AttributeType getType() {
    com.google.cloud.retail.v2.CatalogAttribute.AttributeType result =
        com.google.cloud.retail.v2.CatalogAttribute.AttributeType.forNumber(type_);
    return result == null
        ? com.google.cloud.retail.v2.CatalogAttribute.AttributeType.UNRECOGNIZED
        : result;
  }

  public static final int INDEXABLE_OPTION_FIELD_NUMBER = 5;
  private int indexableOption_ = 0;
  /**
   *
   *
   * <pre>
   * When
   * [AttributesConfig.attribute_config_level][google.cloud.retail.v2.AttributesConfig.attribute_config_level]
   * is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if INDEXABLE_ENABLED attribute values
   * are indexed so that it can be filtered, faceted, or boosted in
   * [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
   *
   * Must be specified, otherwise throws INVALID_FORMAT error.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.CatalogAttribute.IndexableOption indexable_option = 5;</code>
   *
   * @return The enum numeric value on the wire for indexableOption.
   */
  @java.lang.Override
  public int getIndexableOptionValue() {
    return indexableOption_;
  }
  /**
   *
   *
   * <pre>
   * When
   * [AttributesConfig.attribute_config_level][google.cloud.retail.v2.AttributesConfig.attribute_config_level]
   * is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if INDEXABLE_ENABLED attribute values
   * are indexed so that it can be filtered, faceted, or boosted in
   * [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
   *
   * Must be specified, otherwise throws INVALID_FORMAT error.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.CatalogAttribute.IndexableOption indexable_option = 5;</code>
   *
   * @return The indexableOption.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.CatalogAttribute.IndexableOption getIndexableOption() {
    com.google.cloud.retail.v2.CatalogAttribute.IndexableOption result =
        com.google.cloud.retail.v2.CatalogAttribute.IndexableOption.forNumber(indexableOption_);
    return result == null
        ? com.google.cloud.retail.v2.CatalogAttribute.IndexableOption.UNRECOGNIZED
        : result;
  }

  public static final int DYNAMIC_FACETABLE_OPTION_FIELD_NUMBER = 6;
  private int dynamicFacetableOption_ = 0;
  /**
   *
   *
   * <pre>
   * If DYNAMIC_FACETABLE_ENABLED, attribute values are available for dynamic
   * facet. Could only be DYNAMIC_FACETABLE_DISABLED if
   * [CatalogAttribute.indexable_option][google.cloud.retail.v2.CatalogAttribute.indexable_option]
   * is INDEXABLE_DISABLED. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * Must be specified, otherwise throws INVALID_FORMAT error.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2.CatalogAttribute.DynamicFacetableOption dynamic_facetable_option = 6;
   * </code>
   *
   * @return The enum numeric value on the wire for dynamicFacetableOption.
   */
  @java.lang.Override
  public int getDynamicFacetableOptionValue() {
    return dynamicFacetableOption_;
  }
  /**
   *
   *
   * <pre>
   * If DYNAMIC_FACETABLE_ENABLED, attribute values are available for dynamic
   * facet. Could only be DYNAMIC_FACETABLE_DISABLED if
   * [CatalogAttribute.indexable_option][google.cloud.retail.v2.CatalogAttribute.indexable_option]
   * is INDEXABLE_DISABLED. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * Must be specified, otherwise throws INVALID_FORMAT error.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2.CatalogAttribute.DynamicFacetableOption dynamic_facetable_option = 6;
   * </code>
   *
   * @return The dynamicFacetableOption.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.CatalogAttribute.DynamicFacetableOption
      getDynamicFacetableOption() {
    com.google.cloud.retail.v2.CatalogAttribute.DynamicFacetableOption result =
        com.google.cloud.retail.v2.CatalogAttribute.DynamicFacetableOption.forNumber(
            dynamicFacetableOption_);
    return result == null
        ? com.google.cloud.retail.v2.CatalogAttribute.DynamicFacetableOption.UNRECOGNIZED
        : result;
  }

  public static final int SEARCHABLE_OPTION_FIELD_NUMBER = 7;
  private int searchableOption_ = 0;
  /**
   *
   *
   * <pre>
   * When
   * [AttributesConfig.attribute_config_level][google.cloud.retail.v2.AttributesConfig.attribute_config_level]
   * is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if SEARCHABLE_ENABLED, attribute values
   * are searchable by text queries in
   * [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
   *
   * If SEARCHABLE_ENABLED but attribute type is numerical, attribute values
   * will not be searchable by text queries in
   * [SearchService.Search][google.cloud.retail.v2.SearchService.Search], as
   * there are no text values associated to numerical attributes.
   *
   * Must be specified, otherwise throws INVALID_FORMAT error.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.CatalogAttribute.SearchableOption searchable_option = 7;</code>
   *
   * @return The enum numeric value on the wire for searchableOption.
   */
  @java.lang.Override
  public int getSearchableOptionValue() {
    return searchableOption_;
  }
  /**
   *
   *
   * <pre>
   * When
   * [AttributesConfig.attribute_config_level][google.cloud.retail.v2.AttributesConfig.attribute_config_level]
   * is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if SEARCHABLE_ENABLED, attribute values
   * are searchable by text queries in
   * [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
   *
   * If SEARCHABLE_ENABLED but attribute type is numerical, attribute values
   * will not be searchable by text queries in
   * [SearchService.Search][google.cloud.retail.v2.SearchService.Search], as
   * there are no text values associated to numerical attributes.
   *
   * Must be specified, otherwise throws INVALID_FORMAT error.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.CatalogAttribute.SearchableOption searchable_option = 7;</code>
   *
   * @return The searchableOption.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.CatalogAttribute.SearchableOption getSearchableOption() {
    com.google.cloud.retail.v2.CatalogAttribute.SearchableOption result =
        com.google.cloud.retail.v2.CatalogAttribute.SearchableOption.forNumber(searchableOption_);
    return result == null
        ? com.google.cloud.retail.v2.CatalogAttribute.SearchableOption.UNRECOGNIZED
        : result;
  }

  public static final int EXACT_SEARCHABLE_OPTION_FIELD_NUMBER = 11;
  private int exactSearchableOption_ = 0;
  /**
   *
   *
   * <pre>
   * If EXACT_SEARCHABLE_ENABLED, attribute values will be exact searchable.
   * This property only applies to textual custom attributes and requires
   * indexable set to enabled to enable exact-searchable. If unset, the server
   * behavior defaults to
   * [EXACT_SEARCHABLE_DISABLED][google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption.EXACT_SEARCHABLE_DISABLED].
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption exact_searchable_option = 11;
   * </code>
   *
   * @return The enum numeric value on the wire for exactSearchableOption.
   */
  @java.lang.Override
  public int getExactSearchableOptionValue() {
    return exactSearchableOption_;
  }
  /**
   *
   *
   * <pre>
   * If EXACT_SEARCHABLE_ENABLED, attribute values will be exact searchable.
   * This property only applies to textual custom attributes and requires
   * indexable set to enabled to enable exact-searchable. If unset, the server
   * behavior defaults to
   * [EXACT_SEARCHABLE_DISABLED][google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption.EXACT_SEARCHABLE_DISABLED].
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption exact_searchable_option = 11;
   * </code>
   *
   * @return The exactSearchableOption.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption
      getExactSearchableOption() {
    com.google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption result =
        com.google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption.forNumber(
            exactSearchableOption_);
    return result == null
        ? com.google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption.UNRECOGNIZED
        : result;
  }

  public static final int RETRIEVABLE_OPTION_FIELD_NUMBER = 12;
  private int retrievableOption_ = 0;
  /**
   *
   *
   * <pre>
   * If RETRIEVABLE_ENABLED, attribute values are retrievable in the search
   * results. If unset, the server behavior defaults to
   * [RETRIEVABLE_DISABLED][google.cloud.retail.v2.CatalogAttribute.RetrievableOption.RETRIEVABLE_DISABLED].
   * </pre>
   *
   * <code>.google.cloud.retail.v2.CatalogAttribute.RetrievableOption retrievable_option = 12;
   * </code>
   *
   * @return The enum numeric value on the wire for retrievableOption.
   */
  @java.lang.Override
  public int getRetrievableOptionValue() {
    return retrievableOption_;
  }
  /**
   *
   *
   * <pre>
   * If RETRIEVABLE_ENABLED, attribute values are retrievable in the search
   * results. If unset, the server behavior defaults to
   * [RETRIEVABLE_DISABLED][google.cloud.retail.v2.CatalogAttribute.RetrievableOption.RETRIEVABLE_DISABLED].
   * </pre>
   *
   * <code>.google.cloud.retail.v2.CatalogAttribute.RetrievableOption retrievable_option = 12;
   * </code>
   *
   * @return The retrievableOption.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.CatalogAttribute.RetrievableOption getRetrievableOption() {
    com.google.cloud.retail.v2.CatalogAttribute.RetrievableOption result =
        com.google.cloud.retail.v2.CatalogAttribute.RetrievableOption.forNumber(retrievableOption_);
    return result == null
        ? com.google.cloud.retail.v2.CatalogAttribute.RetrievableOption.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, key_);
    }
    if (indexableOption_
        != com.google.cloud.retail.v2.CatalogAttribute.IndexableOption.INDEXABLE_OPTION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, indexableOption_);
    }
    if (dynamicFacetableOption_
        != com.google.cloud.retail.v2.CatalogAttribute.DynamicFacetableOption
            .DYNAMIC_FACETABLE_OPTION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, dynamicFacetableOption_);
    }
    if (searchableOption_
        != com.google.cloud.retail.v2.CatalogAttribute.SearchableOption
            .SEARCHABLE_OPTION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, searchableOption_);
    }
    if (inUse_ != false) {
      output.writeBool(9, inUse_);
    }
    if (type_ != com.google.cloud.retail.v2.CatalogAttribute.AttributeType.UNKNOWN.getNumber()) {
      output.writeEnum(10, type_);
    }
    if (exactSearchableOption_
        != com.google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption
            .EXACT_SEARCHABLE_OPTION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(11, exactSearchableOption_);
    }
    if (retrievableOption_
        != com.google.cloud.retail.v2.CatalogAttribute.RetrievableOption
            .RETRIEVABLE_OPTION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(12, retrievableOption_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, key_);
    }
    if (indexableOption_
        != com.google.cloud.retail.v2.CatalogAttribute.IndexableOption.INDEXABLE_OPTION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, indexableOption_);
    }
    if (dynamicFacetableOption_
        != com.google.cloud.retail.v2.CatalogAttribute.DynamicFacetableOption
            .DYNAMIC_FACETABLE_OPTION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, dynamicFacetableOption_);
    }
    if (searchableOption_
        != com.google.cloud.retail.v2.CatalogAttribute.SearchableOption
            .SEARCHABLE_OPTION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, searchableOption_);
    }
    if (inUse_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(9, inUse_);
    }
    if (type_ != com.google.cloud.retail.v2.CatalogAttribute.AttributeType.UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, type_);
    }
    if (exactSearchableOption_
        != com.google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption
            .EXACT_SEARCHABLE_OPTION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(11, exactSearchableOption_);
    }
    if (retrievableOption_
        != com.google.cloud.retail.v2.CatalogAttribute.RetrievableOption
            .RETRIEVABLE_OPTION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(12, retrievableOption_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2.CatalogAttribute)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2.CatalogAttribute other =
        (com.google.cloud.retail.v2.CatalogAttribute) obj;

    if (!getKey().equals(other.getKey())) return false;
    if (getInUse() != other.getInUse()) return false;
    if (type_ != other.type_) return false;
    if (indexableOption_ != other.indexableOption_) return false;
    if (dynamicFacetableOption_ != other.dynamicFacetableOption_) return false;
    if (searchableOption_ != other.searchableOption_) return false;
    if (exactSearchableOption_ != other.exactSearchableOption_) return false;
    if (retrievableOption_ != other.retrievableOption_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + KEY_FIELD_NUMBER;
    hash = (53 * hash) + getKey().hashCode();
    hash = (37 * hash) + IN_USE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getInUse());
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + INDEXABLE_OPTION_FIELD_NUMBER;
    hash = (53 * hash) + indexableOption_;
    hash = (37 * hash) + DYNAMIC_FACETABLE_OPTION_FIELD_NUMBER;
    hash = (53 * hash) + dynamicFacetableOption_;
    hash = (37 * hash) + SEARCHABLE_OPTION_FIELD_NUMBER;
    hash = (53 * hash) + searchableOption_;
    hash = (37 * hash) + EXACT_SEARCHABLE_OPTION_FIELD_NUMBER;
    hash = (53 * hash) + exactSearchableOption_;
    hash = (37 * hash) + RETRIEVABLE_OPTION_FIELD_NUMBER;
    hash = (53 * hash) + retrievableOption_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2.CatalogAttribute parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.CatalogAttribute parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.CatalogAttribute parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.CatalogAttribute parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.CatalogAttribute parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.CatalogAttribute parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.CatalogAttribute parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.CatalogAttribute parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.CatalogAttribute parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.CatalogAttribute parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.CatalogAttribute parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.CatalogAttribute parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2.CatalogAttribute prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Catalog level attribute config for an attribute. For example, if customers
   * want to enable/disable facet for a specific attribute.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2.CatalogAttribute}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.CatalogAttribute)
      com.google.cloud.retail.v2.CatalogAttributeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2.CatalogProto
          .internal_static_google_cloud_retail_v2_CatalogAttribute_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2.CatalogProto
          .internal_static_google_cloud_retail_v2_CatalogAttribute_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2.CatalogAttribute.class,
              com.google.cloud.retail.v2.CatalogAttribute.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2.CatalogAttribute.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      key_ = "";
      inUse_ = false;
      type_ = 0;
      indexableOption_ = 0;
      dynamicFacetableOption_ = 0;
      searchableOption_ = 0;
      exactSearchableOption_ = 0;
      retrievableOption_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2.CatalogProto
          .internal_static_google_cloud_retail_v2_CatalogAttribute_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.CatalogAttribute getDefaultInstanceForType() {
      return com.google.cloud.retail.v2.CatalogAttribute.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.CatalogAttribute build() {
      com.google.cloud.retail.v2.CatalogAttribute result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.CatalogAttribute buildPartial() {
      com.google.cloud.retail.v2.CatalogAttribute result =
          new com.google.cloud.retail.v2.CatalogAttribute(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.retail.v2.CatalogAttribute result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.key_ = key_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.inUse_ = inUse_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.indexableOption_ = indexableOption_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.dynamicFacetableOption_ = dynamicFacetableOption_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.searchableOption_ = searchableOption_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.exactSearchableOption_ = exactSearchableOption_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.retrievableOption_ = retrievableOption_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2.CatalogAttribute) {
        return mergeFrom((com.google.cloud.retail.v2.CatalogAttribute) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2.CatalogAttribute other) {
      if (other == com.google.cloud.retail.v2.CatalogAttribute.getDefaultInstance()) return this;
      if (!other.getKey().isEmpty()) {
        key_ = other.key_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getInUse() != false) {
        setInUse(other.getInUse());
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.indexableOption_ != 0) {
        setIndexableOptionValue(other.getIndexableOptionValue());
      }
      if (other.dynamicFacetableOption_ != 0) {
        setDynamicFacetableOptionValue(other.getDynamicFacetableOptionValue());
      }
      if (other.searchableOption_ != 0) {
        setSearchableOptionValue(other.getSearchableOptionValue());
      }
      if (other.exactSearchableOption_ != 0) {
        setExactSearchableOptionValue(other.getExactSearchableOptionValue());
      }
      if (other.retrievableOption_ != 0) {
        setRetrievableOptionValue(other.getRetrievableOptionValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                key_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 40:
              {
                indexableOption_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 40
            case 48:
              {
                dynamicFacetableOption_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 48
            case 56:
              {
                searchableOption_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 56
            case 72:
              {
                inUse_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 72
            case 80:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 80
            case 88:
              {
                exactSearchableOption_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 88
            case 96:
              {
                retrievableOption_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 96
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object key_ = "";
    /**
     *
     *
     * <pre>
     * Required. Attribute name.
     * For example: `color`, `brands`, `attributes.custom_attribute`, such as
     * `attributes.xyz`.
     * To be indexable, the attribute name can contain only alpha-numeric
     * characters and underscores. For example, an attribute named
     * `attributes.abc_xyz` can be indexed, but an attribute named
     * `attributes.abc-xyz` cannot be indexed.
     *
     * If the attribute key starts with `attributes.`, then the attribute is a
     * custom attribute. Attributes such as `brands`, `patterns`, and `title` are
     * built-in and called system attributes.
     * </pre>
     *
     * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The key.
     */
    public java.lang.String getKey() {
      java.lang.Object ref = key_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        key_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Attribute name.
     * For example: `color`, `brands`, `attributes.custom_attribute`, such as
     * `attributes.xyz`.
     * To be indexable, the attribute name can contain only alpha-numeric
     * characters and underscores. For example, an attribute named
     * `attributes.abc_xyz` can be indexed, but an attribute named
     * `attributes.abc-xyz` cannot be indexed.
     *
     * If the attribute key starts with `attributes.`, then the attribute is a
     * custom attribute. Attributes such as `brands`, `patterns`, and `title` are
     * built-in and called system attributes.
     * </pre>
     *
     * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for key.
     */
    public com.google.protobuf.ByteString getKeyBytes() {
      java.lang.Object ref = key_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        key_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Attribute name.
     * For example: `color`, `brands`, `attributes.custom_attribute`, such as
     * `attributes.xyz`.
     * To be indexable, the attribute name can contain only alpha-numeric
     * characters and underscores. For example, an attribute named
     * `attributes.abc_xyz` can be indexed, but an attribute named
     * `attributes.abc-xyz` cannot be indexed.
     *
     * If the attribute key starts with `attributes.`, then the attribute is a
     * custom attribute. Attributes such as `brands`, `patterns`, and `title` are
     * built-in and called system attributes.
     * </pre>
     *
     * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The key to set.
     * @return This builder for chaining.
     */
    public Builder setKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      key_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Attribute name.
     * For example: `color`, `brands`, `attributes.custom_attribute`, such as
     * `attributes.xyz`.
     * To be indexable, the attribute name can contain only alpha-numeric
     * characters and underscores. For example, an attribute named
     * `attributes.abc_xyz` can be indexed, but an attribute named
     * `attributes.abc-xyz` cannot be indexed.
     *
     * If the attribute key starts with `attributes.`, then the attribute is a
     * custom attribute. Attributes such as `brands`, `patterns`, and `title` are
     * built-in and called system attributes.
     * </pre>
     *
     * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKey() {
      key_ = getDefaultInstance().getKey();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Attribute name.
     * For example: `color`, `brands`, `attributes.custom_attribute`, such as
     * `attributes.xyz`.
     * To be indexable, the attribute name can contain only alpha-numeric
     * characters and underscores. For example, an attribute named
     * `attributes.abc_xyz` can be indexed, but an attribute named
     * `attributes.abc-xyz` cannot be indexed.
     *
     * If the attribute key starts with `attributes.`, then the attribute is a
     * custom attribute. Attributes such as `brands`, `patterns`, and `title` are
     * built-in and called system attributes.
     * </pre>
     *
     * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for key to set.
     * @return This builder for chaining.
     */
    public Builder setKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      key_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private boolean inUse_;
    /**
     *
     *
     * <pre>
     * Output only. Indicates whether this attribute has been used by any
     * products. `True` if at least one [Product][google.cloud.retail.v2.Product]
     * is using this attribute in
     * [Product.attributes][google.cloud.retail.v2.Product.attributes]. Otherwise,
     * this field is `False`.
     *
     * [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] can be
     * pre-loaded by using
     * [CatalogService.AddCatalogAttribute][google.cloud.retail.v2.CatalogService.AddCatalogAttribute],
     * [CatalogService.ImportCatalogAttributes][], or
     * [CatalogService.UpdateAttributesConfig][google.cloud.retail.v2.CatalogService.UpdateAttributesConfig]
     * APIs. This field is `False` for pre-loaded
     * [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute]s.
     *
     * Only pre-loaded [catalog
     * attributes][google.cloud.retail.v2.CatalogAttribute] that are neither in
     * use by products nor predefined can be deleted. [Catalog
     * attributes][google.cloud.retail.v2.CatalogAttribute] that are
     * either in use by products or are predefined attributes cannot be deleted;
     * however, their configuration properties will reset to default values upon
     * removal request.
     *
     * After catalog changes, it takes about 10 minutes for this field to update.
     * </pre>
     *
     * <code>bool in_use = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The inUse.
     */
    @java.lang.Override
    public boolean getInUse() {
      return inUse_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates whether this attribute has been used by any
     * products. `True` if at least one [Product][google.cloud.retail.v2.Product]
     * is using this attribute in
     * [Product.attributes][google.cloud.retail.v2.Product.attributes]. Otherwise,
     * this field is `False`.
     *
     * [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] can be
     * pre-loaded by using
     * [CatalogService.AddCatalogAttribute][google.cloud.retail.v2.CatalogService.AddCatalogAttribute],
     * [CatalogService.ImportCatalogAttributes][], or
     * [CatalogService.UpdateAttributesConfig][google.cloud.retail.v2.CatalogService.UpdateAttributesConfig]
     * APIs. This field is `False` for pre-loaded
     * [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute]s.
     *
     * Only pre-loaded [catalog
     * attributes][google.cloud.retail.v2.CatalogAttribute] that are neither in
     * use by products nor predefined can be deleted. [Catalog
     * attributes][google.cloud.retail.v2.CatalogAttribute] that are
     * either in use by products or are predefined attributes cannot be deleted;
     * however, their configuration properties will reset to default values upon
     * removal request.
     *
     * After catalog changes, it takes about 10 minutes for this field to update.
     * </pre>
     *
     * <code>bool in_use = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The inUse to set.
     * @return This builder for chaining.
     */
    public Builder setInUse(boolean value) {

      inUse_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates whether this attribute has been used by any
     * products. `True` if at least one [Product][google.cloud.retail.v2.Product]
     * is using this attribute in
     * [Product.attributes][google.cloud.retail.v2.Product.attributes]. Otherwise,
     * this field is `False`.
     *
     * [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] can be
     * pre-loaded by using
     * [CatalogService.AddCatalogAttribute][google.cloud.retail.v2.CatalogService.AddCatalogAttribute],
     * [CatalogService.ImportCatalogAttributes][], or
     * [CatalogService.UpdateAttributesConfig][google.cloud.retail.v2.CatalogService.UpdateAttributesConfig]
     * APIs. This field is `False` for pre-loaded
     * [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute]s.
     *
     * Only pre-loaded [catalog
     * attributes][google.cloud.retail.v2.CatalogAttribute] that are neither in
     * use by products nor predefined can be deleted. [Catalog
     * attributes][google.cloud.retail.v2.CatalogAttribute] that are
     * either in use by products or are predefined attributes cannot be deleted;
     * however, their configuration properties will reset to default values upon
     * removal request.
     *
     * After catalog changes, it takes about 10 minutes for this field to update.
     * </pre>
     *
     * <code>bool in_use = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInUse() {
      bitField0_ = (bitField0_ & ~0x00000002);
      inUse_ = false;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The type of this attribute. This is derived from the attribute
     * in [Product.attributes][google.cloud.retail.v2.Product.attributes].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.CatalogAttribute.AttributeType type = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The type of this attribute. This is derived from the attribute
     * in [Product.attributes][google.cloud.retail.v2.Product.attributes].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.CatalogAttribute.AttributeType type = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The type of this attribute. This is derived from the attribute
     * in [Product.attributes][google.cloud.retail.v2.Product.attributes].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.CatalogAttribute.AttributeType type = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.CatalogAttribute.AttributeType getType() {
      com.google.cloud.retail.v2.CatalogAttribute.AttributeType result =
          com.google.cloud.retail.v2.CatalogAttribute.AttributeType.forNumber(type_);
      return result == null
          ? com.google.cloud.retail.v2.CatalogAttribute.AttributeType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The type of this attribute. This is derived from the attribute
     * in [Product.attributes][google.cloud.retail.v2.Product.attributes].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.CatalogAttribute.AttributeType type = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.retail.v2.CatalogAttribute.AttributeType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The type of this attribute. This is derived from the attribute
     * in [Product.attributes][google.cloud.retail.v2.Product.attributes].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.CatalogAttribute.AttributeType type = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000004);
      type_ = 0;
      onChanged();
      return this;
    }

    private int indexableOption_ = 0;
    /**
     *
     *
     * <pre>
     * When
     * [AttributesConfig.attribute_config_level][google.cloud.retail.v2.AttributesConfig.attribute_config_level]
     * is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if INDEXABLE_ENABLED attribute values
     * are indexed so that it can be filtered, faceted, or boosted in
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
     *
     * Must be specified, otherwise throws INVALID_FORMAT error.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.CatalogAttribute.IndexableOption indexable_option = 5;</code>
     *
     * @return The enum numeric value on the wire for indexableOption.
     */
    @java.lang.Override
    public int getIndexableOptionValue() {
      return indexableOption_;
    }
    /**
     *
     *
     * <pre>
     * When
     * [AttributesConfig.attribute_config_level][google.cloud.retail.v2.AttributesConfig.attribute_config_level]
     * is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if INDEXABLE_ENABLED attribute values
     * are indexed so that it can be filtered, faceted, or boosted in
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
     *
     * Must be specified, otherwise throws INVALID_FORMAT error.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.CatalogAttribute.IndexableOption indexable_option = 5;</code>
     *
     * @param value The enum numeric value on the wire for indexableOption to set.
     * @return This builder for chaining.
     */
    public Builder setIndexableOptionValue(int value) {
      indexableOption_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When
     * [AttributesConfig.attribute_config_level][google.cloud.retail.v2.AttributesConfig.attribute_config_level]
     * is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if INDEXABLE_ENABLED attribute values
     * are indexed so that it can be filtered, faceted, or boosted in
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
     *
     * Must be specified, otherwise throws INVALID_FORMAT error.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.CatalogAttribute.IndexableOption indexable_option = 5;</code>
     *
     * @return The indexableOption.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.CatalogAttribute.IndexableOption getIndexableOption() {
      com.google.cloud.retail.v2.CatalogAttribute.IndexableOption result =
          com.google.cloud.retail.v2.CatalogAttribute.IndexableOption.forNumber(indexableOption_);
      return result == null
          ? com.google.cloud.retail.v2.CatalogAttribute.IndexableOption.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * When
     * [AttributesConfig.attribute_config_level][google.cloud.retail.v2.AttributesConfig.attribute_config_level]
     * is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if INDEXABLE_ENABLED attribute values
     * are indexed so that it can be filtered, faceted, or boosted in
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
     *
     * Must be specified, otherwise throws INVALID_FORMAT error.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.CatalogAttribute.IndexableOption indexable_option = 5;</code>
     *
     * @param value The indexableOption to set.
     * @return This builder for chaining.
     */
    public Builder setIndexableOption(
        com.google.cloud.retail.v2.CatalogAttribute.IndexableOption value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      indexableOption_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When
     * [AttributesConfig.attribute_config_level][google.cloud.retail.v2.AttributesConfig.attribute_config_level]
     * is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if INDEXABLE_ENABLED attribute values
     * are indexed so that it can be filtered, faceted, or boosted in
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
     *
     * Must be specified, otherwise throws INVALID_FORMAT error.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.CatalogAttribute.IndexableOption indexable_option = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIndexableOption() {
      bitField0_ = (bitField0_ & ~0x00000008);
      indexableOption_ = 0;
      onChanged();
      return this;
    }

    private int dynamicFacetableOption_ = 0;
    /**
     *
     *
     * <pre>
     * If DYNAMIC_FACETABLE_ENABLED, attribute values are available for dynamic
     * facet. Could only be DYNAMIC_FACETABLE_DISABLED if
     * [CatalogAttribute.indexable_option][google.cloud.retail.v2.CatalogAttribute.indexable_option]
     * is INDEXABLE_DISABLED. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Must be specified, otherwise throws INVALID_FORMAT error.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.CatalogAttribute.DynamicFacetableOption dynamic_facetable_option = 6;
     * </code>
     *
     * @return The enum numeric value on the wire for dynamicFacetableOption.
     */
    @java.lang.Override
    public int getDynamicFacetableOptionValue() {
      return dynamicFacetableOption_;
    }
    /**
     *
     *
     * <pre>
     * If DYNAMIC_FACETABLE_ENABLED, attribute values are available for dynamic
     * facet. Could only be DYNAMIC_FACETABLE_DISABLED if
     * [CatalogAttribute.indexable_option][google.cloud.retail.v2.CatalogAttribute.indexable_option]
     * is INDEXABLE_DISABLED. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Must be specified, otherwise throws INVALID_FORMAT error.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.CatalogAttribute.DynamicFacetableOption dynamic_facetable_option = 6;
     * </code>
     *
     * @param value The enum numeric value on the wire for dynamicFacetableOption to set.
     * @return This builder for chaining.
     */
    public Builder setDynamicFacetableOptionValue(int value) {
      dynamicFacetableOption_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If DYNAMIC_FACETABLE_ENABLED, attribute values are available for dynamic
     * facet. Could only be DYNAMIC_FACETABLE_DISABLED if
     * [CatalogAttribute.indexable_option][google.cloud.retail.v2.CatalogAttribute.indexable_option]
     * is INDEXABLE_DISABLED. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Must be specified, otherwise throws INVALID_FORMAT error.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.CatalogAttribute.DynamicFacetableOption dynamic_facetable_option = 6;
     * </code>
     *
     * @return The dynamicFacetableOption.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.CatalogAttribute.DynamicFacetableOption
        getDynamicFacetableOption() {
      com.google.cloud.retail.v2.CatalogAttribute.DynamicFacetableOption result =
          com.google.cloud.retail.v2.CatalogAttribute.DynamicFacetableOption.forNumber(
              dynamicFacetableOption_);
      return result == null
          ? com.google.cloud.retail.v2.CatalogAttribute.DynamicFacetableOption.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * If DYNAMIC_FACETABLE_ENABLED, attribute values are available for dynamic
     * facet. Could only be DYNAMIC_FACETABLE_DISABLED if
     * [CatalogAttribute.indexable_option][google.cloud.retail.v2.CatalogAttribute.indexable_option]
     * is INDEXABLE_DISABLED. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Must be specified, otherwise throws INVALID_FORMAT error.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.CatalogAttribute.DynamicFacetableOption dynamic_facetable_option = 6;
     * </code>
     *
     * @param value The dynamicFacetableOption to set.
     * @return This builder for chaining.
     */
    public Builder setDynamicFacetableOption(
        com.google.cloud.retail.v2.CatalogAttribute.DynamicFacetableOption value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      dynamicFacetableOption_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If DYNAMIC_FACETABLE_ENABLED, attribute values are available for dynamic
     * facet. Could only be DYNAMIC_FACETABLE_DISABLED if
     * [CatalogAttribute.indexable_option][google.cloud.retail.v2.CatalogAttribute.indexable_option]
     * is INDEXABLE_DISABLED. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Must be specified, otherwise throws INVALID_FORMAT error.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.CatalogAttribute.DynamicFacetableOption dynamic_facetable_option = 6;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDynamicFacetableOption() {
      bitField0_ = (bitField0_ & ~0x00000010);
      dynamicFacetableOption_ = 0;
      onChanged();
      return this;
    }

    private int searchableOption_ = 0;
    /**
     *
     *
     * <pre>
     * When
     * [AttributesConfig.attribute_config_level][google.cloud.retail.v2.AttributesConfig.attribute_config_level]
     * is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if SEARCHABLE_ENABLED, attribute values
     * are searchable by text queries in
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
     *
     * If SEARCHABLE_ENABLED but attribute type is numerical, attribute values
     * will not be searchable by text queries in
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search], as
     * there are no text values associated to numerical attributes.
     *
     * Must be specified, otherwise throws INVALID_FORMAT error.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.CatalogAttribute.SearchableOption searchable_option = 7;</code>
     *
     * @return The enum numeric value on the wire for searchableOption.
     */
    @java.lang.Override
    public int getSearchableOptionValue() {
      return searchableOption_;
    }
    /**
     *
     *
     * <pre>
     * When
     * [AttributesConfig.attribute_config_level][google.cloud.retail.v2.AttributesConfig.attribute_config_level]
     * is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if SEARCHABLE_ENABLED, attribute values
     * are searchable by text queries in
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
     *
     * If SEARCHABLE_ENABLED but attribute type is numerical, attribute values
     * will not be searchable by text queries in
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search], as
     * there are no text values associated to numerical attributes.
     *
     * Must be specified, otherwise throws INVALID_FORMAT error.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.CatalogAttribute.SearchableOption searchable_option = 7;</code>
     *
     * @param value The enum numeric value on the wire for searchableOption to set.
     * @return This builder for chaining.
     */
    public Builder setSearchableOptionValue(int value) {
      searchableOption_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When
     * [AttributesConfig.attribute_config_level][google.cloud.retail.v2.AttributesConfig.attribute_config_level]
     * is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if SEARCHABLE_ENABLED, attribute values
     * are searchable by text queries in
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
     *
     * If SEARCHABLE_ENABLED but attribute type is numerical, attribute values
     * will not be searchable by text queries in
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search], as
     * there are no text values associated to numerical attributes.
     *
     * Must be specified, otherwise throws INVALID_FORMAT error.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.CatalogAttribute.SearchableOption searchable_option = 7;</code>
     *
     * @return The searchableOption.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.CatalogAttribute.SearchableOption getSearchableOption() {
      com.google.cloud.retail.v2.CatalogAttribute.SearchableOption result =
          com.google.cloud.retail.v2.CatalogAttribute.SearchableOption.forNumber(searchableOption_);
      return result == null
          ? com.google.cloud.retail.v2.CatalogAttribute.SearchableOption.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * When
     * [AttributesConfig.attribute_config_level][google.cloud.retail.v2.AttributesConfig.attribute_config_level]
     * is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if SEARCHABLE_ENABLED, attribute values
     * are searchable by text queries in
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
     *
     * If SEARCHABLE_ENABLED but attribute type is numerical, attribute values
     * will not be searchable by text queries in
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search], as
     * there are no text values associated to numerical attributes.
     *
     * Must be specified, otherwise throws INVALID_FORMAT error.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.CatalogAttribute.SearchableOption searchable_option = 7;</code>
     *
     * @param value The searchableOption to set.
     * @return This builder for chaining.
     */
    public Builder setSearchableOption(
        com.google.cloud.retail.v2.CatalogAttribute.SearchableOption value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      searchableOption_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When
     * [AttributesConfig.attribute_config_level][google.cloud.retail.v2.AttributesConfig.attribute_config_level]
     * is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if SEARCHABLE_ENABLED, attribute values
     * are searchable by text queries in
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
     *
     * If SEARCHABLE_ENABLED but attribute type is numerical, attribute values
     * will not be searchable by text queries in
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search], as
     * there are no text values associated to numerical attributes.
     *
     * Must be specified, otherwise throws INVALID_FORMAT error.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.CatalogAttribute.SearchableOption searchable_option = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSearchableOption() {
      bitField0_ = (bitField0_ & ~0x00000020);
      searchableOption_ = 0;
      onChanged();
      return this;
    }

    private int exactSearchableOption_ = 0;
    /**
     *
     *
     * <pre>
     * If EXACT_SEARCHABLE_ENABLED, attribute values will be exact searchable.
     * This property only applies to textual custom attributes and requires
     * indexable set to enabled to enable exact-searchable. If unset, the server
     * behavior defaults to
     * [EXACT_SEARCHABLE_DISABLED][google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption.EXACT_SEARCHABLE_DISABLED].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption exact_searchable_option = 11;
     * </code>
     *
     * @return The enum numeric value on the wire for exactSearchableOption.
     */
    @java.lang.Override
    public int getExactSearchableOptionValue() {
      return exactSearchableOption_;
    }
    /**
     *
     *
     * <pre>
     * If EXACT_SEARCHABLE_ENABLED, attribute values will be exact searchable.
     * This property only applies to textual custom attributes and requires
     * indexable set to enabled to enable exact-searchable. If unset, the server
     * behavior defaults to
     * [EXACT_SEARCHABLE_DISABLED][google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption.EXACT_SEARCHABLE_DISABLED].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption exact_searchable_option = 11;
     * </code>
     *
     * @param value The enum numeric value on the wire for exactSearchableOption to set.
     * @return This builder for chaining.
     */
    public Builder setExactSearchableOptionValue(int value) {
      exactSearchableOption_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If EXACT_SEARCHABLE_ENABLED, attribute values will be exact searchable.
     * This property only applies to textual custom attributes and requires
     * indexable set to enabled to enable exact-searchable. If unset, the server
     * behavior defaults to
     * [EXACT_SEARCHABLE_DISABLED][google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption.EXACT_SEARCHABLE_DISABLED].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption exact_searchable_option = 11;
     * </code>
     *
     * @return The exactSearchableOption.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption
        getExactSearchableOption() {
      com.google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption result =
          com.google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption.forNumber(
              exactSearchableOption_);
      return result == null
          ? com.google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * If EXACT_SEARCHABLE_ENABLED, attribute values will be exact searchable.
     * This property only applies to textual custom attributes and requires
     * indexable set to enabled to enable exact-searchable. If unset, the server
     * behavior defaults to
     * [EXACT_SEARCHABLE_DISABLED][google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption.EXACT_SEARCHABLE_DISABLED].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption exact_searchable_option = 11;
     * </code>
     *
     * @param value The exactSearchableOption to set.
     * @return This builder for chaining.
     */
    public Builder setExactSearchableOption(
        com.google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      exactSearchableOption_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If EXACT_SEARCHABLE_ENABLED, attribute values will be exact searchable.
     * This property only applies to textual custom attributes and requires
     * indexable set to enabled to enable exact-searchable. If unset, the server
     * behavior defaults to
     * [EXACT_SEARCHABLE_DISABLED][google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption.EXACT_SEARCHABLE_DISABLED].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption exact_searchable_option = 11;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExactSearchableOption() {
      bitField0_ = (bitField0_ & ~0x00000040);
      exactSearchableOption_ = 0;
      onChanged();
      return this;
    }

    private int retrievableOption_ = 0;
    /**
     *
     *
     * <pre>
     * If RETRIEVABLE_ENABLED, attribute values are retrievable in the search
     * results. If unset, the server behavior defaults to
     * [RETRIEVABLE_DISABLED][google.cloud.retail.v2.CatalogAttribute.RetrievableOption.RETRIEVABLE_DISABLED].
     * </pre>
     *
     * <code>.google.cloud.retail.v2.CatalogAttribute.RetrievableOption retrievable_option = 12;
     * </code>
     *
     * @return The enum numeric value on the wire for retrievableOption.
     */
    @java.lang.Override
    public int getRetrievableOptionValue() {
      return retrievableOption_;
    }
    /**
     *
     *
     * <pre>
     * If RETRIEVABLE_ENABLED, attribute values are retrievable in the search
     * results. If unset, the server behavior defaults to
     * [RETRIEVABLE_DISABLED][google.cloud.retail.v2.CatalogAttribute.RetrievableOption.RETRIEVABLE_DISABLED].
     * </pre>
     *
     * <code>.google.cloud.retail.v2.CatalogAttribute.RetrievableOption retrievable_option = 12;
     * </code>
     *
     * @param value The enum numeric value on the wire for retrievableOption to set.
     * @return This builder for chaining.
     */
    public Builder setRetrievableOptionValue(int value) {
      retrievableOption_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If RETRIEVABLE_ENABLED, attribute values are retrievable in the search
     * results. If unset, the server behavior defaults to
     * [RETRIEVABLE_DISABLED][google.cloud.retail.v2.CatalogAttribute.RetrievableOption.RETRIEVABLE_DISABLED].
     * </pre>
     *
     * <code>.google.cloud.retail.v2.CatalogAttribute.RetrievableOption retrievable_option = 12;
     * </code>
     *
     * @return The retrievableOption.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.CatalogAttribute.RetrievableOption getRetrievableOption() {
      com.google.cloud.retail.v2.CatalogAttribute.RetrievableOption result =
          com.google.cloud.retail.v2.CatalogAttribute.RetrievableOption.forNumber(
              retrievableOption_);
      return result == null
          ? com.google.cloud.retail.v2.CatalogAttribute.RetrievableOption.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * If RETRIEVABLE_ENABLED, attribute values are retrievable in the search
     * results. If unset, the server behavior defaults to
     * [RETRIEVABLE_DISABLED][google.cloud.retail.v2.CatalogAttribute.RetrievableOption.RETRIEVABLE_DISABLED].
     * </pre>
     *
     * <code>.google.cloud.retail.v2.CatalogAttribute.RetrievableOption retrievable_option = 12;
     * </code>
     *
     * @param value The retrievableOption to set.
     * @return This builder for chaining.
     */
    public Builder setRetrievableOption(
        com.google.cloud.retail.v2.CatalogAttribute.RetrievableOption value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      retrievableOption_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If RETRIEVABLE_ENABLED, attribute values are retrievable in the search
     * results. If unset, the server behavior defaults to
     * [RETRIEVABLE_DISABLED][google.cloud.retail.v2.CatalogAttribute.RetrievableOption.RETRIEVABLE_DISABLED].
     * </pre>
     *
     * <code>.google.cloud.retail.v2.CatalogAttribute.RetrievableOption retrievable_option = 12;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRetrievableOption() {
      bitField0_ = (bitField0_ & ~0x00000080);
      retrievableOption_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.CatalogAttribute)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.CatalogAttribute)
  private static final com.google.cloud.retail.v2.CatalogAttribute DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2.CatalogAttribute();
  }

  public static com.google.cloud.retail.v2.CatalogAttribute getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CatalogAttribute> PARSER =
      new com.google.protobuf.AbstractParser<CatalogAttribute>() {
        @java.lang.Override
        public CatalogAttribute parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CatalogAttribute> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CatalogAttribute> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2.CatalogAttribute getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
