/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2/user_event_service.proto

package com.google.cloud.retail.v2;

/**
 *
 *
 * <pre>
 * Request message for CollectUserEvent method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2.CollectUserEventRequest}
 */
public final class CollectUserEventRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.CollectUserEventRequest)
    CollectUserEventRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CollectUserEventRequest.newBuilder() to construct.
  private CollectUserEventRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CollectUserEventRequest() {
    parent_ = "";
    userEvent_ = "";
    uri_ = "";
    rawJson_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CollectUserEventRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2.UserEventServiceProto
        .internal_static_google_cloud_retail_v2_CollectUserEventRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2.UserEventServiceProto
        .internal_static_google_cloud_retail_v2_CollectUserEventRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2.CollectUserEventRequest.class,
            com.google.cloud.retail.v2.CollectUserEventRequest.Builder.class);
  }

  private int conversionRuleCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object conversionRule_;

  public enum ConversionRuleCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    PREBUILT_RULE(6),
    CONVERSIONRULE_NOT_SET(0);
    private final int value;

    private ConversionRuleCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConversionRuleCase valueOf(int value) {
      return forNumber(value);
    }

    public static ConversionRuleCase forNumber(int value) {
      switch (value) {
        case 6:
          return PREBUILT_RULE;
        case 0:
          return CONVERSIONRULE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ConversionRuleCase getConversionRuleCase() {
    return ConversionRuleCase.forNumber(conversionRuleCase_);
  }

  public static final int PREBUILT_RULE_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * The prebuilt rule name that can convert a specific type of raw_json.
   * For example: "ga4_bq" rule for the GA4 user event schema.
   * </pre>
   *
   * <code>string prebuilt_rule = 6;</code>
   *
   * @return Whether the prebuiltRule field is set.
   */
  public boolean hasPrebuiltRule() {
    return conversionRuleCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * The prebuilt rule name that can convert a specific type of raw_json.
   * For example: "ga4_bq" rule for the GA4 user event schema.
   * </pre>
   *
   * <code>string prebuilt_rule = 6;</code>
   *
   * @return The prebuiltRule.
   */
  public java.lang.String getPrebuiltRule() {
    java.lang.Object ref = "";
    if (conversionRuleCase_ == 6) {
      ref = conversionRule_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (conversionRuleCase_ == 6) {
        conversionRule_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The prebuilt rule name that can convert a specific type of raw_json.
   * For example: "ga4_bq" rule for the GA4 user event schema.
   * </pre>
   *
   * <code>string prebuilt_rule = 6;</code>
   *
   * @return The bytes for prebuiltRule.
   */
  public com.google.protobuf.ByteString getPrebuiltRuleBytes() {
    java.lang.Object ref = "";
    if (conversionRuleCase_ == 6) {
      ref = conversionRule_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (conversionRuleCase_ == 6) {
        conversionRule_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The parent catalog name, such as
   * `projects/1234/locations/global/catalogs/default_catalog`.
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The parent catalog name, such as
   * `projects/1234/locations/global/catalogs/default_catalog`.
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USER_EVENT_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object userEvent_ = "";
  /**
   *
   *
   * <pre>
   * Required. URL encoded UserEvent proto with a length limit of 2,000,000
   * characters.
   * </pre>
   *
   * <code>string user_event = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The userEvent.
   */
  @java.lang.Override
  public java.lang.String getUserEvent() {
    java.lang.Object ref = userEvent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      userEvent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. URL encoded UserEvent proto with a length limit of 2,000,000
   * characters.
   * </pre>
   *
   * <code>string user_event = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for userEvent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUserEventBytes() {
    java.lang.Object ref = userEvent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      userEvent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int URI_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uri_ = "";
  /**
   *
   *
   * <pre>
   * The URL including cgi-parameters but excluding the hash fragment with a
   * length limit of 5,000 characters. This is often more useful than the
   * referer URL, because many browsers only send the domain for 3rd party
   * requests.
   * </pre>
   *
   * <code>string uri = 3;</code>
   *
   * @return The uri.
   */
  @java.lang.Override
  public java.lang.String getUri() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URL including cgi-parameters but excluding the hash fragment with a
   * length limit of 5,000 characters. This is often more useful than the
   * referer URL, because many browsers only send the domain for 3rd party
   * requests.
   * </pre>
   *
   * <code>string uri = 3;</code>
   *
   * @return The bytes for uri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUriBytes() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ETS_FIELD_NUMBER = 4;
  private long ets_ = 0L;
  /**
   *
   *
   * <pre>
   * The event timestamp in milliseconds. This prevents browser caching of
   * otherwise identical get requests. The name is abbreviated to reduce the
   * payload bytes.
   * </pre>
   *
   * <code>int64 ets = 4;</code>
   *
   * @return The ets.
   */
  @java.lang.Override
  public long getEts() {
    return ets_;
  }

  public static final int RAW_JSON_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object rawJson_ = "";
  /**
   *
   *
   * <pre>
   * An arbitrary serialized JSON string that contains necessary information
   * that can comprise a user event. When this field is specified, the
   * user_event field will be ignored. Note: line-delimited JSON is not
   * supported, a single JSON only.
   * </pre>
   *
   * <code>string raw_json = 5;</code>
   *
   * @return The rawJson.
   */
  @java.lang.Override
  public java.lang.String getRawJson() {
    java.lang.Object ref = rawJson_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      rawJson_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An arbitrary serialized JSON string that contains necessary information
   * that can comprise a user event. When this field is specified, the
   * user_event field will be ignored. Note: line-delimited JSON is not
   * supported, a single JSON only.
   * </pre>
   *
   * <code>string raw_json = 5;</code>
   *
   * @return The bytes for rawJson.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRawJsonBytes() {
    java.lang.Object ref = rawJson_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      rawJson_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userEvent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, userEvent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, uri_);
    }
    if (ets_ != 0L) {
      output.writeInt64(4, ets_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rawJson_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, rawJson_);
    }
    if (conversionRuleCase_ == 6) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, conversionRule_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userEvent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, userEvent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, uri_);
    }
    if (ets_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, ets_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rawJson_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, rawJson_);
    }
    if (conversionRuleCase_ == 6) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, conversionRule_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2.CollectUserEventRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2.CollectUserEventRequest other =
        (com.google.cloud.retail.v2.CollectUserEventRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getUserEvent().equals(other.getUserEvent())) return false;
    if (!getUri().equals(other.getUri())) return false;
    if (getEts() != other.getEts()) return false;
    if (!getRawJson().equals(other.getRawJson())) return false;
    if (!getConversionRuleCase().equals(other.getConversionRuleCase())) return false;
    switch (conversionRuleCase_) {
      case 6:
        if (!getPrebuiltRule().equals(other.getPrebuiltRule())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + USER_EVENT_FIELD_NUMBER;
    hash = (53 * hash) + getUserEvent().hashCode();
    hash = (37 * hash) + URI_FIELD_NUMBER;
    hash = (53 * hash) + getUri().hashCode();
    hash = (37 * hash) + ETS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getEts());
    hash = (37 * hash) + RAW_JSON_FIELD_NUMBER;
    hash = (53 * hash) + getRawJson().hashCode();
    switch (conversionRuleCase_) {
      case 6:
        hash = (37 * hash) + PREBUILT_RULE_FIELD_NUMBER;
        hash = (53 * hash) + getPrebuiltRule().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2.CollectUserEventRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.CollectUserEventRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.CollectUserEventRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.CollectUserEventRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.CollectUserEventRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.CollectUserEventRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.CollectUserEventRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.CollectUserEventRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.CollectUserEventRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.CollectUserEventRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.CollectUserEventRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.CollectUserEventRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2.CollectUserEventRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for CollectUserEvent method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2.CollectUserEventRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.CollectUserEventRequest)
      com.google.cloud.retail.v2.CollectUserEventRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2.UserEventServiceProto
          .internal_static_google_cloud_retail_v2_CollectUserEventRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2.UserEventServiceProto
          .internal_static_google_cloud_retail_v2_CollectUserEventRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2.CollectUserEventRequest.class,
              com.google.cloud.retail.v2.CollectUserEventRequest.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2.CollectUserEventRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      userEvent_ = "";
      uri_ = "";
      ets_ = 0L;
      rawJson_ = "";
      conversionRuleCase_ = 0;
      conversionRule_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2.UserEventServiceProto
          .internal_static_google_cloud_retail_v2_CollectUserEventRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.CollectUserEventRequest getDefaultInstanceForType() {
      return com.google.cloud.retail.v2.CollectUserEventRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.CollectUserEventRequest build() {
      com.google.cloud.retail.v2.CollectUserEventRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.CollectUserEventRequest buildPartial() {
      com.google.cloud.retail.v2.CollectUserEventRequest result =
          new com.google.cloud.retail.v2.CollectUserEventRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.retail.v2.CollectUserEventRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.userEvent_ = userEvent_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.uri_ = uri_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.ets_ = ets_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.rawJson_ = rawJson_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.retail.v2.CollectUserEventRequest result) {
      result.conversionRuleCase_ = conversionRuleCase_;
      result.conversionRule_ = this.conversionRule_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2.CollectUserEventRequest) {
        return mergeFrom((com.google.cloud.retail.v2.CollectUserEventRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2.CollectUserEventRequest other) {
      if (other == com.google.cloud.retail.v2.CollectUserEventRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getUserEvent().isEmpty()) {
        userEvent_ = other.userEvent_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getUri().isEmpty()) {
        uri_ = other.uri_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.getEts() != 0L) {
        setEts(other.getEts());
      }
      if (!other.getRawJson().isEmpty()) {
        rawJson_ = other.rawJson_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      switch (other.getConversionRuleCase()) {
        case PREBUILT_RULE:
          {
            conversionRuleCase_ = 6;
            conversionRule_ = other.conversionRule_;
            onChanged();
            break;
          }
        case CONVERSIONRULE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                userEvent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                uri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 32:
              {
                ets_ = input.readInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 32
            case 42:
              {
                rawJson_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                conversionRuleCase_ = 6;
                conversionRule_ = s;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int conversionRuleCase_ = 0;
    private java.lang.Object conversionRule_;

    public ConversionRuleCase getConversionRuleCase() {
      return ConversionRuleCase.forNumber(conversionRuleCase_);
    }

    public Builder clearConversionRule() {
      conversionRuleCase_ = 0;
      conversionRule_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * The prebuilt rule name that can convert a specific type of raw_json.
     * For example: "ga4_bq" rule for the GA4 user event schema.
     * </pre>
     *
     * <code>string prebuilt_rule = 6;</code>
     *
     * @return Whether the prebuiltRule field is set.
     */
    @java.lang.Override
    public boolean hasPrebuiltRule() {
      return conversionRuleCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * The prebuilt rule name that can convert a specific type of raw_json.
     * For example: "ga4_bq" rule for the GA4 user event schema.
     * </pre>
     *
     * <code>string prebuilt_rule = 6;</code>
     *
     * @return The prebuiltRule.
     */
    @java.lang.Override
    public java.lang.String getPrebuiltRule() {
      java.lang.Object ref = "";
      if (conversionRuleCase_ == 6) {
        ref = conversionRule_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (conversionRuleCase_ == 6) {
          conversionRule_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The prebuilt rule name that can convert a specific type of raw_json.
     * For example: "ga4_bq" rule for the GA4 user event schema.
     * </pre>
     *
     * <code>string prebuilt_rule = 6;</code>
     *
     * @return The bytes for prebuiltRule.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPrebuiltRuleBytes() {
      java.lang.Object ref = "";
      if (conversionRuleCase_ == 6) {
        ref = conversionRule_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (conversionRuleCase_ == 6) {
          conversionRule_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The prebuilt rule name that can convert a specific type of raw_json.
     * For example: "ga4_bq" rule for the GA4 user event schema.
     * </pre>
     *
     * <code>string prebuilt_rule = 6;</code>
     *
     * @param value The prebuiltRule to set.
     * @return This builder for chaining.
     */
    public Builder setPrebuiltRule(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      conversionRuleCase_ = 6;
      conversionRule_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The prebuilt rule name that can convert a specific type of raw_json.
     * For example: "ga4_bq" rule for the GA4 user event schema.
     * </pre>
     *
     * <code>string prebuilt_rule = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrebuiltRule() {
      if (conversionRuleCase_ == 6) {
        conversionRuleCase_ = 0;
        conversionRule_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The prebuilt rule name that can convert a specific type of raw_json.
     * For example: "ga4_bq" rule for the GA4 user event schema.
     * </pre>
     *
     * <code>string prebuilt_rule = 6;</code>
     *
     * @param value The bytes for prebuiltRule to set.
     * @return This builder for chaining.
     */
    public Builder setPrebuiltRuleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      conversionRuleCase_ = 6;
      conversionRule_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The parent catalog name, such as
     * `projects/1234/locations/global/catalogs/default_catalog`.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent catalog name, such as
     * `projects/1234/locations/global/catalogs/default_catalog`.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent catalog name, such as
     * `projects/1234/locations/global/catalogs/default_catalog`.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent catalog name, such as
     * `projects/1234/locations/global/catalogs/default_catalog`.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent catalog name, such as
     * `projects/1234/locations/global/catalogs/default_catalog`.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object userEvent_ = "";
    /**
     *
     *
     * <pre>
     * Required. URL encoded UserEvent proto with a length limit of 2,000,000
     * characters.
     * </pre>
     *
     * <code>string user_event = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The userEvent.
     */
    public java.lang.String getUserEvent() {
      java.lang.Object ref = userEvent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        userEvent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. URL encoded UserEvent proto with a length limit of 2,000,000
     * characters.
     * </pre>
     *
     * <code>string user_event = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for userEvent.
     */
    public com.google.protobuf.ByteString getUserEventBytes() {
      java.lang.Object ref = userEvent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        userEvent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. URL encoded UserEvent proto with a length limit of 2,000,000
     * characters.
     * </pre>
     *
     * <code>string user_event = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The userEvent to set.
     * @return This builder for chaining.
     */
    public Builder setUserEvent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      userEvent_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. URL encoded UserEvent proto with a length limit of 2,000,000
     * characters.
     * </pre>
     *
     * <code>string user_event = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserEvent() {
      userEvent_ = getDefaultInstance().getUserEvent();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. URL encoded UserEvent proto with a length limit of 2,000,000
     * characters.
     * </pre>
     *
     * <code>string user_event = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for userEvent to set.
     * @return This builder for chaining.
     */
    public Builder setUserEventBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      userEvent_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * The URL including cgi-parameters but excluding the hash fragment with a
     * length limit of 5,000 characters. This is often more useful than the
     * referer URL, because many browsers only send the domain for 3rd party
     * requests.
     * </pre>
     *
     * <code>string uri = 3;</code>
     *
     * @return The uri.
     */
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL including cgi-parameters but excluding the hash fragment with a
     * length limit of 5,000 characters. This is often more useful than the
     * referer URL, because many browsers only send the domain for 3rd party
     * requests.
     * </pre>
     *
     * <code>string uri = 3;</code>
     *
     * @return The bytes for uri.
     */
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL including cgi-parameters but excluding the hash fragment with a
     * length limit of 5,000 characters. This is often more useful than the
     * referer URL, because many browsers only send the domain for 3rd party
     * requests.
     * </pre>
     *
     * <code>string uri = 3;</code>
     *
     * @param value The uri to set.
     * @return This builder for chaining.
     */
    public Builder setUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uri_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL including cgi-parameters but excluding the hash fragment with a
     * length limit of 5,000 characters. This is often more useful than the
     * referer URL, because many browsers only send the domain for 3rd party
     * requests.
     * </pre>
     *
     * <code>string uri = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUri() {
      uri_ = getDefaultInstance().getUri();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL including cgi-parameters but excluding the hash fragment with a
     * length limit of 5,000 characters. This is often more useful than the
     * referer URL, because many browsers only send the domain for 3rd party
     * requests.
     * </pre>
     *
     * <code>string uri = 3;</code>
     *
     * @param value The bytes for uri to set.
     * @return This builder for chaining.
     */
    public Builder setUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uri_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private long ets_;
    /**
     *
     *
     * <pre>
     * The event timestamp in milliseconds. This prevents browser caching of
     * otherwise identical get requests. The name is abbreviated to reduce the
     * payload bytes.
     * </pre>
     *
     * <code>int64 ets = 4;</code>
     *
     * @return The ets.
     */
    @java.lang.Override
    public long getEts() {
      return ets_;
    }
    /**
     *
     *
     * <pre>
     * The event timestamp in milliseconds. This prevents browser caching of
     * otherwise identical get requests. The name is abbreviated to reduce the
     * payload bytes.
     * </pre>
     *
     * <code>int64 ets = 4;</code>
     *
     * @param value The ets to set.
     * @return This builder for chaining.
     */
    public Builder setEts(long value) {

      ets_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The event timestamp in milliseconds. This prevents browser caching of
     * otherwise identical get requests. The name is abbreviated to reduce the
     * payload bytes.
     * </pre>
     *
     * <code>int64 ets = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEts() {
      bitField0_ = (bitField0_ & ~0x00000010);
      ets_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object rawJson_ = "";
    /**
     *
     *
     * <pre>
     * An arbitrary serialized JSON string that contains necessary information
     * that can comprise a user event. When this field is specified, the
     * user_event field will be ignored. Note: line-delimited JSON is not
     * supported, a single JSON only.
     * </pre>
     *
     * <code>string raw_json = 5;</code>
     *
     * @return The rawJson.
     */
    public java.lang.String getRawJson() {
      java.lang.Object ref = rawJson_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rawJson_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An arbitrary serialized JSON string that contains necessary information
     * that can comprise a user event. When this field is specified, the
     * user_event field will be ignored. Note: line-delimited JSON is not
     * supported, a single JSON only.
     * </pre>
     *
     * <code>string raw_json = 5;</code>
     *
     * @return The bytes for rawJson.
     */
    public com.google.protobuf.ByteString getRawJsonBytes() {
      java.lang.Object ref = rawJson_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rawJson_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An arbitrary serialized JSON string that contains necessary information
     * that can comprise a user event. When this field is specified, the
     * user_event field will be ignored. Note: line-delimited JSON is not
     * supported, a single JSON only.
     * </pre>
     *
     * <code>string raw_json = 5;</code>
     *
     * @param value The rawJson to set.
     * @return This builder for chaining.
     */
    public Builder setRawJson(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      rawJson_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An arbitrary serialized JSON string that contains necessary information
     * that can comprise a user event. When this field is specified, the
     * user_event field will be ignored. Note: line-delimited JSON is not
     * supported, a single JSON only.
     * </pre>
     *
     * <code>string raw_json = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRawJson() {
      rawJson_ = getDefaultInstance().getRawJson();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An arbitrary serialized JSON string that contains necessary information
     * that can comprise a user event. When this field is specified, the
     * user_event field will be ignored. Note: line-delimited JSON is not
     * supported, a single JSON only.
     * </pre>
     *
     * <code>string raw_json = 5;</code>
     *
     * @param value The bytes for rawJson to set.
     * @return This builder for chaining.
     */
    public Builder setRawJsonBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      rawJson_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.CollectUserEventRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.CollectUserEventRequest)
  private static final com.google.cloud.retail.v2.CollectUserEventRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2.CollectUserEventRequest();
  }

  public static com.google.cloud.retail.v2.CollectUserEventRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CollectUserEventRequest> PARSER =
      new com.google.protobuf.AbstractParser<CollectUserEventRequest>() {
        @java.lang.Override
        public CollectUserEventRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CollectUserEventRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CollectUserEventRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2.CollectUserEventRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
