/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2/model.proto

package com.google.cloud.retail.v2;

/**
 *
 *
 * <pre>
 * Metadata that describes the training and serving parameters of a
 * [Model][google.cloud.retail.v2.Model]. A
 * [Model][google.cloud.retail.v2.Model] can be associated with a
 * [ServingConfig][google.cloud.retail.v2.ServingConfig] and then queried
 * through the Predict API.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2.Model}
 */
public final class Model extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.Model)
    ModelOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Model.newBuilder() to construct.
  private Model(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Model() {
    name_ = "";
    displayName_ = "";
    trainingState_ = 0;
    servingState_ = 0;
    type_ = "";
    optimizationObjective_ = "";
    periodicTuningState_ = 0;
    tuningOperation_ = "";
    dataState_ = 0;
    filteringOption_ = 0;
    servingConfigLists_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Model();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2.ModelProto
        .internal_static_google_cloud_retail_v2_Model_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2.ModelProto
        .internal_static_google_cloud_retail_v2_Model_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2.Model.class, com.google.cloud.retail.v2.Model.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The serving state of the model.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.retail.v2.Model.ServingState}
   */
  public enum ServingState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified serving state.
     * </pre>
     *
     * <code>SERVING_STATE_UNSPECIFIED = 0;</code>
     */
    SERVING_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The model is not serving.
     * </pre>
     *
     * <code>INACTIVE = 1;</code>
     */
    INACTIVE(1),
    /**
     *
     *
     * <pre>
     * The model is serving and can be queried.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    ACTIVE(2),
    /**
     *
     *
     * <pre>
     * The model is trained on tuned hyperparameters and can be
     * queried.
     * </pre>
     *
     * <code>TUNED = 3;</code>
     */
    TUNED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified serving state.
     * </pre>
     *
     * <code>SERVING_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int SERVING_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The model is not serving.
     * </pre>
     *
     * <code>INACTIVE = 1;</code>
     */
    public static final int INACTIVE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The model is serving and can be queried.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    public static final int ACTIVE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The model is trained on tuned hyperparameters and can be
     * queried.
     * </pre>
     *
     * <code>TUNED = 3;</code>
     */
    public static final int TUNED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ServingState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ServingState forNumber(int value) {
      switch (value) {
        case 0:
          return SERVING_STATE_UNSPECIFIED;
        case 1:
          return INACTIVE;
        case 2:
          return ACTIVE;
        case 3:
          return TUNED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ServingState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ServingState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ServingState>() {
          public ServingState findValueByNumber(int number) {
            return ServingState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.retail.v2.Model.getDescriptor().getEnumTypes().get(0);
    }

    private static final ServingState[] VALUES = values();

    public static ServingState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ServingState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2.Model.ServingState)
  }

  /**
   *
   *
   * <pre>
   * The training state of the model.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.retail.v2.Model.TrainingState}
   */
  public enum TrainingState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified training state.
     * </pre>
     *
     * <code>TRAINING_STATE_UNSPECIFIED = 0;</code>
     */
    TRAINING_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The model training is paused.
     * </pre>
     *
     * <code>PAUSED = 1;</code>
     */
    PAUSED(1),
    /**
     *
     *
     * <pre>
     * The model is training.
     * </pre>
     *
     * <code>TRAINING = 2;</code>
     */
    TRAINING(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified training state.
     * </pre>
     *
     * <code>TRAINING_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int TRAINING_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The model training is paused.
     * </pre>
     *
     * <code>PAUSED = 1;</code>
     */
    public static final int PAUSED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The model is training.
     * </pre>
     *
     * <code>TRAINING = 2;</code>
     */
    public static final int TRAINING_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TrainingState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TrainingState forNumber(int value) {
      switch (value) {
        case 0:
          return TRAINING_STATE_UNSPECIFIED;
        case 1:
          return PAUSED;
        case 2:
          return TRAINING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TrainingState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TrainingState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<TrainingState>() {
          public TrainingState findValueByNumber(int number) {
            return TrainingState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.retail.v2.Model.getDescriptor().getEnumTypes().get(1);
    }

    private static final TrainingState[] VALUES = values();

    public static TrainingState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TrainingState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2.Model.TrainingState)
  }

  /**
   *
   *
   * <pre>
   * Describes whether periodic tuning is enabled for this model
   * or not. Periodic tuning is scheduled at most every three months. You can
   * start a tuning process manually by using the `TuneModel`
   * method, which starts a tuning process immediately and resets the quarterly
   * schedule. Enabling or disabling periodic tuning does not affect any
   * current tuning processes.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.retail.v2.Model.PeriodicTuningState}
   */
  public enum PeriodicTuningState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified default value, should never be explicitly set.
     * </pre>
     *
     * <code>PERIODIC_TUNING_STATE_UNSPECIFIED = 0;</code>
     */
    PERIODIC_TUNING_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The model has periodic tuning disabled. Tuning
     * can be reenabled by calling the `EnableModelPeriodicTuning`
     * method or by calling the `TuneModel` method.
     * </pre>
     *
     * <code>PERIODIC_TUNING_DISABLED = 1;</code>
     */
    PERIODIC_TUNING_DISABLED(1),
    /**
     *
     *
     * <pre>
     * The model cannot be tuned with periodic tuning OR the
     * `TuneModel` method. Hide the options in customer UI and
     * reject any requests through the backend self serve API.
     * </pre>
     *
     * <code>ALL_TUNING_DISABLED = 3;</code>
     */
    ALL_TUNING_DISABLED(3),
    /**
     *
     *
     * <pre>
     * The model has periodic tuning enabled. Tuning
     * can be disabled by calling the `DisableModelPeriodicTuning`
     * method.
     * </pre>
     *
     * <code>PERIODIC_TUNING_ENABLED = 2;</code>
     */
    PERIODIC_TUNING_ENABLED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified default value, should never be explicitly set.
     * </pre>
     *
     * <code>PERIODIC_TUNING_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int PERIODIC_TUNING_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The model has periodic tuning disabled. Tuning
     * can be reenabled by calling the `EnableModelPeriodicTuning`
     * method or by calling the `TuneModel` method.
     * </pre>
     *
     * <code>PERIODIC_TUNING_DISABLED = 1;</code>
     */
    public static final int PERIODIC_TUNING_DISABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The model cannot be tuned with periodic tuning OR the
     * `TuneModel` method. Hide the options in customer UI and
     * reject any requests through the backend self serve API.
     * </pre>
     *
     * <code>ALL_TUNING_DISABLED = 3;</code>
     */
    public static final int ALL_TUNING_DISABLED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The model has periodic tuning enabled. Tuning
     * can be disabled by calling the `DisableModelPeriodicTuning`
     * method.
     * </pre>
     *
     * <code>PERIODIC_TUNING_ENABLED = 2;</code>
     */
    public static final int PERIODIC_TUNING_ENABLED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PeriodicTuningState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PeriodicTuningState forNumber(int value) {
      switch (value) {
        case 0:
          return PERIODIC_TUNING_STATE_UNSPECIFIED;
        case 1:
          return PERIODIC_TUNING_DISABLED;
        case 3:
          return ALL_TUNING_DISABLED;
        case 2:
          return PERIODIC_TUNING_ENABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PeriodicTuningState>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PeriodicTuningState>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<PeriodicTuningState>() {
              public PeriodicTuningState findValueByNumber(int number) {
                return PeriodicTuningState.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.retail.v2.Model.getDescriptor().getEnumTypes().get(2);
    }

    private static final PeriodicTuningState[] VALUES = values();

    public static PeriodicTuningState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PeriodicTuningState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2.Model.PeriodicTuningState)
  }

  /**
   *
   *
   * <pre>
   * Describes whether this model have sufficient training data
   * to be continuously trained.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.retail.v2.Model.DataState}
   */
  public enum DataState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified default value, should never be explicitly set.
     * </pre>
     *
     * <code>DATA_STATE_UNSPECIFIED = 0;</code>
     */
    DATA_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The model has sufficient training data.
     * </pre>
     *
     * <code>DATA_OK = 1;</code>
     */
    DATA_OK(1),
    /**
     *
     *
     * <pre>
     * The model does not have sufficient training data. Error
     * messages can be queried via Stackdriver.
     * </pre>
     *
     * <code>DATA_ERROR = 2;</code>
     */
    DATA_ERROR(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified default value, should never be explicitly set.
     * </pre>
     *
     * <code>DATA_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int DATA_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The model has sufficient training data.
     * </pre>
     *
     * <code>DATA_OK = 1;</code>
     */
    public static final int DATA_OK_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The model does not have sufficient training data. Error
     * messages can be queried via Stackdriver.
     * </pre>
     *
     * <code>DATA_ERROR = 2;</code>
     */
    public static final int DATA_ERROR_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DataState forNumber(int value) {
      switch (value) {
        case 0:
          return DATA_STATE_UNSPECIFIED;
        case 1:
          return DATA_OK;
        case 2:
          return DATA_ERROR;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DataState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DataState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DataState>() {
          public DataState findValueByNumber(int number) {
            return DataState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.retail.v2.Model.getDescriptor().getEnumTypes().get(3);
    }

    private static final DataState[] VALUES = values();

    public static DataState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DataState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2.Model.DataState)
  }

  public interface ServingConfigListOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2.Model.ServingConfigList)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. A set of valid serving configs that may be used for
     * `PAGE_OPTIMIZATION`.
     * </pre>
     *
     * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the servingConfigIds.
     */
    java.util.List<java.lang.String> getServingConfigIdsList();
    /**
     *
     *
     * <pre>
     * Optional. A set of valid serving configs that may be used for
     * `PAGE_OPTIMIZATION`.
     * </pre>
     *
     * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of servingConfigIds.
     */
    int getServingConfigIdsCount();
    /**
     *
     *
     * <pre>
     * Optional. A set of valid serving configs that may be used for
     * `PAGE_OPTIMIZATION`.
     * </pre>
     *
     * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The servingConfigIds at the given index.
     */
    java.lang.String getServingConfigIds(int index);
    /**
     *
     *
     * <pre>
     * Optional. A set of valid serving configs that may be used for
     * `PAGE_OPTIMIZATION`.
     * </pre>
     *
     * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the servingConfigIds at the given index.
     */
    com.google.protobuf.ByteString getServingConfigIdsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Represents an ordered combination of valid serving configs, which
   * can be used for `PAGE_OPTIMIZATION` recommendations.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2.Model.ServingConfigList}
   */
  public static final class ServingConfigList extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.Model.ServingConfigList)
      ServingConfigListOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ServingConfigList.newBuilder() to construct.
    private ServingConfigList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ServingConfigList() {
      servingConfigIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ServingConfigList();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2.ModelProto
          .internal_static_google_cloud_retail_v2_Model_ServingConfigList_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2.ModelProto
          .internal_static_google_cloud_retail_v2_Model_ServingConfigList_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2.Model.ServingConfigList.class,
              com.google.cloud.retail.v2.Model.ServingConfigList.Builder.class);
    }

    public static final int SERVING_CONFIG_IDS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList servingConfigIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Optional. A set of valid serving configs that may be used for
     * `PAGE_OPTIMIZATION`.
     * </pre>
     *
     * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the servingConfigIds.
     */
    public com.google.protobuf.ProtocolStringList getServingConfigIdsList() {
      return servingConfigIds_;
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of valid serving configs that may be used for
     * `PAGE_OPTIMIZATION`.
     * </pre>
     *
     * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of servingConfigIds.
     */
    public int getServingConfigIdsCount() {
      return servingConfigIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of valid serving configs that may be used for
     * `PAGE_OPTIMIZATION`.
     * </pre>
     *
     * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The servingConfigIds at the given index.
     */
    public java.lang.String getServingConfigIds(int index) {
      return servingConfigIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of valid serving configs that may be used for
     * `PAGE_OPTIMIZATION`.
     * </pre>
     *
     * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the servingConfigIds at the given index.
     */
    public com.google.protobuf.ByteString getServingConfigIdsBytes(int index) {
      return servingConfigIds_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < servingConfigIds_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, servingConfigIds_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < servingConfigIds_.size(); i++) {
          dataSize += computeStringSizeNoTag(servingConfigIds_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getServingConfigIdsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2.Model.ServingConfigList)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2.Model.ServingConfigList other =
          (com.google.cloud.retail.v2.Model.ServingConfigList) obj;

      if (!getServingConfigIdsList().equals(other.getServingConfigIdsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getServingConfigIdsCount() > 0) {
        hash = (37 * hash) + SERVING_CONFIG_IDS_FIELD_NUMBER;
        hash = (53 * hash) + getServingConfigIdsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2.Model.ServingConfigList parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.Model.ServingConfigList parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.Model.ServingConfigList parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.Model.ServingConfigList parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.Model.ServingConfigList parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.Model.ServingConfigList parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.Model.ServingConfigList parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.Model.ServingConfigList parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.Model.ServingConfigList parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.Model.ServingConfigList parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.Model.ServingConfigList parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.Model.ServingConfigList parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.retail.v2.Model.ServingConfigList prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents an ordered combination of valid serving configs, which
     * can be used for `PAGE_OPTIMIZATION` recommendations.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2.Model.ServingConfigList}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.Model.ServingConfigList)
        com.google.cloud.retail.v2.Model.ServingConfigListOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2.ModelProto
            .internal_static_google_cloud_retail_v2_Model_ServingConfigList_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2.ModelProto
            .internal_static_google_cloud_retail_v2_Model_ServingConfigList_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2.Model.ServingConfigList.class,
                com.google.cloud.retail.v2.Model.ServingConfigList.Builder.class);
      }

      // Construct using com.google.cloud.retail.v2.Model.ServingConfigList.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        servingConfigIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2.ModelProto
            .internal_static_google_cloud_retail_v2_Model_ServingConfigList_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.Model.ServingConfigList getDefaultInstanceForType() {
        return com.google.cloud.retail.v2.Model.ServingConfigList.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.Model.ServingConfigList build() {
        com.google.cloud.retail.v2.Model.ServingConfigList result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.Model.ServingConfigList buildPartial() {
        com.google.cloud.retail.v2.Model.ServingConfigList result =
            new com.google.cloud.retail.v2.Model.ServingConfigList(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.retail.v2.Model.ServingConfigList result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          servingConfigIds_.makeImmutable();
          result.servingConfigIds_ = servingConfigIds_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2.Model.ServingConfigList) {
          return mergeFrom((com.google.cloud.retail.v2.Model.ServingConfigList) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.retail.v2.Model.ServingConfigList other) {
        if (other == com.google.cloud.retail.v2.Model.ServingConfigList.getDefaultInstance())
          return this;
        if (!other.servingConfigIds_.isEmpty()) {
          if (servingConfigIds_.isEmpty()) {
            servingConfigIds_ = other.servingConfigIds_;
            bitField0_ |= 0x00000001;
          } else {
            ensureServingConfigIdsIsMutable();
            servingConfigIds_.addAll(other.servingConfigIds_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureServingConfigIdsIsMutable();
                  servingConfigIds_.add(s);
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList servingConfigIds_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureServingConfigIdsIsMutable() {
        if (!servingConfigIds_.isModifiable()) {
          servingConfigIds_ = new com.google.protobuf.LazyStringArrayList(servingConfigIds_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * Optional. A set of valid serving configs that may be used for
       * `PAGE_OPTIMIZATION`.
       * </pre>
       *
       * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the servingConfigIds.
       */
      public com.google.protobuf.ProtocolStringList getServingConfigIdsList() {
        servingConfigIds_.makeImmutable();
        return servingConfigIds_;
      }
      /**
       *
       *
       * <pre>
       * Optional. A set of valid serving configs that may be used for
       * `PAGE_OPTIMIZATION`.
       * </pre>
       *
       * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The count of servingConfigIds.
       */
      public int getServingConfigIdsCount() {
        return servingConfigIds_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. A set of valid serving configs that may be used for
       * `PAGE_OPTIMIZATION`.
       * </pre>
       *
       * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The servingConfigIds at the given index.
       */
      public java.lang.String getServingConfigIds(int index) {
        return servingConfigIds_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. A set of valid serving configs that may be used for
       * `PAGE_OPTIMIZATION`.
       * </pre>
       *
       * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the servingConfigIds at the given index.
       */
      public com.google.protobuf.ByteString getServingConfigIdsBytes(int index) {
        return servingConfigIds_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. A set of valid serving configs that may be used for
       * `PAGE_OPTIMIZATION`.
       * </pre>
       *
       * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The servingConfigIds to set.
       * @return This builder for chaining.
       */
      public Builder setServingConfigIds(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServingConfigIdsIsMutable();
        servingConfigIds_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A set of valid serving configs that may be used for
       * `PAGE_OPTIMIZATION`.
       * </pre>
       *
       * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The servingConfigIds to add.
       * @return This builder for chaining.
       */
      public Builder addServingConfigIds(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServingConfigIdsIsMutable();
        servingConfigIds_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A set of valid serving configs that may be used for
       * `PAGE_OPTIMIZATION`.
       * </pre>
       *
       * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param values The servingConfigIds to add.
       * @return This builder for chaining.
       */
      public Builder addAllServingConfigIds(java.lang.Iterable<java.lang.String> values) {
        ensureServingConfigIdsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, servingConfigIds_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A set of valid serving configs that may be used for
       * `PAGE_OPTIMIZATION`.
       * </pre>
       *
       * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearServingConfigIds() {
        servingConfigIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A set of valid serving configs that may be used for
       * `PAGE_OPTIMIZATION`.
       * </pre>
       *
       * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The bytes of the servingConfigIds to add.
       * @return This builder for chaining.
       */
      public Builder addServingConfigIdsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureServingConfigIdsIsMutable();
        servingConfigIds_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.Model.ServingConfigList)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.Model.ServingConfigList)
    private static final com.google.cloud.retail.v2.Model.ServingConfigList DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2.Model.ServingConfigList();
    }

    public static com.google.cloud.retail.v2.Model.ServingConfigList getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ServingConfigList> PARSER =
        new com.google.protobuf.AbstractParser<ServingConfigList>() {
          @java.lang.Override
          public ServingConfigList parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ServingConfigList> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ServingConfigList> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.Model.ServingConfigList getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The fully qualified resource name of the model.
   *
   * Format:
   * `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{model_id}`
   * catalog_id has char limit of 50.
   * recommendation_model_id has char limit of 40.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The fully qualified resource name of the model.
   *
   * Format:
   * `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{model_id}`
   * catalog_id has char limit of 50.
   * recommendation_model_id has char limit of 40.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The display name of the model.
   *
   * Should be human readable, used to display Recommendation Models in the
   * Retail Cloud Console Dashboard. UTF-8 encoded string with limit of 1024
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The display name of the model.
   *
   * Should be human readable, used to display Recommendation Models in the
   * Retail Cloud Console Dashboard. UTF-8 encoded string with limit of 1024
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRAINING_STATE_FIELD_NUMBER = 3;
  private int trainingState_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The training state that the model is in (e.g.
   * `TRAINING` or `PAUSED`).
   *
   * Since part of the cost of running the service
   * is frequency of training - this can be used to determine when to train
   * model in order to control cost. If not specified: the default value for
   * `CreateModel` method is `TRAINING`. The default value for
   * `UpdateModel` method is to keep the state the same as before.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2.Model.TrainingState training_state = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for trainingState.
   */
  @java.lang.Override
  public int getTrainingStateValue() {
    return trainingState_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The training state that the model is in (e.g.
   * `TRAINING` or `PAUSED`).
   *
   * Since part of the cost of running the service
   * is frequency of training - this can be used to determine when to train
   * model in order to control cost. If not specified: the default value for
   * `CreateModel` method is `TRAINING`. The default value for
   * `UpdateModel` method is to keep the state the same as before.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2.Model.TrainingState training_state = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The trainingState.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.Model.TrainingState getTrainingState() {
    com.google.cloud.retail.v2.Model.TrainingState result =
        com.google.cloud.retail.v2.Model.TrainingState.forNumber(trainingState_);
    return result == null ? com.google.cloud.retail.v2.Model.TrainingState.UNRECOGNIZED : result;
  }

  public static final int SERVING_STATE_FIELD_NUMBER = 4;
  private int servingState_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The serving state of the model: `ACTIVE`, `NOT_ACTIVE`.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2.Model.ServingState serving_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for servingState.
   */
  @java.lang.Override
  public int getServingStateValue() {
    return servingState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The serving state of the model: `ACTIVE`, `NOT_ACTIVE`.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2.Model.ServingState serving_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The servingState.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.Model.ServingState getServingState() {
    com.google.cloud.retail.v2.Model.ServingState result =
        com.google.cloud.retail.v2.Model.ServingState.forNumber(servingState_);
    return result == null ? com.google.cloud.retail.v2.Model.ServingState.UNRECOGNIZED : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the Recommendation Model was created at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the Recommendation Model was created at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the Recommendation Model was created at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the Recommendation Model was last updated. E.g.
   * if a Recommendation Model was paused - this would be the time the pause was
   * initiated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the Recommendation Model was last updated. E.g.
   * if a Recommendation Model was paused - this would be the time the pause was
   * initiated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the Recommendation Model was last updated. E.g.
   * if a Recommendation Model was paused - this would be the time the pause was
   * initiated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int TYPE_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";
  /**
   *
   *
   * <pre>
   * Required. The type of model e.g. `home-page`.
   *
   * Currently supported values: `recommended-for-you`, `others-you-may-like`,
   * `frequently-bought-together`, `page-optimization`, `similar-items`,
   * `buy-it-again`, `on-sale-items`, and `recently-viewed`(readonly value).
   *
   *
   * This field together with
   * [optimization_objective][google.cloud.retail.v2.Model.optimization_objective]
   * describe model metadata to use to control model training and serving.
   * See https://cloud.google.com/retail/docs/models
   * for more details on what the model metadata control and which combination
   * of parameters are valid. For invalid combinations of parameters (e.g. type
   * = `frequently-bought-together` and optimization_objective = `ctr`), you
   * receive an error 400 if you try to create/update a recommendation with
   * this set of knobs.
   * </pre>
   *
   * <code>string type = 7 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The type of model e.g. `home-page`.
   *
   * Currently supported values: `recommended-for-you`, `others-you-may-like`,
   * `frequently-bought-together`, `page-optimization`, `similar-items`,
   * `buy-it-again`, `on-sale-items`, and `recently-viewed`(readonly value).
   *
   *
   * This field together with
   * [optimization_objective][google.cloud.retail.v2.Model.optimization_objective]
   * describe model metadata to use to control model training and serving.
   * See https://cloud.google.com/retail/docs/models
   * for more details on what the model metadata control and which combination
   * of parameters are valid. For invalid combinations of parameters (e.g. type
   * = `frequently-bought-together` and optimization_objective = `ctr`), you
   * receive an error 400 if you try to create/update a recommendation with
   * this set of knobs.
   * </pre>
   *
   * <code>string type = 7 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OPTIMIZATION_OBJECTIVE_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object optimizationObjective_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The optimization objective e.g. `cvr`.
   *
   * Currently supported
   * values: `ctr`, `cvr`, `revenue-per-order`.
   *
   *  If not specified, we choose default based on model type.
   * Default depends on type of recommendation:
   *
   * `recommended-for-you` =&gt; `ctr`
   *
   * `others-you-may-like` =&gt; `ctr`
   *
   * `frequently-bought-together` =&gt; `revenue_per_order`
   *
   * This field together with
   * [optimization_objective][google.cloud.retail.v2.Model.type]
   * describe model metadata to use to control model training and serving.
   * See https://cloud.google.com/retail/docs/models
   * for more details on what the model metadata control and which combination
   * of parameters are valid. For invalid combinations of parameters (e.g. type
   * = `frequently-bought-together` and optimization_objective = `ctr`), you
   * receive an error 400 if you try to create/update a recommendation with
   * this set of knobs.
   * </pre>
   *
   * <code>string optimization_objective = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The optimizationObjective.
   */
  @java.lang.Override
  public java.lang.String getOptimizationObjective() {
    java.lang.Object ref = optimizationObjective_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      optimizationObjective_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The optimization objective e.g. `cvr`.
   *
   * Currently supported
   * values: `ctr`, `cvr`, `revenue-per-order`.
   *
   *  If not specified, we choose default based on model type.
   * Default depends on type of recommendation:
   *
   * `recommended-for-you` =&gt; `ctr`
   *
   * `others-you-may-like` =&gt; `ctr`
   *
   * `frequently-bought-together` =&gt; `revenue_per_order`
   *
   * This field together with
   * [optimization_objective][google.cloud.retail.v2.Model.type]
   * describe model metadata to use to control model training and serving.
   * See https://cloud.google.com/retail/docs/models
   * for more details on what the model metadata control and which combination
   * of parameters are valid. For invalid combinations of parameters (e.g. type
   * = `frequently-bought-together` and optimization_objective = `ctr`), you
   * receive an error 400 if you try to create/update a recommendation with
   * this set of knobs.
   * </pre>
   *
   * <code>string optimization_objective = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for optimizationObjective.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOptimizationObjectiveBytes() {
    java.lang.Object ref = optimizationObjective_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      optimizationObjective_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PERIODIC_TUNING_STATE_FIELD_NUMBER = 11;
  private int periodicTuningState_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The state of periodic tuning.
   *
   * The period we use is 3 months - to do a
   * one-off tune earlier use the `TuneModel` method. Default value
   * is `PERIODIC_TUNING_ENABLED`.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2.Model.PeriodicTuningState periodic_tuning_state = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for periodicTuningState.
   */
  @java.lang.Override
  public int getPeriodicTuningStateValue() {
    return periodicTuningState_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The state of periodic tuning.
   *
   * The period we use is 3 months - to do a
   * one-off tune earlier use the `TuneModel` method. Default value
   * is `PERIODIC_TUNING_ENABLED`.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2.Model.PeriodicTuningState periodic_tuning_state = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The periodicTuningState.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.Model.PeriodicTuningState getPeriodicTuningState() {
    com.google.cloud.retail.v2.Model.PeriodicTuningState result =
        com.google.cloud.retail.v2.Model.PeriodicTuningState.forNumber(periodicTuningState_);
    return result == null
        ? com.google.cloud.retail.v2.Model.PeriodicTuningState.UNRECOGNIZED
        : result;
  }

  public static final int LAST_TUNE_TIME_FIELD_NUMBER = 12;
  private com.google.protobuf.Timestamp lastTuneTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the latest successful tune finished.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_tune_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lastTuneTime field is set.
   */
  @java.lang.Override
  public boolean hasLastTuneTime() {
    return lastTuneTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the latest successful tune finished.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_tune_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastTuneTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastTuneTime() {
    return lastTuneTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastTuneTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the latest successful tune finished.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_tune_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastTuneTimeOrBuilder() {
    return lastTuneTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastTuneTime_;
  }

  public static final int TUNING_OPERATION_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tuningOperation_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The tune operation associated with the model.
   *
   * Can be used to determine if there is an ongoing tune for this
   * recommendation. Empty field implies no tune is goig on.
   * </pre>
   *
   * <code>string tuning_operation = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The tuningOperation.
   */
  @java.lang.Override
  public java.lang.String getTuningOperation() {
    java.lang.Object ref = tuningOperation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tuningOperation_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The tune operation associated with the model.
   *
   * Can be used to determine if there is an ongoing tune for this
   * recommendation. Empty field implies no tune is goig on.
   * </pre>
   *
   * <code>string tuning_operation = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for tuningOperation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTuningOperationBytes() {
    java.lang.Object ref = tuningOperation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tuningOperation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_STATE_FIELD_NUMBER = 16;
  private int dataState_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The state of data requirements for this model: `DATA_OK` and
   * `DATA_ERROR`.
   *
   * Recommendation model cannot be trained if the data is in
   * `DATA_ERROR` state. Recommendation model can have `DATA_ERROR` state even
   * if serving state is `ACTIVE`: models were trained successfully before, but
   * cannot be refreshed because model no longer has sufficient
   * data for training.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2.Model.DataState data_state = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for dataState.
   */
  @java.lang.Override
  public int getDataStateValue() {
    return dataState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The state of data requirements for this model: `DATA_OK` and
   * `DATA_ERROR`.
   *
   * Recommendation model cannot be trained if the data is in
   * `DATA_ERROR` state. Recommendation model can have `DATA_ERROR` state even
   * if serving state is `ACTIVE`: models were trained successfully before, but
   * cannot be refreshed because model no longer has sufficient
   * data for training.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2.Model.DataState data_state = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The dataState.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.Model.DataState getDataState() {
    com.google.cloud.retail.v2.Model.DataState result =
        com.google.cloud.retail.v2.Model.DataState.forNumber(dataState_);
    return result == null ? com.google.cloud.retail.v2.Model.DataState.UNRECOGNIZED : result;
  }

  public static final int FILTERING_OPTION_FIELD_NUMBER = 18;
  private int filteringOption_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. If `RECOMMENDATIONS_FILTERING_ENABLED`, recommendation filtering
   * by attributes is enabled for the model.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2.RecommendationsFilteringOption filtering_option = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for filteringOption.
   */
  @java.lang.Override
  public int getFilteringOptionValue() {
    return filteringOption_;
  }
  /**
   *
   *
   * <pre>
   * Optional. If `RECOMMENDATIONS_FILTERING_ENABLED`, recommendation filtering
   * by attributes is enabled for the model.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2.RecommendationsFilteringOption filtering_option = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The filteringOption.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.RecommendationsFilteringOption getFilteringOption() {
    com.google.cloud.retail.v2.RecommendationsFilteringOption result =
        com.google.cloud.retail.v2.RecommendationsFilteringOption.forNumber(filteringOption_);
    return result == null
        ? com.google.cloud.retail.v2.RecommendationsFilteringOption.UNRECOGNIZED
        : result;
  }

  public static final int SERVING_CONFIG_LISTS_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.retail.v2.Model.ServingConfigList> servingConfigLists_;
  /**
   *
   *
   * <pre>
   * Output only. The list of valid serving configs associated with the
   * PageOptimizationConfig.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2.Model.ServingConfigList>
      getServingConfigListsList() {
    return servingConfigLists_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The list of valid serving configs associated with the
   * PageOptimizationConfig.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.retail.v2.Model.ServingConfigListOrBuilder>
      getServingConfigListsOrBuilderList() {
    return servingConfigLists_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The list of valid serving configs associated with the
   * PageOptimizationConfig.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getServingConfigListsCount() {
    return servingConfigLists_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The list of valid serving configs associated with the
   * PageOptimizationConfig.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.Model.ServingConfigList getServingConfigLists(int index) {
    return servingConfigLists_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The list of valid serving configs associated with the
   * PageOptimizationConfig.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.Model.ServingConfigListOrBuilder getServingConfigListsOrBuilder(
      int index) {
    return servingConfigLists_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (trainingState_
        != com.google.cloud.retail.v2.Model.TrainingState.TRAINING_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, trainingState_);
    }
    if (servingState_
        != com.google.cloud.retail.v2.Model.ServingState.SERVING_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, servingState_);
    }
    if (createTime_ != null) {
      output.writeMessage(5, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(6, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(optimizationObjective_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, optimizationObjective_);
    }
    if (periodicTuningState_
        != com.google.cloud.retail.v2.Model.PeriodicTuningState.PERIODIC_TUNING_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(11, periodicTuningState_);
    }
    if (lastTuneTime_ != null) {
      output.writeMessage(12, getLastTuneTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tuningOperation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, tuningOperation_);
    }
    if (dataState_
        != com.google.cloud.retail.v2.Model.DataState.DATA_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(16, dataState_);
    }
    if (filteringOption_
        != com.google.cloud.retail.v2.RecommendationsFilteringOption
            .RECOMMENDATIONS_FILTERING_OPTION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(18, filteringOption_);
    }
    for (int i = 0; i < servingConfigLists_.size(); i++) {
      output.writeMessage(19, servingConfigLists_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (trainingState_
        != com.google.cloud.retail.v2.Model.TrainingState.TRAINING_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, trainingState_);
    }
    if (servingState_
        != com.google.cloud.retail.v2.Model.ServingState.SERVING_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, servingState_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(optimizationObjective_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, optimizationObjective_);
    }
    if (periodicTuningState_
        != com.google.cloud.retail.v2.Model.PeriodicTuningState.PERIODIC_TUNING_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(11, periodicTuningState_);
    }
    if (lastTuneTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getLastTuneTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tuningOperation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, tuningOperation_);
    }
    if (dataState_
        != com.google.cloud.retail.v2.Model.DataState.DATA_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(16, dataState_);
    }
    if (filteringOption_
        != com.google.cloud.retail.v2.RecommendationsFilteringOption
            .RECOMMENDATIONS_FILTERING_OPTION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(18, filteringOption_);
    }
    for (int i = 0; i < servingConfigLists_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(19, servingConfigLists_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2.Model)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2.Model other = (com.google.cloud.retail.v2.Model) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (trainingState_ != other.trainingState_) return false;
    if (servingState_ != other.servingState_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getType().equals(other.getType())) return false;
    if (!getOptimizationObjective().equals(other.getOptimizationObjective())) return false;
    if (periodicTuningState_ != other.periodicTuningState_) return false;
    if (hasLastTuneTime() != other.hasLastTuneTime()) return false;
    if (hasLastTuneTime()) {
      if (!getLastTuneTime().equals(other.getLastTuneTime())) return false;
    }
    if (!getTuningOperation().equals(other.getTuningOperation())) return false;
    if (dataState_ != other.dataState_) return false;
    if (filteringOption_ != other.filteringOption_) return false;
    if (!getServingConfigListsList().equals(other.getServingConfigListsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + TRAINING_STATE_FIELD_NUMBER;
    hash = (53 * hash) + trainingState_;
    hash = (37 * hash) + SERVING_STATE_FIELD_NUMBER;
    hash = (53 * hash) + servingState_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getType().hashCode();
    hash = (37 * hash) + OPTIMIZATION_OBJECTIVE_FIELD_NUMBER;
    hash = (53 * hash) + getOptimizationObjective().hashCode();
    hash = (37 * hash) + PERIODIC_TUNING_STATE_FIELD_NUMBER;
    hash = (53 * hash) + periodicTuningState_;
    if (hasLastTuneTime()) {
      hash = (37 * hash) + LAST_TUNE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastTuneTime().hashCode();
    }
    hash = (37 * hash) + TUNING_OPERATION_FIELD_NUMBER;
    hash = (53 * hash) + getTuningOperation().hashCode();
    hash = (37 * hash) + DATA_STATE_FIELD_NUMBER;
    hash = (53 * hash) + dataState_;
    hash = (37 * hash) + FILTERING_OPTION_FIELD_NUMBER;
    hash = (53 * hash) + filteringOption_;
    if (getServingConfigListsCount() > 0) {
      hash = (37 * hash) + SERVING_CONFIG_LISTS_FIELD_NUMBER;
      hash = (53 * hash) + getServingConfigListsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2.Model parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.Model parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.Model parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.Model parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.Model parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.Model parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.Model parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.Model parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.Model parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.Model parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.Model parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.Model parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2.Model prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata that describes the training and serving parameters of a
   * [Model][google.cloud.retail.v2.Model]. A
   * [Model][google.cloud.retail.v2.Model] can be associated with a
   * [ServingConfig][google.cloud.retail.v2.ServingConfig] and then queried
   * through the Predict API.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2.Model}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.Model)
      com.google.cloud.retail.v2.ModelOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2.ModelProto
          .internal_static_google_cloud_retail_v2_Model_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2.ModelProto
          .internal_static_google_cloud_retail_v2_Model_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2.Model.class,
              com.google.cloud.retail.v2.Model.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2.Model.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      trainingState_ = 0;
      servingState_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      type_ = "";
      optimizationObjective_ = "";
      periodicTuningState_ = 0;
      lastTuneTime_ = null;
      if (lastTuneTimeBuilder_ != null) {
        lastTuneTimeBuilder_.dispose();
        lastTuneTimeBuilder_ = null;
      }
      tuningOperation_ = "";
      dataState_ = 0;
      filteringOption_ = 0;
      if (servingConfigListsBuilder_ == null) {
        servingConfigLists_ = java.util.Collections.emptyList();
      } else {
        servingConfigLists_ = null;
        servingConfigListsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00002000);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2.ModelProto
          .internal_static_google_cloud_retail_v2_Model_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.Model getDefaultInstanceForType() {
      return com.google.cloud.retail.v2.Model.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.Model build() {
      com.google.cloud.retail.v2.Model result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.Model buildPartial() {
      com.google.cloud.retail.v2.Model result = new com.google.cloud.retail.v2.Model(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.retail.v2.Model result) {
      if (servingConfigListsBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)) {
          servingConfigLists_ = java.util.Collections.unmodifiableList(servingConfigLists_);
          bitField0_ = (bitField0_ & ~0x00002000);
        }
        result.servingConfigLists_ = servingConfigLists_;
      } else {
        result.servingConfigLists_ = servingConfigListsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.retail.v2.Model result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.trainingState_ = trainingState_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.servingState_ = servingState_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.optimizationObjective_ = optimizationObjective_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.periodicTuningState_ = periodicTuningState_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.lastTuneTime_ =
            lastTuneTimeBuilder_ == null ? lastTuneTime_ : lastTuneTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.tuningOperation_ = tuningOperation_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.dataState_ = dataState_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.filteringOption_ = filteringOption_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2.Model) {
        return mergeFrom((com.google.cloud.retail.v2.Model) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2.Model other) {
      if (other == com.google.cloud.retail.v2.Model.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.trainingState_ != 0) {
        setTrainingStateValue(other.getTrainingStateValue());
      }
      if (other.servingState_ != 0) {
        setServingStateValue(other.getServingStateValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getType().isEmpty()) {
        type_ = other.type_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getOptimizationObjective().isEmpty()) {
        optimizationObjective_ = other.optimizationObjective_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.periodicTuningState_ != 0) {
        setPeriodicTuningStateValue(other.getPeriodicTuningStateValue());
      }
      if (other.hasLastTuneTime()) {
        mergeLastTuneTime(other.getLastTuneTime());
      }
      if (!other.getTuningOperation().isEmpty()) {
        tuningOperation_ = other.tuningOperation_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.dataState_ != 0) {
        setDataStateValue(other.getDataStateValue());
      }
      if (other.filteringOption_ != 0) {
        setFilteringOptionValue(other.getFilteringOptionValue());
      }
      if (servingConfigListsBuilder_ == null) {
        if (!other.servingConfigLists_.isEmpty()) {
          if (servingConfigLists_.isEmpty()) {
            servingConfigLists_ = other.servingConfigLists_;
            bitField0_ = (bitField0_ & ~0x00002000);
          } else {
            ensureServingConfigListsIsMutable();
            servingConfigLists_.addAll(other.servingConfigLists_);
          }
          onChanged();
        }
      } else {
        if (!other.servingConfigLists_.isEmpty()) {
          if (servingConfigListsBuilder_.isEmpty()) {
            servingConfigListsBuilder_.dispose();
            servingConfigListsBuilder_ = null;
            servingConfigLists_ = other.servingConfigLists_;
            bitField0_ = (bitField0_ & ~0x00002000);
            servingConfigListsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getServingConfigListsFieldBuilder()
                    : null;
          } else {
            servingConfigListsBuilder_.addAllMessages(other.servingConfigLists_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                trainingState_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                servingState_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                type_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                optimizationObjective_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 88:
              {
                periodicTuningState_ = input.readEnum();
                bitField0_ |= 0x00000100;
                break;
              } // case 88
            case 98:
              {
                input.readMessage(getLastTuneTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 98
            case 122:
              {
                tuningOperation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 122
            case 128:
              {
                dataState_ = input.readEnum();
                bitField0_ |= 0x00000800;
                break;
              } // case 128
            case 144:
              {
                filteringOption_ = input.readEnum();
                bitField0_ |= 0x00001000;
                break;
              } // case 144
            case 154:
              {
                com.google.cloud.retail.v2.Model.ServingConfigList m =
                    input.readMessage(
                        com.google.cloud.retail.v2.Model.ServingConfigList.parser(),
                        extensionRegistry);
                if (servingConfigListsBuilder_ == null) {
                  ensureServingConfigListsIsMutable();
                  servingConfigLists_.add(m);
                } else {
                  servingConfigListsBuilder_.addMessage(m);
                }
                break;
              } // case 154
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The fully qualified resource name of the model.
     *
     * Format:
     * `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{model_id}`
     * catalog_id has char limit of 50.
     * recommendation_model_id has char limit of 40.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The fully qualified resource name of the model.
     *
     * Format:
     * `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{model_id}`
     * catalog_id has char limit of 50.
     * recommendation_model_id has char limit of 40.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The fully qualified resource name of the model.
     *
     * Format:
     * `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{model_id}`
     * catalog_id has char limit of 50.
     * recommendation_model_id has char limit of 40.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The fully qualified resource name of the model.
     *
     * Format:
     * `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{model_id}`
     * catalog_id has char limit of 50.
     * recommendation_model_id has char limit of 40.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The fully qualified resource name of the model.
     *
     * Format:
     * `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{model_id}`
     * catalog_id has char limit of 50.
     * recommendation_model_id has char limit of 40.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The display name of the model.
     *
     * Should be human readable, used to display Recommendation Models in the
     * Retail Cloud Console Dashboard. UTF-8 encoded string with limit of 1024
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the model.
     *
     * Should be human readable, used to display Recommendation Models in the
     * Retail Cloud Console Dashboard. UTF-8 encoded string with limit of 1024
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the model.
     *
     * Should be human readable, used to display Recommendation Models in the
     * Retail Cloud Console Dashboard. UTF-8 encoded string with limit of 1024
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the model.
     *
     * Should be human readable, used to display Recommendation Models in the
     * Retail Cloud Console Dashboard. UTF-8 encoded string with limit of 1024
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the model.
     *
     * Should be human readable, used to display Recommendation Models in the
     * Retail Cloud Console Dashboard. UTF-8 encoded string with limit of 1024
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int trainingState_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The training state that the model is in (e.g.
     * `TRAINING` or `PAUSED`).
     *
     * Since part of the cost of running the service
     * is frequency of training - this can be used to determine when to train
     * model in order to control cost. If not specified: the default value for
     * `CreateModel` method is `TRAINING`. The default value for
     * `UpdateModel` method is to keep the state the same as before.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.Model.TrainingState training_state = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for trainingState.
     */
    @java.lang.Override
    public int getTrainingStateValue() {
      return trainingState_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The training state that the model is in (e.g.
     * `TRAINING` or `PAUSED`).
     *
     * Since part of the cost of running the service
     * is frequency of training - this can be used to determine when to train
     * model in order to control cost. If not specified: the default value for
     * `CreateModel` method is `TRAINING`. The default value for
     * `UpdateModel` method is to keep the state the same as before.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.Model.TrainingState training_state = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for trainingState to set.
     * @return This builder for chaining.
     */
    public Builder setTrainingStateValue(int value) {
      trainingState_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The training state that the model is in (e.g.
     * `TRAINING` or `PAUSED`).
     *
     * Since part of the cost of running the service
     * is frequency of training - this can be used to determine when to train
     * model in order to control cost. If not specified: the default value for
     * `CreateModel` method is `TRAINING`. The default value for
     * `UpdateModel` method is to keep the state the same as before.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.Model.TrainingState training_state = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The trainingState.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.Model.TrainingState getTrainingState() {
      com.google.cloud.retail.v2.Model.TrainingState result =
          com.google.cloud.retail.v2.Model.TrainingState.forNumber(trainingState_);
      return result == null ? com.google.cloud.retail.v2.Model.TrainingState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The training state that the model is in (e.g.
     * `TRAINING` or `PAUSED`).
     *
     * Since part of the cost of running the service
     * is frequency of training - this can be used to determine when to train
     * model in order to control cost. If not specified: the default value for
     * `CreateModel` method is `TRAINING`. The default value for
     * `UpdateModel` method is to keep the state the same as before.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.Model.TrainingState training_state = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The trainingState to set.
     * @return This builder for chaining.
     */
    public Builder setTrainingState(com.google.cloud.retail.v2.Model.TrainingState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      trainingState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The training state that the model is in (e.g.
     * `TRAINING` or `PAUSED`).
     *
     * Since part of the cost of running the service
     * is frequency of training - this can be used to determine when to train
     * model in order to control cost. If not specified: the default value for
     * `CreateModel` method is `TRAINING`. The default value for
     * `UpdateModel` method is to keep the state the same as before.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.Model.TrainingState training_state = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTrainingState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      trainingState_ = 0;
      onChanged();
      return this;
    }

    private int servingState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The serving state of the model: `ACTIVE`, `NOT_ACTIVE`.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.Model.ServingState serving_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for servingState.
     */
    @java.lang.Override
    public int getServingStateValue() {
      return servingState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The serving state of the model: `ACTIVE`, `NOT_ACTIVE`.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.Model.ServingState serving_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for servingState to set.
     * @return This builder for chaining.
     */
    public Builder setServingStateValue(int value) {
      servingState_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The serving state of the model: `ACTIVE`, `NOT_ACTIVE`.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.Model.ServingState serving_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The servingState.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.Model.ServingState getServingState() {
      com.google.cloud.retail.v2.Model.ServingState result =
          com.google.cloud.retail.v2.Model.ServingState.forNumber(servingState_);
      return result == null ? com.google.cloud.retail.v2.Model.ServingState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The serving state of the model: `ACTIVE`, `NOT_ACTIVE`.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.Model.ServingState serving_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The servingState to set.
     * @return This builder for chaining.
     */
    public Builder setServingState(com.google.cloud.retail.v2.Model.ServingState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      servingState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The serving state of the model: `ACTIVE`, `NOT_ACTIVE`.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.Model.ServingState serving_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServingState() {
      bitField0_ = (bitField0_ & ~0x00000008);
      servingState_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was last updated. E.g.
     * if a Recommendation Model was paused - this would be the time the pause was
     * initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was last updated. E.g.
     * if a Recommendation Model was paused - this would be the time the pause was
     * initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was last updated. E.g.
     * if a Recommendation Model was paused - this would be the time the pause was
     * initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was last updated. E.g.
     * if a Recommendation Model was paused - this would be the time the pause was
     * initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was last updated. E.g.
     * if a Recommendation Model was paused - this would be the time the pause was
     * initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was last updated. E.g.
     * if a Recommendation Model was paused - this would be the time the pause was
     * initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was last updated. E.g.
     * if a Recommendation Model was paused - this would be the time the pause was
     * initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was last updated. E.g.
     * if a Recommendation Model was paused - this would be the time the pause was
     * initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was last updated. E.g.
     * if a Recommendation Model was paused - this would be the time the pause was
     * initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * Required. The type of model e.g. `home-page`.
     *
     * Currently supported values: `recommended-for-you`, `others-you-may-like`,
     * `frequently-bought-together`, `page-optimization`, `similar-items`,
     * `buy-it-again`, `on-sale-items`, and `recently-viewed`(readonly value).
     *
     *
     * This field together with
     * [optimization_objective][google.cloud.retail.v2.Model.optimization_objective]
     * describe model metadata to use to control model training and serving.
     * See https://cloud.google.com/retail/docs/models
     * for more details on what the model metadata control and which combination
     * of parameters are valid. For invalid combinations of parameters (e.g. type
     * = `frequently-bought-together` and optimization_objective = `ctr`), you
     * receive an error 400 if you try to create/update a recommendation with
     * this set of knobs.
     * </pre>
     *
     * <code>string type = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The type of model e.g. `home-page`.
     *
     * Currently supported values: `recommended-for-you`, `others-you-may-like`,
     * `frequently-bought-together`, `page-optimization`, `similar-items`,
     * `buy-it-again`, `on-sale-items`, and `recently-viewed`(readonly value).
     *
     *
     * This field together with
     * [optimization_objective][google.cloud.retail.v2.Model.optimization_objective]
     * describe model metadata to use to control model training and serving.
     * See https://cloud.google.com/retail/docs/models
     * for more details on what the model metadata control and which combination
     * of parameters are valid. For invalid combinations of parameters (e.g. type
     * = `frequently-bought-together` and optimization_objective = `ctr`), you
     * receive an error 400 if you try to create/update a recommendation with
     * this set of knobs.
     * </pre>
     *
     * <code>string type = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The type of model e.g. `home-page`.
     *
     * Currently supported values: `recommended-for-you`, `others-you-may-like`,
     * `frequently-bought-together`, `page-optimization`, `similar-items`,
     * `buy-it-again`, `on-sale-items`, and `recently-viewed`(readonly value).
     *
     *
     * This field together with
     * [optimization_objective][google.cloud.retail.v2.Model.optimization_objective]
     * describe model metadata to use to control model training and serving.
     * See https://cloud.google.com/retail/docs/models
     * for more details on what the model metadata control and which combination
     * of parameters are valid. For invalid combinations of parameters (e.g. type
     * = `frequently-bought-together` and optimization_objective = `ctr`), you
     * receive an error 400 if you try to create/update a recommendation with
     * this set of knobs.
     * </pre>
     *
     * <code>string type = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of model e.g. `home-page`.
     *
     * Currently supported values: `recommended-for-you`, `others-you-may-like`,
     * `frequently-bought-together`, `page-optimization`, `similar-items`,
     * `buy-it-again`, `on-sale-items`, and `recently-viewed`(readonly value).
     *
     *
     * This field together with
     * [optimization_objective][google.cloud.retail.v2.Model.optimization_objective]
     * describe model metadata to use to control model training and serving.
     * See https://cloud.google.com/retail/docs/models
     * for more details on what the model metadata control and which combination
     * of parameters are valid. For invalid combinations of parameters (e.g. type
     * = `frequently-bought-together` and optimization_objective = `ctr`), you
     * receive an error 400 if you try to create/update a recommendation with
     * this set of knobs.
     * </pre>
     *
     * <code>string type = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of model e.g. `home-page`.
     *
     * Currently supported values: `recommended-for-you`, `others-you-may-like`,
     * `frequently-bought-together`, `page-optimization`, `similar-items`,
     * `buy-it-again`, `on-sale-items`, and `recently-viewed`(readonly value).
     *
     *
     * This field together with
     * [optimization_objective][google.cloud.retail.v2.Model.optimization_objective]
     * describe model metadata to use to control model training and serving.
     * See https://cloud.google.com/retail/docs/models
     * for more details on what the model metadata control and which combination
     * of parameters are valid. For invalid combinations of parameters (e.g. type
     * = `frequently-bought-together` and optimization_objective = `ctr`), you
     * receive an error 400 if you try to create/update a recommendation with
     * this set of knobs.
     * </pre>
     *
     * <code>string type = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object optimizationObjective_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The optimization objective e.g. `cvr`.
     *
     * Currently supported
     * values: `ctr`, `cvr`, `revenue-per-order`.
     *
     *  If not specified, we choose default based on model type.
     * Default depends on type of recommendation:
     *
     * `recommended-for-you` =&gt; `ctr`
     *
     * `others-you-may-like` =&gt; `ctr`
     *
     * `frequently-bought-together` =&gt; `revenue_per_order`
     *
     * This field together with
     * [optimization_objective][google.cloud.retail.v2.Model.type]
     * describe model metadata to use to control model training and serving.
     * See https://cloud.google.com/retail/docs/models
     * for more details on what the model metadata control and which combination
     * of parameters are valid. For invalid combinations of parameters (e.g. type
     * = `frequently-bought-together` and optimization_objective = `ctr`), you
     * receive an error 400 if you try to create/update a recommendation with
     * this set of knobs.
     * </pre>
     *
     * <code>string optimization_objective = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The optimizationObjective.
     */
    public java.lang.String getOptimizationObjective() {
      java.lang.Object ref = optimizationObjective_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        optimizationObjective_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The optimization objective e.g. `cvr`.
     *
     * Currently supported
     * values: `ctr`, `cvr`, `revenue-per-order`.
     *
     *  If not specified, we choose default based on model type.
     * Default depends on type of recommendation:
     *
     * `recommended-for-you` =&gt; `ctr`
     *
     * `others-you-may-like` =&gt; `ctr`
     *
     * `frequently-bought-together` =&gt; `revenue_per_order`
     *
     * This field together with
     * [optimization_objective][google.cloud.retail.v2.Model.type]
     * describe model metadata to use to control model training and serving.
     * See https://cloud.google.com/retail/docs/models
     * for more details on what the model metadata control and which combination
     * of parameters are valid. For invalid combinations of parameters (e.g. type
     * = `frequently-bought-together` and optimization_objective = `ctr`), you
     * receive an error 400 if you try to create/update a recommendation with
     * this set of knobs.
     * </pre>
     *
     * <code>string optimization_objective = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for optimizationObjective.
     */
    public com.google.protobuf.ByteString getOptimizationObjectiveBytes() {
      java.lang.Object ref = optimizationObjective_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        optimizationObjective_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The optimization objective e.g. `cvr`.
     *
     * Currently supported
     * values: `ctr`, `cvr`, `revenue-per-order`.
     *
     *  If not specified, we choose default based on model type.
     * Default depends on type of recommendation:
     *
     * `recommended-for-you` =&gt; `ctr`
     *
     * `others-you-may-like` =&gt; `ctr`
     *
     * `frequently-bought-together` =&gt; `revenue_per_order`
     *
     * This field together with
     * [optimization_objective][google.cloud.retail.v2.Model.type]
     * describe model metadata to use to control model training and serving.
     * See https://cloud.google.com/retail/docs/models
     * for more details on what the model metadata control and which combination
     * of parameters are valid. For invalid combinations of parameters (e.g. type
     * = `frequently-bought-together` and optimization_objective = `ctr`), you
     * receive an error 400 if you try to create/update a recommendation with
     * this set of knobs.
     * </pre>
     *
     * <code>string optimization_objective = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The optimizationObjective to set.
     * @return This builder for chaining.
     */
    public Builder setOptimizationObjective(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      optimizationObjective_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The optimization objective e.g. `cvr`.
     *
     * Currently supported
     * values: `ctr`, `cvr`, `revenue-per-order`.
     *
     *  If not specified, we choose default based on model type.
     * Default depends on type of recommendation:
     *
     * `recommended-for-you` =&gt; `ctr`
     *
     * `others-you-may-like` =&gt; `ctr`
     *
     * `frequently-bought-together` =&gt; `revenue_per_order`
     *
     * This field together with
     * [optimization_objective][google.cloud.retail.v2.Model.type]
     * describe model metadata to use to control model training and serving.
     * See https://cloud.google.com/retail/docs/models
     * for more details on what the model metadata control and which combination
     * of parameters are valid. For invalid combinations of parameters (e.g. type
     * = `frequently-bought-together` and optimization_objective = `ctr`), you
     * receive an error 400 if you try to create/update a recommendation with
     * this set of knobs.
     * </pre>
     *
     * <code>string optimization_objective = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOptimizationObjective() {
      optimizationObjective_ = getDefaultInstance().getOptimizationObjective();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The optimization objective e.g. `cvr`.
     *
     * Currently supported
     * values: `ctr`, `cvr`, `revenue-per-order`.
     *
     *  If not specified, we choose default based on model type.
     * Default depends on type of recommendation:
     *
     * `recommended-for-you` =&gt; `ctr`
     *
     * `others-you-may-like` =&gt; `ctr`
     *
     * `frequently-bought-together` =&gt; `revenue_per_order`
     *
     * This field together with
     * [optimization_objective][google.cloud.retail.v2.Model.type]
     * describe model metadata to use to control model training and serving.
     * See https://cloud.google.com/retail/docs/models
     * for more details on what the model metadata control and which combination
     * of parameters are valid. For invalid combinations of parameters (e.g. type
     * = `frequently-bought-together` and optimization_objective = `ctr`), you
     * receive an error 400 if you try to create/update a recommendation with
     * this set of knobs.
     * </pre>
     *
     * <code>string optimization_objective = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for optimizationObjective to set.
     * @return This builder for chaining.
     */
    public Builder setOptimizationObjectiveBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      optimizationObjective_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private int periodicTuningState_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The state of periodic tuning.
     *
     * The period we use is 3 months - to do a
     * one-off tune earlier use the `TuneModel` method. Default value
     * is `PERIODIC_TUNING_ENABLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.Model.PeriodicTuningState periodic_tuning_state = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for periodicTuningState.
     */
    @java.lang.Override
    public int getPeriodicTuningStateValue() {
      return periodicTuningState_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The state of periodic tuning.
     *
     * The period we use is 3 months - to do a
     * one-off tune earlier use the `TuneModel` method. Default value
     * is `PERIODIC_TUNING_ENABLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.Model.PeriodicTuningState periodic_tuning_state = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for periodicTuningState to set.
     * @return This builder for chaining.
     */
    public Builder setPeriodicTuningStateValue(int value) {
      periodicTuningState_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The state of periodic tuning.
     *
     * The period we use is 3 months - to do a
     * one-off tune earlier use the `TuneModel` method. Default value
     * is `PERIODIC_TUNING_ENABLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.Model.PeriodicTuningState periodic_tuning_state = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The periodicTuningState.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.Model.PeriodicTuningState getPeriodicTuningState() {
      com.google.cloud.retail.v2.Model.PeriodicTuningState result =
          com.google.cloud.retail.v2.Model.PeriodicTuningState.forNumber(periodicTuningState_);
      return result == null
          ? com.google.cloud.retail.v2.Model.PeriodicTuningState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The state of periodic tuning.
     *
     * The period we use is 3 months - to do a
     * one-off tune earlier use the `TuneModel` method. Default value
     * is `PERIODIC_TUNING_ENABLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.Model.PeriodicTuningState periodic_tuning_state = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The periodicTuningState to set.
     * @return This builder for chaining.
     */
    public Builder setPeriodicTuningState(
        com.google.cloud.retail.v2.Model.PeriodicTuningState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000100;
      periodicTuningState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The state of periodic tuning.
     *
     * The period we use is 3 months - to do a
     * one-off tune earlier use the `TuneModel` method. Default value
     * is `PERIODIC_TUNING_ENABLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.Model.PeriodicTuningState periodic_tuning_state = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPeriodicTuningState() {
      bitField0_ = (bitField0_ & ~0x00000100);
      periodicTuningState_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp lastTuneTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastTuneTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the latest successful tune finished.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_tune_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastTuneTime field is set.
     */
    public boolean hasLastTuneTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the latest successful tune finished.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_tune_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastTuneTime.
     */
    public com.google.protobuf.Timestamp getLastTuneTime() {
      if (lastTuneTimeBuilder_ == null) {
        return lastTuneTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastTuneTime_;
      } else {
        return lastTuneTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the latest successful tune finished.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_tune_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastTuneTime(com.google.protobuf.Timestamp value) {
      if (lastTuneTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastTuneTime_ = value;
      } else {
        lastTuneTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the latest successful tune finished.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_tune_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastTuneTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastTuneTimeBuilder_ == null) {
        lastTuneTime_ = builderForValue.build();
      } else {
        lastTuneTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the latest successful tune finished.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_tune_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLastTuneTime(com.google.protobuf.Timestamp value) {
      if (lastTuneTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && lastTuneTime_ != null
            && lastTuneTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastTuneTimeBuilder().mergeFrom(value);
        } else {
          lastTuneTime_ = value;
        }
      } else {
        lastTuneTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the latest successful tune finished.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_tune_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLastTuneTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      lastTuneTime_ = null;
      if (lastTuneTimeBuilder_ != null) {
        lastTuneTimeBuilder_.dispose();
        lastTuneTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the latest successful tune finished.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_tune_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getLastTuneTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getLastTuneTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the latest successful tune finished.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_tune_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastTuneTimeOrBuilder() {
      if (lastTuneTimeBuilder_ != null) {
        return lastTuneTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastTuneTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastTuneTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the latest successful tune finished.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_tune_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastTuneTimeFieldBuilder() {
      if (lastTuneTimeBuilder_ == null) {
        lastTuneTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastTuneTime(), getParentForChildren(), isClean());
        lastTuneTime_ = null;
      }
      return lastTuneTimeBuilder_;
    }

    private java.lang.Object tuningOperation_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The tune operation associated with the model.
     *
     * Can be used to determine if there is an ongoing tune for this
     * recommendation. Empty field implies no tune is goig on.
     * </pre>
     *
     * <code>string tuning_operation = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The tuningOperation.
     */
    public java.lang.String getTuningOperation() {
      java.lang.Object ref = tuningOperation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tuningOperation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The tune operation associated with the model.
     *
     * Can be used to determine if there is an ongoing tune for this
     * recommendation. Empty field implies no tune is goig on.
     * </pre>
     *
     * <code>string tuning_operation = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for tuningOperation.
     */
    public com.google.protobuf.ByteString getTuningOperationBytes() {
      java.lang.Object ref = tuningOperation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tuningOperation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The tune operation associated with the model.
     *
     * Can be used to determine if there is an ongoing tune for this
     * recommendation. Empty field implies no tune is goig on.
     * </pre>
     *
     * <code>string tuning_operation = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The tuningOperation to set.
     * @return This builder for chaining.
     */
    public Builder setTuningOperation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tuningOperation_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The tune operation associated with the model.
     *
     * Can be used to determine if there is an ongoing tune for this
     * recommendation. Empty field implies no tune is goig on.
     * </pre>
     *
     * <code>string tuning_operation = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTuningOperation() {
      tuningOperation_ = getDefaultInstance().getTuningOperation();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The tune operation associated with the model.
     *
     * Can be used to determine if there is an ongoing tune for this
     * recommendation. Empty field implies no tune is goig on.
     * </pre>
     *
     * <code>string tuning_operation = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for tuningOperation to set.
     * @return This builder for chaining.
     */
    public Builder setTuningOperationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tuningOperation_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private int dataState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The state of data requirements for this model: `DATA_OK` and
     * `DATA_ERROR`.
     *
     * Recommendation model cannot be trained if the data is in
     * `DATA_ERROR` state. Recommendation model can have `DATA_ERROR` state even
     * if serving state is `ACTIVE`: models were trained successfully before, but
     * cannot be refreshed because model no longer has sufficient
     * data for training.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.Model.DataState data_state = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for dataState.
     */
    @java.lang.Override
    public int getDataStateValue() {
      return dataState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of data requirements for this model: `DATA_OK` and
     * `DATA_ERROR`.
     *
     * Recommendation model cannot be trained if the data is in
     * `DATA_ERROR` state. Recommendation model can have `DATA_ERROR` state even
     * if serving state is `ACTIVE`: models were trained successfully before, but
     * cannot be refreshed because model no longer has sufficient
     * data for training.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.Model.DataState data_state = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for dataState to set.
     * @return This builder for chaining.
     */
    public Builder setDataStateValue(int value) {
      dataState_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of data requirements for this model: `DATA_OK` and
     * `DATA_ERROR`.
     *
     * Recommendation model cannot be trained if the data is in
     * `DATA_ERROR` state. Recommendation model can have `DATA_ERROR` state even
     * if serving state is `ACTIVE`: models were trained successfully before, but
     * cannot be refreshed because model no longer has sufficient
     * data for training.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.Model.DataState data_state = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The dataState.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.Model.DataState getDataState() {
      com.google.cloud.retail.v2.Model.DataState result =
          com.google.cloud.retail.v2.Model.DataState.forNumber(dataState_);
      return result == null ? com.google.cloud.retail.v2.Model.DataState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of data requirements for this model: `DATA_OK` and
     * `DATA_ERROR`.
     *
     * Recommendation model cannot be trained if the data is in
     * `DATA_ERROR` state. Recommendation model can have `DATA_ERROR` state even
     * if serving state is `ACTIVE`: models were trained successfully before, but
     * cannot be refreshed because model no longer has sufficient
     * data for training.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.Model.DataState data_state = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The dataState to set.
     * @return This builder for chaining.
     */
    public Builder setDataState(com.google.cloud.retail.v2.Model.DataState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000800;
      dataState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of data requirements for this model: `DATA_OK` and
     * `DATA_ERROR`.
     *
     * Recommendation model cannot be trained if the data is in
     * `DATA_ERROR` state. Recommendation model can have `DATA_ERROR` state even
     * if serving state is `ACTIVE`: models were trained successfully before, but
     * cannot be refreshed because model no longer has sufficient
     * data for training.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.Model.DataState data_state = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataState() {
      bitField0_ = (bitField0_ & ~0x00000800);
      dataState_ = 0;
      onChanged();
      return this;
    }

    private int filteringOption_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. If `RECOMMENDATIONS_FILTERING_ENABLED`, recommendation filtering
     * by attributes is enabled for the model.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.RecommendationsFilteringOption filtering_option = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for filteringOption.
     */
    @java.lang.Override
    public int getFilteringOptionValue() {
      return filteringOption_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If `RECOMMENDATIONS_FILTERING_ENABLED`, recommendation filtering
     * by attributes is enabled for the model.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.RecommendationsFilteringOption filtering_option = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for filteringOption to set.
     * @return This builder for chaining.
     */
    public Builder setFilteringOptionValue(int value) {
      filteringOption_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If `RECOMMENDATIONS_FILTERING_ENABLED`, recommendation filtering
     * by attributes is enabled for the model.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.RecommendationsFilteringOption filtering_option = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The filteringOption.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.RecommendationsFilteringOption getFilteringOption() {
      com.google.cloud.retail.v2.RecommendationsFilteringOption result =
          com.google.cloud.retail.v2.RecommendationsFilteringOption.forNumber(filteringOption_);
      return result == null
          ? com.google.cloud.retail.v2.RecommendationsFilteringOption.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. If `RECOMMENDATIONS_FILTERING_ENABLED`, recommendation filtering
     * by attributes is enabled for the model.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.RecommendationsFilteringOption filtering_option = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The filteringOption to set.
     * @return This builder for chaining.
     */
    public Builder setFilteringOption(
        com.google.cloud.retail.v2.RecommendationsFilteringOption value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00001000;
      filteringOption_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If `RECOMMENDATIONS_FILTERING_ENABLED`, recommendation filtering
     * by attributes is enabled for the model.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.RecommendationsFilteringOption filtering_option = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilteringOption() {
      bitField0_ = (bitField0_ & ~0x00001000);
      filteringOption_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.retail.v2.Model.ServingConfigList> servingConfigLists_ =
        java.util.Collections.emptyList();

    private void ensureServingConfigListsIsMutable() {
      if (!((bitField0_ & 0x00002000) != 0)) {
        servingConfigLists_ =
            new java.util.ArrayList<com.google.cloud.retail.v2.Model.ServingConfigList>(
                servingConfigLists_);
        bitField0_ |= 0x00002000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2.Model.ServingConfigList,
            com.google.cloud.retail.v2.Model.ServingConfigList.Builder,
            com.google.cloud.retail.v2.Model.ServingConfigListOrBuilder>
        servingConfigListsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.retail.v2.Model.ServingConfigList>
        getServingConfigListsList() {
      if (servingConfigListsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(servingConfigLists_);
      } else {
        return servingConfigListsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getServingConfigListsCount() {
      if (servingConfigListsBuilder_ == null) {
        return servingConfigLists_.size();
      } else {
        return servingConfigListsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2.Model.ServingConfigList getServingConfigLists(int index) {
      if (servingConfigListsBuilder_ == null) {
        return servingConfigLists_.get(index);
      } else {
        return servingConfigListsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setServingConfigLists(
        int index, com.google.cloud.retail.v2.Model.ServingConfigList value) {
      if (servingConfigListsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServingConfigListsIsMutable();
        servingConfigLists_.set(index, value);
        onChanged();
      } else {
        servingConfigListsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setServingConfigLists(
        int index, com.google.cloud.retail.v2.Model.ServingConfigList.Builder builderForValue) {
      if (servingConfigListsBuilder_ == null) {
        ensureServingConfigListsIsMutable();
        servingConfigLists_.set(index, builderForValue.build());
        onChanged();
      } else {
        servingConfigListsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addServingConfigLists(com.google.cloud.retail.v2.Model.ServingConfigList value) {
      if (servingConfigListsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServingConfigListsIsMutable();
        servingConfigLists_.add(value);
        onChanged();
      } else {
        servingConfigListsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addServingConfigLists(
        int index, com.google.cloud.retail.v2.Model.ServingConfigList value) {
      if (servingConfigListsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServingConfigListsIsMutable();
        servingConfigLists_.add(index, value);
        onChanged();
      } else {
        servingConfigListsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addServingConfigLists(
        com.google.cloud.retail.v2.Model.ServingConfigList.Builder builderForValue) {
      if (servingConfigListsBuilder_ == null) {
        ensureServingConfigListsIsMutable();
        servingConfigLists_.add(builderForValue.build());
        onChanged();
      } else {
        servingConfigListsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addServingConfigLists(
        int index, com.google.cloud.retail.v2.Model.ServingConfigList.Builder builderForValue) {
      if (servingConfigListsBuilder_ == null) {
        ensureServingConfigListsIsMutable();
        servingConfigLists_.add(index, builderForValue.build());
        onChanged();
      } else {
        servingConfigListsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllServingConfigLists(
        java.lang.Iterable<? extends com.google.cloud.retail.v2.Model.ServingConfigList> values) {
      if (servingConfigListsBuilder_ == null) {
        ensureServingConfigListsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, servingConfigLists_);
        onChanged();
      } else {
        servingConfigListsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearServingConfigLists() {
      if (servingConfigListsBuilder_ == null) {
        servingConfigLists_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00002000);
        onChanged();
      } else {
        servingConfigListsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeServingConfigLists(int index) {
      if (servingConfigListsBuilder_ == null) {
        ensureServingConfigListsIsMutable();
        servingConfigLists_.remove(index);
        onChanged();
      } else {
        servingConfigListsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2.Model.ServingConfigList.Builder getServingConfigListsBuilder(
        int index) {
      return getServingConfigListsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2.Model.ServingConfigListOrBuilder
        getServingConfigListsOrBuilder(int index) {
      if (servingConfigListsBuilder_ == null) {
        return servingConfigLists_.get(index);
      } else {
        return servingConfigListsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.retail.v2.Model.ServingConfigListOrBuilder>
        getServingConfigListsOrBuilderList() {
      if (servingConfigListsBuilder_ != null) {
        return servingConfigListsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(servingConfigLists_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2.Model.ServingConfigList.Builder
        addServingConfigListsBuilder() {
      return getServingConfigListsFieldBuilder()
          .addBuilder(com.google.cloud.retail.v2.Model.ServingConfigList.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2.Model.ServingConfigList.Builder addServingConfigListsBuilder(
        int index) {
      return getServingConfigListsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.retail.v2.Model.ServingConfigList.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.retail.v2.Model.ServingConfigList.Builder>
        getServingConfigListsBuilderList() {
      return getServingConfigListsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2.Model.ServingConfigList,
            com.google.cloud.retail.v2.Model.ServingConfigList.Builder,
            com.google.cloud.retail.v2.Model.ServingConfigListOrBuilder>
        getServingConfigListsFieldBuilder() {
      if (servingConfigListsBuilder_ == null) {
        servingConfigListsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2.Model.ServingConfigList,
                com.google.cloud.retail.v2.Model.ServingConfigList.Builder,
                com.google.cloud.retail.v2.Model.ServingConfigListOrBuilder>(
                servingConfigLists_,
                ((bitField0_ & 0x00002000) != 0),
                getParentForChildren(),
                isClean());
        servingConfigLists_ = null;
      }
      return servingConfigListsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.Model)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.Model)
  private static final com.google.cloud.retail.v2.Model DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2.Model();
  }

  public static com.google.cloud.retail.v2.Model getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Model> PARSER =
      new com.google.protobuf.AbstractParser<Model>() {
        @java.lang.Override
        public Model parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Model> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Model> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2.Model getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
