/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2/control.proto

package com.google.cloud.retail.v2;

/**
 *
 *
 * <pre>
 * Configures dynamic metadata that can be linked to a
 * [ServingConfig][google.cloud.retail.v2.ServingConfig] and affect search or
 * recommendation results at serving time.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2.Control}
 */
public final class Control extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.Control)
    ControlOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Control.newBuilder() to construct.
  private Control(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Control() {
    name_ = "";
    displayName_ = "";
    associatedServingConfigIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    solutionTypes_ = java.util.Collections.emptyList();
    searchSolutionUseCase_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Control();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2.ControlProto
        .internal_static_google_cloud_retail_v2_Control_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2.ControlProto
        .internal_static_google_cloud_retail_v2_Control_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2.Control.class,
            com.google.cloud.retail.v2.Control.Builder.class);
  }

  private int controlCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object control_;

  public enum ControlCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    RULE(4),
    CONTROL_NOT_SET(0);
    private final int value;

    private ControlCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ControlCase valueOf(int value) {
      return forNumber(value);
    }

    public static ControlCase forNumber(int value) {
      switch (value) {
        case 4:
          return RULE;
        case 0:
          return CONTROL_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ControlCase getControlCase() {
    return ControlCase.forNumber(controlCase_);
  }

  public static final int RULE_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * A rule control - a condition-action pair.
   * Enacts a set action when the condition is triggered.
   * For example: Boost "gShoe" when query full matches "Running Shoes".
   * </pre>
   *
   * <code>.google.cloud.retail.v2.Rule rule = 4;</code>
   *
   * @return Whether the rule field is set.
   */
  @java.lang.Override
  public boolean hasRule() {
    return controlCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * A rule control - a condition-action pair.
   * Enacts a set action when the condition is triggered.
   * For example: Boost "gShoe" when query full matches "Running Shoes".
   * </pre>
   *
   * <code>.google.cloud.retail.v2.Rule rule = 4;</code>
   *
   * @return The rule.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.Rule getRule() {
    if (controlCase_ == 4) {
      return (com.google.cloud.retail.v2.Rule) control_;
    }
    return com.google.cloud.retail.v2.Rule.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A rule control - a condition-action pair.
   * Enacts a set action when the condition is triggered.
   * For example: Boost "gShoe" when query full matches "Running Shoes".
   * </pre>
   *
   * <code>.google.cloud.retail.v2.Rule rule = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.RuleOrBuilder getRuleOrBuilder() {
    if (controlCase_ == 4) {
      return (com.google.cloud.retail.v2.Rule) control_;
    }
    return com.google.cloud.retail.v2.Rule.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. Fully qualified name
   * `projects/&#42;&#47;locations/global/catalogs/&#42;&#47;controls/&#42;`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. Fully qualified name
   * `projects/&#42;&#47;locations/global/catalogs/&#42;&#47;controls/&#42;`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The human readable control display name. Used in Retail UI.
   *
   * This field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an INVALID_ARGUMENT error is thrown.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The human readable control display name. Used in Retail UI.
   *
   * This field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an INVALID_ARGUMENT error is thrown.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ASSOCIATED_SERVING_CONFIG_IDS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList associatedServingConfigIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. List of [serving config][google.cloud.retail.v2.ServingConfig]
   * ids that are associated with this control in the same
   * [Catalog][google.cloud.retail.v2.Catalog].
   *
   * Note the association is managed via the
   * [ServingConfig][google.cloud.retail.v2.ServingConfig], this is an output
   * only denormalized view.
   * </pre>
   *
   * <code>
   * repeated string associated_serving_config_ids = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the associatedServingConfigIds.
   */
  public com.google.protobuf.ProtocolStringList getAssociatedServingConfigIdsList() {
    return associatedServingConfigIds_;
  }
  /**
   *
   *
   * <pre>
   * Output only. List of [serving config][google.cloud.retail.v2.ServingConfig]
   * ids that are associated with this control in the same
   * [Catalog][google.cloud.retail.v2.Catalog].
   *
   * Note the association is managed via the
   * [ServingConfig][google.cloud.retail.v2.ServingConfig], this is an output
   * only denormalized view.
   * </pre>
   *
   * <code>
   * repeated string associated_serving_config_ids = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of associatedServingConfigIds.
   */
  public int getAssociatedServingConfigIdsCount() {
    return associatedServingConfigIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. List of [serving config][google.cloud.retail.v2.ServingConfig]
   * ids that are associated with this control in the same
   * [Catalog][google.cloud.retail.v2.Catalog].
   *
   * Note the association is managed via the
   * [ServingConfig][google.cloud.retail.v2.ServingConfig], this is an output
   * only denormalized view.
   * </pre>
   *
   * <code>
   * repeated string associated_serving_config_ids = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The associatedServingConfigIds at the given index.
   */
  public java.lang.String getAssociatedServingConfigIds(int index) {
    return associatedServingConfigIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. List of [serving config][google.cloud.retail.v2.ServingConfig]
   * ids that are associated with this control in the same
   * [Catalog][google.cloud.retail.v2.Catalog].
   *
   * Note the association is managed via the
   * [ServingConfig][google.cloud.retail.v2.ServingConfig], this is an output
   * only denormalized view.
   * </pre>
   *
   * <code>
   * repeated string associated_serving_config_ids = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the associatedServingConfigIds at the given index.
   */
  public com.google.protobuf.ByteString getAssociatedServingConfigIdsBytes(int index) {
    return associatedServingConfigIds_.getByteString(index);
  }

  public static final int SOLUTION_TYPES_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> solutionTypes_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.retail.v2.SolutionType>
      solutionTypes_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.retail.v2.SolutionType>() {
            public com.google.cloud.retail.v2.SolutionType convert(java.lang.Integer from) {
              com.google.cloud.retail.v2.SolutionType result =
                  com.google.cloud.retail.v2.SolutionType.forNumber(from);
              return result == null ? com.google.cloud.retail.v2.SolutionType.UNRECOGNIZED : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Required. Immutable. The solution types that the control is used for.
   * Currently we support setting only one type of solution at creation time.
   *
   * Only `SOLUTION_TYPE_SEARCH` value is supported at the moment.
   * If no solution type is provided at creation time, will default to
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.SolutionType solution_types = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return A list containing the solutionTypes.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2.SolutionType> getSolutionTypesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.retail.v2.SolutionType>(
        solutionTypes_, solutionTypes_converter_);
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. The solution types that the control is used for.
   * Currently we support setting only one type of solution at creation time.
   *
   * Only `SOLUTION_TYPE_SEARCH` value is supported at the moment.
   * If no solution type is provided at creation time, will default to
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.SolutionType solution_types = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The count of solutionTypes.
   */
  @java.lang.Override
  public int getSolutionTypesCount() {
    return solutionTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. The solution types that the control is used for.
   * Currently we support setting only one type of solution at creation time.
   *
   * Only `SOLUTION_TYPE_SEARCH` value is supported at the moment.
   * If no solution type is provided at creation time, will default to
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.SolutionType solution_types = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The solutionTypes at the given index.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.SolutionType getSolutionTypes(int index) {
    return solutionTypes_converter_.convert(solutionTypes_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. The solution types that the control is used for.
   * Currently we support setting only one type of solution at creation time.
   *
   * Only `SOLUTION_TYPE_SEARCH` value is supported at the moment.
   * If no solution type is provided at creation time, will default to
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.SolutionType solution_types = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for solutionTypes.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getSolutionTypesValueList() {
    return solutionTypes_;
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. The solution types that the control is used for.
   * Currently we support setting only one type of solution at creation time.
   *
   * Only `SOLUTION_TYPE_SEARCH` value is supported at the moment.
   * If no solution type is provided at creation time, will default to
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.SolutionType solution_types = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of solutionTypes at the given index.
   */
  @java.lang.Override
  public int getSolutionTypesValue(int index) {
    return solutionTypes_.get(index);
  }

  private int solutionTypesMemoizedSerializedSize;

  public static final int SEARCH_SOLUTION_USE_CASE_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> searchSolutionUseCase_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.retail.v2.SearchSolutionUseCase>
      searchSolutionUseCase_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.retail.v2.SearchSolutionUseCase>() {
            public com.google.cloud.retail.v2.SearchSolutionUseCase convert(
                java.lang.Integer from) {
              com.google.cloud.retail.v2.SearchSolutionUseCase result =
                  com.google.cloud.retail.v2.SearchSolutionUseCase.forNumber(from);
              return result == null
                  ? com.google.cloud.retail.v2.SearchSolutionUseCase.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Specifies the use case for the control.
   * Affects what condition fields can be set.
   * Only settable by search controls.
   * Will default to
   * [SEARCH_SOLUTION_USE_CASE_SEARCH][google.cloud.retail.v2.SearchSolutionUseCase.SEARCH_SOLUTION_USE_CASE_SEARCH]
   * if not specified. Currently only allow one search_solution_use_case per
   * control.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.SearchSolutionUseCase search_solution_use_case = 7;
   * </code>
   *
   * @return A list containing the searchSolutionUseCase.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2.SearchSolutionUseCase>
      getSearchSolutionUseCaseList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.retail.v2.SearchSolutionUseCase>(
        searchSolutionUseCase_, searchSolutionUseCase_converter_);
  }
  /**
   *
   *
   * <pre>
   * Specifies the use case for the control.
   * Affects what condition fields can be set.
   * Only settable by search controls.
   * Will default to
   * [SEARCH_SOLUTION_USE_CASE_SEARCH][google.cloud.retail.v2.SearchSolutionUseCase.SEARCH_SOLUTION_USE_CASE_SEARCH]
   * if not specified. Currently only allow one search_solution_use_case per
   * control.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.SearchSolutionUseCase search_solution_use_case = 7;
   * </code>
   *
   * @return The count of searchSolutionUseCase.
   */
  @java.lang.Override
  public int getSearchSolutionUseCaseCount() {
    return searchSolutionUseCase_.size();
  }
  /**
   *
   *
   * <pre>
   * Specifies the use case for the control.
   * Affects what condition fields can be set.
   * Only settable by search controls.
   * Will default to
   * [SEARCH_SOLUTION_USE_CASE_SEARCH][google.cloud.retail.v2.SearchSolutionUseCase.SEARCH_SOLUTION_USE_CASE_SEARCH]
   * if not specified. Currently only allow one search_solution_use_case per
   * control.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.SearchSolutionUseCase search_solution_use_case = 7;
   * </code>
   *
   * @param index The index of the element to return.
   * @return The searchSolutionUseCase at the given index.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.SearchSolutionUseCase getSearchSolutionUseCase(int index) {
    return searchSolutionUseCase_converter_.convert(searchSolutionUseCase_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Specifies the use case for the control.
   * Affects what condition fields can be set.
   * Only settable by search controls.
   * Will default to
   * [SEARCH_SOLUTION_USE_CASE_SEARCH][google.cloud.retail.v2.SearchSolutionUseCase.SEARCH_SOLUTION_USE_CASE_SEARCH]
   * if not specified. Currently only allow one search_solution_use_case per
   * control.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.SearchSolutionUseCase search_solution_use_case = 7;
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for searchSolutionUseCase.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getSearchSolutionUseCaseValueList() {
    return searchSolutionUseCase_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the use case for the control.
   * Affects what condition fields can be set.
   * Only settable by search controls.
   * Will default to
   * [SEARCH_SOLUTION_USE_CASE_SEARCH][google.cloud.retail.v2.SearchSolutionUseCase.SEARCH_SOLUTION_USE_CASE_SEARCH]
   * if not specified. Currently only allow one search_solution_use_case per
   * control.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.SearchSolutionUseCase search_solution_use_case = 7;
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of searchSolutionUseCase at the given index.
   */
  @java.lang.Override
  public int getSearchSolutionUseCaseValue(int index) {
    return searchSolutionUseCase_.get(index);
  }

  private int searchSolutionUseCaseMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (controlCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.retail.v2.Rule) control_);
    }
    for (int i = 0; i < associatedServingConfigIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 5, associatedServingConfigIds_.getRaw(i));
    }
    if (getSolutionTypesList().size() > 0) {
      output.writeUInt32NoTag(50);
      output.writeUInt32NoTag(solutionTypesMemoizedSerializedSize);
    }
    for (int i = 0; i < solutionTypes_.size(); i++) {
      output.writeEnumNoTag(solutionTypes_.get(i));
    }
    if (getSearchSolutionUseCaseList().size() > 0) {
      output.writeUInt32NoTag(58);
      output.writeUInt32NoTag(searchSolutionUseCaseMemoizedSerializedSize);
    }
    for (int i = 0; i < searchSolutionUseCase_.size(); i++) {
      output.writeEnumNoTag(searchSolutionUseCase_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (controlCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.retail.v2.Rule) control_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < associatedServingConfigIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(associatedServingConfigIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAssociatedServingConfigIdsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < solutionTypes_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(solutionTypes_.get(i));
      }
      size += dataSize;
      if (!getSolutionTypesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      solutionTypesMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      for (int i = 0; i < searchSolutionUseCase_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(
                searchSolutionUseCase_.get(i));
      }
      size += dataSize;
      if (!getSearchSolutionUseCaseList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      searchSolutionUseCaseMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2.Control)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2.Control other = (com.google.cloud.retail.v2.Control) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getAssociatedServingConfigIdsList().equals(other.getAssociatedServingConfigIdsList()))
      return false;
    if (!solutionTypes_.equals(other.solutionTypes_)) return false;
    if (!searchSolutionUseCase_.equals(other.searchSolutionUseCase_)) return false;
    if (!getControlCase().equals(other.getControlCase())) return false;
    switch (controlCase_) {
      case 4:
        if (!getRule().equals(other.getRule())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (getAssociatedServingConfigIdsCount() > 0) {
      hash = (37 * hash) + ASSOCIATED_SERVING_CONFIG_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getAssociatedServingConfigIdsList().hashCode();
    }
    if (getSolutionTypesCount() > 0) {
      hash = (37 * hash) + SOLUTION_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + solutionTypes_.hashCode();
    }
    if (getSearchSolutionUseCaseCount() > 0) {
      hash = (37 * hash) + SEARCH_SOLUTION_USE_CASE_FIELD_NUMBER;
      hash = (53 * hash) + searchSolutionUseCase_.hashCode();
    }
    switch (controlCase_) {
      case 4:
        hash = (37 * hash) + RULE_FIELD_NUMBER;
        hash = (53 * hash) + getRule().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2.Control parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.Control parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.Control parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.Control parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.Control parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.Control parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.Control parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.Control parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.Control parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.Control parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.Control parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.Control parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2.Control prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configures dynamic metadata that can be linked to a
   * [ServingConfig][google.cloud.retail.v2.ServingConfig] and affect search or
   * recommendation results at serving time.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2.Control}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.Control)
      com.google.cloud.retail.v2.ControlOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2.ControlProto
          .internal_static_google_cloud_retail_v2_Control_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2.ControlProto
          .internal_static_google_cloud_retail_v2_Control_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2.Control.class,
              com.google.cloud.retail.v2.Control.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2.Control.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (ruleBuilder_ != null) {
        ruleBuilder_.clear();
      }
      name_ = "";
      displayName_ = "";
      associatedServingConfigIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      solutionTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      searchSolutionUseCase_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      controlCase_ = 0;
      control_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2.ControlProto
          .internal_static_google_cloud_retail_v2_Control_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.Control getDefaultInstanceForType() {
      return com.google.cloud.retail.v2.Control.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.Control build() {
      com.google.cloud.retail.v2.Control result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.Control buildPartial() {
      com.google.cloud.retail.v2.Control result = new com.google.cloud.retail.v2.Control(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.retail.v2.Control result) {
      if (((bitField0_ & 0x00000010) != 0)) {
        solutionTypes_ = java.util.Collections.unmodifiableList(solutionTypes_);
        bitField0_ = (bitField0_ & ~0x00000010);
      }
      result.solutionTypes_ = solutionTypes_;
      if (((bitField0_ & 0x00000020) != 0)) {
        searchSolutionUseCase_ = java.util.Collections.unmodifiableList(searchSolutionUseCase_);
        bitField0_ = (bitField0_ & ~0x00000020);
      }
      result.searchSolutionUseCase_ = searchSolutionUseCase_;
    }

    private void buildPartial0(com.google.cloud.retail.v2.Control result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        associatedServingConfigIds_.makeImmutable();
        result.associatedServingConfigIds_ = associatedServingConfigIds_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.retail.v2.Control result) {
      result.controlCase_ = controlCase_;
      result.control_ = this.control_;
      if (controlCase_ == 4 && ruleBuilder_ != null) {
        result.control_ = ruleBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2.Control) {
        return mergeFrom((com.google.cloud.retail.v2.Control) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2.Control other) {
      if (other == com.google.cloud.retail.v2.Control.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.associatedServingConfigIds_.isEmpty()) {
        if (associatedServingConfigIds_.isEmpty()) {
          associatedServingConfigIds_ = other.associatedServingConfigIds_;
          bitField0_ |= 0x00000008;
        } else {
          ensureAssociatedServingConfigIdsIsMutable();
          associatedServingConfigIds_.addAll(other.associatedServingConfigIds_);
        }
        onChanged();
      }
      if (!other.solutionTypes_.isEmpty()) {
        if (solutionTypes_.isEmpty()) {
          solutionTypes_ = other.solutionTypes_;
          bitField0_ = (bitField0_ & ~0x00000010);
        } else {
          ensureSolutionTypesIsMutable();
          solutionTypes_.addAll(other.solutionTypes_);
        }
        onChanged();
      }
      if (!other.searchSolutionUseCase_.isEmpty()) {
        if (searchSolutionUseCase_.isEmpty()) {
          searchSolutionUseCase_ = other.searchSolutionUseCase_;
          bitField0_ = (bitField0_ & ~0x00000020);
        } else {
          ensureSearchSolutionUseCaseIsMutable();
          searchSolutionUseCase_.addAll(other.searchSolutionUseCase_);
        }
        onChanged();
      }
      switch (other.getControlCase()) {
        case RULE:
          {
            mergeRule(other.getRule());
            break;
          }
        case CONTROL_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 34:
              {
                input.readMessage(getRuleFieldBuilder().getBuilder(), extensionRegistry);
                controlCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAssociatedServingConfigIdsIsMutable();
                associatedServingConfigIds_.add(s);
                break;
              } // case 42
            case 48:
              {
                int tmpRaw = input.readEnum();
                ensureSolutionTypesIsMutable();
                solutionTypes_.add(tmpRaw);
                break;
              } // case 48
            case 50:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureSolutionTypesIsMutable();
                  solutionTypes_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 50
            case 56:
              {
                int tmpRaw = input.readEnum();
                ensureSearchSolutionUseCaseIsMutable();
                searchSolutionUseCase_.add(tmpRaw);
                break;
              } // case 56
            case 58:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureSearchSolutionUseCaseIsMutable();
                  searchSolutionUseCase_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int controlCase_ = 0;
    private java.lang.Object control_;

    public ControlCase getControlCase() {
      return ControlCase.forNumber(controlCase_);
    }

    public Builder clearControl() {
      controlCase_ = 0;
      control_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2.Rule,
            com.google.cloud.retail.v2.Rule.Builder,
            com.google.cloud.retail.v2.RuleOrBuilder>
        ruleBuilder_;
    /**
     *
     *
     * <pre>
     * A rule control - a condition-action pair.
     * Enacts a set action when the condition is triggered.
     * For example: Boost "gShoe" when query full matches "Running Shoes".
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Rule rule = 4;</code>
     *
     * @return Whether the rule field is set.
     */
    @java.lang.Override
    public boolean hasRule() {
      return controlCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * A rule control - a condition-action pair.
     * Enacts a set action when the condition is triggered.
     * For example: Boost "gShoe" when query full matches "Running Shoes".
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Rule rule = 4;</code>
     *
     * @return The rule.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.Rule getRule() {
      if (ruleBuilder_ == null) {
        if (controlCase_ == 4) {
          return (com.google.cloud.retail.v2.Rule) control_;
        }
        return com.google.cloud.retail.v2.Rule.getDefaultInstance();
      } else {
        if (controlCase_ == 4) {
          return ruleBuilder_.getMessage();
        }
        return com.google.cloud.retail.v2.Rule.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A rule control - a condition-action pair.
     * Enacts a set action when the condition is triggered.
     * For example: Boost "gShoe" when query full matches "Running Shoes".
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Rule rule = 4;</code>
     */
    public Builder setRule(com.google.cloud.retail.v2.Rule value) {
      if (ruleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        control_ = value;
        onChanged();
      } else {
        ruleBuilder_.setMessage(value);
      }
      controlCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A rule control - a condition-action pair.
     * Enacts a set action when the condition is triggered.
     * For example: Boost "gShoe" when query full matches "Running Shoes".
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Rule rule = 4;</code>
     */
    public Builder setRule(com.google.cloud.retail.v2.Rule.Builder builderForValue) {
      if (ruleBuilder_ == null) {
        control_ = builderForValue.build();
        onChanged();
      } else {
        ruleBuilder_.setMessage(builderForValue.build());
      }
      controlCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A rule control - a condition-action pair.
     * Enacts a set action when the condition is triggered.
     * For example: Boost "gShoe" when query full matches "Running Shoes".
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Rule rule = 4;</code>
     */
    public Builder mergeRule(com.google.cloud.retail.v2.Rule value) {
      if (ruleBuilder_ == null) {
        if (controlCase_ == 4 && control_ != com.google.cloud.retail.v2.Rule.getDefaultInstance()) {
          control_ =
              com.google.cloud.retail.v2.Rule.newBuilder((com.google.cloud.retail.v2.Rule) control_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          control_ = value;
        }
        onChanged();
      } else {
        if (controlCase_ == 4) {
          ruleBuilder_.mergeFrom(value);
        } else {
          ruleBuilder_.setMessage(value);
        }
      }
      controlCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A rule control - a condition-action pair.
     * Enacts a set action when the condition is triggered.
     * For example: Boost "gShoe" when query full matches "Running Shoes".
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Rule rule = 4;</code>
     */
    public Builder clearRule() {
      if (ruleBuilder_ == null) {
        if (controlCase_ == 4) {
          controlCase_ = 0;
          control_ = null;
          onChanged();
        }
      } else {
        if (controlCase_ == 4) {
          controlCase_ = 0;
          control_ = null;
        }
        ruleBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A rule control - a condition-action pair.
     * Enacts a set action when the condition is triggered.
     * For example: Boost "gShoe" when query full matches "Running Shoes".
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Rule rule = 4;</code>
     */
    public com.google.cloud.retail.v2.Rule.Builder getRuleBuilder() {
      return getRuleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A rule control - a condition-action pair.
     * Enacts a set action when the condition is triggered.
     * For example: Boost "gShoe" when query full matches "Running Shoes".
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Rule rule = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.RuleOrBuilder getRuleOrBuilder() {
      if ((controlCase_ == 4) && (ruleBuilder_ != null)) {
        return ruleBuilder_.getMessageOrBuilder();
      } else {
        if (controlCase_ == 4) {
          return (com.google.cloud.retail.v2.Rule) control_;
        }
        return com.google.cloud.retail.v2.Rule.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A rule control - a condition-action pair.
     * Enacts a set action when the condition is triggered.
     * For example: Boost "gShoe" when query full matches "Running Shoes".
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Rule rule = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2.Rule,
            com.google.cloud.retail.v2.Rule.Builder,
            com.google.cloud.retail.v2.RuleOrBuilder>
        getRuleFieldBuilder() {
      if (ruleBuilder_ == null) {
        if (!(controlCase_ == 4)) {
          control_ = com.google.cloud.retail.v2.Rule.getDefaultInstance();
        }
        ruleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2.Rule,
                com.google.cloud.retail.v2.Rule.Builder,
                com.google.cloud.retail.v2.RuleOrBuilder>(
                (com.google.cloud.retail.v2.Rule) control_, getParentForChildren(), isClean());
        control_ = null;
      }
      controlCase_ = 4;
      onChanged();
      return ruleBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/global/catalogs/&#42;&#47;controls/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/global/catalogs/&#42;&#47;controls/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/global/catalogs/&#42;&#47;controls/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/global/catalogs/&#42;&#47;controls/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/global/catalogs/&#42;&#47;controls/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The human readable control display name. Used in Retail UI.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human readable control display name. Used in Retail UI.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human readable control display name. Used in Retail UI.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human readable control display name. Used in Retail UI.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human readable control display name. Used in Retail UI.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList associatedServingConfigIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAssociatedServingConfigIdsIsMutable() {
      if (!associatedServingConfigIds_.isModifiable()) {
        associatedServingConfigIds_ =
            new com.google.protobuf.LazyStringArrayList(associatedServingConfigIds_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of [serving config][google.cloud.retail.v2.ServingConfig]
     * ids that are associated with this control in the same
     * [Catalog][google.cloud.retail.v2.Catalog].
     *
     * Note the association is managed via the
     * [ServingConfig][google.cloud.retail.v2.ServingConfig], this is an output
     * only denormalized view.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the associatedServingConfigIds.
     */
    public com.google.protobuf.ProtocolStringList getAssociatedServingConfigIdsList() {
      associatedServingConfigIds_.makeImmutable();
      return associatedServingConfigIds_;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of [serving config][google.cloud.retail.v2.ServingConfig]
     * ids that are associated with this control in the same
     * [Catalog][google.cloud.retail.v2.Catalog].
     *
     * Note the association is managed via the
     * [ServingConfig][google.cloud.retail.v2.ServingConfig], this is an output
     * only denormalized view.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of associatedServingConfigIds.
     */
    public int getAssociatedServingConfigIdsCount() {
      return associatedServingConfigIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. List of [serving config][google.cloud.retail.v2.ServingConfig]
     * ids that are associated with this control in the same
     * [Catalog][google.cloud.retail.v2.Catalog].
     *
     * Note the association is managed via the
     * [ServingConfig][google.cloud.retail.v2.ServingConfig], this is an output
     * only denormalized view.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The associatedServingConfigIds at the given index.
     */
    public java.lang.String getAssociatedServingConfigIds(int index) {
      return associatedServingConfigIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. List of [serving config][google.cloud.retail.v2.ServingConfig]
     * ids that are associated with this control in the same
     * [Catalog][google.cloud.retail.v2.Catalog].
     *
     * Note the association is managed via the
     * [ServingConfig][google.cloud.retail.v2.ServingConfig], this is an output
     * only denormalized view.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the associatedServingConfigIds at the given index.
     */
    public com.google.protobuf.ByteString getAssociatedServingConfigIdsBytes(int index) {
      return associatedServingConfigIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. List of [serving config][google.cloud.retail.v2.ServingConfig]
     * ids that are associated with this control in the same
     * [Catalog][google.cloud.retail.v2.Catalog].
     *
     * Note the association is managed via the
     * [ServingConfig][google.cloud.retail.v2.ServingConfig], this is an output
     * only denormalized view.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The associatedServingConfigIds to set.
     * @return This builder for chaining.
     */
    public Builder setAssociatedServingConfigIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAssociatedServingConfigIdsIsMutable();
      associatedServingConfigIds_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of [serving config][google.cloud.retail.v2.ServingConfig]
     * ids that are associated with this control in the same
     * [Catalog][google.cloud.retail.v2.Catalog].
     *
     * Note the association is managed via the
     * [ServingConfig][google.cloud.retail.v2.ServingConfig], this is an output
     * only denormalized view.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The associatedServingConfigIds to add.
     * @return This builder for chaining.
     */
    public Builder addAssociatedServingConfigIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAssociatedServingConfigIdsIsMutable();
      associatedServingConfigIds_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of [serving config][google.cloud.retail.v2.ServingConfig]
     * ids that are associated with this control in the same
     * [Catalog][google.cloud.retail.v2.Catalog].
     *
     * Note the association is managed via the
     * [ServingConfig][google.cloud.retail.v2.ServingConfig], this is an output
     * only denormalized view.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The associatedServingConfigIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllAssociatedServingConfigIds(java.lang.Iterable<java.lang.String> values) {
      ensureAssociatedServingConfigIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, associatedServingConfigIds_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of [serving config][google.cloud.retail.v2.ServingConfig]
     * ids that are associated with this control in the same
     * [Catalog][google.cloud.retail.v2.Catalog].
     *
     * Note the association is managed via the
     * [ServingConfig][google.cloud.retail.v2.ServingConfig], this is an output
     * only denormalized view.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAssociatedServingConfigIds() {
      associatedServingConfigIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of [serving config][google.cloud.retail.v2.ServingConfig]
     * ids that are associated with this control in the same
     * [Catalog][google.cloud.retail.v2.Catalog].
     *
     * Note the association is managed via the
     * [ServingConfig][google.cloud.retail.v2.ServingConfig], this is an output
     * only denormalized view.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes of the associatedServingConfigIds to add.
     * @return This builder for chaining.
     */
    public Builder addAssociatedServingConfigIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAssociatedServingConfigIdsIsMutable();
      associatedServingConfigIds_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> solutionTypes_ = java.util.Collections.emptyList();

    private void ensureSolutionTypesIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        solutionTypes_ = new java.util.ArrayList<java.lang.Integer>(solutionTypes_);
        bitField0_ |= 0x00000010;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The solution types that the control is used for.
     * Currently we support setting only one type of solution at creation time.
     *
     * Only `SOLUTION_TYPE_SEARCH` value is supported at the moment.
     * If no solution type is provided at creation time, will default to
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SolutionType solution_types = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return A list containing the solutionTypes.
     */
    public java.util.List<com.google.cloud.retail.v2.SolutionType> getSolutionTypesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.retail.v2.SolutionType>(
          solutionTypes_, solutionTypes_converter_);
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The solution types that the control is used for.
     * Currently we support setting only one type of solution at creation time.
     *
     * Only `SOLUTION_TYPE_SEARCH` value is supported at the moment.
     * If no solution type is provided at creation time, will default to
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SolutionType solution_types = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The count of solutionTypes.
     */
    public int getSolutionTypesCount() {
      return solutionTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The solution types that the control is used for.
     * Currently we support setting only one type of solution at creation time.
     *
     * Only `SOLUTION_TYPE_SEARCH` value is supported at the moment.
     * If no solution type is provided at creation time, will default to
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SolutionType solution_types = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The solutionTypes at the given index.
     */
    public com.google.cloud.retail.v2.SolutionType getSolutionTypes(int index) {
      return solutionTypes_converter_.convert(solutionTypes_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The solution types that the control is used for.
     * Currently we support setting only one type of solution at creation time.
     *
     * Only `SOLUTION_TYPE_SEARCH` value is supported at the moment.
     * If no solution type is provided at creation time, will default to
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SolutionType solution_types = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The solutionTypes to set.
     * @return This builder for chaining.
     */
    public Builder setSolutionTypes(int index, com.google.cloud.retail.v2.SolutionType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSolutionTypesIsMutable();
      solutionTypes_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The solution types that the control is used for.
     * Currently we support setting only one type of solution at creation time.
     *
     * Only `SOLUTION_TYPE_SEARCH` value is supported at the moment.
     * If no solution type is provided at creation time, will default to
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SolutionType solution_types = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The solutionTypes to add.
     * @return This builder for chaining.
     */
    public Builder addSolutionTypes(com.google.cloud.retail.v2.SolutionType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSolutionTypesIsMutable();
      solutionTypes_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The solution types that the control is used for.
     * Currently we support setting only one type of solution at creation time.
     *
     * Only `SOLUTION_TYPE_SEARCH` value is supported at the moment.
     * If no solution type is provided at creation time, will default to
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SolutionType solution_types = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param values The solutionTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllSolutionTypes(
        java.lang.Iterable<? extends com.google.cloud.retail.v2.SolutionType> values) {
      ensureSolutionTypesIsMutable();
      for (com.google.cloud.retail.v2.SolutionType value : values) {
        solutionTypes_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The solution types that the control is used for.
     * Currently we support setting only one type of solution at creation time.
     *
     * Only `SOLUTION_TYPE_SEARCH` value is supported at the moment.
     * If no solution type is provided at creation time, will default to
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SolutionType solution_types = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSolutionTypes() {
      solutionTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The solution types that the control is used for.
     * Currently we support setting only one type of solution at creation time.
     *
     * Only `SOLUTION_TYPE_SEARCH` value is supported at the moment.
     * If no solution type is provided at creation time, will default to
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SolutionType solution_types = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for solutionTypes.
     */
    public java.util.List<java.lang.Integer> getSolutionTypesValueList() {
      return java.util.Collections.unmodifiableList(solutionTypes_);
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The solution types that the control is used for.
     * Currently we support setting only one type of solution at creation time.
     *
     * Only `SOLUTION_TYPE_SEARCH` value is supported at the moment.
     * If no solution type is provided at creation time, will default to
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SolutionType solution_types = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of solutionTypes at the given index.
     */
    public int getSolutionTypesValue(int index) {
      return solutionTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The solution types that the control is used for.
     * Currently we support setting only one type of solution at creation time.
     *
     * Only `SOLUTION_TYPE_SEARCH` value is supported at the moment.
     * If no solution type is provided at creation time, will default to
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SolutionType solution_types = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for solutionTypes to set.
     * @return This builder for chaining.
     */
    public Builder setSolutionTypesValue(int index, int value) {
      ensureSolutionTypesIsMutable();
      solutionTypes_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The solution types that the control is used for.
     * Currently we support setting only one type of solution at creation time.
     *
     * Only `SOLUTION_TYPE_SEARCH` value is supported at the moment.
     * If no solution type is provided at creation time, will default to
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SolutionType solution_types = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for solutionTypes to add.
     * @return This builder for chaining.
     */
    public Builder addSolutionTypesValue(int value) {
      ensureSolutionTypesIsMutable();
      solutionTypes_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The solution types that the control is used for.
     * Currently we support setting only one type of solution at creation time.
     *
     * Only `SOLUTION_TYPE_SEARCH` value is supported at the moment.
     * If no solution type is provided at creation time, will default to
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SolutionType solution_types = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param values The enum numeric values on the wire for solutionTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllSolutionTypesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureSolutionTypesIsMutable();
      for (int value : values) {
        solutionTypes_.add(value);
      }
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> searchSolutionUseCase_ =
        java.util.Collections.emptyList();

    private void ensureSearchSolutionUseCaseIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        searchSolutionUseCase_ = new java.util.ArrayList<java.lang.Integer>(searchSolutionUseCase_);
        bitField0_ |= 0x00000020;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only settable by search controls.
     * Will default to
     * [SEARCH_SOLUTION_USE_CASE_SEARCH][google.cloud.retail.v2.SearchSolutionUseCase.SEARCH_SOLUTION_USE_CASE_SEARCH]
     * if not specified. Currently only allow one search_solution_use_case per
     * control.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchSolutionUseCase search_solution_use_case = 7;
     * </code>
     *
     * @return A list containing the searchSolutionUseCase.
     */
    public java.util.List<com.google.cloud.retail.v2.SearchSolutionUseCase>
        getSearchSolutionUseCaseList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.retail.v2.SearchSolutionUseCase>(
          searchSolutionUseCase_, searchSolutionUseCase_converter_);
    }
    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only settable by search controls.
     * Will default to
     * [SEARCH_SOLUTION_USE_CASE_SEARCH][google.cloud.retail.v2.SearchSolutionUseCase.SEARCH_SOLUTION_USE_CASE_SEARCH]
     * if not specified. Currently only allow one search_solution_use_case per
     * control.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchSolutionUseCase search_solution_use_case = 7;
     * </code>
     *
     * @return The count of searchSolutionUseCase.
     */
    public int getSearchSolutionUseCaseCount() {
      return searchSolutionUseCase_.size();
    }
    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only settable by search controls.
     * Will default to
     * [SEARCH_SOLUTION_USE_CASE_SEARCH][google.cloud.retail.v2.SearchSolutionUseCase.SEARCH_SOLUTION_USE_CASE_SEARCH]
     * if not specified. Currently only allow one search_solution_use_case per
     * control.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchSolutionUseCase search_solution_use_case = 7;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The searchSolutionUseCase at the given index.
     */
    public com.google.cloud.retail.v2.SearchSolutionUseCase getSearchSolutionUseCase(int index) {
      return searchSolutionUseCase_converter_.convert(searchSolutionUseCase_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only settable by search controls.
     * Will default to
     * [SEARCH_SOLUTION_USE_CASE_SEARCH][google.cloud.retail.v2.SearchSolutionUseCase.SEARCH_SOLUTION_USE_CASE_SEARCH]
     * if not specified. Currently only allow one search_solution_use_case per
     * control.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchSolutionUseCase search_solution_use_case = 7;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The searchSolutionUseCase to set.
     * @return This builder for chaining.
     */
    public Builder setSearchSolutionUseCase(
        int index, com.google.cloud.retail.v2.SearchSolutionUseCase value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSearchSolutionUseCaseIsMutable();
      searchSolutionUseCase_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only settable by search controls.
     * Will default to
     * [SEARCH_SOLUTION_USE_CASE_SEARCH][google.cloud.retail.v2.SearchSolutionUseCase.SEARCH_SOLUTION_USE_CASE_SEARCH]
     * if not specified. Currently only allow one search_solution_use_case per
     * control.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchSolutionUseCase search_solution_use_case = 7;
     * </code>
     *
     * @param value The searchSolutionUseCase to add.
     * @return This builder for chaining.
     */
    public Builder addSearchSolutionUseCase(
        com.google.cloud.retail.v2.SearchSolutionUseCase value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSearchSolutionUseCaseIsMutable();
      searchSolutionUseCase_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only settable by search controls.
     * Will default to
     * [SEARCH_SOLUTION_USE_CASE_SEARCH][google.cloud.retail.v2.SearchSolutionUseCase.SEARCH_SOLUTION_USE_CASE_SEARCH]
     * if not specified. Currently only allow one search_solution_use_case per
     * control.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchSolutionUseCase search_solution_use_case = 7;
     * </code>
     *
     * @param values The searchSolutionUseCase to add.
     * @return This builder for chaining.
     */
    public Builder addAllSearchSolutionUseCase(
        java.lang.Iterable<? extends com.google.cloud.retail.v2.SearchSolutionUseCase> values) {
      ensureSearchSolutionUseCaseIsMutable();
      for (com.google.cloud.retail.v2.SearchSolutionUseCase value : values) {
        searchSolutionUseCase_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only settable by search controls.
     * Will default to
     * [SEARCH_SOLUTION_USE_CASE_SEARCH][google.cloud.retail.v2.SearchSolutionUseCase.SEARCH_SOLUTION_USE_CASE_SEARCH]
     * if not specified. Currently only allow one search_solution_use_case per
     * control.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchSolutionUseCase search_solution_use_case = 7;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSearchSolutionUseCase() {
      searchSolutionUseCase_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only settable by search controls.
     * Will default to
     * [SEARCH_SOLUTION_USE_CASE_SEARCH][google.cloud.retail.v2.SearchSolutionUseCase.SEARCH_SOLUTION_USE_CASE_SEARCH]
     * if not specified. Currently only allow one search_solution_use_case per
     * control.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchSolutionUseCase search_solution_use_case = 7;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for searchSolutionUseCase.
     */
    public java.util.List<java.lang.Integer> getSearchSolutionUseCaseValueList() {
      return java.util.Collections.unmodifiableList(searchSolutionUseCase_);
    }
    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only settable by search controls.
     * Will default to
     * [SEARCH_SOLUTION_USE_CASE_SEARCH][google.cloud.retail.v2.SearchSolutionUseCase.SEARCH_SOLUTION_USE_CASE_SEARCH]
     * if not specified. Currently only allow one search_solution_use_case per
     * control.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchSolutionUseCase search_solution_use_case = 7;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of searchSolutionUseCase at the given index.
     */
    public int getSearchSolutionUseCaseValue(int index) {
      return searchSolutionUseCase_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only settable by search controls.
     * Will default to
     * [SEARCH_SOLUTION_USE_CASE_SEARCH][google.cloud.retail.v2.SearchSolutionUseCase.SEARCH_SOLUTION_USE_CASE_SEARCH]
     * if not specified. Currently only allow one search_solution_use_case per
     * control.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchSolutionUseCase search_solution_use_case = 7;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for searchSolutionUseCase to set.
     * @return This builder for chaining.
     */
    public Builder setSearchSolutionUseCaseValue(int index, int value) {
      ensureSearchSolutionUseCaseIsMutable();
      searchSolutionUseCase_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only settable by search controls.
     * Will default to
     * [SEARCH_SOLUTION_USE_CASE_SEARCH][google.cloud.retail.v2.SearchSolutionUseCase.SEARCH_SOLUTION_USE_CASE_SEARCH]
     * if not specified. Currently only allow one search_solution_use_case per
     * control.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchSolutionUseCase search_solution_use_case = 7;
     * </code>
     *
     * @param value The enum numeric value on the wire for searchSolutionUseCase to add.
     * @return This builder for chaining.
     */
    public Builder addSearchSolutionUseCaseValue(int value) {
      ensureSearchSolutionUseCaseIsMutable();
      searchSolutionUseCase_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only settable by search controls.
     * Will default to
     * [SEARCH_SOLUTION_USE_CASE_SEARCH][google.cloud.retail.v2.SearchSolutionUseCase.SEARCH_SOLUTION_USE_CASE_SEARCH]
     * if not specified. Currently only allow one search_solution_use_case per
     * control.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchSolutionUseCase search_solution_use_case = 7;
     * </code>
     *
     * @param values The enum numeric values on the wire for searchSolutionUseCase to add.
     * @return This builder for chaining.
     */
    public Builder addAllSearchSolutionUseCaseValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureSearchSolutionUseCaseIsMutable();
      for (int value : values) {
        searchSolutionUseCase_.add(value);
      }
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.Control)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.Control)
  private static final com.google.cloud.retail.v2.Control DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2.Control();
  }

  public static com.google.cloud.retail.v2.Control getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Control> PARSER =
      new com.google.protobuf.AbstractParser<Control>() {
        @java.lang.Override
        public Control parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Control> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Control> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2.Control getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
