/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2/product_service.proto

package com.google.cloud.retail.v2;

/**
 *
 *
 * <pre>
 * Request message for
 * [ProductService.RemoveFulfillmentPlaces][google.cloud.retail.v2.ProductService.RemoveFulfillmentPlaces]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2.RemoveFulfillmentPlacesRequest}
 */
public final class RemoveFulfillmentPlacesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.RemoveFulfillmentPlacesRequest)
    RemoveFulfillmentPlacesRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RemoveFulfillmentPlacesRequest.newBuilder() to construct.
  private RemoveFulfillmentPlacesRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RemoveFulfillmentPlacesRequest() {
    product_ = "";
    type_ = "";
    placeIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RemoveFulfillmentPlacesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2.ProductServiceProto
        .internal_static_google_cloud_retail_v2_RemoveFulfillmentPlacesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2.ProductServiceProto
        .internal_static_google_cloud_retail_v2_RemoveFulfillmentPlacesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.class,
            com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.Builder.class);
  }

  public static final int PRODUCT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object product_ = "";
  /**
   *
   *
   * <pre>
   * Required. Full resource name of [Product][google.cloud.retail.v2.Product],
   * such as
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
   *
   * If the caller does not have permission to access the
   * [Product][google.cloud.retail.v2.Product], regardless of whether or not it
   * exists, a PERMISSION_DENIED error is returned.
   * </pre>
   *
   * <code>
   * string product = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The product.
   */
  @java.lang.Override
  public java.lang.String getProduct() {
    java.lang.Object ref = product_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      product_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Full resource name of [Product][google.cloud.retail.v2.Product],
   * such as
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
   *
   * If the caller does not have permission to access the
   * [Product][google.cloud.retail.v2.Product], regardless of whether or not it
   * exists, a PERMISSION_DENIED error is returned.
   * </pre>
   *
   * <code>
   * string product = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for product.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProductBytes() {
    java.lang.Object ref = product_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      product_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";
  /**
   *
   *
   * <pre>
   * Required. The fulfillment type, including commonly used types (such as
   * pickup in store and same day delivery), and custom types.
   *
   * Supported values:
   *
   * * "pickup-in-store"
   * * "ship-to-store"
   * * "same-day-delivery"
   * * "next-day-delivery"
   * * "custom-type-1"
   * * "custom-type-2"
   * * "custom-type-3"
   * * "custom-type-4"
   * * "custom-type-5"
   *
   * If this field is set to an invalid value other than these, an
   * INVALID_ARGUMENT error is returned.
   *
   * This field directly corresponds to
   * [Product.fulfillment_info.type][google.cloud.retail.v2.FulfillmentInfo.type].
   * </pre>
   *
   * <code>string type = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The fulfillment type, including commonly used types (such as
   * pickup in store and same day delivery), and custom types.
   *
   * Supported values:
   *
   * * "pickup-in-store"
   * * "ship-to-store"
   * * "same-day-delivery"
   * * "next-day-delivery"
   * * "custom-type-1"
   * * "custom-type-2"
   * * "custom-type-3"
   * * "custom-type-4"
   * * "custom-type-5"
   *
   * If this field is set to an invalid value other than these, an
   * INVALID_ARGUMENT error is returned.
   *
   * This field directly corresponds to
   * [Product.fulfillment_info.type][google.cloud.retail.v2.FulfillmentInfo.type].
   * </pre>
   *
   * <code>string type = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PLACE_IDS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList placeIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Required. The IDs for this
   * [type][google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.type], such as
   * the store IDs for "pickup-in-store" or the region IDs for
   * "same-day-delivery", to be removed for this
   * [type][google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.type].
   *
   * At least 1 value is required, and a maximum of 2000 values are allowed.
   * Each value must be a string with a length limit of 10 characters, matching
   * the pattern `[a-zA-Z0-9_-]+`, such as "store1" or "REGION-2". Otherwise, an
   * INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>repeated string place_ids = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return A list containing the placeIds.
   */
  public com.google.protobuf.ProtocolStringList getPlaceIdsList() {
    return placeIds_;
  }
  /**
   *
   *
   * <pre>
   * Required. The IDs for this
   * [type][google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.type], such as
   * the store IDs for "pickup-in-store" or the region IDs for
   * "same-day-delivery", to be removed for this
   * [type][google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.type].
   *
   * At least 1 value is required, and a maximum of 2000 values are allowed.
   * Each value must be a string with a length limit of 10 characters, matching
   * the pattern `[a-zA-Z0-9_-]+`, such as "store1" or "REGION-2". Otherwise, an
   * INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>repeated string place_ids = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The count of placeIds.
   */
  public int getPlaceIdsCount() {
    return placeIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The IDs for this
   * [type][google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.type], such as
   * the store IDs for "pickup-in-store" or the region IDs for
   * "same-day-delivery", to be removed for this
   * [type][google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.type].
   *
   * At least 1 value is required, and a maximum of 2000 values are allowed.
   * Each value must be a string with a length limit of 10 characters, matching
   * the pattern `[a-zA-Z0-9_-]+`, such as "store1" or "REGION-2". Otherwise, an
   * INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>repeated string place_ids = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the element to return.
   * @return The placeIds at the given index.
   */
  public java.lang.String getPlaceIds(int index) {
    return placeIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The IDs for this
   * [type][google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.type], such as
   * the store IDs for "pickup-in-store" or the region IDs for
   * "same-day-delivery", to be removed for this
   * [type][google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.type].
   *
   * At least 1 value is required, and a maximum of 2000 values are allowed.
   * Each value must be a string with a length limit of 10 characters, matching
   * the pattern `[a-zA-Z0-9_-]+`, such as "store1" or "REGION-2". Otherwise, an
   * INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>repeated string place_ids = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the placeIds at the given index.
   */
  public com.google.protobuf.ByteString getPlaceIdsBytes(int index) {
    return placeIds_.getByteString(index);
  }

  public static final int REMOVE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp removeTime_;
  /**
   *
   *
   * <pre>
   * The time when the fulfillment updates are issued, used to prevent
   * out-of-order updates on fulfillment information. If not provided, the
   * internal system time will be used.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp remove_time = 4;</code>
   *
   * @return Whether the removeTime field is set.
   */
  @java.lang.Override
  public boolean hasRemoveTime() {
    return removeTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time when the fulfillment updates are issued, used to prevent
   * out-of-order updates on fulfillment information. If not provided, the
   * internal system time will be used.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp remove_time = 4;</code>
   *
   * @return The removeTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getRemoveTime() {
    return removeTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : removeTime_;
  }
  /**
   *
   *
   * <pre>
   * The time when the fulfillment updates are issued, used to prevent
   * out-of-order updates on fulfillment information. If not provided, the
   * internal system time will be used.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp remove_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getRemoveTimeOrBuilder() {
    return removeTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : removeTime_;
  }

  public static final int ALLOW_MISSING_FIELD_NUMBER = 5;
  private boolean allowMissing_ = false;
  /**
   *
   *
   * <pre>
   * If set to true, and the [Product][google.cloud.retail.v2.Product] is not
   * found, the fulfillment information will still be processed and retained for
   * at most 1 day and processed once the
   * [Product][google.cloud.retail.v2.Product] is created. If set to false, a
   * NOT_FOUND error is returned if the
   * [Product][google.cloud.retail.v2.Product] is not found.
   * </pre>
   *
   * <code>bool allow_missing = 5;</code>
   *
   * @return The allowMissing.
   */
  @java.lang.Override
  public boolean getAllowMissing() {
    return allowMissing_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(product_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, product_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, type_);
    }
    for (int i = 0; i < placeIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, placeIds_.getRaw(i));
    }
    if (removeTime_ != null) {
      output.writeMessage(4, getRemoveTime());
    }
    if (allowMissing_ != false) {
      output.writeBool(5, allowMissing_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(product_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, product_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, type_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < placeIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(placeIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getPlaceIdsList().size();
    }
    if (removeTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getRemoveTime());
    }
    if (allowMissing_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, allowMissing_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest other =
        (com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest) obj;

    if (!getProduct().equals(other.getProduct())) return false;
    if (!getType().equals(other.getType())) return false;
    if (!getPlaceIdsList().equals(other.getPlaceIdsList())) return false;
    if (hasRemoveTime() != other.hasRemoveTime()) return false;
    if (hasRemoveTime()) {
      if (!getRemoveTime().equals(other.getRemoveTime())) return false;
    }
    if (getAllowMissing() != other.getAllowMissing()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PRODUCT_FIELD_NUMBER;
    hash = (53 * hash) + getProduct().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getType().hashCode();
    if (getPlaceIdsCount() > 0) {
      hash = (37 * hash) + PLACE_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getPlaceIdsList().hashCode();
    }
    if (hasRemoveTime()) {
      hash = (37 * hash) + REMOVE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getRemoveTime().hashCode();
    }
    hash = (37 * hash) + ALLOW_MISSING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowMissing());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [ProductService.RemoveFulfillmentPlaces][google.cloud.retail.v2.ProductService.RemoveFulfillmentPlaces]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2.RemoveFulfillmentPlacesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.RemoveFulfillmentPlacesRequest)
      com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2.ProductServiceProto
          .internal_static_google_cloud_retail_v2_RemoveFulfillmentPlacesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2.ProductServiceProto
          .internal_static_google_cloud_retail_v2_RemoveFulfillmentPlacesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.class,
              com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      product_ = "";
      type_ = "";
      placeIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      removeTime_ = null;
      if (removeTimeBuilder_ != null) {
        removeTimeBuilder_.dispose();
        removeTimeBuilder_ = null;
      }
      allowMissing_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2.ProductServiceProto
          .internal_static_google_cloud_retail_v2_RemoveFulfillmentPlacesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest getDefaultInstanceForType() {
      return com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest build() {
      com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest buildPartial() {
      com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest result =
          new com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.product_ = product_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        placeIds_.makeImmutable();
        result.placeIds_ = placeIds_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.removeTime_ = removeTimeBuilder_ == null ? removeTime_ : removeTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.allowMissing_ = allowMissing_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest) {
        return mergeFrom((com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest other) {
      if (other == com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.getDefaultInstance())
        return this;
      if (!other.getProduct().isEmpty()) {
        product_ = other.product_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getType().isEmpty()) {
        type_ = other.type_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.placeIds_.isEmpty()) {
        if (placeIds_.isEmpty()) {
          placeIds_ = other.placeIds_;
          bitField0_ |= 0x00000004;
        } else {
          ensurePlaceIdsIsMutable();
          placeIds_.addAll(other.placeIds_);
        }
        onChanged();
      }
      if (other.hasRemoveTime()) {
        mergeRemoveTime(other.getRemoveTime());
      }
      if (other.getAllowMissing() != false) {
        setAllowMissing(other.getAllowMissing());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                product_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                type_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensurePlaceIdsIsMutable();
                placeIds_.add(s);
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getRemoveTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                allowMissing_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object product_ = "";
    /**
     *
     *
     * <pre>
     * Required. Full resource name of [Product][google.cloud.retail.v2.Product],
     * such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
     *
     * If the caller does not have permission to access the
     * [Product][google.cloud.retail.v2.Product], regardless of whether or not it
     * exists, a PERMISSION_DENIED error is returned.
     * </pre>
     *
     * <code>
     * string product = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The product.
     */
    public java.lang.String getProduct() {
      java.lang.Object ref = product_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        product_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of [Product][google.cloud.retail.v2.Product],
     * such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
     *
     * If the caller does not have permission to access the
     * [Product][google.cloud.retail.v2.Product], regardless of whether or not it
     * exists, a PERMISSION_DENIED error is returned.
     * </pre>
     *
     * <code>
     * string product = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for product.
     */
    public com.google.protobuf.ByteString getProductBytes() {
      java.lang.Object ref = product_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        product_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of [Product][google.cloud.retail.v2.Product],
     * such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
     *
     * If the caller does not have permission to access the
     * [Product][google.cloud.retail.v2.Product], regardless of whether or not it
     * exists, a PERMISSION_DENIED error is returned.
     * </pre>
     *
     * <code>
     * string product = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The product to set.
     * @return This builder for chaining.
     */
    public Builder setProduct(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      product_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of [Product][google.cloud.retail.v2.Product],
     * such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
     *
     * If the caller does not have permission to access the
     * [Product][google.cloud.retail.v2.Product], regardless of whether or not it
     * exists, a PERMISSION_DENIED error is returned.
     * </pre>
     *
     * <code>
     * string product = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProduct() {
      product_ = getDefaultInstance().getProduct();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of [Product][google.cloud.retail.v2.Product],
     * such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
     *
     * If the caller does not have permission to access the
     * [Product][google.cloud.retail.v2.Product], regardless of whether or not it
     * exists, a PERMISSION_DENIED error is returned.
     * </pre>
     *
     * <code>
     * string product = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for product to set.
     * @return This builder for chaining.
     */
    public Builder setProductBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      product_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * Required. The fulfillment type, including commonly used types (such as
     * pickup in store and same day delivery), and custom types.
     *
     * Supported values:
     *
     * * "pickup-in-store"
     * * "ship-to-store"
     * * "same-day-delivery"
     * * "next-day-delivery"
     * * "custom-type-1"
     * * "custom-type-2"
     * * "custom-type-3"
     * * "custom-type-4"
     * * "custom-type-5"
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * This field directly corresponds to
     * [Product.fulfillment_info.type][google.cloud.retail.v2.FulfillmentInfo.type].
     * </pre>
     *
     * <code>string type = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The fulfillment type, including commonly used types (such as
     * pickup in store and same day delivery), and custom types.
     *
     * Supported values:
     *
     * * "pickup-in-store"
     * * "ship-to-store"
     * * "same-day-delivery"
     * * "next-day-delivery"
     * * "custom-type-1"
     * * "custom-type-2"
     * * "custom-type-3"
     * * "custom-type-4"
     * * "custom-type-5"
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * This field directly corresponds to
     * [Product.fulfillment_info.type][google.cloud.retail.v2.FulfillmentInfo.type].
     * </pre>
     *
     * <code>string type = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The fulfillment type, including commonly used types (such as
     * pickup in store and same day delivery), and custom types.
     *
     * Supported values:
     *
     * * "pickup-in-store"
     * * "ship-to-store"
     * * "same-day-delivery"
     * * "next-day-delivery"
     * * "custom-type-1"
     * * "custom-type-2"
     * * "custom-type-3"
     * * "custom-type-4"
     * * "custom-type-5"
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * This field directly corresponds to
     * [Product.fulfillment_info.type][google.cloud.retail.v2.FulfillmentInfo.type].
     * </pre>
     *
     * <code>string type = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The fulfillment type, including commonly used types (such as
     * pickup in store and same day delivery), and custom types.
     *
     * Supported values:
     *
     * * "pickup-in-store"
     * * "ship-to-store"
     * * "same-day-delivery"
     * * "next-day-delivery"
     * * "custom-type-1"
     * * "custom-type-2"
     * * "custom-type-3"
     * * "custom-type-4"
     * * "custom-type-5"
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * This field directly corresponds to
     * [Product.fulfillment_info.type][google.cloud.retail.v2.FulfillmentInfo.type].
     * </pre>
     *
     * <code>string type = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The fulfillment type, including commonly used types (such as
     * pickup in store and same day delivery), and custom types.
     *
     * Supported values:
     *
     * * "pickup-in-store"
     * * "ship-to-store"
     * * "same-day-delivery"
     * * "next-day-delivery"
     * * "custom-type-1"
     * * "custom-type-2"
     * * "custom-type-3"
     * * "custom-type-4"
     * * "custom-type-5"
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * This field directly corresponds to
     * [Product.fulfillment_info.type][google.cloud.retail.v2.FulfillmentInfo.type].
     * </pre>
     *
     * <code>string type = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList placeIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensurePlaceIdsIsMutable() {
      if (!placeIds_.isModifiable()) {
        placeIds_ = new com.google.protobuf.LazyStringArrayList(placeIds_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Required. The IDs for this
     * [type][google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.type], such as
     * the store IDs for "pickup-in-store" or the region IDs for
     * "same-day-delivery", to be removed for this
     * [type][google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.type].
     *
     * At least 1 value is required, and a maximum of 2000 values are allowed.
     * Each value must be a string with a length limit of 10 characters, matching
     * the pattern `[a-zA-Z0-9_-]+`, such as "store1" or "REGION-2". Otherwise, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string place_ids = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the placeIds.
     */
    public com.google.protobuf.ProtocolStringList getPlaceIdsList() {
      placeIds_.makeImmutable();
      return placeIds_;
    }
    /**
     *
     *
     * <pre>
     * Required. The IDs for this
     * [type][google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.type], such as
     * the store IDs for "pickup-in-store" or the region IDs for
     * "same-day-delivery", to be removed for this
     * [type][google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.type].
     *
     * At least 1 value is required, and a maximum of 2000 values are allowed.
     * Each value must be a string with a length limit of 10 characters, matching
     * the pattern `[a-zA-Z0-9_-]+`, such as "store1" or "REGION-2". Otherwise, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string place_ids = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of placeIds.
     */
    public int getPlaceIdsCount() {
      return placeIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. The IDs for this
     * [type][google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.type], such as
     * the store IDs for "pickup-in-store" or the region IDs for
     * "same-day-delivery", to be removed for this
     * [type][google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.type].
     *
     * At least 1 value is required, and a maximum of 2000 values are allowed.
     * Each value must be a string with a length limit of 10 characters, matching
     * the pattern `[a-zA-Z0-9_-]+`, such as "store1" or "REGION-2". Otherwise, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string place_ids = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The placeIds at the given index.
     */
    public java.lang.String getPlaceIds(int index) {
      return placeIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The IDs for this
     * [type][google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.type], such as
     * the store IDs for "pickup-in-store" or the region IDs for
     * "same-day-delivery", to be removed for this
     * [type][google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.type].
     *
     * At least 1 value is required, and a maximum of 2000 values are allowed.
     * Each value must be a string with a length limit of 10 characters, matching
     * the pattern `[a-zA-Z0-9_-]+`, such as "store1" or "REGION-2". Otherwise, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string place_ids = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the placeIds at the given index.
     */
    public com.google.protobuf.ByteString getPlaceIdsBytes(int index) {
      return placeIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The IDs for this
     * [type][google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.type], such as
     * the store IDs for "pickup-in-store" or the region IDs for
     * "same-day-delivery", to be removed for this
     * [type][google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.type].
     *
     * At least 1 value is required, and a maximum of 2000 values are allowed.
     * Each value must be a string with a length limit of 10 characters, matching
     * the pattern `[a-zA-Z0-9_-]+`, such as "store1" or "REGION-2". Otherwise, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string place_ids = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index to set the value at.
     * @param value The placeIds to set.
     * @return This builder for chaining.
     */
    public Builder setPlaceIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePlaceIdsIsMutable();
      placeIds_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The IDs for this
     * [type][google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.type], such as
     * the store IDs for "pickup-in-store" or the region IDs for
     * "same-day-delivery", to be removed for this
     * [type][google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.type].
     *
     * At least 1 value is required, and a maximum of 2000 values are allowed.
     * Each value must be a string with a length limit of 10 characters, matching
     * the pattern `[a-zA-Z0-9_-]+`, such as "store1" or "REGION-2". Otherwise, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string place_ids = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The placeIds to add.
     * @return This builder for chaining.
     */
    public Builder addPlaceIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePlaceIdsIsMutable();
      placeIds_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The IDs for this
     * [type][google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.type], such as
     * the store IDs for "pickup-in-store" or the region IDs for
     * "same-day-delivery", to be removed for this
     * [type][google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.type].
     *
     * At least 1 value is required, and a maximum of 2000 values are allowed.
     * Each value must be a string with a length limit of 10 characters, matching
     * the pattern `[a-zA-Z0-9_-]+`, such as "store1" or "REGION-2". Otherwise, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string place_ids = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param values The placeIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllPlaceIds(java.lang.Iterable<java.lang.String> values) {
      ensurePlaceIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, placeIds_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The IDs for this
     * [type][google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.type], such as
     * the store IDs for "pickup-in-store" or the region IDs for
     * "same-day-delivery", to be removed for this
     * [type][google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.type].
     *
     * At least 1 value is required, and a maximum of 2000 values are allowed.
     * Each value must be a string with a length limit of 10 characters, matching
     * the pattern `[a-zA-Z0-9_-]+`, such as "store1" or "REGION-2". Otherwise, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string place_ids = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPlaceIds() {
      placeIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The IDs for this
     * [type][google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.type], such as
     * the store IDs for "pickup-in-store" or the region IDs for
     * "same-day-delivery", to be removed for this
     * [type][google.cloud.retail.v2.RemoveFulfillmentPlacesRequest.type].
     *
     * At least 1 value is required, and a maximum of 2000 values are allowed.
     * Each value must be a string with a length limit of 10 characters, matching
     * the pattern `[a-zA-Z0-9_-]+`, such as "store1" or "REGION-2". Otherwise, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string place_ids = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes of the placeIds to add.
     * @return This builder for chaining.
     */
    public Builder addPlaceIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensurePlaceIdsIsMutable();
      placeIds_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp removeTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        removeTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time when the fulfillment updates are issued, used to prevent
     * out-of-order updates on fulfillment information. If not provided, the
     * internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp remove_time = 4;</code>
     *
     * @return Whether the removeTime field is set.
     */
    public boolean hasRemoveTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time when the fulfillment updates are issued, used to prevent
     * out-of-order updates on fulfillment information. If not provided, the
     * internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp remove_time = 4;</code>
     *
     * @return The removeTime.
     */
    public com.google.protobuf.Timestamp getRemoveTime() {
      if (removeTimeBuilder_ == null) {
        return removeTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : removeTime_;
      } else {
        return removeTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the fulfillment updates are issued, used to prevent
     * out-of-order updates on fulfillment information. If not provided, the
     * internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp remove_time = 4;</code>
     */
    public Builder setRemoveTime(com.google.protobuf.Timestamp value) {
      if (removeTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        removeTime_ = value;
      } else {
        removeTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the fulfillment updates are issued, used to prevent
     * out-of-order updates on fulfillment information. If not provided, the
     * internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp remove_time = 4;</code>
     */
    public Builder setRemoveTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (removeTimeBuilder_ == null) {
        removeTime_ = builderForValue.build();
      } else {
        removeTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the fulfillment updates are issued, used to prevent
     * out-of-order updates on fulfillment information. If not provided, the
     * internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp remove_time = 4;</code>
     */
    public Builder mergeRemoveTime(com.google.protobuf.Timestamp value) {
      if (removeTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && removeTime_ != null
            && removeTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getRemoveTimeBuilder().mergeFrom(value);
        } else {
          removeTime_ = value;
        }
      } else {
        removeTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the fulfillment updates are issued, used to prevent
     * out-of-order updates on fulfillment information. If not provided, the
     * internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp remove_time = 4;</code>
     */
    public Builder clearRemoveTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      removeTime_ = null;
      if (removeTimeBuilder_ != null) {
        removeTimeBuilder_.dispose();
        removeTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the fulfillment updates are issued, used to prevent
     * out-of-order updates on fulfillment information. If not provided, the
     * internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp remove_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getRemoveTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getRemoveTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time when the fulfillment updates are issued, used to prevent
     * out-of-order updates on fulfillment information. If not provided, the
     * internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp remove_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getRemoveTimeOrBuilder() {
      if (removeTimeBuilder_ != null) {
        return removeTimeBuilder_.getMessageOrBuilder();
      } else {
        return removeTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : removeTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the fulfillment updates are issued, used to prevent
     * out-of-order updates on fulfillment information. If not provided, the
     * internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp remove_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getRemoveTimeFieldBuilder() {
      if (removeTimeBuilder_ == null) {
        removeTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getRemoveTime(), getParentForChildren(), isClean());
        removeTime_ = null;
      }
      return removeTimeBuilder_;
    }

    private boolean allowMissing_;
    /**
     *
     *
     * <pre>
     * If set to true, and the [Product][google.cloud.retail.v2.Product] is not
     * found, the fulfillment information will still be processed and retained for
     * at most 1 day and processed once the
     * [Product][google.cloud.retail.v2.Product] is created. If set to false, a
     * NOT_FOUND error is returned if the
     * [Product][google.cloud.retail.v2.Product] is not found.
     * </pre>
     *
     * <code>bool allow_missing = 5;</code>
     *
     * @return The allowMissing.
     */
    @java.lang.Override
    public boolean getAllowMissing() {
      return allowMissing_;
    }
    /**
     *
     *
     * <pre>
     * If set to true, and the [Product][google.cloud.retail.v2.Product] is not
     * found, the fulfillment information will still be processed and retained for
     * at most 1 day and processed once the
     * [Product][google.cloud.retail.v2.Product] is created. If set to false, a
     * NOT_FOUND error is returned if the
     * [Product][google.cloud.retail.v2.Product] is not found.
     * </pre>
     *
     * <code>bool allow_missing = 5;</code>
     *
     * @param value The allowMissing to set.
     * @return This builder for chaining.
     */
    public Builder setAllowMissing(boolean value) {

      allowMissing_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set to true, and the [Product][google.cloud.retail.v2.Product] is not
     * found, the fulfillment information will still be processed and retained for
     * at most 1 day and processed once the
     * [Product][google.cloud.retail.v2.Product] is created. If set to false, a
     * NOT_FOUND error is returned if the
     * [Product][google.cloud.retail.v2.Product] is not found.
     * </pre>
     *
     * <code>bool allow_missing = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowMissing() {
      bitField0_ = (bitField0_ & ~0x00000010);
      allowMissing_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.RemoveFulfillmentPlacesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.RemoveFulfillmentPlacesRequest)
  private static final com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest();
  }

  public static com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RemoveFulfillmentPlacesRequest> PARSER =
      new com.google.protobuf.AbstractParser<RemoveFulfillmentPlacesRequest>() {
        @java.lang.Override
        public RemoveFulfillmentPlacesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RemoveFulfillmentPlacesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RemoveFulfillmentPlacesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2.RemoveFulfillmentPlacesRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
