/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2/completion_service.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.retail.v2;

/**
 *
 *
 * <pre>
 * Response of the autocomplete query.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2.CompleteQueryResponse}
 */
public final class CompleteQueryResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.CompleteQueryResponse)
    CompleteQueryResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CompleteQueryResponse.newBuilder() to construct.
  private CompleteQueryResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CompleteQueryResponse() {
    completionResults_ = java.util.Collections.emptyList();
    attributionToken_ = "";
    recentSearchResults_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CompleteQueryResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2.CompletionServiceProto
        .internal_static_google_cloud_retail_v2_CompleteQueryResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2.CompletionServiceProto
        .internal_static_google_cloud_retail_v2_CompleteQueryResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2.CompleteQueryResponse.class,
            com.google.cloud.retail.v2.CompleteQueryResponse.Builder.class);
  }

  public interface CompletionResultOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2.CompleteQueryResponse.CompletionResult)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The suggestion.
     */
    java.lang.String getSuggestion();
    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The bytes for suggestion.
     */
    com.google.protobuf.ByteString getSuggestionBytes();

    /**
     *
     *
     * <pre>
     * Custom attributes for the suggestion term.
     *
     * * For "user-data", the attributes are additional custom attributes
     * ingested through BigQuery.
     *
     * * For "cloud-retail", the attributes are product attributes generated
     * by Cloud Retail. It requires
     * [UserEvent.product_details][google.cloud.retail.v2.UserEvent.product_details]
     * is imported properly.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 2;</code>
     */
    int getAttributesCount();
    /**
     *
     *
     * <pre>
     * Custom attributes for the suggestion term.
     *
     * * For "user-data", the attributes are additional custom attributes
     * ingested through BigQuery.
     *
     * * For "cloud-retail", the attributes are product attributes generated
     * by Cloud Retail. It requires
     * [UserEvent.product_details][google.cloud.retail.v2.UserEvent.product_details]
     * is imported properly.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 2;</code>
     */
    boolean containsAttributes(java.lang.String key);
    /** Use {@link #getAttributesMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, com.google.cloud.retail.v2.CustomAttribute> getAttributes();
    /**
     *
     *
     * <pre>
     * Custom attributes for the suggestion term.
     *
     * * For "user-data", the attributes are additional custom attributes
     * ingested through BigQuery.
     *
     * * For "cloud-retail", the attributes are product attributes generated
     * by Cloud Retail. It requires
     * [UserEvent.product_details][google.cloud.retail.v2.UserEvent.product_details]
     * is imported properly.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 2;</code>
     */
    java.util.Map<java.lang.String, com.google.cloud.retail.v2.CustomAttribute> getAttributesMap();
    /**
     *
     *
     * <pre>
     * Custom attributes for the suggestion term.
     *
     * * For "user-data", the attributes are additional custom attributes
     * ingested through BigQuery.
     *
     * * For "cloud-retail", the attributes are product attributes generated
     * by Cloud Retail. It requires
     * [UserEvent.product_details][google.cloud.retail.v2.UserEvent.product_details]
     * is imported properly.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 2;</code>
     */
    /* nullable */
    com.google.cloud.retail.v2.CustomAttribute getAttributesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.retail.v2.CustomAttribute defaultValue);
    /**
     *
     *
     * <pre>
     * Custom attributes for the suggestion term.
     *
     * * For "user-data", the attributes are additional custom attributes
     * ingested through BigQuery.
     *
     * * For "cloud-retail", the attributes are product attributes generated
     * by Cloud Retail. It requires
     * [UserEvent.product_details][google.cloud.retail.v2.UserEvent.product_details]
     * is imported properly.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 2;</code>
     */
    com.google.cloud.retail.v2.CustomAttribute getAttributesOrThrow(java.lang.String key);
  }
  /**
   *
   *
   * <pre>
   * Resource that represents completion results.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2.CompleteQueryResponse.CompletionResult}
   */
  public static final class CompletionResult extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.CompleteQueryResponse.CompletionResult)
      CompletionResultOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CompletionResult.newBuilder() to construct.
    private CompletionResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CompletionResult() {
      suggestion_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CompletionResult();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2.CompletionServiceProto
          .internal_static_google_cloud_retail_v2_CompleteQueryResponse_CompletionResult_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetAttributes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2.CompletionServiceProto
          .internal_static_google_cloud_retail_v2_CompleteQueryResponse_CompletionResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult.class,
              com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult.Builder.class);
    }

    public static final int SUGGESTION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object suggestion_ = "";
    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The suggestion.
     */
    @java.lang.Override
    public java.lang.String getSuggestion() {
      java.lang.Object ref = suggestion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        suggestion_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The bytes for suggestion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSuggestionBytes() {
      java.lang.Object ref = suggestion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        suggestion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ATTRIBUTES_FIELD_NUMBER = 2;

    private static final class AttributesDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.retail.v2.CustomAttribute>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String, com.google.cloud.retail.v2.CustomAttribute>newDefaultInstance(
                      com.google.cloud.retail.v2.CompletionServiceProto
                          .internal_static_google_cloud_retail_v2_CompleteQueryResponse_CompletionResult_AttributesEntry_descriptor,
                      com.google.protobuf.WireFormat.FieldType.STRING,
                      "",
                      com.google.protobuf.WireFormat.FieldType.MESSAGE,
                      com.google.cloud.retail.v2.CustomAttribute.getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.retail.v2.CustomAttribute>
        attributes_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.retail.v2.CustomAttribute>
        internalGetAttributes() {
      if (attributes_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AttributesDefaultEntryHolder.defaultEntry);
      }
      return attributes_;
    }

    public int getAttributesCount() {
      return internalGetAttributes().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Custom attributes for the suggestion term.
     *
     * * For "user-data", the attributes are additional custom attributes
     * ingested through BigQuery.
     *
     * * For "cloud-retail", the attributes are product attributes generated
     * by Cloud Retail. It requires
     * [UserEvent.product_details][google.cloud.retail.v2.UserEvent.product_details]
     * is imported properly.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 2;</code>
     */
    @java.lang.Override
    public boolean containsAttributes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAttributes().getMap().containsKey(key);
    }
    /** Use {@link #getAttributesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.retail.v2.CustomAttribute>
        getAttributes() {
      return getAttributesMap();
    }
    /**
     *
     *
     * <pre>
     * Custom attributes for the suggestion term.
     *
     * * For "user-data", the attributes are additional custom attributes
     * ingested through BigQuery.
     *
     * * For "cloud-retail", the attributes are product attributes generated
     * by Cloud Retail. It requires
     * [UserEvent.product_details][google.cloud.retail.v2.UserEvent.product_details]
     * is imported properly.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 2;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.retail.v2.CustomAttribute>
        getAttributesMap() {
      return internalGetAttributes().getMap();
    }
    /**
     *
     *
     * <pre>
     * Custom attributes for the suggestion term.
     *
     * * For "user-data", the attributes are additional custom attributes
     * ingested through BigQuery.
     *
     * * For "cloud-retail", the attributes are product attributes generated
     * by Cloud Retail. It requires
     * [UserEvent.product_details][google.cloud.retail.v2.UserEvent.product_details]
     * is imported properly.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 2;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.retail.v2.CustomAttribute getAttributesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.retail.v2.CustomAttribute defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.retail.v2.CustomAttribute> map =
          internalGetAttributes().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Custom attributes for the suggestion term.
     *
     * * For "user-data", the attributes are additional custom attributes
     * ingested through BigQuery.
     *
     * * For "cloud-retail", the attributes are product attributes generated
     * by Cloud Retail. It requires
     * [UserEvent.product_details][google.cloud.retail.v2.UserEvent.product_details]
     * is imported properly.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.CustomAttribute getAttributesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.retail.v2.CustomAttribute> map =
          internalGetAttributes().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(suggestion_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, suggestion_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetAttributes(), AttributesDefaultEntryHolder.defaultEntry, 2);
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(suggestion_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, suggestion_);
      }
      for (java.util.Map.Entry<java.lang.String, com.google.cloud.retail.v2.CustomAttribute> entry :
          internalGetAttributes().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, com.google.cloud.retail.v2.CustomAttribute>
            attributes__ =
                AttributesDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, attributes__);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult other =
          (com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult) obj;

      if (!getSuggestion().equals(other.getSuggestion())) return false;
      if (!internalGetAttributes().equals(other.internalGetAttributes())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SUGGESTION_FIELD_NUMBER;
      hash = (53 * hash) + getSuggestion().hashCode();
      if (!internalGetAttributes().getMap().isEmpty()) {
        hash = (37 * hash) + ATTRIBUTES_FIELD_NUMBER;
        hash = (53 * hash) + internalGetAttributes().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Resource that represents completion results.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2.CompleteQueryResponse.CompletionResult}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.CompleteQueryResponse.CompletionResult)
        com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2.CompletionServiceProto
            .internal_static_google_cloud_retail_v2_CompleteQueryResponse_CompletionResult_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 2:
            return internalGetAttributes();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
          int number) {
        switch (number) {
          case 2:
            return internalGetMutableAttributes();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2.CompletionServiceProto
            .internal_static_google_cloud_retail_v2_CompleteQueryResponse_CompletionResult_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult.class,
                com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult.Builder.class);
      }

      // Construct using
      // com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        suggestion_ = "";
        internalGetMutableAttributes().clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2.CompletionServiceProto
            .internal_static_google_cloud_retail_v2_CompleteQueryResponse_CompletionResult_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult
          getDefaultInstanceForType() {
        return com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult build() {
        com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult buildPartial() {
        com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult result =
            new com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.suggestion_ = suggestion_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.attributes_ =
              internalGetAttributes().build(AttributesDefaultEntryHolder.defaultEntry);
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult) {
          return mergeFrom(
              (com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult other) {
        if (other
            == com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult
                .getDefaultInstance()) return this;
        if (!other.getSuggestion().isEmpty()) {
          suggestion_ = other.suggestion_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        internalGetMutableAttributes().mergeFrom(other.internalGetAttributes());
        bitField0_ |= 0x00000002;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  suggestion_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.protobuf.MapEntry<
                          java.lang.String, com.google.cloud.retail.v2.CustomAttribute>
                      attributes__ =
                          input.readMessage(
                              AttributesDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableAttributes()
                      .ensureBuilderMap()
                      .put(attributes__.getKey(), attributes__.getValue());
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object suggestion_ = "";
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @return The suggestion.
       */
      public java.lang.String getSuggestion() {
        java.lang.Object ref = suggestion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          suggestion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @return The bytes for suggestion.
       */
      public com.google.protobuf.ByteString getSuggestionBytes() {
        java.lang.Object ref = suggestion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          suggestion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @param value The suggestion to set.
       * @return This builder for chaining.
       */
      public Builder setSuggestion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        suggestion_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSuggestion() {
        suggestion_ = getDefaultInstance().getSuggestion();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @param value The bytes for suggestion to set.
       * @return This builder for chaining.
       */
      public Builder setSuggestionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        suggestion_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private static final class AttributesConverter
          implements com.google.protobuf.MapFieldBuilder.Converter<
              java.lang.String,
              com.google.cloud.retail.v2.CustomAttributeOrBuilder,
              com.google.cloud.retail.v2.CustomAttribute> {
        @java.lang.Override
        public com.google.cloud.retail.v2.CustomAttribute build(
            com.google.cloud.retail.v2.CustomAttributeOrBuilder val) {
          if (val instanceof com.google.cloud.retail.v2.CustomAttribute) {
            return (com.google.cloud.retail.v2.CustomAttribute) val;
          }
          return ((com.google.cloud.retail.v2.CustomAttribute.Builder) val).build();
        }

        @java.lang.Override
        public com.google.protobuf.MapEntry<
                java.lang.String, com.google.cloud.retail.v2.CustomAttribute>
            defaultEntry() {
          return AttributesDefaultEntryHolder.defaultEntry;
        }
      };

      private static final AttributesConverter attributesConverter = new AttributesConverter();

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.cloud.retail.v2.CustomAttributeOrBuilder,
              com.google.cloud.retail.v2.CustomAttribute,
              com.google.cloud.retail.v2.CustomAttribute.Builder>
          attributes_;

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.cloud.retail.v2.CustomAttributeOrBuilder,
              com.google.cloud.retail.v2.CustomAttribute,
              com.google.cloud.retail.v2.CustomAttribute.Builder>
          internalGetAttributes() {
        if (attributes_ == null) {
          return new com.google.protobuf.MapFieldBuilder<>(attributesConverter);
        }
        return attributes_;
      }

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.cloud.retail.v2.CustomAttributeOrBuilder,
              com.google.cloud.retail.v2.CustomAttribute,
              com.google.cloud.retail.v2.CustomAttribute.Builder>
          internalGetMutableAttributes() {
        if (attributes_ == null) {
          attributes_ = new com.google.protobuf.MapFieldBuilder<>(attributesConverter);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return attributes_;
      }

      public int getAttributesCount() {
        return internalGetAttributes().ensureBuilderMap().size();
      }
      /**
       *
       *
       * <pre>
       * Custom attributes for the suggestion term.
       *
       * * For "user-data", the attributes are additional custom attributes
       * ingested through BigQuery.
       *
       * * For "cloud-retail", the attributes are product attributes generated
       * by Cloud Retail. It requires
       * [UserEvent.product_details][google.cloud.retail.v2.UserEvent.product_details]
       * is imported properly.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 2;</code>
       */
      @java.lang.Override
      public boolean containsAttributes(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetAttributes().ensureBuilderMap().containsKey(key);
      }
      /** Use {@link #getAttributesMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.retail.v2.CustomAttribute>
          getAttributes() {
        return getAttributesMap();
      }
      /**
       *
       *
       * <pre>
       * Custom attributes for the suggestion term.
       *
       * * For "user-data", the attributes are additional custom attributes
       * ingested through BigQuery.
       *
       * * For "cloud-retail", the attributes are product attributes generated
       * by Cloud Retail. It requires
       * [UserEvent.product_details][google.cloud.retail.v2.UserEvent.product_details]
       * is imported properly.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 2;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, com.google.cloud.retail.v2.CustomAttribute>
          getAttributesMap() {
        return internalGetAttributes().getImmutableMap();
      }
      /**
       *
       *
       * <pre>
       * Custom attributes for the suggestion term.
       *
       * * For "user-data", the attributes are additional custom attributes
       * ingested through BigQuery.
       *
       * * For "cloud-retail", the attributes are product attributes generated
       * by Cloud Retail. It requires
       * [UserEvent.product_details][google.cloud.retail.v2.UserEvent.product_details]
       * is imported properly.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 2;</code>
       */
      @java.lang.Override
      public /* nullable */ com.google.cloud.retail.v2.CustomAttribute getAttributesOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.retail.v2.CustomAttribute defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.retail.v2.CustomAttributeOrBuilder> map =
            internalGetMutableAttributes().ensureBuilderMap();
        return map.containsKey(key) ? attributesConverter.build(map.get(key)) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Custom attributes for the suggestion term.
       *
       * * For "user-data", the attributes are additional custom attributes
       * ingested through BigQuery.
       *
       * * For "cloud-retail", the attributes are product attributes generated
       * by Cloud Retail. It requires
       * [UserEvent.product_details][google.cloud.retail.v2.UserEvent.product_details]
       * is imported properly.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.retail.v2.CustomAttribute getAttributesOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.retail.v2.CustomAttributeOrBuilder> map =
            internalGetMutableAttributes().ensureBuilderMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return attributesConverter.build(map.get(key));
      }

      public Builder clearAttributes() {
        bitField0_ = (bitField0_ & ~0x00000002);
        internalGetMutableAttributes().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Custom attributes for the suggestion term.
       *
       * * For "user-data", the attributes are additional custom attributes
       * ingested through BigQuery.
       *
       * * For "cloud-retail", the attributes are product attributes generated
       * by Cloud Retail. It requires
       * [UserEvent.product_details][google.cloud.retail.v2.UserEvent.product_details]
       * is imported properly.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 2;</code>
       */
      public Builder removeAttributes(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableAttributes().ensureBuilderMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.retail.v2.CustomAttribute>
          getMutableAttributes() {
        bitField0_ |= 0x00000002;
        return internalGetMutableAttributes().ensureMessageMap();
      }
      /**
       *
       *
       * <pre>
       * Custom attributes for the suggestion term.
       *
       * * For "user-data", the attributes are additional custom attributes
       * ingested through BigQuery.
       *
       * * For "cloud-retail", the attributes are product attributes generated
       * by Cloud Retail. It requires
       * [UserEvent.product_details][google.cloud.retail.v2.UserEvent.product_details]
       * is imported properly.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 2;</code>
       */
      public Builder putAttributes(
          java.lang.String key, com.google.cloud.retail.v2.CustomAttribute value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableAttributes().ensureBuilderMap().put(key, value);
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Custom attributes for the suggestion term.
       *
       * * For "user-data", the attributes are additional custom attributes
       * ingested through BigQuery.
       *
       * * For "cloud-retail", the attributes are product attributes generated
       * by Cloud Retail. It requires
       * [UserEvent.product_details][google.cloud.retail.v2.UserEvent.product_details]
       * is imported properly.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 2;</code>
       */
      public Builder putAllAttributes(
          java.util.Map<java.lang.String, com.google.cloud.retail.v2.CustomAttribute> values) {
        for (java.util.Map.Entry<java.lang.String, com.google.cloud.retail.v2.CustomAttribute> e :
            values.entrySet()) {
          if (e.getKey() == null || e.getValue() == null) {
            throw new NullPointerException();
          }
        }
        internalGetMutableAttributes().ensureBuilderMap().putAll(values);
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Custom attributes for the suggestion term.
       *
       * * For "user-data", the attributes are additional custom attributes
       * ingested through BigQuery.
       *
       * * For "cloud-retail", the attributes are product attributes generated
       * by Cloud Retail. It requires
       * [UserEvent.product_details][google.cloud.retail.v2.UserEvent.product_details]
       * is imported properly.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 2;</code>
       */
      public com.google.cloud.retail.v2.CustomAttribute.Builder putAttributesBuilderIfAbsent(
          java.lang.String key) {
        java.util.Map<java.lang.String, com.google.cloud.retail.v2.CustomAttributeOrBuilder>
            builderMap = internalGetMutableAttributes().ensureBuilderMap();
        com.google.cloud.retail.v2.CustomAttributeOrBuilder entry = builderMap.get(key);
        if (entry == null) {
          entry = com.google.cloud.retail.v2.CustomAttribute.newBuilder();
          builderMap.put(key, entry);
        }
        if (entry instanceof com.google.cloud.retail.v2.CustomAttribute) {
          entry = ((com.google.cloud.retail.v2.CustomAttribute) entry).toBuilder();
          builderMap.put(key, entry);
        }
        return (com.google.cloud.retail.v2.CustomAttribute.Builder) entry;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.CompleteQueryResponse.CompletionResult)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.CompleteQueryResponse.CompletionResult)
    private static final com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult();
    }

    public static com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CompletionResult> PARSER =
        new com.google.protobuf.AbstractParser<CompletionResult>() {
          @java.lang.Override
          public CompletionResult parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CompletionResult> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CompletionResult> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface RecentSearchResultOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The recent search query.
     * </pre>
     *
     * <code>string recent_search = 1;</code>
     *
     * @return The recentSearch.
     */
    java.lang.String getRecentSearch();
    /**
     *
     *
     * <pre>
     * The recent search query.
     * </pre>
     *
     * <code>string recent_search = 1;</code>
     *
     * @return The bytes for recentSearch.
     */
    com.google.protobuf.ByteString getRecentSearchBytes();
  }
  /**
   *
   *
   * <pre>
   * Recent search of this user.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult}
   */
  public static final class RecentSearchResult extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult)
      RecentSearchResultOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use RecentSearchResult.newBuilder() to construct.
    private RecentSearchResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RecentSearchResult() {
      recentSearch_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RecentSearchResult();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2.CompletionServiceProto
          .internal_static_google_cloud_retail_v2_CompleteQueryResponse_RecentSearchResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2.CompletionServiceProto
          .internal_static_google_cloud_retail_v2_CompleteQueryResponse_RecentSearchResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult.class,
              com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult.Builder.class);
    }

    public static final int RECENT_SEARCH_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object recentSearch_ = "";
    /**
     *
     *
     * <pre>
     * The recent search query.
     * </pre>
     *
     * <code>string recent_search = 1;</code>
     *
     * @return The recentSearch.
     */
    @java.lang.Override
    public java.lang.String getRecentSearch() {
      java.lang.Object ref = recentSearch_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        recentSearch_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The recent search query.
     * </pre>
     *
     * <code>string recent_search = 1;</code>
     *
     * @return The bytes for recentSearch.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRecentSearchBytes() {
      java.lang.Object ref = recentSearch_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        recentSearch_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(recentSearch_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, recentSearch_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(recentSearch_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, recentSearch_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult other =
          (com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult) obj;

      if (!getRecentSearch().equals(other.getRecentSearch())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + RECENT_SEARCH_FIELD_NUMBER;
      hash = (53 * hash) + getRecentSearch().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Recent search of this user.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult)
        com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2.CompletionServiceProto
            .internal_static_google_cloud_retail_v2_CompleteQueryResponse_RecentSearchResult_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2.CompletionServiceProto
            .internal_static_google_cloud_retail_v2_CompleteQueryResponse_RecentSearchResult_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult.class,
                com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult.Builder.class);
      }

      // Construct using
      // com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        recentSearch_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2.CompletionServiceProto
            .internal_static_google_cloud_retail_v2_CompleteQueryResponse_RecentSearchResult_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult
          getDefaultInstanceForType() {
        return com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult build() {
        com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult buildPartial() {
        com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult result =
            new com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.recentSearch_ = recentSearch_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult) {
          return mergeFrom(
              (com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult other) {
        if (other
            == com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult
                .getDefaultInstance()) return this;
        if (!other.getRecentSearch().isEmpty()) {
          recentSearch_ = other.recentSearch_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  recentSearch_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object recentSearch_ = "";
      /**
       *
       *
       * <pre>
       * The recent search query.
       * </pre>
       *
       * <code>string recent_search = 1;</code>
       *
       * @return The recentSearch.
       */
      public java.lang.String getRecentSearch() {
        java.lang.Object ref = recentSearch_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          recentSearch_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The recent search query.
       * </pre>
       *
       * <code>string recent_search = 1;</code>
       *
       * @return The bytes for recentSearch.
       */
      public com.google.protobuf.ByteString getRecentSearchBytes() {
        java.lang.Object ref = recentSearch_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          recentSearch_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The recent search query.
       * </pre>
       *
       * <code>string recent_search = 1;</code>
       *
       * @param value The recentSearch to set.
       * @return This builder for chaining.
       */
      public Builder setRecentSearch(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        recentSearch_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The recent search query.
       * </pre>
       *
       * <code>string recent_search = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRecentSearch() {
        recentSearch_ = getDefaultInstance().getRecentSearch();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The recent search query.
       * </pre>
       *
       * <code>string recent_search = 1;</code>
       *
       * @param value The bytes for recentSearch to set.
       * @return This builder for chaining.
       */
      public Builder setRecentSearchBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        recentSearch_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult)
    private static final com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult();
    }

    public static com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RecentSearchResult> PARSER =
        new com.google.protobuf.AbstractParser<RecentSearchResult>() {
          @java.lang.Override
          public RecentSearchResult parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RecentSearchResult> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RecentSearchResult> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int COMPLETION_RESULTS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult>
      completionResults_;
  /**
   *
   *
   * <pre>
   * Results of the matching suggestions. The result list is ordered and the
   * first result is top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.CompleteQueryResponse.CompletionResult completion_results = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult>
      getCompletionResultsList() {
    return completionResults_;
  }
  /**
   *
   *
   * <pre>
   * Results of the matching suggestions. The result list is ordered and the
   * first result is top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.CompleteQueryResponse.CompletionResult completion_results = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResultOrBuilder>
      getCompletionResultsOrBuilderList() {
    return completionResults_;
  }
  /**
   *
   *
   * <pre>
   * Results of the matching suggestions. The result list is ordered and the
   * first result is top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.CompleteQueryResponse.CompletionResult completion_results = 1;
   * </code>
   */
  @java.lang.Override
  public int getCompletionResultsCount() {
    return completionResults_.size();
  }
  /**
   *
   *
   * <pre>
   * Results of the matching suggestions. The result list is ordered and the
   * first result is top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.CompleteQueryResponse.CompletionResult completion_results = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult getCompletionResults(
      int index) {
    return completionResults_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Results of the matching suggestions. The result list is ordered and the
   * first result is top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.CompleteQueryResponse.CompletionResult completion_results = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResultOrBuilder
      getCompletionResultsOrBuilder(int index) {
    return completionResults_.get(index);
  }

  public static final int ATTRIBUTION_TOKEN_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object attributionToken_ = "";
  /**
   *
   *
   * <pre>
   * A unique complete token. This should be included in the
   * [UserEvent.completion_detail][google.cloud.retail.v2.UserEvent.completion_detail]
   * for search events resulting from this completion, which enables accurate
   * attribution of complete model performance.
   * </pre>
   *
   * <code>string attribution_token = 2;</code>
   *
   * @return The attributionToken.
   */
  @java.lang.Override
  public java.lang.String getAttributionToken() {
    java.lang.Object ref = attributionToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      attributionToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A unique complete token. This should be included in the
   * [UserEvent.completion_detail][google.cloud.retail.v2.UserEvent.completion_detail]
   * for search events resulting from this completion, which enables accurate
   * attribution of complete model performance.
   * </pre>
   *
   * <code>string attribution_token = 2;</code>
   *
   * @return The bytes for attributionToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAttributionTokenBytes() {
    java.lang.Object ref = attributionToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      attributionToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RECENT_SEARCH_RESULTS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult>
      recentSearchResults_;
  /**
   *
   *
   * <pre>
   * Matched recent searches of this user. The maximum number of recent searches
   * is 10. This field is a restricted feature. Contact Retail Search support
   * team if you are interested in enabling it.
   *
   * This feature is only available when
   * [CompleteQueryRequest.visitor_id][google.cloud.retail.v2.CompleteQueryRequest.visitor_id]
   * field is set and [UserEvent][google.cloud.retail.v2.UserEvent] is imported.
   * The recent searches satisfy the follow rules:
   *
   *  * They are ordered from latest to oldest.
   *
   *  * They are matched with
   *  [CompleteQueryRequest.query][google.cloud.retail.v2.CompleteQueryRequest.query]
   *  case insensitively.
   *
   *  * They are transformed to lower case.
   *
   *  * They are UTF-8 safe.
   *
   * Recent searches are deduplicated. More recent searches will be reserved
   * when duplication happens.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult recent_search_results = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult>
      getRecentSearchResultsList() {
    return recentSearchResults_;
  }
  /**
   *
   *
   * <pre>
   * Matched recent searches of this user. The maximum number of recent searches
   * is 10. This field is a restricted feature. Contact Retail Search support
   * team if you are interested in enabling it.
   *
   * This feature is only available when
   * [CompleteQueryRequest.visitor_id][google.cloud.retail.v2.CompleteQueryRequest.visitor_id]
   * field is set and [UserEvent][google.cloud.retail.v2.UserEvent] is imported.
   * The recent searches satisfy the follow rules:
   *
   *  * They are ordered from latest to oldest.
   *
   *  * They are matched with
   *  [CompleteQueryRequest.query][google.cloud.retail.v2.CompleteQueryRequest.query]
   *  case insensitively.
   *
   *  * They are transformed to lower case.
   *
   *  * They are UTF-8 safe.
   *
   * Recent searches are deduplicated. More recent searches will be reserved
   * when duplication happens.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult recent_search_results = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResultOrBuilder>
      getRecentSearchResultsOrBuilderList() {
    return recentSearchResults_;
  }
  /**
   *
   *
   * <pre>
   * Matched recent searches of this user. The maximum number of recent searches
   * is 10. This field is a restricted feature. Contact Retail Search support
   * team if you are interested in enabling it.
   *
   * This feature is only available when
   * [CompleteQueryRequest.visitor_id][google.cloud.retail.v2.CompleteQueryRequest.visitor_id]
   * field is set and [UserEvent][google.cloud.retail.v2.UserEvent] is imported.
   * The recent searches satisfy the follow rules:
   *
   *  * They are ordered from latest to oldest.
   *
   *  * They are matched with
   *  [CompleteQueryRequest.query][google.cloud.retail.v2.CompleteQueryRequest.query]
   *  case insensitively.
   *
   *  * They are transformed to lower case.
   *
   *  * They are UTF-8 safe.
   *
   * Recent searches are deduplicated. More recent searches will be reserved
   * when duplication happens.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult recent_search_results = 3;
   * </code>
   */
  @java.lang.Override
  public int getRecentSearchResultsCount() {
    return recentSearchResults_.size();
  }
  /**
   *
   *
   * <pre>
   * Matched recent searches of this user. The maximum number of recent searches
   * is 10. This field is a restricted feature. Contact Retail Search support
   * team if you are interested in enabling it.
   *
   * This feature is only available when
   * [CompleteQueryRequest.visitor_id][google.cloud.retail.v2.CompleteQueryRequest.visitor_id]
   * field is set and [UserEvent][google.cloud.retail.v2.UserEvent] is imported.
   * The recent searches satisfy the follow rules:
   *
   *  * They are ordered from latest to oldest.
   *
   *  * They are matched with
   *  [CompleteQueryRequest.query][google.cloud.retail.v2.CompleteQueryRequest.query]
   *  case insensitively.
   *
   *  * They are transformed to lower case.
   *
   *  * They are UTF-8 safe.
   *
   * Recent searches are deduplicated. More recent searches will be reserved
   * when duplication happens.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult recent_search_results = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult getRecentSearchResults(
      int index) {
    return recentSearchResults_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Matched recent searches of this user. The maximum number of recent searches
   * is 10. This field is a restricted feature. Contact Retail Search support
   * team if you are interested in enabling it.
   *
   * This feature is only available when
   * [CompleteQueryRequest.visitor_id][google.cloud.retail.v2.CompleteQueryRequest.visitor_id]
   * field is set and [UserEvent][google.cloud.retail.v2.UserEvent] is imported.
   * The recent searches satisfy the follow rules:
   *
   *  * They are ordered from latest to oldest.
   *
   *  * They are matched with
   *  [CompleteQueryRequest.query][google.cloud.retail.v2.CompleteQueryRequest.query]
   *  case insensitively.
   *
   *  * They are transformed to lower case.
   *
   *  * They are UTF-8 safe.
   *
   * Recent searches are deduplicated. More recent searches will be reserved
   * when duplication happens.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult recent_search_results = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResultOrBuilder
      getRecentSearchResultsOrBuilder(int index) {
    return recentSearchResults_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < completionResults_.size(); i++) {
      output.writeMessage(1, completionResults_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(attributionToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, attributionToken_);
    }
    for (int i = 0; i < recentSearchResults_.size(); i++) {
      output.writeMessage(3, recentSearchResults_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < completionResults_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(1, completionResults_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(attributionToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, attributionToken_);
    }
    for (int i = 0; i < recentSearchResults_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, recentSearchResults_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2.CompleteQueryResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2.CompleteQueryResponse other =
        (com.google.cloud.retail.v2.CompleteQueryResponse) obj;

    if (!getCompletionResultsList().equals(other.getCompletionResultsList())) return false;
    if (!getAttributionToken().equals(other.getAttributionToken())) return false;
    if (!getRecentSearchResultsList().equals(other.getRecentSearchResultsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getCompletionResultsCount() > 0) {
      hash = (37 * hash) + COMPLETION_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getCompletionResultsList().hashCode();
    }
    hash = (37 * hash) + ATTRIBUTION_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getAttributionToken().hashCode();
    if (getRecentSearchResultsCount() > 0) {
      hash = (37 * hash) + RECENT_SEARCH_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getRecentSearchResultsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2.CompleteQueryResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.CompleteQueryResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.CompleteQueryResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.CompleteQueryResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.CompleteQueryResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.CompleteQueryResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.CompleteQueryResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.CompleteQueryResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.CompleteQueryResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.CompleteQueryResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.CompleteQueryResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.CompleteQueryResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2.CompleteQueryResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response of the autocomplete query.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2.CompleteQueryResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.CompleteQueryResponse)
      com.google.cloud.retail.v2.CompleteQueryResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2.CompletionServiceProto
          .internal_static_google_cloud_retail_v2_CompleteQueryResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2.CompletionServiceProto
          .internal_static_google_cloud_retail_v2_CompleteQueryResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2.CompleteQueryResponse.class,
              com.google.cloud.retail.v2.CompleteQueryResponse.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2.CompleteQueryResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (completionResultsBuilder_ == null) {
        completionResults_ = java.util.Collections.emptyList();
      } else {
        completionResults_ = null;
        completionResultsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      attributionToken_ = "";
      if (recentSearchResultsBuilder_ == null) {
        recentSearchResults_ = java.util.Collections.emptyList();
      } else {
        recentSearchResults_ = null;
        recentSearchResultsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2.CompletionServiceProto
          .internal_static_google_cloud_retail_v2_CompleteQueryResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.CompleteQueryResponse getDefaultInstanceForType() {
      return com.google.cloud.retail.v2.CompleteQueryResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.CompleteQueryResponse build() {
      com.google.cloud.retail.v2.CompleteQueryResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.CompleteQueryResponse buildPartial() {
      com.google.cloud.retail.v2.CompleteQueryResponse result =
          new com.google.cloud.retail.v2.CompleteQueryResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.retail.v2.CompleteQueryResponse result) {
      if (completionResultsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          completionResults_ = java.util.Collections.unmodifiableList(completionResults_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.completionResults_ = completionResults_;
      } else {
        result.completionResults_ = completionResultsBuilder_.build();
      }
      if (recentSearchResultsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          recentSearchResults_ = java.util.Collections.unmodifiableList(recentSearchResults_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.recentSearchResults_ = recentSearchResults_;
      } else {
        result.recentSearchResults_ = recentSearchResultsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.retail.v2.CompleteQueryResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.attributionToken_ = attributionToken_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2.CompleteQueryResponse) {
        return mergeFrom((com.google.cloud.retail.v2.CompleteQueryResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2.CompleteQueryResponse other) {
      if (other == com.google.cloud.retail.v2.CompleteQueryResponse.getDefaultInstance())
        return this;
      if (completionResultsBuilder_ == null) {
        if (!other.completionResults_.isEmpty()) {
          if (completionResults_.isEmpty()) {
            completionResults_ = other.completionResults_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureCompletionResultsIsMutable();
            completionResults_.addAll(other.completionResults_);
          }
          onChanged();
        }
      } else {
        if (!other.completionResults_.isEmpty()) {
          if (completionResultsBuilder_.isEmpty()) {
            completionResultsBuilder_.dispose();
            completionResultsBuilder_ = null;
            completionResults_ = other.completionResults_;
            bitField0_ = (bitField0_ & ~0x00000001);
            completionResultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCompletionResultsFieldBuilder()
                    : null;
          } else {
            completionResultsBuilder_.addAllMessages(other.completionResults_);
          }
        }
      }
      if (!other.getAttributionToken().isEmpty()) {
        attributionToken_ = other.attributionToken_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (recentSearchResultsBuilder_ == null) {
        if (!other.recentSearchResults_.isEmpty()) {
          if (recentSearchResults_.isEmpty()) {
            recentSearchResults_ = other.recentSearchResults_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureRecentSearchResultsIsMutable();
            recentSearchResults_.addAll(other.recentSearchResults_);
          }
          onChanged();
        }
      } else {
        if (!other.recentSearchResults_.isEmpty()) {
          if (recentSearchResultsBuilder_.isEmpty()) {
            recentSearchResultsBuilder_.dispose();
            recentSearchResultsBuilder_ = null;
            recentSearchResults_ = other.recentSearchResults_;
            bitField0_ = (bitField0_ & ~0x00000004);
            recentSearchResultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRecentSearchResultsFieldBuilder()
                    : null;
          } else {
            recentSearchResultsBuilder_.addAllMessages(other.recentSearchResults_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult m =
                    input.readMessage(
                        com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult.parser(),
                        extensionRegistry);
                if (completionResultsBuilder_ == null) {
                  ensureCompletionResultsIsMutable();
                  completionResults_.add(m);
                } else {
                  completionResultsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                attributionToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult m =
                    input.readMessage(
                        com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult
                            .parser(),
                        extensionRegistry);
                if (recentSearchResultsBuilder_ == null) {
                  ensureRecentSearchResultsIsMutable();
                  recentSearchResults_.add(m);
                } else {
                  recentSearchResultsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult>
        completionResults_ = java.util.Collections.emptyList();

    private void ensureCompletionResultsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        completionResults_ =
            new java.util.ArrayList<
                com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult>(
                completionResults_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult,
            com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult.Builder,
            com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResultOrBuilder>
        completionResultsBuilder_;

    /**
     *
     *
     * <pre>
     * Results of the matching suggestions. The result list is ordered and the
     * first result is top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult>
        getCompletionResultsList() {
      if (completionResultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(completionResults_);
      } else {
        return completionResultsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matching suggestions. The result list is ordered and the
     * first result is top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public int getCompletionResultsCount() {
      if (completionResultsBuilder_ == null) {
        return completionResults_.size();
      } else {
        return completionResultsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matching suggestions. The result list is ordered and the
     * first result is top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult getCompletionResults(
        int index) {
      if (completionResultsBuilder_ == null) {
        return completionResults_.get(index);
      } else {
        return completionResultsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matching suggestions. The result list is ordered and the
     * first result is top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public Builder setCompletionResults(
        int index, com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult value) {
      if (completionResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCompletionResultsIsMutable();
        completionResults_.set(index, value);
        onChanged();
      } else {
        completionResultsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matching suggestions. The result list is ordered and the
     * first result is top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public Builder setCompletionResults(
        int index,
        com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult.Builder builderForValue) {
      if (completionResultsBuilder_ == null) {
        ensureCompletionResultsIsMutable();
        completionResults_.set(index, builderForValue.build());
        onChanged();
      } else {
        completionResultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matching suggestions. The result list is ordered and the
     * first result is top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public Builder addCompletionResults(
        com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult value) {
      if (completionResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCompletionResultsIsMutable();
        completionResults_.add(value);
        onChanged();
      } else {
        completionResultsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matching suggestions. The result list is ordered and the
     * first result is top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public Builder addCompletionResults(
        int index, com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult value) {
      if (completionResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCompletionResultsIsMutable();
        completionResults_.add(index, value);
        onChanged();
      } else {
        completionResultsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matching suggestions. The result list is ordered and the
     * first result is top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public Builder addCompletionResults(
        com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult.Builder builderForValue) {
      if (completionResultsBuilder_ == null) {
        ensureCompletionResultsIsMutable();
        completionResults_.add(builderForValue.build());
        onChanged();
      } else {
        completionResultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matching suggestions. The result list is ordered and the
     * first result is top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public Builder addCompletionResults(
        int index,
        com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult.Builder builderForValue) {
      if (completionResultsBuilder_ == null) {
        ensureCompletionResultsIsMutable();
        completionResults_.add(index, builderForValue.build());
        onChanged();
      } else {
        completionResultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matching suggestions. The result list is ordered and the
     * first result is top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public Builder addAllCompletionResults(
        java.lang.Iterable<
                ? extends com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult>
            values) {
      if (completionResultsBuilder_ == null) {
        ensureCompletionResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, completionResults_);
        onChanged();
      } else {
        completionResultsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matching suggestions. The result list is ordered and the
     * first result is top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public Builder clearCompletionResults() {
      if (completionResultsBuilder_ == null) {
        completionResults_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        completionResultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matching suggestions. The result list is ordered and the
     * first result is top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public Builder removeCompletionResults(int index) {
      if (completionResultsBuilder_ == null) {
        ensureCompletionResultsIsMutable();
        completionResults_.remove(index);
        onChanged();
      } else {
        completionResultsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matching suggestions. The result list is ordered and the
     * first result is top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult.Builder
        getCompletionResultsBuilder(int index) {
      return getCompletionResultsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Results of the matching suggestions. The result list is ordered and the
     * first result is top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResultOrBuilder
        getCompletionResultsOrBuilder(int index) {
      if (completionResultsBuilder_ == null) {
        return completionResults_.get(index);
      } else {
        return completionResultsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matching suggestions. The result list is ordered and the
     * first result is top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResultOrBuilder>
        getCompletionResultsOrBuilderList() {
      if (completionResultsBuilder_ != null) {
        return completionResultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(completionResults_);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matching suggestions. The result list is ordered and the
     * first result is top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult.Builder
        addCompletionResultsBuilder() {
      return getCompletionResultsFieldBuilder()
          .addBuilder(
              com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Results of the matching suggestions. The result list is ordered and the
     * first result is top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult.Builder
        addCompletionResultsBuilder(int index) {
      return getCompletionResultsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Results of the matching suggestions. The result list is ordered and the
     * first result is top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult.Builder>
        getCompletionResultsBuilderList() {
      return getCompletionResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult,
            com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult.Builder,
            com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResultOrBuilder>
        getCompletionResultsFieldBuilder() {
      if (completionResultsBuilder_ == null) {
        completionResultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult,
                com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResult.Builder,
                com.google.cloud.retail.v2.CompleteQueryResponse.CompletionResultOrBuilder>(
                completionResults_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        completionResults_ = null;
      }
      return completionResultsBuilder_;
    }

    private java.lang.Object attributionToken_ = "";
    /**
     *
     *
     * <pre>
     * A unique complete token. This should be included in the
     * [UserEvent.completion_detail][google.cloud.retail.v2.UserEvent.completion_detail]
     * for search events resulting from this completion, which enables accurate
     * attribution of complete model performance.
     * </pre>
     *
     * <code>string attribution_token = 2;</code>
     *
     * @return The attributionToken.
     */
    public java.lang.String getAttributionToken() {
      java.lang.Object ref = attributionToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        attributionToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique complete token. This should be included in the
     * [UserEvent.completion_detail][google.cloud.retail.v2.UserEvent.completion_detail]
     * for search events resulting from this completion, which enables accurate
     * attribution of complete model performance.
     * </pre>
     *
     * <code>string attribution_token = 2;</code>
     *
     * @return The bytes for attributionToken.
     */
    public com.google.protobuf.ByteString getAttributionTokenBytes() {
      java.lang.Object ref = attributionToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        attributionToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique complete token. This should be included in the
     * [UserEvent.completion_detail][google.cloud.retail.v2.UserEvent.completion_detail]
     * for search events resulting from this completion, which enables accurate
     * attribution of complete model performance.
     * </pre>
     *
     * <code>string attribution_token = 2;</code>
     *
     * @param value The attributionToken to set.
     * @return This builder for chaining.
     */
    public Builder setAttributionToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      attributionToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique complete token. This should be included in the
     * [UserEvent.completion_detail][google.cloud.retail.v2.UserEvent.completion_detail]
     * for search events resulting from this completion, which enables accurate
     * attribution of complete model performance.
     * </pre>
     *
     * <code>string attribution_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAttributionToken() {
      attributionToken_ = getDefaultInstance().getAttributionToken();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique complete token. This should be included in the
     * [UserEvent.completion_detail][google.cloud.retail.v2.UserEvent.completion_detail]
     * for search events resulting from this completion, which enables accurate
     * attribution of complete model performance.
     * </pre>
     *
     * <code>string attribution_token = 2;</code>
     *
     * @param value The bytes for attributionToken to set.
     * @return This builder for chaining.
     */
    public Builder setAttributionTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      attributionToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult>
        recentSearchResults_ = java.util.Collections.emptyList();

    private void ensureRecentSearchResultsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        recentSearchResults_ =
            new java.util.ArrayList<
                com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult>(
                recentSearchResults_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult,
            com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult.Builder,
            com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResultOrBuilder>
        recentSearchResultsBuilder_;

    /**
     *
     *
     * <pre>
     * Matched recent searches of this user. The maximum number of recent searches
     * is 10. This field is a restricted feature. Contact Retail Search support
     * team if you are interested in enabling it.
     *
     * This feature is only available when
     * [CompleteQueryRequest.visitor_id][google.cloud.retail.v2.CompleteQueryRequest.visitor_id]
     * field is set and [UserEvent][google.cloud.retail.v2.UserEvent] is imported.
     * The recent searches satisfy the follow rules:
     *
     *  * They are ordered from latest to oldest.
     *
     *  * They are matched with
     *  [CompleteQueryRequest.query][google.cloud.retail.v2.CompleteQueryRequest.query]
     *  case insensitively.
     *
     *  * They are transformed to lower case.
     *
     *  * They are UTF-8 safe.
     *
     * Recent searches are deduplicated. More recent searches will be reserved
     * when duplication happens.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult recent_search_results = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult>
        getRecentSearchResultsList() {
      if (recentSearchResultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(recentSearchResults_);
      } else {
        return recentSearchResultsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Matched recent searches of this user. The maximum number of recent searches
     * is 10. This field is a restricted feature. Contact Retail Search support
     * team if you are interested in enabling it.
     *
     * This feature is only available when
     * [CompleteQueryRequest.visitor_id][google.cloud.retail.v2.CompleteQueryRequest.visitor_id]
     * field is set and [UserEvent][google.cloud.retail.v2.UserEvent] is imported.
     * The recent searches satisfy the follow rules:
     *
     *  * They are ordered from latest to oldest.
     *
     *  * They are matched with
     *  [CompleteQueryRequest.query][google.cloud.retail.v2.CompleteQueryRequest.query]
     *  case insensitively.
     *
     *  * They are transformed to lower case.
     *
     *  * They are UTF-8 safe.
     *
     * Recent searches are deduplicated. More recent searches will be reserved
     * when duplication happens.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult recent_search_results = 3;
     * </code>
     */
    public int getRecentSearchResultsCount() {
      if (recentSearchResultsBuilder_ == null) {
        return recentSearchResults_.size();
      } else {
        return recentSearchResultsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Matched recent searches of this user. The maximum number of recent searches
     * is 10. This field is a restricted feature. Contact Retail Search support
     * team if you are interested in enabling it.
     *
     * This feature is only available when
     * [CompleteQueryRequest.visitor_id][google.cloud.retail.v2.CompleteQueryRequest.visitor_id]
     * field is set and [UserEvent][google.cloud.retail.v2.UserEvent] is imported.
     * The recent searches satisfy the follow rules:
     *
     *  * They are ordered from latest to oldest.
     *
     *  * They are matched with
     *  [CompleteQueryRequest.query][google.cloud.retail.v2.CompleteQueryRequest.query]
     *  case insensitively.
     *
     *  * They are transformed to lower case.
     *
     *  * They are UTF-8 safe.
     *
     * Recent searches are deduplicated. More recent searches will be reserved
     * when duplication happens.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult recent_search_results = 3;
     * </code>
     */
    public com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult
        getRecentSearchResults(int index) {
      if (recentSearchResultsBuilder_ == null) {
        return recentSearchResults_.get(index);
      } else {
        return recentSearchResultsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Matched recent searches of this user. The maximum number of recent searches
     * is 10. This field is a restricted feature. Contact Retail Search support
     * team if you are interested in enabling it.
     *
     * This feature is only available when
     * [CompleteQueryRequest.visitor_id][google.cloud.retail.v2.CompleteQueryRequest.visitor_id]
     * field is set and [UserEvent][google.cloud.retail.v2.UserEvent] is imported.
     * The recent searches satisfy the follow rules:
     *
     *  * They are ordered from latest to oldest.
     *
     *  * They are matched with
     *  [CompleteQueryRequest.query][google.cloud.retail.v2.CompleteQueryRequest.query]
     *  case insensitively.
     *
     *  * They are transformed to lower case.
     *
     *  * They are UTF-8 safe.
     *
     * Recent searches are deduplicated. More recent searches will be reserved
     * when duplication happens.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult recent_search_results = 3;
     * </code>
     */
    public Builder setRecentSearchResults(
        int index, com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult value) {
      if (recentSearchResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRecentSearchResultsIsMutable();
        recentSearchResults_.set(index, value);
        onChanged();
      } else {
        recentSearchResultsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matched recent searches of this user. The maximum number of recent searches
     * is 10. This field is a restricted feature. Contact Retail Search support
     * team if you are interested in enabling it.
     *
     * This feature is only available when
     * [CompleteQueryRequest.visitor_id][google.cloud.retail.v2.CompleteQueryRequest.visitor_id]
     * field is set and [UserEvent][google.cloud.retail.v2.UserEvent] is imported.
     * The recent searches satisfy the follow rules:
     *
     *  * They are ordered from latest to oldest.
     *
     *  * They are matched with
     *  [CompleteQueryRequest.query][google.cloud.retail.v2.CompleteQueryRequest.query]
     *  case insensitively.
     *
     *  * They are transformed to lower case.
     *
     *  * They are UTF-8 safe.
     *
     * Recent searches are deduplicated. More recent searches will be reserved
     * when duplication happens.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult recent_search_results = 3;
     * </code>
     */
    public Builder setRecentSearchResults(
        int index,
        com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult.Builder
            builderForValue) {
      if (recentSearchResultsBuilder_ == null) {
        ensureRecentSearchResultsIsMutable();
        recentSearchResults_.set(index, builderForValue.build());
        onChanged();
      } else {
        recentSearchResultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matched recent searches of this user. The maximum number of recent searches
     * is 10. This field is a restricted feature. Contact Retail Search support
     * team if you are interested in enabling it.
     *
     * This feature is only available when
     * [CompleteQueryRequest.visitor_id][google.cloud.retail.v2.CompleteQueryRequest.visitor_id]
     * field is set and [UserEvent][google.cloud.retail.v2.UserEvent] is imported.
     * The recent searches satisfy the follow rules:
     *
     *  * They are ordered from latest to oldest.
     *
     *  * They are matched with
     *  [CompleteQueryRequest.query][google.cloud.retail.v2.CompleteQueryRequest.query]
     *  case insensitively.
     *
     *  * They are transformed to lower case.
     *
     *  * They are UTF-8 safe.
     *
     * Recent searches are deduplicated. More recent searches will be reserved
     * when duplication happens.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult recent_search_results = 3;
     * </code>
     */
    public Builder addRecentSearchResults(
        com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult value) {
      if (recentSearchResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRecentSearchResultsIsMutable();
        recentSearchResults_.add(value);
        onChanged();
      } else {
        recentSearchResultsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matched recent searches of this user. The maximum number of recent searches
     * is 10. This field is a restricted feature. Contact Retail Search support
     * team if you are interested in enabling it.
     *
     * This feature is only available when
     * [CompleteQueryRequest.visitor_id][google.cloud.retail.v2.CompleteQueryRequest.visitor_id]
     * field is set and [UserEvent][google.cloud.retail.v2.UserEvent] is imported.
     * The recent searches satisfy the follow rules:
     *
     *  * They are ordered from latest to oldest.
     *
     *  * They are matched with
     *  [CompleteQueryRequest.query][google.cloud.retail.v2.CompleteQueryRequest.query]
     *  case insensitively.
     *
     *  * They are transformed to lower case.
     *
     *  * They are UTF-8 safe.
     *
     * Recent searches are deduplicated. More recent searches will be reserved
     * when duplication happens.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult recent_search_results = 3;
     * </code>
     */
    public Builder addRecentSearchResults(
        int index, com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult value) {
      if (recentSearchResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRecentSearchResultsIsMutable();
        recentSearchResults_.add(index, value);
        onChanged();
      } else {
        recentSearchResultsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matched recent searches of this user. The maximum number of recent searches
     * is 10. This field is a restricted feature. Contact Retail Search support
     * team if you are interested in enabling it.
     *
     * This feature is only available when
     * [CompleteQueryRequest.visitor_id][google.cloud.retail.v2.CompleteQueryRequest.visitor_id]
     * field is set and [UserEvent][google.cloud.retail.v2.UserEvent] is imported.
     * The recent searches satisfy the follow rules:
     *
     *  * They are ordered from latest to oldest.
     *
     *  * They are matched with
     *  [CompleteQueryRequest.query][google.cloud.retail.v2.CompleteQueryRequest.query]
     *  case insensitively.
     *
     *  * They are transformed to lower case.
     *
     *  * They are UTF-8 safe.
     *
     * Recent searches are deduplicated. More recent searches will be reserved
     * when duplication happens.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult recent_search_results = 3;
     * </code>
     */
    public Builder addRecentSearchResults(
        com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult.Builder
            builderForValue) {
      if (recentSearchResultsBuilder_ == null) {
        ensureRecentSearchResultsIsMutable();
        recentSearchResults_.add(builderForValue.build());
        onChanged();
      } else {
        recentSearchResultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matched recent searches of this user. The maximum number of recent searches
     * is 10. This field is a restricted feature. Contact Retail Search support
     * team if you are interested in enabling it.
     *
     * This feature is only available when
     * [CompleteQueryRequest.visitor_id][google.cloud.retail.v2.CompleteQueryRequest.visitor_id]
     * field is set and [UserEvent][google.cloud.retail.v2.UserEvent] is imported.
     * The recent searches satisfy the follow rules:
     *
     *  * They are ordered from latest to oldest.
     *
     *  * They are matched with
     *  [CompleteQueryRequest.query][google.cloud.retail.v2.CompleteQueryRequest.query]
     *  case insensitively.
     *
     *  * They are transformed to lower case.
     *
     *  * They are UTF-8 safe.
     *
     * Recent searches are deduplicated. More recent searches will be reserved
     * when duplication happens.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult recent_search_results = 3;
     * </code>
     */
    public Builder addRecentSearchResults(
        int index,
        com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult.Builder
            builderForValue) {
      if (recentSearchResultsBuilder_ == null) {
        ensureRecentSearchResultsIsMutable();
        recentSearchResults_.add(index, builderForValue.build());
        onChanged();
      } else {
        recentSearchResultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matched recent searches of this user. The maximum number of recent searches
     * is 10. This field is a restricted feature. Contact Retail Search support
     * team if you are interested in enabling it.
     *
     * This feature is only available when
     * [CompleteQueryRequest.visitor_id][google.cloud.retail.v2.CompleteQueryRequest.visitor_id]
     * field is set and [UserEvent][google.cloud.retail.v2.UserEvent] is imported.
     * The recent searches satisfy the follow rules:
     *
     *  * They are ordered from latest to oldest.
     *
     *  * They are matched with
     *  [CompleteQueryRequest.query][google.cloud.retail.v2.CompleteQueryRequest.query]
     *  case insensitively.
     *
     *  * They are transformed to lower case.
     *
     *  * They are UTF-8 safe.
     *
     * Recent searches are deduplicated. More recent searches will be reserved
     * when duplication happens.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult recent_search_results = 3;
     * </code>
     */
    public Builder addAllRecentSearchResults(
        java.lang.Iterable<
                ? extends com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult>
            values) {
      if (recentSearchResultsBuilder_ == null) {
        ensureRecentSearchResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, recentSearchResults_);
        onChanged();
      } else {
        recentSearchResultsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matched recent searches of this user. The maximum number of recent searches
     * is 10. This field is a restricted feature. Contact Retail Search support
     * team if you are interested in enabling it.
     *
     * This feature is only available when
     * [CompleteQueryRequest.visitor_id][google.cloud.retail.v2.CompleteQueryRequest.visitor_id]
     * field is set and [UserEvent][google.cloud.retail.v2.UserEvent] is imported.
     * The recent searches satisfy the follow rules:
     *
     *  * They are ordered from latest to oldest.
     *
     *  * They are matched with
     *  [CompleteQueryRequest.query][google.cloud.retail.v2.CompleteQueryRequest.query]
     *  case insensitively.
     *
     *  * They are transformed to lower case.
     *
     *  * They are UTF-8 safe.
     *
     * Recent searches are deduplicated. More recent searches will be reserved
     * when duplication happens.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult recent_search_results = 3;
     * </code>
     */
    public Builder clearRecentSearchResults() {
      if (recentSearchResultsBuilder_ == null) {
        recentSearchResults_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        recentSearchResultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matched recent searches of this user. The maximum number of recent searches
     * is 10. This field is a restricted feature. Contact Retail Search support
     * team if you are interested in enabling it.
     *
     * This feature is only available when
     * [CompleteQueryRequest.visitor_id][google.cloud.retail.v2.CompleteQueryRequest.visitor_id]
     * field is set and [UserEvent][google.cloud.retail.v2.UserEvent] is imported.
     * The recent searches satisfy the follow rules:
     *
     *  * They are ordered from latest to oldest.
     *
     *  * They are matched with
     *  [CompleteQueryRequest.query][google.cloud.retail.v2.CompleteQueryRequest.query]
     *  case insensitively.
     *
     *  * They are transformed to lower case.
     *
     *  * They are UTF-8 safe.
     *
     * Recent searches are deduplicated. More recent searches will be reserved
     * when duplication happens.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult recent_search_results = 3;
     * </code>
     */
    public Builder removeRecentSearchResults(int index) {
      if (recentSearchResultsBuilder_ == null) {
        ensureRecentSearchResultsIsMutable();
        recentSearchResults_.remove(index);
        onChanged();
      } else {
        recentSearchResultsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matched recent searches of this user. The maximum number of recent searches
     * is 10. This field is a restricted feature. Contact Retail Search support
     * team if you are interested in enabling it.
     *
     * This feature is only available when
     * [CompleteQueryRequest.visitor_id][google.cloud.retail.v2.CompleteQueryRequest.visitor_id]
     * field is set and [UserEvent][google.cloud.retail.v2.UserEvent] is imported.
     * The recent searches satisfy the follow rules:
     *
     *  * They are ordered from latest to oldest.
     *
     *  * They are matched with
     *  [CompleteQueryRequest.query][google.cloud.retail.v2.CompleteQueryRequest.query]
     *  case insensitively.
     *
     *  * They are transformed to lower case.
     *
     *  * They are UTF-8 safe.
     *
     * Recent searches are deduplicated. More recent searches will be reserved
     * when duplication happens.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult recent_search_results = 3;
     * </code>
     */
    public com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult.Builder
        getRecentSearchResultsBuilder(int index) {
      return getRecentSearchResultsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Matched recent searches of this user. The maximum number of recent searches
     * is 10. This field is a restricted feature. Contact Retail Search support
     * team if you are interested in enabling it.
     *
     * This feature is only available when
     * [CompleteQueryRequest.visitor_id][google.cloud.retail.v2.CompleteQueryRequest.visitor_id]
     * field is set and [UserEvent][google.cloud.retail.v2.UserEvent] is imported.
     * The recent searches satisfy the follow rules:
     *
     *  * They are ordered from latest to oldest.
     *
     *  * They are matched with
     *  [CompleteQueryRequest.query][google.cloud.retail.v2.CompleteQueryRequest.query]
     *  case insensitively.
     *
     *  * They are transformed to lower case.
     *
     *  * They are UTF-8 safe.
     *
     * Recent searches are deduplicated. More recent searches will be reserved
     * when duplication happens.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult recent_search_results = 3;
     * </code>
     */
    public com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResultOrBuilder
        getRecentSearchResultsOrBuilder(int index) {
      if (recentSearchResultsBuilder_ == null) {
        return recentSearchResults_.get(index);
      } else {
        return recentSearchResultsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Matched recent searches of this user. The maximum number of recent searches
     * is 10. This field is a restricted feature. Contact Retail Search support
     * team if you are interested in enabling it.
     *
     * This feature is only available when
     * [CompleteQueryRequest.visitor_id][google.cloud.retail.v2.CompleteQueryRequest.visitor_id]
     * field is set and [UserEvent][google.cloud.retail.v2.UserEvent] is imported.
     * The recent searches satisfy the follow rules:
     *
     *  * They are ordered from latest to oldest.
     *
     *  * They are matched with
     *  [CompleteQueryRequest.query][google.cloud.retail.v2.CompleteQueryRequest.query]
     *  case insensitively.
     *
     *  * They are transformed to lower case.
     *
     *  * They are UTF-8 safe.
     *
     * Recent searches are deduplicated. More recent searches will be reserved
     * when duplication happens.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult recent_search_results = 3;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResultOrBuilder>
        getRecentSearchResultsOrBuilderList() {
      if (recentSearchResultsBuilder_ != null) {
        return recentSearchResultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(recentSearchResults_);
      }
    }
    /**
     *
     *
     * <pre>
     * Matched recent searches of this user. The maximum number of recent searches
     * is 10. This field is a restricted feature. Contact Retail Search support
     * team if you are interested in enabling it.
     *
     * This feature is only available when
     * [CompleteQueryRequest.visitor_id][google.cloud.retail.v2.CompleteQueryRequest.visitor_id]
     * field is set and [UserEvent][google.cloud.retail.v2.UserEvent] is imported.
     * The recent searches satisfy the follow rules:
     *
     *  * They are ordered from latest to oldest.
     *
     *  * They are matched with
     *  [CompleteQueryRequest.query][google.cloud.retail.v2.CompleteQueryRequest.query]
     *  case insensitively.
     *
     *  * They are transformed to lower case.
     *
     *  * They are UTF-8 safe.
     *
     * Recent searches are deduplicated. More recent searches will be reserved
     * when duplication happens.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult recent_search_results = 3;
     * </code>
     */
    public com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult.Builder
        addRecentSearchResultsBuilder() {
      return getRecentSearchResultsFieldBuilder()
          .addBuilder(
              com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Matched recent searches of this user. The maximum number of recent searches
     * is 10. This field is a restricted feature. Contact Retail Search support
     * team if you are interested in enabling it.
     *
     * This feature is only available when
     * [CompleteQueryRequest.visitor_id][google.cloud.retail.v2.CompleteQueryRequest.visitor_id]
     * field is set and [UserEvent][google.cloud.retail.v2.UserEvent] is imported.
     * The recent searches satisfy the follow rules:
     *
     *  * They are ordered from latest to oldest.
     *
     *  * They are matched with
     *  [CompleteQueryRequest.query][google.cloud.retail.v2.CompleteQueryRequest.query]
     *  case insensitively.
     *
     *  * They are transformed to lower case.
     *
     *  * They are UTF-8 safe.
     *
     * Recent searches are deduplicated. More recent searches will be reserved
     * when duplication happens.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult recent_search_results = 3;
     * </code>
     */
    public com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult.Builder
        addRecentSearchResultsBuilder(int index) {
      return getRecentSearchResultsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Matched recent searches of this user. The maximum number of recent searches
     * is 10. This field is a restricted feature. Contact Retail Search support
     * team if you are interested in enabling it.
     *
     * This feature is only available when
     * [CompleteQueryRequest.visitor_id][google.cloud.retail.v2.CompleteQueryRequest.visitor_id]
     * field is set and [UserEvent][google.cloud.retail.v2.UserEvent] is imported.
     * The recent searches satisfy the follow rules:
     *
     *  * They are ordered from latest to oldest.
     *
     *  * They are matched with
     *  [CompleteQueryRequest.query][google.cloud.retail.v2.CompleteQueryRequest.query]
     *  case insensitively.
     *
     *  * They are transformed to lower case.
     *
     *  * They are UTF-8 safe.
     *
     * Recent searches are deduplicated. More recent searches will be reserved
     * when duplication happens.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult recent_search_results = 3;
     * </code>
     */
    public java.util.List<
            com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult.Builder>
        getRecentSearchResultsBuilderList() {
      return getRecentSearchResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult,
            com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult.Builder,
            com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResultOrBuilder>
        getRecentSearchResultsFieldBuilder() {
      if (recentSearchResultsBuilder_ == null) {
        recentSearchResultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult,
                com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResult.Builder,
                com.google.cloud.retail.v2.CompleteQueryResponse.RecentSearchResultOrBuilder>(
                recentSearchResults_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        recentSearchResults_ = null;
      }
      return recentSearchResultsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.CompleteQueryResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.CompleteQueryResponse)
  private static final com.google.cloud.retail.v2.CompleteQueryResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2.CompleteQueryResponse();
  }

  public static com.google.cloud.retail.v2.CompleteQueryResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CompleteQueryResponse> PARSER =
      new com.google.protobuf.AbstractParser<CompleteQueryResponse>() {
        @java.lang.Override
        public CompleteQueryResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CompleteQueryResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CompleteQueryResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2.CompleteQueryResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
