/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2/product.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.retail.v2;

/**
 *
 *
 * <pre>
 * Product captures all metadata information of items to be recommended or
 * searched.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2.Product}
 */
public final class Product extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.Product)
    ProductOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Product.newBuilder() to construct.
  private Product(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Product() {
    name_ = "";
    id_ = "";
    type_ = 0;
    primaryProductId_ = "";
    collectionMemberIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    gtin_ = "";
    categories_ = com.google.protobuf.LazyStringArrayList.emptyList();
    title_ = "";
    brands_ = com.google.protobuf.LazyStringArrayList.emptyList();
    description_ = "";
    languageCode_ = "";
    tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
    availability_ = 0;
    fulfillmentInfo_ = java.util.Collections.emptyList();
    uri_ = "";
    images_ = java.util.Collections.emptyList();
    sizes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    materials_ = com.google.protobuf.LazyStringArrayList.emptyList();
    patterns_ = com.google.protobuf.LazyStringArrayList.emptyList();
    conditions_ = com.google.protobuf.LazyStringArrayList.emptyList();
    promotions_ = java.util.Collections.emptyList();
    variants_ = java.util.Collections.emptyList();
    localInventories_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Product();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2.ProductProto
        .internal_static_google_cloud_retail_v2_Product_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 12:
        return internalGetAttributes();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2.ProductProto
        .internal_static_google_cloud_retail_v2_Product_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2.Product.class,
            com.google.cloud.retail.v2.Product.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of this product.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.retail.v2.Product.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. Default to
     * [Catalog.product_level_config.ingestion_product_type][google.cloud.retail.v2.ProductLevelConfig.ingestion_product_type]
     * if unset.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The primary type.
     *
     * As the primary unit for predicting, indexing and search serving, a
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product] is grouped with multiple
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product]s.
     * </pre>
     *
     * <code>PRIMARY = 1;</code>
     */
    PRIMARY(1),
    /**
     *
     *
     * <pre>
     * The variant type.
     *
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product]s usually share some common
     * attributes on the same
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s, but they have variant
     * attributes like different colors, sizes and prices, etc.
     * </pre>
     *
     * <code>VARIANT = 2;</code>
     */
    VARIANT(2),
    /**
     *
     *
     * <pre>
     * The collection type. Collection products are bundled
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s or
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product]s that are sold together, such
     * as a jewelry set with necklaces, earrings and rings, etc.
     * </pre>
     *
     * <code>COLLECTION = 3;</code>
     */
    COLLECTION(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. Default to
     * [Catalog.product_level_config.ingestion_product_type][google.cloud.retail.v2.ProductLevelConfig.ingestion_product_type]
     * if unset.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The primary type.
     *
     * As the primary unit for predicting, indexing and search serving, a
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product] is grouped with multiple
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product]s.
     * </pre>
     *
     * <code>PRIMARY = 1;</code>
     */
    public static final int PRIMARY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The variant type.
     *
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product]s usually share some common
     * attributes on the same
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s, but they have variant
     * attributes like different colors, sizes and prices, etc.
     * </pre>
     *
     * <code>VARIANT = 2;</code>
     */
    public static final int VARIANT_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The collection type. Collection products are bundled
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s or
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product]s that are sold together, such
     * as a jewelry set with necklaces, earrings and rings, etc.
     * </pre>
     *
     * <code>COLLECTION = 3;</code>
     */
    public static final int COLLECTION_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return PRIMARY;
        case 2:
          return VARIANT;
        case 3:
          return COLLECTION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.retail.v2.Product.getDescriptor().getEnumTypes().get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2.Product.Type)
  }

  /**
   *
   *
   * <pre>
   * Product availability. If this field is unspecified, the product is
   * assumed to be in stock.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.retail.v2.Product.Availability}
   */
  public enum Availability implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default product availability. Default to
     * [Availability.IN_STOCK][google.cloud.retail.v2.Product.Availability.IN_STOCK]
     * if unset.
     * </pre>
     *
     * <code>AVAILABILITY_UNSPECIFIED = 0;</code>
     */
    AVAILABILITY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Product in stock.
     * </pre>
     *
     * <code>IN_STOCK = 1;</code>
     */
    IN_STOCK(1),
    /**
     *
     *
     * <pre>
     * Product out of stock.
     * </pre>
     *
     * <code>OUT_OF_STOCK = 2;</code>
     */
    OUT_OF_STOCK(2),
    /**
     *
     *
     * <pre>
     * Product that is in pre-order state.
     * </pre>
     *
     * <code>PREORDER = 3;</code>
     */
    PREORDER(3),
    /**
     *
     *
     * <pre>
     * Product that is back-ordered (i.e. temporarily out of stock).
     * </pre>
     *
     * <code>BACKORDER = 4;</code>
     */
    BACKORDER(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default product availability. Default to
     * [Availability.IN_STOCK][google.cloud.retail.v2.Product.Availability.IN_STOCK]
     * if unset.
     * </pre>
     *
     * <code>AVAILABILITY_UNSPECIFIED = 0;</code>
     */
    public static final int AVAILABILITY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Product in stock.
     * </pre>
     *
     * <code>IN_STOCK = 1;</code>
     */
    public static final int IN_STOCK_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Product out of stock.
     * </pre>
     *
     * <code>OUT_OF_STOCK = 2;</code>
     */
    public static final int OUT_OF_STOCK_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Product that is in pre-order state.
     * </pre>
     *
     * <code>PREORDER = 3;</code>
     */
    public static final int PREORDER_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Product that is back-ordered (i.e. temporarily out of stock).
     * </pre>
     *
     * <code>BACKORDER = 4;</code>
     */
    public static final int BACKORDER_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Availability valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Availability forNumber(int value) {
      switch (value) {
        case 0:
          return AVAILABILITY_UNSPECIFIED;
        case 1:
          return IN_STOCK;
        case 2:
          return OUT_OF_STOCK;
        case 3:
          return PREORDER;
        case 4:
          return BACKORDER;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Availability> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Availability> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Availability>() {
          public Availability findValueByNumber(int number) {
            return Availability.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.retail.v2.Product.getDescriptor().getEnumTypes().get(1);
    }

    private static final Availability[] VALUES = values();

    public static Availability valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Availability(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2.Product.Availability)
  }

  private int bitField0_;
  private int expirationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object expiration_;

  public enum ExpirationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    EXPIRE_TIME(16),
    TTL(17),
    EXPIRATION_NOT_SET(0);
    private final int value;

    private ExpirationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ExpirationCase valueOf(int value) {
      return forNumber(value);
    }

    public static ExpirationCase forNumber(int value) {
      switch (value) {
        case 16:
          return EXPIRE_TIME;
        case 17:
          return TTL;
        case 0:
          return EXPIRATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ExpirationCase getExpirationCase() {
    return ExpirationCase.forNumber(expirationCase_);
  }

  public static final int EXPIRE_TIME_FIELD_NUMBER = 16;
  /**
   *
   *
   * <pre>
   * The timestamp when this product becomes unavailable for
   * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
   * that this is only applicable to
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
   * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
   * In general, we suggest the users to delete the stale products explicitly,
   * instead of using this field to determine staleness.
   *
   * If it is set, the [Product][google.cloud.retail.v2.Product] is not
   * available for
   * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
   * [expire_time][google.cloud.retail.v2.Product.expire_time]. However, the
   * product can still be retrieved by
   * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
   * and
   * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
   *
   * [expire_time][google.cloud.retail.v2.Product.expire_time] must be later
   * than [available_time][google.cloud.retail.v2.Product.available_time] and
   * [publish_time][google.cloud.retail.v2.Product.publish_time], otherwise an
   * INVALID_ARGUMENT error is thrown.
   *
   * Corresponding properties: Google Merchant Center property
   * [expiration_date](https://support.google.com/merchants/answer/6324499).
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 16;</code>
   *
   * @return Whether the expireTime field is set.
   */
  @java.lang.Override
  public boolean hasExpireTime() {
    return expirationCase_ == 16;
  }
  /**
   *
   *
   * <pre>
   * The timestamp when this product becomes unavailable for
   * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
   * that this is only applicable to
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
   * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
   * In general, we suggest the users to delete the stale products explicitly,
   * instead of using this field to determine staleness.
   *
   * If it is set, the [Product][google.cloud.retail.v2.Product] is not
   * available for
   * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
   * [expire_time][google.cloud.retail.v2.Product.expire_time]. However, the
   * product can still be retrieved by
   * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
   * and
   * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
   *
   * [expire_time][google.cloud.retail.v2.Product.expire_time] must be later
   * than [available_time][google.cloud.retail.v2.Product.available_time] and
   * [publish_time][google.cloud.retail.v2.Product.publish_time], otherwise an
   * INVALID_ARGUMENT error is thrown.
   *
   * Corresponding properties: Google Merchant Center property
   * [expiration_date](https://support.google.com/merchants/answer/6324499).
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 16;</code>
   *
   * @return The expireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExpireTime() {
    if (expirationCase_ == 16) {
      return (com.google.protobuf.Timestamp) expiration_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The timestamp when this product becomes unavailable for
   * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
   * that this is only applicable to
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
   * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
   * In general, we suggest the users to delete the stale products explicitly,
   * instead of using this field to determine staleness.
   *
   * If it is set, the [Product][google.cloud.retail.v2.Product] is not
   * available for
   * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
   * [expire_time][google.cloud.retail.v2.Product.expire_time]. However, the
   * product can still be retrieved by
   * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
   * and
   * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
   *
   * [expire_time][google.cloud.retail.v2.Product.expire_time] must be later
   * than [available_time][google.cloud.retail.v2.Product.available_time] and
   * [publish_time][google.cloud.retail.v2.Product.publish_time], otherwise an
   * INVALID_ARGUMENT error is thrown.
   *
   * Corresponding properties: Google Merchant Center property
   * [expiration_date](https://support.google.com/merchants/answer/6324499).
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 16;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
    if (expirationCase_ == 16) {
      return (com.google.protobuf.Timestamp) expiration_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  public static final int TTL_FIELD_NUMBER = 17;
  /**
   *
   *
   * <pre>
   * Input only. The TTL (time to live) of the product. Note that this is only
   * applicable to [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * and [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION],
   * and ignored for
   * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]. In general,
   * we suggest the users to delete the stale products explicitly, instead of
   * using this field to determine staleness.
   *
   * If it is set, it must be a non-negative value, and
   * [expire_time][google.cloud.retail.v2.Product.expire_time] is set as
   * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl]. The
   * derived [expire_time][google.cloud.retail.v2.Product.expire_time] is
   * returned in the output and [ttl][google.cloud.retail.v2.Product.ttl] is
   * left blank when retrieving the [Product][google.cloud.retail.v2.Product].
   *
   * If it is set, the product is not available for
   * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
   * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl].
   * However, the product can still be retrieved by
   * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
   * and
   * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 17 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return Whether the ttl field is set.
   */
  @java.lang.Override
  public boolean hasTtl() {
    return expirationCase_ == 17;
  }
  /**
   *
   *
   * <pre>
   * Input only. The TTL (time to live) of the product. Note that this is only
   * applicable to [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * and [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION],
   * and ignored for
   * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]. In general,
   * we suggest the users to delete the stale products explicitly, instead of
   * using this field to determine staleness.
   *
   * If it is set, it must be a non-negative value, and
   * [expire_time][google.cloud.retail.v2.Product.expire_time] is set as
   * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl]. The
   * derived [expire_time][google.cloud.retail.v2.Product.expire_time] is
   * returned in the output and [ttl][google.cloud.retail.v2.Product.ttl] is
   * left blank when retrieving the [Product][google.cloud.retail.v2.Product].
   *
   * If it is set, the product is not available for
   * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
   * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl].
   * However, the product can still be retrieved by
   * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
   * and
   * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 17 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The ttl.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTtl() {
    if (expirationCase_ == 17) {
      return (com.google.protobuf.Duration) expiration_;
    }
    return com.google.protobuf.Duration.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Input only. The TTL (time to live) of the product. Note that this is only
   * applicable to [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * and [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION],
   * and ignored for
   * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]. In general,
   * we suggest the users to delete the stale products explicitly, instead of
   * using this field to determine staleness.
   *
   * If it is set, it must be a non-negative value, and
   * [expire_time][google.cloud.retail.v2.Product.expire_time] is set as
   * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl]. The
   * derived [expire_time][google.cloud.retail.v2.Product.expire_time] is
   * returned in the output and [ttl][google.cloud.retail.v2.Product.ttl] is
   * left blank when retrieving the [Product][google.cloud.retail.v2.Product].
   *
   * If it is set, the product is not available for
   * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
   * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl].
   * However, the product can still be retrieved by
   * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
   * and
   * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 17 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTtlOrBuilder() {
    if (expirationCase_ == 17) {
      return (com.google.protobuf.Duration) expiration_;
    }
    return com.google.protobuf.Duration.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. Full resource name of the product, such as
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/product_id`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. Full resource name of the product, such as
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/product_id`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. [Product][google.cloud.retail.v2.Product] identifier, which is
   * the final component of [name][google.cloud.retail.v2.Product.name]. For
   * example, this field is "id_1", if
   * [name][google.cloud.retail.v2.Product.name] is
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/id_1`.
   *
   * This field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [id](https://support.google.com/merchants/answer/6324405). Schema.org
   * property [Product.sku](https://schema.org/sku).
   * </pre>
   *
   * <code>string id = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. [Product][google.cloud.retail.v2.Product] identifier, which is
   * the final component of [name][google.cloud.retail.v2.Product.name]. For
   * example, this field is "id_1", if
   * [name][google.cloud.retail.v2.Product.name] is
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/id_1`.
   *
   * This field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [id](https://support.google.com/merchants/answer/6324405). Schema.org
   * property [Product.sku](https://schema.org/sku).
   * </pre>
   *
   * <code>string id = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 3;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * Immutable. The type of the product. Default to
   * [Catalog.product_level_config.ingestion_product_type][google.cloud.retail.v2.ProductLevelConfig.ingestion_product_type]
   * if unset.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.Product.Type type = 3 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. The type of the product. Default to
   * [Catalog.product_level_config.ingestion_product_type][google.cloud.retail.v2.ProductLevelConfig.ingestion_product_type]
   * if unset.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.Product.Type type = 3 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.Product.Type getType() {
    com.google.cloud.retail.v2.Product.Type result =
        com.google.cloud.retail.v2.Product.Type.forNumber(type_);
    return result == null ? com.google.cloud.retail.v2.Product.Type.UNRECOGNIZED : result;
  }

  public static final int PRIMARY_PRODUCT_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object primaryProductId_ = "";
  /**
   *
   *
   * <pre>
   * Variant group identifier. Must be an
   * [id][google.cloud.retail.v2.Product.id], with the same parent branch with
   * this product. Otherwise, an error is thrown.
   *
   * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2.Product]s, this field can only be empty or
   * set to the same value as [id][google.cloud.retail.v2.Product.id].
   *
   * For VARIANT [Product][google.cloud.retail.v2.Product]s, this field cannot
   * be empty. A maximum of 2,000 products are allowed to share the same
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2.Product]. Otherwise, an INVALID_ARGUMENT
   * error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [item_group_id](https://support.google.com/merchants/answer/6324507).
   * Schema.org property
   * [Product.inProductGroupWithID](https://schema.org/inProductGroupWithID).
   * </pre>
   *
   * <code>string primary_product_id = 4;</code>
   *
   * @return The primaryProductId.
   */
  @java.lang.Override
  public java.lang.String getPrimaryProductId() {
    java.lang.Object ref = primaryProductId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      primaryProductId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Variant group identifier. Must be an
   * [id][google.cloud.retail.v2.Product.id], with the same parent branch with
   * this product. Otherwise, an error is thrown.
   *
   * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2.Product]s, this field can only be empty or
   * set to the same value as [id][google.cloud.retail.v2.Product.id].
   *
   * For VARIANT [Product][google.cloud.retail.v2.Product]s, this field cannot
   * be empty. A maximum of 2,000 products are allowed to share the same
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2.Product]. Otherwise, an INVALID_ARGUMENT
   * error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [item_group_id](https://support.google.com/merchants/answer/6324507).
   * Schema.org property
   * [Product.inProductGroupWithID](https://schema.org/inProductGroupWithID).
   * </pre>
   *
   * <code>string primary_product_id = 4;</code>
   *
   * @return The bytes for primaryProductId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrimaryProductIdBytes() {
    java.lang.Object ref = primaryProductId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      primaryProductId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COLLECTION_MEMBER_IDS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList collectionMemberIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The [id][google.cloud.retail.v2.Product.id] of the collection members when
   * [type][google.cloud.retail.v2.Product.type] is
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION].
   *
   * Non-existent product ids are allowed.
   * The [type][google.cloud.retail.v2.Product.type] of the members must be
   * either [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] or
   * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT] otherwise an
   * INVALID_ARGUMENT error is thrown. Should not set it for other types. A
   * maximum of 1000 values are allowed. Otherwise, an INVALID_ARGUMENT error is
   * return.
   * </pre>
   *
   * <code>repeated string collection_member_ids = 5;</code>
   *
   * @return A list containing the collectionMemberIds.
   */
  public com.google.protobuf.ProtocolStringList getCollectionMemberIdsList() {
    return collectionMemberIds_;
  }
  /**
   *
   *
   * <pre>
   * The [id][google.cloud.retail.v2.Product.id] of the collection members when
   * [type][google.cloud.retail.v2.Product.type] is
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION].
   *
   * Non-existent product ids are allowed.
   * The [type][google.cloud.retail.v2.Product.type] of the members must be
   * either [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] or
   * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT] otherwise an
   * INVALID_ARGUMENT error is thrown. Should not set it for other types. A
   * maximum of 1000 values are allowed. Otherwise, an INVALID_ARGUMENT error is
   * return.
   * </pre>
   *
   * <code>repeated string collection_member_ids = 5;</code>
   *
   * @return The count of collectionMemberIds.
   */
  public int getCollectionMemberIdsCount() {
    return collectionMemberIds_.size();
  }
  /**
   *
   *
   * <pre>
   * The [id][google.cloud.retail.v2.Product.id] of the collection members when
   * [type][google.cloud.retail.v2.Product.type] is
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION].
   *
   * Non-existent product ids are allowed.
   * The [type][google.cloud.retail.v2.Product.type] of the members must be
   * either [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] or
   * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT] otherwise an
   * INVALID_ARGUMENT error is thrown. Should not set it for other types. A
   * maximum of 1000 values are allowed. Otherwise, an INVALID_ARGUMENT error is
   * return.
   * </pre>
   *
   * <code>repeated string collection_member_ids = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The collectionMemberIds at the given index.
   */
  public java.lang.String getCollectionMemberIds(int index) {
    return collectionMemberIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The [id][google.cloud.retail.v2.Product.id] of the collection members when
   * [type][google.cloud.retail.v2.Product.type] is
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION].
   *
   * Non-existent product ids are allowed.
   * The [type][google.cloud.retail.v2.Product.type] of the members must be
   * either [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] or
   * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT] otherwise an
   * INVALID_ARGUMENT error is thrown. Should not set it for other types. A
   * maximum of 1000 values are allowed. Otherwise, an INVALID_ARGUMENT error is
   * return.
   * </pre>
   *
   * <code>repeated string collection_member_ids = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the collectionMemberIds at the given index.
   */
  public com.google.protobuf.ByteString getCollectionMemberIdsBytes(int index) {
    return collectionMemberIds_.getByteString(index);
  }

  public static final int GTIN_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object gtin_ = "";
  /**
   *
   *
   * <pre>
   * The Global Trade Item Number (GTIN) of the product.
   *
   * This field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * This field must be a Unigram. Otherwise, an INVALID_ARGUMENT error is
   * returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [gtin](https://support.google.com/merchants/answer/6324461).
   * Schema.org property
   * [Product.isbn](https://schema.org/isbn),
   * [Product.gtin8](https://schema.org/gtin8),
   * [Product.gtin12](https://schema.org/gtin12),
   * [Product.gtin13](https://schema.org/gtin13), or
   * [Product.gtin14](https://schema.org/gtin14).
   *
   * If the value is not a valid GTIN, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>string gtin = 6;</code>
   *
   * @return The gtin.
   */
  @java.lang.Override
  public java.lang.String getGtin() {
    java.lang.Object ref = gtin_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      gtin_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Global Trade Item Number (GTIN) of the product.
   *
   * This field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * This field must be a Unigram. Otherwise, an INVALID_ARGUMENT error is
   * returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [gtin](https://support.google.com/merchants/answer/6324461).
   * Schema.org property
   * [Product.isbn](https://schema.org/isbn),
   * [Product.gtin8](https://schema.org/gtin8),
   * [Product.gtin12](https://schema.org/gtin12),
   * [Product.gtin13](https://schema.org/gtin13), or
   * [Product.gtin14](https://schema.org/gtin14).
   *
   * If the value is not a valid GTIN, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>string gtin = 6;</code>
   *
   * @return The bytes for gtin.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGtinBytes() {
    java.lang.Object ref = gtin_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      gtin_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CATEGORIES_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList categories_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Product categories. This field is repeated for supporting one product
   * belonging to several parallel categories. Strongly recommended using the
   * full path for better search / recommendation quality.
   *
   *
   * To represent full path of category, use '&gt;' sign to separate different
   * hierarchies. If '&gt;' is part of the category name, replace it with
   * other character(s).
   *
   * For example, if a shoes product belongs to both
   * ["Shoes &amp; Accessories" -&gt; "Shoes"] and
   * ["Sports &amp; Fitness" -&gt; "Athletic Clothing" -&gt; "Shoes"], it could be
   * represented as:
   *
   *      "categories": [
   *        "Shoes &amp; Accessories &gt; Shoes",
   *        "Sports &amp; Fitness &gt; Athletic Clothing &gt; Shoes"
   *      ]
   *
   * Must be set for [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2.Product] otherwise an INVALID_ARGUMENT
   * error is returned.
   *
   * At most 250 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. Empty values are not allowed.
   * Each value must be a UTF-8 encoded string with a length limit of 5,000
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [google_product_category][mc_google_product_category]. Schema.org property
   * [Product.category] (https://schema.org/category).
   *
   * [mc_google_product_category]:
   * https://support.google.com/merchants/answer/6324436
   * </pre>
   *
   * <code>repeated string categories = 7;</code>
   *
   * @return A list containing the categories.
   */
  public com.google.protobuf.ProtocolStringList getCategoriesList() {
    return categories_;
  }
  /**
   *
   *
   * <pre>
   * Product categories. This field is repeated for supporting one product
   * belonging to several parallel categories. Strongly recommended using the
   * full path for better search / recommendation quality.
   *
   *
   * To represent full path of category, use '&gt;' sign to separate different
   * hierarchies. If '&gt;' is part of the category name, replace it with
   * other character(s).
   *
   * For example, if a shoes product belongs to both
   * ["Shoes &amp; Accessories" -&gt; "Shoes"] and
   * ["Sports &amp; Fitness" -&gt; "Athletic Clothing" -&gt; "Shoes"], it could be
   * represented as:
   *
   *      "categories": [
   *        "Shoes &amp; Accessories &gt; Shoes",
   *        "Sports &amp; Fitness &gt; Athletic Clothing &gt; Shoes"
   *      ]
   *
   * Must be set for [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2.Product] otherwise an INVALID_ARGUMENT
   * error is returned.
   *
   * At most 250 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. Empty values are not allowed.
   * Each value must be a UTF-8 encoded string with a length limit of 5,000
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [google_product_category][mc_google_product_category]. Schema.org property
   * [Product.category] (https://schema.org/category).
   *
   * [mc_google_product_category]:
   * https://support.google.com/merchants/answer/6324436
   * </pre>
   *
   * <code>repeated string categories = 7;</code>
   *
   * @return The count of categories.
   */
  public int getCategoriesCount() {
    return categories_.size();
  }
  /**
   *
   *
   * <pre>
   * Product categories. This field is repeated for supporting one product
   * belonging to several parallel categories. Strongly recommended using the
   * full path for better search / recommendation quality.
   *
   *
   * To represent full path of category, use '&gt;' sign to separate different
   * hierarchies. If '&gt;' is part of the category name, replace it with
   * other character(s).
   *
   * For example, if a shoes product belongs to both
   * ["Shoes &amp; Accessories" -&gt; "Shoes"] and
   * ["Sports &amp; Fitness" -&gt; "Athletic Clothing" -&gt; "Shoes"], it could be
   * represented as:
   *
   *      "categories": [
   *        "Shoes &amp; Accessories &gt; Shoes",
   *        "Sports &amp; Fitness &gt; Athletic Clothing &gt; Shoes"
   *      ]
   *
   * Must be set for [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2.Product] otherwise an INVALID_ARGUMENT
   * error is returned.
   *
   * At most 250 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. Empty values are not allowed.
   * Each value must be a UTF-8 encoded string with a length limit of 5,000
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [google_product_category][mc_google_product_category]. Schema.org property
   * [Product.category] (https://schema.org/category).
   *
   * [mc_google_product_category]:
   * https://support.google.com/merchants/answer/6324436
   * </pre>
   *
   * <code>repeated string categories = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The categories at the given index.
   */
  public java.lang.String getCategories(int index) {
    return categories_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Product categories. This field is repeated for supporting one product
   * belonging to several parallel categories. Strongly recommended using the
   * full path for better search / recommendation quality.
   *
   *
   * To represent full path of category, use '&gt;' sign to separate different
   * hierarchies. If '&gt;' is part of the category name, replace it with
   * other character(s).
   *
   * For example, if a shoes product belongs to both
   * ["Shoes &amp; Accessories" -&gt; "Shoes"] and
   * ["Sports &amp; Fitness" -&gt; "Athletic Clothing" -&gt; "Shoes"], it could be
   * represented as:
   *
   *      "categories": [
   *        "Shoes &amp; Accessories &gt; Shoes",
   *        "Sports &amp; Fitness &gt; Athletic Clothing &gt; Shoes"
   *      ]
   *
   * Must be set for [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2.Product] otherwise an INVALID_ARGUMENT
   * error is returned.
   *
   * At most 250 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. Empty values are not allowed.
   * Each value must be a UTF-8 encoded string with a length limit of 5,000
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [google_product_category][mc_google_product_category]. Schema.org property
   * [Product.category] (https://schema.org/category).
   *
   * [mc_google_product_category]:
   * https://support.google.com/merchants/answer/6324436
   * </pre>
   *
   * <code>repeated string categories = 7;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the categories at the given index.
   */
  public com.google.protobuf.ByteString getCategoriesBytes(int index) {
    return categories_.getByteString(index);
  }

  public static final int TITLE_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object title_ = "";
  /**
   *
   *
   * <pre>
   * Required. Product title.
   *
   * This field must be a UTF-8 encoded string with a length limit of 1,000
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [title](https://support.google.com/merchants/answer/6324415). Schema.org
   * property [Product.name](https://schema.org/name).
   * </pre>
   *
   * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The title.
   */
  @java.lang.Override
  public java.lang.String getTitle() {
    java.lang.Object ref = title_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      title_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Product title.
   *
   * This field must be a UTF-8 encoded string with a length limit of 1,000
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [title](https://support.google.com/merchants/answer/6324415). Schema.org
   * property [Product.name](https://schema.org/name).
   * </pre>
   *
   * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for title.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTitleBytes() {
    java.lang.Object ref = title_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      title_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BRANDS_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList brands_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The brands of the product.
   *
   * A maximum of 30 brands are allowed. Each brand must be a UTF-8 encoded
   * string with a length limit of 1,000 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [brand](https://support.google.com/merchants/answer/6324351). Schema.org
   * property [Product.brand](https://schema.org/brand).
   * </pre>
   *
   * <code>repeated string brands = 9;</code>
   *
   * @return A list containing the brands.
   */
  public com.google.protobuf.ProtocolStringList getBrandsList() {
    return brands_;
  }
  /**
   *
   *
   * <pre>
   * The brands of the product.
   *
   * A maximum of 30 brands are allowed. Each brand must be a UTF-8 encoded
   * string with a length limit of 1,000 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [brand](https://support.google.com/merchants/answer/6324351). Schema.org
   * property [Product.brand](https://schema.org/brand).
   * </pre>
   *
   * <code>repeated string brands = 9;</code>
   *
   * @return The count of brands.
   */
  public int getBrandsCount() {
    return brands_.size();
  }
  /**
   *
   *
   * <pre>
   * The brands of the product.
   *
   * A maximum of 30 brands are allowed. Each brand must be a UTF-8 encoded
   * string with a length limit of 1,000 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [brand](https://support.google.com/merchants/answer/6324351). Schema.org
   * property [Product.brand](https://schema.org/brand).
   * </pre>
   *
   * <code>repeated string brands = 9;</code>
   *
   * @param index The index of the element to return.
   * @return The brands at the given index.
   */
  public java.lang.String getBrands(int index) {
    return brands_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The brands of the product.
   *
   * A maximum of 30 brands are allowed. Each brand must be a UTF-8 encoded
   * string with a length limit of 1,000 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [brand](https://support.google.com/merchants/answer/6324351). Schema.org
   * property [Product.brand](https://schema.org/brand).
   * </pre>
   *
   * <code>repeated string brands = 9;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the brands at the given index.
   */
  public com.google.protobuf.ByteString getBrandsBytes(int index) {
    return brands_.getByteString(index);
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Product description.
   *
   * This field must be a UTF-8 encoded string with a length limit of 5,000
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [description](https://support.google.com/merchants/answer/6324468).
   * Schema.org property [Product.description](https://schema.org/description).
   * </pre>
   *
   * <code>string description = 10;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Product description.
   *
   * This field must be a UTF-8 encoded string with a length limit of 5,000
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [description](https://support.google.com/merchants/answer/6324468).
   * Schema.org property [Product.description](https://schema.org/description).
   * </pre>
   *
   * <code>string description = 10;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object languageCode_ = "";
  /**
   *
   *
   * <pre>
   * Language of the title/description and other string attributes. Use language
   * tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
   *
   * For product prediction, this field is ignored and the model automatically
   * detects the text language. The [Product][google.cloud.retail.v2.Product]
   * can include text in different languages, but duplicating
   * [Product][google.cloud.retail.v2.Product]s to provide text in multiple
   * languages can result in degraded model performance.
   *
   * For product search this field is in use. It defaults to "en-US" if unset.
   * </pre>
   *
   * <code>string language_code = 11;</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Language of the title/description and other string attributes. Use language
   * tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
   *
   * For product prediction, this field is ignored and the model automatically
   * detects the text language. The [Product][google.cloud.retail.v2.Product]
   * can include text in different languages, but duplicating
   * [Product][google.cloud.retail.v2.Product]s to provide text in multiple
   * languages can result in degraded model performance.
   *
   * For product search this field is in use. It defaults to "en-US" if unset.
   * </pre>
   *
   * <code>string language_code = 11;</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ATTRIBUTES_FIELD_NUMBER = 12;

  private static final class AttributesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.retail.v2.CustomAttribute>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.retail.v2.CustomAttribute>newDefaultInstance(
                    com.google.cloud.retail.v2.ProductProto
                        .internal_static_google_cloud_retail_v2_Product_AttributesEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.cloud.retail.v2.CustomAttribute.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.cloud.retail.v2.CustomAttribute>
      attributes_;

  private com.google.protobuf.MapField<java.lang.String, com.google.cloud.retail.v2.CustomAttribute>
      internalGetAttributes() {
    if (attributes_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AttributesDefaultEntryHolder.defaultEntry);
    }
    return attributes_;
  }

  public int getAttributesCount() {
    return internalGetAttributes().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Highly encouraged. Extra product attributes to be included. For example,
   * for products, this could include the store name, vendor, style, color, etc.
   * These are very strong signals for recommendation model, thus we highly
   * recommend providing the attributes here.
   *
   * Features that can take on one of a limited number of possible values. Two
   * types of features can be set are:
   *
   * Textual features. some examples would be the brand/maker of a product, or
   * country of a customer. Numerical features. Some examples would be the
   * height/weight of a product, or age of a customer.
   *
   * For example: `{ "vendor": {"text": ["vendor123", "vendor456"]},
   * "lengths_cm": {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]}
   * }`.
   *
   * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
   * error is returned:
   *
   * * Max entries count: 200.
   * * The key must be a UTF-8 encoded string with a length limit of 128
   *   characters.
   * * For indexable attribute, the key must match the pattern:
   *   `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example, `key0LikeThis` or
   *   `KEY_1_LIKE_THIS`.
   * * For text attributes, at most 400 values are allowed. Empty values are not
   *   allowed. Each value must be a non-empty UTF-8 encoded string with a
   *   length limit of 256 characters.
   * * For number attributes, at most 400 values are allowed.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 12;</code>
   */
  @java.lang.Override
  public boolean containsAttributes(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAttributes().getMap().containsKey(key);
  }
  /** Use {@link #getAttributesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.retail.v2.CustomAttribute>
      getAttributes() {
    return getAttributesMap();
  }
  /**
   *
   *
   * <pre>
   * Highly encouraged. Extra product attributes to be included. For example,
   * for products, this could include the store name, vendor, style, color, etc.
   * These are very strong signals for recommendation model, thus we highly
   * recommend providing the attributes here.
   *
   * Features that can take on one of a limited number of possible values. Two
   * types of features can be set are:
   *
   * Textual features. some examples would be the brand/maker of a product, or
   * country of a customer. Numerical features. Some examples would be the
   * height/weight of a product, or age of a customer.
   *
   * For example: `{ "vendor": {"text": ["vendor123", "vendor456"]},
   * "lengths_cm": {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]}
   * }`.
   *
   * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
   * error is returned:
   *
   * * Max entries count: 200.
   * * The key must be a UTF-8 encoded string with a length limit of 128
   *   characters.
   * * For indexable attribute, the key must match the pattern:
   *   `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example, `key0LikeThis` or
   *   `KEY_1_LIKE_THIS`.
   * * For text attributes, at most 400 values are allowed. Empty values are not
   *   allowed. Each value must be a non-empty UTF-8 encoded string with a
   *   length limit of 256 characters.
   * * For number attributes, at most 400 values are allowed.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 12;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.retail.v2.CustomAttribute>
      getAttributesMap() {
    return internalGetAttributes().getMap();
  }
  /**
   *
   *
   * <pre>
   * Highly encouraged. Extra product attributes to be included. For example,
   * for products, this could include the store name, vendor, style, color, etc.
   * These are very strong signals for recommendation model, thus we highly
   * recommend providing the attributes here.
   *
   * Features that can take on one of a limited number of possible values. Two
   * types of features can be set are:
   *
   * Textual features. some examples would be the brand/maker of a product, or
   * country of a customer. Numerical features. Some examples would be the
   * height/weight of a product, or age of a customer.
   *
   * For example: `{ "vendor": {"text": ["vendor123", "vendor456"]},
   * "lengths_cm": {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]}
   * }`.
   *
   * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
   * error is returned:
   *
   * * Max entries count: 200.
   * * The key must be a UTF-8 encoded string with a length limit of 128
   *   characters.
   * * For indexable attribute, the key must match the pattern:
   *   `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example, `key0LikeThis` or
   *   `KEY_1_LIKE_THIS`.
   * * For text attributes, at most 400 values are allowed. Empty values are not
   *   allowed. Each value must be a non-empty UTF-8 encoded string with a
   *   length limit of 256 characters.
   * * For number attributes, at most 400 values are allowed.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 12;</code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.retail.v2.CustomAttribute getAttributesOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.retail.v2.CustomAttribute defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.retail.v2.CustomAttribute> map =
        internalGetAttributes().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Highly encouraged. Extra product attributes to be included. For example,
   * for products, this could include the store name, vendor, style, color, etc.
   * These are very strong signals for recommendation model, thus we highly
   * recommend providing the attributes here.
   *
   * Features that can take on one of a limited number of possible values. Two
   * types of features can be set are:
   *
   * Textual features. some examples would be the brand/maker of a product, or
   * country of a customer. Numerical features. Some examples would be the
   * height/weight of a product, or age of a customer.
   *
   * For example: `{ "vendor": {"text": ["vendor123", "vendor456"]},
   * "lengths_cm": {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]}
   * }`.
   *
   * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
   * error is returned:
   *
   * * Max entries count: 200.
   * * The key must be a UTF-8 encoded string with a length limit of 128
   *   characters.
   * * For indexable attribute, the key must match the pattern:
   *   `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example, `key0LikeThis` or
   *   `KEY_1_LIKE_THIS`.
   * * For text attributes, at most 400 values are allowed. Empty values are not
   *   allowed. Each value must be a non-empty UTF-8 encoded string with a
   *   length limit of 256 characters.
   * * For number attributes, at most 400 values are allowed.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.CustomAttribute getAttributesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.retail.v2.CustomAttribute> map =
        internalGetAttributes().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int TAGS_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList tags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Custom tags associated with the product.
   *
   * At most 250 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. This value must be a UTF-8
   * encoded string with a length limit of 1,000 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * This tag can be used for filtering recommendation results by passing the
   * tag as part of the
   * [PredictRequest.filter][google.cloud.retail.v2.PredictRequest.filter].
   *
   * Corresponding properties: Google Merchant Center property
   * [custom_label_0–4](https://support.google.com/merchants/answer/6324473).
   * </pre>
   *
   * <code>repeated string tags = 13;</code>
   *
   * @return A list containing the tags.
   */
  public com.google.protobuf.ProtocolStringList getTagsList() {
    return tags_;
  }
  /**
   *
   *
   * <pre>
   * Custom tags associated with the product.
   *
   * At most 250 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. This value must be a UTF-8
   * encoded string with a length limit of 1,000 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * This tag can be used for filtering recommendation results by passing the
   * tag as part of the
   * [PredictRequest.filter][google.cloud.retail.v2.PredictRequest.filter].
   *
   * Corresponding properties: Google Merchant Center property
   * [custom_label_0–4](https://support.google.com/merchants/answer/6324473).
   * </pre>
   *
   * <code>repeated string tags = 13;</code>
   *
   * @return The count of tags.
   */
  public int getTagsCount() {
    return tags_.size();
  }
  /**
   *
   *
   * <pre>
   * Custom tags associated with the product.
   *
   * At most 250 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. This value must be a UTF-8
   * encoded string with a length limit of 1,000 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * This tag can be used for filtering recommendation results by passing the
   * tag as part of the
   * [PredictRequest.filter][google.cloud.retail.v2.PredictRequest.filter].
   *
   * Corresponding properties: Google Merchant Center property
   * [custom_label_0–4](https://support.google.com/merchants/answer/6324473).
   * </pre>
   *
   * <code>repeated string tags = 13;</code>
   *
   * @param index The index of the element to return.
   * @return The tags at the given index.
   */
  public java.lang.String getTags(int index) {
    return tags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Custom tags associated with the product.
   *
   * At most 250 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. This value must be a UTF-8
   * encoded string with a length limit of 1,000 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * This tag can be used for filtering recommendation results by passing the
   * tag as part of the
   * [PredictRequest.filter][google.cloud.retail.v2.PredictRequest.filter].
   *
   * Corresponding properties: Google Merchant Center property
   * [custom_label_0–4](https://support.google.com/merchants/answer/6324473).
   * </pre>
   *
   * <code>repeated string tags = 13;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the tags at the given index.
   */
  public com.google.protobuf.ByteString getTagsBytes(int index) {
    return tags_.getByteString(index);
  }

  public static final int PRICE_INFO_FIELD_NUMBER = 14;
  private com.google.cloud.retail.v2.PriceInfo priceInfo_;
  /**
   *
   *
   * <pre>
   * Product price and cost information.
   *
   * Corresponding properties: Google Merchant Center property
   * [price](https://support.google.com/merchants/answer/6324371).
   * </pre>
   *
   * <code>.google.cloud.retail.v2.PriceInfo price_info = 14;</code>
   *
   * @return Whether the priceInfo field is set.
   */
  @java.lang.Override
  public boolean hasPriceInfo() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Product price and cost information.
   *
   * Corresponding properties: Google Merchant Center property
   * [price](https://support.google.com/merchants/answer/6324371).
   * </pre>
   *
   * <code>.google.cloud.retail.v2.PriceInfo price_info = 14;</code>
   *
   * @return The priceInfo.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.PriceInfo getPriceInfo() {
    return priceInfo_ == null
        ? com.google.cloud.retail.v2.PriceInfo.getDefaultInstance()
        : priceInfo_;
  }
  /**
   *
   *
   * <pre>
   * Product price and cost information.
   *
   * Corresponding properties: Google Merchant Center property
   * [price](https://support.google.com/merchants/answer/6324371).
   * </pre>
   *
   * <code>.google.cloud.retail.v2.PriceInfo price_info = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.PriceInfoOrBuilder getPriceInfoOrBuilder() {
    return priceInfo_ == null
        ? com.google.cloud.retail.v2.PriceInfo.getDefaultInstance()
        : priceInfo_;
  }

  public static final int RATING_FIELD_NUMBER = 15;
  private com.google.cloud.retail.v2.Rating rating_;
  /**
   *
   *
   * <pre>
   * The rating of this product.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.Rating rating = 15;</code>
   *
   * @return Whether the rating field is set.
   */
  @java.lang.Override
  public boolean hasRating() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The rating of this product.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.Rating rating = 15;</code>
   *
   * @return The rating.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.Rating getRating() {
    return rating_ == null ? com.google.cloud.retail.v2.Rating.getDefaultInstance() : rating_;
  }
  /**
   *
   *
   * <pre>
   * The rating of this product.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.Rating rating = 15;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.RatingOrBuilder getRatingOrBuilder() {
    return rating_ == null ? com.google.cloud.retail.v2.Rating.getDefaultInstance() : rating_;
  }

  public static final int AVAILABLE_TIME_FIELD_NUMBER = 18;
  private com.google.protobuf.Timestamp availableTime_;
  /**
   *
   *
   * <pre>
   * The timestamp when this [Product][google.cloud.retail.v2.Product] becomes
   * available for
   * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
   * that this is only applicable to
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
   * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp available_time = 18;</code>
   *
   * @return Whether the availableTime field is set.
   */
  @java.lang.Override
  public boolean hasAvailableTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The timestamp when this [Product][google.cloud.retail.v2.Product] becomes
   * available for
   * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
   * that this is only applicable to
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
   * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp available_time = 18;</code>
   *
   * @return The availableTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getAvailableTime() {
    return availableTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : availableTime_;
  }
  /**
   *
   *
   * <pre>
   * The timestamp when this [Product][google.cloud.retail.v2.Product] becomes
   * available for
   * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
   * that this is only applicable to
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
   * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp available_time = 18;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getAvailableTimeOrBuilder() {
    return availableTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : availableTime_;
  }

  public static final int AVAILABILITY_FIELD_NUMBER = 19;
  private int availability_ = 0;
  /**
   *
   *
   * <pre>
   * The online availability of the [Product][google.cloud.retail.v2.Product].
   * Default to
   * [Availability.IN_STOCK][google.cloud.retail.v2.Product.Availability.IN_STOCK].
   *
   * Corresponding properties: Google Merchant Center property
   * [availability](https://support.google.com/merchants/answer/6324448).
   * Schema.org property [Offer.availability](https://schema.org/availability).
   * </pre>
   *
   * <code>.google.cloud.retail.v2.Product.Availability availability = 19;</code>
   *
   * @return The enum numeric value on the wire for availability.
   */
  @java.lang.Override
  public int getAvailabilityValue() {
    return availability_;
  }
  /**
   *
   *
   * <pre>
   * The online availability of the [Product][google.cloud.retail.v2.Product].
   * Default to
   * [Availability.IN_STOCK][google.cloud.retail.v2.Product.Availability.IN_STOCK].
   *
   * Corresponding properties: Google Merchant Center property
   * [availability](https://support.google.com/merchants/answer/6324448).
   * Schema.org property [Offer.availability](https://schema.org/availability).
   * </pre>
   *
   * <code>.google.cloud.retail.v2.Product.Availability availability = 19;</code>
   *
   * @return The availability.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.Product.Availability getAvailability() {
    com.google.cloud.retail.v2.Product.Availability result =
        com.google.cloud.retail.v2.Product.Availability.forNumber(availability_);
    return result == null ? com.google.cloud.retail.v2.Product.Availability.UNRECOGNIZED : result;
  }

  public static final int AVAILABLE_QUANTITY_FIELD_NUMBER = 20;
  private com.google.protobuf.Int32Value availableQuantity_;
  /**
   *
   *
   * <pre>
   * The available quantity of the item.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value available_quantity = 20;</code>
   *
   * @return Whether the availableQuantity field is set.
   */
  @java.lang.Override
  public boolean hasAvailableQuantity() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The available quantity of the item.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value available_quantity = 20;</code>
   *
   * @return The availableQuantity.
   */
  @java.lang.Override
  public com.google.protobuf.Int32Value getAvailableQuantity() {
    return availableQuantity_ == null
        ? com.google.protobuf.Int32Value.getDefaultInstance()
        : availableQuantity_;
  }
  /**
   *
   *
   * <pre>
   * The available quantity of the item.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value available_quantity = 20;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Int32ValueOrBuilder getAvailableQuantityOrBuilder() {
    return availableQuantity_ == null
        ? com.google.protobuf.Int32Value.getDefaultInstance()
        : availableQuantity_;
  }

  public static final int FULFILLMENT_INFO_FIELD_NUMBER = 21;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.retail.v2.FulfillmentInfo> fulfillmentInfo_;
  /**
   *
   *
   * <pre>
   * Fulfillment information, such as the store IDs for in-store pickup or
   * region IDs for different shipping methods.
   *
   * All the elements must have distinct
   * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
   * Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2.FulfillmentInfo> getFulfillmentInfoList() {
    return fulfillmentInfo_;
  }
  /**
   *
   *
   * <pre>
   * Fulfillment information, such as the store IDs for in-store pickup or
   * region IDs for different shipping methods.
   *
   * All the elements must have distinct
   * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
   * Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.retail.v2.FulfillmentInfoOrBuilder>
      getFulfillmentInfoOrBuilderList() {
    return fulfillmentInfo_;
  }
  /**
   *
   *
   * <pre>
   * Fulfillment information, such as the store IDs for in-store pickup or
   * region IDs for different shipping methods.
   *
   * All the elements must have distinct
   * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
   * Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
   */
  @java.lang.Override
  public int getFulfillmentInfoCount() {
    return fulfillmentInfo_.size();
  }
  /**
   *
   *
   * <pre>
   * Fulfillment information, such as the store IDs for in-store pickup or
   * region IDs for different shipping methods.
   *
   * All the elements must have distinct
   * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
   * Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.FulfillmentInfo getFulfillmentInfo(int index) {
    return fulfillmentInfo_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Fulfillment information, such as the store IDs for in-store pickup or
   * region IDs for different shipping methods.
   *
   * All the elements must have distinct
   * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
   * Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.FulfillmentInfoOrBuilder getFulfillmentInfoOrBuilder(
      int index) {
    return fulfillmentInfo_.get(index);
  }

  public static final int URI_FIELD_NUMBER = 22;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uri_ = "";
  /**
   *
   *
   * <pre>
   * Canonical URL directly linking to the product detail page.
   *
   * It is strongly recommended to provide a valid uri for the product,
   * otherwise the service performance could be significantly degraded.
   *
   * This field must be a UTF-8 encoded string with a length limit of 5,000
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [link](https://support.google.com/merchants/answer/6324416). Schema.org
   * property [Offer.url](https://schema.org/url).
   * </pre>
   *
   * <code>string uri = 22;</code>
   *
   * @return The uri.
   */
  @java.lang.Override
  public java.lang.String getUri() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Canonical URL directly linking to the product detail page.
   *
   * It is strongly recommended to provide a valid uri for the product,
   * otherwise the service performance could be significantly degraded.
   *
   * This field must be a UTF-8 encoded string with a length limit of 5,000
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [link](https://support.google.com/merchants/answer/6324416). Schema.org
   * property [Offer.url](https://schema.org/url).
   * </pre>
   *
   * <code>string uri = 22;</code>
   *
   * @return The bytes for uri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUriBytes() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IMAGES_FIELD_NUMBER = 23;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.retail.v2.Image> images_;
  /**
   *
   *
   * <pre>
   * Product images for the product. We highly recommend putting the main
   * image first.
   *
   * A maximum of 300 images are allowed.
   *
   * Corresponding properties: Google Merchant Center property
   * [image_link](https://support.google.com/merchants/answer/6324350).
   * Schema.org property [Product.image](https://schema.org/image).
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2.Image> getImagesList() {
    return images_;
  }
  /**
   *
   *
   * <pre>
   * Product images for the product. We highly recommend putting the main
   * image first.
   *
   * A maximum of 300 images are allowed.
   *
   * Corresponding properties: Google Merchant Center property
   * [image_link](https://support.google.com/merchants/answer/6324350).
   * Schema.org property [Product.image](https://schema.org/image).
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.retail.v2.ImageOrBuilder>
      getImagesOrBuilderList() {
    return images_;
  }
  /**
   *
   *
   * <pre>
   * Product images for the product. We highly recommend putting the main
   * image first.
   *
   * A maximum of 300 images are allowed.
   *
   * Corresponding properties: Google Merchant Center property
   * [image_link](https://support.google.com/merchants/answer/6324350).
   * Schema.org property [Product.image](https://schema.org/image).
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
   */
  @java.lang.Override
  public int getImagesCount() {
    return images_.size();
  }
  /**
   *
   *
   * <pre>
   * Product images for the product. We highly recommend putting the main
   * image first.
   *
   * A maximum of 300 images are allowed.
   *
   * Corresponding properties: Google Merchant Center property
   * [image_link](https://support.google.com/merchants/answer/6324350).
   * Schema.org property [Product.image](https://schema.org/image).
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.Image getImages(int index) {
    return images_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Product images for the product. We highly recommend putting the main
   * image first.
   *
   * A maximum of 300 images are allowed.
   *
   * Corresponding properties: Google Merchant Center property
   * [image_link](https://support.google.com/merchants/answer/6324350).
   * Schema.org property [Product.image](https://schema.org/image).
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.ImageOrBuilder getImagesOrBuilder(int index) {
    return images_.get(index);
  }

  public static final int AUDIENCE_FIELD_NUMBER = 24;
  private com.google.cloud.retail.v2.Audience audience_;
  /**
   *
   *
   * <pre>
   * The target group associated with a given audience (e.g. male, veterans,
   * car owners, musicians, etc.) of the product.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.Audience audience = 24;</code>
   *
   * @return Whether the audience field is set.
   */
  @java.lang.Override
  public boolean hasAudience() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * The target group associated with a given audience (e.g. male, veterans,
   * car owners, musicians, etc.) of the product.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.Audience audience = 24;</code>
   *
   * @return The audience.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.Audience getAudience() {
    return audience_ == null ? com.google.cloud.retail.v2.Audience.getDefaultInstance() : audience_;
  }
  /**
   *
   *
   * <pre>
   * The target group associated with a given audience (e.g. male, veterans,
   * car owners, musicians, etc.) of the product.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.Audience audience = 24;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.AudienceOrBuilder getAudienceOrBuilder() {
    return audience_ == null ? com.google.cloud.retail.v2.Audience.getDefaultInstance() : audience_;
  }

  public static final int COLOR_INFO_FIELD_NUMBER = 25;
  private com.google.cloud.retail.v2.ColorInfo colorInfo_;
  /**
   *
   *
   * <pre>
   * The color of the product.
   *
   * Corresponding properties: Google Merchant Center property
   * [color](https://support.google.com/merchants/answer/6324487). Schema.org
   * property [Product.color](https://schema.org/color).
   * </pre>
   *
   * <code>.google.cloud.retail.v2.ColorInfo color_info = 25;</code>
   *
   * @return Whether the colorInfo field is set.
   */
  @java.lang.Override
  public boolean hasColorInfo() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * The color of the product.
   *
   * Corresponding properties: Google Merchant Center property
   * [color](https://support.google.com/merchants/answer/6324487). Schema.org
   * property [Product.color](https://schema.org/color).
   * </pre>
   *
   * <code>.google.cloud.retail.v2.ColorInfo color_info = 25;</code>
   *
   * @return The colorInfo.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.ColorInfo getColorInfo() {
    return colorInfo_ == null
        ? com.google.cloud.retail.v2.ColorInfo.getDefaultInstance()
        : colorInfo_;
  }
  /**
   *
   *
   * <pre>
   * The color of the product.
   *
   * Corresponding properties: Google Merchant Center property
   * [color](https://support.google.com/merchants/answer/6324487). Schema.org
   * property [Product.color](https://schema.org/color).
   * </pre>
   *
   * <code>.google.cloud.retail.v2.ColorInfo color_info = 25;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.ColorInfoOrBuilder getColorInfoOrBuilder() {
    return colorInfo_ == null
        ? com.google.cloud.retail.v2.ColorInfo.getDefaultInstance()
        : colorInfo_;
  }

  public static final int SIZES_FIELD_NUMBER = 26;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList sizes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The size of the product. To represent different size systems or size types,
   * consider using this format: [[[size_system:]size_type:]size_value].
   *
   * For example, in "US:MENS:M", "US" represents size system; "MENS" represents
   * size type; "M" represents size value. In "GIRLS:27", size system is empty;
   * "GIRLS" represents size type; "27" represents size value. In "32 inches",
   * both size system and size type are empty, while size value is "32 inches".
   *
   * A maximum of 20 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
   * encoded string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [size](https://support.google.com/merchants/answer/6324492),
   * [size_type](https://support.google.com/merchants/answer/6324497), and
   * [size_system](https://support.google.com/merchants/answer/6324502).
   * Schema.org property [Product.size](https://schema.org/size).
   * </pre>
   *
   * <code>repeated string sizes = 26;</code>
   *
   * @return A list containing the sizes.
   */
  public com.google.protobuf.ProtocolStringList getSizesList() {
    return sizes_;
  }
  /**
   *
   *
   * <pre>
   * The size of the product. To represent different size systems or size types,
   * consider using this format: [[[size_system:]size_type:]size_value].
   *
   * For example, in "US:MENS:M", "US" represents size system; "MENS" represents
   * size type; "M" represents size value. In "GIRLS:27", size system is empty;
   * "GIRLS" represents size type; "27" represents size value. In "32 inches",
   * both size system and size type are empty, while size value is "32 inches".
   *
   * A maximum of 20 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
   * encoded string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [size](https://support.google.com/merchants/answer/6324492),
   * [size_type](https://support.google.com/merchants/answer/6324497), and
   * [size_system](https://support.google.com/merchants/answer/6324502).
   * Schema.org property [Product.size](https://schema.org/size).
   * </pre>
   *
   * <code>repeated string sizes = 26;</code>
   *
   * @return The count of sizes.
   */
  public int getSizesCount() {
    return sizes_.size();
  }
  /**
   *
   *
   * <pre>
   * The size of the product. To represent different size systems or size types,
   * consider using this format: [[[size_system:]size_type:]size_value].
   *
   * For example, in "US:MENS:M", "US" represents size system; "MENS" represents
   * size type; "M" represents size value. In "GIRLS:27", size system is empty;
   * "GIRLS" represents size type; "27" represents size value. In "32 inches",
   * both size system and size type are empty, while size value is "32 inches".
   *
   * A maximum of 20 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
   * encoded string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [size](https://support.google.com/merchants/answer/6324492),
   * [size_type](https://support.google.com/merchants/answer/6324497), and
   * [size_system](https://support.google.com/merchants/answer/6324502).
   * Schema.org property [Product.size](https://schema.org/size).
   * </pre>
   *
   * <code>repeated string sizes = 26;</code>
   *
   * @param index The index of the element to return.
   * @return The sizes at the given index.
   */
  public java.lang.String getSizes(int index) {
    return sizes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The size of the product. To represent different size systems or size types,
   * consider using this format: [[[size_system:]size_type:]size_value].
   *
   * For example, in "US:MENS:M", "US" represents size system; "MENS" represents
   * size type; "M" represents size value. In "GIRLS:27", size system is empty;
   * "GIRLS" represents size type; "27" represents size value. In "32 inches",
   * both size system and size type are empty, while size value is "32 inches".
   *
   * A maximum of 20 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
   * encoded string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [size](https://support.google.com/merchants/answer/6324492),
   * [size_type](https://support.google.com/merchants/answer/6324497), and
   * [size_system](https://support.google.com/merchants/answer/6324502).
   * Schema.org property [Product.size](https://schema.org/size).
   * </pre>
   *
   * <code>repeated string sizes = 26;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the sizes at the given index.
   */
  public com.google.protobuf.ByteString getSizesBytes(int index) {
    return sizes_.getByteString(index);
  }

  public static final int MATERIALS_FIELD_NUMBER = 27;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList materials_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The material of the product. For example, "leather", "wooden".
   *
   * A maximum of 20 values are allowed. Each value must be a UTF-8 encoded
   * string with a length limit of 200 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [material](https://support.google.com/merchants/answer/6324410). Schema.org
   * property [Product.material](https://schema.org/material).
   * </pre>
   *
   * <code>repeated string materials = 27;</code>
   *
   * @return A list containing the materials.
   */
  public com.google.protobuf.ProtocolStringList getMaterialsList() {
    return materials_;
  }
  /**
   *
   *
   * <pre>
   * The material of the product. For example, "leather", "wooden".
   *
   * A maximum of 20 values are allowed. Each value must be a UTF-8 encoded
   * string with a length limit of 200 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [material](https://support.google.com/merchants/answer/6324410). Schema.org
   * property [Product.material](https://schema.org/material).
   * </pre>
   *
   * <code>repeated string materials = 27;</code>
   *
   * @return The count of materials.
   */
  public int getMaterialsCount() {
    return materials_.size();
  }
  /**
   *
   *
   * <pre>
   * The material of the product. For example, "leather", "wooden".
   *
   * A maximum of 20 values are allowed. Each value must be a UTF-8 encoded
   * string with a length limit of 200 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [material](https://support.google.com/merchants/answer/6324410). Schema.org
   * property [Product.material](https://schema.org/material).
   * </pre>
   *
   * <code>repeated string materials = 27;</code>
   *
   * @param index The index of the element to return.
   * @return The materials at the given index.
   */
  public java.lang.String getMaterials(int index) {
    return materials_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The material of the product. For example, "leather", "wooden".
   *
   * A maximum of 20 values are allowed. Each value must be a UTF-8 encoded
   * string with a length limit of 200 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [material](https://support.google.com/merchants/answer/6324410). Schema.org
   * property [Product.material](https://schema.org/material).
   * </pre>
   *
   * <code>repeated string materials = 27;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the materials at the given index.
   */
  public com.google.protobuf.ByteString getMaterialsBytes(int index) {
    return materials_.getByteString(index);
  }

  public static final int PATTERNS_FIELD_NUMBER = 28;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList patterns_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The pattern or graphic print of the product. For example, "striped", "polka
   * dot", "paisley".
   *
   * A maximum of 20 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
   * encoded string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [pattern](https://support.google.com/merchants/answer/6324483). Schema.org
   * property [Product.pattern](https://schema.org/pattern).
   * </pre>
   *
   * <code>repeated string patterns = 28;</code>
   *
   * @return A list containing the patterns.
   */
  public com.google.protobuf.ProtocolStringList getPatternsList() {
    return patterns_;
  }
  /**
   *
   *
   * <pre>
   * The pattern or graphic print of the product. For example, "striped", "polka
   * dot", "paisley".
   *
   * A maximum of 20 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
   * encoded string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [pattern](https://support.google.com/merchants/answer/6324483). Schema.org
   * property [Product.pattern](https://schema.org/pattern).
   * </pre>
   *
   * <code>repeated string patterns = 28;</code>
   *
   * @return The count of patterns.
   */
  public int getPatternsCount() {
    return patterns_.size();
  }
  /**
   *
   *
   * <pre>
   * The pattern or graphic print of the product. For example, "striped", "polka
   * dot", "paisley".
   *
   * A maximum of 20 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
   * encoded string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [pattern](https://support.google.com/merchants/answer/6324483). Schema.org
   * property [Product.pattern](https://schema.org/pattern).
   * </pre>
   *
   * <code>repeated string patterns = 28;</code>
   *
   * @param index The index of the element to return.
   * @return The patterns at the given index.
   */
  public java.lang.String getPatterns(int index) {
    return patterns_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The pattern or graphic print of the product. For example, "striped", "polka
   * dot", "paisley".
   *
   * A maximum of 20 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
   * encoded string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [pattern](https://support.google.com/merchants/answer/6324483). Schema.org
   * property [Product.pattern](https://schema.org/pattern).
   * </pre>
   *
   * <code>repeated string patterns = 28;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the patterns at the given index.
   */
  public com.google.protobuf.ByteString getPatternsBytes(int index) {
    return patterns_.getByteString(index);
  }

  public static final int CONDITIONS_FIELD_NUMBER = 29;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList conditions_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The condition of the product. Strongly encouraged to use the standard
   * values: "new", "refurbished", "used".
   *
   * A maximum of 1 value is allowed per
   * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
   * encoded string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [condition](https://support.google.com/merchants/answer/6324469).
   * Schema.org property
   * [Offer.itemCondition](https://schema.org/itemCondition).
   * </pre>
   *
   * <code>repeated string conditions = 29;</code>
   *
   * @return A list containing the conditions.
   */
  public com.google.protobuf.ProtocolStringList getConditionsList() {
    return conditions_;
  }
  /**
   *
   *
   * <pre>
   * The condition of the product. Strongly encouraged to use the standard
   * values: "new", "refurbished", "used".
   *
   * A maximum of 1 value is allowed per
   * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
   * encoded string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [condition](https://support.google.com/merchants/answer/6324469).
   * Schema.org property
   * [Offer.itemCondition](https://schema.org/itemCondition).
   * </pre>
   *
   * <code>repeated string conditions = 29;</code>
   *
   * @return The count of conditions.
   */
  public int getConditionsCount() {
    return conditions_.size();
  }
  /**
   *
   *
   * <pre>
   * The condition of the product. Strongly encouraged to use the standard
   * values: "new", "refurbished", "used".
   *
   * A maximum of 1 value is allowed per
   * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
   * encoded string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [condition](https://support.google.com/merchants/answer/6324469).
   * Schema.org property
   * [Offer.itemCondition](https://schema.org/itemCondition).
   * </pre>
   *
   * <code>repeated string conditions = 29;</code>
   *
   * @param index The index of the element to return.
   * @return The conditions at the given index.
   */
  public java.lang.String getConditions(int index) {
    return conditions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The condition of the product. Strongly encouraged to use the standard
   * values: "new", "refurbished", "used".
   *
   * A maximum of 1 value is allowed per
   * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
   * encoded string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [condition](https://support.google.com/merchants/answer/6324469).
   * Schema.org property
   * [Offer.itemCondition](https://schema.org/itemCondition).
   * </pre>
   *
   * <code>repeated string conditions = 29;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the conditions at the given index.
   */
  public com.google.protobuf.ByteString getConditionsBytes(int index) {
    return conditions_.getByteString(index);
  }

  public static final int PROMOTIONS_FIELD_NUMBER = 34;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.retail.v2.Promotion> promotions_;
  /**
   *
   *
   * <pre>
   * The promotions applied to the product. A maximum of 10 values are allowed
   * per [Product][google.cloud.retail.v2.Product]. Only
   * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
   * will be used, other fields will be ignored if set.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2.Promotion> getPromotionsList() {
    return promotions_;
  }
  /**
   *
   *
   * <pre>
   * The promotions applied to the product. A maximum of 10 values are allowed
   * per [Product][google.cloud.retail.v2.Product]. Only
   * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
   * will be used, other fields will be ignored if set.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.retail.v2.PromotionOrBuilder>
      getPromotionsOrBuilderList() {
    return promotions_;
  }
  /**
   *
   *
   * <pre>
   * The promotions applied to the product. A maximum of 10 values are allowed
   * per [Product][google.cloud.retail.v2.Product]. Only
   * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
   * will be used, other fields will be ignored if set.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
   */
  @java.lang.Override
  public int getPromotionsCount() {
    return promotions_.size();
  }
  /**
   *
   *
   * <pre>
   * The promotions applied to the product. A maximum of 10 values are allowed
   * per [Product][google.cloud.retail.v2.Product]. Only
   * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
   * will be used, other fields will be ignored if set.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.Promotion getPromotions(int index) {
    return promotions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The promotions applied to the product. A maximum of 10 values are allowed
   * per [Product][google.cloud.retail.v2.Product]. Only
   * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
   * will be used, other fields will be ignored if set.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.PromotionOrBuilder getPromotionsOrBuilder(int index) {
    return promotions_.get(index);
  }

  public static final int PUBLISH_TIME_FIELD_NUMBER = 33;
  private com.google.protobuf.Timestamp publishTime_;
  /**
   *
   *
   * <pre>
   * The timestamp when the product is published by the retailer for the first
   * time, which indicates the freshness of the products. Note that this field
   * is different from
   * [available_time][google.cloud.retail.v2.Product.available_time], given it
   * purely describes product freshness regardless of when it is available on
   * search and recommendation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp publish_time = 33;</code>
   *
   * @return Whether the publishTime field is set.
   */
  @java.lang.Override
  public boolean hasPublishTime() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * The timestamp when the product is published by the retailer for the first
   * time, which indicates the freshness of the products. Note that this field
   * is different from
   * [available_time][google.cloud.retail.v2.Product.available_time], given it
   * purely describes product freshness regardless of when it is available on
   * search and recommendation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp publish_time = 33;</code>
   *
   * @return The publishTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getPublishTime() {
    return publishTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : publishTime_;
  }
  /**
   *
   *
   * <pre>
   * The timestamp when the product is published by the retailer for the first
   * time, which indicates the freshness of the products. Note that this field
   * is different from
   * [available_time][google.cloud.retail.v2.Product.available_time], given it
   * purely describes product freshness regardless of when it is available on
   * search and recommendation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp publish_time = 33;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getPublishTimeOrBuilder() {
    return publishTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : publishTime_;
  }

  public static final int RETRIEVABLE_FIELDS_FIELD_NUMBER = 30;
  private com.google.protobuf.FieldMask retrievableFields_;
  /**
   *
   *
   * <pre>
   * Indicates which fields in the [Product][google.cloud.retail.v2.Product]s
   * are returned in [SearchResponse][google.cloud.retail.v2.SearchResponse].
   *
   * Supported fields for all [type][google.cloud.retail.v2.Product.type]s:
   *
   * * [audience][google.cloud.retail.v2.Product.audience]
   * * [availability][google.cloud.retail.v2.Product.availability]
   * * [brands][google.cloud.retail.v2.Product.brands]
   * * [color_info][google.cloud.retail.v2.Product.color_info]
   * * [conditions][google.cloud.retail.v2.Product.conditions]
   * * [gtin][google.cloud.retail.v2.Product.gtin]
   * * [materials][google.cloud.retail.v2.Product.materials]
   * * [name][google.cloud.retail.v2.Product.name]
   * * [patterns][google.cloud.retail.v2.Product.patterns]
   * * [price_info][google.cloud.retail.v2.Product.price_info]
   * * [rating][google.cloud.retail.v2.Product.rating]
   * * [sizes][google.cloud.retail.v2.Product.sizes]
   * * [title][google.cloud.retail.v2.Product.title]
   * * [uri][google.cloud.retail.v2.Product.uri]
   *
   * Supported fields only for
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION]:
   *
   * * [categories][google.cloud.retail.v2.Product.categories]
   * * [description][google.cloud.retail.v2.Product.description]
   * * [images][google.cloud.retail.v2.Product.images]
   *
   * Supported fields only for
   * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]:
   *
   * * Only the first image in [images][google.cloud.retail.v2.Product.images]
   *
   * To mark [attributes][google.cloud.retail.v2.Product.attributes] as
   * retrievable, include paths of the form "attributes.key" where "key" is the
   * key of a custom attribute, as specified in
   * [attributes][google.cloud.retail.v2.Product.attributes].
   *
   * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], the
   * following fields are always returned in
   * [SearchResponse][google.cloud.retail.v2.SearchResponse] by default:
   *
   * * [name][google.cloud.retail.v2.Product.name]
   *
   * For [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT], the
   * following fields are always returned in by default:
   *
   * * [name][google.cloud.retail.v2.Product.name]
   * * [color_info][google.cloud.retail.v2.Product.color_info]
   *
   * The maximum number of paths is 30. Otherwise, an INVALID_ARGUMENT error is
   * returned.
   *
   * Note: Returning more fields in
   * [SearchResponse][google.cloud.retail.v2.SearchResponse] can increase
   * response payload size and serving latency.
   *
   * This field is deprecated. Use the retrievable site-wide control instead.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask retrievable_fields = 30 [deprecated = true];</code>
   *
   * @deprecated google.cloud.retail.v2.Product.retrievable_fields is deprecated. See
   *     google/cloud/retail/v2/product.proto;l=562
   * @return Whether the retrievableFields field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasRetrievableFields() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Indicates which fields in the [Product][google.cloud.retail.v2.Product]s
   * are returned in [SearchResponse][google.cloud.retail.v2.SearchResponse].
   *
   * Supported fields for all [type][google.cloud.retail.v2.Product.type]s:
   *
   * * [audience][google.cloud.retail.v2.Product.audience]
   * * [availability][google.cloud.retail.v2.Product.availability]
   * * [brands][google.cloud.retail.v2.Product.brands]
   * * [color_info][google.cloud.retail.v2.Product.color_info]
   * * [conditions][google.cloud.retail.v2.Product.conditions]
   * * [gtin][google.cloud.retail.v2.Product.gtin]
   * * [materials][google.cloud.retail.v2.Product.materials]
   * * [name][google.cloud.retail.v2.Product.name]
   * * [patterns][google.cloud.retail.v2.Product.patterns]
   * * [price_info][google.cloud.retail.v2.Product.price_info]
   * * [rating][google.cloud.retail.v2.Product.rating]
   * * [sizes][google.cloud.retail.v2.Product.sizes]
   * * [title][google.cloud.retail.v2.Product.title]
   * * [uri][google.cloud.retail.v2.Product.uri]
   *
   * Supported fields only for
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION]:
   *
   * * [categories][google.cloud.retail.v2.Product.categories]
   * * [description][google.cloud.retail.v2.Product.description]
   * * [images][google.cloud.retail.v2.Product.images]
   *
   * Supported fields only for
   * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]:
   *
   * * Only the first image in [images][google.cloud.retail.v2.Product.images]
   *
   * To mark [attributes][google.cloud.retail.v2.Product.attributes] as
   * retrievable, include paths of the form "attributes.key" where "key" is the
   * key of a custom attribute, as specified in
   * [attributes][google.cloud.retail.v2.Product.attributes].
   *
   * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], the
   * following fields are always returned in
   * [SearchResponse][google.cloud.retail.v2.SearchResponse] by default:
   *
   * * [name][google.cloud.retail.v2.Product.name]
   *
   * For [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT], the
   * following fields are always returned in by default:
   *
   * * [name][google.cloud.retail.v2.Product.name]
   * * [color_info][google.cloud.retail.v2.Product.color_info]
   *
   * The maximum number of paths is 30. Otherwise, an INVALID_ARGUMENT error is
   * returned.
   *
   * Note: Returning more fields in
   * [SearchResponse][google.cloud.retail.v2.SearchResponse] can increase
   * response payload size and serving latency.
   *
   * This field is deprecated. Use the retrievable site-wide control instead.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask retrievable_fields = 30 [deprecated = true];</code>
   *
   * @deprecated google.cloud.retail.v2.Product.retrievable_fields is deprecated. See
   *     google/cloud/retail/v2/product.proto;l=562
   * @return The retrievableFields.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.FieldMask getRetrievableFields() {
    return retrievableFields_ == null
        ? com.google.protobuf.FieldMask.getDefaultInstance()
        : retrievableFields_;
  }
  /**
   *
   *
   * <pre>
   * Indicates which fields in the [Product][google.cloud.retail.v2.Product]s
   * are returned in [SearchResponse][google.cloud.retail.v2.SearchResponse].
   *
   * Supported fields for all [type][google.cloud.retail.v2.Product.type]s:
   *
   * * [audience][google.cloud.retail.v2.Product.audience]
   * * [availability][google.cloud.retail.v2.Product.availability]
   * * [brands][google.cloud.retail.v2.Product.brands]
   * * [color_info][google.cloud.retail.v2.Product.color_info]
   * * [conditions][google.cloud.retail.v2.Product.conditions]
   * * [gtin][google.cloud.retail.v2.Product.gtin]
   * * [materials][google.cloud.retail.v2.Product.materials]
   * * [name][google.cloud.retail.v2.Product.name]
   * * [patterns][google.cloud.retail.v2.Product.patterns]
   * * [price_info][google.cloud.retail.v2.Product.price_info]
   * * [rating][google.cloud.retail.v2.Product.rating]
   * * [sizes][google.cloud.retail.v2.Product.sizes]
   * * [title][google.cloud.retail.v2.Product.title]
   * * [uri][google.cloud.retail.v2.Product.uri]
   *
   * Supported fields only for
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION]:
   *
   * * [categories][google.cloud.retail.v2.Product.categories]
   * * [description][google.cloud.retail.v2.Product.description]
   * * [images][google.cloud.retail.v2.Product.images]
   *
   * Supported fields only for
   * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]:
   *
   * * Only the first image in [images][google.cloud.retail.v2.Product.images]
   *
   * To mark [attributes][google.cloud.retail.v2.Product.attributes] as
   * retrievable, include paths of the form "attributes.key" where "key" is the
   * key of a custom attribute, as specified in
   * [attributes][google.cloud.retail.v2.Product.attributes].
   *
   * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], the
   * following fields are always returned in
   * [SearchResponse][google.cloud.retail.v2.SearchResponse] by default:
   *
   * * [name][google.cloud.retail.v2.Product.name]
   *
   * For [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT], the
   * following fields are always returned in by default:
   *
   * * [name][google.cloud.retail.v2.Product.name]
   * * [color_info][google.cloud.retail.v2.Product.color_info]
   *
   * The maximum number of paths is 30. Otherwise, an INVALID_ARGUMENT error is
   * returned.
   *
   * Note: Returning more fields in
   * [SearchResponse][google.cloud.retail.v2.SearchResponse] can increase
   * response payload size and serving latency.
   *
   * This field is deprecated. Use the retrievable site-wide control instead.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask retrievable_fields = 30 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.FieldMaskOrBuilder getRetrievableFieldsOrBuilder() {
    return retrievableFields_ == null
        ? com.google.protobuf.FieldMask.getDefaultInstance()
        : retrievableFields_;
  }

  public static final int VARIANTS_FIELD_NUMBER = 31;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.retail.v2.Product> variants_;
  /**
   *
   *
   * <pre>
   * Output only. Product variants grouped together on primary product which
   * share similar product attributes. It's automatically grouped by
   * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
   * all the product variants. Only populated for
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2.Product]s.
   *
   * Note: This field is OUTPUT_ONLY for
   * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
   * Do not set this field in API requests.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2.Product> getVariantsList() {
    return variants_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Product variants grouped together on primary product which
   * share similar product attributes. It's automatically grouped by
   * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
   * all the product variants. Only populated for
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2.Product]s.
   *
   * Note: This field is OUTPUT_ONLY for
   * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
   * Do not set this field in API requests.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.retail.v2.ProductOrBuilder>
      getVariantsOrBuilderList() {
    return variants_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Product variants grouped together on primary product which
   * share similar product attributes. It's automatically grouped by
   * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
   * all the product variants. Only populated for
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2.Product]s.
   *
   * Note: This field is OUTPUT_ONLY for
   * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
   * Do not set this field in API requests.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getVariantsCount() {
    return variants_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Product variants grouped together on primary product which
   * share similar product attributes. It's automatically grouped by
   * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
   * all the product variants. Only populated for
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2.Product]s.
   *
   * Note: This field is OUTPUT_ONLY for
   * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
   * Do not set this field in API requests.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.Product getVariants(int index) {
    return variants_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Product variants grouped together on primary product which
   * share similar product attributes. It's automatically grouped by
   * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
   * all the product variants. Only populated for
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2.Product]s.
   *
   * Note: This field is OUTPUT_ONLY for
   * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
   * Do not set this field in API requests.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.ProductOrBuilder getVariantsOrBuilder(int index) {
    return variants_.get(index);
  }

  public static final int LOCAL_INVENTORIES_FIELD_NUMBER = 35;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.retail.v2.LocalInventory> localInventories_;
  /**
   *
   *
   * <pre>
   * Output only. A list of local inventories specific to different places.
   *
   * This field can be managed by
   * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
   * and
   * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
   * APIs if fine-grained, high-volume updates are necessary.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2.LocalInventory> getLocalInventoriesList() {
    return localInventories_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of local inventories specific to different places.
   *
   * This field can be managed by
   * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
   * and
   * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
   * APIs if fine-grained, high-volume updates are necessary.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.retail.v2.LocalInventoryOrBuilder>
      getLocalInventoriesOrBuilderList() {
    return localInventories_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of local inventories specific to different places.
   *
   * This field can be managed by
   * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
   * and
   * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
   * APIs if fine-grained, high-volume updates are necessary.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getLocalInventoriesCount() {
    return localInventories_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of local inventories specific to different places.
   *
   * This field can be managed by
   * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
   * and
   * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
   * APIs if fine-grained, high-volume updates are necessary.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.LocalInventory getLocalInventories(int index) {
    return localInventories_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of local inventories specific to different places.
   *
   * This field can be managed by
   * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
   * and
   * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
   * APIs if fine-grained, high-volume updates are necessary.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.LocalInventoryOrBuilder getLocalInventoriesOrBuilder(
      int index) {
    return localInventories_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, id_);
    }
    if (type_ != com.google.cloud.retail.v2.Product.Type.TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(primaryProductId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, primaryProductId_);
    }
    for (int i = 0; i < collectionMemberIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, collectionMemberIds_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gtin_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, gtin_);
    }
    for (int i = 0; i < categories_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, categories_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, title_);
    }
    for (int i = 0; i < brands_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, brands_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, languageCode_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAttributes(), AttributesDefaultEntryHolder.defaultEntry, 12);
    for (int i = 0; i < tags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, tags_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(14, getPriceInfo());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(15, getRating());
    }
    if (expirationCase_ == 16) {
      output.writeMessage(16, (com.google.protobuf.Timestamp) expiration_);
    }
    if (expirationCase_ == 17) {
      output.writeMessage(17, (com.google.protobuf.Duration) expiration_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(18, getAvailableTime());
    }
    if (availability_
        != com.google.cloud.retail.v2.Product.Availability.AVAILABILITY_UNSPECIFIED.getNumber()) {
      output.writeEnum(19, availability_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(20, getAvailableQuantity());
    }
    for (int i = 0; i < fulfillmentInfo_.size(); i++) {
      output.writeMessage(21, fulfillmentInfo_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 22, uri_);
    }
    for (int i = 0; i < images_.size(); i++) {
      output.writeMessage(23, images_.get(i));
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(24, getAudience());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(25, getColorInfo());
    }
    for (int i = 0; i < sizes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 26, sizes_.getRaw(i));
    }
    for (int i = 0; i < materials_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 27, materials_.getRaw(i));
    }
    for (int i = 0; i < patterns_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 28, patterns_.getRaw(i));
    }
    for (int i = 0; i < conditions_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 29, conditions_.getRaw(i));
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(30, getRetrievableFields());
    }
    for (int i = 0; i < variants_.size(); i++) {
      output.writeMessage(31, variants_.get(i));
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(33, getPublishTime());
    }
    for (int i = 0; i < promotions_.size(); i++) {
      output.writeMessage(34, promotions_.get(i));
    }
    for (int i = 0; i < localInventories_.size(); i++) {
      output.writeMessage(35, localInventories_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, id_);
    }
    if (type_ != com.google.cloud.retail.v2.Product.Type.TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(primaryProductId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, primaryProductId_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < collectionMemberIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(collectionMemberIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getCollectionMemberIdsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gtin_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, gtin_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < categories_.size(); i++) {
        dataSize += computeStringSizeNoTag(categories_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getCategoriesList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, title_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < brands_.size(); i++) {
        dataSize += computeStringSizeNoTag(brands_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getBrandsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, languageCode_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.retail.v2.CustomAttribute> entry :
        internalGetAttributes().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.cloud.retail.v2.CustomAttribute>
          attributes__ =
              AttributesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, attributes__);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < tags_.size(); i++) {
        dataSize += computeStringSizeNoTag(tags_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTagsList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getPriceInfo());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getRating());
    }
    if (expirationCase_ == 16) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              16, (com.google.protobuf.Timestamp) expiration_);
    }
    if (expirationCase_ == 17) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              17, (com.google.protobuf.Duration) expiration_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getAvailableTime());
    }
    if (availability_
        != com.google.cloud.retail.v2.Product.Availability.AVAILABILITY_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(19, availability_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(20, getAvailableQuantity());
    }
    for (int i = 0; i < fulfillmentInfo_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(21, fulfillmentInfo_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(22, uri_);
    }
    for (int i = 0; i < images_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, images_.get(i));
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(24, getAudience());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(25, getColorInfo());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < sizes_.size(); i++) {
        dataSize += computeStringSizeNoTag(sizes_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getSizesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < materials_.size(); i++) {
        dataSize += computeStringSizeNoTag(materials_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getMaterialsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < patterns_.size(); i++) {
        dataSize += computeStringSizeNoTag(patterns_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getPatternsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < conditions_.size(); i++) {
        dataSize += computeStringSizeNoTag(conditions_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getConditionsList().size();
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(30, getRetrievableFields());
    }
    for (int i = 0; i < variants_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(31, variants_.get(i));
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(33, getPublishTime());
    }
    for (int i = 0; i < promotions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(34, promotions_.get(i));
    }
    for (int i = 0; i < localInventories_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(35, localInventories_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2.Product)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2.Product other = (com.google.cloud.retail.v2.Product) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getId().equals(other.getId())) return false;
    if (type_ != other.type_) return false;
    if (!getPrimaryProductId().equals(other.getPrimaryProductId())) return false;
    if (!getCollectionMemberIdsList().equals(other.getCollectionMemberIdsList())) return false;
    if (!getGtin().equals(other.getGtin())) return false;
    if (!getCategoriesList().equals(other.getCategoriesList())) return false;
    if (!getTitle().equals(other.getTitle())) return false;
    if (!getBrandsList().equals(other.getBrandsList())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (!internalGetAttributes().equals(other.internalGetAttributes())) return false;
    if (!getTagsList().equals(other.getTagsList())) return false;
    if (hasPriceInfo() != other.hasPriceInfo()) return false;
    if (hasPriceInfo()) {
      if (!getPriceInfo().equals(other.getPriceInfo())) return false;
    }
    if (hasRating() != other.hasRating()) return false;
    if (hasRating()) {
      if (!getRating().equals(other.getRating())) return false;
    }
    if (hasAvailableTime() != other.hasAvailableTime()) return false;
    if (hasAvailableTime()) {
      if (!getAvailableTime().equals(other.getAvailableTime())) return false;
    }
    if (availability_ != other.availability_) return false;
    if (hasAvailableQuantity() != other.hasAvailableQuantity()) return false;
    if (hasAvailableQuantity()) {
      if (!getAvailableQuantity().equals(other.getAvailableQuantity())) return false;
    }
    if (!getFulfillmentInfoList().equals(other.getFulfillmentInfoList())) return false;
    if (!getUri().equals(other.getUri())) return false;
    if (!getImagesList().equals(other.getImagesList())) return false;
    if (hasAudience() != other.hasAudience()) return false;
    if (hasAudience()) {
      if (!getAudience().equals(other.getAudience())) return false;
    }
    if (hasColorInfo() != other.hasColorInfo()) return false;
    if (hasColorInfo()) {
      if (!getColorInfo().equals(other.getColorInfo())) return false;
    }
    if (!getSizesList().equals(other.getSizesList())) return false;
    if (!getMaterialsList().equals(other.getMaterialsList())) return false;
    if (!getPatternsList().equals(other.getPatternsList())) return false;
    if (!getConditionsList().equals(other.getConditionsList())) return false;
    if (!getPromotionsList().equals(other.getPromotionsList())) return false;
    if (hasPublishTime() != other.hasPublishTime()) return false;
    if (hasPublishTime()) {
      if (!getPublishTime().equals(other.getPublishTime())) return false;
    }
    if (hasRetrievableFields() != other.hasRetrievableFields()) return false;
    if (hasRetrievableFields()) {
      if (!getRetrievableFields().equals(other.getRetrievableFields())) return false;
    }
    if (!getVariantsList().equals(other.getVariantsList())) return false;
    if (!getLocalInventoriesList().equals(other.getLocalInventoriesList())) return false;
    if (!getExpirationCase().equals(other.getExpirationCase())) return false;
    switch (expirationCase_) {
      case 16:
        if (!getExpireTime().equals(other.getExpireTime())) return false;
        break;
      case 17:
        if (!getTtl().equals(other.getTtl())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + PRIMARY_PRODUCT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getPrimaryProductId().hashCode();
    if (getCollectionMemberIdsCount() > 0) {
      hash = (37 * hash) + COLLECTION_MEMBER_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getCollectionMemberIdsList().hashCode();
    }
    hash = (37 * hash) + GTIN_FIELD_NUMBER;
    hash = (53 * hash) + getGtin().hashCode();
    if (getCategoriesCount() > 0) {
      hash = (37 * hash) + CATEGORIES_FIELD_NUMBER;
      hash = (53 * hash) + getCategoriesList().hashCode();
    }
    hash = (37 * hash) + TITLE_FIELD_NUMBER;
    hash = (53 * hash) + getTitle().hashCode();
    if (getBrandsCount() > 0) {
      hash = (37 * hash) + BRANDS_FIELD_NUMBER;
      hash = (53 * hash) + getBrandsList().hashCode();
    }
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    if (!internalGetAttributes().getMap().isEmpty()) {
      hash = (37 * hash) + ATTRIBUTES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAttributes().hashCode();
    }
    if (getTagsCount() > 0) {
      hash = (37 * hash) + TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getTagsList().hashCode();
    }
    if (hasPriceInfo()) {
      hash = (37 * hash) + PRICE_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getPriceInfo().hashCode();
    }
    if (hasRating()) {
      hash = (37 * hash) + RATING_FIELD_NUMBER;
      hash = (53 * hash) + getRating().hashCode();
    }
    if (hasAvailableTime()) {
      hash = (37 * hash) + AVAILABLE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getAvailableTime().hashCode();
    }
    hash = (37 * hash) + AVAILABILITY_FIELD_NUMBER;
    hash = (53 * hash) + availability_;
    if (hasAvailableQuantity()) {
      hash = (37 * hash) + AVAILABLE_QUANTITY_FIELD_NUMBER;
      hash = (53 * hash) + getAvailableQuantity().hashCode();
    }
    if (getFulfillmentInfoCount() > 0) {
      hash = (37 * hash) + FULFILLMENT_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getFulfillmentInfoList().hashCode();
    }
    hash = (37 * hash) + URI_FIELD_NUMBER;
    hash = (53 * hash) + getUri().hashCode();
    if (getImagesCount() > 0) {
      hash = (37 * hash) + IMAGES_FIELD_NUMBER;
      hash = (53 * hash) + getImagesList().hashCode();
    }
    if (hasAudience()) {
      hash = (37 * hash) + AUDIENCE_FIELD_NUMBER;
      hash = (53 * hash) + getAudience().hashCode();
    }
    if (hasColorInfo()) {
      hash = (37 * hash) + COLOR_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getColorInfo().hashCode();
    }
    if (getSizesCount() > 0) {
      hash = (37 * hash) + SIZES_FIELD_NUMBER;
      hash = (53 * hash) + getSizesList().hashCode();
    }
    if (getMaterialsCount() > 0) {
      hash = (37 * hash) + MATERIALS_FIELD_NUMBER;
      hash = (53 * hash) + getMaterialsList().hashCode();
    }
    if (getPatternsCount() > 0) {
      hash = (37 * hash) + PATTERNS_FIELD_NUMBER;
      hash = (53 * hash) + getPatternsList().hashCode();
    }
    if (getConditionsCount() > 0) {
      hash = (37 * hash) + CONDITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getConditionsList().hashCode();
    }
    if (getPromotionsCount() > 0) {
      hash = (37 * hash) + PROMOTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getPromotionsList().hashCode();
    }
    if (hasPublishTime()) {
      hash = (37 * hash) + PUBLISH_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getPublishTime().hashCode();
    }
    if (hasRetrievableFields()) {
      hash = (37 * hash) + RETRIEVABLE_FIELDS_FIELD_NUMBER;
      hash = (53 * hash) + getRetrievableFields().hashCode();
    }
    if (getVariantsCount() > 0) {
      hash = (37 * hash) + VARIANTS_FIELD_NUMBER;
      hash = (53 * hash) + getVariantsList().hashCode();
    }
    if (getLocalInventoriesCount() > 0) {
      hash = (37 * hash) + LOCAL_INVENTORIES_FIELD_NUMBER;
      hash = (53 * hash) + getLocalInventoriesList().hashCode();
    }
    switch (expirationCase_) {
      case 16:
        hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getExpireTime().hashCode();
        break;
      case 17:
        hash = (37 * hash) + TTL_FIELD_NUMBER;
        hash = (53 * hash) + getTtl().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2.Product parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.Product parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.Product parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.Product parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.Product parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.Product parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.Product parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.Product parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.Product parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.Product parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.Product parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.Product parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2.Product prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Product captures all metadata information of items to be recommended or
   * searched.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2.Product}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.Product)
      com.google.cloud.retail.v2.ProductOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2.ProductProto
          .internal_static_google_cloud_retail_v2_Product_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 12:
          return internalGetAttributes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 12:
          return internalGetMutableAttributes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2.ProductProto
          .internal_static_google_cloud_retail_v2_Product_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2.Product.class,
              com.google.cloud.retail.v2.Product.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2.Product.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPriceInfoFieldBuilder();
        getRatingFieldBuilder();
        getAvailableTimeFieldBuilder();
        getAvailableQuantityFieldBuilder();
        getFulfillmentInfoFieldBuilder();
        getImagesFieldBuilder();
        getAudienceFieldBuilder();
        getColorInfoFieldBuilder();
        getPromotionsFieldBuilder();
        getPublishTimeFieldBuilder();
        getRetrievableFieldsFieldBuilder();
        getVariantsFieldBuilder();
        getLocalInventoriesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bitField1_ = 0;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.clear();
      }
      if (ttlBuilder_ != null) {
        ttlBuilder_.clear();
      }
      name_ = "";
      id_ = "";
      type_ = 0;
      primaryProductId_ = "";
      collectionMemberIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      gtin_ = "";
      categories_ = com.google.protobuf.LazyStringArrayList.emptyList();
      title_ = "";
      brands_ = com.google.protobuf.LazyStringArrayList.emptyList();
      description_ = "";
      languageCode_ = "";
      internalGetMutableAttributes().clear();
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      priceInfo_ = null;
      if (priceInfoBuilder_ != null) {
        priceInfoBuilder_.dispose();
        priceInfoBuilder_ = null;
      }
      rating_ = null;
      if (ratingBuilder_ != null) {
        ratingBuilder_.dispose();
        ratingBuilder_ = null;
      }
      availableTime_ = null;
      if (availableTimeBuilder_ != null) {
        availableTimeBuilder_.dispose();
        availableTimeBuilder_ = null;
      }
      availability_ = 0;
      availableQuantity_ = null;
      if (availableQuantityBuilder_ != null) {
        availableQuantityBuilder_.dispose();
        availableQuantityBuilder_ = null;
      }
      if (fulfillmentInfoBuilder_ == null) {
        fulfillmentInfo_ = java.util.Collections.emptyList();
      } else {
        fulfillmentInfo_ = null;
        fulfillmentInfoBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00100000);
      uri_ = "";
      if (imagesBuilder_ == null) {
        images_ = java.util.Collections.emptyList();
      } else {
        images_ = null;
        imagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00400000);
      audience_ = null;
      if (audienceBuilder_ != null) {
        audienceBuilder_.dispose();
        audienceBuilder_ = null;
      }
      colorInfo_ = null;
      if (colorInfoBuilder_ != null) {
        colorInfoBuilder_.dispose();
        colorInfoBuilder_ = null;
      }
      sizes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      materials_ = com.google.protobuf.LazyStringArrayList.emptyList();
      patterns_ = com.google.protobuf.LazyStringArrayList.emptyList();
      conditions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (promotionsBuilder_ == null) {
        promotions_ = java.util.Collections.emptyList();
      } else {
        promotions_ = null;
        promotionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x20000000);
      publishTime_ = null;
      if (publishTimeBuilder_ != null) {
        publishTimeBuilder_.dispose();
        publishTimeBuilder_ = null;
      }
      retrievableFields_ = null;
      if (retrievableFieldsBuilder_ != null) {
        retrievableFieldsBuilder_.dispose();
        retrievableFieldsBuilder_ = null;
      }
      if (variantsBuilder_ == null) {
        variants_ = java.util.Collections.emptyList();
      } else {
        variants_ = null;
        variantsBuilder_.clear();
      }
      bitField1_ = (bitField1_ & ~0x00000001);
      if (localInventoriesBuilder_ == null) {
        localInventories_ = java.util.Collections.emptyList();
      } else {
        localInventories_ = null;
        localInventoriesBuilder_.clear();
      }
      bitField1_ = (bitField1_ & ~0x00000002);
      expirationCase_ = 0;
      expiration_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2.ProductProto
          .internal_static_google_cloud_retail_v2_Product_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.Product getDefaultInstanceForType() {
      return com.google.cloud.retail.v2.Product.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.Product build() {
      com.google.cloud.retail.v2.Product result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.Product buildPartial() {
      com.google.cloud.retail.v2.Product result = new com.google.cloud.retail.v2.Product(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      if (bitField1_ != 0) {
        buildPartial1(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.retail.v2.Product result) {
      if (fulfillmentInfoBuilder_ == null) {
        if (((bitField0_ & 0x00100000) != 0)) {
          fulfillmentInfo_ = java.util.Collections.unmodifiableList(fulfillmentInfo_);
          bitField0_ = (bitField0_ & ~0x00100000);
        }
        result.fulfillmentInfo_ = fulfillmentInfo_;
      } else {
        result.fulfillmentInfo_ = fulfillmentInfoBuilder_.build();
      }
      if (imagesBuilder_ == null) {
        if (((bitField0_ & 0x00400000) != 0)) {
          images_ = java.util.Collections.unmodifiableList(images_);
          bitField0_ = (bitField0_ & ~0x00400000);
        }
        result.images_ = images_;
      } else {
        result.images_ = imagesBuilder_.build();
      }
      if (promotionsBuilder_ == null) {
        if (((bitField0_ & 0x20000000) != 0)) {
          promotions_ = java.util.Collections.unmodifiableList(promotions_);
          bitField0_ = (bitField0_ & ~0x20000000);
        }
        result.promotions_ = promotions_;
      } else {
        result.promotions_ = promotionsBuilder_.build();
      }
      if (variantsBuilder_ == null) {
        if (((bitField1_ & 0x00000001) != 0)) {
          variants_ = java.util.Collections.unmodifiableList(variants_);
          bitField1_ = (bitField1_ & ~0x00000001);
        }
        result.variants_ = variants_;
      } else {
        result.variants_ = variantsBuilder_.build();
      }
      if (localInventoriesBuilder_ == null) {
        if (((bitField1_ & 0x00000002) != 0)) {
          localInventories_ = java.util.Collections.unmodifiableList(localInventories_);
          bitField1_ = (bitField1_ & ~0x00000002);
        }
        result.localInventories_ = localInventories_;
      } else {
        result.localInventories_ = localInventoriesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.retail.v2.Product result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.primaryProductId_ = primaryProductId_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        collectionMemberIds_.makeImmutable();
        result.collectionMemberIds_ = collectionMemberIds_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.gtin_ = gtin_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        categories_.makeImmutable();
        result.categories_ = categories_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.title_ = title_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        brands_.makeImmutable();
        result.brands_ = brands_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.languageCode_ = languageCode_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.attributes_ =
            internalGetAttributes().build(AttributesDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        tags_.makeImmutable();
        result.tags_ = tags_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.priceInfo_ = priceInfoBuilder_ == null ? priceInfo_ : priceInfoBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.rating_ = ratingBuilder_ == null ? rating_ : ratingBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.availableTime_ =
            availableTimeBuilder_ == null ? availableTime_ : availableTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.availability_ = availability_;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.availableQuantity_ =
            availableQuantityBuilder_ == null
                ? availableQuantity_
                : availableQuantityBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.uri_ = uri_;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.audience_ = audienceBuilder_ == null ? audience_ : audienceBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.colorInfo_ = colorInfoBuilder_ == null ? colorInfo_ : colorInfoBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        sizes_.makeImmutable();
        result.sizes_ = sizes_;
      }
      if (((from_bitField0_ & 0x04000000) != 0)) {
        materials_.makeImmutable();
        result.materials_ = materials_;
      }
      if (((from_bitField0_ & 0x08000000) != 0)) {
        patterns_.makeImmutable();
        result.patterns_ = patterns_;
      }
      if (((from_bitField0_ & 0x10000000) != 0)) {
        conditions_.makeImmutable();
        result.conditions_ = conditions_;
      }
      if (((from_bitField0_ & 0x40000000) != 0)) {
        result.publishTime_ =
            publishTimeBuilder_ == null ? publishTime_ : publishTimeBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x80000000) != 0)) {
        result.retrievableFields_ =
            retrievableFieldsBuilder_ == null
                ? retrievableFields_
                : retrievableFieldsBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartial1(com.google.cloud.retail.v2.Product result) {
      int from_bitField1_ = bitField1_;
    }

    private void buildPartialOneofs(com.google.cloud.retail.v2.Product result) {
      result.expirationCase_ = expirationCase_;
      result.expiration_ = this.expiration_;
      if (expirationCase_ == 16 && expireTimeBuilder_ != null) {
        result.expiration_ = expireTimeBuilder_.build();
      }
      if (expirationCase_ == 17 && ttlBuilder_ != null) {
        result.expiration_ = ttlBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2.Product) {
        return mergeFrom((com.google.cloud.retail.v2.Product) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2.Product other) {
      if (other == com.google.cloud.retail.v2.Product.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (!other.getPrimaryProductId().isEmpty()) {
        primaryProductId_ = other.primaryProductId_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.collectionMemberIds_.isEmpty()) {
        if (collectionMemberIds_.isEmpty()) {
          collectionMemberIds_ = other.collectionMemberIds_;
          bitField0_ |= 0x00000040;
        } else {
          ensureCollectionMemberIdsIsMutable();
          collectionMemberIds_.addAll(other.collectionMemberIds_);
        }
        onChanged();
      }
      if (!other.getGtin().isEmpty()) {
        gtin_ = other.gtin_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.categories_.isEmpty()) {
        if (categories_.isEmpty()) {
          categories_ = other.categories_;
          bitField0_ |= 0x00000100;
        } else {
          ensureCategoriesIsMutable();
          categories_.addAll(other.categories_);
        }
        onChanged();
      }
      if (!other.getTitle().isEmpty()) {
        title_ = other.title_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (!other.brands_.isEmpty()) {
        if (brands_.isEmpty()) {
          brands_ = other.brands_;
          bitField0_ |= 0x00000400;
        } else {
          ensureBrandsIsMutable();
          brands_.addAll(other.brands_);
        }
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      internalGetMutableAttributes().mergeFrom(other.internalGetAttributes());
      bitField0_ |= 0x00002000;
      if (!other.tags_.isEmpty()) {
        if (tags_.isEmpty()) {
          tags_ = other.tags_;
          bitField0_ |= 0x00004000;
        } else {
          ensureTagsIsMutable();
          tags_.addAll(other.tags_);
        }
        onChanged();
      }
      if (other.hasPriceInfo()) {
        mergePriceInfo(other.getPriceInfo());
      }
      if (other.hasRating()) {
        mergeRating(other.getRating());
      }
      if (other.hasAvailableTime()) {
        mergeAvailableTime(other.getAvailableTime());
      }
      if (other.availability_ != 0) {
        setAvailabilityValue(other.getAvailabilityValue());
      }
      if (other.hasAvailableQuantity()) {
        mergeAvailableQuantity(other.getAvailableQuantity());
      }
      if (fulfillmentInfoBuilder_ == null) {
        if (!other.fulfillmentInfo_.isEmpty()) {
          if (fulfillmentInfo_.isEmpty()) {
            fulfillmentInfo_ = other.fulfillmentInfo_;
            bitField0_ = (bitField0_ & ~0x00100000);
          } else {
            ensureFulfillmentInfoIsMutable();
            fulfillmentInfo_.addAll(other.fulfillmentInfo_);
          }
          onChanged();
        }
      } else {
        if (!other.fulfillmentInfo_.isEmpty()) {
          if (fulfillmentInfoBuilder_.isEmpty()) {
            fulfillmentInfoBuilder_.dispose();
            fulfillmentInfoBuilder_ = null;
            fulfillmentInfo_ = other.fulfillmentInfo_;
            bitField0_ = (bitField0_ & ~0x00100000);
            fulfillmentInfoBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFulfillmentInfoFieldBuilder()
                    : null;
          } else {
            fulfillmentInfoBuilder_.addAllMessages(other.fulfillmentInfo_);
          }
        }
      }
      if (!other.getUri().isEmpty()) {
        uri_ = other.uri_;
        bitField0_ |= 0x00200000;
        onChanged();
      }
      if (imagesBuilder_ == null) {
        if (!other.images_.isEmpty()) {
          if (images_.isEmpty()) {
            images_ = other.images_;
            bitField0_ = (bitField0_ & ~0x00400000);
          } else {
            ensureImagesIsMutable();
            images_.addAll(other.images_);
          }
          onChanged();
        }
      } else {
        if (!other.images_.isEmpty()) {
          if (imagesBuilder_.isEmpty()) {
            imagesBuilder_.dispose();
            imagesBuilder_ = null;
            images_ = other.images_;
            bitField0_ = (bitField0_ & ~0x00400000);
            imagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getImagesFieldBuilder()
                    : null;
          } else {
            imagesBuilder_.addAllMessages(other.images_);
          }
        }
      }
      if (other.hasAudience()) {
        mergeAudience(other.getAudience());
      }
      if (other.hasColorInfo()) {
        mergeColorInfo(other.getColorInfo());
      }
      if (!other.sizes_.isEmpty()) {
        if (sizes_.isEmpty()) {
          sizes_ = other.sizes_;
          bitField0_ |= 0x02000000;
        } else {
          ensureSizesIsMutable();
          sizes_.addAll(other.sizes_);
        }
        onChanged();
      }
      if (!other.materials_.isEmpty()) {
        if (materials_.isEmpty()) {
          materials_ = other.materials_;
          bitField0_ |= 0x04000000;
        } else {
          ensureMaterialsIsMutable();
          materials_.addAll(other.materials_);
        }
        onChanged();
      }
      if (!other.patterns_.isEmpty()) {
        if (patterns_.isEmpty()) {
          patterns_ = other.patterns_;
          bitField0_ |= 0x08000000;
        } else {
          ensurePatternsIsMutable();
          patterns_.addAll(other.patterns_);
        }
        onChanged();
      }
      if (!other.conditions_.isEmpty()) {
        if (conditions_.isEmpty()) {
          conditions_ = other.conditions_;
          bitField0_ |= 0x10000000;
        } else {
          ensureConditionsIsMutable();
          conditions_.addAll(other.conditions_);
        }
        onChanged();
      }
      if (promotionsBuilder_ == null) {
        if (!other.promotions_.isEmpty()) {
          if (promotions_.isEmpty()) {
            promotions_ = other.promotions_;
            bitField0_ = (bitField0_ & ~0x20000000);
          } else {
            ensurePromotionsIsMutable();
            promotions_.addAll(other.promotions_);
          }
          onChanged();
        }
      } else {
        if (!other.promotions_.isEmpty()) {
          if (promotionsBuilder_.isEmpty()) {
            promotionsBuilder_.dispose();
            promotionsBuilder_ = null;
            promotions_ = other.promotions_;
            bitField0_ = (bitField0_ & ~0x20000000);
            promotionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPromotionsFieldBuilder()
                    : null;
          } else {
            promotionsBuilder_.addAllMessages(other.promotions_);
          }
        }
      }
      if (other.hasPublishTime()) {
        mergePublishTime(other.getPublishTime());
      }
      if (other.hasRetrievableFields()) {
        mergeRetrievableFields(other.getRetrievableFields());
      }
      if (variantsBuilder_ == null) {
        if (!other.variants_.isEmpty()) {
          if (variants_.isEmpty()) {
            variants_ = other.variants_;
            bitField1_ = (bitField1_ & ~0x00000001);
          } else {
            ensureVariantsIsMutable();
            variants_.addAll(other.variants_);
          }
          onChanged();
        }
      } else {
        if (!other.variants_.isEmpty()) {
          if (variantsBuilder_.isEmpty()) {
            variantsBuilder_.dispose();
            variantsBuilder_ = null;
            variants_ = other.variants_;
            bitField1_ = (bitField1_ & ~0x00000001);
            variantsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getVariantsFieldBuilder()
                    : null;
          } else {
            variantsBuilder_.addAllMessages(other.variants_);
          }
        }
      }
      if (localInventoriesBuilder_ == null) {
        if (!other.localInventories_.isEmpty()) {
          if (localInventories_.isEmpty()) {
            localInventories_ = other.localInventories_;
            bitField1_ = (bitField1_ & ~0x00000002);
          } else {
            ensureLocalInventoriesIsMutable();
            localInventories_.addAll(other.localInventories_);
          }
          onChanged();
        }
      } else {
        if (!other.localInventories_.isEmpty()) {
          if (localInventoriesBuilder_.isEmpty()) {
            localInventoriesBuilder_.dispose();
            localInventoriesBuilder_ = null;
            localInventories_ = other.localInventories_;
            bitField1_ = (bitField1_ & ~0x00000002);
            localInventoriesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLocalInventoriesFieldBuilder()
                    : null;
          } else {
            localInventoriesBuilder_.addAllMessages(other.localInventories_);
          }
        }
      }
      switch (other.getExpirationCase()) {
        case EXPIRE_TIME:
          {
            mergeExpireTime(other.getExpireTime());
            break;
          }
        case TTL:
          {
            mergeTtl(other.getTtl());
            break;
          }
        case EXPIRATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 18
            case 24:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 24
            case 34:
              {
                primaryProductId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureCollectionMemberIdsIsMutable();
                collectionMemberIds_.add(s);
                break;
              } // case 42
            case 50:
              {
                gtin_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 50
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureCategoriesIsMutable();
                categories_.add(s);
                break;
              } // case 58
            case 66:
              {
                title_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 66
            case 74:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureBrandsIsMutable();
                brands_.add(s);
                break;
              } // case 74
            case 82:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 82
            case 90:
              {
                languageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 90
            case 98:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.retail.v2.CustomAttribute>
                    attributes__ =
                        input.readMessage(
                            AttributesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableAttributes()
                    .ensureBuilderMap()
                    .put(attributes__.getKey(), attributes__.getValue());
                bitField0_ |= 0x00002000;
                break;
              } // case 98
            case 106:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTagsIsMutable();
                tags_.add(s);
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getPriceInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(getRatingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 122
            case 130:
              {
                input.readMessage(getExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                expirationCase_ = 16;
                break;
              } // case 130
            case 138:
              {
                input.readMessage(getTtlFieldBuilder().getBuilder(), extensionRegistry);
                expirationCase_ = 17;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(getAvailableTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00020000;
                break;
              } // case 146
            case 152:
              {
                availability_ = input.readEnum();
                bitField0_ |= 0x00040000;
                break;
              } // case 152
            case 162:
              {
                input.readMessage(
                    getAvailableQuantityFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00080000;
                break;
              } // case 162
            case 170:
              {
                com.google.cloud.retail.v2.FulfillmentInfo m =
                    input.readMessage(
                        com.google.cloud.retail.v2.FulfillmentInfo.parser(), extensionRegistry);
                if (fulfillmentInfoBuilder_ == null) {
                  ensureFulfillmentInfoIsMutable();
                  fulfillmentInfo_.add(m);
                } else {
                  fulfillmentInfoBuilder_.addMessage(m);
                }
                break;
              } // case 170
            case 178:
              {
                uri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00200000;
                break;
              } // case 178
            case 186:
              {
                com.google.cloud.retail.v2.Image m =
                    input.readMessage(com.google.cloud.retail.v2.Image.parser(), extensionRegistry);
                if (imagesBuilder_ == null) {
                  ensureImagesIsMutable();
                  images_.add(m);
                } else {
                  imagesBuilder_.addMessage(m);
                }
                break;
              } // case 186
            case 194:
              {
                input.readMessage(getAudienceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00800000;
                break;
              } // case 194
            case 202:
              {
                input.readMessage(getColorInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x01000000;
                break;
              } // case 202
            case 210:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSizesIsMutable();
                sizes_.add(s);
                break;
              } // case 210
            case 218:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureMaterialsIsMutable();
                materials_.add(s);
                break;
              } // case 218
            case 226:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensurePatternsIsMutable();
                patterns_.add(s);
                break;
              } // case 226
            case 234:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureConditionsIsMutable();
                conditions_.add(s);
                break;
              } // case 234
            case 242:
              {
                input.readMessage(
                    getRetrievableFieldsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x80000000;
                break;
              } // case 242
            case 250:
              {
                com.google.cloud.retail.v2.Product m =
                    input.readMessage(
                        com.google.cloud.retail.v2.Product.parser(), extensionRegistry);
                if (variantsBuilder_ == null) {
                  ensureVariantsIsMutable();
                  variants_.add(m);
                } else {
                  variantsBuilder_.addMessage(m);
                }
                break;
              } // case 250
            case 266:
              {
                input.readMessage(getPublishTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x40000000;
                break;
              } // case 266
            case 274:
              {
                com.google.cloud.retail.v2.Promotion m =
                    input.readMessage(
                        com.google.cloud.retail.v2.Promotion.parser(), extensionRegistry);
                if (promotionsBuilder_ == null) {
                  ensurePromotionsIsMutable();
                  promotions_.add(m);
                } else {
                  promotionsBuilder_.addMessage(m);
                }
                break;
              } // case 274
            case 282:
              {
                com.google.cloud.retail.v2.LocalInventory m =
                    input.readMessage(
                        com.google.cloud.retail.v2.LocalInventory.parser(), extensionRegistry);
                if (localInventoriesBuilder_ == null) {
                  ensureLocalInventoriesIsMutable();
                  localInventories_.add(m);
                } else {
                  localInventoriesBuilder_.addMessage(m);
                }
                break;
              } // case 282
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int expirationCase_ = 0;
    private java.lang.Object expiration_;

    public ExpirationCase getExpirationCase() {
      return ExpirationCase.forNumber(expirationCase_);
    }

    public Builder clearExpiration() {
      expirationCase_ = 0;
      expiration_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;
    private int bitField1_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        expireTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The timestamp when this product becomes unavailable for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
     * that this is only applicable to
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
     * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
     * In general, we suggest the users to delete the stale products explicitly,
     * instead of using this field to determine staleness.
     *
     * If it is set, the [Product][google.cloud.retail.v2.Product] is not
     * available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
     * [expire_time][google.cloud.retail.v2.Product.expire_time]. However, the
     * product can still be retrieved by
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
     * and
     * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
     *
     * [expire_time][google.cloud.retail.v2.Product.expire_time] must be later
     * than [available_time][google.cloud.retail.v2.Product.available_time] and
     * [publish_time][google.cloud.retail.v2.Product.publish_time], otherwise an
     * INVALID_ARGUMENT error is thrown.
     *
     * Corresponding properties: Google Merchant Center property
     * [expiration_date](https://support.google.com/merchants/answer/6324499).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 16;</code>
     *
     * @return Whether the expireTime field is set.
     */
    @java.lang.Override
    public boolean hasExpireTime() {
      return expirationCase_ == 16;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when this product becomes unavailable for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
     * that this is only applicable to
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
     * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
     * In general, we suggest the users to delete the stale products explicitly,
     * instead of using this field to determine staleness.
     *
     * If it is set, the [Product][google.cloud.retail.v2.Product] is not
     * available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
     * [expire_time][google.cloud.retail.v2.Product.expire_time]. However, the
     * product can still be retrieved by
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
     * and
     * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
     *
     * [expire_time][google.cloud.retail.v2.Product.expire_time] must be later
     * than [available_time][google.cloud.retail.v2.Product.available_time] and
     * [publish_time][google.cloud.retail.v2.Product.publish_time], otherwise an
     * INVALID_ARGUMENT error is thrown.
     *
     * Corresponding properties: Google Merchant Center property
     * [expiration_date](https://support.google.com/merchants/answer/6324499).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 16;</code>
     *
     * @return The expireTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getExpireTime() {
      if (expireTimeBuilder_ == null) {
        if (expirationCase_ == 16) {
          return (com.google.protobuf.Timestamp) expiration_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      } else {
        if (expirationCase_ == 16) {
          return expireTimeBuilder_.getMessage();
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp when this product becomes unavailable for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
     * that this is only applicable to
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
     * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
     * In general, we suggest the users to delete the stale products explicitly,
     * instead of using this field to determine staleness.
     *
     * If it is set, the [Product][google.cloud.retail.v2.Product] is not
     * available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
     * [expire_time][google.cloud.retail.v2.Product.expire_time]. However, the
     * product can still be retrieved by
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
     * and
     * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
     *
     * [expire_time][google.cloud.retail.v2.Product.expire_time] must be later
     * than [available_time][google.cloud.retail.v2.Product.available_time] and
     * [publish_time][google.cloud.retail.v2.Product.publish_time], otherwise an
     * INVALID_ARGUMENT error is thrown.
     *
     * Corresponding properties: Google Merchant Center property
     * [expiration_date](https://support.google.com/merchants/answer/6324499).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 16;</code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expiration_ = value;
        onChanged();
      } else {
        expireTimeBuilder_.setMessage(value);
      }
      expirationCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when this product becomes unavailable for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
     * that this is only applicable to
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
     * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
     * In general, we suggest the users to delete the stale products explicitly,
     * instead of using this field to determine staleness.
     *
     * If it is set, the [Product][google.cloud.retail.v2.Product] is not
     * available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
     * [expire_time][google.cloud.retail.v2.Product.expire_time]. However, the
     * product can still be retrieved by
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
     * and
     * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
     *
     * [expire_time][google.cloud.retail.v2.Product.expire_time] must be later
     * than [available_time][google.cloud.retail.v2.Product.available_time] and
     * [publish_time][google.cloud.retail.v2.Product.publish_time], otherwise an
     * INVALID_ARGUMENT error is thrown.
     *
     * Corresponding properties: Google Merchant Center property
     * [expiration_date](https://support.google.com/merchants/answer/6324499).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 16;</code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (expireTimeBuilder_ == null) {
        expiration_ = builderForValue.build();
        onChanged();
      } else {
        expireTimeBuilder_.setMessage(builderForValue.build());
      }
      expirationCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when this product becomes unavailable for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
     * that this is only applicable to
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
     * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
     * In general, we suggest the users to delete the stale products explicitly,
     * instead of using this field to determine staleness.
     *
     * If it is set, the [Product][google.cloud.retail.v2.Product] is not
     * available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
     * [expire_time][google.cloud.retail.v2.Product.expire_time]. However, the
     * product can still be retrieved by
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
     * and
     * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
     *
     * [expire_time][google.cloud.retail.v2.Product.expire_time] must be later
     * than [available_time][google.cloud.retail.v2.Product.available_time] and
     * [publish_time][google.cloud.retail.v2.Product.publish_time], otherwise an
     * INVALID_ARGUMENT error is thrown.
     *
     * Corresponding properties: Google Merchant Center property
     * [expiration_date](https://support.google.com/merchants/answer/6324499).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 16;</code>
     */
    public Builder mergeExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (expirationCase_ == 16
            && expiration_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          expiration_ =
              com.google.protobuf.Timestamp.newBuilder((com.google.protobuf.Timestamp) expiration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          expiration_ = value;
        }
        onChanged();
      } else {
        if (expirationCase_ == 16) {
          expireTimeBuilder_.mergeFrom(value);
        } else {
          expireTimeBuilder_.setMessage(value);
        }
      }
      expirationCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when this product becomes unavailable for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
     * that this is only applicable to
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
     * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
     * In general, we suggest the users to delete the stale products explicitly,
     * instead of using this field to determine staleness.
     *
     * If it is set, the [Product][google.cloud.retail.v2.Product] is not
     * available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
     * [expire_time][google.cloud.retail.v2.Product.expire_time]. However, the
     * product can still be retrieved by
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
     * and
     * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
     *
     * [expire_time][google.cloud.retail.v2.Product.expire_time] must be later
     * than [available_time][google.cloud.retail.v2.Product.available_time] and
     * [publish_time][google.cloud.retail.v2.Product.publish_time], otherwise an
     * INVALID_ARGUMENT error is thrown.
     *
     * Corresponding properties: Google Merchant Center property
     * [expiration_date](https://support.google.com/merchants/answer/6324499).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 16;</code>
     */
    public Builder clearExpireTime() {
      if (expireTimeBuilder_ == null) {
        if (expirationCase_ == 16) {
          expirationCase_ = 0;
          expiration_ = null;
          onChanged();
        }
      } else {
        if (expirationCase_ == 16) {
          expirationCase_ = 0;
          expiration_ = null;
        }
        expireTimeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when this product becomes unavailable for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
     * that this is only applicable to
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
     * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
     * In general, we suggest the users to delete the stale products explicitly,
     * instead of using this field to determine staleness.
     *
     * If it is set, the [Product][google.cloud.retail.v2.Product] is not
     * available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
     * [expire_time][google.cloud.retail.v2.Product.expire_time]. However, the
     * product can still be retrieved by
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
     * and
     * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
     *
     * [expire_time][google.cloud.retail.v2.Product.expire_time] must be later
     * than [available_time][google.cloud.retail.v2.Product.available_time] and
     * [publish_time][google.cloud.retail.v2.Product.publish_time], otherwise an
     * INVALID_ARGUMENT error is thrown.
     *
     * Corresponding properties: Google Merchant Center property
     * [expiration_date](https://support.google.com/merchants/answer/6324499).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 16;</code>
     */
    public com.google.protobuf.Timestamp.Builder getExpireTimeBuilder() {
      return getExpireTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The timestamp when this product becomes unavailable for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
     * that this is only applicable to
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
     * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
     * In general, we suggest the users to delete the stale products explicitly,
     * instead of using this field to determine staleness.
     *
     * If it is set, the [Product][google.cloud.retail.v2.Product] is not
     * available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
     * [expire_time][google.cloud.retail.v2.Product.expire_time]. However, the
     * product can still be retrieved by
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
     * and
     * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
     *
     * [expire_time][google.cloud.retail.v2.Product.expire_time] must be later
     * than [available_time][google.cloud.retail.v2.Product.available_time] and
     * [publish_time][google.cloud.retail.v2.Product.publish_time], otherwise an
     * INVALID_ARGUMENT error is thrown.
     *
     * Corresponding properties: Google Merchant Center property
     * [expiration_date](https://support.google.com/merchants/answer/6324499).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 16;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
      if ((expirationCase_ == 16) && (expireTimeBuilder_ != null)) {
        return expireTimeBuilder_.getMessageOrBuilder();
      } else {
        if (expirationCase_ == 16) {
          return (com.google.protobuf.Timestamp) expiration_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp when this product becomes unavailable for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
     * that this is only applicable to
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
     * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
     * In general, we suggest the users to delete the stale products explicitly,
     * instead of using this field to determine staleness.
     *
     * If it is set, the [Product][google.cloud.retail.v2.Product] is not
     * available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
     * [expire_time][google.cloud.retail.v2.Product.expire_time]. However, the
     * product can still be retrieved by
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
     * and
     * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
     *
     * [expire_time][google.cloud.retail.v2.Product.expire_time] must be later
     * than [available_time][google.cloud.retail.v2.Product.available_time] and
     * [publish_time][google.cloud.retail.v2.Product.publish_time], otherwise an
     * INVALID_ARGUMENT error is thrown.
     *
     * Corresponding properties: Google Merchant Center property
     * [expiration_date](https://support.google.com/merchants/answer/6324499).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 16;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExpireTimeFieldBuilder() {
      if (expireTimeBuilder_ == null) {
        if (!(expirationCase_ == 16)) {
          expiration_ = com.google.protobuf.Timestamp.getDefaultInstance();
        }
        expireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                (com.google.protobuf.Timestamp) expiration_, getParentForChildren(), isClean());
        expiration_ = null;
      }
      expirationCase_ = 16;
      onChanged();
      return expireTimeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        ttlBuilder_;
    /**
     *
     *
     * <pre>
     * Input only. The TTL (time to live) of the product. Note that this is only
     * applicable to [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * and [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION],
     * and ignored for
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]. In general,
     * we suggest the users to delete the stale products explicitly, instead of
     * using this field to determine staleness.
     *
     * If it is set, it must be a non-negative value, and
     * [expire_time][google.cloud.retail.v2.Product.expire_time] is set as
     * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl]. The
     * derived [expire_time][google.cloud.retail.v2.Product.expire_time] is
     * returned in the output and [ttl][google.cloud.retail.v2.Product.ttl] is
     * left blank when retrieving the [Product][google.cloud.retail.v2.Product].
     *
     * If it is set, the product is not available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
     * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl].
     * However, the product can still be retrieved by
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
     * and
     * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 17 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return Whether the ttl field is set.
     */
    @java.lang.Override
    public boolean hasTtl() {
      return expirationCase_ == 17;
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL (time to live) of the product. Note that this is only
     * applicable to [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * and [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION],
     * and ignored for
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]. In general,
     * we suggest the users to delete the stale products explicitly, instead of
     * using this field to determine staleness.
     *
     * If it is set, it must be a non-negative value, and
     * [expire_time][google.cloud.retail.v2.Product.expire_time] is set as
     * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl]. The
     * derived [expire_time][google.cloud.retail.v2.Product.expire_time] is
     * returned in the output and [ttl][google.cloud.retail.v2.Product.ttl] is
     * left blank when retrieving the [Product][google.cloud.retail.v2.Product].
     *
     * If it is set, the product is not available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
     * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl].
     * However, the product can still be retrieved by
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
     * and
     * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 17 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The ttl.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getTtl() {
      if (ttlBuilder_ == null) {
        if (expirationCase_ == 17) {
          return (com.google.protobuf.Duration) expiration_;
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      } else {
        if (expirationCase_ == 17) {
          return ttlBuilder_.getMessage();
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL (time to live) of the product. Note that this is only
     * applicable to [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * and [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION],
     * and ignored for
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]. In general,
     * we suggest the users to delete the stale products explicitly, instead of
     * using this field to determine staleness.
     *
     * If it is set, it must be a non-negative value, and
     * [expire_time][google.cloud.retail.v2.Product.expire_time] is set as
     * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl]. The
     * derived [expire_time][google.cloud.retail.v2.Product.expire_time] is
     * returned in the output and [ttl][google.cloud.retail.v2.Product.ttl] is
     * left blank when retrieving the [Product][google.cloud.retail.v2.Product].
     *
     * If it is set, the product is not available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
     * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl].
     * However, the product can still be retrieved by
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
     * and
     * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 17 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    public Builder setTtl(com.google.protobuf.Duration value) {
      if (ttlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expiration_ = value;
        onChanged();
      } else {
        ttlBuilder_.setMessage(value);
      }
      expirationCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL (time to live) of the product. Note that this is only
     * applicable to [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * and [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION],
     * and ignored for
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]. In general,
     * we suggest the users to delete the stale products explicitly, instead of
     * using this field to determine staleness.
     *
     * If it is set, it must be a non-negative value, and
     * [expire_time][google.cloud.retail.v2.Product.expire_time] is set as
     * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl]. The
     * derived [expire_time][google.cloud.retail.v2.Product.expire_time] is
     * returned in the output and [ttl][google.cloud.retail.v2.Product.ttl] is
     * left blank when retrieving the [Product][google.cloud.retail.v2.Product].
     *
     * If it is set, the product is not available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
     * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl].
     * However, the product can still be retrieved by
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
     * and
     * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 17 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    public Builder setTtl(com.google.protobuf.Duration.Builder builderForValue) {
      if (ttlBuilder_ == null) {
        expiration_ = builderForValue.build();
        onChanged();
      } else {
        ttlBuilder_.setMessage(builderForValue.build());
      }
      expirationCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL (time to live) of the product. Note that this is only
     * applicable to [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * and [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION],
     * and ignored for
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]. In general,
     * we suggest the users to delete the stale products explicitly, instead of
     * using this field to determine staleness.
     *
     * If it is set, it must be a non-negative value, and
     * [expire_time][google.cloud.retail.v2.Product.expire_time] is set as
     * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl]. The
     * derived [expire_time][google.cloud.retail.v2.Product.expire_time] is
     * returned in the output and [ttl][google.cloud.retail.v2.Product.ttl] is
     * left blank when retrieving the [Product][google.cloud.retail.v2.Product].
     *
     * If it is set, the product is not available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
     * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl].
     * However, the product can still be retrieved by
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
     * and
     * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 17 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    public Builder mergeTtl(com.google.protobuf.Duration value) {
      if (ttlBuilder_ == null) {
        if (expirationCase_ == 17
            && expiration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          expiration_ =
              com.google.protobuf.Duration.newBuilder((com.google.protobuf.Duration) expiration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          expiration_ = value;
        }
        onChanged();
      } else {
        if (expirationCase_ == 17) {
          ttlBuilder_.mergeFrom(value);
        } else {
          ttlBuilder_.setMessage(value);
        }
      }
      expirationCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL (time to live) of the product. Note that this is only
     * applicable to [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * and [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION],
     * and ignored for
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]. In general,
     * we suggest the users to delete the stale products explicitly, instead of
     * using this field to determine staleness.
     *
     * If it is set, it must be a non-negative value, and
     * [expire_time][google.cloud.retail.v2.Product.expire_time] is set as
     * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl]. The
     * derived [expire_time][google.cloud.retail.v2.Product.expire_time] is
     * returned in the output and [ttl][google.cloud.retail.v2.Product.ttl] is
     * left blank when retrieving the [Product][google.cloud.retail.v2.Product].
     *
     * If it is set, the product is not available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
     * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl].
     * However, the product can still be retrieved by
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
     * and
     * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 17 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    public Builder clearTtl() {
      if (ttlBuilder_ == null) {
        if (expirationCase_ == 17) {
          expirationCase_ = 0;
          expiration_ = null;
          onChanged();
        }
      } else {
        if (expirationCase_ == 17) {
          expirationCase_ = 0;
          expiration_ = null;
        }
        ttlBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL (time to live) of the product. Note that this is only
     * applicable to [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * and [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION],
     * and ignored for
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]. In general,
     * we suggest the users to delete the stale products explicitly, instead of
     * using this field to determine staleness.
     *
     * If it is set, it must be a non-negative value, and
     * [expire_time][google.cloud.retail.v2.Product.expire_time] is set as
     * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl]. The
     * derived [expire_time][google.cloud.retail.v2.Product.expire_time] is
     * returned in the output and [ttl][google.cloud.retail.v2.Product.ttl] is
     * left blank when retrieving the [Product][google.cloud.retail.v2.Product].
     *
     * If it is set, the product is not available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
     * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl].
     * However, the product can still be retrieved by
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
     * and
     * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 17 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    public com.google.protobuf.Duration.Builder getTtlBuilder() {
      return getTtlFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL (time to live) of the product. Note that this is only
     * applicable to [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * and [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION],
     * and ignored for
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]. In general,
     * we suggest the users to delete the stale products explicitly, instead of
     * using this field to determine staleness.
     *
     * If it is set, it must be a non-negative value, and
     * [expire_time][google.cloud.retail.v2.Product.expire_time] is set as
     * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl]. The
     * derived [expire_time][google.cloud.retail.v2.Product.expire_time] is
     * returned in the output and [ttl][google.cloud.retail.v2.Product.ttl] is
     * left blank when retrieving the [Product][google.cloud.retail.v2.Product].
     *
     * If it is set, the product is not available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
     * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl].
     * However, the product can still be retrieved by
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
     * and
     * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 17 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getTtlOrBuilder() {
      if ((expirationCase_ == 17) && (ttlBuilder_ != null)) {
        return ttlBuilder_.getMessageOrBuilder();
      } else {
        if (expirationCase_ == 17) {
          return (com.google.protobuf.Duration) expiration_;
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL (time to live) of the product. Note that this is only
     * applicable to [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * and [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION],
     * and ignored for
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]. In general,
     * we suggest the users to delete the stale products explicitly, instead of
     * using this field to determine staleness.
     *
     * If it is set, it must be a non-negative value, and
     * [expire_time][google.cloud.retail.v2.Product.expire_time] is set as
     * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl]. The
     * derived [expire_time][google.cloud.retail.v2.Product.expire_time] is
     * returned in the output and [ttl][google.cloud.retail.v2.Product.ttl] is
     * left blank when retrieving the [Product][google.cloud.retail.v2.Product].
     *
     * If it is set, the product is not available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
     * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl].
     * However, the product can still be retrieved by
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
     * and
     * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 17 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTtlFieldBuilder() {
      if (ttlBuilder_ == null) {
        if (!(expirationCase_ == 17)) {
          expiration_ = com.google.protobuf.Duration.getDefaultInstance();
        }
        ttlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                (com.google.protobuf.Duration) expiration_, getParentForChildren(), isClean());
        expiration_ = null;
      }
      expirationCase_ = 17;
      onChanged();
      return ttlBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Full resource name of the product, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/product_id`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Full resource name of the product, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/product_id`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Full resource name of the product, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/product_id`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Full resource name of the product, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/product_id`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Full resource name of the product, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/product_id`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. [Product][google.cloud.retail.v2.Product] identifier, which is
     * the final component of [name][google.cloud.retail.v2.Product.name]. For
     * example, this field is "id_1", if
     * [name][google.cloud.retail.v2.Product.name] is
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/id_1`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [id](https://support.google.com/merchants/answer/6324405). Schema.org
     * property [Product.sku](https://schema.org/sku).
     * </pre>
     *
     * <code>string id = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. [Product][google.cloud.retail.v2.Product] identifier, which is
     * the final component of [name][google.cloud.retail.v2.Product.name]. For
     * example, this field is "id_1", if
     * [name][google.cloud.retail.v2.Product.name] is
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/id_1`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [id](https://support.google.com/merchants/answer/6324405). Schema.org
     * property [Product.sku](https://schema.org/sku).
     * </pre>
     *
     * <code>string id = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. [Product][google.cloud.retail.v2.Product] identifier, which is
     * the final component of [name][google.cloud.retail.v2.Product.name]. For
     * example, this field is "id_1", if
     * [name][google.cloud.retail.v2.Product.name] is
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/id_1`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [id](https://support.google.com/merchants/answer/6324405). Schema.org
     * property [Product.sku](https://schema.org/sku).
     * </pre>
     *
     * <code>string id = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. [Product][google.cloud.retail.v2.Product] identifier, which is
     * the final component of [name][google.cloud.retail.v2.Product.name]. For
     * example, this field is "id_1", if
     * [name][google.cloud.retail.v2.Product.name] is
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/id_1`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [id](https://support.google.com/merchants/answer/6324405). Schema.org
     * property [Product.sku](https://schema.org/sku).
     * </pre>
     *
     * <code>string id = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. [Product][google.cloud.retail.v2.Product] identifier, which is
     * the final component of [name][google.cloud.retail.v2.Product.name]. For
     * example, this field is "id_1", if
     * [name][google.cloud.retail.v2.Product.name] is
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/id_1`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [id](https://support.google.com/merchants/answer/6324405). Schema.org
     * property [Product.sku](https://schema.org/sku).
     * </pre>
     *
     * <code>string id = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Immutable. The type of the product. Default to
     * [Catalog.product_level_config.ingestion_product_type][google.cloud.retail.v2.ProductLevelConfig.ingestion_product_type]
     * if unset.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.Product.Type type = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The type of the product. Default to
     * [Catalog.product_level_config.ingestion_product_type][google.cloud.retail.v2.ProductLevelConfig.ingestion_product_type]
     * if unset.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.Product.Type type = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The type of the product. Default to
     * [Catalog.product_level_config.ingestion_product_type][google.cloud.retail.v2.ProductLevelConfig.ingestion_product_type]
     * if unset.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.Product.Type type = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.Product.Type getType() {
      com.google.cloud.retail.v2.Product.Type result =
          com.google.cloud.retail.v2.Product.Type.forNumber(type_);
      return result == null ? com.google.cloud.retail.v2.Product.Type.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The type of the product. Default to
     * [Catalog.product_level_config.ingestion_product_type][google.cloud.retail.v2.ProductLevelConfig.ingestion_product_type]
     * if unset.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.Product.Type type = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.retail.v2.Product.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The type of the product. Default to
     * [Catalog.product_level_config.ingestion_product_type][google.cloud.retail.v2.ProductLevelConfig.ingestion_product_type]
     * if unset.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.Product.Type type = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000010);
      type_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object primaryProductId_ = "";
    /**
     *
     *
     * <pre>
     * Variant group identifier. Must be an
     * [id][google.cloud.retail.v2.Product.id], with the same parent branch with
     * this product. Otherwise, an error is thrown.
     *
     * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s, this field can only be empty or
     * set to the same value as [id][google.cloud.retail.v2.Product.id].
     *
     * For VARIANT [Product][google.cloud.retail.v2.Product]s, this field cannot
     * be empty. A maximum of 2,000 products are allowed to share the same
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]. Otherwise, an INVALID_ARGUMENT
     * error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [item_group_id](https://support.google.com/merchants/answer/6324507).
     * Schema.org property
     * [Product.inProductGroupWithID](https://schema.org/inProductGroupWithID).
     * </pre>
     *
     * <code>string primary_product_id = 4;</code>
     *
     * @return The primaryProductId.
     */
    public java.lang.String getPrimaryProductId() {
      java.lang.Object ref = primaryProductId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        primaryProductId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Variant group identifier. Must be an
     * [id][google.cloud.retail.v2.Product.id], with the same parent branch with
     * this product. Otherwise, an error is thrown.
     *
     * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s, this field can only be empty or
     * set to the same value as [id][google.cloud.retail.v2.Product.id].
     *
     * For VARIANT [Product][google.cloud.retail.v2.Product]s, this field cannot
     * be empty. A maximum of 2,000 products are allowed to share the same
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]. Otherwise, an INVALID_ARGUMENT
     * error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [item_group_id](https://support.google.com/merchants/answer/6324507).
     * Schema.org property
     * [Product.inProductGroupWithID](https://schema.org/inProductGroupWithID).
     * </pre>
     *
     * <code>string primary_product_id = 4;</code>
     *
     * @return The bytes for primaryProductId.
     */
    public com.google.protobuf.ByteString getPrimaryProductIdBytes() {
      java.lang.Object ref = primaryProductId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        primaryProductId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Variant group identifier. Must be an
     * [id][google.cloud.retail.v2.Product.id], with the same parent branch with
     * this product. Otherwise, an error is thrown.
     *
     * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s, this field can only be empty or
     * set to the same value as [id][google.cloud.retail.v2.Product.id].
     *
     * For VARIANT [Product][google.cloud.retail.v2.Product]s, this field cannot
     * be empty. A maximum of 2,000 products are allowed to share the same
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]. Otherwise, an INVALID_ARGUMENT
     * error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [item_group_id](https://support.google.com/merchants/answer/6324507).
     * Schema.org property
     * [Product.inProductGroupWithID](https://schema.org/inProductGroupWithID).
     * </pre>
     *
     * <code>string primary_product_id = 4;</code>
     *
     * @param value The primaryProductId to set.
     * @return This builder for chaining.
     */
    public Builder setPrimaryProductId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      primaryProductId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Variant group identifier. Must be an
     * [id][google.cloud.retail.v2.Product.id], with the same parent branch with
     * this product. Otherwise, an error is thrown.
     *
     * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s, this field can only be empty or
     * set to the same value as [id][google.cloud.retail.v2.Product.id].
     *
     * For VARIANT [Product][google.cloud.retail.v2.Product]s, this field cannot
     * be empty. A maximum of 2,000 products are allowed to share the same
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]. Otherwise, an INVALID_ARGUMENT
     * error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [item_group_id](https://support.google.com/merchants/answer/6324507).
     * Schema.org property
     * [Product.inProductGroupWithID](https://schema.org/inProductGroupWithID).
     * </pre>
     *
     * <code>string primary_product_id = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrimaryProductId() {
      primaryProductId_ = getDefaultInstance().getPrimaryProductId();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Variant group identifier. Must be an
     * [id][google.cloud.retail.v2.Product.id], with the same parent branch with
     * this product. Otherwise, an error is thrown.
     *
     * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s, this field can only be empty or
     * set to the same value as [id][google.cloud.retail.v2.Product.id].
     *
     * For VARIANT [Product][google.cloud.retail.v2.Product]s, this field cannot
     * be empty. A maximum of 2,000 products are allowed to share the same
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]. Otherwise, an INVALID_ARGUMENT
     * error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [item_group_id](https://support.google.com/merchants/answer/6324507).
     * Schema.org property
     * [Product.inProductGroupWithID](https://schema.org/inProductGroupWithID).
     * </pre>
     *
     * <code>string primary_product_id = 4;</code>
     *
     * @param value The bytes for primaryProductId to set.
     * @return This builder for chaining.
     */
    public Builder setPrimaryProductIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      primaryProductId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList collectionMemberIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureCollectionMemberIdsIsMutable() {
      if (!collectionMemberIds_.isModifiable()) {
        collectionMemberIds_ = new com.google.protobuf.LazyStringArrayList(collectionMemberIds_);
      }
      bitField0_ |= 0x00000040;
    }
    /**
     *
     *
     * <pre>
     * The [id][google.cloud.retail.v2.Product.id] of the collection members when
     * [type][google.cloud.retail.v2.Product.type] is
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION].
     *
     * Non-existent product ids are allowed.
     * The [type][google.cloud.retail.v2.Product.type] of the members must be
     * either [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] or
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT] otherwise an
     * INVALID_ARGUMENT error is thrown. Should not set it for other types. A
     * maximum of 1000 values are allowed. Otherwise, an INVALID_ARGUMENT error is
     * return.
     * </pre>
     *
     * <code>repeated string collection_member_ids = 5;</code>
     *
     * @return A list containing the collectionMemberIds.
     */
    public com.google.protobuf.ProtocolStringList getCollectionMemberIdsList() {
      collectionMemberIds_.makeImmutable();
      return collectionMemberIds_;
    }
    /**
     *
     *
     * <pre>
     * The [id][google.cloud.retail.v2.Product.id] of the collection members when
     * [type][google.cloud.retail.v2.Product.type] is
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION].
     *
     * Non-existent product ids are allowed.
     * The [type][google.cloud.retail.v2.Product.type] of the members must be
     * either [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] or
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT] otherwise an
     * INVALID_ARGUMENT error is thrown. Should not set it for other types. A
     * maximum of 1000 values are allowed. Otherwise, an INVALID_ARGUMENT error is
     * return.
     * </pre>
     *
     * <code>repeated string collection_member_ids = 5;</code>
     *
     * @return The count of collectionMemberIds.
     */
    public int getCollectionMemberIdsCount() {
      return collectionMemberIds_.size();
    }
    /**
     *
     *
     * <pre>
     * The [id][google.cloud.retail.v2.Product.id] of the collection members when
     * [type][google.cloud.retail.v2.Product.type] is
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION].
     *
     * Non-existent product ids are allowed.
     * The [type][google.cloud.retail.v2.Product.type] of the members must be
     * either [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] or
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT] otherwise an
     * INVALID_ARGUMENT error is thrown. Should not set it for other types. A
     * maximum of 1000 values are allowed. Otherwise, an INVALID_ARGUMENT error is
     * return.
     * </pre>
     *
     * <code>repeated string collection_member_ids = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The collectionMemberIds at the given index.
     */
    public java.lang.String getCollectionMemberIds(int index) {
      return collectionMemberIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The [id][google.cloud.retail.v2.Product.id] of the collection members when
     * [type][google.cloud.retail.v2.Product.type] is
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION].
     *
     * Non-existent product ids are allowed.
     * The [type][google.cloud.retail.v2.Product.type] of the members must be
     * either [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] or
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT] otherwise an
     * INVALID_ARGUMENT error is thrown. Should not set it for other types. A
     * maximum of 1000 values are allowed. Otherwise, an INVALID_ARGUMENT error is
     * return.
     * </pre>
     *
     * <code>repeated string collection_member_ids = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the collectionMemberIds at the given index.
     */
    public com.google.protobuf.ByteString getCollectionMemberIdsBytes(int index) {
      return collectionMemberIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The [id][google.cloud.retail.v2.Product.id] of the collection members when
     * [type][google.cloud.retail.v2.Product.type] is
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION].
     *
     * Non-existent product ids are allowed.
     * The [type][google.cloud.retail.v2.Product.type] of the members must be
     * either [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] or
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT] otherwise an
     * INVALID_ARGUMENT error is thrown. Should not set it for other types. A
     * maximum of 1000 values are allowed. Otherwise, an INVALID_ARGUMENT error is
     * return.
     * </pre>
     *
     * <code>repeated string collection_member_ids = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The collectionMemberIds to set.
     * @return This builder for chaining.
     */
    public Builder setCollectionMemberIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCollectionMemberIdsIsMutable();
      collectionMemberIds_.set(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [id][google.cloud.retail.v2.Product.id] of the collection members when
     * [type][google.cloud.retail.v2.Product.type] is
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION].
     *
     * Non-existent product ids are allowed.
     * The [type][google.cloud.retail.v2.Product.type] of the members must be
     * either [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] or
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT] otherwise an
     * INVALID_ARGUMENT error is thrown. Should not set it for other types. A
     * maximum of 1000 values are allowed. Otherwise, an INVALID_ARGUMENT error is
     * return.
     * </pre>
     *
     * <code>repeated string collection_member_ids = 5;</code>
     *
     * @param value The collectionMemberIds to add.
     * @return This builder for chaining.
     */
    public Builder addCollectionMemberIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCollectionMemberIdsIsMutable();
      collectionMemberIds_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [id][google.cloud.retail.v2.Product.id] of the collection members when
     * [type][google.cloud.retail.v2.Product.type] is
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION].
     *
     * Non-existent product ids are allowed.
     * The [type][google.cloud.retail.v2.Product.type] of the members must be
     * either [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] or
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT] otherwise an
     * INVALID_ARGUMENT error is thrown. Should not set it for other types. A
     * maximum of 1000 values are allowed. Otherwise, an INVALID_ARGUMENT error is
     * return.
     * </pre>
     *
     * <code>repeated string collection_member_ids = 5;</code>
     *
     * @param values The collectionMemberIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllCollectionMemberIds(java.lang.Iterable<java.lang.String> values) {
      ensureCollectionMemberIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, collectionMemberIds_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [id][google.cloud.retail.v2.Product.id] of the collection members when
     * [type][google.cloud.retail.v2.Product.type] is
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION].
     *
     * Non-existent product ids are allowed.
     * The [type][google.cloud.retail.v2.Product.type] of the members must be
     * either [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] or
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT] otherwise an
     * INVALID_ARGUMENT error is thrown. Should not set it for other types. A
     * maximum of 1000 values are allowed. Otherwise, an INVALID_ARGUMENT error is
     * return.
     * </pre>
     *
     * <code>repeated string collection_member_ids = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCollectionMemberIds() {
      collectionMemberIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [id][google.cloud.retail.v2.Product.id] of the collection members when
     * [type][google.cloud.retail.v2.Product.type] is
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION].
     *
     * Non-existent product ids are allowed.
     * The [type][google.cloud.retail.v2.Product.type] of the members must be
     * either [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] or
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT] otherwise an
     * INVALID_ARGUMENT error is thrown. Should not set it for other types. A
     * maximum of 1000 values are allowed. Otherwise, an INVALID_ARGUMENT error is
     * return.
     * </pre>
     *
     * <code>repeated string collection_member_ids = 5;</code>
     *
     * @param value The bytes of the collectionMemberIds to add.
     * @return This builder for chaining.
     */
    public Builder addCollectionMemberIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureCollectionMemberIdsIsMutable();
      collectionMemberIds_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object gtin_ = "";
    /**
     *
     *
     * <pre>
     * The Global Trade Item Number (GTIN) of the product.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * This field must be a Unigram. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [gtin](https://support.google.com/merchants/answer/6324461).
     * Schema.org property
     * [Product.isbn](https://schema.org/isbn),
     * [Product.gtin8](https://schema.org/gtin8),
     * [Product.gtin12](https://schema.org/gtin12),
     * [Product.gtin13](https://schema.org/gtin13), or
     * [Product.gtin14](https://schema.org/gtin14).
     *
     * If the value is not a valid GTIN, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string gtin = 6;</code>
     *
     * @return The gtin.
     */
    public java.lang.String getGtin() {
      java.lang.Object ref = gtin_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gtin_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Global Trade Item Number (GTIN) of the product.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * This field must be a Unigram. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [gtin](https://support.google.com/merchants/answer/6324461).
     * Schema.org property
     * [Product.isbn](https://schema.org/isbn),
     * [Product.gtin8](https://schema.org/gtin8),
     * [Product.gtin12](https://schema.org/gtin12),
     * [Product.gtin13](https://schema.org/gtin13), or
     * [Product.gtin14](https://schema.org/gtin14).
     *
     * If the value is not a valid GTIN, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string gtin = 6;</code>
     *
     * @return The bytes for gtin.
     */
    public com.google.protobuf.ByteString getGtinBytes() {
      java.lang.Object ref = gtin_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gtin_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Global Trade Item Number (GTIN) of the product.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * This field must be a Unigram. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [gtin](https://support.google.com/merchants/answer/6324461).
     * Schema.org property
     * [Product.isbn](https://schema.org/isbn),
     * [Product.gtin8](https://schema.org/gtin8),
     * [Product.gtin12](https://schema.org/gtin12),
     * [Product.gtin13](https://schema.org/gtin13), or
     * [Product.gtin14](https://schema.org/gtin14).
     *
     * If the value is not a valid GTIN, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string gtin = 6;</code>
     *
     * @param value The gtin to set.
     * @return This builder for chaining.
     */
    public Builder setGtin(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      gtin_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Global Trade Item Number (GTIN) of the product.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * This field must be a Unigram. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [gtin](https://support.google.com/merchants/answer/6324461).
     * Schema.org property
     * [Product.isbn](https://schema.org/isbn),
     * [Product.gtin8](https://schema.org/gtin8),
     * [Product.gtin12](https://schema.org/gtin12),
     * [Product.gtin13](https://schema.org/gtin13), or
     * [Product.gtin14](https://schema.org/gtin14).
     *
     * If the value is not a valid GTIN, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string gtin = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGtin() {
      gtin_ = getDefaultInstance().getGtin();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Global Trade Item Number (GTIN) of the product.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * This field must be a Unigram. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [gtin](https://support.google.com/merchants/answer/6324461).
     * Schema.org property
     * [Product.isbn](https://schema.org/isbn),
     * [Product.gtin8](https://schema.org/gtin8),
     * [Product.gtin12](https://schema.org/gtin12),
     * [Product.gtin13](https://schema.org/gtin13), or
     * [Product.gtin14](https://schema.org/gtin14).
     *
     * If the value is not a valid GTIN, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string gtin = 6;</code>
     *
     * @param value The bytes for gtin to set.
     * @return This builder for chaining.
     */
    public Builder setGtinBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      gtin_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList categories_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureCategoriesIsMutable() {
      if (!categories_.isModifiable()) {
        categories_ = new com.google.protobuf.LazyStringArrayList(categories_);
      }
      bitField0_ |= 0x00000100;
    }
    /**
     *
     *
     * <pre>
     * Product categories. This field is repeated for supporting one product
     * belonging to several parallel categories. Strongly recommended using the
     * full path for better search / recommendation quality.
     *
     *
     * To represent full path of category, use '&gt;' sign to separate different
     * hierarchies. If '&gt;' is part of the category name, replace it with
     * other character(s).
     *
     * For example, if a shoes product belongs to both
     * ["Shoes &amp; Accessories" -&gt; "Shoes"] and
     * ["Sports &amp; Fitness" -&gt; "Athletic Clothing" -&gt; "Shoes"], it could be
     * represented as:
     *
     *      "categories": [
     *        "Shoes &amp; Accessories &gt; Shoes",
     *        "Sports &amp; Fitness &gt; Athletic Clothing &gt; Shoes"
     *      ]
     *
     * Must be set for [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product] otherwise an INVALID_ARGUMENT
     * error is returned.
     *
     * At most 250 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Empty values are not allowed.
     * Each value must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [google_product_category][mc_google_product_category]. Schema.org property
     * [Product.category] (https://schema.org/category).
     *
     * [mc_google_product_category]:
     * https://support.google.com/merchants/answer/6324436
     * </pre>
     *
     * <code>repeated string categories = 7;</code>
     *
     * @return A list containing the categories.
     */
    public com.google.protobuf.ProtocolStringList getCategoriesList() {
      categories_.makeImmutable();
      return categories_;
    }
    /**
     *
     *
     * <pre>
     * Product categories. This field is repeated for supporting one product
     * belonging to several parallel categories. Strongly recommended using the
     * full path for better search / recommendation quality.
     *
     *
     * To represent full path of category, use '&gt;' sign to separate different
     * hierarchies. If '&gt;' is part of the category name, replace it with
     * other character(s).
     *
     * For example, if a shoes product belongs to both
     * ["Shoes &amp; Accessories" -&gt; "Shoes"] and
     * ["Sports &amp; Fitness" -&gt; "Athletic Clothing" -&gt; "Shoes"], it could be
     * represented as:
     *
     *      "categories": [
     *        "Shoes &amp; Accessories &gt; Shoes",
     *        "Sports &amp; Fitness &gt; Athletic Clothing &gt; Shoes"
     *      ]
     *
     * Must be set for [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product] otherwise an INVALID_ARGUMENT
     * error is returned.
     *
     * At most 250 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Empty values are not allowed.
     * Each value must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [google_product_category][mc_google_product_category]. Schema.org property
     * [Product.category] (https://schema.org/category).
     *
     * [mc_google_product_category]:
     * https://support.google.com/merchants/answer/6324436
     * </pre>
     *
     * <code>repeated string categories = 7;</code>
     *
     * @return The count of categories.
     */
    public int getCategoriesCount() {
      return categories_.size();
    }
    /**
     *
     *
     * <pre>
     * Product categories. This field is repeated for supporting one product
     * belonging to several parallel categories. Strongly recommended using the
     * full path for better search / recommendation quality.
     *
     *
     * To represent full path of category, use '&gt;' sign to separate different
     * hierarchies. If '&gt;' is part of the category name, replace it with
     * other character(s).
     *
     * For example, if a shoes product belongs to both
     * ["Shoes &amp; Accessories" -&gt; "Shoes"] and
     * ["Sports &amp; Fitness" -&gt; "Athletic Clothing" -&gt; "Shoes"], it could be
     * represented as:
     *
     *      "categories": [
     *        "Shoes &amp; Accessories &gt; Shoes",
     *        "Sports &amp; Fitness &gt; Athletic Clothing &gt; Shoes"
     *      ]
     *
     * Must be set for [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product] otherwise an INVALID_ARGUMENT
     * error is returned.
     *
     * At most 250 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Empty values are not allowed.
     * Each value must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [google_product_category][mc_google_product_category]. Schema.org property
     * [Product.category] (https://schema.org/category).
     *
     * [mc_google_product_category]:
     * https://support.google.com/merchants/answer/6324436
     * </pre>
     *
     * <code>repeated string categories = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The categories at the given index.
     */
    public java.lang.String getCategories(int index) {
      return categories_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Product categories. This field is repeated for supporting one product
     * belonging to several parallel categories. Strongly recommended using the
     * full path for better search / recommendation quality.
     *
     *
     * To represent full path of category, use '&gt;' sign to separate different
     * hierarchies. If '&gt;' is part of the category name, replace it with
     * other character(s).
     *
     * For example, if a shoes product belongs to both
     * ["Shoes &amp; Accessories" -&gt; "Shoes"] and
     * ["Sports &amp; Fitness" -&gt; "Athletic Clothing" -&gt; "Shoes"], it could be
     * represented as:
     *
     *      "categories": [
     *        "Shoes &amp; Accessories &gt; Shoes",
     *        "Sports &amp; Fitness &gt; Athletic Clothing &gt; Shoes"
     *      ]
     *
     * Must be set for [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product] otherwise an INVALID_ARGUMENT
     * error is returned.
     *
     * At most 250 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Empty values are not allowed.
     * Each value must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [google_product_category][mc_google_product_category]. Schema.org property
     * [Product.category] (https://schema.org/category).
     *
     * [mc_google_product_category]:
     * https://support.google.com/merchants/answer/6324436
     * </pre>
     *
     * <code>repeated string categories = 7;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the categories at the given index.
     */
    public com.google.protobuf.ByteString getCategoriesBytes(int index) {
      return categories_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Product categories. This field is repeated for supporting one product
     * belonging to several parallel categories. Strongly recommended using the
     * full path for better search / recommendation quality.
     *
     *
     * To represent full path of category, use '&gt;' sign to separate different
     * hierarchies. If '&gt;' is part of the category name, replace it with
     * other character(s).
     *
     * For example, if a shoes product belongs to both
     * ["Shoes &amp; Accessories" -&gt; "Shoes"] and
     * ["Sports &amp; Fitness" -&gt; "Athletic Clothing" -&gt; "Shoes"], it could be
     * represented as:
     *
     *      "categories": [
     *        "Shoes &amp; Accessories &gt; Shoes",
     *        "Sports &amp; Fitness &gt; Athletic Clothing &gt; Shoes"
     *      ]
     *
     * Must be set for [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product] otherwise an INVALID_ARGUMENT
     * error is returned.
     *
     * At most 250 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Empty values are not allowed.
     * Each value must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [google_product_category][mc_google_product_category]. Schema.org property
     * [Product.category] (https://schema.org/category).
     *
     * [mc_google_product_category]:
     * https://support.google.com/merchants/answer/6324436
     * </pre>
     *
     * <code>repeated string categories = 7;</code>
     *
     * @param index The index to set the value at.
     * @param value The categories to set.
     * @return This builder for chaining.
     */
    public Builder setCategories(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCategoriesIsMutable();
      categories_.set(index, value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Product categories. This field is repeated for supporting one product
     * belonging to several parallel categories. Strongly recommended using the
     * full path for better search / recommendation quality.
     *
     *
     * To represent full path of category, use '&gt;' sign to separate different
     * hierarchies. If '&gt;' is part of the category name, replace it with
     * other character(s).
     *
     * For example, if a shoes product belongs to both
     * ["Shoes &amp; Accessories" -&gt; "Shoes"] and
     * ["Sports &amp; Fitness" -&gt; "Athletic Clothing" -&gt; "Shoes"], it could be
     * represented as:
     *
     *      "categories": [
     *        "Shoes &amp; Accessories &gt; Shoes",
     *        "Sports &amp; Fitness &gt; Athletic Clothing &gt; Shoes"
     *      ]
     *
     * Must be set for [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product] otherwise an INVALID_ARGUMENT
     * error is returned.
     *
     * At most 250 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Empty values are not allowed.
     * Each value must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [google_product_category][mc_google_product_category]. Schema.org property
     * [Product.category] (https://schema.org/category).
     *
     * [mc_google_product_category]:
     * https://support.google.com/merchants/answer/6324436
     * </pre>
     *
     * <code>repeated string categories = 7;</code>
     *
     * @param value The categories to add.
     * @return This builder for chaining.
     */
    public Builder addCategories(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCategoriesIsMutable();
      categories_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Product categories. This field is repeated for supporting one product
     * belonging to several parallel categories. Strongly recommended using the
     * full path for better search / recommendation quality.
     *
     *
     * To represent full path of category, use '&gt;' sign to separate different
     * hierarchies. If '&gt;' is part of the category name, replace it with
     * other character(s).
     *
     * For example, if a shoes product belongs to both
     * ["Shoes &amp; Accessories" -&gt; "Shoes"] and
     * ["Sports &amp; Fitness" -&gt; "Athletic Clothing" -&gt; "Shoes"], it could be
     * represented as:
     *
     *      "categories": [
     *        "Shoes &amp; Accessories &gt; Shoes",
     *        "Sports &amp; Fitness &gt; Athletic Clothing &gt; Shoes"
     *      ]
     *
     * Must be set for [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product] otherwise an INVALID_ARGUMENT
     * error is returned.
     *
     * At most 250 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Empty values are not allowed.
     * Each value must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [google_product_category][mc_google_product_category]. Schema.org property
     * [Product.category] (https://schema.org/category).
     *
     * [mc_google_product_category]:
     * https://support.google.com/merchants/answer/6324436
     * </pre>
     *
     * <code>repeated string categories = 7;</code>
     *
     * @param values The categories to add.
     * @return This builder for chaining.
     */
    public Builder addAllCategories(java.lang.Iterable<java.lang.String> values) {
      ensureCategoriesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, categories_);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Product categories. This field is repeated for supporting one product
     * belonging to several parallel categories. Strongly recommended using the
     * full path for better search / recommendation quality.
     *
     *
     * To represent full path of category, use '&gt;' sign to separate different
     * hierarchies. If '&gt;' is part of the category name, replace it with
     * other character(s).
     *
     * For example, if a shoes product belongs to both
     * ["Shoes &amp; Accessories" -&gt; "Shoes"] and
     * ["Sports &amp; Fitness" -&gt; "Athletic Clothing" -&gt; "Shoes"], it could be
     * represented as:
     *
     *      "categories": [
     *        "Shoes &amp; Accessories &gt; Shoes",
     *        "Sports &amp; Fitness &gt; Athletic Clothing &gt; Shoes"
     *      ]
     *
     * Must be set for [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product] otherwise an INVALID_ARGUMENT
     * error is returned.
     *
     * At most 250 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Empty values are not allowed.
     * Each value must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [google_product_category][mc_google_product_category]. Schema.org property
     * [Product.category] (https://schema.org/category).
     *
     * [mc_google_product_category]:
     * https://support.google.com/merchants/answer/6324436
     * </pre>
     *
     * <code>repeated string categories = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCategories() {
      categories_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Product categories. This field is repeated for supporting one product
     * belonging to several parallel categories. Strongly recommended using the
     * full path for better search / recommendation quality.
     *
     *
     * To represent full path of category, use '&gt;' sign to separate different
     * hierarchies. If '&gt;' is part of the category name, replace it with
     * other character(s).
     *
     * For example, if a shoes product belongs to both
     * ["Shoes &amp; Accessories" -&gt; "Shoes"] and
     * ["Sports &amp; Fitness" -&gt; "Athletic Clothing" -&gt; "Shoes"], it could be
     * represented as:
     *
     *      "categories": [
     *        "Shoes &amp; Accessories &gt; Shoes",
     *        "Sports &amp; Fitness &gt; Athletic Clothing &gt; Shoes"
     *      ]
     *
     * Must be set for [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product] otherwise an INVALID_ARGUMENT
     * error is returned.
     *
     * At most 250 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Empty values are not allowed.
     * Each value must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [google_product_category][mc_google_product_category]. Schema.org property
     * [Product.category] (https://schema.org/category).
     *
     * [mc_google_product_category]:
     * https://support.google.com/merchants/answer/6324436
     * </pre>
     *
     * <code>repeated string categories = 7;</code>
     *
     * @param value The bytes of the categories to add.
     * @return This builder for chaining.
     */
    public Builder addCategoriesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureCategoriesIsMutable();
      categories_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object title_ = "";
    /**
     *
     *
     * <pre>
     * Required. Product title.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [title](https://support.google.com/merchants/answer/6324415). Schema.org
     * property [Product.name](https://schema.org/name).
     * </pre>
     *
     * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The title.
     */
    public java.lang.String getTitle() {
      java.lang.Object ref = title_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        title_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Product title.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [title](https://support.google.com/merchants/answer/6324415). Schema.org
     * property [Product.name](https://schema.org/name).
     * </pre>
     *
     * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for title.
     */
    public com.google.protobuf.ByteString getTitleBytes() {
      java.lang.Object ref = title_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        title_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Product title.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [title](https://support.google.com/merchants/answer/6324415). Schema.org
     * property [Product.name](https://schema.org/name).
     * </pre>
     *
     * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The title to set.
     * @return This builder for chaining.
     */
    public Builder setTitle(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      title_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Product title.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [title](https://support.google.com/merchants/answer/6324415). Schema.org
     * property [Product.name](https://schema.org/name).
     * </pre>
     *
     * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTitle() {
      title_ = getDefaultInstance().getTitle();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Product title.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [title](https://support.google.com/merchants/answer/6324415). Schema.org
     * property [Product.name](https://schema.org/name).
     * </pre>
     *
     * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for title to set.
     * @return This builder for chaining.
     */
    public Builder setTitleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      title_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList brands_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureBrandsIsMutable() {
      if (!brands_.isModifiable()) {
        brands_ = new com.google.protobuf.LazyStringArrayList(brands_);
      }
      bitField0_ |= 0x00000400;
    }
    /**
     *
     *
     * <pre>
     * The brands of the product.
     *
     * A maximum of 30 brands are allowed. Each brand must be a UTF-8 encoded
     * string with a length limit of 1,000 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [brand](https://support.google.com/merchants/answer/6324351). Schema.org
     * property [Product.brand](https://schema.org/brand).
     * </pre>
     *
     * <code>repeated string brands = 9;</code>
     *
     * @return A list containing the brands.
     */
    public com.google.protobuf.ProtocolStringList getBrandsList() {
      brands_.makeImmutable();
      return brands_;
    }
    /**
     *
     *
     * <pre>
     * The brands of the product.
     *
     * A maximum of 30 brands are allowed. Each brand must be a UTF-8 encoded
     * string with a length limit of 1,000 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [brand](https://support.google.com/merchants/answer/6324351). Schema.org
     * property [Product.brand](https://schema.org/brand).
     * </pre>
     *
     * <code>repeated string brands = 9;</code>
     *
     * @return The count of brands.
     */
    public int getBrandsCount() {
      return brands_.size();
    }
    /**
     *
     *
     * <pre>
     * The brands of the product.
     *
     * A maximum of 30 brands are allowed. Each brand must be a UTF-8 encoded
     * string with a length limit of 1,000 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [brand](https://support.google.com/merchants/answer/6324351). Schema.org
     * property [Product.brand](https://schema.org/brand).
     * </pre>
     *
     * <code>repeated string brands = 9;</code>
     *
     * @param index The index of the element to return.
     * @return The brands at the given index.
     */
    public java.lang.String getBrands(int index) {
      return brands_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The brands of the product.
     *
     * A maximum of 30 brands are allowed. Each brand must be a UTF-8 encoded
     * string with a length limit of 1,000 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [brand](https://support.google.com/merchants/answer/6324351). Schema.org
     * property [Product.brand](https://schema.org/brand).
     * </pre>
     *
     * <code>repeated string brands = 9;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the brands at the given index.
     */
    public com.google.protobuf.ByteString getBrandsBytes(int index) {
      return brands_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The brands of the product.
     *
     * A maximum of 30 brands are allowed. Each brand must be a UTF-8 encoded
     * string with a length limit of 1,000 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [brand](https://support.google.com/merchants/answer/6324351). Schema.org
     * property [Product.brand](https://schema.org/brand).
     * </pre>
     *
     * <code>repeated string brands = 9;</code>
     *
     * @param index The index to set the value at.
     * @param value The brands to set.
     * @return This builder for chaining.
     */
    public Builder setBrands(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBrandsIsMutable();
      brands_.set(index, value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The brands of the product.
     *
     * A maximum of 30 brands are allowed. Each brand must be a UTF-8 encoded
     * string with a length limit of 1,000 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [brand](https://support.google.com/merchants/answer/6324351). Schema.org
     * property [Product.brand](https://schema.org/brand).
     * </pre>
     *
     * <code>repeated string brands = 9;</code>
     *
     * @param value The brands to add.
     * @return This builder for chaining.
     */
    public Builder addBrands(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBrandsIsMutable();
      brands_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The brands of the product.
     *
     * A maximum of 30 brands are allowed. Each brand must be a UTF-8 encoded
     * string with a length limit of 1,000 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [brand](https://support.google.com/merchants/answer/6324351). Schema.org
     * property [Product.brand](https://schema.org/brand).
     * </pre>
     *
     * <code>repeated string brands = 9;</code>
     *
     * @param values The brands to add.
     * @return This builder for chaining.
     */
    public Builder addAllBrands(java.lang.Iterable<java.lang.String> values) {
      ensureBrandsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, brands_);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The brands of the product.
     *
     * A maximum of 30 brands are allowed. Each brand must be a UTF-8 encoded
     * string with a length limit of 1,000 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [brand](https://support.google.com/merchants/answer/6324351). Schema.org
     * property [Product.brand](https://schema.org/brand).
     * </pre>
     *
     * <code>repeated string brands = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBrands() {
      brands_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000400);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The brands of the product.
     *
     * A maximum of 30 brands are allowed. Each brand must be a UTF-8 encoded
     * string with a length limit of 1,000 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [brand](https://support.google.com/merchants/answer/6324351). Schema.org
     * property [Product.brand](https://schema.org/brand).
     * </pre>
     *
     * <code>repeated string brands = 9;</code>
     *
     * @param value The bytes of the brands to add.
     * @return This builder for chaining.
     */
    public Builder addBrandsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureBrandsIsMutable();
      brands_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Product description.
     *
     * This field must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [description](https://support.google.com/merchants/answer/6324468).
     * Schema.org property [Product.description](https://schema.org/description).
     * </pre>
     *
     * <code>string description = 10;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Product description.
     *
     * This field must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [description](https://support.google.com/merchants/answer/6324468).
     * Schema.org property [Product.description](https://schema.org/description).
     * </pre>
     *
     * <code>string description = 10;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Product description.
     *
     * This field must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [description](https://support.google.com/merchants/answer/6324468).
     * Schema.org property [Product.description](https://schema.org/description).
     * </pre>
     *
     * <code>string description = 10;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Product description.
     *
     * This field must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [description](https://support.google.com/merchants/answer/6324468).
     * Schema.org property [Product.description](https://schema.org/description).
     * </pre>
     *
     * <code>string description = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Product description.
     *
     * This field must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [description](https://support.google.com/merchants/answer/6324468).
     * Schema.org property [Product.description](https://schema.org/description).
     * </pre>
     *
     * <code>string description = 10;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * Language of the title/description and other string attributes. Use language
     * tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     *
     * For product prediction, this field is ignored and the model automatically
     * detects the text language. The [Product][google.cloud.retail.v2.Product]
     * can include text in different languages, but duplicating
     * [Product][google.cloud.retail.v2.Product]s to provide text in multiple
     * languages can result in degraded model performance.
     *
     * For product search this field is in use. It defaults to "en-US" if unset.
     * </pre>
     *
     * <code>string language_code = 11;</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Language of the title/description and other string attributes. Use language
     * tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     *
     * For product prediction, this field is ignored and the model automatically
     * detects the text language. The [Product][google.cloud.retail.v2.Product]
     * can include text in different languages, but duplicating
     * [Product][google.cloud.retail.v2.Product]s to provide text in multiple
     * languages can result in degraded model performance.
     *
     * For product search this field is in use. It defaults to "en-US" if unset.
     * </pre>
     *
     * <code>string language_code = 11;</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Language of the title/description and other string attributes. Use language
     * tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     *
     * For product prediction, this field is ignored and the model automatically
     * detects the text language. The [Product][google.cloud.retail.v2.Product]
     * can include text in different languages, but duplicating
     * [Product][google.cloud.retail.v2.Product]s to provide text in multiple
     * languages can result in degraded model performance.
     *
     * For product search this field is in use. It defaults to "en-US" if unset.
     * </pre>
     *
     * <code>string language_code = 11;</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      languageCode_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Language of the title/description and other string attributes. Use language
     * tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     *
     * For product prediction, this field is ignored and the model automatically
     * detects the text language. The [Product][google.cloud.retail.v2.Product]
     * can include text in different languages, but duplicating
     * [Product][google.cloud.retail.v2.Product]s to provide text in multiple
     * languages can result in degraded model performance.
     *
     * For product search this field is in use. It defaults to "en-US" if unset.
     * </pre>
     *
     * <code>string language_code = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {
      languageCode_ = getDefaultInstance().getLanguageCode();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Language of the title/description and other string attributes. Use language
     * tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     *
     * For product prediction, this field is ignored and the model automatically
     * detects the text language. The [Product][google.cloud.retail.v2.Product]
     * can include text in different languages, but duplicating
     * [Product][google.cloud.retail.v2.Product]s to provide text in multiple
     * languages can result in degraded model performance.
     *
     * For product search this field is in use. It defaults to "en-US" if unset.
     * </pre>
     *
     * <code>string language_code = 11;</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      languageCode_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private static final class AttributesConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.retail.v2.CustomAttributeOrBuilder,
            com.google.cloud.retail.v2.CustomAttribute> {
      @java.lang.Override
      public com.google.cloud.retail.v2.CustomAttribute build(
          com.google.cloud.retail.v2.CustomAttributeOrBuilder val) {
        if (val instanceof com.google.cloud.retail.v2.CustomAttribute) {
          return (com.google.cloud.retail.v2.CustomAttribute) val;
        }
        return ((com.google.cloud.retail.v2.CustomAttribute.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.retail.v2.CustomAttribute>
          defaultEntry() {
        return AttributesDefaultEntryHolder.defaultEntry;
      }
    };

    private static final AttributesConverter attributesConverter = new AttributesConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.retail.v2.CustomAttributeOrBuilder,
            com.google.cloud.retail.v2.CustomAttribute,
            com.google.cloud.retail.v2.CustomAttribute.Builder>
        attributes_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.retail.v2.CustomAttributeOrBuilder,
            com.google.cloud.retail.v2.CustomAttribute,
            com.google.cloud.retail.v2.CustomAttribute.Builder>
        internalGetAttributes() {
      if (attributes_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(attributesConverter);
      }
      return attributes_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.retail.v2.CustomAttributeOrBuilder,
            com.google.cloud.retail.v2.CustomAttribute,
            com.google.cloud.retail.v2.CustomAttribute.Builder>
        internalGetMutableAttributes() {
      if (attributes_ == null) {
        attributes_ = new com.google.protobuf.MapFieldBuilder<>(attributesConverter);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return attributes_;
    }

    public int getAttributesCount() {
      return internalGetAttributes().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * Highly encouraged. Extra product attributes to be included. For example,
     * for products, this could include the store name, vendor, style, color, etc.
     * These are very strong signals for recommendation model, thus we highly
     * recommend providing the attributes here.
     *
     * Features that can take on one of a limited number of possible values. Two
     * types of features can be set are:
     *
     * Textual features. some examples would be the brand/maker of a product, or
     * country of a customer. Numerical features. Some examples would be the
     * height/weight of a product, or age of a customer.
     *
     * For example: `{ "vendor": {"text": ["vendor123", "vendor456"]},
     * "lengths_cm": {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]}
     * }`.
     *
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     *
     * * Max entries count: 200.
     * * The key must be a UTF-8 encoded string with a length limit of 128
     *   characters.
     * * For indexable attribute, the key must match the pattern:
     *   `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example, `key0LikeThis` or
     *   `KEY_1_LIKE_THIS`.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a non-empty UTF-8 encoded string with a
     *   length limit of 256 characters.
     * * For number attributes, at most 400 values are allowed.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 12;</code>
     */
    @java.lang.Override
    public boolean containsAttributes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAttributes().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getAttributesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.retail.v2.CustomAttribute>
        getAttributes() {
      return getAttributesMap();
    }
    /**
     *
     *
     * <pre>
     * Highly encouraged. Extra product attributes to be included. For example,
     * for products, this could include the store name, vendor, style, color, etc.
     * These are very strong signals for recommendation model, thus we highly
     * recommend providing the attributes here.
     *
     * Features that can take on one of a limited number of possible values. Two
     * types of features can be set are:
     *
     * Textual features. some examples would be the brand/maker of a product, or
     * country of a customer. Numerical features. Some examples would be the
     * height/weight of a product, or age of a customer.
     *
     * For example: `{ "vendor": {"text": ["vendor123", "vendor456"]},
     * "lengths_cm": {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]}
     * }`.
     *
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     *
     * * Max entries count: 200.
     * * The key must be a UTF-8 encoded string with a length limit of 128
     *   characters.
     * * For indexable attribute, the key must match the pattern:
     *   `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example, `key0LikeThis` or
     *   `KEY_1_LIKE_THIS`.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a non-empty UTF-8 encoded string with a
     *   length limit of 256 characters.
     * * For number attributes, at most 400 values are allowed.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 12;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.retail.v2.CustomAttribute>
        getAttributesMap() {
      return internalGetAttributes().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * Highly encouraged. Extra product attributes to be included. For example,
     * for products, this could include the store name, vendor, style, color, etc.
     * These are very strong signals for recommendation model, thus we highly
     * recommend providing the attributes here.
     *
     * Features that can take on one of a limited number of possible values. Two
     * types of features can be set are:
     *
     * Textual features. some examples would be the brand/maker of a product, or
     * country of a customer. Numerical features. Some examples would be the
     * height/weight of a product, or age of a customer.
     *
     * For example: `{ "vendor": {"text": ["vendor123", "vendor456"]},
     * "lengths_cm": {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]}
     * }`.
     *
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     *
     * * Max entries count: 200.
     * * The key must be a UTF-8 encoded string with a length limit of 128
     *   characters.
     * * For indexable attribute, the key must match the pattern:
     *   `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example, `key0LikeThis` or
     *   `KEY_1_LIKE_THIS`.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a non-empty UTF-8 encoded string with a
     *   length limit of 256 characters.
     * * For number attributes, at most 400 values are allowed.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 12;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.retail.v2.CustomAttribute getAttributesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.retail.v2.CustomAttribute defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.retail.v2.CustomAttributeOrBuilder> map =
          internalGetMutableAttributes().ensureBuilderMap();
      return map.containsKey(key) ? attributesConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Highly encouraged. Extra product attributes to be included. For example,
     * for products, this could include the store name, vendor, style, color, etc.
     * These are very strong signals for recommendation model, thus we highly
     * recommend providing the attributes here.
     *
     * Features that can take on one of a limited number of possible values. Two
     * types of features can be set are:
     *
     * Textual features. some examples would be the brand/maker of a product, or
     * country of a customer. Numerical features. Some examples would be the
     * height/weight of a product, or age of a customer.
     *
     * For example: `{ "vendor": {"text": ["vendor123", "vendor456"]},
     * "lengths_cm": {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]}
     * }`.
     *
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     *
     * * Max entries count: 200.
     * * The key must be a UTF-8 encoded string with a length limit of 128
     *   characters.
     * * For indexable attribute, the key must match the pattern:
     *   `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example, `key0LikeThis` or
     *   `KEY_1_LIKE_THIS`.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a non-empty UTF-8 encoded string with a
     *   length limit of 256 characters.
     * * For number attributes, at most 400 values are allowed.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 12;</code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.CustomAttribute getAttributesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.retail.v2.CustomAttributeOrBuilder> map =
          internalGetMutableAttributes().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return attributesConverter.build(map.get(key));
    }

    public Builder clearAttributes() {
      bitField0_ = (bitField0_ & ~0x00002000);
      internalGetMutableAttributes().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Highly encouraged. Extra product attributes to be included. For example,
     * for products, this could include the store name, vendor, style, color, etc.
     * These are very strong signals for recommendation model, thus we highly
     * recommend providing the attributes here.
     *
     * Features that can take on one of a limited number of possible values. Two
     * types of features can be set are:
     *
     * Textual features. some examples would be the brand/maker of a product, or
     * country of a customer. Numerical features. Some examples would be the
     * height/weight of a product, or age of a customer.
     *
     * For example: `{ "vendor": {"text": ["vendor123", "vendor456"]},
     * "lengths_cm": {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]}
     * }`.
     *
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     *
     * * Max entries count: 200.
     * * The key must be a UTF-8 encoded string with a length limit of 128
     *   characters.
     * * For indexable attribute, the key must match the pattern:
     *   `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example, `key0LikeThis` or
     *   `KEY_1_LIKE_THIS`.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a non-empty UTF-8 encoded string with a
     *   length limit of 256 characters.
     * * For number attributes, at most 400 values are allowed.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 12;</code>
     */
    public Builder removeAttributes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAttributes().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.retail.v2.CustomAttribute>
        getMutableAttributes() {
      bitField0_ |= 0x00002000;
      return internalGetMutableAttributes().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * Highly encouraged. Extra product attributes to be included. For example,
     * for products, this could include the store name, vendor, style, color, etc.
     * These are very strong signals for recommendation model, thus we highly
     * recommend providing the attributes here.
     *
     * Features that can take on one of a limited number of possible values. Two
     * types of features can be set are:
     *
     * Textual features. some examples would be the brand/maker of a product, or
     * country of a customer. Numerical features. Some examples would be the
     * height/weight of a product, or age of a customer.
     *
     * For example: `{ "vendor": {"text": ["vendor123", "vendor456"]},
     * "lengths_cm": {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]}
     * }`.
     *
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     *
     * * Max entries count: 200.
     * * The key must be a UTF-8 encoded string with a length limit of 128
     *   characters.
     * * For indexable attribute, the key must match the pattern:
     *   `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example, `key0LikeThis` or
     *   `KEY_1_LIKE_THIS`.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a non-empty UTF-8 encoded string with a
     *   length limit of 256 characters.
     * * For number attributes, at most 400 values are allowed.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 12;</code>
     */
    public Builder putAttributes(
        java.lang.String key, com.google.cloud.retail.v2.CustomAttribute value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAttributes().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00002000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Highly encouraged. Extra product attributes to be included. For example,
     * for products, this could include the store name, vendor, style, color, etc.
     * These are very strong signals for recommendation model, thus we highly
     * recommend providing the attributes here.
     *
     * Features that can take on one of a limited number of possible values. Two
     * types of features can be set are:
     *
     * Textual features. some examples would be the brand/maker of a product, or
     * country of a customer. Numerical features. Some examples would be the
     * height/weight of a product, or age of a customer.
     *
     * For example: `{ "vendor": {"text": ["vendor123", "vendor456"]},
     * "lengths_cm": {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]}
     * }`.
     *
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     *
     * * Max entries count: 200.
     * * The key must be a UTF-8 encoded string with a length limit of 128
     *   characters.
     * * For indexable attribute, the key must match the pattern:
     *   `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example, `key0LikeThis` or
     *   `KEY_1_LIKE_THIS`.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a non-empty UTF-8 encoded string with a
     *   length limit of 256 characters.
     * * For number attributes, at most 400 values are allowed.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 12;</code>
     */
    public Builder putAllAttributes(
        java.util.Map<java.lang.String, com.google.cloud.retail.v2.CustomAttribute> values) {
      for (java.util.Map.Entry<java.lang.String, com.google.cloud.retail.v2.CustomAttribute> e :
          values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableAttributes().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00002000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Highly encouraged. Extra product attributes to be included. For example,
     * for products, this could include the store name, vendor, style, color, etc.
     * These are very strong signals for recommendation model, thus we highly
     * recommend providing the attributes here.
     *
     * Features that can take on one of a limited number of possible values. Two
     * types of features can be set are:
     *
     * Textual features. some examples would be the brand/maker of a product, or
     * country of a customer. Numerical features. Some examples would be the
     * height/weight of a product, or age of a customer.
     *
     * For example: `{ "vendor": {"text": ["vendor123", "vendor456"]},
     * "lengths_cm": {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]}
     * }`.
     *
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     *
     * * Max entries count: 200.
     * * The key must be a UTF-8 encoded string with a length limit of 128
     *   characters.
     * * For indexable attribute, the key must match the pattern:
     *   `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example, `key0LikeThis` or
     *   `KEY_1_LIKE_THIS`.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a non-empty UTF-8 encoded string with a
     *   length limit of 256 characters.
     * * For number attributes, at most 400 values are allowed.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 12;</code>
     */
    public com.google.cloud.retail.v2.CustomAttribute.Builder putAttributesBuilderIfAbsent(
        java.lang.String key) {
      java.util.Map<java.lang.String, com.google.cloud.retail.v2.CustomAttributeOrBuilder>
          builderMap = internalGetMutableAttributes().ensureBuilderMap();
      com.google.cloud.retail.v2.CustomAttributeOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.retail.v2.CustomAttribute.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.retail.v2.CustomAttribute) {
        entry = ((com.google.cloud.retail.v2.CustomAttribute) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.retail.v2.CustomAttribute.Builder) entry;
    }

    private com.google.protobuf.LazyStringArrayList tags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTagsIsMutable() {
      if (!tags_.isModifiable()) {
        tags_ = new com.google.protobuf.LazyStringArrayList(tags_);
      }
      bitField0_ |= 0x00004000;
    }
    /**
     *
     *
     * <pre>
     * Custom tags associated with the product.
     *
     * At most 250 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. This value must be a UTF-8
     * encoded string with a length limit of 1,000 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * This tag can be used for filtering recommendation results by passing the
     * tag as part of the
     * [PredictRequest.filter][google.cloud.retail.v2.PredictRequest.filter].
     *
     * Corresponding properties: Google Merchant Center property
     * [custom_label_0–4](https://support.google.com/merchants/answer/6324473).
     * </pre>
     *
     * <code>repeated string tags = 13;</code>
     *
     * @return A list containing the tags.
     */
    public com.google.protobuf.ProtocolStringList getTagsList() {
      tags_.makeImmutable();
      return tags_;
    }
    /**
     *
     *
     * <pre>
     * Custom tags associated with the product.
     *
     * At most 250 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. This value must be a UTF-8
     * encoded string with a length limit of 1,000 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * This tag can be used for filtering recommendation results by passing the
     * tag as part of the
     * [PredictRequest.filter][google.cloud.retail.v2.PredictRequest.filter].
     *
     * Corresponding properties: Google Merchant Center property
     * [custom_label_0–4](https://support.google.com/merchants/answer/6324473).
     * </pre>
     *
     * <code>repeated string tags = 13;</code>
     *
     * @return The count of tags.
     */
    public int getTagsCount() {
      return tags_.size();
    }
    /**
     *
     *
     * <pre>
     * Custom tags associated with the product.
     *
     * At most 250 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. This value must be a UTF-8
     * encoded string with a length limit of 1,000 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * This tag can be used for filtering recommendation results by passing the
     * tag as part of the
     * [PredictRequest.filter][google.cloud.retail.v2.PredictRequest.filter].
     *
     * Corresponding properties: Google Merchant Center property
     * [custom_label_0–4](https://support.google.com/merchants/answer/6324473).
     * </pre>
     *
     * <code>repeated string tags = 13;</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    public java.lang.String getTags(int index) {
      return tags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Custom tags associated with the product.
     *
     * At most 250 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. This value must be a UTF-8
     * encoded string with a length limit of 1,000 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * This tag can be used for filtering recommendation results by passing the
     * tag as part of the
     * [PredictRequest.filter][google.cloud.retail.v2.PredictRequest.filter].
     *
     * Corresponding properties: Google Merchant Center property
     * [custom_label_0–4](https://support.google.com/merchants/answer/6324473).
     * </pre>
     *
     * <code>repeated string tags = 13;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    public com.google.protobuf.ByteString getTagsBytes(int index) {
      return tags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Custom tags associated with the product.
     *
     * At most 250 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. This value must be a UTF-8
     * encoded string with a length limit of 1,000 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * This tag can be used for filtering recommendation results by passing the
     * tag as part of the
     * [PredictRequest.filter][google.cloud.retail.v2.PredictRequest.filter].
     *
     * Corresponding properties: Google Merchant Center property
     * [custom_label_0–4](https://support.google.com/merchants/answer/6324473).
     * </pre>
     *
     * <code>repeated string tags = 13;</code>
     *
     * @param index The index to set the value at.
     * @param value The tags to set.
     * @return This builder for chaining.
     */
    public Builder setTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.set(index, value);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom tags associated with the product.
     *
     * At most 250 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. This value must be a UTF-8
     * encoded string with a length limit of 1,000 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * This tag can be used for filtering recommendation results by passing the
     * tag as part of the
     * [PredictRequest.filter][google.cloud.retail.v2.PredictRequest.filter].
     *
     * Corresponding properties: Google Merchant Center property
     * [custom_label_0–4](https://support.google.com/merchants/answer/6324473).
     * </pre>
     *
     * <code>repeated string tags = 13;</code>
     *
     * @param value The tags to add.
     * @return This builder for chaining.
     */
    public Builder addTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.add(value);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom tags associated with the product.
     *
     * At most 250 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. This value must be a UTF-8
     * encoded string with a length limit of 1,000 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * This tag can be used for filtering recommendation results by passing the
     * tag as part of the
     * [PredictRequest.filter][google.cloud.retail.v2.PredictRequest.filter].
     *
     * Corresponding properties: Google Merchant Center property
     * [custom_label_0–4](https://support.google.com/merchants/answer/6324473).
     * </pre>
     *
     * <code>repeated string tags = 13;</code>
     *
     * @param values The tags to add.
     * @return This builder for chaining.
     */
    public Builder addAllTags(java.lang.Iterable<java.lang.String> values) {
      ensureTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tags_);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom tags associated with the product.
     *
     * At most 250 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. This value must be a UTF-8
     * encoded string with a length limit of 1,000 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * This tag can be used for filtering recommendation results by passing the
     * tag as part of the
     * [PredictRequest.filter][google.cloud.retail.v2.PredictRequest.filter].
     *
     * Corresponding properties: Google Merchant Center property
     * [custom_label_0–4](https://support.google.com/merchants/answer/6324473).
     * </pre>
     *
     * <code>repeated string tags = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTags() {
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00004000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom tags associated with the product.
     *
     * At most 250 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. This value must be a UTF-8
     * encoded string with a length limit of 1,000 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * This tag can be used for filtering recommendation results by passing the
     * tag as part of the
     * [PredictRequest.filter][google.cloud.retail.v2.PredictRequest.filter].
     *
     * Corresponding properties: Google Merchant Center property
     * [custom_label_0–4](https://support.google.com/merchants/answer/6324473).
     * </pre>
     *
     * <code>repeated string tags = 13;</code>
     *
     * @param value The bytes of the tags to add.
     * @return This builder for chaining.
     */
    public Builder addTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTagsIsMutable();
      tags_.add(value);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private com.google.cloud.retail.v2.PriceInfo priceInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2.PriceInfo,
            com.google.cloud.retail.v2.PriceInfo.Builder,
            com.google.cloud.retail.v2.PriceInfoOrBuilder>
        priceInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Product price and cost information.
     *
     * Corresponding properties: Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371).
     * </pre>
     *
     * <code>.google.cloud.retail.v2.PriceInfo price_info = 14;</code>
     *
     * @return Whether the priceInfo field is set.
     */
    public boolean hasPriceInfo() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Product price and cost information.
     *
     * Corresponding properties: Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371).
     * </pre>
     *
     * <code>.google.cloud.retail.v2.PriceInfo price_info = 14;</code>
     *
     * @return The priceInfo.
     */
    public com.google.cloud.retail.v2.PriceInfo getPriceInfo() {
      if (priceInfoBuilder_ == null) {
        return priceInfo_ == null
            ? com.google.cloud.retail.v2.PriceInfo.getDefaultInstance()
            : priceInfo_;
      } else {
        return priceInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Product price and cost information.
     *
     * Corresponding properties: Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371).
     * </pre>
     *
     * <code>.google.cloud.retail.v2.PriceInfo price_info = 14;</code>
     */
    public Builder setPriceInfo(com.google.cloud.retail.v2.PriceInfo value) {
      if (priceInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        priceInfo_ = value;
      } else {
        priceInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Product price and cost information.
     *
     * Corresponding properties: Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371).
     * </pre>
     *
     * <code>.google.cloud.retail.v2.PriceInfo price_info = 14;</code>
     */
    public Builder setPriceInfo(com.google.cloud.retail.v2.PriceInfo.Builder builderForValue) {
      if (priceInfoBuilder_ == null) {
        priceInfo_ = builderForValue.build();
      } else {
        priceInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Product price and cost information.
     *
     * Corresponding properties: Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371).
     * </pre>
     *
     * <code>.google.cloud.retail.v2.PriceInfo price_info = 14;</code>
     */
    public Builder mergePriceInfo(com.google.cloud.retail.v2.PriceInfo value) {
      if (priceInfoBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && priceInfo_ != null
            && priceInfo_ != com.google.cloud.retail.v2.PriceInfo.getDefaultInstance()) {
          getPriceInfoBuilder().mergeFrom(value);
        } else {
          priceInfo_ = value;
        }
      } else {
        priceInfoBuilder_.mergeFrom(value);
      }
      if (priceInfo_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Product price and cost information.
     *
     * Corresponding properties: Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371).
     * </pre>
     *
     * <code>.google.cloud.retail.v2.PriceInfo price_info = 14;</code>
     */
    public Builder clearPriceInfo() {
      bitField0_ = (bitField0_ & ~0x00008000);
      priceInfo_ = null;
      if (priceInfoBuilder_ != null) {
        priceInfoBuilder_.dispose();
        priceInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Product price and cost information.
     *
     * Corresponding properties: Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371).
     * </pre>
     *
     * <code>.google.cloud.retail.v2.PriceInfo price_info = 14;</code>
     */
    public com.google.cloud.retail.v2.PriceInfo.Builder getPriceInfoBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getPriceInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Product price and cost information.
     *
     * Corresponding properties: Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371).
     * </pre>
     *
     * <code>.google.cloud.retail.v2.PriceInfo price_info = 14;</code>
     */
    public com.google.cloud.retail.v2.PriceInfoOrBuilder getPriceInfoOrBuilder() {
      if (priceInfoBuilder_ != null) {
        return priceInfoBuilder_.getMessageOrBuilder();
      } else {
        return priceInfo_ == null
            ? com.google.cloud.retail.v2.PriceInfo.getDefaultInstance()
            : priceInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Product price and cost information.
     *
     * Corresponding properties: Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371).
     * </pre>
     *
     * <code>.google.cloud.retail.v2.PriceInfo price_info = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2.PriceInfo,
            com.google.cloud.retail.v2.PriceInfo.Builder,
            com.google.cloud.retail.v2.PriceInfoOrBuilder>
        getPriceInfoFieldBuilder() {
      if (priceInfoBuilder_ == null) {
        priceInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2.PriceInfo,
                com.google.cloud.retail.v2.PriceInfo.Builder,
                com.google.cloud.retail.v2.PriceInfoOrBuilder>(
                getPriceInfo(), getParentForChildren(), isClean());
        priceInfo_ = null;
      }
      return priceInfoBuilder_;
    }

    private com.google.cloud.retail.v2.Rating rating_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2.Rating,
            com.google.cloud.retail.v2.Rating.Builder,
            com.google.cloud.retail.v2.RatingOrBuilder>
        ratingBuilder_;
    /**
     *
     *
     * <pre>
     * The rating of this product.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Rating rating = 15;</code>
     *
     * @return Whether the rating field is set.
     */
    public boolean hasRating() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The rating of this product.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Rating rating = 15;</code>
     *
     * @return The rating.
     */
    public com.google.cloud.retail.v2.Rating getRating() {
      if (ratingBuilder_ == null) {
        return rating_ == null ? com.google.cloud.retail.v2.Rating.getDefaultInstance() : rating_;
      } else {
        return ratingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The rating of this product.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Rating rating = 15;</code>
     */
    public Builder setRating(com.google.cloud.retail.v2.Rating value) {
      if (ratingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rating_ = value;
      } else {
        ratingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The rating of this product.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Rating rating = 15;</code>
     */
    public Builder setRating(com.google.cloud.retail.v2.Rating.Builder builderForValue) {
      if (ratingBuilder_ == null) {
        rating_ = builderForValue.build();
      } else {
        ratingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The rating of this product.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Rating rating = 15;</code>
     */
    public Builder mergeRating(com.google.cloud.retail.v2.Rating value) {
      if (ratingBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && rating_ != null
            && rating_ != com.google.cloud.retail.v2.Rating.getDefaultInstance()) {
          getRatingBuilder().mergeFrom(value);
        } else {
          rating_ = value;
        }
      } else {
        ratingBuilder_.mergeFrom(value);
      }
      if (rating_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The rating of this product.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Rating rating = 15;</code>
     */
    public Builder clearRating() {
      bitField0_ = (bitField0_ & ~0x00010000);
      rating_ = null;
      if (ratingBuilder_ != null) {
        ratingBuilder_.dispose();
        ratingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The rating of this product.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Rating rating = 15;</code>
     */
    public com.google.cloud.retail.v2.Rating.Builder getRatingBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getRatingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The rating of this product.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Rating rating = 15;</code>
     */
    public com.google.cloud.retail.v2.RatingOrBuilder getRatingOrBuilder() {
      if (ratingBuilder_ != null) {
        return ratingBuilder_.getMessageOrBuilder();
      } else {
        return rating_ == null ? com.google.cloud.retail.v2.Rating.getDefaultInstance() : rating_;
      }
    }
    /**
     *
     *
     * <pre>
     * The rating of this product.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Rating rating = 15;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2.Rating,
            com.google.cloud.retail.v2.Rating.Builder,
            com.google.cloud.retail.v2.RatingOrBuilder>
        getRatingFieldBuilder() {
      if (ratingBuilder_ == null) {
        ratingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2.Rating,
                com.google.cloud.retail.v2.Rating.Builder,
                com.google.cloud.retail.v2.RatingOrBuilder>(
                getRating(), getParentForChildren(), isClean());
        rating_ = null;
      }
      return ratingBuilder_;
    }

    private com.google.protobuf.Timestamp availableTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        availableTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The timestamp when this [Product][google.cloud.retail.v2.Product] becomes
     * available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
     * that this is only applicable to
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
     * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp available_time = 18;</code>
     *
     * @return Whether the availableTime field is set.
     */
    public boolean hasAvailableTime() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The timestamp when this [Product][google.cloud.retail.v2.Product] becomes
     * available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
     * that this is only applicable to
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
     * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp available_time = 18;</code>
     *
     * @return The availableTime.
     */
    public com.google.protobuf.Timestamp getAvailableTime() {
      if (availableTimeBuilder_ == null) {
        return availableTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : availableTime_;
      } else {
        return availableTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp when this [Product][google.cloud.retail.v2.Product] becomes
     * available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
     * that this is only applicable to
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
     * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp available_time = 18;</code>
     */
    public Builder setAvailableTime(com.google.protobuf.Timestamp value) {
      if (availableTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        availableTime_ = value;
      } else {
        availableTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when this [Product][google.cloud.retail.v2.Product] becomes
     * available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
     * that this is only applicable to
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
     * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp available_time = 18;</code>
     */
    public Builder setAvailableTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (availableTimeBuilder_ == null) {
        availableTime_ = builderForValue.build();
      } else {
        availableTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when this [Product][google.cloud.retail.v2.Product] becomes
     * available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
     * that this is only applicable to
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
     * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp available_time = 18;</code>
     */
    public Builder mergeAvailableTime(com.google.protobuf.Timestamp value) {
      if (availableTimeBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)
            && availableTime_ != null
            && availableTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getAvailableTimeBuilder().mergeFrom(value);
        } else {
          availableTime_ = value;
        }
      } else {
        availableTimeBuilder_.mergeFrom(value);
      }
      if (availableTime_ != null) {
        bitField0_ |= 0x00020000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when this [Product][google.cloud.retail.v2.Product] becomes
     * available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
     * that this is only applicable to
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
     * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp available_time = 18;</code>
     */
    public Builder clearAvailableTime() {
      bitField0_ = (bitField0_ & ~0x00020000);
      availableTime_ = null;
      if (availableTimeBuilder_ != null) {
        availableTimeBuilder_.dispose();
        availableTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when this [Product][google.cloud.retail.v2.Product] becomes
     * available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
     * that this is only applicable to
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
     * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp available_time = 18;</code>
     */
    public com.google.protobuf.Timestamp.Builder getAvailableTimeBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getAvailableTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The timestamp when this [Product][google.cloud.retail.v2.Product] becomes
     * available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
     * that this is only applicable to
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
     * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp available_time = 18;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getAvailableTimeOrBuilder() {
      if (availableTimeBuilder_ != null) {
        return availableTimeBuilder_.getMessageOrBuilder();
      } else {
        return availableTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : availableTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp when this [Product][google.cloud.retail.v2.Product] becomes
     * available for
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
     * that this is only applicable to
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
     * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp available_time = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getAvailableTimeFieldBuilder() {
      if (availableTimeBuilder_ == null) {
        availableTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getAvailableTime(), getParentForChildren(), isClean());
        availableTime_ = null;
      }
      return availableTimeBuilder_;
    }

    private int availability_ = 0;
    /**
     *
     *
     * <pre>
     * The online availability of the [Product][google.cloud.retail.v2.Product].
     * Default to
     * [Availability.IN_STOCK][google.cloud.retail.v2.Product.Availability.IN_STOCK].
     *
     * Corresponding properties: Google Merchant Center property
     * [availability](https://support.google.com/merchants/answer/6324448).
     * Schema.org property [Offer.availability](https://schema.org/availability).
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Product.Availability availability = 19;</code>
     *
     * @return The enum numeric value on the wire for availability.
     */
    @java.lang.Override
    public int getAvailabilityValue() {
      return availability_;
    }
    /**
     *
     *
     * <pre>
     * The online availability of the [Product][google.cloud.retail.v2.Product].
     * Default to
     * [Availability.IN_STOCK][google.cloud.retail.v2.Product.Availability.IN_STOCK].
     *
     * Corresponding properties: Google Merchant Center property
     * [availability](https://support.google.com/merchants/answer/6324448).
     * Schema.org property [Offer.availability](https://schema.org/availability).
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Product.Availability availability = 19;</code>
     *
     * @param value The enum numeric value on the wire for availability to set.
     * @return This builder for chaining.
     */
    public Builder setAvailabilityValue(int value) {
      availability_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The online availability of the [Product][google.cloud.retail.v2.Product].
     * Default to
     * [Availability.IN_STOCK][google.cloud.retail.v2.Product.Availability.IN_STOCK].
     *
     * Corresponding properties: Google Merchant Center property
     * [availability](https://support.google.com/merchants/answer/6324448).
     * Schema.org property [Offer.availability](https://schema.org/availability).
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Product.Availability availability = 19;</code>
     *
     * @return The availability.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.Product.Availability getAvailability() {
      com.google.cloud.retail.v2.Product.Availability result =
          com.google.cloud.retail.v2.Product.Availability.forNumber(availability_);
      return result == null ? com.google.cloud.retail.v2.Product.Availability.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The online availability of the [Product][google.cloud.retail.v2.Product].
     * Default to
     * [Availability.IN_STOCK][google.cloud.retail.v2.Product.Availability.IN_STOCK].
     *
     * Corresponding properties: Google Merchant Center property
     * [availability](https://support.google.com/merchants/answer/6324448).
     * Schema.org property [Offer.availability](https://schema.org/availability).
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Product.Availability availability = 19;</code>
     *
     * @param value The availability to set.
     * @return This builder for chaining.
     */
    public Builder setAvailability(com.google.cloud.retail.v2.Product.Availability value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00040000;
      availability_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The online availability of the [Product][google.cloud.retail.v2.Product].
     * Default to
     * [Availability.IN_STOCK][google.cloud.retail.v2.Product.Availability.IN_STOCK].
     *
     * Corresponding properties: Google Merchant Center property
     * [availability](https://support.google.com/merchants/answer/6324448).
     * Schema.org property [Offer.availability](https://schema.org/availability).
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Product.Availability availability = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAvailability() {
      bitField0_ = (bitField0_ & ~0x00040000);
      availability_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Int32Value availableQuantity_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int32Value,
            com.google.protobuf.Int32Value.Builder,
            com.google.protobuf.Int32ValueOrBuilder>
        availableQuantityBuilder_;
    /**
     *
     *
     * <pre>
     * The available quantity of the item.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value available_quantity = 20;</code>
     *
     * @return Whether the availableQuantity field is set.
     */
    public boolean hasAvailableQuantity() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The available quantity of the item.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value available_quantity = 20;</code>
     *
     * @return The availableQuantity.
     */
    public com.google.protobuf.Int32Value getAvailableQuantity() {
      if (availableQuantityBuilder_ == null) {
        return availableQuantity_ == null
            ? com.google.protobuf.Int32Value.getDefaultInstance()
            : availableQuantity_;
      } else {
        return availableQuantityBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The available quantity of the item.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value available_quantity = 20;</code>
     */
    public Builder setAvailableQuantity(com.google.protobuf.Int32Value value) {
      if (availableQuantityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        availableQuantity_ = value;
      } else {
        availableQuantityBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The available quantity of the item.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value available_quantity = 20;</code>
     */
    public Builder setAvailableQuantity(com.google.protobuf.Int32Value.Builder builderForValue) {
      if (availableQuantityBuilder_ == null) {
        availableQuantity_ = builderForValue.build();
      } else {
        availableQuantityBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The available quantity of the item.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value available_quantity = 20;</code>
     */
    public Builder mergeAvailableQuantity(com.google.protobuf.Int32Value value) {
      if (availableQuantityBuilder_ == null) {
        if (((bitField0_ & 0x00080000) != 0)
            && availableQuantity_ != null
            && availableQuantity_ != com.google.protobuf.Int32Value.getDefaultInstance()) {
          getAvailableQuantityBuilder().mergeFrom(value);
        } else {
          availableQuantity_ = value;
        }
      } else {
        availableQuantityBuilder_.mergeFrom(value);
      }
      if (availableQuantity_ != null) {
        bitField0_ |= 0x00080000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The available quantity of the item.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value available_quantity = 20;</code>
     */
    public Builder clearAvailableQuantity() {
      bitField0_ = (bitField0_ & ~0x00080000);
      availableQuantity_ = null;
      if (availableQuantityBuilder_ != null) {
        availableQuantityBuilder_.dispose();
        availableQuantityBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The available quantity of the item.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value available_quantity = 20;</code>
     */
    public com.google.protobuf.Int32Value.Builder getAvailableQuantityBuilder() {
      bitField0_ |= 0x00080000;
      onChanged();
      return getAvailableQuantityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The available quantity of the item.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value available_quantity = 20;</code>
     */
    public com.google.protobuf.Int32ValueOrBuilder getAvailableQuantityOrBuilder() {
      if (availableQuantityBuilder_ != null) {
        return availableQuantityBuilder_.getMessageOrBuilder();
      } else {
        return availableQuantity_ == null
            ? com.google.protobuf.Int32Value.getDefaultInstance()
            : availableQuantity_;
      }
    }
    /**
     *
     *
     * <pre>
     * The available quantity of the item.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value available_quantity = 20;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int32Value,
            com.google.protobuf.Int32Value.Builder,
            com.google.protobuf.Int32ValueOrBuilder>
        getAvailableQuantityFieldBuilder() {
      if (availableQuantityBuilder_ == null) {
        availableQuantityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int32Value,
                com.google.protobuf.Int32Value.Builder,
                com.google.protobuf.Int32ValueOrBuilder>(
                getAvailableQuantity(), getParentForChildren(), isClean());
        availableQuantity_ = null;
      }
      return availableQuantityBuilder_;
    }

    private java.util.List<com.google.cloud.retail.v2.FulfillmentInfo> fulfillmentInfo_ =
        java.util.Collections.emptyList();

    private void ensureFulfillmentInfoIsMutable() {
      if (!((bitField0_ & 0x00100000) != 0)) {
        fulfillmentInfo_ =
            new java.util.ArrayList<com.google.cloud.retail.v2.FulfillmentInfo>(fulfillmentInfo_);
        bitField0_ |= 0x00100000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2.FulfillmentInfo,
            com.google.cloud.retail.v2.FulfillmentInfo.Builder,
            com.google.cloud.retail.v2.FulfillmentInfoOrBuilder>
        fulfillmentInfoBuilder_;

    /**
     *
     *
     * <pre>
     * Fulfillment information, such as the store IDs for in-store pickup or
     * region IDs for different shipping methods.
     *
     * All the elements must have distinct
     * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
     * Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
     */
    public java.util.List<com.google.cloud.retail.v2.FulfillmentInfo> getFulfillmentInfoList() {
      if (fulfillmentInfoBuilder_ == null) {
        return java.util.Collections.unmodifiableList(fulfillmentInfo_);
      } else {
        return fulfillmentInfoBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Fulfillment information, such as the store IDs for in-store pickup or
     * region IDs for different shipping methods.
     *
     * All the elements must have distinct
     * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
     * Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
     */
    public int getFulfillmentInfoCount() {
      if (fulfillmentInfoBuilder_ == null) {
        return fulfillmentInfo_.size();
      } else {
        return fulfillmentInfoBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Fulfillment information, such as the store IDs for in-store pickup or
     * region IDs for different shipping methods.
     *
     * All the elements must have distinct
     * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
     * Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
     */
    public com.google.cloud.retail.v2.FulfillmentInfo getFulfillmentInfo(int index) {
      if (fulfillmentInfoBuilder_ == null) {
        return fulfillmentInfo_.get(index);
      } else {
        return fulfillmentInfoBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Fulfillment information, such as the store IDs for in-store pickup or
     * region IDs for different shipping methods.
     *
     * All the elements must have distinct
     * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
     * Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
     */
    public Builder setFulfillmentInfo(int index, com.google.cloud.retail.v2.FulfillmentInfo value) {
      if (fulfillmentInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFulfillmentInfoIsMutable();
        fulfillmentInfo_.set(index, value);
        onChanged();
      } else {
        fulfillmentInfoBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fulfillment information, such as the store IDs for in-store pickup or
     * region IDs for different shipping methods.
     *
     * All the elements must have distinct
     * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
     * Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
     */
    public Builder setFulfillmentInfo(
        int index, com.google.cloud.retail.v2.FulfillmentInfo.Builder builderForValue) {
      if (fulfillmentInfoBuilder_ == null) {
        ensureFulfillmentInfoIsMutable();
        fulfillmentInfo_.set(index, builderForValue.build());
        onChanged();
      } else {
        fulfillmentInfoBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fulfillment information, such as the store IDs for in-store pickup or
     * region IDs for different shipping methods.
     *
     * All the elements must have distinct
     * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
     * Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
     */
    public Builder addFulfillmentInfo(com.google.cloud.retail.v2.FulfillmentInfo value) {
      if (fulfillmentInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFulfillmentInfoIsMutable();
        fulfillmentInfo_.add(value);
        onChanged();
      } else {
        fulfillmentInfoBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fulfillment information, such as the store IDs for in-store pickup or
     * region IDs for different shipping methods.
     *
     * All the elements must have distinct
     * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
     * Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
     */
    public Builder addFulfillmentInfo(int index, com.google.cloud.retail.v2.FulfillmentInfo value) {
      if (fulfillmentInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFulfillmentInfoIsMutable();
        fulfillmentInfo_.add(index, value);
        onChanged();
      } else {
        fulfillmentInfoBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fulfillment information, such as the store IDs for in-store pickup or
     * region IDs for different shipping methods.
     *
     * All the elements must have distinct
     * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
     * Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
     */
    public Builder addFulfillmentInfo(
        com.google.cloud.retail.v2.FulfillmentInfo.Builder builderForValue) {
      if (fulfillmentInfoBuilder_ == null) {
        ensureFulfillmentInfoIsMutable();
        fulfillmentInfo_.add(builderForValue.build());
        onChanged();
      } else {
        fulfillmentInfoBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fulfillment information, such as the store IDs for in-store pickup or
     * region IDs for different shipping methods.
     *
     * All the elements must have distinct
     * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
     * Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
     */
    public Builder addFulfillmentInfo(
        int index, com.google.cloud.retail.v2.FulfillmentInfo.Builder builderForValue) {
      if (fulfillmentInfoBuilder_ == null) {
        ensureFulfillmentInfoIsMutable();
        fulfillmentInfo_.add(index, builderForValue.build());
        onChanged();
      } else {
        fulfillmentInfoBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fulfillment information, such as the store IDs for in-store pickup or
     * region IDs for different shipping methods.
     *
     * All the elements must have distinct
     * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
     * Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
     */
    public Builder addAllFulfillmentInfo(
        java.lang.Iterable<? extends com.google.cloud.retail.v2.FulfillmentInfo> values) {
      if (fulfillmentInfoBuilder_ == null) {
        ensureFulfillmentInfoIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fulfillmentInfo_);
        onChanged();
      } else {
        fulfillmentInfoBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fulfillment information, such as the store IDs for in-store pickup or
     * region IDs for different shipping methods.
     *
     * All the elements must have distinct
     * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
     * Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
     */
    public Builder clearFulfillmentInfo() {
      if (fulfillmentInfoBuilder_ == null) {
        fulfillmentInfo_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00100000);
        onChanged();
      } else {
        fulfillmentInfoBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fulfillment information, such as the store IDs for in-store pickup or
     * region IDs for different shipping methods.
     *
     * All the elements must have distinct
     * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
     * Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
     */
    public Builder removeFulfillmentInfo(int index) {
      if (fulfillmentInfoBuilder_ == null) {
        ensureFulfillmentInfoIsMutable();
        fulfillmentInfo_.remove(index);
        onChanged();
      } else {
        fulfillmentInfoBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fulfillment information, such as the store IDs for in-store pickup or
     * region IDs for different shipping methods.
     *
     * All the elements must have distinct
     * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
     * Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
     */
    public com.google.cloud.retail.v2.FulfillmentInfo.Builder getFulfillmentInfoBuilder(int index) {
      return getFulfillmentInfoFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Fulfillment information, such as the store IDs for in-store pickup or
     * region IDs for different shipping methods.
     *
     * All the elements must have distinct
     * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
     * Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
     */
    public com.google.cloud.retail.v2.FulfillmentInfoOrBuilder getFulfillmentInfoOrBuilder(
        int index) {
      if (fulfillmentInfoBuilder_ == null) {
        return fulfillmentInfo_.get(index);
      } else {
        return fulfillmentInfoBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Fulfillment information, such as the store IDs for in-store pickup or
     * region IDs for different shipping methods.
     *
     * All the elements must have distinct
     * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
     * Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
     */
    public java.util.List<? extends com.google.cloud.retail.v2.FulfillmentInfoOrBuilder>
        getFulfillmentInfoOrBuilderList() {
      if (fulfillmentInfoBuilder_ != null) {
        return fulfillmentInfoBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(fulfillmentInfo_);
      }
    }
    /**
     *
     *
     * <pre>
     * Fulfillment information, such as the store IDs for in-store pickup or
     * region IDs for different shipping methods.
     *
     * All the elements must have distinct
     * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
     * Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
     */
    public com.google.cloud.retail.v2.FulfillmentInfo.Builder addFulfillmentInfoBuilder() {
      return getFulfillmentInfoFieldBuilder()
          .addBuilder(com.google.cloud.retail.v2.FulfillmentInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Fulfillment information, such as the store IDs for in-store pickup or
     * region IDs for different shipping methods.
     *
     * All the elements must have distinct
     * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
     * Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
     */
    public com.google.cloud.retail.v2.FulfillmentInfo.Builder addFulfillmentInfoBuilder(int index) {
      return getFulfillmentInfoFieldBuilder()
          .addBuilder(index, com.google.cloud.retail.v2.FulfillmentInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Fulfillment information, such as the store IDs for in-store pickup or
     * region IDs for different shipping methods.
     *
     * All the elements must have distinct
     * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
     * Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
     */
    public java.util.List<com.google.cloud.retail.v2.FulfillmentInfo.Builder>
        getFulfillmentInfoBuilderList() {
      return getFulfillmentInfoFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2.FulfillmentInfo,
            com.google.cloud.retail.v2.FulfillmentInfo.Builder,
            com.google.cloud.retail.v2.FulfillmentInfoOrBuilder>
        getFulfillmentInfoFieldBuilder() {
      if (fulfillmentInfoBuilder_ == null) {
        fulfillmentInfoBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2.FulfillmentInfo,
                com.google.cloud.retail.v2.FulfillmentInfo.Builder,
                com.google.cloud.retail.v2.FulfillmentInfoOrBuilder>(
                fulfillmentInfo_,
                ((bitField0_ & 0x00100000) != 0),
                getParentForChildren(),
                isClean());
        fulfillmentInfo_ = null;
      }
      return fulfillmentInfoBuilder_;
    }

    private java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * Canonical URL directly linking to the product detail page.
     *
     * It is strongly recommended to provide a valid uri for the product,
     * otherwise the service performance could be significantly degraded.
     *
     * This field must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [link](https://support.google.com/merchants/answer/6324416). Schema.org
     * property [Offer.url](https://schema.org/url).
     * </pre>
     *
     * <code>string uri = 22;</code>
     *
     * @return The uri.
     */
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Canonical URL directly linking to the product detail page.
     *
     * It is strongly recommended to provide a valid uri for the product,
     * otherwise the service performance could be significantly degraded.
     *
     * This field must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [link](https://support.google.com/merchants/answer/6324416). Schema.org
     * property [Offer.url](https://schema.org/url).
     * </pre>
     *
     * <code>string uri = 22;</code>
     *
     * @return The bytes for uri.
     */
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Canonical URL directly linking to the product detail page.
     *
     * It is strongly recommended to provide a valid uri for the product,
     * otherwise the service performance could be significantly degraded.
     *
     * This field must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [link](https://support.google.com/merchants/answer/6324416). Schema.org
     * property [Offer.url](https://schema.org/url).
     * </pre>
     *
     * <code>string uri = 22;</code>
     *
     * @param value The uri to set.
     * @return This builder for chaining.
     */
    public Builder setUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uri_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Canonical URL directly linking to the product detail page.
     *
     * It is strongly recommended to provide a valid uri for the product,
     * otherwise the service performance could be significantly degraded.
     *
     * This field must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [link](https://support.google.com/merchants/answer/6324416). Schema.org
     * property [Offer.url](https://schema.org/url).
     * </pre>
     *
     * <code>string uri = 22;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUri() {
      uri_ = getDefaultInstance().getUri();
      bitField0_ = (bitField0_ & ~0x00200000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Canonical URL directly linking to the product detail page.
     *
     * It is strongly recommended to provide a valid uri for the product,
     * otherwise the service performance could be significantly degraded.
     *
     * This field must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [link](https://support.google.com/merchants/answer/6324416). Schema.org
     * property [Offer.url](https://schema.org/url).
     * </pre>
     *
     * <code>string uri = 22;</code>
     *
     * @param value The bytes for uri to set.
     * @return This builder for chaining.
     */
    public Builder setUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uri_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.retail.v2.Image> images_ =
        java.util.Collections.emptyList();

    private void ensureImagesIsMutable() {
      if (!((bitField0_ & 0x00400000) != 0)) {
        images_ = new java.util.ArrayList<com.google.cloud.retail.v2.Image>(images_);
        bitField0_ |= 0x00400000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2.Image,
            com.google.cloud.retail.v2.Image.Builder,
            com.google.cloud.retail.v2.ImageOrBuilder>
        imagesBuilder_;

    /**
     *
     *
     * <pre>
     * Product images for the product. We highly recommend putting the main
     * image first.
     *
     * A maximum of 300 images are allowed.
     *
     * Corresponding properties: Google Merchant Center property
     * [image_link](https://support.google.com/merchants/answer/6324350).
     * Schema.org property [Product.image](https://schema.org/image).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
     */
    public java.util.List<com.google.cloud.retail.v2.Image> getImagesList() {
      if (imagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(images_);
      } else {
        return imagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Product images for the product. We highly recommend putting the main
     * image first.
     *
     * A maximum of 300 images are allowed.
     *
     * Corresponding properties: Google Merchant Center property
     * [image_link](https://support.google.com/merchants/answer/6324350).
     * Schema.org property [Product.image](https://schema.org/image).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
     */
    public int getImagesCount() {
      if (imagesBuilder_ == null) {
        return images_.size();
      } else {
        return imagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Product images for the product. We highly recommend putting the main
     * image first.
     *
     * A maximum of 300 images are allowed.
     *
     * Corresponding properties: Google Merchant Center property
     * [image_link](https://support.google.com/merchants/answer/6324350).
     * Schema.org property [Product.image](https://schema.org/image).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
     */
    public com.google.cloud.retail.v2.Image getImages(int index) {
      if (imagesBuilder_ == null) {
        return images_.get(index);
      } else {
        return imagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Product images for the product. We highly recommend putting the main
     * image first.
     *
     * A maximum of 300 images are allowed.
     *
     * Corresponding properties: Google Merchant Center property
     * [image_link](https://support.google.com/merchants/answer/6324350).
     * Schema.org property [Product.image](https://schema.org/image).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
     */
    public Builder setImages(int index, com.google.cloud.retail.v2.Image value) {
      if (imagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureImagesIsMutable();
        images_.set(index, value);
        onChanged();
      } else {
        imagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Product images for the product. We highly recommend putting the main
     * image first.
     *
     * A maximum of 300 images are allowed.
     *
     * Corresponding properties: Google Merchant Center property
     * [image_link](https://support.google.com/merchants/answer/6324350).
     * Schema.org property [Product.image](https://schema.org/image).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
     */
    public Builder setImages(int index, com.google.cloud.retail.v2.Image.Builder builderForValue) {
      if (imagesBuilder_ == null) {
        ensureImagesIsMutable();
        images_.set(index, builderForValue.build());
        onChanged();
      } else {
        imagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Product images for the product. We highly recommend putting the main
     * image first.
     *
     * A maximum of 300 images are allowed.
     *
     * Corresponding properties: Google Merchant Center property
     * [image_link](https://support.google.com/merchants/answer/6324350).
     * Schema.org property [Product.image](https://schema.org/image).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
     */
    public Builder addImages(com.google.cloud.retail.v2.Image value) {
      if (imagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureImagesIsMutable();
        images_.add(value);
        onChanged();
      } else {
        imagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Product images for the product. We highly recommend putting the main
     * image first.
     *
     * A maximum of 300 images are allowed.
     *
     * Corresponding properties: Google Merchant Center property
     * [image_link](https://support.google.com/merchants/answer/6324350).
     * Schema.org property [Product.image](https://schema.org/image).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
     */
    public Builder addImages(int index, com.google.cloud.retail.v2.Image value) {
      if (imagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureImagesIsMutable();
        images_.add(index, value);
        onChanged();
      } else {
        imagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Product images for the product. We highly recommend putting the main
     * image first.
     *
     * A maximum of 300 images are allowed.
     *
     * Corresponding properties: Google Merchant Center property
     * [image_link](https://support.google.com/merchants/answer/6324350).
     * Schema.org property [Product.image](https://schema.org/image).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
     */
    public Builder addImages(com.google.cloud.retail.v2.Image.Builder builderForValue) {
      if (imagesBuilder_ == null) {
        ensureImagesIsMutable();
        images_.add(builderForValue.build());
        onChanged();
      } else {
        imagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Product images for the product. We highly recommend putting the main
     * image first.
     *
     * A maximum of 300 images are allowed.
     *
     * Corresponding properties: Google Merchant Center property
     * [image_link](https://support.google.com/merchants/answer/6324350).
     * Schema.org property [Product.image](https://schema.org/image).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
     */
    public Builder addImages(int index, com.google.cloud.retail.v2.Image.Builder builderForValue) {
      if (imagesBuilder_ == null) {
        ensureImagesIsMutable();
        images_.add(index, builderForValue.build());
        onChanged();
      } else {
        imagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Product images for the product. We highly recommend putting the main
     * image first.
     *
     * A maximum of 300 images are allowed.
     *
     * Corresponding properties: Google Merchant Center property
     * [image_link](https://support.google.com/merchants/answer/6324350).
     * Schema.org property [Product.image](https://schema.org/image).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
     */
    public Builder addAllImages(
        java.lang.Iterable<? extends com.google.cloud.retail.v2.Image> values) {
      if (imagesBuilder_ == null) {
        ensureImagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, images_);
        onChanged();
      } else {
        imagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Product images for the product. We highly recommend putting the main
     * image first.
     *
     * A maximum of 300 images are allowed.
     *
     * Corresponding properties: Google Merchant Center property
     * [image_link](https://support.google.com/merchants/answer/6324350).
     * Schema.org property [Product.image](https://schema.org/image).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
     */
    public Builder clearImages() {
      if (imagesBuilder_ == null) {
        images_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00400000);
        onChanged();
      } else {
        imagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Product images for the product. We highly recommend putting the main
     * image first.
     *
     * A maximum of 300 images are allowed.
     *
     * Corresponding properties: Google Merchant Center property
     * [image_link](https://support.google.com/merchants/answer/6324350).
     * Schema.org property [Product.image](https://schema.org/image).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
     */
    public Builder removeImages(int index) {
      if (imagesBuilder_ == null) {
        ensureImagesIsMutable();
        images_.remove(index);
        onChanged();
      } else {
        imagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Product images for the product. We highly recommend putting the main
     * image first.
     *
     * A maximum of 300 images are allowed.
     *
     * Corresponding properties: Google Merchant Center property
     * [image_link](https://support.google.com/merchants/answer/6324350).
     * Schema.org property [Product.image](https://schema.org/image).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
     */
    public com.google.cloud.retail.v2.Image.Builder getImagesBuilder(int index) {
      return getImagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Product images for the product. We highly recommend putting the main
     * image first.
     *
     * A maximum of 300 images are allowed.
     *
     * Corresponding properties: Google Merchant Center property
     * [image_link](https://support.google.com/merchants/answer/6324350).
     * Schema.org property [Product.image](https://schema.org/image).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
     */
    public com.google.cloud.retail.v2.ImageOrBuilder getImagesOrBuilder(int index) {
      if (imagesBuilder_ == null) {
        return images_.get(index);
      } else {
        return imagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Product images for the product. We highly recommend putting the main
     * image first.
     *
     * A maximum of 300 images are allowed.
     *
     * Corresponding properties: Google Merchant Center property
     * [image_link](https://support.google.com/merchants/answer/6324350).
     * Schema.org property [Product.image](https://schema.org/image).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
     */
    public java.util.List<? extends com.google.cloud.retail.v2.ImageOrBuilder>
        getImagesOrBuilderList() {
      if (imagesBuilder_ != null) {
        return imagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(images_);
      }
    }
    /**
     *
     *
     * <pre>
     * Product images for the product. We highly recommend putting the main
     * image first.
     *
     * A maximum of 300 images are allowed.
     *
     * Corresponding properties: Google Merchant Center property
     * [image_link](https://support.google.com/merchants/answer/6324350).
     * Schema.org property [Product.image](https://schema.org/image).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
     */
    public com.google.cloud.retail.v2.Image.Builder addImagesBuilder() {
      return getImagesFieldBuilder()
          .addBuilder(com.google.cloud.retail.v2.Image.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Product images for the product. We highly recommend putting the main
     * image first.
     *
     * A maximum of 300 images are allowed.
     *
     * Corresponding properties: Google Merchant Center property
     * [image_link](https://support.google.com/merchants/answer/6324350).
     * Schema.org property [Product.image](https://schema.org/image).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
     */
    public com.google.cloud.retail.v2.Image.Builder addImagesBuilder(int index) {
      return getImagesFieldBuilder()
          .addBuilder(index, com.google.cloud.retail.v2.Image.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Product images for the product. We highly recommend putting the main
     * image first.
     *
     * A maximum of 300 images are allowed.
     *
     * Corresponding properties: Google Merchant Center property
     * [image_link](https://support.google.com/merchants/answer/6324350).
     * Schema.org property [Product.image](https://schema.org/image).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
     */
    public java.util.List<com.google.cloud.retail.v2.Image.Builder> getImagesBuilderList() {
      return getImagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2.Image,
            com.google.cloud.retail.v2.Image.Builder,
            com.google.cloud.retail.v2.ImageOrBuilder>
        getImagesFieldBuilder() {
      if (imagesBuilder_ == null) {
        imagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2.Image,
                com.google.cloud.retail.v2.Image.Builder,
                com.google.cloud.retail.v2.ImageOrBuilder>(
                images_, ((bitField0_ & 0x00400000) != 0), getParentForChildren(), isClean());
        images_ = null;
      }
      return imagesBuilder_;
    }

    private com.google.cloud.retail.v2.Audience audience_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2.Audience,
            com.google.cloud.retail.v2.Audience.Builder,
            com.google.cloud.retail.v2.AudienceOrBuilder>
        audienceBuilder_;
    /**
     *
     *
     * <pre>
     * The target group associated with a given audience (e.g. male, veterans,
     * car owners, musicians, etc.) of the product.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Audience audience = 24;</code>
     *
     * @return Whether the audience field is set.
     */
    public boolean hasAudience() {
      return ((bitField0_ & 0x00800000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The target group associated with a given audience (e.g. male, veterans,
     * car owners, musicians, etc.) of the product.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Audience audience = 24;</code>
     *
     * @return The audience.
     */
    public com.google.cloud.retail.v2.Audience getAudience() {
      if (audienceBuilder_ == null) {
        return audience_ == null
            ? com.google.cloud.retail.v2.Audience.getDefaultInstance()
            : audience_;
      } else {
        return audienceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The target group associated with a given audience (e.g. male, veterans,
     * car owners, musicians, etc.) of the product.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Audience audience = 24;</code>
     */
    public Builder setAudience(com.google.cloud.retail.v2.Audience value) {
      if (audienceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        audience_ = value;
      } else {
        audienceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target group associated with a given audience (e.g. male, veterans,
     * car owners, musicians, etc.) of the product.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Audience audience = 24;</code>
     */
    public Builder setAudience(com.google.cloud.retail.v2.Audience.Builder builderForValue) {
      if (audienceBuilder_ == null) {
        audience_ = builderForValue.build();
      } else {
        audienceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target group associated with a given audience (e.g. male, veterans,
     * car owners, musicians, etc.) of the product.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Audience audience = 24;</code>
     */
    public Builder mergeAudience(com.google.cloud.retail.v2.Audience value) {
      if (audienceBuilder_ == null) {
        if (((bitField0_ & 0x00800000) != 0)
            && audience_ != null
            && audience_ != com.google.cloud.retail.v2.Audience.getDefaultInstance()) {
          getAudienceBuilder().mergeFrom(value);
        } else {
          audience_ = value;
        }
      } else {
        audienceBuilder_.mergeFrom(value);
      }
      if (audience_ != null) {
        bitField0_ |= 0x00800000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target group associated with a given audience (e.g. male, veterans,
     * car owners, musicians, etc.) of the product.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Audience audience = 24;</code>
     */
    public Builder clearAudience() {
      bitField0_ = (bitField0_ & ~0x00800000);
      audience_ = null;
      if (audienceBuilder_ != null) {
        audienceBuilder_.dispose();
        audienceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target group associated with a given audience (e.g. male, veterans,
     * car owners, musicians, etc.) of the product.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Audience audience = 24;</code>
     */
    public com.google.cloud.retail.v2.Audience.Builder getAudienceBuilder() {
      bitField0_ |= 0x00800000;
      onChanged();
      return getAudienceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The target group associated with a given audience (e.g. male, veterans,
     * car owners, musicians, etc.) of the product.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Audience audience = 24;</code>
     */
    public com.google.cloud.retail.v2.AudienceOrBuilder getAudienceOrBuilder() {
      if (audienceBuilder_ != null) {
        return audienceBuilder_.getMessageOrBuilder();
      } else {
        return audience_ == null
            ? com.google.cloud.retail.v2.Audience.getDefaultInstance()
            : audience_;
      }
    }
    /**
     *
     *
     * <pre>
     * The target group associated with a given audience (e.g. male, veterans,
     * car owners, musicians, etc.) of the product.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Audience audience = 24;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2.Audience,
            com.google.cloud.retail.v2.Audience.Builder,
            com.google.cloud.retail.v2.AudienceOrBuilder>
        getAudienceFieldBuilder() {
      if (audienceBuilder_ == null) {
        audienceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2.Audience,
                com.google.cloud.retail.v2.Audience.Builder,
                com.google.cloud.retail.v2.AudienceOrBuilder>(
                getAudience(), getParentForChildren(), isClean());
        audience_ = null;
      }
      return audienceBuilder_;
    }

    private com.google.cloud.retail.v2.ColorInfo colorInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2.ColorInfo,
            com.google.cloud.retail.v2.ColorInfo.Builder,
            com.google.cloud.retail.v2.ColorInfoOrBuilder>
        colorInfoBuilder_;
    /**
     *
     *
     * <pre>
     * The color of the product.
     *
     * Corresponding properties: Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ColorInfo color_info = 25;</code>
     *
     * @return Whether the colorInfo field is set.
     */
    public boolean hasColorInfo() {
      return ((bitField0_ & 0x01000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The color of the product.
     *
     * Corresponding properties: Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ColorInfo color_info = 25;</code>
     *
     * @return The colorInfo.
     */
    public com.google.cloud.retail.v2.ColorInfo getColorInfo() {
      if (colorInfoBuilder_ == null) {
        return colorInfo_ == null
            ? com.google.cloud.retail.v2.ColorInfo.getDefaultInstance()
            : colorInfo_;
      } else {
        return colorInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The color of the product.
     *
     * Corresponding properties: Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ColorInfo color_info = 25;</code>
     */
    public Builder setColorInfo(com.google.cloud.retail.v2.ColorInfo value) {
      if (colorInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        colorInfo_ = value;
      } else {
        colorInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The color of the product.
     *
     * Corresponding properties: Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ColorInfo color_info = 25;</code>
     */
    public Builder setColorInfo(com.google.cloud.retail.v2.ColorInfo.Builder builderForValue) {
      if (colorInfoBuilder_ == null) {
        colorInfo_ = builderForValue.build();
      } else {
        colorInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The color of the product.
     *
     * Corresponding properties: Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ColorInfo color_info = 25;</code>
     */
    public Builder mergeColorInfo(com.google.cloud.retail.v2.ColorInfo value) {
      if (colorInfoBuilder_ == null) {
        if (((bitField0_ & 0x01000000) != 0)
            && colorInfo_ != null
            && colorInfo_ != com.google.cloud.retail.v2.ColorInfo.getDefaultInstance()) {
          getColorInfoBuilder().mergeFrom(value);
        } else {
          colorInfo_ = value;
        }
      } else {
        colorInfoBuilder_.mergeFrom(value);
      }
      if (colorInfo_ != null) {
        bitField0_ |= 0x01000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The color of the product.
     *
     * Corresponding properties: Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ColorInfo color_info = 25;</code>
     */
    public Builder clearColorInfo() {
      bitField0_ = (bitField0_ & ~0x01000000);
      colorInfo_ = null;
      if (colorInfoBuilder_ != null) {
        colorInfoBuilder_.dispose();
        colorInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The color of the product.
     *
     * Corresponding properties: Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ColorInfo color_info = 25;</code>
     */
    public com.google.cloud.retail.v2.ColorInfo.Builder getColorInfoBuilder() {
      bitField0_ |= 0x01000000;
      onChanged();
      return getColorInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The color of the product.
     *
     * Corresponding properties: Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ColorInfo color_info = 25;</code>
     */
    public com.google.cloud.retail.v2.ColorInfoOrBuilder getColorInfoOrBuilder() {
      if (colorInfoBuilder_ != null) {
        return colorInfoBuilder_.getMessageOrBuilder();
      } else {
        return colorInfo_ == null
            ? com.google.cloud.retail.v2.ColorInfo.getDefaultInstance()
            : colorInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * The color of the product.
     *
     * Corresponding properties: Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ColorInfo color_info = 25;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2.ColorInfo,
            com.google.cloud.retail.v2.ColorInfo.Builder,
            com.google.cloud.retail.v2.ColorInfoOrBuilder>
        getColorInfoFieldBuilder() {
      if (colorInfoBuilder_ == null) {
        colorInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2.ColorInfo,
                com.google.cloud.retail.v2.ColorInfo.Builder,
                com.google.cloud.retail.v2.ColorInfoOrBuilder>(
                getColorInfo(), getParentForChildren(), isClean());
        colorInfo_ = null;
      }
      return colorInfoBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList sizes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSizesIsMutable() {
      if (!sizes_.isModifiable()) {
        sizes_ = new com.google.protobuf.LazyStringArrayList(sizes_);
      }
      bitField0_ |= 0x02000000;
    }
    /**
     *
     *
     * <pre>
     * The size of the product. To represent different size systems or size types,
     * consider using this format: [[[size_system:]size_type:]size_value].
     *
     * For example, in "US:MENS:M", "US" represents size system; "MENS" represents
     * size type; "M" represents size value. In "GIRLS:27", size system is empty;
     * "GIRLS" represents size type; "27" represents size value. In "32 inches",
     * both size system and size type are empty, while size value is "32 inches".
     *
     * A maximum of 20 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [size](https://support.google.com/merchants/answer/6324492),
     * [size_type](https://support.google.com/merchants/answer/6324497), and
     * [size_system](https://support.google.com/merchants/answer/6324502).
     * Schema.org property [Product.size](https://schema.org/size).
     * </pre>
     *
     * <code>repeated string sizes = 26;</code>
     *
     * @return A list containing the sizes.
     */
    public com.google.protobuf.ProtocolStringList getSizesList() {
      sizes_.makeImmutable();
      return sizes_;
    }
    /**
     *
     *
     * <pre>
     * The size of the product. To represent different size systems or size types,
     * consider using this format: [[[size_system:]size_type:]size_value].
     *
     * For example, in "US:MENS:M", "US" represents size system; "MENS" represents
     * size type; "M" represents size value. In "GIRLS:27", size system is empty;
     * "GIRLS" represents size type; "27" represents size value. In "32 inches",
     * both size system and size type are empty, while size value is "32 inches".
     *
     * A maximum of 20 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [size](https://support.google.com/merchants/answer/6324492),
     * [size_type](https://support.google.com/merchants/answer/6324497), and
     * [size_system](https://support.google.com/merchants/answer/6324502).
     * Schema.org property [Product.size](https://schema.org/size).
     * </pre>
     *
     * <code>repeated string sizes = 26;</code>
     *
     * @return The count of sizes.
     */
    public int getSizesCount() {
      return sizes_.size();
    }
    /**
     *
     *
     * <pre>
     * The size of the product. To represent different size systems or size types,
     * consider using this format: [[[size_system:]size_type:]size_value].
     *
     * For example, in "US:MENS:M", "US" represents size system; "MENS" represents
     * size type; "M" represents size value. In "GIRLS:27", size system is empty;
     * "GIRLS" represents size type; "27" represents size value. In "32 inches",
     * both size system and size type are empty, while size value is "32 inches".
     *
     * A maximum of 20 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [size](https://support.google.com/merchants/answer/6324492),
     * [size_type](https://support.google.com/merchants/answer/6324497), and
     * [size_system](https://support.google.com/merchants/answer/6324502).
     * Schema.org property [Product.size](https://schema.org/size).
     * </pre>
     *
     * <code>repeated string sizes = 26;</code>
     *
     * @param index The index of the element to return.
     * @return The sizes at the given index.
     */
    public java.lang.String getSizes(int index) {
      return sizes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The size of the product. To represent different size systems or size types,
     * consider using this format: [[[size_system:]size_type:]size_value].
     *
     * For example, in "US:MENS:M", "US" represents size system; "MENS" represents
     * size type; "M" represents size value. In "GIRLS:27", size system is empty;
     * "GIRLS" represents size type; "27" represents size value. In "32 inches",
     * both size system and size type are empty, while size value is "32 inches".
     *
     * A maximum of 20 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [size](https://support.google.com/merchants/answer/6324492),
     * [size_type](https://support.google.com/merchants/answer/6324497), and
     * [size_system](https://support.google.com/merchants/answer/6324502).
     * Schema.org property [Product.size](https://schema.org/size).
     * </pre>
     *
     * <code>repeated string sizes = 26;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the sizes at the given index.
     */
    public com.google.protobuf.ByteString getSizesBytes(int index) {
      return sizes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The size of the product. To represent different size systems or size types,
     * consider using this format: [[[size_system:]size_type:]size_value].
     *
     * For example, in "US:MENS:M", "US" represents size system; "MENS" represents
     * size type; "M" represents size value. In "GIRLS:27", size system is empty;
     * "GIRLS" represents size type; "27" represents size value. In "32 inches",
     * both size system and size type are empty, while size value is "32 inches".
     *
     * A maximum of 20 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [size](https://support.google.com/merchants/answer/6324492),
     * [size_type](https://support.google.com/merchants/answer/6324497), and
     * [size_system](https://support.google.com/merchants/answer/6324502).
     * Schema.org property [Product.size](https://schema.org/size).
     * </pre>
     *
     * <code>repeated string sizes = 26;</code>
     *
     * @param index The index to set the value at.
     * @param value The sizes to set.
     * @return This builder for chaining.
     */
    public Builder setSizes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSizesIsMutable();
      sizes_.set(index, value);
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The size of the product. To represent different size systems or size types,
     * consider using this format: [[[size_system:]size_type:]size_value].
     *
     * For example, in "US:MENS:M", "US" represents size system; "MENS" represents
     * size type; "M" represents size value. In "GIRLS:27", size system is empty;
     * "GIRLS" represents size type; "27" represents size value. In "32 inches",
     * both size system and size type are empty, while size value is "32 inches".
     *
     * A maximum of 20 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [size](https://support.google.com/merchants/answer/6324492),
     * [size_type](https://support.google.com/merchants/answer/6324497), and
     * [size_system](https://support.google.com/merchants/answer/6324502).
     * Schema.org property [Product.size](https://schema.org/size).
     * </pre>
     *
     * <code>repeated string sizes = 26;</code>
     *
     * @param value The sizes to add.
     * @return This builder for chaining.
     */
    public Builder addSizes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSizesIsMutable();
      sizes_.add(value);
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The size of the product. To represent different size systems or size types,
     * consider using this format: [[[size_system:]size_type:]size_value].
     *
     * For example, in "US:MENS:M", "US" represents size system; "MENS" represents
     * size type; "M" represents size value. In "GIRLS:27", size system is empty;
     * "GIRLS" represents size type; "27" represents size value. In "32 inches",
     * both size system and size type are empty, while size value is "32 inches".
     *
     * A maximum of 20 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [size](https://support.google.com/merchants/answer/6324492),
     * [size_type](https://support.google.com/merchants/answer/6324497), and
     * [size_system](https://support.google.com/merchants/answer/6324502).
     * Schema.org property [Product.size](https://schema.org/size).
     * </pre>
     *
     * <code>repeated string sizes = 26;</code>
     *
     * @param values The sizes to add.
     * @return This builder for chaining.
     */
    public Builder addAllSizes(java.lang.Iterable<java.lang.String> values) {
      ensureSizesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sizes_);
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The size of the product. To represent different size systems or size types,
     * consider using this format: [[[size_system:]size_type:]size_value].
     *
     * For example, in "US:MENS:M", "US" represents size system; "MENS" represents
     * size type; "M" represents size value. In "GIRLS:27", size system is empty;
     * "GIRLS" represents size type; "27" represents size value. In "32 inches",
     * both size system and size type are empty, while size value is "32 inches".
     *
     * A maximum of 20 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [size](https://support.google.com/merchants/answer/6324492),
     * [size_type](https://support.google.com/merchants/answer/6324497), and
     * [size_system](https://support.google.com/merchants/answer/6324502).
     * Schema.org property [Product.size](https://schema.org/size).
     * </pre>
     *
     * <code>repeated string sizes = 26;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSizes() {
      sizes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x02000000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The size of the product. To represent different size systems or size types,
     * consider using this format: [[[size_system:]size_type:]size_value].
     *
     * For example, in "US:MENS:M", "US" represents size system; "MENS" represents
     * size type; "M" represents size value. In "GIRLS:27", size system is empty;
     * "GIRLS" represents size type; "27" represents size value. In "32 inches",
     * both size system and size type are empty, while size value is "32 inches".
     *
     * A maximum of 20 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [size](https://support.google.com/merchants/answer/6324492),
     * [size_type](https://support.google.com/merchants/answer/6324497), and
     * [size_system](https://support.google.com/merchants/answer/6324502).
     * Schema.org property [Product.size](https://schema.org/size).
     * </pre>
     *
     * <code>repeated string sizes = 26;</code>
     *
     * @param value The bytes of the sizes to add.
     * @return This builder for chaining.
     */
    public Builder addSizesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSizesIsMutable();
      sizes_.add(value);
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList materials_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureMaterialsIsMutable() {
      if (!materials_.isModifiable()) {
        materials_ = new com.google.protobuf.LazyStringArrayList(materials_);
      }
      bitField0_ |= 0x04000000;
    }
    /**
     *
     *
     * <pre>
     * The material of the product. For example, "leather", "wooden".
     *
     * A maximum of 20 values are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 200 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [material](https://support.google.com/merchants/answer/6324410). Schema.org
     * property [Product.material](https://schema.org/material).
     * </pre>
     *
     * <code>repeated string materials = 27;</code>
     *
     * @return A list containing the materials.
     */
    public com.google.protobuf.ProtocolStringList getMaterialsList() {
      materials_.makeImmutable();
      return materials_;
    }
    /**
     *
     *
     * <pre>
     * The material of the product. For example, "leather", "wooden".
     *
     * A maximum of 20 values are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 200 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [material](https://support.google.com/merchants/answer/6324410). Schema.org
     * property [Product.material](https://schema.org/material).
     * </pre>
     *
     * <code>repeated string materials = 27;</code>
     *
     * @return The count of materials.
     */
    public int getMaterialsCount() {
      return materials_.size();
    }
    /**
     *
     *
     * <pre>
     * The material of the product. For example, "leather", "wooden".
     *
     * A maximum of 20 values are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 200 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [material](https://support.google.com/merchants/answer/6324410). Schema.org
     * property [Product.material](https://schema.org/material).
     * </pre>
     *
     * <code>repeated string materials = 27;</code>
     *
     * @param index The index of the element to return.
     * @return The materials at the given index.
     */
    public java.lang.String getMaterials(int index) {
      return materials_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The material of the product. For example, "leather", "wooden".
     *
     * A maximum of 20 values are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 200 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [material](https://support.google.com/merchants/answer/6324410). Schema.org
     * property [Product.material](https://schema.org/material).
     * </pre>
     *
     * <code>repeated string materials = 27;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the materials at the given index.
     */
    public com.google.protobuf.ByteString getMaterialsBytes(int index) {
      return materials_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The material of the product. For example, "leather", "wooden".
     *
     * A maximum of 20 values are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 200 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [material](https://support.google.com/merchants/answer/6324410). Schema.org
     * property [Product.material](https://schema.org/material).
     * </pre>
     *
     * <code>repeated string materials = 27;</code>
     *
     * @param index The index to set the value at.
     * @param value The materials to set.
     * @return This builder for chaining.
     */
    public Builder setMaterials(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMaterialsIsMutable();
      materials_.set(index, value);
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The material of the product. For example, "leather", "wooden".
     *
     * A maximum of 20 values are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 200 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [material](https://support.google.com/merchants/answer/6324410). Schema.org
     * property [Product.material](https://schema.org/material).
     * </pre>
     *
     * <code>repeated string materials = 27;</code>
     *
     * @param value The materials to add.
     * @return This builder for chaining.
     */
    public Builder addMaterials(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMaterialsIsMutable();
      materials_.add(value);
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The material of the product. For example, "leather", "wooden".
     *
     * A maximum of 20 values are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 200 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [material](https://support.google.com/merchants/answer/6324410). Schema.org
     * property [Product.material](https://schema.org/material).
     * </pre>
     *
     * <code>repeated string materials = 27;</code>
     *
     * @param values The materials to add.
     * @return This builder for chaining.
     */
    public Builder addAllMaterials(java.lang.Iterable<java.lang.String> values) {
      ensureMaterialsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, materials_);
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The material of the product. For example, "leather", "wooden".
     *
     * A maximum of 20 values are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 200 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [material](https://support.google.com/merchants/answer/6324410). Schema.org
     * property [Product.material](https://schema.org/material).
     * </pre>
     *
     * <code>repeated string materials = 27;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaterials() {
      materials_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x04000000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The material of the product. For example, "leather", "wooden".
     *
     * A maximum of 20 values are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 200 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [material](https://support.google.com/merchants/answer/6324410). Schema.org
     * property [Product.material](https://schema.org/material).
     * </pre>
     *
     * <code>repeated string materials = 27;</code>
     *
     * @param value The bytes of the materials to add.
     * @return This builder for chaining.
     */
    public Builder addMaterialsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureMaterialsIsMutable();
      materials_.add(value);
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList patterns_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensurePatternsIsMutable() {
      if (!patterns_.isModifiable()) {
        patterns_ = new com.google.protobuf.LazyStringArrayList(patterns_);
      }
      bitField0_ |= 0x08000000;
    }
    /**
     *
     *
     * <pre>
     * The pattern or graphic print of the product. For example, "striped", "polka
     * dot", "paisley".
     *
     * A maximum of 20 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [pattern](https://support.google.com/merchants/answer/6324483). Schema.org
     * property [Product.pattern](https://schema.org/pattern).
     * </pre>
     *
     * <code>repeated string patterns = 28;</code>
     *
     * @return A list containing the patterns.
     */
    public com.google.protobuf.ProtocolStringList getPatternsList() {
      patterns_.makeImmutable();
      return patterns_;
    }
    /**
     *
     *
     * <pre>
     * The pattern or graphic print of the product. For example, "striped", "polka
     * dot", "paisley".
     *
     * A maximum of 20 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [pattern](https://support.google.com/merchants/answer/6324483). Schema.org
     * property [Product.pattern](https://schema.org/pattern).
     * </pre>
     *
     * <code>repeated string patterns = 28;</code>
     *
     * @return The count of patterns.
     */
    public int getPatternsCount() {
      return patterns_.size();
    }
    /**
     *
     *
     * <pre>
     * The pattern or graphic print of the product. For example, "striped", "polka
     * dot", "paisley".
     *
     * A maximum of 20 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [pattern](https://support.google.com/merchants/answer/6324483). Schema.org
     * property [Product.pattern](https://schema.org/pattern).
     * </pre>
     *
     * <code>repeated string patterns = 28;</code>
     *
     * @param index The index of the element to return.
     * @return The patterns at the given index.
     */
    public java.lang.String getPatterns(int index) {
      return patterns_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The pattern or graphic print of the product. For example, "striped", "polka
     * dot", "paisley".
     *
     * A maximum of 20 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [pattern](https://support.google.com/merchants/answer/6324483). Schema.org
     * property [Product.pattern](https://schema.org/pattern).
     * </pre>
     *
     * <code>repeated string patterns = 28;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the patterns at the given index.
     */
    public com.google.protobuf.ByteString getPatternsBytes(int index) {
      return patterns_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The pattern or graphic print of the product. For example, "striped", "polka
     * dot", "paisley".
     *
     * A maximum of 20 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [pattern](https://support.google.com/merchants/answer/6324483). Schema.org
     * property [Product.pattern](https://schema.org/pattern).
     * </pre>
     *
     * <code>repeated string patterns = 28;</code>
     *
     * @param index The index to set the value at.
     * @param value The patterns to set.
     * @return This builder for chaining.
     */
    public Builder setPatterns(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePatternsIsMutable();
      patterns_.set(index, value);
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The pattern or graphic print of the product. For example, "striped", "polka
     * dot", "paisley".
     *
     * A maximum of 20 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [pattern](https://support.google.com/merchants/answer/6324483). Schema.org
     * property [Product.pattern](https://schema.org/pattern).
     * </pre>
     *
     * <code>repeated string patterns = 28;</code>
     *
     * @param value The patterns to add.
     * @return This builder for chaining.
     */
    public Builder addPatterns(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePatternsIsMutable();
      patterns_.add(value);
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The pattern or graphic print of the product. For example, "striped", "polka
     * dot", "paisley".
     *
     * A maximum of 20 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [pattern](https://support.google.com/merchants/answer/6324483). Schema.org
     * property [Product.pattern](https://schema.org/pattern).
     * </pre>
     *
     * <code>repeated string patterns = 28;</code>
     *
     * @param values The patterns to add.
     * @return This builder for chaining.
     */
    public Builder addAllPatterns(java.lang.Iterable<java.lang.String> values) {
      ensurePatternsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, patterns_);
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The pattern or graphic print of the product. For example, "striped", "polka
     * dot", "paisley".
     *
     * A maximum of 20 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [pattern](https://support.google.com/merchants/answer/6324483). Schema.org
     * property [Product.pattern](https://schema.org/pattern).
     * </pre>
     *
     * <code>repeated string patterns = 28;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPatterns() {
      patterns_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x08000000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The pattern or graphic print of the product. For example, "striped", "polka
     * dot", "paisley".
     *
     * A maximum of 20 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [pattern](https://support.google.com/merchants/answer/6324483). Schema.org
     * property [Product.pattern](https://schema.org/pattern).
     * </pre>
     *
     * <code>repeated string patterns = 28;</code>
     *
     * @param value The bytes of the patterns to add.
     * @return This builder for chaining.
     */
    public Builder addPatternsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensurePatternsIsMutable();
      patterns_.add(value);
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList conditions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureConditionsIsMutable() {
      if (!conditions_.isModifiable()) {
        conditions_ = new com.google.protobuf.LazyStringArrayList(conditions_);
      }
      bitField0_ |= 0x10000000;
    }
    /**
     *
     *
     * <pre>
     * The condition of the product. Strongly encouraged to use the standard
     * values: "new", "refurbished", "used".
     *
     * A maximum of 1 value is allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [condition](https://support.google.com/merchants/answer/6324469).
     * Schema.org property
     * [Offer.itemCondition](https://schema.org/itemCondition).
     * </pre>
     *
     * <code>repeated string conditions = 29;</code>
     *
     * @return A list containing the conditions.
     */
    public com.google.protobuf.ProtocolStringList getConditionsList() {
      conditions_.makeImmutable();
      return conditions_;
    }
    /**
     *
     *
     * <pre>
     * The condition of the product. Strongly encouraged to use the standard
     * values: "new", "refurbished", "used".
     *
     * A maximum of 1 value is allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [condition](https://support.google.com/merchants/answer/6324469).
     * Schema.org property
     * [Offer.itemCondition](https://schema.org/itemCondition).
     * </pre>
     *
     * <code>repeated string conditions = 29;</code>
     *
     * @return The count of conditions.
     */
    public int getConditionsCount() {
      return conditions_.size();
    }
    /**
     *
     *
     * <pre>
     * The condition of the product. Strongly encouraged to use the standard
     * values: "new", "refurbished", "used".
     *
     * A maximum of 1 value is allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [condition](https://support.google.com/merchants/answer/6324469).
     * Schema.org property
     * [Offer.itemCondition](https://schema.org/itemCondition).
     * </pre>
     *
     * <code>repeated string conditions = 29;</code>
     *
     * @param index The index of the element to return.
     * @return The conditions at the given index.
     */
    public java.lang.String getConditions(int index) {
      return conditions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The condition of the product. Strongly encouraged to use the standard
     * values: "new", "refurbished", "used".
     *
     * A maximum of 1 value is allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [condition](https://support.google.com/merchants/answer/6324469).
     * Schema.org property
     * [Offer.itemCondition](https://schema.org/itemCondition).
     * </pre>
     *
     * <code>repeated string conditions = 29;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the conditions at the given index.
     */
    public com.google.protobuf.ByteString getConditionsBytes(int index) {
      return conditions_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The condition of the product. Strongly encouraged to use the standard
     * values: "new", "refurbished", "used".
     *
     * A maximum of 1 value is allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [condition](https://support.google.com/merchants/answer/6324469).
     * Schema.org property
     * [Offer.itemCondition](https://schema.org/itemCondition).
     * </pre>
     *
     * <code>repeated string conditions = 29;</code>
     *
     * @param index The index to set the value at.
     * @param value The conditions to set.
     * @return This builder for chaining.
     */
    public Builder setConditions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureConditionsIsMutable();
      conditions_.set(index, value);
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The condition of the product. Strongly encouraged to use the standard
     * values: "new", "refurbished", "used".
     *
     * A maximum of 1 value is allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [condition](https://support.google.com/merchants/answer/6324469).
     * Schema.org property
     * [Offer.itemCondition](https://schema.org/itemCondition).
     * </pre>
     *
     * <code>repeated string conditions = 29;</code>
     *
     * @param value The conditions to add.
     * @return This builder for chaining.
     */
    public Builder addConditions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureConditionsIsMutable();
      conditions_.add(value);
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The condition of the product. Strongly encouraged to use the standard
     * values: "new", "refurbished", "used".
     *
     * A maximum of 1 value is allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [condition](https://support.google.com/merchants/answer/6324469).
     * Schema.org property
     * [Offer.itemCondition](https://schema.org/itemCondition).
     * </pre>
     *
     * <code>repeated string conditions = 29;</code>
     *
     * @param values The conditions to add.
     * @return This builder for chaining.
     */
    public Builder addAllConditions(java.lang.Iterable<java.lang.String> values) {
      ensureConditionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, conditions_);
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The condition of the product. Strongly encouraged to use the standard
     * values: "new", "refurbished", "used".
     *
     * A maximum of 1 value is allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [condition](https://support.google.com/merchants/answer/6324469).
     * Schema.org property
     * [Offer.itemCondition](https://schema.org/itemCondition).
     * </pre>
     *
     * <code>repeated string conditions = 29;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConditions() {
      conditions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x10000000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The condition of the product. Strongly encouraged to use the standard
     * values: "new", "refurbished", "used".
     *
     * A maximum of 1 value is allowed per
     * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
     * encoded string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Corresponding properties: Google Merchant Center property
     * [condition](https://support.google.com/merchants/answer/6324469).
     * Schema.org property
     * [Offer.itemCondition](https://schema.org/itemCondition).
     * </pre>
     *
     * <code>repeated string conditions = 29;</code>
     *
     * @param value The bytes of the conditions to add.
     * @return This builder for chaining.
     */
    public Builder addConditionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureConditionsIsMutable();
      conditions_.add(value);
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.retail.v2.Promotion> promotions_ =
        java.util.Collections.emptyList();

    private void ensurePromotionsIsMutable() {
      if (!((bitField0_ & 0x20000000) != 0)) {
        promotions_ = new java.util.ArrayList<com.google.cloud.retail.v2.Promotion>(promotions_);
        bitField0_ |= 0x20000000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2.Promotion,
            com.google.cloud.retail.v2.Promotion.Builder,
            com.google.cloud.retail.v2.PromotionOrBuilder>
        promotionsBuilder_;

    /**
     *
     *
     * <pre>
     * The promotions applied to the product. A maximum of 10 values are allowed
     * per [Product][google.cloud.retail.v2.Product]. Only
     * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
     * will be used, other fields will be ignored if set.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
     */
    public java.util.List<com.google.cloud.retail.v2.Promotion> getPromotionsList() {
      if (promotionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(promotions_);
      } else {
        return promotionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The promotions applied to the product. A maximum of 10 values are allowed
     * per [Product][google.cloud.retail.v2.Product]. Only
     * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
     * will be used, other fields will be ignored if set.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
     */
    public int getPromotionsCount() {
      if (promotionsBuilder_ == null) {
        return promotions_.size();
      } else {
        return promotionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The promotions applied to the product. A maximum of 10 values are allowed
     * per [Product][google.cloud.retail.v2.Product]. Only
     * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
     * will be used, other fields will be ignored if set.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
     */
    public com.google.cloud.retail.v2.Promotion getPromotions(int index) {
      if (promotionsBuilder_ == null) {
        return promotions_.get(index);
      } else {
        return promotionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The promotions applied to the product. A maximum of 10 values are allowed
     * per [Product][google.cloud.retail.v2.Product]. Only
     * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
     * will be used, other fields will be ignored if set.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
     */
    public Builder setPromotions(int index, com.google.cloud.retail.v2.Promotion value) {
      if (promotionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePromotionsIsMutable();
        promotions_.set(index, value);
        onChanged();
      } else {
        promotionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The promotions applied to the product. A maximum of 10 values are allowed
     * per [Product][google.cloud.retail.v2.Product]. Only
     * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
     * will be used, other fields will be ignored if set.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
     */
    public Builder setPromotions(
        int index, com.google.cloud.retail.v2.Promotion.Builder builderForValue) {
      if (promotionsBuilder_ == null) {
        ensurePromotionsIsMutable();
        promotions_.set(index, builderForValue.build());
        onChanged();
      } else {
        promotionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The promotions applied to the product. A maximum of 10 values are allowed
     * per [Product][google.cloud.retail.v2.Product]. Only
     * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
     * will be used, other fields will be ignored if set.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
     */
    public Builder addPromotions(com.google.cloud.retail.v2.Promotion value) {
      if (promotionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePromotionsIsMutable();
        promotions_.add(value);
        onChanged();
      } else {
        promotionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The promotions applied to the product. A maximum of 10 values are allowed
     * per [Product][google.cloud.retail.v2.Product]. Only
     * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
     * will be used, other fields will be ignored if set.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
     */
    public Builder addPromotions(int index, com.google.cloud.retail.v2.Promotion value) {
      if (promotionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePromotionsIsMutable();
        promotions_.add(index, value);
        onChanged();
      } else {
        promotionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The promotions applied to the product. A maximum of 10 values are allowed
     * per [Product][google.cloud.retail.v2.Product]. Only
     * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
     * will be used, other fields will be ignored if set.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
     */
    public Builder addPromotions(com.google.cloud.retail.v2.Promotion.Builder builderForValue) {
      if (promotionsBuilder_ == null) {
        ensurePromotionsIsMutable();
        promotions_.add(builderForValue.build());
        onChanged();
      } else {
        promotionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The promotions applied to the product. A maximum of 10 values are allowed
     * per [Product][google.cloud.retail.v2.Product]. Only
     * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
     * will be used, other fields will be ignored if set.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
     */
    public Builder addPromotions(
        int index, com.google.cloud.retail.v2.Promotion.Builder builderForValue) {
      if (promotionsBuilder_ == null) {
        ensurePromotionsIsMutable();
        promotions_.add(index, builderForValue.build());
        onChanged();
      } else {
        promotionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The promotions applied to the product. A maximum of 10 values are allowed
     * per [Product][google.cloud.retail.v2.Product]. Only
     * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
     * will be used, other fields will be ignored if set.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
     */
    public Builder addAllPromotions(
        java.lang.Iterable<? extends com.google.cloud.retail.v2.Promotion> values) {
      if (promotionsBuilder_ == null) {
        ensurePromotionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, promotions_);
        onChanged();
      } else {
        promotionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The promotions applied to the product. A maximum of 10 values are allowed
     * per [Product][google.cloud.retail.v2.Product]. Only
     * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
     * will be used, other fields will be ignored if set.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
     */
    public Builder clearPromotions() {
      if (promotionsBuilder_ == null) {
        promotions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x20000000);
        onChanged();
      } else {
        promotionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The promotions applied to the product. A maximum of 10 values are allowed
     * per [Product][google.cloud.retail.v2.Product]. Only
     * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
     * will be used, other fields will be ignored if set.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
     */
    public Builder removePromotions(int index) {
      if (promotionsBuilder_ == null) {
        ensurePromotionsIsMutable();
        promotions_.remove(index);
        onChanged();
      } else {
        promotionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The promotions applied to the product. A maximum of 10 values are allowed
     * per [Product][google.cloud.retail.v2.Product]. Only
     * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
     * will be used, other fields will be ignored if set.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
     */
    public com.google.cloud.retail.v2.Promotion.Builder getPromotionsBuilder(int index) {
      return getPromotionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The promotions applied to the product. A maximum of 10 values are allowed
     * per [Product][google.cloud.retail.v2.Product]. Only
     * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
     * will be used, other fields will be ignored if set.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
     */
    public com.google.cloud.retail.v2.PromotionOrBuilder getPromotionsOrBuilder(int index) {
      if (promotionsBuilder_ == null) {
        return promotions_.get(index);
      } else {
        return promotionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The promotions applied to the product. A maximum of 10 values are allowed
     * per [Product][google.cloud.retail.v2.Product]. Only
     * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
     * will be used, other fields will be ignored if set.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
     */
    public java.util.List<? extends com.google.cloud.retail.v2.PromotionOrBuilder>
        getPromotionsOrBuilderList() {
      if (promotionsBuilder_ != null) {
        return promotionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(promotions_);
      }
    }
    /**
     *
     *
     * <pre>
     * The promotions applied to the product. A maximum of 10 values are allowed
     * per [Product][google.cloud.retail.v2.Product]. Only
     * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
     * will be used, other fields will be ignored if set.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
     */
    public com.google.cloud.retail.v2.Promotion.Builder addPromotionsBuilder() {
      return getPromotionsFieldBuilder()
          .addBuilder(com.google.cloud.retail.v2.Promotion.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The promotions applied to the product. A maximum of 10 values are allowed
     * per [Product][google.cloud.retail.v2.Product]. Only
     * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
     * will be used, other fields will be ignored if set.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
     */
    public com.google.cloud.retail.v2.Promotion.Builder addPromotionsBuilder(int index) {
      return getPromotionsFieldBuilder()
          .addBuilder(index, com.google.cloud.retail.v2.Promotion.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The promotions applied to the product. A maximum of 10 values are allowed
     * per [Product][google.cloud.retail.v2.Product]. Only
     * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
     * will be used, other fields will be ignored if set.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
     */
    public java.util.List<com.google.cloud.retail.v2.Promotion.Builder> getPromotionsBuilderList() {
      return getPromotionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2.Promotion,
            com.google.cloud.retail.v2.Promotion.Builder,
            com.google.cloud.retail.v2.PromotionOrBuilder>
        getPromotionsFieldBuilder() {
      if (promotionsBuilder_ == null) {
        promotionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2.Promotion,
                com.google.cloud.retail.v2.Promotion.Builder,
                com.google.cloud.retail.v2.PromotionOrBuilder>(
                promotions_, ((bitField0_ & 0x20000000) != 0), getParentForChildren(), isClean());
        promotions_ = null;
      }
      return promotionsBuilder_;
    }

    private com.google.protobuf.Timestamp publishTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        publishTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The timestamp when the product is published by the retailer for the first
     * time, which indicates the freshness of the products. Note that this field
     * is different from
     * [available_time][google.cloud.retail.v2.Product.available_time], given it
     * purely describes product freshness regardless of when it is available on
     * search and recommendation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp publish_time = 33;</code>
     *
     * @return Whether the publishTime field is set.
     */
    public boolean hasPublishTime() {
      return ((bitField0_ & 0x40000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the product is published by the retailer for the first
     * time, which indicates the freshness of the products. Note that this field
     * is different from
     * [available_time][google.cloud.retail.v2.Product.available_time], given it
     * purely describes product freshness regardless of when it is available on
     * search and recommendation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp publish_time = 33;</code>
     *
     * @return The publishTime.
     */
    public com.google.protobuf.Timestamp getPublishTime() {
      if (publishTimeBuilder_ == null) {
        return publishTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : publishTime_;
      } else {
        return publishTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the product is published by the retailer for the first
     * time, which indicates the freshness of the products. Note that this field
     * is different from
     * [available_time][google.cloud.retail.v2.Product.available_time], given it
     * purely describes product freshness regardless of when it is available on
     * search and recommendation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp publish_time = 33;</code>
     */
    public Builder setPublishTime(com.google.protobuf.Timestamp value) {
      if (publishTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        publishTime_ = value;
      } else {
        publishTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the product is published by the retailer for the first
     * time, which indicates the freshness of the products. Note that this field
     * is different from
     * [available_time][google.cloud.retail.v2.Product.available_time], given it
     * purely describes product freshness regardless of when it is available on
     * search and recommendation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp publish_time = 33;</code>
     */
    public Builder setPublishTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (publishTimeBuilder_ == null) {
        publishTime_ = builderForValue.build();
      } else {
        publishTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the product is published by the retailer for the first
     * time, which indicates the freshness of the products. Note that this field
     * is different from
     * [available_time][google.cloud.retail.v2.Product.available_time], given it
     * purely describes product freshness regardless of when it is available on
     * search and recommendation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp publish_time = 33;</code>
     */
    public Builder mergePublishTime(com.google.protobuf.Timestamp value) {
      if (publishTimeBuilder_ == null) {
        if (((bitField0_ & 0x40000000) != 0)
            && publishTime_ != null
            && publishTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getPublishTimeBuilder().mergeFrom(value);
        } else {
          publishTime_ = value;
        }
      } else {
        publishTimeBuilder_.mergeFrom(value);
      }
      if (publishTime_ != null) {
        bitField0_ |= 0x40000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the product is published by the retailer for the first
     * time, which indicates the freshness of the products. Note that this field
     * is different from
     * [available_time][google.cloud.retail.v2.Product.available_time], given it
     * purely describes product freshness regardless of when it is available on
     * search and recommendation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp publish_time = 33;</code>
     */
    public Builder clearPublishTime() {
      bitField0_ = (bitField0_ & ~0x40000000);
      publishTime_ = null;
      if (publishTimeBuilder_ != null) {
        publishTimeBuilder_.dispose();
        publishTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the product is published by the retailer for the first
     * time, which indicates the freshness of the products. Note that this field
     * is different from
     * [available_time][google.cloud.retail.v2.Product.available_time], given it
     * purely describes product freshness regardless of when it is available on
     * search and recommendation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp publish_time = 33;</code>
     */
    public com.google.protobuf.Timestamp.Builder getPublishTimeBuilder() {
      bitField0_ |= 0x40000000;
      onChanged();
      return getPublishTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the product is published by the retailer for the first
     * time, which indicates the freshness of the products. Note that this field
     * is different from
     * [available_time][google.cloud.retail.v2.Product.available_time], given it
     * purely describes product freshness regardless of when it is available on
     * search and recommendation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp publish_time = 33;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getPublishTimeOrBuilder() {
      if (publishTimeBuilder_ != null) {
        return publishTimeBuilder_.getMessageOrBuilder();
      } else {
        return publishTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : publishTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the product is published by the retailer for the first
     * time, which indicates the freshness of the products. Note that this field
     * is different from
     * [available_time][google.cloud.retail.v2.Product.available_time], given it
     * purely describes product freshness regardless of when it is available on
     * search and recommendation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp publish_time = 33;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getPublishTimeFieldBuilder() {
      if (publishTimeBuilder_ == null) {
        publishTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getPublishTime(), getParentForChildren(), isClean());
        publishTime_ = null;
      }
      return publishTimeBuilder_;
    }

    private com.google.protobuf.FieldMask retrievableFields_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        retrievableFieldsBuilder_;
    /**
     *
     *
     * <pre>
     * Indicates which fields in the [Product][google.cloud.retail.v2.Product]s
     * are returned in [SearchResponse][google.cloud.retail.v2.SearchResponse].
     *
     * Supported fields for all [type][google.cloud.retail.v2.Product.type]s:
     *
     * * [audience][google.cloud.retail.v2.Product.audience]
     * * [availability][google.cloud.retail.v2.Product.availability]
     * * [brands][google.cloud.retail.v2.Product.brands]
     * * [color_info][google.cloud.retail.v2.Product.color_info]
     * * [conditions][google.cloud.retail.v2.Product.conditions]
     * * [gtin][google.cloud.retail.v2.Product.gtin]
     * * [materials][google.cloud.retail.v2.Product.materials]
     * * [name][google.cloud.retail.v2.Product.name]
     * * [patterns][google.cloud.retail.v2.Product.patterns]
     * * [price_info][google.cloud.retail.v2.Product.price_info]
     * * [rating][google.cloud.retail.v2.Product.rating]
     * * [sizes][google.cloud.retail.v2.Product.sizes]
     * * [title][google.cloud.retail.v2.Product.title]
     * * [uri][google.cloud.retail.v2.Product.uri]
     *
     * Supported fields only for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION]:
     *
     * * [categories][google.cloud.retail.v2.Product.categories]
     * * [description][google.cloud.retail.v2.Product.description]
     * * [images][google.cloud.retail.v2.Product.images]
     *
     * Supported fields only for
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]:
     *
     * * Only the first image in [images][google.cloud.retail.v2.Product.images]
     *
     * To mark [attributes][google.cloud.retail.v2.Product.attributes] as
     * retrievable, include paths of the form "attributes.key" where "key" is the
     * key of a custom attribute, as specified in
     * [attributes][google.cloud.retail.v2.Product.attributes].
     *
     * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], the
     * following fields are always returned in
     * [SearchResponse][google.cloud.retail.v2.SearchResponse] by default:
     *
     * * [name][google.cloud.retail.v2.Product.name]
     *
     * For [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT], the
     * following fields are always returned in by default:
     *
     * * [name][google.cloud.retail.v2.Product.name]
     * * [color_info][google.cloud.retail.v2.Product.color_info]
     *
     * The maximum number of paths is 30. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     *
     * Note: Returning more fields in
     * [SearchResponse][google.cloud.retail.v2.SearchResponse] can increase
     * response payload size and serving latency.
     *
     * This field is deprecated. Use the retrievable site-wide control instead.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask retrievable_fields = 30 [deprecated = true];</code>
     *
     * @deprecated google.cloud.retail.v2.Product.retrievable_fields is deprecated. See
     *     google/cloud/retail/v2/product.proto;l=562
     * @return Whether the retrievableFields field is set.
     */
    @java.lang.Deprecated
    public boolean hasRetrievableFields() {
      return ((bitField0_ & 0x80000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the [Product][google.cloud.retail.v2.Product]s
     * are returned in [SearchResponse][google.cloud.retail.v2.SearchResponse].
     *
     * Supported fields for all [type][google.cloud.retail.v2.Product.type]s:
     *
     * * [audience][google.cloud.retail.v2.Product.audience]
     * * [availability][google.cloud.retail.v2.Product.availability]
     * * [brands][google.cloud.retail.v2.Product.brands]
     * * [color_info][google.cloud.retail.v2.Product.color_info]
     * * [conditions][google.cloud.retail.v2.Product.conditions]
     * * [gtin][google.cloud.retail.v2.Product.gtin]
     * * [materials][google.cloud.retail.v2.Product.materials]
     * * [name][google.cloud.retail.v2.Product.name]
     * * [patterns][google.cloud.retail.v2.Product.patterns]
     * * [price_info][google.cloud.retail.v2.Product.price_info]
     * * [rating][google.cloud.retail.v2.Product.rating]
     * * [sizes][google.cloud.retail.v2.Product.sizes]
     * * [title][google.cloud.retail.v2.Product.title]
     * * [uri][google.cloud.retail.v2.Product.uri]
     *
     * Supported fields only for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION]:
     *
     * * [categories][google.cloud.retail.v2.Product.categories]
     * * [description][google.cloud.retail.v2.Product.description]
     * * [images][google.cloud.retail.v2.Product.images]
     *
     * Supported fields only for
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]:
     *
     * * Only the first image in [images][google.cloud.retail.v2.Product.images]
     *
     * To mark [attributes][google.cloud.retail.v2.Product.attributes] as
     * retrievable, include paths of the form "attributes.key" where "key" is the
     * key of a custom attribute, as specified in
     * [attributes][google.cloud.retail.v2.Product.attributes].
     *
     * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], the
     * following fields are always returned in
     * [SearchResponse][google.cloud.retail.v2.SearchResponse] by default:
     *
     * * [name][google.cloud.retail.v2.Product.name]
     *
     * For [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT], the
     * following fields are always returned in by default:
     *
     * * [name][google.cloud.retail.v2.Product.name]
     * * [color_info][google.cloud.retail.v2.Product.color_info]
     *
     * The maximum number of paths is 30. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     *
     * Note: Returning more fields in
     * [SearchResponse][google.cloud.retail.v2.SearchResponse] can increase
     * response payload size and serving latency.
     *
     * This field is deprecated. Use the retrievable site-wide control instead.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask retrievable_fields = 30 [deprecated = true];</code>
     *
     * @deprecated google.cloud.retail.v2.Product.retrievable_fields is deprecated. See
     *     google/cloud/retail/v2/product.proto;l=562
     * @return The retrievableFields.
     */
    @java.lang.Deprecated
    public com.google.protobuf.FieldMask getRetrievableFields() {
      if (retrievableFieldsBuilder_ == null) {
        return retrievableFields_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : retrievableFields_;
      } else {
        return retrievableFieldsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the [Product][google.cloud.retail.v2.Product]s
     * are returned in [SearchResponse][google.cloud.retail.v2.SearchResponse].
     *
     * Supported fields for all [type][google.cloud.retail.v2.Product.type]s:
     *
     * * [audience][google.cloud.retail.v2.Product.audience]
     * * [availability][google.cloud.retail.v2.Product.availability]
     * * [brands][google.cloud.retail.v2.Product.brands]
     * * [color_info][google.cloud.retail.v2.Product.color_info]
     * * [conditions][google.cloud.retail.v2.Product.conditions]
     * * [gtin][google.cloud.retail.v2.Product.gtin]
     * * [materials][google.cloud.retail.v2.Product.materials]
     * * [name][google.cloud.retail.v2.Product.name]
     * * [patterns][google.cloud.retail.v2.Product.patterns]
     * * [price_info][google.cloud.retail.v2.Product.price_info]
     * * [rating][google.cloud.retail.v2.Product.rating]
     * * [sizes][google.cloud.retail.v2.Product.sizes]
     * * [title][google.cloud.retail.v2.Product.title]
     * * [uri][google.cloud.retail.v2.Product.uri]
     *
     * Supported fields only for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION]:
     *
     * * [categories][google.cloud.retail.v2.Product.categories]
     * * [description][google.cloud.retail.v2.Product.description]
     * * [images][google.cloud.retail.v2.Product.images]
     *
     * Supported fields only for
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]:
     *
     * * Only the first image in [images][google.cloud.retail.v2.Product.images]
     *
     * To mark [attributes][google.cloud.retail.v2.Product.attributes] as
     * retrievable, include paths of the form "attributes.key" where "key" is the
     * key of a custom attribute, as specified in
     * [attributes][google.cloud.retail.v2.Product.attributes].
     *
     * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], the
     * following fields are always returned in
     * [SearchResponse][google.cloud.retail.v2.SearchResponse] by default:
     *
     * * [name][google.cloud.retail.v2.Product.name]
     *
     * For [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT], the
     * following fields are always returned in by default:
     *
     * * [name][google.cloud.retail.v2.Product.name]
     * * [color_info][google.cloud.retail.v2.Product.color_info]
     *
     * The maximum number of paths is 30. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     *
     * Note: Returning more fields in
     * [SearchResponse][google.cloud.retail.v2.SearchResponse] can increase
     * response payload size and serving latency.
     *
     * This field is deprecated. Use the retrievable site-wide control instead.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask retrievable_fields = 30 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder setRetrievableFields(com.google.protobuf.FieldMask value) {
      if (retrievableFieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        retrievableFields_ = value;
      } else {
        retrievableFieldsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the [Product][google.cloud.retail.v2.Product]s
     * are returned in [SearchResponse][google.cloud.retail.v2.SearchResponse].
     *
     * Supported fields for all [type][google.cloud.retail.v2.Product.type]s:
     *
     * * [audience][google.cloud.retail.v2.Product.audience]
     * * [availability][google.cloud.retail.v2.Product.availability]
     * * [brands][google.cloud.retail.v2.Product.brands]
     * * [color_info][google.cloud.retail.v2.Product.color_info]
     * * [conditions][google.cloud.retail.v2.Product.conditions]
     * * [gtin][google.cloud.retail.v2.Product.gtin]
     * * [materials][google.cloud.retail.v2.Product.materials]
     * * [name][google.cloud.retail.v2.Product.name]
     * * [patterns][google.cloud.retail.v2.Product.patterns]
     * * [price_info][google.cloud.retail.v2.Product.price_info]
     * * [rating][google.cloud.retail.v2.Product.rating]
     * * [sizes][google.cloud.retail.v2.Product.sizes]
     * * [title][google.cloud.retail.v2.Product.title]
     * * [uri][google.cloud.retail.v2.Product.uri]
     *
     * Supported fields only for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION]:
     *
     * * [categories][google.cloud.retail.v2.Product.categories]
     * * [description][google.cloud.retail.v2.Product.description]
     * * [images][google.cloud.retail.v2.Product.images]
     *
     * Supported fields only for
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]:
     *
     * * Only the first image in [images][google.cloud.retail.v2.Product.images]
     *
     * To mark [attributes][google.cloud.retail.v2.Product.attributes] as
     * retrievable, include paths of the form "attributes.key" where "key" is the
     * key of a custom attribute, as specified in
     * [attributes][google.cloud.retail.v2.Product.attributes].
     *
     * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], the
     * following fields are always returned in
     * [SearchResponse][google.cloud.retail.v2.SearchResponse] by default:
     *
     * * [name][google.cloud.retail.v2.Product.name]
     *
     * For [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT], the
     * following fields are always returned in by default:
     *
     * * [name][google.cloud.retail.v2.Product.name]
     * * [color_info][google.cloud.retail.v2.Product.color_info]
     *
     * The maximum number of paths is 30. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     *
     * Note: Returning more fields in
     * [SearchResponse][google.cloud.retail.v2.SearchResponse] can increase
     * response payload size and serving latency.
     *
     * This field is deprecated. Use the retrievable site-wide control instead.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask retrievable_fields = 30 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder setRetrievableFields(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (retrievableFieldsBuilder_ == null) {
        retrievableFields_ = builderForValue.build();
      } else {
        retrievableFieldsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the [Product][google.cloud.retail.v2.Product]s
     * are returned in [SearchResponse][google.cloud.retail.v2.SearchResponse].
     *
     * Supported fields for all [type][google.cloud.retail.v2.Product.type]s:
     *
     * * [audience][google.cloud.retail.v2.Product.audience]
     * * [availability][google.cloud.retail.v2.Product.availability]
     * * [brands][google.cloud.retail.v2.Product.brands]
     * * [color_info][google.cloud.retail.v2.Product.color_info]
     * * [conditions][google.cloud.retail.v2.Product.conditions]
     * * [gtin][google.cloud.retail.v2.Product.gtin]
     * * [materials][google.cloud.retail.v2.Product.materials]
     * * [name][google.cloud.retail.v2.Product.name]
     * * [patterns][google.cloud.retail.v2.Product.patterns]
     * * [price_info][google.cloud.retail.v2.Product.price_info]
     * * [rating][google.cloud.retail.v2.Product.rating]
     * * [sizes][google.cloud.retail.v2.Product.sizes]
     * * [title][google.cloud.retail.v2.Product.title]
     * * [uri][google.cloud.retail.v2.Product.uri]
     *
     * Supported fields only for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION]:
     *
     * * [categories][google.cloud.retail.v2.Product.categories]
     * * [description][google.cloud.retail.v2.Product.description]
     * * [images][google.cloud.retail.v2.Product.images]
     *
     * Supported fields only for
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]:
     *
     * * Only the first image in [images][google.cloud.retail.v2.Product.images]
     *
     * To mark [attributes][google.cloud.retail.v2.Product.attributes] as
     * retrievable, include paths of the form "attributes.key" where "key" is the
     * key of a custom attribute, as specified in
     * [attributes][google.cloud.retail.v2.Product.attributes].
     *
     * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], the
     * following fields are always returned in
     * [SearchResponse][google.cloud.retail.v2.SearchResponse] by default:
     *
     * * [name][google.cloud.retail.v2.Product.name]
     *
     * For [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT], the
     * following fields are always returned in by default:
     *
     * * [name][google.cloud.retail.v2.Product.name]
     * * [color_info][google.cloud.retail.v2.Product.color_info]
     *
     * The maximum number of paths is 30. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     *
     * Note: Returning more fields in
     * [SearchResponse][google.cloud.retail.v2.SearchResponse] can increase
     * response payload size and serving latency.
     *
     * This field is deprecated. Use the retrievable site-wide control instead.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask retrievable_fields = 30 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder mergeRetrievableFields(com.google.protobuf.FieldMask value) {
      if (retrievableFieldsBuilder_ == null) {
        if (((bitField0_ & 0x80000000) != 0)
            && retrievableFields_ != null
            && retrievableFields_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getRetrievableFieldsBuilder().mergeFrom(value);
        } else {
          retrievableFields_ = value;
        }
      } else {
        retrievableFieldsBuilder_.mergeFrom(value);
      }
      if (retrievableFields_ != null) {
        bitField0_ |= 0x80000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the [Product][google.cloud.retail.v2.Product]s
     * are returned in [SearchResponse][google.cloud.retail.v2.SearchResponse].
     *
     * Supported fields for all [type][google.cloud.retail.v2.Product.type]s:
     *
     * * [audience][google.cloud.retail.v2.Product.audience]
     * * [availability][google.cloud.retail.v2.Product.availability]
     * * [brands][google.cloud.retail.v2.Product.brands]
     * * [color_info][google.cloud.retail.v2.Product.color_info]
     * * [conditions][google.cloud.retail.v2.Product.conditions]
     * * [gtin][google.cloud.retail.v2.Product.gtin]
     * * [materials][google.cloud.retail.v2.Product.materials]
     * * [name][google.cloud.retail.v2.Product.name]
     * * [patterns][google.cloud.retail.v2.Product.patterns]
     * * [price_info][google.cloud.retail.v2.Product.price_info]
     * * [rating][google.cloud.retail.v2.Product.rating]
     * * [sizes][google.cloud.retail.v2.Product.sizes]
     * * [title][google.cloud.retail.v2.Product.title]
     * * [uri][google.cloud.retail.v2.Product.uri]
     *
     * Supported fields only for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION]:
     *
     * * [categories][google.cloud.retail.v2.Product.categories]
     * * [description][google.cloud.retail.v2.Product.description]
     * * [images][google.cloud.retail.v2.Product.images]
     *
     * Supported fields only for
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]:
     *
     * * Only the first image in [images][google.cloud.retail.v2.Product.images]
     *
     * To mark [attributes][google.cloud.retail.v2.Product.attributes] as
     * retrievable, include paths of the form "attributes.key" where "key" is the
     * key of a custom attribute, as specified in
     * [attributes][google.cloud.retail.v2.Product.attributes].
     *
     * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], the
     * following fields are always returned in
     * [SearchResponse][google.cloud.retail.v2.SearchResponse] by default:
     *
     * * [name][google.cloud.retail.v2.Product.name]
     *
     * For [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT], the
     * following fields are always returned in by default:
     *
     * * [name][google.cloud.retail.v2.Product.name]
     * * [color_info][google.cloud.retail.v2.Product.color_info]
     *
     * The maximum number of paths is 30. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     *
     * Note: Returning more fields in
     * [SearchResponse][google.cloud.retail.v2.SearchResponse] can increase
     * response payload size and serving latency.
     *
     * This field is deprecated. Use the retrievable site-wide control instead.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask retrievable_fields = 30 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder clearRetrievableFields() {
      bitField0_ = (bitField0_ & ~0x80000000);
      retrievableFields_ = null;
      if (retrievableFieldsBuilder_ != null) {
        retrievableFieldsBuilder_.dispose();
        retrievableFieldsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the [Product][google.cloud.retail.v2.Product]s
     * are returned in [SearchResponse][google.cloud.retail.v2.SearchResponse].
     *
     * Supported fields for all [type][google.cloud.retail.v2.Product.type]s:
     *
     * * [audience][google.cloud.retail.v2.Product.audience]
     * * [availability][google.cloud.retail.v2.Product.availability]
     * * [brands][google.cloud.retail.v2.Product.brands]
     * * [color_info][google.cloud.retail.v2.Product.color_info]
     * * [conditions][google.cloud.retail.v2.Product.conditions]
     * * [gtin][google.cloud.retail.v2.Product.gtin]
     * * [materials][google.cloud.retail.v2.Product.materials]
     * * [name][google.cloud.retail.v2.Product.name]
     * * [patterns][google.cloud.retail.v2.Product.patterns]
     * * [price_info][google.cloud.retail.v2.Product.price_info]
     * * [rating][google.cloud.retail.v2.Product.rating]
     * * [sizes][google.cloud.retail.v2.Product.sizes]
     * * [title][google.cloud.retail.v2.Product.title]
     * * [uri][google.cloud.retail.v2.Product.uri]
     *
     * Supported fields only for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION]:
     *
     * * [categories][google.cloud.retail.v2.Product.categories]
     * * [description][google.cloud.retail.v2.Product.description]
     * * [images][google.cloud.retail.v2.Product.images]
     *
     * Supported fields only for
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]:
     *
     * * Only the first image in [images][google.cloud.retail.v2.Product.images]
     *
     * To mark [attributes][google.cloud.retail.v2.Product.attributes] as
     * retrievable, include paths of the form "attributes.key" where "key" is the
     * key of a custom attribute, as specified in
     * [attributes][google.cloud.retail.v2.Product.attributes].
     *
     * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], the
     * following fields are always returned in
     * [SearchResponse][google.cloud.retail.v2.SearchResponse] by default:
     *
     * * [name][google.cloud.retail.v2.Product.name]
     *
     * For [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT], the
     * following fields are always returned in by default:
     *
     * * [name][google.cloud.retail.v2.Product.name]
     * * [color_info][google.cloud.retail.v2.Product.color_info]
     *
     * The maximum number of paths is 30. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     *
     * Note: Returning more fields in
     * [SearchResponse][google.cloud.retail.v2.SearchResponse] can increase
     * response payload size and serving latency.
     *
     * This field is deprecated. Use the retrievable site-wide control instead.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask retrievable_fields = 30 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.protobuf.FieldMask.Builder getRetrievableFieldsBuilder() {
      bitField0_ |= 0x80000000;
      onChanged();
      return getRetrievableFieldsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the [Product][google.cloud.retail.v2.Product]s
     * are returned in [SearchResponse][google.cloud.retail.v2.SearchResponse].
     *
     * Supported fields for all [type][google.cloud.retail.v2.Product.type]s:
     *
     * * [audience][google.cloud.retail.v2.Product.audience]
     * * [availability][google.cloud.retail.v2.Product.availability]
     * * [brands][google.cloud.retail.v2.Product.brands]
     * * [color_info][google.cloud.retail.v2.Product.color_info]
     * * [conditions][google.cloud.retail.v2.Product.conditions]
     * * [gtin][google.cloud.retail.v2.Product.gtin]
     * * [materials][google.cloud.retail.v2.Product.materials]
     * * [name][google.cloud.retail.v2.Product.name]
     * * [patterns][google.cloud.retail.v2.Product.patterns]
     * * [price_info][google.cloud.retail.v2.Product.price_info]
     * * [rating][google.cloud.retail.v2.Product.rating]
     * * [sizes][google.cloud.retail.v2.Product.sizes]
     * * [title][google.cloud.retail.v2.Product.title]
     * * [uri][google.cloud.retail.v2.Product.uri]
     *
     * Supported fields only for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION]:
     *
     * * [categories][google.cloud.retail.v2.Product.categories]
     * * [description][google.cloud.retail.v2.Product.description]
     * * [images][google.cloud.retail.v2.Product.images]
     *
     * Supported fields only for
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]:
     *
     * * Only the first image in [images][google.cloud.retail.v2.Product.images]
     *
     * To mark [attributes][google.cloud.retail.v2.Product.attributes] as
     * retrievable, include paths of the form "attributes.key" where "key" is the
     * key of a custom attribute, as specified in
     * [attributes][google.cloud.retail.v2.Product.attributes].
     *
     * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], the
     * following fields are always returned in
     * [SearchResponse][google.cloud.retail.v2.SearchResponse] by default:
     *
     * * [name][google.cloud.retail.v2.Product.name]
     *
     * For [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT], the
     * following fields are always returned in by default:
     *
     * * [name][google.cloud.retail.v2.Product.name]
     * * [color_info][google.cloud.retail.v2.Product.color_info]
     *
     * The maximum number of paths is 30. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     *
     * Note: Returning more fields in
     * [SearchResponse][google.cloud.retail.v2.SearchResponse] can increase
     * response payload size and serving latency.
     *
     * This field is deprecated. Use the retrievable site-wide control instead.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask retrievable_fields = 30 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.protobuf.FieldMaskOrBuilder getRetrievableFieldsOrBuilder() {
      if (retrievableFieldsBuilder_ != null) {
        return retrievableFieldsBuilder_.getMessageOrBuilder();
      } else {
        return retrievableFields_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : retrievableFields_;
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the [Product][google.cloud.retail.v2.Product]s
     * are returned in [SearchResponse][google.cloud.retail.v2.SearchResponse].
     *
     * Supported fields for all [type][google.cloud.retail.v2.Product.type]s:
     *
     * * [audience][google.cloud.retail.v2.Product.audience]
     * * [availability][google.cloud.retail.v2.Product.availability]
     * * [brands][google.cloud.retail.v2.Product.brands]
     * * [color_info][google.cloud.retail.v2.Product.color_info]
     * * [conditions][google.cloud.retail.v2.Product.conditions]
     * * [gtin][google.cloud.retail.v2.Product.gtin]
     * * [materials][google.cloud.retail.v2.Product.materials]
     * * [name][google.cloud.retail.v2.Product.name]
     * * [patterns][google.cloud.retail.v2.Product.patterns]
     * * [price_info][google.cloud.retail.v2.Product.price_info]
     * * [rating][google.cloud.retail.v2.Product.rating]
     * * [sizes][google.cloud.retail.v2.Product.sizes]
     * * [title][google.cloud.retail.v2.Product.title]
     * * [uri][google.cloud.retail.v2.Product.uri]
     *
     * Supported fields only for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION]:
     *
     * * [categories][google.cloud.retail.v2.Product.categories]
     * * [description][google.cloud.retail.v2.Product.description]
     * * [images][google.cloud.retail.v2.Product.images]
     *
     * Supported fields only for
     * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]:
     *
     * * Only the first image in [images][google.cloud.retail.v2.Product.images]
     *
     * To mark [attributes][google.cloud.retail.v2.Product.attributes] as
     * retrievable, include paths of the form "attributes.key" where "key" is the
     * key of a custom attribute, as specified in
     * [attributes][google.cloud.retail.v2.Product.attributes].
     *
     * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
     * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], the
     * following fields are always returned in
     * [SearchResponse][google.cloud.retail.v2.SearchResponse] by default:
     *
     * * [name][google.cloud.retail.v2.Product.name]
     *
     * For [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT], the
     * following fields are always returned in by default:
     *
     * * [name][google.cloud.retail.v2.Product.name]
     * * [color_info][google.cloud.retail.v2.Product.color_info]
     *
     * The maximum number of paths is 30. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     *
     * Note: Returning more fields in
     * [SearchResponse][google.cloud.retail.v2.SearchResponse] can increase
     * response payload size and serving latency.
     *
     * This field is deprecated. Use the retrievable site-wide control instead.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask retrievable_fields = 30 [deprecated = true];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getRetrievableFieldsFieldBuilder() {
      if (retrievableFieldsBuilder_ == null) {
        retrievableFieldsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getRetrievableFields(), getParentForChildren(), isClean());
        retrievableFields_ = null;
      }
      return retrievableFieldsBuilder_;
    }

    private java.util.List<com.google.cloud.retail.v2.Product> variants_ =
        java.util.Collections.emptyList();

    private void ensureVariantsIsMutable() {
      if (!((bitField1_ & 0x00000001) != 0)) {
        variants_ = new java.util.ArrayList<com.google.cloud.retail.v2.Product>(variants_);
        bitField1_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2.Product,
            com.google.cloud.retail.v2.Product.Builder,
            com.google.cloud.retail.v2.ProductOrBuilder>
        variantsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Product variants grouped together on primary product which
     * share similar product attributes. It's automatically grouped by
     * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
     * all the product variants. Only populated for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.retail.v2.Product> getVariantsList() {
      if (variantsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(variants_);
      } else {
        return variantsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Product variants grouped together on primary product which
     * share similar product attributes. It's automatically grouped by
     * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
     * all the product variants. Only populated for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getVariantsCount() {
      if (variantsBuilder_ == null) {
        return variants_.size();
      } else {
        return variantsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Product variants grouped together on primary product which
     * share similar product attributes. It's automatically grouped by
     * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
     * all the product variants. Only populated for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2.Product getVariants(int index) {
      if (variantsBuilder_ == null) {
        return variants_.get(index);
      } else {
        return variantsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Product variants grouped together on primary product which
     * share similar product attributes. It's automatically grouped by
     * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
     * all the product variants. Only populated for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setVariants(int index, com.google.cloud.retail.v2.Product value) {
      if (variantsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVariantsIsMutable();
        variants_.set(index, value);
        onChanged();
      } else {
        variantsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Product variants grouped together on primary product which
     * share similar product attributes. It's automatically grouped by
     * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
     * all the product variants. Only populated for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setVariants(
        int index, com.google.cloud.retail.v2.Product.Builder builderForValue) {
      if (variantsBuilder_ == null) {
        ensureVariantsIsMutable();
        variants_.set(index, builderForValue.build());
        onChanged();
      } else {
        variantsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Product variants grouped together on primary product which
     * share similar product attributes. It's automatically grouped by
     * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
     * all the product variants. Only populated for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addVariants(com.google.cloud.retail.v2.Product value) {
      if (variantsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVariantsIsMutable();
        variants_.add(value);
        onChanged();
      } else {
        variantsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Product variants grouped together on primary product which
     * share similar product attributes. It's automatically grouped by
     * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
     * all the product variants. Only populated for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addVariants(int index, com.google.cloud.retail.v2.Product value) {
      if (variantsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVariantsIsMutable();
        variants_.add(index, value);
        onChanged();
      } else {
        variantsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Product variants grouped together on primary product which
     * share similar product attributes. It's automatically grouped by
     * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
     * all the product variants. Only populated for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addVariants(com.google.cloud.retail.v2.Product.Builder builderForValue) {
      if (variantsBuilder_ == null) {
        ensureVariantsIsMutable();
        variants_.add(builderForValue.build());
        onChanged();
      } else {
        variantsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Product variants grouped together on primary product which
     * share similar product attributes. It's automatically grouped by
     * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
     * all the product variants. Only populated for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addVariants(
        int index, com.google.cloud.retail.v2.Product.Builder builderForValue) {
      if (variantsBuilder_ == null) {
        ensureVariantsIsMutable();
        variants_.add(index, builderForValue.build());
        onChanged();
      } else {
        variantsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Product variants grouped together on primary product which
     * share similar product attributes. It's automatically grouped by
     * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
     * all the product variants. Only populated for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllVariants(
        java.lang.Iterable<? extends com.google.cloud.retail.v2.Product> values) {
      if (variantsBuilder_ == null) {
        ensureVariantsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, variants_);
        onChanged();
      } else {
        variantsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Product variants grouped together on primary product which
     * share similar product attributes. It's automatically grouped by
     * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
     * all the product variants. Only populated for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearVariants() {
      if (variantsBuilder_ == null) {
        variants_ = java.util.Collections.emptyList();
        bitField1_ = (bitField1_ & ~0x00000001);
        onChanged();
      } else {
        variantsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Product variants grouped together on primary product which
     * share similar product attributes. It's automatically grouped by
     * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
     * all the product variants. Only populated for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeVariants(int index) {
      if (variantsBuilder_ == null) {
        ensureVariantsIsMutable();
        variants_.remove(index);
        onChanged();
      } else {
        variantsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Product variants grouped together on primary product which
     * share similar product attributes. It's automatically grouped by
     * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
     * all the product variants. Only populated for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2.Product.Builder getVariantsBuilder(int index) {
      return getVariantsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Product variants grouped together on primary product which
     * share similar product attributes. It's automatically grouped by
     * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
     * all the product variants. Only populated for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2.ProductOrBuilder getVariantsOrBuilder(int index) {
      if (variantsBuilder_ == null) {
        return variants_.get(index);
      } else {
        return variantsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Product variants grouped together on primary product which
     * share similar product attributes. It's automatically grouped by
     * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
     * all the product variants. Only populated for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.retail.v2.ProductOrBuilder>
        getVariantsOrBuilderList() {
      if (variantsBuilder_ != null) {
        return variantsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(variants_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Product variants grouped together on primary product which
     * share similar product attributes. It's automatically grouped by
     * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
     * all the product variants. Only populated for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2.Product.Builder addVariantsBuilder() {
      return getVariantsFieldBuilder()
          .addBuilder(com.google.cloud.retail.v2.Product.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Product variants grouped together on primary product which
     * share similar product attributes. It's automatically grouped by
     * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
     * all the product variants. Only populated for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2.Product.Builder addVariantsBuilder(int index) {
      return getVariantsFieldBuilder()
          .addBuilder(index, com.google.cloud.retail.v2.Product.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Product variants grouped together on primary product which
     * share similar product attributes. It's automatically grouped by
     * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
     * all the product variants. Only populated for
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.retail.v2.Product.Builder> getVariantsBuilderList() {
      return getVariantsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2.Product,
            com.google.cloud.retail.v2.Product.Builder,
            com.google.cloud.retail.v2.ProductOrBuilder>
        getVariantsFieldBuilder() {
      if (variantsBuilder_ == null) {
        variantsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2.Product,
                com.google.cloud.retail.v2.Product.Builder,
                com.google.cloud.retail.v2.ProductOrBuilder>(
                variants_, ((bitField1_ & 0x00000001) != 0), getParentForChildren(), isClean());
        variants_ = null;
      }
      return variantsBuilder_;
    }

    private java.util.List<com.google.cloud.retail.v2.LocalInventory> localInventories_ =
        java.util.Collections.emptyList();

    private void ensureLocalInventoriesIsMutable() {
      if (!((bitField1_ & 0x00000002) != 0)) {
        localInventories_ =
            new java.util.ArrayList<com.google.cloud.retail.v2.LocalInventory>(localInventories_);
        bitField1_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2.LocalInventory,
            com.google.cloud.retail.v2.LocalInventory.Builder,
            com.google.cloud.retail.v2.LocalInventoryOrBuilder>
        localInventoriesBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. A list of local inventories specific to different places.
     *
     * This field can be managed by
     * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
     * and
     * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
     * APIs if fine-grained, high-volume updates are necessary.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.retail.v2.LocalInventory> getLocalInventoriesList() {
      if (localInventoriesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(localInventories_);
      } else {
        return localInventoriesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of local inventories specific to different places.
     *
     * This field can be managed by
     * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
     * and
     * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
     * APIs if fine-grained, high-volume updates are necessary.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getLocalInventoriesCount() {
      if (localInventoriesBuilder_ == null) {
        return localInventories_.size();
      } else {
        return localInventoriesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of local inventories specific to different places.
     *
     * This field can be managed by
     * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
     * and
     * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
     * APIs if fine-grained, high-volume updates are necessary.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2.LocalInventory getLocalInventories(int index) {
      if (localInventoriesBuilder_ == null) {
        return localInventories_.get(index);
      } else {
        return localInventoriesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of local inventories specific to different places.
     *
     * This field can be managed by
     * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
     * and
     * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
     * APIs if fine-grained, high-volume updates are necessary.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLocalInventories(int index, com.google.cloud.retail.v2.LocalInventory value) {
      if (localInventoriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocalInventoriesIsMutable();
        localInventories_.set(index, value);
        onChanged();
      } else {
        localInventoriesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of local inventories specific to different places.
     *
     * This field can be managed by
     * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
     * and
     * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
     * APIs if fine-grained, high-volume updates are necessary.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLocalInventories(
        int index, com.google.cloud.retail.v2.LocalInventory.Builder builderForValue) {
      if (localInventoriesBuilder_ == null) {
        ensureLocalInventoriesIsMutable();
        localInventories_.set(index, builderForValue.build());
        onChanged();
      } else {
        localInventoriesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of local inventories specific to different places.
     *
     * This field can be managed by
     * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
     * and
     * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
     * APIs if fine-grained, high-volume updates are necessary.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addLocalInventories(com.google.cloud.retail.v2.LocalInventory value) {
      if (localInventoriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocalInventoriesIsMutable();
        localInventories_.add(value);
        onChanged();
      } else {
        localInventoriesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of local inventories specific to different places.
     *
     * This field can be managed by
     * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
     * and
     * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
     * APIs if fine-grained, high-volume updates are necessary.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addLocalInventories(int index, com.google.cloud.retail.v2.LocalInventory value) {
      if (localInventoriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocalInventoriesIsMutable();
        localInventories_.add(index, value);
        onChanged();
      } else {
        localInventoriesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of local inventories specific to different places.
     *
     * This field can be managed by
     * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
     * and
     * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
     * APIs if fine-grained, high-volume updates are necessary.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addLocalInventories(
        com.google.cloud.retail.v2.LocalInventory.Builder builderForValue) {
      if (localInventoriesBuilder_ == null) {
        ensureLocalInventoriesIsMutable();
        localInventories_.add(builderForValue.build());
        onChanged();
      } else {
        localInventoriesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of local inventories specific to different places.
     *
     * This field can be managed by
     * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
     * and
     * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
     * APIs if fine-grained, high-volume updates are necessary.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addLocalInventories(
        int index, com.google.cloud.retail.v2.LocalInventory.Builder builderForValue) {
      if (localInventoriesBuilder_ == null) {
        ensureLocalInventoriesIsMutable();
        localInventories_.add(index, builderForValue.build());
        onChanged();
      } else {
        localInventoriesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of local inventories specific to different places.
     *
     * This field can be managed by
     * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
     * and
     * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
     * APIs if fine-grained, high-volume updates are necessary.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllLocalInventories(
        java.lang.Iterable<? extends com.google.cloud.retail.v2.LocalInventory> values) {
      if (localInventoriesBuilder_ == null) {
        ensureLocalInventoriesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, localInventories_);
        onChanged();
      } else {
        localInventoriesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of local inventories specific to different places.
     *
     * This field can be managed by
     * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
     * and
     * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
     * APIs if fine-grained, high-volume updates are necessary.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLocalInventories() {
      if (localInventoriesBuilder_ == null) {
        localInventories_ = java.util.Collections.emptyList();
        bitField1_ = (bitField1_ & ~0x00000002);
        onChanged();
      } else {
        localInventoriesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of local inventories specific to different places.
     *
     * This field can be managed by
     * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
     * and
     * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
     * APIs if fine-grained, high-volume updates are necessary.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeLocalInventories(int index) {
      if (localInventoriesBuilder_ == null) {
        ensureLocalInventoriesIsMutable();
        localInventories_.remove(index);
        onChanged();
      } else {
        localInventoriesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of local inventories specific to different places.
     *
     * This field can be managed by
     * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
     * and
     * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
     * APIs if fine-grained, high-volume updates are necessary.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2.LocalInventory.Builder getLocalInventoriesBuilder(int index) {
      return getLocalInventoriesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of local inventories specific to different places.
     *
     * This field can be managed by
     * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
     * and
     * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
     * APIs if fine-grained, high-volume updates are necessary.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2.LocalInventoryOrBuilder getLocalInventoriesOrBuilder(
        int index) {
      if (localInventoriesBuilder_ == null) {
        return localInventories_.get(index);
      } else {
        return localInventoriesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of local inventories specific to different places.
     *
     * This field can be managed by
     * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
     * and
     * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
     * APIs if fine-grained, high-volume updates are necessary.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.retail.v2.LocalInventoryOrBuilder>
        getLocalInventoriesOrBuilderList() {
      if (localInventoriesBuilder_ != null) {
        return localInventoriesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(localInventories_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of local inventories specific to different places.
     *
     * This field can be managed by
     * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
     * and
     * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
     * APIs if fine-grained, high-volume updates are necessary.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2.LocalInventory.Builder addLocalInventoriesBuilder() {
      return getLocalInventoriesFieldBuilder()
          .addBuilder(com.google.cloud.retail.v2.LocalInventory.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of local inventories specific to different places.
     *
     * This field can be managed by
     * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
     * and
     * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
     * APIs if fine-grained, high-volume updates are necessary.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2.LocalInventory.Builder addLocalInventoriesBuilder(int index) {
      return getLocalInventoriesFieldBuilder()
          .addBuilder(index, com.google.cloud.retail.v2.LocalInventory.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of local inventories specific to different places.
     *
     * This field can be managed by
     * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
     * and
     * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
     * APIs if fine-grained, high-volume updates are necessary.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.retail.v2.LocalInventory.Builder>
        getLocalInventoriesBuilderList() {
      return getLocalInventoriesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2.LocalInventory,
            com.google.cloud.retail.v2.LocalInventory.Builder,
            com.google.cloud.retail.v2.LocalInventoryOrBuilder>
        getLocalInventoriesFieldBuilder() {
      if (localInventoriesBuilder_ == null) {
        localInventoriesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2.LocalInventory,
                com.google.cloud.retail.v2.LocalInventory.Builder,
                com.google.cloud.retail.v2.LocalInventoryOrBuilder>(
                localInventories_,
                ((bitField1_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        localInventories_ = null;
      }
      return localInventoriesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.Product)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.Product)
  private static final com.google.cloud.retail.v2.Product DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2.Product();
  }

  public static com.google.cloud.retail.v2.Product getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Product> PARSER =
      new com.google.protobuf.AbstractParser<Product>() {
        @java.lang.Override
        public Product parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Product> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Product> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2.Product getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
