/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ControlName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CATALOG_CONTROL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/catalogs/{catalog}/controls/{control}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String catalog;
    private final String control;

    @Deprecated
    protected ControlName() {
        this.project = null;
        this.location = null;
        this.catalog = null;
        this.control = null;
    }

    private ControlName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.catalog = (String)Preconditions.checkNotNull((Object)builder.getCatalog());
        this.control = (String)Preconditions.checkNotNull((Object)builder.getControl());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getControl() {
        return this.control;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ControlName of(String project, String location, String catalog, String control) {
        return ControlName.newBuilder().setProject(project).setLocation(location).setCatalog(catalog).setControl(control).build();
    }

    public static String format(String project, String location, String catalog, String control) {
        return ControlName.newBuilder().setProject(project).setLocation(location).setCatalog(catalog).setControl(control).build().toString();
    }

    public static ControlName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CATALOG_CONTROL.validatedMatch(formattedString, "ControlName.parse: formattedString not in valid format");
        return ControlName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("catalog"), (String)matchMap.get("control"));
    }

    public static List<ControlName> parseList(List<String> formattedStrings) {
        ArrayList<ControlName> list = new ArrayList<ControlName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ControlName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ControlName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ControlName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CATALOG_CONTROL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ControlName controlName = this;
            synchronized (controlName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.catalog != null) {
                        fieldMapBuilder.put((Object)"catalog", (Object)this.catalog);
                    }
                    if (this.control != null) {
                        fieldMapBuilder.put((Object)"control", (Object)this.control);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CATALOG_CONTROL.instantiate(new String[]{"project", this.project, "location", this.location, "catalog", this.catalog, "control", this.control});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ControlName that = (ControlName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.catalog, that.catalog) && Objects.equals(this.control, that.control);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.catalog);
        h *= 1000003;
        return h ^= Objects.hashCode(this.control);
    }

    public static class Builder {
        private String project;
        private String location;
        private String catalog;
        private String control;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public String getControl() {
            return this.control;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCatalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public Builder setControl(String control) {
            this.control = control;
            return this;
        }

        private Builder(ControlName controlName) {
            this.project = controlName.project;
            this.location = controlName.location;
            this.catalog = controlName.catalog;
            this.control = controlName.control;
        }

        public ControlName build() {
            return new ControlName(this);
        }
    }
}

