/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2/product_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2;

/**
 *
 *
 * <pre>
 * Request message for
 * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2.AddLocalInventoriesRequest}
 */
public final class AddLocalInventoriesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.AddLocalInventoriesRequest)
    AddLocalInventoriesRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AddLocalInventoriesRequest.newBuilder() to construct.
  private AddLocalInventoriesRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AddLocalInventoriesRequest() {
    product_ = "";
    localInventories_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AddLocalInventoriesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2.ProductServiceProto
        .internal_static_google_cloud_retail_v2_AddLocalInventoriesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2.ProductServiceProto
        .internal_static_google_cloud_retail_v2_AddLocalInventoriesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2.AddLocalInventoriesRequest.class,
            com.google.cloud.retail.v2.AddLocalInventoriesRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PRODUCT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object product_ = "";
  /**
   *
   *
   * <pre>
   * Required. Full resource name of [Product][google.cloud.retail.v2.Product],
   * such as
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
   *
   * If the caller does not have permission to access the
   * [Product][google.cloud.retail.v2.Product], regardless of whether or not it
   * exists, a PERMISSION_DENIED error is returned.
   * </pre>
   *
   * <code>
   * string product = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The product.
   */
  @java.lang.Override
  public java.lang.String getProduct() {
    java.lang.Object ref = product_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      product_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Full resource name of [Product][google.cloud.retail.v2.Product],
   * such as
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
   *
   * If the caller does not have permission to access the
   * [Product][google.cloud.retail.v2.Product], regardless of whether or not it
   * exists, a PERMISSION_DENIED error is returned.
   * </pre>
   *
   * <code>
   * string product = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for product.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProductBytes() {
    java.lang.Object ref = product_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      product_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCAL_INVENTORIES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.retail.v2.LocalInventory> localInventories_;
  /**
   *
   *
   * <pre>
   * Required. A list of inventory information at difference places. Each place
   * is identified by its place ID. At most 3000 inventories are allowed per
   * request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2.LocalInventory> getLocalInventoriesList() {
    return localInventories_;
  }
  /**
   *
   *
   * <pre>
   * Required. A list of inventory information at difference places. Each place
   * is identified by its place ID. At most 3000 inventories are allowed per
   * request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.retail.v2.LocalInventoryOrBuilder>
      getLocalInventoriesOrBuilderList() {
    return localInventories_;
  }
  /**
   *
   *
   * <pre>
   * Required. A list of inventory information at difference places. Each place
   * is identified by its place ID. At most 3000 inventories are allowed per
   * request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getLocalInventoriesCount() {
    return localInventories_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. A list of inventory information at difference places. Each place
   * is identified by its place ID. At most 3000 inventories are allowed per
   * request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.LocalInventory getLocalInventories(int index) {
    return localInventories_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. A list of inventory information at difference places. Each place
   * is identified by its place ID. At most 3000 inventories are allowed per
   * request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.LocalInventoryOrBuilder getLocalInventoriesOrBuilder(
      int index) {
    return localInventories_.get(index);
  }

  public static final int ADD_MASK_FIELD_NUMBER = 4;
  private com.google.protobuf.FieldMask addMask_;
  /**
   *
   *
   * <pre>
   * Indicates which inventory fields in the provided list of
   * [LocalInventory][google.cloud.retail.v2.LocalInventory] to update. The
   * field is updated to the provided value.
   *
   * If a field is set while the place does not have a previous local inventory,
   * the local inventory at that store is created.
   *
   * If a field is set while the value of that field is not provided, the
   * original field value, if it exists, is deleted.
   *
   * If the mask is not set or set with empty paths, all inventory fields will
   * be updated.
   *
   * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
   * is returned and the entire update will be ignored.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask add_mask = 4;</code>
   *
   * @return Whether the addMask field is set.
   */
  @java.lang.Override
  public boolean hasAddMask() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Indicates which inventory fields in the provided list of
   * [LocalInventory][google.cloud.retail.v2.LocalInventory] to update. The
   * field is updated to the provided value.
   *
   * If a field is set while the place does not have a previous local inventory,
   * the local inventory at that store is created.
   *
   * If a field is set while the value of that field is not provided, the
   * original field value, if it exists, is deleted.
   *
   * If the mask is not set or set with empty paths, all inventory fields will
   * be updated.
   *
   * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
   * is returned and the entire update will be ignored.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask add_mask = 4;</code>
   *
   * @return The addMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getAddMask() {
    return addMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : addMask_;
  }
  /**
   *
   *
   * <pre>
   * Indicates which inventory fields in the provided list of
   * [LocalInventory][google.cloud.retail.v2.LocalInventory] to update. The
   * field is updated to the provided value.
   *
   * If a field is set while the place does not have a previous local inventory,
   * the local inventory at that store is created.
   *
   * If a field is set while the value of that field is not provided, the
   * original field value, if it exists, is deleted.
   *
   * If the mask is not set or set with empty paths, all inventory fields will
   * be updated.
   *
   * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
   * is returned and the entire update will be ignored.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask add_mask = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getAddMaskOrBuilder() {
    return addMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : addMask_;
  }

  public static final int ADD_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp addTime_;
  /**
   *
   *
   * <pre>
   * The time when the inventory updates are issued. Used to prevent
   * out-of-order updates on local inventory fields. If not provided, the
   * internal system time will be used.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp add_time = 5;</code>
   *
   * @return Whether the addTime field is set.
   */
  @java.lang.Override
  public boolean hasAddTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time when the inventory updates are issued. Used to prevent
   * out-of-order updates on local inventory fields. If not provided, the
   * internal system time will be used.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp add_time = 5;</code>
   *
   * @return The addTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getAddTime() {
    return addTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : addTime_;
  }
  /**
   *
   *
   * <pre>
   * The time when the inventory updates are issued. Used to prevent
   * out-of-order updates on local inventory fields. If not provided, the
   * internal system time will be used.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp add_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getAddTimeOrBuilder() {
    return addTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : addTime_;
  }

  public static final int ALLOW_MISSING_FIELD_NUMBER = 6;
  private boolean allowMissing_ = false;
  /**
   *
   *
   * <pre>
   * If set to true, and the [Product][google.cloud.retail.v2.Product] is not
   * found, the local inventory will still be processed and retained for at most
   * 1 day and processed once the [Product][google.cloud.retail.v2.Product] is
   * created. If set to false, a NOT_FOUND error is returned if the
   * [Product][google.cloud.retail.v2.Product] is not found.
   * </pre>
   *
   * <code>bool allow_missing = 6;</code>
   *
   * @return The allowMissing.
   */
  @java.lang.Override
  public boolean getAllowMissing() {
    return allowMissing_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(product_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, product_);
    }
    for (int i = 0; i < localInventories_.size(); i++) {
      output.writeMessage(2, localInventories_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getAddMask());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getAddTime());
    }
    if (allowMissing_ != false) {
      output.writeBool(6, allowMissing_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(product_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, product_);
    }
    for (int i = 0; i < localInventories_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, localInventories_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getAddMask());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getAddTime());
    }
    if (allowMissing_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, allowMissing_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2.AddLocalInventoriesRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2.AddLocalInventoriesRequest other =
        (com.google.cloud.retail.v2.AddLocalInventoriesRequest) obj;

    if (!getProduct().equals(other.getProduct())) return false;
    if (!getLocalInventoriesList().equals(other.getLocalInventoriesList())) return false;
    if (hasAddMask() != other.hasAddMask()) return false;
    if (hasAddMask()) {
      if (!getAddMask().equals(other.getAddMask())) return false;
    }
    if (hasAddTime() != other.hasAddTime()) return false;
    if (hasAddTime()) {
      if (!getAddTime().equals(other.getAddTime())) return false;
    }
    if (getAllowMissing() != other.getAllowMissing()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PRODUCT_FIELD_NUMBER;
    hash = (53 * hash) + getProduct().hashCode();
    if (getLocalInventoriesCount() > 0) {
      hash = (37 * hash) + LOCAL_INVENTORIES_FIELD_NUMBER;
      hash = (53 * hash) + getLocalInventoriesList().hashCode();
    }
    if (hasAddMask()) {
      hash = (37 * hash) + ADD_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getAddMask().hashCode();
    }
    if (hasAddTime()) {
      hash = (37 * hash) + ADD_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getAddTime().hashCode();
    }
    hash = (37 * hash) + ALLOW_MISSING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowMissing());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2.AddLocalInventoriesRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.AddLocalInventoriesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.AddLocalInventoriesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.AddLocalInventoriesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.AddLocalInventoriesRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.AddLocalInventoriesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.AddLocalInventoriesRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.AddLocalInventoriesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.AddLocalInventoriesRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.AddLocalInventoriesRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.AddLocalInventoriesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.AddLocalInventoriesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.retail.v2.AddLocalInventoriesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2.AddLocalInventoriesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.AddLocalInventoriesRequest)
      com.google.cloud.retail.v2.AddLocalInventoriesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2.ProductServiceProto
          .internal_static_google_cloud_retail_v2_AddLocalInventoriesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2.ProductServiceProto
          .internal_static_google_cloud_retail_v2_AddLocalInventoriesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2.AddLocalInventoriesRequest.class,
              com.google.cloud.retail.v2.AddLocalInventoriesRequest.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2.AddLocalInventoriesRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getLocalInventoriesFieldBuilder();
        getAddMaskFieldBuilder();
        getAddTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      product_ = "";
      if (localInventoriesBuilder_ == null) {
        localInventories_ = java.util.Collections.emptyList();
      } else {
        localInventories_ = null;
        localInventoriesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      addMask_ = null;
      if (addMaskBuilder_ != null) {
        addMaskBuilder_.dispose();
        addMaskBuilder_ = null;
      }
      addTime_ = null;
      if (addTimeBuilder_ != null) {
        addTimeBuilder_.dispose();
        addTimeBuilder_ = null;
      }
      allowMissing_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2.ProductServiceProto
          .internal_static_google_cloud_retail_v2_AddLocalInventoriesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.AddLocalInventoriesRequest getDefaultInstanceForType() {
      return com.google.cloud.retail.v2.AddLocalInventoriesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.AddLocalInventoriesRequest build() {
      com.google.cloud.retail.v2.AddLocalInventoriesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.AddLocalInventoriesRequest buildPartial() {
      com.google.cloud.retail.v2.AddLocalInventoriesRequest result =
          new com.google.cloud.retail.v2.AddLocalInventoriesRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.retail.v2.AddLocalInventoriesRequest result) {
      if (localInventoriesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          localInventories_ = java.util.Collections.unmodifiableList(localInventories_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.localInventories_ = localInventories_;
      } else {
        result.localInventories_ = localInventoriesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.retail.v2.AddLocalInventoriesRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.product_ = product_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.addMask_ = addMaskBuilder_ == null ? addMask_ : addMaskBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.addTime_ = addTimeBuilder_ == null ? addTime_ : addTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.allowMissing_ = allowMissing_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2.AddLocalInventoriesRequest) {
        return mergeFrom((com.google.cloud.retail.v2.AddLocalInventoriesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2.AddLocalInventoriesRequest other) {
      if (other == com.google.cloud.retail.v2.AddLocalInventoriesRequest.getDefaultInstance())
        return this;
      if (!other.getProduct().isEmpty()) {
        product_ = other.product_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (localInventoriesBuilder_ == null) {
        if (!other.localInventories_.isEmpty()) {
          if (localInventories_.isEmpty()) {
            localInventories_ = other.localInventories_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureLocalInventoriesIsMutable();
            localInventories_.addAll(other.localInventories_);
          }
          onChanged();
        }
      } else {
        if (!other.localInventories_.isEmpty()) {
          if (localInventoriesBuilder_.isEmpty()) {
            localInventoriesBuilder_.dispose();
            localInventoriesBuilder_ = null;
            localInventories_ = other.localInventories_;
            bitField0_ = (bitField0_ & ~0x00000002);
            localInventoriesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLocalInventoriesFieldBuilder()
                    : null;
          } else {
            localInventoriesBuilder_.addAllMessages(other.localInventories_);
          }
        }
      }
      if (other.hasAddMask()) {
        mergeAddMask(other.getAddMask());
      }
      if (other.hasAddTime()) {
        mergeAddTime(other.getAddTime());
      }
      if (other.getAllowMissing() != false) {
        setAllowMissing(other.getAllowMissing());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                product_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.retail.v2.LocalInventory m =
                    input.readMessage(
                        com.google.cloud.retail.v2.LocalInventory.parser(), extensionRegistry);
                if (localInventoriesBuilder_ == null) {
                  ensureLocalInventoriesIsMutable();
                  localInventories_.add(m);
                } else {
                  localInventoriesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 34:
              {
                input.readMessage(getAddMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getAddTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 48:
              {
                allowMissing_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 48
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object product_ = "";
    /**
     *
     *
     * <pre>
     * Required. Full resource name of [Product][google.cloud.retail.v2.Product],
     * such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
     *
     * If the caller does not have permission to access the
     * [Product][google.cloud.retail.v2.Product], regardless of whether or not it
     * exists, a PERMISSION_DENIED error is returned.
     * </pre>
     *
     * <code>
     * string product = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The product.
     */
    public java.lang.String getProduct() {
      java.lang.Object ref = product_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        product_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of [Product][google.cloud.retail.v2.Product],
     * such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
     *
     * If the caller does not have permission to access the
     * [Product][google.cloud.retail.v2.Product], regardless of whether or not it
     * exists, a PERMISSION_DENIED error is returned.
     * </pre>
     *
     * <code>
     * string product = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for product.
     */
    public com.google.protobuf.ByteString getProductBytes() {
      java.lang.Object ref = product_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        product_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of [Product][google.cloud.retail.v2.Product],
     * such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
     *
     * If the caller does not have permission to access the
     * [Product][google.cloud.retail.v2.Product], regardless of whether or not it
     * exists, a PERMISSION_DENIED error is returned.
     * </pre>
     *
     * <code>
     * string product = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The product to set.
     * @return This builder for chaining.
     */
    public Builder setProduct(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      product_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of [Product][google.cloud.retail.v2.Product],
     * such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
     *
     * If the caller does not have permission to access the
     * [Product][google.cloud.retail.v2.Product], regardless of whether or not it
     * exists, a PERMISSION_DENIED error is returned.
     * </pre>
     *
     * <code>
     * string product = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProduct() {
      product_ = getDefaultInstance().getProduct();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of [Product][google.cloud.retail.v2.Product],
     * such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
     *
     * If the caller does not have permission to access the
     * [Product][google.cloud.retail.v2.Product], regardless of whether or not it
     * exists, a PERMISSION_DENIED error is returned.
     * </pre>
     *
     * <code>
     * string product = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for product to set.
     * @return This builder for chaining.
     */
    public Builder setProductBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      product_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.retail.v2.LocalInventory> localInventories_ =
        java.util.Collections.emptyList();

    private void ensureLocalInventoriesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        localInventories_ =
            new java.util.ArrayList<com.google.cloud.retail.v2.LocalInventory>(localInventories_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2.LocalInventory,
            com.google.cloud.retail.v2.LocalInventory.Builder,
            com.google.cloud.retail.v2.LocalInventoryOrBuilder>
        localInventoriesBuilder_;

    /**
     *
     *
     * <pre>
     * Required. A list of inventory information at difference places. Each place
     * is identified by its place ID. At most 3000 inventories are allowed per
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.retail.v2.LocalInventory> getLocalInventoriesList() {
      if (localInventoriesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(localInventories_);
      } else {
        return localInventoriesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A list of inventory information at difference places. Each place
     * is identified by its place ID. At most 3000 inventories are allowed per
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getLocalInventoriesCount() {
      if (localInventoriesBuilder_ == null) {
        return localInventories_.size();
      } else {
        return localInventoriesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A list of inventory information at difference places. Each place
     * is identified by its place ID. At most 3000 inventories are allowed per
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.retail.v2.LocalInventory getLocalInventories(int index) {
      if (localInventoriesBuilder_ == null) {
        return localInventories_.get(index);
      } else {
        return localInventoriesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A list of inventory information at difference places. Each place
     * is identified by its place ID. At most 3000 inventories are allowed per
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setLocalInventories(int index, com.google.cloud.retail.v2.LocalInventory value) {
      if (localInventoriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocalInventoriesIsMutable();
        localInventories_.set(index, value);
        onChanged();
      } else {
        localInventoriesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of inventory information at difference places. Each place
     * is identified by its place ID. At most 3000 inventories are allowed per
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setLocalInventories(
        int index, com.google.cloud.retail.v2.LocalInventory.Builder builderForValue) {
      if (localInventoriesBuilder_ == null) {
        ensureLocalInventoriesIsMutable();
        localInventories_.set(index, builderForValue.build());
        onChanged();
      } else {
        localInventoriesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of inventory information at difference places. Each place
     * is identified by its place ID. At most 3000 inventories are allowed per
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addLocalInventories(com.google.cloud.retail.v2.LocalInventory value) {
      if (localInventoriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocalInventoriesIsMutable();
        localInventories_.add(value);
        onChanged();
      } else {
        localInventoriesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of inventory information at difference places. Each place
     * is identified by its place ID. At most 3000 inventories are allowed per
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addLocalInventories(int index, com.google.cloud.retail.v2.LocalInventory value) {
      if (localInventoriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocalInventoriesIsMutable();
        localInventories_.add(index, value);
        onChanged();
      } else {
        localInventoriesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of inventory information at difference places. Each place
     * is identified by its place ID. At most 3000 inventories are allowed per
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addLocalInventories(
        com.google.cloud.retail.v2.LocalInventory.Builder builderForValue) {
      if (localInventoriesBuilder_ == null) {
        ensureLocalInventoriesIsMutable();
        localInventories_.add(builderForValue.build());
        onChanged();
      } else {
        localInventoriesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of inventory information at difference places. Each place
     * is identified by its place ID. At most 3000 inventories are allowed per
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addLocalInventories(
        int index, com.google.cloud.retail.v2.LocalInventory.Builder builderForValue) {
      if (localInventoriesBuilder_ == null) {
        ensureLocalInventoriesIsMutable();
        localInventories_.add(index, builderForValue.build());
        onChanged();
      } else {
        localInventoriesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of inventory information at difference places. Each place
     * is identified by its place ID. At most 3000 inventories are allowed per
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllLocalInventories(
        java.lang.Iterable<? extends com.google.cloud.retail.v2.LocalInventory> values) {
      if (localInventoriesBuilder_ == null) {
        ensureLocalInventoriesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, localInventories_);
        onChanged();
      } else {
        localInventoriesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of inventory information at difference places. Each place
     * is identified by its place ID. At most 3000 inventories are allowed per
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearLocalInventories() {
      if (localInventoriesBuilder_ == null) {
        localInventories_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        localInventoriesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of inventory information at difference places. Each place
     * is identified by its place ID. At most 3000 inventories are allowed per
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeLocalInventories(int index) {
      if (localInventoriesBuilder_ == null) {
        ensureLocalInventoriesIsMutable();
        localInventories_.remove(index);
        onChanged();
      } else {
        localInventoriesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of inventory information at difference places. Each place
     * is identified by its place ID. At most 3000 inventories are allowed per
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.retail.v2.LocalInventory.Builder getLocalInventoriesBuilder(int index) {
      return getLocalInventoriesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. A list of inventory information at difference places. Each place
     * is identified by its place ID. At most 3000 inventories are allowed per
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.retail.v2.LocalInventoryOrBuilder getLocalInventoriesOrBuilder(
        int index) {
      if (localInventoriesBuilder_ == null) {
        return localInventories_.get(index);
      } else {
        return localInventoriesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A list of inventory information at difference places. Each place
     * is identified by its place ID. At most 3000 inventories are allowed per
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.retail.v2.LocalInventoryOrBuilder>
        getLocalInventoriesOrBuilderList() {
      if (localInventoriesBuilder_ != null) {
        return localInventoriesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(localInventories_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A list of inventory information at difference places. Each place
     * is identified by its place ID. At most 3000 inventories are allowed per
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.retail.v2.LocalInventory.Builder addLocalInventoriesBuilder() {
      return getLocalInventoriesFieldBuilder()
          .addBuilder(com.google.cloud.retail.v2.LocalInventory.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. A list of inventory information at difference places. Each place
     * is identified by its place ID. At most 3000 inventories are allowed per
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.retail.v2.LocalInventory.Builder addLocalInventoriesBuilder(int index) {
      return getLocalInventoriesFieldBuilder()
          .addBuilder(index, com.google.cloud.retail.v2.LocalInventory.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. A list of inventory information at difference places. Each place
     * is identified by its place ID. At most 3000 inventories are allowed per
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.retail.v2.LocalInventory.Builder>
        getLocalInventoriesBuilderList() {
      return getLocalInventoriesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2.LocalInventory,
            com.google.cloud.retail.v2.LocalInventory.Builder,
            com.google.cloud.retail.v2.LocalInventoryOrBuilder>
        getLocalInventoriesFieldBuilder() {
      if (localInventoriesBuilder_ == null) {
        localInventoriesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2.LocalInventory,
                com.google.cloud.retail.v2.LocalInventory.Builder,
                com.google.cloud.retail.v2.LocalInventoryOrBuilder>(
                localInventories_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        localInventories_ = null;
      }
      return localInventoriesBuilder_;
    }

    private com.google.protobuf.FieldMask addMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        addMaskBuilder_;
    /**
     *
     *
     * <pre>
     * Indicates which inventory fields in the provided list of
     * [LocalInventory][google.cloud.retail.v2.LocalInventory] to update. The
     * field is updated to the provided value.
     *
     * If a field is set while the place does not have a previous local inventory,
     * the local inventory at that store is created.
     *
     * If a field is set while the value of that field is not provided, the
     * original field value, if it exists, is deleted.
     *
     * If the mask is not set or set with empty paths, all inventory fields will
     * be updated.
     *
     * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     * is returned and the entire update will be ignored.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask add_mask = 4;</code>
     *
     * @return Whether the addMask field is set.
     */
    public boolean hasAddMask() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Indicates which inventory fields in the provided list of
     * [LocalInventory][google.cloud.retail.v2.LocalInventory] to update. The
     * field is updated to the provided value.
     *
     * If a field is set while the place does not have a previous local inventory,
     * the local inventory at that store is created.
     *
     * If a field is set while the value of that field is not provided, the
     * original field value, if it exists, is deleted.
     *
     * If the mask is not set or set with empty paths, all inventory fields will
     * be updated.
     *
     * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     * is returned and the entire update will be ignored.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask add_mask = 4;</code>
     *
     * @return The addMask.
     */
    public com.google.protobuf.FieldMask getAddMask() {
      if (addMaskBuilder_ == null) {
        return addMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : addMask_;
      } else {
        return addMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates which inventory fields in the provided list of
     * [LocalInventory][google.cloud.retail.v2.LocalInventory] to update. The
     * field is updated to the provided value.
     *
     * If a field is set while the place does not have a previous local inventory,
     * the local inventory at that store is created.
     *
     * If a field is set while the value of that field is not provided, the
     * original field value, if it exists, is deleted.
     *
     * If the mask is not set or set with empty paths, all inventory fields will
     * be updated.
     *
     * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     * is returned and the entire update will be ignored.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask add_mask = 4;</code>
     */
    public Builder setAddMask(com.google.protobuf.FieldMask value) {
      if (addMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        addMask_ = value;
      } else {
        addMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates which inventory fields in the provided list of
     * [LocalInventory][google.cloud.retail.v2.LocalInventory] to update. The
     * field is updated to the provided value.
     *
     * If a field is set while the place does not have a previous local inventory,
     * the local inventory at that store is created.
     *
     * If a field is set while the value of that field is not provided, the
     * original field value, if it exists, is deleted.
     *
     * If the mask is not set or set with empty paths, all inventory fields will
     * be updated.
     *
     * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     * is returned and the entire update will be ignored.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask add_mask = 4;</code>
     */
    public Builder setAddMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (addMaskBuilder_ == null) {
        addMask_ = builderForValue.build();
      } else {
        addMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates which inventory fields in the provided list of
     * [LocalInventory][google.cloud.retail.v2.LocalInventory] to update. The
     * field is updated to the provided value.
     *
     * If a field is set while the place does not have a previous local inventory,
     * the local inventory at that store is created.
     *
     * If a field is set while the value of that field is not provided, the
     * original field value, if it exists, is deleted.
     *
     * If the mask is not set or set with empty paths, all inventory fields will
     * be updated.
     *
     * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     * is returned and the entire update will be ignored.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask add_mask = 4;</code>
     */
    public Builder mergeAddMask(com.google.protobuf.FieldMask value) {
      if (addMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && addMask_ != null
            && addMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getAddMaskBuilder().mergeFrom(value);
        } else {
          addMask_ = value;
        }
      } else {
        addMaskBuilder_.mergeFrom(value);
      }
      if (addMask_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates which inventory fields in the provided list of
     * [LocalInventory][google.cloud.retail.v2.LocalInventory] to update. The
     * field is updated to the provided value.
     *
     * If a field is set while the place does not have a previous local inventory,
     * the local inventory at that store is created.
     *
     * If a field is set while the value of that field is not provided, the
     * original field value, if it exists, is deleted.
     *
     * If the mask is not set or set with empty paths, all inventory fields will
     * be updated.
     *
     * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     * is returned and the entire update will be ignored.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask add_mask = 4;</code>
     */
    public Builder clearAddMask() {
      bitField0_ = (bitField0_ & ~0x00000004);
      addMask_ = null;
      if (addMaskBuilder_ != null) {
        addMaskBuilder_.dispose();
        addMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates which inventory fields in the provided list of
     * [LocalInventory][google.cloud.retail.v2.LocalInventory] to update. The
     * field is updated to the provided value.
     *
     * If a field is set while the place does not have a previous local inventory,
     * the local inventory at that store is created.
     *
     * If a field is set while the value of that field is not provided, the
     * original field value, if it exists, is deleted.
     *
     * If the mask is not set or set with empty paths, all inventory fields will
     * be updated.
     *
     * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     * is returned and the entire update will be ignored.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask add_mask = 4;</code>
     */
    public com.google.protobuf.FieldMask.Builder getAddMaskBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getAddMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Indicates which inventory fields in the provided list of
     * [LocalInventory][google.cloud.retail.v2.LocalInventory] to update. The
     * field is updated to the provided value.
     *
     * If a field is set while the place does not have a previous local inventory,
     * the local inventory at that store is created.
     *
     * If a field is set while the value of that field is not provided, the
     * original field value, if it exists, is deleted.
     *
     * If the mask is not set or set with empty paths, all inventory fields will
     * be updated.
     *
     * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     * is returned and the entire update will be ignored.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask add_mask = 4;</code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getAddMaskOrBuilder() {
      if (addMaskBuilder_ != null) {
        return addMaskBuilder_.getMessageOrBuilder();
      } else {
        return addMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : addMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates which inventory fields in the provided list of
     * [LocalInventory][google.cloud.retail.v2.LocalInventory] to update. The
     * field is updated to the provided value.
     *
     * If a field is set while the place does not have a previous local inventory,
     * the local inventory at that store is created.
     *
     * If a field is set while the value of that field is not provided, the
     * original field value, if it exists, is deleted.
     *
     * If the mask is not set or set with empty paths, all inventory fields will
     * be updated.
     *
     * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     * is returned and the entire update will be ignored.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask add_mask = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getAddMaskFieldBuilder() {
      if (addMaskBuilder_ == null) {
        addMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getAddMask(), getParentForChildren(), isClean());
        addMask_ = null;
      }
      return addMaskBuilder_;
    }

    private com.google.protobuf.Timestamp addTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        addTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time when the inventory updates are issued. Used to prevent
     * out-of-order updates on local inventory fields. If not provided, the
     * internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp add_time = 5;</code>
     *
     * @return Whether the addTime field is set.
     */
    public boolean hasAddTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time when the inventory updates are issued. Used to prevent
     * out-of-order updates on local inventory fields. If not provided, the
     * internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp add_time = 5;</code>
     *
     * @return The addTime.
     */
    public com.google.protobuf.Timestamp getAddTime() {
      if (addTimeBuilder_ == null) {
        return addTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : addTime_;
      } else {
        return addTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the inventory updates are issued. Used to prevent
     * out-of-order updates on local inventory fields. If not provided, the
     * internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp add_time = 5;</code>
     */
    public Builder setAddTime(com.google.protobuf.Timestamp value) {
      if (addTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        addTime_ = value;
      } else {
        addTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the inventory updates are issued. Used to prevent
     * out-of-order updates on local inventory fields. If not provided, the
     * internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp add_time = 5;</code>
     */
    public Builder setAddTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (addTimeBuilder_ == null) {
        addTime_ = builderForValue.build();
      } else {
        addTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the inventory updates are issued. Used to prevent
     * out-of-order updates on local inventory fields. If not provided, the
     * internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp add_time = 5;</code>
     */
    public Builder mergeAddTime(com.google.protobuf.Timestamp value) {
      if (addTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && addTime_ != null
            && addTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getAddTimeBuilder().mergeFrom(value);
        } else {
          addTime_ = value;
        }
      } else {
        addTimeBuilder_.mergeFrom(value);
      }
      if (addTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the inventory updates are issued. Used to prevent
     * out-of-order updates on local inventory fields. If not provided, the
     * internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp add_time = 5;</code>
     */
    public Builder clearAddTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      addTime_ = null;
      if (addTimeBuilder_ != null) {
        addTimeBuilder_.dispose();
        addTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the inventory updates are issued. Used to prevent
     * out-of-order updates on local inventory fields. If not provided, the
     * internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp add_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getAddTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getAddTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time when the inventory updates are issued. Used to prevent
     * out-of-order updates on local inventory fields. If not provided, the
     * internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp add_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getAddTimeOrBuilder() {
      if (addTimeBuilder_ != null) {
        return addTimeBuilder_.getMessageOrBuilder();
      } else {
        return addTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : addTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the inventory updates are issued. Used to prevent
     * out-of-order updates on local inventory fields. If not provided, the
     * internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp add_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getAddTimeFieldBuilder() {
      if (addTimeBuilder_ == null) {
        addTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getAddTime(), getParentForChildren(), isClean());
        addTime_ = null;
      }
      return addTimeBuilder_;
    }

    private boolean allowMissing_;
    /**
     *
     *
     * <pre>
     * If set to true, and the [Product][google.cloud.retail.v2.Product] is not
     * found, the local inventory will still be processed and retained for at most
     * 1 day and processed once the [Product][google.cloud.retail.v2.Product] is
     * created. If set to false, a NOT_FOUND error is returned if the
     * [Product][google.cloud.retail.v2.Product] is not found.
     * </pre>
     *
     * <code>bool allow_missing = 6;</code>
     *
     * @return The allowMissing.
     */
    @java.lang.Override
    public boolean getAllowMissing() {
      return allowMissing_;
    }
    /**
     *
     *
     * <pre>
     * If set to true, and the [Product][google.cloud.retail.v2.Product] is not
     * found, the local inventory will still be processed and retained for at most
     * 1 day and processed once the [Product][google.cloud.retail.v2.Product] is
     * created. If set to false, a NOT_FOUND error is returned if the
     * [Product][google.cloud.retail.v2.Product] is not found.
     * </pre>
     *
     * <code>bool allow_missing = 6;</code>
     *
     * @param value The allowMissing to set.
     * @return This builder for chaining.
     */
    public Builder setAllowMissing(boolean value) {

      allowMissing_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set to true, and the [Product][google.cloud.retail.v2.Product] is not
     * found, the local inventory will still be processed and retained for at most
     * 1 day and processed once the [Product][google.cloud.retail.v2.Product] is
     * created. If set to false, a NOT_FOUND error is returned if the
     * [Product][google.cloud.retail.v2.Product] is not found.
     * </pre>
     *
     * <code>bool allow_missing = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowMissing() {
      bitField0_ = (bitField0_ & ~0x00000010);
      allowMissing_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.AddLocalInventoriesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.AddLocalInventoriesRequest)
  private static final com.google.cloud.retail.v2.AddLocalInventoriesRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2.AddLocalInventoriesRequest();
  }

  public static com.google.cloud.retail.v2.AddLocalInventoriesRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AddLocalInventoriesRequest> PARSER =
      new com.google.protobuf.AbstractParser<AddLocalInventoriesRequest>() {
        @java.lang.Override
        public AddLocalInventoriesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AddLocalInventoriesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AddLocalInventoriesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2.AddLocalInventoriesRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
