/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2/catalog.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2;

/**
 *
 *
 * <pre>
 * Catalog level attribute config.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2.AttributesConfig}
 */
public final class AttributesConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.AttributesConfig)
    AttributesConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AttributesConfig.newBuilder() to construct.
  private AttributesConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AttributesConfig() {
    name_ = "";
    attributeConfigLevel_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AttributesConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2.CatalogProto
        .internal_static_google_cloud_retail_v2_AttributesConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 2:
        return internalGetCatalogAttributes();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2.CatalogProto
        .internal_static_google_cloud_retail_v2_AttributesConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2.AttributesConfig.class,
            com.google.cloud.retail.v2.AttributesConfig.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. Immutable. The fully qualified resource name of the attribute
   * config. Format: `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;attributesConfig`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. The fully qualified resource name of the attribute
   * config. Format: `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;attributesConfig`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CATALOG_ATTRIBUTES_FIELD_NUMBER = 2;

  private static final class CatalogAttributesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.retail.v2.CatalogAttribute>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.retail.v2.CatalogAttribute>newDefaultInstance(
                    com.google.cloud.retail.v2.CatalogProto
                        .internal_static_google_cloud_retail_v2_AttributesConfig_CatalogAttributesEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.cloud.retail.v2.CatalogAttribute.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.retail.v2.CatalogAttribute>
      catalogAttributes_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.retail.v2.CatalogAttribute>
      internalGetCatalogAttributes() {
    if (catalogAttributes_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          CatalogAttributesDefaultEntryHolder.defaultEntry);
    }
    return catalogAttributes_;
  }

  public int getCatalogAttributesCount() {
    return internalGetCatalogAttributes().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Enable attribute(s) config at catalog level.
   * For example, indexable, dynamic_facetable, or searchable for each
   * attribute.
   *
   * The key is catalog attribute's name.
   * For example: `color`, `brands`, `attributes.custom_attribute`, such as
   * `attributes.xyz`.
   *
   * The maximum number of catalog attributes allowed in a request is 1000.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.retail.v2.CatalogAttribute&gt; catalog_attributes = 2;
   * </code>
   */
  @java.lang.Override
  public boolean containsCatalogAttributes(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetCatalogAttributes().getMap().containsKey(key);
  }
  /** Use {@link #getCatalogAttributesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.retail.v2.CatalogAttribute>
      getCatalogAttributes() {
    return getCatalogAttributesMap();
  }
  /**
   *
   *
   * <pre>
   * Enable attribute(s) config at catalog level.
   * For example, indexable, dynamic_facetable, or searchable for each
   * attribute.
   *
   * The key is catalog attribute's name.
   * For example: `color`, `brands`, `attributes.custom_attribute`, such as
   * `attributes.xyz`.
   *
   * The maximum number of catalog attributes allowed in a request is 1000.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.retail.v2.CatalogAttribute&gt; catalog_attributes = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.retail.v2.CatalogAttribute>
      getCatalogAttributesMap() {
    return internalGetCatalogAttributes().getMap();
  }
  /**
   *
   *
   * <pre>
   * Enable attribute(s) config at catalog level.
   * For example, indexable, dynamic_facetable, or searchable for each
   * attribute.
   *
   * The key is catalog attribute's name.
   * For example: `color`, `brands`, `attributes.custom_attribute`, such as
   * `attributes.xyz`.
   *
   * The maximum number of catalog attributes allowed in a request is 1000.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.retail.v2.CatalogAttribute&gt; catalog_attributes = 2;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.retail.v2.CatalogAttribute getCatalogAttributesOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.retail.v2.CatalogAttribute defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.retail.v2.CatalogAttribute> map =
        internalGetCatalogAttributes().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Enable attribute(s) config at catalog level.
   * For example, indexable, dynamic_facetable, or searchable for each
   * attribute.
   *
   * The key is catalog attribute's name.
   * For example: `color`, `brands`, `attributes.custom_attribute`, such as
   * `attributes.xyz`.
   *
   * The maximum number of catalog attributes allowed in a request is 1000.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.retail.v2.CatalogAttribute&gt; catalog_attributes = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.CatalogAttribute getCatalogAttributesOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.retail.v2.CatalogAttribute> map =
        internalGetCatalogAttributes().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ATTRIBUTE_CONFIG_LEVEL_FIELD_NUMBER = 3;
  private int attributeConfigLevel_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The
   * [AttributeConfigLevel][google.cloud.retail.v2.AttributeConfigLevel] used
   * for this catalog.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2.AttributeConfigLevel attribute_config_level = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for attributeConfigLevel.
   */
  @java.lang.Override
  public int getAttributeConfigLevelValue() {
    return attributeConfigLevel_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The
   * [AttributeConfigLevel][google.cloud.retail.v2.AttributeConfigLevel] used
   * for this catalog.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2.AttributeConfigLevel attribute_config_level = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The attributeConfigLevel.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.AttributeConfigLevel getAttributeConfigLevel() {
    com.google.cloud.retail.v2.AttributeConfigLevel result =
        com.google.cloud.retail.v2.AttributeConfigLevel.forNumber(attributeConfigLevel_);
    return result == null ? com.google.cloud.retail.v2.AttributeConfigLevel.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetCatalogAttributes(),
        CatalogAttributesDefaultEntryHolder.defaultEntry,
        2);
    if (attributeConfigLevel_
        != com.google.cloud.retail.v2.AttributeConfigLevel.ATTRIBUTE_CONFIG_LEVEL_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, attributeConfigLevel_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.retail.v2.CatalogAttribute> entry :
        internalGetCatalogAttributes().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.cloud.retail.v2.CatalogAttribute>
          catalogAttributes__ =
              CatalogAttributesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, catalogAttributes__);
    }
    if (attributeConfigLevel_
        != com.google.cloud.retail.v2.AttributeConfigLevel.ATTRIBUTE_CONFIG_LEVEL_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, attributeConfigLevel_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2.AttributesConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2.AttributesConfig other =
        (com.google.cloud.retail.v2.AttributesConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (!internalGetCatalogAttributes().equals(other.internalGetCatalogAttributes())) return false;
    if (attributeConfigLevel_ != other.attributeConfigLevel_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (!internalGetCatalogAttributes().getMap().isEmpty()) {
      hash = (37 * hash) + CATALOG_ATTRIBUTES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetCatalogAttributes().hashCode();
    }
    hash = (37 * hash) + ATTRIBUTE_CONFIG_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + attributeConfigLevel_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2.AttributesConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.AttributesConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.AttributesConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.AttributesConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.AttributesConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.AttributesConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.AttributesConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.AttributesConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.AttributesConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.AttributesConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.AttributesConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.AttributesConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2.AttributesConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Catalog level attribute config.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2.AttributesConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.AttributesConfig)
      com.google.cloud.retail.v2.AttributesConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2.CatalogProto
          .internal_static_google_cloud_retail_v2_AttributesConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetCatalogAttributes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetMutableCatalogAttributes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2.CatalogProto
          .internal_static_google_cloud_retail_v2_AttributesConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2.AttributesConfig.class,
              com.google.cloud.retail.v2.AttributesConfig.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2.AttributesConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      internalGetMutableCatalogAttributes().clear();
      attributeConfigLevel_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2.CatalogProto
          .internal_static_google_cloud_retail_v2_AttributesConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.AttributesConfig getDefaultInstanceForType() {
      return com.google.cloud.retail.v2.AttributesConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.AttributesConfig build() {
      com.google.cloud.retail.v2.AttributesConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.AttributesConfig buildPartial() {
      com.google.cloud.retail.v2.AttributesConfig result =
          new com.google.cloud.retail.v2.AttributesConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.retail.v2.AttributesConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.catalogAttributes_ =
            internalGetCatalogAttributes().build(CatalogAttributesDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.attributeConfigLevel_ = attributeConfigLevel_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2.AttributesConfig) {
        return mergeFrom((com.google.cloud.retail.v2.AttributesConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2.AttributesConfig other) {
      if (other == com.google.cloud.retail.v2.AttributesConfig.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      internalGetMutableCatalogAttributes().mergeFrom(other.internalGetCatalogAttributes());
      bitField0_ |= 0x00000002;
      if (other.attributeConfigLevel_ != 0) {
        setAttributeConfigLevelValue(other.getAttributeConfigLevelValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.retail.v2.CatalogAttribute>
                    catalogAttributes__ =
                        input.readMessage(
                            CatalogAttributesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableCatalogAttributes()
                    .ensureBuilderMap()
                    .put(catalogAttributes__.getKey(), catalogAttributes__.getValue());
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                attributeConfigLevel_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Immutable. The fully qualified resource name of the attribute
     * config. Format: `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;attributesConfig`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The fully qualified resource name of the attribute
     * config. Format: `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;attributesConfig`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The fully qualified resource name of the attribute
     * config. Format: `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;attributesConfig`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The fully qualified resource name of the attribute
     * config. Format: `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;attributesConfig`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The fully qualified resource name of the attribute
     * config. Format: `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;attributesConfig`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private static final class CatalogAttributesConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.retail.v2.CatalogAttributeOrBuilder,
            com.google.cloud.retail.v2.CatalogAttribute> {
      @java.lang.Override
      public com.google.cloud.retail.v2.CatalogAttribute build(
          com.google.cloud.retail.v2.CatalogAttributeOrBuilder val) {
        if (val instanceof com.google.cloud.retail.v2.CatalogAttribute) {
          return (com.google.cloud.retail.v2.CatalogAttribute) val;
        }
        return ((com.google.cloud.retail.v2.CatalogAttribute.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.retail.v2.CatalogAttribute>
          defaultEntry() {
        return CatalogAttributesDefaultEntryHolder.defaultEntry;
      }
    };

    private static final CatalogAttributesConverter catalogAttributesConverter =
        new CatalogAttributesConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.retail.v2.CatalogAttributeOrBuilder,
            com.google.cloud.retail.v2.CatalogAttribute,
            com.google.cloud.retail.v2.CatalogAttribute.Builder>
        catalogAttributes_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.retail.v2.CatalogAttributeOrBuilder,
            com.google.cloud.retail.v2.CatalogAttribute,
            com.google.cloud.retail.v2.CatalogAttribute.Builder>
        internalGetCatalogAttributes() {
      if (catalogAttributes_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(catalogAttributesConverter);
      }
      return catalogAttributes_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.retail.v2.CatalogAttributeOrBuilder,
            com.google.cloud.retail.v2.CatalogAttribute,
            com.google.cloud.retail.v2.CatalogAttribute.Builder>
        internalGetMutableCatalogAttributes() {
      if (catalogAttributes_ == null) {
        catalogAttributes_ = new com.google.protobuf.MapFieldBuilder<>(catalogAttributesConverter);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return catalogAttributes_;
    }

    public int getCatalogAttributesCount() {
      return internalGetCatalogAttributes().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * Enable attribute(s) config at catalog level.
     * For example, indexable, dynamic_facetable, or searchable for each
     * attribute.
     *
     * The key is catalog attribute's name.
     * For example: `color`, `brands`, `attributes.custom_attribute`, such as
     * `attributes.xyz`.
     *
     * The maximum number of catalog attributes allowed in a request is 1000.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2.CatalogAttribute&gt; catalog_attributes = 2;
     * </code>
     */
    @java.lang.Override
    public boolean containsCatalogAttributes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetCatalogAttributes().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getCatalogAttributesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.retail.v2.CatalogAttribute>
        getCatalogAttributes() {
      return getCatalogAttributesMap();
    }
    /**
     *
     *
     * <pre>
     * Enable attribute(s) config at catalog level.
     * For example, indexable, dynamic_facetable, or searchable for each
     * attribute.
     *
     * The key is catalog attribute's name.
     * For example: `color`, `brands`, `attributes.custom_attribute`, such as
     * `attributes.xyz`.
     *
     * The maximum number of catalog attributes allowed in a request is 1000.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2.CatalogAttribute&gt; catalog_attributes = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.retail.v2.CatalogAttribute>
        getCatalogAttributesMap() {
      return internalGetCatalogAttributes().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * Enable attribute(s) config at catalog level.
     * For example, indexable, dynamic_facetable, or searchable for each
     * attribute.
     *
     * The key is catalog attribute's name.
     * For example: `color`, `brands`, `attributes.custom_attribute`, such as
     * `attributes.xyz`.
     *
     * The maximum number of catalog attributes allowed in a request is 1000.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2.CatalogAttribute&gt; catalog_attributes = 2;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.retail.v2.CatalogAttribute getCatalogAttributesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.retail.v2.CatalogAttribute defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.retail.v2.CatalogAttributeOrBuilder> map =
          internalGetMutableCatalogAttributes().ensureBuilderMap();
      return map.containsKey(key) ? catalogAttributesConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Enable attribute(s) config at catalog level.
     * For example, indexable, dynamic_facetable, or searchable for each
     * attribute.
     *
     * The key is catalog attribute's name.
     * For example: `color`, `brands`, `attributes.custom_attribute`, such as
     * `attributes.xyz`.
     *
     * The maximum number of catalog attributes allowed in a request is 1000.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2.CatalogAttribute&gt; catalog_attributes = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.CatalogAttribute getCatalogAttributesOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.retail.v2.CatalogAttributeOrBuilder> map =
          internalGetMutableCatalogAttributes().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return catalogAttributesConverter.build(map.get(key));
    }

    public Builder clearCatalogAttributes() {
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableCatalogAttributes().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable attribute(s) config at catalog level.
     * For example, indexable, dynamic_facetable, or searchable for each
     * attribute.
     *
     * The key is catalog attribute's name.
     * For example: `color`, `brands`, `attributes.custom_attribute`, such as
     * `attributes.xyz`.
     *
     * The maximum number of catalog attributes allowed in a request is 1000.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2.CatalogAttribute&gt; catalog_attributes = 2;
     * </code>
     */
    public Builder removeCatalogAttributes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableCatalogAttributes().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.retail.v2.CatalogAttribute>
        getMutableCatalogAttributes() {
      bitField0_ |= 0x00000002;
      return internalGetMutableCatalogAttributes().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * Enable attribute(s) config at catalog level.
     * For example, indexable, dynamic_facetable, or searchable for each
     * attribute.
     *
     * The key is catalog attribute's name.
     * For example: `color`, `brands`, `attributes.custom_attribute`, such as
     * `attributes.xyz`.
     *
     * The maximum number of catalog attributes allowed in a request is 1000.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2.CatalogAttribute&gt; catalog_attributes = 2;
     * </code>
     */
    public Builder putCatalogAttributes(
        java.lang.String key, com.google.cloud.retail.v2.CatalogAttribute value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableCatalogAttributes().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable attribute(s) config at catalog level.
     * For example, indexable, dynamic_facetable, or searchable for each
     * attribute.
     *
     * The key is catalog attribute's name.
     * For example: `color`, `brands`, `attributes.custom_attribute`, such as
     * `attributes.xyz`.
     *
     * The maximum number of catalog attributes allowed in a request is 1000.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2.CatalogAttribute&gt; catalog_attributes = 2;
     * </code>
     */
    public Builder putAllCatalogAttributes(
        java.util.Map<java.lang.String, com.google.cloud.retail.v2.CatalogAttribute> values) {
      for (java.util.Map.Entry<java.lang.String, com.google.cloud.retail.v2.CatalogAttribute> e :
          values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableCatalogAttributes().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable attribute(s) config at catalog level.
     * For example, indexable, dynamic_facetable, or searchable for each
     * attribute.
     *
     * The key is catalog attribute's name.
     * For example: `color`, `brands`, `attributes.custom_attribute`, such as
     * `attributes.xyz`.
     *
     * The maximum number of catalog attributes allowed in a request is 1000.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2.CatalogAttribute&gt; catalog_attributes = 2;
     * </code>
     */
    public com.google.cloud.retail.v2.CatalogAttribute.Builder putCatalogAttributesBuilderIfAbsent(
        java.lang.String key) {
      java.util.Map<java.lang.String, com.google.cloud.retail.v2.CatalogAttributeOrBuilder>
          builderMap = internalGetMutableCatalogAttributes().ensureBuilderMap();
      com.google.cloud.retail.v2.CatalogAttributeOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.retail.v2.CatalogAttribute.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.retail.v2.CatalogAttribute) {
        entry = ((com.google.cloud.retail.v2.CatalogAttribute) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.retail.v2.CatalogAttribute.Builder) entry;
    }

    private int attributeConfigLevel_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The
     * [AttributeConfigLevel][google.cloud.retail.v2.AttributeConfigLevel] used
     * for this catalog.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.AttributeConfigLevel attribute_config_level = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for attributeConfigLevel.
     */
    @java.lang.Override
    public int getAttributeConfigLevelValue() {
      return attributeConfigLevel_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The
     * [AttributeConfigLevel][google.cloud.retail.v2.AttributeConfigLevel] used
     * for this catalog.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.AttributeConfigLevel attribute_config_level = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for attributeConfigLevel to set.
     * @return This builder for chaining.
     */
    public Builder setAttributeConfigLevelValue(int value) {
      attributeConfigLevel_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The
     * [AttributeConfigLevel][google.cloud.retail.v2.AttributeConfigLevel] used
     * for this catalog.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.AttributeConfigLevel attribute_config_level = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The attributeConfigLevel.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.AttributeConfigLevel getAttributeConfigLevel() {
      com.google.cloud.retail.v2.AttributeConfigLevel result =
          com.google.cloud.retail.v2.AttributeConfigLevel.forNumber(attributeConfigLevel_);
      return result == null ? com.google.cloud.retail.v2.AttributeConfigLevel.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The
     * [AttributeConfigLevel][google.cloud.retail.v2.AttributeConfigLevel] used
     * for this catalog.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.AttributeConfigLevel attribute_config_level = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The attributeConfigLevel to set.
     * @return This builder for chaining.
     */
    public Builder setAttributeConfigLevel(com.google.cloud.retail.v2.AttributeConfigLevel value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      attributeConfigLevel_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The
     * [AttributeConfigLevel][google.cloud.retail.v2.AttributeConfigLevel] used
     * for this catalog.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.AttributeConfigLevel attribute_config_level = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAttributeConfigLevel() {
      bitField0_ = (bitField0_ & ~0x00000004);
      attributeConfigLevel_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.AttributesConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.AttributesConfig)
  private static final com.google.cloud.retail.v2.AttributesConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2.AttributesConfig();
  }

  public static com.google.cloud.retail.v2.AttributesConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AttributesConfig> PARSER =
      new com.google.protobuf.AbstractParser<AttributesConfig>() {
        @java.lang.Override
        public AttributesConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AttributesConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AttributesConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2.AttributesConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
