/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2/common.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2;

/**
 *
 *
 * <pre>
 * The color information of a [Product][google.cloud.retail.v2.Product].
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2.ColorInfo}
 */
public final class ColorInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.ColorInfo)
    ColorInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ColorInfo.newBuilder() to construct.
  private ColorInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ColorInfo() {
    colorFamilies_ = com.google.protobuf.LazyStringArrayList.emptyList();
    colors_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ColorInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2.CommonProto
        .internal_static_google_cloud_retail_v2_ColorInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2.CommonProto
        .internal_static_google_cloud_retail_v2_ColorInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2.ColorInfo.class,
            com.google.cloud.retail.v2.ColorInfo.Builder.class);
  }

  public static final int COLOR_FAMILIES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList colorFamilies_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The standard color families. Strongly recommended to use the following
   * standard color groups: "Red", "Pink", "Orange", "Yellow", "Purple",
   * "Green", "Cyan", "Blue", "Brown", "White", "Gray", "Black" and
   * "Mixed". Normally it is expected to have only 1 color family. May consider
   * using single "Mixed" instead of multiple values.
   *
   * A maximum of 5 values are allowed. Each value must be a UTF-8 encoded
   * string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Google Merchant Center property
   * [color](https://support.google.com/merchants/answer/6324487). Schema.org
   * property [Product.color](https://schema.org/color).
   * </pre>
   *
   * <code>repeated string color_families = 1;</code>
   *
   * @return A list containing the colorFamilies.
   */
  public com.google.protobuf.ProtocolStringList getColorFamiliesList() {
    return colorFamilies_;
  }
  /**
   *
   *
   * <pre>
   * The standard color families. Strongly recommended to use the following
   * standard color groups: "Red", "Pink", "Orange", "Yellow", "Purple",
   * "Green", "Cyan", "Blue", "Brown", "White", "Gray", "Black" and
   * "Mixed". Normally it is expected to have only 1 color family. May consider
   * using single "Mixed" instead of multiple values.
   *
   * A maximum of 5 values are allowed. Each value must be a UTF-8 encoded
   * string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Google Merchant Center property
   * [color](https://support.google.com/merchants/answer/6324487). Schema.org
   * property [Product.color](https://schema.org/color).
   * </pre>
   *
   * <code>repeated string color_families = 1;</code>
   *
   * @return The count of colorFamilies.
   */
  public int getColorFamiliesCount() {
    return colorFamilies_.size();
  }
  /**
   *
   *
   * <pre>
   * The standard color families. Strongly recommended to use the following
   * standard color groups: "Red", "Pink", "Orange", "Yellow", "Purple",
   * "Green", "Cyan", "Blue", "Brown", "White", "Gray", "Black" and
   * "Mixed". Normally it is expected to have only 1 color family. May consider
   * using single "Mixed" instead of multiple values.
   *
   * A maximum of 5 values are allowed. Each value must be a UTF-8 encoded
   * string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Google Merchant Center property
   * [color](https://support.google.com/merchants/answer/6324487). Schema.org
   * property [Product.color](https://schema.org/color).
   * </pre>
   *
   * <code>repeated string color_families = 1;</code>
   *
   * @param index The index of the element to return.
   * @return The colorFamilies at the given index.
   */
  public java.lang.String getColorFamilies(int index) {
    return colorFamilies_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The standard color families. Strongly recommended to use the following
   * standard color groups: "Red", "Pink", "Orange", "Yellow", "Purple",
   * "Green", "Cyan", "Blue", "Brown", "White", "Gray", "Black" and
   * "Mixed". Normally it is expected to have only 1 color family. May consider
   * using single "Mixed" instead of multiple values.
   *
   * A maximum of 5 values are allowed. Each value must be a UTF-8 encoded
   * string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Google Merchant Center property
   * [color](https://support.google.com/merchants/answer/6324487). Schema.org
   * property [Product.color](https://schema.org/color).
   * </pre>
   *
   * <code>repeated string color_families = 1;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the colorFamilies at the given index.
   */
  public com.google.protobuf.ByteString getColorFamiliesBytes(int index) {
    return colorFamilies_.getByteString(index);
  }

  public static final int COLORS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList colors_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The color display names, which may be different from standard color family
   * names, such as the color aliases used in the website frontend. Normally
   * it is expected to have only 1 color. May consider using single "Mixed"
   * instead of multiple values.
   *
   * A maximum of 75 colors are allowed. Each value must be a UTF-8 encoded
   * string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Google Merchant Center property
   * [color](https://support.google.com/merchants/answer/6324487). Schema.org
   * property [Product.color](https://schema.org/color).
   * </pre>
   *
   * <code>repeated string colors = 2;</code>
   *
   * @return A list containing the colors.
   */
  public com.google.protobuf.ProtocolStringList getColorsList() {
    return colors_;
  }
  /**
   *
   *
   * <pre>
   * The color display names, which may be different from standard color family
   * names, such as the color aliases used in the website frontend. Normally
   * it is expected to have only 1 color. May consider using single "Mixed"
   * instead of multiple values.
   *
   * A maximum of 75 colors are allowed. Each value must be a UTF-8 encoded
   * string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Google Merchant Center property
   * [color](https://support.google.com/merchants/answer/6324487). Schema.org
   * property [Product.color](https://schema.org/color).
   * </pre>
   *
   * <code>repeated string colors = 2;</code>
   *
   * @return The count of colors.
   */
  public int getColorsCount() {
    return colors_.size();
  }
  /**
   *
   *
   * <pre>
   * The color display names, which may be different from standard color family
   * names, such as the color aliases used in the website frontend. Normally
   * it is expected to have only 1 color. May consider using single "Mixed"
   * instead of multiple values.
   *
   * A maximum of 75 colors are allowed. Each value must be a UTF-8 encoded
   * string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Google Merchant Center property
   * [color](https://support.google.com/merchants/answer/6324487). Schema.org
   * property [Product.color](https://schema.org/color).
   * </pre>
   *
   * <code>repeated string colors = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The colors at the given index.
   */
  public java.lang.String getColors(int index) {
    return colors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The color display names, which may be different from standard color family
   * names, such as the color aliases used in the website frontend. Normally
   * it is expected to have only 1 color. May consider using single "Mixed"
   * instead of multiple values.
   *
   * A maximum of 75 colors are allowed. Each value must be a UTF-8 encoded
   * string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Google Merchant Center property
   * [color](https://support.google.com/merchants/answer/6324487). Schema.org
   * property [Product.color](https://schema.org/color).
   * </pre>
   *
   * <code>repeated string colors = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the colors at the given index.
   */
  public com.google.protobuf.ByteString getColorsBytes(int index) {
    return colors_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < colorFamilies_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, colorFamilies_.getRaw(i));
    }
    for (int i = 0; i < colors_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, colors_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < colorFamilies_.size(); i++) {
        dataSize += computeStringSizeNoTag(colorFamilies_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getColorFamiliesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < colors_.size(); i++) {
        dataSize += computeStringSizeNoTag(colors_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getColorsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2.ColorInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2.ColorInfo other = (com.google.cloud.retail.v2.ColorInfo) obj;

    if (!getColorFamiliesList().equals(other.getColorFamiliesList())) return false;
    if (!getColorsList().equals(other.getColorsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getColorFamiliesCount() > 0) {
      hash = (37 * hash) + COLOR_FAMILIES_FIELD_NUMBER;
      hash = (53 * hash) + getColorFamiliesList().hashCode();
    }
    if (getColorsCount() > 0) {
      hash = (37 * hash) + COLORS_FIELD_NUMBER;
      hash = (53 * hash) + getColorsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2.ColorInfo parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.ColorInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.ColorInfo parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.ColorInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.ColorInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.ColorInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.ColorInfo parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.ColorInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.ColorInfo parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.ColorInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.ColorInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.ColorInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2.ColorInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The color information of a [Product][google.cloud.retail.v2.Product].
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2.ColorInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.ColorInfo)
      com.google.cloud.retail.v2.ColorInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2.CommonProto
          .internal_static_google_cloud_retail_v2_ColorInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2.CommonProto
          .internal_static_google_cloud_retail_v2_ColorInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2.ColorInfo.class,
              com.google.cloud.retail.v2.ColorInfo.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2.ColorInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      colorFamilies_ = com.google.protobuf.LazyStringArrayList.emptyList();
      colors_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2.CommonProto
          .internal_static_google_cloud_retail_v2_ColorInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.ColorInfo getDefaultInstanceForType() {
      return com.google.cloud.retail.v2.ColorInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.ColorInfo build() {
      com.google.cloud.retail.v2.ColorInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.ColorInfo buildPartial() {
      com.google.cloud.retail.v2.ColorInfo result = new com.google.cloud.retail.v2.ColorInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.retail.v2.ColorInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        colorFamilies_.makeImmutable();
        result.colorFamilies_ = colorFamilies_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        colors_.makeImmutable();
        result.colors_ = colors_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2.ColorInfo) {
        return mergeFrom((com.google.cloud.retail.v2.ColorInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2.ColorInfo other) {
      if (other == com.google.cloud.retail.v2.ColorInfo.getDefaultInstance()) return this;
      if (!other.colorFamilies_.isEmpty()) {
        if (colorFamilies_.isEmpty()) {
          colorFamilies_ = other.colorFamilies_;
          bitField0_ |= 0x00000001;
        } else {
          ensureColorFamiliesIsMutable();
          colorFamilies_.addAll(other.colorFamilies_);
        }
        onChanged();
      }
      if (!other.colors_.isEmpty()) {
        if (colors_.isEmpty()) {
          colors_ = other.colors_;
          bitField0_ |= 0x00000002;
        } else {
          ensureColorsIsMutable();
          colors_.addAll(other.colors_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureColorFamiliesIsMutable();
                colorFamilies_.add(s);
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureColorsIsMutable();
                colors_.add(s);
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList colorFamilies_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureColorFamiliesIsMutable() {
      if (!colorFamilies_.isModifiable()) {
        colorFamilies_ = new com.google.protobuf.LazyStringArrayList(colorFamilies_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     *
     *
     * <pre>
     * The standard color families. Strongly recommended to use the following
     * standard color groups: "Red", "Pink", "Orange", "Yellow", "Purple",
     * "Green", "Cyan", "Blue", "Brown", "White", "Gray", "Black" and
     * "Mixed". Normally it is expected to have only 1 color family. May consider
     * using single "Mixed" instead of multiple values.
     *
     * A maximum of 5 values are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>repeated string color_families = 1;</code>
     *
     * @return A list containing the colorFamilies.
     */
    public com.google.protobuf.ProtocolStringList getColorFamiliesList() {
      colorFamilies_.makeImmutable();
      return colorFamilies_;
    }
    /**
     *
     *
     * <pre>
     * The standard color families. Strongly recommended to use the following
     * standard color groups: "Red", "Pink", "Orange", "Yellow", "Purple",
     * "Green", "Cyan", "Blue", "Brown", "White", "Gray", "Black" and
     * "Mixed". Normally it is expected to have only 1 color family. May consider
     * using single "Mixed" instead of multiple values.
     *
     * A maximum of 5 values are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>repeated string color_families = 1;</code>
     *
     * @return The count of colorFamilies.
     */
    public int getColorFamiliesCount() {
      return colorFamilies_.size();
    }
    /**
     *
     *
     * <pre>
     * The standard color families. Strongly recommended to use the following
     * standard color groups: "Red", "Pink", "Orange", "Yellow", "Purple",
     * "Green", "Cyan", "Blue", "Brown", "White", "Gray", "Black" and
     * "Mixed". Normally it is expected to have only 1 color family. May consider
     * using single "Mixed" instead of multiple values.
     *
     * A maximum of 5 values are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>repeated string color_families = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The colorFamilies at the given index.
     */
    public java.lang.String getColorFamilies(int index) {
      return colorFamilies_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The standard color families. Strongly recommended to use the following
     * standard color groups: "Red", "Pink", "Orange", "Yellow", "Purple",
     * "Green", "Cyan", "Blue", "Brown", "White", "Gray", "Black" and
     * "Mixed". Normally it is expected to have only 1 color family. May consider
     * using single "Mixed" instead of multiple values.
     *
     * A maximum of 5 values are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>repeated string color_families = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the colorFamilies at the given index.
     */
    public com.google.protobuf.ByteString getColorFamiliesBytes(int index) {
      return colorFamilies_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The standard color families. Strongly recommended to use the following
     * standard color groups: "Red", "Pink", "Orange", "Yellow", "Purple",
     * "Green", "Cyan", "Blue", "Brown", "White", "Gray", "Black" and
     * "Mixed". Normally it is expected to have only 1 color family. May consider
     * using single "Mixed" instead of multiple values.
     *
     * A maximum of 5 values are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>repeated string color_families = 1;</code>
     *
     * @param index The index to set the value at.
     * @param value The colorFamilies to set.
     * @return This builder for chaining.
     */
    public Builder setColorFamilies(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureColorFamiliesIsMutable();
      colorFamilies_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The standard color families. Strongly recommended to use the following
     * standard color groups: "Red", "Pink", "Orange", "Yellow", "Purple",
     * "Green", "Cyan", "Blue", "Brown", "White", "Gray", "Black" and
     * "Mixed". Normally it is expected to have only 1 color family. May consider
     * using single "Mixed" instead of multiple values.
     *
     * A maximum of 5 values are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>repeated string color_families = 1;</code>
     *
     * @param value The colorFamilies to add.
     * @return This builder for chaining.
     */
    public Builder addColorFamilies(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureColorFamiliesIsMutable();
      colorFamilies_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The standard color families. Strongly recommended to use the following
     * standard color groups: "Red", "Pink", "Orange", "Yellow", "Purple",
     * "Green", "Cyan", "Blue", "Brown", "White", "Gray", "Black" and
     * "Mixed". Normally it is expected to have only 1 color family. May consider
     * using single "Mixed" instead of multiple values.
     *
     * A maximum of 5 values are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>repeated string color_families = 1;</code>
     *
     * @param values The colorFamilies to add.
     * @return This builder for chaining.
     */
    public Builder addAllColorFamilies(java.lang.Iterable<java.lang.String> values) {
      ensureColorFamiliesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, colorFamilies_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The standard color families. Strongly recommended to use the following
     * standard color groups: "Red", "Pink", "Orange", "Yellow", "Purple",
     * "Green", "Cyan", "Blue", "Brown", "White", "Gray", "Black" and
     * "Mixed". Normally it is expected to have only 1 color family. May consider
     * using single "Mixed" instead of multiple values.
     *
     * A maximum of 5 values are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>repeated string color_families = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearColorFamilies() {
      colorFamilies_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The standard color families. Strongly recommended to use the following
     * standard color groups: "Red", "Pink", "Orange", "Yellow", "Purple",
     * "Green", "Cyan", "Blue", "Brown", "White", "Gray", "Black" and
     * "Mixed". Normally it is expected to have only 1 color family. May consider
     * using single "Mixed" instead of multiple values.
     *
     * A maximum of 5 values are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>repeated string color_families = 1;</code>
     *
     * @param value The bytes of the colorFamilies to add.
     * @return This builder for chaining.
     */
    public Builder addColorFamiliesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureColorFamiliesIsMutable();
      colorFamilies_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList colors_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureColorsIsMutable() {
      if (!colors_.isModifiable()) {
        colors_ = new com.google.protobuf.LazyStringArrayList(colors_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * The color display names, which may be different from standard color family
     * names, such as the color aliases used in the website frontend. Normally
     * it is expected to have only 1 color. May consider using single "Mixed"
     * instead of multiple values.
     *
     * A maximum of 75 colors are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>repeated string colors = 2;</code>
     *
     * @return A list containing the colors.
     */
    public com.google.protobuf.ProtocolStringList getColorsList() {
      colors_.makeImmutable();
      return colors_;
    }
    /**
     *
     *
     * <pre>
     * The color display names, which may be different from standard color family
     * names, such as the color aliases used in the website frontend. Normally
     * it is expected to have only 1 color. May consider using single "Mixed"
     * instead of multiple values.
     *
     * A maximum of 75 colors are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>repeated string colors = 2;</code>
     *
     * @return The count of colors.
     */
    public int getColorsCount() {
      return colors_.size();
    }
    /**
     *
     *
     * <pre>
     * The color display names, which may be different from standard color family
     * names, such as the color aliases used in the website frontend. Normally
     * it is expected to have only 1 color. May consider using single "Mixed"
     * instead of multiple values.
     *
     * A maximum of 75 colors are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>repeated string colors = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The colors at the given index.
     */
    public java.lang.String getColors(int index) {
      return colors_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The color display names, which may be different from standard color family
     * names, such as the color aliases used in the website frontend. Normally
     * it is expected to have only 1 color. May consider using single "Mixed"
     * instead of multiple values.
     *
     * A maximum of 75 colors are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>repeated string colors = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the colors at the given index.
     */
    public com.google.protobuf.ByteString getColorsBytes(int index) {
      return colors_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The color display names, which may be different from standard color family
     * names, such as the color aliases used in the website frontend. Normally
     * it is expected to have only 1 color. May consider using single "Mixed"
     * instead of multiple values.
     *
     * A maximum of 75 colors are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>repeated string colors = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The colors to set.
     * @return This builder for chaining.
     */
    public Builder setColors(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureColorsIsMutable();
      colors_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The color display names, which may be different from standard color family
     * names, such as the color aliases used in the website frontend. Normally
     * it is expected to have only 1 color. May consider using single "Mixed"
     * instead of multiple values.
     *
     * A maximum of 75 colors are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>repeated string colors = 2;</code>
     *
     * @param value The colors to add.
     * @return This builder for chaining.
     */
    public Builder addColors(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureColorsIsMutable();
      colors_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The color display names, which may be different from standard color family
     * names, such as the color aliases used in the website frontend. Normally
     * it is expected to have only 1 color. May consider using single "Mixed"
     * instead of multiple values.
     *
     * A maximum of 75 colors are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>repeated string colors = 2;</code>
     *
     * @param values The colors to add.
     * @return This builder for chaining.
     */
    public Builder addAllColors(java.lang.Iterable<java.lang.String> values) {
      ensureColorsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, colors_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The color display names, which may be different from standard color family
     * names, such as the color aliases used in the website frontend. Normally
     * it is expected to have only 1 color. May consider using single "Mixed"
     * instead of multiple values.
     *
     * A maximum of 75 colors are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>repeated string colors = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearColors() {
      colors_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The color display names, which may be different from standard color family
     * names, such as the color aliases used in the website frontend. Normally
     * it is expected to have only 1 color. May consider using single "Mixed"
     * instead of multiple values.
     *
     * A maximum of 75 colors are allowed. Each value must be a UTF-8 encoded
     * string with a length limit of 128 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Google Merchant Center property
     * [color](https://support.google.com/merchants/answer/6324487). Schema.org
     * property [Product.color](https://schema.org/color).
     * </pre>
     *
     * <code>repeated string colors = 2;</code>
     *
     * @param value The bytes of the colors to add.
     * @return This builder for chaining.
     */
    public Builder addColorsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureColorsIsMutable();
      colors_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.ColorInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.ColorInfo)
  private static final com.google.cloud.retail.v2.ColorInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2.ColorInfo();
  }

  public static com.google.cloud.retail.v2.ColorInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ColorInfo> PARSER =
      new com.google.protobuf.AbstractParser<ColorInfo>() {
        @java.lang.Override
        public ColorInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ColorInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ColorInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2.ColorInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
