/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2/completion_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2;

/**
 *
 *
 * <pre>
 * Autocomplete parameters.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2.CompleteQueryRequest}
 */
public final class CompleteQueryRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.CompleteQueryRequest)
    CompleteQueryRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CompleteQueryRequest.newBuilder() to construct.
  private CompleteQueryRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CompleteQueryRequest() {
    catalog_ = "";
    query_ = "";
    visitorId_ = "";
    languageCodes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    deviceType_ = "";
    dataset_ = "";
    entity_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CompleteQueryRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2.CompletionServiceProto
        .internal_static_google_cloud_retail_v2_CompleteQueryRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2.CompletionServiceProto
        .internal_static_google_cloud_retail_v2_CompleteQueryRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2.CompleteQueryRequest.class,
            com.google.cloud.retail.v2.CompleteQueryRequest.Builder.class);
  }

  public static final int CATALOG_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object catalog_ = "";
  /**
   *
   *
   * <pre>
   * Required. Catalog for which the completion is performed.
   *
   * Full resource name of catalog, such as
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog`.
   * </pre>
   *
   * <code>
   * string catalog = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The catalog.
   */
  @java.lang.Override
  public java.lang.String getCatalog() {
    java.lang.Object ref = catalog_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      catalog_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Catalog for which the completion is performed.
   *
   * Full resource name of catalog, such as
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog`.
   * </pre>
   *
   * <code>
   * string catalog = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for catalog.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCatalogBytes() {
    java.lang.Object ref = catalog_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      catalog_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object query_ = "";
  /**
   *
   *
   * <pre>
   * Required. The query used to generate suggestions.
   *
   * The maximum number of allowed characters is 255.
   * </pre>
   *
   * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The query.
   */
  @java.lang.Override
  public java.lang.String getQuery() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      query_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The query used to generate suggestions.
   *
   * The maximum number of allowed characters is 255.
   * </pre>
   *
   * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for query.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQueryBytes() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      query_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VISITOR_ID_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object visitorId_ = "";
  /**
   *
   *
   * <pre>
   * Required field. A unique identifier for tracking visitors. For example,
   * this could be implemented with an HTTP cookie, which should be able to
   * uniquely identify a visitor on a single device. This unique identifier
   * should not change if the visitor logs in or out of the website.
   *
   * The field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>string visitor_id = 7;</code>
   *
   * @return The visitorId.
   */
  @java.lang.Override
  public java.lang.String getVisitorId() {
    java.lang.Object ref = visitorId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      visitorId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required field. A unique identifier for tracking visitors. For example,
   * this could be implemented with an HTTP cookie, which should be able to
   * uniquely identify a visitor on a single device. This unique identifier
   * should not change if the visitor logs in or out of the website.
   *
   * The field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>string visitor_id = 7;</code>
   *
   * @return The bytes for visitorId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVisitorIdBytes() {
    java.lang.Object ref = visitorId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      visitorId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LANGUAGE_CODES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList languageCodes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Note that this field applies for `user-data` dataset only. For requests
   * with `cloud-retail` dataset, setting this field has no effect.
   *
   * The language filters applied to the output suggestions. If set, it should
   * contain the language of the query. If not set, suggestions are returned
   * without considering language restrictions. This is the BCP-47 language
   * code, such as "en-US" or "sr-Latn". For more information, see [Tags for
   * Identifying Languages](https://tools.ietf.org/html/bcp47). The maximum
   * number of language codes is 3.
   * </pre>
   *
   * <code>repeated string language_codes = 3;</code>
   *
   * @return A list containing the languageCodes.
   */
  public com.google.protobuf.ProtocolStringList getLanguageCodesList() {
    return languageCodes_;
  }
  /**
   *
   *
   * <pre>
   * Note that this field applies for `user-data` dataset only. For requests
   * with `cloud-retail` dataset, setting this field has no effect.
   *
   * The language filters applied to the output suggestions. If set, it should
   * contain the language of the query. If not set, suggestions are returned
   * without considering language restrictions. This is the BCP-47 language
   * code, such as "en-US" or "sr-Latn". For more information, see [Tags for
   * Identifying Languages](https://tools.ietf.org/html/bcp47). The maximum
   * number of language codes is 3.
   * </pre>
   *
   * <code>repeated string language_codes = 3;</code>
   *
   * @return The count of languageCodes.
   */
  public int getLanguageCodesCount() {
    return languageCodes_.size();
  }
  /**
   *
   *
   * <pre>
   * Note that this field applies for `user-data` dataset only. For requests
   * with `cloud-retail` dataset, setting this field has no effect.
   *
   * The language filters applied to the output suggestions. If set, it should
   * contain the language of the query. If not set, suggestions are returned
   * without considering language restrictions. This is the BCP-47 language
   * code, such as "en-US" or "sr-Latn". For more information, see [Tags for
   * Identifying Languages](https://tools.ietf.org/html/bcp47). The maximum
   * number of language codes is 3.
   * </pre>
   *
   * <code>repeated string language_codes = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The languageCodes at the given index.
   */
  public java.lang.String getLanguageCodes(int index) {
    return languageCodes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Note that this field applies for `user-data` dataset only. For requests
   * with `cloud-retail` dataset, setting this field has no effect.
   *
   * The language filters applied to the output suggestions. If set, it should
   * contain the language of the query. If not set, suggestions are returned
   * without considering language restrictions. This is the BCP-47 language
   * code, such as "en-US" or "sr-Latn". For more information, see [Tags for
   * Identifying Languages](https://tools.ietf.org/html/bcp47). The maximum
   * number of language codes is 3.
   * </pre>
   *
   * <code>repeated string language_codes = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the languageCodes at the given index.
   */
  public com.google.protobuf.ByteString getLanguageCodesBytes(int index) {
    return languageCodes_.getByteString(index);
  }

  public static final int DEVICE_TYPE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object deviceType_ = "";
  /**
   *
   *
   * <pre>
   * The device type context for completion suggestions. We recommend that you
   * leave this field empty.
   *
   * It can apply different suggestions on different device types, e.g.
   * `DESKTOP`, `MOBILE`. If it is empty, the suggestions are across all device
   * types.
   *
   * Supported formats:
   *
   * * `UNKNOWN_DEVICE_TYPE`
   *
   * * `DESKTOP`
   *
   * * `MOBILE`
   *
   * * A customized string starts with `OTHER_`, e.g. `OTHER_IPHONE`.
   * </pre>
   *
   * <code>string device_type = 4;</code>
   *
   * @return The deviceType.
   */
  @java.lang.Override
  public java.lang.String getDeviceType() {
    java.lang.Object ref = deviceType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deviceType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The device type context for completion suggestions. We recommend that you
   * leave this field empty.
   *
   * It can apply different suggestions on different device types, e.g.
   * `DESKTOP`, `MOBILE`. If it is empty, the suggestions are across all device
   * types.
   *
   * Supported formats:
   *
   * * `UNKNOWN_DEVICE_TYPE`
   *
   * * `DESKTOP`
   *
   * * `MOBILE`
   *
   * * A customized string starts with `OTHER_`, e.g. `OTHER_IPHONE`.
   * </pre>
   *
   * <code>string device_type = 4;</code>
   *
   * @return The bytes for deviceType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeviceTypeBytes() {
    java.lang.Object ref = deviceType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deviceType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATASET_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dataset_ = "";
  /**
   *
   *
   * <pre>
   * Determines which dataset to use for fetching completion. "user-data" will
   * use the imported dataset through
   * [CompletionService.ImportCompletionData][google.cloud.retail.v2.CompletionService.ImportCompletionData].
   * "cloud-retail" will use the dataset generated by cloud retail based on user
   * events. If leave empty, it will use the "user-data".
   *
   * Current supported values:
   *
   * * user-data
   *
   * * cloud-retail:
   *   This option requires enabling auto-learning function first. See
   *   [guidelines](https://cloud.google.com/retail/docs/completion-overview#generated-completion-dataset).
   * </pre>
   *
   * <code>string dataset = 6;</code>
   *
   * @return The dataset.
   */
  @java.lang.Override
  public java.lang.String getDataset() {
    java.lang.Object ref = dataset_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dataset_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Determines which dataset to use for fetching completion. "user-data" will
   * use the imported dataset through
   * [CompletionService.ImportCompletionData][google.cloud.retail.v2.CompletionService.ImportCompletionData].
   * "cloud-retail" will use the dataset generated by cloud retail based on user
   * events. If leave empty, it will use the "user-data".
   *
   * Current supported values:
   *
   * * user-data
   *
   * * cloud-retail:
   *   This option requires enabling auto-learning function first. See
   *   [guidelines](https://cloud.google.com/retail/docs/completion-overview#generated-completion-dataset).
   * </pre>
   *
   * <code>string dataset = 6;</code>
   *
   * @return The bytes for dataset.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatasetBytes() {
    java.lang.Object ref = dataset_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dataset_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAX_SUGGESTIONS_FIELD_NUMBER = 5;
  private int maxSuggestions_ = 0;
  /**
   *
   *
   * <pre>
   * Completion max suggestions. If left unset or set to 0, then will fallback
   * to the configured value
   * [CompletionConfig.max_suggestions][google.cloud.retail.v2.CompletionConfig.max_suggestions].
   *
   * The maximum allowed max suggestions is 20. If it is set higher, it will be
   * capped by 20.
   * </pre>
   *
   * <code>int32 max_suggestions = 5;</code>
   *
   * @return The maxSuggestions.
   */
  @java.lang.Override
  public int getMaxSuggestions() {
    return maxSuggestions_;
  }

  public static final int ENABLE_ATTRIBUTE_SUGGESTIONS_FIELD_NUMBER = 9;
  private boolean enableAttributeSuggestions_ = false;
  /**
   *
   *
   * <pre>
   * If true, attribute suggestions are enabled and provided in the response.
   *
   * This field is only available for the "cloud-retail" dataset.
   * </pre>
   *
   * <code>bool enable_attribute_suggestions = 9;</code>
   *
   * @return The enableAttributeSuggestions.
   */
  @java.lang.Override
  public boolean getEnableAttributeSuggestions() {
    return enableAttributeSuggestions_;
  }

  public static final int ENTITY_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object entity_ = "";
  /**
   *
   *
   * <pre>
   * The entity for customers who run multiple entities, domains, sites, or
   * regions, for example, `Google US`, `Google Ads`, `Waymo`,
   * `google.com`, `youtube.com`, etc.
   * If this is set, it must be an exact match with
   * [UserEvent.entity][google.cloud.retail.v2.UserEvent.entity] to get
   * per-entity autocomplete results.
   * </pre>
   *
   * <code>string entity = 10;</code>
   *
   * @return The entity.
   */
  @java.lang.Override
  public java.lang.String getEntity() {
    java.lang.Object ref = entity_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      entity_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The entity for customers who run multiple entities, domains, sites, or
   * regions, for example, `Google US`, `Google Ads`, `Waymo`,
   * `google.com`, `youtube.com`, etc.
   * If this is set, it must be an exact match with
   * [UserEvent.entity][google.cloud.retail.v2.UserEvent.entity] to get
   * per-entity autocomplete results.
   * </pre>
   *
   * <code>string entity = 10;</code>
   *
   * @return The bytes for entity.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEntityBytes() {
    java.lang.Object ref = entity_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      entity_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(catalog_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, catalog_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, query_);
    }
    for (int i = 0; i < languageCodes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, languageCodes_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deviceType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, deviceType_);
    }
    if (maxSuggestions_ != 0) {
      output.writeInt32(5, maxSuggestions_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataset_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, dataset_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(visitorId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, visitorId_);
    }
    if (enableAttributeSuggestions_ != false) {
      output.writeBool(9, enableAttributeSuggestions_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entity_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, entity_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(catalog_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, catalog_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, query_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < languageCodes_.size(); i++) {
        dataSize += computeStringSizeNoTag(languageCodes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getLanguageCodesList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deviceType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, deviceType_);
    }
    if (maxSuggestions_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, maxSuggestions_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataset_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, dataset_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(visitorId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, visitorId_);
    }
    if (enableAttributeSuggestions_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(9, enableAttributeSuggestions_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entity_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, entity_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2.CompleteQueryRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2.CompleteQueryRequest other =
        (com.google.cloud.retail.v2.CompleteQueryRequest) obj;

    if (!getCatalog().equals(other.getCatalog())) return false;
    if (!getQuery().equals(other.getQuery())) return false;
    if (!getVisitorId().equals(other.getVisitorId())) return false;
    if (!getLanguageCodesList().equals(other.getLanguageCodesList())) return false;
    if (!getDeviceType().equals(other.getDeviceType())) return false;
    if (!getDataset().equals(other.getDataset())) return false;
    if (getMaxSuggestions() != other.getMaxSuggestions()) return false;
    if (getEnableAttributeSuggestions() != other.getEnableAttributeSuggestions()) return false;
    if (!getEntity().equals(other.getEntity())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CATALOG_FIELD_NUMBER;
    hash = (53 * hash) + getCatalog().hashCode();
    hash = (37 * hash) + QUERY_FIELD_NUMBER;
    hash = (53 * hash) + getQuery().hashCode();
    hash = (37 * hash) + VISITOR_ID_FIELD_NUMBER;
    hash = (53 * hash) + getVisitorId().hashCode();
    if (getLanguageCodesCount() > 0) {
      hash = (37 * hash) + LANGUAGE_CODES_FIELD_NUMBER;
      hash = (53 * hash) + getLanguageCodesList().hashCode();
    }
    hash = (37 * hash) + DEVICE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getDeviceType().hashCode();
    hash = (37 * hash) + DATASET_FIELD_NUMBER;
    hash = (53 * hash) + getDataset().hashCode();
    hash = (37 * hash) + MAX_SUGGESTIONS_FIELD_NUMBER;
    hash = (53 * hash) + getMaxSuggestions();
    hash = (37 * hash) + ENABLE_ATTRIBUTE_SUGGESTIONS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableAttributeSuggestions());
    hash = (37 * hash) + ENTITY_FIELD_NUMBER;
    hash = (53 * hash) + getEntity().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2.CompleteQueryRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.CompleteQueryRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.CompleteQueryRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.CompleteQueryRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.CompleteQueryRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.CompleteQueryRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.CompleteQueryRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.CompleteQueryRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.CompleteQueryRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.CompleteQueryRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.CompleteQueryRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.CompleteQueryRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2.CompleteQueryRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Autocomplete parameters.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2.CompleteQueryRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.CompleteQueryRequest)
      com.google.cloud.retail.v2.CompleteQueryRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2.CompletionServiceProto
          .internal_static_google_cloud_retail_v2_CompleteQueryRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2.CompletionServiceProto
          .internal_static_google_cloud_retail_v2_CompleteQueryRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2.CompleteQueryRequest.class,
              com.google.cloud.retail.v2.CompleteQueryRequest.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2.CompleteQueryRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      catalog_ = "";
      query_ = "";
      visitorId_ = "";
      languageCodes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      deviceType_ = "";
      dataset_ = "";
      maxSuggestions_ = 0;
      enableAttributeSuggestions_ = false;
      entity_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2.CompletionServiceProto
          .internal_static_google_cloud_retail_v2_CompleteQueryRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.CompleteQueryRequest getDefaultInstanceForType() {
      return com.google.cloud.retail.v2.CompleteQueryRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.CompleteQueryRequest build() {
      com.google.cloud.retail.v2.CompleteQueryRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.CompleteQueryRequest buildPartial() {
      com.google.cloud.retail.v2.CompleteQueryRequest result =
          new com.google.cloud.retail.v2.CompleteQueryRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.retail.v2.CompleteQueryRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.catalog_ = catalog_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.query_ = query_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.visitorId_ = visitorId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        languageCodes_.makeImmutable();
        result.languageCodes_ = languageCodes_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.deviceType_ = deviceType_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.dataset_ = dataset_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.maxSuggestions_ = maxSuggestions_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.enableAttributeSuggestions_ = enableAttributeSuggestions_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.entity_ = entity_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2.CompleteQueryRequest) {
        return mergeFrom((com.google.cloud.retail.v2.CompleteQueryRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2.CompleteQueryRequest other) {
      if (other == com.google.cloud.retail.v2.CompleteQueryRequest.getDefaultInstance())
        return this;
      if (!other.getCatalog().isEmpty()) {
        catalog_ = other.catalog_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getQuery().isEmpty()) {
        query_ = other.query_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getVisitorId().isEmpty()) {
        visitorId_ = other.visitorId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.languageCodes_.isEmpty()) {
        if (languageCodes_.isEmpty()) {
          languageCodes_ = other.languageCodes_;
          bitField0_ |= 0x00000008;
        } else {
          ensureLanguageCodesIsMutable();
          languageCodes_.addAll(other.languageCodes_);
        }
        onChanged();
      }
      if (!other.getDeviceType().isEmpty()) {
        deviceType_ = other.deviceType_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getDataset().isEmpty()) {
        dataset_ = other.dataset_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.getMaxSuggestions() != 0) {
        setMaxSuggestions(other.getMaxSuggestions());
      }
      if (other.getEnableAttributeSuggestions() != false) {
        setEnableAttributeSuggestions(other.getEnableAttributeSuggestions());
      }
      if (!other.getEntity().isEmpty()) {
        entity_ = other.entity_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                catalog_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                query_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureLanguageCodesIsMutable();
                languageCodes_.add(s);
                break;
              } // case 26
            case 34:
              {
                deviceType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 40:
              {
                maxSuggestions_ = input.readInt32();
                bitField0_ |= 0x00000040;
                break;
              } // case 40
            case 50:
              {
                dataset_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                visitorId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 58
            case 72:
              {
                enableAttributeSuggestions_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 72
            case 82:
              {
                entity_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object catalog_ = "";
    /**
     *
     *
     * <pre>
     * Required. Catalog for which the completion is performed.
     *
     * Full resource name of catalog, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog`.
     * </pre>
     *
     * <code>
     * string catalog = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The catalog.
     */
    public java.lang.String getCatalog() {
      java.lang.Object ref = catalog_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        catalog_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Catalog for which the completion is performed.
     *
     * Full resource name of catalog, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog`.
     * </pre>
     *
     * <code>
     * string catalog = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for catalog.
     */
    public com.google.protobuf.ByteString getCatalogBytes() {
      java.lang.Object ref = catalog_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        catalog_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Catalog for which the completion is performed.
     *
     * Full resource name of catalog, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog`.
     * </pre>
     *
     * <code>
     * string catalog = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The catalog to set.
     * @return This builder for chaining.
     */
    public Builder setCatalog(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      catalog_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Catalog for which the completion is performed.
     *
     * Full resource name of catalog, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog`.
     * </pre>
     *
     * <code>
     * string catalog = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCatalog() {
      catalog_ = getDefaultInstance().getCatalog();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Catalog for which the completion is performed.
     *
     * Full resource name of catalog, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog`.
     * </pre>
     *
     * <code>
     * string catalog = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for catalog to set.
     * @return This builder for chaining.
     */
    public Builder setCatalogBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      catalog_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object query_ = "";
    /**
     *
     *
     * <pre>
     * Required. The query used to generate suggestions.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The query.
     */
    public java.lang.String getQuery() {
      java.lang.Object ref = query_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        query_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The query used to generate suggestions.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for query.
     */
    public com.google.protobuf.ByteString getQueryBytes() {
      java.lang.Object ref = query_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        query_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The query used to generate suggestions.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The query to set.
     * @return This builder for chaining.
     */
    public Builder setQuery(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      query_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The query used to generate suggestions.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuery() {
      query_ = getDefaultInstance().getQuery();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The query used to generate suggestions.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for query to set.
     * @return This builder for chaining.
     */
    public Builder setQueryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      query_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object visitorId_ = "";
    /**
     *
     *
     * <pre>
     * Required field. A unique identifier for tracking visitors. For example,
     * this could be implemented with an HTTP cookie, which should be able to
     * uniquely identify a visitor on a single device. This unique identifier
     * should not change if the visitor logs in or out of the website.
     *
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string visitor_id = 7;</code>
     *
     * @return The visitorId.
     */
    public java.lang.String getVisitorId() {
      java.lang.Object ref = visitorId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        visitorId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required field. A unique identifier for tracking visitors. For example,
     * this could be implemented with an HTTP cookie, which should be able to
     * uniquely identify a visitor on a single device. This unique identifier
     * should not change if the visitor logs in or out of the website.
     *
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string visitor_id = 7;</code>
     *
     * @return The bytes for visitorId.
     */
    public com.google.protobuf.ByteString getVisitorIdBytes() {
      java.lang.Object ref = visitorId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        visitorId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required field. A unique identifier for tracking visitors. For example,
     * this could be implemented with an HTTP cookie, which should be able to
     * uniquely identify a visitor on a single device. This unique identifier
     * should not change if the visitor logs in or out of the website.
     *
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string visitor_id = 7;</code>
     *
     * @param value The visitorId to set.
     * @return This builder for chaining.
     */
    public Builder setVisitorId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      visitorId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required field. A unique identifier for tracking visitors. For example,
     * this could be implemented with an HTTP cookie, which should be able to
     * uniquely identify a visitor on a single device. This unique identifier
     * should not change if the visitor logs in or out of the website.
     *
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string visitor_id = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVisitorId() {
      visitorId_ = getDefaultInstance().getVisitorId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required field. A unique identifier for tracking visitors. For example,
     * this could be implemented with an HTTP cookie, which should be able to
     * uniquely identify a visitor on a single device. This unique identifier
     * should not change if the visitor logs in or out of the website.
     *
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string visitor_id = 7;</code>
     *
     * @param value The bytes for visitorId to set.
     * @return This builder for chaining.
     */
    public Builder setVisitorIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      visitorId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList languageCodes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureLanguageCodesIsMutable() {
      if (!languageCodes_.isModifiable()) {
        languageCodes_ = new com.google.protobuf.LazyStringArrayList(languageCodes_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * Note that this field applies for `user-data` dataset only. For requests
     * with `cloud-retail` dataset, setting this field has no effect.
     *
     * The language filters applied to the output suggestions. If set, it should
     * contain the language of the query. If not set, suggestions are returned
     * without considering language restrictions. This is the BCP-47 language
     * code, such as "en-US" or "sr-Latn". For more information, see [Tags for
     * Identifying Languages](https://tools.ietf.org/html/bcp47). The maximum
     * number of language codes is 3.
     * </pre>
     *
     * <code>repeated string language_codes = 3;</code>
     *
     * @return A list containing the languageCodes.
     */
    public com.google.protobuf.ProtocolStringList getLanguageCodesList() {
      languageCodes_.makeImmutable();
      return languageCodes_;
    }
    /**
     *
     *
     * <pre>
     * Note that this field applies for `user-data` dataset only. For requests
     * with `cloud-retail` dataset, setting this field has no effect.
     *
     * The language filters applied to the output suggestions. If set, it should
     * contain the language of the query. If not set, suggestions are returned
     * without considering language restrictions. This is the BCP-47 language
     * code, such as "en-US" or "sr-Latn". For more information, see [Tags for
     * Identifying Languages](https://tools.ietf.org/html/bcp47). The maximum
     * number of language codes is 3.
     * </pre>
     *
     * <code>repeated string language_codes = 3;</code>
     *
     * @return The count of languageCodes.
     */
    public int getLanguageCodesCount() {
      return languageCodes_.size();
    }
    /**
     *
     *
     * <pre>
     * Note that this field applies for `user-data` dataset only. For requests
     * with `cloud-retail` dataset, setting this field has no effect.
     *
     * The language filters applied to the output suggestions. If set, it should
     * contain the language of the query. If not set, suggestions are returned
     * without considering language restrictions. This is the BCP-47 language
     * code, such as "en-US" or "sr-Latn". For more information, see [Tags for
     * Identifying Languages](https://tools.ietf.org/html/bcp47). The maximum
     * number of language codes is 3.
     * </pre>
     *
     * <code>repeated string language_codes = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The languageCodes at the given index.
     */
    public java.lang.String getLanguageCodes(int index) {
      return languageCodes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Note that this field applies for `user-data` dataset only. For requests
     * with `cloud-retail` dataset, setting this field has no effect.
     *
     * The language filters applied to the output suggestions. If set, it should
     * contain the language of the query. If not set, suggestions are returned
     * without considering language restrictions. This is the BCP-47 language
     * code, such as "en-US" or "sr-Latn". For more information, see [Tags for
     * Identifying Languages](https://tools.ietf.org/html/bcp47). The maximum
     * number of language codes is 3.
     * </pre>
     *
     * <code>repeated string language_codes = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the languageCodes at the given index.
     */
    public com.google.protobuf.ByteString getLanguageCodesBytes(int index) {
      return languageCodes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Note that this field applies for `user-data` dataset only. For requests
     * with `cloud-retail` dataset, setting this field has no effect.
     *
     * The language filters applied to the output suggestions. If set, it should
     * contain the language of the query. If not set, suggestions are returned
     * without considering language restrictions. This is the BCP-47 language
     * code, such as "en-US" or "sr-Latn". For more information, see [Tags for
     * Identifying Languages](https://tools.ietf.org/html/bcp47). The maximum
     * number of language codes is 3.
     * </pre>
     *
     * <code>repeated string language_codes = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The languageCodes to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLanguageCodesIsMutable();
      languageCodes_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Note that this field applies for `user-data` dataset only. For requests
     * with `cloud-retail` dataset, setting this field has no effect.
     *
     * The language filters applied to the output suggestions. If set, it should
     * contain the language of the query. If not set, suggestions are returned
     * without considering language restrictions. This is the BCP-47 language
     * code, such as "en-US" or "sr-Latn". For more information, see [Tags for
     * Identifying Languages](https://tools.ietf.org/html/bcp47). The maximum
     * number of language codes is 3.
     * </pre>
     *
     * <code>repeated string language_codes = 3;</code>
     *
     * @param value The languageCodes to add.
     * @return This builder for chaining.
     */
    public Builder addLanguageCodes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLanguageCodesIsMutable();
      languageCodes_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Note that this field applies for `user-data` dataset only. For requests
     * with `cloud-retail` dataset, setting this field has no effect.
     *
     * The language filters applied to the output suggestions. If set, it should
     * contain the language of the query. If not set, suggestions are returned
     * without considering language restrictions. This is the BCP-47 language
     * code, such as "en-US" or "sr-Latn". For more information, see [Tags for
     * Identifying Languages](https://tools.ietf.org/html/bcp47). The maximum
     * number of language codes is 3.
     * </pre>
     *
     * <code>repeated string language_codes = 3;</code>
     *
     * @param values The languageCodes to add.
     * @return This builder for chaining.
     */
    public Builder addAllLanguageCodes(java.lang.Iterable<java.lang.String> values) {
      ensureLanguageCodesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, languageCodes_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Note that this field applies for `user-data` dataset only. For requests
     * with `cloud-retail` dataset, setting this field has no effect.
     *
     * The language filters applied to the output suggestions. If set, it should
     * contain the language of the query. If not set, suggestions are returned
     * without considering language restrictions. This is the BCP-47 language
     * code, such as "en-US" or "sr-Latn". For more information, see [Tags for
     * Identifying Languages](https://tools.ietf.org/html/bcp47). The maximum
     * number of language codes is 3.
     * </pre>
     *
     * <code>repeated string language_codes = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCodes() {
      languageCodes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Note that this field applies for `user-data` dataset only. For requests
     * with `cloud-retail` dataset, setting this field has no effect.
     *
     * The language filters applied to the output suggestions. If set, it should
     * contain the language of the query. If not set, suggestions are returned
     * without considering language restrictions. This is the BCP-47 language
     * code, such as "en-US" or "sr-Latn". For more information, see [Tags for
     * Identifying Languages](https://tools.ietf.org/html/bcp47). The maximum
     * number of language codes is 3.
     * </pre>
     *
     * <code>repeated string language_codes = 3;</code>
     *
     * @param value The bytes of the languageCodes to add.
     * @return This builder for chaining.
     */
    public Builder addLanguageCodesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureLanguageCodesIsMutable();
      languageCodes_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object deviceType_ = "";
    /**
     *
     *
     * <pre>
     * The device type context for completion suggestions. We recommend that you
     * leave this field empty.
     *
     * It can apply different suggestions on different device types, e.g.
     * `DESKTOP`, `MOBILE`. If it is empty, the suggestions are across all device
     * types.
     *
     * Supported formats:
     *
     * * `UNKNOWN_DEVICE_TYPE`
     *
     * * `DESKTOP`
     *
     * * `MOBILE`
     *
     * * A customized string starts with `OTHER_`, e.g. `OTHER_IPHONE`.
     * </pre>
     *
     * <code>string device_type = 4;</code>
     *
     * @return The deviceType.
     */
    public java.lang.String getDeviceType() {
      java.lang.Object ref = deviceType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deviceType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The device type context for completion suggestions. We recommend that you
     * leave this field empty.
     *
     * It can apply different suggestions on different device types, e.g.
     * `DESKTOP`, `MOBILE`. If it is empty, the suggestions are across all device
     * types.
     *
     * Supported formats:
     *
     * * `UNKNOWN_DEVICE_TYPE`
     *
     * * `DESKTOP`
     *
     * * `MOBILE`
     *
     * * A customized string starts with `OTHER_`, e.g. `OTHER_IPHONE`.
     * </pre>
     *
     * <code>string device_type = 4;</code>
     *
     * @return The bytes for deviceType.
     */
    public com.google.protobuf.ByteString getDeviceTypeBytes() {
      java.lang.Object ref = deviceType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deviceType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The device type context for completion suggestions. We recommend that you
     * leave this field empty.
     *
     * It can apply different suggestions on different device types, e.g.
     * `DESKTOP`, `MOBILE`. If it is empty, the suggestions are across all device
     * types.
     *
     * Supported formats:
     *
     * * `UNKNOWN_DEVICE_TYPE`
     *
     * * `DESKTOP`
     *
     * * `MOBILE`
     *
     * * A customized string starts with `OTHER_`, e.g. `OTHER_IPHONE`.
     * </pre>
     *
     * <code>string device_type = 4;</code>
     *
     * @param value The deviceType to set.
     * @return This builder for chaining.
     */
    public Builder setDeviceType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deviceType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The device type context for completion suggestions. We recommend that you
     * leave this field empty.
     *
     * It can apply different suggestions on different device types, e.g.
     * `DESKTOP`, `MOBILE`. If it is empty, the suggestions are across all device
     * types.
     *
     * Supported formats:
     *
     * * `UNKNOWN_DEVICE_TYPE`
     *
     * * `DESKTOP`
     *
     * * `MOBILE`
     *
     * * A customized string starts with `OTHER_`, e.g. `OTHER_IPHONE`.
     * </pre>
     *
     * <code>string device_type = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeviceType() {
      deviceType_ = getDefaultInstance().getDeviceType();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The device type context for completion suggestions. We recommend that you
     * leave this field empty.
     *
     * It can apply different suggestions on different device types, e.g.
     * `DESKTOP`, `MOBILE`. If it is empty, the suggestions are across all device
     * types.
     *
     * Supported formats:
     *
     * * `UNKNOWN_DEVICE_TYPE`
     *
     * * `DESKTOP`
     *
     * * `MOBILE`
     *
     * * A customized string starts with `OTHER_`, e.g. `OTHER_IPHONE`.
     * </pre>
     *
     * <code>string device_type = 4;</code>
     *
     * @param value The bytes for deviceType to set.
     * @return This builder for chaining.
     */
    public Builder setDeviceTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deviceType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object dataset_ = "";
    /**
     *
     *
     * <pre>
     * Determines which dataset to use for fetching completion. "user-data" will
     * use the imported dataset through
     * [CompletionService.ImportCompletionData][google.cloud.retail.v2.CompletionService.ImportCompletionData].
     * "cloud-retail" will use the dataset generated by cloud retail based on user
     * events. If leave empty, it will use the "user-data".
     *
     * Current supported values:
     *
     * * user-data
     *
     * * cloud-retail:
     *   This option requires enabling auto-learning function first. See
     *   [guidelines](https://cloud.google.com/retail/docs/completion-overview#generated-completion-dataset).
     * </pre>
     *
     * <code>string dataset = 6;</code>
     *
     * @return The dataset.
     */
    public java.lang.String getDataset() {
      java.lang.Object ref = dataset_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataset_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Determines which dataset to use for fetching completion. "user-data" will
     * use the imported dataset through
     * [CompletionService.ImportCompletionData][google.cloud.retail.v2.CompletionService.ImportCompletionData].
     * "cloud-retail" will use the dataset generated by cloud retail based on user
     * events. If leave empty, it will use the "user-data".
     *
     * Current supported values:
     *
     * * user-data
     *
     * * cloud-retail:
     *   This option requires enabling auto-learning function first. See
     *   [guidelines](https://cloud.google.com/retail/docs/completion-overview#generated-completion-dataset).
     * </pre>
     *
     * <code>string dataset = 6;</code>
     *
     * @return The bytes for dataset.
     */
    public com.google.protobuf.ByteString getDatasetBytes() {
      java.lang.Object ref = dataset_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataset_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Determines which dataset to use for fetching completion. "user-data" will
     * use the imported dataset through
     * [CompletionService.ImportCompletionData][google.cloud.retail.v2.CompletionService.ImportCompletionData].
     * "cloud-retail" will use the dataset generated by cloud retail based on user
     * events. If leave empty, it will use the "user-data".
     *
     * Current supported values:
     *
     * * user-data
     *
     * * cloud-retail:
     *   This option requires enabling auto-learning function first. See
     *   [guidelines](https://cloud.google.com/retail/docs/completion-overview#generated-completion-dataset).
     * </pre>
     *
     * <code>string dataset = 6;</code>
     *
     * @param value The dataset to set.
     * @return This builder for chaining.
     */
    public Builder setDataset(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataset_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Determines which dataset to use for fetching completion. "user-data" will
     * use the imported dataset through
     * [CompletionService.ImportCompletionData][google.cloud.retail.v2.CompletionService.ImportCompletionData].
     * "cloud-retail" will use the dataset generated by cloud retail based on user
     * events. If leave empty, it will use the "user-data".
     *
     * Current supported values:
     *
     * * user-data
     *
     * * cloud-retail:
     *   This option requires enabling auto-learning function first. See
     *   [guidelines](https://cloud.google.com/retail/docs/completion-overview#generated-completion-dataset).
     * </pre>
     *
     * <code>string dataset = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataset() {
      dataset_ = getDefaultInstance().getDataset();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Determines which dataset to use for fetching completion. "user-data" will
     * use the imported dataset through
     * [CompletionService.ImportCompletionData][google.cloud.retail.v2.CompletionService.ImportCompletionData].
     * "cloud-retail" will use the dataset generated by cloud retail based on user
     * events. If leave empty, it will use the "user-data".
     *
     * Current supported values:
     *
     * * user-data
     *
     * * cloud-retail:
     *   This option requires enabling auto-learning function first. See
     *   [guidelines](https://cloud.google.com/retail/docs/completion-overview#generated-completion-dataset).
     * </pre>
     *
     * <code>string dataset = 6;</code>
     *
     * @param value The bytes for dataset to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dataset_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private int maxSuggestions_;
    /**
     *
     *
     * <pre>
     * Completion max suggestions. If left unset or set to 0, then will fallback
     * to the configured value
     * [CompletionConfig.max_suggestions][google.cloud.retail.v2.CompletionConfig.max_suggestions].
     *
     * The maximum allowed max suggestions is 20. If it is set higher, it will be
     * capped by 20.
     * </pre>
     *
     * <code>int32 max_suggestions = 5;</code>
     *
     * @return The maxSuggestions.
     */
    @java.lang.Override
    public int getMaxSuggestions() {
      return maxSuggestions_;
    }
    /**
     *
     *
     * <pre>
     * Completion max suggestions. If left unset or set to 0, then will fallback
     * to the configured value
     * [CompletionConfig.max_suggestions][google.cloud.retail.v2.CompletionConfig.max_suggestions].
     *
     * The maximum allowed max suggestions is 20. If it is set higher, it will be
     * capped by 20.
     * </pre>
     *
     * <code>int32 max_suggestions = 5;</code>
     *
     * @param value The maxSuggestions to set.
     * @return This builder for chaining.
     */
    public Builder setMaxSuggestions(int value) {

      maxSuggestions_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Completion max suggestions. If left unset or set to 0, then will fallback
     * to the configured value
     * [CompletionConfig.max_suggestions][google.cloud.retail.v2.CompletionConfig.max_suggestions].
     *
     * The maximum allowed max suggestions is 20. If it is set higher, it will be
     * capped by 20.
     * </pre>
     *
     * <code>int32 max_suggestions = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxSuggestions() {
      bitField0_ = (bitField0_ & ~0x00000040);
      maxSuggestions_ = 0;
      onChanged();
      return this;
    }

    private boolean enableAttributeSuggestions_;
    /**
     *
     *
     * <pre>
     * If true, attribute suggestions are enabled and provided in the response.
     *
     * This field is only available for the "cloud-retail" dataset.
     * </pre>
     *
     * <code>bool enable_attribute_suggestions = 9;</code>
     *
     * @return The enableAttributeSuggestions.
     */
    @java.lang.Override
    public boolean getEnableAttributeSuggestions() {
      return enableAttributeSuggestions_;
    }
    /**
     *
     *
     * <pre>
     * If true, attribute suggestions are enabled and provided in the response.
     *
     * This field is only available for the "cloud-retail" dataset.
     * </pre>
     *
     * <code>bool enable_attribute_suggestions = 9;</code>
     *
     * @param value The enableAttributeSuggestions to set.
     * @return This builder for chaining.
     */
    public Builder setEnableAttributeSuggestions(boolean value) {

      enableAttributeSuggestions_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, attribute suggestions are enabled and provided in the response.
     *
     * This field is only available for the "cloud-retail" dataset.
     * </pre>
     *
     * <code>bool enable_attribute_suggestions = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableAttributeSuggestions() {
      bitField0_ = (bitField0_ & ~0x00000080);
      enableAttributeSuggestions_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object entity_ = "";
    /**
     *
     *
     * <pre>
     * The entity for customers who run multiple entities, domains, sites, or
     * regions, for example, `Google US`, `Google Ads`, `Waymo`,
     * `google.com`, `youtube.com`, etc.
     * If this is set, it must be an exact match with
     * [UserEvent.entity][google.cloud.retail.v2.UserEvent.entity] to get
     * per-entity autocomplete results.
     * </pre>
     *
     * <code>string entity = 10;</code>
     *
     * @return The entity.
     */
    public java.lang.String getEntity() {
      java.lang.Object ref = entity_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entity_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The entity for customers who run multiple entities, domains, sites, or
     * regions, for example, `Google US`, `Google Ads`, `Waymo`,
     * `google.com`, `youtube.com`, etc.
     * If this is set, it must be an exact match with
     * [UserEvent.entity][google.cloud.retail.v2.UserEvent.entity] to get
     * per-entity autocomplete results.
     * </pre>
     *
     * <code>string entity = 10;</code>
     *
     * @return The bytes for entity.
     */
    public com.google.protobuf.ByteString getEntityBytes() {
      java.lang.Object ref = entity_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entity_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The entity for customers who run multiple entities, domains, sites, or
     * regions, for example, `Google US`, `Google Ads`, `Waymo`,
     * `google.com`, `youtube.com`, etc.
     * If this is set, it must be an exact match with
     * [UserEvent.entity][google.cloud.retail.v2.UserEvent.entity] to get
     * per-entity autocomplete results.
     * </pre>
     *
     * <code>string entity = 10;</code>
     *
     * @param value The entity to set.
     * @return This builder for chaining.
     */
    public Builder setEntity(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      entity_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity for customers who run multiple entities, domains, sites, or
     * regions, for example, `Google US`, `Google Ads`, `Waymo`,
     * `google.com`, `youtube.com`, etc.
     * If this is set, it must be an exact match with
     * [UserEvent.entity][google.cloud.retail.v2.UserEvent.entity] to get
     * per-entity autocomplete results.
     * </pre>
     *
     * <code>string entity = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntity() {
      entity_ = getDefaultInstance().getEntity();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity for customers who run multiple entities, domains, sites, or
     * regions, for example, `Google US`, `Google Ads`, `Waymo`,
     * `google.com`, `youtube.com`, etc.
     * If this is set, it must be an exact match with
     * [UserEvent.entity][google.cloud.retail.v2.UserEvent.entity] to get
     * per-entity autocomplete results.
     * </pre>
     *
     * <code>string entity = 10;</code>
     *
     * @param value The bytes for entity to set.
     * @return This builder for chaining.
     */
    public Builder setEntityBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      entity_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.CompleteQueryRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.CompleteQueryRequest)
  private static final com.google.cloud.retail.v2.CompleteQueryRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2.CompleteQueryRequest();
  }

  public static com.google.cloud.retail.v2.CompleteQueryRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CompleteQueryRequest> PARSER =
      new com.google.protobuf.AbstractParser<CompleteQueryRequest>() {
        @java.lang.Override
        public CompleteQueryRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CompleteQueryRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CompleteQueryRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2.CompleteQueryRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
