/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2/export_config.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2;

/**
 *
 *
 * <pre>
 * The output configuration setting.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2.OutputConfig}
 */
public final class OutputConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.OutputConfig)
    OutputConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OutputConfig.newBuilder() to construct.
  private OutputConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OutputConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OutputConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2.ExportConfigProto
        .internal_static_google_cloud_retail_v2_OutputConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2.ExportConfigProto
        .internal_static_google_cloud_retail_v2_OutputConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2.OutputConfig.class,
            com.google.cloud.retail.v2.OutputConfig.Builder.class);
  }

  public interface GcsDestinationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2.OutputConfig.GcsDestination)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The output uri prefix for saving output data to json files.
     * Some mapping examples are as follows:
     * output_uri_prefix         sample output(assuming the object is foo.json)
     * ========================  =============================================
     * gs://bucket/              gs://bucket/foo.json
     * gs://bucket/folder/       gs://bucket/folder/foo.json
     * gs://bucket/folder/item_  gs://bucket/folder/item_foo.json
     * </pre>
     *
     * <code>string output_uri_prefix = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The outputUriPrefix.
     */
    java.lang.String getOutputUriPrefix();
    /**
     *
     *
     * <pre>
     * Required. The output uri prefix for saving output data to json files.
     * Some mapping examples are as follows:
     * output_uri_prefix         sample output(assuming the object is foo.json)
     * ========================  =============================================
     * gs://bucket/              gs://bucket/foo.json
     * gs://bucket/folder/       gs://bucket/folder/foo.json
     * gs://bucket/folder/item_  gs://bucket/folder/item_foo.json
     * </pre>
     *
     * <code>string output_uri_prefix = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for outputUriPrefix.
     */
    com.google.protobuf.ByteString getOutputUriPrefixBytes();
  }
  /**
   *
   *
   * <pre>
   * The Google Cloud Storage output destination configuration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2.OutputConfig.GcsDestination}
   */
  public static final class GcsDestination extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.OutputConfig.GcsDestination)
      GcsDestinationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GcsDestination.newBuilder() to construct.
    private GcsDestination(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GcsDestination() {
      outputUriPrefix_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GcsDestination();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2.ExportConfigProto
          .internal_static_google_cloud_retail_v2_OutputConfig_GcsDestination_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2.ExportConfigProto
          .internal_static_google_cloud_retail_v2_OutputConfig_GcsDestination_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2.OutputConfig.GcsDestination.class,
              com.google.cloud.retail.v2.OutputConfig.GcsDestination.Builder.class);
    }

    public static final int OUTPUT_URI_PREFIX_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object outputUriPrefix_ = "";
    /**
     *
     *
     * <pre>
     * Required. The output uri prefix for saving output data to json files.
     * Some mapping examples are as follows:
     * output_uri_prefix         sample output(assuming the object is foo.json)
     * ========================  =============================================
     * gs://bucket/              gs://bucket/foo.json
     * gs://bucket/folder/       gs://bucket/folder/foo.json
     * gs://bucket/folder/item_  gs://bucket/folder/item_foo.json
     * </pre>
     *
     * <code>string output_uri_prefix = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The outputUriPrefix.
     */
    @java.lang.Override
    public java.lang.String getOutputUriPrefix() {
      java.lang.Object ref = outputUriPrefix_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        outputUriPrefix_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The output uri prefix for saving output data to json files.
     * Some mapping examples are as follows:
     * output_uri_prefix         sample output(assuming the object is foo.json)
     * ========================  =============================================
     * gs://bucket/              gs://bucket/foo.json
     * gs://bucket/folder/       gs://bucket/folder/foo.json
     * gs://bucket/folder/item_  gs://bucket/folder/item_foo.json
     * </pre>
     *
     * <code>string output_uri_prefix = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for outputUriPrefix.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOutputUriPrefixBytes() {
      java.lang.Object ref = outputUriPrefix_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        outputUriPrefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputUriPrefix_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, outputUriPrefix_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputUriPrefix_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, outputUriPrefix_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2.OutputConfig.GcsDestination)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2.OutputConfig.GcsDestination other =
          (com.google.cloud.retail.v2.OutputConfig.GcsDestination) obj;

      if (!getOutputUriPrefix().equals(other.getOutputUriPrefix())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + OUTPUT_URI_PREFIX_FIELD_NUMBER;
      hash = (53 * hash) + getOutputUriPrefix().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2.OutputConfig.GcsDestination parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.OutputConfig.GcsDestination parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.OutputConfig.GcsDestination parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.OutputConfig.GcsDestination parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.OutputConfig.GcsDestination parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.OutputConfig.GcsDestination parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.OutputConfig.GcsDestination parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.OutputConfig.GcsDestination parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.OutputConfig.GcsDestination parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.OutputConfig.GcsDestination parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.OutputConfig.GcsDestination parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.OutputConfig.GcsDestination parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2.OutputConfig.GcsDestination prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage output destination configuration.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2.OutputConfig.GcsDestination}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.OutputConfig.GcsDestination)
        com.google.cloud.retail.v2.OutputConfig.GcsDestinationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2.ExportConfigProto
            .internal_static_google_cloud_retail_v2_OutputConfig_GcsDestination_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2.ExportConfigProto
            .internal_static_google_cloud_retail_v2_OutputConfig_GcsDestination_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2.OutputConfig.GcsDestination.class,
                com.google.cloud.retail.v2.OutputConfig.GcsDestination.Builder.class);
      }

      // Construct using com.google.cloud.retail.v2.OutputConfig.GcsDestination.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        outputUriPrefix_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2.ExportConfigProto
            .internal_static_google_cloud_retail_v2_OutputConfig_GcsDestination_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.OutputConfig.GcsDestination getDefaultInstanceForType() {
        return com.google.cloud.retail.v2.OutputConfig.GcsDestination.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.OutputConfig.GcsDestination build() {
        com.google.cloud.retail.v2.OutputConfig.GcsDestination result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.OutputConfig.GcsDestination buildPartial() {
        com.google.cloud.retail.v2.OutputConfig.GcsDestination result =
            new com.google.cloud.retail.v2.OutputConfig.GcsDestination(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.retail.v2.OutputConfig.GcsDestination result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.outputUriPrefix_ = outputUriPrefix_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2.OutputConfig.GcsDestination) {
          return mergeFrom((com.google.cloud.retail.v2.OutputConfig.GcsDestination) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.retail.v2.OutputConfig.GcsDestination other) {
        if (other == com.google.cloud.retail.v2.OutputConfig.GcsDestination.getDefaultInstance())
          return this;
        if (!other.getOutputUriPrefix().isEmpty()) {
          outputUriPrefix_ = other.outputUriPrefix_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  outputUriPrefix_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object outputUriPrefix_ = "";
      /**
       *
       *
       * <pre>
       * Required. The output uri prefix for saving output data to json files.
       * Some mapping examples are as follows:
       * output_uri_prefix         sample output(assuming the object is foo.json)
       * ========================  =============================================
       * gs://bucket/              gs://bucket/foo.json
       * gs://bucket/folder/       gs://bucket/folder/foo.json
       * gs://bucket/folder/item_  gs://bucket/folder/item_foo.json
       * </pre>
       *
       * <code>string output_uri_prefix = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The outputUriPrefix.
       */
      public java.lang.String getOutputUriPrefix() {
        java.lang.Object ref = outputUriPrefix_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          outputUriPrefix_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The output uri prefix for saving output data to json files.
       * Some mapping examples are as follows:
       * output_uri_prefix         sample output(assuming the object is foo.json)
       * ========================  =============================================
       * gs://bucket/              gs://bucket/foo.json
       * gs://bucket/folder/       gs://bucket/folder/foo.json
       * gs://bucket/folder/item_  gs://bucket/folder/item_foo.json
       * </pre>
       *
       * <code>string output_uri_prefix = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for outputUriPrefix.
       */
      public com.google.protobuf.ByteString getOutputUriPrefixBytes() {
        java.lang.Object ref = outputUriPrefix_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          outputUriPrefix_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The output uri prefix for saving output data to json files.
       * Some mapping examples are as follows:
       * output_uri_prefix         sample output(assuming the object is foo.json)
       * ========================  =============================================
       * gs://bucket/              gs://bucket/foo.json
       * gs://bucket/folder/       gs://bucket/folder/foo.json
       * gs://bucket/folder/item_  gs://bucket/folder/item_foo.json
       * </pre>
       *
       * <code>string output_uri_prefix = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The outputUriPrefix to set.
       * @return This builder for chaining.
       */
      public Builder setOutputUriPrefix(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputUriPrefix_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The output uri prefix for saving output data to json files.
       * Some mapping examples are as follows:
       * output_uri_prefix         sample output(assuming the object is foo.json)
       * ========================  =============================================
       * gs://bucket/              gs://bucket/foo.json
       * gs://bucket/folder/       gs://bucket/folder/foo.json
       * gs://bucket/folder/item_  gs://bucket/folder/item_foo.json
       * </pre>
       *
       * <code>string output_uri_prefix = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOutputUriPrefix() {
        outputUriPrefix_ = getDefaultInstance().getOutputUriPrefix();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The output uri prefix for saving output data to json files.
       * Some mapping examples are as follows:
       * output_uri_prefix         sample output(assuming the object is foo.json)
       * ========================  =============================================
       * gs://bucket/              gs://bucket/foo.json
       * gs://bucket/folder/       gs://bucket/folder/foo.json
       * gs://bucket/folder/item_  gs://bucket/folder/item_foo.json
       * </pre>
       *
       * <code>string output_uri_prefix = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for outputUriPrefix to set.
       * @return This builder for chaining.
       */
      public Builder setOutputUriPrefixBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        outputUriPrefix_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.OutputConfig.GcsDestination)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.OutputConfig.GcsDestination)
    private static final com.google.cloud.retail.v2.OutputConfig.GcsDestination DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2.OutputConfig.GcsDestination();
    }

    public static com.google.cloud.retail.v2.OutputConfig.GcsDestination getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GcsDestination> PARSER =
        new com.google.protobuf.AbstractParser<GcsDestination>() {
          @java.lang.Override
          public GcsDestination parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GcsDestination> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GcsDestination> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.OutputConfig.GcsDestination getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface BigQueryDestinationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2.OutputConfig.BigQueryDestination)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The ID of a BigQuery Dataset.
     * </pre>
     *
     * <code>string dataset_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The datasetId.
     */
    java.lang.String getDatasetId();
    /**
     *
     *
     * <pre>
     * Required. The ID of a BigQuery Dataset.
     * </pre>
     *
     * <code>string dataset_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for datasetId.
     */
    com.google.protobuf.ByteString getDatasetIdBytes();

    /**
     *
     *
     * <pre>
     * Required. The prefix of exported BigQuery tables.
     * </pre>
     *
     * <code>string table_id_prefix = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The tableIdPrefix.
     */
    java.lang.String getTableIdPrefix();
    /**
     *
     *
     * <pre>
     * Required. The prefix of exported BigQuery tables.
     * </pre>
     *
     * <code>string table_id_prefix = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for tableIdPrefix.
     */
    com.google.protobuf.ByteString getTableIdPrefixBytes();

    /**
     *
     *
     * <pre>
     * Required. Describes the table type. The following values are supported:
     *
     * * `table`: A BigQuery native table.
     * * `view`: A virtual table defined by a SQL query.
     * </pre>
     *
     * <code>string table_type = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The tableType.
     */
    java.lang.String getTableType();
    /**
     *
     *
     * <pre>
     * Required. Describes the table type. The following values are supported:
     *
     * * `table`: A BigQuery native table.
     * * `view`: A virtual table defined by a SQL query.
     * </pre>
     *
     * <code>string table_type = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for tableType.
     */
    com.google.protobuf.ByteString getTableTypeBytes();
  }
  /**
   *
   *
   * <pre>
   * The BigQuery output destination configuration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2.OutputConfig.BigQueryDestination}
   */
  public static final class BigQueryDestination extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.OutputConfig.BigQueryDestination)
      BigQueryDestinationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BigQueryDestination.newBuilder() to construct.
    private BigQueryDestination(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BigQueryDestination() {
      datasetId_ = "";
      tableIdPrefix_ = "";
      tableType_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BigQueryDestination();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2.ExportConfigProto
          .internal_static_google_cloud_retail_v2_OutputConfig_BigQueryDestination_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2.ExportConfigProto
          .internal_static_google_cloud_retail_v2_OutputConfig_BigQueryDestination_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2.OutputConfig.BigQueryDestination.class,
              com.google.cloud.retail.v2.OutputConfig.BigQueryDestination.Builder.class);
    }

    public static final int DATASET_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object datasetId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The ID of a BigQuery Dataset.
     * </pre>
     *
     * <code>string dataset_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The datasetId.
     */
    @java.lang.Override
    public java.lang.String getDatasetId() {
      java.lang.Object ref = datasetId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        datasetId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of a BigQuery Dataset.
     * </pre>
     *
     * <code>string dataset_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for datasetId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDatasetIdBytes() {
      java.lang.Object ref = datasetId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        datasetId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TABLE_ID_PREFIX_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object tableIdPrefix_ = "";
    /**
     *
     *
     * <pre>
     * Required. The prefix of exported BigQuery tables.
     * </pre>
     *
     * <code>string table_id_prefix = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The tableIdPrefix.
     */
    @java.lang.Override
    public java.lang.String getTableIdPrefix() {
      java.lang.Object ref = tableIdPrefix_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tableIdPrefix_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The prefix of exported BigQuery tables.
     * </pre>
     *
     * <code>string table_id_prefix = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for tableIdPrefix.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTableIdPrefixBytes() {
      java.lang.Object ref = tableIdPrefix_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tableIdPrefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TABLE_TYPE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object tableType_ = "";
    /**
     *
     *
     * <pre>
     * Required. Describes the table type. The following values are supported:
     *
     * * `table`: A BigQuery native table.
     * * `view`: A virtual table defined by a SQL query.
     * </pre>
     *
     * <code>string table_type = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The tableType.
     */
    @java.lang.Override
    public java.lang.String getTableType() {
      java.lang.Object ref = tableType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tableType_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Describes the table type. The following values are supported:
     *
     * * `table`: A BigQuery native table.
     * * `view`: A virtual table defined by a SQL query.
     * </pre>
     *
     * <code>string table_type = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for tableType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTableTypeBytes() {
      java.lang.Object ref = tableType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tableType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, datasetId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableIdPrefix_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, tableIdPrefix_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableType_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, tableType_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, datasetId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableIdPrefix_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, tableIdPrefix_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableType_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, tableType_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2.OutputConfig.BigQueryDestination)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2.OutputConfig.BigQueryDestination other =
          (com.google.cloud.retail.v2.OutputConfig.BigQueryDestination) obj;

      if (!getDatasetId().equals(other.getDatasetId())) return false;
      if (!getTableIdPrefix().equals(other.getTableIdPrefix())) return false;
      if (!getTableType().equals(other.getTableType())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DATASET_ID_FIELD_NUMBER;
      hash = (53 * hash) + getDatasetId().hashCode();
      hash = (37 * hash) + TABLE_ID_PREFIX_FIELD_NUMBER;
      hash = (53 * hash) + getTableIdPrefix().hashCode();
      hash = (37 * hash) + TABLE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getTableType().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2.OutputConfig.BigQueryDestination parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.OutputConfig.BigQueryDestination parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.OutputConfig.BigQueryDestination parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.OutputConfig.BigQueryDestination parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.OutputConfig.BigQueryDestination parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.OutputConfig.BigQueryDestination parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.OutputConfig.BigQueryDestination parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.OutputConfig.BigQueryDestination parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.OutputConfig.BigQueryDestination parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.OutputConfig.BigQueryDestination parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.OutputConfig.BigQueryDestination parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.OutputConfig.BigQueryDestination parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2.OutputConfig.BigQueryDestination prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The BigQuery output destination configuration.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2.OutputConfig.BigQueryDestination}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.OutputConfig.BigQueryDestination)
        com.google.cloud.retail.v2.OutputConfig.BigQueryDestinationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2.ExportConfigProto
            .internal_static_google_cloud_retail_v2_OutputConfig_BigQueryDestination_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2.ExportConfigProto
            .internal_static_google_cloud_retail_v2_OutputConfig_BigQueryDestination_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2.OutputConfig.BigQueryDestination.class,
                com.google.cloud.retail.v2.OutputConfig.BigQueryDestination.Builder.class);
      }

      // Construct using com.google.cloud.retail.v2.OutputConfig.BigQueryDestination.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        datasetId_ = "";
        tableIdPrefix_ = "";
        tableType_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2.ExportConfigProto
            .internal_static_google_cloud_retail_v2_OutputConfig_BigQueryDestination_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.OutputConfig.BigQueryDestination
          getDefaultInstanceForType() {
        return com.google.cloud.retail.v2.OutputConfig.BigQueryDestination.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.OutputConfig.BigQueryDestination build() {
        com.google.cloud.retail.v2.OutputConfig.BigQueryDestination result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.OutputConfig.BigQueryDestination buildPartial() {
        com.google.cloud.retail.v2.OutputConfig.BigQueryDestination result =
            new com.google.cloud.retail.v2.OutputConfig.BigQueryDestination(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.retail.v2.OutputConfig.BigQueryDestination result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.datasetId_ = datasetId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.tableIdPrefix_ = tableIdPrefix_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.tableType_ = tableType_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2.OutputConfig.BigQueryDestination) {
          return mergeFrom((com.google.cloud.retail.v2.OutputConfig.BigQueryDestination) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.retail.v2.OutputConfig.BigQueryDestination other) {
        if (other
            == com.google.cloud.retail.v2.OutputConfig.BigQueryDestination.getDefaultInstance())
          return this;
        if (!other.getDatasetId().isEmpty()) {
          datasetId_ = other.datasetId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getTableIdPrefix().isEmpty()) {
          tableIdPrefix_ = other.tableIdPrefix_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getTableType().isEmpty()) {
          tableType_ = other.tableType_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  datasetId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  tableIdPrefix_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  tableType_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object datasetId_ = "";
      /**
       *
       *
       * <pre>
       * Required. The ID of a BigQuery Dataset.
       * </pre>
       *
       * <code>string dataset_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The datasetId.
       */
      public java.lang.String getDatasetId() {
        java.lang.Object ref = datasetId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          datasetId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of a BigQuery Dataset.
       * </pre>
       *
       * <code>string dataset_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for datasetId.
       */
      public com.google.protobuf.ByteString getDatasetIdBytes() {
        java.lang.Object ref = datasetId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          datasetId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of a BigQuery Dataset.
       * </pre>
       *
       * <code>string dataset_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The datasetId to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        datasetId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of a BigQuery Dataset.
       * </pre>
       *
       * <code>string dataset_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDatasetId() {
        datasetId_ = getDefaultInstance().getDatasetId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of a BigQuery Dataset.
       * </pre>
       *
       * <code>string dataset_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for datasetId to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        datasetId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object tableIdPrefix_ = "";
      /**
       *
       *
       * <pre>
       * Required. The prefix of exported BigQuery tables.
       * </pre>
       *
       * <code>string table_id_prefix = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The tableIdPrefix.
       */
      public java.lang.String getTableIdPrefix() {
        java.lang.Object ref = tableIdPrefix_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          tableIdPrefix_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The prefix of exported BigQuery tables.
       * </pre>
       *
       * <code>string table_id_prefix = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for tableIdPrefix.
       */
      public com.google.protobuf.ByteString getTableIdPrefixBytes() {
        java.lang.Object ref = tableIdPrefix_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          tableIdPrefix_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The prefix of exported BigQuery tables.
       * </pre>
       *
       * <code>string table_id_prefix = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The tableIdPrefix to set.
       * @return This builder for chaining.
       */
      public Builder setTableIdPrefix(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        tableIdPrefix_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The prefix of exported BigQuery tables.
       * </pre>
       *
       * <code>string table_id_prefix = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTableIdPrefix() {
        tableIdPrefix_ = getDefaultInstance().getTableIdPrefix();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The prefix of exported BigQuery tables.
       * </pre>
       *
       * <code>string table_id_prefix = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for tableIdPrefix to set.
       * @return This builder for chaining.
       */
      public Builder setTableIdPrefixBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        tableIdPrefix_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object tableType_ = "";
      /**
       *
       *
       * <pre>
       * Required. Describes the table type. The following values are supported:
       *
       * * `table`: A BigQuery native table.
       * * `view`: A virtual table defined by a SQL query.
       * </pre>
       *
       * <code>string table_type = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The tableType.
       */
      public java.lang.String getTableType() {
        java.lang.Object ref = tableType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          tableType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Describes the table type. The following values are supported:
       *
       * * `table`: A BigQuery native table.
       * * `view`: A virtual table defined by a SQL query.
       * </pre>
       *
       * <code>string table_type = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for tableType.
       */
      public com.google.protobuf.ByteString getTableTypeBytes() {
        java.lang.Object ref = tableType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          tableType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Describes the table type. The following values are supported:
       *
       * * `table`: A BigQuery native table.
       * * `view`: A virtual table defined by a SQL query.
       * </pre>
       *
       * <code>string table_type = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The tableType to set.
       * @return This builder for chaining.
       */
      public Builder setTableType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        tableType_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Describes the table type. The following values are supported:
       *
       * * `table`: A BigQuery native table.
       * * `view`: A virtual table defined by a SQL query.
       * </pre>
       *
       * <code>string table_type = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTableType() {
        tableType_ = getDefaultInstance().getTableType();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Describes the table type. The following values are supported:
       *
       * * `table`: A BigQuery native table.
       * * `view`: A virtual table defined by a SQL query.
       * </pre>
       *
       * <code>string table_type = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for tableType to set.
       * @return This builder for chaining.
       */
      public Builder setTableTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        tableType_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.OutputConfig.BigQueryDestination)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.OutputConfig.BigQueryDestination)
    private static final com.google.cloud.retail.v2.OutputConfig.BigQueryDestination
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2.OutputConfig.BigQueryDestination();
    }

    public static com.google.cloud.retail.v2.OutputConfig.BigQueryDestination getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BigQueryDestination> PARSER =
        new com.google.protobuf.AbstractParser<BigQueryDestination>() {
          @java.lang.Override
          public BigQueryDestination parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BigQueryDestination> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BigQueryDestination> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.OutputConfig.BigQueryDestination getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int destinationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object destination_;

  public enum DestinationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_DESTINATION(1),
    BIGQUERY_DESTINATION(2),
    DESTINATION_NOT_SET(0);
    private final int value;

    private DestinationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DestinationCase valueOf(int value) {
      return forNumber(value);
    }

    public static DestinationCase forNumber(int value) {
      switch (value) {
        case 1:
          return GCS_DESTINATION;
        case 2:
          return BIGQUERY_DESTINATION;
        case 0:
          return DESTINATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DestinationCase getDestinationCase() {
    return DestinationCase.forNumber(destinationCase_);
  }

  public static final int GCS_DESTINATION_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * The Google Cloud Storage location where the output is to be written to.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.OutputConfig.GcsDestination gcs_destination = 1;</code>
   *
   * @return Whether the gcsDestination field is set.
   */
  @java.lang.Override
  public boolean hasGcsDestination() {
    return destinationCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * The Google Cloud Storage location where the output is to be written to.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.OutputConfig.GcsDestination gcs_destination = 1;</code>
   *
   * @return The gcsDestination.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.OutputConfig.GcsDestination getGcsDestination() {
    if (destinationCase_ == 1) {
      return (com.google.cloud.retail.v2.OutputConfig.GcsDestination) destination_;
    }
    return com.google.cloud.retail.v2.OutputConfig.GcsDestination.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The Google Cloud Storage location where the output is to be written to.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.OutputConfig.GcsDestination gcs_destination = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.OutputConfig.GcsDestinationOrBuilder
      getGcsDestinationOrBuilder() {
    if (destinationCase_ == 1) {
      return (com.google.cloud.retail.v2.OutputConfig.GcsDestination) destination_;
    }
    return com.google.cloud.retail.v2.OutputConfig.GcsDestination.getDefaultInstance();
  }

  public static final int BIGQUERY_DESTINATION_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The BigQuery location where the output is to be written to.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.OutputConfig.BigQueryDestination bigquery_destination = 2;</code>
   *
   * @return Whether the bigqueryDestination field is set.
   */
  @java.lang.Override
  public boolean hasBigqueryDestination() {
    return destinationCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The BigQuery location where the output is to be written to.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.OutputConfig.BigQueryDestination bigquery_destination = 2;</code>
   *
   * @return The bigqueryDestination.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.OutputConfig.BigQueryDestination getBigqueryDestination() {
    if (destinationCase_ == 2) {
      return (com.google.cloud.retail.v2.OutputConfig.BigQueryDestination) destination_;
    }
    return com.google.cloud.retail.v2.OutputConfig.BigQueryDestination.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The BigQuery location where the output is to be written to.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.OutputConfig.BigQueryDestination bigquery_destination = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.OutputConfig.BigQueryDestinationOrBuilder
      getBigqueryDestinationOrBuilder() {
    if (destinationCase_ == 2) {
      return (com.google.cloud.retail.v2.OutputConfig.BigQueryDestination) destination_;
    }
    return com.google.cloud.retail.v2.OutputConfig.BigQueryDestination.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (destinationCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.retail.v2.OutputConfig.GcsDestination) destination_);
    }
    if (destinationCase_ == 2) {
      output.writeMessage(
          2, (com.google.cloud.retail.v2.OutputConfig.BigQueryDestination) destination_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (destinationCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.retail.v2.OutputConfig.GcsDestination) destination_);
    }
    if (destinationCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.retail.v2.OutputConfig.BigQueryDestination) destination_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2.OutputConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2.OutputConfig other = (com.google.cloud.retail.v2.OutputConfig) obj;

    if (!getDestinationCase().equals(other.getDestinationCase())) return false;
    switch (destinationCase_) {
      case 1:
        if (!getGcsDestination().equals(other.getGcsDestination())) return false;
        break;
      case 2:
        if (!getBigqueryDestination().equals(other.getBigqueryDestination())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (destinationCase_) {
      case 1:
        hash = (37 * hash) + GCS_DESTINATION_FIELD_NUMBER;
        hash = (53 * hash) + getGcsDestination().hashCode();
        break;
      case 2:
        hash = (37 * hash) + BIGQUERY_DESTINATION_FIELD_NUMBER;
        hash = (53 * hash) + getBigqueryDestination().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2.OutputConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.OutputConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.OutputConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.OutputConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.OutputConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.OutputConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.OutputConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.OutputConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.OutputConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.OutputConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.OutputConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.OutputConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2.OutputConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The output configuration setting.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2.OutputConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.OutputConfig)
      com.google.cloud.retail.v2.OutputConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2.ExportConfigProto
          .internal_static_google_cloud_retail_v2_OutputConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2.ExportConfigProto
          .internal_static_google_cloud_retail_v2_OutputConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2.OutputConfig.class,
              com.google.cloud.retail.v2.OutputConfig.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2.OutputConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (gcsDestinationBuilder_ != null) {
        gcsDestinationBuilder_.clear();
      }
      if (bigqueryDestinationBuilder_ != null) {
        bigqueryDestinationBuilder_.clear();
      }
      destinationCase_ = 0;
      destination_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2.ExportConfigProto
          .internal_static_google_cloud_retail_v2_OutputConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.OutputConfig getDefaultInstanceForType() {
      return com.google.cloud.retail.v2.OutputConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.OutputConfig build() {
      com.google.cloud.retail.v2.OutputConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.OutputConfig buildPartial() {
      com.google.cloud.retail.v2.OutputConfig result =
          new com.google.cloud.retail.v2.OutputConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.retail.v2.OutputConfig result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.retail.v2.OutputConfig result) {
      result.destinationCase_ = destinationCase_;
      result.destination_ = this.destination_;
      if (destinationCase_ == 1 && gcsDestinationBuilder_ != null) {
        result.destination_ = gcsDestinationBuilder_.build();
      }
      if (destinationCase_ == 2 && bigqueryDestinationBuilder_ != null) {
        result.destination_ = bigqueryDestinationBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2.OutputConfig) {
        return mergeFrom((com.google.cloud.retail.v2.OutputConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2.OutputConfig other) {
      if (other == com.google.cloud.retail.v2.OutputConfig.getDefaultInstance()) return this;
      switch (other.getDestinationCase()) {
        case GCS_DESTINATION:
          {
            mergeGcsDestination(other.getGcsDestination());
            break;
          }
        case BIGQUERY_DESTINATION:
          {
            mergeBigqueryDestination(other.getBigqueryDestination());
            break;
          }
        case DESTINATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getGcsDestinationFieldBuilder().getBuilder(), extensionRegistry);
                destinationCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getBigqueryDestinationFieldBuilder().getBuilder(), extensionRegistry);
                destinationCase_ = 2;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int destinationCase_ = 0;
    private java.lang.Object destination_;

    public DestinationCase getDestinationCase() {
      return DestinationCase.forNumber(destinationCase_);
    }

    public Builder clearDestination() {
      destinationCase_ = 0;
      destination_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2.OutputConfig.GcsDestination,
            com.google.cloud.retail.v2.OutputConfig.GcsDestination.Builder,
            com.google.cloud.retail.v2.OutputConfig.GcsDestinationOrBuilder>
        gcsDestinationBuilder_;
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the output is to be written to.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.OutputConfig.GcsDestination gcs_destination = 1;</code>
     *
     * @return Whether the gcsDestination field is set.
     */
    @java.lang.Override
    public boolean hasGcsDestination() {
      return destinationCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the output is to be written to.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.OutputConfig.GcsDestination gcs_destination = 1;</code>
     *
     * @return The gcsDestination.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.OutputConfig.GcsDestination getGcsDestination() {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 1) {
          return (com.google.cloud.retail.v2.OutputConfig.GcsDestination) destination_;
        }
        return com.google.cloud.retail.v2.OutputConfig.GcsDestination.getDefaultInstance();
      } else {
        if (destinationCase_ == 1) {
          return gcsDestinationBuilder_.getMessage();
        }
        return com.google.cloud.retail.v2.OutputConfig.GcsDestination.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the output is to be written to.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.OutputConfig.GcsDestination gcs_destination = 1;</code>
     */
    public Builder setGcsDestination(com.google.cloud.retail.v2.OutputConfig.GcsDestination value) {
      if (gcsDestinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
        onChanged();
      } else {
        gcsDestinationBuilder_.setMessage(value);
      }
      destinationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the output is to be written to.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.OutputConfig.GcsDestination gcs_destination = 1;</code>
     */
    public Builder setGcsDestination(
        com.google.cloud.retail.v2.OutputConfig.GcsDestination.Builder builderForValue) {
      if (gcsDestinationBuilder_ == null) {
        destination_ = builderForValue.build();
        onChanged();
      } else {
        gcsDestinationBuilder_.setMessage(builderForValue.build());
      }
      destinationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the output is to be written to.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.OutputConfig.GcsDestination gcs_destination = 1;</code>
     */
    public Builder mergeGcsDestination(
        com.google.cloud.retail.v2.OutputConfig.GcsDestination value) {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 1
            && destination_
                != com.google.cloud.retail.v2.OutputConfig.GcsDestination.getDefaultInstance()) {
          destination_ =
              com.google.cloud.retail.v2.OutputConfig.GcsDestination.newBuilder(
                      (com.google.cloud.retail.v2.OutputConfig.GcsDestination) destination_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destination_ = value;
        }
        onChanged();
      } else {
        if (destinationCase_ == 1) {
          gcsDestinationBuilder_.mergeFrom(value);
        } else {
          gcsDestinationBuilder_.setMessage(value);
        }
      }
      destinationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the output is to be written to.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.OutputConfig.GcsDestination gcs_destination = 1;</code>
     */
    public Builder clearGcsDestination() {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 1) {
          destinationCase_ = 0;
          destination_ = null;
          onChanged();
        }
      } else {
        if (destinationCase_ == 1) {
          destinationCase_ = 0;
          destination_ = null;
        }
        gcsDestinationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the output is to be written to.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.OutputConfig.GcsDestination gcs_destination = 1;</code>
     */
    public com.google.cloud.retail.v2.OutputConfig.GcsDestination.Builder
        getGcsDestinationBuilder() {
      return getGcsDestinationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the output is to be written to.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.OutputConfig.GcsDestination gcs_destination = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.OutputConfig.GcsDestinationOrBuilder
        getGcsDestinationOrBuilder() {
      if ((destinationCase_ == 1) && (gcsDestinationBuilder_ != null)) {
        return gcsDestinationBuilder_.getMessageOrBuilder();
      } else {
        if (destinationCase_ == 1) {
          return (com.google.cloud.retail.v2.OutputConfig.GcsDestination) destination_;
        }
        return com.google.cloud.retail.v2.OutputConfig.GcsDestination.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the output is to be written to.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.OutputConfig.GcsDestination gcs_destination = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2.OutputConfig.GcsDestination,
            com.google.cloud.retail.v2.OutputConfig.GcsDestination.Builder,
            com.google.cloud.retail.v2.OutputConfig.GcsDestinationOrBuilder>
        getGcsDestinationFieldBuilder() {
      if (gcsDestinationBuilder_ == null) {
        if (!(destinationCase_ == 1)) {
          destination_ =
              com.google.cloud.retail.v2.OutputConfig.GcsDestination.getDefaultInstance();
        }
        gcsDestinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2.OutputConfig.GcsDestination,
                com.google.cloud.retail.v2.OutputConfig.GcsDestination.Builder,
                com.google.cloud.retail.v2.OutputConfig.GcsDestinationOrBuilder>(
                (com.google.cloud.retail.v2.OutputConfig.GcsDestination) destination_,
                getParentForChildren(),
                isClean());
        destination_ = null;
      }
      destinationCase_ = 1;
      onChanged();
      return gcsDestinationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2.OutputConfig.BigQueryDestination,
            com.google.cloud.retail.v2.OutputConfig.BigQueryDestination.Builder,
            com.google.cloud.retail.v2.OutputConfig.BigQueryDestinationOrBuilder>
        bigqueryDestinationBuilder_;
    /**
     *
     *
     * <pre>
     * The BigQuery location where the output is to be written to.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.OutputConfig.BigQueryDestination bigquery_destination = 2;
     * </code>
     *
     * @return Whether the bigqueryDestination field is set.
     */
    @java.lang.Override
    public boolean hasBigqueryDestination() {
      return destinationCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The BigQuery location where the output is to be written to.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.OutputConfig.BigQueryDestination bigquery_destination = 2;
     * </code>
     *
     * @return The bigqueryDestination.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.OutputConfig.BigQueryDestination getBigqueryDestination() {
      if (bigqueryDestinationBuilder_ == null) {
        if (destinationCase_ == 2) {
          return (com.google.cloud.retail.v2.OutputConfig.BigQueryDestination) destination_;
        }
        return com.google.cloud.retail.v2.OutputConfig.BigQueryDestination.getDefaultInstance();
      } else {
        if (destinationCase_ == 2) {
          return bigqueryDestinationBuilder_.getMessage();
        }
        return com.google.cloud.retail.v2.OutputConfig.BigQueryDestination.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The BigQuery location where the output is to be written to.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.OutputConfig.BigQueryDestination bigquery_destination = 2;
     * </code>
     */
    public Builder setBigqueryDestination(
        com.google.cloud.retail.v2.OutputConfig.BigQueryDestination value) {
      if (bigqueryDestinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
        onChanged();
      } else {
        bigqueryDestinationBuilder_.setMessage(value);
      }
      destinationCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BigQuery location where the output is to be written to.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.OutputConfig.BigQueryDestination bigquery_destination = 2;
     * </code>
     */
    public Builder setBigqueryDestination(
        com.google.cloud.retail.v2.OutputConfig.BigQueryDestination.Builder builderForValue) {
      if (bigqueryDestinationBuilder_ == null) {
        destination_ = builderForValue.build();
        onChanged();
      } else {
        bigqueryDestinationBuilder_.setMessage(builderForValue.build());
      }
      destinationCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BigQuery location where the output is to be written to.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.OutputConfig.BigQueryDestination bigquery_destination = 2;
     * </code>
     */
    public Builder mergeBigqueryDestination(
        com.google.cloud.retail.v2.OutputConfig.BigQueryDestination value) {
      if (bigqueryDestinationBuilder_ == null) {
        if (destinationCase_ == 2
            && destination_
                != com.google.cloud.retail.v2.OutputConfig.BigQueryDestination
                    .getDefaultInstance()) {
          destination_ =
              com.google.cloud.retail.v2.OutputConfig.BigQueryDestination.newBuilder(
                      (com.google.cloud.retail.v2.OutputConfig.BigQueryDestination) destination_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destination_ = value;
        }
        onChanged();
      } else {
        if (destinationCase_ == 2) {
          bigqueryDestinationBuilder_.mergeFrom(value);
        } else {
          bigqueryDestinationBuilder_.setMessage(value);
        }
      }
      destinationCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BigQuery location where the output is to be written to.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.OutputConfig.BigQueryDestination bigquery_destination = 2;
     * </code>
     */
    public Builder clearBigqueryDestination() {
      if (bigqueryDestinationBuilder_ == null) {
        if (destinationCase_ == 2) {
          destinationCase_ = 0;
          destination_ = null;
          onChanged();
        }
      } else {
        if (destinationCase_ == 2) {
          destinationCase_ = 0;
          destination_ = null;
        }
        bigqueryDestinationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BigQuery location where the output is to be written to.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.OutputConfig.BigQueryDestination bigquery_destination = 2;
     * </code>
     */
    public com.google.cloud.retail.v2.OutputConfig.BigQueryDestination.Builder
        getBigqueryDestinationBuilder() {
      return getBigqueryDestinationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The BigQuery location where the output is to be written to.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.OutputConfig.BigQueryDestination bigquery_destination = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.OutputConfig.BigQueryDestinationOrBuilder
        getBigqueryDestinationOrBuilder() {
      if ((destinationCase_ == 2) && (bigqueryDestinationBuilder_ != null)) {
        return bigqueryDestinationBuilder_.getMessageOrBuilder();
      } else {
        if (destinationCase_ == 2) {
          return (com.google.cloud.retail.v2.OutputConfig.BigQueryDestination) destination_;
        }
        return com.google.cloud.retail.v2.OutputConfig.BigQueryDestination.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The BigQuery location where the output is to be written to.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.OutputConfig.BigQueryDestination bigquery_destination = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2.OutputConfig.BigQueryDestination,
            com.google.cloud.retail.v2.OutputConfig.BigQueryDestination.Builder,
            com.google.cloud.retail.v2.OutputConfig.BigQueryDestinationOrBuilder>
        getBigqueryDestinationFieldBuilder() {
      if (bigqueryDestinationBuilder_ == null) {
        if (!(destinationCase_ == 2)) {
          destination_ =
              com.google.cloud.retail.v2.OutputConfig.BigQueryDestination.getDefaultInstance();
        }
        bigqueryDestinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2.OutputConfig.BigQueryDestination,
                com.google.cloud.retail.v2.OutputConfig.BigQueryDestination.Builder,
                com.google.cloud.retail.v2.OutputConfig.BigQueryDestinationOrBuilder>(
                (com.google.cloud.retail.v2.OutputConfig.BigQueryDestination) destination_,
                getParentForChildren(),
                isClean());
        destination_ = null;
      }
      destinationCase_ = 2;
      onChanged();
      return bigqueryDestinationBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.OutputConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.OutputConfig)
  private static final com.google.cloud.retail.v2.OutputConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2.OutputConfig();
  }

  public static com.google.cloud.retail.v2.OutputConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OutputConfig> PARSER =
      new com.google.protobuf.AbstractParser<OutputConfig>() {
        @java.lang.Override
        public OutputConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OutputConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OutputConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2.OutputConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
