/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2/product.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2;

public interface ProductOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2.Product)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Note that this field is applied in the following ways:
   *
   * * If the [Product][google.cloud.retail.v2.Product] is already expired
   * when it is uploaded, this product
   *   is not indexed for search.
   *
   * * If the [Product][google.cloud.retail.v2.Product] is not expired when it
   * is uploaded, only the
   *   [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]'s and
   *   [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION]'s
   *   expireTime is respected, and
   *   [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]'s
   *   expireTime is not used.
   *
   * In general, we suggest the users to delete the stale
   * products explicitly, instead of using this field to determine staleness.
   *
   * [expire_time][google.cloud.retail.v2.Product.expire_time] must be later
   * than [available_time][google.cloud.retail.v2.Product.available_time] and
   * [publish_time][google.cloud.retail.v2.Product.publish_time], otherwise an
   * INVALID_ARGUMENT error is thrown.
   *
   * Corresponding properties: Google Merchant Center property
   * [expiration_date](https://support.google.com/merchants/answer/6324499).
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 16;</code>
   *
   * @return Whether the expireTime field is set.
   */
  boolean hasExpireTime();
  /**
   *
   *
   * <pre>
   * Note that this field is applied in the following ways:
   *
   * * If the [Product][google.cloud.retail.v2.Product] is already expired
   * when it is uploaded, this product
   *   is not indexed for search.
   *
   * * If the [Product][google.cloud.retail.v2.Product] is not expired when it
   * is uploaded, only the
   *   [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]'s and
   *   [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION]'s
   *   expireTime is respected, and
   *   [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]'s
   *   expireTime is not used.
   *
   * In general, we suggest the users to delete the stale
   * products explicitly, instead of using this field to determine staleness.
   *
   * [expire_time][google.cloud.retail.v2.Product.expire_time] must be later
   * than [available_time][google.cloud.retail.v2.Product.available_time] and
   * [publish_time][google.cloud.retail.v2.Product.publish_time], otherwise an
   * INVALID_ARGUMENT error is thrown.
   *
   * Corresponding properties: Google Merchant Center property
   * [expiration_date](https://support.google.com/merchants/answer/6324499).
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 16;</code>
   *
   * @return The expireTime.
   */
  com.google.protobuf.Timestamp getExpireTime();
  /**
   *
   *
   * <pre>
   * Note that this field is applied in the following ways:
   *
   * * If the [Product][google.cloud.retail.v2.Product] is already expired
   * when it is uploaded, this product
   *   is not indexed for search.
   *
   * * If the [Product][google.cloud.retail.v2.Product] is not expired when it
   * is uploaded, only the
   *   [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]'s and
   *   [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION]'s
   *   expireTime is respected, and
   *   [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]'s
   *   expireTime is not used.
   *
   * In general, we suggest the users to delete the stale
   * products explicitly, instead of using this field to determine staleness.
   *
   * [expire_time][google.cloud.retail.v2.Product.expire_time] must be later
   * than [available_time][google.cloud.retail.v2.Product.available_time] and
   * [publish_time][google.cloud.retail.v2.Product.publish_time], otherwise an
   * INVALID_ARGUMENT error is thrown.
   *
   * Corresponding properties: Google Merchant Center property
   * [expiration_date](https://support.google.com/merchants/answer/6324499).
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 16;</code>
   */
  com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Input only. The TTL (time to live) of the product. Note that this is only
   * applicable to [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * and [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION],
   * and ignored for
   * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]. In general,
   * we suggest the users to delete the stale products explicitly, instead of
   * using this field to determine staleness.
   *
   * If it is set, it must be a non-negative value, and
   * [expire_time][google.cloud.retail.v2.Product.expire_time] is set as
   * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl]. The
   * derived [expire_time][google.cloud.retail.v2.Product.expire_time] is
   * returned in the output and [ttl][google.cloud.retail.v2.Product.ttl] is
   * left blank when retrieving the [Product][google.cloud.retail.v2.Product].
   *
   * If it is set, the product is not available for
   * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
   * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl].
   * However, the product can still be retrieved by
   * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
   * and
   * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 17 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return Whether the ttl field is set.
   */
  boolean hasTtl();
  /**
   *
   *
   * <pre>
   * Input only. The TTL (time to live) of the product. Note that this is only
   * applicable to [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * and [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION],
   * and ignored for
   * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]. In general,
   * we suggest the users to delete the stale products explicitly, instead of
   * using this field to determine staleness.
   *
   * If it is set, it must be a non-negative value, and
   * [expire_time][google.cloud.retail.v2.Product.expire_time] is set as
   * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl]. The
   * derived [expire_time][google.cloud.retail.v2.Product.expire_time] is
   * returned in the output and [ttl][google.cloud.retail.v2.Product.ttl] is
   * left blank when retrieving the [Product][google.cloud.retail.v2.Product].
   *
   * If it is set, the product is not available for
   * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
   * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl].
   * However, the product can still be retrieved by
   * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
   * and
   * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 17 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The ttl.
   */
  com.google.protobuf.Duration getTtl();
  /**
   *
   *
   * <pre>
   * Input only. The TTL (time to live) of the product. Note that this is only
   * applicable to [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * and [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION],
   * and ignored for
   * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]. In general,
   * we suggest the users to delete the stale products explicitly, instead of
   * using this field to determine staleness.
   *
   * If it is set, it must be a non-negative value, and
   * [expire_time][google.cloud.retail.v2.Product.expire_time] is set as
   * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl]. The
   * derived [expire_time][google.cloud.retail.v2.Product.expire_time] is
   * returned in the output and [ttl][google.cloud.retail.v2.Product.ttl] is
   * left blank when retrieving the [Product][google.cloud.retail.v2.Product].
   *
   * If it is set, the product is not available for
   * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] after
   * current timestamp plus [ttl][google.cloud.retail.v2.Product.ttl].
   * However, the product can still be retrieved by
   * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
   * and
   * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 17 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   */
  com.google.protobuf.DurationOrBuilder getTtlOrBuilder();

  /**
   *
   *
   * <pre>
   * Immutable. Full resource name of the product, such as
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/product_id`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Immutable. Full resource name of the product, such as
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/product_id`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Immutable. [Product][google.cloud.retail.v2.Product] identifier, which is
   * the final component of [name][google.cloud.retail.v2.Product.name]. For
   * example, this field is "id_1", if
   * [name][google.cloud.retail.v2.Product.name] is
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/id_1`.
   *
   * This field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [id](https://support.google.com/merchants/answer/6324405). Schema.org
   * property [Product.sku](https://schema.org/sku).
   * </pre>
   *
   * <code>string id = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The id.
   */
  java.lang.String getId();
  /**
   *
   *
   * <pre>
   * Immutable. [Product][google.cloud.retail.v2.Product] identifier, which is
   * the final component of [name][google.cloud.retail.v2.Product.name]. For
   * example, this field is "id_1", if
   * [name][google.cloud.retail.v2.Product.name] is
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/id_1`.
   *
   * This field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [id](https://support.google.com/merchants/answer/6324405). Schema.org
   * property [Product.sku](https://schema.org/sku).
   * </pre>
   *
   * <code>string id = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for id.
   */
  com.google.protobuf.ByteString getIdBytes();

  /**
   *
   *
   * <pre>
   * Immutable. The type of the product. Default to
   * [Catalog.product_level_config.ingestion_product_type][google.cloud.retail.v2.ProductLevelConfig.ingestion_product_type]
   * if unset.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.Product.Type type = 3 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for type.
   */
  int getTypeValue();
  /**
   *
   *
   * <pre>
   * Immutable. The type of the product. Default to
   * [Catalog.product_level_config.ingestion_product_type][google.cloud.retail.v2.ProductLevelConfig.ingestion_product_type]
   * if unset.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.Product.Type type = 3 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The type.
   */
  com.google.cloud.retail.v2.Product.Type getType();

  /**
   *
   *
   * <pre>
   * Variant group identifier. Must be an
   * [id][google.cloud.retail.v2.Product.id], with the same parent branch with
   * this product. Otherwise, an error is thrown.
   *
   * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2.Product]s, this field can only be empty or
   * set to the same value as [id][google.cloud.retail.v2.Product.id].
   *
   * For VARIANT [Product][google.cloud.retail.v2.Product]s, this field cannot
   * be empty. A maximum of 2,000 products are allowed to share the same
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2.Product]. Otherwise, an INVALID_ARGUMENT
   * error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [item_group_id](https://support.google.com/merchants/answer/6324507).
   * Schema.org property
   * [Product.inProductGroupWithID](https://schema.org/inProductGroupWithID).
   * </pre>
   *
   * <code>string primary_product_id = 4;</code>
   *
   * @return The primaryProductId.
   */
  java.lang.String getPrimaryProductId();
  /**
   *
   *
   * <pre>
   * Variant group identifier. Must be an
   * [id][google.cloud.retail.v2.Product.id], with the same parent branch with
   * this product. Otherwise, an error is thrown.
   *
   * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2.Product]s, this field can only be empty or
   * set to the same value as [id][google.cloud.retail.v2.Product.id].
   *
   * For VARIANT [Product][google.cloud.retail.v2.Product]s, this field cannot
   * be empty. A maximum of 2,000 products are allowed to share the same
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2.Product]. Otherwise, an INVALID_ARGUMENT
   * error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [item_group_id](https://support.google.com/merchants/answer/6324507).
   * Schema.org property
   * [Product.inProductGroupWithID](https://schema.org/inProductGroupWithID).
   * </pre>
   *
   * <code>string primary_product_id = 4;</code>
   *
   * @return The bytes for primaryProductId.
   */
  com.google.protobuf.ByteString getPrimaryProductIdBytes();

  /**
   *
   *
   * <pre>
   * The [id][google.cloud.retail.v2.Product.id] of the collection members when
   * [type][google.cloud.retail.v2.Product.type] is
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION].
   *
   * Non-existent product ids are allowed.
   * The [type][google.cloud.retail.v2.Product.type] of the members must be
   * either [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] or
   * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT] otherwise an
   * INVALID_ARGUMENT error is thrown. Should not set it for other types. A
   * maximum of 1000 values are allowed. Otherwise, an INVALID_ARGUMENT error is
   * return.
   * </pre>
   *
   * <code>repeated string collection_member_ids = 5;</code>
   *
   * @return A list containing the collectionMemberIds.
   */
  java.util.List<java.lang.String> getCollectionMemberIdsList();
  /**
   *
   *
   * <pre>
   * The [id][google.cloud.retail.v2.Product.id] of the collection members when
   * [type][google.cloud.retail.v2.Product.type] is
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION].
   *
   * Non-existent product ids are allowed.
   * The [type][google.cloud.retail.v2.Product.type] of the members must be
   * either [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] or
   * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT] otherwise an
   * INVALID_ARGUMENT error is thrown. Should not set it for other types. A
   * maximum of 1000 values are allowed. Otherwise, an INVALID_ARGUMENT error is
   * return.
   * </pre>
   *
   * <code>repeated string collection_member_ids = 5;</code>
   *
   * @return The count of collectionMemberIds.
   */
  int getCollectionMemberIdsCount();
  /**
   *
   *
   * <pre>
   * The [id][google.cloud.retail.v2.Product.id] of the collection members when
   * [type][google.cloud.retail.v2.Product.type] is
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION].
   *
   * Non-existent product ids are allowed.
   * The [type][google.cloud.retail.v2.Product.type] of the members must be
   * either [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] or
   * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT] otherwise an
   * INVALID_ARGUMENT error is thrown. Should not set it for other types. A
   * maximum of 1000 values are allowed. Otherwise, an INVALID_ARGUMENT error is
   * return.
   * </pre>
   *
   * <code>repeated string collection_member_ids = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The collectionMemberIds at the given index.
   */
  java.lang.String getCollectionMemberIds(int index);
  /**
   *
   *
   * <pre>
   * The [id][google.cloud.retail.v2.Product.id] of the collection members when
   * [type][google.cloud.retail.v2.Product.type] is
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION].
   *
   * Non-existent product ids are allowed.
   * The [type][google.cloud.retail.v2.Product.type] of the members must be
   * either [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] or
   * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT] otherwise an
   * INVALID_ARGUMENT error is thrown. Should not set it for other types. A
   * maximum of 1000 values are allowed. Otherwise, an INVALID_ARGUMENT error is
   * return.
   * </pre>
   *
   * <code>repeated string collection_member_ids = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the collectionMemberIds at the given index.
   */
  com.google.protobuf.ByteString getCollectionMemberIdsBytes(int index);

  /**
   *
   *
   * <pre>
   * The Global Trade Item Number (GTIN) of the product.
   *
   * This field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * This field must be a Unigram. Otherwise, an INVALID_ARGUMENT error is
   * returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [gtin](https://support.google.com/merchants/answer/6324461).
   * Schema.org property
   * [Product.isbn](https://schema.org/isbn),
   * [Product.gtin8](https://schema.org/gtin8),
   * [Product.gtin12](https://schema.org/gtin12),
   * [Product.gtin13](https://schema.org/gtin13), or
   * [Product.gtin14](https://schema.org/gtin14).
   *
   * If the value is not a valid GTIN, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>string gtin = 6;</code>
   *
   * @return The gtin.
   */
  java.lang.String getGtin();
  /**
   *
   *
   * <pre>
   * The Global Trade Item Number (GTIN) of the product.
   *
   * This field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * This field must be a Unigram. Otherwise, an INVALID_ARGUMENT error is
   * returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [gtin](https://support.google.com/merchants/answer/6324461).
   * Schema.org property
   * [Product.isbn](https://schema.org/isbn),
   * [Product.gtin8](https://schema.org/gtin8),
   * [Product.gtin12](https://schema.org/gtin12),
   * [Product.gtin13](https://schema.org/gtin13), or
   * [Product.gtin14](https://schema.org/gtin14).
   *
   * If the value is not a valid GTIN, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>string gtin = 6;</code>
   *
   * @return The bytes for gtin.
   */
  com.google.protobuf.ByteString getGtinBytes();

  /**
   *
   *
   * <pre>
   * Product categories. This field is repeated for supporting one product
   * belonging to several parallel categories. Strongly recommended using the
   * full path for better search / recommendation quality.
   *
   *
   * To represent full path of category, use '&gt;' sign to separate different
   * hierarchies. If '&gt;' is part of the category name, replace it with
   * other character(s).
   *
   * For example, if a shoes product belongs to both
   * ["Shoes &amp; Accessories" -&gt; "Shoes"] and
   * ["Sports &amp; Fitness" -&gt; "Athletic Clothing" -&gt; "Shoes"], it could be
   * represented as:
   *
   *      "categories": [
   *        "Shoes &amp; Accessories &gt; Shoes",
   *        "Sports &amp; Fitness &gt; Athletic Clothing &gt; Shoes"
   *      ]
   *
   * Must be set for [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2.Product] otherwise an INVALID_ARGUMENT
   * error is returned.
   *
   * At most 250 values are allowed per
   * [Product][google.cloud.retail.v2.Product] unless overridden through the
   * Google Cloud console. Empty values are not allowed. Each value must be a
   * UTF-8 encoded string with a length limit of 5,000 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [google_product_category][mc_google_product_category]. Schema.org property
   * [Product.category] (https://schema.org/category).
   *
   * [mc_google_product_category]:
   * https://support.google.com/merchants/answer/6324436
   * </pre>
   *
   * <code>repeated string categories = 7;</code>
   *
   * @return A list containing the categories.
   */
  java.util.List<java.lang.String> getCategoriesList();
  /**
   *
   *
   * <pre>
   * Product categories. This field is repeated for supporting one product
   * belonging to several parallel categories. Strongly recommended using the
   * full path for better search / recommendation quality.
   *
   *
   * To represent full path of category, use '&gt;' sign to separate different
   * hierarchies. If '&gt;' is part of the category name, replace it with
   * other character(s).
   *
   * For example, if a shoes product belongs to both
   * ["Shoes &amp; Accessories" -&gt; "Shoes"] and
   * ["Sports &amp; Fitness" -&gt; "Athletic Clothing" -&gt; "Shoes"], it could be
   * represented as:
   *
   *      "categories": [
   *        "Shoes &amp; Accessories &gt; Shoes",
   *        "Sports &amp; Fitness &gt; Athletic Clothing &gt; Shoes"
   *      ]
   *
   * Must be set for [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2.Product] otherwise an INVALID_ARGUMENT
   * error is returned.
   *
   * At most 250 values are allowed per
   * [Product][google.cloud.retail.v2.Product] unless overridden through the
   * Google Cloud console. Empty values are not allowed. Each value must be a
   * UTF-8 encoded string with a length limit of 5,000 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [google_product_category][mc_google_product_category]. Schema.org property
   * [Product.category] (https://schema.org/category).
   *
   * [mc_google_product_category]:
   * https://support.google.com/merchants/answer/6324436
   * </pre>
   *
   * <code>repeated string categories = 7;</code>
   *
   * @return The count of categories.
   */
  int getCategoriesCount();
  /**
   *
   *
   * <pre>
   * Product categories. This field is repeated for supporting one product
   * belonging to several parallel categories. Strongly recommended using the
   * full path for better search / recommendation quality.
   *
   *
   * To represent full path of category, use '&gt;' sign to separate different
   * hierarchies. If '&gt;' is part of the category name, replace it with
   * other character(s).
   *
   * For example, if a shoes product belongs to both
   * ["Shoes &amp; Accessories" -&gt; "Shoes"] and
   * ["Sports &amp; Fitness" -&gt; "Athletic Clothing" -&gt; "Shoes"], it could be
   * represented as:
   *
   *      "categories": [
   *        "Shoes &amp; Accessories &gt; Shoes",
   *        "Sports &amp; Fitness &gt; Athletic Clothing &gt; Shoes"
   *      ]
   *
   * Must be set for [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2.Product] otherwise an INVALID_ARGUMENT
   * error is returned.
   *
   * At most 250 values are allowed per
   * [Product][google.cloud.retail.v2.Product] unless overridden through the
   * Google Cloud console. Empty values are not allowed. Each value must be a
   * UTF-8 encoded string with a length limit of 5,000 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [google_product_category][mc_google_product_category]. Schema.org property
   * [Product.category] (https://schema.org/category).
   *
   * [mc_google_product_category]:
   * https://support.google.com/merchants/answer/6324436
   * </pre>
   *
   * <code>repeated string categories = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The categories at the given index.
   */
  java.lang.String getCategories(int index);
  /**
   *
   *
   * <pre>
   * Product categories. This field is repeated for supporting one product
   * belonging to several parallel categories. Strongly recommended using the
   * full path for better search / recommendation quality.
   *
   *
   * To represent full path of category, use '&gt;' sign to separate different
   * hierarchies. If '&gt;' is part of the category name, replace it with
   * other character(s).
   *
   * For example, if a shoes product belongs to both
   * ["Shoes &amp; Accessories" -&gt; "Shoes"] and
   * ["Sports &amp; Fitness" -&gt; "Athletic Clothing" -&gt; "Shoes"], it could be
   * represented as:
   *
   *      "categories": [
   *        "Shoes &amp; Accessories &gt; Shoes",
   *        "Sports &amp; Fitness &gt; Athletic Clothing &gt; Shoes"
   *      ]
   *
   * Must be set for [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2.Product] otherwise an INVALID_ARGUMENT
   * error is returned.
   *
   * At most 250 values are allowed per
   * [Product][google.cloud.retail.v2.Product] unless overridden through the
   * Google Cloud console. Empty values are not allowed. Each value must be a
   * UTF-8 encoded string with a length limit of 5,000 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [google_product_category][mc_google_product_category]. Schema.org property
   * [Product.category] (https://schema.org/category).
   *
   * [mc_google_product_category]:
   * https://support.google.com/merchants/answer/6324436
   * </pre>
   *
   * <code>repeated string categories = 7;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the categories at the given index.
   */
  com.google.protobuf.ByteString getCategoriesBytes(int index);

  /**
   *
   *
   * <pre>
   * Required. Product title.
   *
   * This field must be a UTF-8 encoded string with a length limit of 1,000
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [title](https://support.google.com/merchants/answer/6324415). Schema.org
   * property [Product.name](https://schema.org/name).
   * </pre>
   *
   * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The title.
   */
  java.lang.String getTitle();
  /**
   *
   *
   * <pre>
   * Required. Product title.
   *
   * This field must be a UTF-8 encoded string with a length limit of 1,000
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [title](https://support.google.com/merchants/answer/6324415). Schema.org
   * property [Product.name](https://schema.org/name).
   * </pre>
   *
   * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for title.
   */
  com.google.protobuf.ByteString getTitleBytes();

  /**
   *
   *
   * <pre>
   * The brands of the product.
   *
   * A maximum of 30 brands are allowed unless overridden through the Google
   * Cloud console. Each
   * brand must be a UTF-8 encoded string with a length limit of 1,000
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [brand](https://support.google.com/merchants/answer/6324351). Schema.org
   * property [Product.brand](https://schema.org/brand).
   * </pre>
   *
   * <code>repeated string brands = 9;</code>
   *
   * @return A list containing the brands.
   */
  java.util.List<java.lang.String> getBrandsList();
  /**
   *
   *
   * <pre>
   * The brands of the product.
   *
   * A maximum of 30 brands are allowed unless overridden through the Google
   * Cloud console. Each
   * brand must be a UTF-8 encoded string with a length limit of 1,000
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [brand](https://support.google.com/merchants/answer/6324351). Schema.org
   * property [Product.brand](https://schema.org/brand).
   * </pre>
   *
   * <code>repeated string brands = 9;</code>
   *
   * @return The count of brands.
   */
  int getBrandsCount();
  /**
   *
   *
   * <pre>
   * The brands of the product.
   *
   * A maximum of 30 brands are allowed unless overridden through the Google
   * Cloud console. Each
   * brand must be a UTF-8 encoded string with a length limit of 1,000
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [brand](https://support.google.com/merchants/answer/6324351). Schema.org
   * property [Product.brand](https://schema.org/brand).
   * </pre>
   *
   * <code>repeated string brands = 9;</code>
   *
   * @param index The index of the element to return.
   * @return The brands at the given index.
   */
  java.lang.String getBrands(int index);
  /**
   *
   *
   * <pre>
   * The brands of the product.
   *
   * A maximum of 30 brands are allowed unless overridden through the Google
   * Cloud console. Each
   * brand must be a UTF-8 encoded string with a length limit of 1,000
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [brand](https://support.google.com/merchants/answer/6324351). Schema.org
   * property [Product.brand](https://schema.org/brand).
   * </pre>
   *
   * <code>repeated string brands = 9;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the brands at the given index.
   */
  com.google.protobuf.ByteString getBrandsBytes(int index);

  /**
   *
   *
   * <pre>
   * Product description.
   *
   * This field must be a UTF-8 encoded string with a length limit of 5,000
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [description](https://support.google.com/merchants/answer/6324468).
   * Schema.org property [Product.description](https://schema.org/description).
   * </pre>
   *
   * <code>string description = 10;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();
  /**
   *
   *
   * <pre>
   * Product description.
   *
   * This field must be a UTF-8 encoded string with a length limit of 5,000
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [description](https://support.google.com/merchants/answer/6324468).
   * Schema.org property [Product.description](https://schema.org/description).
   * </pre>
   *
   * <code>string description = 10;</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * Language of the title/description and other string attributes. Use language
   * tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
   *
   * For product prediction, this field is ignored and the model automatically
   * detects the text language. The [Product][google.cloud.retail.v2.Product]
   * can include text in different languages, but duplicating
   * [Product][google.cloud.retail.v2.Product]s to provide text in multiple
   * languages can result in degraded model performance.
   *
   * For product search this field is in use. It defaults to "en-US" if unset.
   * </pre>
   *
   * <code>string language_code = 11;</code>
   *
   * @return The languageCode.
   */
  java.lang.String getLanguageCode();
  /**
   *
   *
   * <pre>
   * Language of the title/description and other string attributes. Use language
   * tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
   *
   * For product prediction, this field is ignored and the model automatically
   * detects the text language. The [Product][google.cloud.retail.v2.Product]
   * can include text in different languages, but duplicating
   * [Product][google.cloud.retail.v2.Product]s to provide text in multiple
   * languages can result in degraded model performance.
   *
   * For product search this field is in use. It defaults to "en-US" if unset.
   * </pre>
   *
   * <code>string language_code = 11;</code>
   *
   * @return The bytes for languageCode.
   */
  com.google.protobuf.ByteString getLanguageCodeBytes();

  /**
   *
   *
   * <pre>
   * Highly encouraged. Extra product attributes to be included. For example,
   * for products, this could include the store name, vendor, style, color, etc.
   * These are very strong signals for recommendation model, thus we highly
   * recommend providing the attributes here.
   *
   * Features that can take on one of a limited number of possible values. Two
   * types of features can be set are:
   *
   * Textual features. some examples would be the brand/maker of a product, or
   * country of a customer. Numerical features. Some examples would be the
   * height/weight of a product, or age of a customer.
   *
   * For example: `{ "vendor": {"text": ["vendor123", "vendor456"]},
   * "lengths_cm": {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]}
   * }`.
   *
   * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
   * error is returned:
   *
   * * Max entries count: 200.
   * * The key must be a UTF-8 encoded string with a length limit of 128
   *   characters.
   * * For indexable attribute, the key must match the pattern:
   *   `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example, `key0LikeThis` or
   *   `KEY_1_LIKE_THIS`.
   * * For text attributes, at most 400 values are allowed. Empty values are not
   *   allowed. Each value must be a non-empty UTF-8 encoded string with a
   *   length limit of 256 characters.
   * * For number attributes, at most 400 values are allowed.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 12;</code>
   */
  int getAttributesCount();
  /**
   *
   *
   * <pre>
   * Highly encouraged. Extra product attributes to be included. For example,
   * for products, this could include the store name, vendor, style, color, etc.
   * These are very strong signals for recommendation model, thus we highly
   * recommend providing the attributes here.
   *
   * Features that can take on one of a limited number of possible values. Two
   * types of features can be set are:
   *
   * Textual features. some examples would be the brand/maker of a product, or
   * country of a customer. Numerical features. Some examples would be the
   * height/weight of a product, or age of a customer.
   *
   * For example: `{ "vendor": {"text": ["vendor123", "vendor456"]},
   * "lengths_cm": {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]}
   * }`.
   *
   * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
   * error is returned:
   *
   * * Max entries count: 200.
   * * The key must be a UTF-8 encoded string with a length limit of 128
   *   characters.
   * * For indexable attribute, the key must match the pattern:
   *   `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example, `key0LikeThis` or
   *   `KEY_1_LIKE_THIS`.
   * * For text attributes, at most 400 values are allowed. Empty values are not
   *   allowed. Each value must be a non-empty UTF-8 encoded string with a
   *   length limit of 256 characters.
   * * For number attributes, at most 400 values are allowed.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 12;</code>
   */
  boolean containsAttributes(java.lang.String key);
  /** Use {@link #getAttributesMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, com.google.cloud.retail.v2.CustomAttribute> getAttributes();
  /**
   *
   *
   * <pre>
   * Highly encouraged. Extra product attributes to be included. For example,
   * for products, this could include the store name, vendor, style, color, etc.
   * These are very strong signals for recommendation model, thus we highly
   * recommend providing the attributes here.
   *
   * Features that can take on one of a limited number of possible values. Two
   * types of features can be set are:
   *
   * Textual features. some examples would be the brand/maker of a product, or
   * country of a customer. Numerical features. Some examples would be the
   * height/weight of a product, or age of a customer.
   *
   * For example: `{ "vendor": {"text": ["vendor123", "vendor456"]},
   * "lengths_cm": {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]}
   * }`.
   *
   * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
   * error is returned:
   *
   * * Max entries count: 200.
   * * The key must be a UTF-8 encoded string with a length limit of 128
   *   characters.
   * * For indexable attribute, the key must match the pattern:
   *   `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example, `key0LikeThis` or
   *   `KEY_1_LIKE_THIS`.
   * * For text attributes, at most 400 values are allowed. Empty values are not
   *   allowed. Each value must be a non-empty UTF-8 encoded string with a
   *   length limit of 256 characters.
   * * For number attributes, at most 400 values are allowed.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 12;</code>
   */
  java.util.Map<java.lang.String, com.google.cloud.retail.v2.CustomAttribute> getAttributesMap();
  /**
   *
   *
   * <pre>
   * Highly encouraged. Extra product attributes to be included. For example,
   * for products, this could include the store name, vendor, style, color, etc.
   * These are very strong signals for recommendation model, thus we highly
   * recommend providing the attributes here.
   *
   * Features that can take on one of a limited number of possible values. Two
   * types of features can be set are:
   *
   * Textual features. some examples would be the brand/maker of a product, or
   * country of a customer. Numerical features. Some examples would be the
   * height/weight of a product, or age of a customer.
   *
   * For example: `{ "vendor": {"text": ["vendor123", "vendor456"]},
   * "lengths_cm": {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]}
   * }`.
   *
   * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
   * error is returned:
   *
   * * Max entries count: 200.
   * * The key must be a UTF-8 encoded string with a length limit of 128
   *   characters.
   * * For indexable attribute, the key must match the pattern:
   *   `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example, `key0LikeThis` or
   *   `KEY_1_LIKE_THIS`.
   * * For text attributes, at most 400 values are allowed. Empty values are not
   *   allowed. Each value must be a non-empty UTF-8 encoded string with a
   *   length limit of 256 characters.
   * * For number attributes, at most 400 values are allowed.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 12;</code>
   */
  /* nullable */
  com.google.cloud.retail.v2.CustomAttribute getAttributesOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.retail.v2.CustomAttribute defaultValue);
  /**
   *
   *
   * <pre>
   * Highly encouraged. Extra product attributes to be included. For example,
   * for products, this could include the store name, vendor, style, color, etc.
   * These are very strong signals for recommendation model, thus we highly
   * recommend providing the attributes here.
   *
   * Features that can take on one of a limited number of possible values. Two
   * types of features can be set are:
   *
   * Textual features. some examples would be the brand/maker of a product, or
   * country of a customer. Numerical features. Some examples would be the
   * height/weight of a product, or age of a customer.
   *
   * For example: `{ "vendor": {"text": ["vendor123", "vendor456"]},
   * "lengths_cm": {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]}
   * }`.
   *
   * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
   * error is returned:
   *
   * * Max entries count: 200.
   * * The key must be a UTF-8 encoded string with a length limit of 128
   *   characters.
   * * For indexable attribute, the key must match the pattern:
   *   `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example, `key0LikeThis` or
   *   `KEY_1_LIKE_THIS`.
   * * For text attributes, at most 400 values are allowed. Empty values are not
   *   allowed. Each value must be a non-empty UTF-8 encoded string with a
   *   length limit of 256 characters.
   * * For number attributes, at most 400 values are allowed.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.retail.v2.CustomAttribute&gt; attributes = 12;</code>
   */
  com.google.cloud.retail.v2.CustomAttribute getAttributesOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Custom tags associated with the product.
   *
   * At most 250 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. This value must be a UTF-8
   * encoded string with a length limit of 1,000 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * This tag can be used for filtering recommendation results by passing the
   * tag as part of the
   * [PredictRequest.filter][google.cloud.retail.v2.PredictRequest.filter].
   *
   * Corresponding properties: Google Merchant Center property
   * [custom_label_0–4](https://support.google.com/merchants/answer/6324473).
   * </pre>
   *
   * <code>repeated string tags = 13;</code>
   *
   * @return A list containing the tags.
   */
  java.util.List<java.lang.String> getTagsList();
  /**
   *
   *
   * <pre>
   * Custom tags associated with the product.
   *
   * At most 250 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. This value must be a UTF-8
   * encoded string with a length limit of 1,000 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * This tag can be used for filtering recommendation results by passing the
   * tag as part of the
   * [PredictRequest.filter][google.cloud.retail.v2.PredictRequest.filter].
   *
   * Corresponding properties: Google Merchant Center property
   * [custom_label_0–4](https://support.google.com/merchants/answer/6324473).
   * </pre>
   *
   * <code>repeated string tags = 13;</code>
   *
   * @return The count of tags.
   */
  int getTagsCount();
  /**
   *
   *
   * <pre>
   * Custom tags associated with the product.
   *
   * At most 250 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. This value must be a UTF-8
   * encoded string with a length limit of 1,000 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * This tag can be used for filtering recommendation results by passing the
   * tag as part of the
   * [PredictRequest.filter][google.cloud.retail.v2.PredictRequest.filter].
   *
   * Corresponding properties: Google Merchant Center property
   * [custom_label_0–4](https://support.google.com/merchants/answer/6324473).
   * </pre>
   *
   * <code>repeated string tags = 13;</code>
   *
   * @param index The index of the element to return.
   * @return The tags at the given index.
   */
  java.lang.String getTags(int index);
  /**
   *
   *
   * <pre>
   * Custom tags associated with the product.
   *
   * At most 250 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. This value must be a UTF-8
   * encoded string with a length limit of 1,000 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * This tag can be used for filtering recommendation results by passing the
   * tag as part of the
   * [PredictRequest.filter][google.cloud.retail.v2.PredictRequest.filter].
   *
   * Corresponding properties: Google Merchant Center property
   * [custom_label_0–4](https://support.google.com/merchants/answer/6324473).
   * </pre>
   *
   * <code>repeated string tags = 13;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the tags at the given index.
   */
  com.google.protobuf.ByteString getTagsBytes(int index);

  /**
   *
   *
   * <pre>
   * Product price and cost information.
   *
   * Corresponding properties: Google Merchant Center property
   * [price](https://support.google.com/merchants/answer/6324371).
   * </pre>
   *
   * <code>.google.cloud.retail.v2.PriceInfo price_info = 14;</code>
   *
   * @return Whether the priceInfo field is set.
   */
  boolean hasPriceInfo();
  /**
   *
   *
   * <pre>
   * Product price and cost information.
   *
   * Corresponding properties: Google Merchant Center property
   * [price](https://support.google.com/merchants/answer/6324371).
   * </pre>
   *
   * <code>.google.cloud.retail.v2.PriceInfo price_info = 14;</code>
   *
   * @return The priceInfo.
   */
  com.google.cloud.retail.v2.PriceInfo getPriceInfo();
  /**
   *
   *
   * <pre>
   * Product price and cost information.
   *
   * Corresponding properties: Google Merchant Center property
   * [price](https://support.google.com/merchants/answer/6324371).
   * </pre>
   *
   * <code>.google.cloud.retail.v2.PriceInfo price_info = 14;</code>
   */
  com.google.cloud.retail.v2.PriceInfoOrBuilder getPriceInfoOrBuilder();

  /**
   *
   *
   * <pre>
   * The rating of this product.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.Rating rating = 15;</code>
   *
   * @return Whether the rating field is set.
   */
  boolean hasRating();
  /**
   *
   *
   * <pre>
   * The rating of this product.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.Rating rating = 15;</code>
   *
   * @return The rating.
   */
  com.google.cloud.retail.v2.Rating getRating();
  /**
   *
   *
   * <pre>
   * The rating of this product.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.Rating rating = 15;</code>
   */
  com.google.cloud.retail.v2.RatingOrBuilder getRatingOrBuilder();

  /**
   *
   *
   * <pre>
   * The timestamp when this [Product][google.cloud.retail.v2.Product] becomes
   * available for
   * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
   * that this is only applicable to
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
   * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp available_time = 18;</code>
   *
   * @return Whether the availableTime field is set.
   */
  boolean hasAvailableTime();
  /**
   *
   *
   * <pre>
   * The timestamp when this [Product][google.cloud.retail.v2.Product] becomes
   * available for
   * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
   * that this is only applicable to
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
   * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp available_time = 18;</code>
   *
   * @return The availableTime.
   */
  com.google.protobuf.Timestamp getAvailableTime();
  /**
   *
   *
   * <pre>
   * The timestamp when this [Product][google.cloud.retail.v2.Product] becomes
   * available for
   * [SearchService.Search][google.cloud.retail.v2.SearchService.Search]. Note
   * that this is only applicable to
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], and
   * ignored for [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp available_time = 18;</code>
   */
  com.google.protobuf.TimestampOrBuilder getAvailableTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * The online availability of the [Product][google.cloud.retail.v2.Product].
   * Default to
   * [Availability.IN_STOCK][google.cloud.retail.v2.Product.Availability.IN_STOCK].
   *
   * For primary products with variants set the availability of the primary as
   * [Availability.OUT_OF_STOCK][google.cloud.retail.v2.Product.Availability.OUT_OF_STOCK]
   * and set the true availability at the variant level. This way the primary
   * product will be considered "in stock" as long as it has at least one
   * variant in stock.
   *
   * For primary products with no variants set the true availability at the
   * primary level.
   *
   * Corresponding properties: Google Merchant Center property
   * [availability](https://support.google.com/merchants/answer/6324448).
   * Schema.org property [Offer.availability](https://schema.org/availability).
   * </pre>
   *
   * <code>.google.cloud.retail.v2.Product.Availability availability = 19;</code>
   *
   * @return The enum numeric value on the wire for availability.
   */
  int getAvailabilityValue();
  /**
   *
   *
   * <pre>
   * The online availability of the [Product][google.cloud.retail.v2.Product].
   * Default to
   * [Availability.IN_STOCK][google.cloud.retail.v2.Product.Availability.IN_STOCK].
   *
   * For primary products with variants set the availability of the primary as
   * [Availability.OUT_OF_STOCK][google.cloud.retail.v2.Product.Availability.OUT_OF_STOCK]
   * and set the true availability at the variant level. This way the primary
   * product will be considered "in stock" as long as it has at least one
   * variant in stock.
   *
   * For primary products with no variants set the true availability at the
   * primary level.
   *
   * Corresponding properties: Google Merchant Center property
   * [availability](https://support.google.com/merchants/answer/6324448).
   * Schema.org property [Offer.availability](https://schema.org/availability).
   * </pre>
   *
   * <code>.google.cloud.retail.v2.Product.Availability availability = 19;</code>
   *
   * @return The availability.
   */
  com.google.cloud.retail.v2.Product.Availability getAvailability();

  /**
   *
   *
   * <pre>
   * The available quantity of the item.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value available_quantity = 20;</code>
   *
   * @return Whether the availableQuantity field is set.
   */
  boolean hasAvailableQuantity();
  /**
   *
   *
   * <pre>
   * The available quantity of the item.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value available_quantity = 20;</code>
   *
   * @return The availableQuantity.
   */
  com.google.protobuf.Int32Value getAvailableQuantity();
  /**
   *
   *
   * <pre>
   * The available quantity of the item.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value available_quantity = 20;</code>
   */
  com.google.protobuf.Int32ValueOrBuilder getAvailableQuantityOrBuilder();

  /**
   *
   *
   * <pre>
   * Fulfillment information, such as the store IDs for in-store pickup or
   * region IDs for different shipping methods.
   *
   * All the elements must have distinct
   * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
   * Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
   */
  java.util.List<com.google.cloud.retail.v2.FulfillmentInfo> getFulfillmentInfoList();
  /**
   *
   *
   * <pre>
   * Fulfillment information, such as the store IDs for in-store pickup or
   * region IDs for different shipping methods.
   *
   * All the elements must have distinct
   * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
   * Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
   */
  com.google.cloud.retail.v2.FulfillmentInfo getFulfillmentInfo(int index);
  /**
   *
   *
   * <pre>
   * Fulfillment information, such as the store IDs for in-store pickup or
   * region IDs for different shipping methods.
   *
   * All the elements must have distinct
   * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
   * Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
   */
  int getFulfillmentInfoCount();
  /**
   *
   *
   * <pre>
   * Fulfillment information, such as the store IDs for in-store pickup or
   * region IDs for different shipping methods.
   *
   * All the elements must have distinct
   * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
   * Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
   */
  java.util.List<? extends com.google.cloud.retail.v2.FulfillmentInfoOrBuilder>
      getFulfillmentInfoOrBuilderList();
  /**
   *
   *
   * <pre>
   * Fulfillment information, such as the store IDs for in-store pickup or
   * region IDs for different shipping methods.
   *
   * All the elements must have distinct
   * [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type].
   * Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.FulfillmentInfo fulfillment_info = 21;</code>
   */
  com.google.cloud.retail.v2.FulfillmentInfoOrBuilder getFulfillmentInfoOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Canonical URL directly linking to the product detail page.
   *
   * It is strongly recommended to provide a valid uri for the product,
   * otherwise the service performance could be significantly degraded.
   *
   * This field must be a UTF-8 encoded string with a length limit of 5,000
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [link](https://support.google.com/merchants/answer/6324416). Schema.org
   * property [Offer.url](https://schema.org/url).
   * </pre>
   *
   * <code>string uri = 22;</code>
   *
   * @return The uri.
   */
  java.lang.String getUri();
  /**
   *
   *
   * <pre>
   * Canonical URL directly linking to the product detail page.
   *
   * It is strongly recommended to provide a valid uri for the product,
   * otherwise the service performance could be significantly degraded.
   *
   * This field must be a UTF-8 encoded string with a length limit of 5,000
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [link](https://support.google.com/merchants/answer/6324416). Schema.org
   * property [Offer.url](https://schema.org/url).
   * </pre>
   *
   * <code>string uri = 22;</code>
   *
   * @return The bytes for uri.
   */
  com.google.protobuf.ByteString getUriBytes();

  /**
   *
   *
   * <pre>
   * Product images for the product. We highly recommend putting the main
   * image first.
   *
   * A maximum of 300 images are allowed.
   *
   * Corresponding properties: Google Merchant Center property
   * [image_link](https://support.google.com/merchants/answer/6324350).
   * Schema.org property [Product.image](https://schema.org/image).
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
   */
  java.util.List<com.google.cloud.retail.v2.Image> getImagesList();
  /**
   *
   *
   * <pre>
   * Product images for the product. We highly recommend putting the main
   * image first.
   *
   * A maximum of 300 images are allowed.
   *
   * Corresponding properties: Google Merchant Center property
   * [image_link](https://support.google.com/merchants/answer/6324350).
   * Schema.org property [Product.image](https://schema.org/image).
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
   */
  com.google.cloud.retail.v2.Image getImages(int index);
  /**
   *
   *
   * <pre>
   * Product images for the product. We highly recommend putting the main
   * image first.
   *
   * A maximum of 300 images are allowed.
   *
   * Corresponding properties: Google Merchant Center property
   * [image_link](https://support.google.com/merchants/answer/6324350).
   * Schema.org property [Product.image](https://schema.org/image).
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
   */
  int getImagesCount();
  /**
   *
   *
   * <pre>
   * Product images for the product. We highly recommend putting the main
   * image first.
   *
   * A maximum of 300 images are allowed.
   *
   * Corresponding properties: Google Merchant Center property
   * [image_link](https://support.google.com/merchants/answer/6324350).
   * Schema.org property [Product.image](https://schema.org/image).
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
   */
  java.util.List<? extends com.google.cloud.retail.v2.ImageOrBuilder> getImagesOrBuilderList();
  /**
   *
   *
   * <pre>
   * Product images for the product. We highly recommend putting the main
   * image first.
   *
   * A maximum of 300 images are allowed.
   *
   * Corresponding properties: Google Merchant Center property
   * [image_link](https://support.google.com/merchants/answer/6324350).
   * Schema.org property [Product.image](https://schema.org/image).
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
   */
  com.google.cloud.retail.v2.ImageOrBuilder getImagesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * The target group associated with a given audience (e.g. male, veterans,
   * car owners, musicians, etc.) of the product.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.Audience audience = 24;</code>
   *
   * @return Whether the audience field is set.
   */
  boolean hasAudience();
  /**
   *
   *
   * <pre>
   * The target group associated with a given audience (e.g. male, veterans,
   * car owners, musicians, etc.) of the product.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.Audience audience = 24;</code>
   *
   * @return The audience.
   */
  com.google.cloud.retail.v2.Audience getAudience();
  /**
   *
   *
   * <pre>
   * The target group associated with a given audience (e.g. male, veterans,
   * car owners, musicians, etc.) of the product.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.Audience audience = 24;</code>
   */
  com.google.cloud.retail.v2.AudienceOrBuilder getAudienceOrBuilder();

  /**
   *
   *
   * <pre>
   * The color of the product.
   *
   * Corresponding properties: Google Merchant Center property
   * [color](https://support.google.com/merchants/answer/6324487). Schema.org
   * property [Product.color](https://schema.org/color).
   * </pre>
   *
   * <code>.google.cloud.retail.v2.ColorInfo color_info = 25;</code>
   *
   * @return Whether the colorInfo field is set.
   */
  boolean hasColorInfo();
  /**
   *
   *
   * <pre>
   * The color of the product.
   *
   * Corresponding properties: Google Merchant Center property
   * [color](https://support.google.com/merchants/answer/6324487). Schema.org
   * property [Product.color](https://schema.org/color).
   * </pre>
   *
   * <code>.google.cloud.retail.v2.ColorInfo color_info = 25;</code>
   *
   * @return The colorInfo.
   */
  com.google.cloud.retail.v2.ColorInfo getColorInfo();
  /**
   *
   *
   * <pre>
   * The color of the product.
   *
   * Corresponding properties: Google Merchant Center property
   * [color](https://support.google.com/merchants/answer/6324487). Schema.org
   * property [Product.color](https://schema.org/color).
   * </pre>
   *
   * <code>.google.cloud.retail.v2.ColorInfo color_info = 25;</code>
   */
  com.google.cloud.retail.v2.ColorInfoOrBuilder getColorInfoOrBuilder();

  /**
   *
   *
   * <pre>
   * The size of the product. To represent different size systems or size types,
   * consider using this format: [[[size_system:]size_type:]size_value].
   *
   * For example, in "US:MENS:M", "US" represents size system; "MENS" represents
   * size type; "M" represents size value. In "GIRLS:27", size system is empty;
   * "GIRLS" represents size type; "27" represents size value. In "32 inches",
   * both size system and size type are empty, while size value is "32 inches".
   *
   * A maximum of 20 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
   * encoded string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [size](https://support.google.com/merchants/answer/6324492),
   * [size_type](https://support.google.com/merchants/answer/6324497), and
   * [size_system](https://support.google.com/merchants/answer/6324502).
   * Schema.org property [Product.size](https://schema.org/size).
   * </pre>
   *
   * <code>repeated string sizes = 26;</code>
   *
   * @return A list containing the sizes.
   */
  java.util.List<java.lang.String> getSizesList();
  /**
   *
   *
   * <pre>
   * The size of the product. To represent different size systems or size types,
   * consider using this format: [[[size_system:]size_type:]size_value].
   *
   * For example, in "US:MENS:M", "US" represents size system; "MENS" represents
   * size type; "M" represents size value. In "GIRLS:27", size system is empty;
   * "GIRLS" represents size type; "27" represents size value. In "32 inches",
   * both size system and size type are empty, while size value is "32 inches".
   *
   * A maximum of 20 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
   * encoded string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [size](https://support.google.com/merchants/answer/6324492),
   * [size_type](https://support.google.com/merchants/answer/6324497), and
   * [size_system](https://support.google.com/merchants/answer/6324502).
   * Schema.org property [Product.size](https://schema.org/size).
   * </pre>
   *
   * <code>repeated string sizes = 26;</code>
   *
   * @return The count of sizes.
   */
  int getSizesCount();
  /**
   *
   *
   * <pre>
   * The size of the product. To represent different size systems or size types,
   * consider using this format: [[[size_system:]size_type:]size_value].
   *
   * For example, in "US:MENS:M", "US" represents size system; "MENS" represents
   * size type; "M" represents size value. In "GIRLS:27", size system is empty;
   * "GIRLS" represents size type; "27" represents size value. In "32 inches",
   * both size system and size type are empty, while size value is "32 inches".
   *
   * A maximum of 20 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
   * encoded string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [size](https://support.google.com/merchants/answer/6324492),
   * [size_type](https://support.google.com/merchants/answer/6324497), and
   * [size_system](https://support.google.com/merchants/answer/6324502).
   * Schema.org property [Product.size](https://schema.org/size).
   * </pre>
   *
   * <code>repeated string sizes = 26;</code>
   *
   * @param index The index of the element to return.
   * @return The sizes at the given index.
   */
  java.lang.String getSizes(int index);
  /**
   *
   *
   * <pre>
   * The size of the product. To represent different size systems or size types,
   * consider using this format: [[[size_system:]size_type:]size_value].
   *
   * For example, in "US:MENS:M", "US" represents size system; "MENS" represents
   * size type; "M" represents size value. In "GIRLS:27", size system is empty;
   * "GIRLS" represents size type; "27" represents size value. In "32 inches",
   * both size system and size type are empty, while size value is "32 inches".
   *
   * A maximum of 20 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
   * encoded string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [size](https://support.google.com/merchants/answer/6324492),
   * [size_type](https://support.google.com/merchants/answer/6324497), and
   * [size_system](https://support.google.com/merchants/answer/6324502).
   * Schema.org property [Product.size](https://schema.org/size).
   * </pre>
   *
   * <code>repeated string sizes = 26;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the sizes at the given index.
   */
  com.google.protobuf.ByteString getSizesBytes(int index);

  /**
   *
   *
   * <pre>
   * The material of the product. For example, "leather", "wooden".
   *
   * A maximum of 20 values are allowed. Each value must be a UTF-8 encoded
   * string with a length limit of 200 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [material](https://support.google.com/merchants/answer/6324410). Schema.org
   * property [Product.material](https://schema.org/material).
   * </pre>
   *
   * <code>repeated string materials = 27;</code>
   *
   * @return A list containing the materials.
   */
  java.util.List<java.lang.String> getMaterialsList();
  /**
   *
   *
   * <pre>
   * The material of the product. For example, "leather", "wooden".
   *
   * A maximum of 20 values are allowed. Each value must be a UTF-8 encoded
   * string with a length limit of 200 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [material](https://support.google.com/merchants/answer/6324410). Schema.org
   * property [Product.material](https://schema.org/material).
   * </pre>
   *
   * <code>repeated string materials = 27;</code>
   *
   * @return The count of materials.
   */
  int getMaterialsCount();
  /**
   *
   *
   * <pre>
   * The material of the product. For example, "leather", "wooden".
   *
   * A maximum of 20 values are allowed. Each value must be a UTF-8 encoded
   * string with a length limit of 200 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [material](https://support.google.com/merchants/answer/6324410). Schema.org
   * property [Product.material](https://schema.org/material).
   * </pre>
   *
   * <code>repeated string materials = 27;</code>
   *
   * @param index The index of the element to return.
   * @return The materials at the given index.
   */
  java.lang.String getMaterials(int index);
  /**
   *
   *
   * <pre>
   * The material of the product. For example, "leather", "wooden".
   *
   * A maximum of 20 values are allowed. Each value must be a UTF-8 encoded
   * string with a length limit of 200 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [material](https://support.google.com/merchants/answer/6324410). Schema.org
   * property [Product.material](https://schema.org/material).
   * </pre>
   *
   * <code>repeated string materials = 27;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the materials at the given index.
   */
  com.google.protobuf.ByteString getMaterialsBytes(int index);

  /**
   *
   *
   * <pre>
   * The pattern or graphic print of the product. For example, "striped", "polka
   * dot", "paisley".
   *
   * A maximum of 20 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
   * encoded string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [pattern](https://support.google.com/merchants/answer/6324483). Schema.org
   * property [Product.pattern](https://schema.org/pattern).
   * </pre>
   *
   * <code>repeated string patterns = 28;</code>
   *
   * @return A list containing the patterns.
   */
  java.util.List<java.lang.String> getPatternsList();
  /**
   *
   *
   * <pre>
   * The pattern or graphic print of the product. For example, "striped", "polka
   * dot", "paisley".
   *
   * A maximum of 20 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
   * encoded string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [pattern](https://support.google.com/merchants/answer/6324483). Schema.org
   * property [Product.pattern](https://schema.org/pattern).
   * </pre>
   *
   * <code>repeated string patterns = 28;</code>
   *
   * @return The count of patterns.
   */
  int getPatternsCount();
  /**
   *
   *
   * <pre>
   * The pattern or graphic print of the product. For example, "striped", "polka
   * dot", "paisley".
   *
   * A maximum of 20 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
   * encoded string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [pattern](https://support.google.com/merchants/answer/6324483). Schema.org
   * property [Product.pattern](https://schema.org/pattern).
   * </pre>
   *
   * <code>repeated string patterns = 28;</code>
   *
   * @param index The index of the element to return.
   * @return The patterns at the given index.
   */
  java.lang.String getPatterns(int index);
  /**
   *
   *
   * <pre>
   * The pattern or graphic print of the product. For example, "striped", "polka
   * dot", "paisley".
   *
   * A maximum of 20 values are allowed per
   * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
   * encoded string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [pattern](https://support.google.com/merchants/answer/6324483). Schema.org
   * property [Product.pattern](https://schema.org/pattern).
   * </pre>
   *
   * <code>repeated string patterns = 28;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the patterns at the given index.
   */
  com.google.protobuf.ByteString getPatternsBytes(int index);

  /**
   *
   *
   * <pre>
   * The condition of the product. Strongly encouraged to use the standard
   * values: "new", "refurbished", "used".
   *
   * A maximum of 1 value is allowed per
   * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
   * encoded string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [condition](https://support.google.com/merchants/answer/6324469).
   * Schema.org property
   * [Offer.itemCondition](https://schema.org/itemCondition).
   * </pre>
   *
   * <code>repeated string conditions = 29;</code>
   *
   * @return A list containing the conditions.
   */
  java.util.List<java.lang.String> getConditionsList();
  /**
   *
   *
   * <pre>
   * The condition of the product. Strongly encouraged to use the standard
   * values: "new", "refurbished", "used".
   *
   * A maximum of 1 value is allowed per
   * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
   * encoded string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [condition](https://support.google.com/merchants/answer/6324469).
   * Schema.org property
   * [Offer.itemCondition](https://schema.org/itemCondition).
   * </pre>
   *
   * <code>repeated string conditions = 29;</code>
   *
   * @return The count of conditions.
   */
  int getConditionsCount();
  /**
   *
   *
   * <pre>
   * The condition of the product. Strongly encouraged to use the standard
   * values: "new", "refurbished", "used".
   *
   * A maximum of 1 value is allowed per
   * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
   * encoded string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [condition](https://support.google.com/merchants/answer/6324469).
   * Schema.org property
   * [Offer.itemCondition](https://schema.org/itemCondition).
   * </pre>
   *
   * <code>repeated string conditions = 29;</code>
   *
   * @param index The index of the element to return.
   * @return The conditions at the given index.
   */
  java.lang.String getConditions(int index);
  /**
   *
   *
   * <pre>
   * The condition of the product. Strongly encouraged to use the standard
   * values: "new", "refurbished", "used".
   *
   * A maximum of 1 value is allowed per
   * [Product][google.cloud.retail.v2.Product]. Each value must be a UTF-8
   * encoded string with a length limit of 128 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   *
   * Corresponding properties: Google Merchant Center property
   * [condition](https://support.google.com/merchants/answer/6324469).
   * Schema.org property
   * [Offer.itemCondition](https://schema.org/itemCondition).
   * </pre>
   *
   * <code>repeated string conditions = 29;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the conditions at the given index.
   */
  com.google.protobuf.ByteString getConditionsBytes(int index);

  /**
   *
   *
   * <pre>
   * The promotions applied to the product. A maximum of 10 values are allowed
   * per [Product][google.cloud.retail.v2.Product]. Only
   * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
   * will be used, other fields will be ignored if set.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
   */
  java.util.List<com.google.cloud.retail.v2.Promotion> getPromotionsList();
  /**
   *
   *
   * <pre>
   * The promotions applied to the product. A maximum of 10 values are allowed
   * per [Product][google.cloud.retail.v2.Product]. Only
   * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
   * will be used, other fields will be ignored if set.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
   */
  com.google.cloud.retail.v2.Promotion getPromotions(int index);
  /**
   *
   *
   * <pre>
   * The promotions applied to the product. A maximum of 10 values are allowed
   * per [Product][google.cloud.retail.v2.Product]. Only
   * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
   * will be used, other fields will be ignored if set.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
   */
  int getPromotionsCount();
  /**
   *
   *
   * <pre>
   * The promotions applied to the product. A maximum of 10 values are allowed
   * per [Product][google.cloud.retail.v2.Product]. Only
   * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
   * will be used, other fields will be ignored if set.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
   */
  java.util.List<? extends com.google.cloud.retail.v2.PromotionOrBuilder>
      getPromotionsOrBuilderList();
  /**
   *
   *
   * <pre>
   * The promotions applied to the product. A maximum of 10 values are allowed
   * per [Product][google.cloud.retail.v2.Product]. Only
   * [Promotion.promotion_id][google.cloud.retail.v2.Promotion.promotion_id]
   * will be used, other fields will be ignored if set.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.Promotion promotions = 34;</code>
   */
  com.google.cloud.retail.v2.PromotionOrBuilder getPromotionsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * The timestamp when the product is published by the retailer for the first
   * time, which indicates the freshness of the products. Note that this field
   * is different from
   * [available_time][google.cloud.retail.v2.Product.available_time], given it
   * purely describes product freshness regardless of when it is available on
   * search and recommendation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp publish_time = 33;</code>
   *
   * @return Whether the publishTime field is set.
   */
  boolean hasPublishTime();
  /**
   *
   *
   * <pre>
   * The timestamp when the product is published by the retailer for the first
   * time, which indicates the freshness of the products. Note that this field
   * is different from
   * [available_time][google.cloud.retail.v2.Product.available_time], given it
   * purely describes product freshness regardless of when it is available on
   * search and recommendation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp publish_time = 33;</code>
   *
   * @return The publishTime.
   */
  com.google.protobuf.Timestamp getPublishTime();
  /**
   *
   *
   * <pre>
   * The timestamp when the product is published by the retailer for the first
   * time, which indicates the freshness of the products. Note that this field
   * is different from
   * [available_time][google.cloud.retail.v2.Product.available_time], given it
   * purely describes product freshness regardless of when it is available on
   * search and recommendation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp publish_time = 33;</code>
   */
  com.google.protobuf.TimestampOrBuilder getPublishTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Indicates which fields in the [Product][google.cloud.retail.v2.Product]s
   * are returned in [SearchResponse][google.cloud.retail.v2.SearchResponse].
   *
   * Supported fields for all [type][google.cloud.retail.v2.Product.type]s:
   *
   * * [audience][google.cloud.retail.v2.Product.audience]
   * * [availability][google.cloud.retail.v2.Product.availability]
   * * [brands][google.cloud.retail.v2.Product.brands]
   * * [color_info][google.cloud.retail.v2.Product.color_info]
   * * [conditions][google.cloud.retail.v2.Product.conditions]
   * * [gtin][google.cloud.retail.v2.Product.gtin]
   * * [materials][google.cloud.retail.v2.Product.materials]
   * * [name][google.cloud.retail.v2.Product.name]
   * * [patterns][google.cloud.retail.v2.Product.patterns]
   * * [price_info][google.cloud.retail.v2.Product.price_info]
   * * [rating][google.cloud.retail.v2.Product.rating]
   * * [sizes][google.cloud.retail.v2.Product.sizes]
   * * [title][google.cloud.retail.v2.Product.title]
   * * [uri][google.cloud.retail.v2.Product.uri]
   *
   * Supported fields only for
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION]:
   *
   * * [categories][google.cloud.retail.v2.Product.categories]
   * * [description][google.cloud.retail.v2.Product.description]
   * * [images][google.cloud.retail.v2.Product.images]
   *
   * Supported fields only for
   * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]:
   *
   * * Only the first image in [images][google.cloud.retail.v2.Product.images]
   *
   * To mark [attributes][google.cloud.retail.v2.Product.attributes] as
   * retrievable, include paths of the form "attributes.key" where "key" is the
   * key of a custom attribute, as specified in
   * [attributes][google.cloud.retail.v2.Product.attributes].
   *
   * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], the
   * following fields are always returned in
   * [SearchResponse][google.cloud.retail.v2.SearchResponse] by default:
   *
   * * [name][google.cloud.retail.v2.Product.name]
   *
   * For [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT], the
   * following fields are always returned in by default:
   *
   * * [name][google.cloud.retail.v2.Product.name]
   * * [color_info][google.cloud.retail.v2.Product.color_info]
   *
   *
   * Note: Returning more fields in
   * [SearchResponse][google.cloud.retail.v2.SearchResponse] can increase
   * response payload size and serving latency.
   *
   * This field is deprecated. Use the retrievable site-wide control instead.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask retrievable_fields = 30 [deprecated = true];</code>
   *
   * @deprecated google.cloud.retail.v2.Product.retrievable_fields is deprecated. See
   *     google/cloud/retail/v2/product.proto;l=570
   * @return Whether the retrievableFields field is set.
   */
  @java.lang.Deprecated
  boolean hasRetrievableFields();
  /**
   *
   *
   * <pre>
   * Indicates which fields in the [Product][google.cloud.retail.v2.Product]s
   * are returned in [SearchResponse][google.cloud.retail.v2.SearchResponse].
   *
   * Supported fields for all [type][google.cloud.retail.v2.Product.type]s:
   *
   * * [audience][google.cloud.retail.v2.Product.audience]
   * * [availability][google.cloud.retail.v2.Product.availability]
   * * [brands][google.cloud.retail.v2.Product.brands]
   * * [color_info][google.cloud.retail.v2.Product.color_info]
   * * [conditions][google.cloud.retail.v2.Product.conditions]
   * * [gtin][google.cloud.retail.v2.Product.gtin]
   * * [materials][google.cloud.retail.v2.Product.materials]
   * * [name][google.cloud.retail.v2.Product.name]
   * * [patterns][google.cloud.retail.v2.Product.patterns]
   * * [price_info][google.cloud.retail.v2.Product.price_info]
   * * [rating][google.cloud.retail.v2.Product.rating]
   * * [sizes][google.cloud.retail.v2.Product.sizes]
   * * [title][google.cloud.retail.v2.Product.title]
   * * [uri][google.cloud.retail.v2.Product.uri]
   *
   * Supported fields only for
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION]:
   *
   * * [categories][google.cloud.retail.v2.Product.categories]
   * * [description][google.cloud.retail.v2.Product.description]
   * * [images][google.cloud.retail.v2.Product.images]
   *
   * Supported fields only for
   * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]:
   *
   * * Only the first image in [images][google.cloud.retail.v2.Product.images]
   *
   * To mark [attributes][google.cloud.retail.v2.Product.attributes] as
   * retrievable, include paths of the form "attributes.key" where "key" is the
   * key of a custom attribute, as specified in
   * [attributes][google.cloud.retail.v2.Product.attributes].
   *
   * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], the
   * following fields are always returned in
   * [SearchResponse][google.cloud.retail.v2.SearchResponse] by default:
   *
   * * [name][google.cloud.retail.v2.Product.name]
   *
   * For [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT], the
   * following fields are always returned in by default:
   *
   * * [name][google.cloud.retail.v2.Product.name]
   * * [color_info][google.cloud.retail.v2.Product.color_info]
   *
   *
   * Note: Returning more fields in
   * [SearchResponse][google.cloud.retail.v2.SearchResponse] can increase
   * response payload size and serving latency.
   *
   * This field is deprecated. Use the retrievable site-wide control instead.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask retrievable_fields = 30 [deprecated = true];</code>
   *
   * @deprecated google.cloud.retail.v2.Product.retrievable_fields is deprecated. See
   *     google/cloud/retail/v2/product.proto;l=570
   * @return The retrievableFields.
   */
  @java.lang.Deprecated
  com.google.protobuf.FieldMask getRetrievableFields();
  /**
   *
   *
   * <pre>
   * Indicates which fields in the [Product][google.cloud.retail.v2.Product]s
   * are returned in [SearchResponse][google.cloud.retail.v2.SearchResponse].
   *
   * Supported fields for all [type][google.cloud.retail.v2.Product.type]s:
   *
   * * [audience][google.cloud.retail.v2.Product.audience]
   * * [availability][google.cloud.retail.v2.Product.availability]
   * * [brands][google.cloud.retail.v2.Product.brands]
   * * [color_info][google.cloud.retail.v2.Product.color_info]
   * * [conditions][google.cloud.retail.v2.Product.conditions]
   * * [gtin][google.cloud.retail.v2.Product.gtin]
   * * [materials][google.cloud.retail.v2.Product.materials]
   * * [name][google.cloud.retail.v2.Product.name]
   * * [patterns][google.cloud.retail.v2.Product.patterns]
   * * [price_info][google.cloud.retail.v2.Product.price_info]
   * * [rating][google.cloud.retail.v2.Product.rating]
   * * [sizes][google.cloud.retail.v2.Product.sizes]
   * * [title][google.cloud.retail.v2.Product.title]
   * * [uri][google.cloud.retail.v2.Product.uri]
   *
   * Supported fields only for
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION]:
   *
   * * [categories][google.cloud.retail.v2.Product.categories]
   * * [description][google.cloud.retail.v2.Product.description]
   * * [images][google.cloud.retail.v2.Product.images]
   *
   * Supported fields only for
   * [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]:
   *
   * * Only the first image in [images][google.cloud.retail.v2.Product.images]
   *
   * To mark [attributes][google.cloud.retail.v2.Product.attributes] as
   * retrievable, include paths of the form "attributes.key" where "key" is the
   * key of a custom attribute, as specified in
   * [attributes][google.cloud.retail.v2.Product.attributes].
   *
   * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] and
   * [Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION], the
   * following fields are always returned in
   * [SearchResponse][google.cloud.retail.v2.SearchResponse] by default:
   *
   * * [name][google.cloud.retail.v2.Product.name]
   *
   * For [Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT], the
   * following fields are always returned in by default:
   *
   * * [name][google.cloud.retail.v2.Product.name]
   * * [color_info][google.cloud.retail.v2.Product.color_info]
   *
   *
   * Note: Returning more fields in
   * [SearchResponse][google.cloud.retail.v2.SearchResponse] can increase
   * response payload size and serving latency.
   *
   * This field is deprecated. Use the retrievable site-wide control instead.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask retrievable_fields = 30 [deprecated = true];</code>
   */
  @java.lang.Deprecated
  com.google.protobuf.FieldMaskOrBuilder getRetrievableFieldsOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Product variants grouped together on primary product which
   * share similar product attributes. It's automatically grouped by
   * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
   * all the product variants. Only populated for
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2.Product]s.
   *
   * Note: This field is OUTPUT_ONLY for
   * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
   * Do not set this field in API requests.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<com.google.cloud.retail.v2.Product> getVariantsList();
  /**
   *
   *
   * <pre>
   * Output only. Product variants grouped together on primary product which
   * share similar product attributes. It's automatically grouped by
   * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
   * all the product variants. Only populated for
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2.Product]s.
   *
   * Note: This field is OUTPUT_ONLY for
   * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
   * Do not set this field in API requests.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.retail.v2.Product getVariants(int index);
  /**
   *
   *
   * <pre>
   * Output only. Product variants grouped together on primary product which
   * share similar product attributes. It's automatically grouped by
   * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
   * all the product variants. Only populated for
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2.Product]s.
   *
   * Note: This field is OUTPUT_ONLY for
   * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
   * Do not set this field in API requests.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getVariantsCount();
  /**
   *
   *
   * <pre>
   * Output only. Product variants grouped together on primary product which
   * share similar product attributes. It's automatically grouped by
   * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
   * all the product variants. Only populated for
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2.Product]s.
   *
   * Note: This field is OUTPUT_ONLY for
   * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
   * Do not set this field in API requests.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<? extends com.google.cloud.retail.v2.ProductOrBuilder> getVariantsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Output only. Product variants grouped together on primary product which
   * share similar product attributes. It's automatically grouped by
   * [primary_product_id][google.cloud.retail.v2.Product.primary_product_id] for
   * all the product variants. Only populated for
   * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2.Product]s.
   *
   * Note: This field is OUTPUT_ONLY for
   * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct].
   * Do not set this field in API requests.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.Product variants = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.retail.v2.ProductOrBuilder getVariantsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Output only. A list of local inventories specific to different places.
   *
   * This field can be managed by
   * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
   * and
   * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
   * APIs if fine-grained, high-volume updates are necessary.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<com.google.cloud.retail.v2.LocalInventory> getLocalInventoriesList();
  /**
   *
   *
   * <pre>
   * Output only. A list of local inventories specific to different places.
   *
   * This field can be managed by
   * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
   * and
   * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
   * APIs if fine-grained, high-volume updates are necessary.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.retail.v2.LocalInventory getLocalInventories(int index);
  /**
   *
   *
   * <pre>
   * Output only. A list of local inventories specific to different places.
   *
   * This field can be managed by
   * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
   * and
   * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
   * APIs if fine-grained, high-volume updates are necessary.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getLocalInventoriesCount();
  /**
   *
   *
   * <pre>
   * Output only. A list of local inventories specific to different places.
   *
   * This field can be managed by
   * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
   * and
   * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
   * APIs if fine-grained, high-volume updates are necessary.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<? extends com.google.cloud.retail.v2.LocalInventoryOrBuilder>
      getLocalInventoriesOrBuilderList();
  /**
   *
   *
   * <pre>
   * Output only. A list of local inventories specific to different places.
   *
   * This field can be managed by
   * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
   * and
   * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
   * APIs if fine-grained, high-volume updates are necessary.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.LocalInventory local_inventories = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.retail.v2.LocalInventoryOrBuilder getLocalInventoriesOrBuilder(int index);

  com.google.cloud.retail.v2.Product.ExpirationCase getExpirationCase();
}
