/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2/search_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2;

/**
 *
 *
 * <pre>
 * Response message for
 * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2.SearchResponse}
 */
public final class SearchResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.SearchResponse)
    SearchResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SearchResponse.newBuilder() to construct.
  private SearchResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SearchResponse() {
    results_ = java.util.Collections.emptyList();
    facets_ = java.util.Collections.emptyList();
    correctedQuery_ = "";
    attributionToken_ = "";
    nextPageToken_ = "";
    redirectUri_ = "";
    appliedControls_ = com.google.protobuf.LazyStringArrayList.emptyList();
    invalidConditionBoostSpecs_ = java.util.Collections.emptyList();
    experimentInfo_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SearchResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2.SearchServiceProto
        .internal_static_google_cloud_retail_v2_SearchResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2.SearchServiceProto
        .internal_static_google_cloud_retail_v2_SearchResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2.SearchResponse.class,
            com.google.cloud.retail.v2.SearchResponse.Builder.class);
  }

  public interface SearchResultOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2.SearchResponse.SearchResult)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * [Product.id][google.cloud.retail.v2.Product.id] of the searched
     * [Product][google.cloud.retail.v2.Product].
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    java.lang.String getId();
    /**
     *
     *
     * <pre>
     * [Product.id][google.cloud.retail.v2.Product.id] of the searched
     * [Product][google.cloud.retail.v2.Product].
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    com.google.protobuf.ByteString getIdBytes();

    /**
     *
     *
     * <pre>
     * The product data snippet in the search response. Only
     * [Product.name][google.cloud.retail.v2.Product.name] is guaranteed to be
     * populated.
     *
     * [Product.variants][google.cloud.retail.v2.Product.variants] contains the
     * product variants that match the search query. If there are multiple
     * product variants matching the query, top 5 most relevant product variants
     * are returned and ordered by relevancy.
     *
     * If relevancy can be deternmined, use
     * [matching_variant_fields][google.cloud.retail.v2.SearchResponse.SearchResult.matching_variant_fields]
     * to look up matched product variants fields. If relevancy cannot be
     * determined, e.g. when searching "shoe" all products in a shoe product can
     * be a match, 5 product variants are returned but order is meaningless.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Product product = 2;</code>
     *
     * @return Whether the product field is set.
     */
    boolean hasProduct();
    /**
     *
     *
     * <pre>
     * The product data snippet in the search response. Only
     * [Product.name][google.cloud.retail.v2.Product.name] is guaranteed to be
     * populated.
     *
     * [Product.variants][google.cloud.retail.v2.Product.variants] contains the
     * product variants that match the search query. If there are multiple
     * product variants matching the query, top 5 most relevant product variants
     * are returned and ordered by relevancy.
     *
     * If relevancy can be deternmined, use
     * [matching_variant_fields][google.cloud.retail.v2.SearchResponse.SearchResult.matching_variant_fields]
     * to look up matched product variants fields. If relevancy cannot be
     * determined, e.g. when searching "shoe" all products in a shoe product can
     * be a match, 5 product variants are returned but order is meaningless.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Product product = 2;</code>
     *
     * @return The product.
     */
    com.google.cloud.retail.v2.Product getProduct();
    /**
     *
     *
     * <pre>
     * The product data snippet in the search response. Only
     * [Product.name][google.cloud.retail.v2.Product.name] is guaranteed to be
     * populated.
     *
     * [Product.variants][google.cloud.retail.v2.Product.variants] contains the
     * product variants that match the search query. If there are multiple
     * product variants matching the query, top 5 most relevant product variants
     * are returned and ordered by relevancy.
     *
     * If relevancy can be deternmined, use
     * [matching_variant_fields][google.cloud.retail.v2.SearchResponse.SearchResult.matching_variant_fields]
     * to look up matched product variants fields. If relevancy cannot be
     * determined, e.g. when searching "shoe" all products in a shoe product can
     * be a match, 5 product variants are returned but order is meaningless.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Product product = 2;</code>
     */
    com.google.cloud.retail.v2.ProductOrBuilder getProductOrBuilder();

    /**
     *
     *
     * <pre>
     * The count of matched
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product]s.
     * </pre>
     *
     * <code>int32 matching_variant_count = 3;</code>
     *
     * @return The matchingVariantCount.
     */
    int getMatchingVariantCount();

    /**
     *
     *
     * <pre>
     * If a [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product] matches the search query, this
     * map indicates which [Product][google.cloud.retail.v2.Product] fields are
     * matched. The key is the
     * [Product.name][google.cloud.retail.v2.Product.name], the value is a field
     * mask of the matched [Product][google.cloud.retail.v2.Product] fields. If
     * matched attributes cannot be determined, this map will be empty.
     *
     * For example, a key "sku1" with field mask
     * "products.color_info" indicates there is a match between
     * "sku1" [ColorInfo][google.cloud.retail.v2.ColorInfo] and the query.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.FieldMask&gt; matching_variant_fields = 4;</code>
     */
    int getMatchingVariantFieldsCount();
    /**
     *
     *
     * <pre>
     * If a [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product] matches the search query, this
     * map indicates which [Product][google.cloud.retail.v2.Product] fields are
     * matched. The key is the
     * [Product.name][google.cloud.retail.v2.Product.name], the value is a field
     * mask of the matched [Product][google.cloud.retail.v2.Product] fields. If
     * matched attributes cannot be determined, this map will be empty.
     *
     * For example, a key "sku1" with field mask
     * "products.color_info" indicates there is a match between
     * "sku1" [ColorInfo][google.cloud.retail.v2.ColorInfo] and the query.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.FieldMask&gt; matching_variant_fields = 4;</code>
     */
    boolean containsMatchingVariantFields(java.lang.String key);
    /** Use {@link #getMatchingVariantFieldsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, com.google.protobuf.FieldMask> getMatchingVariantFields();
    /**
     *
     *
     * <pre>
     * If a [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product] matches the search query, this
     * map indicates which [Product][google.cloud.retail.v2.Product] fields are
     * matched. The key is the
     * [Product.name][google.cloud.retail.v2.Product.name], the value is a field
     * mask of the matched [Product][google.cloud.retail.v2.Product] fields. If
     * matched attributes cannot be determined, this map will be empty.
     *
     * For example, a key "sku1" with field mask
     * "products.color_info" indicates there is a match between
     * "sku1" [ColorInfo][google.cloud.retail.v2.ColorInfo] and the query.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.FieldMask&gt; matching_variant_fields = 4;</code>
     */
    java.util.Map<java.lang.String, com.google.protobuf.FieldMask> getMatchingVariantFieldsMap();
    /**
     *
     *
     * <pre>
     * If a [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product] matches the search query, this
     * map indicates which [Product][google.cloud.retail.v2.Product] fields are
     * matched. The key is the
     * [Product.name][google.cloud.retail.v2.Product.name], the value is a field
     * mask of the matched [Product][google.cloud.retail.v2.Product] fields. If
     * matched attributes cannot be determined, this map will be empty.
     *
     * For example, a key "sku1" with field mask
     * "products.color_info" indicates there is a match between
     * "sku1" [ColorInfo][google.cloud.retail.v2.ColorInfo] and the query.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.FieldMask&gt; matching_variant_fields = 4;</code>
     */
    /* nullable */
    com.google.protobuf.FieldMask getMatchingVariantFieldsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.protobuf.FieldMask defaultValue);
    /**
     *
     *
     * <pre>
     * If a [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product] matches the search query, this
     * map indicates which [Product][google.cloud.retail.v2.Product] fields are
     * matched. The key is the
     * [Product.name][google.cloud.retail.v2.Product.name], the value is a field
     * mask of the matched [Product][google.cloud.retail.v2.Product] fields. If
     * matched attributes cannot be determined, this map will be empty.
     *
     * For example, a key "sku1" with field mask
     * "products.color_info" indicates there is a match between
     * "sku1" [ColorInfo][google.cloud.retail.v2.ColorInfo] and the query.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.FieldMask&gt; matching_variant_fields = 4;</code>
     */
    com.google.protobuf.FieldMask getMatchingVariantFieldsOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * The rollup matching
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product] attributes. The key is one of
     * the
     * [SearchRequest.variant_rollup_keys][google.cloud.retail.v2.SearchRequest.variant_rollup_keys].
     * The values are the merged and de-duplicated
     * [Product][google.cloud.retail.v2.Product] attributes. Notice that the
     * rollup values are respect filter. For example, when filtering by
     * "colorFamilies:ANY(&#92;"red&#92;")" and rollup "colorFamilies", only "red" is
     * returned.
     *
     * For textual and numerical attributes, the rollup values is a list of
     * string or double values with type
     * [google.protobuf.ListValue][google.protobuf.ListValue]. For example, if
     * there are two variants with colors "red" and "blue", the rollup values
     * are
     *
     *     { key: "colorFamilies"
     *       value {
     *         list_value {
     *           values { string_value: "red" }
     *           values { string_value: "blue" }
     *          }
     *       }
     *     }
     *
     * For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], the rollup
     * values is a double value with type
     * [google.protobuf.Value][google.protobuf.Value]. For example,
     * `{key: "pickupInStore.store1" value { number_value: 10 }}` means a there
     * are 10 variants in this product are available in the store "store1".
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; variant_rollup_values = 5;</code>
     */
    int getVariantRollupValuesCount();
    /**
     *
     *
     * <pre>
     * The rollup matching
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product] attributes. The key is one of
     * the
     * [SearchRequest.variant_rollup_keys][google.cloud.retail.v2.SearchRequest.variant_rollup_keys].
     * The values are the merged and de-duplicated
     * [Product][google.cloud.retail.v2.Product] attributes. Notice that the
     * rollup values are respect filter. For example, when filtering by
     * "colorFamilies:ANY(&#92;"red&#92;")" and rollup "colorFamilies", only "red" is
     * returned.
     *
     * For textual and numerical attributes, the rollup values is a list of
     * string or double values with type
     * [google.protobuf.ListValue][google.protobuf.ListValue]. For example, if
     * there are two variants with colors "red" and "blue", the rollup values
     * are
     *
     *     { key: "colorFamilies"
     *       value {
     *         list_value {
     *           values { string_value: "red" }
     *           values { string_value: "blue" }
     *          }
     *       }
     *     }
     *
     * For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], the rollup
     * values is a double value with type
     * [google.protobuf.Value][google.protobuf.Value]. For example,
     * `{key: "pickupInStore.store1" value { number_value: 10 }}` means a there
     * are 10 variants in this product are available in the store "store1".
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; variant_rollup_values = 5;</code>
     */
    boolean containsVariantRollupValues(java.lang.String key);
    /** Use {@link #getVariantRollupValuesMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, com.google.protobuf.Value> getVariantRollupValues();
    /**
     *
     *
     * <pre>
     * The rollup matching
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product] attributes. The key is one of
     * the
     * [SearchRequest.variant_rollup_keys][google.cloud.retail.v2.SearchRequest.variant_rollup_keys].
     * The values are the merged and de-duplicated
     * [Product][google.cloud.retail.v2.Product] attributes. Notice that the
     * rollup values are respect filter. For example, when filtering by
     * "colorFamilies:ANY(&#92;"red&#92;")" and rollup "colorFamilies", only "red" is
     * returned.
     *
     * For textual and numerical attributes, the rollup values is a list of
     * string or double values with type
     * [google.protobuf.ListValue][google.protobuf.ListValue]. For example, if
     * there are two variants with colors "red" and "blue", the rollup values
     * are
     *
     *     { key: "colorFamilies"
     *       value {
     *         list_value {
     *           values { string_value: "red" }
     *           values { string_value: "blue" }
     *          }
     *       }
     *     }
     *
     * For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], the rollup
     * values is a double value with type
     * [google.protobuf.Value][google.protobuf.Value]. For example,
     * `{key: "pickupInStore.store1" value { number_value: 10 }}` means a there
     * are 10 variants in this product are available in the store "store1".
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; variant_rollup_values = 5;</code>
     */
    java.util.Map<java.lang.String, com.google.protobuf.Value> getVariantRollupValuesMap();
    /**
     *
     *
     * <pre>
     * The rollup matching
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product] attributes. The key is one of
     * the
     * [SearchRequest.variant_rollup_keys][google.cloud.retail.v2.SearchRequest.variant_rollup_keys].
     * The values are the merged and de-duplicated
     * [Product][google.cloud.retail.v2.Product] attributes. Notice that the
     * rollup values are respect filter. For example, when filtering by
     * "colorFamilies:ANY(&#92;"red&#92;")" and rollup "colorFamilies", only "red" is
     * returned.
     *
     * For textual and numerical attributes, the rollup values is a list of
     * string or double values with type
     * [google.protobuf.ListValue][google.protobuf.ListValue]. For example, if
     * there are two variants with colors "red" and "blue", the rollup values
     * are
     *
     *     { key: "colorFamilies"
     *       value {
     *         list_value {
     *           values { string_value: "red" }
     *           values { string_value: "blue" }
     *          }
     *       }
     *     }
     *
     * For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], the rollup
     * values is a double value with type
     * [google.protobuf.Value][google.protobuf.Value]. For example,
     * `{key: "pickupInStore.store1" value { number_value: 10 }}` means a there
     * are 10 variants in this product are available in the store "store1".
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; variant_rollup_values = 5;</code>
     */
    /* nullable */
    com.google.protobuf.Value getVariantRollupValuesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.protobuf.Value defaultValue);
    /**
     *
     *
     * <pre>
     * The rollup matching
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product] attributes. The key is one of
     * the
     * [SearchRequest.variant_rollup_keys][google.cloud.retail.v2.SearchRequest.variant_rollup_keys].
     * The values are the merged and de-duplicated
     * [Product][google.cloud.retail.v2.Product] attributes. Notice that the
     * rollup values are respect filter. For example, when filtering by
     * "colorFamilies:ANY(&#92;"red&#92;")" and rollup "colorFamilies", only "red" is
     * returned.
     *
     * For textual and numerical attributes, the rollup values is a list of
     * string or double values with type
     * [google.protobuf.ListValue][google.protobuf.ListValue]. For example, if
     * there are two variants with colors "red" and "blue", the rollup values
     * are
     *
     *     { key: "colorFamilies"
     *       value {
     *         list_value {
     *           values { string_value: "red" }
     *           values { string_value: "blue" }
     *          }
     *       }
     *     }
     *
     * For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], the rollup
     * values is a double value with type
     * [google.protobuf.Value][google.protobuf.Value]. For example,
     * `{key: "pickupInStore.store1" value { number_value: 10 }}` means a there
     * are 10 variants in this product are available in the store "store1".
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; variant_rollup_values = 5;</code>
     */
    com.google.protobuf.Value getVariantRollupValuesOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * Specifies previous events related to this product for this user based on
     * [UserEvent][google.cloud.retail.v2.UserEvent] with same
     * [SearchRequest.visitor_id][google.cloud.retail.v2.SearchRequest.visitor_id]
     * or [UserInfo.user_id][google.cloud.retail.v2.UserInfo.user_id].
     *
     * This is set only when
     * [SearchRequest.PersonalizationSpec.mode][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.mode]
     * is
     * [SearchRequest.PersonalizationSpec.Mode.AUTO][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.Mode.AUTO].
     *
     * Possible values:
     *
     * * `purchased`: Indicates that this product has been purchased before.
     * </pre>
     *
     * <code>repeated string personal_labels = 7;</code>
     *
     * @return A list containing the personalLabels.
     */
    java.util.List<java.lang.String> getPersonalLabelsList();
    /**
     *
     *
     * <pre>
     * Specifies previous events related to this product for this user based on
     * [UserEvent][google.cloud.retail.v2.UserEvent] with same
     * [SearchRequest.visitor_id][google.cloud.retail.v2.SearchRequest.visitor_id]
     * or [UserInfo.user_id][google.cloud.retail.v2.UserInfo.user_id].
     *
     * This is set only when
     * [SearchRequest.PersonalizationSpec.mode][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.mode]
     * is
     * [SearchRequest.PersonalizationSpec.Mode.AUTO][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.Mode.AUTO].
     *
     * Possible values:
     *
     * * `purchased`: Indicates that this product has been purchased before.
     * </pre>
     *
     * <code>repeated string personal_labels = 7;</code>
     *
     * @return The count of personalLabels.
     */
    int getPersonalLabelsCount();
    /**
     *
     *
     * <pre>
     * Specifies previous events related to this product for this user based on
     * [UserEvent][google.cloud.retail.v2.UserEvent] with same
     * [SearchRequest.visitor_id][google.cloud.retail.v2.SearchRequest.visitor_id]
     * or [UserInfo.user_id][google.cloud.retail.v2.UserInfo.user_id].
     *
     * This is set only when
     * [SearchRequest.PersonalizationSpec.mode][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.mode]
     * is
     * [SearchRequest.PersonalizationSpec.Mode.AUTO][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.Mode.AUTO].
     *
     * Possible values:
     *
     * * `purchased`: Indicates that this product has been purchased before.
     * </pre>
     *
     * <code>repeated string personal_labels = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The personalLabels at the given index.
     */
    java.lang.String getPersonalLabels(int index);
    /**
     *
     *
     * <pre>
     * Specifies previous events related to this product for this user based on
     * [UserEvent][google.cloud.retail.v2.UserEvent] with same
     * [SearchRequest.visitor_id][google.cloud.retail.v2.SearchRequest.visitor_id]
     * or [UserInfo.user_id][google.cloud.retail.v2.UserInfo.user_id].
     *
     * This is set only when
     * [SearchRequest.PersonalizationSpec.mode][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.mode]
     * is
     * [SearchRequest.PersonalizationSpec.Mode.AUTO][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.Mode.AUTO].
     *
     * Possible values:
     *
     * * `purchased`: Indicates that this product has been purchased before.
     * </pre>
     *
     * <code>repeated string personal_labels = 7;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the personalLabels at the given index.
     */
    com.google.protobuf.ByteString getPersonalLabelsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Represents the search results.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2.SearchResponse.SearchResult}
   */
  public static final class SearchResult extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.SearchResponse.SearchResult)
      SearchResultOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SearchResult.newBuilder() to construct.
    private SearchResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SearchResult() {
      id_ = "";
      personalLabels_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SearchResult();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2.SearchServiceProto
          .internal_static_google_cloud_retail_v2_SearchResponse_SearchResult_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMatchingVariantFields();
        case 5:
          return internalGetVariantRollupValues();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2.SearchServiceProto
          .internal_static_google_cloud_retail_v2_SearchResponse_SearchResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2.SearchResponse.SearchResult.class,
              com.google.cloud.retail.v2.SearchResponse.SearchResult.Builder.class);
    }

    private int bitField0_;
    public static final int ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * [Product.id][google.cloud.retail.v2.Product.id] of the searched
     * [Product][google.cloud.retail.v2.Product].
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * [Product.id][google.cloud.retail.v2.Product.id] of the searched
     * [Product][google.cloud.retail.v2.Product].
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PRODUCT_FIELD_NUMBER = 2;
    private com.google.cloud.retail.v2.Product product_;
    /**
     *
     *
     * <pre>
     * The product data snippet in the search response. Only
     * [Product.name][google.cloud.retail.v2.Product.name] is guaranteed to be
     * populated.
     *
     * [Product.variants][google.cloud.retail.v2.Product.variants] contains the
     * product variants that match the search query. If there are multiple
     * product variants matching the query, top 5 most relevant product variants
     * are returned and ordered by relevancy.
     *
     * If relevancy can be deternmined, use
     * [matching_variant_fields][google.cloud.retail.v2.SearchResponse.SearchResult.matching_variant_fields]
     * to look up matched product variants fields. If relevancy cannot be
     * determined, e.g. when searching "shoe" all products in a shoe product can
     * be a match, 5 product variants are returned but order is meaningless.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Product product = 2;</code>
     *
     * @return Whether the product field is set.
     */
    @java.lang.Override
    public boolean hasProduct() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The product data snippet in the search response. Only
     * [Product.name][google.cloud.retail.v2.Product.name] is guaranteed to be
     * populated.
     *
     * [Product.variants][google.cloud.retail.v2.Product.variants] contains the
     * product variants that match the search query. If there are multiple
     * product variants matching the query, top 5 most relevant product variants
     * are returned and ordered by relevancy.
     *
     * If relevancy can be deternmined, use
     * [matching_variant_fields][google.cloud.retail.v2.SearchResponse.SearchResult.matching_variant_fields]
     * to look up matched product variants fields. If relevancy cannot be
     * determined, e.g. when searching "shoe" all products in a shoe product can
     * be a match, 5 product variants are returned but order is meaningless.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Product product = 2;</code>
     *
     * @return The product.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.Product getProduct() {
      return product_ == null ? com.google.cloud.retail.v2.Product.getDefaultInstance() : product_;
    }
    /**
     *
     *
     * <pre>
     * The product data snippet in the search response. Only
     * [Product.name][google.cloud.retail.v2.Product.name] is guaranteed to be
     * populated.
     *
     * [Product.variants][google.cloud.retail.v2.Product.variants] contains the
     * product variants that match the search query. If there are multiple
     * product variants matching the query, top 5 most relevant product variants
     * are returned and ordered by relevancy.
     *
     * If relevancy can be deternmined, use
     * [matching_variant_fields][google.cloud.retail.v2.SearchResponse.SearchResult.matching_variant_fields]
     * to look up matched product variants fields. If relevancy cannot be
     * determined, e.g. when searching "shoe" all products in a shoe product can
     * be a match, 5 product variants are returned but order is meaningless.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.Product product = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.ProductOrBuilder getProductOrBuilder() {
      return product_ == null ? com.google.cloud.retail.v2.Product.getDefaultInstance() : product_;
    }

    public static final int MATCHING_VARIANT_COUNT_FIELD_NUMBER = 3;
    private int matchingVariantCount_ = 0;
    /**
     *
     *
     * <pre>
     * The count of matched
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product]s.
     * </pre>
     *
     * <code>int32 matching_variant_count = 3;</code>
     *
     * @return The matchingVariantCount.
     */
    @java.lang.Override
    public int getMatchingVariantCount() {
      return matchingVariantCount_;
    }

    public static final int MATCHING_VARIANT_FIELDS_FIELD_NUMBER = 4;

    private static final class MatchingVariantFieldsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.FieldMask>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String, com.google.protobuf.FieldMask>newDefaultInstance(
                      com.google.cloud.retail.v2.SearchServiceProto
                          .internal_static_google_cloud_retail_v2_SearchResponse_SearchResult_MatchingVariantFieldsEntry_descriptor,
                      com.google.protobuf.WireFormat.FieldType.STRING,
                      "",
                      com.google.protobuf.WireFormat.FieldType.MESSAGE,
                      com.google.protobuf.FieldMask.getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.FieldMask>
        matchingVariantFields_;

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.FieldMask>
        internalGetMatchingVariantFields() {
      if (matchingVariantFields_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            MatchingVariantFieldsDefaultEntryHolder.defaultEntry);
      }
      return matchingVariantFields_;
    }

    public int getMatchingVariantFieldsCount() {
      return internalGetMatchingVariantFields().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * If a [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product] matches the search query, this
     * map indicates which [Product][google.cloud.retail.v2.Product] fields are
     * matched. The key is the
     * [Product.name][google.cloud.retail.v2.Product.name], the value is a field
     * mask of the matched [Product][google.cloud.retail.v2.Product] fields. If
     * matched attributes cannot be determined, this map will be empty.
     *
     * For example, a key "sku1" with field mask
     * "products.color_info" indicates there is a match between
     * "sku1" [ColorInfo][google.cloud.retail.v2.ColorInfo] and the query.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.FieldMask&gt; matching_variant_fields = 4;</code>
     */
    @java.lang.Override
    public boolean containsMatchingVariantFields(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetMatchingVariantFields().getMap().containsKey(key);
    }
    /** Use {@link #getMatchingVariantFieldsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.FieldMask>
        getMatchingVariantFields() {
      return getMatchingVariantFieldsMap();
    }
    /**
     *
     *
     * <pre>
     * If a [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product] matches the search query, this
     * map indicates which [Product][google.cloud.retail.v2.Product] fields are
     * matched. The key is the
     * [Product.name][google.cloud.retail.v2.Product.name], the value is a field
     * mask of the matched [Product][google.cloud.retail.v2.Product] fields. If
     * matched attributes cannot be determined, this map will be empty.
     *
     * For example, a key "sku1" with field mask
     * "products.color_info" indicates there is a match between
     * "sku1" [ColorInfo][google.cloud.retail.v2.ColorInfo] and the query.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.FieldMask&gt; matching_variant_fields = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.protobuf.FieldMask>
        getMatchingVariantFieldsMap() {
      return internalGetMatchingVariantFields().getMap();
    }
    /**
     *
     *
     * <pre>
     * If a [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product] matches the search query, this
     * map indicates which [Product][google.cloud.retail.v2.Product] fields are
     * matched. The key is the
     * [Product.name][google.cloud.retail.v2.Product.name], the value is a field
     * mask of the matched [Product][google.cloud.retail.v2.Product] fields. If
     * matched attributes cannot be determined, this map will be empty.
     *
     * For example, a key "sku1" with field mask
     * "products.color_info" indicates there is a match between
     * "sku1" [ColorInfo][google.cloud.retail.v2.ColorInfo] and the query.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.FieldMask&gt; matching_variant_fields = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.protobuf.FieldMask getMatchingVariantFieldsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.protobuf.FieldMask defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.FieldMask> map =
          internalGetMatchingVariantFields().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * If a [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product] matches the search query, this
     * map indicates which [Product][google.cloud.retail.v2.Product] fields are
     * matched. The key is the
     * [Product.name][google.cloud.retail.v2.Product.name], the value is a field
     * mask of the matched [Product][google.cloud.retail.v2.Product] fields. If
     * matched attributes cannot be determined, this map will be empty.
     *
     * For example, a key "sku1" with field mask
     * "products.color_info" indicates there is a match between
     * "sku1" [ColorInfo][google.cloud.retail.v2.ColorInfo] and the query.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.FieldMask&gt; matching_variant_fields = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.FieldMask getMatchingVariantFieldsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.FieldMask> map =
          internalGetMatchingVariantFields().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int VARIANT_ROLLUP_VALUES_FIELD_NUMBER = 5;

    private static final class VariantRollupValuesDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String, com.google.protobuf.Value>newDefaultInstance(
                      com.google.cloud.retail.v2.SearchServiceProto
                          .internal_static_google_cloud_retail_v2_SearchResponse_SearchResult_VariantRollupValuesEntry_descriptor,
                      com.google.protobuf.WireFormat.FieldType.STRING,
                      "",
                      com.google.protobuf.WireFormat.FieldType.MESSAGE,
                      com.google.protobuf.Value.getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
        variantRollupValues_;

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
        internalGetVariantRollupValues() {
      if (variantRollupValues_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            VariantRollupValuesDefaultEntryHolder.defaultEntry);
      }
      return variantRollupValues_;
    }

    public int getVariantRollupValuesCount() {
      return internalGetVariantRollupValues().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The rollup matching
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product] attributes. The key is one of
     * the
     * [SearchRequest.variant_rollup_keys][google.cloud.retail.v2.SearchRequest.variant_rollup_keys].
     * The values are the merged and de-duplicated
     * [Product][google.cloud.retail.v2.Product] attributes. Notice that the
     * rollup values are respect filter. For example, when filtering by
     * "colorFamilies:ANY(&#92;"red&#92;")" and rollup "colorFamilies", only "red" is
     * returned.
     *
     * For textual and numerical attributes, the rollup values is a list of
     * string or double values with type
     * [google.protobuf.ListValue][google.protobuf.ListValue]. For example, if
     * there are two variants with colors "red" and "blue", the rollup values
     * are
     *
     *     { key: "colorFamilies"
     *       value {
     *         list_value {
     *           values { string_value: "red" }
     *           values { string_value: "blue" }
     *          }
     *       }
     *     }
     *
     * For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], the rollup
     * values is a double value with type
     * [google.protobuf.Value][google.protobuf.Value]. For example,
     * `{key: "pickupInStore.store1" value { number_value: 10 }}` means a there
     * are 10 variants in this product are available in the store "store1".
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; variant_rollup_values = 5;</code>
     */
    @java.lang.Override
    public boolean containsVariantRollupValues(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetVariantRollupValues().getMap().containsKey(key);
    }
    /** Use {@link #getVariantRollupValuesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getVariantRollupValues() {
      return getVariantRollupValuesMap();
    }
    /**
     *
     *
     * <pre>
     * The rollup matching
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product] attributes. The key is one of
     * the
     * [SearchRequest.variant_rollup_keys][google.cloud.retail.v2.SearchRequest.variant_rollup_keys].
     * The values are the merged and de-duplicated
     * [Product][google.cloud.retail.v2.Product] attributes. Notice that the
     * rollup values are respect filter. For example, when filtering by
     * "colorFamilies:ANY(&#92;"red&#92;")" and rollup "colorFamilies", only "red" is
     * returned.
     *
     * For textual and numerical attributes, the rollup values is a list of
     * string or double values with type
     * [google.protobuf.ListValue][google.protobuf.ListValue]. For example, if
     * there are two variants with colors "red" and "blue", the rollup values
     * are
     *
     *     { key: "colorFamilies"
     *       value {
     *         list_value {
     *           values { string_value: "red" }
     *           values { string_value: "blue" }
     *          }
     *       }
     *     }
     *
     * For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], the rollup
     * values is a double value with type
     * [google.protobuf.Value][google.protobuf.Value]. For example,
     * `{key: "pickupInStore.store1" value { number_value: 10 }}` means a there
     * are 10 variants in this product are available in the store "store1".
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; variant_rollup_values = 5;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getVariantRollupValuesMap() {
      return internalGetVariantRollupValues().getMap();
    }
    /**
     *
     *
     * <pre>
     * The rollup matching
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product] attributes. The key is one of
     * the
     * [SearchRequest.variant_rollup_keys][google.cloud.retail.v2.SearchRequest.variant_rollup_keys].
     * The values are the merged and de-duplicated
     * [Product][google.cloud.retail.v2.Product] attributes. Notice that the
     * rollup values are respect filter. For example, when filtering by
     * "colorFamilies:ANY(&#92;"red&#92;")" and rollup "colorFamilies", only "red" is
     * returned.
     *
     * For textual and numerical attributes, the rollup values is a list of
     * string or double values with type
     * [google.protobuf.ListValue][google.protobuf.ListValue]. For example, if
     * there are two variants with colors "red" and "blue", the rollup values
     * are
     *
     *     { key: "colorFamilies"
     *       value {
     *         list_value {
     *           values { string_value: "red" }
     *           values { string_value: "blue" }
     *          }
     *       }
     *     }
     *
     * For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], the rollup
     * values is a double value with type
     * [google.protobuf.Value][google.protobuf.Value]. For example,
     * `{key: "pickupInStore.store1" value { number_value: 10 }}` means a there
     * are 10 variants in this product are available in the store "store1".
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; variant_rollup_values = 5;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.protobuf.Value getVariantRollupValuesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.protobuf.Value defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.Value> map =
          internalGetVariantRollupValues().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The rollup matching
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product] attributes. The key is one of
     * the
     * [SearchRequest.variant_rollup_keys][google.cloud.retail.v2.SearchRequest.variant_rollup_keys].
     * The values are the merged and de-duplicated
     * [Product][google.cloud.retail.v2.Product] attributes. Notice that the
     * rollup values are respect filter. For example, when filtering by
     * "colorFamilies:ANY(&#92;"red&#92;")" and rollup "colorFamilies", only "red" is
     * returned.
     *
     * For textual and numerical attributes, the rollup values is a list of
     * string or double values with type
     * [google.protobuf.ListValue][google.protobuf.ListValue]. For example, if
     * there are two variants with colors "red" and "blue", the rollup values
     * are
     *
     *     { key: "colorFamilies"
     *       value {
     *         list_value {
     *           values { string_value: "red" }
     *           values { string_value: "blue" }
     *          }
     *       }
     *     }
     *
     * For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], the rollup
     * values is a double value with type
     * [google.protobuf.Value][google.protobuf.Value]. For example,
     * `{key: "pickupInStore.store1" value { number_value: 10 }}` means a there
     * are 10 variants in this product are available in the store "store1".
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; variant_rollup_values = 5;</code>
     */
    @java.lang.Override
    public com.google.protobuf.Value getVariantRollupValuesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.Value> map =
          internalGetVariantRollupValues().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int PERSONAL_LABELS_FIELD_NUMBER = 7;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList personalLabels_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Specifies previous events related to this product for this user based on
     * [UserEvent][google.cloud.retail.v2.UserEvent] with same
     * [SearchRequest.visitor_id][google.cloud.retail.v2.SearchRequest.visitor_id]
     * or [UserInfo.user_id][google.cloud.retail.v2.UserInfo.user_id].
     *
     * This is set only when
     * [SearchRequest.PersonalizationSpec.mode][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.mode]
     * is
     * [SearchRequest.PersonalizationSpec.Mode.AUTO][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.Mode.AUTO].
     *
     * Possible values:
     *
     * * `purchased`: Indicates that this product has been purchased before.
     * </pre>
     *
     * <code>repeated string personal_labels = 7;</code>
     *
     * @return A list containing the personalLabels.
     */
    public com.google.protobuf.ProtocolStringList getPersonalLabelsList() {
      return personalLabels_;
    }
    /**
     *
     *
     * <pre>
     * Specifies previous events related to this product for this user based on
     * [UserEvent][google.cloud.retail.v2.UserEvent] with same
     * [SearchRequest.visitor_id][google.cloud.retail.v2.SearchRequest.visitor_id]
     * or [UserInfo.user_id][google.cloud.retail.v2.UserInfo.user_id].
     *
     * This is set only when
     * [SearchRequest.PersonalizationSpec.mode][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.mode]
     * is
     * [SearchRequest.PersonalizationSpec.Mode.AUTO][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.Mode.AUTO].
     *
     * Possible values:
     *
     * * `purchased`: Indicates that this product has been purchased before.
     * </pre>
     *
     * <code>repeated string personal_labels = 7;</code>
     *
     * @return The count of personalLabels.
     */
    public int getPersonalLabelsCount() {
      return personalLabels_.size();
    }
    /**
     *
     *
     * <pre>
     * Specifies previous events related to this product for this user based on
     * [UserEvent][google.cloud.retail.v2.UserEvent] with same
     * [SearchRequest.visitor_id][google.cloud.retail.v2.SearchRequest.visitor_id]
     * or [UserInfo.user_id][google.cloud.retail.v2.UserInfo.user_id].
     *
     * This is set only when
     * [SearchRequest.PersonalizationSpec.mode][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.mode]
     * is
     * [SearchRequest.PersonalizationSpec.Mode.AUTO][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.Mode.AUTO].
     *
     * Possible values:
     *
     * * `purchased`: Indicates that this product has been purchased before.
     * </pre>
     *
     * <code>repeated string personal_labels = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The personalLabels at the given index.
     */
    public java.lang.String getPersonalLabels(int index) {
      return personalLabels_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Specifies previous events related to this product for this user based on
     * [UserEvent][google.cloud.retail.v2.UserEvent] with same
     * [SearchRequest.visitor_id][google.cloud.retail.v2.SearchRequest.visitor_id]
     * or [UserInfo.user_id][google.cloud.retail.v2.UserInfo.user_id].
     *
     * This is set only when
     * [SearchRequest.PersonalizationSpec.mode][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.mode]
     * is
     * [SearchRequest.PersonalizationSpec.Mode.AUTO][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.Mode.AUTO].
     *
     * Possible values:
     *
     * * `purchased`: Indicates that this product has been purchased before.
     * </pre>
     *
     * <code>repeated string personal_labels = 7;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the personalLabels at the given index.
     */
    public com.google.protobuf.ByteString getPersonalLabelsBytes(int index) {
      return personalLabels_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getProduct());
      }
      if (matchingVariantCount_ != 0) {
        output.writeInt32(3, matchingVariantCount_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output,
          internalGetMatchingVariantFields(),
          MatchingVariantFieldsDefaultEntryHolder.defaultEntry,
          4);
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output,
          internalGetVariantRollupValues(),
          VariantRollupValuesDefaultEntryHolder.defaultEntry,
          5);
      for (int i = 0; i < personalLabels_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, personalLabels_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getProduct());
      }
      if (matchingVariantCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, matchingVariantCount_);
      }
      for (java.util.Map.Entry<java.lang.String, com.google.protobuf.FieldMask> entry :
          internalGetMatchingVariantFields().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.FieldMask>
            matchingVariantFields__ =
                MatchingVariantFieldsDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(4, matchingVariantFields__);
      }
      for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Value> entry :
          internalGetVariantRollupValues().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
            variantRollupValues__ =
                VariantRollupValuesDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, variantRollupValues__);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < personalLabels_.size(); i++) {
          dataSize += computeStringSizeNoTag(personalLabels_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getPersonalLabelsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2.SearchResponse.SearchResult)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2.SearchResponse.SearchResult other =
          (com.google.cloud.retail.v2.SearchResponse.SearchResult) obj;

      if (!getId().equals(other.getId())) return false;
      if (hasProduct() != other.hasProduct()) return false;
      if (hasProduct()) {
        if (!getProduct().equals(other.getProduct())) return false;
      }
      if (getMatchingVariantCount() != other.getMatchingVariantCount()) return false;
      if (!internalGetMatchingVariantFields().equals(other.internalGetMatchingVariantFields()))
        return false;
      if (!internalGetVariantRollupValues().equals(other.internalGetVariantRollupValues()))
        return false;
      if (!getPersonalLabelsList().equals(other.getPersonalLabelsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      if (hasProduct()) {
        hash = (37 * hash) + PRODUCT_FIELD_NUMBER;
        hash = (53 * hash) + getProduct().hashCode();
      }
      hash = (37 * hash) + MATCHING_VARIANT_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getMatchingVariantCount();
      if (!internalGetMatchingVariantFields().getMap().isEmpty()) {
        hash = (37 * hash) + MATCHING_VARIANT_FIELDS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetMatchingVariantFields().hashCode();
      }
      if (!internalGetVariantRollupValues().getMap().isEmpty()) {
        hash = (37 * hash) + VARIANT_ROLLUP_VALUES_FIELD_NUMBER;
        hash = (53 * hash) + internalGetVariantRollupValues().hashCode();
      }
      if (getPersonalLabelsCount() > 0) {
        hash = (37 * hash) + PERSONAL_LABELS_FIELD_NUMBER;
        hash = (53 * hash) + getPersonalLabelsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2.SearchResponse.SearchResult parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.SearchResponse.SearchResult parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.SearchResponse.SearchResult parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.SearchResponse.SearchResult parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.SearchResponse.SearchResult parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.SearchResponse.SearchResult parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.SearchResponse.SearchResult parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.SearchResponse.SearchResult parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.SearchResponse.SearchResult parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.SearchResponse.SearchResult parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.SearchResponse.SearchResult parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.SearchResponse.SearchResult parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2.SearchResponse.SearchResult prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents the search results.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2.SearchResponse.SearchResult}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.SearchResponse.SearchResult)
        com.google.cloud.retail.v2.SearchResponse.SearchResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2.SearchServiceProto
            .internal_static_google_cloud_retail_v2_SearchResponse_SearchResult_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 4:
            return internalGetMatchingVariantFields();
          case 5:
            return internalGetVariantRollupValues();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
          int number) {
        switch (number) {
          case 4:
            return internalGetMutableMatchingVariantFields();
          case 5:
            return internalGetMutableVariantRollupValues();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2.SearchServiceProto
            .internal_static_google_cloud_retail_v2_SearchResponse_SearchResult_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2.SearchResponse.SearchResult.class,
                com.google.cloud.retail.v2.SearchResponse.SearchResult.Builder.class);
      }

      // Construct using com.google.cloud.retail.v2.SearchResponse.SearchResult.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getProductFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        id_ = "";
        product_ = null;
        if (productBuilder_ != null) {
          productBuilder_.dispose();
          productBuilder_ = null;
        }
        matchingVariantCount_ = 0;
        internalGetMutableMatchingVariantFields().clear();
        internalGetMutableVariantRollupValues().clear();
        personalLabels_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2.SearchServiceProto
            .internal_static_google_cloud_retail_v2_SearchResponse_SearchResult_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.SearchResponse.SearchResult getDefaultInstanceForType() {
        return com.google.cloud.retail.v2.SearchResponse.SearchResult.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.SearchResponse.SearchResult build() {
        com.google.cloud.retail.v2.SearchResponse.SearchResult result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.SearchResponse.SearchResult buildPartial() {
        com.google.cloud.retail.v2.SearchResponse.SearchResult result =
            new com.google.cloud.retail.v2.SearchResponse.SearchResult(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.retail.v2.SearchResponse.SearchResult result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.id_ = id_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.product_ = productBuilder_ == null ? product_ : productBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.matchingVariantCount_ = matchingVariantCount_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.matchingVariantFields_ =
              internalGetMatchingVariantFields()
                  .build(MatchingVariantFieldsDefaultEntryHolder.defaultEntry);
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.variantRollupValues_ =
              internalGetVariantRollupValues()
                  .build(VariantRollupValuesDefaultEntryHolder.defaultEntry);
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          personalLabels_.makeImmutable();
          result.personalLabels_ = personalLabels_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2.SearchResponse.SearchResult) {
          return mergeFrom((com.google.cloud.retail.v2.SearchResponse.SearchResult) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.retail.v2.SearchResponse.SearchResult other) {
        if (other == com.google.cloud.retail.v2.SearchResponse.SearchResult.getDefaultInstance())
          return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasProduct()) {
          mergeProduct(other.getProduct());
        }
        if (other.getMatchingVariantCount() != 0) {
          setMatchingVariantCount(other.getMatchingVariantCount());
        }
        internalGetMutableMatchingVariantFields()
            .mergeFrom(other.internalGetMatchingVariantFields());
        bitField0_ |= 0x00000008;
        internalGetMutableVariantRollupValues().mergeFrom(other.internalGetVariantRollupValues());
        bitField0_ |= 0x00000010;
        if (!other.personalLabels_.isEmpty()) {
          if (personalLabels_.isEmpty()) {
            personalLabels_ = other.personalLabels_;
            bitField0_ |= 0x00000020;
          } else {
            ensurePersonalLabelsIsMutable();
            personalLabels_.addAll(other.personalLabels_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  id_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getProductFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  matchingVariantCount_ = input.readInt32();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 34:
                {
                  com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.FieldMask>
                      matchingVariantFields__ =
                          input.readMessage(
                              MatchingVariantFieldsDefaultEntryHolder.defaultEntry
                                  .getParserForType(),
                              extensionRegistry);
                  internalGetMutableMatchingVariantFields()
                      .ensureBuilderMap()
                      .put(matchingVariantFields__.getKey(), matchingVariantFields__.getValue());
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
                      variantRollupValues__ =
                          input.readMessage(
                              VariantRollupValuesDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableVariantRollupValues()
                      .ensureBuilderMap()
                      .put(variantRollupValues__.getKey(), variantRollupValues__.getValue());
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 58:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensurePersonalLabelsIsMutable();
                  personalLabels_.add(s);
                  break;
                } // case 58
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object id_ = "";
      /**
       *
       *
       * <pre>
       * [Product.id][google.cloud.retail.v2.Product.id] of the searched
       * [Product][google.cloud.retail.v2.Product].
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The id.
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * [Product.id][google.cloud.retail.v2.Product.id] of the searched
       * [Product][google.cloud.retail.v2.Product].
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The bytes for id.
       */
      public com.google.protobuf.ByteString getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * [Product.id][google.cloud.retail.v2.Product.id] of the searched
       * [Product][google.cloud.retail.v2.Product].
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @param value The id to set.
       * @return This builder for chaining.
       */
      public Builder setId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * [Product.id][google.cloud.retail.v2.Product.id] of the searched
       * [Product][google.cloud.retail.v2.Product].
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearId() {
        id_ = getDefaultInstance().getId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * [Product.id][google.cloud.retail.v2.Product.id] of the searched
       * [Product][google.cloud.retail.v2.Product].
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @param value The bytes for id to set.
       * @return This builder for chaining.
       */
      public Builder setIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.cloud.retail.v2.Product product_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.retail.v2.Product,
              com.google.cloud.retail.v2.Product.Builder,
              com.google.cloud.retail.v2.ProductOrBuilder>
          productBuilder_;
      /**
       *
       *
       * <pre>
       * The product data snippet in the search response. Only
       * [Product.name][google.cloud.retail.v2.Product.name] is guaranteed to be
       * populated.
       *
       * [Product.variants][google.cloud.retail.v2.Product.variants] contains the
       * product variants that match the search query. If there are multiple
       * product variants matching the query, top 5 most relevant product variants
       * are returned and ordered by relevancy.
       *
       * If relevancy can be deternmined, use
       * [matching_variant_fields][google.cloud.retail.v2.SearchResponse.SearchResult.matching_variant_fields]
       * to look up matched product variants fields. If relevancy cannot be
       * determined, e.g. when searching "shoe" all products in a shoe product can
       * be a match, 5 product variants are returned but order is meaningless.
       * </pre>
       *
       * <code>.google.cloud.retail.v2.Product product = 2;</code>
       *
       * @return Whether the product field is set.
       */
      public boolean hasProduct() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The product data snippet in the search response. Only
       * [Product.name][google.cloud.retail.v2.Product.name] is guaranteed to be
       * populated.
       *
       * [Product.variants][google.cloud.retail.v2.Product.variants] contains the
       * product variants that match the search query. If there are multiple
       * product variants matching the query, top 5 most relevant product variants
       * are returned and ordered by relevancy.
       *
       * If relevancy can be deternmined, use
       * [matching_variant_fields][google.cloud.retail.v2.SearchResponse.SearchResult.matching_variant_fields]
       * to look up matched product variants fields. If relevancy cannot be
       * determined, e.g. when searching "shoe" all products in a shoe product can
       * be a match, 5 product variants are returned but order is meaningless.
       * </pre>
       *
       * <code>.google.cloud.retail.v2.Product product = 2;</code>
       *
       * @return The product.
       */
      public com.google.cloud.retail.v2.Product getProduct() {
        if (productBuilder_ == null) {
          return product_ == null
              ? com.google.cloud.retail.v2.Product.getDefaultInstance()
              : product_;
        } else {
          return productBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The product data snippet in the search response. Only
       * [Product.name][google.cloud.retail.v2.Product.name] is guaranteed to be
       * populated.
       *
       * [Product.variants][google.cloud.retail.v2.Product.variants] contains the
       * product variants that match the search query. If there are multiple
       * product variants matching the query, top 5 most relevant product variants
       * are returned and ordered by relevancy.
       *
       * If relevancy can be deternmined, use
       * [matching_variant_fields][google.cloud.retail.v2.SearchResponse.SearchResult.matching_variant_fields]
       * to look up matched product variants fields. If relevancy cannot be
       * determined, e.g. when searching "shoe" all products in a shoe product can
       * be a match, 5 product variants are returned but order is meaningless.
       * </pre>
       *
       * <code>.google.cloud.retail.v2.Product product = 2;</code>
       */
      public Builder setProduct(com.google.cloud.retail.v2.Product value) {
        if (productBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          product_ = value;
        } else {
          productBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The product data snippet in the search response. Only
       * [Product.name][google.cloud.retail.v2.Product.name] is guaranteed to be
       * populated.
       *
       * [Product.variants][google.cloud.retail.v2.Product.variants] contains the
       * product variants that match the search query. If there are multiple
       * product variants matching the query, top 5 most relevant product variants
       * are returned and ordered by relevancy.
       *
       * If relevancy can be deternmined, use
       * [matching_variant_fields][google.cloud.retail.v2.SearchResponse.SearchResult.matching_variant_fields]
       * to look up matched product variants fields. If relevancy cannot be
       * determined, e.g. when searching "shoe" all products in a shoe product can
       * be a match, 5 product variants are returned but order is meaningless.
       * </pre>
       *
       * <code>.google.cloud.retail.v2.Product product = 2;</code>
       */
      public Builder setProduct(com.google.cloud.retail.v2.Product.Builder builderForValue) {
        if (productBuilder_ == null) {
          product_ = builderForValue.build();
        } else {
          productBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The product data snippet in the search response. Only
       * [Product.name][google.cloud.retail.v2.Product.name] is guaranteed to be
       * populated.
       *
       * [Product.variants][google.cloud.retail.v2.Product.variants] contains the
       * product variants that match the search query. If there are multiple
       * product variants matching the query, top 5 most relevant product variants
       * are returned and ordered by relevancy.
       *
       * If relevancy can be deternmined, use
       * [matching_variant_fields][google.cloud.retail.v2.SearchResponse.SearchResult.matching_variant_fields]
       * to look up matched product variants fields. If relevancy cannot be
       * determined, e.g. when searching "shoe" all products in a shoe product can
       * be a match, 5 product variants are returned but order is meaningless.
       * </pre>
       *
       * <code>.google.cloud.retail.v2.Product product = 2;</code>
       */
      public Builder mergeProduct(com.google.cloud.retail.v2.Product value) {
        if (productBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && product_ != null
              && product_ != com.google.cloud.retail.v2.Product.getDefaultInstance()) {
            getProductBuilder().mergeFrom(value);
          } else {
            product_ = value;
          }
        } else {
          productBuilder_.mergeFrom(value);
        }
        if (product_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The product data snippet in the search response. Only
       * [Product.name][google.cloud.retail.v2.Product.name] is guaranteed to be
       * populated.
       *
       * [Product.variants][google.cloud.retail.v2.Product.variants] contains the
       * product variants that match the search query. If there are multiple
       * product variants matching the query, top 5 most relevant product variants
       * are returned and ordered by relevancy.
       *
       * If relevancy can be deternmined, use
       * [matching_variant_fields][google.cloud.retail.v2.SearchResponse.SearchResult.matching_variant_fields]
       * to look up matched product variants fields. If relevancy cannot be
       * determined, e.g. when searching "shoe" all products in a shoe product can
       * be a match, 5 product variants are returned but order is meaningless.
       * </pre>
       *
       * <code>.google.cloud.retail.v2.Product product = 2;</code>
       */
      public Builder clearProduct() {
        bitField0_ = (bitField0_ & ~0x00000002);
        product_ = null;
        if (productBuilder_ != null) {
          productBuilder_.dispose();
          productBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The product data snippet in the search response. Only
       * [Product.name][google.cloud.retail.v2.Product.name] is guaranteed to be
       * populated.
       *
       * [Product.variants][google.cloud.retail.v2.Product.variants] contains the
       * product variants that match the search query. If there are multiple
       * product variants matching the query, top 5 most relevant product variants
       * are returned and ordered by relevancy.
       *
       * If relevancy can be deternmined, use
       * [matching_variant_fields][google.cloud.retail.v2.SearchResponse.SearchResult.matching_variant_fields]
       * to look up matched product variants fields. If relevancy cannot be
       * determined, e.g. when searching "shoe" all products in a shoe product can
       * be a match, 5 product variants are returned but order is meaningless.
       * </pre>
       *
       * <code>.google.cloud.retail.v2.Product product = 2;</code>
       */
      public com.google.cloud.retail.v2.Product.Builder getProductBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getProductFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The product data snippet in the search response. Only
       * [Product.name][google.cloud.retail.v2.Product.name] is guaranteed to be
       * populated.
       *
       * [Product.variants][google.cloud.retail.v2.Product.variants] contains the
       * product variants that match the search query. If there are multiple
       * product variants matching the query, top 5 most relevant product variants
       * are returned and ordered by relevancy.
       *
       * If relevancy can be deternmined, use
       * [matching_variant_fields][google.cloud.retail.v2.SearchResponse.SearchResult.matching_variant_fields]
       * to look up matched product variants fields. If relevancy cannot be
       * determined, e.g. when searching "shoe" all products in a shoe product can
       * be a match, 5 product variants are returned but order is meaningless.
       * </pre>
       *
       * <code>.google.cloud.retail.v2.Product product = 2;</code>
       */
      public com.google.cloud.retail.v2.ProductOrBuilder getProductOrBuilder() {
        if (productBuilder_ != null) {
          return productBuilder_.getMessageOrBuilder();
        } else {
          return product_ == null
              ? com.google.cloud.retail.v2.Product.getDefaultInstance()
              : product_;
        }
      }
      /**
       *
       *
       * <pre>
       * The product data snippet in the search response. Only
       * [Product.name][google.cloud.retail.v2.Product.name] is guaranteed to be
       * populated.
       *
       * [Product.variants][google.cloud.retail.v2.Product.variants] contains the
       * product variants that match the search query. If there are multiple
       * product variants matching the query, top 5 most relevant product variants
       * are returned and ordered by relevancy.
       *
       * If relevancy can be deternmined, use
       * [matching_variant_fields][google.cloud.retail.v2.SearchResponse.SearchResult.matching_variant_fields]
       * to look up matched product variants fields. If relevancy cannot be
       * determined, e.g. when searching "shoe" all products in a shoe product can
       * be a match, 5 product variants are returned but order is meaningless.
       * </pre>
       *
       * <code>.google.cloud.retail.v2.Product product = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.retail.v2.Product,
              com.google.cloud.retail.v2.Product.Builder,
              com.google.cloud.retail.v2.ProductOrBuilder>
          getProductFieldBuilder() {
        if (productBuilder_ == null) {
          productBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.retail.v2.Product,
                  com.google.cloud.retail.v2.Product.Builder,
                  com.google.cloud.retail.v2.ProductOrBuilder>(
                  getProduct(), getParentForChildren(), isClean());
          product_ = null;
        }
        return productBuilder_;
      }

      private int matchingVariantCount_;
      /**
       *
       *
       * <pre>
       * The count of matched
       * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2.Product]s.
       * </pre>
       *
       * <code>int32 matching_variant_count = 3;</code>
       *
       * @return The matchingVariantCount.
       */
      @java.lang.Override
      public int getMatchingVariantCount() {
        return matchingVariantCount_;
      }
      /**
       *
       *
       * <pre>
       * The count of matched
       * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2.Product]s.
       * </pre>
       *
       * <code>int32 matching_variant_count = 3;</code>
       *
       * @param value The matchingVariantCount to set.
       * @return This builder for chaining.
       */
      public Builder setMatchingVariantCount(int value) {

        matchingVariantCount_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The count of matched
       * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2.Product]s.
       * </pre>
       *
       * <code>int32 matching_variant_count = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMatchingVariantCount() {
        bitField0_ = (bitField0_ & ~0x00000004);
        matchingVariantCount_ = 0;
        onChanged();
        return this;
      }

      private static final class MatchingVariantFieldsConverter
          implements com.google.protobuf.MapFieldBuilder.Converter<
              java.lang.String,
              com.google.protobuf.FieldMaskOrBuilder,
              com.google.protobuf.FieldMask> {
        @java.lang.Override
        public com.google.protobuf.FieldMask build(com.google.protobuf.FieldMaskOrBuilder val) {
          if (val instanceof com.google.protobuf.FieldMask) {
            return (com.google.protobuf.FieldMask) val;
          }
          return ((com.google.protobuf.FieldMask.Builder) val).build();
        }

        @java.lang.Override
        public com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.FieldMask>
            defaultEntry() {
          return MatchingVariantFieldsDefaultEntryHolder.defaultEntry;
        }
      };

      private static final MatchingVariantFieldsConverter matchingVariantFieldsConverter =
          new MatchingVariantFieldsConverter();

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protobuf.FieldMaskOrBuilder,
              com.google.protobuf.FieldMask,
              com.google.protobuf.FieldMask.Builder>
          matchingVariantFields_;

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protobuf.FieldMaskOrBuilder,
              com.google.protobuf.FieldMask,
              com.google.protobuf.FieldMask.Builder>
          internalGetMatchingVariantFields() {
        if (matchingVariantFields_ == null) {
          return new com.google.protobuf.MapFieldBuilder<>(matchingVariantFieldsConverter);
        }
        return matchingVariantFields_;
      }

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protobuf.FieldMaskOrBuilder,
              com.google.protobuf.FieldMask,
              com.google.protobuf.FieldMask.Builder>
          internalGetMutableMatchingVariantFields() {
        if (matchingVariantFields_ == null) {
          matchingVariantFields_ =
              new com.google.protobuf.MapFieldBuilder<>(matchingVariantFieldsConverter);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return matchingVariantFields_;
      }

      public int getMatchingVariantFieldsCount() {
        return internalGetMatchingVariantFields().ensureBuilderMap().size();
      }
      /**
       *
       *
       * <pre>
       * If a [variant][google.cloud.retail.v2.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2.Product] matches the search query, this
       * map indicates which [Product][google.cloud.retail.v2.Product] fields are
       * matched. The key is the
       * [Product.name][google.cloud.retail.v2.Product.name], the value is a field
       * mask of the matched [Product][google.cloud.retail.v2.Product] fields. If
       * matched attributes cannot be determined, this map will be empty.
       *
       * For example, a key "sku1" with field mask
       * "products.color_info" indicates there is a match between
       * "sku1" [ColorInfo][google.cloud.retail.v2.ColorInfo] and the query.
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.FieldMask&gt; matching_variant_fields = 4;</code>
       */
      @java.lang.Override
      public boolean containsMatchingVariantFields(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetMatchingVariantFields().ensureBuilderMap().containsKey(key);
      }
      /** Use {@link #getMatchingVariantFieldsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.protobuf.FieldMask>
          getMatchingVariantFields() {
        return getMatchingVariantFieldsMap();
      }
      /**
       *
       *
       * <pre>
       * If a [variant][google.cloud.retail.v2.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2.Product] matches the search query, this
       * map indicates which [Product][google.cloud.retail.v2.Product] fields are
       * matched. The key is the
       * [Product.name][google.cloud.retail.v2.Product.name], the value is a field
       * mask of the matched [Product][google.cloud.retail.v2.Product] fields. If
       * matched attributes cannot be determined, this map will be empty.
       *
       * For example, a key "sku1" with field mask
       * "products.color_info" indicates there is a match between
       * "sku1" [ColorInfo][google.cloud.retail.v2.ColorInfo] and the query.
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.FieldMask&gt; matching_variant_fields = 4;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, com.google.protobuf.FieldMask>
          getMatchingVariantFieldsMap() {
        return internalGetMatchingVariantFields().getImmutableMap();
      }
      /**
       *
       *
       * <pre>
       * If a [variant][google.cloud.retail.v2.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2.Product] matches the search query, this
       * map indicates which [Product][google.cloud.retail.v2.Product] fields are
       * matched. The key is the
       * [Product.name][google.cloud.retail.v2.Product.name], the value is a field
       * mask of the matched [Product][google.cloud.retail.v2.Product] fields. If
       * matched attributes cannot be determined, this map will be empty.
       *
       * For example, a key "sku1" with field mask
       * "products.color_info" indicates there is a match between
       * "sku1" [ColorInfo][google.cloud.retail.v2.ColorInfo] and the query.
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.FieldMask&gt; matching_variant_fields = 4;</code>
       */
      @java.lang.Override
      public /* nullable */ com.google.protobuf.FieldMask getMatchingVariantFieldsOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.protobuf.FieldMask defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.protobuf.FieldMaskOrBuilder> map =
            internalGetMutableMatchingVariantFields().ensureBuilderMap();
        return map.containsKey(key)
            ? matchingVariantFieldsConverter.build(map.get(key))
            : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * If a [variant][google.cloud.retail.v2.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2.Product] matches the search query, this
       * map indicates which [Product][google.cloud.retail.v2.Product] fields are
       * matched. The key is the
       * [Product.name][google.cloud.retail.v2.Product.name], the value is a field
       * mask of the matched [Product][google.cloud.retail.v2.Product] fields. If
       * matched attributes cannot be determined, this map will be empty.
       *
       * For example, a key "sku1" with field mask
       * "products.color_info" indicates there is a match between
       * "sku1" [ColorInfo][google.cloud.retail.v2.ColorInfo] and the query.
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.FieldMask&gt; matching_variant_fields = 4;</code>
       */
      @java.lang.Override
      public com.google.protobuf.FieldMask getMatchingVariantFieldsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.protobuf.FieldMaskOrBuilder> map =
            internalGetMutableMatchingVariantFields().ensureBuilderMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return matchingVariantFieldsConverter.build(map.get(key));
      }

      public Builder clearMatchingVariantFields() {
        bitField0_ = (bitField0_ & ~0x00000008);
        internalGetMutableMatchingVariantFields().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If a [variant][google.cloud.retail.v2.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2.Product] matches the search query, this
       * map indicates which [Product][google.cloud.retail.v2.Product] fields are
       * matched. The key is the
       * [Product.name][google.cloud.retail.v2.Product.name], the value is a field
       * mask of the matched [Product][google.cloud.retail.v2.Product] fields. If
       * matched attributes cannot be determined, this map will be empty.
       *
       * For example, a key "sku1" with field mask
       * "products.color_info" indicates there is a match between
       * "sku1" [ColorInfo][google.cloud.retail.v2.ColorInfo] and the query.
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.FieldMask&gt; matching_variant_fields = 4;</code>
       */
      public Builder removeMatchingVariantFields(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableMatchingVariantFields().ensureBuilderMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.protobuf.FieldMask>
          getMutableMatchingVariantFields() {
        bitField0_ |= 0x00000008;
        return internalGetMutableMatchingVariantFields().ensureMessageMap();
      }
      /**
       *
       *
       * <pre>
       * If a [variant][google.cloud.retail.v2.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2.Product] matches the search query, this
       * map indicates which [Product][google.cloud.retail.v2.Product] fields are
       * matched. The key is the
       * [Product.name][google.cloud.retail.v2.Product.name], the value is a field
       * mask of the matched [Product][google.cloud.retail.v2.Product] fields. If
       * matched attributes cannot be determined, this map will be empty.
       *
       * For example, a key "sku1" with field mask
       * "products.color_info" indicates there is a match between
       * "sku1" [ColorInfo][google.cloud.retail.v2.ColorInfo] and the query.
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.FieldMask&gt; matching_variant_fields = 4;</code>
       */
      public Builder putMatchingVariantFields(
          java.lang.String key, com.google.protobuf.FieldMask value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableMatchingVariantFields().ensureBuilderMap().put(key, value);
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       *
       *
       * <pre>
       * If a [variant][google.cloud.retail.v2.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2.Product] matches the search query, this
       * map indicates which [Product][google.cloud.retail.v2.Product] fields are
       * matched. The key is the
       * [Product.name][google.cloud.retail.v2.Product.name], the value is a field
       * mask of the matched [Product][google.cloud.retail.v2.Product] fields. If
       * matched attributes cannot be determined, this map will be empty.
       *
       * For example, a key "sku1" with field mask
       * "products.color_info" indicates there is a match between
       * "sku1" [ColorInfo][google.cloud.retail.v2.ColorInfo] and the query.
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.FieldMask&gt; matching_variant_fields = 4;</code>
       */
      public Builder putAllMatchingVariantFields(
          java.util.Map<java.lang.String, com.google.protobuf.FieldMask> values) {
        for (java.util.Map.Entry<java.lang.String, com.google.protobuf.FieldMask> e :
            values.entrySet()) {
          if (e.getKey() == null || e.getValue() == null) {
            throw new NullPointerException();
          }
        }
        internalGetMutableMatchingVariantFields().ensureBuilderMap().putAll(values);
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       *
       *
       * <pre>
       * If a [variant][google.cloud.retail.v2.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2.Product] matches the search query, this
       * map indicates which [Product][google.cloud.retail.v2.Product] fields are
       * matched. The key is the
       * [Product.name][google.cloud.retail.v2.Product.name], the value is a field
       * mask of the matched [Product][google.cloud.retail.v2.Product] fields. If
       * matched attributes cannot be determined, this map will be empty.
       *
       * For example, a key "sku1" with field mask
       * "products.color_info" indicates there is a match between
       * "sku1" [ColorInfo][google.cloud.retail.v2.ColorInfo] and the query.
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.FieldMask&gt; matching_variant_fields = 4;</code>
       */
      public com.google.protobuf.FieldMask.Builder putMatchingVariantFieldsBuilderIfAbsent(
          java.lang.String key) {
        java.util.Map<java.lang.String, com.google.protobuf.FieldMaskOrBuilder> builderMap =
            internalGetMutableMatchingVariantFields().ensureBuilderMap();
        com.google.protobuf.FieldMaskOrBuilder entry = builderMap.get(key);
        if (entry == null) {
          entry = com.google.protobuf.FieldMask.newBuilder();
          builderMap.put(key, entry);
        }
        if (entry instanceof com.google.protobuf.FieldMask) {
          entry = ((com.google.protobuf.FieldMask) entry).toBuilder();
          builderMap.put(key, entry);
        }
        return (com.google.protobuf.FieldMask.Builder) entry;
      }

      private static final class VariantRollupValuesConverter
          implements com.google.protobuf.MapFieldBuilder.Converter<
              java.lang.String, com.google.protobuf.ValueOrBuilder, com.google.protobuf.Value> {
        @java.lang.Override
        public com.google.protobuf.Value build(com.google.protobuf.ValueOrBuilder val) {
          if (val instanceof com.google.protobuf.Value) {
            return (com.google.protobuf.Value) val;
          }
          return ((com.google.protobuf.Value.Builder) val).build();
        }

        @java.lang.Override
        public com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
            defaultEntry() {
          return VariantRollupValuesDefaultEntryHolder.defaultEntry;
        }
      };

      private static final VariantRollupValuesConverter variantRollupValuesConverter =
          new VariantRollupValuesConverter();

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protobuf.ValueOrBuilder,
              com.google.protobuf.Value,
              com.google.protobuf.Value.Builder>
          variantRollupValues_;

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protobuf.ValueOrBuilder,
              com.google.protobuf.Value,
              com.google.protobuf.Value.Builder>
          internalGetVariantRollupValues() {
        if (variantRollupValues_ == null) {
          return new com.google.protobuf.MapFieldBuilder<>(variantRollupValuesConverter);
        }
        return variantRollupValues_;
      }

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protobuf.ValueOrBuilder,
              com.google.protobuf.Value,
              com.google.protobuf.Value.Builder>
          internalGetMutableVariantRollupValues() {
        if (variantRollupValues_ == null) {
          variantRollupValues_ =
              new com.google.protobuf.MapFieldBuilder<>(variantRollupValuesConverter);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return variantRollupValues_;
      }

      public int getVariantRollupValuesCount() {
        return internalGetVariantRollupValues().ensureBuilderMap().size();
      }
      /**
       *
       *
       * <pre>
       * The rollup matching
       * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2.Product] attributes. The key is one of
       * the
       * [SearchRequest.variant_rollup_keys][google.cloud.retail.v2.SearchRequest.variant_rollup_keys].
       * The values are the merged and de-duplicated
       * [Product][google.cloud.retail.v2.Product] attributes. Notice that the
       * rollup values are respect filter. For example, when filtering by
       * "colorFamilies:ANY(&#92;"red&#92;")" and rollup "colorFamilies", only "red" is
       * returned.
       *
       * For textual and numerical attributes, the rollup values is a list of
       * string or double values with type
       * [google.protobuf.ListValue][google.protobuf.ListValue]. For example, if
       * there are two variants with colors "red" and "blue", the rollup values
       * are
       *
       *     { key: "colorFamilies"
       *       value {
       *         list_value {
       *           values { string_value: "red" }
       *           values { string_value: "blue" }
       *          }
       *       }
       *     }
       *
       * For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], the rollup
       * values is a double value with type
       * [google.protobuf.Value][google.protobuf.Value]. For example,
       * `{key: "pickupInStore.store1" value { number_value: 10 }}` means a there
       * are 10 variants in this product are available in the store "store1".
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; variant_rollup_values = 5;</code>
       */
      @java.lang.Override
      public boolean containsVariantRollupValues(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetVariantRollupValues().ensureBuilderMap().containsKey(key);
      }
      /** Use {@link #getVariantRollupValuesMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.protobuf.Value> getVariantRollupValues() {
        return getVariantRollupValuesMap();
      }
      /**
       *
       *
       * <pre>
       * The rollup matching
       * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2.Product] attributes. The key is one of
       * the
       * [SearchRequest.variant_rollup_keys][google.cloud.retail.v2.SearchRequest.variant_rollup_keys].
       * The values are the merged and de-duplicated
       * [Product][google.cloud.retail.v2.Product] attributes. Notice that the
       * rollup values are respect filter. For example, when filtering by
       * "colorFamilies:ANY(&#92;"red&#92;")" and rollup "colorFamilies", only "red" is
       * returned.
       *
       * For textual and numerical attributes, the rollup values is a list of
       * string or double values with type
       * [google.protobuf.ListValue][google.protobuf.ListValue]. For example, if
       * there are two variants with colors "red" and "blue", the rollup values
       * are
       *
       *     { key: "colorFamilies"
       *       value {
       *         list_value {
       *           values { string_value: "red" }
       *           values { string_value: "blue" }
       *          }
       *       }
       *     }
       *
       * For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], the rollup
       * values is a double value with type
       * [google.protobuf.Value][google.protobuf.Value]. For example,
       * `{key: "pickupInStore.store1" value { number_value: 10 }}` means a there
       * are 10 variants in this product are available in the store "store1".
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; variant_rollup_values = 5;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, com.google.protobuf.Value>
          getVariantRollupValuesMap() {
        return internalGetVariantRollupValues().getImmutableMap();
      }
      /**
       *
       *
       * <pre>
       * The rollup matching
       * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2.Product] attributes. The key is one of
       * the
       * [SearchRequest.variant_rollup_keys][google.cloud.retail.v2.SearchRequest.variant_rollup_keys].
       * The values are the merged and de-duplicated
       * [Product][google.cloud.retail.v2.Product] attributes. Notice that the
       * rollup values are respect filter. For example, when filtering by
       * "colorFamilies:ANY(&#92;"red&#92;")" and rollup "colorFamilies", only "red" is
       * returned.
       *
       * For textual and numerical attributes, the rollup values is a list of
       * string or double values with type
       * [google.protobuf.ListValue][google.protobuf.ListValue]. For example, if
       * there are two variants with colors "red" and "blue", the rollup values
       * are
       *
       *     { key: "colorFamilies"
       *       value {
       *         list_value {
       *           values { string_value: "red" }
       *           values { string_value: "blue" }
       *          }
       *       }
       *     }
       *
       * For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], the rollup
       * values is a double value with type
       * [google.protobuf.Value][google.protobuf.Value]. For example,
       * `{key: "pickupInStore.store1" value { number_value: 10 }}` means a there
       * are 10 variants in this product are available in the store "store1".
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; variant_rollup_values = 5;</code>
       */
      @java.lang.Override
      public /* nullable */ com.google.protobuf.Value getVariantRollupValuesOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.protobuf.Value defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> map =
            internalGetMutableVariantRollupValues().ensureBuilderMap();
        return map.containsKey(key)
            ? variantRollupValuesConverter.build(map.get(key))
            : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * The rollup matching
       * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2.Product] attributes. The key is one of
       * the
       * [SearchRequest.variant_rollup_keys][google.cloud.retail.v2.SearchRequest.variant_rollup_keys].
       * The values are the merged and de-duplicated
       * [Product][google.cloud.retail.v2.Product] attributes. Notice that the
       * rollup values are respect filter. For example, when filtering by
       * "colorFamilies:ANY(&#92;"red&#92;")" and rollup "colorFamilies", only "red" is
       * returned.
       *
       * For textual and numerical attributes, the rollup values is a list of
       * string or double values with type
       * [google.protobuf.ListValue][google.protobuf.ListValue]. For example, if
       * there are two variants with colors "red" and "blue", the rollup values
       * are
       *
       *     { key: "colorFamilies"
       *       value {
       *         list_value {
       *           values { string_value: "red" }
       *           values { string_value: "blue" }
       *          }
       *       }
       *     }
       *
       * For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], the rollup
       * values is a double value with type
       * [google.protobuf.Value][google.protobuf.Value]. For example,
       * `{key: "pickupInStore.store1" value { number_value: 10 }}` means a there
       * are 10 variants in this product are available in the store "store1".
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; variant_rollup_values = 5;</code>
       */
      @java.lang.Override
      public com.google.protobuf.Value getVariantRollupValuesOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> map =
            internalGetMutableVariantRollupValues().ensureBuilderMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return variantRollupValuesConverter.build(map.get(key));
      }

      public Builder clearVariantRollupValues() {
        bitField0_ = (bitField0_ & ~0x00000010);
        internalGetMutableVariantRollupValues().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The rollup matching
       * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2.Product] attributes. The key is one of
       * the
       * [SearchRequest.variant_rollup_keys][google.cloud.retail.v2.SearchRequest.variant_rollup_keys].
       * The values are the merged and de-duplicated
       * [Product][google.cloud.retail.v2.Product] attributes. Notice that the
       * rollup values are respect filter. For example, when filtering by
       * "colorFamilies:ANY(&#92;"red&#92;")" and rollup "colorFamilies", only "red" is
       * returned.
       *
       * For textual and numerical attributes, the rollup values is a list of
       * string or double values with type
       * [google.protobuf.ListValue][google.protobuf.ListValue]. For example, if
       * there are two variants with colors "red" and "blue", the rollup values
       * are
       *
       *     { key: "colorFamilies"
       *       value {
       *         list_value {
       *           values { string_value: "red" }
       *           values { string_value: "blue" }
       *          }
       *       }
       *     }
       *
       * For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], the rollup
       * values is a double value with type
       * [google.protobuf.Value][google.protobuf.Value]. For example,
       * `{key: "pickupInStore.store1" value { number_value: 10 }}` means a there
       * are 10 variants in this product are available in the store "store1".
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; variant_rollup_values = 5;</code>
       */
      public Builder removeVariantRollupValues(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableVariantRollupValues().ensureBuilderMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.protobuf.Value>
          getMutableVariantRollupValues() {
        bitField0_ |= 0x00000010;
        return internalGetMutableVariantRollupValues().ensureMessageMap();
      }
      /**
       *
       *
       * <pre>
       * The rollup matching
       * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2.Product] attributes. The key is one of
       * the
       * [SearchRequest.variant_rollup_keys][google.cloud.retail.v2.SearchRequest.variant_rollup_keys].
       * The values are the merged and de-duplicated
       * [Product][google.cloud.retail.v2.Product] attributes. Notice that the
       * rollup values are respect filter. For example, when filtering by
       * "colorFamilies:ANY(&#92;"red&#92;")" and rollup "colorFamilies", only "red" is
       * returned.
       *
       * For textual and numerical attributes, the rollup values is a list of
       * string or double values with type
       * [google.protobuf.ListValue][google.protobuf.ListValue]. For example, if
       * there are two variants with colors "red" and "blue", the rollup values
       * are
       *
       *     { key: "colorFamilies"
       *       value {
       *         list_value {
       *           values { string_value: "red" }
       *           values { string_value: "blue" }
       *          }
       *       }
       *     }
       *
       * For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], the rollup
       * values is a double value with type
       * [google.protobuf.Value][google.protobuf.Value]. For example,
       * `{key: "pickupInStore.store1" value { number_value: 10 }}` means a there
       * are 10 variants in this product are available in the store "store1".
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; variant_rollup_values = 5;</code>
       */
      public Builder putVariantRollupValues(java.lang.String key, com.google.protobuf.Value value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableVariantRollupValues().ensureBuilderMap().put(key, value);
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The rollup matching
       * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2.Product] attributes. The key is one of
       * the
       * [SearchRequest.variant_rollup_keys][google.cloud.retail.v2.SearchRequest.variant_rollup_keys].
       * The values are the merged and de-duplicated
       * [Product][google.cloud.retail.v2.Product] attributes. Notice that the
       * rollup values are respect filter. For example, when filtering by
       * "colorFamilies:ANY(&#92;"red&#92;")" and rollup "colorFamilies", only "red" is
       * returned.
       *
       * For textual and numerical attributes, the rollup values is a list of
       * string or double values with type
       * [google.protobuf.ListValue][google.protobuf.ListValue]. For example, if
       * there are two variants with colors "red" and "blue", the rollup values
       * are
       *
       *     { key: "colorFamilies"
       *       value {
       *         list_value {
       *           values { string_value: "red" }
       *           values { string_value: "blue" }
       *          }
       *       }
       *     }
       *
       * For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], the rollup
       * values is a double value with type
       * [google.protobuf.Value][google.protobuf.Value]. For example,
       * `{key: "pickupInStore.store1" value { number_value: 10 }}` means a there
       * are 10 variants in this product are available in the store "store1".
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; variant_rollup_values = 5;</code>
       */
      public Builder putAllVariantRollupValues(
          java.util.Map<java.lang.String, com.google.protobuf.Value> values) {
        for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Value> e :
            values.entrySet()) {
          if (e.getKey() == null || e.getValue() == null) {
            throw new NullPointerException();
          }
        }
        internalGetMutableVariantRollupValues().ensureBuilderMap().putAll(values);
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The rollup matching
       * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2.Product] attributes. The key is one of
       * the
       * [SearchRequest.variant_rollup_keys][google.cloud.retail.v2.SearchRequest.variant_rollup_keys].
       * The values are the merged and de-duplicated
       * [Product][google.cloud.retail.v2.Product] attributes. Notice that the
       * rollup values are respect filter. For example, when filtering by
       * "colorFamilies:ANY(&#92;"red&#92;")" and rollup "colorFamilies", only "red" is
       * returned.
       *
       * For textual and numerical attributes, the rollup values is a list of
       * string or double values with type
       * [google.protobuf.ListValue][google.protobuf.ListValue]. For example, if
       * there are two variants with colors "red" and "blue", the rollup values
       * are
       *
       *     { key: "colorFamilies"
       *       value {
       *         list_value {
       *           values { string_value: "red" }
       *           values { string_value: "blue" }
       *          }
       *       }
       *     }
       *
       * For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], the rollup
       * values is a double value with type
       * [google.protobuf.Value][google.protobuf.Value]. For example,
       * `{key: "pickupInStore.store1" value { number_value: 10 }}` means a there
       * are 10 variants in this product are available in the store "store1".
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; variant_rollup_values = 5;</code>
       */
      public com.google.protobuf.Value.Builder putVariantRollupValuesBuilderIfAbsent(
          java.lang.String key) {
        java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> builderMap =
            internalGetMutableVariantRollupValues().ensureBuilderMap();
        com.google.protobuf.ValueOrBuilder entry = builderMap.get(key);
        if (entry == null) {
          entry = com.google.protobuf.Value.newBuilder();
          builderMap.put(key, entry);
        }
        if (entry instanceof com.google.protobuf.Value) {
          entry = ((com.google.protobuf.Value) entry).toBuilder();
          builderMap.put(key, entry);
        }
        return (com.google.protobuf.Value.Builder) entry;
      }

      private com.google.protobuf.LazyStringArrayList personalLabels_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensurePersonalLabelsIsMutable() {
        if (!personalLabels_.isModifiable()) {
          personalLabels_ = new com.google.protobuf.LazyStringArrayList(personalLabels_);
        }
        bitField0_ |= 0x00000020;
      }
      /**
       *
       *
       * <pre>
       * Specifies previous events related to this product for this user based on
       * [UserEvent][google.cloud.retail.v2.UserEvent] with same
       * [SearchRequest.visitor_id][google.cloud.retail.v2.SearchRequest.visitor_id]
       * or [UserInfo.user_id][google.cloud.retail.v2.UserInfo.user_id].
       *
       * This is set only when
       * [SearchRequest.PersonalizationSpec.mode][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.mode]
       * is
       * [SearchRequest.PersonalizationSpec.Mode.AUTO][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.Mode.AUTO].
       *
       * Possible values:
       *
       * * `purchased`: Indicates that this product has been purchased before.
       * </pre>
       *
       * <code>repeated string personal_labels = 7;</code>
       *
       * @return A list containing the personalLabels.
       */
      public com.google.protobuf.ProtocolStringList getPersonalLabelsList() {
        personalLabels_.makeImmutable();
        return personalLabels_;
      }
      /**
       *
       *
       * <pre>
       * Specifies previous events related to this product for this user based on
       * [UserEvent][google.cloud.retail.v2.UserEvent] with same
       * [SearchRequest.visitor_id][google.cloud.retail.v2.SearchRequest.visitor_id]
       * or [UserInfo.user_id][google.cloud.retail.v2.UserInfo.user_id].
       *
       * This is set only when
       * [SearchRequest.PersonalizationSpec.mode][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.mode]
       * is
       * [SearchRequest.PersonalizationSpec.Mode.AUTO][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.Mode.AUTO].
       *
       * Possible values:
       *
       * * `purchased`: Indicates that this product has been purchased before.
       * </pre>
       *
       * <code>repeated string personal_labels = 7;</code>
       *
       * @return The count of personalLabels.
       */
      public int getPersonalLabelsCount() {
        return personalLabels_.size();
      }
      /**
       *
       *
       * <pre>
       * Specifies previous events related to this product for this user based on
       * [UserEvent][google.cloud.retail.v2.UserEvent] with same
       * [SearchRequest.visitor_id][google.cloud.retail.v2.SearchRequest.visitor_id]
       * or [UserInfo.user_id][google.cloud.retail.v2.UserInfo.user_id].
       *
       * This is set only when
       * [SearchRequest.PersonalizationSpec.mode][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.mode]
       * is
       * [SearchRequest.PersonalizationSpec.Mode.AUTO][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.Mode.AUTO].
       *
       * Possible values:
       *
       * * `purchased`: Indicates that this product has been purchased before.
       * </pre>
       *
       * <code>repeated string personal_labels = 7;</code>
       *
       * @param index The index of the element to return.
       * @return The personalLabels at the given index.
       */
      public java.lang.String getPersonalLabels(int index) {
        return personalLabels_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Specifies previous events related to this product for this user based on
       * [UserEvent][google.cloud.retail.v2.UserEvent] with same
       * [SearchRequest.visitor_id][google.cloud.retail.v2.SearchRequest.visitor_id]
       * or [UserInfo.user_id][google.cloud.retail.v2.UserInfo.user_id].
       *
       * This is set only when
       * [SearchRequest.PersonalizationSpec.mode][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.mode]
       * is
       * [SearchRequest.PersonalizationSpec.Mode.AUTO][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.Mode.AUTO].
       *
       * Possible values:
       *
       * * `purchased`: Indicates that this product has been purchased before.
       * </pre>
       *
       * <code>repeated string personal_labels = 7;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the personalLabels at the given index.
       */
      public com.google.protobuf.ByteString getPersonalLabelsBytes(int index) {
        return personalLabels_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Specifies previous events related to this product for this user based on
       * [UserEvent][google.cloud.retail.v2.UserEvent] with same
       * [SearchRequest.visitor_id][google.cloud.retail.v2.SearchRequest.visitor_id]
       * or [UserInfo.user_id][google.cloud.retail.v2.UserInfo.user_id].
       *
       * This is set only when
       * [SearchRequest.PersonalizationSpec.mode][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.mode]
       * is
       * [SearchRequest.PersonalizationSpec.Mode.AUTO][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.Mode.AUTO].
       *
       * Possible values:
       *
       * * `purchased`: Indicates that this product has been purchased before.
       * </pre>
       *
       * <code>repeated string personal_labels = 7;</code>
       *
       * @param index The index to set the value at.
       * @param value The personalLabels to set.
       * @return This builder for chaining.
       */
      public Builder setPersonalLabels(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePersonalLabelsIsMutable();
        personalLabels_.set(index, value);
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies previous events related to this product for this user based on
       * [UserEvent][google.cloud.retail.v2.UserEvent] with same
       * [SearchRequest.visitor_id][google.cloud.retail.v2.SearchRequest.visitor_id]
       * or [UserInfo.user_id][google.cloud.retail.v2.UserInfo.user_id].
       *
       * This is set only when
       * [SearchRequest.PersonalizationSpec.mode][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.mode]
       * is
       * [SearchRequest.PersonalizationSpec.Mode.AUTO][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.Mode.AUTO].
       *
       * Possible values:
       *
       * * `purchased`: Indicates that this product has been purchased before.
       * </pre>
       *
       * <code>repeated string personal_labels = 7;</code>
       *
       * @param value The personalLabels to add.
       * @return This builder for chaining.
       */
      public Builder addPersonalLabels(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePersonalLabelsIsMutable();
        personalLabels_.add(value);
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies previous events related to this product for this user based on
       * [UserEvent][google.cloud.retail.v2.UserEvent] with same
       * [SearchRequest.visitor_id][google.cloud.retail.v2.SearchRequest.visitor_id]
       * or [UserInfo.user_id][google.cloud.retail.v2.UserInfo.user_id].
       *
       * This is set only when
       * [SearchRequest.PersonalizationSpec.mode][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.mode]
       * is
       * [SearchRequest.PersonalizationSpec.Mode.AUTO][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.Mode.AUTO].
       *
       * Possible values:
       *
       * * `purchased`: Indicates that this product has been purchased before.
       * </pre>
       *
       * <code>repeated string personal_labels = 7;</code>
       *
       * @param values The personalLabels to add.
       * @return This builder for chaining.
       */
      public Builder addAllPersonalLabels(java.lang.Iterable<java.lang.String> values) {
        ensurePersonalLabelsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, personalLabels_);
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies previous events related to this product for this user based on
       * [UserEvent][google.cloud.retail.v2.UserEvent] with same
       * [SearchRequest.visitor_id][google.cloud.retail.v2.SearchRequest.visitor_id]
       * or [UserInfo.user_id][google.cloud.retail.v2.UserInfo.user_id].
       *
       * This is set only when
       * [SearchRequest.PersonalizationSpec.mode][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.mode]
       * is
       * [SearchRequest.PersonalizationSpec.Mode.AUTO][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.Mode.AUTO].
       *
       * Possible values:
       *
       * * `purchased`: Indicates that this product has been purchased before.
       * </pre>
       *
       * <code>repeated string personal_labels = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPersonalLabels() {
        personalLabels_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies previous events related to this product for this user based on
       * [UserEvent][google.cloud.retail.v2.UserEvent] with same
       * [SearchRequest.visitor_id][google.cloud.retail.v2.SearchRequest.visitor_id]
       * or [UserInfo.user_id][google.cloud.retail.v2.UserInfo.user_id].
       *
       * This is set only when
       * [SearchRequest.PersonalizationSpec.mode][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.mode]
       * is
       * [SearchRequest.PersonalizationSpec.Mode.AUTO][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.Mode.AUTO].
       *
       * Possible values:
       *
       * * `purchased`: Indicates that this product has been purchased before.
       * </pre>
       *
       * <code>repeated string personal_labels = 7;</code>
       *
       * @param value The bytes of the personalLabels to add.
       * @return This builder for chaining.
       */
      public Builder addPersonalLabelsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensurePersonalLabelsIsMutable();
        personalLabels_.add(value);
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.SearchResponse.SearchResult)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.SearchResponse.SearchResult)
    private static final com.google.cloud.retail.v2.SearchResponse.SearchResult DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2.SearchResponse.SearchResult();
    }

    public static com.google.cloud.retail.v2.SearchResponse.SearchResult getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SearchResult> PARSER =
        new com.google.protobuf.AbstractParser<SearchResult>() {
          @java.lang.Override
          public SearchResult parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SearchResult> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SearchResult> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.SearchResponse.SearchResult getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FacetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2.SearchResponse.Facet)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The key for this facet. E.g., "colorFamilies" or "price" or
     * "attributes.attr1".
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The key.
     */
    java.lang.String getKey();
    /**
     *
     *
     * <pre>
     * The key for this facet. E.g., "colorFamilies" or "price" or
     * "attributes.attr1".
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The bytes for key.
     */
    com.google.protobuf.ByteString getKeyBytes();

    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
     */
    java.util.List<com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue> getValuesList();
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
     */
    com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue getValues(int index);
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
     */
    int getValuesCount();
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
     */
    java.util.List<? extends com.google.cloud.retail.v2.SearchResponse.Facet.FacetValueOrBuilder>
        getValuesOrBuilderList();
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
     */
    com.google.cloud.retail.v2.SearchResponse.Facet.FacetValueOrBuilder getValuesOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * Whether the facet is dynamically generated.
     * </pre>
     *
     * <code>bool dynamic_facet = 3;</code>
     *
     * @return The dynamicFacet.
     */
    boolean getDynamicFacet();
  }
  /**
   *
   *
   * <pre>
   * A facet result.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2.SearchResponse.Facet}
   */
  public static final class Facet extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.SearchResponse.Facet)
      FacetOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Facet.newBuilder() to construct.
    private Facet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Facet() {
      key_ = "";
      values_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Facet();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2.SearchServiceProto
          .internal_static_google_cloud_retail_v2_SearchResponse_Facet_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2.SearchServiceProto
          .internal_static_google_cloud_retail_v2_SearchResponse_Facet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2.SearchResponse.Facet.class,
              com.google.cloud.retail.v2.SearchResponse.Facet.Builder.class);
    }

    public interface FacetValueOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2.SearchResponse.Facet.FacetValue)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Text value of a facet, such as "Black" for facet "colorFamilies".
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return Whether the value field is set.
       */
      boolean hasValue();
      /**
       *
       *
       * <pre>
       * Text value of a facet, such as "Black" for facet "colorFamilies".
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return The value.
       */
      java.lang.String getValue();
      /**
       *
       *
       * <pre>
       * Text value of a facet, such as "Black" for facet "colorFamilies".
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return The bytes for value.
       */
      com.google.protobuf.ByteString getValueBytes();

      /**
       *
       *
       * <pre>
       * Interval value for a facet, such as [10, 20) for facet "price".
       * </pre>
       *
       * <code>.google.cloud.retail.v2.Interval interval = 2;</code>
       *
       * @return Whether the interval field is set.
       */
      boolean hasInterval();
      /**
       *
       *
       * <pre>
       * Interval value for a facet, such as [10, 20) for facet "price".
       * </pre>
       *
       * <code>.google.cloud.retail.v2.Interval interval = 2;</code>
       *
       * @return The interval.
       */
      com.google.cloud.retail.v2.Interval getInterval();
      /**
       *
       *
       * <pre>
       * Interval value for a facet, such as [10, 20) for facet "price".
       * </pre>
       *
       * <code>.google.cloud.retail.v2.Interval interval = 2;</code>
       */
      com.google.cloud.retail.v2.IntervalOrBuilder getIntervalOrBuilder();

      /**
       *
       *
       * <pre>
       * Number of items that have this facet value.
       * </pre>
       *
       * <code>int64 count = 3;</code>
       *
       * @return The count.
       */
      long getCount();

      /**
       *
       *
       * <pre>
       * The minimum value in the
       * [FacetValue.interval][google.cloud.retail.v2.SearchResponse.Facet.FacetValue.interval].
       * Only supported on numerical facets and returned if
       * [SearchRequest.FacetSpec.FacetKey.return_min_max][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.return_min_max]
       * is true.
       * </pre>
       *
       * <code>double min_value = 5;</code>
       *
       * @return The minValue.
       */
      double getMinValue();

      /**
       *
       *
       * <pre>
       * The maximum value in the
       * [FacetValue.interval][google.cloud.retail.v2.SearchResponse.Facet.FacetValue.interval].
       * Only supported on numerical facets and returned if
       * [SearchRequest.FacetSpec.FacetKey.return_min_max][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.return_min_max]
       * is true.
       * </pre>
       *
       * <code>double max_value = 6;</code>
       *
       * @return The maxValue.
       */
      double getMaxValue();

      com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue.FacetValueCase getFacetValueCase();
    }
    /**
     *
     *
     * <pre>
     * A facet value which contains value names and their count.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2.SearchResponse.Facet.FacetValue}
     */
    public static final class FacetValue extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.SearchResponse.Facet.FacetValue)
        FacetValueOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use FacetValue.newBuilder() to construct.
      private FacetValue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private FacetValue() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new FacetValue();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2.SearchServiceProto
            .internal_static_google_cloud_retail_v2_SearchResponse_Facet_FacetValue_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2.SearchServiceProto
            .internal_static_google_cloud_retail_v2_SearchResponse_Facet_FacetValue_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue.class,
                com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue.Builder.class);
      }

      private int facetValueCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object facetValue_;

      public enum FacetValueCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        VALUE(1),
        INTERVAL(2),
        FACETVALUE_NOT_SET(0);
        private final int value;

        private FacetValueCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static FacetValueCase valueOf(int value) {
          return forNumber(value);
        }

        public static FacetValueCase forNumber(int value) {
          switch (value) {
            case 1:
              return VALUE;
            case 2:
              return INTERVAL;
            case 0:
              return FACETVALUE_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public FacetValueCase getFacetValueCase() {
        return FacetValueCase.forNumber(facetValueCase_);
      }

      public static final int VALUE_FIELD_NUMBER = 1;
      /**
       *
       *
       * <pre>
       * Text value of a facet, such as "Black" for facet "colorFamilies".
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return Whether the value field is set.
       */
      public boolean hasValue() {
        return facetValueCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Text value of a facet, such as "Black" for facet "colorFamilies".
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return The value.
       */
      public java.lang.String getValue() {
        java.lang.Object ref = "";
        if (facetValueCase_ == 1) {
          ref = facetValue_;
        }
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (facetValueCase_ == 1) {
            facetValue_ = s;
          }
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Text value of a facet, such as "Black" for facet "colorFamilies".
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return The bytes for value.
       */
      public com.google.protobuf.ByteString getValueBytes() {
        java.lang.Object ref = "";
        if (facetValueCase_ == 1) {
          ref = facetValue_;
        }
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (facetValueCase_ == 1) {
            facetValue_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int INTERVAL_FIELD_NUMBER = 2;
      /**
       *
       *
       * <pre>
       * Interval value for a facet, such as [10, 20) for facet "price".
       * </pre>
       *
       * <code>.google.cloud.retail.v2.Interval interval = 2;</code>
       *
       * @return Whether the interval field is set.
       */
      @java.lang.Override
      public boolean hasInterval() {
        return facetValueCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Interval value for a facet, such as [10, 20) for facet "price".
       * </pre>
       *
       * <code>.google.cloud.retail.v2.Interval interval = 2;</code>
       *
       * @return The interval.
       */
      @java.lang.Override
      public com.google.cloud.retail.v2.Interval getInterval() {
        if (facetValueCase_ == 2) {
          return (com.google.cloud.retail.v2.Interval) facetValue_;
        }
        return com.google.cloud.retail.v2.Interval.getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * Interval value for a facet, such as [10, 20) for facet "price".
       * </pre>
       *
       * <code>.google.cloud.retail.v2.Interval interval = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.retail.v2.IntervalOrBuilder getIntervalOrBuilder() {
        if (facetValueCase_ == 2) {
          return (com.google.cloud.retail.v2.Interval) facetValue_;
        }
        return com.google.cloud.retail.v2.Interval.getDefaultInstance();
      }

      public static final int COUNT_FIELD_NUMBER = 3;
      private long count_ = 0L;
      /**
       *
       *
       * <pre>
       * Number of items that have this facet value.
       * </pre>
       *
       * <code>int64 count = 3;</code>
       *
       * @return The count.
       */
      @java.lang.Override
      public long getCount() {
        return count_;
      }

      public static final int MIN_VALUE_FIELD_NUMBER = 5;
      private double minValue_ = 0D;
      /**
       *
       *
       * <pre>
       * The minimum value in the
       * [FacetValue.interval][google.cloud.retail.v2.SearchResponse.Facet.FacetValue.interval].
       * Only supported on numerical facets and returned if
       * [SearchRequest.FacetSpec.FacetKey.return_min_max][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.return_min_max]
       * is true.
       * </pre>
       *
       * <code>double min_value = 5;</code>
       *
       * @return The minValue.
       */
      @java.lang.Override
      public double getMinValue() {
        return minValue_;
      }

      public static final int MAX_VALUE_FIELD_NUMBER = 6;
      private double maxValue_ = 0D;
      /**
       *
       *
       * <pre>
       * The maximum value in the
       * [FacetValue.interval][google.cloud.retail.v2.SearchResponse.Facet.FacetValue.interval].
       * Only supported on numerical facets and returned if
       * [SearchRequest.FacetSpec.FacetKey.return_min_max][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.return_min_max]
       * is true.
       * </pre>
       *
       * <code>double max_value = 6;</code>
       *
       * @return The maxValue.
       */
      @java.lang.Override
      public double getMaxValue() {
        return maxValue_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (facetValueCase_ == 1) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, facetValue_);
        }
        if (facetValueCase_ == 2) {
          output.writeMessage(2, (com.google.cloud.retail.v2.Interval) facetValue_);
        }
        if (count_ != 0L) {
          output.writeInt64(3, count_);
        }
        if (java.lang.Double.doubleToRawLongBits(minValue_) != 0) {
          output.writeDouble(5, minValue_);
        }
        if (java.lang.Double.doubleToRawLongBits(maxValue_) != 0) {
          output.writeDouble(6, maxValue_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (facetValueCase_ == 1) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, facetValue_);
        }
        if (facetValueCase_ == 2) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2, (com.google.cloud.retail.v2.Interval) facetValue_);
        }
        if (count_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, count_);
        }
        if (java.lang.Double.doubleToRawLongBits(minValue_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeDoubleSize(5, minValue_);
        }
        if (java.lang.Double.doubleToRawLongBits(maxValue_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeDoubleSize(6, maxValue_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue)) {
          return super.equals(obj);
        }
        com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue other =
            (com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue) obj;

        if (getCount() != other.getCount()) return false;
        if (java.lang.Double.doubleToLongBits(getMinValue())
            != java.lang.Double.doubleToLongBits(other.getMinValue())) return false;
        if (java.lang.Double.doubleToLongBits(getMaxValue())
            != java.lang.Double.doubleToLongBits(other.getMaxValue())) return false;
        if (!getFacetValueCase().equals(other.getFacetValueCase())) return false;
        switch (facetValueCase_) {
          case 1:
            if (!getValue().equals(other.getValue())) return false;
            break;
          case 2:
            if (!getInterval().equals(other.getInterval())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + COUNT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getCount());
        hash = (37 * hash) + MIN_VALUE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getMinValue()));
        hash = (37 * hash) + MAX_VALUE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getMaxValue()));
        switch (facetValueCase_) {
          case 1:
            hash = (37 * hash) + VALUE_FIELD_NUMBER;
            hash = (53 * hash) + getValue().hashCode();
            break;
          case 2:
            hash = (37 * hash) + INTERVAL_FIELD_NUMBER;
            hash = (53 * hash) + getInterval().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A facet value which contains value names and their count.
       * </pre>
       *
       * Protobuf type {@code google.cloud.retail.v2.SearchResponse.Facet.FacetValue}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.SearchResponse.Facet.FacetValue)
          com.google.cloud.retail.v2.SearchResponse.Facet.FacetValueOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.retail.v2.SearchServiceProto
              .internal_static_google_cloud_retail_v2_SearchResponse_Facet_FacetValue_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.retail.v2.SearchServiceProto
              .internal_static_google_cloud_retail_v2_SearchResponse_Facet_FacetValue_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue.class,
                  com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue.Builder.class);
        }

        // Construct using com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (intervalBuilder_ != null) {
            intervalBuilder_.clear();
          }
          count_ = 0L;
          minValue_ = 0D;
          maxValue_ = 0D;
          facetValueCase_ = 0;
          facetValue_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.retail.v2.SearchServiceProto
              .internal_static_google_cloud_retail_v2_SearchResponse_Facet_FacetValue_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue
            getDefaultInstanceForType() {
          return com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue build() {
          com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue buildPartial() {
          com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue result =
              new com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.count_ = count_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.minValue_ = minValue_;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.maxValue_ = maxValue_;
          }
        }

        private void buildPartialOneofs(
            com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue result) {
          result.facetValueCase_ = facetValueCase_;
          result.facetValue_ = this.facetValue_;
          if (facetValueCase_ == 2 && intervalBuilder_ != null) {
            result.facetValue_ = intervalBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue) {
            return mergeFrom((com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue other) {
          if (other
              == com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue.getDefaultInstance())
            return this;
          if (other.getCount() != 0L) {
            setCount(other.getCount());
          }
          if (other.getMinValue() != 0D) {
            setMinValue(other.getMinValue());
          }
          if (other.getMaxValue() != 0D) {
            setMaxValue(other.getMaxValue());
          }
          switch (other.getFacetValueCase()) {
            case VALUE:
              {
                facetValueCase_ = 1;
                facetValue_ = other.facetValue_;
                onChanged();
                break;
              }
            case INTERVAL:
              {
                mergeInterval(other.getInterval());
                break;
              }
            case FACETVALUE_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    facetValueCase_ = 1;
                    facetValue_ = s;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getIntervalFieldBuilder().getBuilder(), extensionRegistry);
                    facetValueCase_ = 2;
                    break;
                  } // case 18
                case 24:
                  {
                    count_ = input.readInt64();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                case 41:
                  {
                    minValue_ = input.readDouble();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 41
                case 49:
                  {
                    maxValue_ = input.readDouble();
                    bitField0_ |= 0x00000010;
                    break;
                  } // case 49
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int facetValueCase_ = 0;
        private java.lang.Object facetValue_;

        public FacetValueCase getFacetValueCase() {
          return FacetValueCase.forNumber(facetValueCase_);
        }

        public Builder clearFacetValue() {
          facetValueCase_ = 0;
          facetValue_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        /**
         *
         *
         * <pre>
         * Text value of a facet, such as "Black" for facet "colorFamilies".
         * </pre>
         *
         * <code>string value = 1;</code>
         *
         * @return Whether the value field is set.
         */
        @java.lang.Override
        public boolean hasValue() {
          return facetValueCase_ == 1;
        }
        /**
         *
         *
         * <pre>
         * Text value of a facet, such as "Black" for facet "colorFamilies".
         * </pre>
         *
         * <code>string value = 1;</code>
         *
         * @return The value.
         */
        @java.lang.Override
        public java.lang.String getValue() {
          java.lang.Object ref = "";
          if (facetValueCase_ == 1) {
            ref = facetValue_;
          }
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (facetValueCase_ == 1) {
              facetValue_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Text value of a facet, such as "Black" for facet "colorFamilies".
         * </pre>
         *
         * <code>string value = 1;</code>
         *
         * @return The bytes for value.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getValueBytes() {
          java.lang.Object ref = "";
          if (facetValueCase_ == 1) {
            ref = facetValue_;
          }
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            if (facetValueCase_ == 1) {
              facetValue_ = b;
            }
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Text value of a facet, such as "Black" for facet "colorFamilies".
         * </pre>
         *
         * <code>string value = 1;</code>
         *
         * @param value The value to set.
         * @return This builder for chaining.
         */
        public Builder setValue(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          facetValueCase_ = 1;
          facetValue_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Text value of a facet, such as "Black" for facet "colorFamilies".
         * </pre>
         *
         * <code>string value = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearValue() {
          if (facetValueCase_ == 1) {
            facetValueCase_ = 0;
            facetValue_ = null;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Text value of a facet, such as "Black" for facet "colorFamilies".
         * </pre>
         *
         * <code>string value = 1;</code>
         *
         * @param value The bytes for value to set.
         * @return This builder for chaining.
         */
        public Builder setValueBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          facetValueCase_ = 1;
          facetValue_ = value;
          onChanged();
          return this;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2.Interval,
                com.google.cloud.retail.v2.Interval.Builder,
                com.google.cloud.retail.v2.IntervalOrBuilder>
            intervalBuilder_;
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price".
         * </pre>
         *
         * <code>.google.cloud.retail.v2.Interval interval = 2;</code>
         *
         * @return Whether the interval field is set.
         */
        @java.lang.Override
        public boolean hasInterval() {
          return facetValueCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price".
         * </pre>
         *
         * <code>.google.cloud.retail.v2.Interval interval = 2;</code>
         *
         * @return The interval.
         */
        @java.lang.Override
        public com.google.cloud.retail.v2.Interval getInterval() {
          if (intervalBuilder_ == null) {
            if (facetValueCase_ == 2) {
              return (com.google.cloud.retail.v2.Interval) facetValue_;
            }
            return com.google.cloud.retail.v2.Interval.getDefaultInstance();
          } else {
            if (facetValueCase_ == 2) {
              return intervalBuilder_.getMessage();
            }
            return com.google.cloud.retail.v2.Interval.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price".
         * </pre>
         *
         * <code>.google.cloud.retail.v2.Interval interval = 2;</code>
         */
        public Builder setInterval(com.google.cloud.retail.v2.Interval value) {
          if (intervalBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            facetValue_ = value;
            onChanged();
          } else {
            intervalBuilder_.setMessage(value);
          }
          facetValueCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price".
         * </pre>
         *
         * <code>.google.cloud.retail.v2.Interval interval = 2;</code>
         */
        public Builder setInterval(com.google.cloud.retail.v2.Interval.Builder builderForValue) {
          if (intervalBuilder_ == null) {
            facetValue_ = builderForValue.build();
            onChanged();
          } else {
            intervalBuilder_.setMessage(builderForValue.build());
          }
          facetValueCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price".
         * </pre>
         *
         * <code>.google.cloud.retail.v2.Interval interval = 2;</code>
         */
        public Builder mergeInterval(com.google.cloud.retail.v2.Interval value) {
          if (intervalBuilder_ == null) {
            if (facetValueCase_ == 2
                && facetValue_ != com.google.cloud.retail.v2.Interval.getDefaultInstance()) {
              facetValue_ =
                  com.google.cloud.retail.v2.Interval.newBuilder(
                          (com.google.cloud.retail.v2.Interval) facetValue_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              facetValue_ = value;
            }
            onChanged();
          } else {
            if (facetValueCase_ == 2) {
              intervalBuilder_.mergeFrom(value);
            } else {
              intervalBuilder_.setMessage(value);
            }
          }
          facetValueCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price".
         * </pre>
         *
         * <code>.google.cloud.retail.v2.Interval interval = 2;</code>
         */
        public Builder clearInterval() {
          if (intervalBuilder_ == null) {
            if (facetValueCase_ == 2) {
              facetValueCase_ = 0;
              facetValue_ = null;
              onChanged();
            }
          } else {
            if (facetValueCase_ == 2) {
              facetValueCase_ = 0;
              facetValue_ = null;
            }
            intervalBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price".
         * </pre>
         *
         * <code>.google.cloud.retail.v2.Interval interval = 2;</code>
         */
        public com.google.cloud.retail.v2.Interval.Builder getIntervalBuilder() {
          return getIntervalFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price".
         * </pre>
         *
         * <code>.google.cloud.retail.v2.Interval interval = 2;</code>
         */
        @java.lang.Override
        public com.google.cloud.retail.v2.IntervalOrBuilder getIntervalOrBuilder() {
          if ((facetValueCase_ == 2) && (intervalBuilder_ != null)) {
            return intervalBuilder_.getMessageOrBuilder();
          } else {
            if (facetValueCase_ == 2) {
              return (com.google.cloud.retail.v2.Interval) facetValue_;
            }
            return com.google.cloud.retail.v2.Interval.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price".
         * </pre>
         *
         * <code>.google.cloud.retail.v2.Interval interval = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2.Interval,
                com.google.cloud.retail.v2.Interval.Builder,
                com.google.cloud.retail.v2.IntervalOrBuilder>
            getIntervalFieldBuilder() {
          if (intervalBuilder_ == null) {
            if (!(facetValueCase_ == 2)) {
              facetValue_ = com.google.cloud.retail.v2.Interval.getDefaultInstance();
            }
            intervalBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.retail.v2.Interval,
                    com.google.cloud.retail.v2.Interval.Builder,
                    com.google.cloud.retail.v2.IntervalOrBuilder>(
                    (com.google.cloud.retail.v2.Interval) facetValue_,
                    getParentForChildren(),
                    isClean());
            facetValue_ = null;
          }
          facetValueCase_ = 2;
          onChanged();
          return intervalBuilder_;
        }

        private long count_;
        /**
         *
         *
         * <pre>
         * Number of items that have this facet value.
         * </pre>
         *
         * <code>int64 count = 3;</code>
         *
         * @return The count.
         */
        @java.lang.Override
        public long getCount() {
          return count_;
        }
        /**
         *
         *
         * <pre>
         * Number of items that have this facet value.
         * </pre>
         *
         * <code>int64 count = 3;</code>
         *
         * @param value The count to set.
         * @return This builder for chaining.
         */
        public Builder setCount(long value) {

          count_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of items that have this facet value.
         * </pre>
         *
         * <code>int64 count = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCount() {
          bitField0_ = (bitField0_ & ~0x00000004);
          count_ = 0L;
          onChanged();
          return this;
        }

        private double minValue_;
        /**
         *
         *
         * <pre>
         * The minimum value in the
         * [FacetValue.interval][google.cloud.retail.v2.SearchResponse.Facet.FacetValue.interval].
         * Only supported on numerical facets and returned if
         * [SearchRequest.FacetSpec.FacetKey.return_min_max][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.return_min_max]
         * is true.
         * </pre>
         *
         * <code>double min_value = 5;</code>
         *
         * @return The minValue.
         */
        @java.lang.Override
        public double getMinValue() {
          return minValue_;
        }
        /**
         *
         *
         * <pre>
         * The minimum value in the
         * [FacetValue.interval][google.cloud.retail.v2.SearchResponse.Facet.FacetValue.interval].
         * Only supported on numerical facets and returned if
         * [SearchRequest.FacetSpec.FacetKey.return_min_max][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.return_min_max]
         * is true.
         * </pre>
         *
         * <code>double min_value = 5;</code>
         *
         * @param value The minValue to set.
         * @return This builder for chaining.
         */
        public Builder setMinValue(double value) {

          minValue_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The minimum value in the
         * [FacetValue.interval][google.cloud.retail.v2.SearchResponse.Facet.FacetValue.interval].
         * Only supported on numerical facets and returned if
         * [SearchRequest.FacetSpec.FacetKey.return_min_max][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.return_min_max]
         * is true.
         * </pre>
         *
         * <code>double min_value = 5;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMinValue() {
          bitField0_ = (bitField0_ & ~0x00000008);
          minValue_ = 0D;
          onChanged();
          return this;
        }

        private double maxValue_;
        /**
         *
         *
         * <pre>
         * The maximum value in the
         * [FacetValue.interval][google.cloud.retail.v2.SearchResponse.Facet.FacetValue.interval].
         * Only supported on numerical facets and returned if
         * [SearchRequest.FacetSpec.FacetKey.return_min_max][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.return_min_max]
         * is true.
         * </pre>
         *
         * <code>double max_value = 6;</code>
         *
         * @return The maxValue.
         */
        @java.lang.Override
        public double getMaxValue() {
          return maxValue_;
        }
        /**
         *
         *
         * <pre>
         * The maximum value in the
         * [FacetValue.interval][google.cloud.retail.v2.SearchResponse.Facet.FacetValue.interval].
         * Only supported on numerical facets and returned if
         * [SearchRequest.FacetSpec.FacetKey.return_min_max][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.return_min_max]
         * is true.
         * </pre>
         *
         * <code>double max_value = 6;</code>
         *
         * @param value The maxValue to set.
         * @return This builder for chaining.
         */
        public Builder setMaxValue(double value) {

          maxValue_ = value;
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The maximum value in the
         * [FacetValue.interval][google.cloud.retail.v2.SearchResponse.Facet.FacetValue.interval].
         * Only supported on numerical facets and returned if
         * [SearchRequest.FacetSpec.FacetKey.return_min_max][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.return_min_max]
         * is true.
         * </pre>
         *
         * <code>double max_value = 6;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMaxValue() {
          bitField0_ = (bitField0_ & ~0x00000010);
          maxValue_ = 0D;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.SearchResponse.Facet.FacetValue)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.SearchResponse.Facet.FacetValue)
      private static final com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue();
      }

      public static com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<FacetValue> PARSER =
          new com.google.protobuf.AbstractParser<FacetValue>() {
            @java.lang.Override
            public FacetValue parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<FacetValue> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<FacetValue> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int KEY_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object key_ = "";
    /**
     *
     *
     * <pre>
     * The key for this facet. E.g., "colorFamilies" or "price" or
     * "attributes.attr1".
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The key.
     */
    @java.lang.Override
    public java.lang.String getKey() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        key_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The key for this facet. E.g., "colorFamilies" or "price" or
     * "attributes.attr1".
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The bytes for key.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKeyBytes() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        key_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VALUES_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue> values_;
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue>
        getValuesList() {
      return values_;
    }
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.retail.v2.SearchResponse.Facet.FacetValueOrBuilder>
        getValuesOrBuilderList() {
      return values_;
    }
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
     */
    @java.lang.Override
    public int getValuesCount() {
      return values_.size();
    }
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue getValues(int index) {
      return values_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.SearchResponse.Facet.FacetValueOrBuilder getValuesOrBuilder(
        int index) {
      return values_.get(index);
    }

    public static final int DYNAMIC_FACET_FIELD_NUMBER = 3;
    private boolean dynamicFacet_ = false;
    /**
     *
     *
     * <pre>
     * Whether the facet is dynamically generated.
     * </pre>
     *
     * <code>bool dynamic_facet = 3;</code>
     *
     * @return The dynamicFacet.
     */
    @java.lang.Override
    public boolean getDynamicFacet() {
      return dynamicFacet_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, key_);
      }
      for (int i = 0; i < values_.size(); i++) {
        output.writeMessage(2, values_.get(i));
      }
      if (dynamicFacet_ != false) {
        output.writeBool(3, dynamicFacet_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, key_);
      }
      for (int i = 0; i < values_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, values_.get(i));
      }
      if (dynamicFacet_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, dynamicFacet_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2.SearchResponse.Facet)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2.SearchResponse.Facet other =
          (com.google.cloud.retail.v2.SearchResponse.Facet) obj;

      if (!getKey().equals(other.getKey())) return false;
      if (!getValuesList().equals(other.getValuesList())) return false;
      if (getDynamicFacet() != other.getDynamicFacet()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + KEY_FIELD_NUMBER;
      hash = (53 * hash) + getKey().hashCode();
      if (getValuesCount() > 0) {
        hash = (37 * hash) + VALUES_FIELD_NUMBER;
        hash = (53 * hash) + getValuesList().hashCode();
      }
      hash = (37 * hash) + DYNAMIC_FACET_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDynamicFacet());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2.SearchResponse.Facet parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.SearchResponse.Facet parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.SearchResponse.Facet parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.SearchResponse.Facet parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.SearchResponse.Facet parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.SearchResponse.Facet parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.SearchResponse.Facet parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.SearchResponse.Facet parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.SearchResponse.Facet parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.SearchResponse.Facet parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.SearchResponse.Facet parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.SearchResponse.Facet parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.retail.v2.SearchResponse.Facet prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A facet result.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2.SearchResponse.Facet}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.SearchResponse.Facet)
        com.google.cloud.retail.v2.SearchResponse.FacetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2.SearchServiceProto
            .internal_static_google_cloud_retail_v2_SearchResponse_Facet_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2.SearchServiceProto
            .internal_static_google_cloud_retail_v2_SearchResponse_Facet_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2.SearchResponse.Facet.class,
                com.google.cloud.retail.v2.SearchResponse.Facet.Builder.class);
      }

      // Construct using com.google.cloud.retail.v2.SearchResponse.Facet.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        key_ = "";
        if (valuesBuilder_ == null) {
          values_ = java.util.Collections.emptyList();
        } else {
          values_ = null;
          valuesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        dynamicFacet_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2.SearchServiceProto
            .internal_static_google_cloud_retail_v2_SearchResponse_Facet_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.SearchResponse.Facet getDefaultInstanceForType() {
        return com.google.cloud.retail.v2.SearchResponse.Facet.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.SearchResponse.Facet build() {
        com.google.cloud.retail.v2.SearchResponse.Facet result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.SearchResponse.Facet buildPartial() {
        com.google.cloud.retail.v2.SearchResponse.Facet result =
            new com.google.cloud.retail.v2.SearchResponse.Facet(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.retail.v2.SearchResponse.Facet result) {
        if (valuesBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            values_ = java.util.Collections.unmodifiableList(values_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.values_ = values_;
        } else {
          result.values_ = valuesBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.retail.v2.SearchResponse.Facet result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.key_ = key_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.dynamicFacet_ = dynamicFacet_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2.SearchResponse.Facet) {
          return mergeFrom((com.google.cloud.retail.v2.SearchResponse.Facet) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.retail.v2.SearchResponse.Facet other) {
        if (other == com.google.cloud.retail.v2.SearchResponse.Facet.getDefaultInstance())
          return this;
        if (!other.getKey().isEmpty()) {
          key_ = other.key_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (valuesBuilder_ == null) {
          if (!other.values_.isEmpty()) {
            if (values_.isEmpty()) {
              values_ = other.values_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureValuesIsMutable();
              values_.addAll(other.values_);
            }
            onChanged();
          }
        } else {
          if (!other.values_.isEmpty()) {
            if (valuesBuilder_.isEmpty()) {
              valuesBuilder_.dispose();
              valuesBuilder_ = null;
              values_ = other.values_;
              bitField0_ = (bitField0_ & ~0x00000002);
              valuesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getValuesFieldBuilder()
                      : null;
            } else {
              valuesBuilder_.addAllMessages(other.values_);
            }
          }
        }
        if (other.getDynamicFacet() != false) {
          setDynamicFacet(other.getDynamicFacet());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  key_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue m =
                      input.readMessage(
                          com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue.parser(),
                          extensionRegistry);
                  if (valuesBuilder_ == null) {
                    ensureValuesIsMutable();
                    values_.add(m);
                  } else {
                    valuesBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              case 24:
                {
                  dynamicFacet_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object key_ = "";
      /**
       *
       *
       * <pre>
       * The key for this facet. E.g., "colorFamilies" or "price" or
       * "attributes.attr1".
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return The key.
       */
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          key_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The key for this facet. E.g., "colorFamilies" or "price" or
       * "attributes.attr1".
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return The bytes for key.
       */
      public com.google.protobuf.ByteString getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The key for this facet. E.g., "colorFamilies" or "price" or
       * "attributes.attr1".
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @param value The key to set.
       * @return This builder for chaining.
       */
      public Builder setKey(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        key_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The key for this facet. E.g., "colorFamilies" or "price" or
       * "attributes.attr1".
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKey() {
        key_ = getDefaultInstance().getKey();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The key for this facet. E.g., "colorFamilies" or "price" or
       * "attributes.attr1".
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @param value The bytes for key to set.
       * @return This builder for chaining.
       */
      public Builder setKeyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        key_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue> values_ =
          java.util.Collections.emptyList();

      private void ensureValuesIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          values_ =
              new java.util.ArrayList<com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue>(
                  values_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue,
              com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue.Builder,
              com.google.cloud.retail.v2.SearchResponse.Facet.FacetValueOrBuilder>
          valuesBuilder_;

      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
       */
      public java.util.List<com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue>
          getValuesList() {
        if (valuesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(values_);
        } else {
          return valuesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
       */
      public int getValuesCount() {
        if (valuesBuilder_ == null) {
          return values_.size();
        } else {
          return valuesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
       */
      public com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue getValues(int index) {
        if (valuesBuilder_ == null) {
          return values_.get(index);
        } else {
          return valuesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
       */
      public Builder setValues(
          int index, com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue value) {
        if (valuesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValuesIsMutable();
          values_.set(index, value);
          onChanged();
        } else {
          valuesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
       */
      public Builder setValues(
          int index,
          com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue.Builder builderForValue) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          values_.set(index, builderForValue.build());
          onChanged();
        } else {
          valuesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
       */
      public Builder addValues(com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue value) {
        if (valuesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValuesIsMutable();
          values_.add(value);
          onChanged();
        } else {
          valuesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
       */
      public Builder addValues(
          int index, com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue value) {
        if (valuesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValuesIsMutable();
          values_.add(index, value);
          onChanged();
        } else {
          valuesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
       */
      public Builder addValues(
          com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue.Builder builderForValue) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          values_.add(builderForValue.build());
          onChanged();
        } else {
          valuesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
       */
      public Builder addValues(
          int index,
          com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue.Builder builderForValue) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          values_.add(index, builderForValue.build());
          onChanged();
        } else {
          valuesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
       */
      public Builder addAllValues(
          java.lang.Iterable<? extends com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue>
              values) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
          onChanged();
        } else {
          valuesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
       */
      public Builder clearValues() {
        if (valuesBuilder_ == null) {
          values_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          valuesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
       */
      public Builder removeValues(int index) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          values_.remove(index);
          onChanged();
        } else {
          valuesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
       */
      public com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue.Builder getValuesBuilder(
          int index) {
        return getValuesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
       */
      public com.google.cloud.retail.v2.SearchResponse.Facet.FacetValueOrBuilder getValuesOrBuilder(
          int index) {
        if (valuesBuilder_ == null) {
          return values_.get(index);
        } else {
          return valuesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
       */
      public java.util.List<
              ? extends com.google.cloud.retail.v2.SearchResponse.Facet.FacetValueOrBuilder>
          getValuesOrBuilderList() {
        if (valuesBuilder_ != null) {
          return valuesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(values_);
        }
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
       */
      public com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue.Builder addValuesBuilder() {
        return getValuesFieldBuilder()
            .addBuilder(
                com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
       */
      public com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue.Builder addValuesBuilder(
          int index) {
        return getValuesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet.FacetValue values = 2;</code>
       */
      public java.util.List<com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue.Builder>
          getValuesBuilderList() {
        return getValuesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue,
              com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue.Builder,
              com.google.cloud.retail.v2.SearchResponse.Facet.FacetValueOrBuilder>
          getValuesFieldBuilder() {
        if (valuesBuilder_ == null) {
          valuesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue,
                  com.google.cloud.retail.v2.SearchResponse.Facet.FacetValue.Builder,
                  com.google.cloud.retail.v2.SearchResponse.Facet.FacetValueOrBuilder>(
                  values_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          values_ = null;
        }
        return valuesBuilder_;
      }

      private boolean dynamicFacet_;
      /**
       *
       *
       * <pre>
       * Whether the facet is dynamically generated.
       * </pre>
       *
       * <code>bool dynamic_facet = 3;</code>
       *
       * @return The dynamicFacet.
       */
      @java.lang.Override
      public boolean getDynamicFacet() {
        return dynamicFacet_;
      }
      /**
       *
       *
       * <pre>
       * Whether the facet is dynamically generated.
       * </pre>
       *
       * <code>bool dynamic_facet = 3;</code>
       *
       * @param value The dynamicFacet to set.
       * @return This builder for chaining.
       */
      public Builder setDynamicFacet(boolean value) {

        dynamicFacet_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether the facet is dynamically generated.
       * </pre>
       *
       * <code>bool dynamic_facet = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDynamicFacet() {
        bitField0_ = (bitField0_ & ~0x00000004);
        dynamicFacet_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.SearchResponse.Facet)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.SearchResponse.Facet)
    private static final com.google.cloud.retail.v2.SearchResponse.Facet DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2.SearchResponse.Facet();
    }

    public static com.google.cloud.retail.v2.SearchResponse.Facet getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Facet> PARSER =
        new com.google.protobuf.AbstractParser<Facet>() {
          @java.lang.Override
          public Facet parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Facet> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Facet> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.SearchResponse.Facet getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface QueryExpansionInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2.SearchResponse.QueryExpansionInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Bool describing whether query expansion has occurred.
     * </pre>
     *
     * <code>bool expanded_query = 1;</code>
     *
     * @return The expandedQuery.
     */
    boolean getExpandedQuery();

    /**
     *
     *
     * <pre>
     * Number of pinned results. This field will only be set when expansion
     * happens and
     * [SearchRequest.QueryExpansionSpec.pin_unexpanded_results][google.cloud.retail.v2.SearchRequest.QueryExpansionSpec.pin_unexpanded_results]
     * is set to true.
     * </pre>
     *
     * <code>int64 pinned_result_count = 2;</code>
     *
     * @return The pinnedResultCount.
     */
    long getPinnedResultCount();
  }
  /**
   *
   *
   * <pre>
   * Information describing query expansion including whether expansion has
   * occurred.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2.SearchResponse.QueryExpansionInfo}
   */
  public static final class QueryExpansionInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.SearchResponse.QueryExpansionInfo)
      QueryExpansionInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use QueryExpansionInfo.newBuilder() to construct.
    private QueryExpansionInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private QueryExpansionInfo() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new QueryExpansionInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2.SearchServiceProto
          .internal_static_google_cloud_retail_v2_SearchResponse_QueryExpansionInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2.SearchServiceProto
          .internal_static_google_cloud_retail_v2_SearchResponse_QueryExpansionInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo.class,
              com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo.Builder.class);
    }

    public static final int EXPANDED_QUERY_FIELD_NUMBER = 1;
    private boolean expandedQuery_ = false;
    /**
     *
     *
     * <pre>
     * Bool describing whether query expansion has occurred.
     * </pre>
     *
     * <code>bool expanded_query = 1;</code>
     *
     * @return The expandedQuery.
     */
    @java.lang.Override
    public boolean getExpandedQuery() {
      return expandedQuery_;
    }

    public static final int PINNED_RESULT_COUNT_FIELD_NUMBER = 2;
    private long pinnedResultCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Number of pinned results. This field will only be set when expansion
     * happens and
     * [SearchRequest.QueryExpansionSpec.pin_unexpanded_results][google.cloud.retail.v2.SearchRequest.QueryExpansionSpec.pin_unexpanded_results]
     * is set to true.
     * </pre>
     *
     * <code>int64 pinned_result_count = 2;</code>
     *
     * @return The pinnedResultCount.
     */
    @java.lang.Override
    public long getPinnedResultCount() {
      return pinnedResultCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (expandedQuery_ != false) {
        output.writeBool(1, expandedQuery_);
      }
      if (pinnedResultCount_ != 0L) {
        output.writeInt64(2, pinnedResultCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (expandedQuery_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, expandedQuery_);
      }
      if (pinnedResultCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, pinnedResultCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo other =
          (com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo) obj;

      if (getExpandedQuery() != other.getExpandedQuery()) return false;
      if (getPinnedResultCount() != other.getPinnedResultCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + EXPANDED_QUERY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getExpandedQuery());
      hash = (37 * hash) + PINNED_RESULT_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPinnedResultCount());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Information describing query expansion including whether expansion has
     * occurred.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2.SearchResponse.QueryExpansionInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.SearchResponse.QueryExpansionInfo)
        com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2.SearchServiceProto
            .internal_static_google_cloud_retail_v2_SearchResponse_QueryExpansionInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2.SearchServiceProto
            .internal_static_google_cloud_retail_v2_SearchResponse_QueryExpansionInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo.class,
                com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo.Builder.class);
      }

      // Construct using com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        expandedQuery_ = false;
        pinnedResultCount_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2.SearchServiceProto
            .internal_static_google_cloud_retail_v2_SearchResponse_QueryExpansionInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo
          getDefaultInstanceForType() {
        return com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo build() {
        com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo buildPartial() {
        com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo result =
            new com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.expandedQuery_ = expandedQuery_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.pinnedResultCount_ = pinnedResultCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo) {
          return mergeFrom((com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo other) {
        if (other
            == com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo.getDefaultInstance())
          return this;
        if (other.getExpandedQuery() != false) {
          setExpandedQuery(other.getExpandedQuery());
        }
        if (other.getPinnedResultCount() != 0L) {
          setPinnedResultCount(other.getPinnedResultCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  expandedQuery_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  pinnedResultCount_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean expandedQuery_;
      /**
       *
       *
       * <pre>
       * Bool describing whether query expansion has occurred.
       * </pre>
       *
       * <code>bool expanded_query = 1;</code>
       *
       * @return The expandedQuery.
       */
      @java.lang.Override
      public boolean getExpandedQuery() {
        return expandedQuery_;
      }
      /**
       *
       *
       * <pre>
       * Bool describing whether query expansion has occurred.
       * </pre>
       *
       * <code>bool expanded_query = 1;</code>
       *
       * @param value The expandedQuery to set.
       * @return This builder for chaining.
       */
      public Builder setExpandedQuery(boolean value) {

        expandedQuery_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Bool describing whether query expansion has occurred.
       * </pre>
       *
       * <code>bool expanded_query = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExpandedQuery() {
        bitField0_ = (bitField0_ & ~0x00000001);
        expandedQuery_ = false;
        onChanged();
        return this;
      }

      private long pinnedResultCount_;
      /**
       *
       *
       * <pre>
       * Number of pinned results. This field will only be set when expansion
       * happens and
       * [SearchRequest.QueryExpansionSpec.pin_unexpanded_results][google.cloud.retail.v2.SearchRequest.QueryExpansionSpec.pin_unexpanded_results]
       * is set to true.
       * </pre>
       *
       * <code>int64 pinned_result_count = 2;</code>
       *
       * @return The pinnedResultCount.
       */
      @java.lang.Override
      public long getPinnedResultCount() {
        return pinnedResultCount_;
      }
      /**
       *
       *
       * <pre>
       * Number of pinned results. This field will only be set when expansion
       * happens and
       * [SearchRequest.QueryExpansionSpec.pin_unexpanded_results][google.cloud.retail.v2.SearchRequest.QueryExpansionSpec.pin_unexpanded_results]
       * is set to true.
       * </pre>
       *
       * <code>int64 pinned_result_count = 2;</code>
       *
       * @param value The pinnedResultCount to set.
       * @return This builder for chaining.
       */
      public Builder setPinnedResultCount(long value) {

        pinnedResultCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Number of pinned results. This field will only be set when expansion
       * happens and
       * [SearchRequest.QueryExpansionSpec.pin_unexpanded_results][google.cloud.retail.v2.SearchRequest.QueryExpansionSpec.pin_unexpanded_results]
       * is set to true.
       * </pre>
       *
       * <code>int64 pinned_result_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPinnedResultCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        pinnedResultCount_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.SearchResponse.QueryExpansionInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.SearchResponse.QueryExpansionInfo)
    private static final com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo();
    }

    public static com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<QueryExpansionInfo> PARSER =
        new com.google.protobuf.AbstractParser<QueryExpansionInfo>() {
          @java.lang.Override
          public QueryExpansionInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<QueryExpansionInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<QueryExpansionInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ConversationalSearchResultOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2.SearchResponse.ConversationalSearchResult)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Conversation UUID. This field will be stored in client side storage to
     * maintain the conversation session with server and will be used for next
     * search request's
     * [SearchRequest.ConversationalSearchSpec.conversation_id][google.cloud.retail.v2.SearchRequest.ConversationalSearchSpec.conversation_id]
     * to restore conversation state in server.
     * </pre>
     *
     * <code>string conversation_id = 1;</code>
     *
     * @return The conversationId.
     */
    java.lang.String getConversationId();
    /**
     *
     *
     * <pre>
     * Conversation UUID. This field will be stored in client side storage to
     * maintain the conversation session with server and will be used for next
     * search request's
     * [SearchRequest.ConversationalSearchSpec.conversation_id][google.cloud.retail.v2.SearchRequest.ConversationalSearchSpec.conversation_id]
     * to restore conversation state in server.
     * </pre>
     *
     * <code>string conversation_id = 1;</code>
     *
     * @return The bytes for conversationId.
     */
    com.google.protobuf.ByteString getConversationIdBytes();

    /**
     *
     *
     * <pre>
     * The current refined query for the conversational search. This field
     * will be used in customer UI that the query in the search bar should be
     * replaced with the refined query. For example, if
     * [SearchRequest.query][google.cloud.retail.v2.SearchRequest.query] is
     * `dress` and next
     * [SearchRequest.ConversationalSearchSpec.UserAnswer.text_answer][google.cloud.retail.v2.SearchRequest.ConversationalSearchSpec.UserAnswer.text_answer]
     * is `red color`, which does not match any product attribute value filters,
     * the refined query will be `dress, red color`.
     * </pre>
     *
     * <code>string refined_query = 2;</code>
     *
     * @return The refinedQuery.
     */
    java.lang.String getRefinedQuery();
    /**
     *
     *
     * <pre>
     * The current refined query for the conversational search. This field
     * will be used in customer UI that the query in the search bar should be
     * replaced with the refined query. For example, if
     * [SearchRequest.query][google.cloud.retail.v2.SearchRequest.query] is
     * `dress` and next
     * [SearchRequest.ConversationalSearchSpec.UserAnswer.text_answer][google.cloud.retail.v2.SearchRequest.ConversationalSearchSpec.UserAnswer.text_answer]
     * is `red color`, which does not match any product attribute value filters,
     * the refined query will be `dress, red color`.
     * </pre>
     *
     * <code>string refined_query = 2;</code>
     *
     * @return The bytes for refinedQuery.
     */
    com.google.protobuf.ByteString getRefinedQueryBytes();

    /**
     *
     *
     * <pre>
     * This field is deprecated but will be kept for backward compatibility.
     * There is expected to have only one additional filter and the value will
     * be the same to the same as field `additional_filter`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    java.util.List<
            com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter>
        getAdditionalFiltersList();
    /**
     *
     *
     * <pre>
     * This field is deprecated but will be kept for backward compatibility.
     * There is expected to have only one additional filter and the value will
     * be the same to the same as field `additional_filter`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
        getAdditionalFilters(int index);
    /**
     *
     *
     * <pre>
     * This field is deprecated but will be kept for backward compatibility.
     * There is expected to have only one additional filter and the value will
     * be the same to the same as field `additional_filter`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    int getAdditionalFiltersCount();
    /**
     *
     *
     * <pre>
     * This field is deprecated but will be kept for backward compatibility.
     * There is expected to have only one additional filter and the value will
     * be the same to the same as field `additional_filter`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    java.util.List<
            ? extends
                com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                    .AdditionalFilterOrBuilder>
        getAdditionalFiltersOrBuilderList();
    /**
     *
     *
     * <pre>
     * This field is deprecated but will be kept for backward compatibility.
     * There is expected to have only one additional filter and the value will
     * be the same to the same as field `additional_filter`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilterOrBuilder
        getAdditionalFiltersOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * The follow-up question. e.g., `What is the color?`
     * </pre>
     *
     * <code>string followup_question = 4;</code>
     *
     * @return The followupQuestion.
     */
    java.lang.String getFollowupQuestion();
    /**
     *
     *
     * <pre>
     * The follow-up question. e.g., `What is the color?`
     * </pre>
     *
     * <code>string followup_question = 4;</code>
     *
     * @return The bytes for followupQuestion.
     */
    com.google.protobuf.ByteString getFollowupQuestionBytes();

    /**
     *
     *
     * <pre>
     * The answer options provided to client for the follow-up question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
     * </code>
     */
    java.util.List<
            com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer>
        getSuggestedAnswersList();
    /**
     *
     *
     * <pre>
     * The answer options provided to client for the follow-up question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
     * </code>
     */
    com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
        getSuggestedAnswers(int index);
    /**
     *
     *
     * <pre>
     * The answer options provided to client for the follow-up question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
     * </code>
     */
    int getSuggestedAnswersCount();
    /**
     *
     *
     * <pre>
     * The answer options provided to client for the follow-up question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                    .SuggestedAnswerOrBuilder>
        getSuggestedAnswersOrBuilderList();
    /**
     *
     *
     * <pre>
     * The answer options provided to client for the follow-up question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
     * </code>
     */
    com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswerOrBuilder
        getSuggestedAnswersOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * This is the incremental additional filters implied from the current
     * user answer. User should add the suggested addition filters to the
     * previous
     * [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter],  and
     * use the merged filter in the follow up search request.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filter = 6;
     * </code>
     *
     * @return Whether the additionalFilter field is set.
     */
    boolean hasAdditionalFilter();
    /**
     *
     *
     * <pre>
     * This is the incremental additional filters implied from the current
     * user answer. User should add the suggested addition filters to the
     * previous
     * [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter],  and
     * use the merged filter in the follow up search request.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filter = 6;
     * </code>
     *
     * @return The additionalFilter.
     */
    com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
        getAdditionalFilter();
    /**
     *
     *
     * <pre>
     * This is the incremental additional filters implied from the current
     * user answer. User should add the suggested addition filters to the
     * previous
     * [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter],  and
     * use the merged filter in the follow up search request.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filter = 6;
     * </code>
     */
    com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilterOrBuilder
        getAdditionalFilterOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * This field specifies all related information that is needed on client
   * side for UI rendering of conversational retail search.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2.SearchResponse.ConversationalSearchResult}
   */
  public static final class ConversationalSearchResult
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.SearchResponse.ConversationalSearchResult)
      ConversationalSearchResultOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ConversationalSearchResult.newBuilder() to construct.
    private ConversationalSearchResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ConversationalSearchResult() {
      conversationId_ = "";
      refinedQuery_ = "";
      additionalFilters_ = java.util.Collections.emptyList();
      followupQuestion_ = "";
      suggestedAnswers_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ConversationalSearchResult();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2.SearchServiceProto
          .internal_static_google_cloud_retail_v2_SearchResponse_ConversationalSearchResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2.SearchServiceProto
          .internal_static_google_cloud_retail_v2_SearchResponse_ConversationalSearchResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.class,
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.Builder.class);
    }

    public interface SuggestedAnswerOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Product attribute value, including an attribute key and an
       * attribute value. Other types can be added here in the future.
       * </pre>
       *
       * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
       *
       * @return Whether the productAttributeValue field is set.
       */
      boolean hasProductAttributeValue();
      /**
       *
       *
       * <pre>
       * Product attribute value, including an attribute key and an
       * attribute value. Other types can be added here in the future.
       * </pre>
       *
       * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
       *
       * @return The productAttributeValue.
       */
      com.google.cloud.retail.v2.ProductAttributeValue getProductAttributeValue();
      /**
       *
       *
       * <pre>
       * Product attribute value, including an attribute key and an
       * attribute value. Other types can be added here in the future.
       * </pre>
       *
       * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
       */
      com.google.cloud.retail.v2.ProductAttributeValueOrBuilder getProductAttributeValueOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * Suggested answers to the follow-up question.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer}
     */
    public static final class SuggestedAnswer extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer)
        SuggestedAnswerOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use SuggestedAnswer.newBuilder() to construct.
      private SuggestedAnswer(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private SuggestedAnswer() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new SuggestedAnswer();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2.SearchServiceProto
            .internal_static_google_cloud_retail_v2_SearchResponse_ConversationalSearchResult_SuggestedAnswer_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2.SearchServiceProto
            .internal_static_google_cloud_retail_v2_SearchResponse_ConversationalSearchResult_SuggestedAnswer_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
                    .class,
                com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
                    .Builder.class);
      }

      private int bitField0_;
      public static final int PRODUCT_ATTRIBUTE_VALUE_FIELD_NUMBER = 1;
      private com.google.cloud.retail.v2.ProductAttributeValue productAttributeValue_;
      /**
       *
       *
       * <pre>
       * Product attribute value, including an attribute key and an
       * attribute value. Other types can be added here in the future.
       * </pre>
       *
       * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
       *
       * @return Whether the productAttributeValue field is set.
       */
      @java.lang.Override
      public boolean hasProductAttributeValue() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Product attribute value, including an attribute key and an
       * attribute value. Other types can be added here in the future.
       * </pre>
       *
       * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
       *
       * @return The productAttributeValue.
       */
      @java.lang.Override
      public com.google.cloud.retail.v2.ProductAttributeValue getProductAttributeValue() {
        return productAttributeValue_ == null
            ? com.google.cloud.retail.v2.ProductAttributeValue.getDefaultInstance()
            : productAttributeValue_;
      }
      /**
       *
       *
       * <pre>
       * Product attribute value, including an attribute key and an
       * attribute value. Other types can be added here in the future.
       * </pre>
       *
       * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.retail.v2.ProductAttributeValueOrBuilder
          getProductAttributeValueOrBuilder() {
        return productAttributeValue_ == null
            ? com.google.cloud.retail.v2.ProductAttributeValue.getDefaultInstance()
            : productAttributeValue_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getProductAttributeValue());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  1, getProductAttributeValue());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer)) {
          return super.equals(obj);
        }
        com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer other =
            (com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer)
                obj;

        if (hasProductAttributeValue() != other.hasProductAttributeValue()) return false;
        if (hasProductAttributeValue()) {
          if (!getProductAttributeValue().equals(other.getProductAttributeValue())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasProductAttributeValue()) {
          hash = (37 * hash) + PRODUCT_ATTRIBUTE_VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getProductAttributeValue().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .SuggestedAnswer
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .SuggestedAnswer
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .SuggestedAnswer
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .SuggestedAnswer
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .SuggestedAnswer
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .SuggestedAnswer
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .SuggestedAnswer
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .SuggestedAnswer
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .SuggestedAnswer
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .SuggestedAnswer
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .SuggestedAnswer
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .SuggestedAnswer
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Suggested answers to the follow-up question.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer)
          com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .SuggestedAnswerOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.retail.v2.SearchServiceProto
              .internal_static_google_cloud_retail_v2_SearchResponse_ConversationalSearchResult_SuggestedAnswer_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.retail.v2.SearchServiceProto
              .internal_static_google_cloud_retail_v2_SearchResponse_ConversationalSearchResult_SuggestedAnswer_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                      .SuggestedAnswer.class,
                  com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                      .SuggestedAnswer.Builder.class);
        }

        // Construct using
        // com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getProductAttributeValueFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          productAttributeValue_ = null;
          if (productAttributeValueBuilder_ != null) {
            productAttributeValueBuilder_.dispose();
            productAttributeValueBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.retail.v2.SearchServiceProto
              .internal_static_google_cloud_retail_v2_SearchResponse_ConversationalSearchResult_SuggestedAnswer_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
            getDefaultInstanceForType() {
          return com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .SuggestedAnswer.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
            build() {
          com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
            buildPartial() {
          com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
              result =
                  new com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                      .SuggestedAnswer(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
                result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.productAttributeValue_ =
                productAttributeValueBuilder_ == null
                    ? productAttributeValue_
                    : productAttributeValueBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                  .SuggestedAnswer) {
            return mergeFrom(
                (com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                        .SuggestedAnswer)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
                other) {
          if (other
              == com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                  .SuggestedAnswer.getDefaultInstance()) return this;
          if (other.hasProductAttributeValue()) {
            mergeProductAttributeValue(other.getProductAttributeValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(
                        getProductAttributeValueFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.retail.v2.ProductAttributeValue productAttributeValue_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2.ProductAttributeValue,
                com.google.cloud.retail.v2.ProductAttributeValue.Builder,
                com.google.cloud.retail.v2.ProductAttributeValueOrBuilder>
            productAttributeValueBuilder_;
        /**
         *
         *
         * <pre>
         * Product attribute value, including an attribute key and an
         * attribute value. Other types can be added here in the future.
         * </pre>
         *
         * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
         *
         * @return Whether the productAttributeValue field is set.
         */
        public boolean hasProductAttributeValue() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * Product attribute value, including an attribute key and an
         * attribute value. Other types can be added here in the future.
         * </pre>
         *
         * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
         *
         * @return The productAttributeValue.
         */
        public com.google.cloud.retail.v2.ProductAttributeValue getProductAttributeValue() {
          if (productAttributeValueBuilder_ == null) {
            return productAttributeValue_ == null
                ? com.google.cloud.retail.v2.ProductAttributeValue.getDefaultInstance()
                : productAttributeValue_;
          } else {
            return productAttributeValueBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Product attribute value, including an attribute key and an
         * attribute value. Other types can be added here in the future.
         * </pre>
         *
         * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
         */
        public Builder setProductAttributeValue(
            com.google.cloud.retail.v2.ProductAttributeValue value) {
          if (productAttributeValueBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            productAttributeValue_ = value;
          } else {
            productAttributeValueBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Product attribute value, including an attribute key and an
         * attribute value. Other types can be added here in the future.
         * </pre>
         *
         * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
         */
        public Builder setProductAttributeValue(
            com.google.cloud.retail.v2.ProductAttributeValue.Builder builderForValue) {
          if (productAttributeValueBuilder_ == null) {
            productAttributeValue_ = builderForValue.build();
          } else {
            productAttributeValueBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Product attribute value, including an attribute key and an
         * attribute value. Other types can be added here in the future.
         * </pre>
         *
         * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
         */
        public Builder mergeProductAttributeValue(
            com.google.cloud.retail.v2.ProductAttributeValue value) {
          if (productAttributeValueBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && productAttributeValue_ != null
                && productAttributeValue_
                    != com.google.cloud.retail.v2.ProductAttributeValue.getDefaultInstance()) {
              getProductAttributeValueBuilder().mergeFrom(value);
            } else {
              productAttributeValue_ = value;
            }
          } else {
            productAttributeValueBuilder_.mergeFrom(value);
          }
          if (productAttributeValue_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Product attribute value, including an attribute key and an
         * attribute value. Other types can be added here in the future.
         * </pre>
         *
         * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
         */
        public Builder clearProductAttributeValue() {
          bitField0_ = (bitField0_ & ~0x00000001);
          productAttributeValue_ = null;
          if (productAttributeValueBuilder_ != null) {
            productAttributeValueBuilder_.dispose();
            productAttributeValueBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Product attribute value, including an attribute key and an
         * attribute value. Other types can be added here in the future.
         * </pre>
         *
         * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
         */
        public com.google.cloud.retail.v2.ProductAttributeValue.Builder
            getProductAttributeValueBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getProductAttributeValueFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Product attribute value, including an attribute key and an
         * attribute value. Other types can be added here in the future.
         * </pre>
         *
         * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
         */
        public com.google.cloud.retail.v2.ProductAttributeValueOrBuilder
            getProductAttributeValueOrBuilder() {
          if (productAttributeValueBuilder_ != null) {
            return productAttributeValueBuilder_.getMessageOrBuilder();
          } else {
            return productAttributeValue_ == null
                ? com.google.cloud.retail.v2.ProductAttributeValue.getDefaultInstance()
                : productAttributeValue_;
          }
        }
        /**
         *
         *
         * <pre>
         * Product attribute value, including an attribute key and an
         * attribute value. Other types can be added here in the future.
         * </pre>
         *
         * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2.ProductAttributeValue,
                com.google.cloud.retail.v2.ProductAttributeValue.Builder,
                com.google.cloud.retail.v2.ProductAttributeValueOrBuilder>
            getProductAttributeValueFieldBuilder() {
          if (productAttributeValueBuilder_ == null) {
            productAttributeValueBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.retail.v2.ProductAttributeValue,
                    com.google.cloud.retail.v2.ProductAttributeValue.Builder,
                    com.google.cloud.retail.v2.ProductAttributeValueOrBuilder>(
                    getProductAttributeValue(), getParentForChildren(), isClean());
            productAttributeValue_ = null;
          }
          return productAttributeValueBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer)
      private static final com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .SuggestedAnswer
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                .SuggestedAnswer();
      }

      public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .SuggestedAnswer
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<SuggestedAnswer> PARSER =
          new com.google.protobuf.AbstractParser<SuggestedAnswer>() {
            @java.lang.Override
            public SuggestedAnswer parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<SuggestedAnswer> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<SuggestedAnswer> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface AdditionalFilterOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Product attribute value, including an attribute key and an
       * attribute value. Other types can be added here in the future.
       * </pre>
       *
       * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
       *
       * @return Whether the productAttributeValue field is set.
       */
      boolean hasProductAttributeValue();
      /**
       *
       *
       * <pre>
       * Product attribute value, including an attribute key and an
       * attribute value. Other types can be added here in the future.
       * </pre>
       *
       * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
       *
       * @return The productAttributeValue.
       */
      com.google.cloud.retail.v2.ProductAttributeValue getProductAttributeValue();
      /**
       *
       *
       * <pre>
       * Product attribute value, including an attribute key and an
       * attribute value. Other types can be added here in the future.
       * </pre>
       *
       * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
       */
      com.google.cloud.retail.v2.ProductAttributeValueOrBuilder getProductAttributeValueOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * Additional filter that client side need to apply.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter}
     */
    public static final class AdditionalFilter extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter)
        AdditionalFilterOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use AdditionalFilter.newBuilder() to construct.
      private AdditionalFilter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private AdditionalFilter() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new AdditionalFilter();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2.SearchServiceProto
            .internal_static_google_cloud_retail_v2_SearchResponse_ConversationalSearchResult_AdditionalFilter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2.SearchServiceProto
            .internal_static_google_cloud_retail_v2_SearchResponse_ConversationalSearchResult_AdditionalFilter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                    .AdditionalFilter.class,
                com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                    .AdditionalFilter.Builder.class);
      }

      private int bitField0_;
      public static final int PRODUCT_ATTRIBUTE_VALUE_FIELD_NUMBER = 1;
      private com.google.cloud.retail.v2.ProductAttributeValue productAttributeValue_;
      /**
       *
       *
       * <pre>
       * Product attribute value, including an attribute key and an
       * attribute value. Other types can be added here in the future.
       * </pre>
       *
       * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
       *
       * @return Whether the productAttributeValue field is set.
       */
      @java.lang.Override
      public boolean hasProductAttributeValue() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Product attribute value, including an attribute key and an
       * attribute value. Other types can be added here in the future.
       * </pre>
       *
       * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
       *
       * @return The productAttributeValue.
       */
      @java.lang.Override
      public com.google.cloud.retail.v2.ProductAttributeValue getProductAttributeValue() {
        return productAttributeValue_ == null
            ? com.google.cloud.retail.v2.ProductAttributeValue.getDefaultInstance()
            : productAttributeValue_;
      }
      /**
       *
       *
       * <pre>
       * Product attribute value, including an attribute key and an
       * attribute value. Other types can be added here in the future.
       * </pre>
       *
       * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.retail.v2.ProductAttributeValueOrBuilder
          getProductAttributeValueOrBuilder() {
        return productAttributeValue_ == null
            ? com.google.cloud.retail.v2.ProductAttributeValue.getDefaultInstance()
            : productAttributeValue_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getProductAttributeValue());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  1, getProductAttributeValue());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                .AdditionalFilter)) {
          return super.equals(obj);
        }
        com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
            other =
                (com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                        .AdditionalFilter)
                    obj;

        if (hasProductAttributeValue() != other.hasProductAttributeValue()) return false;
        if (hasProductAttributeValue()) {
          if (!getProductAttributeValue().equals(other.getProductAttributeValue())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasProductAttributeValue()) {
          hash = (37 * hash) + PRODUCT_ATTRIBUTE_VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getProductAttributeValue().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .AdditionalFilter
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .AdditionalFilter
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .AdditionalFilter
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .AdditionalFilter
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .AdditionalFilter
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .AdditionalFilter
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .AdditionalFilter
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .AdditionalFilter
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .AdditionalFilter
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .AdditionalFilter
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .AdditionalFilter
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .AdditionalFilter
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Additional filter that client side need to apply.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter)
          com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .AdditionalFilterOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.retail.v2.SearchServiceProto
              .internal_static_google_cloud_retail_v2_SearchResponse_ConversationalSearchResult_AdditionalFilter_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.retail.v2.SearchServiceProto
              .internal_static_google_cloud_retail_v2_SearchResponse_ConversationalSearchResult_AdditionalFilter_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                      .AdditionalFilter.class,
                  com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                      .AdditionalFilter.Builder.class);
        }

        // Construct using
        // com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getProductAttributeValueFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          productAttributeValue_ = null;
          if (productAttributeValueBuilder_ != null) {
            productAttributeValueBuilder_.dispose();
            productAttributeValueBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.retail.v2.SearchServiceProto
              .internal_static_google_cloud_retail_v2_SearchResponse_ConversationalSearchResult_AdditionalFilter_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
            getDefaultInstanceForType() {
          return com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .AdditionalFilter.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
            build() {
          com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
            buildPartial() {
          com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
              result =
                  new com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                      .AdditionalFilter(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
                result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.productAttributeValue_ =
                productAttributeValueBuilder_ == null
                    ? productAttributeValue_
                    : productAttributeValueBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                  .AdditionalFilter) {
            return mergeFrom(
                (com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                        .AdditionalFilter)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
                other) {
          if (other
              == com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                  .AdditionalFilter.getDefaultInstance()) return this;
          if (other.hasProductAttributeValue()) {
            mergeProductAttributeValue(other.getProductAttributeValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(
                        getProductAttributeValueFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.retail.v2.ProductAttributeValue productAttributeValue_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2.ProductAttributeValue,
                com.google.cloud.retail.v2.ProductAttributeValue.Builder,
                com.google.cloud.retail.v2.ProductAttributeValueOrBuilder>
            productAttributeValueBuilder_;
        /**
         *
         *
         * <pre>
         * Product attribute value, including an attribute key and an
         * attribute value. Other types can be added here in the future.
         * </pre>
         *
         * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
         *
         * @return Whether the productAttributeValue field is set.
         */
        public boolean hasProductAttributeValue() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * Product attribute value, including an attribute key and an
         * attribute value. Other types can be added here in the future.
         * </pre>
         *
         * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
         *
         * @return The productAttributeValue.
         */
        public com.google.cloud.retail.v2.ProductAttributeValue getProductAttributeValue() {
          if (productAttributeValueBuilder_ == null) {
            return productAttributeValue_ == null
                ? com.google.cloud.retail.v2.ProductAttributeValue.getDefaultInstance()
                : productAttributeValue_;
          } else {
            return productAttributeValueBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Product attribute value, including an attribute key and an
         * attribute value. Other types can be added here in the future.
         * </pre>
         *
         * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
         */
        public Builder setProductAttributeValue(
            com.google.cloud.retail.v2.ProductAttributeValue value) {
          if (productAttributeValueBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            productAttributeValue_ = value;
          } else {
            productAttributeValueBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Product attribute value, including an attribute key and an
         * attribute value. Other types can be added here in the future.
         * </pre>
         *
         * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
         */
        public Builder setProductAttributeValue(
            com.google.cloud.retail.v2.ProductAttributeValue.Builder builderForValue) {
          if (productAttributeValueBuilder_ == null) {
            productAttributeValue_ = builderForValue.build();
          } else {
            productAttributeValueBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Product attribute value, including an attribute key and an
         * attribute value. Other types can be added here in the future.
         * </pre>
         *
         * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
         */
        public Builder mergeProductAttributeValue(
            com.google.cloud.retail.v2.ProductAttributeValue value) {
          if (productAttributeValueBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && productAttributeValue_ != null
                && productAttributeValue_
                    != com.google.cloud.retail.v2.ProductAttributeValue.getDefaultInstance()) {
              getProductAttributeValueBuilder().mergeFrom(value);
            } else {
              productAttributeValue_ = value;
            }
          } else {
            productAttributeValueBuilder_.mergeFrom(value);
          }
          if (productAttributeValue_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Product attribute value, including an attribute key and an
         * attribute value. Other types can be added here in the future.
         * </pre>
         *
         * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
         */
        public Builder clearProductAttributeValue() {
          bitField0_ = (bitField0_ & ~0x00000001);
          productAttributeValue_ = null;
          if (productAttributeValueBuilder_ != null) {
            productAttributeValueBuilder_.dispose();
            productAttributeValueBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Product attribute value, including an attribute key and an
         * attribute value. Other types can be added here in the future.
         * </pre>
         *
         * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
         */
        public com.google.cloud.retail.v2.ProductAttributeValue.Builder
            getProductAttributeValueBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getProductAttributeValueFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Product attribute value, including an attribute key and an
         * attribute value. Other types can be added here in the future.
         * </pre>
         *
         * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
         */
        public com.google.cloud.retail.v2.ProductAttributeValueOrBuilder
            getProductAttributeValueOrBuilder() {
          if (productAttributeValueBuilder_ != null) {
            return productAttributeValueBuilder_.getMessageOrBuilder();
          } else {
            return productAttributeValue_ == null
                ? com.google.cloud.retail.v2.ProductAttributeValue.getDefaultInstance()
                : productAttributeValue_;
          }
        }
        /**
         *
         *
         * <pre>
         * Product attribute value, including an attribute key and an
         * attribute value. Other types can be added here in the future.
         * </pre>
         *
         * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2.ProductAttributeValue,
                com.google.cloud.retail.v2.ProductAttributeValue.Builder,
                com.google.cloud.retail.v2.ProductAttributeValueOrBuilder>
            getProductAttributeValueFieldBuilder() {
          if (productAttributeValueBuilder_ == null) {
            productAttributeValueBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.retail.v2.ProductAttributeValue,
                    com.google.cloud.retail.v2.ProductAttributeValue.Builder,
                    com.google.cloud.retail.v2.ProductAttributeValueOrBuilder>(
                    getProductAttributeValue(), getParentForChildren(), isClean());
            productAttributeValue_ = null;
          }
          return productAttributeValueBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter)
      private static final com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .AdditionalFilter
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                .AdditionalFilter();
      }

      public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .AdditionalFilter
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<AdditionalFilter> PARSER =
          new com.google.protobuf.AbstractParser<AdditionalFilter>() {
            @java.lang.Override
            public AdditionalFilter parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<AdditionalFilter> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<AdditionalFilter> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int CONVERSATION_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object conversationId_ = "";
    /**
     *
     *
     * <pre>
     * Conversation UUID. This field will be stored in client side storage to
     * maintain the conversation session with server and will be used for next
     * search request's
     * [SearchRequest.ConversationalSearchSpec.conversation_id][google.cloud.retail.v2.SearchRequest.ConversationalSearchSpec.conversation_id]
     * to restore conversation state in server.
     * </pre>
     *
     * <code>string conversation_id = 1;</code>
     *
     * @return The conversationId.
     */
    @java.lang.Override
    public java.lang.String getConversationId() {
      java.lang.Object ref = conversationId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        conversationId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Conversation UUID. This field will be stored in client side storage to
     * maintain the conversation session with server and will be used for next
     * search request's
     * [SearchRequest.ConversationalSearchSpec.conversation_id][google.cloud.retail.v2.SearchRequest.ConversationalSearchSpec.conversation_id]
     * to restore conversation state in server.
     * </pre>
     *
     * <code>string conversation_id = 1;</code>
     *
     * @return The bytes for conversationId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getConversationIdBytes() {
      java.lang.Object ref = conversationId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        conversationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int REFINED_QUERY_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object refinedQuery_ = "";
    /**
     *
     *
     * <pre>
     * The current refined query for the conversational search. This field
     * will be used in customer UI that the query in the search bar should be
     * replaced with the refined query. For example, if
     * [SearchRequest.query][google.cloud.retail.v2.SearchRequest.query] is
     * `dress` and next
     * [SearchRequest.ConversationalSearchSpec.UserAnswer.text_answer][google.cloud.retail.v2.SearchRequest.ConversationalSearchSpec.UserAnswer.text_answer]
     * is `red color`, which does not match any product attribute value filters,
     * the refined query will be `dress, red color`.
     * </pre>
     *
     * <code>string refined_query = 2;</code>
     *
     * @return The refinedQuery.
     */
    @java.lang.Override
    public java.lang.String getRefinedQuery() {
      java.lang.Object ref = refinedQuery_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        refinedQuery_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The current refined query for the conversational search. This field
     * will be used in customer UI that the query in the search bar should be
     * replaced with the refined query. For example, if
     * [SearchRequest.query][google.cloud.retail.v2.SearchRequest.query] is
     * `dress` and next
     * [SearchRequest.ConversationalSearchSpec.UserAnswer.text_answer][google.cloud.retail.v2.SearchRequest.ConversationalSearchSpec.UserAnswer.text_answer]
     * is `red color`, which does not match any product attribute value filters,
     * the refined query will be `dress, red color`.
     * </pre>
     *
     * <code>string refined_query = 2;</code>
     *
     * @return The bytes for refinedQuery.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRefinedQueryBytes() {
      java.lang.Object ref = refinedQuery_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        refinedQuery_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ADDITIONAL_FILTERS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter>
        additionalFilters_;
    /**
     *
     *
     * <pre>
     * This field is deprecated but will be kept for backward compatibility.
     * There is expected to have only one additional filter and the value will
     * be the same to the same as field `additional_filter`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.List<
            com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter>
        getAdditionalFiltersList() {
      return additionalFilters_;
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated but will be kept for backward compatibility.
     * There is expected to have only one additional filter and the value will
     * be the same to the same as field `additional_filter`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.List<
            ? extends
                com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                    .AdditionalFilterOrBuilder>
        getAdditionalFiltersOrBuilderList() {
      return additionalFilters_;
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated but will be kept for backward compatibility.
     * There is expected to have only one additional filter and the value will
     * be the same to the same as field `additional_filter`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public int getAdditionalFiltersCount() {
      return additionalFilters_.size();
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated but will be kept for backward compatibility.
     * There is expected to have only one additional filter and the value will
     * be the same to the same as field `additional_filter`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
        getAdditionalFilters(int index) {
      return additionalFilters_.get(index);
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated but will be kept for backward compatibility.
     * There is expected to have only one additional filter and the value will
     * be the same to the same as field `additional_filter`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
            .AdditionalFilterOrBuilder
        getAdditionalFiltersOrBuilder(int index) {
      return additionalFilters_.get(index);
    }

    public static final int FOLLOWUP_QUESTION_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object followupQuestion_ = "";
    /**
     *
     *
     * <pre>
     * The follow-up question. e.g., `What is the color?`
     * </pre>
     *
     * <code>string followup_question = 4;</code>
     *
     * @return The followupQuestion.
     */
    @java.lang.Override
    public java.lang.String getFollowupQuestion() {
      java.lang.Object ref = followupQuestion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        followupQuestion_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The follow-up question. e.g., `What is the color?`
     * </pre>
     *
     * <code>string followup_question = 4;</code>
     *
     * @return The bytes for followupQuestion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFollowupQuestionBytes() {
      java.lang.Object ref = followupQuestion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        followupQuestion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SUGGESTED_ANSWERS_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer>
        suggestedAnswers_;
    /**
     *
     *
     * <pre>
     * The answer options provided to client for the follow-up question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer>
        getSuggestedAnswersList() {
      return suggestedAnswers_;
    }
    /**
     *
     *
     * <pre>
     * The answer options provided to client for the follow-up question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                    .SuggestedAnswerOrBuilder>
        getSuggestedAnswersOrBuilderList() {
      return suggestedAnswers_;
    }
    /**
     *
     *
     * <pre>
     * The answer options provided to client for the follow-up question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
     * </code>
     */
    @java.lang.Override
    public int getSuggestedAnswersCount() {
      return suggestedAnswers_.size();
    }
    /**
     *
     *
     * <pre>
     * The answer options provided to client for the follow-up question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
        getSuggestedAnswers(int index) {
      return suggestedAnswers_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The answer options provided to client for the follow-up question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
            .SuggestedAnswerOrBuilder
        getSuggestedAnswersOrBuilder(int index) {
      return suggestedAnswers_.get(index);
    }

    public static final int ADDITIONAL_FILTER_FIELD_NUMBER = 6;
    private com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
        additionalFilter_;
    /**
     *
     *
     * <pre>
     * This is the incremental additional filters implied from the current
     * user answer. User should add the suggested addition filters to the
     * previous
     * [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter],  and
     * use the merged filter in the follow up search request.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filter = 6;
     * </code>
     *
     * @return Whether the additionalFilter field is set.
     */
    @java.lang.Override
    public boolean hasAdditionalFilter() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * This is the incremental additional filters implied from the current
     * user answer. User should add the suggested addition filters to the
     * previous
     * [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter],  and
     * use the merged filter in the follow up search request.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filter = 6;
     * </code>
     *
     * @return The additionalFilter.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
        getAdditionalFilter() {
      return additionalFilter_ == null
          ? com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
              .getDefaultInstance()
          : additionalFilter_;
    }
    /**
     *
     *
     * <pre>
     * This is the incremental additional filters implied from the current
     * user answer. User should add the suggested addition filters to the
     * previous
     * [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter],  and
     * use the merged filter in the follow up search request.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filter = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
            .AdditionalFilterOrBuilder
        getAdditionalFilterOrBuilder() {
      return additionalFilter_ == null
          ? com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
              .getDefaultInstance()
          : additionalFilter_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversationId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, conversationId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(refinedQuery_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, refinedQuery_);
      }
      for (int i = 0; i < additionalFilters_.size(); i++) {
        output.writeMessage(3, additionalFilters_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(followupQuestion_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, followupQuestion_);
      }
      for (int i = 0; i < suggestedAnswers_.size(); i++) {
        output.writeMessage(5, suggestedAnswers_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(6, getAdditionalFilter());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversationId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, conversationId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(refinedQuery_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, refinedQuery_);
      }
      for (int i = 0; i < additionalFilters_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(3, additionalFilters_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(followupQuestion_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, followupQuestion_);
      }
      for (int i = 0; i < suggestedAnswers_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(5, suggestedAnswers_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getAdditionalFilter());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult other =
          (com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult) obj;

      if (!getConversationId().equals(other.getConversationId())) return false;
      if (!getRefinedQuery().equals(other.getRefinedQuery())) return false;
      if (!getAdditionalFiltersList().equals(other.getAdditionalFiltersList())) return false;
      if (!getFollowupQuestion().equals(other.getFollowupQuestion())) return false;
      if (!getSuggestedAnswersList().equals(other.getSuggestedAnswersList())) return false;
      if (hasAdditionalFilter() != other.hasAdditionalFilter()) return false;
      if (hasAdditionalFilter()) {
        if (!getAdditionalFilter().equals(other.getAdditionalFilter())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CONVERSATION_ID_FIELD_NUMBER;
      hash = (53 * hash) + getConversationId().hashCode();
      hash = (37 * hash) + REFINED_QUERY_FIELD_NUMBER;
      hash = (53 * hash) + getRefinedQuery().hashCode();
      if (getAdditionalFiltersCount() > 0) {
        hash = (37 * hash) + ADDITIONAL_FILTERS_FIELD_NUMBER;
        hash = (53 * hash) + getAdditionalFiltersList().hashCode();
      }
      hash = (37 * hash) + FOLLOWUP_QUESTION_FIELD_NUMBER;
      hash = (53 * hash) + getFollowupQuestion().hashCode();
      if (getSuggestedAnswersCount() > 0) {
        hash = (37 * hash) + SUGGESTED_ANSWERS_FIELD_NUMBER;
        hash = (53 * hash) + getSuggestedAnswersList().hashCode();
      }
      if (hasAdditionalFilter()) {
        hash = (37 * hash) + ADDITIONAL_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getAdditionalFilter().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * This field specifies all related information that is needed on client
     * side for UI rendering of conversational retail search.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2.SearchResponse.ConversationalSearchResult}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.SearchResponse.ConversationalSearchResult)
        com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2.SearchServiceProto
            .internal_static_google_cloud_retail_v2_SearchResponse_ConversationalSearchResult_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2.SearchServiceProto
            .internal_static_google_cloud_retail_v2_SearchResponse_ConversationalSearchResult_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.class,
                com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.Builder.class);
      }

      // Construct using
      // com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getAdditionalFiltersFieldBuilder();
          getSuggestedAnswersFieldBuilder();
          getAdditionalFilterFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        conversationId_ = "";
        refinedQuery_ = "";
        if (additionalFiltersBuilder_ == null) {
          additionalFilters_ = java.util.Collections.emptyList();
        } else {
          additionalFilters_ = null;
          additionalFiltersBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        followupQuestion_ = "";
        if (suggestedAnswersBuilder_ == null) {
          suggestedAnswers_ = java.util.Collections.emptyList();
        } else {
          suggestedAnswers_ = null;
          suggestedAnswersBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        additionalFilter_ = null;
        if (additionalFilterBuilder_ != null) {
          additionalFilterBuilder_.dispose();
          additionalFilterBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2.SearchServiceProto
            .internal_static_google_cloud_retail_v2_SearchResponse_ConversationalSearchResult_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
          getDefaultInstanceForType() {
        return com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult build() {
        com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult buildPartial() {
        com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult result =
            new com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult result) {
        if (additionalFiltersBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            additionalFilters_ = java.util.Collections.unmodifiableList(additionalFilters_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.additionalFilters_ = additionalFilters_;
        } else {
          result.additionalFilters_ = additionalFiltersBuilder_.build();
        }
        if (suggestedAnswersBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)) {
            suggestedAnswers_ = java.util.Collections.unmodifiableList(suggestedAnswers_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.suggestedAnswers_ = suggestedAnswers_;
        } else {
          result.suggestedAnswers_ = suggestedAnswersBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.conversationId_ = conversationId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.refinedQuery_ = refinedQuery_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.followupQuestion_ = followupQuestion_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.additionalFilter_ =
              additionalFilterBuilder_ == null
                  ? additionalFilter_
                  : additionalFilterBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult) {
          return mergeFrom(
              (com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult other) {
        if (other
            == com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                .getDefaultInstance()) return this;
        if (!other.getConversationId().isEmpty()) {
          conversationId_ = other.conversationId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getRefinedQuery().isEmpty()) {
          refinedQuery_ = other.refinedQuery_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (additionalFiltersBuilder_ == null) {
          if (!other.additionalFilters_.isEmpty()) {
            if (additionalFilters_.isEmpty()) {
              additionalFilters_ = other.additionalFilters_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureAdditionalFiltersIsMutable();
              additionalFilters_.addAll(other.additionalFilters_);
            }
            onChanged();
          }
        } else {
          if (!other.additionalFilters_.isEmpty()) {
            if (additionalFiltersBuilder_.isEmpty()) {
              additionalFiltersBuilder_.dispose();
              additionalFiltersBuilder_ = null;
              additionalFilters_ = other.additionalFilters_;
              bitField0_ = (bitField0_ & ~0x00000004);
              additionalFiltersBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getAdditionalFiltersFieldBuilder()
                      : null;
            } else {
              additionalFiltersBuilder_.addAllMessages(other.additionalFilters_);
            }
          }
        }
        if (!other.getFollowupQuestion().isEmpty()) {
          followupQuestion_ = other.followupQuestion_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (suggestedAnswersBuilder_ == null) {
          if (!other.suggestedAnswers_.isEmpty()) {
            if (suggestedAnswers_.isEmpty()) {
              suggestedAnswers_ = other.suggestedAnswers_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensureSuggestedAnswersIsMutable();
              suggestedAnswers_.addAll(other.suggestedAnswers_);
            }
            onChanged();
          }
        } else {
          if (!other.suggestedAnswers_.isEmpty()) {
            if (suggestedAnswersBuilder_.isEmpty()) {
              suggestedAnswersBuilder_.dispose();
              suggestedAnswersBuilder_ = null;
              suggestedAnswers_ = other.suggestedAnswers_;
              bitField0_ = (bitField0_ & ~0x00000010);
              suggestedAnswersBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getSuggestedAnswersFieldBuilder()
                      : null;
            } else {
              suggestedAnswersBuilder_.addAllMessages(other.suggestedAnswers_);
            }
          }
        }
        if (other.hasAdditionalFilter()) {
          mergeAdditionalFilter(other.getAdditionalFilter());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  conversationId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  refinedQuery_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                          .AdditionalFilter
                      m =
                          input.readMessage(
                              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                                  .AdditionalFilter.parser(),
                              extensionRegistry);
                  if (additionalFiltersBuilder_ == null) {
                    ensureAdditionalFiltersIsMutable();
                    additionalFilters_.add(m);
                  } else {
                    additionalFiltersBuilder_.addMessage(m);
                  }
                  break;
                } // case 26
              case 34:
                {
                  followupQuestion_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                          .SuggestedAnswer
                      m =
                          input.readMessage(
                              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                                  .SuggestedAnswer.parser(),
                              extensionRegistry);
                  if (suggestedAnswersBuilder_ == null) {
                    ensureSuggestedAnswersIsMutable();
                    suggestedAnswers_.add(m);
                  } else {
                    suggestedAnswersBuilder_.addMessage(m);
                  }
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(
                      getAdditionalFilterFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object conversationId_ = "";
      /**
       *
       *
       * <pre>
       * Conversation UUID. This field will be stored in client side storage to
       * maintain the conversation session with server and will be used for next
       * search request's
       * [SearchRequest.ConversationalSearchSpec.conversation_id][google.cloud.retail.v2.SearchRequest.ConversationalSearchSpec.conversation_id]
       * to restore conversation state in server.
       * </pre>
       *
       * <code>string conversation_id = 1;</code>
       *
       * @return The conversationId.
       */
      public java.lang.String getConversationId() {
        java.lang.Object ref = conversationId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          conversationId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Conversation UUID. This field will be stored in client side storage to
       * maintain the conversation session with server and will be used for next
       * search request's
       * [SearchRequest.ConversationalSearchSpec.conversation_id][google.cloud.retail.v2.SearchRequest.ConversationalSearchSpec.conversation_id]
       * to restore conversation state in server.
       * </pre>
       *
       * <code>string conversation_id = 1;</code>
       *
       * @return The bytes for conversationId.
       */
      public com.google.protobuf.ByteString getConversationIdBytes() {
        java.lang.Object ref = conversationId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          conversationId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Conversation UUID. This field will be stored in client side storage to
       * maintain the conversation session with server and will be used for next
       * search request's
       * [SearchRequest.ConversationalSearchSpec.conversation_id][google.cloud.retail.v2.SearchRequest.ConversationalSearchSpec.conversation_id]
       * to restore conversation state in server.
       * </pre>
       *
       * <code>string conversation_id = 1;</code>
       *
       * @param value The conversationId to set.
       * @return This builder for chaining.
       */
      public Builder setConversationId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        conversationId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Conversation UUID. This field will be stored in client side storage to
       * maintain the conversation session with server and will be used for next
       * search request's
       * [SearchRequest.ConversationalSearchSpec.conversation_id][google.cloud.retail.v2.SearchRequest.ConversationalSearchSpec.conversation_id]
       * to restore conversation state in server.
       * </pre>
       *
       * <code>string conversation_id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearConversationId() {
        conversationId_ = getDefaultInstance().getConversationId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Conversation UUID. This field will be stored in client side storage to
       * maintain the conversation session with server and will be used for next
       * search request's
       * [SearchRequest.ConversationalSearchSpec.conversation_id][google.cloud.retail.v2.SearchRequest.ConversationalSearchSpec.conversation_id]
       * to restore conversation state in server.
       * </pre>
       *
       * <code>string conversation_id = 1;</code>
       *
       * @param value The bytes for conversationId to set.
       * @return This builder for chaining.
       */
      public Builder setConversationIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        conversationId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object refinedQuery_ = "";
      /**
       *
       *
       * <pre>
       * The current refined query for the conversational search. This field
       * will be used in customer UI that the query in the search bar should be
       * replaced with the refined query. For example, if
       * [SearchRequest.query][google.cloud.retail.v2.SearchRequest.query] is
       * `dress` and next
       * [SearchRequest.ConversationalSearchSpec.UserAnswer.text_answer][google.cloud.retail.v2.SearchRequest.ConversationalSearchSpec.UserAnswer.text_answer]
       * is `red color`, which does not match any product attribute value filters,
       * the refined query will be `dress, red color`.
       * </pre>
       *
       * <code>string refined_query = 2;</code>
       *
       * @return The refinedQuery.
       */
      public java.lang.String getRefinedQuery() {
        java.lang.Object ref = refinedQuery_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          refinedQuery_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The current refined query for the conversational search. This field
       * will be used in customer UI that the query in the search bar should be
       * replaced with the refined query. For example, if
       * [SearchRequest.query][google.cloud.retail.v2.SearchRequest.query] is
       * `dress` and next
       * [SearchRequest.ConversationalSearchSpec.UserAnswer.text_answer][google.cloud.retail.v2.SearchRequest.ConversationalSearchSpec.UserAnswer.text_answer]
       * is `red color`, which does not match any product attribute value filters,
       * the refined query will be `dress, red color`.
       * </pre>
       *
       * <code>string refined_query = 2;</code>
       *
       * @return The bytes for refinedQuery.
       */
      public com.google.protobuf.ByteString getRefinedQueryBytes() {
        java.lang.Object ref = refinedQuery_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          refinedQuery_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The current refined query for the conversational search. This field
       * will be used in customer UI that the query in the search bar should be
       * replaced with the refined query. For example, if
       * [SearchRequest.query][google.cloud.retail.v2.SearchRequest.query] is
       * `dress` and next
       * [SearchRequest.ConversationalSearchSpec.UserAnswer.text_answer][google.cloud.retail.v2.SearchRequest.ConversationalSearchSpec.UserAnswer.text_answer]
       * is `red color`, which does not match any product attribute value filters,
       * the refined query will be `dress, red color`.
       * </pre>
       *
       * <code>string refined_query = 2;</code>
       *
       * @param value The refinedQuery to set.
       * @return This builder for chaining.
       */
      public Builder setRefinedQuery(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        refinedQuery_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The current refined query for the conversational search. This field
       * will be used in customer UI that the query in the search bar should be
       * replaced with the refined query. For example, if
       * [SearchRequest.query][google.cloud.retail.v2.SearchRequest.query] is
       * `dress` and next
       * [SearchRequest.ConversationalSearchSpec.UserAnswer.text_answer][google.cloud.retail.v2.SearchRequest.ConversationalSearchSpec.UserAnswer.text_answer]
       * is `red color`, which does not match any product attribute value filters,
       * the refined query will be `dress, red color`.
       * </pre>
       *
       * <code>string refined_query = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRefinedQuery() {
        refinedQuery_ = getDefaultInstance().getRefinedQuery();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The current refined query for the conversational search. This field
       * will be used in customer UI that the query in the search bar should be
       * replaced with the refined query. For example, if
       * [SearchRequest.query][google.cloud.retail.v2.SearchRequest.query] is
       * `dress` and next
       * [SearchRequest.ConversationalSearchSpec.UserAnswer.text_answer][google.cloud.retail.v2.SearchRequest.ConversationalSearchSpec.UserAnswer.text_answer]
       * is `red color`, which does not match any product attribute value filters,
       * the refined query will be `dress, red color`.
       * </pre>
       *
       * <code>string refined_query = 2;</code>
       *
       * @param value The bytes for refinedQuery to set.
       * @return This builder for chaining.
       */
      public Builder setRefinedQueryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        refinedQuery_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter>
          additionalFilters_ = java.util.Collections.emptyList();

      private void ensureAdditionalFiltersIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          additionalFilters_ =
              new java.util.ArrayList<
                  com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                      .AdditionalFilter>(additionalFilters_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter,
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
                  .Builder,
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                  .AdditionalFilterOrBuilder>
          additionalFiltersBuilder_;

      /**
       *
       *
       * <pre>
       * This field is deprecated but will be kept for backward compatibility.
       * There is expected to have only one additional filter and the value will
       * be the same to the same as field `additional_filter`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public java.util.List<
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter>
          getAdditionalFiltersList() {
        if (additionalFiltersBuilder_ == null) {
          return java.util.Collections.unmodifiableList(additionalFilters_);
        } else {
          return additionalFiltersBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * This field is deprecated but will be kept for backward compatibility.
       * There is expected to have only one additional filter and the value will
       * be the same to the same as field `additional_filter`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public int getAdditionalFiltersCount() {
        if (additionalFiltersBuilder_ == null) {
          return additionalFilters_.size();
        } else {
          return additionalFiltersBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * This field is deprecated but will be kept for backward compatibility.
       * There is expected to have only one additional filter and the value will
       * be the same to the same as field `additional_filter`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
          getAdditionalFilters(int index) {
        if (additionalFiltersBuilder_ == null) {
          return additionalFilters_.get(index);
        } else {
          return additionalFiltersBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * This field is deprecated but will be kept for backward compatibility.
       * There is expected to have only one additional filter and the value will
       * be the same to the same as field `additional_filter`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder setAdditionalFilters(
          int index,
          com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
              value) {
        if (additionalFiltersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAdditionalFiltersIsMutable();
          additionalFilters_.set(index, value);
          onChanged();
        } else {
          additionalFiltersBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field is deprecated but will be kept for backward compatibility.
       * There is expected to have only one additional filter and the value will
       * be the same to the same as field `additional_filter`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder setAdditionalFilters(
          int index,
          com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
                  .Builder
              builderForValue) {
        if (additionalFiltersBuilder_ == null) {
          ensureAdditionalFiltersIsMutable();
          additionalFilters_.set(index, builderForValue.build());
          onChanged();
        } else {
          additionalFiltersBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field is deprecated but will be kept for backward compatibility.
       * There is expected to have only one additional filter and the value will
       * be the same to the same as field `additional_filter`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addAdditionalFilters(
          com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
              value) {
        if (additionalFiltersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAdditionalFiltersIsMutable();
          additionalFilters_.add(value);
          onChanged();
        } else {
          additionalFiltersBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field is deprecated but will be kept for backward compatibility.
       * There is expected to have only one additional filter and the value will
       * be the same to the same as field `additional_filter`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addAdditionalFilters(
          int index,
          com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
              value) {
        if (additionalFiltersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAdditionalFiltersIsMutable();
          additionalFilters_.add(index, value);
          onChanged();
        } else {
          additionalFiltersBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field is deprecated but will be kept for backward compatibility.
       * There is expected to have only one additional filter and the value will
       * be the same to the same as field `additional_filter`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addAdditionalFilters(
          com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
                  .Builder
              builderForValue) {
        if (additionalFiltersBuilder_ == null) {
          ensureAdditionalFiltersIsMutable();
          additionalFilters_.add(builderForValue.build());
          onChanged();
        } else {
          additionalFiltersBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field is deprecated but will be kept for backward compatibility.
       * There is expected to have only one additional filter and the value will
       * be the same to the same as field `additional_filter`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addAdditionalFilters(
          int index,
          com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
                  .Builder
              builderForValue) {
        if (additionalFiltersBuilder_ == null) {
          ensureAdditionalFiltersIsMutable();
          additionalFilters_.add(index, builderForValue.build());
          onChanged();
        } else {
          additionalFiltersBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field is deprecated but will be kept for backward compatibility.
       * There is expected to have only one additional filter and the value will
       * be the same to the same as field `additional_filter`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addAllAdditionalFilters(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                          .AdditionalFilter>
              values) {
        if (additionalFiltersBuilder_ == null) {
          ensureAdditionalFiltersIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, additionalFilters_);
          onChanged();
        } else {
          additionalFiltersBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field is deprecated but will be kept for backward compatibility.
       * There is expected to have only one additional filter and the value will
       * be the same to the same as field `additional_filter`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder clearAdditionalFilters() {
        if (additionalFiltersBuilder_ == null) {
          additionalFilters_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          additionalFiltersBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field is deprecated but will be kept for backward compatibility.
       * There is expected to have only one additional filter and the value will
       * be the same to the same as field `additional_filter`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder removeAdditionalFilters(int index) {
        if (additionalFiltersBuilder_ == null) {
          ensureAdditionalFiltersIsMutable();
          additionalFilters_.remove(index);
          onChanged();
        } else {
          additionalFiltersBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field is deprecated but will be kept for backward compatibility.
       * There is expected to have only one additional filter and the value will
       * be the same to the same as field `additional_filter`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
              .Builder
          getAdditionalFiltersBuilder(int index) {
        return getAdditionalFiltersFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * This field is deprecated but will be kept for backward compatibility.
       * There is expected to have only one additional filter and the value will
       * be the same to the same as field `additional_filter`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .AdditionalFilterOrBuilder
          getAdditionalFiltersOrBuilder(int index) {
        if (additionalFiltersBuilder_ == null) {
          return additionalFilters_.get(index);
        } else {
          return additionalFiltersBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * This field is deprecated but will be kept for backward compatibility.
       * There is expected to have only one additional filter and the value will
       * be the same to the same as field `additional_filter`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public java.util.List<
              ? extends
                  com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                      .AdditionalFilterOrBuilder>
          getAdditionalFiltersOrBuilderList() {
        if (additionalFiltersBuilder_ != null) {
          return additionalFiltersBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(additionalFilters_);
        }
      }
      /**
       *
       *
       * <pre>
       * This field is deprecated but will be kept for backward compatibility.
       * There is expected to have only one additional filter and the value will
       * be the same to the same as field `additional_filter`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
              .Builder
          addAdditionalFiltersBuilder() {
        return getAdditionalFiltersFieldBuilder()
            .addBuilder(
                com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                    .AdditionalFilter.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * This field is deprecated but will be kept for backward compatibility.
       * There is expected to have only one additional filter and the value will
       * be the same to the same as field `additional_filter`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
              .Builder
          addAdditionalFiltersBuilder(int index) {
        return getAdditionalFiltersFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                    .AdditionalFilter.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * This field is deprecated but will be kept for backward compatibility.
       * There is expected to have only one additional filter and the value will
       * be the same to the same as field `additional_filter`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filters = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public java.util.List<
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
                  .Builder>
          getAdditionalFiltersBuilderList() {
        return getAdditionalFiltersFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter,
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
                  .Builder,
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                  .AdditionalFilterOrBuilder>
          getAdditionalFiltersFieldBuilder() {
        if (additionalFiltersBuilder_ == null) {
          additionalFiltersBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                      .AdditionalFilter,
                  com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                      .AdditionalFilter.Builder,
                  com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                      .AdditionalFilterOrBuilder>(
                  additionalFilters_,
                  ((bitField0_ & 0x00000004) != 0),
                  getParentForChildren(),
                  isClean());
          additionalFilters_ = null;
        }
        return additionalFiltersBuilder_;
      }

      private java.lang.Object followupQuestion_ = "";
      /**
       *
       *
       * <pre>
       * The follow-up question. e.g., `What is the color?`
       * </pre>
       *
       * <code>string followup_question = 4;</code>
       *
       * @return The followupQuestion.
       */
      public java.lang.String getFollowupQuestion() {
        java.lang.Object ref = followupQuestion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          followupQuestion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The follow-up question. e.g., `What is the color?`
       * </pre>
       *
       * <code>string followup_question = 4;</code>
       *
       * @return The bytes for followupQuestion.
       */
      public com.google.protobuf.ByteString getFollowupQuestionBytes() {
        java.lang.Object ref = followupQuestion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          followupQuestion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The follow-up question. e.g., `What is the color?`
       * </pre>
       *
       * <code>string followup_question = 4;</code>
       *
       * @param value The followupQuestion to set.
       * @return This builder for chaining.
       */
      public Builder setFollowupQuestion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        followupQuestion_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The follow-up question. e.g., `What is the color?`
       * </pre>
       *
       * <code>string followup_question = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFollowupQuestion() {
        followupQuestion_ = getDefaultInstance().getFollowupQuestion();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The follow-up question. e.g., `What is the color?`
       * </pre>
       *
       * <code>string followup_question = 4;</code>
       *
       * @param value The bytes for followupQuestion to set.
       * @return This builder for chaining.
       */
      public Builder setFollowupQuestionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        followupQuestion_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer>
          suggestedAnswers_ = java.util.Collections.emptyList();

      private void ensureSuggestedAnswersIsMutable() {
        if (!((bitField0_ & 0x00000010) != 0)) {
          suggestedAnswers_ =
              new java.util.ArrayList<
                  com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                      .SuggestedAnswer>(suggestedAnswers_);
          bitField0_ |= 0x00000010;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer,
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
                  .Builder,
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                  .SuggestedAnswerOrBuilder>
          suggestedAnswersBuilder_;

      /**
       *
       *
       * <pre>
       * The answer options provided to client for the follow-up question.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
       * </code>
       */
      public java.util.List<
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer>
          getSuggestedAnswersList() {
        if (suggestedAnswersBuilder_ == null) {
          return java.util.Collections.unmodifiableList(suggestedAnswers_);
        } else {
          return suggestedAnswersBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The answer options provided to client for the follow-up question.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
       * </code>
       */
      public int getSuggestedAnswersCount() {
        if (suggestedAnswersBuilder_ == null) {
          return suggestedAnswers_.size();
        } else {
          return suggestedAnswersBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The answer options provided to client for the follow-up question.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
       * </code>
       */
      public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
          getSuggestedAnswers(int index) {
        if (suggestedAnswersBuilder_ == null) {
          return suggestedAnswers_.get(index);
        } else {
          return suggestedAnswersBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The answer options provided to client for the follow-up question.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
       * </code>
       */
      public Builder setSuggestedAnswers(
          int index,
          com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
              value) {
        if (suggestedAnswersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSuggestedAnswersIsMutable();
          suggestedAnswers_.set(index, value);
          onChanged();
        } else {
          suggestedAnswersBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The answer options provided to client for the follow-up question.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
       * </code>
       */
      public Builder setSuggestedAnswers(
          int index,
          com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
                  .Builder
              builderForValue) {
        if (suggestedAnswersBuilder_ == null) {
          ensureSuggestedAnswersIsMutable();
          suggestedAnswers_.set(index, builderForValue.build());
          onChanged();
        } else {
          suggestedAnswersBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The answer options provided to client for the follow-up question.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
       * </code>
       */
      public Builder addSuggestedAnswers(
          com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
              value) {
        if (suggestedAnswersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSuggestedAnswersIsMutable();
          suggestedAnswers_.add(value);
          onChanged();
        } else {
          suggestedAnswersBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The answer options provided to client for the follow-up question.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
       * </code>
       */
      public Builder addSuggestedAnswers(
          int index,
          com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
              value) {
        if (suggestedAnswersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSuggestedAnswersIsMutable();
          suggestedAnswers_.add(index, value);
          onChanged();
        } else {
          suggestedAnswersBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The answer options provided to client for the follow-up question.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
       * </code>
       */
      public Builder addSuggestedAnswers(
          com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
                  .Builder
              builderForValue) {
        if (suggestedAnswersBuilder_ == null) {
          ensureSuggestedAnswersIsMutable();
          suggestedAnswers_.add(builderForValue.build());
          onChanged();
        } else {
          suggestedAnswersBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The answer options provided to client for the follow-up question.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
       * </code>
       */
      public Builder addSuggestedAnswers(
          int index,
          com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
                  .Builder
              builderForValue) {
        if (suggestedAnswersBuilder_ == null) {
          ensureSuggestedAnswersIsMutable();
          suggestedAnswers_.add(index, builderForValue.build());
          onChanged();
        } else {
          suggestedAnswersBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The answer options provided to client for the follow-up question.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
       * </code>
       */
      public Builder addAllSuggestedAnswers(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                          .SuggestedAnswer>
              values) {
        if (suggestedAnswersBuilder_ == null) {
          ensureSuggestedAnswersIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, suggestedAnswers_);
          onChanged();
        } else {
          suggestedAnswersBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The answer options provided to client for the follow-up question.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
       * </code>
       */
      public Builder clearSuggestedAnswers() {
        if (suggestedAnswersBuilder_ == null) {
          suggestedAnswers_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          suggestedAnswersBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The answer options provided to client for the follow-up question.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
       * </code>
       */
      public Builder removeSuggestedAnswers(int index) {
        if (suggestedAnswersBuilder_ == null) {
          ensureSuggestedAnswersIsMutable();
          suggestedAnswers_.remove(index);
          onChanged();
        } else {
          suggestedAnswersBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The answer options provided to client for the follow-up question.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
       * </code>
       */
      public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
              .Builder
          getSuggestedAnswersBuilder(int index) {
        return getSuggestedAnswersFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The answer options provided to client for the follow-up question.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
       * </code>
       */
      public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .SuggestedAnswerOrBuilder
          getSuggestedAnswersOrBuilder(int index) {
        if (suggestedAnswersBuilder_ == null) {
          return suggestedAnswers_.get(index);
        } else {
          return suggestedAnswersBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The answer options provided to client for the follow-up question.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                      .SuggestedAnswerOrBuilder>
          getSuggestedAnswersOrBuilderList() {
        if (suggestedAnswersBuilder_ != null) {
          return suggestedAnswersBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(suggestedAnswers_);
        }
      }
      /**
       *
       *
       * <pre>
       * The answer options provided to client for the follow-up question.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
       * </code>
       */
      public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
              .Builder
          addSuggestedAnswersBuilder() {
        return getSuggestedAnswersFieldBuilder()
            .addBuilder(
                com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The answer options provided to client for the follow-up question.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
       * </code>
       */
      public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
              .Builder
          addSuggestedAnswersBuilder(int index) {
        return getSuggestedAnswersFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The answer options provided to client for the follow-up question.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer suggested_answers = 5;
       * </code>
       */
      public java.util.List<
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
                  .Builder>
          getSuggestedAnswersBuilderList() {
        return getSuggestedAnswersFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer,
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.SuggestedAnswer
                  .Builder,
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                  .SuggestedAnswerOrBuilder>
          getSuggestedAnswersFieldBuilder() {
        if (suggestedAnswersBuilder_ == null) {
          suggestedAnswersBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                      .SuggestedAnswer,
                  com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                      .SuggestedAnswer.Builder,
                  com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                      .SuggestedAnswerOrBuilder>(
                  suggestedAnswers_,
                  ((bitField0_ & 0x00000010) != 0),
                  getParentForChildren(),
                  isClean());
          suggestedAnswers_ = null;
        }
        return suggestedAnswersBuilder_;
      }

      private com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
          additionalFilter_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter,
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
                  .Builder,
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                  .AdditionalFilterOrBuilder>
          additionalFilterBuilder_;
      /**
       *
       *
       * <pre>
       * This is the incremental additional filters implied from the current
       * user answer. User should add the suggested addition filters to the
       * previous
       * [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter],  and
       * use the merged filter in the follow up search request.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filter = 6;
       * </code>
       *
       * @return Whether the additionalFilter field is set.
       */
      public boolean hasAdditionalFilter() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       *
       *
       * <pre>
       * This is the incremental additional filters implied from the current
       * user answer. User should add the suggested addition filters to the
       * previous
       * [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter],  and
       * use the merged filter in the follow up search request.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filter = 6;
       * </code>
       *
       * @return The additionalFilter.
       */
      public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
          getAdditionalFilter() {
        if (additionalFilterBuilder_ == null) {
          return additionalFilter_ == null
              ? com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                  .AdditionalFilter.getDefaultInstance()
              : additionalFilter_;
        } else {
          return additionalFilterBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * This is the incremental additional filters implied from the current
       * user answer. User should add the suggested addition filters to the
       * previous
       * [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter],  and
       * use the merged filter in the follow up search request.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filter = 6;
       * </code>
       */
      public Builder setAdditionalFilter(
          com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
              value) {
        if (additionalFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          additionalFilter_ = value;
        } else {
          additionalFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This is the incremental additional filters implied from the current
       * user answer. User should add the suggested addition filters to the
       * previous
       * [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter],  and
       * use the merged filter in the follow up search request.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filter = 6;
       * </code>
       */
      public Builder setAdditionalFilter(
          com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
                  .Builder
              builderForValue) {
        if (additionalFilterBuilder_ == null) {
          additionalFilter_ = builderForValue.build();
        } else {
          additionalFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This is the incremental additional filters implied from the current
       * user answer. User should add the suggested addition filters to the
       * previous
       * [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter],  and
       * use the merged filter in the follow up search request.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filter = 6;
       * </code>
       */
      public Builder mergeAdditionalFilter(
          com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
              value) {
        if (additionalFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)
              && additionalFilter_ != null
              && additionalFilter_
                  != com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                      .AdditionalFilter.getDefaultInstance()) {
            getAdditionalFilterBuilder().mergeFrom(value);
          } else {
            additionalFilter_ = value;
          }
        } else {
          additionalFilterBuilder_.mergeFrom(value);
        }
        if (additionalFilter_ != null) {
          bitField0_ |= 0x00000020;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * This is the incremental additional filters implied from the current
       * user answer. User should add the suggested addition filters to the
       * previous
       * [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter],  and
       * use the merged filter in the follow up search request.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filter = 6;
       * </code>
       */
      public Builder clearAdditionalFilter() {
        bitField0_ = (bitField0_ & ~0x00000020);
        additionalFilter_ = null;
        if (additionalFilterBuilder_ != null) {
          additionalFilterBuilder_.dispose();
          additionalFilterBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This is the incremental additional filters implied from the current
       * user answer. User should add the suggested addition filters to the
       * previous
       * [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter],  and
       * use the merged filter in the follow up search request.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filter = 6;
       * </code>
       */
      public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
              .Builder
          getAdditionalFilterBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getAdditionalFilterFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * This is the incremental additional filters implied from the current
       * user answer. User should add the suggested addition filters to the
       * previous
       * [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter],  and
       * use the merged filter in the follow up search request.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filter = 6;
       * </code>
       */
      public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
              .AdditionalFilterOrBuilder
          getAdditionalFilterOrBuilder() {
        if (additionalFilterBuilder_ != null) {
          return additionalFilterBuilder_.getMessageOrBuilder();
        } else {
          return additionalFilter_ == null
              ? com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                  .AdditionalFilter.getDefaultInstance()
              : additionalFilter_;
        }
      }
      /**
       *
       *
       * <pre>
       * This is the incremental additional filters implied from the current
       * user answer. User should add the suggested addition filters to the
       * previous
       * [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter],  and
       * use the merged filter in the follow up search request.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter additional_filter = 6;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter,
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.AdditionalFilter
                  .Builder,
              com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                  .AdditionalFilterOrBuilder>
          getAdditionalFilterFieldBuilder() {
        if (additionalFilterBuilder_ == null) {
          additionalFilterBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                      .AdditionalFilter,
                  com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                      .AdditionalFilter.Builder,
                  com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                      .AdditionalFilterOrBuilder>(
                  getAdditionalFilter(), getParentForChildren(), isClean());
          additionalFilter_ = null;
        }
        return additionalFilterBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.SearchResponse.ConversationalSearchResult)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.SearchResponse.ConversationalSearchResult)
    private static final com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult();
    }

    public static com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ConversationalSearchResult> PARSER =
        new com.google.protobuf.AbstractParser<ConversationalSearchResult>() {
          @java.lang.Override
          public ConversationalSearchResult parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ConversationalSearchResult> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ConversationalSearchResult> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TileNavigationResultOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2.SearchResponse.TileNavigationResult)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The current tiles that are used for tile navigation, sorted by
     * engagement.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
     */
    java.util.List<com.google.cloud.retail.v2.Tile> getTilesList();
    /**
     *
     *
     * <pre>
     * The current tiles that are used for tile navigation, sorted by
     * engagement.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
     */
    com.google.cloud.retail.v2.Tile getTiles(int index);
    /**
     *
     *
     * <pre>
     * The current tiles that are used for tile navigation, sorted by
     * engagement.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
     */
    int getTilesCount();
    /**
     *
     *
     * <pre>
     * The current tiles that are used for tile navigation, sorted by
     * engagement.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
     */
    java.util.List<? extends com.google.cloud.retail.v2.TileOrBuilder> getTilesOrBuilderList();
    /**
     *
     *
     * <pre>
     * The current tiles that are used for tile navigation, sorted by
     * engagement.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
     */
    com.google.cloud.retail.v2.TileOrBuilder getTilesOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * This field specifies all related information for tile navigation that will
   * be used in client side.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2.SearchResponse.TileNavigationResult}
   */
  public static final class TileNavigationResult extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.SearchResponse.TileNavigationResult)
      TileNavigationResultOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TileNavigationResult.newBuilder() to construct.
    private TileNavigationResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TileNavigationResult() {
      tiles_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TileNavigationResult();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2.SearchServiceProto
          .internal_static_google_cloud_retail_v2_SearchResponse_TileNavigationResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2.SearchServiceProto
          .internal_static_google_cloud_retail_v2_SearchResponse_TileNavigationResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2.SearchResponse.TileNavigationResult.class,
              com.google.cloud.retail.v2.SearchResponse.TileNavigationResult.Builder.class);
    }

    public static final int TILES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.retail.v2.Tile> tiles_;
    /**
     *
     *
     * <pre>
     * The current tiles that are used for tile navigation, sorted by
     * engagement.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.retail.v2.Tile> getTilesList() {
      return tiles_;
    }
    /**
     *
     *
     * <pre>
     * The current tiles that are used for tile navigation, sorted by
     * engagement.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.retail.v2.TileOrBuilder>
        getTilesOrBuilderList() {
      return tiles_;
    }
    /**
     *
     *
     * <pre>
     * The current tiles that are used for tile navigation, sorted by
     * engagement.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
     */
    @java.lang.Override
    public int getTilesCount() {
      return tiles_.size();
    }
    /**
     *
     *
     * <pre>
     * The current tiles that are used for tile navigation, sorted by
     * engagement.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.Tile getTiles(int index) {
      return tiles_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The current tiles that are used for tile navigation, sorted by
     * engagement.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.TileOrBuilder getTilesOrBuilder(int index) {
      return tiles_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < tiles_.size(); i++) {
        output.writeMessage(1, tiles_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < tiles_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, tiles_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2.SearchResponse.TileNavigationResult)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2.SearchResponse.TileNavigationResult other =
          (com.google.cloud.retail.v2.SearchResponse.TileNavigationResult) obj;

      if (!getTilesList().equals(other.getTilesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getTilesCount() > 0) {
        hash = (37 * hash) + TILES_FIELD_NUMBER;
        hash = (53 * hash) + getTilesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2.SearchResponse.TileNavigationResult parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.SearchResponse.TileNavigationResult parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.SearchResponse.TileNavigationResult parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.SearchResponse.TileNavigationResult parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.SearchResponse.TileNavigationResult parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2.SearchResponse.TileNavigationResult parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.SearchResponse.TileNavigationResult parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.SearchResponse.TileNavigationResult parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.SearchResponse.TileNavigationResult parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.SearchResponse.TileNavigationResult parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2.SearchResponse.TileNavigationResult parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2.SearchResponse.TileNavigationResult parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2.SearchResponse.TileNavigationResult prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * This field specifies all related information for tile navigation that will
     * be used in client side.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2.SearchResponse.TileNavigationResult}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.SearchResponse.TileNavigationResult)
        com.google.cloud.retail.v2.SearchResponse.TileNavigationResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2.SearchServiceProto
            .internal_static_google_cloud_retail_v2_SearchResponse_TileNavigationResult_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2.SearchServiceProto
            .internal_static_google_cloud_retail_v2_SearchResponse_TileNavigationResult_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2.SearchResponse.TileNavigationResult.class,
                com.google.cloud.retail.v2.SearchResponse.TileNavigationResult.Builder.class);
      }

      // Construct using com.google.cloud.retail.v2.SearchResponse.TileNavigationResult.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (tilesBuilder_ == null) {
          tiles_ = java.util.Collections.emptyList();
        } else {
          tiles_ = null;
          tilesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2.SearchServiceProto
            .internal_static_google_cloud_retail_v2_SearchResponse_TileNavigationResult_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.SearchResponse.TileNavigationResult
          getDefaultInstanceForType() {
        return com.google.cloud.retail.v2.SearchResponse.TileNavigationResult.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.SearchResponse.TileNavigationResult build() {
        com.google.cloud.retail.v2.SearchResponse.TileNavigationResult result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2.SearchResponse.TileNavigationResult buildPartial() {
        com.google.cloud.retail.v2.SearchResponse.TileNavigationResult result =
            new com.google.cloud.retail.v2.SearchResponse.TileNavigationResult(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.retail.v2.SearchResponse.TileNavigationResult result) {
        if (tilesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            tiles_ = java.util.Collections.unmodifiableList(tiles_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.tiles_ = tiles_;
        } else {
          result.tiles_ = tilesBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.retail.v2.SearchResponse.TileNavigationResult result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2.SearchResponse.TileNavigationResult) {
          return mergeFrom((com.google.cloud.retail.v2.SearchResponse.TileNavigationResult) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.retail.v2.SearchResponse.TileNavigationResult other) {
        if (other
            == com.google.cloud.retail.v2.SearchResponse.TileNavigationResult.getDefaultInstance())
          return this;
        if (tilesBuilder_ == null) {
          if (!other.tiles_.isEmpty()) {
            if (tiles_.isEmpty()) {
              tiles_ = other.tiles_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureTilesIsMutable();
              tiles_.addAll(other.tiles_);
            }
            onChanged();
          }
        } else {
          if (!other.tiles_.isEmpty()) {
            if (tilesBuilder_.isEmpty()) {
              tilesBuilder_.dispose();
              tilesBuilder_ = null;
              tiles_ = other.tiles_;
              bitField0_ = (bitField0_ & ~0x00000001);
              tilesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getTilesFieldBuilder()
                      : null;
            } else {
              tilesBuilder_.addAllMessages(other.tiles_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.retail.v2.Tile m =
                      input.readMessage(
                          com.google.cloud.retail.v2.Tile.parser(), extensionRegistry);
                  if (tilesBuilder_ == null) {
                    ensureTilesIsMutable();
                    tiles_.add(m);
                  } else {
                    tilesBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.retail.v2.Tile> tiles_ =
          java.util.Collections.emptyList();

      private void ensureTilesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          tiles_ = new java.util.ArrayList<com.google.cloud.retail.v2.Tile>(tiles_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.retail.v2.Tile,
              com.google.cloud.retail.v2.Tile.Builder,
              com.google.cloud.retail.v2.TileOrBuilder>
          tilesBuilder_;

      /**
       *
       *
       * <pre>
       * The current tiles that are used for tile navigation, sorted by
       * engagement.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
       */
      public java.util.List<com.google.cloud.retail.v2.Tile> getTilesList() {
        if (tilesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(tiles_);
        } else {
          return tilesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The current tiles that are used for tile navigation, sorted by
       * engagement.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
       */
      public int getTilesCount() {
        if (tilesBuilder_ == null) {
          return tiles_.size();
        } else {
          return tilesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The current tiles that are used for tile navigation, sorted by
       * engagement.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
       */
      public com.google.cloud.retail.v2.Tile getTiles(int index) {
        if (tilesBuilder_ == null) {
          return tiles_.get(index);
        } else {
          return tilesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The current tiles that are used for tile navigation, sorted by
       * engagement.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
       */
      public Builder setTiles(int index, com.google.cloud.retail.v2.Tile value) {
        if (tilesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTilesIsMutable();
          tiles_.set(index, value);
          onChanged();
        } else {
          tilesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The current tiles that are used for tile navigation, sorted by
       * engagement.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
       */
      public Builder setTiles(int index, com.google.cloud.retail.v2.Tile.Builder builderForValue) {
        if (tilesBuilder_ == null) {
          ensureTilesIsMutable();
          tiles_.set(index, builderForValue.build());
          onChanged();
        } else {
          tilesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The current tiles that are used for tile navigation, sorted by
       * engagement.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
       */
      public Builder addTiles(com.google.cloud.retail.v2.Tile value) {
        if (tilesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTilesIsMutable();
          tiles_.add(value);
          onChanged();
        } else {
          tilesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The current tiles that are used for tile navigation, sorted by
       * engagement.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
       */
      public Builder addTiles(int index, com.google.cloud.retail.v2.Tile value) {
        if (tilesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTilesIsMutable();
          tiles_.add(index, value);
          onChanged();
        } else {
          tilesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The current tiles that are used for tile navigation, sorted by
       * engagement.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
       */
      public Builder addTiles(com.google.cloud.retail.v2.Tile.Builder builderForValue) {
        if (tilesBuilder_ == null) {
          ensureTilesIsMutable();
          tiles_.add(builderForValue.build());
          onChanged();
        } else {
          tilesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The current tiles that are used for tile navigation, sorted by
       * engagement.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
       */
      public Builder addTiles(int index, com.google.cloud.retail.v2.Tile.Builder builderForValue) {
        if (tilesBuilder_ == null) {
          ensureTilesIsMutable();
          tiles_.add(index, builderForValue.build());
          onChanged();
        } else {
          tilesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The current tiles that are used for tile navigation, sorted by
       * engagement.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
       */
      public Builder addAllTiles(
          java.lang.Iterable<? extends com.google.cloud.retail.v2.Tile> values) {
        if (tilesBuilder_ == null) {
          ensureTilesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tiles_);
          onChanged();
        } else {
          tilesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The current tiles that are used for tile navigation, sorted by
       * engagement.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
       */
      public Builder clearTiles() {
        if (tilesBuilder_ == null) {
          tiles_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          tilesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The current tiles that are used for tile navigation, sorted by
       * engagement.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
       */
      public Builder removeTiles(int index) {
        if (tilesBuilder_ == null) {
          ensureTilesIsMutable();
          tiles_.remove(index);
          onChanged();
        } else {
          tilesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The current tiles that are used for tile navigation, sorted by
       * engagement.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
       */
      public com.google.cloud.retail.v2.Tile.Builder getTilesBuilder(int index) {
        return getTilesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The current tiles that are used for tile navigation, sorted by
       * engagement.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
       */
      public com.google.cloud.retail.v2.TileOrBuilder getTilesOrBuilder(int index) {
        if (tilesBuilder_ == null) {
          return tiles_.get(index);
        } else {
          return tilesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The current tiles that are used for tile navigation, sorted by
       * engagement.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
       */
      public java.util.List<? extends com.google.cloud.retail.v2.TileOrBuilder>
          getTilesOrBuilderList() {
        if (tilesBuilder_ != null) {
          return tilesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(tiles_);
        }
      }
      /**
       *
       *
       * <pre>
       * The current tiles that are used for tile navigation, sorted by
       * engagement.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
       */
      public com.google.cloud.retail.v2.Tile.Builder addTilesBuilder() {
        return getTilesFieldBuilder()
            .addBuilder(com.google.cloud.retail.v2.Tile.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The current tiles that are used for tile navigation, sorted by
       * engagement.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
       */
      public com.google.cloud.retail.v2.Tile.Builder addTilesBuilder(int index) {
        return getTilesFieldBuilder()
            .addBuilder(index, com.google.cloud.retail.v2.Tile.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The current tiles that are used for tile navigation, sorted by
       * engagement.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2.Tile tiles = 1;</code>
       */
      public java.util.List<com.google.cloud.retail.v2.Tile.Builder> getTilesBuilderList() {
        return getTilesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.retail.v2.Tile,
              com.google.cloud.retail.v2.Tile.Builder,
              com.google.cloud.retail.v2.TileOrBuilder>
          getTilesFieldBuilder() {
        if (tilesBuilder_ == null) {
          tilesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.retail.v2.Tile,
                  com.google.cloud.retail.v2.Tile.Builder,
                  com.google.cloud.retail.v2.TileOrBuilder>(
                  tiles_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          tiles_ = null;
        }
        return tilesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.SearchResponse.TileNavigationResult)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.SearchResponse.TileNavigationResult)
    private static final com.google.cloud.retail.v2.SearchResponse.TileNavigationResult
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2.SearchResponse.TileNavigationResult();
    }

    public static com.google.cloud.retail.v2.SearchResponse.TileNavigationResult
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TileNavigationResult> PARSER =
        new com.google.protobuf.AbstractParser<TileNavigationResult>() {
          @java.lang.Override
          public TileNavigationResult parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TileNavigationResult> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TileNavigationResult> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.SearchResponse.TileNavigationResult
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int RESULTS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.retail.v2.SearchResponse.SearchResult> results_;
  /**
   *
   *
   * <pre>
   * A list of matched items. The order represents the ranking.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.SearchResponse.SearchResult results = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2.SearchResponse.SearchResult> getResultsList() {
    return results_;
  }
  /**
   *
   *
   * <pre>
   * A list of matched items. The order represents the ranking.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.SearchResponse.SearchResult results = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.retail.v2.SearchResponse.SearchResultOrBuilder>
      getResultsOrBuilderList() {
    return results_;
  }
  /**
   *
   *
   * <pre>
   * A list of matched items. The order represents the ranking.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.SearchResponse.SearchResult results = 1;</code>
   */
  @java.lang.Override
  public int getResultsCount() {
    return results_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of matched items. The order represents the ranking.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.SearchResponse.SearchResult results = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.SearchResponse.SearchResult getResults(int index) {
    return results_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of matched items. The order represents the ranking.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.SearchResponse.SearchResult results = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.SearchResponse.SearchResultOrBuilder getResultsOrBuilder(
      int index) {
    return results_.get(index);
  }

  public static final int FACETS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.retail.v2.SearchResponse.Facet> facets_;
  /**
   *
   *
   * <pre>
   * Results of facets requested by user.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet facets = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2.SearchResponse.Facet> getFacetsList() {
    return facets_;
  }
  /**
   *
   *
   * <pre>
   * Results of facets requested by user.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet facets = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.retail.v2.SearchResponse.FacetOrBuilder>
      getFacetsOrBuilderList() {
    return facets_;
  }
  /**
   *
   *
   * <pre>
   * Results of facets requested by user.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet facets = 2;</code>
   */
  @java.lang.Override
  public int getFacetsCount() {
    return facets_.size();
  }
  /**
   *
   *
   * <pre>
   * Results of facets requested by user.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet facets = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.SearchResponse.Facet getFacets(int index) {
    return facets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Results of facets requested by user.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet facets = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.SearchResponse.FacetOrBuilder getFacetsOrBuilder(int index) {
    return facets_.get(index);
  }

  public static final int TOTAL_SIZE_FIELD_NUMBER = 3;
  private int totalSize_ = 0;
  /**
   *
   *
   * <pre>
   * The estimated total count of matched items irrespective of pagination. The
   * count of [results][google.cloud.retail.v2.SearchResponse.results] returned
   * by pagination may be less than the
   * [total_size][google.cloud.retail.v2.SearchResponse.total_size] that
   * matches.
   * </pre>
   *
   * <code>int32 total_size = 3;</code>
   *
   * @return The totalSize.
   */
  @java.lang.Override
  public int getTotalSize() {
    return totalSize_;
  }

  public static final int CORRECTED_QUERY_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object correctedQuery_ = "";
  /**
   *
   *
   * <pre>
   * Contains the spell corrected query, if found. If the spell correction type
   * is AUTOMATIC, then the search results are based on corrected_query.
   * Otherwise the original query is used for search.
   * </pre>
   *
   * <code>string corrected_query = 4;</code>
   *
   * @return The correctedQuery.
   */
  @java.lang.Override
  public java.lang.String getCorrectedQuery() {
    java.lang.Object ref = correctedQuery_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      correctedQuery_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Contains the spell corrected query, if found. If the spell correction type
   * is AUTOMATIC, then the search results are based on corrected_query.
   * Otherwise the original query is used for search.
   * </pre>
   *
   * <code>string corrected_query = 4;</code>
   *
   * @return The bytes for correctedQuery.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCorrectedQueryBytes() {
    java.lang.Object ref = correctedQuery_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      correctedQuery_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ATTRIBUTION_TOKEN_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object attributionToken_ = "";
  /**
   *
   *
   * <pre>
   * A unique search token. This should be included in the
   * [UserEvent][google.cloud.retail.v2.UserEvent] logs resulting from this
   * search, which enables accurate attribution of search model performance.
   * </pre>
   *
   * <code>string attribution_token = 5;</code>
   *
   * @return The attributionToken.
   */
  @java.lang.Override
  public java.lang.String getAttributionToken() {
    java.lang.Object ref = attributionToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      attributionToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A unique search token. This should be included in the
   * [UserEvent][google.cloud.retail.v2.UserEvent] logs resulting from this
   * search, which enables accurate attribution of search model performance.
   * </pre>
   *
   * <code>string attribution_token = 5;</code>
   *
   * @return The bytes for attributionToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAttributionTokenBytes() {
    java.lang.Object ref = attributionToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      attributionToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextPageToken_ = "";
  /**
   *
   *
   * <pre>
   * A token that can be sent as
   * [SearchRequest.page_token][google.cloud.retail.v2.SearchRequest.page_token]
   * to retrieve the next page. If this field is omitted, there are no
   * subsequent pages.
   * </pre>
   *
   * <code>string next_page_token = 6;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A token that can be sent as
   * [SearchRequest.page_token][google.cloud.retail.v2.SearchRequest.page_token]
   * to retrieve the next page. If this field is omitted, there are no
   * subsequent pages.
   * </pre>
   *
   * <code>string next_page_token = 6;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_EXPANSION_INFO_FIELD_NUMBER = 7;
  private com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo queryExpansionInfo_;
  /**
   *
   *
   * <pre>
   * Query expansion information for the returned results.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo query_expansion_info = 7;
   * </code>
   *
   * @return Whether the queryExpansionInfo field is set.
   */
  @java.lang.Override
  public boolean hasQueryExpansionInfo() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Query expansion information for the returned results.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo query_expansion_info = 7;
   * </code>
   *
   * @return The queryExpansionInfo.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo getQueryExpansionInfo() {
    return queryExpansionInfo_ == null
        ? com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo.getDefaultInstance()
        : queryExpansionInfo_;
  }
  /**
   *
   *
   * <pre>
   * Query expansion information for the returned results.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo query_expansion_info = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfoOrBuilder
      getQueryExpansionInfoOrBuilder() {
    return queryExpansionInfo_ == null
        ? com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo.getDefaultInstance()
        : queryExpansionInfo_;
  }

  public static final int REDIRECT_URI_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object redirectUri_ = "";
  /**
   *
   *
   * <pre>
   * The URI of a customer-defined redirect page. If redirect action is
   * triggered, no search is performed, and only
   * [redirect_uri][google.cloud.retail.v2.SearchResponse.redirect_uri] and
   * [attribution_token][google.cloud.retail.v2.SearchResponse.attribution_token]
   * are set in the response.
   * </pre>
   *
   * <code>string redirect_uri = 10;</code>
   *
   * @return The redirectUri.
   */
  @java.lang.Override
  public java.lang.String getRedirectUri() {
    java.lang.Object ref = redirectUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      redirectUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URI of a customer-defined redirect page. If redirect action is
   * triggered, no search is performed, and only
   * [redirect_uri][google.cloud.retail.v2.SearchResponse.redirect_uri] and
   * [attribution_token][google.cloud.retail.v2.SearchResponse.attribution_token]
   * are set in the response.
   * </pre>
   *
   * <code>string redirect_uri = 10;</code>
   *
   * @return The bytes for redirectUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRedirectUriBytes() {
    java.lang.Object ref = redirectUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      redirectUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APPLIED_CONTROLS_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList appliedControls_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The fully qualified resource name of applied
   * [controls](https://cloud.google.com/retail/docs/serving-control-rules).
   * </pre>
   *
   * <code>repeated string applied_controls = 12;</code>
   *
   * @return A list containing the appliedControls.
   */
  public com.google.protobuf.ProtocolStringList getAppliedControlsList() {
    return appliedControls_;
  }
  /**
   *
   *
   * <pre>
   * The fully qualified resource name of applied
   * [controls](https://cloud.google.com/retail/docs/serving-control-rules).
   * </pre>
   *
   * <code>repeated string applied_controls = 12;</code>
   *
   * @return The count of appliedControls.
   */
  public int getAppliedControlsCount() {
    return appliedControls_.size();
  }
  /**
   *
   *
   * <pre>
   * The fully qualified resource name of applied
   * [controls](https://cloud.google.com/retail/docs/serving-control-rules).
   * </pre>
   *
   * <code>repeated string applied_controls = 12;</code>
   *
   * @param index The index of the element to return.
   * @return The appliedControls at the given index.
   */
  public java.lang.String getAppliedControls(int index) {
    return appliedControls_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The fully qualified resource name of applied
   * [controls](https://cloud.google.com/retail/docs/serving-control-rules).
   * </pre>
   *
   * <code>repeated string applied_controls = 12;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the appliedControls at the given index.
   */
  public com.google.protobuf.ByteString getAppliedControlsBytes(int index) {
    return appliedControls_.getByteString(index);
  }

  public static final int INVALID_CONDITION_BOOST_SPECS_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec>
      invalidConditionBoostSpecs_;
  /**
   *
   *
   * <pre>
   * The invalid
   * [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
   * that are not applied during serving.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec invalid_condition_boost_specs = 14;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec>
      getInvalidConditionBoostSpecsList() {
    return invalidConditionBoostSpecs_;
  }
  /**
   *
   *
   * <pre>
   * The invalid
   * [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
   * that are not applied during serving.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec invalid_condition_boost_specs = 14;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpecOrBuilder>
      getInvalidConditionBoostSpecsOrBuilderList() {
    return invalidConditionBoostSpecs_;
  }
  /**
   *
   *
   * <pre>
   * The invalid
   * [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
   * that are not applied during serving.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec invalid_condition_boost_specs = 14;
   * </code>
   */
  @java.lang.Override
  public int getInvalidConditionBoostSpecsCount() {
    return invalidConditionBoostSpecs_.size();
  }
  /**
   *
   *
   * <pre>
   * The invalid
   * [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
   * that are not applied during serving.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec invalid_condition_boost_specs = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec
      getInvalidConditionBoostSpecs(int index) {
    return invalidConditionBoostSpecs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The invalid
   * [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
   * that are not applied during serving.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec invalid_condition_boost_specs = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpecOrBuilder
      getInvalidConditionBoostSpecsOrBuilder(int index) {
    return invalidConditionBoostSpecs_.get(index);
  }

  public static final int EXPERIMENT_INFO_FIELD_NUMBER = 17;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.retail.v2.ExperimentInfo> experimentInfo_;
  /**
   *
   *
   * <pre>
   * Metadata related to A/B testing [Experiment][] associated with this
   * response. Only exists when an experiment is triggered.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.ExperimentInfo experiment_info = 17;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2.ExperimentInfo> getExperimentInfoList() {
    return experimentInfo_;
  }
  /**
   *
   *
   * <pre>
   * Metadata related to A/B testing [Experiment][] associated with this
   * response. Only exists when an experiment is triggered.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.ExperimentInfo experiment_info = 17;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.retail.v2.ExperimentInfoOrBuilder>
      getExperimentInfoOrBuilderList() {
    return experimentInfo_;
  }
  /**
   *
   *
   * <pre>
   * Metadata related to A/B testing [Experiment][] associated with this
   * response. Only exists when an experiment is triggered.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.ExperimentInfo experiment_info = 17;</code>
   */
  @java.lang.Override
  public int getExperimentInfoCount() {
    return experimentInfo_.size();
  }
  /**
   *
   *
   * <pre>
   * Metadata related to A/B testing [Experiment][] associated with this
   * response. Only exists when an experiment is triggered.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.ExperimentInfo experiment_info = 17;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.ExperimentInfo getExperimentInfo(int index) {
    return experimentInfo_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Metadata related to A/B testing [Experiment][] associated with this
   * response. Only exists when an experiment is triggered.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2.ExperimentInfo experiment_info = 17;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.ExperimentInfoOrBuilder getExperimentInfoOrBuilder(int index) {
    return experimentInfo_.get(index);
  }

  public static final int CONVERSATIONAL_SEARCH_RESULT_FIELD_NUMBER = 18;
  private com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
      conversationalSearchResult_;
  /**
   *
   *
   * <pre>
   * This field specifies all related information that is needed on client
   * side for UI rendering of conversational retail search.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult conversational_search_result = 18;
   * </code>
   *
   * @return Whether the conversationalSearchResult field is set.
   */
  @java.lang.Override
  public boolean hasConversationalSearchResult() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * This field specifies all related information that is needed on client
   * side for UI rendering of conversational retail search.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult conversational_search_result = 18;
   * </code>
   *
   * @return The conversationalSearchResult.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
      getConversationalSearchResult() {
    return conversationalSearchResult_ == null
        ? com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.getDefaultInstance()
        : conversationalSearchResult_;
  }
  /**
   *
   *
   * <pre>
   * This field specifies all related information that is needed on client
   * side for UI rendering of conversational retail search.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult conversational_search_result = 18;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResultOrBuilder
      getConversationalSearchResultOrBuilder() {
    return conversationalSearchResult_ == null
        ? com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.getDefaultInstance()
        : conversationalSearchResult_;
  }

  public static final int TILE_NAVIGATION_RESULT_FIELD_NUMBER = 19;
  private com.google.cloud.retail.v2.SearchResponse.TileNavigationResult tileNavigationResult_;
  /**
   *
   *
   * <pre>
   * This field specifies all related information for tile navigation that will
   * be used in client side.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.SearchResponse.TileNavigationResult tile_navigation_result = 19;
   * </code>
   *
   * @return Whether the tileNavigationResult field is set.
   */
  @java.lang.Override
  public boolean hasTileNavigationResult() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * This field specifies all related information for tile navigation that will
   * be used in client side.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.SearchResponse.TileNavigationResult tile_navigation_result = 19;
   * </code>
   *
   * @return The tileNavigationResult.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.SearchResponse.TileNavigationResult getTileNavigationResult() {
    return tileNavigationResult_ == null
        ? com.google.cloud.retail.v2.SearchResponse.TileNavigationResult.getDefaultInstance()
        : tileNavigationResult_;
  }
  /**
   *
   *
   * <pre>
   * This field specifies all related information for tile navigation that will
   * be used in client side.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.SearchResponse.TileNavigationResult tile_navigation_result = 19;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.SearchResponse.TileNavigationResultOrBuilder
      getTileNavigationResultOrBuilder() {
    return tileNavigationResult_ == null
        ? com.google.cloud.retail.v2.SearchResponse.TileNavigationResult.getDefaultInstance()
        : tileNavigationResult_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < results_.size(); i++) {
      output.writeMessage(1, results_.get(i));
    }
    for (int i = 0; i < facets_.size(); i++) {
      output.writeMessage(2, facets_.get(i));
    }
    if (totalSize_ != 0) {
      output.writeInt32(3, totalSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(correctedQuery_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, correctedQuery_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(attributionToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, attributionToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, nextPageToken_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getQueryExpansionInfo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(redirectUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, redirectUri_);
    }
    for (int i = 0; i < appliedControls_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, appliedControls_.getRaw(i));
    }
    for (int i = 0; i < invalidConditionBoostSpecs_.size(); i++) {
      output.writeMessage(14, invalidConditionBoostSpecs_.get(i));
    }
    for (int i = 0; i < experimentInfo_.size(); i++) {
      output.writeMessage(17, experimentInfo_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(18, getConversationalSearchResult());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(19, getTileNavigationResult());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < results_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, results_.get(i));
    }
    for (int i = 0; i < facets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, facets_.get(i));
    }
    if (totalSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, totalSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(correctedQuery_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, correctedQuery_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(attributionToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, attributionToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, nextPageToken_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getQueryExpansionInfo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(redirectUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, redirectUri_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < appliedControls_.size(); i++) {
        dataSize += computeStringSizeNoTag(appliedControls_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAppliedControlsList().size();
    }
    for (int i = 0; i < invalidConditionBoostSpecs_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14, invalidConditionBoostSpecs_.get(i));
    }
    for (int i = 0; i < experimentInfo_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, experimentInfo_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              18, getConversationalSearchResult());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(19, getTileNavigationResult());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2.SearchResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2.SearchResponse other =
        (com.google.cloud.retail.v2.SearchResponse) obj;

    if (!getResultsList().equals(other.getResultsList())) return false;
    if (!getFacetsList().equals(other.getFacetsList())) return false;
    if (getTotalSize() != other.getTotalSize()) return false;
    if (!getCorrectedQuery().equals(other.getCorrectedQuery())) return false;
    if (!getAttributionToken().equals(other.getAttributionToken())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (hasQueryExpansionInfo() != other.hasQueryExpansionInfo()) return false;
    if (hasQueryExpansionInfo()) {
      if (!getQueryExpansionInfo().equals(other.getQueryExpansionInfo())) return false;
    }
    if (!getRedirectUri().equals(other.getRedirectUri())) return false;
    if (!getAppliedControlsList().equals(other.getAppliedControlsList())) return false;
    if (!getInvalidConditionBoostSpecsList().equals(other.getInvalidConditionBoostSpecsList()))
      return false;
    if (!getExperimentInfoList().equals(other.getExperimentInfoList())) return false;
    if (hasConversationalSearchResult() != other.hasConversationalSearchResult()) return false;
    if (hasConversationalSearchResult()) {
      if (!getConversationalSearchResult().equals(other.getConversationalSearchResult()))
        return false;
    }
    if (hasTileNavigationResult() != other.hasTileNavigationResult()) return false;
    if (hasTileNavigationResult()) {
      if (!getTileNavigationResult().equals(other.getTileNavigationResult())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getResultsCount() > 0) {
      hash = (37 * hash) + RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getResultsList().hashCode();
    }
    if (getFacetsCount() > 0) {
      hash = (37 * hash) + FACETS_FIELD_NUMBER;
      hash = (53 * hash) + getFacetsList().hashCode();
    }
    hash = (37 * hash) + TOTAL_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getTotalSize();
    hash = (37 * hash) + CORRECTED_QUERY_FIELD_NUMBER;
    hash = (53 * hash) + getCorrectedQuery().hashCode();
    hash = (37 * hash) + ATTRIBUTION_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getAttributionToken().hashCode();
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    if (hasQueryExpansionInfo()) {
      hash = (37 * hash) + QUERY_EXPANSION_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getQueryExpansionInfo().hashCode();
    }
    hash = (37 * hash) + REDIRECT_URI_FIELD_NUMBER;
    hash = (53 * hash) + getRedirectUri().hashCode();
    if (getAppliedControlsCount() > 0) {
      hash = (37 * hash) + APPLIED_CONTROLS_FIELD_NUMBER;
      hash = (53 * hash) + getAppliedControlsList().hashCode();
    }
    if (getInvalidConditionBoostSpecsCount() > 0) {
      hash = (37 * hash) + INVALID_CONDITION_BOOST_SPECS_FIELD_NUMBER;
      hash = (53 * hash) + getInvalidConditionBoostSpecsList().hashCode();
    }
    if (getExperimentInfoCount() > 0) {
      hash = (37 * hash) + EXPERIMENT_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getExperimentInfoList().hashCode();
    }
    if (hasConversationalSearchResult()) {
      hash = (37 * hash) + CONVERSATIONAL_SEARCH_RESULT_FIELD_NUMBER;
      hash = (53 * hash) + getConversationalSearchResult().hashCode();
    }
    if (hasTileNavigationResult()) {
      hash = (37 * hash) + TILE_NAVIGATION_RESULT_FIELD_NUMBER;
      hash = (53 * hash) + getTileNavigationResult().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2.SearchResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.SearchResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.SearchResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.SearchResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.SearchResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.SearchResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.SearchResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.SearchResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.SearchResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.SearchResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.SearchResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.SearchResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2.SearchResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for
   * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2.SearchResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.SearchResponse)
      com.google.cloud.retail.v2.SearchResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2.SearchServiceProto
          .internal_static_google_cloud_retail_v2_SearchResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2.SearchServiceProto
          .internal_static_google_cloud_retail_v2_SearchResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2.SearchResponse.class,
              com.google.cloud.retail.v2.SearchResponse.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2.SearchResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getResultsFieldBuilder();
        getFacetsFieldBuilder();
        getQueryExpansionInfoFieldBuilder();
        getInvalidConditionBoostSpecsFieldBuilder();
        getExperimentInfoFieldBuilder();
        getConversationalSearchResultFieldBuilder();
        getTileNavigationResultFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (resultsBuilder_ == null) {
        results_ = java.util.Collections.emptyList();
      } else {
        results_ = null;
        resultsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (facetsBuilder_ == null) {
        facets_ = java.util.Collections.emptyList();
      } else {
        facets_ = null;
        facetsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      totalSize_ = 0;
      correctedQuery_ = "";
      attributionToken_ = "";
      nextPageToken_ = "";
      queryExpansionInfo_ = null;
      if (queryExpansionInfoBuilder_ != null) {
        queryExpansionInfoBuilder_.dispose();
        queryExpansionInfoBuilder_ = null;
      }
      redirectUri_ = "";
      appliedControls_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (invalidConditionBoostSpecsBuilder_ == null) {
        invalidConditionBoostSpecs_ = java.util.Collections.emptyList();
      } else {
        invalidConditionBoostSpecs_ = null;
        invalidConditionBoostSpecsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      if (experimentInfoBuilder_ == null) {
        experimentInfo_ = java.util.Collections.emptyList();
      } else {
        experimentInfo_ = null;
        experimentInfoBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      conversationalSearchResult_ = null;
      if (conversationalSearchResultBuilder_ != null) {
        conversationalSearchResultBuilder_.dispose();
        conversationalSearchResultBuilder_ = null;
      }
      tileNavigationResult_ = null;
      if (tileNavigationResultBuilder_ != null) {
        tileNavigationResultBuilder_.dispose();
        tileNavigationResultBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2.SearchServiceProto
          .internal_static_google_cloud_retail_v2_SearchResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.SearchResponse getDefaultInstanceForType() {
      return com.google.cloud.retail.v2.SearchResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.SearchResponse build() {
      com.google.cloud.retail.v2.SearchResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.SearchResponse buildPartial() {
      com.google.cloud.retail.v2.SearchResponse result =
          new com.google.cloud.retail.v2.SearchResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.retail.v2.SearchResponse result) {
      if (resultsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          results_ = java.util.Collections.unmodifiableList(results_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.results_ = results_;
      } else {
        result.results_ = resultsBuilder_.build();
      }
      if (facetsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          facets_ = java.util.Collections.unmodifiableList(facets_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.facets_ = facets_;
      } else {
        result.facets_ = facetsBuilder_.build();
      }
      if (invalidConditionBoostSpecsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          invalidConditionBoostSpecs_ =
              java.util.Collections.unmodifiableList(invalidConditionBoostSpecs_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.invalidConditionBoostSpecs_ = invalidConditionBoostSpecs_;
      } else {
        result.invalidConditionBoostSpecs_ = invalidConditionBoostSpecsBuilder_.build();
      }
      if (experimentInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          experimentInfo_ = java.util.Collections.unmodifiableList(experimentInfo_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.experimentInfo_ = experimentInfo_;
      } else {
        result.experimentInfo_ = experimentInfoBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.retail.v2.SearchResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.totalSize_ = totalSize_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.correctedQuery_ = correctedQuery_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.attributionToken_ = attributionToken_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.nextPageToken_ = nextPageToken_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.queryExpansionInfo_ =
            queryExpansionInfoBuilder_ == null
                ? queryExpansionInfo_
                : queryExpansionInfoBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.redirectUri_ = redirectUri_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        appliedControls_.makeImmutable();
        result.appliedControls_ = appliedControls_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.conversationalSearchResult_ =
            conversationalSearchResultBuilder_ == null
                ? conversationalSearchResult_
                : conversationalSearchResultBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.tileNavigationResult_ =
            tileNavigationResultBuilder_ == null
                ? tileNavigationResult_
                : tileNavigationResultBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2.SearchResponse) {
        return mergeFrom((com.google.cloud.retail.v2.SearchResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2.SearchResponse other) {
      if (other == com.google.cloud.retail.v2.SearchResponse.getDefaultInstance()) return this;
      if (resultsBuilder_ == null) {
        if (!other.results_.isEmpty()) {
          if (results_.isEmpty()) {
            results_ = other.results_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureResultsIsMutable();
            results_.addAll(other.results_);
          }
          onChanged();
        }
      } else {
        if (!other.results_.isEmpty()) {
          if (resultsBuilder_.isEmpty()) {
            resultsBuilder_.dispose();
            resultsBuilder_ = null;
            results_ = other.results_;
            bitField0_ = (bitField0_ & ~0x00000001);
            resultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getResultsFieldBuilder()
                    : null;
          } else {
            resultsBuilder_.addAllMessages(other.results_);
          }
        }
      }
      if (facetsBuilder_ == null) {
        if (!other.facets_.isEmpty()) {
          if (facets_.isEmpty()) {
            facets_ = other.facets_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureFacetsIsMutable();
            facets_.addAll(other.facets_);
          }
          onChanged();
        }
      } else {
        if (!other.facets_.isEmpty()) {
          if (facetsBuilder_.isEmpty()) {
            facetsBuilder_.dispose();
            facetsBuilder_ = null;
            facets_ = other.facets_;
            bitField0_ = (bitField0_ & ~0x00000002);
            facetsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFacetsFieldBuilder()
                    : null;
          } else {
            facetsBuilder_.addAllMessages(other.facets_);
          }
        }
      }
      if (other.getTotalSize() != 0) {
        setTotalSize(other.getTotalSize());
      }
      if (!other.getCorrectedQuery().isEmpty()) {
        correctedQuery_ = other.correctedQuery_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getAttributionToken().isEmpty()) {
        attributionToken_ = other.attributionToken_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasQueryExpansionInfo()) {
        mergeQueryExpansionInfo(other.getQueryExpansionInfo());
      }
      if (!other.getRedirectUri().isEmpty()) {
        redirectUri_ = other.redirectUri_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.appliedControls_.isEmpty()) {
        if (appliedControls_.isEmpty()) {
          appliedControls_ = other.appliedControls_;
          bitField0_ |= 0x00000100;
        } else {
          ensureAppliedControlsIsMutable();
          appliedControls_.addAll(other.appliedControls_);
        }
        onChanged();
      }
      if (invalidConditionBoostSpecsBuilder_ == null) {
        if (!other.invalidConditionBoostSpecs_.isEmpty()) {
          if (invalidConditionBoostSpecs_.isEmpty()) {
            invalidConditionBoostSpecs_ = other.invalidConditionBoostSpecs_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensureInvalidConditionBoostSpecsIsMutable();
            invalidConditionBoostSpecs_.addAll(other.invalidConditionBoostSpecs_);
          }
          onChanged();
        }
      } else {
        if (!other.invalidConditionBoostSpecs_.isEmpty()) {
          if (invalidConditionBoostSpecsBuilder_.isEmpty()) {
            invalidConditionBoostSpecsBuilder_.dispose();
            invalidConditionBoostSpecsBuilder_ = null;
            invalidConditionBoostSpecs_ = other.invalidConditionBoostSpecs_;
            bitField0_ = (bitField0_ & ~0x00000200);
            invalidConditionBoostSpecsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInvalidConditionBoostSpecsFieldBuilder()
                    : null;
          } else {
            invalidConditionBoostSpecsBuilder_.addAllMessages(other.invalidConditionBoostSpecs_);
          }
        }
      }
      if (experimentInfoBuilder_ == null) {
        if (!other.experimentInfo_.isEmpty()) {
          if (experimentInfo_.isEmpty()) {
            experimentInfo_ = other.experimentInfo_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureExperimentInfoIsMutable();
            experimentInfo_.addAll(other.experimentInfo_);
          }
          onChanged();
        }
      } else {
        if (!other.experimentInfo_.isEmpty()) {
          if (experimentInfoBuilder_.isEmpty()) {
            experimentInfoBuilder_.dispose();
            experimentInfoBuilder_ = null;
            experimentInfo_ = other.experimentInfo_;
            bitField0_ = (bitField0_ & ~0x00000400);
            experimentInfoBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getExperimentInfoFieldBuilder()
                    : null;
          } else {
            experimentInfoBuilder_.addAllMessages(other.experimentInfo_);
          }
        }
      }
      if (other.hasConversationalSearchResult()) {
        mergeConversationalSearchResult(other.getConversationalSearchResult());
      }
      if (other.hasTileNavigationResult()) {
        mergeTileNavigationResult(other.getTileNavigationResult());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.retail.v2.SearchResponse.SearchResult m =
                    input.readMessage(
                        com.google.cloud.retail.v2.SearchResponse.SearchResult.parser(),
                        extensionRegistry);
                if (resultsBuilder_ == null) {
                  ensureResultsIsMutable();
                  results_.add(m);
                } else {
                  resultsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.retail.v2.SearchResponse.Facet m =
                    input.readMessage(
                        com.google.cloud.retail.v2.SearchResponse.Facet.parser(),
                        extensionRegistry);
                if (facetsBuilder_ == null) {
                  ensureFacetsIsMutable();
                  facets_.add(m);
                } else {
                  facetsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 24:
              {
                totalSize_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                correctedQuery_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                attributionToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                nextPageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getQueryExpansionInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 82:
              {
                redirectUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 82
            case 98:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAppliedControlsIsMutable();
                appliedControls_.add(s);
                break;
              } // case 98
            case 114:
              {
                com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec m =
                    input.readMessage(
                        com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec
                            .parser(),
                        extensionRegistry);
                if (invalidConditionBoostSpecsBuilder_ == null) {
                  ensureInvalidConditionBoostSpecsIsMutable();
                  invalidConditionBoostSpecs_.add(m);
                } else {
                  invalidConditionBoostSpecsBuilder_.addMessage(m);
                }
                break;
              } // case 114
            case 138:
              {
                com.google.cloud.retail.v2.ExperimentInfo m =
                    input.readMessage(
                        com.google.cloud.retail.v2.ExperimentInfo.parser(), extensionRegistry);
                if (experimentInfoBuilder_ == null) {
                  ensureExperimentInfoIsMutable();
                  experimentInfo_.add(m);
                } else {
                  experimentInfoBuilder_.addMessage(m);
                }
                break;
              } // case 138
            case 146:
              {
                input.readMessage(
                    getConversationalSearchResultFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 146
            case 154:
              {
                input.readMessage(
                    getTileNavigationResultFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 154
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.retail.v2.SearchResponse.SearchResult> results_ =
        java.util.Collections.emptyList();

    private void ensureResultsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        results_ =
            new java.util.ArrayList<com.google.cloud.retail.v2.SearchResponse.SearchResult>(
                results_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2.SearchResponse.SearchResult,
            com.google.cloud.retail.v2.SearchResponse.SearchResult.Builder,
            com.google.cloud.retail.v2.SearchResponse.SearchResultOrBuilder>
        resultsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of matched items. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.SearchResult results = 1;</code>
     */
    public java.util.List<com.google.cloud.retail.v2.SearchResponse.SearchResult> getResultsList() {
      if (resultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(results_);
      } else {
        return resultsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of matched items. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.SearchResult results = 1;</code>
     */
    public int getResultsCount() {
      if (resultsBuilder_ == null) {
        return results_.size();
      } else {
        return resultsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of matched items. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.SearchResult results = 1;</code>
     */
    public com.google.cloud.retail.v2.SearchResponse.SearchResult getResults(int index) {
      if (resultsBuilder_ == null) {
        return results_.get(index);
      } else {
        return resultsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of matched items. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.SearchResult results = 1;</code>
     */
    public Builder setResults(
        int index, com.google.cloud.retail.v2.SearchResponse.SearchResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.set(index, value);
        onChanged();
      } else {
        resultsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of matched items. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.SearchResult results = 1;</code>
     */
    public Builder setResults(
        int index, com.google.cloud.retail.v2.SearchResponse.SearchResult.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.set(index, builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of matched items. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.SearchResult results = 1;</code>
     */
    public Builder addResults(com.google.cloud.retail.v2.SearchResponse.SearchResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.add(value);
        onChanged();
      } else {
        resultsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of matched items. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.SearchResult results = 1;</code>
     */
    public Builder addResults(
        int index, com.google.cloud.retail.v2.SearchResponse.SearchResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.add(index, value);
        onChanged();
      } else {
        resultsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of matched items. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.SearchResult results = 1;</code>
     */
    public Builder addResults(
        com.google.cloud.retail.v2.SearchResponse.SearchResult.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.add(builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of matched items. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.SearchResult results = 1;</code>
     */
    public Builder addResults(
        int index, com.google.cloud.retail.v2.SearchResponse.SearchResult.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.add(index, builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of matched items. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.SearchResult results = 1;</code>
     */
    public Builder addAllResults(
        java.lang.Iterable<? extends com.google.cloud.retail.v2.SearchResponse.SearchResult>
            values) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, results_);
        onChanged();
      } else {
        resultsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of matched items. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.SearchResult results = 1;</code>
     */
    public Builder clearResults() {
      if (resultsBuilder_ == null) {
        results_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        resultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of matched items. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.SearchResult results = 1;</code>
     */
    public Builder removeResults(int index) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.remove(index);
        onChanged();
      } else {
        resultsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of matched items. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.SearchResult results = 1;</code>
     */
    public com.google.cloud.retail.v2.SearchResponse.SearchResult.Builder getResultsBuilder(
        int index) {
      return getResultsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of matched items. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.SearchResult results = 1;</code>
     */
    public com.google.cloud.retail.v2.SearchResponse.SearchResultOrBuilder getResultsOrBuilder(
        int index) {
      if (resultsBuilder_ == null) {
        return results_.get(index);
      } else {
        return resultsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of matched items. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.SearchResult results = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.retail.v2.SearchResponse.SearchResultOrBuilder>
        getResultsOrBuilderList() {
      if (resultsBuilder_ != null) {
        return resultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(results_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of matched items. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.SearchResult results = 1;</code>
     */
    public com.google.cloud.retail.v2.SearchResponse.SearchResult.Builder addResultsBuilder() {
      return getResultsFieldBuilder()
          .addBuilder(com.google.cloud.retail.v2.SearchResponse.SearchResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of matched items. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.SearchResult results = 1;</code>
     */
    public com.google.cloud.retail.v2.SearchResponse.SearchResult.Builder addResultsBuilder(
        int index) {
      return getResultsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.retail.v2.SearchResponse.SearchResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of matched items. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.SearchResult results = 1;</code>
     */
    public java.util.List<com.google.cloud.retail.v2.SearchResponse.SearchResult.Builder>
        getResultsBuilderList() {
      return getResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2.SearchResponse.SearchResult,
            com.google.cloud.retail.v2.SearchResponse.SearchResult.Builder,
            com.google.cloud.retail.v2.SearchResponse.SearchResultOrBuilder>
        getResultsFieldBuilder() {
      if (resultsBuilder_ == null) {
        resultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2.SearchResponse.SearchResult,
                com.google.cloud.retail.v2.SearchResponse.SearchResult.Builder,
                com.google.cloud.retail.v2.SearchResponse.SearchResultOrBuilder>(
                results_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        results_ = null;
      }
      return resultsBuilder_;
    }

    private java.util.List<com.google.cloud.retail.v2.SearchResponse.Facet> facets_ =
        java.util.Collections.emptyList();

    private void ensureFacetsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        facets_ = new java.util.ArrayList<com.google.cloud.retail.v2.SearchResponse.Facet>(facets_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2.SearchResponse.Facet,
            com.google.cloud.retail.v2.SearchResponse.Facet.Builder,
            com.google.cloud.retail.v2.SearchResponse.FacetOrBuilder>
        facetsBuilder_;

    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet facets = 2;</code>
     */
    public java.util.List<com.google.cloud.retail.v2.SearchResponse.Facet> getFacetsList() {
      if (facetsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(facets_);
      } else {
        return facetsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet facets = 2;</code>
     */
    public int getFacetsCount() {
      if (facetsBuilder_ == null) {
        return facets_.size();
      } else {
        return facetsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet facets = 2;</code>
     */
    public com.google.cloud.retail.v2.SearchResponse.Facet getFacets(int index) {
      if (facetsBuilder_ == null) {
        return facets_.get(index);
      } else {
        return facetsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet facets = 2;</code>
     */
    public Builder setFacets(int index, com.google.cloud.retail.v2.SearchResponse.Facet value) {
      if (facetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFacetsIsMutable();
        facets_.set(index, value);
        onChanged();
      } else {
        facetsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet facets = 2;</code>
     */
    public Builder setFacets(
        int index, com.google.cloud.retail.v2.SearchResponse.Facet.Builder builderForValue) {
      if (facetsBuilder_ == null) {
        ensureFacetsIsMutable();
        facets_.set(index, builderForValue.build());
        onChanged();
      } else {
        facetsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet facets = 2;</code>
     */
    public Builder addFacets(com.google.cloud.retail.v2.SearchResponse.Facet value) {
      if (facetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFacetsIsMutable();
        facets_.add(value);
        onChanged();
      } else {
        facetsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet facets = 2;</code>
     */
    public Builder addFacets(int index, com.google.cloud.retail.v2.SearchResponse.Facet value) {
      if (facetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFacetsIsMutable();
        facets_.add(index, value);
        onChanged();
      } else {
        facetsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet facets = 2;</code>
     */
    public Builder addFacets(
        com.google.cloud.retail.v2.SearchResponse.Facet.Builder builderForValue) {
      if (facetsBuilder_ == null) {
        ensureFacetsIsMutable();
        facets_.add(builderForValue.build());
        onChanged();
      } else {
        facetsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet facets = 2;</code>
     */
    public Builder addFacets(
        int index, com.google.cloud.retail.v2.SearchResponse.Facet.Builder builderForValue) {
      if (facetsBuilder_ == null) {
        ensureFacetsIsMutable();
        facets_.add(index, builderForValue.build());
        onChanged();
      } else {
        facetsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet facets = 2;</code>
     */
    public Builder addAllFacets(
        java.lang.Iterable<? extends com.google.cloud.retail.v2.SearchResponse.Facet> values) {
      if (facetsBuilder_ == null) {
        ensureFacetsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, facets_);
        onChanged();
      } else {
        facetsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet facets = 2;</code>
     */
    public Builder clearFacets() {
      if (facetsBuilder_ == null) {
        facets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        facetsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet facets = 2;</code>
     */
    public Builder removeFacets(int index) {
      if (facetsBuilder_ == null) {
        ensureFacetsIsMutable();
        facets_.remove(index);
        onChanged();
      } else {
        facetsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet facets = 2;</code>
     */
    public com.google.cloud.retail.v2.SearchResponse.Facet.Builder getFacetsBuilder(int index) {
      return getFacetsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet facets = 2;</code>
     */
    public com.google.cloud.retail.v2.SearchResponse.FacetOrBuilder getFacetsOrBuilder(int index) {
      if (facetsBuilder_ == null) {
        return facets_.get(index);
      } else {
        return facetsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet facets = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.retail.v2.SearchResponse.FacetOrBuilder>
        getFacetsOrBuilderList() {
      if (facetsBuilder_ != null) {
        return facetsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(facets_);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet facets = 2;</code>
     */
    public com.google.cloud.retail.v2.SearchResponse.Facet.Builder addFacetsBuilder() {
      return getFacetsFieldBuilder()
          .addBuilder(com.google.cloud.retail.v2.SearchResponse.Facet.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet facets = 2;</code>
     */
    public com.google.cloud.retail.v2.SearchResponse.Facet.Builder addFacetsBuilder(int index) {
      return getFacetsFieldBuilder()
          .addBuilder(index, com.google.cloud.retail.v2.SearchResponse.Facet.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.SearchResponse.Facet facets = 2;</code>
     */
    public java.util.List<com.google.cloud.retail.v2.SearchResponse.Facet.Builder>
        getFacetsBuilderList() {
      return getFacetsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2.SearchResponse.Facet,
            com.google.cloud.retail.v2.SearchResponse.Facet.Builder,
            com.google.cloud.retail.v2.SearchResponse.FacetOrBuilder>
        getFacetsFieldBuilder() {
      if (facetsBuilder_ == null) {
        facetsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2.SearchResponse.Facet,
                com.google.cloud.retail.v2.SearchResponse.Facet.Builder,
                com.google.cloud.retail.v2.SearchResponse.FacetOrBuilder>(
                facets_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        facets_ = null;
      }
      return facetsBuilder_;
    }

    private int totalSize_;
    /**
     *
     *
     * <pre>
     * The estimated total count of matched items irrespective of pagination. The
     * count of [results][google.cloud.retail.v2.SearchResponse.results] returned
     * by pagination may be less than the
     * [total_size][google.cloud.retail.v2.SearchResponse.total_size] that
     * matches.
     * </pre>
     *
     * <code>int32 total_size = 3;</code>
     *
     * @return The totalSize.
     */
    @java.lang.Override
    public int getTotalSize() {
      return totalSize_;
    }
    /**
     *
     *
     * <pre>
     * The estimated total count of matched items irrespective of pagination. The
     * count of [results][google.cloud.retail.v2.SearchResponse.results] returned
     * by pagination may be less than the
     * [total_size][google.cloud.retail.v2.SearchResponse.total_size] that
     * matches.
     * </pre>
     *
     * <code>int32 total_size = 3;</code>
     *
     * @param value The totalSize to set.
     * @return This builder for chaining.
     */
    public Builder setTotalSize(int value) {

      totalSize_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The estimated total count of matched items irrespective of pagination. The
     * count of [results][google.cloud.retail.v2.SearchResponse.results] returned
     * by pagination may be less than the
     * [total_size][google.cloud.retail.v2.SearchResponse.total_size] that
     * matches.
     * </pre>
     *
     * <code>int32 total_size = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalSize() {
      bitField0_ = (bitField0_ & ~0x00000004);
      totalSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object correctedQuery_ = "";
    /**
     *
     *
     * <pre>
     * Contains the spell corrected query, if found. If the spell correction type
     * is AUTOMATIC, then the search results are based on corrected_query.
     * Otherwise the original query is used for search.
     * </pre>
     *
     * <code>string corrected_query = 4;</code>
     *
     * @return The correctedQuery.
     */
    public java.lang.String getCorrectedQuery() {
      java.lang.Object ref = correctedQuery_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        correctedQuery_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Contains the spell corrected query, if found. If the spell correction type
     * is AUTOMATIC, then the search results are based on corrected_query.
     * Otherwise the original query is used for search.
     * </pre>
     *
     * <code>string corrected_query = 4;</code>
     *
     * @return The bytes for correctedQuery.
     */
    public com.google.protobuf.ByteString getCorrectedQueryBytes() {
      java.lang.Object ref = correctedQuery_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        correctedQuery_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Contains the spell corrected query, if found. If the spell correction type
     * is AUTOMATIC, then the search results are based on corrected_query.
     * Otherwise the original query is used for search.
     * </pre>
     *
     * <code>string corrected_query = 4;</code>
     *
     * @param value The correctedQuery to set.
     * @return This builder for chaining.
     */
    public Builder setCorrectedQuery(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      correctedQuery_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains the spell corrected query, if found. If the spell correction type
     * is AUTOMATIC, then the search results are based on corrected_query.
     * Otherwise the original query is used for search.
     * </pre>
     *
     * <code>string corrected_query = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCorrectedQuery() {
      correctedQuery_ = getDefaultInstance().getCorrectedQuery();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains the spell corrected query, if found. If the spell correction type
     * is AUTOMATIC, then the search results are based on corrected_query.
     * Otherwise the original query is used for search.
     * </pre>
     *
     * <code>string corrected_query = 4;</code>
     *
     * @param value The bytes for correctedQuery to set.
     * @return This builder for chaining.
     */
    public Builder setCorrectedQueryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      correctedQuery_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object attributionToken_ = "";
    /**
     *
     *
     * <pre>
     * A unique search token. This should be included in the
     * [UserEvent][google.cloud.retail.v2.UserEvent] logs resulting from this
     * search, which enables accurate attribution of search model performance.
     * </pre>
     *
     * <code>string attribution_token = 5;</code>
     *
     * @return The attributionToken.
     */
    public java.lang.String getAttributionToken() {
      java.lang.Object ref = attributionToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        attributionToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique search token. This should be included in the
     * [UserEvent][google.cloud.retail.v2.UserEvent] logs resulting from this
     * search, which enables accurate attribution of search model performance.
     * </pre>
     *
     * <code>string attribution_token = 5;</code>
     *
     * @return The bytes for attributionToken.
     */
    public com.google.protobuf.ByteString getAttributionTokenBytes() {
      java.lang.Object ref = attributionToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        attributionToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique search token. This should be included in the
     * [UserEvent][google.cloud.retail.v2.UserEvent] logs resulting from this
     * search, which enables accurate attribution of search model performance.
     * </pre>
     *
     * <code>string attribution_token = 5;</code>
     *
     * @param value The attributionToken to set.
     * @return This builder for chaining.
     */
    public Builder setAttributionToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      attributionToken_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique search token. This should be included in the
     * [UserEvent][google.cloud.retail.v2.UserEvent] logs resulting from this
     * search, which enables accurate attribution of search model performance.
     * </pre>
     *
     * <code>string attribution_token = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAttributionToken() {
      attributionToken_ = getDefaultInstance().getAttributionToken();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique search token. This should be included in the
     * [UserEvent][google.cloud.retail.v2.UserEvent] logs resulting from this
     * search, which enables accurate attribution of search model performance.
     * </pre>
     *
     * <code>string attribution_token = 5;</code>
     *
     * @param value The bytes for attributionToken to set.
     * @return This builder for chaining.
     */
    public Builder setAttributionTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      attributionToken_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * A token that can be sent as
     * [SearchRequest.page_token][google.cloud.retail.v2.SearchRequest.page_token]
     * to retrieve the next page. If this field is omitted, there are no
     * subsequent pages.
     * </pre>
     *
     * <code>string next_page_token = 6;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A token that can be sent as
     * [SearchRequest.page_token][google.cloud.retail.v2.SearchRequest.page_token]
     * to retrieve the next page. If this field is omitted, there are no
     * subsequent pages.
     * </pre>
     *
     * <code>string next_page_token = 6;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A token that can be sent as
     * [SearchRequest.page_token][google.cloud.retail.v2.SearchRequest.page_token]
     * to retrieve the next page. If this field is omitted, there are no
     * subsequent pages.
     * </pre>
     *
     * <code>string next_page_token = 6;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextPageToken_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A token that can be sent as
     * [SearchRequest.page_token][google.cloud.retail.v2.SearchRequest.page_token]
     * to retrieve the next page. If this field is omitted, there are no
     * subsequent pages.
     * </pre>
     *
     * <code>string next_page_token = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {
      nextPageToken_ = getDefaultInstance().getNextPageToken();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A token that can be sent as
     * [SearchRequest.page_token][google.cloud.retail.v2.SearchRequest.page_token]
     * to retrieve the next page. If this field is omitted, there are no
     * subsequent pages.
     * </pre>
     *
     * <code>string next_page_token = 6;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextPageToken_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo queryExpansionInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo,
            com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo.Builder,
            com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfoOrBuilder>
        queryExpansionInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Query expansion information for the returned results.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo query_expansion_info = 7;
     * </code>
     *
     * @return Whether the queryExpansionInfo field is set.
     */
    public boolean hasQueryExpansionInfo() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Query expansion information for the returned results.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo query_expansion_info = 7;
     * </code>
     *
     * @return The queryExpansionInfo.
     */
    public com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo getQueryExpansionInfo() {
      if (queryExpansionInfoBuilder_ == null) {
        return queryExpansionInfo_ == null
            ? com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo.getDefaultInstance()
            : queryExpansionInfo_;
      } else {
        return queryExpansionInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Query expansion information for the returned results.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo query_expansion_info = 7;
     * </code>
     */
    public Builder setQueryExpansionInfo(
        com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo value) {
      if (queryExpansionInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryExpansionInfo_ = value;
      } else {
        queryExpansionInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query expansion information for the returned results.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo query_expansion_info = 7;
     * </code>
     */
    public Builder setQueryExpansionInfo(
        com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo.Builder builderForValue) {
      if (queryExpansionInfoBuilder_ == null) {
        queryExpansionInfo_ = builderForValue.build();
      } else {
        queryExpansionInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query expansion information for the returned results.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo query_expansion_info = 7;
     * </code>
     */
    public Builder mergeQueryExpansionInfo(
        com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo value) {
      if (queryExpansionInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && queryExpansionInfo_ != null
            && queryExpansionInfo_
                != com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo
                    .getDefaultInstance()) {
          getQueryExpansionInfoBuilder().mergeFrom(value);
        } else {
          queryExpansionInfo_ = value;
        }
      } else {
        queryExpansionInfoBuilder_.mergeFrom(value);
      }
      if (queryExpansionInfo_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query expansion information for the returned results.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo query_expansion_info = 7;
     * </code>
     */
    public Builder clearQueryExpansionInfo() {
      bitField0_ = (bitField0_ & ~0x00000040);
      queryExpansionInfo_ = null;
      if (queryExpansionInfoBuilder_ != null) {
        queryExpansionInfoBuilder_.dispose();
        queryExpansionInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query expansion information for the returned results.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo query_expansion_info = 7;
     * </code>
     */
    public com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo.Builder
        getQueryExpansionInfoBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getQueryExpansionInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Query expansion information for the returned results.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo query_expansion_info = 7;
     * </code>
     */
    public com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfoOrBuilder
        getQueryExpansionInfoOrBuilder() {
      if (queryExpansionInfoBuilder_ != null) {
        return queryExpansionInfoBuilder_.getMessageOrBuilder();
      } else {
        return queryExpansionInfo_ == null
            ? com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo.getDefaultInstance()
            : queryExpansionInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Query expansion information for the returned results.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo query_expansion_info = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo,
            com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo.Builder,
            com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfoOrBuilder>
        getQueryExpansionInfoFieldBuilder() {
      if (queryExpansionInfoBuilder_ == null) {
        queryExpansionInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo,
                com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo.Builder,
                com.google.cloud.retail.v2.SearchResponse.QueryExpansionInfoOrBuilder>(
                getQueryExpansionInfo(), getParentForChildren(), isClean());
        queryExpansionInfo_ = null;
      }
      return queryExpansionInfoBuilder_;
    }

    private java.lang.Object redirectUri_ = "";
    /**
     *
     *
     * <pre>
     * The URI of a customer-defined redirect page. If redirect action is
     * triggered, no search is performed, and only
     * [redirect_uri][google.cloud.retail.v2.SearchResponse.redirect_uri] and
     * [attribution_token][google.cloud.retail.v2.SearchResponse.attribution_token]
     * are set in the response.
     * </pre>
     *
     * <code>string redirect_uri = 10;</code>
     *
     * @return The redirectUri.
     */
    public java.lang.String getRedirectUri() {
      java.lang.Object ref = redirectUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        redirectUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI of a customer-defined redirect page. If redirect action is
     * triggered, no search is performed, and only
     * [redirect_uri][google.cloud.retail.v2.SearchResponse.redirect_uri] and
     * [attribution_token][google.cloud.retail.v2.SearchResponse.attribution_token]
     * are set in the response.
     * </pre>
     *
     * <code>string redirect_uri = 10;</code>
     *
     * @return The bytes for redirectUri.
     */
    public com.google.protobuf.ByteString getRedirectUriBytes() {
      java.lang.Object ref = redirectUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        redirectUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI of a customer-defined redirect page. If redirect action is
     * triggered, no search is performed, and only
     * [redirect_uri][google.cloud.retail.v2.SearchResponse.redirect_uri] and
     * [attribution_token][google.cloud.retail.v2.SearchResponse.attribution_token]
     * are set in the response.
     * </pre>
     *
     * <code>string redirect_uri = 10;</code>
     *
     * @param value The redirectUri to set.
     * @return This builder for chaining.
     */
    public Builder setRedirectUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      redirectUri_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI of a customer-defined redirect page. If redirect action is
     * triggered, no search is performed, and only
     * [redirect_uri][google.cloud.retail.v2.SearchResponse.redirect_uri] and
     * [attribution_token][google.cloud.retail.v2.SearchResponse.attribution_token]
     * are set in the response.
     * </pre>
     *
     * <code>string redirect_uri = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRedirectUri() {
      redirectUri_ = getDefaultInstance().getRedirectUri();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI of a customer-defined redirect page. If redirect action is
     * triggered, no search is performed, and only
     * [redirect_uri][google.cloud.retail.v2.SearchResponse.redirect_uri] and
     * [attribution_token][google.cloud.retail.v2.SearchResponse.attribution_token]
     * are set in the response.
     * </pre>
     *
     * <code>string redirect_uri = 10;</code>
     *
     * @param value The bytes for redirectUri to set.
     * @return This builder for chaining.
     */
    public Builder setRedirectUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      redirectUri_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList appliedControls_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAppliedControlsIsMutable() {
      if (!appliedControls_.isModifiable()) {
        appliedControls_ = new com.google.protobuf.LazyStringArrayList(appliedControls_);
      }
      bitField0_ |= 0x00000100;
    }
    /**
     *
     *
     * <pre>
     * The fully qualified resource name of applied
     * [controls](https://cloud.google.com/retail/docs/serving-control-rules).
     * </pre>
     *
     * <code>repeated string applied_controls = 12;</code>
     *
     * @return A list containing the appliedControls.
     */
    public com.google.protobuf.ProtocolStringList getAppliedControlsList() {
      appliedControls_.makeImmutable();
      return appliedControls_;
    }
    /**
     *
     *
     * <pre>
     * The fully qualified resource name of applied
     * [controls](https://cloud.google.com/retail/docs/serving-control-rules).
     * </pre>
     *
     * <code>repeated string applied_controls = 12;</code>
     *
     * @return The count of appliedControls.
     */
    public int getAppliedControlsCount() {
      return appliedControls_.size();
    }
    /**
     *
     *
     * <pre>
     * The fully qualified resource name of applied
     * [controls](https://cloud.google.com/retail/docs/serving-control-rules).
     * </pre>
     *
     * <code>repeated string applied_controls = 12;</code>
     *
     * @param index The index of the element to return.
     * @return The appliedControls at the given index.
     */
    public java.lang.String getAppliedControls(int index) {
      return appliedControls_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The fully qualified resource name of applied
     * [controls](https://cloud.google.com/retail/docs/serving-control-rules).
     * </pre>
     *
     * <code>repeated string applied_controls = 12;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the appliedControls at the given index.
     */
    public com.google.protobuf.ByteString getAppliedControlsBytes(int index) {
      return appliedControls_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The fully qualified resource name of applied
     * [controls](https://cloud.google.com/retail/docs/serving-control-rules).
     * </pre>
     *
     * <code>repeated string applied_controls = 12;</code>
     *
     * @param index The index to set the value at.
     * @param value The appliedControls to set.
     * @return This builder for chaining.
     */
    public Builder setAppliedControls(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAppliedControlsIsMutable();
      appliedControls_.set(index, value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fully qualified resource name of applied
     * [controls](https://cloud.google.com/retail/docs/serving-control-rules).
     * </pre>
     *
     * <code>repeated string applied_controls = 12;</code>
     *
     * @param value The appliedControls to add.
     * @return This builder for chaining.
     */
    public Builder addAppliedControls(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAppliedControlsIsMutable();
      appliedControls_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fully qualified resource name of applied
     * [controls](https://cloud.google.com/retail/docs/serving-control-rules).
     * </pre>
     *
     * <code>repeated string applied_controls = 12;</code>
     *
     * @param values The appliedControls to add.
     * @return This builder for chaining.
     */
    public Builder addAllAppliedControls(java.lang.Iterable<java.lang.String> values) {
      ensureAppliedControlsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, appliedControls_);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fully qualified resource name of applied
     * [controls](https://cloud.google.com/retail/docs/serving-control-rules).
     * </pre>
     *
     * <code>repeated string applied_controls = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAppliedControls() {
      appliedControls_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fully qualified resource name of applied
     * [controls](https://cloud.google.com/retail/docs/serving-control-rules).
     * </pre>
     *
     * <code>repeated string applied_controls = 12;</code>
     *
     * @param value The bytes of the appliedControls to add.
     * @return This builder for chaining.
     */
    public Builder addAppliedControlsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAppliedControlsIsMutable();
      appliedControls_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec>
        invalidConditionBoostSpecs_ = java.util.Collections.emptyList();

    private void ensureInvalidConditionBoostSpecsIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        invalidConditionBoostSpecs_ =
            new java.util.ArrayList<
                com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec>(
                invalidConditionBoostSpecs_);
        bitField0_ |= 0x00000200;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec,
            com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec.Builder,
            com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpecOrBuilder>
        invalidConditionBoostSpecsBuilder_;

    /**
     *
     *
     * <pre>
     * The invalid
     * [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
     * that are not applied during serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec invalid_condition_boost_specs = 14;
     * </code>
     */
    public java.util.List<com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec>
        getInvalidConditionBoostSpecsList() {
      if (invalidConditionBoostSpecsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(invalidConditionBoostSpecs_);
      } else {
        return invalidConditionBoostSpecsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The invalid
     * [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
     * that are not applied during serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec invalid_condition_boost_specs = 14;
     * </code>
     */
    public int getInvalidConditionBoostSpecsCount() {
      if (invalidConditionBoostSpecsBuilder_ == null) {
        return invalidConditionBoostSpecs_.size();
      } else {
        return invalidConditionBoostSpecsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The invalid
     * [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
     * that are not applied during serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec invalid_condition_boost_specs = 14;
     * </code>
     */
    public com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec
        getInvalidConditionBoostSpecs(int index) {
      if (invalidConditionBoostSpecsBuilder_ == null) {
        return invalidConditionBoostSpecs_.get(index);
      } else {
        return invalidConditionBoostSpecsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The invalid
     * [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
     * that are not applied during serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec invalid_condition_boost_specs = 14;
     * </code>
     */
    public Builder setInvalidConditionBoostSpecs(
        int index, com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec value) {
      if (invalidConditionBoostSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInvalidConditionBoostSpecsIsMutable();
        invalidConditionBoostSpecs_.set(index, value);
        onChanged();
      } else {
        invalidConditionBoostSpecsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The invalid
     * [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
     * that are not applied during serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec invalid_condition_boost_specs = 14;
     * </code>
     */
    public Builder setInvalidConditionBoostSpecs(
        int index,
        com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec.Builder
            builderForValue) {
      if (invalidConditionBoostSpecsBuilder_ == null) {
        ensureInvalidConditionBoostSpecsIsMutable();
        invalidConditionBoostSpecs_.set(index, builderForValue.build());
        onChanged();
      } else {
        invalidConditionBoostSpecsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The invalid
     * [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
     * that are not applied during serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec invalid_condition_boost_specs = 14;
     * </code>
     */
    public Builder addInvalidConditionBoostSpecs(
        com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec value) {
      if (invalidConditionBoostSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInvalidConditionBoostSpecsIsMutable();
        invalidConditionBoostSpecs_.add(value);
        onChanged();
      } else {
        invalidConditionBoostSpecsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The invalid
     * [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
     * that are not applied during serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec invalid_condition_boost_specs = 14;
     * </code>
     */
    public Builder addInvalidConditionBoostSpecs(
        int index, com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec value) {
      if (invalidConditionBoostSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInvalidConditionBoostSpecsIsMutable();
        invalidConditionBoostSpecs_.add(index, value);
        onChanged();
      } else {
        invalidConditionBoostSpecsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The invalid
     * [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
     * that are not applied during serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec invalid_condition_boost_specs = 14;
     * </code>
     */
    public Builder addInvalidConditionBoostSpecs(
        com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec.Builder
            builderForValue) {
      if (invalidConditionBoostSpecsBuilder_ == null) {
        ensureInvalidConditionBoostSpecsIsMutable();
        invalidConditionBoostSpecs_.add(builderForValue.build());
        onChanged();
      } else {
        invalidConditionBoostSpecsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The invalid
     * [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
     * that are not applied during serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec invalid_condition_boost_specs = 14;
     * </code>
     */
    public Builder addInvalidConditionBoostSpecs(
        int index,
        com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec.Builder
            builderForValue) {
      if (invalidConditionBoostSpecsBuilder_ == null) {
        ensureInvalidConditionBoostSpecsIsMutable();
        invalidConditionBoostSpecs_.add(index, builderForValue.build());
        onChanged();
      } else {
        invalidConditionBoostSpecsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The invalid
     * [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
     * that are not applied during serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec invalid_condition_boost_specs = 14;
     * </code>
     */
    public Builder addAllInvalidConditionBoostSpecs(
        java.lang.Iterable<
                ? extends com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec>
            values) {
      if (invalidConditionBoostSpecsBuilder_ == null) {
        ensureInvalidConditionBoostSpecsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, invalidConditionBoostSpecs_);
        onChanged();
      } else {
        invalidConditionBoostSpecsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The invalid
     * [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
     * that are not applied during serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec invalid_condition_boost_specs = 14;
     * </code>
     */
    public Builder clearInvalidConditionBoostSpecs() {
      if (invalidConditionBoostSpecsBuilder_ == null) {
        invalidConditionBoostSpecs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        invalidConditionBoostSpecsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The invalid
     * [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
     * that are not applied during serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec invalid_condition_boost_specs = 14;
     * </code>
     */
    public Builder removeInvalidConditionBoostSpecs(int index) {
      if (invalidConditionBoostSpecsBuilder_ == null) {
        ensureInvalidConditionBoostSpecsIsMutable();
        invalidConditionBoostSpecs_.remove(index);
        onChanged();
      } else {
        invalidConditionBoostSpecsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The invalid
     * [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
     * that are not applied during serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec invalid_condition_boost_specs = 14;
     * </code>
     */
    public com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec.Builder
        getInvalidConditionBoostSpecsBuilder(int index) {
      return getInvalidConditionBoostSpecsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The invalid
     * [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
     * that are not applied during serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec invalid_condition_boost_specs = 14;
     * </code>
     */
    public com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpecOrBuilder
        getInvalidConditionBoostSpecsOrBuilder(int index) {
      if (invalidConditionBoostSpecsBuilder_ == null) {
        return invalidConditionBoostSpecs_.get(index);
      } else {
        return invalidConditionBoostSpecsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The invalid
     * [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
     * that are not applied during serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec invalid_condition_boost_specs = 14;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpecOrBuilder>
        getInvalidConditionBoostSpecsOrBuilderList() {
      if (invalidConditionBoostSpecsBuilder_ != null) {
        return invalidConditionBoostSpecsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(invalidConditionBoostSpecs_);
      }
    }
    /**
     *
     *
     * <pre>
     * The invalid
     * [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
     * that are not applied during serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec invalid_condition_boost_specs = 14;
     * </code>
     */
    public com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec.Builder
        addInvalidConditionBoostSpecsBuilder() {
      return getInvalidConditionBoostSpecsFieldBuilder()
          .addBuilder(
              com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The invalid
     * [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
     * that are not applied during serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec invalid_condition_boost_specs = 14;
     * </code>
     */
    public com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec.Builder
        addInvalidConditionBoostSpecsBuilder(int index) {
      return getInvalidConditionBoostSpecsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The invalid
     * [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
     * that are not applied during serving.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec invalid_condition_boost_specs = 14;
     * </code>
     */
    public java.util.List<
            com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec.Builder>
        getInvalidConditionBoostSpecsBuilderList() {
      return getInvalidConditionBoostSpecsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec,
            com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec.Builder,
            com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpecOrBuilder>
        getInvalidConditionBoostSpecsFieldBuilder() {
      if (invalidConditionBoostSpecsBuilder_ == null) {
        invalidConditionBoostSpecsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec,
                com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec.Builder,
                com.google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpecOrBuilder>(
                invalidConditionBoostSpecs_,
                ((bitField0_ & 0x00000200) != 0),
                getParentForChildren(),
                isClean());
        invalidConditionBoostSpecs_ = null;
      }
      return invalidConditionBoostSpecsBuilder_;
    }

    private java.util.List<com.google.cloud.retail.v2.ExperimentInfo> experimentInfo_ =
        java.util.Collections.emptyList();

    private void ensureExperimentInfoIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        experimentInfo_ =
            new java.util.ArrayList<com.google.cloud.retail.v2.ExperimentInfo>(experimentInfo_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2.ExperimentInfo,
            com.google.cloud.retail.v2.ExperimentInfo.Builder,
            com.google.cloud.retail.v2.ExperimentInfoOrBuilder>
        experimentInfoBuilder_;

    /**
     *
     *
     * <pre>
     * Metadata related to A/B testing [Experiment][] associated with this
     * response. Only exists when an experiment is triggered.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.ExperimentInfo experiment_info = 17;</code>
     */
    public java.util.List<com.google.cloud.retail.v2.ExperimentInfo> getExperimentInfoList() {
      if (experimentInfoBuilder_ == null) {
        return java.util.Collections.unmodifiableList(experimentInfo_);
      } else {
        return experimentInfoBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata related to A/B testing [Experiment][] associated with this
     * response. Only exists when an experiment is triggered.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.ExperimentInfo experiment_info = 17;</code>
     */
    public int getExperimentInfoCount() {
      if (experimentInfoBuilder_ == null) {
        return experimentInfo_.size();
      } else {
        return experimentInfoBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata related to A/B testing [Experiment][] associated with this
     * response. Only exists when an experiment is triggered.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.ExperimentInfo experiment_info = 17;</code>
     */
    public com.google.cloud.retail.v2.ExperimentInfo getExperimentInfo(int index) {
      if (experimentInfoBuilder_ == null) {
        return experimentInfo_.get(index);
      } else {
        return experimentInfoBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata related to A/B testing [Experiment][] associated with this
     * response. Only exists when an experiment is triggered.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.ExperimentInfo experiment_info = 17;</code>
     */
    public Builder setExperimentInfo(int index, com.google.cloud.retail.v2.ExperimentInfo value) {
      if (experimentInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExperimentInfoIsMutable();
        experimentInfo_.set(index, value);
        onChanged();
      } else {
        experimentInfoBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata related to A/B testing [Experiment][] associated with this
     * response. Only exists when an experiment is triggered.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.ExperimentInfo experiment_info = 17;</code>
     */
    public Builder setExperimentInfo(
        int index, com.google.cloud.retail.v2.ExperimentInfo.Builder builderForValue) {
      if (experimentInfoBuilder_ == null) {
        ensureExperimentInfoIsMutable();
        experimentInfo_.set(index, builderForValue.build());
        onChanged();
      } else {
        experimentInfoBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata related to A/B testing [Experiment][] associated with this
     * response. Only exists when an experiment is triggered.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.ExperimentInfo experiment_info = 17;</code>
     */
    public Builder addExperimentInfo(com.google.cloud.retail.v2.ExperimentInfo value) {
      if (experimentInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExperimentInfoIsMutable();
        experimentInfo_.add(value);
        onChanged();
      } else {
        experimentInfoBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata related to A/B testing [Experiment][] associated with this
     * response. Only exists when an experiment is triggered.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.ExperimentInfo experiment_info = 17;</code>
     */
    public Builder addExperimentInfo(int index, com.google.cloud.retail.v2.ExperimentInfo value) {
      if (experimentInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExperimentInfoIsMutable();
        experimentInfo_.add(index, value);
        onChanged();
      } else {
        experimentInfoBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata related to A/B testing [Experiment][] associated with this
     * response. Only exists when an experiment is triggered.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.ExperimentInfo experiment_info = 17;</code>
     */
    public Builder addExperimentInfo(
        com.google.cloud.retail.v2.ExperimentInfo.Builder builderForValue) {
      if (experimentInfoBuilder_ == null) {
        ensureExperimentInfoIsMutable();
        experimentInfo_.add(builderForValue.build());
        onChanged();
      } else {
        experimentInfoBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata related to A/B testing [Experiment][] associated with this
     * response. Only exists when an experiment is triggered.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.ExperimentInfo experiment_info = 17;</code>
     */
    public Builder addExperimentInfo(
        int index, com.google.cloud.retail.v2.ExperimentInfo.Builder builderForValue) {
      if (experimentInfoBuilder_ == null) {
        ensureExperimentInfoIsMutable();
        experimentInfo_.add(index, builderForValue.build());
        onChanged();
      } else {
        experimentInfoBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata related to A/B testing [Experiment][] associated with this
     * response. Only exists when an experiment is triggered.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.ExperimentInfo experiment_info = 17;</code>
     */
    public Builder addAllExperimentInfo(
        java.lang.Iterable<? extends com.google.cloud.retail.v2.ExperimentInfo> values) {
      if (experimentInfoBuilder_ == null) {
        ensureExperimentInfoIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, experimentInfo_);
        onChanged();
      } else {
        experimentInfoBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata related to A/B testing [Experiment][] associated with this
     * response. Only exists when an experiment is triggered.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.ExperimentInfo experiment_info = 17;</code>
     */
    public Builder clearExperimentInfo() {
      if (experimentInfoBuilder_ == null) {
        experimentInfo_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        experimentInfoBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata related to A/B testing [Experiment][] associated with this
     * response. Only exists when an experiment is triggered.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.ExperimentInfo experiment_info = 17;</code>
     */
    public Builder removeExperimentInfo(int index) {
      if (experimentInfoBuilder_ == null) {
        ensureExperimentInfoIsMutable();
        experimentInfo_.remove(index);
        onChanged();
      } else {
        experimentInfoBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata related to A/B testing [Experiment][] associated with this
     * response. Only exists when an experiment is triggered.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.ExperimentInfo experiment_info = 17;</code>
     */
    public com.google.cloud.retail.v2.ExperimentInfo.Builder getExperimentInfoBuilder(int index) {
      return getExperimentInfoFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Metadata related to A/B testing [Experiment][] associated with this
     * response. Only exists when an experiment is triggered.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.ExperimentInfo experiment_info = 17;</code>
     */
    public com.google.cloud.retail.v2.ExperimentInfoOrBuilder getExperimentInfoOrBuilder(
        int index) {
      if (experimentInfoBuilder_ == null) {
        return experimentInfo_.get(index);
      } else {
        return experimentInfoBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata related to A/B testing [Experiment][] associated with this
     * response. Only exists when an experiment is triggered.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.ExperimentInfo experiment_info = 17;</code>
     */
    public java.util.List<? extends com.google.cloud.retail.v2.ExperimentInfoOrBuilder>
        getExperimentInfoOrBuilderList() {
      if (experimentInfoBuilder_ != null) {
        return experimentInfoBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(experimentInfo_);
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata related to A/B testing [Experiment][] associated with this
     * response. Only exists when an experiment is triggered.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.ExperimentInfo experiment_info = 17;</code>
     */
    public com.google.cloud.retail.v2.ExperimentInfo.Builder addExperimentInfoBuilder() {
      return getExperimentInfoFieldBuilder()
          .addBuilder(com.google.cloud.retail.v2.ExperimentInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Metadata related to A/B testing [Experiment][] associated with this
     * response. Only exists when an experiment is triggered.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.ExperimentInfo experiment_info = 17;</code>
     */
    public com.google.cloud.retail.v2.ExperimentInfo.Builder addExperimentInfoBuilder(int index) {
      return getExperimentInfoFieldBuilder()
          .addBuilder(index, com.google.cloud.retail.v2.ExperimentInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Metadata related to A/B testing [Experiment][] associated with this
     * response. Only exists when an experiment is triggered.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2.ExperimentInfo experiment_info = 17;</code>
     */
    public java.util.List<com.google.cloud.retail.v2.ExperimentInfo.Builder>
        getExperimentInfoBuilderList() {
      return getExperimentInfoFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2.ExperimentInfo,
            com.google.cloud.retail.v2.ExperimentInfo.Builder,
            com.google.cloud.retail.v2.ExperimentInfoOrBuilder>
        getExperimentInfoFieldBuilder() {
      if (experimentInfoBuilder_ == null) {
        experimentInfoBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2.ExperimentInfo,
                com.google.cloud.retail.v2.ExperimentInfo.Builder,
                com.google.cloud.retail.v2.ExperimentInfoOrBuilder>(
                experimentInfo_,
                ((bitField0_ & 0x00000400) != 0),
                getParentForChildren(),
                isClean());
        experimentInfo_ = null;
      }
      return experimentInfoBuilder_;
    }

    private com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
        conversationalSearchResult_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult,
            com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.Builder,
            com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResultOrBuilder>
        conversationalSearchResultBuilder_;
    /**
     *
     *
     * <pre>
     * This field specifies all related information that is needed on client
     * side for UI rendering of conversational retail search.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult conversational_search_result = 18;
     * </code>
     *
     * @return Whether the conversationalSearchResult field is set.
     */
    public boolean hasConversationalSearchResult() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * This field specifies all related information that is needed on client
     * side for UI rendering of conversational retail search.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult conversational_search_result = 18;
     * </code>
     *
     * @return The conversationalSearchResult.
     */
    public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
        getConversationalSearchResult() {
      if (conversationalSearchResultBuilder_ == null) {
        return conversationalSearchResult_ == null
            ? com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                .getDefaultInstance()
            : conversationalSearchResult_;
      } else {
        return conversationalSearchResultBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * This field specifies all related information that is needed on client
     * side for UI rendering of conversational retail search.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult conversational_search_result = 18;
     * </code>
     */
    public Builder setConversationalSearchResult(
        com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult value) {
      if (conversationalSearchResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        conversationalSearchResult_ = value;
      } else {
        conversationalSearchResultBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field specifies all related information that is needed on client
     * side for UI rendering of conversational retail search.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult conversational_search_result = 18;
     * </code>
     */
    public Builder setConversationalSearchResult(
        com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.Builder
            builderForValue) {
      if (conversationalSearchResultBuilder_ == null) {
        conversationalSearchResult_ = builderForValue.build();
      } else {
        conversationalSearchResultBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field specifies all related information that is needed on client
     * side for UI rendering of conversational retail search.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult conversational_search_result = 18;
     * </code>
     */
    public Builder mergeConversationalSearchResult(
        com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult value) {
      if (conversationalSearchResultBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && conversationalSearchResult_ != null
            && conversationalSearchResult_
                != com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                    .getDefaultInstance()) {
          getConversationalSearchResultBuilder().mergeFrom(value);
        } else {
          conversationalSearchResult_ = value;
        }
      } else {
        conversationalSearchResultBuilder_.mergeFrom(value);
      }
      if (conversationalSearchResult_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field specifies all related information that is needed on client
     * side for UI rendering of conversational retail search.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult conversational_search_result = 18;
     * </code>
     */
    public Builder clearConversationalSearchResult() {
      bitField0_ = (bitField0_ & ~0x00000800);
      conversationalSearchResult_ = null;
      if (conversationalSearchResultBuilder_ != null) {
        conversationalSearchResultBuilder_.dispose();
        conversationalSearchResultBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field specifies all related information that is needed on client
     * side for UI rendering of conversational retail search.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult conversational_search_result = 18;
     * </code>
     */
    public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.Builder
        getConversationalSearchResultBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getConversationalSearchResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * This field specifies all related information that is needed on client
     * side for UI rendering of conversational retail search.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult conversational_search_result = 18;
     * </code>
     */
    public com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResultOrBuilder
        getConversationalSearchResultOrBuilder() {
      if (conversationalSearchResultBuilder_ != null) {
        return conversationalSearchResultBuilder_.getMessageOrBuilder();
      } else {
        return conversationalSearchResult_ == null
            ? com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult
                .getDefaultInstance()
            : conversationalSearchResult_;
      }
    }
    /**
     *
     *
     * <pre>
     * This field specifies all related information that is needed on client
     * side for UI rendering of conversational retail search.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.SearchResponse.ConversationalSearchResult conversational_search_result = 18;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult,
            com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.Builder,
            com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResultOrBuilder>
        getConversationalSearchResultFieldBuilder() {
      if (conversationalSearchResultBuilder_ == null) {
        conversationalSearchResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult,
                com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResult.Builder,
                com.google.cloud.retail.v2.SearchResponse.ConversationalSearchResultOrBuilder>(
                getConversationalSearchResult(), getParentForChildren(), isClean());
        conversationalSearchResult_ = null;
      }
      return conversationalSearchResultBuilder_;
    }

    private com.google.cloud.retail.v2.SearchResponse.TileNavigationResult tileNavigationResult_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2.SearchResponse.TileNavigationResult,
            com.google.cloud.retail.v2.SearchResponse.TileNavigationResult.Builder,
            com.google.cloud.retail.v2.SearchResponse.TileNavigationResultOrBuilder>
        tileNavigationResultBuilder_;
    /**
     *
     *
     * <pre>
     * This field specifies all related information for tile navigation that will
     * be used in client side.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.SearchResponse.TileNavigationResult tile_navigation_result = 19;
     * </code>
     *
     * @return Whether the tileNavigationResult field is set.
     */
    public boolean hasTileNavigationResult() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * This field specifies all related information for tile navigation that will
     * be used in client side.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.SearchResponse.TileNavigationResult tile_navigation_result = 19;
     * </code>
     *
     * @return The tileNavigationResult.
     */
    public com.google.cloud.retail.v2.SearchResponse.TileNavigationResult
        getTileNavigationResult() {
      if (tileNavigationResultBuilder_ == null) {
        return tileNavigationResult_ == null
            ? com.google.cloud.retail.v2.SearchResponse.TileNavigationResult.getDefaultInstance()
            : tileNavigationResult_;
      } else {
        return tileNavigationResultBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * This field specifies all related information for tile navigation that will
     * be used in client side.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.SearchResponse.TileNavigationResult tile_navigation_result = 19;
     * </code>
     */
    public Builder setTileNavigationResult(
        com.google.cloud.retail.v2.SearchResponse.TileNavigationResult value) {
      if (tileNavigationResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tileNavigationResult_ = value;
      } else {
        tileNavigationResultBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field specifies all related information for tile navigation that will
     * be used in client side.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.SearchResponse.TileNavigationResult tile_navigation_result = 19;
     * </code>
     */
    public Builder setTileNavigationResult(
        com.google.cloud.retail.v2.SearchResponse.TileNavigationResult.Builder builderForValue) {
      if (tileNavigationResultBuilder_ == null) {
        tileNavigationResult_ = builderForValue.build();
      } else {
        tileNavigationResultBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field specifies all related information for tile navigation that will
     * be used in client side.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.SearchResponse.TileNavigationResult tile_navigation_result = 19;
     * </code>
     */
    public Builder mergeTileNavigationResult(
        com.google.cloud.retail.v2.SearchResponse.TileNavigationResult value) {
      if (tileNavigationResultBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && tileNavigationResult_ != null
            && tileNavigationResult_
                != com.google.cloud.retail.v2.SearchResponse.TileNavigationResult
                    .getDefaultInstance()) {
          getTileNavigationResultBuilder().mergeFrom(value);
        } else {
          tileNavigationResult_ = value;
        }
      } else {
        tileNavigationResultBuilder_.mergeFrom(value);
      }
      if (tileNavigationResult_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field specifies all related information for tile navigation that will
     * be used in client side.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.SearchResponse.TileNavigationResult tile_navigation_result = 19;
     * </code>
     */
    public Builder clearTileNavigationResult() {
      bitField0_ = (bitField0_ & ~0x00001000);
      tileNavigationResult_ = null;
      if (tileNavigationResultBuilder_ != null) {
        tileNavigationResultBuilder_.dispose();
        tileNavigationResultBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field specifies all related information for tile navigation that will
     * be used in client side.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.SearchResponse.TileNavigationResult tile_navigation_result = 19;
     * </code>
     */
    public com.google.cloud.retail.v2.SearchResponse.TileNavigationResult.Builder
        getTileNavigationResultBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getTileNavigationResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * This field specifies all related information for tile navigation that will
     * be used in client side.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.SearchResponse.TileNavigationResult tile_navigation_result = 19;
     * </code>
     */
    public com.google.cloud.retail.v2.SearchResponse.TileNavigationResultOrBuilder
        getTileNavigationResultOrBuilder() {
      if (tileNavigationResultBuilder_ != null) {
        return tileNavigationResultBuilder_.getMessageOrBuilder();
      } else {
        return tileNavigationResult_ == null
            ? com.google.cloud.retail.v2.SearchResponse.TileNavigationResult.getDefaultInstance()
            : tileNavigationResult_;
      }
    }
    /**
     *
     *
     * <pre>
     * This field specifies all related information for tile navigation that will
     * be used in client side.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2.SearchResponse.TileNavigationResult tile_navigation_result = 19;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2.SearchResponse.TileNavigationResult,
            com.google.cloud.retail.v2.SearchResponse.TileNavigationResult.Builder,
            com.google.cloud.retail.v2.SearchResponse.TileNavigationResultOrBuilder>
        getTileNavigationResultFieldBuilder() {
      if (tileNavigationResultBuilder_ == null) {
        tileNavigationResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2.SearchResponse.TileNavigationResult,
                com.google.cloud.retail.v2.SearchResponse.TileNavigationResult.Builder,
                com.google.cloud.retail.v2.SearchResponse.TileNavigationResultOrBuilder>(
                getTileNavigationResult(), getParentForChildren(), isClean());
        tileNavigationResult_ = null;
      }
      return tileNavigationResultBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.SearchResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.SearchResponse)
  private static final com.google.cloud.retail.v2.SearchResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2.SearchResponse();
  }

  public static com.google.cloud.retail.v2.SearchResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SearchResponse> PARSER =
      new com.google.protobuf.AbstractParser<SearchResponse>() {
        @java.lang.Override
        public SearchResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SearchResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SearchResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2.SearchResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
