/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2/search_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2;

/**
 *
 *
 * <pre>
 * This field specifies the tile information including an attribute key,
 * attribute value. More fields will be added in the future, eg: product id
 * or product counts, etc.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2.Tile}
 */
public final class Tile extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2.Tile)
    TileOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Tile.newBuilder() to construct.
  private Tile(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Tile() {
    representativeProductId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Tile();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2.SearchServiceProto
        .internal_static_google_cloud_retail_v2_Tile_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2.SearchServiceProto
        .internal_static_google_cloud_retail_v2_Tile_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2.Tile.class, com.google.cloud.retail.v2.Tile.Builder.class);
  }

  private int productAttributeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object productAttribute_;

  public enum ProductAttributeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    PRODUCT_ATTRIBUTE_VALUE(1),
    PRODUCT_ATTRIBUTE_INTERVAL(2),
    PRODUCTATTRIBUTE_NOT_SET(0);
    private final int value;

    private ProductAttributeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ProductAttributeCase valueOf(int value) {
      return forNumber(value);
    }

    public static ProductAttributeCase forNumber(int value) {
      switch (value) {
        case 1:
          return PRODUCT_ATTRIBUTE_VALUE;
        case 2:
          return PRODUCT_ATTRIBUTE_INTERVAL;
        case 0:
          return PRODUCTATTRIBUTE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ProductAttributeCase getProductAttributeCase() {
    return ProductAttributeCase.forNumber(productAttributeCase_);
  }

  public static final int PRODUCT_ATTRIBUTE_VALUE_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * The product attribute key-value.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
   *
   * @return Whether the productAttributeValue field is set.
   */
  @java.lang.Override
  public boolean hasProductAttributeValue() {
    return productAttributeCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * The product attribute key-value.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
   *
   * @return The productAttributeValue.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.ProductAttributeValue getProductAttributeValue() {
    if (productAttributeCase_ == 1) {
      return (com.google.cloud.retail.v2.ProductAttributeValue) productAttribute_;
    }
    return com.google.cloud.retail.v2.ProductAttributeValue.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The product attribute key-value.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.ProductAttributeValueOrBuilder
      getProductAttributeValueOrBuilder() {
    if (productAttributeCase_ == 1) {
      return (com.google.cloud.retail.v2.ProductAttributeValue) productAttribute_;
    }
    return com.google.cloud.retail.v2.ProductAttributeValue.getDefaultInstance();
  }

  public static final int PRODUCT_ATTRIBUTE_INTERVAL_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The product attribute key-numeric interval.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.ProductAttributeInterval product_attribute_interval = 2;</code>
   *
   * @return Whether the productAttributeInterval field is set.
   */
  @java.lang.Override
  public boolean hasProductAttributeInterval() {
    return productAttributeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The product attribute key-numeric interval.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.ProductAttributeInterval product_attribute_interval = 2;</code>
   *
   * @return The productAttributeInterval.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.ProductAttributeInterval getProductAttributeInterval() {
    if (productAttributeCase_ == 2) {
      return (com.google.cloud.retail.v2.ProductAttributeInterval) productAttribute_;
    }
    return com.google.cloud.retail.v2.ProductAttributeInterval.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The product attribute key-numeric interval.
   * </pre>
   *
   * <code>.google.cloud.retail.v2.ProductAttributeInterval product_attribute_interval = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2.ProductAttributeIntervalOrBuilder
      getProductAttributeIntervalOrBuilder() {
    if (productAttributeCase_ == 2) {
      return (com.google.cloud.retail.v2.ProductAttributeInterval) productAttribute_;
    }
    return com.google.cloud.retail.v2.ProductAttributeInterval.getDefaultInstance();
  }

  public static final int REPRESENTATIVE_PRODUCT_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object representativeProductId_ = "";
  /**
   *
   *
   * <pre>
   * The representative product id for this tile.
   * </pre>
   *
   * <code>string representative_product_id = 3;</code>
   *
   * @return The representativeProductId.
   */
  @java.lang.Override
  public java.lang.String getRepresentativeProductId() {
    java.lang.Object ref = representativeProductId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      representativeProductId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The representative product id for this tile.
   * </pre>
   *
   * <code>string representative_product_id = 3;</code>
   *
   * @return The bytes for representativeProductId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRepresentativeProductIdBytes() {
    java.lang.Object ref = representativeProductId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      representativeProductId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (productAttributeCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.retail.v2.ProductAttributeValue) productAttribute_);
    }
    if (productAttributeCase_ == 2) {
      output.writeMessage(
          2, (com.google.cloud.retail.v2.ProductAttributeInterval) productAttribute_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(representativeProductId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, representativeProductId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (productAttributeCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.retail.v2.ProductAttributeValue) productAttribute_);
    }
    if (productAttributeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.retail.v2.ProductAttributeInterval) productAttribute_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(representativeProductId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, representativeProductId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2.Tile)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2.Tile other = (com.google.cloud.retail.v2.Tile) obj;

    if (!getRepresentativeProductId().equals(other.getRepresentativeProductId())) return false;
    if (!getProductAttributeCase().equals(other.getProductAttributeCase())) return false;
    switch (productAttributeCase_) {
      case 1:
        if (!getProductAttributeValue().equals(other.getProductAttributeValue())) return false;
        break;
      case 2:
        if (!getProductAttributeInterval().equals(other.getProductAttributeInterval()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + REPRESENTATIVE_PRODUCT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRepresentativeProductId().hashCode();
    switch (productAttributeCase_) {
      case 1:
        hash = (37 * hash) + PRODUCT_ATTRIBUTE_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getProductAttributeValue().hashCode();
        break;
      case 2:
        hash = (37 * hash) + PRODUCT_ATTRIBUTE_INTERVAL_FIELD_NUMBER;
        hash = (53 * hash) + getProductAttributeInterval().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2.Tile parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.Tile parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.Tile parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.Tile parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.Tile parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2.Tile parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.Tile parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.Tile parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.Tile parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.Tile parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2.Tile parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2.Tile parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2.Tile prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * This field specifies the tile information including an attribute key,
   * attribute value. More fields will be added in the future, eg: product id
   * or product counts, etc.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2.Tile}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2.Tile)
      com.google.cloud.retail.v2.TileOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2.SearchServiceProto
          .internal_static_google_cloud_retail_v2_Tile_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2.SearchServiceProto
          .internal_static_google_cloud_retail_v2_Tile_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2.Tile.class, com.google.cloud.retail.v2.Tile.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2.Tile.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (productAttributeValueBuilder_ != null) {
        productAttributeValueBuilder_.clear();
      }
      if (productAttributeIntervalBuilder_ != null) {
        productAttributeIntervalBuilder_.clear();
      }
      representativeProductId_ = "";
      productAttributeCase_ = 0;
      productAttribute_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2.SearchServiceProto
          .internal_static_google_cloud_retail_v2_Tile_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.Tile getDefaultInstanceForType() {
      return com.google.cloud.retail.v2.Tile.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.Tile build() {
      com.google.cloud.retail.v2.Tile result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2.Tile buildPartial() {
      com.google.cloud.retail.v2.Tile result = new com.google.cloud.retail.v2.Tile(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.retail.v2.Tile result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.representativeProductId_ = representativeProductId_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.retail.v2.Tile result) {
      result.productAttributeCase_ = productAttributeCase_;
      result.productAttribute_ = this.productAttribute_;
      if (productAttributeCase_ == 1 && productAttributeValueBuilder_ != null) {
        result.productAttribute_ = productAttributeValueBuilder_.build();
      }
      if (productAttributeCase_ == 2 && productAttributeIntervalBuilder_ != null) {
        result.productAttribute_ = productAttributeIntervalBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2.Tile) {
        return mergeFrom((com.google.cloud.retail.v2.Tile) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2.Tile other) {
      if (other == com.google.cloud.retail.v2.Tile.getDefaultInstance()) return this;
      if (!other.getRepresentativeProductId().isEmpty()) {
        representativeProductId_ = other.representativeProductId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      switch (other.getProductAttributeCase()) {
        case PRODUCT_ATTRIBUTE_VALUE:
          {
            mergeProductAttributeValue(other.getProductAttributeValue());
            break;
          }
        case PRODUCT_ATTRIBUTE_INTERVAL:
          {
            mergeProductAttributeInterval(other.getProductAttributeInterval());
            break;
          }
        case PRODUCTATTRIBUTE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getProductAttributeValueFieldBuilder().getBuilder(), extensionRegistry);
                productAttributeCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getProductAttributeIntervalFieldBuilder().getBuilder(), extensionRegistry);
                productAttributeCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                representativeProductId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int productAttributeCase_ = 0;
    private java.lang.Object productAttribute_;

    public ProductAttributeCase getProductAttributeCase() {
      return ProductAttributeCase.forNumber(productAttributeCase_);
    }

    public Builder clearProductAttribute() {
      productAttributeCase_ = 0;
      productAttribute_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2.ProductAttributeValue,
            com.google.cloud.retail.v2.ProductAttributeValue.Builder,
            com.google.cloud.retail.v2.ProductAttributeValueOrBuilder>
        productAttributeValueBuilder_;
    /**
     *
     *
     * <pre>
     * The product attribute key-value.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
     *
     * @return Whether the productAttributeValue field is set.
     */
    @java.lang.Override
    public boolean hasProductAttributeValue() {
      return productAttributeCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * The product attribute key-value.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
     *
     * @return The productAttributeValue.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.ProductAttributeValue getProductAttributeValue() {
      if (productAttributeValueBuilder_ == null) {
        if (productAttributeCase_ == 1) {
          return (com.google.cloud.retail.v2.ProductAttributeValue) productAttribute_;
        }
        return com.google.cloud.retail.v2.ProductAttributeValue.getDefaultInstance();
      } else {
        if (productAttributeCase_ == 1) {
          return productAttributeValueBuilder_.getMessage();
        }
        return com.google.cloud.retail.v2.ProductAttributeValue.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The product attribute key-value.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
     */
    public Builder setProductAttributeValue(
        com.google.cloud.retail.v2.ProductAttributeValue value) {
      if (productAttributeValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        productAttribute_ = value;
        onChanged();
      } else {
        productAttributeValueBuilder_.setMessage(value);
      }
      productAttributeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The product attribute key-value.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
     */
    public Builder setProductAttributeValue(
        com.google.cloud.retail.v2.ProductAttributeValue.Builder builderForValue) {
      if (productAttributeValueBuilder_ == null) {
        productAttribute_ = builderForValue.build();
        onChanged();
      } else {
        productAttributeValueBuilder_.setMessage(builderForValue.build());
      }
      productAttributeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The product attribute key-value.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
     */
    public Builder mergeProductAttributeValue(
        com.google.cloud.retail.v2.ProductAttributeValue value) {
      if (productAttributeValueBuilder_ == null) {
        if (productAttributeCase_ == 1
            && productAttribute_
                != com.google.cloud.retail.v2.ProductAttributeValue.getDefaultInstance()) {
          productAttribute_ =
              com.google.cloud.retail.v2.ProductAttributeValue.newBuilder(
                      (com.google.cloud.retail.v2.ProductAttributeValue) productAttribute_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          productAttribute_ = value;
        }
        onChanged();
      } else {
        if (productAttributeCase_ == 1) {
          productAttributeValueBuilder_.mergeFrom(value);
        } else {
          productAttributeValueBuilder_.setMessage(value);
        }
      }
      productAttributeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The product attribute key-value.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
     */
    public Builder clearProductAttributeValue() {
      if (productAttributeValueBuilder_ == null) {
        if (productAttributeCase_ == 1) {
          productAttributeCase_ = 0;
          productAttribute_ = null;
          onChanged();
        }
      } else {
        if (productAttributeCase_ == 1) {
          productAttributeCase_ = 0;
          productAttribute_ = null;
        }
        productAttributeValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The product attribute key-value.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
     */
    public com.google.cloud.retail.v2.ProductAttributeValue.Builder
        getProductAttributeValueBuilder() {
      return getProductAttributeValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The product attribute key-value.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.ProductAttributeValueOrBuilder
        getProductAttributeValueOrBuilder() {
      if ((productAttributeCase_ == 1) && (productAttributeValueBuilder_ != null)) {
        return productAttributeValueBuilder_.getMessageOrBuilder();
      } else {
        if (productAttributeCase_ == 1) {
          return (com.google.cloud.retail.v2.ProductAttributeValue) productAttribute_;
        }
        return com.google.cloud.retail.v2.ProductAttributeValue.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The product attribute key-value.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ProductAttributeValue product_attribute_value = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2.ProductAttributeValue,
            com.google.cloud.retail.v2.ProductAttributeValue.Builder,
            com.google.cloud.retail.v2.ProductAttributeValueOrBuilder>
        getProductAttributeValueFieldBuilder() {
      if (productAttributeValueBuilder_ == null) {
        if (!(productAttributeCase_ == 1)) {
          productAttribute_ = com.google.cloud.retail.v2.ProductAttributeValue.getDefaultInstance();
        }
        productAttributeValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2.ProductAttributeValue,
                com.google.cloud.retail.v2.ProductAttributeValue.Builder,
                com.google.cloud.retail.v2.ProductAttributeValueOrBuilder>(
                (com.google.cloud.retail.v2.ProductAttributeValue) productAttribute_,
                getParentForChildren(),
                isClean());
        productAttribute_ = null;
      }
      productAttributeCase_ = 1;
      onChanged();
      return productAttributeValueBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2.ProductAttributeInterval,
            com.google.cloud.retail.v2.ProductAttributeInterval.Builder,
            com.google.cloud.retail.v2.ProductAttributeIntervalOrBuilder>
        productAttributeIntervalBuilder_;
    /**
     *
     *
     * <pre>
     * The product attribute key-numeric interval.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ProductAttributeInterval product_attribute_interval = 2;</code>
     *
     * @return Whether the productAttributeInterval field is set.
     */
    @java.lang.Override
    public boolean hasProductAttributeInterval() {
      return productAttributeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The product attribute key-numeric interval.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ProductAttributeInterval product_attribute_interval = 2;</code>
     *
     * @return The productAttributeInterval.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.ProductAttributeInterval getProductAttributeInterval() {
      if (productAttributeIntervalBuilder_ == null) {
        if (productAttributeCase_ == 2) {
          return (com.google.cloud.retail.v2.ProductAttributeInterval) productAttribute_;
        }
        return com.google.cloud.retail.v2.ProductAttributeInterval.getDefaultInstance();
      } else {
        if (productAttributeCase_ == 2) {
          return productAttributeIntervalBuilder_.getMessage();
        }
        return com.google.cloud.retail.v2.ProductAttributeInterval.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The product attribute key-numeric interval.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ProductAttributeInterval product_attribute_interval = 2;</code>
     */
    public Builder setProductAttributeInterval(
        com.google.cloud.retail.v2.ProductAttributeInterval value) {
      if (productAttributeIntervalBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        productAttribute_ = value;
        onChanged();
      } else {
        productAttributeIntervalBuilder_.setMessage(value);
      }
      productAttributeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The product attribute key-numeric interval.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ProductAttributeInterval product_attribute_interval = 2;</code>
     */
    public Builder setProductAttributeInterval(
        com.google.cloud.retail.v2.ProductAttributeInterval.Builder builderForValue) {
      if (productAttributeIntervalBuilder_ == null) {
        productAttribute_ = builderForValue.build();
        onChanged();
      } else {
        productAttributeIntervalBuilder_.setMessage(builderForValue.build());
      }
      productAttributeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The product attribute key-numeric interval.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ProductAttributeInterval product_attribute_interval = 2;</code>
     */
    public Builder mergeProductAttributeInterval(
        com.google.cloud.retail.v2.ProductAttributeInterval value) {
      if (productAttributeIntervalBuilder_ == null) {
        if (productAttributeCase_ == 2
            && productAttribute_
                != com.google.cloud.retail.v2.ProductAttributeInterval.getDefaultInstance()) {
          productAttribute_ =
              com.google.cloud.retail.v2.ProductAttributeInterval.newBuilder(
                      (com.google.cloud.retail.v2.ProductAttributeInterval) productAttribute_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          productAttribute_ = value;
        }
        onChanged();
      } else {
        if (productAttributeCase_ == 2) {
          productAttributeIntervalBuilder_.mergeFrom(value);
        } else {
          productAttributeIntervalBuilder_.setMessage(value);
        }
      }
      productAttributeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The product attribute key-numeric interval.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ProductAttributeInterval product_attribute_interval = 2;</code>
     */
    public Builder clearProductAttributeInterval() {
      if (productAttributeIntervalBuilder_ == null) {
        if (productAttributeCase_ == 2) {
          productAttributeCase_ = 0;
          productAttribute_ = null;
          onChanged();
        }
      } else {
        if (productAttributeCase_ == 2) {
          productAttributeCase_ = 0;
          productAttribute_ = null;
        }
        productAttributeIntervalBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The product attribute key-numeric interval.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ProductAttributeInterval product_attribute_interval = 2;</code>
     */
    public com.google.cloud.retail.v2.ProductAttributeInterval.Builder
        getProductAttributeIntervalBuilder() {
      return getProductAttributeIntervalFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The product attribute key-numeric interval.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ProductAttributeInterval product_attribute_interval = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2.ProductAttributeIntervalOrBuilder
        getProductAttributeIntervalOrBuilder() {
      if ((productAttributeCase_ == 2) && (productAttributeIntervalBuilder_ != null)) {
        return productAttributeIntervalBuilder_.getMessageOrBuilder();
      } else {
        if (productAttributeCase_ == 2) {
          return (com.google.cloud.retail.v2.ProductAttributeInterval) productAttribute_;
        }
        return com.google.cloud.retail.v2.ProductAttributeInterval.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The product attribute key-numeric interval.
     * </pre>
     *
     * <code>.google.cloud.retail.v2.ProductAttributeInterval product_attribute_interval = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2.ProductAttributeInterval,
            com.google.cloud.retail.v2.ProductAttributeInterval.Builder,
            com.google.cloud.retail.v2.ProductAttributeIntervalOrBuilder>
        getProductAttributeIntervalFieldBuilder() {
      if (productAttributeIntervalBuilder_ == null) {
        if (!(productAttributeCase_ == 2)) {
          productAttribute_ =
              com.google.cloud.retail.v2.ProductAttributeInterval.getDefaultInstance();
        }
        productAttributeIntervalBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2.ProductAttributeInterval,
                com.google.cloud.retail.v2.ProductAttributeInterval.Builder,
                com.google.cloud.retail.v2.ProductAttributeIntervalOrBuilder>(
                (com.google.cloud.retail.v2.ProductAttributeInterval) productAttribute_,
                getParentForChildren(),
                isClean());
        productAttribute_ = null;
      }
      productAttributeCase_ = 2;
      onChanged();
      return productAttributeIntervalBuilder_;
    }

    private java.lang.Object representativeProductId_ = "";
    /**
     *
     *
     * <pre>
     * The representative product id for this tile.
     * </pre>
     *
     * <code>string representative_product_id = 3;</code>
     *
     * @return The representativeProductId.
     */
    public java.lang.String getRepresentativeProductId() {
      java.lang.Object ref = representativeProductId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        representativeProductId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The representative product id for this tile.
     * </pre>
     *
     * <code>string representative_product_id = 3;</code>
     *
     * @return The bytes for representativeProductId.
     */
    public com.google.protobuf.ByteString getRepresentativeProductIdBytes() {
      java.lang.Object ref = representativeProductId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        representativeProductId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The representative product id for this tile.
     * </pre>
     *
     * <code>string representative_product_id = 3;</code>
     *
     * @param value The representativeProductId to set.
     * @return This builder for chaining.
     */
    public Builder setRepresentativeProductId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      representativeProductId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The representative product id for this tile.
     * </pre>
     *
     * <code>string representative_product_id = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRepresentativeProductId() {
      representativeProductId_ = getDefaultInstance().getRepresentativeProductId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The representative product id for this tile.
     * </pre>
     *
     * <code>string representative_product_id = 3;</code>
     *
     * @param value The bytes for representativeProductId to set.
     * @return This builder for chaining.
     */
    public Builder setRepresentativeProductIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      representativeProductId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2.Tile)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2.Tile)
  private static final com.google.cloud.retail.v2.Tile DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2.Tile();
  }

  public static com.google.cloud.retail.v2.Tile getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Tile> PARSER =
      new com.google.protobuf.AbstractParser<Tile>() {
        @java.lang.Override
        public Tile parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Tile> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Tile> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2.Tile getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
