/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2alpha/catalog.proto

package com.google.cloud.retail.v2alpha;

/**
 *
 *
 * <pre>
 * The catalog configuration.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2alpha.Catalog}
 */
public final class Catalog extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.Catalog)
    CatalogOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Catalog.newBuilder() to construct.
  private Catalog(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Catalog() {
    name_ = "";
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Catalog();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2alpha.CatalogProto
        .internal_static_google_cloud_retail_v2alpha_Catalog_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2alpha.CatalogProto
        .internal_static_google_cloud_retail_v2alpha_Catalog_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2alpha.Catalog.class,
            com.google.cloud.retail.v2alpha.Catalog.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. Immutable. The fully qualified resource name of the catalog.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. The fully qualified resource name of the catalog.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. Immutable. The catalog display name.
   *
   * This field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>
   * string display_name = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. The catalog display name.
   *
   * This field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>
   * string display_name = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRODUCT_LEVEL_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.retail.v2alpha.ProductLevelConfig productLevelConfig_;
  /**
   *
   *
   * <pre>
   * Required. The product level configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.ProductLevelConfig product_level_config = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the productLevelConfig field is set.
   */
  @java.lang.Override
  public boolean hasProductLevelConfig() {
    return productLevelConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The product level configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.ProductLevelConfig product_level_config = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The productLevelConfig.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.ProductLevelConfig getProductLevelConfig() {
    return productLevelConfig_ == null
        ? com.google.cloud.retail.v2alpha.ProductLevelConfig.getDefaultInstance()
        : productLevelConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. The product level configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.ProductLevelConfig product_level_config = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.ProductLevelConfigOrBuilder
      getProductLevelConfigOrBuilder() {
    return productLevelConfig_ == null
        ? com.google.cloud.retail.v2alpha.ProductLevelConfig.getDefaultInstance()
        : productLevelConfig_;
  }

  public static final int MERCHANT_CENTER_LINKING_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.retail.v2alpha.MerchantCenterLinkingConfig merchantCenterLinkingConfig_;
  /**
   *
   *
   * <pre>
   * The Merchant Center linking configuration.
   * Once a link is added, the data stream from Merchant Center to Cloud Retail
   * will be enabled automatically. The requester must have access to the
   * merchant center account in order to make changes to this field.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.MerchantCenterLinkingConfig merchant_center_linking_config = 6;
   * </code>
   *
   * @return Whether the merchantCenterLinkingConfig field is set.
   */
  @java.lang.Override
  public boolean hasMerchantCenterLinkingConfig() {
    return merchantCenterLinkingConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * The Merchant Center linking configuration.
   * Once a link is added, the data stream from Merchant Center to Cloud Retail
   * will be enabled automatically. The requester must have access to the
   * merchant center account in order to make changes to this field.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.MerchantCenterLinkingConfig merchant_center_linking_config = 6;
   * </code>
   *
   * @return The merchantCenterLinkingConfig.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.MerchantCenterLinkingConfig
      getMerchantCenterLinkingConfig() {
    return merchantCenterLinkingConfig_ == null
        ? com.google.cloud.retail.v2alpha.MerchantCenterLinkingConfig.getDefaultInstance()
        : merchantCenterLinkingConfig_;
  }
  /**
   *
   *
   * <pre>
   * The Merchant Center linking configuration.
   * Once a link is added, the data stream from Merchant Center to Cloud Retail
   * will be enabled automatically. The requester must have access to the
   * merchant center account in order to make changes to this field.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.MerchantCenterLinkingConfig merchant_center_linking_config = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.MerchantCenterLinkingConfigOrBuilder
      getMerchantCenterLinkingConfigOrBuilder() {
    return merchantCenterLinkingConfig_ == null
        ? com.google.cloud.retail.v2alpha.MerchantCenterLinkingConfig.getDefaultInstance()
        : merchantCenterLinkingConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (productLevelConfig_ != null) {
      output.writeMessage(4, getProductLevelConfig());
    }
    if (merchantCenterLinkingConfig_ != null) {
      output.writeMessage(6, getMerchantCenterLinkingConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (productLevelConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getProductLevelConfig());
    }
    if (merchantCenterLinkingConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, getMerchantCenterLinkingConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2alpha.Catalog)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2alpha.Catalog other = (com.google.cloud.retail.v2alpha.Catalog) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasProductLevelConfig() != other.hasProductLevelConfig()) return false;
    if (hasProductLevelConfig()) {
      if (!getProductLevelConfig().equals(other.getProductLevelConfig())) return false;
    }
    if (hasMerchantCenterLinkingConfig() != other.hasMerchantCenterLinkingConfig()) return false;
    if (hasMerchantCenterLinkingConfig()) {
      if (!getMerchantCenterLinkingConfig().equals(other.getMerchantCenterLinkingConfig()))
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasProductLevelConfig()) {
      hash = (37 * hash) + PRODUCT_LEVEL_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getProductLevelConfig().hashCode();
    }
    if (hasMerchantCenterLinkingConfig()) {
      hash = (37 * hash) + MERCHANT_CENTER_LINKING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getMerchantCenterLinkingConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2alpha.Catalog parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.Catalog parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.Catalog parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.Catalog parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.Catalog parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.Catalog parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.Catalog parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.Catalog parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.Catalog parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.Catalog parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.Catalog parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.Catalog parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2alpha.Catalog prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The catalog configuration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.Catalog}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.Catalog)
      com.google.cloud.retail.v2alpha.CatalogOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.CatalogProto
          .internal_static_google_cloud_retail_v2alpha_Catalog_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.CatalogProto
          .internal_static_google_cloud_retail_v2alpha_Catalog_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.Catalog.class,
              com.google.cloud.retail.v2alpha.Catalog.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2alpha.Catalog.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      productLevelConfig_ = null;
      if (productLevelConfigBuilder_ != null) {
        productLevelConfigBuilder_.dispose();
        productLevelConfigBuilder_ = null;
      }
      merchantCenterLinkingConfig_ = null;
      if (merchantCenterLinkingConfigBuilder_ != null) {
        merchantCenterLinkingConfigBuilder_.dispose();
        merchantCenterLinkingConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2alpha.CatalogProto
          .internal_static_google_cloud_retail_v2alpha_Catalog_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Catalog getDefaultInstanceForType() {
      return com.google.cloud.retail.v2alpha.Catalog.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Catalog build() {
      com.google.cloud.retail.v2alpha.Catalog result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Catalog buildPartial() {
      com.google.cloud.retail.v2alpha.Catalog result =
          new com.google.cloud.retail.v2alpha.Catalog(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.retail.v2alpha.Catalog result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.productLevelConfig_ =
            productLevelConfigBuilder_ == null
                ? productLevelConfig_
                : productLevelConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.merchantCenterLinkingConfig_ =
            merchantCenterLinkingConfigBuilder_ == null
                ? merchantCenterLinkingConfig_
                : merchantCenterLinkingConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2alpha.Catalog) {
        return mergeFrom((com.google.cloud.retail.v2alpha.Catalog) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2alpha.Catalog other) {
      if (other == com.google.cloud.retail.v2alpha.Catalog.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasProductLevelConfig()) {
        mergeProductLevelConfig(other.getProductLevelConfig());
      }
      if (other.hasMerchantCenterLinkingConfig()) {
        mergeMerchantCenterLinkingConfig(other.getMerchantCenterLinkingConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 34:
              {
                input.readMessage(
                    getProductLevelConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 50:
              {
                input.readMessage(
                    getMerchantCenterLinkingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Immutable. The fully qualified resource name of the catalog.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The fully qualified resource name of the catalog.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The fully qualified resource name of the catalog.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The fully qualified resource name of the catalog.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The fully qualified resource name of the catalog.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. Immutable. The catalog display name.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>
     * string display_name = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The catalog display name.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>
     * string display_name = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The catalog display name.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>
     * string display_name = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The catalog display name.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>
     * string display_name = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The catalog display name.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>
     * string display_name = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.retail.v2alpha.ProductLevelConfig productLevelConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.ProductLevelConfig,
            com.google.cloud.retail.v2alpha.ProductLevelConfig.Builder,
            com.google.cloud.retail.v2alpha.ProductLevelConfigOrBuilder>
        productLevelConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The product level configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.ProductLevelConfig product_level_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the productLevelConfig field is set.
     */
    public boolean hasProductLevelConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The product level configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.ProductLevelConfig product_level_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The productLevelConfig.
     */
    public com.google.cloud.retail.v2alpha.ProductLevelConfig getProductLevelConfig() {
      if (productLevelConfigBuilder_ == null) {
        return productLevelConfig_ == null
            ? com.google.cloud.retail.v2alpha.ProductLevelConfig.getDefaultInstance()
            : productLevelConfig_;
      } else {
        return productLevelConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The product level configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.ProductLevelConfig product_level_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setProductLevelConfig(com.google.cloud.retail.v2alpha.ProductLevelConfig value) {
      if (productLevelConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        productLevelConfig_ = value;
      } else {
        productLevelConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The product level configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.ProductLevelConfig product_level_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setProductLevelConfig(
        com.google.cloud.retail.v2alpha.ProductLevelConfig.Builder builderForValue) {
      if (productLevelConfigBuilder_ == null) {
        productLevelConfig_ = builderForValue.build();
      } else {
        productLevelConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The product level configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.ProductLevelConfig product_level_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeProductLevelConfig(
        com.google.cloud.retail.v2alpha.ProductLevelConfig value) {
      if (productLevelConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && productLevelConfig_ != null
            && productLevelConfig_
                != com.google.cloud.retail.v2alpha.ProductLevelConfig.getDefaultInstance()) {
          getProductLevelConfigBuilder().mergeFrom(value);
        } else {
          productLevelConfig_ = value;
        }
      } else {
        productLevelConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The product level configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.ProductLevelConfig product_level_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearProductLevelConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      productLevelConfig_ = null;
      if (productLevelConfigBuilder_ != null) {
        productLevelConfigBuilder_.dispose();
        productLevelConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The product level configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.ProductLevelConfig product_level_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.ProductLevelConfig.Builder
        getProductLevelConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getProductLevelConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The product level configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.ProductLevelConfig product_level_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.ProductLevelConfigOrBuilder
        getProductLevelConfigOrBuilder() {
      if (productLevelConfigBuilder_ != null) {
        return productLevelConfigBuilder_.getMessageOrBuilder();
      } else {
        return productLevelConfig_ == null
            ? com.google.cloud.retail.v2alpha.ProductLevelConfig.getDefaultInstance()
            : productLevelConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The product level configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.ProductLevelConfig product_level_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.ProductLevelConfig,
            com.google.cloud.retail.v2alpha.ProductLevelConfig.Builder,
            com.google.cloud.retail.v2alpha.ProductLevelConfigOrBuilder>
        getProductLevelConfigFieldBuilder() {
      if (productLevelConfigBuilder_ == null) {
        productLevelConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2alpha.ProductLevelConfig,
                com.google.cloud.retail.v2alpha.ProductLevelConfig.Builder,
                com.google.cloud.retail.v2alpha.ProductLevelConfigOrBuilder>(
                getProductLevelConfig(), getParentForChildren(), isClean());
        productLevelConfig_ = null;
      }
      return productLevelConfigBuilder_;
    }

    private com.google.cloud.retail.v2alpha.MerchantCenterLinkingConfig
        merchantCenterLinkingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.MerchantCenterLinkingConfig,
            com.google.cloud.retail.v2alpha.MerchantCenterLinkingConfig.Builder,
            com.google.cloud.retail.v2alpha.MerchantCenterLinkingConfigOrBuilder>
        merchantCenterLinkingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The Merchant Center linking configuration.
     * Once a link is added, the data stream from Merchant Center to Cloud Retail
     * will be enabled automatically. The requester must have access to the
     * merchant center account in order to make changes to this field.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.MerchantCenterLinkingConfig merchant_center_linking_config = 6;
     * </code>
     *
     * @return Whether the merchantCenterLinkingConfig field is set.
     */
    public boolean hasMerchantCenterLinkingConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The Merchant Center linking configuration.
     * Once a link is added, the data stream from Merchant Center to Cloud Retail
     * will be enabled automatically. The requester must have access to the
     * merchant center account in order to make changes to this field.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.MerchantCenterLinkingConfig merchant_center_linking_config = 6;
     * </code>
     *
     * @return The merchantCenterLinkingConfig.
     */
    public com.google.cloud.retail.v2alpha.MerchantCenterLinkingConfig
        getMerchantCenterLinkingConfig() {
      if (merchantCenterLinkingConfigBuilder_ == null) {
        return merchantCenterLinkingConfig_ == null
            ? com.google.cloud.retail.v2alpha.MerchantCenterLinkingConfig.getDefaultInstance()
            : merchantCenterLinkingConfig_;
      } else {
        return merchantCenterLinkingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The Merchant Center linking configuration.
     * Once a link is added, the data stream from Merchant Center to Cloud Retail
     * will be enabled automatically. The requester must have access to the
     * merchant center account in order to make changes to this field.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.MerchantCenterLinkingConfig merchant_center_linking_config = 6;
     * </code>
     */
    public Builder setMerchantCenterLinkingConfig(
        com.google.cloud.retail.v2alpha.MerchantCenterLinkingConfig value) {
      if (merchantCenterLinkingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        merchantCenterLinkingConfig_ = value;
      } else {
        merchantCenterLinkingConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Merchant Center linking configuration.
     * Once a link is added, the data stream from Merchant Center to Cloud Retail
     * will be enabled automatically. The requester must have access to the
     * merchant center account in order to make changes to this field.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.MerchantCenterLinkingConfig merchant_center_linking_config = 6;
     * </code>
     */
    public Builder setMerchantCenterLinkingConfig(
        com.google.cloud.retail.v2alpha.MerchantCenterLinkingConfig.Builder builderForValue) {
      if (merchantCenterLinkingConfigBuilder_ == null) {
        merchantCenterLinkingConfig_ = builderForValue.build();
      } else {
        merchantCenterLinkingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Merchant Center linking configuration.
     * Once a link is added, the data stream from Merchant Center to Cloud Retail
     * will be enabled automatically. The requester must have access to the
     * merchant center account in order to make changes to this field.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.MerchantCenterLinkingConfig merchant_center_linking_config = 6;
     * </code>
     */
    public Builder mergeMerchantCenterLinkingConfig(
        com.google.cloud.retail.v2alpha.MerchantCenterLinkingConfig value) {
      if (merchantCenterLinkingConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && merchantCenterLinkingConfig_ != null
            && merchantCenterLinkingConfig_
                != com.google.cloud.retail.v2alpha.MerchantCenterLinkingConfig
                    .getDefaultInstance()) {
          getMerchantCenterLinkingConfigBuilder().mergeFrom(value);
        } else {
          merchantCenterLinkingConfig_ = value;
        }
      } else {
        merchantCenterLinkingConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Merchant Center linking configuration.
     * Once a link is added, the data stream from Merchant Center to Cloud Retail
     * will be enabled automatically. The requester must have access to the
     * merchant center account in order to make changes to this field.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.MerchantCenterLinkingConfig merchant_center_linking_config = 6;
     * </code>
     */
    public Builder clearMerchantCenterLinkingConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      merchantCenterLinkingConfig_ = null;
      if (merchantCenterLinkingConfigBuilder_ != null) {
        merchantCenterLinkingConfigBuilder_.dispose();
        merchantCenterLinkingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Merchant Center linking configuration.
     * Once a link is added, the data stream from Merchant Center to Cloud Retail
     * will be enabled automatically. The requester must have access to the
     * merchant center account in order to make changes to this field.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.MerchantCenterLinkingConfig merchant_center_linking_config = 6;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.MerchantCenterLinkingConfig.Builder
        getMerchantCenterLinkingConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getMerchantCenterLinkingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Merchant Center linking configuration.
     * Once a link is added, the data stream from Merchant Center to Cloud Retail
     * will be enabled automatically. The requester must have access to the
     * merchant center account in order to make changes to this field.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.MerchantCenterLinkingConfig merchant_center_linking_config = 6;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.MerchantCenterLinkingConfigOrBuilder
        getMerchantCenterLinkingConfigOrBuilder() {
      if (merchantCenterLinkingConfigBuilder_ != null) {
        return merchantCenterLinkingConfigBuilder_.getMessageOrBuilder();
      } else {
        return merchantCenterLinkingConfig_ == null
            ? com.google.cloud.retail.v2alpha.MerchantCenterLinkingConfig.getDefaultInstance()
            : merchantCenterLinkingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The Merchant Center linking configuration.
     * Once a link is added, the data stream from Merchant Center to Cloud Retail
     * will be enabled automatically. The requester must have access to the
     * merchant center account in order to make changes to this field.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.MerchantCenterLinkingConfig merchant_center_linking_config = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.MerchantCenterLinkingConfig,
            com.google.cloud.retail.v2alpha.MerchantCenterLinkingConfig.Builder,
            com.google.cloud.retail.v2alpha.MerchantCenterLinkingConfigOrBuilder>
        getMerchantCenterLinkingConfigFieldBuilder() {
      if (merchantCenterLinkingConfigBuilder_ == null) {
        merchantCenterLinkingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2alpha.MerchantCenterLinkingConfig,
                com.google.cloud.retail.v2alpha.MerchantCenterLinkingConfig.Builder,
                com.google.cloud.retail.v2alpha.MerchantCenterLinkingConfigOrBuilder>(
                getMerchantCenterLinkingConfig(), getParentForChildren(), isClean());
        merchantCenterLinkingConfig_ = null;
      }
      return merchantCenterLinkingConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.Catalog)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.Catalog)
  private static final com.google.cloud.retail.v2alpha.Catalog DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.Catalog();
  }

  public static com.google.cloud.retail.v2alpha.Catalog getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Catalog> PARSER =
      new com.google.protobuf.AbstractParser<Catalog>() {
        @java.lang.Override
        public Catalog parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Catalog> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Catalog> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2alpha.Catalog getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
