/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2alpha/common.proto

package com.google.cloud.retail.v2alpha;

/**
 *
 *
 * <pre>
 * The price information of a [Product][google.cloud.retail.v2alpha.Product].
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2alpha.PriceInfo}
 */
public final class PriceInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.PriceInfo)
    PriceInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PriceInfo.newBuilder() to construct.
  private PriceInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PriceInfo() {
    currencyCode_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PriceInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2alpha.CommonProto
        .internal_static_google_cloud_retail_v2alpha_PriceInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2alpha.CommonProto
        .internal_static_google_cloud_retail_v2alpha_PriceInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2alpha.PriceInfo.class,
            com.google.cloud.retail.v2alpha.PriceInfo.Builder.class);
  }

  public interface PriceRangeOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.PriceInfo.PriceRange)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The inclusive
     * [Product.pricing_info.price][google.cloud.retail.v2alpha.PriceInfo.price]
     * interval of all
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product] having the same
     * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.Interval price = 1;</code>
     *
     * @return Whether the price field is set.
     */
    boolean hasPrice();
    /**
     *
     *
     * <pre>
     * The inclusive
     * [Product.pricing_info.price][google.cloud.retail.v2alpha.PriceInfo.price]
     * interval of all
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product] having the same
     * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.Interval price = 1;</code>
     *
     * @return The price.
     */
    com.google.cloud.retail.v2alpha.Interval getPrice();
    /**
     *
     *
     * <pre>
     * The inclusive
     * [Product.pricing_info.price][google.cloud.retail.v2alpha.PriceInfo.price]
     * interval of all
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product] having the same
     * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.Interval price = 1;</code>
     */
    com.google.cloud.retail.v2alpha.IntervalOrBuilder getPriceOrBuilder();

    /**
     *
     *
     * <pre>
     * The inclusive
     * [Product.pricing_info.original_price][google.cloud.retail.v2alpha.PriceInfo.original_price]
     * internal of all
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product] having the same
     * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.Interval original_price = 2;</code>
     *
     * @return Whether the originalPrice field is set.
     */
    boolean hasOriginalPrice();
    /**
     *
     *
     * <pre>
     * The inclusive
     * [Product.pricing_info.original_price][google.cloud.retail.v2alpha.PriceInfo.original_price]
     * internal of all
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product] having the same
     * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.Interval original_price = 2;</code>
     *
     * @return The originalPrice.
     */
    com.google.cloud.retail.v2alpha.Interval getOriginalPrice();
    /**
     *
     *
     * <pre>
     * The inclusive
     * [Product.pricing_info.original_price][google.cloud.retail.v2alpha.PriceInfo.original_price]
     * internal of all
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product] having the same
     * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.Interval original_price = 2;</code>
     */
    com.google.cloud.retail.v2alpha.IntervalOrBuilder getOriginalPriceOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * The price range of all
   * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
   * [Product][google.cloud.retail.v2alpha.Product] having the same
   * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.PriceInfo.PriceRange}
   */
  public static final class PriceRange extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.PriceInfo.PriceRange)
      PriceRangeOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PriceRange.newBuilder() to construct.
    private PriceRange(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PriceRange() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PriceRange();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.CommonProto
          .internal_static_google_cloud_retail_v2alpha_PriceInfo_PriceRange_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.CommonProto
          .internal_static_google_cloud_retail_v2alpha_PriceInfo_PriceRange_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.PriceInfo.PriceRange.class,
              com.google.cloud.retail.v2alpha.PriceInfo.PriceRange.Builder.class);
    }

    public static final int PRICE_FIELD_NUMBER = 1;
    private com.google.cloud.retail.v2alpha.Interval price_;
    /**
     *
     *
     * <pre>
     * The inclusive
     * [Product.pricing_info.price][google.cloud.retail.v2alpha.PriceInfo.price]
     * interval of all
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product] having the same
     * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.Interval price = 1;</code>
     *
     * @return Whether the price field is set.
     */
    @java.lang.Override
    public boolean hasPrice() {
      return price_ != null;
    }
    /**
     *
     *
     * <pre>
     * The inclusive
     * [Product.pricing_info.price][google.cloud.retail.v2alpha.PriceInfo.price]
     * interval of all
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product] having the same
     * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.Interval price = 1;</code>
     *
     * @return The price.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Interval getPrice() {
      return price_ == null
          ? com.google.cloud.retail.v2alpha.Interval.getDefaultInstance()
          : price_;
    }
    /**
     *
     *
     * <pre>
     * The inclusive
     * [Product.pricing_info.price][google.cloud.retail.v2alpha.PriceInfo.price]
     * interval of all
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product] having the same
     * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.Interval price = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.IntervalOrBuilder getPriceOrBuilder() {
      return price_ == null
          ? com.google.cloud.retail.v2alpha.Interval.getDefaultInstance()
          : price_;
    }

    public static final int ORIGINAL_PRICE_FIELD_NUMBER = 2;
    private com.google.cloud.retail.v2alpha.Interval originalPrice_;
    /**
     *
     *
     * <pre>
     * The inclusive
     * [Product.pricing_info.original_price][google.cloud.retail.v2alpha.PriceInfo.original_price]
     * internal of all
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product] having the same
     * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.Interval original_price = 2;</code>
     *
     * @return Whether the originalPrice field is set.
     */
    @java.lang.Override
    public boolean hasOriginalPrice() {
      return originalPrice_ != null;
    }
    /**
     *
     *
     * <pre>
     * The inclusive
     * [Product.pricing_info.original_price][google.cloud.retail.v2alpha.PriceInfo.original_price]
     * internal of all
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product] having the same
     * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.Interval original_price = 2;</code>
     *
     * @return The originalPrice.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Interval getOriginalPrice() {
      return originalPrice_ == null
          ? com.google.cloud.retail.v2alpha.Interval.getDefaultInstance()
          : originalPrice_;
    }
    /**
     *
     *
     * <pre>
     * The inclusive
     * [Product.pricing_info.original_price][google.cloud.retail.v2alpha.PriceInfo.original_price]
     * internal of all
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product] having the same
     * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.Interval original_price = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.IntervalOrBuilder getOriginalPriceOrBuilder() {
      return originalPrice_ == null
          ? com.google.cloud.retail.v2alpha.Interval.getDefaultInstance()
          : originalPrice_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (price_ != null) {
        output.writeMessage(1, getPrice());
      }
      if (originalPrice_ != null) {
        output.writeMessage(2, getOriginalPrice());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (price_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getPrice());
      }
      if (originalPrice_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getOriginalPrice());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2alpha.PriceInfo.PriceRange)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2alpha.PriceInfo.PriceRange other =
          (com.google.cloud.retail.v2alpha.PriceInfo.PriceRange) obj;

      if (hasPrice() != other.hasPrice()) return false;
      if (hasPrice()) {
        if (!getPrice().equals(other.getPrice())) return false;
      }
      if (hasOriginalPrice() != other.hasOriginalPrice()) return false;
      if (hasOriginalPrice()) {
        if (!getOriginalPrice().equals(other.getOriginalPrice())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasPrice()) {
        hash = (37 * hash) + PRICE_FIELD_NUMBER;
        hash = (53 * hash) + getPrice().hashCode();
      }
      if (hasOriginalPrice()) {
        hash = (37 * hash) + ORIGINAL_PRICE_FIELD_NUMBER;
        hash = (53 * hash) + getOriginalPrice().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2alpha.PriceInfo.PriceRange parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.PriceInfo.PriceRange parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.PriceInfo.PriceRange parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.PriceInfo.PriceRange parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.PriceInfo.PriceRange parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.PriceInfo.PriceRange parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.PriceInfo.PriceRange parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.PriceInfo.PriceRange parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.PriceInfo.PriceRange parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.PriceInfo.PriceRange parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.PriceInfo.PriceRange parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.PriceInfo.PriceRange parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2alpha.PriceInfo.PriceRange prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The price range of all
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product] having the same
     * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2alpha.PriceInfo.PriceRange}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.PriceInfo.PriceRange)
        com.google.cloud.retail.v2alpha.PriceInfo.PriceRangeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.CommonProto
            .internal_static_google_cloud_retail_v2alpha_PriceInfo_PriceRange_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.CommonProto
            .internal_static_google_cloud_retail_v2alpha_PriceInfo_PriceRange_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.PriceInfo.PriceRange.class,
                com.google.cloud.retail.v2alpha.PriceInfo.PriceRange.Builder.class);
      }

      // Construct using com.google.cloud.retail.v2alpha.PriceInfo.PriceRange.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        price_ = null;
        if (priceBuilder_ != null) {
          priceBuilder_.dispose();
          priceBuilder_ = null;
        }
        originalPrice_ = null;
        if (originalPriceBuilder_ != null) {
          originalPriceBuilder_.dispose();
          originalPriceBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2alpha.CommonProto
            .internal_static_google_cloud_retail_v2alpha_PriceInfo_PriceRange_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.PriceInfo.PriceRange getDefaultInstanceForType() {
        return com.google.cloud.retail.v2alpha.PriceInfo.PriceRange.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.PriceInfo.PriceRange build() {
        com.google.cloud.retail.v2alpha.PriceInfo.PriceRange result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.PriceInfo.PriceRange buildPartial() {
        com.google.cloud.retail.v2alpha.PriceInfo.PriceRange result =
            new com.google.cloud.retail.v2alpha.PriceInfo.PriceRange(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.retail.v2alpha.PriceInfo.PriceRange result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.price_ = priceBuilder_ == null ? price_ : priceBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.originalPrice_ =
              originalPriceBuilder_ == null ? originalPrice_ : originalPriceBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2alpha.PriceInfo.PriceRange) {
          return mergeFrom((com.google.cloud.retail.v2alpha.PriceInfo.PriceRange) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.retail.v2alpha.PriceInfo.PriceRange other) {
        if (other == com.google.cloud.retail.v2alpha.PriceInfo.PriceRange.getDefaultInstance())
          return this;
        if (other.hasPrice()) {
          mergePrice(other.getPrice());
        }
        if (other.hasOriginalPrice()) {
          mergeOriginalPrice(other.getOriginalPrice());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getPriceFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getOriginalPriceFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.retail.v2alpha.Interval price_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.retail.v2alpha.Interval,
              com.google.cloud.retail.v2alpha.Interval.Builder,
              com.google.cloud.retail.v2alpha.IntervalOrBuilder>
          priceBuilder_;
      /**
       *
       *
       * <pre>
       * The inclusive
       * [Product.pricing_info.price][google.cloud.retail.v2alpha.PriceInfo.price]
       * interval of all
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2alpha.Product] having the same
       * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.Interval price = 1;</code>
       *
       * @return Whether the price field is set.
       */
      public boolean hasPrice() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The inclusive
       * [Product.pricing_info.price][google.cloud.retail.v2alpha.PriceInfo.price]
       * interval of all
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2alpha.Product] having the same
       * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.Interval price = 1;</code>
       *
       * @return The price.
       */
      public com.google.cloud.retail.v2alpha.Interval getPrice() {
        if (priceBuilder_ == null) {
          return price_ == null
              ? com.google.cloud.retail.v2alpha.Interval.getDefaultInstance()
              : price_;
        } else {
          return priceBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The inclusive
       * [Product.pricing_info.price][google.cloud.retail.v2alpha.PriceInfo.price]
       * interval of all
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2alpha.Product] having the same
       * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.Interval price = 1;</code>
       */
      public Builder setPrice(com.google.cloud.retail.v2alpha.Interval value) {
        if (priceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          price_ = value;
        } else {
          priceBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The inclusive
       * [Product.pricing_info.price][google.cloud.retail.v2alpha.PriceInfo.price]
       * interval of all
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2alpha.Product] having the same
       * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.Interval price = 1;</code>
       */
      public Builder setPrice(com.google.cloud.retail.v2alpha.Interval.Builder builderForValue) {
        if (priceBuilder_ == null) {
          price_ = builderForValue.build();
        } else {
          priceBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The inclusive
       * [Product.pricing_info.price][google.cloud.retail.v2alpha.PriceInfo.price]
       * interval of all
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2alpha.Product] having the same
       * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.Interval price = 1;</code>
       */
      public Builder mergePrice(com.google.cloud.retail.v2alpha.Interval value) {
        if (priceBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && price_ != null
              && price_ != com.google.cloud.retail.v2alpha.Interval.getDefaultInstance()) {
            getPriceBuilder().mergeFrom(value);
          } else {
            price_ = value;
          }
        } else {
          priceBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The inclusive
       * [Product.pricing_info.price][google.cloud.retail.v2alpha.PriceInfo.price]
       * interval of all
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2alpha.Product] having the same
       * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.Interval price = 1;</code>
       */
      public Builder clearPrice() {
        bitField0_ = (bitField0_ & ~0x00000001);
        price_ = null;
        if (priceBuilder_ != null) {
          priceBuilder_.dispose();
          priceBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The inclusive
       * [Product.pricing_info.price][google.cloud.retail.v2alpha.PriceInfo.price]
       * interval of all
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2alpha.Product] having the same
       * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.Interval price = 1;</code>
       */
      public com.google.cloud.retail.v2alpha.Interval.Builder getPriceBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getPriceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The inclusive
       * [Product.pricing_info.price][google.cloud.retail.v2alpha.PriceInfo.price]
       * interval of all
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2alpha.Product] having the same
       * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.Interval price = 1;</code>
       */
      public com.google.cloud.retail.v2alpha.IntervalOrBuilder getPriceOrBuilder() {
        if (priceBuilder_ != null) {
          return priceBuilder_.getMessageOrBuilder();
        } else {
          return price_ == null
              ? com.google.cloud.retail.v2alpha.Interval.getDefaultInstance()
              : price_;
        }
      }
      /**
       *
       *
       * <pre>
       * The inclusive
       * [Product.pricing_info.price][google.cloud.retail.v2alpha.PriceInfo.price]
       * interval of all
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2alpha.Product] having the same
       * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.Interval price = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.retail.v2alpha.Interval,
              com.google.cloud.retail.v2alpha.Interval.Builder,
              com.google.cloud.retail.v2alpha.IntervalOrBuilder>
          getPriceFieldBuilder() {
        if (priceBuilder_ == null) {
          priceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.retail.v2alpha.Interval,
                  com.google.cloud.retail.v2alpha.Interval.Builder,
                  com.google.cloud.retail.v2alpha.IntervalOrBuilder>(
                  getPrice(), getParentForChildren(), isClean());
          price_ = null;
        }
        return priceBuilder_;
      }

      private com.google.cloud.retail.v2alpha.Interval originalPrice_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.retail.v2alpha.Interval,
              com.google.cloud.retail.v2alpha.Interval.Builder,
              com.google.cloud.retail.v2alpha.IntervalOrBuilder>
          originalPriceBuilder_;
      /**
       *
       *
       * <pre>
       * The inclusive
       * [Product.pricing_info.original_price][google.cloud.retail.v2alpha.PriceInfo.original_price]
       * internal of all
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2alpha.Product] having the same
       * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.Interval original_price = 2;</code>
       *
       * @return Whether the originalPrice field is set.
       */
      public boolean hasOriginalPrice() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The inclusive
       * [Product.pricing_info.original_price][google.cloud.retail.v2alpha.PriceInfo.original_price]
       * internal of all
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2alpha.Product] having the same
       * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.Interval original_price = 2;</code>
       *
       * @return The originalPrice.
       */
      public com.google.cloud.retail.v2alpha.Interval getOriginalPrice() {
        if (originalPriceBuilder_ == null) {
          return originalPrice_ == null
              ? com.google.cloud.retail.v2alpha.Interval.getDefaultInstance()
              : originalPrice_;
        } else {
          return originalPriceBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The inclusive
       * [Product.pricing_info.original_price][google.cloud.retail.v2alpha.PriceInfo.original_price]
       * internal of all
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2alpha.Product] having the same
       * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.Interval original_price = 2;</code>
       */
      public Builder setOriginalPrice(com.google.cloud.retail.v2alpha.Interval value) {
        if (originalPriceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          originalPrice_ = value;
        } else {
          originalPriceBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The inclusive
       * [Product.pricing_info.original_price][google.cloud.retail.v2alpha.PriceInfo.original_price]
       * internal of all
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2alpha.Product] having the same
       * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.Interval original_price = 2;</code>
       */
      public Builder setOriginalPrice(
          com.google.cloud.retail.v2alpha.Interval.Builder builderForValue) {
        if (originalPriceBuilder_ == null) {
          originalPrice_ = builderForValue.build();
        } else {
          originalPriceBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The inclusive
       * [Product.pricing_info.original_price][google.cloud.retail.v2alpha.PriceInfo.original_price]
       * internal of all
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2alpha.Product] having the same
       * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.Interval original_price = 2;</code>
       */
      public Builder mergeOriginalPrice(com.google.cloud.retail.v2alpha.Interval value) {
        if (originalPriceBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && originalPrice_ != null
              && originalPrice_ != com.google.cloud.retail.v2alpha.Interval.getDefaultInstance()) {
            getOriginalPriceBuilder().mergeFrom(value);
          } else {
            originalPrice_ = value;
          }
        } else {
          originalPriceBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The inclusive
       * [Product.pricing_info.original_price][google.cloud.retail.v2alpha.PriceInfo.original_price]
       * internal of all
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2alpha.Product] having the same
       * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.Interval original_price = 2;</code>
       */
      public Builder clearOriginalPrice() {
        bitField0_ = (bitField0_ & ~0x00000002);
        originalPrice_ = null;
        if (originalPriceBuilder_ != null) {
          originalPriceBuilder_.dispose();
          originalPriceBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The inclusive
       * [Product.pricing_info.original_price][google.cloud.retail.v2alpha.PriceInfo.original_price]
       * internal of all
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2alpha.Product] having the same
       * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.Interval original_price = 2;</code>
       */
      public com.google.cloud.retail.v2alpha.Interval.Builder getOriginalPriceBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getOriginalPriceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The inclusive
       * [Product.pricing_info.original_price][google.cloud.retail.v2alpha.PriceInfo.original_price]
       * internal of all
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2alpha.Product] having the same
       * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.Interval original_price = 2;</code>
       */
      public com.google.cloud.retail.v2alpha.IntervalOrBuilder getOriginalPriceOrBuilder() {
        if (originalPriceBuilder_ != null) {
          return originalPriceBuilder_.getMessageOrBuilder();
        } else {
          return originalPrice_ == null
              ? com.google.cloud.retail.v2alpha.Interval.getDefaultInstance()
              : originalPrice_;
        }
      }
      /**
       *
       *
       * <pre>
       * The inclusive
       * [Product.pricing_info.original_price][google.cloud.retail.v2alpha.PriceInfo.original_price]
       * internal of all
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * [Product][google.cloud.retail.v2alpha.Product] having the same
       * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.Interval original_price = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.retail.v2alpha.Interval,
              com.google.cloud.retail.v2alpha.Interval.Builder,
              com.google.cloud.retail.v2alpha.IntervalOrBuilder>
          getOriginalPriceFieldBuilder() {
        if (originalPriceBuilder_ == null) {
          originalPriceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.retail.v2alpha.Interval,
                  com.google.cloud.retail.v2alpha.Interval.Builder,
                  com.google.cloud.retail.v2alpha.IntervalOrBuilder>(
                  getOriginalPrice(), getParentForChildren(), isClean());
          originalPrice_ = null;
        }
        return originalPriceBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.PriceInfo.PriceRange)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.PriceInfo.PriceRange)
    private static final com.google.cloud.retail.v2alpha.PriceInfo.PriceRange DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.PriceInfo.PriceRange();
    }

    public static com.google.cloud.retail.v2alpha.PriceInfo.PriceRange getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PriceRange> PARSER =
        new com.google.protobuf.AbstractParser<PriceRange>() {
          @java.lang.Override
          public PriceRange parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PriceRange> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PriceRange> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.PriceInfo.PriceRange getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int CURRENCY_CODE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object currencyCode_ = "";
  /**
   *
   *
   * <pre>
   * The 3-letter currency code defined in [ISO
   * 4217](https://www.iso.org/iso-4217-currency-codes.html).
   *
   * If this field is an unrecognizable currency code, an INVALID_ARGUMENT
   * error is returned.
   *
   * The
   * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
   * [Product][google.cloud.retail.v2alpha.Product]s with the same
   * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id]
   * must share the same
   * [currency_code][google.cloud.retail.v2alpha.PriceInfo.currency_code].
   * Otherwise, a FAILED_PRECONDITION error is returned.
   * </pre>
   *
   * <code>string currency_code = 1;</code>
   *
   * @return The currencyCode.
   */
  @java.lang.Override
  public java.lang.String getCurrencyCode() {
    java.lang.Object ref = currencyCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      currencyCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The 3-letter currency code defined in [ISO
   * 4217](https://www.iso.org/iso-4217-currency-codes.html).
   *
   * If this field is an unrecognizable currency code, an INVALID_ARGUMENT
   * error is returned.
   *
   * The
   * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
   * [Product][google.cloud.retail.v2alpha.Product]s with the same
   * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id]
   * must share the same
   * [currency_code][google.cloud.retail.v2alpha.PriceInfo.currency_code].
   * Otherwise, a FAILED_PRECONDITION error is returned.
   * </pre>
   *
   * <code>string currency_code = 1;</code>
   *
   * @return The bytes for currencyCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCurrencyCodeBytes() {
    java.lang.Object ref = currencyCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      currencyCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRICE_FIELD_NUMBER = 2;
  private float price_ = 0F;
  /**
   *
   *
   * <pre>
   * Price of the product.
   *
   * Google Merchant Center property
   * [price](https://support.google.com/merchants/answer/6324371). Schema.org
   * property [Offer.price](https://schema.org/price).
   * </pre>
   *
   * <code>float price = 2;</code>
   *
   * @return The price.
   */
  @java.lang.Override
  public float getPrice() {
    return price_;
  }

  public static final int ORIGINAL_PRICE_FIELD_NUMBER = 3;
  private float originalPrice_ = 0F;
  /**
   *
   *
   * <pre>
   * Price of the product without any discount. If zero, by default set to be
   * the [price][google.cloud.retail.v2alpha.PriceInfo.price]. If set,
   * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price]
   * should be greater than or equal to
   * [price][google.cloud.retail.v2alpha.PriceInfo.price], otherwise an
   * INVALID_ARGUMENT error is thrown.
   * </pre>
   *
   * <code>float original_price = 3;</code>
   *
   * @return The originalPrice.
   */
  @java.lang.Override
  public float getOriginalPrice() {
    return originalPrice_;
  }

  public static final int COST_FIELD_NUMBER = 4;
  private float cost_ = 0F;
  /**
   *
   *
   * <pre>
   * The costs associated with the sale of a particular product. Used for gross
   * profit reporting.
   *
   * * Profit = [price][google.cloud.retail.v2alpha.PriceInfo.price] -
   * [cost][google.cloud.retail.v2alpha.PriceInfo.cost]
   *
   * Google Merchant Center property
   * [cost_of_goods_sold](https://support.google.com/merchants/answer/9017895).
   * </pre>
   *
   * <code>float cost = 4;</code>
   *
   * @return The cost.
   */
  @java.lang.Override
  public float getCost() {
    return cost_;
  }

  public static final int PRICE_EFFECTIVE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp priceEffectiveTime_;
  /**
   *
   *
   * <pre>
   * The timestamp when the [price][google.cloud.retail.v2alpha.PriceInfo.price]
   * starts to be effective. This can be set as a future timestamp, and the
   * [price][google.cloud.retail.v2alpha.PriceInfo.price] is only used for
   * search after
   * [price_effective_time][google.cloud.retail.v2alpha.PriceInfo.price_effective_time].
   * If so, the
   * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] must
   * be set and
   * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] is
   * used before
   * [price_effective_time][google.cloud.retail.v2alpha.PriceInfo.price_effective_time].
   *
   * Do not set if [price][google.cloud.retail.v2alpha.PriceInfo.price] is
   * always effective because it will cause additional latency during search.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp price_effective_time = 5;</code>
   *
   * @return Whether the priceEffectiveTime field is set.
   */
  @java.lang.Override
  public boolean hasPriceEffectiveTime() {
    return priceEffectiveTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The timestamp when the [price][google.cloud.retail.v2alpha.PriceInfo.price]
   * starts to be effective. This can be set as a future timestamp, and the
   * [price][google.cloud.retail.v2alpha.PriceInfo.price] is only used for
   * search after
   * [price_effective_time][google.cloud.retail.v2alpha.PriceInfo.price_effective_time].
   * If so, the
   * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] must
   * be set and
   * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] is
   * used before
   * [price_effective_time][google.cloud.retail.v2alpha.PriceInfo.price_effective_time].
   *
   * Do not set if [price][google.cloud.retail.v2alpha.PriceInfo.price] is
   * always effective because it will cause additional latency during search.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp price_effective_time = 5;</code>
   *
   * @return The priceEffectiveTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getPriceEffectiveTime() {
    return priceEffectiveTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : priceEffectiveTime_;
  }
  /**
   *
   *
   * <pre>
   * The timestamp when the [price][google.cloud.retail.v2alpha.PriceInfo.price]
   * starts to be effective. This can be set as a future timestamp, and the
   * [price][google.cloud.retail.v2alpha.PriceInfo.price] is only used for
   * search after
   * [price_effective_time][google.cloud.retail.v2alpha.PriceInfo.price_effective_time].
   * If so, the
   * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] must
   * be set and
   * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] is
   * used before
   * [price_effective_time][google.cloud.retail.v2alpha.PriceInfo.price_effective_time].
   *
   * Do not set if [price][google.cloud.retail.v2alpha.PriceInfo.price] is
   * always effective because it will cause additional latency during search.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp price_effective_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getPriceEffectiveTimeOrBuilder() {
    return priceEffectiveTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : priceEffectiveTime_;
  }

  public static final int PRICE_EXPIRE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp priceExpireTime_;
  /**
   *
   *
   * <pre>
   * The timestamp when the [price][google.cloud.retail.v2alpha.PriceInfo.price]
   * stops to be effective. The
   * [price][google.cloud.retail.v2alpha.PriceInfo.price] is used for search
   * before
   * [price_expire_time][google.cloud.retail.v2alpha.PriceInfo.price_expire_time].
   * If this field is set, the
   * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] must
   * be set and
   * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] is
   * used after
   * [price_expire_time][google.cloud.retail.v2alpha.PriceInfo.price_expire_time].
   *
   * Do not set if [price][google.cloud.retail.v2alpha.PriceInfo.price] is
   * always effective because it will cause additional latency during search.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp price_expire_time = 6;</code>
   *
   * @return Whether the priceExpireTime field is set.
   */
  @java.lang.Override
  public boolean hasPriceExpireTime() {
    return priceExpireTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The timestamp when the [price][google.cloud.retail.v2alpha.PriceInfo.price]
   * stops to be effective. The
   * [price][google.cloud.retail.v2alpha.PriceInfo.price] is used for search
   * before
   * [price_expire_time][google.cloud.retail.v2alpha.PriceInfo.price_expire_time].
   * If this field is set, the
   * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] must
   * be set and
   * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] is
   * used after
   * [price_expire_time][google.cloud.retail.v2alpha.PriceInfo.price_expire_time].
   *
   * Do not set if [price][google.cloud.retail.v2alpha.PriceInfo.price] is
   * always effective because it will cause additional latency during search.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp price_expire_time = 6;</code>
   *
   * @return The priceExpireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getPriceExpireTime() {
    return priceExpireTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : priceExpireTime_;
  }
  /**
   *
   *
   * <pre>
   * The timestamp when the [price][google.cloud.retail.v2alpha.PriceInfo.price]
   * stops to be effective. The
   * [price][google.cloud.retail.v2alpha.PriceInfo.price] is used for search
   * before
   * [price_expire_time][google.cloud.retail.v2alpha.PriceInfo.price_expire_time].
   * If this field is set, the
   * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] must
   * be set and
   * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] is
   * used after
   * [price_expire_time][google.cloud.retail.v2alpha.PriceInfo.price_expire_time].
   *
   * Do not set if [price][google.cloud.retail.v2alpha.PriceInfo.price] is
   * always effective because it will cause additional latency during search.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp price_expire_time = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getPriceExpireTimeOrBuilder() {
    return priceExpireTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : priceExpireTime_;
  }

  public static final int PRICE_RANGE_FIELD_NUMBER = 7;
  private com.google.cloud.retail.v2alpha.PriceInfo.PriceRange priceRange_;
  /**
   *
   *
   * <pre>
   * Output only. The price range of all the child
   * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
   * [Product][google.cloud.retail.v2alpha.Product]s grouped together on the
   * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2alpha.Product]. Only populated for
   * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2alpha.Product]s.
   *
   * Note: This field is OUTPUT_ONLY for
   * [ProductService.GetProduct][google.cloud.retail.v2alpha.ProductService.GetProduct].
   * Do not set this field in API requests.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.PriceInfo.PriceRange price_range = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the priceRange field is set.
   */
  @java.lang.Override
  public boolean hasPriceRange() {
    return priceRange_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The price range of all the child
   * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
   * [Product][google.cloud.retail.v2alpha.Product]s grouped together on the
   * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2alpha.Product]. Only populated for
   * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2alpha.Product]s.
   *
   * Note: This field is OUTPUT_ONLY for
   * [ProductService.GetProduct][google.cloud.retail.v2alpha.ProductService.GetProduct].
   * Do not set this field in API requests.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.PriceInfo.PriceRange price_range = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The priceRange.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.PriceInfo.PriceRange getPriceRange() {
    return priceRange_ == null
        ? com.google.cloud.retail.v2alpha.PriceInfo.PriceRange.getDefaultInstance()
        : priceRange_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The price range of all the child
   * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
   * [Product][google.cloud.retail.v2alpha.Product]s grouped together on the
   * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2alpha.Product]. Only populated for
   * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
   * [Product][google.cloud.retail.v2alpha.Product]s.
   *
   * Note: This field is OUTPUT_ONLY for
   * [ProductService.GetProduct][google.cloud.retail.v2alpha.ProductService.GetProduct].
   * Do not set this field in API requests.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.PriceInfo.PriceRange price_range = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.PriceInfo.PriceRangeOrBuilder getPriceRangeOrBuilder() {
    return priceRange_ == null
        ? com.google.cloud.retail.v2alpha.PriceInfo.PriceRange.getDefaultInstance()
        : priceRange_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(currencyCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, currencyCode_);
    }
    if (java.lang.Float.floatToRawIntBits(price_) != 0) {
      output.writeFloat(2, price_);
    }
    if (java.lang.Float.floatToRawIntBits(originalPrice_) != 0) {
      output.writeFloat(3, originalPrice_);
    }
    if (java.lang.Float.floatToRawIntBits(cost_) != 0) {
      output.writeFloat(4, cost_);
    }
    if (priceEffectiveTime_ != null) {
      output.writeMessage(5, getPriceEffectiveTime());
    }
    if (priceExpireTime_ != null) {
      output.writeMessage(6, getPriceExpireTime());
    }
    if (priceRange_ != null) {
      output.writeMessage(7, getPriceRange());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(currencyCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, currencyCode_);
    }
    if (java.lang.Float.floatToRawIntBits(price_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, price_);
    }
    if (java.lang.Float.floatToRawIntBits(originalPrice_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(3, originalPrice_);
    }
    if (java.lang.Float.floatToRawIntBits(cost_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(4, cost_);
    }
    if (priceEffectiveTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getPriceEffectiveTime());
    }
    if (priceExpireTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getPriceExpireTime());
    }
    if (priceRange_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getPriceRange());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2alpha.PriceInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2alpha.PriceInfo other =
        (com.google.cloud.retail.v2alpha.PriceInfo) obj;

    if (!getCurrencyCode().equals(other.getCurrencyCode())) return false;
    if (java.lang.Float.floatToIntBits(getPrice())
        != java.lang.Float.floatToIntBits(other.getPrice())) return false;
    if (java.lang.Float.floatToIntBits(getOriginalPrice())
        != java.lang.Float.floatToIntBits(other.getOriginalPrice())) return false;
    if (java.lang.Float.floatToIntBits(getCost())
        != java.lang.Float.floatToIntBits(other.getCost())) return false;
    if (hasPriceEffectiveTime() != other.hasPriceEffectiveTime()) return false;
    if (hasPriceEffectiveTime()) {
      if (!getPriceEffectiveTime().equals(other.getPriceEffectiveTime())) return false;
    }
    if (hasPriceExpireTime() != other.hasPriceExpireTime()) return false;
    if (hasPriceExpireTime()) {
      if (!getPriceExpireTime().equals(other.getPriceExpireTime())) return false;
    }
    if (hasPriceRange() != other.hasPriceRange()) return false;
    if (hasPriceRange()) {
      if (!getPriceRange().equals(other.getPriceRange())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CURRENCY_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getCurrencyCode().hashCode();
    hash = (37 * hash) + PRICE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getPrice());
    hash = (37 * hash) + ORIGINAL_PRICE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getOriginalPrice());
    hash = (37 * hash) + COST_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getCost());
    if (hasPriceEffectiveTime()) {
      hash = (37 * hash) + PRICE_EFFECTIVE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getPriceEffectiveTime().hashCode();
    }
    if (hasPriceExpireTime()) {
      hash = (37 * hash) + PRICE_EXPIRE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getPriceExpireTime().hashCode();
    }
    if (hasPriceRange()) {
      hash = (37 * hash) + PRICE_RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getPriceRange().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2alpha.PriceInfo parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.PriceInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.PriceInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.PriceInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.PriceInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.PriceInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.PriceInfo parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.PriceInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.PriceInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.PriceInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.PriceInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.PriceInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2alpha.PriceInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The price information of a [Product][google.cloud.retail.v2alpha.Product].
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.PriceInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.PriceInfo)
      com.google.cloud.retail.v2alpha.PriceInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.CommonProto
          .internal_static_google_cloud_retail_v2alpha_PriceInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.CommonProto
          .internal_static_google_cloud_retail_v2alpha_PriceInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.PriceInfo.class,
              com.google.cloud.retail.v2alpha.PriceInfo.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2alpha.PriceInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      currencyCode_ = "";
      price_ = 0F;
      originalPrice_ = 0F;
      cost_ = 0F;
      priceEffectiveTime_ = null;
      if (priceEffectiveTimeBuilder_ != null) {
        priceEffectiveTimeBuilder_.dispose();
        priceEffectiveTimeBuilder_ = null;
      }
      priceExpireTime_ = null;
      if (priceExpireTimeBuilder_ != null) {
        priceExpireTimeBuilder_.dispose();
        priceExpireTimeBuilder_ = null;
      }
      priceRange_ = null;
      if (priceRangeBuilder_ != null) {
        priceRangeBuilder_.dispose();
        priceRangeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2alpha.CommonProto
          .internal_static_google_cloud_retail_v2alpha_PriceInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.PriceInfo getDefaultInstanceForType() {
      return com.google.cloud.retail.v2alpha.PriceInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.PriceInfo build() {
      com.google.cloud.retail.v2alpha.PriceInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.PriceInfo buildPartial() {
      com.google.cloud.retail.v2alpha.PriceInfo result =
          new com.google.cloud.retail.v2alpha.PriceInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.retail.v2alpha.PriceInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.currencyCode_ = currencyCode_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.price_ = price_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.originalPrice_ = originalPrice_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.cost_ = cost_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.priceEffectiveTime_ =
            priceEffectiveTimeBuilder_ == null
                ? priceEffectiveTime_
                : priceEffectiveTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.priceExpireTime_ =
            priceExpireTimeBuilder_ == null ? priceExpireTime_ : priceExpireTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.priceRange_ = priceRangeBuilder_ == null ? priceRange_ : priceRangeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2alpha.PriceInfo) {
        return mergeFrom((com.google.cloud.retail.v2alpha.PriceInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2alpha.PriceInfo other) {
      if (other == com.google.cloud.retail.v2alpha.PriceInfo.getDefaultInstance()) return this;
      if (!other.getCurrencyCode().isEmpty()) {
        currencyCode_ = other.currencyCode_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getPrice() != 0F) {
        setPrice(other.getPrice());
      }
      if (other.getOriginalPrice() != 0F) {
        setOriginalPrice(other.getOriginalPrice());
      }
      if (other.getCost() != 0F) {
        setCost(other.getCost());
      }
      if (other.hasPriceEffectiveTime()) {
        mergePriceEffectiveTime(other.getPriceEffectiveTime());
      }
      if (other.hasPriceExpireTime()) {
        mergePriceExpireTime(other.getPriceExpireTime());
      }
      if (other.hasPriceRange()) {
        mergePriceRange(other.getPriceRange());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                currencyCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 21:
              {
                price_ = input.readFloat();
                bitField0_ |= 0x00000002;
                break;
              } // case 21
            case 29:
              {
                originalPrice_ = input.readFloat();
                bitField0_ |= 0x00000004;
                break;
              } // case 29
            case 37:
              {
                cost_ = input.readFloat();
                bitField0_ |= 0x00000008;
                break;
              } // case 37
            case 42:
              {
                input.readMessage(
                    getPriceEffectiveTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getPriceExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getPriceRangeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object currencyCode_ = "";
    /**
     *
     *
     * <pre>
     * The 3-letter currency code defined in [ISO
     * 4217](https://www.iso.org/iso-4217-currency-codes.html).
     *
     * If this field is an unrecognizable currency code, an INVALID_ARGUMENT
     * error is returned.
     *
     * The
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s with the same
     * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id]
     * must share the same
     * [currency_code][google.cloud.retail.v2alpha.PriceInfo.currency_code].
     * Otherwise, a FAILED_PRECONDITION error is returned.
     * </pre>
     *
     * <code>string currency_code = 1;</code>
     *
     * @return The currencyCode.
     */
    public java.lang.String getCurrencyCode() {
      java.lang.Object ref = currencyCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        currencyCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The 3-letter currency code defined in [ISO
     * 4217](https://www.iso.org/iso-4217-currency-codes.html).
     *
     * If this field is an unrecognizable currency code, an INVALID_ARGUMENT
     * error is returned.
     *
     * The
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s with the same
     * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id]
     * must share the same
     * [currency_code][google.cloud.retail.v2alpha.PriceInfo.currency_code].
     * Otherwise, a FAILED_PRECONDITION error is returned.
     * </pre>
     *
     * <code>string currency_code = 1;</code>
     *
     * @return The bytes for currencyCode.
     */
    public com.google.protobuf.ByteString getCurrencyCodeBytes() {
      java.lang.Object ref = currencyCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        currencyCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The 3-letter currency code defined in [ISO
     * 4217](https://www.iso.org/iso-4217-currency-codes.html).
     *
     * If this field is an unrecognizable currency code, an INVALID_ARGUMENT
     * error is returned.
     *
     * The
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s with the same
     * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id]
     * must share the same
     * [currency_code][google.cloud.retail.v2alpha.PriceInfo.currency_code].
     * Otherwise, a FAILED_PRECONDITION error is returned.
     * </pre>
     *
     * <code>string currency_code = 1;</code>
     *
     * @param value The currencyCode to set.
     * @return This builder for chaining.
     */
    public Builder setCurrencyCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      currencyCode_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The 3-letter currency code defined in [ISO
     * 4217](https://www.iso.org/iso-4217-currency-codes.html).
     *
     * If this field is an unrecognizable currency code, an INVALID_ARGUMENT
     * error is returned.
     *
     * The
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s with the same
     * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id]
     * must share the same
     * [currency_code][google.cloud.retail.v2alpha.PriceInfo.currency_code].
     * Otherwise, a FAILED_PRECONDITION error is returned.
     * </pre>
     *
     * <code>string currency_code = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCurrencyCode() {
      currencyCode_ = getDefaultInstance().getCurrencyCode();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The 3-letter currency code defined in [ISO
     * 4217](https://www.iso.org/iso-4217-currency-codes.html).
     *
     * If this field is an unrecognizable currency code, an INVALID_ARGUMENT
     * error is returned.
     *
     * The
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s with the same
     * [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id]
     * must share the same
     * [currency_code][google.cloud.retail.v2alpha.PriceInfo.currency_code].
     * Otherwise, a FAILED_PRECONDITION error is returned.
     * </pre>
     *
     * <code>string currency_code = 1;</code>
     *
     * @param value The bytes for currencyCode to set.
     * @return This builder for chaining.
     */
    public Builder setCurrencyCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      currencyCode_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private float price_;
    /**
     *
     *
     * <pre>
     * Price of the product.
     *
     * Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371). Schema.org
     * property [Offer.price](https://schema.org/price).
     * </pre>
     *
     * <code>float price = 2;</code>
     *
     * @return The price.
     */
    @java.lang.Override
    public float getPrice() {
      return price_;
    }
    /**
     *
     *
     * <pre>
     * Price of the product.
     *
     * Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371). Schema.org
     * property [Offer.price](https://schema.org/price).
     * </pre>
     *
     * <code>float price = 2;</code>
     *
     * @param value The price to set.
     * @return This builder for chaining.
     */
    public Builder setPrice(float value) {

      price_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price of the product.
     *
     * Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371). Schema.org
     * property [Offer.price](https://schema.org/price).
     * </pre>
     *
     * <code>float price = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrice() {
      bitField0_ = (bitField0_ & ~0x00000002);
      price_ = 0F;
      onChanged();
      return this;
    }

    private float originalPrice_;
    /**
     *
     *
     * <pre>
     * Price of the product without any discount. If zero, by default set to be
     * the [price][google.cloud.retail.v2alpha.PriceInfo.price]. If set,
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price]
     * should be greater than or equal to
     * [price][google.cloud.retail.v2alpha.PriceInfo.price], otherwise an
     * INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>float original_price = 3;</code>
     *
     * @return The originalPrice.
     */
    @java.lang.Override
    public float getOriginalPrice() {
      return originalPrice_;
    }
    /**
     *
     *
     * <pre>
     * Price of the product without any discount. If zero, by default set to be
     * the [price][google.cloud.retail.v2alpha.PriceInfo.price]. If set,
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price]
     * should be greater than or equal to
     * [price][google.cloud.retail.v2alpha.PriceInfo.price], otherwise an
     * INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>float original_price = 3;</code>
     *
     * @param value The originalPrice to set.
     * @return This builder for chaining.
     */
    public Builder setOriginalPrice(float value) {

      originalPrice_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price of the product without any discount. If zero, by default set to be
     * the [price][google.cloud.retail.v2alpha.PriceInfo.price]. If set,
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price]
     * should be greater than or equal to
     * [price][google.cloud.retail.v2alpha.PriceInfo.price], otherwise an
     * INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>float original_price = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOriginalPrice() {
      bitField0_ = (bitField0_ & ~0x00000004);
      originalPrice_ = 0F;
      onChanged();
      return this;
    }

    private float cost_;
    /**
     *
     *
     * <pre>
     * The costs associated with the sale of a particular product. Used for gross
     * profit reporting.
     *
     * * Profit = [price][google.cloud.retail.v2alpha.PriceInfo.price] -
     * [cost][google.cloud.retail.v2alpha.PriceInfo.cost]
     *
     * Google Merchant Center property
     * [cost_of_goods_sold](https://support.google.com/merchants/answer/9017895).
     * </pre>
     *
     * <code>float cost = 4;</code>
     *
     * @return The cost.
     */
    @java.lang.Override
    public float getCost() {
      return cost_;
    }
    /**
     *
     *
     * <pre>
     * The costs associated with the sale of a particular product. Used for gross
     * profit reporting.
     *
     * * Profit = [price][google.cloud.retail.v2alpha.PriceInfo.price] -
     * [cost][google.cloud.retail.v2alpha.PriceInfo.cost]
     *
     * Google Merchant Center property
     * [cost_of_goods_sold](https://support.google.com/merchants/answer/9017895).
     * </pre>
     *
     * <code>float cost = 4;</code>
     *
     * @param value The cost to set.
     * @return This builder for chaining.
     */
    public Builder setCost(float value) {

      cost_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The costs associated with the sale of a particular product. Used for gross
     * profit reporting.
     *
     * * Profit = [price][google.cloud.retail.v2alpha.PriceInfo.price] -
     * [cost][google.cloud.retail.v2alpha.PriceInfo.cost]
     *
     * Google Merchant Center property
     * [cost_of_goods_sold](https://support.google.com/merchants/answer/9017895).
     * </pre>
     *
     * <code>float cost = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCost() {
      bitField0_ = (bitField0_ & ~0x00000008);
      cost_ = 0F;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp priceEffectiveTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        priceEffectiveTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The timestamp when the [price][google.cloud.retail.v2alpha.PriceInfo.price]
     * starts to be effective. This can be set as a future timestamp, and the
     * [price][google.cloud.retail.v2alpha.PriceInfo.price] is only used for
     * search after
     * [price_effective_time][google.cloud.retail.v2alpha.PriceInfo.price_effective_time].
     * If so, the
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] must
     * be set and
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] is
     * used before
     * [price_effective_time][google.cloud.retail.v2alpha.PriceInfo.price_effective_time].
     *
     * Do not set if [price][google.cloud.retail.v2alpha.PriceInfo.price] is
     * always effective because it will cause additional latency during search.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp price_effective_time = 5;</code>
     *
     * @return Whether the priceEffectiveTime field is set.
     */
    public boolean hasPriceEffectiveTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the [price][google.cloud.retail.v2alpha.PriceInfo.price]
     * starts to be effective. This can be set as a future timestamp, and the
     * [price][google.cloud.retail.v2alpha.PriceInfo.price] is only used for
     * search after
     * [price_effective_time][google.cloud.retail.v2alpha.PriceInfo.price_effective_time].
     * If so, the
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] must
     * be set and
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] is
     * used before
     * [price_effective_time][google.cloud.retail.v2alpha.PriceInfo.price_effective_time].
     *
     * Do not set if [price][google.cloud.retail.v2alpha.PriceInfo.price] is
     * always effective because it will cause additional latency during search.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp price_effective_time = 5;</code>
     *
     * @return The priceEffectiveTime.
     */
    public com.google.protobuf.Timestamp getPriceEffectiveTime() {
      if (priceEffectiveTimeBuilder_ == null) {
        return priceEffectiveTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : priceEffectiveTime_;
      } else {
        return priceEffectiveTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the [price][google.cloud.retail.v2alpha.PriceInfo.price]
     * starts to be effective. This can be set as a future timestamp, and the
     * [price][google.cloud.retail.v2alpha.PriceInfo.price] is only used for
     * search after
     * [price_effective_time][google.cloud.retail.v2alpha.PriceInfo.price_effective_time].
     * If so, the
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] must
     * be set and
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] is
     * used before
     * [price_effective_time][google.cloud.retail.v2alpha.PriceInfo.price_effective_time].
     *
     * Do not set if [price][google.cloud.retail.v2alpha.PriceInfo.price] is
     * always effective because it will cause additional latency during search.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp price_effective_time = 5;</code>
     */
    public Builder setPriceEffectiveTime(com.google.protobuf.Timestamp value) {
      if (priceEffectiveTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        priceEffectiveTime_ = value;
      } else {
        priceEffectiveTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the [price][google.cloud.retail.v2alpha.PriceInfo.price]
     * starts to be effective. This can be set as a future timestamp, and the
     * [price][google.cloud.retail.v2alpha.PriceInfo.price] is only used for
     * search after
     * [price_effective_time][google.cloud.retail.v2alpha.PriceInfo.price_effective_time].
     * If so, the
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] must
     * be set and
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] is
     * used before
     * [price_effective_time][google.cloud.retail.v2alpha.PriceInfo.price_effective_time].
     *
     * Do not set if [price][google.cloud.retail.v2alpha.PriceInfo.price] is
     * always effective because it will cause additional latency during search.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp price_effective_time = 5;</code>
     */
    public Builder setPriceEffectiveTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (priceEffectiveTimeBuilder_ == null) {
        priceEffectiveTime_ = builderForValue.build();
      } else {
        priceEffectiveTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the [price][google.cloud.retail.v2alpha.PriceInfo.price]
     * starts to be effective. This can be set as a future timestamp, and the
     * [price][google.cloud.retail.v2alpha.PriceInfo.price] is only used for
     * search after
     * [price_effective_time][google.cloud.retail.v2alpha.PriceInfo.price_effective_time].
     * If so, the
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] must
     * be set and
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] is
     * used before
     * [price_effective_time][google.cloud.retail.v2alpha.PriceInfo.price_effective_time].
     *
     * Do not set if [price][google.cloud.retail.v2alpha.PriceInfo.price] is
     * always effective because it will cause additional latency during search.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp price_effective_time = 5;</code>
     */
    public Builder mergePriceEffectiveTime(com.google.protobuf.Timestamp value) {
      if (priceEffectiveTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && priceEffectiveTime_ != null
            && priceEffectiveTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getPriceEffectiveTimeBuilder().mergeFrom(value);
        } else {
          priceEffectiveTime_ = value;
        }
      } else {
        priceEffectiveTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the [price][google.cloud.retail.v2alpha.PriceInfo.price]
     * starts to be effective. This can be set as a future timestamp, and the
     * [price][google.cloud.retail.v2alpha.PriceInfo.price] is only used for
     * search after
     * [price_effective_time][google.cloud.retail.v2alpha.PriceInfo.price_effective_time].
     * If so, the
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] must
     * be set and
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] is
     * used before
     * [price_effective_time][google.cloud.retail.v2alpha.PriceInfo.price_effective_time].
     *
     * Do not set if [price][google.cloud.retail.v2alpha.PriceInfo.price] is
     * always effective because it will cause additional latency during search.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp price_effective_time = 5;</code>
     */
    public Builder clearPriceEffectiveTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      priceEffectiveTime_ = null;
      if (priceEffectiveTimeBuilder_ != null) {
        priceEffectiveTimeBuilder_.dispose();
        priceEffectiveTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the [price][google.cloud.retail.v2alpha.PriceInfo.price]
     * starts to be effective. This can be set as a future timestamp, and the
     * [price][google.cloud.retail.v2alpha.PriceInfo.price] is only used for
     * search after
     * [price_effective_time][google.cloud.retail.v2alpha.PriceInfo.price_effective_time].
     * If so, the
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] must
     * be set and
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] is
     * used before
     * [price_effective_time][google.cloud.retail.v2alpha.PriceInfo.price_effective_time].
     *
     * Do not set if [price][google.cloud.retail.v2alpha.PriceInfo.price] is
     * always effective because it will cause additional latency during search.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp price_effective_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getPriceEffectiveTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getPriceEffectiveTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the [price][google.cloud.retail.v2alpha.PriceInfo.price]
     * starts to be effective. This can be set as a future timestamp, and the
     * [price][google.cloud.retail.v2alpha.PriceInfo.price] is only used for
     * search after
     * [price_effective_time][google.cloud.retail.v2alpha.PriceInfo.price_effective_time].
     * If so, the
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] must
     * be set and
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] is
     * used before
     * [price_effective_time][google.cloud.retail.v2alpha.PriceInfo.price_effective_time].
     *
     * Do not set if [price][google.cloud.retail.v2alpha.PriceInfo.price] is
     * always effective because it will cause additional latency during search.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp price_effective_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getPriceEffectiveTimeOrBuilder() {
      if (priceEffectiveTimeBuilder_ != null) {
        return priceEffectiveTimeBuilder_.getMessageOrBuilder();
      } else {
        return priceEffectiveTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : priceEffectiveTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the [price][google.cloud.retail.v2alpha.PriceInfo.price]
     * starts to be effective. This can be set as a future timestamp, and the
     * [price][google.cloud.retail.v2alpha.PriceInfo.price] is only used for
     * search after
     * [price_effective_time][google.cloud.retail.v2alpha.PriceInfo.price_effective_time].
     * If so, the
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] must
     * be set and
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] is
     * used before
     * [price_effective_time][google.cloud.retail.v2alpha.PriceInfo.price_effective_time].
     *
     * Do not set if [price][google.cloud.retail.v2alpha.PriceInfo.price] is
     * always effective because it will cause additional latency during search.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp price_effective_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getPriceEffectiveTimeFieldBuilder() {
      if (priceEffectiveTimeBuilder_ == null) {
        priceEffectiveTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getPriceEffectiveTime(), getParentForChildren(), isClean());
        priceEffectiveTime_ = null;
      }
      return priceEffectiveTimeBuilder_;
    }

    private com.google.protobuf.Timestamp priceExpireTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        priceExpireTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The timestamp when the [price][google.cloud.retail.v2alpha.PriceInfo.price]
     * stops to be effective. The
     * [price][google.cloud.retail.v2alpha.PriceInfo.price] is used for search
     * before
     * [price_expire_time][google.cloud.retail.v2alpha.PriceInfo.price_expire_time].
     * If this field is set, the
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] must
     * be set and
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] is
     * used after
     * [price_expire_time][google.cloud.retail.v2alpha.PriceInfo.price_expire_time].
     *
     * Do not set if [price][google.cloud.retail.v2alpha.PriceInfo.price] is
     * always effective because it will cause additional latency during search.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp price_expire_time = 6;</code>
     *
     * @return Whether the priceExpireTime field is set.
     */
    public boolean hasPriceExpireTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the [price][google.cloud.retail.v2alpha.PriceInfo.price]
     * stops to be effective. The
     * [price][google.cloud.retail.v2alpha.PriceInfo.price] is used for search
     * before
     * [price_expire_time][google.cloud.retail.v2alpha.PriceInfo.price_expire_time].
     * If this field is set, the
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] must
     * be set and
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] is
     * used after
     * [price_expire_time][google.cloud.retail.v2alpha.PriceInfo.price_expire_time].
     *
     * Do not set if [price][google.cloud.retail.v2alpha.PriceInfo.price] is
     * always effective because it will cause additional latency during search.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp price_expire_time = 6;</code>
     *
     * @return The priceExpireTime.
     */
    public com.google.protobuf.Timestamp getPriceExpireTime() {
      if (priceExpireTimeBuilder_ == null) {
        return priceExpireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : priceExpireTime_;
      } else {
        return priceExpireTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the [price][google.cloud.retail.v2alpha.PriceInfo.price]
     * stops to be effective. The
     * [price][google.cloud.retail.v2alpha.PriceInfo.price] is used for search
     * before
     * [price_expire_time][google.cloud.retail.v2alpha.PriceInfo.price_expire_time].
     * If this field is set, the
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] must
     * be set and
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] is
     * used after
     * [price_expire_time][google.cloud.retail.v2alpha.PriceInfo.price_expire_time].
     *
     * Do not set if [price][google.cloud.retail.v2alpha.PriceInfo.price] is
     * always effective because it will cause additional latency during search.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp price_expire_time = 6;</code>
     */
    public Builder setPriceExpireTime(com.google.protobuf.Timestamp value) {
      if (priceExpireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        priceExpireTime_ = value;
      } else {
        priceExpireTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the [price][google.cloud.retail.v2alpha.PriceInfo.price]
     * stops to be effective. The
     * [price][google.cloud.retail.v2alpha.PriceInfo.price] is used for search
     * before
     * [price_expire_time][google.cloud.retail.v2alpha.PriceInfo.price_expire_time].
     * If this field is set, the
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] must
     * be set and
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] is
     * used after
     * [price_expire_time][google.cloud.retail.v2alpha.PriceInfo.price_expire_time].
     *
     * Do not set if [price][google.cloud.retail.v2alpha.PriceInfo.price] is
     * always effective because it will cause additional latency during search.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp price_expire_time = 6;</code>
     */
    public Builder setPriceExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (priceExpireTimeBuilder_ == null) {
        priceExpireTime_ = builderForValue.build();
      } else {
        priceExpireTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the [price][google.cloud.retail.v2alpha.PriceInfo.price]
     * stops to be effective. The
     * [price][google.cloud.retail.v2alpha.PriceInfo.price] is used for search
     * before
     * [price_expire_time][google.cloud.retail.v2alpha.PriceInfo.price_expire_time].
     * If this field is set, the
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] must
     * be set and
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] is
     * used after
     * [price_expire_time][google.cloud.retail.v2alpha.PriceInfo.price_expire_time].
     *
     * Do not set if [price][google.cloud.retail.v2alpha.PriceInfo.price] is
     * always effective because it will cause additional latency during search.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp price_expire_time = 6;</code>
     */
    public Builder mergePriceExpireTime(com.google.protobuf.Timestamp value) {
      if (priceExpireTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && priceExpireTime_ != null
            && priceExpireTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getPriceExpireTimeBuilder().mergeFrom(value);
        } else {
          priceExpireTime_ = value;
        }
      } else {
        priceExpireTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the [price][google.cloud.retail.v2alpha.PriceInfo.price]
     * stops to be effective. The
     * [price][google.cloud.retail.v2alpha.PriceInfo.price] is used for search
     * before
     * [price_expire_time][google.cloud.retail.v2alpha.PriceInfo.price_expire_time].
     * If this field is set, the
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] must
     * be set and
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] is
     * used after
     * [price_expire_time][google.cloud.retail.v2alpha.PriceInfo.price_expire_time].
     *
     * Do not set if [price][google.cloud.retail.v2alpha.PriceInfo.price] is
     * always effective because it will cause additional latency during search.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp price_expire_time = 6;</code>
     */
    public Builder clearPriceExpireTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      priceExpireTime_ = null;
      if (priceExpireTimeBuilder_ != null) {
        priceExpireTimeBuilder_.dispose();
        priceExpireTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the [price][google.cloud.retail.v2alpha.PriceInfo.price]
     * stops to be effective. The
     * [price][google.cloud.retail.v2alpha.PriceInfo.price] is used for search
     * before
     * [price_expire_time][google.cloud.retail.v2alpha.PriceInfo.price_expire_time].
     * If this field is set, the
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] must
     * be set and
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] is
     * used after
     * [price_expire_time][google.cloud.retail.v2alpha.PriceInfo.price_expire_time].
     *
     * Do not set if [price][google.cloud.retail.v2alpha.PriceInfo.price] is
     * always effective because it will cause additional latency during search.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp price_expire_time = 6;</code>
     */
    public com.google.protobuf.Timestamp.Builder getPriceExpireTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getPriceExpireTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the [price][google.cloud.retail.v2alpha.PriceInfo.price]
     * stops to be effective. The
     * [price][google.cloud.retail.v2alpha.PriceInfo.price] is used for search
     * before
     * [price_expire_time][google.cloud.retail.v2alpha.PriceInfo.price_expire_time].
     * If this field is set, the
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] must
     * be set and
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] is
     * used after
     * [price_expire_time][google.cloud.retail.v2alpha.PriceInfo.price_expire_time].
     *
     * Do not set if [price][google.cloud.retail.v2alpha.PriceInfo.price] is
     * always effective because it will cause additional latency during search.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp price_expire_time = 6;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getPriceExpireTimeOrBuilder() {
      if (priceExpireTimeBuilder_ != null) {
        return priceExpireTimeBuilder_.getMessageOrBuilder();
      } else {
        return priceExpireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : priceExpireTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp when the [price][google.cloud.retail.v2alpha.PriceInfo.price]
     * stops to be effective. The
     * [price][google.cloud.retail.v2alpha.PriceInfo.price] is used for search
     * before
     * [price_expire_time][google.cloud.retail.v2alpha.PriceInfo.price_expire_time].
     * If this field is set, the
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] must
     * be set and
     * [original_price][google.cloud.retail.v2alpha.PriceInfo.original_price] is
     * used after
     * [price_expire_time][google.cloud.retail.v2alpha.PriceInfo.price_expire_time].
     *
     * Do not set if [price][google.cloud.retail.v2alpha.PriceInfo.price] is
     * always effective because it will cause additional latency during search.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp price_expire_time = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getPriceExpireTimeFieldBuilder() {
      if (priceExpireTimeBuilder_ == null) {
        priceExpireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getPriceExpireTime(), getParentForChildren(), isClean());
        priceExpireTime_ = null;
      }
      return priceExpireTimeBuilder_;
    }

    private com.google.cloud.retail.v2alpha.PriceInfo.PriceRange priceRange_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.PriceInfo.PriceRange,
            com.google.cloud.retail.v2alpha.PriceInfo.PriceRange.Builder,
            com.google.cloud.retail.v2alpha.PriceInfo.PriceRangeOrBuilder>
        priceRangeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The price range of all the child
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s grouped together on the
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2alpha.Product]. Only populated for
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2alpha.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2alpha.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.PriceInfo.PriceRange price_range = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the priceRange field is set.
     */
    public boolean hasPriceRange() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The price range of all the child
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s grouped together on the
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2alpha.Product]. Only populated for
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2alpha.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2alpha.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.PriceInfo.PriceRange price_range = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The priceRange.
     */
    public com.google.cloud.retail.v2alpha.PriceInfo.PriceRange getPriceRange() {
      if (priceRangeBuilder_ == null) {
        return priceRange_ == null
            ? com.google.cloud.retail.v2alpha.PriceInfo.PriceRange.getDefaultInstance()
            : priceRange_;
      } else {
        return priceRangeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The price range of all the child
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s grouped together on the
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2alpha.Product]. Only populated for
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2alpha.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2alpha.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.PriceInfo.PriceRange price_range = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPriceRange(com.google.cloud.retail.v2alpha.PriceInfo.PriceRange value) {
      if (priceRangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        priceRange_ = value;
      } else {
        priceRangeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The price range of all the child
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s grouped together on the
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2alpha.Product]. Only populated for
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2alpha.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2alpha.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.PriceInfo.PriceRange price_range = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPriceRange(
        com.google.cloud.retail.v2alpha.PriceInfo.PriceRange.Builder builderForValue) {
      if (priceRangeBuilder_ == null) {
        priceRange_ = builderForValue.build();
      } else {
        priceRangeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The price range of all the child
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s grouped together on the
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2alpha.Product]. Only populated for
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2alpha.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2alpha.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.PriceInfo.PriceRange price_range = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergePriceRange(com.google.cloud.retail.v2alpha.PriceInfo.PriceRange value) {
      if (priceRangeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && priceRange_ != null
            && priceRange_
                != com.google.cloud.retail.v2alpha.PriceInfo.PriceRange.getDefaultInstance()) {
          getPriceRangeBuilder().mergeFrom(value);
        } else {
          priceRange_ = value;
        }
      } else {
        priceRangeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The price range of all the child
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s grouped together on the
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2alpha.Product]. Only populated for
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2alpha.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2alpha.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.PriceInfo.PriceRange price_range = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPriceRange() {
      bitField0_ = (bitField0_ & ~0x00000040);
      priceRange_ = null;
      if (priceRangeBuilder_ != null) {
        priceRangeBuilder_.dispose();
        priceRangeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The price range of all the child
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s grouped together on the
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2alpha.Product]. Only populated for
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2alpha.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2alpha.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.PriceInfo.PriceRange price_range = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.PriceInfo.PriceRange.Builder getPriceRangeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getPriceRangeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The price range of all the child
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s grouped together on the
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2alpha.Product]. Only populated for
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2alpha.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2alpha.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.PriceInfo.PriceRange price_range = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.PriceInfo.PriceRangeOrBuilder getPriceRangeOrBuilder() {
      if (priceRangeBuilder_ != null) {
        return priceRangeBuilder_.getMessageOrBuilder();
      } else {
        return priceRange_ == null
            ? com.google.cloud.retail.v2alpha.PriceInfo.PriceRange.getDefaultInstance()
            : priceRange_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The price range of all the child
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s grouped together on the
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2alpha.Product]. Only populated for
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2alpha.Product]s.
     *
     * Note: This field is OUTPUT_ONLY for
     * [ProductService.GetProduct][google.cloud.retail.v2alpha.ProductService.GetProduct].
     * Do not set this field in API requests.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.PriceInfo.PriceRange price_range = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.PriceInfo.PriceRange,
            com.google.cloud.retail.v2alpha.PriceInfo.PriceRange.Builder,
            com.google.cloud.retail.v2alpha.PriceInfo.PriceRangeOrBuilder>
        getPriceRangeFieldBuilder() {
      if (priceRangeBuilder_ == null) {
        priceRangeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2alpha.PriceInfo.PriceRange,
                com.google.cloud.retail.v2alpha.PriceInfo.PriceRange.Builder,
                com.google.cloud.retail.v2alpha.PriceInfo.PriceRangeOrBuilder>(
                getPriceRange(), getParentForChildren(), isClean());
        priceRange_ = null;
      }
      return priceRangeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.PriceInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.PriceInfo)
  private static final com.google.cloud.retail.v2alpha.PriceInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.PriceInfo();
  }

  public static com.google.cloud.retail.v2alpha.PriceInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PriceInfo> PARSER =
      new com.google.protobuf.AbstractParser<PriceInfo>() {
        @java.lang.Override
        public PriceInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PriceInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PriceInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2alpha.PriceInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
