/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2alpha/catalog.proto

package com.google.cloud.retail.v2alpha;

/**
 *
 *
 * <pre>
 * Configures what level the product should be uploaded with regards to
 * how users will be send events and how predictions will be made.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2alpha.ProductLevelConfig}
 */
public final class ProductLevelConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.ProductLevelConfig)
    ProductLevelConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ProductLevelConfig.newBuilder() to construct.
  private ProductLevelConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ProductLevelConfig() {
    ingestionProductType_ = "";
    merchantCenterProductIdField_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ProductLevelConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2alpha.CatalogProto
        .internal_static_google_cloud_retail_v2alpha_ProductLevelConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2alpha.CatalogProto
        .internal_static_google_cloud_retail_v2alpha_ProductLevelConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2alpha.ProductLevelConfig.class,
            com.google.cloud.retail.v2alpha.ProductLevelConfig.Builder.class);
  }

  public static final int INGESTION_PRODUCT_TYPE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ingestionProductType_ = "";
  /**
   *
   *
   * <pre>
   * The type of [Product][google.cloud.retail.v2alpha.Product]s allowed to be
   * ingested into the catalog. Acceptable values are:
   *
   * * `primary` (default): You can ingest
   * [Product][google.cloud.retail.v2alpha.Product]s of all types. When
   *   ingesting a [Product][google.cloud.retail.v2alpha.Product], its type will
   *   default to
   *   [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
   *   if unset.
   * * `variant` (incompatible with Retail Search): You can only
   *   ingest
   *   [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
   *   [Product][google.cloud.retail.v2alpha.Product]s. This means
   *   [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id]
   *   cannot be empty.
   *
   * If this field is set to an invalid value other than these, an
   * INVALID_ARGUMENT error is returned.
   *
   * If this field is `variant` and
   * [merchant_center_product_id_field][google.cloud.retail.v2alpha.ProductLevelConfig.merchant_center_product_id_field]
   * is `itemGroupId`, an INVALID_ARGUMENT error is returned.
   *
   * See [Product
   * levels](https://cloud.google.com/retail/docs/catalog#product-levels)
   * for more details.
   * </pre>
   *
   * <code>string ingestion_product_type = 1;</code>
   *
   * @return The ingestionProductType.
   */
  @java.lang.Override
  public java.lang.String getIngestionProductType() {
    java.lang.Object ref = ingestionProductType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ingestionProductType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The type of [Product][google.cloud.retail.v2alpha.Product]s allowed to be
   * ingested into the catalog. Acceptable values are:
   *
   * * `primary` (default): You can ingest
   * [Product][google.cloud.retail.v2alpha.Product]s of all types. When
   *   ingesting a [Product][google.cloud.retail.v2alpha.Product], its type will
   *   default to
   *   [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
   *   if unset.
   * * `variant` (incompatible with Retail Search): You can only
   *   ingest
   *   [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
   *   [Product][google.cloud.retail.v2alpha.Product]s. This means
   *   [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id]
   *   cannot be empty.
   *
   * If this field is set to an invalid value other than these, an
   * INVALID_ARGUMENT error is returned.
   *
   * If this field is `variant` and
   * [merchant_center_product_id_field][google.cloud.retail.v2alpha.ProductLevelConfig.merchant_center_product_id_field]
   * is `itemGroupId`, an INVALID_ARGUMENT error is returned.
   *
   * See [Product
   * levels](https://cloud.google.com/retail/docs/catalog#product-levels)
   * for more details.
   * </pre>
   *
   * <code>string ingestion_product_type = 1;</code>
   *
   * @return The bytes for ingestionProductType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIngestionProductTypeBytes() {
    java.lang.Object ref = ingestionProductType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ingestionProductType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MERCHANT_CENTER_PRODUCT_ID_FIELD_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object merchantCenterProductIdField_ = "";
  /**
   *
   *
   * <pre>
   * Which field of [Merchant Center
   * Product](/bigquery-transfer/docs/merchant-center-products-schema) should be
   * imported as [Product.id][google.cloud.retail.v2alpha.Product.id].
   * Acceptable values are:
   *
   * * `offerId` (default): Import `offerId` as the product ID.
   * * `itemGroupId`: Import `itemGroupId` as the product ID. Notice that Retail
   *   API will choose one item from the ones with the same `itemGroupId`, and
   *   use it to represent the item group.
   *
   * If this field is set to an invalid value other than these, an
   * INVALID_ARGUMENT error is returned.
   *
   * If this field is `itemGroupId` and
   * [ingestion_product_type][google.cloud.retail.v2alpha.ProductLevelConfig.ingestion_product_type]
   * is `variant`, an INVALID_ARGUMENT error is returned.
   *
   * See [Product
   * levels](https://cloud.google.com/retail/docs/catalog#product-levels)
   * for more details.
   * </pre>
   *
   * <code>string merchant_center_product_id_field = 2;</code>
   *
   * @return The merchantCenterProductIdField.
   */
  @java.lang.Override
  public java.lang.String getMerchantCenterProductIdField() {
    java.lang.Object ref = merchantCenterProductIdField_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      merchantCenterProductIdField_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Which field of [Merchant Center
   * Product](/bigquery-transfer/docs/merchant-center-products-schema) should be
   * imported as [Product.id][google.cloud.retail.v2alpha.Product.id].
   * Acceptable values are:
   *
   * * `offerId` (default): Import `offerId` as the product ID.
   * * `itemGroupId`: Import `itemGroupId` as the product ID. Notice that Retail
   *   API will choose one item from the ones with the same `itemGroupId`, and
   *   use it to represent the item group.
   *
   * If this field is set to an invalid value other than these, an
   * INVALID_ARGUMENT error is returned.
   *
   * If this field is `itemGroupId` and
   * [ingestion_product_type][google.cloud.retail.v2alpha.ProductLevelConfig.ingestion_product_type]
   * is `variant`, an INVALID_ARGUMENT error is returned.
   *
   * See [Product
   * levels](https://cloud.google.com/retail/docs/catalog#product-levels)
   * for more details.
   * </pre>
   *
   * <code>string merchant_center_product_id_field = 2;</code>
   *
   * @return The bytes for merchantCenterProductIdField.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMerchantCenterProductIdFieldBytes() {
    java.lang.Object ref = merchantCenterProductIdField_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      merchantCenterProductIdField_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ingestionProductType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, ingestionProductType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(merchantCenterProductIdField_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, merchantCenterProductIdField_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ingestionProductType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, ingestionProductType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(merchantCenterProductIdField_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              2, merchantCenterProductIdField_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2alpha.ProductLevelConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2alpha.ProductLevelConfig other =
        (com.google.cloud.retail.v2alpha.ProductLevelConfig) obj;

    if (!getIngestionProductType().equals(other.getIngestionProductType())) return false;
    if (!getMerchantCenterProductIdField().equals(other.getMerchantCenterProductIdField()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + INGESTION_PRODUCT_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getIngestionProductType().hashCode();
    hash = (37 * hash) + MERCHANT_CENTER_PRODUCT_ID_FIELD_FIELD_NUMBER;
    hash = (53 * hash) + getMerchantCenterProductIdField().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2alpha.ProductLevelConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.ProductLevelConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.ProductLevelConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.ProductLevelConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.ProductLevelConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.ProductLevelConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.ProductLevelConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.ProductLevelConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.ProductLevelConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.ProductLevelConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.ProductLevelConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.ProductLevelConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2alpha.ProductLevelConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configures what level the product should be uploaded with regards to
   * how users will be send events and how predictions will be made.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.ProductLevelConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.ProductLevelConfig)
      com.google.cloud.retail.v2alpha.ProductLevelConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.CatalogProto
          .internal_static_google_cloud_retail_v2alpha_ProductLevelConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.CatalogProto
          .internal_static_google_cloud_retail_v2alpha_ProductLevelConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.ProductLevelConfig.class,
              com.google.cloud.retail.v2alpha.ProductLevelConfig.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2alpha.ProductLevelConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      ingestionProductType_ = "";
      merchantCenterProductIdField_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2alpha.CatalogProto
          .internal_static_google_cloud_retail_v2alpha_ProductLevelConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.ProductLevelConfig getDefaultInstanceForType() {
      return com.google.cloud.retail.v2alpha.ProductLevelConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.ProductLevelConfig build() {
      com.google.cloud.retail.v2alpha.ProductLevelConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.ProductLevelConfig buildPartial() {
      com.google.cloud.retail.v2alpha.ProductLevelConfig result =
          new com.google.cloud.retail.v2alpha.ProductLevelConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.retail.v2alpha.ProductLevelConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.ingestionProductType_ = ingestionProductType_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.merchantCenterProductIdField_ = merchantCenterProductIdField_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2alpha.ProductLevelConfig) {
        return mergeFrom((com.google.cloud.retail.v2alpha.ProductLevelConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2alpha.ProductLevelConfig other) {
      if (other == com.google.cloud.retail.v2alpha.ProductLevelConfig.getDefaultInstance())
        return this;
      if (!other.getIngestionProductType().isEmpty()) {
        ingestionProductType_ = other.ingestionProductType_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getMerchantCenterProductIdField().isEmpty()) {
        merchantCenterProductIdField_ = other.merchantCenterProductIdField_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                ingestionProductType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                merchantCenterProductIdField_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object ingestionProductType_ = "";
    /**
     *
     *
     * <pre>
     * The type of [Product][google.cloud.retail.v2alpha.Product]s allowed to be
     * ingested into the catalog. Acceptable values are:
     *
     * * `primary` (default): You can ingest
     * [Product][google.cloud.retail.v2alpha.Product]s of all types. When
     *   ingesting a [Product][google.cloud.retail.v2alpha.Product], its type will
     *   default to
     *   [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     *   if unset.
     * * `variant` (incompatible with Retail Search): You can only
     *   ingest
     *   [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     *   [Product][google.cloud.retail.v2alpha.Product]s. This means
     *   [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id]
     *   cannot be empty.
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * If this field is `variant` and
     * [merchant_center_product_id_field][google.cloud.retail.v2alpha.ProductLevelConfig.merchant_center_product_id_field]
     * is `itemGroupId`, an INVALID_ARGUMENT error is returned.
     *
     * See [Product
     * levels](https://cloud.google.com/retail/docs/catalog#product-levels)
     * for more details.
     * </pre>
     *
     * <code>string ingestion_product_type = 1;</code>
     *
     * @return The ingestionProductType.
     */
    public java.lang.String getIngestionProductType() {
      java.lang.Object ref = ingestionProductType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ingestionProductType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of [Product][google.cloud.retail.v2alpha.Product]s allowed to be
     * ingested into the catalog. Acceptable values are:
     *
     * * `primary` (default): You can ingest
     * [Product][google.cloud.retail.v2alpha.Product]s of all types. When
     *   ingesting a [Product][google.cloud.retail.v2alpha.Product], its type will
     *   default to
     *   [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     *   if unset.
     * * `variant` (incompatible with Retail Search): You can only
     *   ingest
     *   [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     *   [Product][google.cloud.retail.v2alpha.Product]s. This means
     *   [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id]
     *   cannot be empty.
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * If this field is `variant` and
     * [merchant_center_product_id_field][google.cloud.retail.v2alpha.ProductLevelConfig.merchant_center_product_id_field]
     * is `itemGroupId`, an INVALID_ARGUMENT error is returned.
     *
     * See [Product
     * levels](https://cloud.google.com/retail/docs/catalog#product-levels)
     * for more details.
     * </pre>
     *
     * <code>string ingestion_product_type = 1;</code>
     *
     * @return The bytes for ingestionProductType.
     */
    public com.google.protobuf.ByteString getIngestionProductTypeBytes() {
      java.lang.Object ref = ingestionProductType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ingestionProductType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of [Product][google.cloud.retail.v2alpha.Product]s allowed to be
     * ingested into the catalog. Acceptable values are:
     *
     * * `primary` (default): You can ingest
     * [Product][google.cloud.retail.v2alpha.Product]s of all types. When
     *   ingesting a [Product][google.cloud.retail.v2alpha.Product], its type will
     *   default to
     *   [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     *   if unset.
     * * `variant` (incompatible with Retail Search): You can only
     *   ingest
     *   [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     *   [Product][google.cloud.retail.v2alpha.Product]s. This means
     *   [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id]
     *   cannot be empty.
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * If this field is `variant` and
     * [merchant_center_product_id_field][google.cloud.retail.v2alpha.ProductLevelConfig.merchant_center_product_id_field]
     * is `itemGroupId`, an INVALID_ARGUMENT error is returned.
     *
     * See [Product
     * levels](https://cloud.google.com/retail/docs/catalog#product-levels)
     * for more details.
     * </pre>
     *
     * <code>string ingestion_product_type = 1;</code>
     *
     * @param value The ingestionProductType to set.
     * @return This builder for chaining.
     */
    public Builder setIngestionProductType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ingestionProductType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of [Product][google.cloud.retail.v2alpha.Product]s allowed to be
     * ingested into the catalog. Acceptable values are:
     *
     * * `primary` (default): You can ingest
     * [Product][google.cloud.retail.v2alpha.Product]s of all types. When
     *   ingesting a [Product][google.cloud.retail.v2alpha.Product], its type will
     *   default to
     *   [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     *   if unset.
     * * `variant` (incompatible with Retail Search): You can only
     *   ingest
     *   [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     *   [Product][google.cloud.retail.v2alpha.Product]s. This means
     *   [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id]
     *   cannot be empty.
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * If this field is `variant` and
     * [merchant_center_product_id_field][google.cloud.retail.v2alpha.ProductLevelConfig.merchant_center_product_id_field]
     * is `itemGroupId`, an INVALID_ARGUMENT error is returned.
     *
     * See [Product
     * levels](https://cloud.google.com/retail/docs/catalog#product-levels)
     * for more details.
     * </pre>
     *
     * <code>string ingestion_product_type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIngestionProductType() {
      ingestionProductType_ = getDefaultInstance().getIngestionProductType();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of [Product][google.cloud.retail.v2alpha.Product]s allowed to be
     * ingested into the catalog. Acceptable values are:
     *
     * * `primary` (default): You can ingest
     * [Product][google.cloud.retail.v2alpha.Product]s of all types. When
     *   ingesting a [Product][google.cloud.retail.v2alpha.Product], its type will
     *   default to
     *   [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     *   if unset.
     * * `variant` (incompatible with Retail Search): You can only
     *   ingest
     *   [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     *   [Product][google.cloud.retail.v2alpha.Product]s. This means
     *   [Product.primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id]
     *   cannot be empty.
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * If this field is `variant` and
     * [merchant_center_product_id_field][google.cloud.retail.v2alpha.ProductLevelConfig.merchant_center_product_id_field]
     * is `itemGroupId`, an INVALID_ARGUMENT error is returned.
     *
     * See [Product
     * levels](https://cloud.google.com/retail/docs/catalog#product-levels)
     * for more details.
     * </pre>
     *
     * <code>string ingestion_product_type = 1;</code>
     *
     * @param value The bytes for ingestionProductType to set.
     * @return This builder for chaining.
     */
    public Builder setIngestionProductTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ingestionProductType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object merchantCenterProductIdField_ = "";
    /**
     *
     *
     * <pre>
     * Which field of [Merchant Center
     * Product](/bigquery-transfer/docs/merchant-center-products-schema) should be
     * imported as [Product.id][google.cloud.retail.v2alpha.Product.id].
     * Acceptable values are:
     *
     * * `offerId` (default): Import `offerId` as the product ID.
     * * `itemGroupId`: Import `itemGroupId` as the product ID. Notice that Retail
     *   API will choose one item from the ones with the same `itemGroupId`, and
     *   use it to represent the item group.
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * If this field is `itemGroupId` and
     * [ingestion_product_type][google.cloud.retail.v2alpha.ProductLevelConfig.ingestion_product_type]
     * is `variant`, an INVALID_ARGUMENT error is returned.
     *
     * See [Product
     * levels](https://cloud.google.com/retail/docs/catalog#product-levels)
     * for more details.
     * </pre>
     *
     * <code>string merchant_center_product_id_field = 2;</code>
     *
     * @return The merchantCenterProductIdField.
     */
    public java.lang.String getMerchantCenterProductIdField() {
      java.lang.Object ref = merchantCenterProductIdField_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        merchantCenterProductIdField_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Which field of [Merchant Center
     * Product](/bigquery-transfer/docs/merchant-center-products-schema) should be
     * imported as [Product.id][google.cloud.retail.v2alpha.Product.id].
     * Acceptable values are:
     *
     * * `offerId` (default): Import `offerId` as the product ID.
     * * `itemGroupId`: Import `itemGroupId` as the product ID. Notice that Retail
     *   API will choose one item from the ones with the same `itemGroupId`, and
     *   use it to represent the item group.
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * If this field is `itemGroupId` and
     * [ingestion_product_type][google.cloud.retail.v2alpha.ProductLevelConfig.ingestion_product_type]
     * is `variant`, an INVALID_ARGUMENT error is returned.
     *
     * See [Product
     * levels](https://cloud.google.com/retail/docs/catalog#product-levels)
     * for more details.
     * </pre>
     *
     * <code>string merchant_center_product_id_field = 2;</code>
     *
     * @return The bytes for merchantCenterProductIdField.
     */
    public com.google.protobuf.ByteString getMerchantCenterProductIdFieldBytes() {
      java.lang.Object ref = merchantCenterProductIdField_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        merchantCenterProductIdField_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Which field of [Merchant Center
     * Product](/bigquery-transfer/docs/merchant-center-products-schema) should be
     * imported as [Product.id][google.cloud.retail.v2alpha.Product.id].
     * Acceptable values are:
     *
     * * `offerId` (default): Import `offerId` as the product ID.
     * * `itemGroupId`: Import `itemGroupId` as the product ID. Notice that Retail
     *   API will choose one item from the ones with the same `itemGroupId`, and
     *   use it to represent the item group.
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * If this field is `itemGroupId` and
     * [ingestion_product_type][google.cloud.retail.v2alpha.ProductLevelConfig.ingestion_product_type]
     * is `variant`, an INVALID_ARGUMENT error is returned.
     *
     * See [Product
     * levels](https://cloud.google.com/retail/docs/catalog#product-levels)
     * for more details.
     * </pre>
     *
     * <code>string merchant_center_product_id_field = 2;</code>
     *
     * @param value The merchantCenterProductIdField to set.
     * @return This builder for chaining.
     */
    public Builder setMerchantCenterProductIdField(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      merchantCenterProductIdField_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which field of [Merchant Center
     * Product](/bigquery-transfer/docs/merchant-center-products-schema) should be
     * imported as [Product.id][google.cloud.retail.v2alpha.Product.id].
     * Acceptable values are:
     *
     * * `offerId` (default): Import `offerId` as the product ID.
     * * `itemGroupId`: Import `itemGroupId` as the product ID. Notice that Retail
     *   API will choose one item from the ones with the same `itemGroupId`, and
     *   use it to represent the item group.
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * If this field is `itemGroupId` and
     * [ingestion_product_type][google.cloud.retail.v2alpha.ProductLevelConfig.ingestion_product_type]
     * is `variant`, an INVALID_ARGUMENT error is returned.
     *
     * See [Product
     * levels](https://cloud.google.com/retail/docs/catalog#product-levels)
     * for more details.
     * </pre>
     *
     * <code>string merchant_center_product_id_field = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMerchantCenterProductIdField() {
      merchantCenterProductIdField_ = getDefaultInstance().getMerchantCenterProductIdField();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which field of [Merchant Center
     * Product](/bigquery-transfer/docs/merchant-center-products-schema) should be
     * imported as [Product.id][google.cloud.retail.v2alpha.Product.id].
     * Acceptable values are:
     *
     * * `offerId` (default): Import `offerId` as the product ID.
     * * `itemGroupId`: Import `itemGroupId` as the product ID. Notice that Retail
     *   API will choose one item from the ones with the same `itemGroupId`, and
     *   use it to represent the item group.
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * If this field is `itemGroupId` and
     * [ingestion_product_type][google.cloud.retail.v2alpha.ProductLevelConfig.ingestion_product_type]
     * is `variant`, an INVALID_ARGUMENT error is returned.
     *
     * See [Product
     * levels](https://cloud.google.com/retail/docs/catalog#product-levels)
     * for more details.
     * </pre>
     *
     * <code>string merchant_center_product_id_field = 2;</code>
     *
     * @param value The bytes for merchantCenterProductIdField to set.
     * @return This builder for chaining.
     */
    public Builder setMerchantCenterProductIdFieldBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      merchantCenterProductIdField_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.ProductLevelConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.ProductLevelConfig)
  private static final com.google.cloud.retail.v2alpha.ProductLevelConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.ProductLevelConfig();
  }

  public static com.google.cloud.retail.v2alpha.ProductLevelConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ProductLevelConfig> PARSER =
      new com.google.protobuf.AbstractParser<ProductLevelConfig>() {
        @java.lang.Override
        public ProductLevelConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ProductLevelConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ProductLevelConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2alpha.ProductLevelConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
