/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2alpha/serving_config.proto

package com.google.cloud.retail.v2alpha;

public interface ServingConfigOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.ServingConfig)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Immutable. Fully qualified name
   * `projects/&#42;&#47;locations/global/catalogs/&#42;&#47;servingConfig/&#42;`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Immutable. Fully qualified name
   * `projects/&#42;&#47;locations/global/catalogs/&#42;&#47;servingConfig/&#42;`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Required. The human readable serving config display name. Used in Retail
   * UI.
   *
   * This field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  java.lang.String getDisplayName();
  /**
   *
   *
   * <pre>
   * Required. The human readable serving config display name. Used in Retail
   * UI.
   *
   * This field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  com.google.protobuf.ByteString getDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * The id of the model in the same
   * [Catalog][google.cloud.retail.v2alpha.Catalog] to use at serving time.
   * Currently only RecommendationModels are supported:
   * https://cloud.google.com/retail/recommendations-ai/docs/create-models
   * Can be changed but only to a compatible model (e.g.
   * others-you-may-like CTR to others-you-may-like CVR).
   *
   * Required when
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
   * </pre>
   *
   * <code>string model_id = 3;</code>
   *
   * @return The modelId.
   */
  java.lang.String getModelId();
  /**
   *
   *
   * <pre>
   * The id of the model in the same
   * [Catalog][google.cloud.retail.v2alpha.Catalog] to use at serving time.
   * Currently only RecommendationModels are supported:
   * https://cloud.google.com/retail/recommendations-ai/docs/create-models
   * Can be changed but only to a compatible model (e.g.
   * others-you-may-like CTR to others-you-may-like CVR).
   *
   * Required when
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
   * </pre>
   *
   * <code>string model_id = 3;</code>
   *
   * @return The bytes for modelId.
   */
  com.google.protobuf.ByteString getModelIdBytes();

  /**
   *
   *
   * <pre>
   * How much price ranking we want in serving results.
   * Price reranking causes product items with a similar
   * recommendation probability to be ordered by price, with the
   * highest-priced items first. This setting could result in a decrease in
   * click-through and conversion rates.
   *  Allowed values are:
   *
   * * `no-price-reranking`
   * * `low-price-reranking`
   * * `medium-price-reranking`
   * * `high-price-reranking`
   *
   * If not specified, we choose default based on model type. Default value:
   * `no-price-reranking`.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
   * </pre>
   *
   * <code>string price_reranking_level = 4;</code>
   *
   * @return The priceRerankingLevel.
   */
  java.lang.String getPriceRerankingLevel();
  /**
   *
   *
   * <pre>
   * How much price ranking we want in serving results.
   * Price reranking causes product items with a similar
   * recommendation probability to be ordered by price, with the
   * highest-priced items first. This setting could result in a decrease in
   * click-through and conversion rates.
   *  Allowed values are:
   *
   * * `no-price-reranking`
   * * `low-price-reranking`
   * * `medium-price-reranking`
   * * `high-price-reranking`
   *
   * If not specified, we choose default based on model type. Default value:
   * `no-price-reranking`.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
   * </pre>
   *
   * <code>string price_reranking_level = 4;</code>
   *
   * @return The bytes for priceRerankingLevel.
   */
  com.google.protobuf.ByteString getPriceRerankingLevelBytes();

  /**
   *
   *
   * <pre>
   * Facet specifications for faceted search. If empty, no facets are returned.
   * The ids refer to the ids of [Control][google.cloud.retail.v2alpha.Control]
   * resources with only the Facet control set. These controls are assumed to be
   * in the same [Catalog][google.cloud.retail.v2alpha.Catalog] as the
   * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig].
   * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
   * is returned.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string facet_control_ids = 5;</code>
   *
   * @return A list containing the facetControlIds.
   */
  java.util.List<java.lang.String> getFacetControlIdsList();
  /**
   *
   *
   * <pre>
   * Facet specifications for faceted search. If empty, no facets are returned.
   * The ids refer to the ids of [Control][google.cloud.retail.v2alpha.Control]
   * resources with only the Facet control set. These controls are assumed to be
   * in the same [Catalog][google.cloud.retail.v2alpha.Catalog] as the
   * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig].
   * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
   * is returned.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string facet_control_ids = 5;</code>
   *
   * @return The count of facetControlIds.
   */
  int getFacetControlIdsCount();
  /**
   *
   *
   * <pre>
   * Facet specifications for faceted search. If empty, no facets are returned.
   * The ids refer to the ids of [Control][google.cloud.retail.v2alpha.Control]
   * resources with only the Facet control set. These controls are assumed to be
   * in the same [Catalog][google.cloud.retail.v2alpha.Catalog] as the
   * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig].
   * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
   * is returned.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string facet_control_ids = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The facetControlIds at the given index.
   */
  java.lang.String getFacetControlIds(int index);
  /**
   *
   *
   * <pre>
   * Facet specifications for faceted search. If empty, no facets are returned.
   * The ids refer to the ids of [Control][google.cloud.retail.v2alpha.Control]
   * resources with only the Facet control set. These controls are assumed to be
   * in the same [Catalog][google.cloud.retail.v2alpha.Catalog] as the
   * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig].
   * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
   * is returned.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string facet_control_ids = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the facetControlIds at the given index.
   */
  com.google.protobuf.ByteString getFacetControlIdsBytes(int index);

  /**
   *
   *
   * <pre>
   * The specification for dynamically generated facets. Notice that only
   * textual facets can be dynamically generated.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 6;
   * </code>
   *
   * @return Whether the dynamicFacetSpec field is set.
   */
  boolean hasDynamicFacetSpec();
  /**
   *
   *
   * <pre>
   * The specification for dynamically generated facets. Notice that only
   * textual facets can be dynamically generated.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 6;
   * </code>
   *
   * @return The dynamicFacetSpec.
   */
  com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec getDynamicFacetSpec();
  /**
   *
   *
   * <pre>
   * The specification for dynamically generated facets. Notice that only
   * textual facets can be dynamically generated.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 6;
   * </code>
   */
  com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpecOrBuilder
      getDynamicFacetSpecOrBuilder();

  /**
   *
   *
   * <pre>
   * Condition boost specifications. If a product matches multiple conditions
   * in the specifications, boost scores from these specifications are all
   * applied and combined in a non-linear way. Maximum number of
   * specifications is 100.
   *
   * Notice that if both
   * [ServingConfig.boost_control_ids][google.cloud.retail.v2alpha.ServingConfig.boost_control_ids]
   * and
   * [SearchRequest.boost_spec][google.cloud.retail.v2alpha.SearchRequest.boost_spec]
   * are set, the boost conditions from both places are evaluated. If a search
   * request matches multiple boost conditions, the final boost score is equal
   * to the sum of the boost scores from all matched boost conditions.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string boost_control_ids = 7;</code>
   *
   * @return A list containing the boostControlIds.
   */
  java.util.List<java.lang.String> getBoostControlIdsList();
  /**
   *
   *
   * <pre>
   * Condition boost specifications. If a product matches multiple conditions
   * in the specifications, boost scores from these specifications are all
   * applied and combined in a non-linear way. Maximum number of
   * specifications is 100.
   *
   * Notice that if both
   * [ServingConfig.boost_control_ids][google.cloud.retail.v2alpha.ServingConfig.boost_control_ids]
   * and
   * [SearchRequest.boost_spec][google.cloud.retail.v2alpha.SearchRequest.boost_spec]
   * are set, the boost conditions from both places are evaluated. If a search
   * request matches multiple boost conditions, the final boost score is equal
   * to the sum of the boost scores from all matched boost conditions.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string boost_control_ids = 7;</code>
   *
   * @return The count of boostControlIds.
   */
  int getBoostControlIdsCount();
  /**
   *
   *
   * <pre>
   * Condition boost specifications. If a product matches multiple conditions
   * in the specifications, boost scores from these specifications are all
   * applied and combined in a non-linear way. Maximum number of
   * specifications is 100.
   *
   * Notice that if both
   * [ServingConfig.boost_control_ids][google.cloud.retail.v2alpha.ServingConfig.boost_control_ids]
   * and
   * [SearchRequest.boost_spec][google.cloud.retail.v2alpha.SearchRequest.boost_spec]
   * are set, the boost conditions from both places are evaluated. If a search
   * request matches multiple boost conditions, the final boost score is equal
   * to the sum of the boost scores from all matched boost conditions.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string boost_control_ids = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The boostControlIds at the given index.
   */
  java.lang.String getBoostControlIds(int index);
  /**
   *
   *
   * <pre>
   * Condition boost specifications. If a product matches multiple conditions
   * in the specifications, boost scores from these specifications are all
   * applied and combined in a non-linear way. Maximum number of
   * specifications is 100.
   *
   * Notice that if both
   * [ServingConfig.boost_control_ids][google.cloud.retail.v2alpha.ServingConfig.boost_control_ids]
   * and
   * [SearchRequest.boost_spec][google.cloud.retail.v2alpha.SearchRequest.boost_spec]
   * are set, the boost conditions from both places are evaluated. If a search
   * request matches multiple boost conditions, the final boost score is equal
   * to the sum of the boost scores from all matched boost conditions.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string boost_control_ids = 7;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the boostControlIds at the given index.
   */
  com.google.protobuf.ByteString getBoostControlIdsBytes(int index);

  /**
   *
   *
   * <pre>
   * Condition filter specifications. If a product matches multiple conditions
   * in the specifications, filters from these specifications are all
   * applied and combined via the AND operator. Maximum number of
   * specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string filter_control_ids = 9;</code>
   *
   * @return A list containing the filterControlIds.
   */
  java.util.List<java.lang.String> getFilterControlIdsList();
  /**
   *
   *
   * <pre>
   * Condition filter specifications. If a product matches multiple conditions
   * in the specifications, filters from these specifications are all
   * applied and combined via the AND operator. Maximum number of
   * specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string filter_control_ids = 9;</code>
   *
   * @return The count of filterControlIds.
   */
  int getFilterControlIdsCount();
  /**
   *
   *
   * <pre>
   * Condition filter specifications. If a product matches multiple conditions
   * in the specifications, filters from these specifications are all
   * applied and combined via the AND operator. Maximum number of
   * specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string filter_control_ids = 9;</code>
   *
   * @param index The index of the element to return.
   * @return The filterControlIds at the given index.
   */
  java.lang.String getFilterControlIds(int index);
  /**
   *
   *
   * <pre>
   * Condition filter specifications. If a product matches multiple conditions
   * in the specifications, filters from these specifications are all
   * applied and combined via the AND operator. Maximum number of
   * specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string filter_control_ids = 9;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the filterControlIds at the given index.
   */
  com.google.protobuf.ByteString getFilterControlIdsBytes(int index);

  /**
   *
   *
   * <pre>
   * Condition redirect specifications. Only the first triggered redirect action
   * is applied, even if multiple apply. Maximum number of specifications is
   * 1000.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string redirect_control_ids = 10;</code>
   *
   * @return A list containing the redirectControlIds.
   */
  java.util.List<java.lang.String> getRedirectControlIdsList();
  /**
   *
   *
   * <pre>
   * Condition redirect specifications. Only the first triggered redirect action
   * is applied, even if multiple apply. Maximum number of specifications is
   * 1000.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string redirect_control_ids = 10;</code>
   *
   * @return The count of redirectControlIds.
   */
  int getRedirectControlIdsCount();
  /**
   *
   *
   * <pre>
   * Condition redirect specifications. Only the first triggered redirect action
   * is applied, even if multiple apply. Maximum number of specifications is
   * 1000.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string redirect_control_ids = 10;</code>
   *
   * @param index The index of the element to return.
   * @return The redirectControlIds at the given index.
   */
  java.lang.String getRedirectControlIds(int index);
  /**
   *
   *
   * <pre>
   * Condition redirect specifications. Only the first triggered redirect action
   * is applied, even if multiple apply. Maximum number of specifications is
   * 1000.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string redirect_control_ids = 10;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the redirectControlIds at the given index.
   */
  com.google.protobuf.ByteString getRedirectControlIdsBytes(int index);

  /**
   *
   *
   * <pre>
   * Condition synonyms specifications. If multiple syonyms conditions match,
   * all matching synonyms control in the list will execute. Order of controls
   * in the list will not matter. Maximum number of specifications is
   * 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string twoway_synonyms_control_ids = 18;</code>
   *
   * @return A list containing the twowaySynonymsControlIds.
   */
  java.util.List<java.lang.String> getTwowaySynonymsControlIdsList();
  /**
   *
   *
   * <pre>
   * Condition synonyms specifications. If multiple syonyms conditions match,
   * all matching synonyms control in the list will execute. Order of controls
   * in the list will not matter. Maximum number of specifications is
   * 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string twoway_synonyms_control_ids = 18;</code>
   *
   * @return The count of twowaySynonymsControlIds.
   */
  int getTwowaySynonymsControlIdsCount();
  /**
   *
   *
   * <pre>
   * Condition synonyms specifications. If multiple syonyms conditions match,
   * all matching synonyms control in the list will execute. Order of controls
   * in the list will not matter. Maximum number of specifications is
   * 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string twoway_synonyms_control_ids = 18;</code>
   *
   * @param index The index of the element to return.
   * @return The twowaySynonymsControlIds at the given index.
   */
  java.lang.String getTwowaySynonymsControlIds(int index);
  /**
   *
   *
   * <pre>
   * Condition synonyms specifications. If multiple syonyms conditions match,
   * all matching synonyms control in the list will execute. Order of controls
   * in the list will not matter. Maximum number of specifications is
   * 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string twoway_synonyms_control_ids = 18;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the twowaySynonymsControlIds at the given index.
   */
  com.google.protobuf.ByteString getTwowaySynonymsControlIdsBytes(int index);

  /**
   *
   *
   * <pre>
   * Condition oneway synonyms specifications. If multiple oneway synonyms
   * conditions match, all matching oneway synonyms controls in the list will
   * execute. Order of controls in the list will not matter. Maximum number of
   * specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string oneway_synonyms_control_ids = 12;</code>
   *
   * @return A list containing the onewaySynonymsControlIds.
   */
  java.util.List<java.lang.String> getOnewaySynonymsControlIdsList();
  /**
   *
   *
   * <pre>
   * Condition oneway synonyms specifications. If multiple oneway synonyms
   * conditions match, all matching oneway synonyms controls in the list will
   * execute. Order of controls in the list will not matter. Maximum number of
   * specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string oneway_synonyms_control_ids = 12;</code>
   *
   * @return The count of onewaySynonymsControlIds.
   */
  int getOnewaySynonymsControlIdsCount();
  /**
   *
   *
   * <pre>
   * Condition oneway synonyms specifications. If multiple oneway synonyms
   * conditions match, all matching oneway synonyms controls in the list will
   * execute. Order of controls in the list will not matter. Maximum number of
   * specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string oneway_synonyms_control_ids = 12;</code>
   *
   * @param index The index of the element to return.
   * @return The onewaySynonymsControlIds at the given index.
   */
  java.lang.String getOnewaySynonymsControlIds(int index);
  /**
   *
   *
   * <pre>
   * Condition oneway synonyms specifications. If multiple oneway synonyms
   * conditions match, all matching oneway synonyms controls in the list will
   * execute. Order of controls in the list will not matter. Maximum number of
   * specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string oneway_synonyms_control_ids = 12;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the onewaySynonymsControlIds at the given index.
   */
  com.google.protobuf.ByteString getOnewaySynonymsControlIdsBytes(int index);

  /**
   *
   *
   * <pre>
   * Condition do not associate specifications. If multiple do not associate
   * conditions match, all matching do not associate controls in the list will
   * execute.
   * - Order does not matter.
   * - Maximum number of specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string do_not_associate_control_ids = 13;</code>
   *
   * @return A list containing the doNotAssociateControlIds.
   */
  java.util.List<java.lang.String> getDoNotAssociateControlIdsList();
  /**
   *
   *
   * <pre>
   * Condition do not associate specifications. If multiple do not associate
   * conditions match, all matching do not associate controls in the list will
   * execute.
   * - Order does not matter.
   * - Maximum number of specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string do_not_associate_control_ids = 13;</code>
   *
   * @return The count of doNotAssociateControlIds.
   */
  int getDoNotAssociateControlIdsCount();
  /**
   *
   *
   * <pre>
   * Condition do not associate specifications. If multiple do not associate
   * conditions match, all matching do not associate controls in the list will
   * execute.
   * - Order does not matter.
   * - Maximum number of specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string do_not_associate_control_ids = 13;</code>
   *
   * @param index The index of the element to return.
   * @return The doNotAssociateControlIds at the given index.
   */
  java.lang.String getDoNotAssociateControlIds(int index);
  /**
   *
   *
   * <pre>
   * Condition do not associate specifications. If multiple do not associate
   * conditions match, all matching do not associate controls in the list will
   * execute.
   * - Order does not matter.
   * - Maximum number of specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string do_not_associate_control_ids = 13;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the doNotAssociateControlIds at the given index.
   */
  com.google.protobuf.ByteString getDoNotAssociateControlIdsBytes(int index);

  /**
   *
   *
   * <pre>
   * Condition replacement specifications.
   * - Applied according to the order in the list.
   * - A previously replaced term can not be re-replaced.
   * - Maximum number of specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string replacement_control_ids = 14;</code>
   *
   * @return A list containing the replacementControlIds.
   */
  java.util.List<java.lang.String> getReplacementControlIdsList();
  /**
   *
   *
   * <pre>
   * Condition replacement specifications.
   * - Applied according to the order in the list.
   * - A previously replaced term can not be re-replaced.
   * - Maximum number of specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string replacement_control_ids = 14;</code>
   *
   * @return The count of replacementControlIds.
   */
  int getReplacementControlIdsCount();
  /**
   *
   *
   * <pre>
   * Condition replacement specifications.
   * - Applied according to the order in the list.
   * - A previously replaced term can not be re-replaced.
   * - Maximum number of specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string replacement_control_ids = 14;</code>
   *
   * @param index The index of the element to return.
   * @return The replacementControlIds at the given index.
   */
  java.lang.String getReplacementControlIds(int index);
  /**
   *
   *
   * <pre>
   * Condition replacement specifications.
   * - Applied according to the order in the list.
   * - A previously replaced term can not be re-replaced.
   * - Maximum number of specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string replacement_control_ids = 14;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the replacementControlIds at the given index.
   */
  com.google.protobuf.ByteString getReplacementControlIdsBytes(int index);

  /**
   *
   *
   * <pre>
   * Condition ignore specifications. If multiple ignore
   * conditions match, all matching ignore controls in the list will
   * execute.
   * - Order does not matter.
   * - Maximum number of specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string ignore_control_ids = 15;</code>
   *
   * @return A list containing the ignoreControlIds.
   */
  java.util.List<java.lang.String> getIgnoreControlIdsList();
  /**
   *
   *
   * <pre>
   * Condition ignore specifications. If multiple ignore
   * conditions match, all matching ignore controls in the list will
   * execute.
   * - Order does not matter.
   * - Maximum number of specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string ignore_control_ids = 15;</code>
   *
   * @return The count of ignoreControlIds.
   */
  int getIgnoreControlIdsCount();
  /**
   *
   *
   * <pre>
   * Condition ignore specifications. If multiple ignore
   * conditions match, all matching ignore controls in the list will
   * execute.
   * - Order does not matter.
   * - Maximum number of specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string ignore_control_ids = 15;</code>
   *
   * @param index The index of the element to return.
   * @return The ignoreControlIds at the given index.
   */
  java.lang.String getIgnoreControlIds(int index);
  /**
   *
   *
   * <pre>
   * Condition ignore specifications. If multiple ignore
   * conditions match, all matching ignore controls in the list will
   * execute.
   * - Order does not matter.
   * - Maximum number of specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string ignore_control_ids = 15;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the ignoreControlIds at the given index.
   */
  com.google.protobuf.ByteString getIgnoreControlIdsBytes(int index);

  /**
   *
   *
   * <pre>
   * How much diversity to use in recommendation model results e.g.
   * `medium-diversity` or `high-diversity`. Currently supported values:
   *
   * * `no-diversity`
   * * `low-diversity`
   * * `medium-diversity`
   * * `high-diversity`
   * * `auto-diversity`
   *
   * If not specified, we choose default based on recommendation model
   * type. Default value: `no-diversity`.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
   * </pre>
   *
   * <code>string diversity_level = 8;</code>
   *
   * @return The diversityLevel.
   */
  java.lang.String getDiversityLevel();
  /**
   *
   *
   * <pre>
   * How much diversity to use in recommendation model results e.g.
   * `medium-diversity` or `high-diversity`. Currently supported values:
   *
   * * `no-diversity`
   * * `low-diversity`
   * * `medium-diversity`
   * * `high-diversity`
   * * `auto-diversity`
   *
   * If not specified, we choose default based on recommendation model
   * type. Default value: `no-diversity`.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
   * </pre>
   *
   * <code>string diversity_level = 8;</code>
   *
   * @return The bytes for diversityLevel.
   */
  com.google.protobuf.ByteString getDiversityLevelBytes();

  /**
   *
   *
   * <pre>
   * What kind of diversity to use - data driven or rule based. If unset, the
   * server behavior defaults to
   * [RULE_BASED_DIVERSITY][google.cloud.retail.v2alpha.ServingConfig.DiversityType.RULE_BASED_DIVERSITY].
   * </pre>
   *
   * <code>.google.cloud.retail.v2alpha.ServingConfig.DiversityType diversity_type = 20;</code>
   *
   * @return The enum numeric value on the wire for diversityType.
   */
  int getDiversityTypeValue();
  /**
   *
   *
   * <pre>
   * What kind of diversity to use - data driven or rule based. If unset, the
   * server behavior defaults to
   * [RULE_BASED_DIVERSITY][google.cloud.retail.v2alpha.ServingConfig.DiversityType.RULE_BASED_DIVERSITY].
   * </pre>
   *
   * <code>.google.cloud.retail.v2alpha.ServingConfig.DiversityType diversity_type = 20;</code>
   *
   * @return The diversityType.
   */
  com.google.cloud.retail.v2alpha.ServingConfig.DiversityType getDiversityType();

  /**
   *
   *
   * <pre>
   * Whether to add additional category filters on the `similar-items` model.
   * If not specified, we enable it by default.
   *  Allowed values are:
   *
   * * `no-category-match`: No additional filtering of original results from
   *   the model and the customer's filters.
   * * `relaxed-category-match`: Only keep results with categories that match
   *   at least one item categories in the PredictRequests's context item.
   *   * If customer also sends filters in the PredictRequest, then the results
   *   will satisfy both conditions (user given and category match).
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
   * </pre>
   *
   * <code>string enable_category_filter_level = 16;</code>
   *
   * @return The enableCategoryFilterLevel.
   */
  java.lang.String getEnableCategoryFilterLevel();
  /**
   *
   *
   * <pre>
   * Whether to add additional category filters on the `similar-items` model.
   * If not specified, we enable it by default.
   *  Allowed values are:
   *
   * * `no-category-match`: No additional filtering of original results from
   *   the model and the customer's filters.
   * * `relaxed-category-match`: Only keep results with categories that match
   *   at least one item categories in the PredictRequests's context item.
   *   * If customer also sends filters in the PredictRequest, then the results
   *   will satisfy both conditions (user given and category match).
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
   * </pre>
   *
   * <code>string enable_category_filter_level = 16;</code>
   *
   * @return The bytes for enableCategoryFilterLevel.
   */
  com.google.protobuf.ByteString getEnableCategoryFilterLevelBytes();

  /**
   *
   *
   * <pre>
   * The specification for personalization spec.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   *
   * Notice that if both
   * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec]
   * and
   * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
   * are set.
   * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
   * will override
   * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec].
   * </pre>
   *
   * <code>.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec personalization_spec = 21;
   * </code>
   *
   * @return Whether the personalizationSpec field is set.
   */
  boolean hasPersonalizationSpec();
  /**
   *
   *
   * <pre>
   * The specification for personalization spec.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   *
   * Notice that if both
   * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec]
   * and
   * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
   * are set.
   * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
   * will override
   * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec].
   * </pre>
   *
   * <code>.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec personalization_spec = 21;
   * </code>
   *
   * @return The personalizationSpec.
   */
  com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec getPersonalizationSpec();
  /**
   *
   *
   * <pre>
   * The specification for personalization spec.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2alpha.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   *
   * Notice that if both
   * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec]
   * and
   * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
   * are set.
   * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
   * will override
   * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec].
   * </pre>
   *
   * <code>.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec personalization_spec = 21;
   * </code>
   */
  com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpecOrBuilder
      getPersonalizationSpecOrBuilder();

  /**
   *
   *
   * <pre>
   * Required. Immutable. Specifies the solution types that a serving config can
   * be associated with. Currently we support setting only one type of solution.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.SolutionType solution_types = 19 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return A list containing the solutionTypes.
   */
  java.util.List<com.google.cloud.retail.v2alpha.SolutionType> getSolutionTypesList();
  /**
   *
   *
   * <pre>
   * Required. Immutable. Specifies the solution types that a serving config can
   * be associated with. Currently we support setting only one type of solution.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.SolutionType solution_types = 19 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The count of solutionTypes.
   */
  int getSolutionTypesCount();
  /**
   *
   *
   * <pre>
   * Required. Immutable. Specifies the solution types that a serving config can
   * be associated with. Currently we support setting only one type of solution.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.SolutionType solution_types = 19 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The solutionTypes at the given index.
   */
  com.google.cloud.retail.v2alpha.SolutionType getSolutionTypes(int index);
  /**
   *
   *
   * <pre>
   * Required. Immutable. Specifies the solution types that a serving config can
   * be associated with. Currently we support setting only one type of solution.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.SolutionType solution_types = 19 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for solutionTypes.
   */
  java.util.List<java.lang.Integer> getSolutionTypesValueList();
  /**
   *
   *
   * <pre>
   * Required. Immutable. Specifies the solution types that a serving config can
   * be associated with. Currently we support setting only one type of solution.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.SolutionType solution_types = 19 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of solutionTypes at the given index.
   */
  int getSolutionTypesValue(int index);
}
