/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2alpha/import_config.proto

package com.google.cloud.retail.v2alpha;

/**
 *
 *
 * <pre>
 * The input config source for user events.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2alpha.UserEventInputConfig}
 */
public final class UserEventInputConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.UserEventInputConfig)
    UserEventInputConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UserEventInputConfig.newBuilder() to construct.
  private UserEventInputConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UserEventInputConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UserEventInputConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2alpha.ImportConfigProto
        .internal_static_google_cloud_retail_v2alpha_UserEventInputConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2alpha.ImportConfigProto
        .internal_static_google_cloud_retail_v2alpha_UserEventInputConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2alpha.UserEventInputConfig.class,
            com.google.cloud.retail.v2alpha.UserEventInputConfig.Builder.class);
  }

  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    USER_EVENT_INLINE_SOURCE(1),
    GCS_SOURCE(2),
    BIG_QUERY_SOURCE(3),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 1:
          return USER_EVENT_INLINE_SOURCE;
        case 2:
          return GCS_SOURCE;
        case 3:
          return BIG_QUERY_SOURCE;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int USER_EVENT_INLINE_SOURCE_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Required. The Inline source for the input content for UserEvents.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.UserEventInlineSource user_event_inline_source = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the userEventInlineSource field is set.
   */
  @java.lang.Override
  public boolean hasUserEventInlineSource() {
    return sourceCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Required. The Inline source for the input content for UserEvents.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.UserEventInlineSource user_event_inline_source = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The userEventInlineSource.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.UserEventInlineSource getUserEventInlineSource() {
    if (sourceCase_ == 1) {
      return (com.google.cloud.retail.v2alpha.UserEventInlineSource) source_;
    }
    return com.google.cloud.retail.v2alpha.UserEventInlineSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Required. The Inline source for the input content for UserEvents.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.UserEventInlineSource user_event_inline_source = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.UserEventInlineSourceOrBuilder
      getUserEventInlineSourceOrBuilder() {
    if (sourceCase_ == 1) {
      return (com.google.cloud.retail.v2alpha.UserEventInlineSource) source_;
    }
    return com.google.cloud.retail.v2alpha.UserEventInlineSource.getDefaultInstance();
  }

  public static final int GCS_SOURCE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Required. Google Cloud Storage location for the input content.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.GcsSource gcs_source = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the gcsSource field is set.
   */
  @java.lang.Override
  public boolean hasGcsSource() {
    return sourceCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Required. Google Cloud Storage location for the input content.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.GcsSource gcs_source = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The gcsSource.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.GcsSource getGcsSource() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.retail.v2alpha.GcsSource) source_;
    }
    return com.google.cloud.retail.v2alpha.GcsSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Required. Google Cloud Storage location for the input content.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.GcsSource gcs_source = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.GcsSourceOrBuilder getGcsSourceOrBuilder() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.retail.v2alpha.GcsSource) source_;
    }
    return com.google.cloud.retail.v2alpha.GcsSource.getDefaultInstance();
  }

  public static final int BIG_QUERY_SOURCE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Required. BigQuery input source.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.BigQuerySource big_query_source = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the bigQuerySource field is set.
   */
  @java.lang.Override
  public boolean hasBigQuerySource() {
    return sourceCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Required. BigQuery input source.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.BigQuerySource big_query_source = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The bigQuerySource.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.BigQuerySource getBigQuerySource() {
    if (sourceCase_ == 3) {
      return (com.google.cloud.retail.v2alpha.BigQuerySource) source_;
    }
    return com.google.cloud.retail.v2alpha.BigQuerySource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Required. BigQuery input source.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.BigQuerySource big_query_source = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.BigQuerySourceOrBuilder getBigQuerySourceOrBuilder() {
    if (sourceCase_ == 3) {
      return (com.google.cloud.retail.v2alpha.BigQuerySource) source_;
    }
    return com.google.cloud.retail.v2alpha.BigQuerySource.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (sourceCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.retail.v2alpha.UserEventInlineSource) source_);
    }
    if (sourceCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.retail.v2alpha.GcsSource) source_);
    }
    if (sourceCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.retail.v2alpha.BigQuerySource) source_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (sourceCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.retail.v2alpha.UserEventInlineSource) source_);
    }
    if (sourceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.retail.v2alpha.GcsSource) source_);
    }
    if (sourceCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.retail.v2alpha.BigQuerySource) source_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2alpha.UserEventInputConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2alpha.UserEventInputConfig other =
        (com.google.cloud.retail.v2alpha.UserEventInputConfig) obj;

    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 1:
        if (!getUserEventInlineSource().equals(other.getUserEventInlineSource())) return false;
        break;
      case 2:
        if (!getGcsSource().equals(other.getGcsSource())) return false;
        break;
      case 3:
        if (!getBigQuerySource().equals(other.getBigQuerySource())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (sourceCase_) {
      case 1:
        hash = (37 * hash) + USER_EVENT_INLINE_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getUserEventInlineSource().hashCode();
        break;
      case 2:
        hash = (37 * hash) + GCS_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getGcsSource().hashCode();
        break;
      case 3:
        hash = (37 * hash) + BIG_QUERY_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getBigQuerySource().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2alpha.UserEventInputConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.UserEventInputConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.UserEventInputConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.UserEventInputConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.UserEventInputConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.UserEventInputConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.UserEventInputConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.UserEventInputConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.UserEventInputConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.UserEventInputConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.UserEventInputConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.UserEventInputConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2alpha.UserEventInputConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The input config source for user events.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.UserEventInputConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.UserEventInputConfig)
      com.google.cloud.retail.v2alpha.UserEventInputConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.ImportConfigProto
          .internal_static_google_cloud_retail_v2alpha_UserEventInputConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.ImportConfigProto
          .internal_static_google_cloud_retail_v2alpha_UserEventInputConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.UserEventInputConfig.class,
              com.google.cloud.retail.v2alpha.UserEventInputConfig.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2alpha.UserEventInputConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (userEventInlineSourceBuilder_ != null) {
        userEventInlineSourceBuilder_.clear();
      }
      if (gcsSourceBuilder_ != null) {
        gcsSourceBuilder_.clear();
      }
      if (bigQuerySourceBuilder_ != null) {
        bigQuerySourceBuilder_.clear();
      }
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2alpha.ImportConfigProto
          .internal_static_google_cloud_retail_v2alpha_UserEventInputConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.UserEventInputConfig getDefaultInstanceForType() {
      return com.google.cloud.retail.v2alpha.UserEventInputConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.UserEventInputConfig build() {
      com.google.cloud.retail.v2alpha.UserEventInputConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.UserEventInputConfig buildPartial() {
      com.google.cloud.retail.v2alpha.UserEventInputConfig result =
          new com.google.cloud.retail.v2alpha.UserEventInputConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.retail.v2alpha.UserEventInputConfig result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.retail.v2alpha.UserEventInputConfig result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
      if (sourceCase_ == 1 && userEventInlineSourceBuilder_ != null) {
        result.source_ = userEventInlineSourceBuilder_.build();
      }
      if (sourceCase_ == 2 && gcsSourceBuilder_ != null) {
        result.source_ = gcsSourceBuilder_.build();
      }
      if (sourceCase_ == 3 && bigQuerySourceBuilder_ != null) {
        result.source_ = bigQuerySourceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2alpha.UserEventInputConfig) {
        return mergeFrom((com.google.cloud.retail.v2alpha.UserEventInputConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2alpha.UserEventInputConfig other) {
      if (other == com.google.cloud.retail.v2alpha.UserEventInputConfig.getDefaultInstance())
        return this;
      switch (other.getSourceCase()) {
        case USER_EVENT_INLINE_SOURCE:
          {
            mergeUserEventInlineSource(other.getUserEventInlineSource());
            break;
          }
        case GCS_SOURCE:
          {
            mergeGcsSource(other.getGcsSource());
            break;
          }
        case BIG_QUERY_SOURCE:
          {
            mergeBigQuerySource(other.getBigQuerySource());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getUserEventInlineSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getGcsSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getBigQuerySourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.UserEventInlineSource,
            com.google.cloud.retail.v2alpha.UserEventInlineSource.Builder,
            com.google.cloud.retail.v2alpha.UserEventInlineSourceOrBuilder>
        userEventInlineSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The Inline source for the input content for UserEvents.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.UserEventInlineSource user_event_inline_source = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the userEventInlineSource field is set.
     */
    @java.lang.Override
    public boolean hasUserEventInlineSource() {
      return sourceCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Required. The Inline source for the input content for UserEvents.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.UserEventInlineSource user_event_inline_source = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The userEventInlineSource.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.UserEventInlineSource getUserEventInlineSource() {
      if (userEventInlineSourceBuilder_ == null) {
        if (sourceCase_ == 1) {
          return (com.google.cloud.retail.v2alpha.UserEventInlineSource) source_;
        }
        return com.google.cloud.retail.v2alpha.UserEventInlineSource.getDefaultInstance();
      } else {
        if (sourceCase_ == 1) {
          return userEventInlineSourceBuilder_.getMessage();
        }
        return com.google.cloud.retail.v2alpha.UserEventInlineSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Inline source for the input content for UserEvents.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.UserEventInlineSource user_event_inline_source = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUserEventInlineSource(
        com.google.cloud.retail.v2alpha.UserEventInlineSource value) {
      if (userEventInlineSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        userEventInlineSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Inline source for the input content for UserEvents.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.UserEventInlineSource user_event_inline_source = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUserEventInlineSource(
        com.google.cloud.retail.v2alpha.UserEventInlineSource.Builder builderForValue) {
      if (userEventInlineSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        userEventInlineSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Inline source for the input content for UserEvents.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.UserEventInlineSource user_event_inline_source = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeUserEventInlineSource(
        com.google.cloud.retail.v2alpha.UserEventInlineSource value) {
      if (userEventInlineSourceBuilder_ == null) {
        if (sourceCase_ == 1
            && source_
                != com.google.cloud.retail.v2alpha.UserEventInlineSource.getDefaultInstance()) {
          source_ =
              com.google.cloud.retail.v2alpha.UserEventInlineSource.newBuilder(
                      (com.google.cloud.retail.v2alpha.UserEventInlineSource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 1) {
          userEventInlineSourceBuilder_.mergeFrom(value);
        } else {
          userEventInlineSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Inline source for the input content for UserEvents.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.UserEventInlineSource user_event_inline_source = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearUserEventInlineSource() {
      if (userEventInlineSourceBuilder_ == null) {
        if (sourceCase_ == 1) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 1) {
          sourceCase_ = 0;
          source_ = null;
        }
        userEventInlineSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Inline source for the input content for UserEvents.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.UserEventInlineSource user_event_inline_source = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.UserEventInlineSource.Builder
        getUserEventInlineSourceBuilder() {
      return getUserEventInlineSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The Inline source for the input content for UserEvents.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.UserEventInlineSource user_event_inline_source = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.UserEventInlineSourceOrBuilder
        getUserEventInlineSourceOrBuilder() {
      if ((sourceCase_ == 1) && (userEventInlineSourceBuilder_ != null)) {
        return userEventInlineSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 1) {
          return (com.google.cloud.retail.v2alpha.UserEventInlineSource) source_;
        }
        return com.google.cloud.retail.v2alpha.UserEventInlineSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Inline source for the input content for UserEvents.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.UserEventInlineSource user_event_inline_source = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.UserEventInlineSource,
            com.google.cloud.retail.v2alpha.UserEventInlineSource.Builder,
            com.google.cloud.retail.v2alpha.UserEventInlineSourceOrBuilder>
        getUserEventInlineSourceFieldBuilder() {
      if (userEventInlineSourceBuilder_ == null) {
        if (!(sourceCase_ == 1)) {
          source_ = com.google.cloud.retail.v2alpha.UserEventInlineSource.getDefaultInstance();
        }
        userEventInlineSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2alpha.UserEventInlineSource,
                com.google.cloud.retail.v2alpha.UserEventInlineSource.Builder,
                com.google.cloud.retail.v2alpha.UserEventInlineSourceOrBuilder>(
                (com.google.cloud.retail.v2alpha.UserEventInlineSource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 1;
      onChanged();
      return userEventInlineSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.GcsSource,
            com.google.cloud.retail.v2alpha.GcsSource.Builder,
            com.google.cloud.retail.v2alpha.GcsSourceOrBuilder>
        gcsSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Google Cloud Storage location for the input content.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.GcsSource gcs_source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the gcsSource field is set.
     */
    @java.lang.Override
    public boolean hasGcsSource() {
      return sourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Required. Google Cloud Storage location for the input content.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.GcsSource gcs_source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The gcsSource.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.GcsSource getGcsSource() {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          return (com.google.cloud.retail.v2alpha.GcsSource) source_;
        }
        return com.google.cloud.retail.v2alpha.GcsSource.getDefaultInstance();
      } else {
        if (sourceCase_ == 2) {
          return gcsSourceBuilder_.getMessage();
        }
        return com.google.cloud.retail.v2alpha.GcsSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Google Cloud Storage location for the input content.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.GcsSource gcs_source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setGcsSource(com.google.cloud.retail.v2alpha.GcsSource value) {
      if (gcsSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Google Cloud Storage location for the input content.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.GcsSource gcs_source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setGcsSource(com.google.cloud.retail.v2alpha.GcsSource.Builder builderForValue) {
      if (gcsSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Google Cloud Storage location for the input content.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.GcsSource gcs_source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeGcsSource(com.google.cloud.retail.v2alpha.GcsSource value) {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 2
            && source_ != com.google.cloud.retail.v2alpha.GcsSource.getDefaultInstance()) {
          source_ =
              com.google.cloud.retail.v2alpha.GcsSource.newBuilder(
                      (com.google.cloud.retail.v2alpha.GcsSource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 2) {
          gcsSourceBuilder_.mergeFrom(value);
        } else {
          gcsSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Google Cloud Storage location for the input content.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.GcsSource gcs_source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearGcsSource() {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
        }
        gcsSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Google Cloud Storage location for the input content.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.GcsSource gcs_source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.GcsSource.Builder getGcsSourceBuilder() {
      return getGcsSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Google Cloud Storage location for the input content.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.GcsSource gcs_source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.GcsSourceOrBuilder getGcsSourceOrBuilder() {
      if ((sourceCase_ == 2) && (gcsSourceBuilder_ != null)) {
        return gcsSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 2) {
          return (com.google.cloud.retail.v2alpha.GcsSource) source_;
        }
        return com.google.cloud.retail.v2alpha.GcsSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Google Cloud Storage location for the input content.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.GcsSource gcs_source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.GcsSource,
            com.google.cloud.retail.v2alpha.GcsSource.Builder,
            com.google.cloud.retail.v2alpha.GcsSourceOrBuilder>
        getGcsSourceFieldBuilder() {
      if (gcsSourceBuilder_ == null) {
        if (!(sourceCase_ == 2)) {
          source_ = com.google.cloud.retail.v2alpha.GcsSource.getDefaultInstance();
        }
        gcsSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2alpha.GcsSource,
                com.google.cloud.retail.v2alpha.GcsSource.Builder,
                com.google.cloud.retail.v2alpha.GcsSourceOrBuilder>(
                (com.google.cloud.retail.v2alpha.GcsSource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 2;
      onChanged();
      return gcsSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.BigQuerySource,
            com.google.cloud.retail.v2alpha.BigQuerySource.Builder,
            com.google.cloud.retail.v2alpha.BigQuerySourceOrBuilder>
        bigQuerySourceBuilder_;
    /**
     *
     *
     * <pre>
     * Required. BigQuery input source.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.BigQuerySource big_query_source = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the bigQuerySource field is set.
     */
    @java.lang.Override
    public boolean hasBigQuerySource() {
      return sourceCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Required. BigQuery input source.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.BigQuerySource big_query_source = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The bigQuerySource.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.BigQuerySource getBigQuerySource() {
      if (bigQuerySourceBuilder_ == null) {
        if (sourceCase_ == 3) {
          return (com.google.cloud.retail.v2alpha.BigQuerySource) source_;
        }
        return com.google.cloud.retail.v2alpha.BigQuerySource.getDefaultInstance();
      } else {
        if (sourceCase_ == 3) {
          return bigQuerySourceBuilder_.getMessage();
        }
        return com.google.cloud.retail.v2alpha.BigQuerySource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. BigQuery input source.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.BigQuerySource big_query_source = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setBigQuerySource(com.google.cloud.retail.v2alpha.BigQuerySource value) {
      if (bigQuerySourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        bigQuerySourceBuilder_.setMessage(value);
      }
      sourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. BigQuery input source.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.BigQuerySource big_query_source = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setBigQuerySource(
        com.google.cloud.retail.v2alpha.BigQuerySource.Builder builderForValue) {
      if (bigQuerySourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        bigQuerySourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. BigQuery input source.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.BigQuerySource big_query_source = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeBigQuerySource(com.google.cloud.retail.v2alpha.BigQuerySource value) {
      if (bigQuerySourceBuilder_ == null) {
        if (sourceCase_ == 3
            && source_ != com.google.cloud.retail.v2alpha.BigQuerySource.getDefaultInstance()) {
          source_ =
              com.google.cloud.retail.v2alpha.BigQuerySource.newBuilder(
                      (com.google.cloud.retail.v2alpha.BigQuerySource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 3) {
          bigQuerySourceBuilder_.mergeFrom(value);
        } else {
          bigQuerySourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. BigQuery input source.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.BigQuerySource big_query_source = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearBigQuerySource() {
      if (bigQuerySourceBuilder_ == null) {
        if (sourceCase_ == 3) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 3) {
          sourceCase_ = 0;
          source_ = null;
        }
        bigQuerySourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. BigQuery input source.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.BigQuerySource big_query_source = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.BigQuerySource.Builder getBigQuerySourceBuilder() {
      return getBigQuerySourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. BigQuery input source.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.BigQuerySource big_query_source = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.BigQuerySourceOrBuilder getBigQuerySourceOrBuilder() {
      if ((sourceCase_ == 3) && (bigQuerySourceBuilder_ != null)) {
        return bigQuerySourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 3) {
          return (com.google.cloud.retail.v2alpha.BigQuerySource) source_;
        }
        return com.google.cloud.retail.v2alpha.BigQuerySource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. BigQuery input source.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.BigQuerySource big_query_source = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.BigQuerySource,
            com.google.cloud.retail.v2alpha.BigQuerySource.Builder,
            com.google.cloud.retail.v2alpha.BigQuerySourceOrBuilder>
        getBigQuerySourceFieldBuilder() {
      if (bigQuerySourceBuilder_ == null) {
        if (!(sourceCase_ == 3)) {
          source_ = com.google.cloud.retail.v2alpha.BigQuerySource.getDefaultInstance();
        }
        bigQuerySourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2alpha.BigQuerySource,
                com.google.cloud.retail.v2alpha.BigQuerySource.Builder,
                com.google.cloud.retail.v2alpha.BigQuerySourceOrBuilder>(
                (com.google.cloud.retail.v2alpha.BigQuerySource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 3;
      onChanged();
      return bigQuerySourceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.UserEventInputConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.UserEventInputConfig)
  private static final com.google.cloud.retail.v2alpha.UserEventInputConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.UserEventInputConfig();
  }

  public static com.google.cloud.retail.v2alpha.UserEventInputConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UserEventInputConfig> PARSER =
      new com.google.protobuf.AbstractParser<UserEventInputConfig>() {
        @java.lang.Override
        public UserEventInputConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UserEventInputConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UserEventInputConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2alpha.UserEventInputConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
