/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2alpha/import_config.proto

package com.google.cloud.retail.v2alpha;

/**
 *
 *
 * <pre>
 * Metadata related to the progress of the Import operation. This is
 * returned by the google.longrunning.Operation.metadata field.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2alpha.ImportMetadata}
 */
public final class ImportMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.ImportMetadata)
    ImportMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportMetadata.newBuilder() to construct.
  private ImportMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportMetadata() {
    requestId_ = "";
    notificationPubsubTopic_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2alpha.ImportConfigProto
        .internal_static_google_cloud_retail_v2alpha_ImportMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2alpha.ImportConfigProto
        .internal_static_google_cloud_retail_v2alpha_ImportMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2alpha.ImportMetadata.class,
            com.google.cloud.retail.v2alpha.ImportMetadata.Builder.class);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Operation create time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Operation create time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Operation create time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Operation last update time. If the operation is done, this is also the
   * finish time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 2;</code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Operation last update time. If the operation is done, this is also the
   * finish time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 2;</code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Operation last update time. If the operation is done, this is also the
   * finish time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int SUCCESS_COUNT_FIELD_NUMBER = 3;
  private long successCount_ = 0L;
  /**
   *
   *
   * <pre>
   * Count of entries that were processed successfully.
   * </pre>
   *
   * <code>int64 success_count = 3;</code>
   *
   * @return The successCount.
   */
  @java.lang.Override
  public long getSuccessCount() {
    return successCount_;
  }

  public static final int FAILURE_COUNT_FIELD_NUMBER = 4;
  private long failureCount_ = 0L;
  /**
   *
   *
   * <pre>
   * Count of entries that encountered errors while processing.
   * </pre>
   *
   * <code>int64 failure_count = 4;</code>
   *
   * @return The failureCount.
   */
  @java.lang.Override
  public long getFailureCount() {
    return failureCount_;
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";
  /**
   *
   *
   * <pre>
   * Deprecated. This field is never set.
   * </pre>
   *
   * <code>string request_id = 5 [deprecated = true];</code>
   *
   * @deprecated google.cloud.retail.v2alpha.ImportMetadata.request_id is deprecated. See
   *     google/cloud/retail/v2alpha/import_config.proto;l=339
   * @return The requestId.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Deprecated. This field is never set.
   * </pre>
   *
   * <code>string request_id = 5 [deprecated = true];</code>
   *
   * @deprecated google.cloud.retail.v2alpha.ImportMetadata.request_id is deprecated. See
   *     google/cloud/retail/v2alpha/import_config.proto;l=339
   * @return The bytes for requestId.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NOTIFICATION_PUBSUB_TOPIC_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object notificationPubsubTopic_ = "";
  /**
   *
   *
   * <pre>
   * Pub/Sub topic for receiving notification. If this field is set,
   * when the import is finished, a notification is sent to
   * specified Pub/Sub topic. The message data is JSON string of a
   * [Operation][google.longrunning.Operation].
   * Format of the Pub/Sub topic is `projects/{project}/topics/{topic}`.
   * </pre>
   *
   * <code>string notification_pubsub_topic = 6;</code>
   *
   * @return The notificationPubsubTopic.
   */
  @java.lang.Override
  public java.lang.String getNotificationPubsubTopic() {
    java.lang.Object ref = notificationPubsubTopic_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      notificationPubsubTopic_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Pub/Sub topic for receiving notification. If this field is set,
   * when the import is finished, a notification is sent to
   * specified Pub/Sub topic. The message data is JSON string of a
   * [Operation][google.longrunning.Operation].
   * Format of the Pub/Sub topic is `projects/{project}/topics/{topic}`.
   * </pre>
   *
   * <code>string notification_pubsub_topic = 6;</code>
   *
   * @return The bytes for notificationPubsubTopic.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNotificationPubsubTopicBytes() {
    java.lang.Object ref = notificationPubsubTopic_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      notificationPubsubTopic_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRANSFORMED_USER_EVENTS_METADATA_FIELD_NUMBER = 7;
  private com.google.cloud.retail.v2alpha.TransformedUserEventsMetadata
      transformedUserEventsMetadata_;
  /**
   *
   *
   * <pre>
   * Metadata related to transform user events.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.TransformedUserEventsMetadata transformed_user_events_metadata = 7;
   * </code>
   *
   * @return Whether the transformedUserEventsMetadata field is set.
   */
  @java.lang.Override
  public boolean hasTransformedUserEventsMetadata() {
    return transformedUserEventsMetadata_ != null;
  }
  /**
   *
   *
   * <pre>
   * Metadata related to transform user events.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.TransformedUserEventsMetadata transformed_user_events_metadata = 7;
   * </code>
   *
   * @return The transformedUserEventsMetadata.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.TransformedUserEventsMetadata
      getTransformedUserEventsMetadata() {
    return transformedUserEventsMetadata_ == null
        ? com.google.cloud.retail.v2alpha.TransformedUserEventsMetadata.getDefaultInstance()
        : transformedUserEventsMetadata_;
  }
  /**
   *
   *
   * <pre>
   * Metadata related to transform user events.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.TransformedUserEventsMetadata transformed_user_events_metadata = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.TransformedUserEventsMetadataOrBuilder
      getTransformedUserEventsMetadataOrBuilder() {
    return transformedUserEventsMetadata_ == null
        ? com.google.cloud.retail.v2alpha.TransformedUserEventsMetadata.getDefaultInstance()
        : transformedUserEventsMetadata_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (createTime_ != null) {
      output.writeMessage(1, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(2, getUpdateTime());
    }
    if (successCount_ != 0L) {
      output.writeInt64(3, successCount_);
    }
    if (failureCount_ != 0L) {
      output.writeInt64(4, failureCount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, requestId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(notificationPubsubTopic_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, notificationPubsubTopic_);
    }
    if (transformedUserEventsMetadata_ != null) {
      output.writeMessage(7, getTransformedUserEventsMetadata());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getUpdateTime());
    }
    if (successCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, successCount_);
    }
    if (failureCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, failureCount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, requestId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(notificationPubsubTopic_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, notificationPubsubTopic_);
    }
    if (transformedUserEventsMetadata_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, getTransformedUserEventsMetadata());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2alpha.ImportMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2alpha.ImportMetadata other =
        (com.google.cloud.retail.v2alpha.ImportMetadata) obj;

    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (getSuccessCount() != other.getSuccessCount()) return false;
    if (getFailureCount() != other.getFailureCount()) return false;
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (!getNotificationPubsubTopic().equals(other.getNotificationPubsubTopic())) return false;
    if (hasTransformedUserEventsMetadata() != other.hasTransformedUserEventsMetadata())
      return false;
    if (hasTransformedUserEventsMetadata()) {
      if (!getTransformedUserEventsMetadata().equals(other.getTransformedUserEventsMetadata()))
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + SUCCESS_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getSuccessCount());
    hash = (37 * hash) + FAILURE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getFailureCount());
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    hash = (37 * hash) + NOTIFICATION_PUBSUB_TOPIC_FIELD_NUMBER;
    hash = (53 * hash) + getNotificationPubsubTopic().hashCode();
    if (hasTransformedUserEventsMetadata()) {
      hash = (37 * hash) + TRANSFORMED_USER_EVENTS_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getTransformedUserEventsMetadata().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2alpha.ImportMetadata parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.ImportMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.ImportMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.ImportMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.ImportMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.ImportMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.ImportMetadata parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.ImportMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.ImportMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.ImportMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.ImportMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.ImportMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2alpha.ImportMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata related to the progress of the Import operation. This is
   * returned by the google.longrunning.Operation.metadata field.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.ImportMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.ImportMetadata)
      com.google.cloud.retail.v2alpha.ImportMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.ImportConfigProto
          .internal_static_google_cloud_retail_v2alpha_ImportMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.ImportConfigProto
          .internal_static_google_cloud_retail_v2alpha_ImportMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.ImportMetadata.class,
              com.google.cloud.retail.v2alpha.ImportMetadata.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2alpha.ImportMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      successCount_ = 0L;
      failureCount_ = 0L;
      requestId_ = "";
      notificationPubsubTopic_ = "";
      transformedUserEventsMetadata_ = null;
      if (transformedUserEventsMetadataBuilder_ != null) {
        transformedUserEventsMetadataBuilder_.dispose();
        transformedUserEventsMetadataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2alpha.ImportConfigProto
          .internal_static_google_cloud_retail_v2alpha_ImportMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.ImportMetadata getDefaultInstanceForType() {
      return com.google.cloud.retail.v2alpha.ImportMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.ImportMetadata build() {
      com.google.cloud.retail.v2alpha.ImportMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.ImportMetadata buildPartial() {
      com.google.cloud.retail.v2alpha.ImportMetadata result =
          new com.google.cloud.retail.v2alpha.ImportMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.retail.v2alpha.ImportMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.successCount_ = successCount_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.failureCount_ = failureCount_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.requestId_ = requestId_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.notificationPubsubTopic_ = notificationPubsubTopic_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.transformedUserEventsMetadata_ =
            transformedUserEventsMetadataBuilder_ == null
                ? transformedUserEventsMetadata_
                : transformedUserEventsMetadataBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2alpha.ImportMetadata) {
        return mergeFrom((com.google.cloud.retail.v2alpha.ImportMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2alpha.ImportMetadata other) {
      if (other == com.google.cloud.retail.v2alpha.ImportMetadata.getDefaultInstance()) return this;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.getSuccessCount() != 0L) {
        setSuccessCount(other.getSuccessCount());
      }
      if (other.getFailureCount() != 0L) {
        setFailureCount(other.getFailureCount());
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getNotificationPubsubTopic().isEmpty()) {
        notificationPubsubTopic_ = other.notificationPubsubTopic_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasTransformedUserEventsMetadata()) {
        mergeTransformedUserEventsMetadata(other.getTransformedUserEventsMetadata());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                successCount_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                failureCount_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                notificationPubsubTopic_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getTransformedUserEventsMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private long successCount_;
    /**
     *
     *
     * <pre>
     * Count of entries that were processed successfully.
     * </pre>
     *
     * <code>int64 success_count = 3;</code>
     *
     * @return The successCount.
     */
    @java.lang.Override
    public long getSuccessCount() {
      return successCount_;
    }
    /**
     *
     *
     * <pre>
     * Count of entries that were processed successfully.
     * </pre>
     *
     * <code>int64 success_count = 3;</code>
     *
     * @param value The successCount to set.
     * @return This builder for chaining.
     */
    public Builder setSuccessCount(long value) {

      successCount_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Count of entries that were processed successfully.
     * </pre>
     *
     * <code>int64 success_count = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSuccessCount() {
      bitField0_ = (bitField0_ & ~0x00000004);
      successCount_ = 0L;
      onChanged();
      return this;
    }

    private long failureCount_;
    /**
     *
     *
     * <pre>
     * Count of entries that encountered errors while processing.
     * </pre>
     *
     * <code>int64 failure_count = 4;</code>
     *
     * @return The failureCount.
     */
    @java.lang.Override
    public long getFailureCount() {
      return failureCount_;
    }
    /**
     *
     *
     * <pre>
     * Count of entries that encountered errors while processing.
     * </pre>
     *
     * <code>int64 failure_count = 4;</code>
     *
     * @param value The failureCount to set.
     * @return This builder for chaining.
     */
    public Builder setFailureCount(long value) {

      failureCount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Count of entries that encountered errors while processing.
     * </pre>
     *
     * <code>int64 failure_count = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFailureCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      failureCount_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * Deprecated. This field is never set.
     * </pre>
     *
     * <code>string request_id = 5 [deprecated = true];</code>
     *
     * @deprecated google.cloud.retail.v2alpha.ImportMetadata.request_id is deprecated. See
     *     google/cloud/retail/v2alpha/import_config.proto;l=339
     * @return The requestId.
     */
    @java.lang.Deprecated
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field is never set.
     * </pre>
     *
     * <code>string request_id = 5 [deprecated = true];</code>
     *
     * @deprecated google.cloud.retail.v2alpha.ImportMetadata.request_id is deprecated. See
     *     google/cloud/retail/v2alpha/import_config.proto;l=339
     * @return The bytes for requestId.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field is never set.
     * </pre>
     *
     * <code>string request_id = 5 [deprecated = true];</code>
     *
     * @deprecated google.cloud.retail.v2alpha.ImportMetadata.request_id is deprecated. See
     *     google/cloud/retail/v2alpha/import_config.proto;l=339
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field is never set.
     * </pre>
     *
     * <code>string request_id = 5 [deprecated = true];</code>
     *
     * @deprecated google.cloud.retail.v2alpha.ImportMetadata.request_id is deprecated. See
     *     google/cloud/retail/v2alpha/import_config.proto;l=339
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field is never set.
     * </pre>
     *
     * <code>string request_id = 5 [deprecated = true];</code>
     *
     * @deprecated google.cloud.retail.v2alpha.ImportMetadata.request_id is deprecated. See
     *     google/cloud/retail/v2alpha/import_config.proto;l=339
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object notificationPubsubTopic_ = "";
    /**
     *
     *
     * <pre>
     * Pub/Sub topic for receiving notification. If this field is set,
     * when the import is finished, a notification is sent to
     * specified Pub/Sub topic. The message data is JSON string of a
     * [Operation][google.longrunning.Operation].
     * Format of the Pub/Sub topic is `projects/{project}/topics/{topic}`.
     * </pre>
     *
     * <code>string notification_pubsub_topic = 6;</code>
     *
     * @return The notificationPubsubTopic.
     */
    public java.lang.String getNotificationPubsubTopic() {
      java.lang.Object ref = notificationPubsubTopic_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        notificationPubsubTopic_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Pub/Sub topic for receiving notification. If this field is set,
     * when the import is finished, a notification is sent to
     * specified Pub/Sub topic. The message data is JSON string of a
     * [Operation][google.longrunning.Operation].
     * Format of the Pub/Sub topic is `projects/{project}/topics/{topic}`.
     * </pre>
     *
     * <code>string notification_pubsub_topic = 6;</code>
     *
     * @return The bytes for notificationPubsubTopic.
     */
    public com.google.protobuf.ByteString getNotificationPubsubTopicBytes() {
      java.lang.Object ref = notificationPubsubTopic_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        notificationPubsubTopic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Pub/Sub topic for receiving notification. If this field is set,
     * when the import is finished, a notification is sent to
     * specified Pub/Sub topic. The message data is JSON string of a
     * [Operation][google.longrunning.Operation].
     * Format of the Pub/Sub topic is `projects/{project}/topics/{topic}`.
     * </pre>
     *
     * <code>string notification_pubsub_topic = 6;</code>
     *
     * @param value The notificationPubsubTopic to set.
     * @return This builder for chaining.
     */
    public Builder setNotificationPubsubTopic(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      notificationPubsubTopic_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pub/Sub topic for receiving notification. If this field is set,
     * when the import is finished, a notification is sent to
     * specified Pub/Sub topic. The message data is JSON string of a
     * [Operation][google.longrunning.Operation].
     * Format of the Pub/Sub topic is `projects/{project}/topics/{topic}`.
     * </pre>
     *
     * <code>string notification_pubsub_topic = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNotificationPubsubTopic() {
      notificationPubsubTopic_ = getDefaultInstance().getNotificationPubsubTopic();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pub/Sub topic for receiving notification. If this field is set,
     * when the import is finished, a notification is sent to
     * specified Pub/Sub topic. The message data is JSON string of a
     * [Operation][google.longrunning.Operation].
     * Format of the Pub/Sub topic is `projects/{project}/topics/{topic}`.
     * </pre>
     *
     * <code>string notification_pubsub_topic = 6;</code>
     *
     * @param value The bytes for notificationPubsubTopic to set.
     * @return This builder for chaining.
     */
    public Builder setNotificationPubsubTopicBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      notificationPubsubTopic_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.cloud.retail.v2alpha.TransformedUserEventsMetadata
        transformedUserEventsMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.TransformedUserEventsMetadata,
            com.google.cloud.retail.v2alpha.TransformedUserEventsMetadata.Builder,
            com.google.cloud.retail.v2alpha.TransformedUserEventsMetadataOrBuilder>
        transformedUserEventsMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata related to transform user events.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.TransformedUserEventsMetadata transformed_user_events_metadata = 7;
     * </code>
     *
     * @return Whether the transformedUserEventsMetadata field is set.
     */
    public boolean hasTransformedUserEventsMetadata() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Metadata related to transform user events.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.TransformedUserEventsMetadata transformed_user_events_metadata = 7;
     * </code>
     *
     * @return The transformedUserEventsMetadata.
     */
    public com.google.cloud.retail.v2alpha.TransformedUserEventsMetadata
        getTransformedUserEventsMetadata() {
      if (transformedUserEventsMetadataBuilder_ == null) {
        return transformedUserEventsMetadata_ == null
            ? com.google.cloud.retail.v2alpha.TransformedUserEventsMetadata.getDefaultInstance()
            : transformedUserEventsMetadata_;
      } else {
        return transformedUserEventsMetadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata related to transform user events.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.TransformedUserEventsMetadata transformed_user_events_metadata = 7;
     * </code>
     */
    public Builder setTransformedUserEventsMetadata(
        com.google.cloud.retail.v2alpha.TransformedUserEventsMetadata value) {
      if (transformedUserEventsMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transformedUserEventsMetadata_ = value;
      } else {
        transformedUserEventsMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata related to transform user events.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.TransformedUserEventsMetadata transformed_user_events_metadata = 7;
     * </code>
     */
    public Builder setTransformedUserEventsMetadata(
        com.google.cloud.retail.v2alpha.TransformedUserEventsMetadata.Builder builderForValue) {
      if (transformedUserEventsMetadataBuilder_ == null) {
        transformedUserEventsMetadata_ = builderForValue.build();
      } else {
        transformedUserEventsMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata related to transform user events.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.TransformedUserEventsMetadata transformed_user_events_metadata = 7;
     * </code>
     */
    public Builder mergeTransformedUserEventsMetadata(
        com.google.cloud.retail.v2alpha.TransformedUserEventsMetadata value) {
      if (transformedUserEventsMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && transformedUserEventsMetadata_ != null
            && transformedUserEventsMetadata_
                != com.google.cloud.retail.v2alpha.TransformedUserEventsMetadata
                    .getDefaultInstance()) {
          getTransformedUserEventsMetadataBuilder().mergeFrom(value);
        } else {
          transformedUserEventsMetadata_ = value;
        }
      } else {
        transformedUserEventsMetadataBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata related to transform user events.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.TransformedUserEventsMetadata transformed_user_events_metadata = 7;
     * </code>
     */
    public Builder clearTransformedUserEventsMetadata() {
      bitField0_ = (bitField0_ & ~0x00000040);
      transformedUserEventsMetadata_ = null;
      if (transformedUserEventsMetadataBuilder_ != null) {
        transformedUserEventsMetadataBuilder_.dispose();
        transformedUserEventsMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata related to transform user events.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.TransformedUserEventsMetadata transformed_user_events_metadata = 7;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.TransformedUserEventsMetadata.Builder
        getTransformedUserEventsMetadataBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getTransformedUserEventsMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata related to transform user events.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.TransformedUserEventsMetadata transformed_user_events_metadata = 7;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.TransformedUserEventsMetadataOrBuilder
        getTransformedUserEventsMetadataOrBuilder() {
      if (transformedUserEventsMetadataBuilder_ != null) {
        return transformedUserEventsMetadataBuilder_.getMessageOrBuilder();
      } else {
        return transformedUserEventsMetadata_ == null
            ? com.google.cloud.retail.v2alpha.TransformedUserEventsMetadata.getDefaultInstance()
            : transformedUserEventsMetadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata related to transform user events.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.TransformedUserEventsMetadata transformed_user_events_metadata = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.TransformedUserEventsMetadata,
            com.google.cloud.retail.v2alpha.TransformedUserEventsMetadata.Builder,
            com.google.cloud.retail.v2alpha.TransformedUserEventsMetadataOrBuilder>
        getTransformedUserEventsMetadataFieldBuilder() {
      if (transformedUserEventsMetadataBuilder_ == null) {
        transformedUserEventsMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2alpha.TransformedUserEventsMetadata,
                com.google.cloud.retail.v2alpha.TransformedUserEventsMetadata.Builder,
                com.google.cloud.retail.v2alpha.TransformedUserEventsMetadataOrBuilder>(
                getTransformedUserEventsMetadata(), getParentForChildren(), isClean());
        transformedUserEventsMetadata_ = null;
      }
      return transformedUserEventsMetadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.ImportMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.ImportMetadata)
  private static final com.google.cloud.retail.v2alpha.ImportMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.ImportMetadata();
  }

  public static com.google.cloud.retail.v2alpha.ImportMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportMetadata> PARSER =
      new com.google.protobuf.AbstractParser<ImportMetadata>() {
        @java.lang.Override
        public ImportMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImportMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2alpha.ImportMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
