/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2alpha/merchant_center_account_link.proto

package com.google.cloud.retail.v2alpha;

/**
 *
 *
 * <pre>
 * Represents a link between a Merchant Center account and a branch.
 * Once a link is established, products from the linked merchant center account
 * will be streamed to the linked branch.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2alpha.MerchantCenterAccountLink}
 */
public final class MerchantCenterAccountLink extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.MerchantCenterAccountLink)
    MerchantCenterAccountLinkOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MerchantCenterAccountLink.newBuilder() to construct.
  private MerchantCenterAccountLink(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MerchantCenterAccountLink() {
    name_ = "";
    id_ = "";
    branchId_ = "";
    feedLabel_ = "";
    languageCode_ = "";
    feedFilters_ = java.util.Collections.emptyList();
    state_ = 0;
    projectId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MerchantCenterAccountLink();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2alpha.MerchantCenterAccountLinkProto
        .internal_static_google_cloud_retail_v2alpha_MerchantCenterAccountLink_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2alpha.MerchantCenterAccountLinkProto
        .internal_static_google_cloud_retail_v2alpha_MerchantCenterAccountLink_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.class,
            com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The state of the link.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.retail.v2alpha.MerchantCenterAccountLink.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Link is created and LRO is not complete.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    PENDING(1),
    /**
     *
     *
     * <pre>
     * Link is active.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    ACTIVE(2),
    /**
     *
     *
     * <pre>
     * Link creation failed.
     * </pre>
     *
     * <code>FAILED = 3;</code>
     */
    FAILED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Link is created and LRO is not complete.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    public static final int PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Link is active.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    public static final int ACTIVE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Link creation failed.
     * </pre>
     *
     * <code>FAILED = 3;</code>
     */
    public static final int FAILED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return PENDING;
        case 2:
          return ACTIVE;
        case 3:
          return FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2alpha.MerchantCenterAccountLink.State)
  }

  public interface MerchantCenterFeedFilterOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Merchant Center primary feed ID.
     * </pre>
     *
     * <code>int64 primary_feed_id = 1;</code>
     *
     * @return The primaryFeedId.
     */
    long getPrimaryFeedId();

    /**
     *
     *
     * <pre>
     * Merchant Center primary feed name. The name is used for the display
     * purposes only.
     * </pre>
     *
     * <code>string primary_feed_name = 2;</code>
     *
     * @return The primaryFeedName.
     */
    java.lang.String getPrimaryFeedName();
    /**
     *
     *
     * <pre>
     * Merchant Center primary feed name. The name is used for the display
     * purposes only.
     * </pre>
     *
     * <code>string primary_feed_name = 2;</code>
     *
     * @return The bytes for primaryFeedName.
     */
    com.google.protobuf.ByteString getPrimaryFeedNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Merchant Center Feed filter criterion.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter}
   */
  public static final class MerchantCenterFeedFilter extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter)
      MerchantCenterFeedFilterOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MerchantCenterFeedFilter.newBuilder() to construct.
    private MerchantCenterFeedFilter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MerchantCenterFeedFilter() {
      primaryFeedName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MerchantCenterFeedFilter();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.MerchantCenterAccountLinkProto
          .internal_static_google_cloud_retail_v2alpha_MerchantCenterAccountLink_MerchantCenterFeedFilter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.MerchantCenterAccountLinkProto
          .internal_static_google_cloud_retail_v2alpha_MerchantCenterAccountLink_MerchantCenterFeedFilter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
                  .class,
              com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
                  .Builder.class);
    }

    public static final int PRIMARY_FEED_ID_FIELD_NUMBER = 1;
    private long primaryFeedId_ = 0L;
    /**
     *
     *
     * <pre>
     * Merchant Center primary feed ID.
     * </pre>
     *
     * <code>int64 primary_feed_id = 1;</code>
     *
     * @return The primaryFeedId.
     */
    @java.lang.Override
    public long getPrimaryFeedId() {
      return primaryFeedId_;
    }

    public static final int PRIMARY_FEED_NAME_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object primaryFeedName_ = "";
    /**
     *
     *
     * <pre>
     * Merchant Center primary feed name. The name is used for the display
     * purposes only.
     * </pre>
     *
     * <code>string primary_feed_name = 2;</code>
     *
     * @return The primaryFeedName.
     */
    @java.lang.Override
    public java.lang.String getPrimaryFeedName() {
      java.lang.Object ref = primaryFeedName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        primaryFeedName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Merchant Center primary feed name. The name is used for the display
     * purposes only.
     * </pre>
     *
     * <code>string primary_feed_name = 2;</code>
     *
     * @return The bytes for primaryFeedName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPrimaryFeedNameBytes() {
      java.lang.Object ref = primaryFeedName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        primaryFeedName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (primaryFeedId_ != 0L) {
        output.writeInt64(1, primaryFeedId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(primaryFeedName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, primaryFeedName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (primaryFeedId_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, primaryFeedId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(primaryFeedName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, primaryFeedName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter other =
          (com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter) obj;

      if (getPrimaryFeedId() != other.getPrimaryFeedId()) return false;
      if (!getPrimaryFeedName().equals(other.getPrimaryFeedName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PRIMARY_FEED_ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPrimaryFeedId());
      hash = (37 * hash) + PRIMARY_FEED_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getPrimaryFeedName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Merchant Center Feed filter criterion.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter)
        com.google.cloud.retail.v2alpha.MerchantCenterAccountLink
            .MerchantCenterFeedFilterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.MerchantCenterAccountLinkProto
            .internal_static_google_cloud_retail_v2alpha_MerchantCenterAccountLink_MerchantCenterFeedFilter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.MerchantCenterAccountLinkProto
            .internal_static_google_cloud_retail_v2alpha_MerchantCenterAccountLink_MerchantCenterFeedFilter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
                    .class,
                com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        primaryFeedId_ = 0L;
        primaryFeedName_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2alpha.MerchantCenterAccountLinkProto
            .internal_static_google_cloud_retail_v2alpha_MerchantCenterAccountLink_MerchantCenterFeedFilter_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
          getDefaultInstanceForType() {
        return com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
          build() {
        com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
          buildPartial() {
        com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter result =
            new com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.primaryFeedId_ = primaryFeedId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.primaryFeedName_ = primaryFeedName_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter) {
          return mergeFrom(
              (com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
              other) {
        if (other
            == com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
                .getDefaultInstance()) return this;
        if (other.getPrimaryFeedId() != 0L) {
          setPrimaryFeedId(other.getPrimaryFeedId());
        }
        if (!other.getPrimaryFeedName().isEmpty()) {
          primaryFeedName_ = other.primaryFeedName_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  primaryFeedId_ = input.readInt64();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  primaryFeedName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private long primaryFeedId_;
      /**
       *
       *
       * <pre>
       * Merchant Center primary feed ID.
       * </pre>
       *
       * <code>int64 primary_feed_id = 1;</code>
       *
       * @return The primaryFeedId.
       */
      @java.lang.Override
      public long getPrimaryFeedId() {
        return primaryFeedId_;
      }
      /**
       *
       *
       * <pre>
       * Merchant Center primary feed ID.
       * </pre>
       *
       * <code>int64 primary_feed_id = 1;</code>
       *
       * @param value The primaryFeedId to set.
       * @return This builder for chaining.
       */
      public Builder setPrimaryFeedId(long value) {

        primaryFeedId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Merchant Center primary feed ID.
       * </pre>
       *
       * <code>int64 primary_feed_id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPrimaryFeedId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        primaryFeedId_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object primaryFeedName_ = "";
      /**
       *
       *
       * <pre>
       * Merchant Center primary feed name. The name is used for the display
       * purposes only.
       * </pre>
       *
       * <code>string primary_feed_name = 2;</code>
       *
       * @return The primaryFeedName.
       */
      public java.lang.String getPrimaryFeedName() {
        java.lang.Object ref = primaryFeedName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          primaryFeedName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Merchant Center primary feed name. The name is used for the display
       * purposes only.
       * </pre>
       *
       * <code>string primary_feed_name = 2;</code>
       *
       * @return The bytes for primaryFeedName.
       */
      public com.google.protobuf.ByteString getPrimaryFeedNameBytes() {
        java.lang.Object ref = primaryFeedName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          primaryFeedName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Merchant Center primary feed name. The name is used for the display
       * purposes only.
       * </pre>
       *
       * <code>string primary_feed_name = 2;</code>
       *
       * @param value The primaryFeedName to set.
       * @return This builder for chaining.
       */
      public Builder setPrimaryFeedName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        primaryFeedName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Merchant Center primary feed name. The name is used for the display
       * purposes only.
       * </pre>
       *
       * <code>string primary_feed_name = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPrimaryFeedName() {
        primaryFeedName_ = getDefaultInstance().getPrimaryFeedName();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Merchant Center primary feed name. The name is used for the display
       * purposes only.
       * </pre>
       *
       * <code>string primary_feed_name = 2;</code>
       *
       * @param value The bytes for primaryFeedName to set.
       * @return This builder for chaining.
       */
      public Builder setPrimaryFeedNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        primaryFeedName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter)
    private static final com.google.cloud.retail.v2alpha.MerchantCenterAccountLink
            .MerchantCenterFeedFilter
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter();
    }

    public static com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MerchantCenterFeedFilter> PARSER =
        new com.google.protobuf.AbstractParser<MerchantCenterFeedFilter>() {
          @java.lang.Override
          public MerchantCenterFeedFilter parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MerchantCenterFeedFilter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MerchantCenterFeedFilter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Immutable. Full resource name of the Merchant Center Account
   * Link, such as
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/merchantCenterAccountLinks/merchant_center_account_link`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Immutable. Full resource name of the Merchant Center Account
   * Link, such as
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/merchantCenterAccountLinks/merchant_center_account_link`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Immutable.
   * [MerchantCenterAccountLink][google.cloud.retail.v2alpha.MerchantCenterAccountLink]
   * identifier, which is the final component of
   * [name][google.cloud.retail.v2alpha.MerchantCenterAccountLink.name]. This
   * field is auto generated and follows the convention:
   * `BranchId_MerchantCenterAccountId`.
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/merchantCenterAccountLinks/id_1`.
   * </pre>
   *
   * <code>
   * string id = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Immutable.
   * [MerchantCenterAccountLink][google.cloud.retail.v2alpha.MerchantCenterAccountLink]
   * identifier, which is the final component of
   * [name][google.cloud.retail.v2alpha.MerchantCenterAccountLink.name]. This
   * field is auto generated and follows the convention:
   * `BranchId_MerchantCenterAccountId`.
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/merchantCenterAccountLinks/id_1`.
   * </pre>
   *
   * <code>
   * string id = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MERCHANT_CENTER_ACCOUNT_ID_FIELD_NUMBER = 2;
  private long merchantCenterAccountId_ = 0L;
  /**
   *
   *
   * <pre>
   * Required. The linked [Merchant center account
   * id](https://developers.google.com/shopping-content/guides/accountstatuses).
   * The account must be a standalone account or a sub-account of a MCA.
   * </pre>
   *
   * <code>int64 merchant_center_account_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The merchantCenterAccountId.
   */
  @java.lang.Override
  public long getMerchantCenterAccountId() {
    return merchantCenterAccountId_;
  }

  public static final int BRANCH_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object branchId_ = "";
  /**
   *
   *
   * <pre>
   * Required. The branch id (e.g. 0/1/2) within the catalog that products from
   * merchant_center_account_id are streamed to. When updating this field, an
   * empty value will use the currently configured default branch. However,
   * changing the default branch later on won't change the linked branch here.
   *
   * A single branch id can only have one linked merchant center account id.
   * </pre>
   *
   * <code>string branch_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The branchId.
   */
  @java.lang.Override
  public java.lang.String getBranchId() {
    java.lang.Object ref = branchId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      branchId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The branch id (e.g. 0/1/2) within the catalog that products from
   * merchant_center_account_id are streamed to. When updating this field, an
   * empty value will use the currently configured default branch. However,
   * changing the default branch later on won't change the linked branch here.
   *
   * A single branch id can only have one linked merchant center account id.
   * </pre>
   *
   * <code>string branch_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for branchId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBranchIdBytes() {
    java.lang.Object ref = branchId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      branchId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FEED_LABEL_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object feedLabel_ = "";
  /**
   *
   *
   * <pre>
   * The FeedLabel used to perform filtering.
   * Note: this replaces
   * [region_id](https://developers.google.com/shopping-content/reference/rest/v2.1/products#Product.FIELDS.feed_label).
   *
   * Example value: `US`.
   * Example value: `FeedLabel1`.
   * </pre>
   *
   * <code>string feed_label = 4;</code>
   *
   * @return The feedLabel.
   */
  @java.lang.Override
  public java.lang.String getFeedLabel() {
    java.lang.Object ref = feedLabel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      feedLabel_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The FeedLabel used to perform filtering.
   * Note: this replaces
   * [region_id](https://developers.google.com/shopping-content/reference/rest/v2.1/products#Product.FIELDS.feed_label).
   *
   * Example value: `US`.
   * Example value: `FeedLabel1`.
   * </pre>
   *
   * <code>string feed_label = 4;</code>
   *
   * @return The bytes for feedLabel.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFeedLabelBytes() {
    java.lang.Object ref = feedLabel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      feedLabel_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object languageCode_ = "";
  /**
   *
   *
   * <pre>
   * Language of the title/description and other string attributes. Use language
   * tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
   * ISO 639-1.
   *
   * This specifies the language of offers in Merchant Center that will be
   * accepted. If empty, no language filtering will be performed.
   *
   * Example value: `en`.
   * </pre>
   *
   * <code>string language_code = 5;</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Language of the title/description and other string attributes. Use language
   * tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
   * ISO 639-1.
   *
   * This specifies the language of offers in Merchant Center that will be
   * accepted. If empty, no language filtering will be performed.
   *
   * Example value: `en`.
   * </pre>
   *
   * <code>string language_code = 5;</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FEED_FILTERS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter>
      feedFilters_;
  /**
   *
   *
   * <pre>
   * Criteria for the Merchant Center feeds to be ingested via the link.
   * All offers will be ingested if the list is empty.
   * Otherwise the offers will be ingested from selected feeds.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter feed_filters = 6;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter>
      getFeedFiltersList() {
    return feedFilters_;
  }
  /**
   *
   *
   * <pre>
   * Criteria for the Merchant Center feeds to be ingested via the link.
   * All offers will be ingested if the list is empty.
   * Otherwise the offers will be ingested from selected feeds.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter feed_filters = 6;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.retail.v2alpha.MerchantCenterAccountLink
                  .MerchantCenterFeedFilterOrBuilder>
      getFeedFiltersOrBuilderList() {
    return feedFilters_;
  }
  /**
   *
   *
   * <pre>
   * Criteria for the Merchant Center feeds to be ingested via the link.
   * All offers will be ingested if the list is empty.
   * Otherwise the offers will be ingested from selected feeds.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter feed_filters = 6;
   * </code>
   */
  @java.lang.Override
  public int getFeedFiltersCount() {
    return feedFilters_.size();
  }
  /**
   *
   *
   * <pre>
   * Criteria for the Merchant Center feeds to be ingested via the link.
   * All offers will be ingested if the list is empty.
   * Otherwise the offers will be ingested from selected feeds.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter feed_filters = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
      getFeedFilters(int index) {
    return feedFilters_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Criteria for the Merchant Center feeds to be ingested via the link.
   * All offers will be ingested if the list is empty.
   * Otherwise the offers will be ingested from selected feeds.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter feed_filters = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilterOrBuilder
      getFeedFiltersOrBuilder(int index) {
    return feedFilters_.get(index);
  }

  public static final int STATE_FIELD_NUMBER = 7;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Represents the state of the link.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.MerchantCenterAccountLink.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Represents the state of the link.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.MerchantCenterAccountLink.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.State getState() {
    com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.State result =
        com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.State.forNumber(state_);
    return result == null
        ? com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.State.UNRECOGNIZED
        : result;
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. GCP project ID.
   * </pre>
   *
   * <code>string project_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. GCP project ID.
   * </pre>
   *
   * <code>string project_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (merchantCenterAccountId_ != 0L) {
      output.writeInt64(2, merchantCenterAccountId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(branchId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, branchId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(feedLabel_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, feedLabel_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, languageCode_);
    }
    for (int i = 0; i < feedFilters_.size(); i++) {
      output.writeMessage(6, feedFilters_.get(i));
    }
    if (state_
        != com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.State.STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, projectId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (merchantCenterAccountId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, merchantCenterAccountId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(branchId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, branchId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(feedLabel_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, feedLabel_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, languageCode_);
    }
    for (int i = 0; i < feedFilters_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, feedFilters_.get(i));
    }
    if (state_
        != com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.State.STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, projectId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2alpha.MerchantCenterAccountLink)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2alpha.MerchantCenterAccountLink other =
        (com.google.cloud.retail.v2alpha.MerchantCenterAccountLink) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getId().equals(other.getId())) return false;
    if (getMerchantCenterAccountId() != other.getMerchantCenterAccountId()) return false;
    if (!getBranchId().equals(other.getBranchId())) return false;
    if (!getFeedLabel().equals(other.getFeedLabel())) return false;
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (!getFeedFiltersList().equals(other.getFeedFiltersList())) return false;
    if (state_ != other.state_) return false;
    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + MERCHANT_CENTER_ACCOUNT_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMerchantCenterAccountId());
    hash = (37 * hash) + BRANCH_ID_FIELD_NUMBER;
    hash = (53 * hash) + getBranchId().hashCode();
    hash = (37 * hash) + FEED_LABEL_FIELD_NUMBER;
    hash = (53 * hash) + getFeedLabel().hashCode();
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    if (getFeedFiltersCount() > 0) {
      hash = (37 * hash) + FEED_FILTERS_FIELD_NUMBER;
      hash = (53 * hash) + getFeedFiltersList().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2alpha.MerchantCenterAccountLink parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.MerchantCenterAccountLink parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.MerchantCenterAccountLink parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.MerchantCenterAccountLink parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.MerchantCenterAccountLink parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.MerchantCenterAccountLink parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.MerchantCenterAccountLink parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.MerchantCenterAccountLink parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.MerchantCenterAccountLink parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.MerchantCenterAccountLink parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.MerchantCenterAccountLink parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.MerchantCenterAccountLink parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.retail.v2alpha.MerchantCenterAccountLink prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a link between a Merchant Center account and a branch.
   * Once a link is established, products from the linked merchant center account
   * will be streamed to the linked branch.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.MerchantCenterAccountLink}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.MerchantCenterAccountLink)
      com.google.cloud.retail.v2alpha.MerchantCenterAccountLinkOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.MerchantCenterAccountLinkProto
          .internal_static_google_cloud_retail_v2alpha_MerchantCenterAccountLink_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.MerchantCenterAccountLinkProto
          .internal_static_google_cloud_retail_v2alpha_MerchantCenterAccountLink_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.class,
              com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      id_ = "";
      merchantCenterAccountId_ = 0L;
      branchId_ = "";
      feedLabel_ = "";
      languageCode_ = "";
      if (feedFiltersBuilder_ == null) {
        feedFilters_ = java.util.Collections.emptyList();
      } else {
        feedFilters_ = null;
        feedFiltersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      state_ = 0;
      projectId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2alpha.MerchantCenterAccountLinkProto
          .internal_static_google_cloud_retail_v2alpha_MerchantCenterAccountLink_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.MerchantCenterAccountLink getDefaultInstanceForType() {
      return com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.MerchantCenterAccountLink build() {
      com.google.cloud.retail.v2alpha.MerchantCenterAccountLink result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.MerchantCenterAccountLink buildPartial() {
      com.google.cloud.retail.v2alpha.MerchantCenterAccountLink result =
          new com.google.cloud.retail.v2alpha.MerchantCenterAccountLink(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.retail.v2alpha.MerchantCenterAccountLink result) {
      if (feedFiltersBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          feedFilters_ = java.util.Collections.unmodifiableList(feedFilters_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.feedFilters_ = feedFilters_;
      } else {
        result.feedFilters_ = feedFiltersBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.retail.v2alpha.MerchantCenterAccountLink result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.merchantCenterAccountId_ = merchantCenterAccountId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.branchId_ = branchId_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.feedLabel_ = feedLabel_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.languageCode_ = languageCode_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.projectId_ = projectId_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2alpha.MerchantCenterAccountLink) {
        return mergeFrom((com.google.cloud.retail.v2alpha.MerchantCenterAccountLink) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2alpha.MerchantCenterAccountLink other) {
      if (other == com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getMerchantCenterAccountId() != 0L) {
        setMerchantCenterAccountId(other.getMerchantCenterAccountId());
      }
      if (!other.getBranchId().isEmpty()) {
        branchId_ = other.branchId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getFeedLabel().isEmpty()) {
        feedLabel_ = other.feedLabel_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (feedFiltersBuilder_ == null) {
        if (!other.feedFilters_.isEmpty()) {
          if (feedFilters_.isEmpty()) {
            feedFilters_ = other.feedFilters_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureFeedFiltersIsMutable();
            feedFilters_.addAll(other.feedFilters_);
          }
          onChanged();
        }
      } else {
        if (!other.feedFilters_.isEmpty()) {
          if (feedFiltersBuilder_.isEmpty()) {
            feedFiltersBuilder_.dispose();
            feedFiltersBuilder_ = null;
            feedFilters_ = other.feedFilters_;
            bitField0_ = (bitField0_ & ~0x00000040);
            feedFiltersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFeedFiltersFieldBuilder()
                    : null;
          } else {
            feedFiltersBuilder_.addAllMessages(other.feedFilters_);
          }
        }
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                merchantCenterAccountId_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 16
            case 26:
              {
                branchId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                feedLabel_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                languageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
                    m =
                        input.readMessage(
                            com.google.cloud.retail.v2alpha.MerchantCenterAccountLink
                                .MerchantCenterFeedFilter.parser(),
                            extensionRegistry);
                if (feedFiltersBuilder_ == null) {
                  ensureFeedFiltersIsMutable();
                  feedFilters_.add(m);
                } else {
                  feedFiltersBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 56:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 56
            case 66:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 66
            case 74:
              {
                projectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Immutable. Full resource name of the Merchant Center Account
     * Link, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/merchantCenterAccountLinks/merchant_center_account_link`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. Full resource name of the Merchant Center Account
     * Link, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/merchantCenterAccountLinks/merchant_center_account_link`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. Full resource name of the Merchant Center Account
     * Link, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/merchantCenterAccountLinks/merchant_center_account_link`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. Full resource name of the Merchant Center Account
     * Link, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/merchantCenterAccountLinks/merchant_center_account_link`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. Full resource name of the Merchant Center Account
     * Link, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/merchantCenterAccountLinks/merchant_center_account_link`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Immutable.
     * [MerchantCenterAccountLink][google.cloud.retail.v2alpha.MerchantCenterAccountLink]
     * identifier, which is the final component of
     * [name][google.cloud.retail.v2alpha.MerchantCenterAccountLink.name]. This
     * field is auto generated and follows the convention:
     * `BranchId_MerchantCenterAccountId`.
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/merchantCenterAccountLinks/id_1`.
     * </pre>
     *
     * <code>
     * string id = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable.
     * [MerchantCenterAccountLink][google.cloud.retail.v2alpha.MerchantCenterAccountLink]
     * identifier, which is the final component of
     * [name][google.cloud.retail.v2alpha.MerchantCenterAccountLink.name]. This
     * field is auto generated and follows the convention:
     * `BranchId_MerchantCenterAccountId`.
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/merchantCenterAccountLinks/id_1`.
     * </pre>
     *
     * <code>
     * string id = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable.
     * [MerchantCenterAccountLink][google.cloud.retail.v2alpha.MerchantCenterAccountLink]
     * identifier, which is the final component of
     * [name][google.cloud.retail.v2alpha.MerchantCenterAccountLink.name]. This
     * field is auto generated and follows the convention:
     * `BranchId_MerchantCenterAccountId`.
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/merchantCenterAccountLinks/id_1`.
     * </pre>
     *
     * <code>
     * string id = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable.
     * [MerchantCenterAccountLink][google.cloud.retail.v2alpha.MerchantCenterAccountLink]
     * identifier, which is the final component of
     * [name][google.cloud.retail.v2alpha.MerchantCenterAccountLink.name]. This
     * field is auto generated and follows the convention:
     * `BranchId_MerchantCenterAccountId`.
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/merchantCenterAccountLinks/id_1`.
     * </pre>
     *
     * <code>
     * string id = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable.
     * [MerchantCenterAccountLink][google.cloud.retail.v2alpha.MerchantCenterAccountLink]
     * identifier, which is the final component of
     * [name][google.cloud.retail.v2alpha.MerchantCenterAccountLink.name]. This
     * field is auto generated and follows the convention:
     * `BranchId_MerchantCenterAccountId`.
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/merchantCenterAccountLinks/id_1`.
     * </pre>
     *
     * <code>
     * string id = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private long merchantCenterAccountId_;
    /**
     *
     *
     * <pre>
     * Required. The linked [Merchant center account
     * id](https://developers.google.com/shopping-content/guides/accountstatuses).
     * The account must be a standalone account or a sub-account of a MCA.
     * </pre>
     *
     * <code>int64 merchant_center_account_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The merchantCenterAccountId.
     */
    @java.lang.Override
    public long getMerchantCenterAccountId() {
      return merchantCenterAccountId_;
    }
    /**
     *
     *
     * <pre>
     * Required. The linked [Merchant center account
     * id](https://developers.google.com/shopping-content/guides/accountstatuses).
     * The account must be a standalone account or a sub-account of a MCA.
     * </pre>
     *
     * <code>int64 merchant_center_account_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The merchantCenterAccountId to set.
     * @return This builder for chaining.
     */
    public Builder setMerchantCenterAccountId(long value) {

      merchantCenterAccountId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The linked [Merchant center account
     * id](https://developers.google.com/shopping-content/guides/accountstatuses).
     * The account must be a standalone account or a sub-account of a MCA.
     * </pre>
     *
     * <code>int64 merchant_center_account_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMerchantCenterAccountId() {
      bitField0_ = (bitField0_ & ~0x00000004);
      merchantCenterAccountId_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object branchId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The branch id (e.g. 0/1/2) within the catalog that products from
     * merchant_center_account_id are streamed to. When updating this field, an
     * empty value will use the currently configured default branch. However,
     * changing the default branch later on won't change the linked branch here.
     *
     * A single branch id can only have one linked merchant center account id.
     * </pre>
     *
     * <code>string branch_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The branchId.
     */
    public java.lang.String getBranchId() {
      java.lang.Object ref = branchId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        branchId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The branch id (e.g. 0/1/2) within the catalog that products from
     * merchant_center_account_id are streamed to. When updating this field, an
     * empty value will use the currently configured default branch. However,
     * changing the default branch later on won't change the linked branch here.
     *
     * A single branch id can only have one linked merchant center account id.
     * </pre>
     *
     * <code>string branch_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for branchId.
     */
    public com.google.protobuf.ByteString getBranchIdBytes() {
      java.lang.Object ref = branchId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        branchId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The branch id (e.g. 0/1/2) within the catalog that products from
     * merchant_center_account_id are streamed to. When updating this field, an
     * empty value will use the currently configured default branch. However,
     * changing the default branch later on won't change the linked branch here.
     *
     * A single branch id can only have one linked merchant center account id.
     * </pre>
     *
     * <code>string branch_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The branchId to set.
     * @return This builder for chaining.
     */
    public Builder setBranchId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      branchId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The branch id (e.g. 0/1/2) within the catalog that products from
     * merchant_center_account_id are streamed to. When updating this field, an
     * empty value will use the currently configured default branch. However,
     * changing the default branch later on won't change the linked branch here.
     *
     * A single branch id can only have one linked merchant center account id.
     * </pre>
     *
     * <code>string branch_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBranchId() {
      branchId_ = getDefaultInstance().getBranchId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The branch id (e.g. 0/1/2) within the catalog that products from
     * merchant_center_account_id are streamed to. When updating this field, an
     * empty value will use the currently configured default branch. However,
     * changing the default branch later on won't change the linked branch here.
     *
     * A single branch id can only have one linked merchant center account id.
     * </pre>
     *
     * <code>string branch_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for branchId to set.
     * @return This builder for chaining.
     */
    public Builder setBranchIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      branchId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object feedLabel_ = "";
    /**
     *
     *
     * <pre>
     * The FeedLabel used to perform filtering.
     * Note: this replaces
     * [region_id](https://developers.google.com/shopping-content/reference/rest/v2.1/products#Product.FIELDS.feed_label).
     *
     * Example value: `US`.
     * Example value: `FeedLabel1`.
     * </pre>
     *
     * <code>string feed_label = 4;</code>
     *
     * @return The feedLabel.
     */
    public java.lang.String getFeedLabel() {
      java.lang.Object ref = feedLabel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        feedLabel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The FeedLabel used to perform filtering.
     * Note: this replaces
     * [region_id](https://developers.google.com/shopping-content/reference/rest/v2.1/products#Product.FIELDS.feed_label).
     *
     * Example value: `US`.
     * Example value: `FeedLabel1`.
     * </pre>
     *
     * <code>string feed_label = 4;</code>
     *
     * @return The bytes for feedLabel.
     */
    public com.google.protobuf.ByteString getFeedLabelBytes() {
      java.lang.Object ref = feedLabel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        feedLabel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The FeedLabel used to perform filtering.
     * Note: this replaces
     * [region_id](https://developers.google.com/shopping-content/reference/rest/v2.1/products#Product.FIELDS.feed_label).
     *
     * Example value: `US`.
     * Example value: `FeedLabel1`.
     * </pre>
     *
     * <code>string feed_label = 4;</code>
     *
     * @param value The feedLabel to set.
     * @return This builder for chaining.
     */
    public Builder setFeedLabel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      feedLabel_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The FeedLabel used to perform filtering.
     * Note: this replaces
     * [region_id](https://developers.google.com/shopping-content/reference/rest/v2.1/products#Product.FIELDS.feed_label).
     *
     * Example value: `US`.
     * Example value: `FeedLabel1`.
     * </pre>
     *
     * <code>string feed_label = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFeedLabel() {
      feedLabel_ = getDefaultInstance().getFeedLabel();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The FeedLabel used to perform filtering.
     * Note: this replaces
     * [region_id](https://developers.google.com/shopping-content/reference/rest/v2.1/products#Product.FIELDS.feed_label).
     *
     * Example value: `US`.
     * Example value: `FeedLabel1`.
     * </pre>
     *
     * <code>string feed_label = 4;</code>
     *
     * @param value The bytes for feedLabel to set.
     * @return This builder for chaining.
     */
    public Builder setFeedLabelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      feedLabel_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * Language of the title/description and other string attributes. Use language
     * tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     * ISO 639-1.
     *
     * This specifies the language of offers in Merchant Center that will be
     * accepted. If empty, no language filtering will be performed.
     *
     * Example value: `en`.
     * </pre>
     *
     * <code>string language_code = 5;</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Language of the title/description and other string attributes. Use language
     * tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     * ISO 639-1.
     *
     * This specifies the language of offers in Merchant Center that will be
     * accepted. If empty, no language filtering will be performed.
     *
     * Example value: `en`.
     * </pre>
     *
     * <code>string language_code = 5;</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Language of the title/description and other string attributes. Use language
     * tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     * ISO 639-1.
     *
     * This specifies the language of offers in Merchant Center that will be
     * accepted. If empty, no language filtering will be performed.
     *
     * Example value: `en`.
     * </pre>
     *
     * <code>string language_code = 5;</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      languageCode_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Language of the title/description and other string attributes. Use language
     * tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     * ISO 639-1.
     *
     * This specifies the language of offers in Merchant Center that will be
     * accepted. If empty, no language filtering will be performed.
     *
     * Example value: `en`.
     * </pre>
     *
     * <code>string language_code = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {
      languageCode_ = getDefaultInstance().getLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Language of the title/description and other string attributes. Use language
     * tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     * ISO 639-1.
     *
     * This specifies the language of offers in Merchant Center that will be
     * accepted. If empty, no language filtering will be performed.
     *
     * Example value: `en`.
     * </pre>
     *
     * <code>string language_code = 5;</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      languageCode_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter>
        feedFilters_ = java.util.Collections.emptyList();

    private void ensureFeedFiltersIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        feedFilters_ =
            new java.util.ArrayList<
                com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter>(
                feedFilters_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter,
            com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
                .Builder,
            com.google.cloud.retail.v2alpha.MerchantCenterAccountLink
                .MerchantCenterFeedFilterOrBuilder>
        feedFiltersBuilder_;

    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter feed_filters = 6;
     * </code>
     */
    public java.util.List<
            com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter>
        getFeedFiltersList() {
      if (feedFiltersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(feedFilters_);
      } else {
        return feedFiltersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter feed_filters = 6;
     * </code>
     */
    public int getFeedFiltersCount() {
      if (feedFiltersBuilder_ == null) {
        return feedFilters_.size();
      } else {
        return feedFiltersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter feed_filters = 6;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
        getFeedFilters(int index) {
      if (feedFiltersBuilder_ == null) {
        return feedFilters_.get(index);
      } else {
        return feedFiltersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter feed_filters = 6;
     * </code>
     */
    public Builder setFeedFilters(
        int index,
        com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter value) {
      if (feedFiltersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeedFiltersIsMutable();
        feedFilters_.set(index, value);
        onChanged();
      } else {
        feedFiltersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter feed_filters = 6;
     * </code>
     */
    public Builder setFeedFilters(
        int index,
        com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter.Builder
            builderForValue) {
      if (feedFiltersBuilder_ == null) {
        ensureFeedFiltersIsMutable();
        feedFilters_.set(index, builderForValue.build());
        onChanged();
      } else {
        feedFiltersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter feed_filters = 6;
     * </code>
     */
    public Builder addFeedFilters(
        com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter value) {
      if (feedFiltersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeedFiltersIsMutable();
        feedFilters_.add(value);
        onChanged();
      } else {
        feedFiltersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter feed_filters = 6;
     * </code>
     */
    public Builder addFeedFilters(
        int index,
        com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter value) {
      if (feedFiltersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeedFiltersIsMutable();
        feedFilters_.add(index, value);
        onChanged();
      } else {
        feedFiltersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter feed_filters = 6;
     * </code>
     */
    public Builder addFeedFilters(
        com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter.Builder
            builderForValue) {
      if (feedFiltersBuilder_ == null) {
        ensureFeedFiltersIsMutable();
        feedFilters_.add(builderForValue.build());
        onChanged();
      } else {
        feedFiltersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter feed_filters = 6;
     * </code>
     */
    public Builder addFeedFilters(
        int index,
        com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter.Builder
            builderForValue) {
      if (feedFiltersBuilder_ == null) {
        ensureFeedFiltersIsMutable();
        feedFilters_.add(index, builderForValue.build());
        onChanged();
      } else {
        feedFiltersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter feed_filters = 6;
     * </code>
     */
    public Builder addAllFeedFilters(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.retail.v2alpha.MerchantCenterAccountLink
                        .MerchantCenterFeedFilter>
            values) {
      if (feedFiltersBuilder_ == null) {
        ensureFeedFiltersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, feedFilters_);
        onChanged();
      } else {
        feedFiltersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter feed_filters = 6;
     * </code>
     */
    public Builder clearFeedFilters() {
      if (feedFiltersBuilder_ == null) {
        feedFilters_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        feedFiltersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter feed_filters = 6;
     * </code>
     */
    public Builder removeFeedFilters(int index) {
      if (feedFiltersBuilder_ == null) {
        ensureFeedFiltersIsMutable();
        feedFilters_.remove(index);
        onChanged();
      } else {
        feedFiltersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter feed_filters = 6;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
            .Builder
        getFeedFiltersBuilder(int index) {
      return getFeedFiltersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter feed_filters = 6;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.MerchantCenterAccountLink
            .MerchantCenterFeedFilterOrBuilder
        getFeedFiltersOrBuilder(int index) {
      if (feedFiltersBuilder_ == null) {
        return feedFilters_.get(index);
      } else {
        return feedFiltersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter feed_filters = 6;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.retail.v2alpha.MerchantCenterAccountLink
                    .MerchantCenterFeedFilterOrBuilder>
        getFeedFiltersOrBuilderList() {
      if (feedFiltersBuilder_ != null) {
        return feedFiltersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(feedFilters_);
      }
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter feed_filters = 6;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
            .Builder
        addFeedFiltersBuilder() {
      return getFeedFiltersFieldBuilder()
          .addBuilder(
              com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter feed_filters = 6;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
            .Builder
        addFeedFiltersBuilder(int index) {
      return getFeedFiltersFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter feed_filters = 6;
     * </code>
     */
    public java.util.List<
            com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
                .Builder>
        getFeedFiltersBuilderList() {
      return getFeedFiltersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter,
            com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
                .Builder,
            com.google.cloud.retail.v2alpha.MerchantCenterAccountLink
                .MerchantCenterFeedFilterOrBuilder>
        getFeedFiltersFieldBuilder() {
      if (feedFiltersBuilder_ == null) {
        feedFiltersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter,
                com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.MerchantCenterFeedFilter
                    .Builder,
                com.google.cloud.retail.v2alpha.MerchantCenterAccountLink
                    .MerchantCenterFeedFilterOrBuilder>(
                feedFilters_, ((bitField0_ & 0x00000040) != 0), getParentForChildren(), isClean());
        feedFilters_ = null;
      }
      return feedFiltersBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Represents the state of the link.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.MerchantCenterAccountLink.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents the state of the link.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.MerchantCenterAccountLink.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents the state of the link.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.MerchantCenterAccountLink.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.State getState() {
      com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.State result =
          com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.State.forNumber(state_);
      return result == null
          ? com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents the state of the link.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.MerchantCenterAccountLink.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.retail.v2alpha.MerchantCenterAccountLink.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents the state of the link.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.MerchantCenterAccountLink.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000080);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. GCP project ID.
     * </pre>
     *
     * <code>string project_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. GCP project ID.
     * </pre>
     *
     * <code>string project_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. GCP project ID.
     * </pre>
     *
     * <code>string project_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectId_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. GCP project ID.
     * </pre>
     *
     * <code>string project_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {
      projectId_ = getDefaultInstance().getProjectId();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. GCP project ID.
     * </pre>
     *
     * <code>string project_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectId_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.MerchantCenterAccountLink)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.MerchantCenterAccountLink)
  private static final com.google.cloud.retail.v2alpha.MerchantCenterAccountLink DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.MerchantCenterAccountLink();
  }

  public static com.google.cloud.retail.v2alpha.MerchantCenterAccountLink getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MerchantCenterAccountLink> PARSER =
      new com.google.protobuf.AbstractParser<MerchantCenterAccountLink>() {
        @java.lang.Override
        public MerchantCenterAccountLink parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MerchantCenterAccountLink> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MerchantCenterAccountLink> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2alpha.MerchantCenterAccountLink getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
