/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2alpha/catalog.proto

package com.google.cloud.retail.v2alpha;

/**
 *
 *
 * <pre>
 * Represents a link between a Merchant Center account and a branch.
 * Once a link is established, products from the linked merchant center account
 * will be streamed to the linked branch.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2alpha.MerchantCenterLink}
 */
public final class MerchantCenterLink extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.MerchantCenterLink)
    MerchantCenterLinkOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MerchantCenterLink.newBuilder() to construct.
  private MerchantCenterLink(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MerchantCenterLink() {
    branchId_ = "";
    destinations_ = com.google.protobuf.LazyStringArrayList.emptyList();
    regionCode_ = "";
    languageCode_ = "";
    feeds_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MerchantCenterLink();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2alpha.CatalogProto
        .internal_static_google_cloud_retail_v2alpha_MerchantCenterLink_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2alpha.CatalogProto
        .internal_static_google_cloud_retail_v2alpha_MerchantCenterLink_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2alpha.MerchantCenterLink.class,
            com.google.cloud.retail.v2alpha.MerchantCenterLink.Builder.class);
  }

  public static final int MERCHANT_CENTER_ACCOUNT_ID_FIELD_NUMBER = 1;
  private long merchantCenterAccountId_ = 0L;
  /**
   *
   *
   * <pre>
   * Required. The linked [Merchant center account
   * ID](https://developers.google.com/shopping-content/guides/accountstatuses).
   * The account must be a standalone account or a sub-account of a MCA.
   * </pre>
   *
   * <code>int64 merchant_center_account_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The merchantCenterAccountId.
   */
  @java.lang.Override
  public long getMerchantCenterAccountId() {
    return merchantCenterAccountId_;
  }

  public static final int BRANCH_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object branchId_ = "";
  /**
   *
   *
   * <pre>
   * The branch ID (e.g. 0/1/2) within this catalog that products from
   * merchant_center_account_id are streamed to. When updating this field, an
   * empty value will use the currently configured default branch. However,
   * changing the default branch later on won't change the linked branch here.
   *
   * A single branch ID can only have one linked merchant center account ID.
   * </pre>
   *
   * <code>string branch_id = 2;</code>
   *
   * @return The branchId.
   */
  @java.lang.Override
  public java.lang.String getBranchId() {
    java.lang.Object ref = branchId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      branchId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The branch ID (e.g. 0/1/2) within this catalog that products from
   * merchant_center_account_id are streamed to. When updating this field, an
   * empty value will use the currently configured default branch. However,
   * changing the default branch later on won't change the linked branch here.
   *
   * A single branch ID can only have one linked merchant center account ID.
   * </pre>
   *
   * <code>string branch_id = 2;</code>
   *
   * @return The bytes for branchId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBranchIdBytes() {
    java.lang.Object ref = branchId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      branchId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESTINATIONS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList destinations_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * String representing the destination to import for, all if left empty.
   * List of possible values is given in [Included
   * destination](https://support.google.com/merchants/answer/7501026).
   * List of allowed string values:
   * "Shopping_ads", "Buy_on_google_listings", "Display_ads", "Local_inventory
   * _ads", "Free_listings", "Free_local_listings"
   * NOTE: The string values are case sensitive.
   * </pre>
   *
   * <code>repeated string destinations = 3;</code>
   *
   * @return A list containing the destinations.
   */
  public com.google.protobuf.ProtocolStringList getDestinationsList() {
    return destinations_;
  }
  /**
   *
   *
   * <pre>
   * String representing the destination to import for, all if left empty.
   * List of possible values is given in [Included
   * destination](https://support.google.com/merchants/answer/7501026).
   * List of allowed string values:
   * "Shopping_ads", "Buy_on_google_listings", "Display_ads", "Local_inventory
   * _ads", "Free_listings", "Free_local_listings"
   * NOTE: The string values are case sensitive.
   * </pre>
   *
   * <code>repeated string destinations = 3;</code>
   *
   * @return The count of destinations.
   */
  public int getDestinationsCount() {
    return destinations_.size();
  }
  /**
   *
   *
   * <pre>
   * String representing the destination to import for, all if left empty.
   * List of possible values is given in [Included
   * destination](https://support.google.com/merchants/answer/7501026).
   * List of allowed string values:
   * "Shopping_ads", "Buy_on_google_listings", "Display_ads", "Local_inventory
   * _ads", "Free_listings", "Free_local_listings"
   * NOTE: The string values are case sensitive.
   * </pre>
   *
   * <code>repeated string destinations = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The destinations at the given index.
   */
  public java.lang.String getDestinations(int index) {
    return destinations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * String representing the destination to import for, all if left empty.
   * List of possible values is given in [Included
   * destination](https://support.google.com/merchants/answer/7501026).
   * List of allowed string values:
   * "Shopping_ads", "Buy_on_google_listings", "Display_ads", "Local_inventory
   * _ads", "Free_listings", "Free_local_listings"
   * NOTE: The string values are case sensitive.
   * </pre>
   *
   * <code>repeated string destinations = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the destinations at the given index.
   */
  public com.google.protobuf.ByteString getDestinationsBytes(int index) {
    return destinations_.getByteString(index);
  }

  public static final int REGION_CODE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object regionCode_ = "";
  /**
   *
   *
   * <pre>
   * Region code of offers to accept. 2-letter Uppercase ISO 3166-1 alpha-2
   * code. List of values can be found
   * [here](https://www.iana.org/assignments/language-subtag-registry/language-subtag-registry)
   * under the `region` tag. If left blank no region filtering will be
   * performed.
   *
   * Example value: `US`.
   * </pre>
   *
   * <code>string region_code = 4;</code>
   *
   * @return The regionCode.
   */
  @java.lang.Override
  public java.lang.String getRegionCode() {
    java.lang.Object ref = regionCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      regionCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Region code of offers to accept. 2-letter Uppercase ISO 3166-1 alpha-2
   * code. List of values can be found
   * [here](https://www.iana.org/assignments/language-subtag-registry/language-subtag-registry)
   * under the `region` tag. If left blank no region filtering will be
   * performed.
   *
   * Example value: `US`.
   * </pre>
   *
   * <code>string region_code = 4;</code>
   *
   * @return The bytes for regionCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionCodeBytes() {
    java.lang.Object ref = regionCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      regionCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object languageCode_ = "";
  /**
   *
   *
   * <pre>
   * Language of the title/description and other string attributes. Use language
   * tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
   * ISO 639-1.
   *
   * This specifies the language of offers in Merchant Center that will be
   * accepted. If  empty no language filtering will be performed.
   *
   * Example value: `en`.
   * </pre>
   *
   * <code>string language_code = 5;</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Language of the title/description and other string attributes. Use language
   * tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
   * ISO 639-1.
   *
   * This specifies the language of offers in Merchant Center that will be
   * accepted. If  empty no language filtering will be performed.
   *
   * Example value: `en`.
   * </pre>
   *
   * <code>string language_code = 5;</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FEEDS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter> feeds_;
  /**
   *
   *
   * <pre>
   * Criteria for the Merchant Center feeds to be ingested via the link.
   * All offers will be ingested if the list is empty.
   * Otherwise the offers will be ingested from selected feeds.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.MerchantCenterFeedFilter feeds = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter> getFeedsList() {
    return feeds_;
  }
  /**
   *
   *
   * <pre>
   * Criteria for the Merchant Center feeds to be ingested via the link.
   * All offers will be ingested if the list is empty.
   * Otherwise the offers will be ingested from selected feeds.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.MerchantCenterFeedFilter feeds = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.retail.v2alpha.MerchantCenterFeedFilterOrBuilder>
      getFeedsOrBuilderList() {
    return feeds_;
  }
  /**
   *
   *
   * <pre>
   * Criteria for the Merchant Center feeds to be ingested via the link.
   * All offers will be ingested if the list is empty.
   * Otherwise the offers will be ingested from selected feeds.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.MerchantCenterFeedFilter feeds = 6;</code>
   */
  @java.lang.Override
  public int getFeedsCount() {
    return feeds_.size();
  }
  /**
   *
   *
   * <pre>
   * Criteria for the Merchant Center feeds to be ingested via the link.
   * All offers will be ingested if the list is empty.
   * Otherwise the offers will be ingested from selected feeds.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.MerchantCenterFeedFilter feeds = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter getFeeds(int index) {
    return feeds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Criteria for the Merchant Center feeds to be ingested via the link.
   * All offers will be ingested if the list is empty.
   * Otherwise the offers will be ingested from selected feeds.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.MerchantCenterFeedFilter feeds = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.MerchantCenterFeedFilterOrBuilder getFeedsOrBuilder(
      int index) {
    return feeds_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (merchantCenterAccountId_ != 0L) {
      output.writeInt64(1, merchantCenterAccountId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(branchId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, branchId_);
    }
    for (int i = 0; i < destinations_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, destinations_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(regionCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, regionCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, languageCode_);
    }
    for (int i = 0; i < feeds_.size(); i++) {
      output.writeMessage(6, feeds_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (merchantCenterAccountId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, merchantCenterAccountId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(branchId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, branchId_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < destinations_.size(); i++) {
        dataSize += computeStringSizeNoTag(destinations_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getDestinationsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(regionCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, regionCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, languageCode_);
    }
    for (int i = 0; i < feeds_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, feeds_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2alpha.MerchantCenterLink)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2alpha.MerchantCenterLink other =
        (com.google.cloud.retail.v2alpha.MerchantCenterLink) obj;

    if (getMerchantCenterAccountId() != other.getMerchantCenterAccountId()) return false;
    if (!getBranchId().equals(other.getBranchId())) return false;
    if (!getDestinationsList().equals(other.getDestinationsList())) return false;
    if (!getRegionCode().equals(other.getRegionCode())) return false;
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (!getFeedsList().equals(other.getFeedsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MERCHANT_CENTER_ACCOUNT_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMerchantCenterAccountId());
    hash = (37 * hash) + BRANCH_ID_FIELD_NUMBER;
    hash = (53 * hash) + getBranchId().hashCode();
    if (getDestinationsCount() > 0) {
      hash = (37 * hash) + DESTINATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getDestinationsList().hashCode();
    }
    hash = (37 * hash) + REGION_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getRegionCode().hashCode();
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    if (getFeedsCount() > 0) {
      hash = (37 * hash) + FEEDS_FIELD_NUMBER;
      hash = (53 * hash) + getFeedsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2alpha.MerchantCenterLink parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.MerchantCenterLink parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.MerchantCenterLink parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.MerchantCenterLink parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.MerchantCenterLink parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.MerchantCenterLink parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.MerchantCenterLink parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.MerchantCenterLink parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.MerchantCenterLink parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.MerchantCenterLink parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.MerchantCenterLink parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.MerchantCenterLink parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2alpha.MerchantCenterLink prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a link between a Merchant Center account and a branch.
   * Once a link is established, products from the linked merchant center account
   * will be streamed to the linked branch.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.MerchantCenterLink}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.MerchantCenterLink)
      com.google.cloud.retail.v2alpha.MerchantCenterLinkOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.CatalogProto
          .internal_static_google_cloud_retail_v2alpha_MerchantCenterLink_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.CatalogProto
          .internal_static_google_cloud_retail_v2alpha_MerchantCenterLink_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.MerchantCenterLink.class,
              com.google.cloud.retail.v2alpha.MerchantCenterLink.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2alpha.MerchantCenterLink.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      merchantCenterAccountId_ = 0L;
      branchId_ = "";
      destinations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      regionCode_ = "";
      languageCode_ = "";
      if (feedsBuilder_ == null) {
        feeds_ = java.util.Collections.emptyList();
      } else {
        feeds_ = null;
        feedsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2alpha.CatalogProto
          .internal_static_google_cloud_retail_v2alpha_MerchantCenterLink_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.MerchantCenterLink getDefaultInstanceForType() {
      return com.google.cloud.retail.v2alpha.MerchantCenterLink.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.MerchantCenterLink build() {
      com.google.cloud.retail.v2alpha.MerchantCenterLink result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.MerchantCenterLink buildPartial() {
      com.google.cloud.retail.v2alpha.MerchantCenterLink result =
          new com.google.cloud.retail.v2alpha.MerchantCenterLink(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.retail.v2alpha.MerchantCenterLink result) {
      if (feedsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          feeds_ = java.util.Collections.unmodifiableList(feeds_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.feeds_ = feeds_;
      } else {
        result.feeds_ = feedsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.retail.v2alpha.MerchantCenterLink result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.merchantCenterAccountId_ = merchantCenterAccountId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.branchId_ = branchId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        destinations_.makeImmutable();
        result.destinations_ = destinations_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.regionCode_ = regionCode_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.languageCode_ = languageCode_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2alpha.MerchantCenterLink) {
        return mergeFrom((com.google.cloud.retail.v2alpha.MerchantCenterLink) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2alpha.MerchantCenterLink other) {
      if (other == com.google.cloud.retail.v2alpha.MerchantCenterLink.getDefaultInstance())
        return this;
      if (other.getMerchantCenterAccountId() != 0L) {
        setMerchantCenterAccountId(other.getMerchantCenterAccountId());
      }
      if (!other.getBranchId().isEmpty()) {
        branchId_ = other.branchId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.destinations_.isEmpty()) {
        if (destinations_.isEmpty()) {
          destinations_ = other.destinations_;
          bitField0_ |= 0x00000004;
        } else {
          ensureDestinationsIsMutable();
          destinations_.addAll(other.destinations_);
        }
        onChanged();
      }
      if (!other.getRegionCode().isEmpty()) {
        regionCode_ = other.regionCode_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (feedsBuilder_ == null) {
        if (!other.feeds_.isEmpty()) {
          if (feeds_.isEmpty()) {
            feeds_ = other.feeds_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureFeedsIsMutable();
            feeds_.addAll(other.feeds_);
          }
          onChanged();
        }
      } else {
        if (!other.feeds_.isEmpty()) {
          if (feedsBuilder_.isEmpty()) {
            feedsBuilder_.dispose();
            feedsBuilder_ = null;
            feeds_ = other.feeds_;
            bitField0_ = (bitField0_ & ~0x00000020);
            feedsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFeedsFieldBuilder()
                    : null;
          } else {
            feedsBuilder_.addAllMessages(other.feeds_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                merchantCenterAccountId_ = input.readInt64();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                branchId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDestinationsIsMutable();
                destinations_.add(s);
                break;
              } // case 26
            case 34:
              {
                regionCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                languageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter m =
                    input.readMessage(
                        com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter.parser(),
                        extensionRegistry);
                if (feedsBuilder_ == null) {
                  ensureFeedsIsMutable();
                  feeds_.add(m);
                } else {
                  feedsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private long merchantCenterAccountId_;
    /**
     *
     *
     * <pre>
     * Required. The linked [Merchant center account
     * ID](https://developers.google.com/shopping-content/guides/accountstatuses).
     * The account must be a standalone account or a sub-account of a MCA.
     * </pre>
     *
     * <code>int64 merchant_center_account_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The merchantCenterAccountId.
     */
    @java.lang.Override
    public long getMerchantCenterAccountId() {
      return merchantCenterAccountId_;
    }
    /**
     *
     *
     * <pre>
     * Required. The linked [Merchant center account
     * ID](https://developers.google.com/shopping-content/guides/accountstatuses).
     * The account must be a standalone account or a sub-account of a MCA.
     * </pre>
     *
     * <code>int64 merchant_center_account_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The merchantCenterAccountId to set.
     * @return This builder for chaining.
     */
    public Builder setMerchantCenterAccountId(long value) {

      merchantCenterAccountId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The linked [Merchant center account
     * ID](https://developers.google.com/shopping-content/guides/accountstatuses).
     * The account must be a standalone account or a sub-account of a MCA.
     * </pre>
     *
     * <code>int64 merchant_center_account_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMerchantCenterAccountId() {
      bitField0_ = (bitField0_ & ~0x00000001);
      merchantCenterAccountId_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object branchId_ = "";
    /**
     *
     *
     * <pre>
     * The branch ID (e.g. 0/1/2) within this catalog that products from
     * merchant_center_account_id are streamed to. When updating this field, an
     * empty value will use the currently configured default branch. However,
     * changing the default branch later on won't change the linked branch here.
     *
     * A single branch ID can only have one linked merchant center account ID.
     * </pre>
     *
     * <code>string branch_id = 2;</code>
     *
     * @return The branchId.
     */
    public java.lang.String getBranchId() {
      java.lang.Object ref = branchId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        branchId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The branch ID (e.g. 0/1/2) within this catalog that products from
     * merchant_center_account_id are streamed to. When updating this field, an
     * empty value will use the currently configured default branch. However,
     * changing the default branch later on won't change the linked branch here.
     *
     * A single branch ID can only have one linked merchant center account ID.
     * </pre>
     *
     * <code>string branch_id = 2;</code>
     *
     * @return The bytes for branchId.
     */
    public com.google.protobuf.ByteString getBranchIdBytes() {
      java.lang.Object ref = branchId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        branchId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The branch ID (e.g. 0/1/2) within this catalog that products from
     * merchant_center_account_id are streamed to. When updating this field, an
     * empty value will use the currently configured default branch. However,
     * changing the default branch later on won't change the linked branch here.
     *
     * A single branch ID can only have one linked merchant center account ID.
     * </pre>
     *
     * <code>string branch_id = 2;</code>
     *
     * @param value The branchId to set.
     * @return This builder for chaining.
     */
    public Builder setBranchId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      branchId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The branch ID (e.g. 0/1/2) within this catalog that products from
     * merchant_center_account_id are streamed to. When updating this field, an
     * empty value will use the currently configured default branch. However,
     * changing the default branch later on won't change the linked branch here.
     *
     * A single branch ID can only have one linked merchant center account ID.
     * </pre>
     *
     * <code>string branch_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBranchId() {
      branchId_ = getDefaultInstance().getBranchId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The branch ID (e.g. 0/1/2) within this catalog that products from
     * merchant_center_account_id are streamed to. When updating this field, an
     * empty value will use the currently configured default branch. However,
     * changing the default branch later on won't change the linked branch here.
     *
     * A single branch ID can only have one linked merchant center account ID.
     * </pre>
     *
     * <code>string branch_id = 2;</code>
     *
     * @param value The bytes for branchId to set.
     * @return This builder for chaining.
     */
    public Builder setBranchIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      branchId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList destinations_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureDestinationsIsMutable() {
      if (!destinations_.isModifiable()) {
        destinations_ = new com.google.protobuf.LazyStringArrayList(destinations_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * String representing the destination to import for, all if left empty.
     * List of possible values is given in [Included
     * destination](https://support.google.com/merchants/answer/7501026).
     * List of allowed string values:
     * "Shopping_ads", "Buy_on_google_listings", "Display_ads", "Local_inventory
     * _ads", "Free_listings", "Free_local_listings"
     * NOTE: The string values are case sensitive.
     * </pre>
     *
     * <code>repeated string destinations = 3;</code>
     *
     * @return A list containing the destinations.
     */
    public com.google.protobuf.ProtocolStringList getDestinationsList() {
      destinations_.makeImmutable();
      return destinations_;
    }
    /**
     *
     *
     * <pre>
     * String representing the destination to import for, all if left empty.
     * List of possible values is given in [Included
     * destination](https://support.google.com/merchants/answer/7501026).
     * List of allowed string values:
     * "Shopping_ads", "Buy_on_google_listings", "Display_ads", "Local_inventory
     * _ads", "Free_listings", "Free_local_listings"
     * NOTE: The string values are case sensitive.
     * </pre>
     *
     * <code>repeated string destinations = 3;</code>
     *
     * @return The count of destinations.
     */
    public int getDestinationsCount() {
      return destinations_.size();
    }
    /**
     *
     *
     * <pre>
     * String representing the destination to import for, all if left empty.
     * List of possible values is given in [Included
     * destination](https://support.google.com/merchants/answer/7501026).
     * List of allowed string values:
     * "Shopping_ads", "Buy_on_google_listings", "Display_ads", "Local_inventory
     * _ads", "Free_listings", "Free_local_listings"
     * NOTE: The string values are case sensitive.
     * </pre>
     *
     * <code>repeated string destinations = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The destinations at the given index.
     */
    public java.lang.String getDestinations(int index) {
      return destinations_.get(index);
    }
    /**
     *
     *
     * <pre>
     * String representing the destination to import for, all if left empty.
     * List of possible values is given in [Included
     * destination](https://support.google.com/merchants/answer/7501026).
     * List of allowed string values:
     * "Shopping_ads", "Buy_on_google_listings", "Display_ads", "Local_inventory
     * _ads", "Free_listings", "Free_local_listings"
     * NOTE: The string values are case sensitive.
     * </pre>
     *
     * <code>repeated string destinations = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the destinations at the given index.
     */
    public com.google.protobuf.ByteString getDestinationsBytes(int index) {
      return destinations_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * String representing the destination to import for, all if left empty.
     * List of possible values is given in [Included
     * destination](https://support.google.com/merchants/answer/7501026).
     * List of allowed string values:
     * "Shopping_ads", "Buy_on_google_listings", "Display_ads", "Local_inventory
     * _ads", "Free_listings", "Free_local_listings"
     * NOTE: The string values are case sensitive.
     * </pre>
     *
     * <code>repeated string destinations = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The destinations to set.
     * @return This builder for chaining.
     */
    public Builder setDestinations(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDestinationsIsMutable();
      destinations_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * String representing the destination to import for, all if left empty.
     * List of possible values is given in [Included
     * destination](https://support.google.com/merchants/answer/7501026).
     * List of allowed string values:
     * "Shopping_ads", "Buy_on_google_listings", "Display_ads", "Local_inventory
     * _ads", "Free_listings", "Free_local_listings"
     * NOTE: The string values are case sensitive.
     * </pre>
     *
     * <code>repeated string destinations = 3;</code>
     *
     * @param value The destinations to add.
     * @return This builder for chaining.
     */
    public Builder addDestinations(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDestinationsIsMutable();
      destinations_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * String representing the destination to import for, all if left empty.
     * List of possible values is given in [Included
     * destination](https://support.google.com/merchants/answer/7501026).
     * List of allowed string values:
     * "Shopping_ads", "Buy_on_google_listings", "Display_ads", "Local_inventory
     * _ads", "Free_listings", "Free_local_listings"
     * NOTE: The string values are case sensitive.
     * </pre>
     *
     * <code>repeated string destinations = 3;</code>
     *
     * @param values The destinations to add.
     * @return This builder for chaining.
     */
    public Builder addAllDestinations(java.lang.Iterable<java.lang.String> values) {
      ensureDestinationsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, destinations_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * String representing the destination to import for, all if left empty.
     * List of possible values is given in [Included
     * destination](https://support.google.com/merchants/answer/7501026).
     * List of allowed string values:
     * "Shopping_ads", "Buy_on_google_listings", "Display_ads", "Local_inventory
     * _ads", "Free_listings", "Free_local_listings"
     * NOTE: The string values are case sensitive.
     * </pre>
     *
     * <code>repeated string destinations = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestinations() {
      destinations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * String representing the destination to import for, all if left empty.
     * List of possible values is given in [Included
     * destination](https://support.google.com/merchants/answer/7501026).
     * List of allowed string values:
     * "Shopping_ads", "Buy_on_google_listings", "Display_ads", "Local_inventory
     * _ads", "Free_listings", "Free_local_listings"
     * NOTE: The string values are case sensitive.
     * </pre>
     *
     * <code>repeated string destinations = 3;</code>
     *
     * @param value The bytes of the destinations to add.
     * @return This builder for chaining.
     */
    public Builder addDestinationsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDestinationsIsMutable();
      destinations_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object regionCode_ = "";
    /**
     *
     *
     * <pre>
     * Region code of offers to accept. 2-letter Uppercase ISO 3166-1 alpha-2
     * code. List of values can be found
     * [here](https://www.iana.org/assignments/language-subtag-registry/language-subtag-registry)
     * under the `region` tag. If left blank no region filtering will be
     * performed.
     *
     * Example value: `US`.
     * </pre>
     *
     * <code>string region_code = 4;</code>
     *
     * @return The regionCode.
     */
    public java.lang.String getRegionCode() {
      java.lang.Object ref = regionCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        regionCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Region code of offers to accept. 2-letter Uppercase ISO 3166-1 alpha-2
     * code. List of values can be found
     * [here](https://www.iana.org/assignments/language-subtag-registry/language-subtag-registry)
     * under the `region` tag. If left blank no region filtering will be
     * performed.
     *
     * Example value: `US`.
     * </pre>
     *
     * <code>string region_code = 4;</code>
     *
     * @return The bytes for regionCode.
     */
    public com.google.protobuf.ByteString getRegionCodeBytes() {
      java.lang.Object ref = regionCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        regionCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Region code of offers to accept. 2-letter Uppercase ISO 3166-1 alpha-2
     * code. List of values can be found
     * [here](https://www.iana.org/assignments/language-subtag-registry/language-subtag-registry)
     * under the `region` tag. If left blank no region filtering will be
     * performed.
     *
     * Example value: `US`.
     * </pre>
     *
     * <code>string region_code = 4;</code>
     *
     * @param value The regionCode to set.
     * @return This builder for chaining.
     */
    public Builder setRegionCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      regionCode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Region code of offers to accept. 2-letter Uppercase ISO 3166-1 alpha-2
     * code. List of values can be found
     * [here](https://www.iana.org/assignments/language-subtag-registry/language-subtag-registry)
     * under the `region` tag. If left blank no region filtering will be
     * performed.
     *
     * Example value: `US`.
     * </pre>
     *
     * <code>string region_code = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegionCode() {
      regionCode_ = getDefaultInstance().getRegionCode();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Region code of offers to accept. 2-letter Uppercase ISO 3166-1 alpha-2
     * code. List of values can be found
     * [here](https://www.iana.org/assignments/language-subtag-registry/language-subtag-registry)
     * under the `region` tag. If left blank no region filtering will be
     * performed.
     *
     * Example value: `US`.
     * </pre>
     *
     * <code>string region_code = 4;</code>
     *
     * @param value The bytes for regionCode to set.
     * @return This builder for chaining.
     */
    public Builder setRegionCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      regionCode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * Language of the title/description and other string attributes. Use language
     * tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     * ISO 639-1.
     *
     * This specifies the language of offers in Merchant Center that will be
     * accepted. If  empty no language filtering will be performed.
     *
     * Example value: `en`.
     * </pre>
     *
     * <code>string language_code = 5;</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Language of the title/description and other string attributes. Use language
     * tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     * ISO 639-1.
     *
     * This specifies the language of offers in Merchant Center that will be
     * accepted. If  empty no language filtering will be performed.
     *
     * Example value: `en`.
     * </pre>
     *
     * <code>string language_code = 5;</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Language of the title/description and other string attributes. Use language
     * tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     * ISO 639-1.
     *
     * This specifies the language of offers in Merchant Center that will be
     * accepted. If  empty no language filtering will be performed.
     *
     * Example value: `en`.
     * </pre>
     *
     * <code>string language_code = 5;</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      languageCode_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Language of the title/description and other string attributes. Use language
     * tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     * ISO 639-1.
     *
     * This specifies the language of offers in Merchant Center that will be
     * accepted. If  empty no language filtering will be performed.
     *
     * Example value: `en`.
     * </pre>
     *
     * <code>string language_code = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {
      languageCode_ = getDefaultInstance().getLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Language of the title/description and other string attributes. Use language
     * tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     * ISO 639-1.
     *
     * This specifies the language of offers in Merchant Center that will be
     * accepted. If  empty no language filtering will be performed.
     *
     * Example value: `en`.
     * </pre>
     *
     * <code>string language_code = 5;</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      languageCode_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter> feeds_ =
        java.util.Collections.emptyList();

    private void ensureFeedsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        feeds_ =
            new java.util.ArrayList<com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter>(
                feeds_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter,
            com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter.Builder,
            com.google.cloud.retail.v2alpha.MerchantCenterFeedFilterOrBuilder>
        feedsBuilder_;

    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.MerchantCenterFeedFilter feeds = 6;</code>
     */
    public java.util.List<com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter> getFeedsList() {
      if (feedsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(feeds_);
      } else {
        return feedsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.MerchantCenterFeedFilter feeds = 6;</code>
     */
    public int getFeedsCount() {
      if (feedsBuilder_ == null) {
        return feeds_.size();
      } else {
        return feedsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.MerchantCenterFeedFilter feeds = 6;</code>
     */
    public com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter getFeeds(int index) {
      if (feedsBuilder_ == null) {
        return feeds_.get(index);
      } else {
        return feedsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.MerchantCenterFeedFilter feeds = 6;</code>
     */
    public Builder setFeeds(
        int index, com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter value) {
      if (feedsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeedsIsMutable();
        feeds_.set(index, value);
        onChanged();
      } else {
        feedsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.MerchantCenterFeedFilter feeds = 6;</code>
     */
    public Builder setFeeds(
        int index,
        com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter.Builder builderForValue) {
      if (feedsBuilder_ == null) {
        ensureFeedsIsMutable();
        feeds_.set(index, builderForValue.build());
        onChanged();
      } else {
        feedsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.MerchantCenterFeedFilter feeds = 6;</code>
     */
    public Builder addFeeds(com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter value) {
      if (feedsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeedsIsMutable();
        feeds_.add(value);
        onChanged();
      } else {
        feedsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.MerchantCenterFeedFilter feeds = 6;</code>
     */
    public Builder addFeeds(
        int index, com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter value) {
      if (feedsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeedsIsMutable();
        feeds_.add(index, value);
        onChanged();
      } else {
        feedsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.MerchantCenterFeedFilter feeds = 6;</code>
     */
    public Builder addFeeds(
        com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter.Builder builderForValue) {
      if (feedsBuilder_ == null) {
        ensureFeedsIsMutable();
        feeds_.add(builderForValue.build());
        onChanged();
      } else {
        feedsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.MerchantCenterFeedFilter feeds = 6;</code>
     */
    public Builder addFeeds(
        int index,
        com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter.Builder builderForValue) {
      if (feedsBuilder_ == null) {
        ensureFeedsIsMutable();
        feeds_.add(index, builderForValue.build());
        onChanged();
      } else {
        feedsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.MerchantCenterFeedFilter feeds = 6;</code>
     */
    public Builder addAllFeeds(
        java.lang.Iterable<? extends com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter>
            values) {
      if (feedsBuilder_ == null) {
        ensureFeedsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, feeds_);
        onChanged();
      } else {
        feedsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.MerchantCenterFeedFilter feeds = 6;</code>
     */
    public Builder clearFeeds() {
      if (feedsBuilder_ == null) {
        feeds_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        feedsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.MerchantCenterFeedFilter feeds = 6;</code>
     */
    public Builder removeFeeds(int index) {
      if (feedsBuilder_ == null) {
        ensureFeedsIsMutable();
        feeds_.remove(index);
        onChanged();
      } else {
        feedsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.MerchantCenterFeedFilter feeds = 6;</code>
     */
    public com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter.Builder getFeedsBuilder(
        int index) {
      return getFeedsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.MerchantCenterFeedFilter feeds = 6;</code>
     */
    public com.google.cloud.retail.v2alpha.MerchantCenterFeedFilterOrBuilder getFeedsOrBuilder(
        int index) {
      if (feedsBuilder_ == null) {
        return feeds_.get(index);
      } else {
        return feedsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.MerchantCenterFeedFilter feeds = 6;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.retail.v2alpha.MerchantCenterFeedFilterOrBuilder>
        getFeedsOrBuilderList() {
      if (feedsBuilder_ != null) {
        return feedsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(feeds_);
      }
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.MerchantCenterFeedFilter feeds = 6;</code>
     */
    public com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter.Builder addFeedsBuilder() {
      return getFeedsFieldBuilder()
          .addBuilder(
              com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.MerchantCenterFeedFilter feeds = 6;</code>
     */
    public com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter.Builder addFeedsBuilder(
        int index) {
      return getFeedsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Criteria for the Merchant Center feeds to be ingested via the link.
     * All offers will be ingested if the list is empty.
     * Otherwise the offers will be ingested from selected feeds.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.MerchantCenterFeedFilter feeds = 6;</code>
     */
    public java.util.List<com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter.Builder>
        getFeedsBuilderList() {
      return getFeedsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter,
            com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter.Builder,
            com.google.cloud.retail.v2alpha.MerchantCenterFeedFilterOrBuilder>
        getFeedsFieldBuilder() {
      if (feedsBuilder_ == null) {
        feedsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter,
                com.google.cloud.retail.v2alpha.MerchantCenterFeedFilter.Builder,
                com.google.cloud.retail.v2alpha.MerchantCenterFeedFilterOrBuilder>(
                feeds_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
        feeds_ = null;
      }
      return feedsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.MerchantCenterLink)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.MerchantCenterLink)
  private static final com.google.cloud.retail.v2alpha.MerchantCenterLink DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.MerchantCenterLink();
  }

  public static com.google.cloud.retail.v2alpha.MerchantCenterLink getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MerchantCenterLink> PARSER =
      new com.google.protobuf.AbstractParser<MerchantCenterLink>() {
        @java.lang.Override
        public MerchantCenterLink parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MerchantCenterLink> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MerchantCenterLink> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2alpha.MerchantCenterLink getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
