/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2alpha/import_config.proto

package com.google.cloud.retail.v2alpha;

/**
 *
 *
 * <pre>
 * The inline source for the input config for ImportProducts method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2alpha.ProductInlineSource}
 */
public final class ProductInlineSource extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.ProductInlineSource)
    ProductInlineSourceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ProductInlineSource.newBuilder() to construct.
  private ProductInlineSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ProductInlineSource() {
    products_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ProductInlineSource();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2alpha.ImportConfigProto
        .internal_static_google_cloud_retail_v2alpha_ProductInlineSource_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2alpha.ImportConfigProto
        .internal_static_google_cloud_retail_v2alpha_ProductInlineSource_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2alpha.ProductInlineSource.class,
            com.google.cloud.retail.v2alpha.ProductInlineSource.Builder.class);
  }

  public static final int PRODUCTS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.retail.v2alpha.Product> products_;
  /**
   *
   *
   * <pre>
   * Required. A list of products to update/create. Each product must have a
   * valid [Product.id][google.cloud.retail.v2alpha.Product.id]. Recommended max
   * of 100 items.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Product products = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2alpha.Product> getProductsList() {
    return products_;
  }
  /**
   *
   *
   * <pre>
   * Required. A list of products to update/create. Each product must have a
   * valid [Product.id][google.cloud.retail.v2alpha.Product.id]. Recommended max
   * of 100 items.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Product products = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.retail.v2alpha.ProductOrBuilder>
      getProductsOrBuilderList() {
    return products_;
  }
  /**
   *
   *
   * <pre>
   * Required. A list of products to update/create. Each product must have a
   * valid [Product.id][google.cloud.retail.v2alpha.Product.id]. Recommended max
   * of 100 items.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Product products = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getProductsCount() {
    return products_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. A list of products to update/create. Each product must have a
   * valid [Product.id][google.cloud.retail.v2alpha.Product.id]. Recommended max
   * of 100 items.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Product products = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.Product getProducts(int index) {
    return products_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. A list of products to update/create. Each product must have a
   * valid [Product.id][google.cloud.retail.v2alpha.Product.id]. Recommended max
   * of 100 items.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Product products = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.ProductOrBuilder getProductsOrBuilder(int index) {
    return products_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < products_.size(); i++) {
      output.writeMessage(1, products_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < products_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, products_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2alpha.ProductInlineSource)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2alpha.ProductInlineSource other =
        (com.google.cloud.retail.v2alpha.ProductInlineSource) obj;

    if (!getProductsList().equals(other.getProductsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getProductsCount() > 0) {
      hash = (37 * hash) + PRODUCTS_FIELD_NUMBER;
      hash = (53 * hash) + getProductsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2alpha.ProductInlineSource parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.ProductInlineSource parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.ProductInlineSource parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.ProductInlineSource parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.ProductInlineSource parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.ProductInlineSource parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.ProductInlineSource parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.ProductInlineSource parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.ProductInlineSource parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.ProductInlineSource parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.ProductInlineSource parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.ProductInlineSource parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2alpha.ProductInlineSource prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The inline source for the input config for ImportProducts method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.ProductInlineSource}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.ProductInlineSource)
      com.google.cloud.retail.v2alpha.ProductInlineSourceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.ImportConfigProto
          .internal_static_google_cloud_retail_v2alpha_ProductInlineSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.ImportConfigProto
          .internal_static_google_cloud_retail_v2alpha_ProductInlineSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.ProductInlineSource.class,
              com.google.cloud.retail.v2alpha.ProductInlineSource.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2alpha.ProductInlineSource.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (productsBuilder_ == null) {
        products_ = java.util.Collections.emptyList();
      } else {
        products_ = null;
        productsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2alpha.ImportConfigProto
          .internal_static_google_cloud_retail_v2alpha_ProductInlineSource_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.ProductInlineSource getDefaultInstanceForType() {
      return com.google.cloud.retail.v2alpha.ProductInlineSource.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.ProductInlineSource build() {
      com.google.cloud.retail.v2alpha.ProductInlineSource result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.ProductInlineSource buildPartial() {
      com.google.cloud.retail.v2alpha.ProductInlineSource result =
          new com.google.cloud.retail.v2alpha.ProductInlineSource(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.retail.v2alpha.ProductInlineSource result) {
      if (productsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          products_ = java.util.Collections.unmodifiableList(products_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.products_ = products_;
      } else {
        result.products_ = productsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.retail.v2alpha.ProductInlineSource result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2alpha.ProductInlineSource) {
        return mergeFrom((com.google.cloud.retail.v2alpha.ProductInlineSource) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2alpha.ProductInlineSource other) {
      if (other == com.google.cloud.retail.v2alpha.ProductInlineSource.getDefaultInstance())
        return this;
      if (productsBuilder_ == null) {
        if (!other.products_.isEmpty()) {
          if (products_.isEmpty()) {
            products_ = other.products_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureProductsIsMutable();
            products_.addAll(other.products_);
          }
          onChanged();
        }
      } else {
        if (!other.products_.isEmpty()) {
          if (productsBuilder_.isEmpty()) {
            productsBuilder_.dispose();
            productsBuilder_ = null;
            products_ = other.products_;
            bitField0_ = (bitField0_ & ~0x00000001);
            productsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getProductsFieldBuilder()
                    : null;
          } else {
            productsBuilder_.addAllMessages(other.products_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.retail.v2alpha.Product m =
                    input.readMessage(
                        com.google.cloud.retail.v2alpha.Product.parser(), extensionRegistry);
                if (productsBuilder_ == null) {
                  ensureProductsIsMutable();
                  products_.add(m);
                } else {
                  productsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.retail.v2alpha.Product> products_ =
        java.util.Collections.emptyList();

    private void ensureProductsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        products_ = new java.util.ArrayList<com.google.cloud.retail.v2alpha.Product>(products_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2alpha.Product,
            com.google.cloud.retail.v2alpha.Product.Builder,
            com.google.cloud.retail.v2alpha.ProductOrBuilder>
        productsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. A list of products to update/create. Each product must have a
     * valid [Product.id][google.cloud.retail.v2alpha.Product.id]. Recommended max
     * of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Product products = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.retail.v2alpha.Product> getProductsList() {
      if (productsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(products_);
      } else {
        return productsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A list of products to update/create. Each product must have a
     * valid [Product.id][google.cloud.retail.v2alpha.Product.id]. Recommended max
     * of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Product products = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getProductsCount() {
      if (productsBuilder_ == null) {
        return products_.size();
      } else {
        return productsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A list of products to update/create. Each product must have a
     * valid [Product.id][google.cloud.retail.v2alpha.Product.id]. Recommended max
     * of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Product products = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.Product getProducts(int index) {
      if (productsBuilder_ == null) {
        return products_.get(index);
      } else {
        return productsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A list of products to update/create. Each product must have a
     * valid [Product.id][google.cloud.retail.v2alpha.Product.id]. Recommended max
     * of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Product products = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setProducts(int index, com.google.cloud.retail.v2alpha.Product value) {
      if (productsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProductsIsMutable();
        products_.set(index, value);
        onChanged();
      } else {
        productsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of products to update/create. Each product must have a
     * valid [Product.id][google.cloud.retail.v2alpha.Product.id]. Recommended max
     * of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Product products = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setProducts(
        int index, com.google.cloud.retail.v2alpha.Product.Builder builderForValue) {
      if (productsBuilder_ == null) {
        ensureProductsIsMutable();
        products_.set(index, builderForValue.build());
        onChanged();
      } else {
        productsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of products to update/create. Each product must have a
     * valid [Product.id][google.cloud.retail.v2alpha.Product.id]. Recommended max
     * of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Product products = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addProducts(com.google.cloud.retail.v2alpha.Product value) {
      if (productsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProductsIsMutable();
        products_.add(value);
        onChanged();
      } else {
        productsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of products to update/create. Each product must have a
     * valid [Product.id][google.cloud.retail.v2alpha.Product.id]. Recommended max
     * of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Product products = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addProducts(int index, com.google.cloud.retail.v2alpha.Product value) {
      if (productsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProductsIsMutable();
        products_.add(index, value);
        onChanged();
      } else {
        productsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of products to update/create. Each product must have a
     * valid [Product.id][google.cloud.retail.v2alpha.Product.id]. Recommended max
     * of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Product products = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addProducts(com.google.cloud.retail.v2alpha.Product.Builder builderForValue) {
      if (productsBuilder_ == null) {
        ensureProductsIsMutable();
        products_.add(builderForValue.build());
        onChanged();
      } else {
        productsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of products to update/create. Each product must have a
     * valid [Product.id][google.cloud.retail.v2alpha.Product.id]. Recommended max
     * of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Product products = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addProducts(
        int index, com.google.cloud.retail.v2alpha.Product.Builder builderForValue) {
      if (productsBuilder_ == null) {
        ensureProductsIsMutable();
        products_.add(index, builderForValue.build());
        onChanged();
      } else {
        productsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of products to update/create. Each product must have a
     * valid [Product.id][google.cloud.retail.v2alpha.Product.id]. Recommended max
     * of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Product products = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllProducts(
        java.lang.Iterable<? extends com.google.cloud.retail.v2alpha.Product> values) {
      if (productsBuilder_ == null) {
        ensureProductsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, products_);
        onChanged();
      } else {
        productsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of products to update/create. Each product must have a
     * valid [Product.id][google.cloud.retail.v2alpha.Product.id]. Recommended max
     * of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Product products = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearProducts() {
      if (productsBuilder_ == null) {
        products_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        productsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of products to update/create. Each product must have a
     * valid [Product.id][google.cloud.retail.v2alpha.Product.id]. Recommended max
     * of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Product products = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeProducts(int index) {
      if (productsBuilder_ == null) {
        ensureProductsIsMutable();
        products_.remove(index);
        onChanged();
      } else {
        productsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of products to update/create. Each product must have a
     * valid [Product.id][google.cloud.retail.v2alpha.Product.id]. Recommended max
     * of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Product products = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.Product.Builder getProductsBuilder(int index) {
      return getProductsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. A list of products to update/create. Each product must have a
     * valid [Product.id][google.cloud.retail.v2alpha.Product.id]. Recommended max
     * of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Product products = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.ProductOrBuilder getProductsOrBuilder(int index) {
      if (productsBuilder_ == null) {
        return products_.get(index);
      } else {
        return productsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A list of products to update/create. Each product must have a
     * valid [Product.id][google.cloud.retail.v2alpha.Product.id]. Recommended max
     * of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Product products = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.retail.v2alpha.ProductOrBuilder>
        getProductsOrBuilderList() {
      if (productsBuilder_ != null) {
        return productsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(products_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A list of products to update/create. Each product must have a
     * valid [Product.id][google.cloud.retail.v2alpha.Product.id]. Recommended max
     * of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Product products = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.Product.Builder addProductsBuilder() {
      return getProductsFieldBuilder()
          .addBuilder(com.google.cloud.retail.v2alpha.Product.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. A list of products to update/create. Each product must have a
     * valid [Product.id][google.cloud.retail.v2alpha.Product.id]. Recommended max
     * of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Product products = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.Product.Builder addProductsBuilder(int index) {
      return getProductsFieldBuilder()
          .addBuilder(index, com.google.cloud.retail.v2alpha.Product.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. A list of products to update/create. Each product must have a
     * valid [Product.id][google.cloud.retail.v2alpha.Product.id]. Recommended max
     * of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Product products = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.retail.v2alpha.Product.Builder>
        getProductsBuilderList() {
      return getProductsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2alpha.Product,
            com.google.cloud.retail.v2alpha.Product.Builder,
            com.google.cloud.retail.v2alpha.ProductOrBuilder>
        getProductsFieldBuilder() {
      if (productsBuilder_ == null) {
        productsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2alpha.Product,
                com.google.cloud.retail.v2alpha.Product.Builder,
                com.google.cloud.retail.v2alpha.ProductOrBuilder>(
                products_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        products_ = null;
      }
      return productsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.ProductInlineSource)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.ProductInlineSource)
  private static final com.google.cloud.retail.v2alpha.ProductInlineSource DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.ProductInlineSource();
  }

  public static com.google.cloud.retail.v2alpha.ProductInlineSource getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ProductInlineSource> PARSER =
      new com.google.protobuf.AbstractParser<ProductInlineSource>() {
        @java.lang.Override
        public ProductInlineSource parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ProductInlineSource> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ProductInlineSource> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2alpha.ProductInlineSource getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
