/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2alpha/project_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2alpha;

/**
 *
 *
 * <pre>
 * Response for ListEnrolledSolutions method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse}
 */
public final class ListEnrolledSolutionsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse)
    ListEnrolledSolutionsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListEnrolledSolutionsResponse.newBuilder() to construct.
  private ListEnrolledSolutionsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListEnrolledSolutionsResponse() {
    enrolledSolutions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListEnrolledSolutionsResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2alpha.ProjectServiceProto
        .internal_static_google_cloud_retail_v2alpha_ListEnrolledSolutionsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2alpha.ProjectServiceProto
        .internal_static_google_cloud_retail_v2alpha_ListEnrolledSolutionsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse.class,
            com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse.Builder.class);
  }

  public static final int ENROLLED_SOLUTIONS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> enrolledSolutions_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.retail.v2alpha.SolutionType>
      enrolledSolutions_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.retail.v2alpha.SolutionType>() {
            public com.google.cloud.retail.v2alpha.SolutionType convert(java.lang.Integer from) {
              com.google.cloud.retail.v2alpha.SolutionType result =
                  com.google.cloud.retail.v2alpha.SolutionType.forNumber(from);
              return result == null
                  ? com.google.cloud.retail.v2alpha.SolutionType.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Retail API solutions that the project has enrolled.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.SolutionType enrolled_solutions = 1;</code>
   *
   * @return A list containing the enrolledSolutions.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2alpha.SolutionType> getEnrolledSolutionsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.retail.v2alpha.SolutionType>(
        enrolledSolutions_, enrolledSolutions_converter_);
  }
  /**
   *
   *
   * <pre>
   * Retail API solutions that the project has enrolled.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.SolutionType enrolled_solutions = 1;</code>
   *
   * @return The count of enrolledSolutions.
   */
  @java.lang.Override
  public int getEnrolledSolutionsCount() {
    return enrolledSolutions_.size();
  }
  /**
   *
   *
   * <pre>
   * Retail API solutions that the project has enrolled.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.SolutionType enrolled_solutions = 1;</code>
   *
   * @param index The index of the element to return.
   * @return The enrolledSolutions at the given index.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.SolutionType getEnrolledSolutions(int index) {
    return enrolledSolutions_converter_.convert(enrolledSolutions_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Retail API solutions that the project has enrolled.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.SolutionType enrolled_solutions = 1;</code>
   *
   * @return A list containing the enum numeric values on the wire for enrolledSolutions.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getEnrolledSolutionsValueList() {
    return enrolledSolutions_;
  }
  /**
   *
   *
   * <pre>
   * Retail API solutions that the project has enrolled.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.SolutionType enrolled_solutions = 1;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of enrolledSolutions at the given index.
   */
  @java.lang.Override
  public int getEnrolledSolutionsValue(int index) {
    return enrolledSolutions_.get(index);
  }

  private int enrolledSolutionsMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (getEnrolledSolutionsList().size() > 0) {
      output.writeUInt32NoTag(10);
      output.writeUInt32NoTag(enrolledSolutionsMemoizedSerializedSize);
    }
    for (int i = 0; i < enrolledSolutions_.size(); i++) {
      output.writeEnumNoTag(enrolledSolutions_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < enrolledSolutions_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(enrolledSolutions_.get(i));
      }
      size += dataSize;
      if (!getEnrolledSolutionsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      enrolledSolutionsMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse other =
        (com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse) obj;

    if (!enrolledSolutions_.equals(other.enrolledSolutions_)) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getEnrolledSolutionsCount() > 0) {
      hash = (37 * hash) + ENROLLED_SOLUTIONS_FIELD_NUMBER;
      hash = (53 * hash) + enrolledSolutions_.hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response for ListEnrolledSolutions method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse)
      com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.ProjectServiceProto
          .internal_static_google_cloud_retail_v2alpha_ListEnrolledSolutionsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.ProjectServiceProto
          .internal_static_google_cloud_retail_v2alpha_ListEnrolledSolutionsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse.class,
              com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      enrolledSolutions_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2alpha.ProjectServiceProto
          .internal_static_google_cloud_retail_v2alpha_ListEnrolledSolutionsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse
        getDefaultInstanceForType() {
      return com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse build() {
      com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse buildPartial() {
      com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse result =
          new com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse result) {
      if (((bitField0_ & 0x00000001) != 0)) {
        enrolledSolutions_ = java.util.Collections.unmodifiableList(enrolledSolutions_);
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.enrolledSolutions_ = enrolledSolutions_;
    }

    private void buildPartial0(
        com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse) {
        return mergeFrom((com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse other) {
      if (other
          == com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse.getDefaultInstance())
        return this;
      if (!other.enrolledSolutions_.isEmpty()) {
        if (enrolledSolutions_.isEmpty()) {
          enrolledSolutions_ = other.enrolledSolutions_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureEnrolledSolutionsIsMutable();
          enrolledSolutions_.addAll(other.enrolledSolutions_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                int tmpRaw = input.readEnum();
                ensureEnrolledSolutionsIsMutable();
                enrolledSolutions_.add(tmpRaw);
                break;
              } // case 8
            case 10:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureEnrolledSolutionsIsMutable();
                  enrolledSolutions_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<java.lang.Integer> enrolledSolutions_ =
        java.util.Collections.emptyList();

    private void ensureEnrolledSolutionsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        enrolledSolutions_ = new java.util.ArrayList<java.lang.Integer>(enrolledSolutions_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Retail API solutions that the project has enrolled.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SolutionType enrolled_solutions = 1;</code>
     *
     * @return A list containing the enrolledSolutions.
     */
    public java.util.List<com.google.cloud.retail.v2alpha.SolutionType> getEnrolledSolutionsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.retail.v2alpha.SolutionType>(
          enrolledSolutions_, enrolledSolutions_converter_);
    }
    /**
     *
     *
     * <pre>
     * Retail API solutions that the project has enrolled.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SolutionType enrolled_solutions = 1;</code>
     *
     * @return The count of enrolledSolutions.
     */
    public int getEnrolledSolutionsCount() {
      return enrolledSolutions_.size();
    }
    /**
     *
     *
     * <pre>
     * Retail API solutions that the project has enrolled.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SolutionType enrolled_solutions = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The enrolledSolutions at the given index.
     */
    public com.google.cloud.retail.v2alpha.SolutionType getEnrolledSolutions(int index) {
      return enrolledSolutions_converter_.convert(enrolledSolutions_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Retail API solutions that the project has enrolled.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SolutionType enrolled_solutions = 1;</code>
     *
     * @param index The index to set the value at.
     * @param value The enrolledSolutions to set.
     * @return This builder for chaining.
     */
    public Builder setEnrolledSolutions(
        int index, com.google.cloud.retail.v2alpha.SolutionType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEnrolledSolutionsIsMutable();
      enrolledSolutions_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Retail API solutions that the project has enrolled.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SolutionType enrolled_solutions = 1;</code>
     *
     * @param value The enrolledSolutions to add.
     * @return This builder for chaining.
     */
    public Builder addEnrolledSolutions(com.google.cloud.retail.v2alpha.SolutionType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEnrolledSolutionsIsMutable();
      enrolledSolutions_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Retail API solutions that the project has enrolled.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SolutionType enrolled_solutions = 1;</code>
     *
     * @param values The enrolledSolutions to add.
     * @return This builder for chaining.
     */
    public Builder addAllEnrolledSolutions(
        java.lang.Iterable<? extends com.google.cloud.retail.v2alpha.SolutionType> values) {
      ensureEnrolledSolutionsIsMutable();
      for (com.google.cloud.retail.v2alpha.SolutionType value : values) {
        enrolledSolutions_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Retail API solutions that the project has enrolled.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SolutionType enrolled_solutions = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnrolledSolutions() {
      enrolledSolutions_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Retail API solutions that the project has enrolled.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SolutionType enrolled_solutions = 1;</code>
     *
     * @return A list containing the enum numeric values on the wire for enrolledSolutions.
     */
    public java.util.List<java.lang.Integer> getEnrolledSolutionsValueList() {
      return java.util.Collections.unmodifiableList(enrolledSolutions_);
    }
    /**
     *
     *
     * <pre>
     * Retail API solutions that the project has enrolled.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SolutionType enrolled_solutions = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of enrolledSolutions at the given index.
     */
    public int getEnrolledSolutionsValue(int index) {
      return enrolledSolutions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Retail API solutions that the project has enrolled.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SolutionType enrolled_solutions = 1;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for enrolledSolutions to set.
     * @return This builder for chaining.
     */
    public Builder setEnrolledSolutionsValue(int index, int value) {
      ensureEnrolledSolutionsIsMutable();
      enrolledSolutions_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Retail API solutions that the project has enrolled.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SolutionType enrolled_solutions = 1;</code>
     *
     * @param value The enum numeric value on the wire for enrolledSolutions to add.
     * @return This builder for chaining.
     */
    public Builder addEnrolledSolutionsValue(int value) {
      ensureEnrolledSolutionsIsMutable();
      enrolledSolutions_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Retail API solutions that the project has enrolled.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SolutionType enrolled_solutions = 1;</code>
     *
     * @param values The enum numeric values on the wire for enrolledSolutions to add.
     * @return This builder for chaining.
     */
    public Builder addAllEnrolledSolutionsValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureEnrolledSolutionsIsMutable();
      for (int value : values) {
        enrolledSolutions_.add(value);
      }
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse)
  private static final com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse();
  }

  public static com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListEnrolledSolutionsResponse> PARSER =
      new com.google.protobuf.AbstractParser<ListEnrolledSolutionsResponse>() {
        @java.lang.Override
        public ListEnrolledSolutionsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListEnrolledSolutionsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListEnrolledSolutionsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
