/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2alpha/model.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2alpha;

/**
 *
 *
 * <pre>
 * Metadata that describes the training and serving parameters of a
 * [Model][google.cloud.retail.v2alpha.Model]. A
 * [Model][google.cloud.retail.v2alpha.Model] can be associated with a
 * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig] and then queried
 * through the Predict API.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2alpha.Model}
 */
public final class Model extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.Model)
    ModelOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Model.newBuilder() to construct.
  private Model(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Model() {
    name_ = "";
    displayName_ = "";
    trainingState_ = 0;
    servingState_ = 0;
    type_ = "";
    optimizationObjective_ = "";
    periodicTuningState_ = 0;
    tuningOperation_ = "";
    dataState_ = 0;
    filteringOption_ = 0;
    servingConfigLists_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Model();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2alpha.ModelProto
        .internal_static_google_cloud_retail_v2alpha_Model_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2alpha.ModelProto
        .internal_static_google_cloud_retail_v2alpha_Model_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2alpha.Model.class,
            com.google.cloud.retail.v2alpha.Model.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The serving state of the model.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.retail.v2alpha.Model.ServingState}
   */
  public enum ServingState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified serving state.
     * </pre>
     *
     * <code>SERVING_STATE_UNSPECIFIED = 0;</code>
     */
    SERVING_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The model is not serving.
     * </pre>
     *
     * <code>INACTIVE = 1;</code>
     */
    INACTIVE(1),
    /**
     *
     *
     * <pre>
     * The model is serving and can be queried.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    ACTIVE(2),
    /**
     *
     *
     * <pre>
     * The model is trained on tuned hyperparameters and can be
     * queried.
     * </pre>
     *
     * <code>TUNED = 3;</code>
     */
    TUNED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified serving state.
     * </pre>
     *
     * <code>SERVING_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int SERVING_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The model is not serving.
     * </pre>
     *
     * <code>INACTIVE = 1;</code>
     */
    public static final int INACTIVE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The model is serving and can be queried.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    public static final int ACTIVE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The model is trained on tuned hyperparameters and can be
     * queried.
     * </pre>
     *
     * <code>TUNED = 3;</code>
     */
    public static final int TUNED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ServingState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ServingState forNumber(int value) {
      switch (value) {
        case 0:
          return SERVING_STATE_UNSPECIFIED;
        case 1:
          return INACTIVE;
        case 2:
          return ACTIVE;
        case 3:
          return TUNED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ServingState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ServingState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ServingState>() {
          public ServingState findValueByNumber(int number) {
            return ServingState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.Model.getDescriptor().getEnumTypes().get(0);
    }

    private static final ServingState[] VALUES = values();

    public static ServingState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ServingState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2alpha.Model.ServingState)
  }

  /**
   *
   *
   * <pre>
   * The training state of the model.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.retail.v2alpha.Model.TrainingState}
   */
  public enum TrainingState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified training state.
     * </pre>
     *
     * <code>TRAINING_STATE_UNSPECIFIED = 0;</code>
     */
    TRAINING_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The model training is paused.
     * </pre>
     *
     * <code>PAUSED = 1;</code>
     */
    PAUSED(1),
    /**
     *
     *
     * <pre>
     * The model is training.
     * </pre>
     *
     * <code>TRAINING = 2;</code>
     */
    TRAINING(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified training state.
     * </pre>
     *
     * <code>TRAINING_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int TRAINING_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The model training is paused.
     * </pre>
     *
     * <code>PAUSED = 1;</code>
     */
    public static final int PAUSED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The model is training.
     * </pre>
     *
     * <code>TRAINING = 2;</code>
     */
    public static final int TRAINING_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TrainingState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TrainingState forNumber(int value) {
      switch (value) {
        case 0:
          return TRAINING_STATE_UNSPECIFIED;
        case 1:
          return PAUSED;
        case 2:
          return TRAINING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TrainingState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TrainingState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<TrainingState>() {
          public TrainingState findValueByNumber(int number) {
            return TrainingState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.Model.getDescriptor().getEnumTypes().get(1);
    }

    private static final TrainingState[] VALUES = values();

    public static TrainingState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TrainingState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2alpha.Model.TrainingState)
  }

  /**
   *
   *
   * <pre>
   * Describes whether periodic tuning is enabled for this model
   * or not. Periodic tuning is scheduled at most every three months. You can
   * start a tuning process manually by using the `TuneModel`
   * method, which starts a tuning process immediately and resets the quarterly
   * schedule. Enabling or disabling periodic tuning does not affect any
   * current tuning processes.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.retail.v2alpha.Model.PeriodicTuningState}
   */
  public enum PeriodicTuningState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified default value, should never be explicitly set.
     * </pre>
     *
     * <code>PERIODIC_TUNING_STATE_UNSPECIFIED = 0;</code>
     */
    PERIODIC_TUNING_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The model has periodic tuning disabled. Tuning
     * can be reenabled by calling the `EnableModelPeriodicTuning`
     * method or by calling the `TuneModel` method.
     * </pre>
     *
     * <code>PERIODIC_TUNING_DISABLED = 1;</code>
     */
    PERIODIC_TUNING_DISABLED(1),
    /**
     *
     *
     * <pre>
     * The model cannot be tuned with periodic tuning OR the
     * `TuneModel` method. Hide the options in customer UI and
     * reject any requests through the backend self serve API.
     * </pre>
     *
     * <code>ALL_TUNING_DISABLED = 3;</code>
     */
    ALL_TUNING_DISABLED(3),
    /**
     *
     *
     * <pre>
     * The model has periodic tuning enabled. Tuning
     * can be disabled by calling the `DisableModelPeriodicTuning`
     * method.
     * </pre>
     *
     * <code>PERIODIC_TUNING_ENABLED = 2;</code>
     */
    PERIODIC_TUNING_ENABLED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified default value, should never be explicitly set.
     * </pre>
     *
     * <code>PERIODIC_TUNING_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int PERIODIC_TUNING_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The model has periodic tuning disabled. Tuning
     * can be reenabled by calling the `EnableModelPeriodicTuning`
     * method or by calling the `TuneModel` method.
     * </pre>
     *
     * <code>PERIODIC_TUNING_DISABLED = 1;</code>
     */
    public static final int PERIODIC_TUNING_DISABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The model cannot be tuned with periodic tuning OR the
     * `TuneModel` method. Hide the options in customer UI and
     * reject any requests through the backend self serve API.
     * </pre>
     *
     * <code>ALL_TUNING_DISABLED = 3;</code>
     */
    public static final int ALL_TUNING_DISABLED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The model has periodic tuning enabled. Tuning
     * can be disabled by calling the `DisableModelPeriodicTuning`
     * method.
     * </pre>
     *
     * <code>PERIODIC_TUNING_ENABLED = 2;</code>
     */
    public static final int PERIODIC_TUNING_ENABLED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PeriodicTuningState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PeriodicTuningState forNumber(int value) {
      switch (value) {
        case 0:
          return PERIODIC_TUNING_STATE_UNSPECIFIED;
        case 1:
          return PERIODIC_TUNING_DISABLED;
        case 3:
          return ALL_TUNING_DISABLED;
        case 2:
          return PERIODIC_TUNING_ENABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PeriodicTuningState>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PeriodicTuningState>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<PeriodicTuningState>() {
              public PeriodicTuningState findValueByNumber(int number) {
                return PeriodicTuningState.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.Model.getDescriptor().getEnumTypes().get(2);
    }

    private static final PeriodicTuningState[] VALUES = values();

    public static PeriodicTuningState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PeriodicTuningState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2alpha.Model.PeriodicTuningState)
  }

  /**
   *
   *
   * <pre>
   * Describes whether this model have sufficient training data
   * to be continuously trained.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.retail.v2alpha.Model.DataState}
   */
  public enum DataState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified default value, should never be explicitly set.
     * </pre>
     *
     * <code>DATA_STATE_UNSPECIFIED = 0;</code>
     */
    DATA_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The model has sufficient training data.
     * </pre>
     *
     * <code>DATA_OK = 1;</code>
     */
    DATA_OK(1),
    /**
     *
     *
     * <pre>
     * The model does not have sufficient training data. Error
     * messages can be queried via Stackdriver.
     * </pre>
     *
     * <code>DATA_ERROR = 2;</code>
     */
    DATA_ERROR(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified default value, should never be explicitly set.
     * </pre>
     *
     * <code>DATA_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int DATA_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The model has sufficient training data.
     * </pre>
     *
     * <code>DATA_OK = 1;</code>
     */
    public static final int DATA_OK_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The model does not have sufficient training data. Error
     * messages can be queried via Stackdriver.
     * </pre>
     *
     * <code>DATA_ERROR = 2;</code>
     */
    public static final int DATA_ERROR_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DataState forNumber(int value) {
      switch (value) {
        case 0:
          return DATA_STATE_UNSPECIFIED;
        case 1:
          return DATA_OK;
        case 2:
          return DATA_ERROR;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DataState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DataState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DataState>() {
          public DataState findValueByNumber(int number) {
            return DataState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.Model.getDescriptor().getEnumTypes().get(3);
    }

    private static final DataState[] VALUES = values();

    public static DataState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DataState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2alpha.Model.DataState)
  }

  /**
   *
   *
   * <pre>
   * Use single or multiple context products for recommendations.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.retail.v2alpha.Model.ContextProductsType}
   */
  public enum ContextProductsType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified default value, should never be explicitly set.
     * Defaults to
     * [MULTIPLE_CONTEXT_PRODUCTS][google.cloud.retail.v2alpha.Model.ContextProductsType.MULTIPLE_CONTEXT_PRODUCTS].
     * </pre>
     *
     * <code>CONTEXT_PRODUCTS_TYPE_UNSPECIFIED = 0;</code>
     */
    CONTEXT_PRODUCTS_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Use only a single product as context for the recommendation. Typically
     * used on pages like add-to-cart or product details.
     * </pre>
     *
     * <code>SINGLE_CONTEXT_PRODUCT = 1;</code>
     */
    SINGLE_CONTEXT_PRODUCT(1),
    /**
     *
     *
     * <pre>
     * Use one or multiple products as context for the recommendation. Typically
     * used on shopping cart pages.
     * </pre>
     *
     * <code>MULTIPLE_CONTEXT_PRODUCTS = 2;</code>
     */
    MULTIPLE_CONTEXT_PRODUCTS(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified default value, should never be explicitly set.
     * Defaults to
     * [MULTIPLE_CONTEXT_PRODUCTS][google.cloud.retail.v2alpha.Model.ContextProductsType.MULTIPLE_CONTEXT_PRODUCTS].
     * </pre>
     *
     * <code>CONTEXT_PRODUCTS_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int CONTEXT_PRODUCTS_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Use only a single product as context for the recommendation. Typically
     * used on pages like add-to-cart or product details.
     * </pre>
     *
     * <code>SINGLE_CONTEXT_PRODUCT = 1;</code>
     */
    public static final int SINGLE_CONTEXT_PRODUCT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Use one or multiple products as context for the recommendation. Typically
     * used on shopping cart pages.
     * </pre>
     *
     * <code>MULTIPLE_CONTEXT_PRODUCTS = 2;</code>
     */
    public static final int MULTIPLE_CONTEXT_PRODUCTS_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ContextProductsType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ContextProductsType forNumber(int value) {
      switch (value) {
        case 0:
          return CONTEXT_PRODUCTS_TYPE_UNSPECIFIED;
        case 1:
          return SINGLE_CONTEXT_PRODUCT;
        case 2:
          return MULTIPLE_CONTEXT_PRODUCTS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ContextProductsType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ContextProductsType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ContextProductsType>() {
              public ContextProductsType findValueByNumber(int number) {
                return ContextProductsType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.Model.getDescriptor().getEnumTypes().get(4);
    }

    private static final ContextProductsType[] VALUES = values();

    public static ContextProductsType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ContextProductsType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2alpha.Model.ContextProductsType)
  }

  public interface PageOptimizationConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.Model.PageOptimizationConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The type of [UserEvent][google.cloud.retail.v2alpha.UserEvent]
     * this page optimization is shown for.
     *
     * Each page has an associated event type - this will be the
     * corresponding event type for the page that the page optimization
     * model is used on.
     *
     * Supported types:
     *
     * * `add-to-cart`: Products being added to cart.
     * * `detail-page-view`: Products detail page viewed.
     * * `home-page-view`: Homepage viewed
     * * `category-page-view`: Homepage viewed
     * * `shopping-cart-page-view`: User viewing a shopping cart.
     *
     * `home-page-view` only allows models with type `recommended-for-you`.
     * All other page_optimization_event_type allow all
     * [Model.types][google.cloud.retail.v2alpha.Model.type].
     * </pre>
     *
     * <code>string page_optimization_event_type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The pageOptimizationEventType.
     */
    java.lang.String getPageOptimizationEventType();
    /**
     *
     *
     * <pre>
     * Required. The type of [UserEvent][google.cloud.retail.v2alpha.UserEvent]
     * this page optimization is shown for.
     *
     * Each page has an associated event type - this will be the
     * corresponding event type for the page that the page optimization
     * model is used on.
     *
     * Supported types:
     *
     * * `add-to-cart`: Products being added to cart.
     * * `detail-page-view`: Products detail page viewed.
     * * `home-page-view`: Homepage viewed
     * * `category-page-view`: Homepage viewed
     * * `shopping-cart-page-view`: User viewing a shopping cart.
     *
     * `home-page-view` only allows models with type `recommended-for-you`.
     * All other page_optimization_event_type allow all
     * [Model.types][google.cloud.retail.v2alpha.Model.type].
     * </pre>
     *
     * <code>string page_optimization_event_type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The bytes for pageOptimizationEventType.
     */
    com.google.protobuf.ByteString getPageOptimizationEventTypeBytes();

    /**
     *
     *
     * <pre>
     * Required. A list of panel configurations.
     *
     * Limit = 5.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel>
        getPanelsList();
    /**
     *
     *
     * <pre>
     * Required. A list of panel configurations.
     *
     * Limit = 5.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel getPanels(int index);
    /**
     *
     *
     * <pre>
     * Required. A list of panel configurations.
     *
     * Limit = 5.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    int getPanelsCount();
    /**
     *
     *
     * <pre>
     * Required. A list of panel configurations.
     *
     * Limit = 5.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.PanelOrBuilder>
        getPanelsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Required. A list of panel configurations.
     *
     * Limit = 5.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.PanelOrBuilder getPanelsOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * Optional. How to restrict results across panels e.g. can the same
     * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig] be shown on
     * multiple panels at once.
     *
     * If unspecified, default to `UNIQUE_MODEL_RESTRICTION`.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Restriction restriction = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for restriction.
     */
    int getRestrictionValue();
    /**
     *
     *
     * <pre>
     * Optional. How to restrict results across panels e.g. can the same
     * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig] be shown on
     * multiple panels at once.
     *
     * If unspecified, default to `UNIQUE_MODEL_RESTRICTION`.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Restriction restriction = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The restriction.
     */
    com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Restriction getRestriction();
  }
  /**
   *
   *
   * <pre>
   * The PageOptimizationConfig for model training.
   *
   * This determines how many panels to optimize for, and which serving
   * configs to consider for each panel.
   * The purpose of this model is to optimize which
   * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig] to show on which
   * panels in way that optimizes the visitors shopping journey.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.Model.PageOptimizationConfig}
   */
  public static final class PageOptimizationConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.Model.PageOptimizationConfig)
      PageOptimizationConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PageOptimizationConfig.newBuilder() to construct.
    private PageOptimizationConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PageOptimizationConfig() {
      pageOptimizationEventType_ = "";
      panels_ = java.util.Collections.emptyList();
      restriction_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PageOptimizationConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.ModelProto
          .internal_static_google_cloud_retail_v2alpha_Model_PageOptimizationConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.ModelProto
          .internal_static_google_cloud_retail_v2alpha_Model_PageOptimizationConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.class,
              com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Restrictions of expected returned results.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Restriction}
     */
    public enum Restriction implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified value for restriction.
       * </pre>
       *
       * <code>RESTRICTION_UNSPECIFIED = 0;</code>
       */
      RESTRICTION_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Allow any [ServingConfig][google.cloud.retail.v2alpha.ServingConfig] to
       * be show on any number of panels.
       *
       * Example:
       *
       * `Panel1 candidates`: pdp_ctr, pdp_cvr, home_page_ctr_no_diversity
       *
       * `Panel2 candidates`: home_page_ctr_no_diversity,
       * home_page_ctr_diversity,
       *  pdp_cvr_no_diversity
       *
       * `Restriction` = NO_RESTRICTION
       *
       * `Valid combinations`:
       *
       *   * &lt;i&gt; (pdp_ctr, home_page_ctr_no_diversity)
       *   * (pdp_ctr, home_page_ctr_diversity)
       *   * (pdp_ctr, pdp_cvr_no_diversity)
       *   * (pdp_cvr, home_page_ctr_no_diversity)
       *   * (pdp_cvr, home_page_ctr_diversity)
       *   * (pdp_cvr, pdp_cvr_no_diversity)
       *   * (home_page_ctr_no_diversity, home_page_ctr_no_diversity)
       *   * (home_page_ctr_no_diversity, home_page_ctr_diversity)
       *   * (home_page_ctr_no_diversity, pdp_cvr_no_diversity) &lt;/i&gt;
       *
       * `Invalid combinations`: []
       * </pre>
       *
       * <code>NO_RESTRICTION = 1;</code>
       */
      NO_RESTRICTION(1),
      /**
       *
       *
       * <pre>
       * Do not allow the same
       * [ServingConfig.name][google.cloud.retail.v2alpha.ServingConfig.name] to
       * be shown on multiple panels.
       *
       * Example:
       *
       * `Panel1 candidates`: &lt;i&gt; pdp_ctr, pdp_cvr, home_page_ctr_no_diversity
       * &lt;/i&gt;
       *
       * `Panel2 candidates`: &lt;i&gt; home_page_ctr_no_diversity,
       * home_page_ctr_diversity_low,
       *    pdp_cvr_no_diversity &lt;/i&gt;
       *
       * `Restriction` = `UNIQUE_SERVING_CONFIG_RESTRICTION`
       *
       * `Valid combinations`:
       *
       *   * &lt;i&gt; (pdp_ctr, home_page_ctr_no_diversity)
       *   * (pdp_ctr, home_page_ctr_diversity_low)
       *   * (pdp_ctr, pdp_cvr_no_diversity)
       *   * (pdp_ctr, pdp_cvr_no_diversity)
       *   * (pdp_cvr, home_page_ctr_no_diversity)
       *   * (pdp_cvr, home_page_ctr_diversity_low)
       *   * (pdp_cvr, pdp_cvr_no_diversity)
       *   * (home_page_ctr_no_diversity, home_page_ctr_diversity_low)
       *   * (home_page_ctr_no_diversity, pdp_cvr_no_diversity) &lt;/i&gt;
       *
       * `Invalid combinations`:
       *
       *  * &lt;i&gt; (home_page_ctr_no_diversity, home_page_ctr_no_diversity) &lt;/i&gt;
       * </pre>
       *
       * <code>UNIQUE_SERVING_CONFIG_RESTRICTION = 2;</code>
       */
      UNIQUE_SERVING_CONFIG_RESTRICTION(2),
      /**
       *
       *
       * <pre>
       * Do not allow multiple
       * [ServingConfigs][google.cloud.retail.v2alpha.ServingConfig] with same
       * [Model.name][google.cloud.retail.v2alpha.Model.name] to be show on on
       * different panels.
       *
       * Example:
       *
       * `Panel1 candidates`: &lt;i&gt; pdp_ctr, pdp_cvr, home_page_ctr_no_diversity
       * &lt;/i&gt;
       *
       * `Panel2 candidates`: &lt;i&gt; home_page_ctr_no_diversity,
       * home_page_ctr_diversity_low,
       *  pdp_cvr_no_diversity &lt;/i&gt;
       *
       * `Restriction` = `UNIQUE_MODEL_RESTRICTION`
       *
       * `Valid combinations`:
       *
       *  * &lt;i&gt; (pdp_ctr, home_page_ctr_no_diversity)
       *  * (pdp_ctr, home_page_ctr_diversity)
       *  * (pdp_ctr, pdp_cvr_no_diversity)
       *  * (pdp_ctr, pdp_cvr_no_diversity)
       *  * (pdp_cvr, home_page_ctr_no_diversity)
       *  * (pdp_cvr, home_page_ctr_diversity_low)
       *  * (home_page_ctr_no_diversity, pdp_cvr_no_diversity) &lt;/i&gt;
       *
       * `Invalid combinations`:
       *
       *  *  &lt;i&gt; (home_page_ctr_no_diversity, home_page_ctr_no_diversity)
       *  * (pdp_cvr, pdp_cvr_no_diversity) &lt;/i&gt;
       * </pre>
       *
       * <code>UNIQUE_MODEL_RESTRICTION = 3;</code>
       */
      UNIQUE_MODEL_RESTRICTION(3),
      /**
       *
       *
       * <pre>
       * Do not allow multiple
       * [ServingConfigs][google.cloud.retail.v2alpha.ServingConfig] with same
       * [Model.type][google.cloud.retail.v2alpha.Model.type] to be shown on
       * different panels.
       *
       * Example:
       *
       * `Panel1 candidates`: &lt;i&gt; pdp_ctr, pdp_cvr, home_page_ctr_no_diversity
       * &lt;/i&gt;
       *
       * `Panel2 candidates`: &lt;i&gt; home_page_ctr_no_diversity,
       * home_page_ctr_diversity_low,
       *  pdp_cvr_no_diversity &lt;/i&gt;
       *
       * `Restriction` = `UNIQUE_MODEL_RESTRICTION`
       *
       * `Valid combinations`:
       *
       * * &lt;i&gt; (pdp_ctr, home_page_ctr_no_diversity)
       * * (pdp_ctr, home_page_ctr_diversity)
       * * (pdp_cvr, home_page_ctr_no_diversity)
       * *   (pdp_cvr, home_page_ctr_diversity_low)
       * * (home_page_ctr_no_diversity, pdp_cvr_no_diversity) &lt;/i&gt;
       *
       * `Invalid combinations`:
       *
       *  *  &lt;i&gt; (pdp_ctr, pdp_cvr_no_diversity)
       *  * (pdp_ctr, pdp_cvr_no_diversity)
       *  * (pdp_cvr, pdp_cvr_no_diversity)
       *  * (home_page_ctr_no_diversity, home_page_ctr_no_diversity)
       *  *  (home_page_ctr_no_diversity, home_page_ctr_diversity) &lt;/i&gt;
       * </pre>
       *
       * <code>UNIQUE_MODEL_TYPE_RESTRICTION = 4;</code>
       */
      UNIQUE_MODEL_TYPE_RESTRICTION(4),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified value for restriction.
       * </pre>
       *
       * <code>RESTRICTION_UNSPECIFIED = 0;</code>
       */
      public static final int RESTRICTION_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Allow any [ServingConfig][google.cloud.retail.v2alpha.ServingConfig] to
       * be show on any number of panels.
       *
       * Example:
       *
       * `Panel1 candidates`: pdp_ctr, pdp_cvr, home_page_ctr_no_diversity
       *
       * `Panel2 candidates`: home_page_ctr_no_diversity,
       * home_page_ctr_diversity,
       *  pdp_cvr_no_diversity
       *
       * `Restriction` = NO_RESTRICTION
       *
       * `Valid combinations`:
       *
       *   * &lt;i&gt; (pdp_ctr, home_page_ctr_no_diversity)
       *   * (pdp_ctr, home_page_ctr_diversity)
       *   * (pdp_ctr, pdp_cvr_no_diversity)
       *   * (pdp_cvr, home_page_ctr_no_diversity)
       *   * (pdp_cvr, home_page_ctr_diversity)
       *   * (pdp_cvr, pdp_cvr_no_diversity)
       *   * (home_page_ctr_no_diversity, home_page_ctr_no_diversity)
       *   * (home_page_ctr_no_diversity, home_page_ctr_diversity)
       *   * (home_page_ctr_no_diversity, pdp_cvr_no_diversity) &lt;/i&gt;
       *
       * `Invalid combinations`: []
       * </pre>
       *
       * <code>NO_RESTRICTION = 1;</code>
       */
      public static final int NO_RESTRICTION_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Do not allow the same
       * [ServingConfig.name][google.cloud.retail.v2alpha.ServingConfig.name] to
       * be shown on multiple panels.
       *
       * Example:
       *
       * `Panel1 candidates`: &lt;i&gt; pdp_ctr, pdp_cvr, home_page_ctr_no_diversity
       * &lt;/i&gt;
       *
       * `Panel2 candidates`: &lt;i&gt; home_page_ctr_no_diversity,
       * home_page_ctr_diversity_low,
       *    pdp_cvr_no_diversity &lt;/i&gt;
       *
       * `Restriction` = `UNIQUE_SERVING_CONFIG_RESTRICTION`
       *
       * `Valid combinations`:
       *
       *   * &lt;i&gt; (pdp_ctr, home_page_ctr_no_diversity)
       *   * (pdp_ctr, home_page_ctr_diversity_low)
       *   * (pdp_ctr, pdp_cvr_no_diversity)
       *   * (pdp_ctr, pdp_cvr_no_diversity)
       *   * (pdp_cvr, home_page_ctr_no_diversity)
       *   * (pdp_cvr, home_page_ctr_diversity_low)
       *   * (pdp_cvr, pdp_cvr_no_diversity)
       *   * (home_page_ctr_no_diversity, home_page_ctr_diversity_low)
       *   * (home_page_ctr_no_diversity, pdp_cvr_no_diversity) &lt;/i&gt;
       *
       * `Invalid combinations`:
       *
       *  * &lt;i&gt; (home_page_ctr_no_diversity, home_page_ctr_no_diversity) &lt;/i&gt;
       * </pre>
       *
       * <code>UNIQUE_SERVING_CONFIG_RESTRICTION = 2;</code>
       */
      public static final int UNIQUE_SERVING_CONFIG_RESTRICTION_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Do not allow multiple
       * [ServingConfigs][google.cloud.retail.v2alpha.ServingConfig] with same
       * [Model.name][google.cloud.retail.v2alpha.Model.name] to be show on on
       * different panels.
       *
       * Example:
       *
       * `Panel1 candidates`: &lt;i&gt; pdp_ctr, pdp_cvr, home_page_ctr_no_diversity
       * &lt;/i&gt;
       *
       * `Panel2 candidates`: &lt;i&gt; home_page_ctr_no_diversity,
       * home_page_ctr_diversity_low,
       *  pdp_cvr_no_diversity &lt;/i&gt;
       *
       * `Restriction` = `UNIQUE_MODEL_RESTRICTION`
       *
       * `Valid combinations`:
       *
       *  * &lt;i&gt; (pdp_ctr, home_page_ctr_no_diversity)
       *  * (pdp_ctr, home_page_ctr_diversity)
       *  * (pdp_ctr, pdp_cvr_no_diversity)
       *  * (pdp_ctr, pdp_cvr_no_diversity)
       *  * (pdp_cvr, home_page_ctr_no_diversity)
       *  * (pdp_cvr, home_page_ctr_diversity_low)
       *  * (home_page_ctr_no_diversity, pdp_cvr_no_diversity) &lt;/i&gt;
       *
       * `Invalid combinations`:
       *
       *  *  &lt;i&gt; (home_page_ctr_no_diversity, home_page_ctr_no_diversity)
       *  * (pdp_cvr, pdp_cvr_no_diversity) &lt;/i&gt;
       * </pre>
       *
       * <code>UNIQUE_MODEL_RESTRICTION = 3;</code>
       */
      public static final int UNIQUE_MODEL_RESTRICTION_VALUE = 3;
      /**
       *
       *
       * <pre>
       * Do not allow multiple
       * [ServingConfigs][google.cloud.retail.v2alpha.ServingConfig] with same
       * [Model.type][google.cloud.retail.v2alpha.Model.type] to be shown on
       * different panels.
       *
       * Example:
       *
       * `Panel1 candidates`: &lt;i&gt; pdp_ctr, pdp_cvr, home_page_ctr_no_diversity
       * &lt;/i&gt;
       *
       * `Panel2 candidates`: &lt;i&gt; home_page_ctr_no_diversity,
       * home_page_ctr_diversity_low,
       *  pdp_cvr_no_diversity &lt;/i&gt;
       *
       * `Restriction` = `UNIQUE_MODEL_RESTRICTION`
       *
       * `Valid combinations`:
       *
       * * &lt;i&gt; (pdp_ctr, home_page_ctr_no_diversity)
       * * (pdp_ctr, home_page_ctr_diversity)
       * * (pdp_cvr, home_page_ctr_no_diversity)
       * *   (pdp_cvr, home_page_ctr_diversity_low)
       * * (home_page_ctr_no_diversity, pdp_cvr_no_diversity) &lt;/i&gt;
       *
       * `Invalid combinations`:
       *
       *  *  &lt;i&gt; (pdp_ctr, pdp_cvr_no_diversity)
       *  * (pdp_ctr, pdp_cvr_no_diversity)
       *  * (pdp_cvr, pdp_cvr_no_diversity)
       *  * (home_page_ctr_no_diversity, home_page_ctr_no_diversity)
       *  *  (home_page_ctr_no_diversity, home_page_ctr_diversity) &lt;/i&gt;
       * </pre>
       *
       * <code>UNIQUE_MODEL_TYPE_RESTRICTION = 4;</code>
       */
      public static final int UNIQUE_MODEL_TYPE_RESTRICTION_VALUE = 4;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Restriction valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Restriction forNumber(int value) {
        switch (value) {
          case 0:
            return RESTRICTION_UNSPECIFIED;
          case 1:
            return NO_RESTRICTION;
          case 2:
            return UNIQUE_SERVING_CONFIG_RESTRICTION;
          case 3:
            return UNIQUE_MODEL_RESTRICTION;
          case 4:
            return UNIQUE_MODEL_TYPE_RESTRICTION;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Restriction> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Restriction> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Restriction>() {
            public Restriction findValueByNumber(int number) {
              return Restriction.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Restriction[] VALUES = values();

      public static Restriction valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Restriction(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Restriction)
    }

    public interface CandidateOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * This has to be a valid
       * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig]
       * identifier. For example, for a ServingConfig with full name:
       * `projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/my_candidate_config`,
       * this would be `my_candidate_config`.
       * </pre>
       *
       * <code>string serving_config_id = 1;</code>
       *
       * @return Whether the servingConfigId field is set.
       */
      boolean hasServingConfigId();
      /**
       *
       *
       * <pre>
       * This has to be a valid
       * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig]
       * identifier. For example, for a ServingConfig with full name:
       * `projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/my_candidate_config`,
       * this would be `my_candidate_config`.
       * </pre>
       *
       * <code>string serving_config_id = 1;</code>
       *
       * @return The servingConfigId.
       */
      java.lang.String getServingConfigId();
      /**
       *
       *
       * <pre>
       * This has to be a valid
       * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig]
       * identifier. For example, for a ServingConfig with full name:
       * `projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/my_candidate_config`,
       * this would be `my_candidate_config`.
       * </pre>
       *
       * <code>string serving_config_id = 1;</code>
       *
       * @return The bytes for servingConfigId.
       */
      com.google.protobuf.ByteString getServingConfigIdBytes();

      com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate.CandidateCase
          getCandidateCase();
    }
    /**
     *
     *
     * <pre>
     * A candidate to consider for a given panel. Currently only
     * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig] are valid
     * candidates.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate}
     */
    public static final class Candidate extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate)
        CandidateOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Candidate.newBuilder() to construct.
      private Candidate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Candidate() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Candidate();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.ModelProto
            .internal_static_google_cloud_retail_v2alpha_Model_PageOptimizationConfig_Candidate_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.ModelProto
            .internal_static_google_cloud_retail_v2alpha_Model_PageOptimizationConfig_Candidate_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate.class,
                com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate.Builder
                    .class);
      }

      private int candidateCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object candidate_;

      public enum CandidateCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        SERVING_CONFIG_ID(1),
        CANDIDATE_NOT_SET(0);
        private final int value;

        private CandidateCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static CandidateCase valueOf(int value) {
          return forNumber(value);
        }

        public static CandidateCase forNumber(int value) {
          switch (value) {
            case 1:
              return SERVING_CONFIG_ID;
            case 0:
              return CANDIDATE_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public CandidateCase getCandidateCase() {
        return CandidateCase.forNumber(candidateCase_);
      }

      public static final int SERVING_CONFIG_ID_FIELD_NUMBER = 1;
      /**
       *
       *
       * <pre>
       * This has to be a valid
       * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig]
       * identifier. For example, for a ServingConfig with full name:
       * `projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/my_candidate_config`,
       * this would be `my_candidate_config`.
       * </pre>
       *
       * <code>string serving_config_id = 1;</code>
       *
       * @return Whether the servingConfigId field is set.
       */
      public boolean hasServingConfigId() {
        return candidateCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * This has to be a valid
       * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig]
       * identifier. For example, for a ServingConfig with full name:
       * `projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/my_candidate_config`,
       * this would be `my_candidate_config`.
       * </pre>
       *
       * <code>string serving_config_id = 1;</code>
       *
       * @return The servingConfigId.
       */
      public java.lang.String getServingConfigId() {
        java.lang.Object ref = "";
        if (candidateCase_ == 1) {
          ref = candidate_;
        }
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (candidateCase_ == 1) {
            candidate_ = s;
          }
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * This has to be a valid
       * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig]
       * identifier. For example, for a ServingConfig with full name:
       * `projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/my_candidate_config`,
       * this would be `my_candidate_config`.
       * </pre>
       *
       * <code>string serving_config_id = 1;</code>
       *
       * @return The bytes for servingConfigId.
       */
      public com.google.protobuf.ByteString getServingConfigIdBytes() {
        java.lang.Object ref = "";
        if (candidateCase_ == 1) {
          ref = candidate_;
        }
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (candidateCase_ == 1) {
            candidate_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (candidateCase_ == 1) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, candidate_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (candidateCase_ == 1) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, candidate_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate)) {
          return super.equals(obj);
        }
        com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate other =
            (com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate) obj;

        if (!getCandidateCase().equals(other.getCandidateCase())) return false;
        switch (candidateCase_) {
          case 1:
            if (!getServingConfigId().equals(other.getServingConfigId())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        switch (candidateCase_) {
          case 1:
            hash = (37 * hash) + SERVING_CONFIG_ID_FIELD_NUMBER;
            hash = (53 * hash) + getServingConfigId().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A candidate to consider for a given panel. Currently only
       * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig] are valid
       * candidates.
       * </pre>
       *
       * Protobuf type {@code google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate)
          com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.CandidateOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.retail.v2alpha.ModelProto
              .internal_static_google_cloud_retail_v2alpha_Model_PageOptimizationConfig_Candidate_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.retail.v2alpha.ModelProto
              .internal_static_google_cloud_retail_v2alpha_Model_PageOptimizationConfig_Candidate_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate.class,
                  com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          candidateCase_ = 0;
          candidate_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.retail.v2alpha.ModelProto
              .internal_static_google_cloud_retail_v2alpha_Model_PageOptimizationConfig_Candidate_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
            getDefaultInstanceForType() {
          return com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate build() {
          com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
            buildPartial() {
          com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate result =
              new com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate result) {
          int from_bitField0_ = bitField0_;
        }

        private void buildPartialOneofs(
            com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate result) {
          result.candidateCase_ = candidateCase_;
          result.candidate_ = this.candidate_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate) {
            return mergeFrom(
                (com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate other) {
          if (other
              == com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
                  .getDefaultInstance()) return this;
          switch (other.getCandidateCase()) {
            case SERVING_CONFIG_ID:
              {
                candidateCase_ = 1;
                candidate_ = other.candidate_;
                onChanged();
                break;
              }
            case CANDIDATE_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    candidateCase_ = 1;
                    candidate_ = s;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int candidateCase_ = 0;
        private java.lang.Object candidate_;

        public CandidateCase getCandidateCase() {
          return CandidateCase.forNumber(candidateCase_);
        }

        public Builder clearCandidate() {
          candidateCase_ = 0;
          candidate_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        /**
         *
         *
         * <pre>
         * This has to be a valid
         * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig]
         * identifier. For example, for a ServingConfig with full name:
         * `projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/my_candidate_config`,
         * this would be `my_candidate_config`.
         * </pre>
         *
         * <code>string serving_config_id = 1;</code>
         *
         * @return Whether the servingConfigId field is set.
         */
        @java.lang.Override
        public boolean hasServingConfigId() {
          return candidateCase_ == 1;
        }
        /**
         *
         *
         * <pre>
         * This has to be a valid
         * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig]
         * identifier. For example, for a ServingConfig with full name:
         * `projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/my_candidate_config`,
         * this would be `my_candidate_config`.
         * </pre>
         *
         * <code>string serving_config_id = 1;</code>
         *
         * @return The servingConfigId.
         */
        @java.lang.Override
        public java.lang.String getServingConfigId() {
          java.lang.Object ref = "";
          if (candidateCase_ == 1) {
            ref = candidate_;
          }
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (candidateCase_ == 1) {
              candidate_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * This has to be a valid
         * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig]
         * identifier. For example, for a ServingConfig with full name:
         * `projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/my_candidate_config`,
         * this would be `my_candidate_config`.
         * </pre>
         *
         * <code>string serving_config_id = 1;</code>
         *
         * @return The bytes for servingConfigId.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getServingConfigIdBytes() {
          java.lang.Object ref = "";
          if (candidateCase_ == 1) {
            ref = candidate_;
          }
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            if (candidateCase_ == 1) {
              candidate_ = b;
            }
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * This has to be a valid
         * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig]
         * identifier. For example, for a ServingConfig with full name:
         * `projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/my_candidate_config`,
         * this would be `my_candidate_config`.
         * </pre>
         *
         * <code>string serving_config_id = 1;</code>
         *
         * @param value The servingConfigId to set.
         * @return This builder for chaining.
         */
        public Builder setServingConfigId(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          candidateCase_ = 1;
          candidate_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * This has to be a valid
         * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig]
         * identifier. For example, for a ServingConfig with full name:
         * `projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/my_candidate_config`,
         * this would be `my_candidate_config`.
         * </pre>
         *
         * <code>string serving_config_id = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearServingConfigId() {
          if (candidateCase_ == 1) {
            candidateCase_ = 0;
            candidate_ = null;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * This has to be a valid
         * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig]
         * identifier. For example, for a ServingConfig with full name:
         * `projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/my_candidate_config`,
         * this would be `my_candidate_config`.
         * </pre>
         *
         * <code>string serving_config_id = 1;</code>
         *
         * @param value The bytes for servingConfigId to set.
         * @return This builder for chaining.
         */
        public Builder setServingConfigIdBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          candidateCase_ = 1;
          candidate_ = value;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate)
      private static final com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate();
      }

      public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Candidate> PARSER =
          new com.google.protobuf.AbstractParser<Candidate>() {
            @java.lang.Override
            public Candidate parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Candidate> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Candidate> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface PanelOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. The name to display for the panel.
       * </pre>
       *
       * <code>string display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The displayName.
       */
      java.lang.String getDisplayName();
      /**
       *
       *
       * <pre>
       * Optional. The name to display for the panel.
       * </pre>
       *
       * <code>string display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for displayName.
       */
      com.google.protobuf.ByteString getDisplayNameBytes();

      /**
       *
       *
       * <pre>
       * Required. The candidates to consider on the panel.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      java.util.List<com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate>
          getCandidatesList();
      /**
       *
       *
       * <pre>
       * Required. The candidates to consider on the panel.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate getCandidates(
          int index);
      /**
       *
       *
       * <pre>
       * Required. The candidates to consider on the panel.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      int getCandidatesCount();
      /**
       *
       *
       * <pre>
       * Required. The candidates to consider on the panel.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.CandidateOrBuilder>
          getCandidatesOrBuilderList();
      /**
       *
       *
       * <pre>
       * Required. The candidates to consider on the panel.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.CandidateOrBuilder
          getCandidatesOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * Required. The default candidate. If the model fails at serving time,
       * we fall back to the default.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate default_candidate = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the defaultCandidate field is set.
       */
      boolean hasDefaultCandidate();
      /**
       *
       *
       * <pre>
       * Required. The default candidate. If the model fails at serving time,
       * we fall back to the default.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate default_candidate = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The defaultCandidate.
       */
      com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate getDefaultCandidate();
      /**
       *
       *
       * <pre>
       * Required. The default candidate. If the model fails at serving time,
       * we fall back to the default.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate default_candidate = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.CandidateOrBuilder
          getDefaultCandidateOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * An individual panel with a list of
     * [ServingConfigs][google.cloud.retail.v2alpha.ServingConfig] to consider
     * for it.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel}
     */
    public static final class Panel extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel)
        PanelOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Panel.newBuilder() to construct.
      private Panel(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Panel() {
        displayName_ = "";
        candidates_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Panel();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.ModelProto
            .internal_static_google_cloud_retail_v2alpha_Model_PageOptimizationConfig_Panel_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.ModelProto
            .internal_static_google_cloud_retail_v2alpha_Model_PageOptimizationConfig_Panel_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel.class,
                com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel.Builder.class);
      }

      private int bitField0_;
      public static final int DISPLAY_NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object displayName_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The name to display for the panel.
       * </pre>
       *
       * <code>string display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The displayName.
       */
      @java.lang.Override
      public java.lang.String getDisplayName() {
        java.lang.Object ref = displayName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayName_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The name to display for the panel.
       * </pre>
       *
       * <code>string display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for displayName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDisplayNameBytes() {
        java.lang.Object ref = displayName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int CANDIDATES_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate>
          candidates_;
      /**
       *
       *
       * <pre>
       * Required. The candidates to consider on the panel.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate>
          getCandidatesList() {
        return candidates_;
      }
      /**
       *
       *
       * <pre>
       * Required. The candidates to consider on the panel.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.CandidateOrBuilder>
          getCandidatesOrBuilderList() {
        return candidates_;
      }
      /**
       *
       *
       * <pre>
       * Required. The candidates to consider on the panel.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public int getCandidatesCount() {
        return candidates_.size();
      }
      /**
       *
       *
       * <pre>
       * Required. The candidates to consider on the panel.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate getCandidates(
          int index) {
        return candidates_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Required. The candidates to consider on the panel.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.CandidateOrBuilder
          getCandidatesOrBuilder(int index) {
        return candidates_.get(index);
      }

      public static final int DEFAULT_CANDIDATE_FIELD_NUMBER = 3;
      private com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
          defaultCandidate_;
      /**
       *
       *
       * <pre>
       * Required. The default candidate. If the model fails at serving time,
       * we fall back to the default.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate default_candidate = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the defaultCandidate field is set.
       */
      @java.lang.Override
      public boolean hasDefaultCandidate() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. The default candidate. If the model fails at serving time,
       * we fall back to the default.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate default_candidate = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The defaultCandidate.
       */
      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
          getDefaultCandidate() {
        return defaultCandidate_ == null
            ? com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
                .getDefaultInstance()
            : defaultCandidate_;
      }
      /**
       *
       *
       * <pre>
       * Required. The default candidate. If the model fails at serving time,
       * we fall back to the default.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate default_candidate = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.CandidateOrBuilder
          getDefaultCandidateOrBuilder() {
        return defaultCandidate_ == null
            ? com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
                .getDefaultInstance()
            : defaultCandidate_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
        }
        for (int i = 0; i < candidates_.size(); i++) {
          output.writeMessage(2, candidates_.get(i));
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(3, getDefaultCandidate());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
        }
        for (int i = 0; i < candidates_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, candidates_.get(i));
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(3, getDefaultCandidate());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel)) {
          return super.equals(obj);
        }
        com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel other =
            (com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel) obj;

        if (!getDisplayName().equals(other.getDisplayName())) return false;
        if (!getCandidatesList().equals(other.getCandidatesList())) return false;
        if (hasDefaultCandidate() != other.hasDefaultCandidate()) return false;
        if (hasDefaultCandidate()) {
          if (!getDefaultCandidate().equals(other.getDefaultCandidate())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getDisplayName().hashCode();
        if (getCandidatesCount() > 0) {
          hash = (37 * hash) + CANDIDATES_FIELD_NUMBER;
          hash = (53 * hash) + getCandidatesList().hashCode();
        }
        if (hasDefaultCandidate()) {
          hash = (37 * hash) + DEFAULT_CANDIDATE_FIELD_NUMBER;
          hash = (53 * hash) + getDefaultCandidate().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * An individual panel with a list of
       * [ServingConfigs][google.cloud.retail.v2alpha.ServingConfig] to consider
       * for it.
       * </pre>
       *
       * Protobuf type {@code google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel)
          com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.PanelOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.retail.v2alpha.ModelProto
              .internal_static_google_cloud_retail_v2alpha_Model_PageOptimizationConfig_Panel_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.retail.v2alpha.ModelProto
              .internal_static_google_cloud_retail_v2alpha_Model_PageOptimizationConfig_Panel_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel.class,
                  com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel.Builder.class);
        }

        // Construct using
        // com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getCandidatesFieldBuilder();
            getDefaultCandidateFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          displayName_ = "";
          if (candidatesBuilder_ == null) {
            candidates_ = java.util.Collections.emptyList();
          } else {
            candidates_ = null;
            candidatesBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          defaultCandidate_ = null;
          if (defaultCandidateBuilder_ != null) {
            defaultCandidateBuilder_.dispose();
            defaultCandidateBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.retail.v2alpha.ModelProto
              .internal_static_google_cloud_retail_v2alpha_Model_PageOptimizationConfig_Panel_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel
            getDefaultInstanceForType() {
          return com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel build() {
          com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel buildPartial() {
          com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel result =
              new com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel result) {
          if (candidatesBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)) {
              candidates_ = java.util.Collections.unmodifiableList(candidates_);
              bitField0_ = (bitField0_ & ~0x00000002);
            }
            result.candidates_ = candidates_;
          } else {
            result.candidates_ = candidatesBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.displayName_ = displayName_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.defaultCandidate_ =
                defaultCandidateBuilder_ == null
                    ? defaultCandidate_
                    : defaultCandidateBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel) {
            return mergeFrom(
                (com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel other) {
          if (other
              == com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel
                  .getDefaultInstance()) return this;
          if (!other.getDisplayName().isEmpty()) {
            displayName_ = other.displayName_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (candidatesBuilder_ == null) {
            if (!other.candidates_.isEmpty()) {
              if (candidates_.isEmpty()) {
                candidates_ = other.candidates_;
                bitField0_ = (bitField0_ & ~0x00000002);
              } else {
                ensureCandidatesIsMutable();
                candidates_.addAll(other.candidates_);
              }
              onChanged();
            }
          } else {
            if (!other.candidates_.isEmpty()) {
              if (candidatesBuilder_.isEmpty()) {
                candidatesBuilder_.dispose();
                candidatesBuilder_ = null;
                candidates_ = other.candidates_;
                bitField0_ = (bitField0_ & ~0x00000002);
                candidatesBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getCandidatesFieldBuilder()
                        : null;
              } else {
                candidatesBuilder_.addAllMessages(other.candidates_);
              }
            }
          }
          if (other.hasDefaultCandidate()) {
            mergeDefaultCandidate(other.getDefaultCandidate());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    displayName_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate m =
                        input.readMessage(
                            com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
                                .parser(),
                            extensionRegistry);
                    if (candidatesBuilder_ == null) {
                      ensureCandidatesIsMutable();
                      candidates_.add(m);
                    } else {
                      candidatesBuilder_.addMessage(m);
                    }
                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(
                        getDefaultCandidateFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object displayName_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The name to display for the panel.
         * </pre>
         *
         * <code>string display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The displayName.
         */
        public java.lang.String getDisplayName() {
          java.lang.Object ref = displayName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            displayName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The name to display for the panel.
         * </pre>
         *
         * <code>string display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for displayName.
         */
        public com.google.protobuf.ByteString getDisplayNameBytes() {
          java.lang.Object ref = displayName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            displayName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The name to display for the panel.
         * </pre>
         *
         * <code>string display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The displayName to set.
         * @return This builder for chaining.
         */
        public Builder setDisplayName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          displayName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The name to display for the panel.
         * </pre>
         *
         * <code>string display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDisplayName() {
          displayName_ = getDefaultInstance().getDisplayName();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The name to display for the panel.
         * </pre>
         *
         * <code>string display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for displayName to set.
         * @return This builder for chaining.
         */
        public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          displayName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.util.List<
                com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate>
            candidates_ = java.util.Collections.emptyList();

        private void ensureCandidatesIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            candidates_ =
                new java.util.ArrayList<
                    com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate>(
                    candidates_);
            bitField0_ |= 0x00000002;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate,
                com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate.Builder,
                com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.CandidateOrBuilder>
            candidatesBuilder_;

        /**
         *
         *
         * <pre>
         * Required. The candidates to consider on the panel.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<
                com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate>
            getCandidatesList() {
          if (candidatesBuilder_ == null) {
            return java.util.Collections.unmodifiableList(candidates_);
          } else {
            return candidatesBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The candidates to consider on the panel.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public int getCandidatesCount() {
          if (candidatesBuilder_ == null) {
            return candidates_.size();
          } else {
            return candidatesBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The candidates to consider on the panel.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate getCandidates(
            int index) {
          if (candidatesBuilder_ == null) {
            return candidates_.get(index);
          } else {
            return candidatesBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The candidates to consider on the panel.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setCandidates(
            int index,
            com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate value) {
          if (candidatesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCandidatesIsMutable();
            candidates_.set(index, value);
            onChanged();
          } else {
            candidatesBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The candidates to consider on the panel.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setCandidates(
            int index,
            com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate.Builder
                builderForValue) {
          if (candidatesBuilder_ == null) {
            ensureCandidatesIsMutable();
            candidates_.set(index, builderForValue.build());
            onChanged();
          } else {
            candidatesBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The candidates to consider on the panel.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addCandidates(
            com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate value) {
          if (candidatesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCandidatesIsMutable();
            candidates_.add(value);
            onChanged();
          } else {
            candidatesBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The candidates to consider on the panel.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addCandidates(
            int index,
            com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate value) {
          if (candidatesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCandidatesIsMutable();
            candidates_.add(index, value);
            onChanged();
          } else {
            candidatesBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The candidates to consider on the panel.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addCandidates(
            com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate.Builder
                builderForValue) {
          if (candidatesBuilder_ == null) {
            ensureCandidatesIsMutable();
            candidates_.add(builderForValue.build());
            onChanged();
          } else {
            candidatesBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The candidates to consider on the panel.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addCandidates(
            int index,
            com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate.Builder
                builderForValue) {
          if (candidatesBuilder_ == null) {
            ensureCandidatesIsMutable();
            candidates_.add(index, builderForValue.build());
            onChanged();
          } else {
            candidatesBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The candidates to consider on the panel.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addAllCandidates(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate>
                values) {
          if (candidatesBuilder_ == null) {
            ensureCandidatesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, candidates_);
            onChanged();
          } else {
            candidatesBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The candidates to consider on the panel.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder clearCandidates() {
          if (candidatesBuilder_ == null) {
            candidates_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
          } else {
            candidatesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The candidates to consider on the panel.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder removeCandidates(int index) {
          if (candidatesBuilder_ == null) {
            ensureCandidatesIsMutable();
            candidates_.remove(index);
            onChanged();
          } else {
            candidatesBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The candidates to consider on the panel.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate.Builder
            getCandidatesBuilder(int index) {
          return getCandidatesFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Required. The candidates to consider on the panel.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.CandidateOrBuilder
            getCandidatesOrBuilder(int index) {
          if (candidatesBuilder_ == null) {
            return candidates_.get(index);
          } else {
            return candidatesBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The candidates to consider on the panel.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.CandidateOrBuilder>
            getCandidatesOrBuilderList() {
          if (candidatesBuilder_ != null) {
            return candidatesBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(candidates_);
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The candidates to consider on the panel.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate.Builder
            addCandidatesBuilder() {
          return getCandidatesFieldBuilder()
              .addBuilder(
                  com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Required. The candidates to consider on the panel.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate.Builder
            addCandidatesBuilder(int index) {
          return getCandidatesFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Required. The candidates to consider on the panel.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate candidates = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<
                com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate.Builder>
            getCandidatesBuilderList() {
          return getCandidatesFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate,
                com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate.Builder,
                com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.CandidateOrBuilder>
            getCandidatesFieldBuilder() {
          if (candidatesBuilder_ == null) {
            candidatesBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate,
                    com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate.Builder,
                    com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig
                        .CandidateOrBuilder>(
                    candidates_,
                    ((bitField0_ & 0x00000002) != 0),
                    getParentForChildren(),
                    isClean());
            candidates_ = null;
          }
          return candidatesBuilder_;
        }

        private com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
            defaultCandidate_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate,
                com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate.Builder,
                com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.CandidateOrBuilder>
            defaultCandidateBuilder_;
        /**
         *
         *
         * <pre>
         * Required. The default candidate. If the model fails at serving time,
         * we fall back to the default.
         * </pre>
         *
         * <code>
         * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate default_candidate = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the defaultCandidate field is set.
         */
        public boolean hasDefaultCandidate() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         *
         *
         * <pre>
         * Required. The default candidate. If the model fails at serving time,
         * we fall back to the default.
         * </pre>
         *
         * <code>
         * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate default_candidate = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The defaultCandidate.
         */
        public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
            getDefaultCandidate() {
          if (defaultCandidateBuilder_ == null) {
            return defaultCandidate_ == null
                ? com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
                    .getDefaultInstance()
                : defaultCandidate_;
          } else {
            return defaultCandidateBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The default candidate. If the model fails at serving time,
         * we fall back to the default.
         * </pre>
         *
         * <code>
         * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate default_candidate = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setDefaultCandidate(
            com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate value) {
          if (defaultCandidateBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            defaultCandidate_ = value;
          } else {
            defaultCandidateBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The default candidate. If the model fails at serving time,
         * we fall back to the default.
         * </pre>
         *
         * <code>
         * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate default_candidate = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setDefaultCandidate(
            com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate.Builder
                builderForValue) {
          if (defaultCandidateBuilder_ == null) {
            defaultCandidate_ = builderForValue.build();
          } else {
            defaultCandidateBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The default candidate. If the model fails at serving time,
         * we fall back to the default.
         * </pre>
         *
         * <code>
         * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate default_candidate = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder mergeDefaultCandidate(
            com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate value) {
          if (defaultCandidateBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)
                && defaultCandidate_ != null
                && defaultCandidate_
                    != com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
                        .getDefaultInstance()) {
              getDefaultCandidateBuilder().mergeFrom(value);
            } else {
              defaultCandidate_ = value;
            }
          } else {
            defaultCandidateBuilder_.mergeFrom(value);
          }
          if (defaultCandidate_ != null) {
            bitField0_ |= 0x00000004;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The default candidate. If the model fails at serving time,
         * we fall back to the default.
         * </pre>
         *
         * <code>
         * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate default_candidate = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder clearDefaultCandidate() {
          bitField0_ = (bitField0_ & ~0x00000004);
          defaultCandidate_ = null;
          if (defaultCandidateBuilder_ != null) {
            defaultCandidateBuilder_.dispose();
            defaultCandidateBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The default candidate. If the model fails at serving time,
         * we fall back to the default.
         * </pre>
         *
         * <code>
         * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate default_candidate = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate.Builder
            getDefaultCandidateBuilder() {
          bitField0_ |= 0x00000004;
          onChanged();
          return getDefaultCandidateFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Required. The default candidate. If the model fails at serving time,
         * we fall back to the default.
         * </pre>
         *
         * <code>
         * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate default_candidate = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.CandidateOrBuilder
            getDefaultCandidateOrBuilder() {
          if (defaultCandidateBuilder_ != null) {
            return defaultCandidateBuilder_.getMessageOrBuilder();
          } else {
            return defaultCandidate_ == null
                ? com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate
                    .getDefaultInstance()
                : defaultCandidate_;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The default candidate. If the model fails at serving time,
         * we fall back to the default.
         * </pre>
         *
         * <code>
         * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate default_candidate = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate,
                com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate.Builder,
                com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.CandidateOrBuilder>
            getDefaultCandidateFieldBuilder() {
          if (defaultCandidateBuilder_ == null) {
            defaultCandidateBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate,
                    com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Candidate.Builder,
                    com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig
                        .CandidateOrBuilder>(
                    getDefaultCandidate(), getParentForChildren(), isClean());
            defaultCandidate_ = null;
          }
          return defaultCandidateBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel)
      private static final com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel();
      }

      public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Panel> PARSER =
          new com.google.protobuf.AbstractParser<Panel>() {
            @java.lang.Override
            public Panel parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Panel> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Panel> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int PAGE_OPTIMIZATION_EVENT_TYPE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object pageOptimizationEventType_ = "";
    /**
     *
     *
     * <pre>
     * Required. The type of [UserEvent][google.cloud.retail.v2alpha.UserEvent]
     * this page optimization is shown for.
     *
     * Each page has an associated event type - this will be the
     * corresponding event type for the page that the page optimization
     * model is used on.
     *
     * Supported types:
     *
     * * `add-to-cart`: Products being added to cart.
     * * `detail-page-view`: Products detail page viewed.
     * * `home-page-view`: Homepage viewed
     * * `category-page-view`: Homepage viewed
     * * `shopping-cart-page-view`: User viewing a shopping cart.
     *
     * `home-page-view` only allows models with type `recommended-for-you`.
     * All other page_optimization_event_type allow all
     * [Model.types][google.cloud.retail.v2alpha.Model.type].
     * </pre>
     *
     * <code>string page_optimization_event_type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The pageOptimizationEventType.
     */
    @java.lang.Override
    public java.lang.String getPageOptimizationEventType() {
      java.lang.Object ref = pageOptimizationEventType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageOptimizationEventType_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The type of [UserEvent][google.cloud.retail.v2alpha.UserEvent]
     * this page optimization is shown for.
     *
     * Each page has an associated event type - this will be the
     * corresponding event type for the page that the page optimization
     * model is used on.
     *
     * Supported types:
     *
     * * `add-to-cart`: Products being added to cart.
     * * `detail-page-view`: Products detail page viewed.
     * * `home-page-view`: Homepage viewed
     * * `category-page-view`: Homepage viewed
     * * `shopping-cart-page-view`: User viewing a shopping cart.
     *
     * `home-page-view` only allows models with type `recommended-for-you`.
     * All other page_optimization_event_type allow all
     * [Model.types][google.cloud.retail.v2alpha.Model.type].
     * </pre>
     *
     * <code>string page_optimization_event_type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The bytes for pageOptimizationEventType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPageOptimizationEventTypeBytes() {
      java.lang.Object ref = pageOptimizationEventType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageOptimizationEventType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PANELS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel>
        panels_;
    /**
     *
     *
     * <pre>
     * Required. A list of panel configurations.
     *
     * Limit = 5.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel>
        getPanelsList() {
      return panels_;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of panel configurations.
     *
     * Limit = 5.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.PanelOrBuilder>
        getPanelsOrBuilderList() {
      return panels_;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of panel configurations.
     *
     * Limit = 5.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public int getPanelsCount() {
      return panels_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. A list of panel configurations.
     *
     * Limit = 5.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel getPanels(int index) {
      return panels_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. A list of panel configurations.
     *
     * Limit = 5.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.PanelOrBuilder
        getPanelsOrBuilder(int index) {
      return panels_.get(index);
    }

    public static final int RESTRICTION_FIELD_NUMBER = 3;
    private int restriction_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. How to restrict results across panels e.g. can the same
     * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig] be shown on
     * multiple panels at once.
     *
     * If unspecified, default to `UNIQUE_MODEL_RESTRICTION`.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Restriction restriction = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for restriction.
     */
    @java.lang.Override
    public int getRestrictionValue() {
      return restriction_;
    }
    /**
     *
     *
     * <pre>
     * Optional. How to restrict results across panels e.g. can the same
     * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig] be shown on
     * multiple panels at once.
     *
     * If unspecified, default to `UNIQUE_MODEL_RESTRICTION`.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Restriction restriction = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The restriction.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Restriction
        getRestriction() {
      com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Restriction result =
          com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Restriction.forNumber(
              restriction_);
      return result == null
          ? com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Restriction.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageOptimizationEventType_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, pageOptimizationEventType_);
      }
      for (int i = 0; i < panels_.size(); i++) {
        output.writeMessage(2, panels_.get(i));
      }
      if (restriction_
          != com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Restriction
              .RESTRICTION_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(3, restriction_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageOptimizationEventType_)) {
        size +=
            com.google.protobuf.GeneratedMessageV3.computeStringSize(1, pageOptimizationEventType_);
      }
      for (int i = 0; i < panels_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, panels_.get(i));
      }
      if (restriction_
          != com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Restriction
              .RESTRICTION_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, restriction_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig other =
          (com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig) obj;

      if (!getPageOptimizationEventType().equals(other.getPageOptimizationEventType()))
        return false;
      if (!getPanelsList().equals(other.getPanelsList())) return false;
      if (restriction_ != other.restriction_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PAGE_OPTIMIZATION_EVENT_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getPageOptimizationEventType().hashCode();
      if (getPanelsCount() > 0) {
        hash = (37 * hash) + PANELS_FIELD_NUMBER;
        hash = (53 * hash) + getPanelsList().hashCode();
      }
      hash = (37 * hash) + RESTRICTION_FIELD_NUMBER;
      hash = (53 * hash) + restriction_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The PageOptimizationConfig for model training.
     *
     * This determines how many panels to optimize for, and which serving
     * configs to consider for each panel.
     * The purpose of this model is to optimize which
     * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig] to show on which
     * panels in way that optimizes the visitors shopping journey.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2alpha.Model.PageOptimizationConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.Model.PageOptimizationConfig)
        com.google.cloud.retail.v2alpha.Model.PageOptimizationConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.ModelProto
            .internal_static_google_cloud_retail_v2alpha_Model_PageOptimizationConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.ModelProto
            .internal_static_google_cloud_retail_v2alpha_Model_PageOptimizationConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.class,
                com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Builder.class);
      }

      // Construct using com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        pageOptimizationEventType_ = "";
        if (panelsBuilder_ == null) {
          panels_ = java.util.Collections.emptyList();
        } else {
          panels_ = null;
          panelsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        restriction_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2alpha.ModelProto
            .internal_static_google_cloud_retail_v2alpha_Model_PageOptimizationConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig
          getDefaultInstanceForType() {
        return com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig build() {
        com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig buildPartial() {
        com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig result =
            new com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig result) {
        if (panelsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            panels_ = java.util.Collections.unmodifiableList(panels_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.panels_ = panels_;
        } else {
          result.panels_ = panelsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.pageOptimizationEventType_ = pageOptimizationEventType_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.restriction_ = restriction_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig) {
          return mergeFrom((com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig other) {
        if (other
            == com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.getDefaultInstance())
          return this;
        if (!other.getPageOptimizationEventType().isEmpty()) {
          pageOptimizationEventType_ = other.pageOptimizationEventType_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (panelsBuilder_ == null) {
          if (!other.panels_.isEmpty()) {
            if (panels_.isEmpty()) {
              panels_ = other.panels_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensurePanelsIsMutable();
              panels_.addAll(other.panels_);
            }
            onChanged();
          }
        } else {
          if (!other.panels_.isEmpty()) {
            if (panelsBuilder_.isEmpty()) {
              panelsBuilder_.dispose();
              panelsBuilder_ = null;
              panels_ = other.panels_;
              bitField0_ = (bitField0_ & ~0x00000002);
              panelsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getPanelsFieldBuilder()
                      : null;
            } else {
              panelsBuilder_.addAllMessages(other.panels_);
            }
          }
        }
        if (other.restriction_ != 0) {
          setRestrictionValue(other.getRestrictionValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  pageOptimizationEventType_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel m =
                      input.readMessage(
                          com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel
                              .parser(),
                          extensionRegistry);
                  if (panelsBuilder_ == null) {
                    ensurePanelsIsMutable();
                    panels_.add(m);
                  } else {
                    panelsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              case 24:
                {
                  restriction_ = input.readEnum();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object pageOptimizationEventType_ = "";
      /**
       *
       *
       * <pre>
       * Required. The type of [UserEvent][google.cloud.retail.v2alpha.UserEvent]
       * this page optimization is shown for.
       *
       * Each page has an associated event type - this will be the
       * corresponding event type for the page that the page optimization
       * model is used on.
       *
       * Supported types:
       *
       * * `add-to-cart`: Products being added to cart.
       * * `detail-page-view`: Products detail page viewed.
       * * `home-page-view`: Homepage viewed
       * * `category-page-view`: Homepage viewed
       * * `shopping-cart-page-view`: User viewing a shopping cart.
       *
       * `home-page-view` only allows models with type `recommended-for-you`.
       * All other page_optimization_event_type allow all
       * [Model.types][google.cloud.retail.v2alpha.Model.type].
       * </pre>
       *
       * <code>string page_optimization_event_type = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The pageOptimizationEventType.
       */
      public java.lang.String getPageOptimizationEventType() {
        java.lang.Object ref = pageOptimizationEventType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          pageOptimizationEventType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The type of [UserEvent][google.cloud.retail.v2alpha.UserEvent]
       * this page optimization is shown for.
       *
       * Each page has an associated event type - this will be the
       * corresponding event type for the page that the page optimization
       * model is used on.
       *
       * Supported types:
       *
       * * `add-to-cart`: Products being added to cart.
       * * `detail-page-view`: Products detail page viewed.
       * * `home-page-view`: Homepage viewed
       * * `category-page-view`: Homepage viewed
       * * `shopping-cart-page-view`: User viewing a shopping cart.
       *
       * `home-page-view` only allows models with type `recommended-for-you`.
       * All other page_optimization_event_type allow all
       * [Model.types][google.cloud.retail.v2alpha.Model.type].
       * </pre>
       *
       * <code>string page_optimization_event_type = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The bytes for pageOptimizationEventType.
       */
      public com.google.protobuf.ByteString getPageOptimizationEventTypeBytes() {
        java.lang.Object ref = pageOptimizationEventType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          pageOptimizationEventType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The type of [UserEvent][google.cloud.retail.v2alpha.UserEvent]
       * this page optimization is shown for.
       *
       * Each page has an associated event type - this will be the
       * corresponding event type for the page that the page optimization
       * model is used on.
       *
       * Supported types:
       *
       * * `add-to-cart`: Products being added to cart.
       * * `detail-page-view`: Products detail page viewed.
       * * `home-page-view`: Homepage viewed
       * * `category-page-view`: Homepage viewed
       * * `shopping-cart-page-view`: User viewing a shopping cart.
       *
       * `home-page-view` only allows models with type `recommended-for-you`.
       * All other page_optimization_event_type allow all
       * [Model.types][google.cloud.retail.v2alpha.Model.type].
       * </pre>
       *
       * <code>string page_optimization_event_type = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The pageOptimizationEventType to set.
       * @return This builder for chaining.
       */
      public Builder setPageOptimizationEventType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        pageOptimizationEventType_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The type of [UserEvent][google.cloud.retail.v2alpha.UserEvent]
       * this page optimization is shown for.
       *
       * Each page has an associated event type - this will be the
       * corresponding event type for the page that the page optimization
       * model is used on.
       *
       * Supported types:
       *
       * * `add-to-cart`: Products being added to cart.
       * * `detail-page-view`: Products detail page viewed.
       * * `home-page-view`: Homepage viewed
       * * `category-page-view`: Homepage viewed
       * * `shopping-cart-page-view`: User viewing a shopping cart.
       *
       * `home-page-view` only allows models with type `recommended-for-you`.
       * All other page_optimization_event_type allow all
       * [Model.types][google.cloud.retail.v2alpha.Model.type].
       * </pre>
       *
       * <code>string page_optimization_event_type = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPageOptimizationEventType() {
        pageOptimizationEventType_ = getDefaultInstance().getPageOptimizationEventType();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The type of [UserEvent][google.cloud.retail.v2alpha.UserEvent]
       * this page optimization is shown for.
       *
       * Each page has an associated event type - this will be the
       * corresponding event type for the page that the page optimization
       * model is used on.
       *
       * Supported types:
       *
       * * `add-to-cart`: Products being added to cart.
       * * `detail-page-view`: Products detail page viewed.
       * * `home-page-view`: Homepage viewed
       * * `category-page-view`: Homepage viewed
       * * `shopping-cart-page-view`: User viewing a shopping cart.
       *
       * `home-page-view` only allows models with type `recommended-for-you`.
       * All other page_optimization_event_type allow all
       * [Model.types][google.cloud.retail.v2alpha.Model.type].
       * </pre>
       *
       * <code>string page_optimization_event_type = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The bytes for pageOptimizationEventType to set.
       * @return This builder for chaining.
       */
      public Builder setPageOptimizationEventTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        pageOptimizationEventType_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel>
          panels_ = java.util.Collections.emptyList();

      private void ensurePanelsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          panels_ =
              new java.util.ArrayList<
                  com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel>(panels_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel,
              com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel.Builder,
              com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.PanelOrBuilder>
          panelsBuilder_;

      /**
       *
       *
       * <pre>
       * Required. A list of panel configurations.
       *
       * Limit = 5.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel>
          getPanelsList() {
        if (panelsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(panels_);
        } else {
          return panelsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of panel configurations.
       *
       * Limit = 5.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public int getPanelsCount() {
        if (panelsBuilder_ == null) {
          return panels_.size();
        } else {
          return panelsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of panel configurations.
       *
       * Limit = 5.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel getPanels(
          int index) {
        if (panelsBuilder_ == null) {
          return panels_.get(index);
        } else {
          return panelsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of panel configurations.
       *
       * Limit = 5.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setPanels(
          int index, com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel value) {
        if (panelsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePanelsIsMutable();
          panels_.set(index, value);
          onChanged();
        } else {
          panelsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of panel configurations.
       *
       * Limit = 5.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setPanels(
          int index,
          com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel.Builder
              builderForValue) {
        if (panelsBuilder_ == null) {
          ensurePanelsIsMutable();
          panels_.set(index, builderForValue.build());
          onChanged();
        } else {
          panelsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of panel configurations.
       *
       * Limit = 5.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addPanels(
          com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel value) {
        if (panelsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePanelsIsMutable();
          panels_.add(value);
          onChanged();
        } else {
          panelsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of panel configurations.
       *
       * Limit = 5.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addPanels(
          int index, com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel value) {
        if (panelsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePanelsIsMutable();
          panels_.add(index, value);
          onChanged();
        } else {
          panelsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of panel configurations.
       *
       * Limit = 5.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addPanels(
          com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel.Builder
              builderForValue) {
        if (panelsBuilder_ == null) {
          ensurePanelsIsMutable();
          panels_.add(builderForValue.build());
          onChanged();
        } else {
          panelsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of panel configurations.
       *
       * Limit = 5.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addPanels(
          int index,
          com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel.Builder
              builderForValue) {
        if (panelsBuilder_ == null) {
          ensurePanelsIsMutable();
          panels_.add(index, builderForValue.build());
          onChanged();
        } else {
          panelsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of panel configurations.
       *
       * Limit = 5.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addAllPanels(
          java.lang.Iterable<
                  ? extends com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel>
              values) {
        if (panelsBuilder_ == null) {
          ensurePanelsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, panels_);
          onChanged();
        } else {
          panelsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of panel configurations.
       *
       * Limit = 5.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearPanels() {
        if (panelsBuilder_ == null) {
          panels_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          panelsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of panel configurations.
       *
       * Limit = 5.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder removePanels(int index) {
        if (panelsBuilder_ == null) {
          ensurePanelsIsMutable();
          panels_.remove(index);
          onChanged();
        } else {
          panelsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of panel configurations.
       *
       * Limit = 5.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel.Builder
          getPanelsBuilder(int index) {
        return getPanelsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Required. A list of panel configurations.
       *
       * Limit = 5.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.PanelOrBuilder
          getPanelsOrBuilder(int index) {
        if (panelsBuilder_ == null) {
          return panels_.get(index);
        } else {
          return panelsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of panel configurations.
       *
       * Limit = 5.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.PanelOrBuilder>
          getPanelsOrBuilderList() {
        if (panelsBuilder_ != null) {
          return panelsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(panels_);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of panel configurations.
       *
       * Limit = 5.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel.Builder
          addPanelsBuilder() {
        return getPanelsFieldBuilder()
            .addBuilder(
                com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. A list of panel configurations.
       *
       * Limit = 5.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel.Builder
          addPanelsBuilder(int index) {
        return getPanelsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. A list of panel configurations.
       *
       * Limit = 5.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel panels = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<
              com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel.Builder>
          getPanelsBuilderList() {
        return getPanelsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel,
              com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel.Builder,
              com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.PanelOrBuilder>
          getPanelsFieldBuilder() {
        if (panelsBuilder_ == null) {
          panelsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel,
                  com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Panel.Builder,
                  com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.PanelOrBuilder>(
                  panels_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          panels_ = null;
        }
        return panelsBuilder_;
      }

      private int restriction_ = 0;
      /**
       *
       *
       * <pre>
       * Optional. How to restrict results across panels e.g. can the same
       * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig] be shown on
       * multiple panels at once.
       *
       * If unspecified, default to `UNIQUE_MODEL_RESTRICTION`.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Restriction restriction = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enum numeric value on the wire for restriction.
       */
      @java.lang.Override
      public int getRestrictionValue() {
        return restriction_;
      }
      /**
       *
       *
       * <pre>
       * Optional. How to restrict results across panels e.g. can the same
       * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig] be shown on
       * multiple panels at once.
       *
       * If unspecified, default to `UNIQUE_MODEL_RESTRICTION`.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Restriction restriction = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The enum numeric value on the wire for restriction to set.
       * @return This builder for chaining.
       */
      public Builder setRestrictionValue(int value) {
        restriction_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. How to restrict results across panels e.g. can the same
       * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig] be shown on
       * multiple panels at once.
       *
       * If unspecified, default to `UNIQUE_MODEL_RESTRICTION`.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Restriction restriction = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The restriction.
       */
      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Restriction
          getRestriction() {
        com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Restriction result =
            com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Restriction.forNumber(
                restriction_);
        return result == null
            ? com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Restriction.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Optional. How to restrict results across panels e.g. can the same
       * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig] be shown on
       * multiple panels at once.
       *
       * If unspecified, default to `UNIQUE_MODEL_RESTRICTION`.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Restriction restriction = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The restriction to set.
       * @return This builder for chaining.
       */
      public Builder setRestriction(
          com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Restriction value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        restriction_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. How to restrict results across panels e.g. can the same
       * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig] be shown on
       * multiple panels at once.
       *
       * If unspecified, default to `UNIQUE_MODEL_RESTRICTION`.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Restriction restriction = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRestriction() {
        bitField0_ = (bitField0_ & ~0x00000004);
        restriction_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.Model.PageOptimizationConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.Model.PageOptimizationConfig)
    private static final com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig();
    }

    public static com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PageOptimizationConfig> PARSER =
        new com.google.protobuf.AbstractParser<PageOptimizationConfig>() {
          @java.lang.Override
          public PageOptimizationConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PageOptimizationConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PageOptimizationConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ServingConfigListOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.Model.ServingConfigList)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. A set of valid serving configs that may be used for
     * `PAGE_OPTIMIZATION`.
     * </pre>
     *
     * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the servingConfigIds.
     */
    java.util.List<java.lang.String> getServingConfigIdsList();
    /**
     *
     *
     * <pre>
     * Optional. A set of valid serving configs that may be used for
     * `PAGE_OPTIMIZATION`.
     * </pre>
     *
     * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of servingConfigIds.
     */
    int getServingConfigIdsCount();
    /**
     *
     *
     * <pre>
     * Optional. A set of valid serving configs that may be used for
     * `PAGE_OPTIMIZATION`.
     * </pre>
     *
     * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The servingConfigIds at the given index.
     */
    java.lang.String getServingConfigIds(int index);
    /**
     *
     *
     * <pre>
     * Optional. A set of valid serving configs that may be used for
     * `PAGE_OPTIMIZATION`.
     * </pre>
     *
     * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the servingConfigIds at the given index.
     */
    com.google.protobuf.ByteString getServingConfigIdsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Represents an ordered combination of valid serving configs, which
   * can be used for `PAGE_OPTIMIZATION` recommendations.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.Model.ServingConfigList}
   */
  public static final class ServingConfigList extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.Model.ServingConfigList)
      ServingConfigListOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ServingConfigList.newBuilder() to construct.
    private ServingConfigList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ServingConfigList() {
      servingConfigIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ServingConfigList();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.ModelProto
          .internal_static_google_cloud_retail_v2alpha_Model_ServingConfigList_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.ModelProto
          .internal_static_google_cloud_retail_v2alpha_Model_ServingConfigList_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.Model.ServingConfigList.class,
              com.google.cloud.retail.v2alpha.Model.ServingConfigList.Builder.class);
    }

    public static final int SERVING_CONFIG_IDS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList servingConfigIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Optional. A set of valid serving configs that may be used for
     * `PAGE_OPTIMIZATION`.
     * </pre>
     *
     * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the servingConfigIds.
     */
    public com.google.protobuf.ProtocolStringList getServingConfigIdsList() {
      return servingConfigIds_;
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of valid serving configs that may be used for
     * `PAGE_OPTIMIZATION`.
     * </pre>
     *
     * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of servingConfigIds.
     */
    public int getServingConfigIdsCount() {
      return servingConfigIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of valid serving configs that may be used for
     * `PAGE_OPTIMIZATION`.
     * </pre>
     *
     * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The servingConfigIds at the given index.
     */
    public java.lang.String getServingConfigIds(int index) {
      return servingConfigIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of valid serving configs that may be used for
     * `PAGE_OPTIMIZATION`.
     * </pre>
     *
     * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the servingConfigIds at the given index.
     */
    public com.google.protobuf.ByteString getServingConfigIdsBytes(int index) {
      return servingConfigIds_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < servingConfigIds_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, servingConfigIds_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < servingConfigIds_.size(); i++) {
          dataSize += computeStringSizeNoTag(servingConfigIds_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getServingConfigIdsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2alpha.Model.ServingConfigList)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2alpha.Model.ServingConfigList other =
          (com.google.cloud.retail.v2alpha.Model.ServingConfigList) obj;

      if (!getServingConfigIdsList().equals(other.getServingConfigIdsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getServingConfigIdsCount() > 0) {
        hash = (37 * hash) + SERVING_CONFIG_IDS_FIELD_NUMBER;
        hash = (53 * hash) + getServingConfigIdsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2alpha.Model.ServingConfigList parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.Model.ServingConfigList parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Model.ServingConfigList parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.Model.ServingConfigList parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Model.ServingConfigList parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.Model.ServingConfigList parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Model.ServingConfigList parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.Model.ServingConfigList parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Model.ServingConfigList parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.Model.ServingConfigList parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Model.ServingConfigList parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.Model.ServingConfigList parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2alpha.Model.ServingConfigList prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents an ordered combination of valid serving configs, which
     * can be used for `PAGE_OPTIMIZATION` recommendations.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2alpha.Model.ServingConfigList}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.Model.ServingConfigList)
        com.google.cloud.retail.v2alpha.Model.ServingConfigListOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.ModelProto
            .internal_static_google_cloud_retail_v2alpha_Model_ServingConfigList_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.ModelProto
            .internal_static_google_cloud_retail_v2alpha_Model_ServingConfigList_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.Model.ServingConfigList.class,
                com.google.cloud.retail.v2alpha.Model.ServingConfigList.Builder.class);
      }

      // Construct using com.google.cloud.retail.v2alpha.Model.ServingConfigList.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        servingConfigIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2alpha.ModelProto
            .internal_static_google_cloud_retail_v2alpha_Model_ServingConfigList_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Model.ServingConfigList getDefaultInstanceForType() {
        return com.google.cloud.retail.v2alpha.Model.ServingConfigList.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Model.ServingConfigList build() {
        com.google.cloud.retail.v2alpha.Model.ServingConfigList result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Model.ServingConfigList buildPartial() {
        com.google.cloud.retail.v2alpha.Model.ServingConfigList result =
            new com.google.cloud.retail.v2alpha.Model.ServingConfigList(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.retail.v2alpha.Model.ServingConfigList result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          servingConfigIds_.makeImmutable();
          result.servingConfigIds_ = servingConfigIds_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2alpha.Model.ServingConfigList) {
          return mergeFrom((com.google.cloud.retail.v2alpha.Model.ServingConfigList) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.retail.v2alpha.Model.ServingConfigList other) {
        if (other == com.google.cloud.retail.v2alpha.Model.ServingConfigList.getDefaultInstance())
          return this;
        if (!other.servingConfigIds_.isEmpty()) {
          if (servingConfigIds_.isEmpty()) {
            servingConfigIds_ = other.servingConfigIds_;
            bitField0_ |= 0x00000001;
          } else {
            ensureServingConfigIdsIsMutable();
            servingConfigIds_.addAll(other.servingConfigIds_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureServingConfigIdsIsMutable();
                  servingConfigIds_.add(s);
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList servingConfigIds_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureServingConfigIdsIsMutable() {
        if (!servingConfigIds_.isModifiable()) {
          servingConfigIds_ = new com.google.protobuf.LazyStringArrayList(servingConfigIds_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * Optional. A set of valid serving configs that may be used for
       * `PAGE_OPTIMIZATION`.
       * </pre>
       *
       * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the servingConfigIds.
       */
      public com.google.protobuf.ProtocolStringList getServingConfigIdsList() {
        servingConfigIds_.makeImmutable();
        return servingConfigIds_;
      }
      /**
       *
       *
       * <pre>
       * Optional. A set of valid serving configs that may be used for
       * `PAGE_OPTIMIZATION`.
       * </pre>
       *
       * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The count of servingConfigIds.
       */
      public int getServingConfigIdsCount() {
        return servingConfigIds_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. A set of valid serving configs that may be used for
       * `PAGE_OPTIMIZATION`.
       * </pre>
       *
       * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The servingConfigIds at the given index.
       */
      public java.lang.String getServingConfigIds(int index) {
        return servingConfigIds_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. A set of valid serving configs that may be used for
       * `PAGE_OPTIMIZATION`.
       * </pre>
       *
       * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the servingConfigIds at the given index.
       */
      public com.google.protobuf.ByteString getServingConfigIdsBytes(int index) {
        return servingConfigIds_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. A set of valid serving configs that may be used for
       * `PAGE_OPTIMIZATION`.
       * </pre>
       *
       * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The servingConfigIds to set.
       * @return This builder for chaining.
       */
      public Builder setServingConfigIds(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServingConfigIdsIsMutable();
        servingConfigIds_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A set of valid serving configs that may be used for
       * `PAGE_OPTIMIZATION`.
       * </pre>
       *
       * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The servingConfigIds to add.
       * @return This builder for chaining.
       */
      public Builder addServingConfigIds(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServingConfigIdsIsMutable();
        servingConfigIds_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A set of valid serving configs that may be used for
       * `PAGE_OPTIMIZATION`.
       * </pre>
       *
       * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param values The servingConfigIds to add.
       * @return This builder for chaining.
       */
      public Builder addAllServingConfigIds(java.lang.Iterable<java.lang.String> values) {
        ensureServingConfigIdsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, servingConfigIds_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A set of valid serving configs that may be used for
       * `PAGE_OPTIMIZATION`.
       * </pre>
       *
       * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearServingConfigIds() {
        servingConfigIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A set of valid serving configs that may be used for
       * `PAGE_OPTIMIZATION`.
       * </pre>
       *
       * <code>repeated string serving_config_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The bytes of the servingConfigIds to add.
       * @return This builder for chaining.
       */
      public Builder addServingConfigIdsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureServingConfigIdsIsMutable();
        servingConfigIds_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.Model.ServingConfigList)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.Model.ServingConfigList)
    private static final com.google.cloud.retail.v2alpha.Model.ServingConfigList DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.Model.ServingConfigList();
    }

    public static com.google.cloud.retail.v2alpha.Model.ServingConfigList getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ServingConfigList> PARSER =
        new com.google.protobuf.AbstractParser<ServingConfigList>() {
          @java.lang.Override
          public ServingConfigList parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ServingConfigList> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ServingConfigList> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Model.ServingConfigList getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FrequentlyBoughtTogetherFeaturesConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Specifies the context of the model when it is used in predict
     * requests. Can only be set for the `frequently-bought-together` type. If
     * it isn't specified, it defaults to
     * [MULTIPLE_CONTEXT_PRODUCTS][google.cloud.retail.v2alpha.Model.ContextProductsType.MULTIPLE_CONTEXT_PRODUCTS].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.ContextProductsType context_products_type = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for contextProductsType.
     */
    int getContextProductsTypeValue();
    /**
     *
     *
     * <pre>
     * Optional. Specifies the context of the model when it is used in predict
     * requests. Can only be set for the `frequently-bought-together` type. If
     * it isn't specified, it defaults to
     * [MULTIPLE_CONTEXT_PRODUCTS][google.cloud.retail.v2alpha.Model.ContextProductsType.MULTIPLE_CONTEXT_PRODUCTS].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.ContextProductsType context_products_type = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The contextProductsType.
     */
    com.google.cloud.retail.v2alpha.Model.ContextProductsType getContextProductsType();
  }
  /**
   *
   *
   * <pre>
   * Additional configs for the frequently-bought-together model type.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig}
   */
  public static final class FrequentlyBoughtTogetherFeaturesConfig
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig)
      FrequentlyBoughtTogetherFeaturesConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FrequentlyBoughtTogetherFeaturesConfig.newBuilder() to construct.
    private FrequentlyBoughtTogetherFeaturesConfig(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FrequentlyBoughtTogetherFeaturesConfig() {
      contextProductsType_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FrequentlyBoughtTogetherFeaturesConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.ModelProto
          .internal_static_google_cloud_retail_v2alpha_Model_FrequentlyBoughtTogetherFeaturesConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.ModelProto
          .internal_static_google_cloud_retail_v2alpha_Model_FrequentlyBoughtTogetherFeaturesConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig.class,
              com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig.Builder
                  .class);
    }

    public static final int CONTEXT_PRODUCTS_TYPE_FIELD_NUMBER = 2;
    private int contextProductsType_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Specifies the context of the model when it is used in predict
     * requests. Can only be set for the `frequently-bought-together` type. If
     * it isn't specified, it defaults to
     * [MULTIPLE_CONTEXT_PRODUCTS][google.cloud.retail.v2alpha.Model.ContextProductsType.MULTIPLE_CONTEXT_PRODUCTS].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.ContextProductsType context_products_type = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for contextProductsType.
     */
    @java.lang.Override
    public int getContextProductsTypeValue() {
      return contextProductsType_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the context of the model when it is used in predict
     * requests. Can only be set for the `frequently-bought-together` type. If
     * it isn't specified, it defaults to
     * [MULTIPLE_CONTEXT_PRODUCTS][google.cloud.retail.v2alpha.Model.ContextProductsType.MULTIPLE_CONTEXT_PRODUCTS].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.ContextProductsType context_products_type = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The contextProductsType.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Model.ContextProductsType getContextProductsType() {
      com.google.cloud.retail.v2alpha.Model.ContextProductsType result =
          com.google.cloud.retail.v2alpha.Model.ContextProductsType.forNumber(contextProductsType_);
      return result == null
          ? com.google.cloud.retail.v2alpha.Model.ContextProductsType.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (contextProductsType_
          != com.google.cloud.retail.v2alpha.Model.ContextProductsType
              .CONTEXT_PRODUCTS_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, contextProductsType_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (contextProductsType_
          != com.google.cloud.retail.v2alpha.Model.ContextProductsType
              .CONTEXT_PRODUCTS_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, contextProductsType_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig other =
          (com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig) obj;

      if (contextProductsType_ != other.contextProductsType_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CONTEXT_PRODUCTS_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + contextProductsType_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Additional configs for the frequently-bought-together model type.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig)
        com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.ModelProto
            .internal_static_google_cloud_retail_v2alpha_Model_FrequentlyBoughtTogetherFeaturesConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.ModelProto
            .internal_static_google_cloud_retail_v2alpha_Model_FrequentlyBoughtTogetherFeaturesConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig.class,
                com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        contextProductsType_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2alpha.ModelProto
            .internal_static_google_cloud_retail_v2alpha_Model_FrequentlyBoughtTogetherFeaturesConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
          getDefaultInstanceForType() {
        return com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig build() {
        com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
          buildPartial() {
        com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig result =
            new com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.contextProductsType_ = contextProductsType_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig) {
          return mergeFrom(
              (com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig other) {
        if (other
            == com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
                .getDefaultInstance()) return this;
        if (other.contextProductsType_ != 0) {
          setContextProductsTypeValue(other.getContextProductsTypeValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 16:
                {
                  contextProductsType_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int contextProductsType_ = 0;
      /**
       *
       *
       * <pre>
       * Optional. Specifies the context of the model when it is used in predict
       * requests. Can only be set for the `frequently-bought-together` type. If
       * it isn't specified, it defaults to
       * [MULTIPLE_CONTEXT_PRODUCTS][google.cloud.retail.v2alpha.Model.ContextProductsType.MULTIPLE_CONTEXT_PRODUCTS].
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.ContextProductsType context_products_type = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enum numeric value on the wire for contextProductsType.
       */
      @java.lang.Override
      public int getContextProductsTypeValue() {
        return contextProductsType_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies the context of the model when it is used in predict
       * requests. Can only be set for the `frequently-bought-together` type. If
       * it isn't specified, it defaults to
       * [MULTIPLE_CONTEXT_PRODUCTS][google.cloud.retail.v2alpha.Model.ContextProductsType.MULTIPLE_CONTEXT_PRODUCTS].
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.ContextProductsType context_products_type = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The enum numeric value on the wire for contextProductsType to set.
       * @return This builder for chaining.
       */
      public Builder setContextProductsTypeValue(int value) {
        contextProductsType_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies the context of the model when it is used in predict
       * requests. Can only be set for the `frequently-bought-together` type. If
       * it isn't specified, it defaults to
       * [MULTIPLE_CONTEXT_PRODUCTS][google.cloud.retail.v2alpha.Model.ContextProductsType.MULTIPLE_CONTEXT_PRODUCTS].
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.ContextProductsType context_products_type = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The contextProductsType.
       */
      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Model.ContextProductsType getContextProductsType() {
        com.google.cloud.retail.v2alpha.Model.ContextProductsType result =
            com.google.cloud.retail.v2alpha.Model.ContextProductsType.forNumber(
                contextProductsType_);
        return result == null
            ? com.google.cloud.retail.v2alpha.Model.ContextProductsType.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies the context of the model when it is used in predict
       * requests. Can only be set for the `frequently-bought-together` type. If
       * it isn't specified, it defaults to
       * [MULTIPLE_CONTEXT_PRODUCTS][google.cloud.retail.v2alpha.Model.ContextProductsType.MULTIPLE_CONTEXT_PRODUCTS].
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.ContextProductsType context_products_type = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The contextProductsType to set.
       * @return This builder for chaining.
       */
      public Builder setContextProductsType(
          com.google.cloud.retail.v2alpha.Model.ContextProductsType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        contextProductsType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies the context of the model when it is used in predict
       * requests. Can only be set for the `frequently-bought-together` type. If
       * it isn't specified, it defaults to
       * [MULTIPLE_CONTEXT_PRODUCTS][google.cloud.retail.v2alpha.Model.ContextProductsType.MULTIPLE_CONTEXT_PRODUCTS].
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.ContextProductsType context_products_type = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContextProductsType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        contextProductsType_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig)
    private static final com.google.cloud.retail.v2alpha.Model
            .FrequentlyBoughtTogetherFeaturesConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig();
    }

    public static com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FrequentlyBoughtTogetherFeaturesConfig> PARSER =
        new com.google.protobuf.AbstractParser<FrequentlyBoughtTogetherFeaturesConfig>() {
          @java.lang.Override
          public FrequentlyBoughtTogetherFeaturesConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FrequentlyBoughtTogetherFeaturesConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FrequentlyBoughtTogetherFeaturesConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ModelFeaturesConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.Model.ModelFeaturesConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Additional configs for frequently-bought-together models.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig frequently_bought_together_config = 1;
     * </code>
     *
     * @return Whether the frequentlyBoughtTogetherConfig field is set.
     */
    boolean hasFrequentlyBoughtTogetherConfig();
    /**
     *
     *
     * <pre>
     * Additional configs for frequently-bought-together models.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig frequently_bought_together_config = 1;
     * </code>
     *
     * @return The frequentlyBoughtTogetherConfig.
     */
    com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
        getFrequentlyBoughtTogetherConfig();
    /**
     *
     *
     * <pre>
     * Additional configs for frequently-bought-together models.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig frequently_bought_together_config = 1;
     * </code>
     */
    com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfigOrBuilder
        getFrequentlyBoughtTogetherConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. LLM embedding config to use for this model.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig llm_embedding_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the llmEmbeddingConfig field is set.
     */
    boolean hasLlmEmbeddingConfig();
    /**
     *
     *
     * <pre>
     * Optional. LLM embedding config to use for this model.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig llm_embedding_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The llmEmbeddingConfig.
     */
    com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
        getLlmEmbeddingConfig();
    /**
     *
     *
     * <pre>
     * Optional. LLM embedding config to use for this model.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig llm_embedding_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfigOrBuilder
        getLlmEmbeddingConfigOrBuilder();

    com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.TypeDedicatedConfigCase
        getTypeDedicatedConfigCase();
  }
  /**
   *
   *
   * <pre>
   * Additional model features config.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.Model.ModelFeaturesConfig}
   */
  public static final class ModelFeaturesConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.Model.ModelFeaturesConfig)
      ModelFeaturesConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ModelFeaturesConfig.newBuilder() to construct.
    private ModelFeaturesConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ModelFeaturesConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ModelFeaturesConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.ModelProto
          .internal_static_google_cloud_retail_v2alpha_Model_ModelFeaturesConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.ModelProto
          .internal_static_google_cloud_retail_v2alpha_Model_ModelFeaturesConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.class,
              com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.Builder.class);
    }

    public interface LlmEmbeddingConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. The LLM embedding version to use.
       * Currently only `v0` is supported. If not specified, feature will
       * not be turned on.
       * </pre>
       *
       * <code>string llm_embedding_version = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The llmEmbeddingVersion.
       */
      java.lang.String getLlmEmbeddingVersion();
      /**
       *
       *
       * <pre>
       * Optional. The LLM embedding version to use.
       * Currently only `v0` is supported. If not specified, feature will
       * not be turned on.
       * </pre>
       *
       * <code>string llm_embedding_version = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for llmEmbeddingVersion.
       */
      com.google.protobuf.ByteString getLlmEmbeddingVersionBytes();
    }
    /**
     *
     *
     * <pre>
     * Config that turns on usage of llm embeddings as features to the model.
     * Embeddings leverage unstructured text fields like description and title.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig}
     */
    public static final class LlmEmbeddingConfig extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig)
        LlmEmbeddingConfigOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use LlmEmbeddingConfig.newBuilder() to construct.
      private LlmEmbeddingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private LlmEmbeddingConfig() {
        llmEmbeddingVersion_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new LlmEmbeddingConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.ModelProto
            .internal_static_google_cloud_retail_v2alpha_Model_ModelFeaturesConfig_LlmEmbeddingConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.ModelProto
            .internal_static_google_cloud_retail_v2alpha_Model_ModelFeaturesConfig_LlmEmbeddingConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig.class,
                com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig.Builder
                    .class);
      }

      public static final int LLM_EMBEDDING_VERSION_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object llmEmbeddingVersion_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The LLM embedding version to use.
       * Currently only `v0` is supported. If not specified, feature will
       * not be turned on.
       * </pre>
       *
       * <code>string llm_embedding_version = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The llmEmbeddingVersion.
       */
      @java.lang.Override
      public java.lang.String getLlmEmbeddingVersion() {
        java.lang.Object ref = llmEmbeddingVersion_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          llmEmbeddingVersion_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The LLM embedding version to use.
       * Currently only `v0` is supported. If not specified, feature will
       * not be turned on.
       * </pre>
       *
       * <code>string llm_embedding_version = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for llmEmbeddingVersion.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getLlmEmbeddingVersionBytes() {
        java.lang.Object ref = llmEmbeddingVersion_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          llmEmbeddingVersion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(llmEmbeddingVersion_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, llmEmbeddingVersion_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(llmEmbeddingVersion_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, llmEmbeddingVersion_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig other =
            (com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig) obj;

        if (!getLlmEmbeddingVersion().equals(other.getLlmEmbeddingVersion())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + LLM_EMBEDDING_VERSION_FIELD_NUMBER;
        hash = (53 * hash) + getLlmEmbeddingVersion().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Config that turns on usage of llm embeddings as features to the model.
       * Embeddings leverage unstructured text fields like description and title.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig)
          com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.retail.v2alpha.ModelProto
              .internal_static_google_cloud_retail_v2alpha_Model_ModelFeaturesConfig_LlmEmbeddingConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.retail.v2alpha.ModelProto
              .internal_static_google_cloud_retail_v2alpha_Model_ModelFeaturesConfig_LlmEmbeddingConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
                      .class,
                  com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          llmEmbeddingVersion_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.retail.v2alpha.ModelProto
              .internal_static_google_cloud_retail_v2alpha_Model_ModelFeaturesConfig_LlmEmbeddingConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
            getDefaultInstanceForType() {
          return com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
            build() {
          com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
            buildPartial() {
          com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig result =
              new com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.llmEmbeddingVersion_ = llmEmbeddingVersion_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig) {
            return mergeFrom(
                (com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig other) {
          if (other
              == com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
                  .getDefaultInstance()) return this;
          if (!other.getLlmEmbeddingVersion().isEmpty()) {
            llmEmbeddingVersion_ = other.llmEmbeddingVersion_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    llmEmbeddingVersion_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object llmEmbeddingVersion_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The LLM embedding version to use.
         * Currently only `v0` is supported. If not specified, feature will
         * not be turned on.
         * </pre>
         *
         * <code>string llm_embedding_version = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The llmEmbeddingVersion.
         */
        public java.lang.String getLlmEmbeddingVersion() {
          java.lang.Object ref = llmEmbeddingVersion_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            llmEmbeddingVersion_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The LLM embedding version to use.
         * Currently only `v0` is supported. If not specified, feature will
         * not be turned on.
         * </pre>
         *
         * <code>string llm_embedding_version = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for llmEmbeddingVersion.
         */
        public com.google.protobuf.ByteString getLlmEmbeddingVersionBytes() {
          java.lang.Object ref = llmEmbeddingVersion_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            llmEmbeddingVersion_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The LLM embedding version to use.
         * Currently only `v0` is supported. If not specified, feature will
         * not be turned on.
         * </pre>
         *
         * <code>string llm_embedding_version = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The llmEmbeddingVersion to set.
         * @return This builder for chaining.
         */
        public Builder setLlmEmbeddingVersion(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          llmEmbeddingVersion_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The LLM embedding version to use.
         * Currently only `v0` is supported. If not specified, feature will
         * not be turned on.
         * </pre>
         *
         * <code>string llm_embedding_version = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearLlmEmbeddingVersion() {
          llmEmbeddingVersion_ = getDefaultInstance().getLlmEmbeddingVersion();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The LLM embedding version to use.
         * Currently only `v0` is supported. If not specified, feature will
         * not be turned on.
         * </pre>
         *
         * <code>string llm_embedding_version = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for llmEmbeddingVersion to set.
         * @return This builder for chaining.
         */
        public Builder setLlmEmbeddingVersionBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          llmEmbeddingVersion_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig)
      private static final com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig
              .LlmEmbeddingConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig();
      }

      public static com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<LlmEmbeddingConfig> PARSER =
          new com.google.protobuf.AbstractParser<LlmEmbeddingConfig>() {
            @java.lang.Override
            public LlmEmbeddingConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<LlmEmbeddingConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<LlmEmbeddingConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    private int typeDedicatedConfigCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object typeDedicatedConfig_;

    public enum TypeDedicatedConfigCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      FREQUENTLY_BOUGHT_TOGETHER_CONFIG(1),
      TYPEDEDICATEDCONFIG_NOT_SET(0);
      private final int value;

      private TypeDedicatedConfigCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static TypeDedicatedConfigCase valueOf(int value) {
        return forNumber(value);
      }

      public static TypeDedicatedConfigCase forNumber(int value) {
        switch (value) {
          case 1:
            return FREQUENTLY_BOUGHT_TOGETHER_CONFIG;
          case 0:
            return TYPEDEDICATEDCONFIG_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public TypeDedicatedConfigCase getTypeDedicatedConfigCase() {
      return TypeDedicatedConfigCase.forNumber(typeDedicatedConfigCase_);
    }

    public static final int FREQUENTLY_BOUGHT_TOGETHER_CONFIG_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Additional configs for frequently-bought-together models.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig frequently_bought_together_config = 1;
     * </code>
     *
     * @return Whether the frequentlyBoughtTogetherConfig field is set.
     */
    @java.lang.Override
    public boolean hasFrequentlyBoughtTogetherConfig() {
      return typeDedicatedConfigCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Additional configs for frequently-bought-together models.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig frequently_bought_together_config = 1;
     * </code>
     *
     * @return The frequentlyBoughtTogetherConfig.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
        getFrequentlyBoughtTogetherConfig() {
      if (typeDedicatedConfigCase_ == 1) {
        return (com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig)
            typeDedicatedConfig_;
      }
      return com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Additional configs for frequently-bought-together models.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig frequently_bought_together_config = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfigOrBuilder
        getFrequentlyBoughtTogetherConfigOrBuilder() {
      if (typeDedicatedConfigCase_ == 1) {
        return (com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig)
            typeDedicatedConfig_;
      }
      return com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
          .getDefaultInstance();
    }

    public static final int LLM_EMBEDDING_CONFIG_FIELD_NUMBER = 2;
    private com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
        llmEmbeddingConfig_;
    /**
     *
     *
     * <pre>
     * Optional. LLM embedding config to use for this model.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig llm_embedding_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the llmEmbeddingConfig field is set.
     */
    @java.lang.Override
    public boolean hasLlmEmbeddingConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. LLM embedding config to use for this model.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig llm_embedding_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The llmEmbeddingConfig.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
        getLlmEmbeddingConfig() {
      return llmEmbeddingConfig_ == null
          ? com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
              .getDefaultInstance()
          : llmEmbeddingConfig_;
    }
    /**
     *
     *
     * <pre>
     * Optional. LLM embedding config to use for this model.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig llm_embedding_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfigOrBuilder
        getLlmEmbeddingConfigOrBuilder() {
      return llmEmbeddingConfig_ == null
          ? com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
              .getDefaultInstance()
          : llmEmbeddingConfig_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (typeDedicatedConfigCase_ == 1) {
        output.writeMessage(
            1,
            (com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig)
                typeDedicatedConfig_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getLlmEmbeddingConfig());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (typeDedicatedConfigCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1,
                (com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig)
                    typeDedicatedConfig_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(2, getLlmEmbeddingConfig());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig other =
          (com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig) obj;

      if (hasLlmEmbeddingConfig() != other.hasLlmEmbeddingConfig()) return false;
      if (hasLlmEmbeddingConfig()) {
        if (!getLlmEmbeddingConfig().equals(other.getLlmEmbeddingConfig())) return false;
      }
      if (!getTypeDedicatedConfigCase().equals(other.getTypeDedicatedConfigCase())) return false;
      switch (typeDedicatedConfigCase_) {
        case 1:
          if (!getFrequentlyBoughtTogetherConfig()
              .equals(other.getFrequentlyBoughtTogetherConfig())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasLlmEmbeddingConfig()) {
        hash = (37 * hash) + LLM_EMBEDDING_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getLlmEmbeddingConfig().hashCode();
      }
      switch (typeDedicatedConfigCase_) {
        case 1:
          hash = (37 * hash) + FREQUENTLY_BOUGHT_TOGETHER_CONFIG_FIELD_NUMBER;
          hash = (53 * hash) + getFrequentlyBoughtTogetherConfig().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Additional model features config.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2alpha.Model.ModelFeaturesConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.Model.ModelFeaturesConfig)
        com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.ModelProto
            .internal_static_google_cloud_retail_v2alpha_Model_ModelFeaturesConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.ModelProto
            .internal_static_google_cloud_retail_v2alpha_Model_ModelFeaturesConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.class,
                com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.Builder.class);
      }

      // Construct using com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getLlmEmbeddingConfigFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (frequentlyBoughtTogetherConfigBuilder_ != null) {
          frequentlyBoughtTogetherConfigBuilder_.clear();
        }
        llmEmbeddingConfig_ = null;
        if (llmEmbeddingConfigBuilder_ != null) {
          llmEmbeddingConfigBuilder_.dispose();
          llmEmbeddingConfigBuilder_ = null;
        }
        typeDedicatedConfigCase_ = 0;
        typeDedicatedConfig_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2alpha.ModelProto
            .internal_static_google_cloud_retail_v2alpha_Model_ModelFeaturesConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig getDefaultInstanceForType() {
        return com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig build() {
        com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig buildPartial() {
        com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig result =
            new com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.llmEmbeddingConfig_ =
              llmEmbeddingConfigBuilder_ == null
                  ? llmEmbeddingConfig_
                  : llmEmbeddingConfigBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig result) {
        result.typeDedicatedConfigCase_ = typeDedicatedConfigCase_;
        result.typeDedicatedConfig_ = this.typeDedicatedConfig_;
        if (typeDedicatedConfigCase_ == 1 && frequentlyBoughtTogetherConfigBuilder_ != null) {
          result.typeDedicatedConfig_ = frequentlyBoughtTogetherConfigBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig) {
          return mergeFrom((com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig other) {
        if (other == com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.getDefaultInstance())
          return this;
        if (other.hasLlmEmbeddingConfig()) {
          mergeLlmEmbeddingConfig(other.getLlmEmbeddingConfig());
        }
        switch (other.getTypeDedicatedConfigCase()) {
          case FREQUENTLY_BOUGHT_TOGETHER_CONFIG:
            {
              mergeFrequentlyBoughtTogetherConfig(other.getFrequentlyBoughtTogetherConfig());
              break;
            }
          case TYPEDEDICATEDCONFIG_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getFrequentlyBoughtTogetherConfigFieldBuilder().getBuilder(),
                      extensionRegistry);
                  typeDedicatedConfigCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getLlmEmbeddingConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int typeDedicatedConfigCase_ = 0;
      private java.lang.Object typeDedicatedConfig_;

      public TypeDedicatedConfigCase getTypeDedicatedConfigCase() {
        return TypeDedicatedConfigCase.forNumber(typeDedicatedConfigCase_);
      }

      public Builder clearTypeDedicatedConfig() {
        typeDedicatedConfigCase_ = 0;
        typeDedicatedConfig_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig,
              com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig.Builder,
              com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfigOrBuilder>
          frequentlyBoughtTogetherConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Additional configs for frequently-bought-together models.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig frequently_bought_together_config = 1;
       * </code>
       *
       * @return Whether the frequentlyBoughtTogetherConfig field is set.
       */
      @java.lang.Override
      public boolean hasFrequentlyBoughtTogetherConfig() {
        return typeDedicatedConfigCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Additional configs for frequently-bought-together models.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig frequently_bought_together_config = 1;
       * </code>
       *
       * @return The frequentlyBoughtTogetherConfig.
       */
      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
          getFrequentlyBoughtTogetherConfig() {
        if (frequentlyBoughtTogetherConfigBuilder_ == null) {
          if (typeDedicatedConfigCase_ == 1) {
            return (com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig)
                typeDedicatedConfig_;
          }
          return com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
              .getDefaultInstance();
        } else {
          if (typeDedicatedConfigCase_ == 1) {
            return frequentlyBoughtTogetherConfigBuilder_.getMessage();
          }
          return com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Additional configs for frequently-bought-together models.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig frequently_bought_together_config = 1;
       * </code>
       */
      public Builder setFrequentlyBoughtTogetherConfig(
          com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig value) {
        if (frequentlyBoughtTogetherConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          typeDedicatedConfig_ = value;
          onChanged();
        } else {
          frequentlyBoughtTogetherConfigBuilder_.setMessage(value);
        }
        typeDedicatedConfigCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Additional configs for frequently-bought-together models.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig frequently_bought_together_config = 1;
       * </code>
       */
      public Builder setFrequentlyBoughtTogetherConfig(
          com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig.Builder
              builderForValue) {
        if (frequentlyBoughtTogetherConfigBuilder_ == null) {
          typeDedicatedConfig_ = builderForValue.build();
          onChanged();
        } else {
          frequentlyBoughtTogetherConfigBuilder_.setMessage(builderForValue.build());
        }
        typeDedicatedConfigCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Additional configs for frequently-bought-together models.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig frequently_bought_together_config = 1;
       * </code>
       */
      public Builder mergeFrequentlyBoughtTogetherConfig(
          com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig value) {
        if (frequentlyBoughtTogetherConfigBuilder_ == null) {
          if (typeDedicatedConfigCase_ == 1
              && typeDedicatedConfig_
                  != com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
                      .getDefaultInstance()) {
            typeDedicatedConfig_ =
                com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
                    .newBuilder(
                        (com.google.cloud.retail.v2alpha.Model
                                .FrequentlyBoughtTogetherFeaturesConfig)
                            typeDedicatedConfig_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            typeDedicatedConfig_ = value;
          }
          onChanged();
        } else {
          if (typeDedicatedConfigCase_ == 1) {
            frequentlyBoughtTogetherConfigBuilder_.mergeFrom(value);
          } else {
            frequentlyBoughtTogetherConfigBuilder_.setMessage(value);
          }
        }
        typeDedicatedConfigCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Additional configs for frequently-bought-together models.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig frequently_bought_together_config = 1;
       * </code>
       */
      public Builder clearFrequentlyBoughtTogetherConfig() {
        if (frequentlyBoughtTogetherConfigBuilder_ == null) {
          if (typeDedicatedConfigCase_ == 1) {
            typeDedicatedConfigCase_ = 0;
            typeDedicatedConfig_ = null;
            onChanged();
          }
        } else {
          if (typeDedicatedConfigCase_ == 1) {
            typeDedicatedConfigCase_ = 0;
            typeDedicatedConfig_ = null;
          }
          frequentlyBoughtTogetherConfigBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Additional configs for frequently-bought-together models.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig frequently_bought_together_config = 1;
       * </code>
       */
      public com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig.Builder
          getFrequentlyBoughtTogetherConfigBuilder() {
        return getFrequentlyBoughtTogetherConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Additional configs for frequently-bought-together models.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig frequently_bought_together_config = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfigOrBuilder
          getFrequentlyBoughtTogetherConfigOrBuilder() {
        if ((typeDedicatedConfigCase_ == 1) && (frequentlyBoughtTogetherConfigBuilder_ != null)) {
          return frequentlyBoughtTogetherConfigBuilder_.getMessageOrBuilder();
        } else {
          if (typeDedicatedConfigCase_ == 1) {
            return (com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig)
                typeDedicatedConfig_;
          }
          return com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Additional configs for frequently-bought-together models.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig frequently_bought_together_config = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig,
              com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig.Builder,
              com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfigOrBuilder>
          getFrequentlyBoughtTogetherConfigFieldBuilder() {
        if (frequentlyBoughtTogetherConfigBuilder_ == null) {
          if (!(typeDedicatedConfigCase_ == 1)) {
            typeDedicatedConfig_ =
                com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
                    .getDefaultInstance();
          }
          frequentlyBoughtTogetherConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig,
                  com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig
                      .Builder,
                  com.google.cloud.retail.v2alpha.Model
                      .FrequentlyBoughtTogetherFeaturesConfigOrBuilder>(
                  (com.google.cloud.retail.v2alpha.Model.FrequentlyBoughtTogetherFeaturesConfig)
                      typeDedicatedConfig_,
                  getParentForChildren(),
                  isClean());
          typeDedicatedConfig_ = null;
        }
        typeDedicatedConfigCase_ = 1;
        onChanged();
        return frequentlyBoughtTogetherConfigBuilder_;
      }

      private com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
          llmEmbeddingConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig,
              com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig.Builder,
              com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfigOrBuilder>
          llmEmbeddingConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. LLM embedding config to use for this model.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig llm_embedding_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the llmEmbeddingConfig field is set.
       */
      public boolean hasLlmEmbeddingConfig() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. LLM embedding config to use for this model.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig llm_embedding_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The llmEmbeddingConfig.
       */
      public com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
          getLlmEmbeddingConfig() {
        if (llmEmbeddingConfigBuilder_ == null) {
          return llmEmbeddingConfig_ == null
              ? com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
                  .getDefaultInstance()
              : llmEmbeddingConfig_;
        } else {
          return llmEmbeddingConfigBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. LLM embedding config to use for this model.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig llm_embedding_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setLlmEmbeddingConfig(
          com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig value) {
        if (llmEmbeddingConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          llmEmbeddingConfig_ = value;
        } else {
          llmEmbeddingConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. LLM embedding config to use for this model.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig llm_embedding_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setLlmEmbeddingConfig(
          com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig.Builder
              builderForValue) {
        if (llmEmbeddingConfigBuilder_ == null) {
          llmEmbeddingConfig_ = builderForValue.build();
        } else {
          llmEmbeddingConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. LLM embedding config to use for this model.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig llm_embedding_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeLlmEmbeddingConfig(
          com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig value) {
        if (llmEmbeddingConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && llmEmbeddingConfig_ != null
              && llmEmbeddingConfig_
                  != com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
                      .getDefaultInstance()) {
            getLlmEmbeddingConfigBuilder().mergeFrom(value);
          } else {
            llmEmbeddingConfig_ = value;
          }
        } else {
          llmEmbeddingConfigBuilder_.mergeFrom(value);
        }
        if (llmEmbeddingConfig_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. LLM embedding config to use for this model.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig llm_embedding_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearLlmEmbeddingConfig() {
        bitField0_ = (bitField0_ & ~0x00000002);
        llmEmbeddingConfig_ = null;
        if (llmEmbeddingConfigBuilder_ != null) {
          llmEmbeddingConfigBuilder_.dispose();
          llmEmbeddingConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. LLM embedding config to use for this model.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig llm_embedding_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig.Builder
          getLlmEmbeddingConfigBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getLlmEmbeddingConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. LLM embedding config to use for this model.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig llm_embedding_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfigOrBuilder
          getLlmEmbeddingConfigOrBuilder() {
        if (llmEmbeddingConfigBuilder_ != null) {
          return llmEmbeddingConfigBuilder_.getMessageOrBuilder();
        } else {
          return llmEmbeddingConfig_ == null
              ? com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
                  .getDefaultInstance()
              : llmEmbeddingConfig_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. LLM embedding config to use for this model.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig llm_embedding_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig,
              com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig.Builder,
              com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfigOrBuilder>
          getLlmEmbeddingConfigFieldBuilder() {
        if (llmEmbeddingConfigBuilder_ == null) {
          llmEmbeddingConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig,
                  com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.LlmEmbeddingConfig
                      .Builder,
                  com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig
                      .LlmEmbeddingConfigOrBuilder>(
                  getLlmEmbeddingConfig(), getParentForChildren(), isClean());
          llmEmbeddingConfig_ = null;
        }
        return llmEmbeddingConfigBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.Model.ModelFeaturesConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.Model.ModelFeaturesConfig)
    private static final com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig();
    }

    public static com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ModelFeaturesConfig> PARSER =
        new com.google.protobuf.AbstractParser<ModelFeaturesConfig>() {
          @java.lang.Override
          public ModelFeaturesConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ModelFeaturesConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ModelFeaturesConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int trainingConfigCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object trainingConfig_;

  public enum TrainingConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    PAGE_OPTIMIZATION_CONFIG(17),
    TRAININGCONFIG_NOT_SET(0);
    private final int value;

    private TrainingConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TrainingConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static TrainingConfigCase forNumber(int value) {
      switch (value) {
        case 17:
          return PAGE_OPTIMIZATION_CONFIG;
        case 0:
          return TRAININGCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TrainingConfigCase getTrainingConfigCase() {
    return TrainingConfigCase.forNumber(trainingConfigCase_);
  }

  public static final int PAGE_OPTIMIZATION_CONFIG_FIELD_NUMBER = 17;
  /**
   *
   *
   * <pre>
   * Optional. The page optimization config.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig page_optimization_config = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the pageOptimizationConfig field is set.
   */
  @java.lang.Override
  public boolean hasPageOptimizationConfig() {
    return trainingConfigCase_ == 17;
  }
  /**
   *
   *
   * <pre>
   * Optional. The page optimization config.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig page_optimization_config = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The pageOptimizationConfig.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig getPageOptimizationConfig() {
    if (trainingConfigCase_ == 17) {
      return (com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig) trainingConfig_;
    }
    return com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. The page optimization config.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig page_optimization_config = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfigOrBuilder
      getPageOptimizationConfigOrBuilder() {
    if (trainingConfigCase_ == 17) {
      return (com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig) trainingConfig_;
    }
    return com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The fully qualified resource name of the model.
   *
   * Format:
   * `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{model_id}`
   * catalog_id has char limit of 50.
   * recommendation_model_id has char limit of 40.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The fully qualified resource name of the model.
   *
   * Format:
   * `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{model_id}`
   * catalog_id has char limit of 50.
   * recommendation_model_id has char limit of 40.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The display name of the model.
   *
   * Should be human readable, used to display Recommendation Models in the
   * Retail Cloud Console Dashboard. UTF-8 encoded string with limit of 1024
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The display name of the model.
   *
   * Should be human readable, used to display Recommendation Models in the
   * Retail Cloud Console Dashboard. UTF-8 encoded string with limit of 1024
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRAINING_STATE_FIELD_NUMBER = 3;
  private int trainingState_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The training state that the model is in (e.g.
   * `TRAINING` or `PAUSED`).
   *
   * Since part of the cost of running the service
   * is frequency of training - this can be used to determine when to train
   * model in order to control cost. If not specified: the default value for
   * `CreateModel` method is `TRAINING`. The default value for
   * `UpdateModel` method is to keep the state the same as before.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.Model.TrainingState training_state = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for trainingState.
   */
  @java.lang.Override
  public int getTrainingStateValue() {
    return trainingState_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The training state that the model is in (e.g.
   * `TRAINING` or `PAUSED`).
   *
   * Since part of the cost of running the service
   * is frequency of training - this can be used to determine when to train
   * model in order to control cost. If not specified: the default value for
   * `CreateModel` method is `TRAINING`. The default value for
   * `UpdateModel` method is to keep the state the same as before.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.Model.TrainingState training_state = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The trainingState.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.Model.TrainingState getTrainingState() {
    com.google.cloud.retail.v2alpha.Model.TrainingState result =
        com.google.cloud.retail.v2alpha.Model.TrainingState.forNumber(trainingState_);
    return result == null
        ? com.google.cloud.retail.v2alpha.Model.TrainingState.UNRECOGNIZED
        : result;
  }

  public static final int SERVING_STATE_FIELD_NUMBER = 4;
  private int servingState_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The serving state of the model: `ACTIVE`, `NOT_ACTIVE`.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.Model.ServingState serving_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for servingState.
   */
  @java.lang.Override
  public int getServingStateValue() {
    return servingState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The serving state of the model: `ACTIVE`, `NOT_ACTIVE`.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.Model.ServingState serving_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The servingState.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.Model.ServingState getServingState() {
    com.google.cloud.retail.v2alpha.Model.ServingState result =
        com.google.cloud.retail.v2alpha.Model.ServingState.forNumber(servingState_);
    return result == null
        ? com.google.cloud.retail.v2alpha.Model.ServingState.UNRECOGNIZED
        : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the Recommendation Model was created at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the Recommendation Model was created at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the Recommendation Model was created at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the Recommendation Model was last updated. E.g.
   * if a Recommendation Model was paused - this would be the time the pause was
   * initiated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the Recommendation Model was last updated. E.g.
   * if a Recommendation Model was paused - this would be the time the pause was
   * initiated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the Recommendation Model was last updated. E.g.
   * if a Recommendation Model was paused - this would be the time the pause was
   * initiated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int TYPE_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";
  /**
   *
   *
   * <pre>
   * Required. The type of model e.g. `home-page`.
   *
   * Currently supported values: `recommended-for-you`, `others-you-may-like`,
   * `frequently-bought-together`, `page-optimization`, `similar-items`,
   * `buy-it-again`, `on-sale-items`, and `recently-viewed`(readonly value).
   *
   *
   * This field together with
   * [optimization_objective][google.cloud.retail.v2alpha.Model.optimization_objective]
   * describe model metadata to use to control model training and serving.
   * See https://cloud.google.com/retail/docs/models
   * for more details on what the model metadata control and which combination
   * of parameters are valid. For invalid combinations of parameters (e.g. type
   * = `frequently-bought-together` and optimization_objective = `ctr`), you
   * receive an error 400 if you try to create/update a recommendation with
   * this set of knobs.
   * </pre>
   *
   * <code>string type = 7 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The type of model e.g. `home-page`.
   *
   * Currently supported values: `recommended-for-you`, `others-you-may-like`,
   * `frequently-bought-together`, `page-optimization`, `similar-items`,
   * `buy-it-again`, `on-sale-items`, and `recently-viewed`(readonly value).
   *
   *
   * This field together with
   * [optimization_objective][google.cloud.retail.v2alpha.Model.optimization_objective]
   * describe model metadata to use to control model training and serving.
   * See https://cloud.google.com/retail/docs/models
   * for more details on what the model metadata control and which combination
   * of parameters are valid. For invalid combinations of parameters (e.g. type
   * = `frequently-bought-together` and optimization_objective = `ctr`), you
   * receive an error 400 if you try to create/update a recommendation with
   * this set of knobs.
   * </pre>
   *
   * <code>string type = 7 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OPTIMIZATION_OBJECTIVE_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object optimizationObjective_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The optimization objective e.g. `cvr`.
   *
   * Currently supported
   * values: `ctr`, `cvr`, `revenue-per-order`.
   *
   *  If not specified, we choose default based on model type.
   * Default depends on type of recommendation:
   *
   * `recommended-for-you` =&gt; `ctr`
   *
   * `others-you-may-like` =&gt; `ctr`
   *
   * `frequently-bought-together` =&gt; `revenue_per_order`
   *
   * This field together with
   * [optimization_objective][google.cloud.retail.v2alpha.Model.type]
   * describe model metadata to use to control model training and serving.
   * See https://cloud.google.com/retail/docs/models
   * for more details on what the model metadata control and which combination
   * of parameters are valid. For invalid combinations of parameters (e.g. type
   * = `frequently-bought-together` and optimization_objective = `ctr`), you
   * receive an error 400 if you try to create/update a recommendation with
   * this set of knobs.
   * </pre>
   *
   * <code>string optimization_objective = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The optimizationObjective.
   */
  @java.lang.Override
  public java.lang.String getOptimizationObjective() {
    java.lang.Object ref = optimizationObjective_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      optimizationObjective_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The optimization objective e.g. `cvr`.
   *
   * Currently supported
   * values: `ctr`, `cvr`, `revenue-per-order`.
   *
   *  If not specified, we choose default based on model type.
   * Default depends on type of recommendation:
   *
   * `recommended-for-you` =&gt; `ctr`
   *
   * `others-you-may-like` =&gt; `ctr`
   *
   * `frequently-bought-together` =&gt; `revenue_per_order`
   *
   * This field together with
   * [optimization_objective][google.cloud.retail.v2alpha.Model.type]
   * describe model metadata to use to control model training and serving.
   * See https://cloud.google.com/retail/docs/models
   * for more details on what the model metadata control and which combination
   * of parameters are valid. For invalid combinations of parameters (e.g. type
   * = `frequently-bought-together` and optimization_objective = `ctr`), you
   * receive an error 400 if you try to create/update a recommendation with
   * this set of knobs.
   * </pre>
   *
   * <code>string optimization_objective = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for optimizationObjective.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOptimizationObjectiveBytes() {
    java.lang.Object ref = optimizationObjective_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      optimizationObjective_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PERIODIC_TUNING_STATE_FIELD_NUMBER = 11;
  private int periodicTuningState_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The state of periodic tuning.
   *
   * The period we use is 3 months - to do a
   * one-off tune earlier use the `TuneModel` method. Default value
   * is `PERIODIC_TUNING_ENABLED`.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.Model.PeriodicTuningState periodic_tuning_state = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for periodicTuningState.
   */
  @java.lang.Override
  public int getPeriodicTuningStateValue() {
    return periodicTuningState_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The state of periodic tuning.
   *
   * The period we use is 3 months - to do a
   * one-off tune earlier use the `TuneModel` method. Default value
   * is `PERIODIC_TUNING_ENABLED`.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.Model.PeriodicTuningState periodic_tuning_state = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The periodicTuningState.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.Model.PeriodicTuningState getPeriodicTuningState() {
    com.google.cloud.retail.v2alpha.Model.PeriodicTuningState result =
        com.google.cloud.retail.v2alpha.Model.PeriodicTuningState.forNumber(periodicTuningState_);
    return result == null
        ? com.google.cloud.retail.v2alpha.Model.PeriodicTuningState.UNRECOGNIZED
        : result;
  }

  public static final int LAST_TUNE_TIME_FIELD_NUMBER = 12;
  private com.google.protobuf.Timestamp lastTuneTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the latest successful tune finished.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_tune_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lastTuneTime field is set.
   */
  @java.lang.Override
  public boolean hasLastTuneTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the latest successful tune finished.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_tune_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastTuneTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastTuneTime() {
    return lastTuneTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastTuneTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the latest successful tune finished.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_tune_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastTuneTimeOrBuilder() {
    return lastTuneTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastTuneTime_;
  }

  public static final int TUNING_OPERATION_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tuningOperation_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The tune operation associated with the model.
   *
   * Can be used to determine if there is an ongoing tune for this
   * recommendation. Empty field implies no tune is goig on.
   * </pre>
   *
   * <code>string tuning_operation = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The tuningOperation.
   */
  @java.lang.Override
  public java.lang.String getTuningOperation() {
    java.lang.Object ref = tuningOperation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tuningOperation_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The tune operation associated with the model.
   *
   * Can be used to determine if there is an ongoing tune for this
   * recommendation. Empty field implies no tune is goig on.
   * </pre>
   *
   * <code>string tuning_operation = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for tuningOperation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTuningOperationBytes() {
    java.lang.Object ref = tuningOperation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tuningOperation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_STATE_FIELD_NUMBER = 16;
  private int dataState_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The state of data requirements for this model: `DATA_OK` and
   * `DATA_ERROR`.
   *
   * Recommendation model cannot be trained if the data is in
   * `DATA_ERROR` state. Recommendation model can have `DATA_ERROR` state even
   * if serving state is `ACTIVE`: models were trained successfully before, but
   * cannot be refreshed because model no longer has sufficient
   * data for training.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.Model.DataState data_state = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for dataState.
   */
  @java.lang.Override
  public int getDataStateValue() {
    return dataState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The state of data requirements for this model: `DATA_OK` and
   * `DATA_ERROR`.
   *
   * Recommendation model cannot be trained if the data is in
   * `DATA_ERROR` state. Recommendation model can have `DATA_ERROR` state even
   * if serving state is `ACTIVE`: models were trained successfully before, but
   * cannot be refreshed because model no longer has sufficient
   * data for training.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.Model.DataState data_state = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The dataState.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.Model.DataState getDataState() {
    com.google.cloud.retail.v2alpha.Model.DataState result =
        com.google.cloud.retail.v2alpha.Model.DataState.forNumber(dataState_);
    return result == null ? com.google.cloud.retail.v2alpha.Model.DataState.UNRECOGNIZED : result;
  }

  public static final int FILTERING_OPTION_FIELD_NUMBER = 18;
  private int filteringOption_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. If `RECOMMENDATIONS_FILTERING_ENABLED`, recommendation filtering
   * by attributes is enabled for the model.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.RecommendationsFilteringOption filtering_option = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for filteringOption.
   */
  @java.lang.Override
  public int getFilteringOptionValue() {
    return filteringOption_;
  }
  /**
   *
   *
   * <pre>
   * Optional. If `RECOMMENDATIONS_FILTERING_ENABLED`, recommendation filtering
   * by attributes is enabled for the model.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.RecommendationsFilteringOption filtering_option = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The filteringOption.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.RecommendationsFilteringOption getFilteringOption() {
    com.google.cloud.retail.v2alpha.RecommendationsFilteringOption result =
        com.google.cloud.retail.v2alpha.RecommendationsFilteringOption.forNumber(filteringOption_);
    return result == null
        ? com.google.cloud.retail.v2alpha.RecommendationsFilteringOption.UNRECOGNIZED
        : result;
  }

  public static final int SERVING_CONFIG_LISTS_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.retail.v2alpha.Model.ServingConfigList>
      servingConfigLists_;
  /**
   *
   *
   * <pre>
   * Output only. The list of valid serving configs associated with the
   * PageOptimizationConfig.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2alpha.Model.ServingConfigList>
      getServingConfigListsList() {
    return servingConfigLists_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The list of valid serving configs associated with the
   * PageOptimizationConfig.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.retail.v2alpha.Model.ServingConfigListOrBuilder>
      getServingConfigListsOrBuilderList() {
    return servingConfigLists_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The list of valid serving configs associated with the
   * PageOptimizationConfig.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getServingConfigListsCount() {
    return servingConfigLists_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The list of valid serving configs associated with the
   * PageOptimizationConfig.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.Model.ServingConfigList getServingConfigLists(int index) {
    return servingConfigLists_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The list of valid serving configs associated with the
   * PageOptimizationConfig.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.Model.ServingConfigListOrBuilder
      getServingConfigListsOrBuilder(int index) {
    return servingConfigLists_.get(index);
  }

  public static final int MODEL_FEATURES_CONFIG_FIELD_NUMBER = 22;
  private com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig modelFeaturesConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Additional model features config.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig model_features_config = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the modelFeaturesConfig field is set.
   */
  @java.lang.Override
  public boolean hasModelFeaturesConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Additional model features config.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig model_features_config = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The modelFeaturesConfig.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig getModelFeaturesConfig() {
    return modelFeaturesConfig_ == null
        ? com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.getDefaultInstance()
        : modelFeaturesConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Additional model features config.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig model_features_config = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfigOrBuilder
      getModelFeaturesConfigOrBuilder() {
    return modelFeaturesConfig_ == null
        ? com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.getDefaultInstance()
        : modelFeaturesConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (trainingState_
        != com.google.cloud.retail.v2alpha.Model.TrainingState.TRAINING_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, trainingState_);
    }
    if (servingState_
        != com.google.cloud.retail.v2alpha.Model.ServingState.SERVING_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, servingState_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(optimizationObjective_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, optimizationObjective_);
    }
    if (periodicTuningState_
        != com.google.cloud.retail.v2alpha.Model.PeriodicTuningState
            .PERIODIC_TUNING_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(11, periodicTuningState_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(12, getLastTuneTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tuningOperation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, tuningOperation_);
    }
    if (dataState_
        != com.google.cloud.retail.v2alpha.Model.DataState.DATA_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(16, dataState_);
    }
    if (trainingConfigCase_ == 17) {
      output.writeMessage(
          17, (com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig) trainingConfig_);
    }
    if (filteringOption_
        != com.google.cloud.retail.v2alpha.RecommendationsFilteringOption
            .RECOMMENDATIONS_FILTERING_OPTION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(18, filteringOption_);
    }
    for (int i = 0; i < servingConfigLists_.size(); i++) {
      output.writeMessage(19, servingConfigLists_.get(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(22, getModelFeaturesConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (trainingState_
        != com.google.cloud.retail.v2alpha.Model.TrainingState.TRAINING_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, trainingState_);
    }
    if (servingState_
        != com.google.cloud.retail.v2alpha.Model.ServingState.SERVING_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, servingState_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(optimizationObjective_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, optimizationObjective_);
    }
    if (periodicTuningState_
        != com.google.cloud.retail.v2alpha.Model.PeriodicTuningState
            .PERIODIC_TUNING_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(11, periodicTuningState_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getLastTuneTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tuningOperation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, tuningOperation_);
    }
    if (dataState_
        != com.google.cloud.retail.v2alpha.Model.DataState.DATA_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(16, dataState_);
    }
    if (trainingConfigCase_ == 17) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              17, (com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig) trainingConfig_);
    }
    if (filteringOption_
        != com.google.cloud.retail.v2alpha.RecommendationsFilteringOption
            .RECOMMENDATIONS_FILTERING_OPTION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(18, filteringOption_);
    }
    for (int i = 0; i < servingConfigLists_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(19, servingConfigLists_.get(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(22, getModelFeaturesConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2alpha.Model)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2alpha.Model other = (com.google.cloud.retail.v2alpha.Model) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (trainingState_ != other.trainingState_) return false;
    if (servingState_ != other.servingState_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getType().equals(other.getType())) return false;
    if (!getOptimizationObjective().equals(other.getOptimizationObjective())) return false;
    if (periodicTuningState_ != other.periodicTuningState_) return false;
    if (hasLastTuneTime() != other.hasLastTuneTime()) return false;
    if (hasLastTuneTime()) {
      if (!getLastTuneTime().equals(other.getLastTuneTime())) return false;
    }
    if (!getTuningOperation().equals(other.getTuningOperation())) return false;
    if (dataState_ != other.dataState_) return false;
    if (filteringOption_ != other.filteringOption_) return false;
    if (!getServingConfigListsList().equals(other.getServingConfigListsList())) return false;
    if (hasModelFeaturesConfig() != other.hasModelFeaturesConfig()) return false;
    if (hasModelFeaturesConfig()) {
      if (!getModelFeaturesConfig().equals(other.getModelFeaturesConfig())) return false;
    }
    if (!getTrainingConfigCase().equals(other.getTrainingConfigCase())) return false;
    switch (trainingConfigCase_) {
      case 17:
        if (!getPageOptimizationConfig().equals(other.getPageOptimizationConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + TRAINING_STATE_FIELD_NUMBER;
    hash = (53 * hash) + trainingState_;
    hash = (37 * hash) + SERVING_STATE_FIELD_NUMBER;
    hash = (53 * hash) + servingState_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getType().hashCode();
    hash = (37 * hash) + OPTIMIZATION_OBJECTIVE_FIELD_NUMBER;
    hash = (53 * hash) + getOptimizationObjective().hashCode();
    hash = (37 * hash) + PERIODIC_TUNING_STATE_FIELD_NUMBER;
    hash = (53 * hash) + periodicTuningState_;
    if (hasLastTuneTime()) {
      hash = (37 * hash) + LAST_TUNE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastTuneTime().hashCode();
    }
    hash = (37 * hash) + TUNING_OPERATION_FIELD_NUMBER;
    hash = (53 * hash) + getTuningOperation().hashCode();
    hash = (37 * hash) + DATA_STATE_FIELD_NUMBER;
    hash = (53 * hash) + dataState_;
    hash = (37 * hash) + FILTERING_OPTION_FIELD_NUMBER;
    hash = (53 * hash) + filteringOption_;
    if (getServingConfigListsCount() > 0) {
      hash = (37 * hash) + SERVING_CONFIG_LISTS_FIELD_NUMBER;
      hash = (53 * hash) + getServingConfigListsList().hashCode();
    }
    if (hasModelFeaturesConfig()) {
      hash = (37 * hash) + MODEL_FEATURES_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getModelFeaturesConfig().hashCode();
    }
    switch (trainingConfigCase_) {
      case 17:
        hash = (37 * hash) + PAGE_OPTIMIZATION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getPageOptimizationConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2alpha.Model parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.Model parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.Model parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.Model parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.Model parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.Model parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.Model parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.Model parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.Model parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.Model parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.Model parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.Model parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2alpha.Model prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata that describes the training and serving parameters of a
   * [Model][google.cloud.retail.v2alpha.Model]. A
   * [Model][google.cloud.retail.v2alpha.Model] can be associated with a
   * [ServingConfig][google.cloud.retail.v2alpha.ServingConfig] and then queried
   * through the Predict API.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.Model}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.Model)
      com.google.cloud.retail.v2alpha.ModelOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.ModelProto
          .internal_static_google_cloud_retail_v2alpha_Model_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.ModelProto
          .internal_static_google_cloud_retail_v2alpha_Model_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.Model.class,
              com.google.cloud.retail.v2alpha.Model.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2alpha.Model.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getLastTuneTimeFieldBuilder();
        getServingConfigListsFieldBuilder();
        getModelFeaturesConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (pageOptimizationConfigBuilder_ != null) {
        pageOptimizationConfigBuilder_.clear();
      }
      name_ = "";
      displayName_ = "";
      trainingState_ = 0;
      servingState_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      type_ = "";
      optimizationObjective_ = "";
      periodicTuningState_ = 0;
      lastTuneTime_ = null;
      if (lastTuneTimeBuilder_ != null) {
        lastTuneTimeBuilder_.dispose();
        lastTuneTimeBuilder_ = null;
      }
      tuningOperation_ = "";
      dataState_ = 0;
      filteringOption_ = 0;
      if (servingConfigListsBuilder_ == null) {
        servingConfigLists_ = java.util.Collections.emptyList();
      } else {
        servingConfigLists_ = null;
        servingConfigListsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00004000);
      modelFeaturesConfig_ = null;
      if (modelFeaturesConfigBuilder_ != null) {
        modelFeaturesConfigBuilder_.dispose();
        modelFeaturesConfigBuilder_ = null;
      }
      trainingConfigCase_ = 0;
      trainingConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2alpha.ModelProto
          .internal_static_google_cloud_retail_v2alpha_Model_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Model getDefaultInstanceForType() {
      return com.google.cloud.retail.v2alpha.Model.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Model build() {
      com.google.cloud.retail.v2alpha.Model result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Model buildPartial() {
      com.google.cloud.retail.v2alpha.Model result =
          new com.google.cloud.retail.v2alpha.Model(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.retail.v2alpha.Model result) {
      if (servingConfigListsBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)) {
          servingConfigLists_ = java.util.Collections.unmodifiableList(servingConfigLists_);
          bitField0_ = (bitField0_ & ~0x00004000);
        }
        result.servingConfigLists_ = servingConfigLists_;
      } else {
        result.servingConfigLists_ = servingConfigListsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.retail.v2alpha.Model result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.trainingState_ = trainingState_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.servingState_ = servingState_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.optimizationObjective_ = optimizationObjective_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.periodicTuningState_ = periodicTuningState_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.lastTuneTime_ =
            lastTuneTimeBuilder_ == null ? lastTuneTime_ : lastTuneTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.tuningOperation_ = tuningOperation_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.dataState_ = dataState_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.filteringOption_ = filteringOption_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.modelFeaturesConfig_ =
            modelFeaturesConfigBuilder_ == null
                ? modelFeaturesConfig_
                : modelFeaturesConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.retail.v2alpha.Model result) {
      result.trainingConfigCase_ = trainingConfigCase_;
      result.trainingConfig_ = this.trainingConfig_;
      if (trainingConfigCase_ == 17 && pageOptimizationConfigBuilder_ != null) {
        result.trainingConfig_ = pageOptimizationConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2alpha.Model) {
        return mergeFrom((com.google.cloud.retail.v2alpha.Model) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2alpha.Model other) {
      if (other == com.google.cloud.retail.v2alpha.Model.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.trainingState_ != 0) {
        setTrainingStateValue(other.getTrainingStateValue());
      }
      if (other.servingState_ != 0) {
        setServingStateValue(other.getServingStateValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getType().isEmpty()) {
        type_ = other.type_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getOptimizationObjective().isEmpty()) {
        optimizationObjective_ = other.optimizationObjective_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.periodicTuningState_ != 0) {
        setPeriodicTuningStateValue(other.getPeriodicTuningStateValue());
      }
      if (other.hasLastTuneTime()) {
        mergeLastTuneTime(other.getLastTuneTime());
      }
      if (!other.getTuningOperation().isEmpty()) {
        tuningOperation_ = other.tuningOperation_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.dataState_ != 0) {
        setDataStateValue(other.getDataStateValue());
      }
      if (other.filteringOption_ != 0) {
        setFilteringOptionValue(other.getFilteringOptionValue());
      }
      if (servingConfigListsBuilder_ == null) {
        if (!other.servingConfigLists_.isEmpty()) {
          if (servingConfigLists_.isEmpty()) {
            servingConfigLists_ = other.servingConfigLists_;
            bitField0_ = (bitField0_ & ~0x00004000);
          } else {
            ensureServingConfigListsIsMutable();
            servingConfigLists_.addAll(other.servingConfigLists_);
          }
          onChanged();
        }
      } else {
        if (!other.servingConfigLists_.isEmpty()) {
          if (servingConfigListsBuilder_.isEmpty()) {
            servingConfigListsBuilder_.dispose();
            servingConfigListsBuilder_ = null;
            servingConfigLists_ = other.servingConfigLists_;
            bitField0_ = (bitField0_ & ~0x00004000);
            servingConfigListsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getServingConfigListsFieldBuilder()
                    : null;
          } else {
            servingConfigListsBuilder_.addAllMessages(other.servingConfigLists_);
          }
        }
      }
      if (other.hasModelFeaturesConfig()) {
        mergeModelFeaturesConfig(other.getModelFeaturesConfig());
      }
      switch (other.getTrainingConfigCase()) {
        case PAGE_OPTIMIZATION_CONFIG:
          {
            mergePageOptimizationConfig(other.getPageOptimizationConfig());
            break;
          }
        case TRAININGCONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 24:
              {
                trainingState_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 24
            case 32:
              {
                servingState_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                type_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                optimizationObjective_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 88:
              {
                periodicTuningState_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 88
            case 98:
              {
                input.readMessage(getLastTuneTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 98
            case 122:
              {
                tuningOperation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 122
            case 128:
              {
                dataState_ = input.readEnum();
                bitField0_ |= 0x00001000;
                break;
              } // case 128
            case 138:
              {
                input.readMessage(
                    getPageOptimizationConfigFieldBuilder().getBuilder(), extensionRegistry);
                trainingConfigCase_ = 17;
                break;
              } // case 138
            case 144:
              {
                filteringOption_ = input.readEnum();
                bitField0_ |= 0x00002000;
                break;
              } // case 144
            case 154:
              {
                com.google.cloud.retail.v2alpha.Model.ServingConfigList m =
                    input.readMessage(
                        com.google.cloud.retail.v2alpha.Model.ServingConfigList.parser(),
                        extensionRegistry);
                if (servingConfigListsBuilder_ == null) {
                  ensureServingConfigListsIsMutable();
                  servingConfigLists_.add(m);
                } else {
                  servingConfigListsBuilder_.addMessage(m);
                }
                break;
              } // case 154
            case 178:
              {
                input.readMessage(
                    getModelFeaturesConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 178
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int trainingConfigCase_ = 0;
    private java.lang.Object trainingConfig_;

    public TrainingConfigCase getTrainingConfigCase() {
      return TrainingConfigCase.forNumber(trainingConfigCase_);
    }

    public Builder clearTrainingConfig() {
      trainingConfigCase_ = 0;
      trainingConfig_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig,
            com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Builder,
            com.google.cloud.retail.v2alpha.Model.PageOptimizationConfigOrBuilder>
        pageOptimizationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The page optimization config.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig page_optimization_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the pageOptimizationConfig field is set.
     */
    @java.lang.Override
    public boolean hasPageOptimizationConfig() {
      return trainingConfigCase_ == 17;
    }
    /**
     *
     *
     * <pre>
     * Optional. The page optimization config.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig page_optimization_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The pageOptimizationConfig.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig
        getPageOptimizationConfig() {
      if (pageOptimizationConfigBuilder_ == null) {
        if (trainingConfigCase_ == 17) {
          return (com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig) trainingConfig_;
        }
        return com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.getDefaultInstance();
      } else {
        if (trainingConfigCase_ == 17) {
          return pageOptimizationConfigBuilder_.getMessage();
        }
        return com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The page optimization config.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig page_optimization_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPageOptimizationConfig(
        com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig value) {
      if (pageOptimizationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        trainingConfig_ = value;
        onChanged();
      } else {
        pageOptimizationConfigBuilder_.setMessage(value);
      }
      trainingConfigCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The page optimization config.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig page_optimization_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPageOptimizationConfig(
        com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Builder builderForValue) {
      if (pageOptimizationConfigBuilder_ == null) {
        trainingConfig_ = builderForValue.build();
        onChanged();
      } else {
        pageOptimizationConfigBuilder_.setMessage(builderForValue.build());
      }
      trainingConfigCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The page optimization config.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig page_optimization_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePageOptimizationConfig(
        com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig value) {
      if (pageOptimizationConfigBuilder_ == null) {
        if (trainingConfigCase_ == 17
            && trainingConfig_
                != com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig
                    .getDefaultInstance()) {
          trainingConfig_ =
              com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.newBuilder(
                      (com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig)
                          trainingConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          trainingConfig_ = value;
        }
        onChanged();
      } else {
        if (trainingConfigCase_ == 17) {
          pageOptimizationConfigBuilder_.mergeFrom(value);
        } else {
          pageOptimizationConfigBuilder_.setMessage(value);
        }
      }
      trainingConfigCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The page optimization config.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig page_optimization_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPageOptimizationConfig() {
      if (pageOptimizationConfigBuilder_ == null) {
        if (trainingConfigCase_ == 17) {
          trainingConfigCase_ = 0;
          trainingConfig_ = null;
          onChanged();
        }
      } else {
        if (trainingConfigCase_ == 17) {
          trainingConfigCase_ = 0;
          trainingConfig_ = null;
        }
        pageOptimizationConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The page optimization config.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig page_optimization_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Builder
        getPageOptimizationConfigBuilder() {
      return getPageOptimizationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The page optimization config.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig page_optimization_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Model.PageOptimizationConfigOrBuilder
        getPageOptimizationConfigOrBuilder() {
      if ((trainingConfigCase_ == 17) && (pageOptimizationConfigBuilder_ != null)) {
        return pageOptimizationConfigBuilder_.getMessageOrBuilder();
      } else {
        if (trainingConfigCase_ == 17) {
          return (com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig) trainingConfig_;
        }
        return com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The page optimization config.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.PageOptimizationConfig page_optimization_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig,
            com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Builder,
            com.google.cloud.retail.v2alpha.Model.PageOptimizationConfigOrBuilder>
        getPageOptimizationConfigFieldBuilder() {
      if (pageOptimizationConfigBuilder_ == null) {
        if (!(trainingConfigCase_ == 17)) {
          trainingConfig_ =
              com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.getDefaultInstance();
        }
        pageOptimizationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig,
                com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig.Builder,
                com.google.cloud.retail.v2alpha.Model.PageOptimizationConfigOrBuilder>(
                (com.google.cloud.retail.v2alpha.Model.PageOptimizationConfig) trainingConfig_,
                getParentForChildren(),
                isClean());
        trainingConfig_ = null;
      }
      trainingConfigCase_ = 17;
      onChanged();
      return pageOptimizationConfigBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The fully qualified resource name of the model.
     *
     * Format:
     * `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{model_id}`
     * catalog_id has char limit of 50.
     * recommendation_model_id has char limit of 40.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The fully qualified resource name of the model.
     *
     * Format:
     * `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{model_id}`
     * catalog_id has char limit of 50.
     * recommendation_model_id has char limit of 40.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The fully qualified resource name of the model.
     *
     * Format:
     * `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{model_id}`
     * catalog_id has char limit of 50.
     * recommendation_model_id has char limit of 40.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The fully qualified resource name of the model.
     *
     * Format:
     * `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{model_id}`
     * catalog_id has char limit of 50.
     * recommendation_model_id has char limit of 40.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The fully qualified resource name of the model.
     *
     * Format:
     * `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{model_id}`
     * catalog_id has char limit of 50.
     * recommendation_model_id has char limit of 40.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The display name of the model.
     *
     * Should be human readable, used to display Recommendation Models in the
     * Retail Cloud Console Dashboard. UTF-8 encoded string with limit of 1024
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the model.
     *
     * Should be human readable, used to display Recommendation Models in the
     * Retail Cloud Console Dashboard. UTF-8 encoded string with limit of 1024
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the model.
     *
     * Should be human readable, used to display Recommendation Models in the
     * Retail Cloud Console Dashboard. UTF-8 encoded string with limit of 1024
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the model.
     *
     * Should be human readable, used to display Recommendation Models in the
     * Retail Cloud Console Dashboard. UTF-8 encoded string with limit of 1024
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the model.
     *
     * Should be human readable, used to display Recommendation Models in the
     * Retail Cloud Console Dashboard. UTF-8 encoded string with limit of 1024
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int trainingState_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The training state that the model is in (e.g.
     * `TRAINING` or `PAUSED`).
     *
     * Since part of the cost of running the service
     * is frequency of training - this can be used to determine when to train
     * model in order to control cost. If not specified: the default value for
     * `CreateModel` method is `TRAINING`. The default value for
     * `UpdateModel` method is to keep the state the same as before.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.TrainingState training_state = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for trainingState.
     */
    @java.lang.Override
    public int getTrainingStateValue() {
      return trainingState_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The training state that the model is in (e.g.
     * `TRAINING` or `PAUSED`).
     *
     * Since part of the cost of running the service
     * is frequency of training - this can be used to determine when to train
     * model in order to control cost. If not specified: the default value for
     * `CreateModel` method is `TRAINING`. The default value for
     * `UpdateModel` method is to keep the state the same as before.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.TrainingState training_state = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for trainingState to set.
     * @return This builder for chaining.
     */
    public Builder setTrainingStateValue(int value) {
      trainingState_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The training state that the model is in (e.g.
     * `TRAINING` or `PAUSED`).
     *
     * Since part of the cost of running the service
     * is frequency of training - this can be used to determine when to train
     * model in order to control cost. If not specified: the default value for
     * `CreateModel` method is `TRAINING`. The default value for
     * `UpdateModel` method is to keep the state the same as before.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.TrainingState training_state = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The trainingState.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Model.TrainingState getTrainingState() {
      com.google.cloud.retail.v2alpha.Model.TrainingState result =
          com.google.cloud.retail.v2alpha.Model.TrainingState.forNumber(trainingState_);
      return result == null
          ? com.google.cloud.retail.v2alpha.Model.TrainingState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The training state that the model is in (e.g.
     * `TRAINING` or `PAUSED`).
     *
     * Since part of the cost of running the service
     * is frequency of training - this can be used to determine when to train
     * model in order to control cost. If not specified: the default value for
     * `CreateModel` method is `TRAINING`. The default value for
     * `UpdateModel` method is to keep the state the same as before.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.TrainingState training_state = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The trainingState to set.
     * @return This builder for chaining.
     */
    public Builder setTrainingState(com.google.cloud.retail.v2alpha.Model.TrainingState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      trainingState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The training state that the model is in (e.g.
     * `TRAINING` or `PAUSED`).
     *
     * Since part of the cost of running the service
     * is frequency of training - this can be used to determine when to train
     * model in order to control cost. If not specified: the default value for
     * `CreateModel` method is `TRAINING`. The default value for
     * `UpdateModel` method is to keep the state the same as before.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.TrainingState training_state = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTrainingState() {
      bitField0_ = (bitField0_ & ~0x00000008);
      trainingState_ = 0;
      onChanged();
      return this;
    }

    private int servingState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The serving state of the model: `ACTIVE`, `NOT_ACTIVE`.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.ServingState serving_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for servingState.
     */
    @java.lang.Override
    public int getServingStateValue() {
      return servingState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The serving state of the model: `ACTIVE`, `NOT_ACTIVE`.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.ServingState serving_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for servingState to set.
     * @return This builder for chaining.
     */
    public Builder setServingStateValue(int value) {
      servingState_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The serving state of the model: `ACTIVE`, `NOT_ACTIVE`.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.ServingState serving_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The servingState.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Model.ServingState getServingState() {
      com.google.cloud.retail.v2alpha.Model.ServingState result =
          com.google.cloud.retail.v2alpha.Model.ServingState.forNumber(servingState_);
      return result == null
          ? com.google.cloud.retail.v2alpha.Model.ServingState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The serving state of the model: `ACTIVE`, `NOT_ACTIVE`.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.ServingState serving_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The servingState to set.
     * @return This builder for chaining.
     */
    public Builder setServingState(com.google.cloud.retail.v2alpha.Model.ServingState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      servingState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The serving state of the model: `ACTIVE`, `NOT_ACTIVE`.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.ServingState serving_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServingState() {
      bitField0_ = (bitField0_ & ~0x00000010);
      servingState_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was last updated. E.g.
     * if a Recommendation Model was paused - this would be the time the pause was
     * initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was last updated. E.g.
     * if a Recommendation Model was paused - this would be the time the pause was
     * initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was last updated. E.g.
     * if a Recommendation Model was paused - this would be the time the pause was
     * initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was last updated. E.g.
     * if a Recommendation Model was paused - this would be the time the pause was
     * initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was last updated. E.g.
     * if a Recommendation Model was paused - this would be the time the pause was
     * initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was last updated. E.g.
     * if a Recommendation Model was paused - this would be the time the pause was
     * initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was last updated. E.g.
     * if a Recommendation Model was paused - this would be the time the pause was
     * initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was last updated. E.g.
     * if a Recommendation Model was paused - this would be the time the pause was
     * initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Model was last updated. E.g.
     * if a Recommendation Model was paused - this would be the time the pause was
     * initiated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * Required. The type of model e.g. `home-page`.
     *
     * Currently supported values: `recommended-for-you`, `others-you-may-like`,
     * `frequently-bought-together`, `page-optimization`, `similar-items`,
     * `buy-it-again`, `on-sale-items`, and `recently-viewed`(readonly value).
     *
     *
     * This field together with
     * [optimization_objective][google.cloud.retail.v2alpha.Model.optimization_objective]
     * describe model metadata to use to control model training and serving.
     * See https://cloud.google.com/retail/docs/models
     * for more details on what the model metadata control and which combination
     * of parameters are valid. For invalid combinations of parameters (e.g. type
     * = `frequently-bought-together` and optimization_objective = `ctr`), you
     * receive an error 400 if you try to create/update a recommendation with
     * this set of knobs.
     * </pre>
     *
     * <code>string type = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The type of model e.g. `home-page`.
     *
     * Currently supported values: `recommended-for-you`, `others-you-may-like`,
     * `frequently-bought-together`, `page-optimization`, `similar-items`,
     * `buy-it-again`, `on-sale-items`, and `recently-viewed`(readonly value).
     *
     *
     * This field together with
     * [optimization_objective][google.cloud.retail.v2alpha.Model.optimization_objective]
     * describe model metadata to use to control model training and serving.
     * See https://cloud.google.com/retail/docs/models
     * for more details on what the model metadata control and which combination
     * of parameters are valid. For invalid combinations of parameters (e.g. type
     * = `frequently-bought-together` and optimization_objective = `ctr`), you
     * receive an error 400 if you try to create/update a recommendation with
     * this set of knobs.
     * </pre>
     *
     * <code>string type = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The type of model e.g. `home-page`.
     *
     * Currently supported values: `recommended-for-you`, `others-you-may-like`,
     * `frequently-bought-together`, `page-optimization`, `similar-items`,
     * `buy-it-again`, `on-sale-items`, and `recently-viewed`(readonly value).
     *
     *
     * This field together with
     * [optimization_objective][google.cloud.retail.v2alpha.Model.optimization_objective]
     * describe model metadata to use to control model training and serving.
     * See https://cloud.google.com/retail/docs/models
     * for more details on what the model metadata control and which combination
     * of parameters are valid. For invalid combinations of parameters (e.g. type
     * = `frequently-bought-together` and optimization_objective = `ctr`), you
     * receive an error 400 if you try to create/update a recommendation with
     * this set of knobs.
     * </pre>
     *
     * <code>string type = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of model e.g. `home-page`.
     *
     * Currently supported values: `recommended-for-you`, `others-you-may-like`,
     * `frequently-bought-together`, `page-optimization`, `similar-items`,
     * `buy-it-again`, `on-sale-items`, and `recently-viewed`(readonly value).
     *
     *
     * This field together with
     * [optimization_objective][google.cloud.retail.v2alpha.Model.optimization_objective]
     * describe model metadata to use to control model training and serving.
     * See https://cloud.google.com/retail/docs/models
     * for more details on what the model metadata control and which combination
     * of parameters are valid. For invalid combinations of parameters (e.g. type
     * = `frequently-bought-together` and optimization_objective = `ctr`), you
     * receive an error 400 if you try to create/update a recommendation with
     * this set of knobs.
     * </pre>
     *
     * <code>string type = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of model e.g. `home-page`.
     *
     * Currently supported values: `recommended-for-you`, `others-you-may-like`,
     * `frequently-bought-together`, `page-optimization`, `similar-items`,
     * `buy-it-again`, `on-sale-items`, and `recently-viewed`(readonly value).
     *
     *
     * This field together with
     * [optimization_objective][google.cloud.retail.v2alpha.Model.optimization_objective]
     * describe model metadata to use to control model training and serving.
     * See https://cloud.google.com/retail/docs/models
     * for more details on what the model metadata control and which combination
     * of parameters are valid. For invalid combinations of parameters (e.g. type
     * = `frequently-bought-together` and optimization_objective = `ctr`), you
     * receive an error 400 if you try to create/update a recommendation with
     * this set of knobs.
     * </pre>
     *
     * <code>string type = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object optimizationObjective_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The optimization objective e.g. `cvr`.
     *
     * Currently supported
     * values: `ctr`, `cvr`, `revenue-per-order`.
     *
     *  If not specified, we choose default based on model type.
     * Default depends on type of recommendation:
     *
     * `recommended-for-you` =&gt; `ctr`
     *
     * `others-you-may-like` =&gt; `ctr`
     *
     * `frequently-bought-together` =&gt; `revenue_per_order`
     *
     * This field together with
     * [optimization_objective][google.cloud.retail.v2alpha.Model.type]
     * describe model metadata to use to control model training and serving.
     * See https://cloud.google.com/retail/docs/models
     * for more details on what the model metadata control and which combination
     * of parameters are valid. For invalid combinations of parameters (e.g. type
     * = `frequently-bought-together` and optimization_objective = `ctr`), you
     * receive an error 400 if you try to create/update a recommendation with
     * this set of knobs.
     * </pre>
     *
     * <code>string optimization_objective = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The optimizationObjective.
     */
    public java.lang.String getOptimizationObjective() {
      java.lang.Object ref = optimizationObjective_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        optimizationObjective_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The optimization objective e.g. `cvr`.
     *
     * Currently supported
     * values: `ctr`, `cvr`, `revenue-per-order`.
     *
     *  If not specified, we choose default based on model type.
     * Default depends on type of recommendation:
     *
     * `recommended-for-you` =&gt; `ctr`
     *
     * `others-you-may-like` =&gt; `ctr`
     *
     * `frequently-bought-together` =&gt; `revenue_per_order`
     *
     * This field together with
     * [optimization_objective][google.cloud.retail.v2alpha.Model.type]
     * describe model metadata to use to control model training and serving.
     * See https://cloud.google.com/retail/docs/models
     * for more details on what the model metadata control and which combination
     * of parameters are valid. For invalid combinations of parameters (e.g. type
     * = `frequently-bought-together` and optimization_objective = `ctr`), you
     * receive an error 400 if you try to create/update a recommendation with
     * this set of knobs.
     * </pre>
     *
     * <code>string optimization_objective = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for optimizationObjective.
     */
    public com.google.protobuf.ByteString getOptimizationObjectiveBytes() {
      java.lang.Object ref = optimizationObjective_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        optimizationObjective_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The optimization objective e.g. `cvr`.
     *
     * Currently supported
     * values: `ctr`, `cvr`, `revenue-per-order`.
     *
     *  If not specified, we choose default based on model type.
     * Default depends on type of recommendation:
     *
     * `recommended-for-you` =&gt; `ctr`
     *
     * `others-you-may-like` =&gt; `ctr`
     *
     * `frequently-bought-together` =&gt; `revenue_per_order`
     *
     * This field together with
     * [optimization_objective][google.cloud.retail.v2alpha.Model.type]
     * describe model metadata to use to control model training and serving.
     * See https://cloud.google.com/retail/docs/models
     * for more details on what the model metadata control and which combination
     * of parameters are valid. For invalid combinations of parameters (e.g. type
     * = `frequently-bought-together` and optimization_objective = `ctr`), you
     * receive an error 400 if you try to create/update a recommendation with
     * this set of knobs.
     * </pre>
     *
     * <code>string optimization_objective = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The optimizationObjective to set.
     * @return This builder for chaining.
     */
    public Builder setOptimizationObjective(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      optimizationObjective_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The optimization objective e.g. `cvr`.
     *
     * Currently supported
     * values: `ctr`, `cvr`, `revenue-per-order`.
     *
     *  If not specified, we choose default based on model type.
     * Default depends on type of recommendation:
     *
     * `recommended-for-you` =&gt; `ctr`
     *
     * `others-you-may-like` =&gt; `ctr`
     *
     * `frequently-bought-together` =&gt; `revenue_per_order`
     *
     * This field together with
     * [optimization_objective][google.cloud.retail.v2alpha.Model.type]
     * describe model metadata to use to control model training and serving.
     * See https://cloud.google.com/retail/docs/models
     * for more details on what the model metadata control and which combination
     * of parameters are valid. For invalid combinations of parameters (e.g. type
     * = `frequently-bought-together` and optimization_objective = `ctr`), you
     * receive an error 400 if you try to create/update a recommendation with
     * this set of knobs.
     * </pre>
     *
     * <code>string optimization_objective = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOptimizationObjective() {
      optimizationObjective_ = getDefaultInstance().getOptimizationObjective();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The optimization objective e.g. `cvr`.
     *
     * Currently supported
     * values: `ctr`, `cvr`, `revenue-per-order`.
     *
     *  If not specified, we choose default based on model type.
     * Default depends on type of recommendation:
     *
     * `recommended-for-you` =&gt; `ctr`
     *
     * `others-you-may-like` =&gt; `ctr`
     *
     * `frequently-bought-together` =&gt; `revenue_per_order`
     *
     * This field together with
     * [optimization_objective][google.cloud.retail.v2alpha.Model.type]
     * describe model metadata to use to control model training and serving.
     * See https://cloud.google.com/retail/docs/models
     * for more details on what the model metadata control and which combination
     * of parameters are valid. For invalid combinations of parameters (e.g. type
     * = `frequently-bought-together` and optimization_objective = `ctr`), you
     * receive an error 400 if you try to create/update a recommendation with
     * this set of knobs.
     * </pre>
     *
     * <code>string optimization_objective = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for optimizationObjective to set.
     * @return This builder for chaining.
     */
    public Builder setOptimizationObjectiveBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      optimizationObjective_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private int periodicTuningState_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The state of periodic tuning.
     *
     * The period we use is 3 months - to do a
     * one-off tune earlier use the `TuneModel` method. Default value
     * is `PERIODIC_TUNING_ENABLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.PeriodicTuningState periodic_tuning_state = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for periodicTuningState.
     */
    @java.lang.Override
    public int getPeriodicTuningStateValue() {
      return periodicTuningState_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The state of periodic tuning.
     *
     * The period we use is 3 months - to do a
     * one-off tune earlier use the `TuneModel` method. Default value
     * is `PERIODIC_TUNING_ENABLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.PeriodicTuningState periodic_tuning_state = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for periodicTuningState to set.
     * @return This builder for chaining.
     */
    public Builder setPeriodicTuningStateValue(int value) {
      periodicTuningState_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The state of periodic tuning.
     *
     * The period we use is 3 months - to do a
     * one-off tune earlier use the `TuneModel` method. Default value
     * is `PERIODIC_TUNING_ENABLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.PeriodicTuningState periodic_tuning_state = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The periodicTuningState.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Model.PeriodicTuningState getPeriodicTuningState() {
      com.google.cloud.retail.v2alpha.Model.PeriodicTuningState result =
          com.google.cloud.retail.v2alpha.Model.PeriodicTuningState.forNumber(periodicTuningState_);
      return result == null
          ? com.google.cloud.retail.v2alpha.Model.PeriodicTuningState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The state of periodic tuning.
     *
     * The period we use is 3 months - to do a
     * one-off tune earlier use the `TuneModel` method. Default value
     * is `PERIODIC_TUNING_ENABLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.PeriodicTuningState periodic_tuning_state = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The periodicTuningState to set.
     * @return This builder for chaining.
     */
    public Builder setPeriodicTuningState(
        com.google.cloud.retail.v2alpha.Model.PeriodicTuningState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      periodicTuningState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The state of periodic tuning.
     *
     * The period we use is 3 months - to do a
     * one-off tune earlier use the `TuneModel` method. Default value
     * is `PERIODIC_TUNING_ENABLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.PeriodicTuningState periodic_tuning_state = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPeriodicTuningState() {
      bitField0_ = (bitField0_ & ~0x00000200);
      periodicTuningState_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp lastTuneTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastTuneTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the latest successful tune finished.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_tune_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastTuneTime field is set.
     */
    public boolean hasLastTuneTime() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the latest successful tune finished.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_tune_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastTuneTime.
     */
    public com.google.protobuf.Timestamp getLastTuneTime() {
      if (lastTuneTimeBuilder_ == null) {
        return lastTuneTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastTuneTime_;
      } else {
        return lastTuneTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the latest successful tune finished.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_tune_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastTuneTime(com.google.protobuf.Timestamp value) {
      if (lastTuneTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastTuneTime_ = value;
      } else {
        lastTuneTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the latest successful tune finished.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_tune_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastTuneTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastTuneTimeBuilder_ == null) {
        lastTuneTime_ = builderForValue.build();
      } else {
        lastTuneTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the latest successful tune finished.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_tune_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLastTuneTime(com.google.protobuf.Timestamp value) {
      if (lastTuneTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && lastTuneTime_ != null
            && lastTuneTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastTuneTimeBuilder().mergeFrom(value);
        } else {
          lastTuneTime_ = value;
        }
      } else {
        lastTuneTimeBuilder_.mergeFrom(value);
      }
      if (lastTuneTime_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the latest successful tune finished.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_tune_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLastTuneTime() {
      bitField0_ = (bitField0_ & ~0x00000400);
      lastTuneTime_ = null;
      if (lastTuneTimeBuilder_ != null) {
        lastTuneTimeBuilder_.dispose();
        lastTuneTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the latest successful tune finished.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_tune_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getLastTuneTimeBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getLastTuneTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the latest successful tune finished.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_tune_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastTuneTimeOrBuilder() {
      if (lastTuneTimeBuilder_ != null) {
        return lastTuneTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastTuneTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastTuneTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the latest successful tune finished.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_tune_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastTuneTimeFieldBuilder() {
      if (lastTuneTimeBuilder_ == null) {
        lastTuneTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastTuneTime(), getParentForChildren(), isClean());
        lastTuneTime_ = null;
      }
      return lastTuneTimeBuilder_;
    }

    private java.lang.Object tuningOperation_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The tune operation associated with the model.
     *
     * Can be used to determine if there is an ongoing tune for this
     * recommendation. Empty field implies no tune is goig on.
     * </pre>
     *
     * <code>string tuning_operation = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The tuningOperation.
     */
    public java.lang.String getTuningOperation() {
      java.lang.Object ref = tuningOperation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tuningOperation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The tune operation associated with the model.
     *
     * Can be used to determine if there is an ongoing tune for this
     * recommendation. Empty field implies no tune is goig on.
     * </pre>
     *
     * <code>string tuning_operation = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for tuningOperation.
     */
    public com.google.protobuf.ByteString getTuningOperationBytes() {
      java.lang.Object ref = tuningOperation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tuningOperation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The tune operation associated with the model.
     *
     * Can be used to determine if there is an ongoing tune for this
     * recommendation. Empty field implies no tune is goig on.
     * </pre>
     *
     * <code>string tuning_operation = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The tuningOperation to set.
     * @return This builder for chaining.
     */
    public Builder setTuningOperation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tuningOperation_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The tune operation associated with the model.
     *
     * Can be used to determine if there is an ongoing tune for this
     * recommendation. Empty field implies no tune is goig on.
     * </pre>
     *
     * <code>string tuning_operation = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTuningOperation() {
      tuningOperation_ = getDefaultInstance().getTuningOperation();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The tune operation associated with the model.
     *
     * Can be used to determine if there is an ongoing tune for this
     * recommendation. Empty field implies no tune is goig on.
     * </pre>
     *
     * <code>string tuning_operation = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for tuningOperation to set.
     * @return This builder for chaining.
     */
    public Builder setTuningOperationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tuningOperation_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private int dataState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The state of data requirements for this model: `DATA_OK` and
     * `DATA_ERROR`.
     *
     * Recommendation model cannot be trained if the data is in
     * `DATA_ERROR` state. Recommendation model can have `DATA_ERROR` state even
     * if serving state is `ACTIVE`: models were trained successfully before, but
     * cannot be refreshed because model no longer has sufficient
     * data for training.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.DataState data_state = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for dataState.
     */
    @java.lang.Override
    public int getDataStateValue() {
      return dataState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of data requirements for this model: `DATA_OK` and
     * `DATA_ERROR`.
     *
     * Recommendation model cannot be trained if the data is in
     * `DATA_ERROR` state. Recommendation model can have `DATA_ERROR` state even
     * if serving state is `ACTIVE`: models were trained successfully before, but
     * cannot be refreshed because model no longer has sufficient
     * data for training.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.DataState data_state = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for dataState to set.
     * @return This builder for chaining.
     */
    public Builder setDataStateValue(int value) {
      dataState_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of data requirements for this model: `DATA_OK` and
     * `DATA_ERROR`.
     *
     * Recommendation model cannot be trained if the data is in
     * `DATA_ERROR` state. Recommendation model can have `DATA_ERROR` state even
     * if serving state is `ACTIVE`: models were trained successfully before, but
     * cannot be refreshed because model no longer has sufficient
     * data for training.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.DataState data_state = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The dataState.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Model.DataState getDataState() {
      com.google.cloud.retail.v2alpha.Model.DataState result =
          com.google.cloud.retail.v2alpha.Model.DataState.forNumber(dataState_);
      return result == null ? com.google.cloud.retail.v2alpha.Model.DataState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of data requirements for this model: `DATA_OK` and
     * `DATA_ERROR`.
     *
     * Recommendation model cannot be trained if the data is in
     * `DATA_ERROR` state. Recommendation model can have `DATA_ERROR` state even
     * if serving state is `ACTIVE`: models were trained successfully before, but
     * cannot be refreshed because model no longer has sufficient
     * data for training.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.DataState data_state = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The dataState to set.
     * @return This builder for chaining.
     */
    public Builder setDataState(com.google.cloud.retail.v2alpha.Model.DataState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00001000;
      dataState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of data requirements for this model: `DATA_OK` and
     * `DATA_ERROR`.
     *
     * Recommendation model cannot be trained if the data is in
     * `DATA_ERROR` state. Recommendation model can have `DATA_ERROR` state even
     * if serving state is `ACTIVE`: models were trained successfully before, but
     * cannot be refreshed because model no longer has sufficient
     * data for training.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.DataState data_state = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataState() {
      bitField0_ = (bitField0_ & ~0x00001000);
      dataState_ = 0;
      onChanged();
      return this;
    }

    private int filteringOption_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. If `RECOMMENDATIONS_FILTERING_ENABLED`, recommendation filtering
     * by attributes is enabled for the model.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.RecommendationsFilteringOption filtering_option = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for filteringOption.
     */
    @java.lang.Override
    public int getFilteringOptionValue() {
      return filteringOption_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If `RECOMMENDATIONS_FILTERING_ENABLED`, recommendation filtering
     * by attributes is enabled for the model.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.RecommendationsFilteringOption filtering_option = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for filteringOption to set.
     * @return This builder for chaining.
     */
    public Builder setFilteringOptionValue(int value) {
      filteringOption_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If `RECOMMENDATIONS_FILTERING_ENABLED`, recommendation filtering
     * by attributes is enabled for the model.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.RecommendationsFilteringOption filtering_option = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The filteringOption.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.RecommendationsFilteringOption getFilteringOption() {
      com.google.cloud.retail.v2alpha.RecommendationsFilteringOption result =
          com.google.cloud.retail.v2alpha.RecommendationsFilteringOption.forNumber(
              filteringOption_);
      return result == null
          ? com.google.cloud.retail.v2alpha.RecommendationsFilteringOption.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. If `RECOMMENDATIONS_FILTERING_ENABLED`, recommendation filtering
     * by attributes is enabled for the model.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.RecommendationsFilteringOption filtering_option = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The filteringOption to set.
     * @return This builder for chaining.
     */
    public Builder setFilteringOption(
        com.google.cloud.retail.v2alpha.RecommendationsFilteringOption value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00002000;
      filteringOption_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If `RECOMMENDATIONS_FILTERING_ENABLED`, recommendation filtering
     * by attributes is enabled for the model.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.RecommendationsFilteringOption filtering_option = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilteringOption() {
      bitField0_ = (bitField0_ & ~0x00002000);
      filteringOption_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.retail.v2alpha.Model.ServingConfigList>
        servingConfigLists_ = java.util.Collections.emptyList();

    private void ensureServingConfigListsIsMutable() {
      if (!((bitField0_ & 0x00004000) != 0)) {
        servingConfigLists_ =
            new java.util.ArrayList<com.google.cloud.retail.v2alpha.Model.ServingConfigList>(
                servingConfigLists_);
        bitField0_ |= 0x00004000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2alpha.Model.ServingConfigList,
            com.google.cloud.retail.v2alpha.Model.ServingConfigList.Builder,
            com.google.cloud.retail.v2alpha.Model.ServingConfigListOrBuilder>
        servingConfigListsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.retail.v2alpha.Model.ServingConfigList>
        getServingConfigListsList() {
      if (servingConfigListsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(servingConfigLists_);
      } else {
        return servingConfigListsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getServingConfigListsCount() {
      if (servingConfigListsBuilder_ == null) {
        return servingConfigLists_.size();
      } else {
        return servingConfigListsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.Model.ServingConfigList getServingConfigLists(
        int index) {
      if (servingConfigListsBuilder_ == null) {
        return servingConfigLists_.get(index);
      } else {
        return servingConfigListsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setServingConfigLists(
        int index, com.google.cloud.retail.v2alpha.Model.ServingConfigList value) {
      if (servingConfigListsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServingConfigListsIsMutable();
        servingConfigLists_.set(index, value);
        onChanged();
      } else {
        servingConfigListsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setServingConfigLists(
        int index,
        com.google.cloud.retail.v2alpha.Model.ServingConfigList.Builder builderForValue) {
      if (servingConfigListsBuilder_ == null) {
        ensureServingConfigListsIsMutable();
        servingConfigLists_.set(index, builderForValue.build());
        onChanged();
      } else {
        servingConfigListsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addServingConfigLists(
        com.google.cloud.retail.v2alpha.Model.ServingConfigList value) {
      if (servingConfigListsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServingConfigListsIsMutable();
        servingConfigLists_.add(value);
        onChanged();
      } else {
        servingConfigListsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addServingConfigLists(
        int index, com.google.cloud.retail.v2alpha.Model.ServingConfigList value) {
      if (servingConfigListsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServingConfigListsIsMutable();
        servingConfigLists_.add(index, value);
        onChanged();
      } else {
        servingConfigListsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addServingConfigLists(
        com.google.cloud.retail.v2alpha.Model.ServingConfigList.Builder builderForValue) {
      if (servingConfigListsBuilder_ == null) {
        ensureServingConfigListsIsMutable();
        servingConfigLists_.add(builderForValue.build());
        onChanged();
      } else {
        servingConfigListsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addServingConfigLists(
        int index,
        com.google.cloud.retail.v2alpha.Model.ServingConfigList.Builder builderForValue) {
      if (servingConfigListsBuilder_ == null) {
        ensureServingConfigListsIsMutable();
        servingConfigLists_.add(index, builderForValue.build());
        onChanged();
      } else {
        servingConfigListsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllServingConfigLists(
        java.lang.Iterable<? extends com.google.cloud.retail.v2alpha.Model.ServingConfigList>
            values) {
      if (servingConfigListsBuilder_ == null) {
        ensureServingConfigListsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, servingConfigLists_);
        onChanged();
      } else {
        servingConfigListsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearServingConfigLists() {
      if (servingConfigListsBuilder_ == null) {
        servingConfigLists_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00004000);
        onChanged();
      } else {
        servingConfigListsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeServingConfigLists(int index) {
      if (servingConfigListsBuilder_ == null) {
        ensureServingConfigListsIsMutable();
        servingConfigLists_.remove(index);
        onChanged();
      } else {
        servingConfigListsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.Model.ServingConfigList.Builder
        getServingConfigListsBuilder(int index) {
      return getServingConfigListsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.Model.ServingConfigListOrBuilder
        getServingConfigListsOrBuilder(int index) {
      if (servingConfigListsBuilder_ == null) {
        return servingConfigLists_.get(index);
      } else {
        return servingConfigListsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.retail.v2alpha.Model.ServingConfigListOrBuilder>
        getServingConfigListsOrBuilderList() {
      if (servingConfigListsBuilder_ != null) {
        return servingConfigListsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(servingConfigLists_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.Model.ServingConfigList.Builder
        addServingConfigListsBuilder() {
      return getServingConfigListsFieldBuilder()
          .addBuilder(com.google.cloud.retail.v2alpha.Model.ServingConfigList.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.Model.ServingConfigList.Builder
        addServingConfigListsBuilder(int index) {
      return getServingConfigListsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.retail.v2alpha.Model.ServingConfigList.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of valid serving configs associated with the
     * PageOptimizationConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Model.ServingConfigList serving_config_lists = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.retail.v2alpha.Model.ServingConfigList.Builder>
        getServingConfigListsBuilderList() {
      return getServingConfigListsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2alpha.Model.ServingConfigList,
            com.google.cloud.retail.v2alpha.Model.ServingConfigList.Builder,
            com.google.cloud.retail.v2alpha.Model.ServingConfigListOrBuilder>
        getServingConfigListsFieldBuilder() {
      if (servingConfigListsBuilder_ == null) {
        servingConfigListsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2alpha.Model.ServingConfigList,
                com.google.cloud.retail.v2alpha.Model.ServingConfigList.Builder,
                com.google.cloud.retail.v2alpha.Model.ServingConfigListOrBuilder>(
                servingConfigLists_,
                ((bitField0_ & 0x00004000) != 0),
                getParentForChildren(),
                isClean());
        servingConfigLists_ = null;
      }
      return servingConfigListsBuilder_;
    }

    private com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig modelFeaturesConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig,
            com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.Builder,
            com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfigOrBuilder>
        modelFeaturesConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Additional model features config.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig model_features_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the modelFeaturesConfig field is set.
     */
    public boolean hasModelFeaturesConfig() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional model features config.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig model_features_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The modelFeaturesConfig.
     */
    public com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig getModelFeaturesConfig() {
      if (modelFeaturesConfigBuilder_ == null) {
        return modelFeaturesConfig_ == null
            ? com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.getDefaultInstance()
            : modelFeaturesConfig_;
      } else {
        return modelFeaturesConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional model features config.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig model_features_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setModelFeaturesConfig(
        com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig value) {
      if (modelFeaturesConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelFeaturesConfig_ = value;
      } else {
        modelFeaturesConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional model features config.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig model_features_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setModelFeaturesConfig(
        com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.Builder builderForValue) {
      if (modelFeaturesConfigBuilder_ == null) {
        modelFeaturesConfig_ = builderForValue.build();
      } else {
        modelFeaturesConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional model features config.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig model_features_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeModelFeaturesConfig(
        com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig value) {
      if (modelFeaturesConfigBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && modelFeaturesConfig_ != null
            && modelFeaturesConfig_
                != com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.getDefaultInstance()) {
          getModelFeaturesConfigBuilder().mergeFrom(value);
        } else {
          modelFeaturesConfig_ = value;
        }
      } else {
        modelFeaturesConfigBuilder_.mergeFrom(value);
      }
      if (modelFeaturesConfig_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional model features config.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig model_features_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearModelFeaturesConfig() {
      bitField0_ = (bitField0_ & ~0x00008000);
      modelFeaturesConfig_ = null;
      if (modelFeaturesConfigBuilder_ != null) {
        modelFeaturesConfigBuilder_.dispose();
        modelFeaturesConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional model features config.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig model_features_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.Builder
        getModelFeaturesConfigBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getModelFeaturesConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional model features config.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig model_features_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfigOrBuilder
        getModelFeaturesConfigOrBuilder() {
      if (modelFeaturesConfigBuilder_ != null) {
        return modelFeaturesConfigBuilder_.getMessageOrBuilder();
      } else {
        return modelFeaturesConfig_ == null
            ? com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.getDefaultInstance()
            : modelFeaturesConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional model features config.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Model.ModelFeaturesConfig model_features_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig,
            com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.Builder,
            com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfigOrBuilder>
        getModelFeaturesConfigFieldBuilder() {
      if (modelFeaturesConfigBuilder_ == null) {
        modelFeaturesConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig,
                com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfig.Builder,
                com.google.cloud.retail.v2alpha.Model.ModelFeaturesConfigOrBuilder>(
                getModelFeaturesConfig(), getParentForChildren(), isClean());
        modelFeaturesConfig_ = null;
      }
      return modelFeaturesConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.Model)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.Model)
  private static final com.google.cloud.retail.v2alpha.Model DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.Model();
  }

  public static com.google.cloud.retail.v2alpha.Model getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Model> PARSER =
      new com.google.protobuf.AbstractParser<Model>() {
        @java.lang.Override
        public Model parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Model> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Model> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2alpha.Model getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
